// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptEnvironmentAccountConnectionInput`](crate::input::AcceptEnvironmentAccountConnectionInput)
pub mod accept_environment_account_connection_input {
    /// A builder for [`AcceptEnvironmentAccountConnectionInput`](crate::input::AcceptEnvironmentAccountConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptEnvironmentAccountConnectionInput`](crate::input::AcceptEnvironmentAccountConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptEnvironmentAccountConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptEnvironmentAccountConnectionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type AcceptEnvironmentAccountConnectionInputOperationOutputAlias =
    crate::operation::AcceptEnvironmentAccountConnection;
#[doc(hidden)]
pub type AcceptEnvironmentAccountConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptEnvironmentAccountConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AcceptEnvironmentAccountConnection`](crate::operation::AcceptEnvironmentAccountConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptEnvironmentAccountConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptEnvironmentAccountConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptEnvironmentAccountConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptEnvironmentAccountConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.AcceptEnvironmentAccountConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_environment_account_connection(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptEnvironmentAccountConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptEnvironmentAccountConnection",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptEnvironmentAccountConnectionInput`](crate::input::AcceptEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::accept_environment_account_connection_input::Builder {
        crate::input::accept_environment_account_connection_input::Builder::default()
    }
}

/// See [`CancelEnvironmentDeploymentInput`](crate::input::CancelEnvironmentDeploymentInput)
pub mod cancel_environment_deployment_input {
    /// A builder for [`CancelEnvironmentDeploymentInput`](crate::input::CancelEnvironmentDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment with the deployment to cancel.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment with the deployment to cancel.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelEnvironmentDeploymentInput`](crate::input::CancelEnvironmentDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelEnvironmentDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelEnvironmentDeploymentInput {
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelEnvironmentDeploymentInputOperationOutputAlias =
    crate::operation::CancelEnvironmentDeployment;
#[doc(hidden)]
pub type CancelEnvironmentDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelEnvironmentDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CancelEnvironmentDeployment`](crate::operation::CancelEnvironmentDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelEnvironmentDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelEnvironmentDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelEnvironmentDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelEnvironmentDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CancelEnvironmentDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_environment_deployment(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelEnvironmentDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelEnvironmentDeployment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelEnvironmentDeploymentInput`](crate::input::CancelEnvironmentDeploymentInput)
    pub fn builder() -> crate::input::cancel_environment_deployment_input::Builder {
        crate::input::cancel_environment_deployment_input::Builder::default()
    }
}

/// See [`CancelServiceInstanceDeploymentInput`](crate::input::CancelServiceInstanceDeploymentInput)
pub mod cancel_service_instance_deployment_input {
    /// A builder for [`CancelServiceInstanceDeploymentInput`](crate::input::CancelServiceInstanceDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_instance_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service instance with the deployment to cancel.</p>
        pub fn service_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the service instance with the deployment to cancel.</p>
        pub fn set_service_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_instance_name = input;
            self
        }
        /// <p>The name of the service with the service instance deployment to cancel.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service with the service instance deployment to cancel.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelServiceInstanceDeploymentInput`](crate::input::CancelServiceInstanceDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelServiceInstanceDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelServiceInstanceDeploymentInput {
                service_instance_name: self.service_instance_name,
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelServiceInstanceDeploymentInputOperationOutputAlias =
    crate::operation::CancelServiceInstanceDeployment;
#[doc(hidden)]
pub type CancelServiceInstanceDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelServiceInstanceDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CancelServiceInstanceDeployment`](crate::operation::CancelServiceInstanceDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelServiceInstanceDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelServiceInstanceDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelServiceInstanceDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelServiceInstanceDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CancelServiceInstanceDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_service_instance_deployment(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelServiceInstanceDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelServiceInstanceDeployment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelServiceInstanceDeploymentInput`](crate::input::CancelServiceInstanceDeploymentInput)
    pub fn builder() -> crate::input::cancel_service_instance_deployment_input::Builder {
        crate::input::cancel_service_instance_deployment_input::Builder::default()
    }
}

/// See [`CancelServicePipelineDeploymentInput`](crate::input::CancelServicePipelineDeploymentInput)
pub mod cancel_service_pipeline_deployment_input {
    /// A builder for [`CancelServicePipelineDeploymentInput`](crate::input::CancelServicePipelineDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service with the service pipeline deployment to cancel.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service with the service pipeline deployment to cancel.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelServicePipelineDeploymentInput`](crate::input::CancelServicePipelineDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelServicePipelineDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelServicePipelineDeploymentInput {
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelServicePipelineDeploymentInputOperationOutputAlias =
    crate::operation::CancelServicePipelineDeployment;
#[doc(hidden)]
pub type CancelServicePipelineDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelServicePipelineDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CancelServicePipelineDeployment`](crate::operation::CancelServicePipelineDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelServicePipelineDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelServicePipelineDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelServicePipelineDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelServicePipelineDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CancelServicePipelineDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_service_pipeline_deployment(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelServicePipelineDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelServicePipelineDeployment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelServicePipelineDeploymentInput`](crate::input::CancelServicePipelineDeploymentInput)
    pub fn builder() -> crate::input::cancel_service_pipeline_deployment_input::Builder {
        crate::input::cancel_service_pipeline_deployment_input::Builder::default()
    }
}

/// See [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
pub mod create_environment_input {
    /// A builder for [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) proton_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_account_connection_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the environment template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>AWS Proton Administrator
        /// Guide</i>.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>AWS Proton Administrator
        /// Guide</i>.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The ID of the major version of the environment template.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The ID of the major version of the environment template.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The ID of the minor version of the environment template.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The ID of the minor version of the environment template.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>A description of the environment that's being created and deployed.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment that's being created and deployed.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A link to a YAML formatted spec file that provides inputs as defined in the environment template bundle schema file. For more
        /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the
        /// <i>AWS Proton Administrator Guide</i>.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>A link to a YAML formatted spec file that provides inputs as defined in the environment template bundle schema file. For more
        /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the
        /// <i>AWS Proton Administrator Guide</i>.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make calls to other services on your behalf. You
        /// must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value.</p>
        pub fn proton_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.proton_service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make calls to other services on your behalf. You
        /// must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value.</p>
        pub fn set_proton_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proton_service_role_arn = input;
            self
        }
        /// <p>The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an
        /// environment account. You must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code>
        /// parameter and value. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>AWS Proton Administrator guide</i>.</p>
        pub fn environment_account_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an
        /// environment account. You must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code>
        /// parameter and value. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>AWS Proton Administrator guide</i>.</p>
        pub fn set_environment_account_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your environment. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for your environment. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentInput {
                name: self.name,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                description: self.description,
                spec: self.spec,
                proton_service_role_arn: self.proton_service_role_arn,
                environment_account_connection_id: self.environment_account_connection_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentInputOperationOutputAlias = crate::operation::CreateEnvironment;
#[doc(hidden)]
pub type CreateEnvironmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironment`](crate::operation::CreateEnvironment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateEnvironment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_environment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
}

/// See [`CreateEnvironmentAccountConnectionInput`](crate::input::CreateEnvironmentAccountConnectionInput)
pub mod create_environment_account_connection_input {
    /// A builder for [`CreateEnvironmentAccountConnectionInput`](crate::input::CreateEnvironmentAccountConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) management_account_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the environment account connection that
        /// the first request created.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the environment account connection that
        /// the first request created.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton
        /// environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM
        /// role to provision environment infrastructure resources in the associated environment account.</p>
        pub fn management_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.management_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton
        /// environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM
        /// role to provision environment infrastructure resources in the associated environment account.</p>
        pub fn set_management_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.management_account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision
        /// infrastructure resources in the associated environment account.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision
        /// infrastructure resources in the associated environment account.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the AWS Proton environment that's created in the associated management account.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the AWS Proton environment that's created in the associated management account.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentAccountConnectionInput`](crate::input::CreateEnvironmentAccountConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentAccountConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentAccountConnectionInput {
                client_token: self.client_token,
                management_account_id: self.management_account_id,
                role_arn: self.role_arn,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentAccountConnectionInputOperationOutputAlias =
    crate::operation::CreateEnvironmentAccountConnection;
#[doc(hidden)]
pub type CreateEnvironmentAccountConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEnvironmentAccountConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironmentAccountConnection`](crate::operation::CreateEnvironmentAccountConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironmentAccountConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEnvironmentAccountConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEnvironmentAccountConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEnvironmentAccountConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateEnvironmentAccountConnection",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_environment_account_connection(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironmentAccountConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironmentAccountConnection",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentAccountConnectionInput`](crate::input::CreateEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::create_environment_account_connection_input::Builder {
        crate::input::create_environment_account_connection_input::Builder::default()
    }
}

/// See [`CreateEnvironmentTemplateInput`](crate::input::CreateEnvironmentTemplateInput)
pub mod create_environment_template_input {
    /// A builder for [`CreateEnvironmentTemplateInput`](crate::input::CreateEnvironmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) provisioning: std::option::Option<crate::model::Provisioning>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the environment template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The environment template name as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The environment template name as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A customer provided encryption key that AWS Proton uses to encrypt data.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>A customer provided encryption key that AWS Proton uses to encrypt data.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.provisioning = Some(input);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn set_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.provisioning = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your environment template. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for your environment template. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentTemplateInput`](crate::input::CreateEnvironmentTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentTemplateInput {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
                encryption_key: self.encryption_key,
                provisioning: self.provisioning,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentTemplateInputOperationOutputAlias =
    crate::operation::CreateEnvironmentTemplate;
#[doc(hidden)]
pub type CreateEnvironmentTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEnvironmentTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironmentTemplate`](crate::operation::CreateEnvironmentTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironmentTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEnvironmentTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEnvironmentTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEnvironmentTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateEnvironmentTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_environment_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironmentTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironmentTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentTemplateInput`](crate::input::CreateEnvironmentTemplateInput)
    pub fn builder() -> crate::input::create_environment_template_input::Builder {
        crate::input::create_environment_template_input::Builder::default()
    }
}

/// See [`CreateEnvironmentTemplateVersionInput`](crate::input::CreateEnvironmentTemplateVersionInput)
pub mod create_environment_template_version_input {
    /// A builder for [`CreateEnvironmentTemplateVersionInput`](crate::input::CreateEnvironmentTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::TemplateVersionSourceInput>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the environment template version that
        /// the first request created.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the environment template version that
        /// the first request created.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>A description of the new version of an environment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the new version of an environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>To create a new minor version of the environment template, include a <code>majorVersion</code>.</p>
        /// <p>To create a new major and minor version of the environment template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To create a new minor version of the environment template, include a <code>majorVersion</code>.</p>
        /// <p>To create a new major and minor version of the environment template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of an template.</p>
        pub fn source(mut self, input: crate::model::TemplateVersionSourceInput) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of an template.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionSourceInput>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for a new version of an environment template.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for a new version of an environment template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentTemplateVersionInput`](crate::input::CreateEnvironmentTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentTemplateVersionInput {
                client_token: self.client_token,
                template_name: self.template_name,
                description: self.description,
                major_version: self.major_version,
                source: self.source,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentTemplateVersionInputOperationOutputAlias =
    crate::operation::CreateEnvironmentTemplateVersion;
#[doc(hidden)]
pub type CreateEnvironmentTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEnvironmentTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironmentTemplateVersion`](crate::operation::CreateEnvironmentTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironmentTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEnvironmentTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEnvironmentTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEnvironmentTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateEnvironmentTemplateVersion",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_environment_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironmentTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironmentTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentTemplateVersionInput`](crate::input::CreateEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::create_environment_template_version_input::Builder {
        crate::input::create_environment_template_version_input::Builder::default()
    }
}

/// See [`CreateServiceInput`](crate::input::CreateServiceInput)
pub mod create_service_input {
    /// A builder for [`CreateServiceInput`](crate::input::CreateServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) repository_connection_arn: std::option::Option<std::string::String>,
        pub(crate) repository_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The service name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the AWS Proton service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the AWS Proton service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the service template that's used to create the service.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template that's used to create the service.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The ID of the major version of the service template that was used to create the service.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The ID of the major version of the service template that was used to create the service.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The ID of the minor version of the service template that was used to create the service.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The ID of the minor version of the service template that was used to create the service.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. Don’t
        /// include pipeline inputs in the spec if your service template <i>doesn’t</i> include a service pipeline. For more
        /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html">Create a service</a> in the
        /// <i>AWS Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html">Create a service</a> in the <i>AWS Proton User Guide</i>.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. Don’t
        /// include pipeline inputs in the spec if your service template <i>doesn’t</i> include a service pipeline. For more
        /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html">Create a service</a> in the
        /// <i>AWS Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html">Create a service</a> in the <i>AWS Proton User Guide</i>.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up repository connection</a> in the
        /// <i>AWS Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up with AWS Proton</a> in the <i>AWS Proton
        /// User Guide</i>. <i>Don't</i> include this parameter if your service template <i>doesn't</i> include
        /// a service pipeline.</p>
        pub fn repository_connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up repository connection</a> in the
        /// <i>AWS Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up with AWS Proton</a> in the <i>AWS Proton
        /// User Guide</i>. <i>Don't</i> include this parameter if your service template <i>doesn't</i> include
        /// a service pipeline.</p>
        pub fn set_repository_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_connection_arn = input;
            self
        }
        /// <p>The ID of the code repository. <i>Don't</i> include this parameter if your service template <i>doesn't</i>
        /// include a service pipeline.</p>
        pub fn repository_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_id = Some(input.into());
            self
        }
        /// <p>The ID of the code repository. <i>Don't</i> include this parameter if your service template <i>doesn't</i>
        /// include a service pipeline.</p>
        pub fn set_repository_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_id = input;
            self
        }
        /// <p>The name of the code repository branch that holds the code that's deployed in AWS Proton. <i>Don't</i> include this
        /// parameter if your service template <i>doesn't</i> include a service pipeline.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the code repository branch that holds the code that's deployed in AWS Proton. <i>Don't</i> include this
        /// parameter if your service template <i>doesn't</i> include a service pipeline.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your service. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for your service. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceInput`](crate::input::CreateServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceInput {
                name: self.name,
                description: self.description,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                spec: self.spec,
                repository_connection_arn: self.repository_connection_arn,
                repository_id: self.repository_id,
                branch_name: self.branch_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceInputOperationOutputAlias = crate::operation::CreateService;
#[doc(hidden)]
pub type CreateServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServiceInput {
    /// Consumes the builder and constructs an Operation<[`CreateService`](crate::operation::CreateService)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateService",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceInput`](crate::input::CreateServiceInput)
    pub fn builder() -> crate::input::create_service_input::Builder {
        crate::input::create_service_input::Builder::default()
    }
}

/// See [`CreateServiceTemplateInput`](crate::input::CreateServiceTemplateInput)
pub mod create_service_template_input {
    /// A builder for [`CreateServiceTemplateInput`](crate::input::CreateServiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) pipeline_provisioning: std::option::Option<crate::model::Provisioning>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the service template as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the service template as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the service template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A customer provided encryption key that's used to encrypt data.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>A customer provided encryption key that's used to encrypt data.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>AWS Proton includes a service pipeline for your service by default. When included, this parameter indicates that an AWS Proton service
        /// pipeline <i>won't</i> be included for your service. Once specified, this parameter <i>can't</i> be changed.
        /// For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Service template
        /// bundles</a> in the <i>AWS Proton Administrator Guide</i>.</p>
        pub fn pipeline_provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.pipeline_provisioning = Some(input);
            self
        }
        /// <p>AWS Proton includes a service pipeline for your service by default. When included, this parameter indicates that an AWS Proton service
        /// pipeline <i>won't</i> be included for your service. Once specified, this parameter <i>can't</i> be changed.
        /// For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Service template
        /// bundles</a> in the <i>AWS Proton Administrator Guide</i>.</p>
        pub fn set_pipeline_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.pipeline_provisioning = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your service template. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for your service template. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceTemplateInput`](crate::input::CreateServiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceTemplateInput {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
                encryption_key: self.encryption_key,
                pipeline_provisioning: self.pipeline_provisioning,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceTemplateInputOperationOutputAlias = crate::operation::CreateServiceTemplate;
#[doc(hidden)]
pub type CreateServiceTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateServiceTemplate`](crate::operation::CreateServiceTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServiceTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateServiceTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_service_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServiceTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceTemplateInput`](crate::input::CreateServiceTemplateInput)
    pub fn builder() -> crate::input::create_service_template_input::Builder {
        crate::input::create_service_template_input::Builder::default()
    }
}

/// See [`CreateServiceTemplateVersionInput`](crate::input::CreateServiceTemplateVersionInput)
pub mod create_service_template_version_input {
    /// A builder for [`CreateServiceTemplateVersionInput`](crate::input::CreateServiceTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::TemplateVersionSourceInput>,
        pub(crate) compatible_environment_templates:
            std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the service template version that the
        /// first request created.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the service template version that the
        /// first request created.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>A description of the new version of a service template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the new version of a service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>To create a new minor version of the service template, include a <code>majorVersion</code>.</p>
        /// <p>To create a new major and minor version of the service template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To create a new minor version of the service template, include a <code>majorVersion</code>.</p>
        /// <p>To create a new major and minor version of the service template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of a service template.</p>
        pub fn source(mut self, input: crate::model::TemplateVersionSourceInput) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of a service template.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionSourceInput>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `compatible_environment_templates`.
        ///
        /// To override the contents of this collection use [`set_compatible_environment_templates`](Self::set_compatible_environment_templates).
        ///
        /// <p>An array of compatible environment template objects for the new version of a service template.</p>
        pub fn compatible_environment_templates(
            mut self,
            input: impl Into<crate::model::CompatibleEnvironmentTemplateInput>,
        ) -> Self {
            let mut v = self.compatible_environment_templates.unwrap_or_default();
            v.push(input.into());
            self.compatible_environment_templates = Some(v);
            self
        }
        /// <p>An array of compatible environment template objects for the new version of a service template.</p>
        pub fn set_compatible_environment_templates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>,
            >,
        ) -> Self {
            self.compatible_environment_templates = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for a new version of a service template.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for a new version of a service template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceTemplateVersionInput`](crate::input::CreateServiceTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceTemplateVersionInput {
                client_token: self.client_token,
                template_name: self.template_name,
                description: self.description,
                major_version: self.major_version,
                source: self.source,
                compatible_environment_templates: self.compatible_environment_templates,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceTemplateVersionInputOperationOutputAlias =
    crate::operation::CreateServiceTemplateVersion;
#[doc(hidden)]
pub type CreateServiceTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServiceTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateServiceTemplateVersion`](crate::operation::CreateServiceTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServiceTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.CreateServiceTemplateVersion",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_service_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServiceTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServiceTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceTemplateVersionInput`](crate::input::CreateServiceTemplateVersionInput)
    pub fn builder() -> crate::input::create_service_template_version_input::Builder {
        crate::input::create_service_template_version_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
pub mod delete_environment_input {
    /// A builder for [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentInputOperationOutputAlias = crate::operation::DeleteEnvironment;
#[doc(hidden)]
pub type DeleteEnvironmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironment`](crate::operation::DeleteEnvironment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteEnvironment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_environment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    pub fn builder() -> crate::input::delete_environment_input::Builder {
        crate::input::delete_environment_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentAccountConnectionInput`](crate::input::DeleteEnvironmentAccountConnectionInput)
pub mod delete_environment_account_connection_input {
    /// A builder for [`DeleteEnvironmentAccountConnectionInput`](crate::input::DeleteEnvironmentAccountConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentAccountConnectionInput`](crate::input::DeleteEnvironmentAccountConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentAccountConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentAccountConnectionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentAccountConnectionInputOperationOutputAlias =
    crate::operation::DeleteEnvironmentAccountConnection;
#[doc(hidden)]
pub type DeleteEnvironmentAccountConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEnvironmentAccountConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironmentAccountConnection`](crate::operation::DeleteEnvironmentAccountConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironmentAccountConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEnvironmentAccountConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEnvironmentAccountConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEnvironmentAccountConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteEnvironmentAccountConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_environment_account_connection(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironmentAccountConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironmentAccountConnection",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentAccountConnectionInput`](crate::input::DeleteEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::delete_environment_account_connection_input::Builder {
        crate::input::delete_environment_account_connection_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentTemplateInput`](crate::input::DeleteEnvironmentTemplateInput)
pub mod delete_environment_template_input {
    /// A builder for [`DeleteEnvironmentTemplateInput`](crate::input::DeleteEnvironmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment template to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment template to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentTemplateInput`](crate::input::DeleteEnvironmentTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentTemplateInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentTemplateInputOperationOutputAlias =
    crate::operation::DeleteEnvironmentTemplate;
#[doc(hidden)]
pub type DeleteEnvironmentTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEnvironmentTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironmentTemplate`](crate::operation::DeleteEnvironmentTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironmentTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEnvironmentTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEnvironmentTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEnvironmentTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteEnvironmentTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_environment_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironmentTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironmentTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentTemplateInput`](crate::input::DeleteEnvironmentTemplateInput)
    pub fn builder() -> crate::input::delete_environment_template_input::Builder {
        crate::input::delete_environment_template_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentTemplateVersionInput`](crate::input::DeleteEnvironmentTemplateVersionInput)
pub mod delete_environment_template_version_input {
    /// A builder for [`DeleteEnvironmentTemplateVersionInput`](crate::input::DeleteEnvironmentTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The environment template major version to delete.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The environment template major version to delete.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>The environment template minor version to delete.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The environment template minor version to delete.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentTemplateVersionInput`](crate::input::DeleteEnvironmentTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentTemplateVersionInput {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentTemplateVersionInputOperationOutputAlias =
    crate::operation::DeleteEnvironmentTemplateVersion;
#[doc(hidden)]
pub type DeleteEnvironmentTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEnvironmentTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironmentTemplateVersion`](crate::operation::DeleteEnvironmentTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironmentTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEnvironmentTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEnvironmentTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEnvironmentTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteEnvironmentTemplateVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_environment_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironmentTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironmentTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentTemplateVersionInput`](crate::input::DeleteEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::delete_environment_template_version_input::Builder {
        crate::input::delete_environment_template_version_input::Builder::default()
    }
}

/// See [`DeleteServiceInput`](crate::input::DeleteServiceInput)
pub mod delete_service_input {
    /// A builder for [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceInput`](crate::input::DeleteServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceInputOperationOutputAlias = crate::operation::DeleteService;
#[doc(hidden)]
pub type DeleteServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServiceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteService`](crate::operation::DeleteService)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteService",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    pub fn builder() -> crate::input::delete_service_input::Builder {
        crate::input::delete_service_input::Builder::default()
    }
}

/// See [`DeleteServiceTemplateInput`](crate::input::DeleteServiceTemplateInput)
pub mod delete_service_template_input {
    /// A builder for [`DeleteServiceTemplateInput`](crate::input::DeleteServiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service template to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service template to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceTemplateInput`](crate::input::DeleteServiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceTemplateInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceTemplateInputOperationOutputAlias = crate::operation::DeleteServiceTemplate;
#[doc(hidden)]
pub type DeleteServiceTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServiceTemplate`](crate::operation::DeleteServiceTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServiceTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteServiceTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_service_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServiceTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceTemplateInput`](crate::input::DeleteServiceTemplateInput)
    pub fn builder() -> crate::input::delete_service_template_input::Builder {
        crate::input::delete_service_template_input::Builder::default()
    }
}

/// See [`DeleteServiceTemplateVersionInput`](crate::input::DeleteServiceTemplateVersionInput)
pub mod delete_service_template_version_input {
    /// A builder for [`DeleteServiceTemplateVersionInput`](crate::input::DeleteServiceTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The service template major version to delete.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The service template major version to delete.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>The service template minor version to delete.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The service template minor version to delete.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceTemplateVersionInput`](crate::input::DeleteServiceTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceTemplateVersionInput {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceTemplateVersionInputOperationOutputAlias =
    crate::operation::DeleteServiceTemplateVersion;
#[doc(hidden)]
pub type DeleteServiceTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServiceTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServiceTemplateVersion`](crate::operation::DeleteServiceTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServiceTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.DeleteServiceTemplateVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_service_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServiceTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServiceTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceTemplateVersionInput`](crate::input::DeleteServiceTemplateVersionInput)
    pub fn builder() -> crate::input::delete_service_template_version_input::Builder {
        crate::input::delete_service_template_version_input::Builder::default()
    }
}

/// See [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
pub mod get_account_settings_input {
    /// A builder for [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountSettingsInputOperationOutputAlias = crate::operation::GetAccountSettings;
#[doc(hidden)]
pub type GetAccountSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountSettings`](crate::operation::GetAccountSettings)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetAccountSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_account_settings(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountSettings",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
}

/// See [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
pub mod get_environment_input {
    /// A builder for [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment that you want to get the detail data for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnvironmentInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetEnvironmentInputOperationOutputAlias = crate::operation::GetEnvironment;
#[doc(hidden)]
pub type GetEnvironmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`GetEnvironment`](crate::operation::GetEnvironment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnvironment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetEnvironment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_environment(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnvironment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    pub fn builder() -> crate::input::get_environment_input::Builder {
        crate::input::get_environment_input::Builder::default()
    }
}

/// See [`GetEnvironmentAccountConnectionInput`](crate::input::GetEnvironmentAccountConnectionInput)
pub mod get_environment_account_connection_input {
    /// A builder for [`GetEnvironmentAccountConnectionInput`](crate::input::GetEnvironmentAccountConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentAccountConnectionInput`](crate::input::GetEnvironmentAccountConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnvironmentAccountConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnvironmentAccountConnectionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetEnvironmentAccountConnectionInputOperationOutputAlias =
    crate::operation::GetEnvironmentAccountConnection;
#[doc(hidden)]
pub type GetEnvironmentAccountConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEnvironmentAccountConnectionInput {
    /// Consumes the builder and constructs an Operation<[`GetEnvironmentAccountConnection`](crate::operation::GetEnvironmentAccountConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnvironmentAccountConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnvironmentAccountConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnvironmentAccountConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnvironmentAccountConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetEnvironmentAccountConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_environment_account_connection(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnvironmentAccountConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnvironmentAccountConnection",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnvironmentAccountConnectionInput`](crate::input::GetEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::get_environment_account_connection_input::Builder {
        crate::input::get_environment_account_connection_input::Builder::default()
    }
}

/// See [`GetEnvironmentTemplateInput`](crate::input::GetEnvironmentTemplateInput)
pub mod get_environment_template_input {
    /// A builder for [`GetEnvironmentTemplateInput`](crate::input::GetEnvironmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment template that you want to get the detail data for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment template that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentTemplateInput`](crate::input::GetEnvironmentTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnvironmentTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnvironmentTemplateInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetEnvironmentTemplateInputOperationOutputAlias = crate::operation::GetEnvironmentTemplate;
#[doc(hidden)]
pub type GetEnvironmentTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEnvironmentTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetEnvironmentTemplate`](crate::operation::GetEnvironmentTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnvironmentTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnvironmentTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnvironmentTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnvironmentTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetEnvironmentTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_environment_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnvironmentTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnvironmentTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnvironmentTemplateInput`](crate::input::GetEnvironmentTemplateInput)
    pub fn builder() -> crate::input::get_environment_template_input::Builder {
        crate::input::get_environment_template_input::Builder::default()
    }
}

/// See [`GetEnvironmentTemplateVersionInput`](crate::input::GetEnvironmentTemplateVersionInput)
pub mod get_environment_template_version_input {
    /// A builder for [`GetEnvironmentTemplateVersionInput`](crate::input::GetEnvironmentTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>To view environment template major version detail data, include <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To view environment template major version detail data, include <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>To view environment template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>To view environment template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentTemplateVersionInput`](crate::input::GetEnvironmentTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnvironmentTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnvironmentTemplateVersionInput {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEnvironmentTemplateVersionInputOperationOutputAlias =
    crate::operation::GetEnvironmentTemplateVersion;
#[doc(hidden)]
pub type GetEnvironmentTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEnvironmentTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetEnvironmentTemplateVersion`](crate::operation::GetEnvironmentTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnvironmentTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnvironmentTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnvironmentTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnvironmentTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetEnvironmentTemplateVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_environment_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnvironmentTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnvironmentTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnvironmentTemplateVersionInput`](crate::input::GetEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::get_environment_template_version_input::Builder {
        crate::input::get_environment_template_version_input::Builder::default()
    }
}

/// See [`GetServiceInput`](crate::input::GetServiceInput)
pub mod get_service_input {
    /// A builder for [`GetServiceInput`](crate::input::GetServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service that you want to get the detail data for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceInput`](crate::input::GetServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetServiceInputOperationOutputAlias = crate::operation::GetService;
#[doc(hidden)]
pub type GetServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceInput {
    /// Consumes the builder and constructs an Operation<[`GetService`](crate::operation::GetService)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetService",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceInput`](crate::input::GetServiceInput)
    pub fn builder() -> crate::input::get_service_input::Builder {
        crate::input::get_service_input::Builder::default()
    }
}

/// See [`GetServiceInstanceInput`](crate::input::GetServiceInstanceInput)
pub mod get_service_instance_input {
    /// A builder for [`GetServiceInstanceInput`](crate::input::GetServiceInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a service instance that you want to get the detail data for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a service instance that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceInstanceInput`](crate::input::GetServiceInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceInstanceInput {
                name: self.name,
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceInstanceInputOperationOutputAlias = crate::operation::GetServiceInstance;
#[doc(hidden)]
pub type GetServiceInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceInstance`](crate::operation::GetServiceInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetServiceInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_instance(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceInstance",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceInstanceInput`](crate::input::GetServiceInstanceInput)
    pub fn builder() -> crate::input::get_service_instance_input::Builder {
        crate::input::get_service_instance_input::Builder::default()
    }
}

/// See [`GetServiceTemplateInput`](crate::input::GetServiceTemplateInput)
pub mod get_service_template_input {
    /// A builder for [`GetServiceTemplateInput`](crate::input::GetServiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service template that you want to get detail data for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service template that you want to get detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceTemplateInput`](crate::input::GetServiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceTemplateInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetServiceTemplateInputOperationOutputAlias = crate::operation::GetServiceTemplate;
#[doc(hidden)]
pub type GetServiceTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceTemplate`](crate::operation::GetServiceTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetServiceTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_template(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceTemplateInput`](crate::input::GetServiceTemplateInput)
    pub fn builder() -> crate::input::get_service_template_input::Builder {
        crate::input::get_service_template_input::Builder::default()
    }
}

/// See [`GetServiceTemplateVersionInput`](crate::input::GetServiceTemplateVersionInput)
pub mod get_service_template_version_input {
    /// A builder for [`GetServiceTemplateVersionInput`](crate::input::GetServiceTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>To view service template major version detail data, include <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To view service template major version detail data, include <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>To view service template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>To view service template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceTemplateVersionInput`](crate::input::GetServiceTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceTemplateVersionInput {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceTemplateVersionInputOperationOutputAlias =
    crate::operation::GetServiceTemplateVersion;
#[doc(hidden)]
pub type GetServiceTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceTemplateVersion`](crate::operation::GetServiceTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.GetServiceTemplateVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_template_version(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceTemplateVersionInput`](crate::input::GetServiceTemplateVersionInput)
    pub fn builder() -> crate::input::get_service_template_version_input::Builder {
        crate::input::get_service_template_version_input::Builder::default()
    }
}

/// See [`ListEnvironmentAccountConnectionsInput`](crate::input::ListEnvironmentAccountConnectionsInput)
pub mod list_environment_account_connections_input {
    /// A builder for [`ListEnvironmentAccountConnectionsInput`](crate::input::ListEnvironmentAccountConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) requested_by:
            std::option::Option<crate::model::EnvironmentAccountConnectionRequesterAccountType>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) statuses:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentAccountConnectionStatus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of account making the <code>ListEnvironmentAccountConnections</code> request.</p>
        pub fn requested_by(
            mut self,
            input: crate::model::EnvironmentAccountConnectionRequesterAccountType,
        ) -> Self {
            self.requested_by = Some(input);
            self
        }
        /// <p>The type of account making the <code>ListEnvironmentAccountConnections</code> request.</p>
        pub fn set_requested_by(
            mut self,
            input: std::option::Option<
                crate::model::EnvironmentAccountConnectionRequesterAccountType,
            >,
        ) -> Self {
            self.requested_by = input;
            self
        }
        /// <p>The environment name that's associated with each listed environment account connection.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The environment name that's associated with each listed environment account connection.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>The status details for each listed environment account connection.</p>
        pub fn statuses(
            mut self,
            input: impl Into<crate::model::EnvironmentAccountConnectionStatus>,
        ) -> Self {
            let mut v = self.statuses.unwrap_or_default();
            v.push(input.into());
            self.statuses = Some(v);
            self
        }
        /// <p>The status details for each listed environment account connection.</p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::EnvironmentAccountConnectionStatus>,
            >,
        ) -> Self {
            self.statuses = input;
            self
        }
        /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
        /// list of environment account connections that was previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
        /// list of environment account connections that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of environment account connections to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of environment account connections to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentAccountConnectionsInput`](crate::input::ListEnvironmentAccountConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentAccountConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentAccountConnectionsInput {
                requested_by: self.requested_by,
                environment_name: self.environment_name,
                statuses: self.statuses,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentAccountConnectionsInputOperationOutputAlias =
    crate::operation::ListEnvironmentAccountConnections;
#[doc(hidden)]
pub type ListEnvironmentAccountConnectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEnvironmentAccountConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironmentAccountConnections`](crate::operation::ListEnvironmentAccountConnections)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironmentAccountConnections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentAccountConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentAccountConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentAccountConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListEnvironmentAccountConnections",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_environment_account_connections(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironmentAccountConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironmentAccountConnections",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentAccountConnectionsInput`](crate::input::ListEnvironmentAccountConnectionsInput)
    pub fn builder() -> crate::input::list_environment_account_connections_input::Builder {
        crate::input::list_environment_account_connections_input::Builder::default()
    }
}

/// See [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
pub mod list_environments_input {
    /// A builder for [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) environment_templates:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateFilter>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next environment in the array of environments, after the list of environments that was
        /// previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next environment in the array of environments, after the list of environments that was
        /// previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of environments to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of environments to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `environment_templates`.
        ///
        /// To override the contents of this collection use [`set_environment_templates`](Self::set_environment_templates).
        ///
        /// <p>An array of the versions of the environment template.</p>
        pub fn environment_templates(
            mut self,
            input: impl Into<crate::model::EnvironmentTemplateFilter>,
        ) -> Self {
            let mut v = self.environment_templates.unwrap_or_default();
            v.push(input.into());
            self.environment_templates = Some(v);
            self
        }
        /// <p>An array of the versions of the environment template.</p>
        pub fn set_environment_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateFilter>>,
        ) -> Self {
            self.environment_templates = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                environment_templates: self.environment_templates,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentsInputOperationOutputAlias = crate::operation::ListEnvironments;
#[doc(hidden)]
pub type ListEnvironmentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEnvironmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironments`](crate::operation::ListEnvironments)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListEnvironments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_environments(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironments",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    pub fn builder() -> crate::input::list_environments_input::Builder {
        crate::input::list_environments_input::Builder::default()
    }
}

/// See [`ListEnvironmentTemplatesInput`](crate::input::ListEnvironmentTemplatesInput)
pub mod list_environment_templates_input {
    /// A builder for [`ListEnvironmentTemplatesInput`](crate::input::ListEnvironmentTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the list of environment
        /// templates that was previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the list of environment
        /// templates that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of environment templates to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of environment templates to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentTemplatesInput`](crate::input::ListEnvironmentTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentTemplatesInputOperationOutputAlias =
    crate::operation::ListEnvironmentTemplates;
#[doc(hidden)]
pub type ListEnvironmentTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEnvironmentTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironmentTemplates`](crate::operation::ListEnvironmentTemplates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironmentTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListEnvironmentTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_environment_templates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironmentTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironmentTemplates",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentTemplatesInput`](crate::input::ListEnvironmentTemplatesInput)
    pub fn builder() -> crate::input::list_environment_templates_input::Builder {
        crate::input::list_environment_templates_input::Builder::default()
    }
}

/// See [`ListEnvironmentTemplateVersionsInput`](crate::input::ListEnvironmentTemplateVersionsInput)
pub mod list_environment_template_versions_input {
    /// A builder for [`ListEnvironmentTemplateVersionsInput`](crate::input::ListEnvironmentTemplateVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
        /// after the list of major or minor versions that was previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
        /// after the list of major or minor versions that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of major or minor versions of an environment template to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of major or minor versions of an environment template to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>To view a list of minor of versions under a major version of an environment template, include <code>majorVersion</code>.</p>
        /// <p>To view a list of major versions of an environment template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To view a list of minor of versions under a major version of an environment template, include <code>majorVersion</code>.</p>
        /// <p>To view a list of major versions of an environment template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentTemplateVersionsInput`](crate::input::ListEnvironmentTemplateVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentTemplateVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentTemplateVersionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                template_name: self.template_name,
                major_version: self.major_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentTemplateVersionsInputOperationOutputAlias =
    crate::operation::ListEnvironmentTemplateVersions;
#[doc(hidden)]
pub type ListEnvironmentTemplateVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEnvironmentTemplateVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironmentTemplateVersions`](crate::operation::ListEnvironmentTemplateVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironmentTemplateVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentTemplateVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentTemplateVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentTemplateVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListEnvironmentTemplateVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_environment_template_versions(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironmentTemplateVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironmentTemplateVersions",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentTemplateVersionsInput`](crate::input::ListEnvironmentTemplateVersionsInput)
    pub fn builder() -> crate::input::list_environment_template_versions_input::Builder {
        crate::input::list_environment_template_versions_input::Builder::default()
    }
}

/// See [`ListServiceInstancesInput`](crate::input::ListServiceInstancesInput)
pub mod list_service_instances_input {
    /// A builder for [`ListServiceInstancesInput`](crate::input::ListServiceInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>A token to indicate the location of the next service in the array of service instances, after the list of service instances that was
        /// previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next service in the array of service instances, after the list of service instances that was
        /// previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of service instances to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of service instances to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceInstancesInput`](crate::input::ListServiceInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServiceInstancesInput {
                service_name: self.service_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServiceInstancesInputOperationOutputAlias = crate::operation::ListServiceInstances;
#[doc(hidden)]
pub type ListServiceInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServiceInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceInstances`](crate::operation::ListServiceInstances)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListServiceInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_service_instances(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceInstances",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceInstancesInput`](crate::input::ListServiceInstancesInput)
    pub fn builder() -> crate::input::list_service_instances_input::Builder {
        crate::input::list_service_instances_input::Builder::default()
    }
}

/// See [`ListServicesInput`](crate::input::ListServicesInput)
pub mod list_services_input {
    /// A builder for [`ListServicesInput`](crate::input::ListServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next service in the array of services, after the list of services that was previously
        /// requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next service in the array of services, after the list of services that was previously
        /// requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of services to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of services to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesInput`](crate::input::ListServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServicesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServicesInputOperationOutputAlias = crate::operation::ListServices;
#[doc(hidden)]
pub type ListServicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServicesInput {
    /// Consumes the builder and constructs an Operation<[`ListServices`](crate::operation::ListServices)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListServices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_services(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServices",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServicesInput`](crate::input::ListServicesInput)
    pub fn builder() -> crate::input::list_services_input::Builder {
        crate::input::list_services_input::Builder::default()
    }
}

/// See [`ListServiceTemplatesInput`](crate::input::ListServiceTemplatesInput)
pub mod list_service_templates_input {
    /// A builder for [`ListServiceTemplatesInput`](crate::input::ListServiceTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next service template in the array of service templates, after the list of service templates
        /// previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next service template in the array of service templates, after the list of service templates
        /// previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of service templates to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of service templates to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceTemplatesInput`](crate::input::ListServiceTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServiceTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServiceTemplatesInputOperationOutputAlias = crate::operation::ListServiceTemplates;
#[doc(hidden)]
pub type ListServiceTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServiceTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceTemplates`](crate::operation::ListServiceTemplates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListServiceTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_service_templates(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceTemplates",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceTemplatesInput`](crate::input::ListServiceTemplatesInput)
    pub fn builder() -> crate::input::list_service_templates_input::Builder {
        crate::input::list_service_templates_input::Builder::default()
    }
}

/// See [`ListServiceTemplateVersionsInput`](crate::input::ListServiceTemplateVersionsInput)
pub mod list_service_template_versions_input {
    /// A builder for [`ListServiceTemplateVersionsInput`](crate::input::ListServiceTemplateVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
        /// the list of major or minor versions that was previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
        /// the list of major or minor versions that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of major or minor versions of a service template to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of major or minor versions of a service template to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>To view a list of minor of versions under a major version of a service template, include <code>majorVersion</code>.</p>
        /// <p>To view a list of major versions of a service template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To view a list of minor of versions under a major version of a service template, include <code>majorVersion</code>.</p>
        /// <p>To view a list of major versions of a service template, <i>exclude</i>
        /// <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceTemplateVersionsInput`](crate::input::ListServiceTemplateVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceTemplateVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServiceTemplateVersionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                template_name: self.template_name,
                major_version: self.major_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServiceTemplateVersionsInputOperationOutputAlias =
    crate::operation::ListServiceTemplateVersions;
#[doc(hidden)]
pub type ListServiceTemplateVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServiceTemplateVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceTemplateVersions`](crate::operation::ListServiceTemplateVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceTemplateVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceTemplateVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceTemplateVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceTemplateVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListServiceTemplateVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_service_template_versions(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceTemplateVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceTemplateVersions",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceTemplateVersionsInput`](crate::input::ListServiceTemplateVersionsInput)
    pub fn builder() -> crate::input::list_service_template_versions_input::Builder {
        crate::input::list_service_template_versions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for the listed tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for the listed tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the list of resource tags that was
        /// previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the list of resource tags that was
        /// previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of tags to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of tags to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RejectEnvironmentAccountConnectionInput`](crate::input::RejectEnvironmentAccountConnectionInput)
pub mod reject_environment_account_connection_input {
    /// A builder for [`RejectEnvironmentAccountConnectionInput`](crate::input::RejectEnvironmentAccountConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection to reject.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection to reject.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectEnvironmentAccountConnectionInput`](crate::input::RejectEnvironmentAccountConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectEnvironmentAccountConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectEnvironmentAccountConnectionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type RejectEnvironmentAccountConnectionInputOperationOutputAlias =
    crate::operation::RejectEnvironmentAccountConnection;
#[doc(hidden)]
pub type RejectEnvironmentAccountConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RejectEnvironmentAccountConnectionInput {
    /// Consumes the builder and constructs an Operation<[`RejectEnvironmentAccountConnection`](crate::operation::RejectEnvironmentAccountConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectEnvironmentAccountConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectEnvironmentAccountConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectEnvironmentAccountConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectEnvironmentAccountConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.RejectEnvironmentAccountConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_environment_account_connection(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectEnvironmentAccountConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectEnvironmentAccountConnection",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectEnvironmentAccountConnectionInput`](crate::input::RejectEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::reject_environment_account_connection_input::Builder {
        crate::input::reject_environment_account_connection_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that the resource tag is applied to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the resource tag is applied to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of resource tags to apply to a resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of resource tags to apply to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that the tag is to be removed from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the tag is to be removed from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag keys indicating the resource tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>An array of tag keys indicating the resource tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
pub mod update_account_settings_input {
    /// A builder for [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_service_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS Proton pipeline service role.</p>
        pub fn pipeline_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Proton pipeline service role.</p>
        pub fn set_pipeline_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_service_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccountSettingsInput {
                pipeline_service_role_arn: self.pipeline_service_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccountSettingsInputOperationOutputAlias = crate::operation::UpdateAccountSettings;
#[doc(hidden)]
pub type UpdateAccountSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccountSettings`](crate::operation::UpdateAccountSettings)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccountSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateAccountSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_account_settings(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccountSettings",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    pub fn builder() -> crate::input::update_account_settings_input::Builder {
        crate::input::update_account_settings_input::Builder::default()
    }
}

/// See [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
pub mod update_environment_input {
    /// A builder for [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) proton_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentUpdateType>,
        pub(crate) environment_account_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the environment update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The formatted specification that defines the update.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The formatted specification that defines the update.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The ID of the major version of the environment to update.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The ID of the major version of the environment to update.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The ID of the minor version of the environment to update.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The ID of the minor version of the environment to update.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make API calls to other services your
        /// behalf.</p>
        pub fn proton_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.proton_service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make API calls to other services your
        /// behalf.</p>
        pub fn set_proton_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proton_service_role_arn = input;
            self
        }
        /// <p>There are four modes for updating an environment as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are
        /// updated. <i>Don’t</i> include minor or major version parameters when you use this
        /// <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current
        /// major version in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of
        /// the current template, by default. You can also specify a different major version that is higher than the major version in use
        /// and a minor version (optional).</p>
        /// </dd>
        /// </dl>
        pub fn deployment_type(mut self, input: crate::model::DeploymentUpdateType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>There are four modes for updating an environment as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are
        /// updated. <i>Don’t</i> include minor or major version parameters when you use this
        /// <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current
        /// major version in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of
        /// the current template, by default. You can also specify a different major version that is higher than the major version in use
        /// and a minor version (optional).</p>
        /// </dd>
        /// </dl>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentUpdateType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>The ID of the environment account connection.</p>
        /// <p>You can only update to a new environment account connection if it was created in the same environment account that the current
        /// environment account connection was created in and is associated with the current environment.</p>
        pub fn environment_account_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection.</p>
        /// <p>You can only update to a new environment account connection if it was created in the same environment account that the current
        /// environment account connection was created in and is associated with the current environment.</p>
        pub fn set_environment_account_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnvironmentInput {
                name: self.name,
                description: self.description,
                spec: self.spec,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                proton_service_role_arn: self.proton_service_role_arn,
                deployment_type: self.deployment_type,
                environment_account_connection_id: self.environment_account_connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnvironmentInputOperationOutputAlias = crate::operation::UpdateEnvironment;
#[doc(hidden)]
pub type UpdateEnvironmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnvironment`](crate::operation::UpdateEnvironment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnvironment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateEnvironment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_environment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnvironment",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    pub fn builder() -> crate::input::update_environment_input::Builder {
        crate::input::update_environment_input::Builder::default()
    }
}

/// See [`UpdateEnvironmentAccountConnectionInput`](crate::input::UpdateEnvironmentAccountConnectionInput)
pub mod update_environment_account_connection_input {
    /// A builder for [`UpdateEnvironmentAccountConnectionInput`](crate::input::UpdateEnvironmentAccountConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that is associated with the environment account connection to update.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that is associated with the environment account connection to update.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentAccountConnectionInput`](crate::input::UpdateEnvironmentAccountConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnvironmentAccountConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnvironmentAccountConnectionInput {
                id: self.id,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnvironmentAccountConnectionInputOperationOutputAlias =
    crate::operation::UpdateEnvironmentAccountConnection;
#[doc(hidden)]
pub type UpdateEnvironmentAccountConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEnvironmentAccountConnectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnvironmentAccountConnection`](crate::operation::UpdateEnvironmentAccountConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnvironmentAccountConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEnvironmentAccountConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEnvironmentAccountConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEnvironmentAccountConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateEnvironmentAccountConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_environment_account_connection(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnvironmentAccountConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnvironmentAccountConnection",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentAccountConnectionInput`](crate::input::UpdateEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::update_environment_account_connection_input::Builder {
        crate::input::update_environment_account_connection_input::Builder::default()
    }
}

/// See [`UpdateEnvironmentTemplateInput`](crate::input::UpdateEnvironmentTemplateInput)
pub mod update_environment_template_input {
    /// A builder for [`UpdateEnvironmentTemplateInput`](crate::input::UpdateEnvironmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment template to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment template to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the environment template to update as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template to update as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the environment template update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment template update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentTemplateInput`](crate::input::UpdateEnvironmentTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnvironmentTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnvironmentTemplateInput {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnvironmentTemplateInputOperationOutputAlias =
    crate::operation::UpdateEnvironmentTemplate;
#[doc(hidden)]
pub type UpdateEnvironmentTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEnvironmentTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnvironmentTemplate`](crate::operation::UpdateEnvironmentTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnvironmentTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEnvironmentTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEnvironmentTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEnvironmentTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateEnvironmentTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_environment_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnvironmentTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnvironmentTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentTemplateInput`](crate::input::UpdateEnvironmentTemplateInput)
    pub fn builder() -> crate::input::update_environment_template_input::Builder {
        crate::input::update_environment_template_input::Builder::default()
    }
}

/// See [`UpdateEnvironmentTemplateVersionInput`](crate::input::UpdateEnvironmentTemplateVersionInput)
pub mod update_environment_template_version_input {
    /// A builder for [`UpdateEnvironmentTemplateVersionInput`](crate::input::UpdateEnvironmentTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TemplateVersionStatus>,
    }
    impl Builder {
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>To update a major version of an environment template, include <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To update a major version of an environment template, include <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>To update a minor version of an environment template, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>To update a minor version of an environment template, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>A description of environment template version to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of environment template version to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the environment template minor version to update.</p>
        pub fn status(mut self, input: crate::model::TemplateVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the environment template minor version to update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentTemplateVersionInput`](crate::input::UpdateEnvironmentTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnvironmentTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnvironmentTemplateVersionInput {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
                description: self.description,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnvironmentTemplateVersionInputOperationOutputAlias =
    crate::operation::UpdateEnvironmentTemplateVersion;
#[doc(hidden)]
pub type UpdateEnvironmentTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEnvironmentTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnvironmentTemplateVersion`](crate::operation::UpdateEnvironmentTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnvironmentTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEnvironmentTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEnvironmentTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEnvironmentTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateEnvironmentTemplateVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_environment_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnvironmentTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnvironmentTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentTemplateVersionInput`](crate::input::UpdateEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::update_environment_template_version_input::Builder {
        crate::input::update_environment_template_version_input::Builder::default()
    }
}

/// See [`UpdateServiceInput`](crate::input::UpdateServiceInput)
pub mod update_service_input {
    /// A builder for [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service to edit.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service to edit.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The edited service description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The edited service description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the
        /// list. <i>Don't</i> include edits to the existing service instances or pipeline. For more information, see <i>Edit a
        /// service</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-update.html">AWS Proton Administrator
        /// Guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-update.html">AWS Proton User Guide</a>.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the
        /// list. <i>Don't</i> include edits to the existing service instances or pipeline. For more information, see <i>Edit a
        /// service</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-update.html">AWS Proton Administrator
        /// Guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-update.html">AWS Proton User Guide</a>.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceInput`](crate::input::UpdateServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceInput {
                name: self.name,
                description: self.description,
                spec: self.spec,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceInputOperationOutputAlias = crate::operation::UpdateService;
#[doc(hidden)]
pub type UpdateServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServiceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateService`](crate::operation::UpdateService)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateService",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    pub fn builder() -> crate::input::update_service_input::Builder {
        crate::input::update_service_input::Builder::default()
    }
}

/// See [`UpdateServiceInstanceInput`](crate::input::UpdateServiceInstanceInput)
pub mod update_service_instance_input {
    /// A builder for [`UpdateServiceInstanceInput`](crate::input::UpdateServiceInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentUpdateType>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service instance to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service instance to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service instance as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are
        /// updated. <i>Don’t</i> include minor or major version parameters when you use this
        /// <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the
        /// current major version in use, by default. You can also specify a different minor version of the current major version in
        /// use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version
        /// of the current template, by default. You can also specify a different major version that is higher than the major version in
        /// use and a minor version (optional).</p>
        /// </dd>
        /// </dl>
        pub fn deployment_type(mut self, input: crate::model::DeploymentUpdateType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service instance as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are
        /// updated. <i>Don’t</i> include minor or major version parameters when you use this
        /// <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the
        /// current major version in use, by default. You can also specify a different minor version of the current major version in
        /// use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version
        /// of the current template, by default. You can also specify a different major version that is higher than the major version in
        /// use and a minor version (optional).</p>
        /// </dd>
        /// </dl>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentUpdateType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>The formatted specification that defines the service instance update.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The formatted specification that defines the service instance update.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The major version of the service template to update.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The major version of the service template to update.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The minor version of the service template to update.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of the service template to update.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceInstanceInput`](crate::input::UpdateServiceInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceInstanceInput {
                name: self.name,
                service_name: self.service_name,
                deployment_type: self.deployment_type,
                spec: self.spec,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceInstanceInputOperationOutputAlias = crate::operation::UpdateServiceInstance;
#[doc(hidden)]
pub type UpdateServiceInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServiceInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServiceInstance`](crate::operation::UpdateServiceInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServiceInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServiceInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServiceInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServiceInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateServiceInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_service_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServiceInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServiceInstance",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceInstanceInput`](crate::input::UpdateServiceInstanceInput)
    pub fn builder() -> crate::input::update_service_instance_input::Builder {
        crate::input::update_service_instance_input::Builder::default()
    }
}

/// See [`UpdateServicePipelineInput`](crate::input::UpdateServicePipelineInput)
pub mod update_service_pipeline_input {
    /// A builder for [`UpdateServicePipelineInput`](crate::input::UpdateServicePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentUpdateType>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service to that the pipeline is associated with.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service to that the pipeline is associated with.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The spec for the service pipeline to update.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The spec for the service pipeline to update.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service pipeline as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are
        /// updated. <i>Don’t</i> include minor or major version parameters when you use this
        /// <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the
        /// current major version in use, by default. You can also specify a different minor version of the current major version in
        /// use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version
        /// of the current template, by default. You can also specify a different major version that is higher than the major version in
        /// use and a minor version (optional).</p>
        /// </dd>
        /// </dl>
        pub fn deployment_type(mut self, input: crate::model::DeploymentUpdateType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service pipeline as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are
        /// updated. <i>Don’t</i> include minor or major version parameters when you use this
        /// <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the
        /// current major version in use, by default. You can also specify a different minor version of the current major version in
        /// use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version
        /// of the current template, by default. You can also specify a different major version that is higher than the major version in
        /// use and a minor version (optional).</p>
        /// </dd>
        /// </dl>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentUpdateType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>The major version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The major version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The minor version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServicePipelineInput`](crate::input::UpdateServicePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServicePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServicePipelineInput {
                service_name: self.service_name,
                spec: self.spec,
                deployment_type: self.deployment_type,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServicePipelineInputOperationOutputAlias = crate::operation::UpdateServicePipeline;
#[doc(hidden)]
pub type UpdateServicePipelineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServicePipelineInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServicePipeline`](crate::operation::UpdateServicePipeline)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServicePipeline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServicePipelineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServicePipelineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServicePipelineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateServicePipeline",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_service_pipeline(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServicePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServicePipeline",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServicePipelineInput`](crate::input::UpdateServicePipelineInput)
    pub fn builder() -> crate::input::update_service_pipeline_input::Builder {
        crate::input::update_service_pipeline_input::Builder::default()
    }
}

/// See [`UpdateServiceTemplateInput`](crate::input::UpdateServiceTemplateInput)
pub mod update_service_template_input {
    /// A builder for [`UpdateServiceTemplateInput`](crate::input::UpdateServiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service template to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service template to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the service template to update as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the service template to update as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the service template update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the service template update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceTemplateInput`](crate::input::UpdateServiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceTemplateInput {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceTemplateInputOperationOutputAlias = crate::operation::UpdateServiceTemplate;
#[doc(hidden)]
pub type UpdateServiceTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServiceTemplate`](crate::operation::UpdateServiceTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServiceTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServiceTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServiceTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServiceTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateServiceTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_service_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServiceTemplate",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceTemplateInput`](crate::input::UpdateServiceTemplateInput)
    pub fn builder() -> crate::input::update_service_template_input::Builder {
        crate::input::update_service_template_input::Builder::default()
    }
}

/// See [`UpdateServiceTemplateVersionInput`](crate::input::UpdateServiceTemplateVersionInput)
pub mod update_service_template_version_input {
    /// A builder for [`UpdateServiceTemplateVersionInput`](crate::input::UpdateServiceTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TemplateVersionStatus>,
        pub(crate) compatible_environment_templates:
            std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>To update a major version of a service template, include <code>majorVersion</code>.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>To update a major version of a service template, include <code>majorVersion</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>To update a minor version of a service template, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>To update a minor version of a service template, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>A description of a service template version to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of a service template version to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the service template minor version to update.</p>
        pub fn status(mut self, input: crate::model::TemplateVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service template minor version to update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `compatible_environment_templates`.
        ///
        /// To override the contents of this collection use [`set_compatible_environment_templates`](Self::set_compatible_environment_templates).
        ///
        /// <p>An array of compatible environment names for a service template major or minor version to update.</p>
        pub fn compatible_environment_templates(
            mut self,
            input: impl Into<crate::model::CompatibleEnvironmentTemplateInput>,
        ) -> Self {
            let mut v = self.compatible_environment_templates.unwrap_or_default();
            v.push(input.into());
            self.compatible_environment_templates = Some(v);
            self
        }
        /// <p>An array of compatible environment names for a service template major or minor version to update.</p>
        pub fn set_compatible_environment_templates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>,
            >,
        ) -> Self {
            self.compatible_environment_templates = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceTemplateVersionInput`](crate::input::UpdateServiceTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceTemplateVersionInput {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
                description: self.description,
                status: self.status,
                compatible_environment_templates: self.compatible_environment_templates,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceTemplateVersionInputOperationOutputAlias =
    crate::operation::UpdateServiceTemplateVersion;
#[doc(hidden)]
pub type UpdateServiceTemplateVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServiceTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServiceTemplateVersion`](crate::operation::UpdateServiceTemplateVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServiceTemplateVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServiceTemplateVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServiceTemplateVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServiceTemplateVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AwsProton20200720.UpdateServiceTemplateVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_service_template_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServiceTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServiceTemplateVersion",
            "proton",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceTemplateVersionInput`](crate::input::UpdateServiceTemplateVersionInput)
    pub fn builder() -> crate::input::update_service_template_version_input::Builder {
        crate::input::update_service_template_version_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceTemplateVersionsInput {
    /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
    /// the list of major or minor versions that was previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of major or minor versions of a service template to list.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>To view a list of minor of versions under a major version of a service template, include <code>majorVersion</code>.</p>
    /// <p>To view a list of major versions of a service template, <i>exclude</i>
    /// <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListServiceTemplateVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceTemplateVersionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceTemplateVersionInput {
    /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the service template version that the
    /// first request created.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>A description of the new version of a service template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>To create a new minor version of the service template, include a <code>majorVersion</code>.</p>
    /// <p>To create a new major and minor version of the service template, <i>exclude</i>
    /// <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>An object that includes the template bundle S3 bucket path and name for the new version of a service template.</p>
    pub source: std::option::Option<crate::model::TemplateVersionSourceInput>,
    /// <p>An array of compatible environment template objects for the new version of a service template.</p>
    pub compatible_environment_templates:
        std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>>,
    /// <p>Create tags for a new version of a service template.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateServiceTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceTemplateVersionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("major_version", &self.major_version);
        formatter.field("source", &self.source);
        formatter.field(
            "compatible_environment_templates",
            &self.compatible_environment_templates,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceTemplateVersionInput {
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The service template major version to delete.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>The service template minor version to delete.</p>
    pub minor_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteServiceTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceTemplateVersionInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceTemplateVersionInput {
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>To update a major version of a service template, include <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>To update a minor version of a service template, include <code>minorVersion</code>.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>A description of a service template version to update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the service template minor version to update.</p>
    pub status: std::option::Option<crate::model::TemplateVersionStatus>,
    /// <p>An array of compatible environment names for a service template major or minor version to update.</p>
    pub compatible_environment_templates:
        std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>>,
}
impl std::fmt::Debug for UpdateServiceTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceTemplateVersionInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field(
            "compatible_environment_templates",
            &self.compatible_environment_templates,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceTemplateVersionInput {
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>To view service template major version detail data, include <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>To view service template minor version detail data, include <code>minorVersion</code>.</p>
    pub minor_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetServiceTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceTemplateVersionInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceTemplatesInput {
    /// <p>A token to indicate the location of the next service template in the array of service templates, after the list of service templates
    /// previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of service templates to list.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListServiceTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceTemplateInput {
    /// <p>The name of the service template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the service template as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the service template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A customer provided encryption key that's used to encrypt data.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>AWS Proton includes a service pipeline for your service by default. When included, this parameter indicates that an AWS Proton service
    /// pipeline <i>won't</i> be included for your service. Once specified, this parameter <i>can't</i> be changed.
    /// For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Service template
    /// bundles</a> in the <i>AWS Proton Administrator Guide</i>.</p>
    pub pipeline_provisioning: std::option::Option<crate::model::Provisioning>,
    /// <p>Create tags for your service template. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateServiceTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceTemplateInput");
        formatter.field("name", &self.name);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("pipeline_provisioning", &self.pipeline_provisioning);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceTemplateInput {
    /// <p>The name of the service template to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteServiceTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceTemplateInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceTemplateInput {
    /// <p>The name of the service template to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the service template to update as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the service template update.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateServiceTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceTemplateInput");
        formatter.field("name", &self.name);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceTemplateInput {
    /// <p>The name of the service template that you want to get detail data for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetServiceTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceTemplateInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesInput {
    /// <p>A token to indicate the location of the next service in the array of services, after the list of services that was previously
    /// requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of services to list.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListServicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceInput {
    /// <p>The service name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the AWS Proton service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the service template that's used to create the service.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The ID of the major version of the service template that was used to create the service.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The ID of the minor version of the service template that was used to create the service.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. Don’t
    /// include pipeline inputs in the spec if your service template <i>doesn’t</i> include a service pipeline. For more
    /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html">Create a service</a> in the
    /// <i>AWS Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html">Create a service</a> in the <i>AWS Proton User Guide</i>.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up repository connection</a> in the
    /// <i>AWS Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up with AWS Proton</a> in the <i>AWS Proton
    /// User Guide</i>. <i>Don't</i> include this parameter if your service template <i>doesn't</i> include
    /// a service pipeline.</p>
    pub repository_connection_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the code repository. <i>Don't</i> include this parameter if your service template <i>doesn't</i>
    /// include a service pipeline.</p>
    pub repository_id: std::option::Option<std::string::String>,
    /// <p>The name of the code repository branch that holds the code that's deployed in AWS Proton. <i>Don't</i> include this
    /// parameter if your service template <i>doesn't</i> include a service pipeline.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>Create tags for your service. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceInput");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("repository_connection_arn", &self.repository_connection_arn);
        formatter.field("repository_id", &self.repository_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceInput {
    /// <p>The name of the service to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceInput {
    /// <p>The name of the service to edit.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The edited service description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the
    /// list. <i>Don't</i> include edits to the existing service instances or pipeline. For more information, see <i>Edit a
    /// service</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-update.html">AWS Proton Administrator
    /// Guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-update.html">AWS Proton User Guide</a>.</p>
    pub spec: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceInput");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceInput {
    /// <p>The name of the service that you want to get the detail data for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServicePipelineInput {
    /// <p>The name of the service to that the pipeline is associated with.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The spec for the service pipeline to update.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>The deployment type.</p>
    /// <p>There are four modes for updating a service pipeline as described in the following. The <code>deploymentType</code> field defines the
    /// mode.</p>
    /// <dl>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>CURRENT_VERSION</code>
    /// </p>
    /// <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are
    /// updated. <i>Don’t</i> include minor or major version parameters when you use this
    /// <code>deployment-type</code>.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MINOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the
    /// current major version in use, by default. You can also specify a different minor version of the current major version in
    /// use.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MAJOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version
    /// of the current template, by default. You can also specify a different major version that is higher than the major version in
    /// use and a minor version (optional).</p>
    /// </dd>
    /// </dl>
    pub deployment_type: std::option::Option<crate::model::DeploymentUpdateType>,
    /// <p>The major version of the service template that was used to create the service that the pipeline is associated with.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of the service template that was used to create the service that the pipeline is associated with.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateServicePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServicePipelineInput");
        formatter.field("service_name", &self.service_name);
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceInstancesInput {
    /// <p>The name of the service that the service instance belongs to.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>A token to indicate the location of the next service in the array of service instances, after the list of service instances that was
    /// previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of service instances to list.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListServiceInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceInstancesInput");
        formatter.field("service_name", &self.service_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceInstanceInput {
    /// <p>The name of the service instance to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the service that the service instance belongs to.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The deployment type.</p>
    /// <p>There are four modes for updating a service instance as described in the following. The <code>deploymentType</code> field defines the
    /// mode.</p>
    /// <dl>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>CURRENT_VERSION</code>
    /// </p>
    /// <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are
    /// updated. <i>Don’t</i> include minor or major version parameters when you use this
    /// <code>deployment-type</code>.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MINOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the
    /// current major version in use, by default. You can also specify a different minor version of the current major version in
    /// use.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MAJOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version
    /// of the current template, by default. You can also specify a different major version that is higher than the major version in
    /// use and a minor version (optional).</p>
    /// </dd>
    /// </dl>
    pub deployment_type: std::option::Option<crate::model::DeploymentUpdateType>,
    /// <p>The formatted specification that defines the service instance update.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>The major version of the service template to update.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of the service template to update.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateServiceInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceInstanceInput");
        formatter.field("name", &self.name);
        formatter.field("service_name", &self.service_name);
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceInstanceInput {
    /// <p>The name of a service instance that you want to get the detail data for.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the service that the service instance belongs to.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetServiceInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceInstanceInput");
        formatter.field("name", &self.name);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentTemplateVersionsInput {
    /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
    /// after the list of major or minor versions that was previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of major or minor versions of an environment template to list.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The name of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>To view a list of minor of versions under a major version of an environment template, include <code>majorVersion</code>.</p>
    /// <p>To view a list of major versions of an environment template, <i>exclude</i>
    /// <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListEnvironmentTemplateVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentTemplateVersionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentTemplateVersionInput {
    /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the environment template version that
    /// the first request created.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>A description of the new version of an environment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>To create a new minor version of the environment template, include a <code>majorVersion</code>.</p>
    /// <p>To create a new major and minor version of the environment template, <i>exclude</i>
    /// <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>An object that includes the template bundle S3 bucket path and name for the new version of an template.</p>
    pub source: std::option::Option<crate::model::TemplateVersionSourceInput>,
    /// <p>Create tags for a new version of an environment template.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateEnvironmentTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentTemplateVersionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("major_version", &self.major_version);
        formatter.field("source", &self.source);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentTemplateVersionInput {
    /// <p>The name of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The environment template major version to delete.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>The environment template minor version to delete.</p>
    pub minor_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEnvironmentTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentTemplateVersionInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentTemplateVersionInput {
    /// <p>The name of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>To update a major version of an environment template, include <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>To update a minor version of an environment template, include <code>minorVersion</code>.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>A description of environment template version to update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the environment template minor version to update.</p>
    pub status: std::option::Option<crate::model::TemplateVersionStatus>,
}
impl std::fmt::Debug for UpdateEnvironmentTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentTemplateVersionInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentTemplateVersionInput {
    /// <p>The name of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>To view environment template major version detail data, include <code>majorVersion</code>.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>To view environment template minor version detail data, include <code>minorVersion</code>.</p>
    pub minor_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEnvironmentTemplateVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentTemplateVersionInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentTemplatesInput {
    /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the list of environment
    /// templates that was previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of environment templates to list.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEnvironmentTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentTemplateInput {
    /// <p>The name of the environment template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The environment template name as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the environment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A customer provided encryption key that AWS Proton uses to encrypt data.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub provisioning: std::option::Option<crate::model::Provisioning>,
    /// <p>Create tags for your environment template. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateEnvironmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentTemplateInput");
        formatter.field("name", &self.name);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("provisioning", &self.provisioning);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentTemplateInput {
    /// <p>The name of the environment template to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEnvironmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentTemplateInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentTemplateInput {
    /// <p>The name of the environment template to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the environment template to update as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the environment template update.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEnvironmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentTemplateInput");
        formatter.field("name", &self.name);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentTemplateInput {
    /// <p>The name of the environment template that you want to get the detail data for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEnvironmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentTemplateInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsInput {
    /// <p>A token to indicate the location of the next environment in the array of environments, after the list of environments that was
    /// previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of environments to list.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An array of the versions of the environment template.</p>
    pub environment_templates:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateFilter>>,
}
impl std::fmt::Debug for ListEnvironmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("environment_templates", &self.environment_templates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentInput {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the environment template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>AWS Proton Administrator
    /// Guide</i>.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The ID of the major version of the environment template.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The ID of the minor version of the environment template.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>A description of the environment that's being created and deployed.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A link to a YAML formatted spec file that provides inputs as defined in the environment template bundle schema file. For more
    /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the
    /// <i>AWS Proton Administrator Guide</i>.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make calls to other services on your behalf. You
    /// must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value.</p>
    pub proton_service_role_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an
    /// environment account. You must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code>
    /// parameter and value. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>AWS Proton Administrator guide</i>.</p>
    pub environment_account_connection_id: std::option::Option<std::string::String>,
    /// <p>Create tags for your environment. For more information, see <i>AWS Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">AWS Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton User Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentInput");
        formatter.field("name", &self.name);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("proton_service_role_arn", &self.proton_service_role_arn);
        formatter.field(
            "environment_account_connection_id",
            &self.environment_account_connection_id,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentInput {
    /// <p>The name of the environment to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentInput {
    /// <p>The name of the environment to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the environment update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The formatted specification that defines the update.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>The ID of the major version of the environment to update.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The ID of the minor version of the environment to update.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make API calls to other services your
    /// behalf.</p>
    pub proton_service_role_arn: std::option::Option<std::string::String>,
    /// <p>There are four modes for updating an environment as described in the following. The <code>deploymentType</code> field defines the
    /// mode.</p>
    /// <dl>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>CURRENT_VERSION</code>
    /// </p>
    /// <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are
    /// updated. <i>Don’t</i> include minor or major version parameters when you use this
    /// <code>deployment-type</code>.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MINOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current
    /// major version in use, by default. You can also specify a different minor version of the current major version in use.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MAJOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of
    /// the current template, by default. You can also specify a different major version that is higher than the major version in use
    /// and a minor version (optional).</p>
    /// </dd>
    /// </dl>
    pub deployment_type: std::option::Option<crate::model::DeploymentUpdateType>,
    /// <p>The ID of the environment account connection.</p>
    /// <p>You can only update to a new environment account connection if it was created in the same environment account that the current
    /// environment account connection was created in and is associated with the current environment.</p>
    pub environment_account_connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentInput");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("proton_service_role_arn", &self.proton_service_role_arn);
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field(
            "environment_account_connection_id",
            &self.environment_account_connection_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentInput {
    /// <p>The name of the environment that you want to get the detail data for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectEnvironmentAccountConnectionInput {
    /// <p>The ID of the environment account connection to reject.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RejectEnvironmentAccountConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectEnvironmentAccountConnectionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptEnvironmentAccountConnectionInput {
    /// <p>The ID of the environment account connection.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AcceptEnvironmentAccountConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptEnvironmentAccountConnectionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentAccountConnectionsInput {
    /// <p>The type of account making the <code>ListEnvironmentAccountConnections</code> request.</p>
    pub requested_by:
        std::option::Option<crate::model::EnvironmentAccountConnectionRequesterAccountType>,
    /// <p>The environment name that's associated with each listed environment account connection.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The status details for each listed environment account connection.</p>
    pub statuses:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentAccountConnectionStatus>>,
    /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
    /// list of environment account connections that was previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of environment account connections to list.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEnvironmentAccountConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentAccountConnectionsInput");
        formatter.field("requested_by", &self.requested_by);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("statuses", &self.statuses);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentAccountConnectionInput {
    /// <p>When included, if two identicial requests are made with the same client token, AWS Proton returns the environment account connection that
    /// the first request created.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton
    /// environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM
    /// role to provision environment infrastructure resources in the associated environment account.</p>
    pub management_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision
    /// infrastructure resources in the associated environment account.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the AWS Proton environment that's created in the associated management account.</p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateEnvironmentAccountConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentAccountConnectionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("management_account_id", &self.management_account_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentAccountConnectionInput {
    /// <p>The ID of the environment account connection to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEnvironmentAccountConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentAccountConnectionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentAccountConnectionInput {
    /// <p>The ID of the environment account connection to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM service role that is associated with the environment account connection to update.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEnvironmentAccountConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentAccountConnectionInput");
        formatter.field("id", &self.id);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentAccountConnectionInput {
    /// <p>The ID of the environment account connection.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEnvironmentAccountConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentAccountConnectionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountSettingsInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS Proton pipeline service role.</p>
    pub pipeline_service_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAccountSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountSettingsInput");
        formatter.field("pipeline_service_role_arn", &self.pipeline_service_role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSettingsInput {}
impl std::fmt::Debug for GetAccountSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSettingsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the tag is to be removed from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of tag keys indicating the resource tags to be removed from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the resource tag is applied to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of resource tags to apply to a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for the listed tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the list of resource tags that was
    /// previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of tags to list.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelServicePipelineDeploymentInput {
    /// <p>The name of the service with the service pipeline deployment to cancel.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelServicePipelineDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelServicePipelineDeploymentInput");
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelServiceInstanceDeploymentInput {
    /// <p>The name of the service instance with the deployment to cancel.</p>
    pub service_instance_name: std::option::Option<std::string::String>,
    /// <p>The name of the service with the service instance deployment to cancel.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelServiceInstanceDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelServiceInstanceDeploymentInput");
        formatter.field("service_instance_name", &self.service_instance_name);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelEnvironmentDeploymentInput {
    /// <p>The name of the environment with the deployment to cancel.</p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelEnvironmentDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelEnvironmentDeploymentInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}
