// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Price List Service
///
/// Client for invoking operations on AWS Price List Service. Each operation on AWS Price List Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_pricing::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_pricing::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_pricing::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `DescribeServices` operation.
    ///
    /// See [`DescribeServices`](crate::client::fluent_builders::DescribeServices) for more information about the
    /// operation and its arguments.
    pub fn describe_services(&self) -> fluent_builders::DescribeServices<C, M, R> {
        fluent_builders::DescribeServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAttributeValues` operation.
    ///
    /// See [`GetAttributeValues`](crate::client::fluent_builders::GetAttributeValues) for more information about the
    /// operation and its arguments.
    pub fn get_attribute_values(&self) -> fluent_builders::GetAttributeValues<C, M, R> {
        fluent_builders::GetAttributeValues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProducts` operation.
    ///
    /// See [`GetProducts`](crate::client::fluent_builders::GetProducts) for more information about the
    /// operation and its arguments.
    pub fn get_products(&self) -> fluent_builders::GetProducts<C, M, R> {
        fluent_builders::GetProducts::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DescribeServices`.
    ///
    /// <p>Returns the metadata for one service or a list of the metadata for all services. Use
    /// this without a service code to get the service codes for all services.
    /// Use it with a service code, such as <code>AmazonEC2</code>, to get information specific to
    /// that service, such as the attribute
    /// names available for that service. For example, some of the attribute names available for EC2 are
    /// <code>volumeType</code>, <code>maxIopsVolume</code>, <code>operation</code>,
    /// <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeServices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_services_input::Builder,
    }
    impl<C, M, R> DescribeServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServicesInputOperationOutputAlias,
                crate::output::DescribeServicesOutput,
                crate::error::DescribeServicesError,
                crate::input::DescribeServicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The code for the service whose information you want to retrieve, such as <code>AmazonEC2</code>.
        /// You can use
        /// the <code>ServiceCode</code> to filter the results in a <code>GetProducts</code> call.
        /// To retrieve a list of all services, leave this blank.</p>
        pub fn service_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(inp);
            self
        }
        /// <p>The code for the service whose information you want to retrieve, such as <code>AmazonEC2</code>.
        /// You can use
        /// the <code>ServiceCode</code> to filter the results in a <code>GetProducts</code> call.
        /// To retrieve a list of all services, leave this blank.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The format version that you want the response to be in.</p>
        /// <p>Valid values are: <code>aws_v1</code>
        /// </p>
        pub fn format_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.format_version(inp);
            self
        }
        /// <p>The format version that you want the response to be in.</p>
        /// <p>Valid values are: <code>aws_v1</code>
        /// </p>
        pub fn set_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_format_version(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want returned in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that you want returned in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttributeValues`.
    ///
    /// <p>Returns a list of attribute values. Attibutes are similar to the details
    /// in a Price List API offer file. For a list of available attributes, see
    /// <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs">Offer File Definitions</a>
    /// in the <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html">Amazon Web Services Billing and Cost Management User Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAttributeValues<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_attribute_values_input::Builder,
    }
    impl<C, M, R> GetAttributeValues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAttributeValues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttributeValuesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttributeValuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAttributeValuesInputOperationOutputAlias,
                crate::output::GetAttributeValuesOutput,
                crate::error::GetAttributeValuesError,
                crate::input::GetAttributeValuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service code for the service whose attributes you want to retrieve. For example, if you want
        /// the retrieve an EC2 attribute, use <code>AmazonEC2</code>.</p>
        pub fn service_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(inp);
            self
        }
        /// <p>The service code for the service whose attributes you want to retrieve. For example, if you want
        /// the retrieve an EC2 attribute, use <code>AmazonEC2</code>.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The name of the attribute that you want to retrieve the values for, such as <code>volumeType</code>.</p>
        pub fn attribute_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(inp);
            self
        }
        /// <p>The name of the attribute that you want to retrieve the values for, such as <code>volumeType</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProducts`.
    ///
    /// <p>Returns a list of all products that match the filter criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProducts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_products_input::Builder,
    }
    impl<C, M, R> GetProducts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProductsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProductsInputOperationOutputAlias,
                crate::output::GetProductsOutput,
                crate::error::GetProductsError,
                crate::input::GetProductsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The code for the service whose products you want to retrieve. </p>
        pub fn service_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(inp);
            self
        }
        /// <p>The code for the service whose products you want to retrieve. </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The list of filters that limit the returned products. only products that match all filters
        /// are returned.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The list of filters that limit the returned products. only products that match all filters
        /// are returned.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The format version that you want the response to be in.</p>
        /// <p>Valid values are: <code>aws_v1</code>
        /// </p>
        pub fn format_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.format_version(inp);
            self
        }
        /// <p>The format version that you want the response to be in.</p>
        /// <p>Valid values are: <code>aws_v1</code>
        /// </p>
        pub fn set_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_format_version(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
