// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProductsOutput {
    /// <p>The format version of the response. For example, aws_v1.</p>
    pub format_version: std::option::Option<std::string::String>,
    /// <p>The list of products that match your filters. The list contains both the product metadata and the price information.</p>
    pub price_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetProductsOutput {
    /// <p>The format version of the response. For example, aws_v1.</p>
    pub fn format_version(&self) -> std::option::Option<&str> {
        self.format_version.as_deref()
    }
    /// <p>The list of products that match your filters. The list contains both the product metadata and the price information.</p>
    pub fn price_list(&self) -> std::option::Option<&[std::string::String]> {
        self.price_list.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetProductsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProductsOutput");
        formatter.field("format_version", &self.format_version);
        formatter.field("price_list", &self.price_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetProductsOutput`](crate::output::GetProductsOutput)
pub mod get_products_output {
    /// A builder for [`GetProductsOutput`](crate::output::GetProductsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format_version: std::option::Option<std::string::String>,
        pub(crate) price_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The format version of the response. For example, aws_v1.</p>
        pub fn format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.format_version = Some(input.into());
            self
        }
        /// <p>The format version of the response. For example, aws_v1.</p>
        pub fn set_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.format_version = input;
            self
        }
        /// Appends an item to `price_list`.
        ///
        /// To override the contents of this collection use [`set_price_list`](Self::set_price_list).
        ///
        /// <p>The list of products that match your filters. The list contains both the product metadata and the price information.</p>
        pub fn price_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.price_list.unwrap_or_default();
            v.push(input.into());
            self.price_list = Some(v);
            self
        }
        /// <p>The list of products that match your filters. The list contains both the product metadata and the price information.</p>
        pub fn set_price_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.price_list = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProductsOutput`](crate::output::GetProductsOutput)
        pub fn build(self) -> crate::output::GetProductsOutput {
            crate::output::GetProductsOutput {
                format_version: self.format_version,
                price_list: self.price_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetProductsOutput {
    /// Creates a new builder-style object to manufacture [`GetProductsOutput`](crate::output::GetProductsOutput)
    pub fn builder() -> crate::output::get_products_output::Builder {
        crate::output::get_products_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAttributeValuesOutput {
    /// <p>The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>.</p>
    pub attribute_values: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAttributeValuesOutput {
    /// <p>The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>.</p>
    pub fn attribute_values(&self) -> std::option::Option<&[crate::model::AttributeValue]> {
        self.attribute_values.as_deref()
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAttributeValuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAttributeValuesOutput");
        formatter.field("attribute_values", &self.attribute_values);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetAttributeValuesOutput`](crate::output::GetAttributeValuesOutput)
pub mod get_attribute_values_output {
    /// A builder for [`GetAttributeValuesOutput`](crate::output::GetAttributeValuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_values:
            std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attribute_values`.
        ///
        /// To override the contents of this collection use [`set_attribute_values`](Self::set_attribute_values).
        ///
        /// <p>The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>.</p>
        pub fn attribute_values(mut self, input: crate::model::AttributeValue) -> Self {
            let mut v = self.attribute_values.unwrap_or_default();
            v.push(input);
            self.attribute_values = Some(v);
            self
        }
        /// <p>The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>.</p>
        pub fn set_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.attribute_values = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAttributeValuesOutput`](crate::output::GetAttributeValuesOutput)
        pub fn build(self) -> crate::output::GetAttributeValuesOutput {
            crate::output::GetAttributeValuesOutput {
                attribute_values: self.attribute_values,
                next_token: self.next_token,
            }
        }
    }
}
impl GetAttributeValuesOutput {
    /// Creates a new builder-style object to manufacture [`GetAttributeValuesOutput`](crate::output::GetAttributeValuesOutput)
    pub fn builder() -> crate::output::get_attribute_values_output::Builder {
        crate::output::get_attribute_values_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServicesOutput {
    /// <p>The service metadata for the service or services in the response.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    /// <p>The format version of the response. For example, <code>aws_v1</code>.</p>
    pub format_version: std::option::Option<std::string::String>,
    /// <p>The pagination token for the next set of retrievable results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeServicesOutput {
    /// <p>The service metadata for the service or services in the response.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::Service]> {
        self.services.as_deref()
    }
    /// <p>The format version of the response. For example, <code>aws_v1</code>.</p>
    pub fn format_version(&self) -> std::option::Option<&str> {
        self.format_version.as_deref()
    }
    /// <p>The pagination token for the next set of retrievable results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServicesOutput");
        formatter.field("services", &self.services);
        formatter.field("format_version", &self.format_version);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
pub mod describe_services_output {
    /// A builder for [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
        pub(crate) format_version: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The service metadata for the service or services in the response.</p>
        pub fn services(mut self, input: crate::model::Service) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input);
            self.services = Some(v);
            self
        }
        /// <p>The service metadata for the service or services in the response.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>The format version of the response. For example, <code>aws_v1</code>.</p>
        pub fn format_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.format_version = Some(input.into());
            self
        }
        /// <p>The format version of the response. For example, <code>aws_v1</code>.</p>
        pub fn set_format_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.format_version = input;
            self
        }
        /// <p>The pagination token for the next set of retrievable results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the next set of retrievable results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
        pub fn build(self) -> crate::output::DescribeServicesOutput {
            crate::output::DescribeServicesOutput {
                services: self.services,
                format_version: self.format_version,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeServicesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
    pub fn builder() -> crate::output::describe_services_output::Builder {
        crate::output::describe_services_output::Builder::default()
    }
}
