// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Polly
///
/// Client for invoking operations on Amazon Polly. Each operation on Amazon Polly is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_polly::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_polly::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_polly::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`DeleteLexicon`](crate::client::fluent_builders::DeleteLexicon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteLexicon::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteLexicon::set_name): <p>The name of the lexicon to delete. Must be an existing lexicon in the region.</p>
    /// - On success, responds with [`DeleteLexiconOutput`](crate::output::DeleteLexiconOutput)

    /// - On failure, responds with [`SdkError<DeleteLexiconError>`](crate::error::DeleteLexiconError)
    pub fn delete_lexicon(&self) -> fluent_builders::DeleteLexicon {
        fluent_builders::DeleteLexicon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVoices`](crate::client::fluent_builders::DescribeVoices) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(Engine)`](crate::client::fluent_builders::DescribeVoices::engine) / [`set_engine(Option<Engine>)`](crate::client::fluent_builders::DescribeVoices::set_engine): <p>Specifies the engine (<code>standard</code> or <code>neural</code>) used by Amazon Polly when processing input text for speech synthesis. </p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::DescribeVoices::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::DescribeVoices::set_language_code): <p> The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned. </p>
    ///   - [`include_additional_language_codes(bool)`](crate::client::fluent_builders::DescribeVoices::include_additional_language_codes) / [`set_include_additional_language_codes(bool)`](crate::client::fluent_builders::DescribeVoices::set_include_additional_language_codes): <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeVoices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeVoices::set_next_token): <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
    /// - On success, responds with [`DescribeVoicesOutput`](crate::output::DescribeVoicesOutput) with field(s):
    ///   - [`voices(Option<Vec<Voice>>)`](crate::output::DescribeVoicesOutput::voices): <p>A list of voices with their properties.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeVoicesOutput::next_token): <p>The pagination token to use in the next request to continue the listing of voices. <code>NextToken</code> is returned only if the response is truncated.</p>
    /// - On failure, responds with [`SdkError<DescribeVoicesError>`](crate::error::DescribeVoicesError)
    pub fn describe_voices(&self) -> fluent_builders::DescribeVoices {
        fluent_builders::DescribeVoices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLexicon`](crate::client::fluent_builders::GetLexicon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetLexicon::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetLexicon::set_name): <p>Name of the lexicon.</p>
    /// - On success, responds with [`GetLexiconOutput`](crate::output::GetLexiconOutput) with field(s):
    ///   - [`lexicon(Option<Lexicon>)`](crate::output::GetLexiconOutput::lexicon): <p>Lexicon object that provides name and the string content of the lexicon. </p>
    ///   - [`lexicon_attributes(Option<LexiconAttributes>)`](crate::output::GetLexiconOutput::lexicon_attributes): <p>Metadata of the lexicon, including phonetic alphabetic used, language code, lexicon ARN, number of lexemes defined in the lexicon, and size of lexicon in bytes.</p>
    /// - On failure, responds with [`SdkError<GetLexiconError>`](crate::error::GetLexiconError)
    pub fn get_lexicon(&self) -> fluent_builders::GetLexicon {
        fluent_builders::GetLexicon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSpeechSynthesisTask`](crate::client::fluent_builders::GetSpeechSynthesisTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::GetSpeechSynthesisTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::GetSpeechSynthesisTask::set_task_id): <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
    /// - On success, responds with [`GetSpeechSynthesisTaskOutput`](crate::output::GetSpeechSynthesisTaskOutput) with field(s):
    ///   - [`synthesis_task(Option<SynthesisTask>)`](crate::output::GetSpeechSynthesisTaskOutput::synthesis_task): <p>SynthesisTask object that provides information from the requested task, including output format, creation time, task status, and so on.</p>
    /// - On failure, responds with [`SdkError<GetSpeechSynthesisTaskError>`](crate::error::GetSpeechSynthesisTaskError)
    pub fn get_speech_synthesis_task(&self) -> fluent_builders::GetSpeechSynthesisTask {
        fluent_builders::GetSpeechSynthesisTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLexicons`](crate::client::fluent_builders::ListLexicons) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLexicons::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLexicons::set_next_token): <p>An opaque pagination token returned from previous <code>ListLexicons</code> operation. If present, indicates where to continue the list of lexicons.</p>
    /// - On success, responds with [`ListLexiconsOutput`](crate::output::ListLexiconsOutput) with field(s):
    ///   - [`lexicons(Option<Vec<LexiconDescription>>)`](crate::output::ListLexiconsOutput::lexicons): <p>A list of lexicon names and attributes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLexiconsOutput::next_token): <p>The pagination token to use in the next request to continue the listing of lexicons. <code>NextToken</code> is returned only if the response is truncated.</p>
    /// - On failure, responds with [`SdkError<ListLexiconsError>`](crate::error::ListLexiconsError)
    pub fn list_lexicons(&self) -> fluent_builders::ListLexicons {
        fluent_builders::ListLexicons::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSpeechSynthesisTasks`](crate::client::fluent_builders::ListSpeechSynthesisTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSpeechSynthesisTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSpeechSynthesisTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSpeechSynthesisTasks::set_max_results): <p>Maximum number of speech synthesis tasks returned in a List operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSpeechSynthesisTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSpeechSynthesisTasks::set_next_token): <p>The pagination token to use in the next request to continue the listing of speech synthesis tasks. </p>
    ///   - [`status(TaskStatus)`](crate::client::fluent_builders::ListSpeechSynthesisTasks::status) / [`set_status(Option<TaskStatus>)`](crate::client::fluent_builders::ListSpeechSynthesisTasks::set_status): <p>Status of the speech synthesis tasks returned in a List operation</p>
    /// - On success, responds with [`ListSpeechSynthesisTasksOutput`](crate::output::ListSpeechSynthesisTasksOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListSpeechSynthesisTasksOutput::next_token): <p>An opaque pagination token returned from the previous List operation in this request. If present, this indicates where to continue the listing.</p>
    ///   - [`synthesis_tasks(Option<Vec<SynthesisTask>>)`](crate::output::ListSpeechSynthesisTasksOutput::synthesis_tasks): <p>List of SynthesisTask objects that provides information from the specified task in the list request, including output format, creation time, task status, and so on.</p>
    /// - On failure, responds with [`SdkError<ListSpeechSynthesisTasksError>`](crate::error::ListSpeechSynthesisTasksError)
    pub fn list_speech_synthesis_tasks(&self) -> fluent_builders::ListSpeechSynthesisTasks {
        fluent_builders::ListSpeechSynthesisTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLexicon`](crate::client::fluent_builders::PutLexicon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutLexicon::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutLexicon::set_name): <p>Name of the lexicon. The name must follow the regular express format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long. </p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::PutLexicon::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::PutLexicon::set_content): <p>Content of the PLS lexicon as string data.</p>
    /// - On success, responds with [`PutLexiconOutput`](crate::output::PutLexiconOutput)

    /// - On failure, responds with [`SdkError<PutLexiconError>`](crate::error::PutLexiconError)
    pub fn put_lexicon(&self) -> fluent_builders::PutLexicon {
        fluent_builders::PutLexicon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSpeechSynthesisTask`](crate::client::fluent_builders::StartSpeechSynthesisTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(Engine)`](crate::client::fluent_builders::StartSpeechSynthesisTask::engine) / [`set_engine(Option<Engine>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_engine): <p>Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartSpeechSynthesisTask::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_language_code): <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>  <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    ///   - [`lexicon_names(Vec<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::lexicon_names) / [`set_lexicon_names(Option<Vec<String>>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_lexicon_names): <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. </p>
    ///   - [`output_format(OutputFormat)`](crate::client::fluent_builders::StartSpeechSynthesisTask::output_format) / [`set_output_format(Option<OutputFormat>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_output_format): <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json. </p>
    ///   - [`output_s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::output_s3_bucket_name) / [`set_output_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_output_s3_bucket_name): <p>Amazon S3 bucket name to which the output file will be saved.</p>
    ///   - [`output_s3_key_prefix(impl Into<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::output_s3_key_prefix) / [`set_output_s3_key_prefix(Option<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_output_s3_key_prefix): <p>The Amazon S3 key prefix for the output speech file.</p>
    ///   - [`sample_rate(impl Into<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::sample_rate) / [`set_sample_rate(Option<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_sample_rate): <p>The audio frequency specified in Hz.</p>  <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000".</p>  <p>Valid values for pcm are "8000" and "16000" The default value is "16000". </p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_sns_topic_arn): <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    ///   - [`speech_mark_types(Vec<SpeechMarkType>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::speech_mark_types) / [`set_speech_mark_types(Option<Vec<SpeechMarkType>>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_speech_mark_types): <p>The type of speech marks returned for the input text.</p>
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_text): <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text. </p>
    ///   - [`text_type(TextType)`](crate::client::fluent_builders::StartSpeechSynthesisTask::text_type) / [`set_text_type(Option<TextType>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_text_type): <p>Specifies whether the input text is plain text or SSML. The default value is plain text. </p>
    ///   - [`voice_id(VoiceId)`](crate::client::fluent_builders::StartSpeechSynthesisTask::voice_id) / [`set_voice_id(Option<VoiceId>)`](crate::client::fluent_builders::StartSpeechSynthesisTask::set_voice_id): <p>Voice ID to use for the synthesis. </p>
    /// - On success, responds with [`StartSpeechSynthesisTaskOutput`](crate::output::StartSpeechSynthesisTaskOutput) with field(s):
    ///   - [`synthesis_task(Option<SynthesisTask>)`](crate::output::StartSpeechSynthesisTaskOutput::synthesis_task): <p>SynthesisTask object that provides information and attributes about a newly submitted speech synthesis task.</p>
    /// - On failure, responds with [`SdkError<StartSpeechSynthesisTaskError>`](crate::error::StartSpeechSynthesisTaskError)
    pub fn start_speech_synthesis_task(&self) -> fluent_builders::StartSpeechSynthesisTask {
        fluent_builders::StartSpeechSynthesisTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SynthesizeSpeech`](crate::client::fluent_builders::SynthesizeSpeech) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(Engine)`](crate::client::fluent_builders::SynthesizeSpeech::engine) / [`set_engine(Option<Engine>)`](crate::client::fluent_builders::SynthesizeSpeech::set_engine): <p>Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input text for speech synthesis. For information on Amazon Polly voices and which voices are available in standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>  <p> <b>NTTS-only voices</b> </p>  <p>When using NTTS-only voices such as Kevin (en-US), this parameter is required and must be set to <code>neural</code>. If the engine is not specified, or is set to <code>standard</code>, this will result in an error. </p>  <p>Type: String</p>  <p>Valid Values: <code>standard</code> | <code>neural</code> </p>  <p>Required: Yes</p>  <p> <b>Standard voices</b> </p>  <p>For standard voices, this is not required; the engine parameter defaults to <code>standard</code>. If the engine is not specified, or is set to <code>standard</code> and an NTTS-only voice is selected, this will result in an error. </p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::SynthesizeSpeech::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::SynthesizeSpeech::set_language_code): <p>Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>  <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    ///   - [`lexicon_names(Vec<String>)`](crate::client::fluent_builders::SynthesizeSpeech::lexicon_names) / [`set_lexicon_names(Option<Vec<String>>)`](crate::client::fluent_builders::SynthesizeSpeech::set_lexicon_names): <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
    ///   - [`output_format(OutputFormat)`](crate::client::fluent_builders::SynthesizeSpeech::output_format) / [`set_output_format(Option<OutputFormat>)`](crate::client::fluent_builders::SynthesizeSpeech::set_output_format): <p> The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json. </p>  <p>When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format. </p>
    ///   - [`sample_rate(impl Into<String>)`](crate::client::fluent_builders::SynthesizeSpeech::sample_rate) / [`set_sample_rate(Option<String>)`](crate::client::fluent_builders::SynthesizeSpeech::set_sample_rate): <p>The audio frequency specified in Hz.</p>  <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000".</p>  <p>Valid values for pcm are "8000" and "16000" The default value is "16000". </p>
    ///   - [`speech_mark_types(Vec<SpeechMarkType>)`](crate::client::fluent_builders::SynthesizeSpeech::speech_mark_types) / [`set_speech_mark_types(Option<Vec<SpeechMarkType>>)`](crate::client::fluent_builders::SynthesizeSpeech::set_speech_mark_types): <p>The type of speech marks returned for the input text.</p>
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::SynthesizeSpeech::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::SynthesizeSpeech::set_text): <p> Input text to synthesize. If you specify <code>ssml</code> as the <code>TextType</code>, follow the SSML format for the input text. </p>
    ///   - [`text_type(TextType)`](crate::client::fluent_builders::SynthesizeSpeech::text_type) / [`set_text_type(Option<TextType>)`](crate::client::fluent_builders::SynthesizeSpeech::set_text_type): <p> Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using SSML</a>.</p>
    ///   - [`voice_id(VoiceId)`](crate::client::fluent_builders::SynthesizeSpeech::voice_id) / [`set_voice_id(Option<VoiceId>)`](crate::client::fluent_builders::SynthesizeSpeech::set_voice_id): <p> Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
    /// - On success, responds with [`SynthesizeSpeechOutput`](crate::output::SynthesizeSpeechOutput) with field(s):
    ///   - [`audio_stream(byte_stream::ByteStream)`](crate::output::SynthesizeSpeechOutput::audio_stream): <p> Stream containing the synthesized speech. </p>
    ///   - [`content_type(Option<String>)`](crate::output::SynthesizeSpeechOutput::content_type): <p> Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request. </p>  <ul>   <li> <p> If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg. </p> </li>   <li> <p> If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg. </p> </li>   <li> <p> If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format. </p> </li>   <li> <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/json.</p> </li>  </ul>  <p> </p>
    ///   - [`request_characters(i32)`](crate::output::SynthesizeSpeechOutput::request_characters): <p>Number of characters synthesized.</p>
    /// - On failure, responds with [`SdkError<SynthesizeSpeechError>`](crate::error::SynthesizeSpeechError)
    pub fn synthesize_speech(&self) -> fluent_builders::SynthesizeSpeech {
        fluent_builders::SynthesizeSpeech::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DeleteLexicon`.
    ///
    /// <p>Deletes the specified pronunciation lexicon stored in an Amazon Web Services Region. A lexicon which has been deleted is not available for speech synthesis, nor is it possible to retrieve it using either the <code>GetLexicon</code> or <code>ListLexicon</code> APIs.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLexicon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_lexicon_input::Builder,
    }
    impl DeleteLexicon {
        /// Creates a new `DeleteLexicon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLexiconOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLexiconError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the lexicon to delete. Must be an existing lexicon in the region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the lexicon to delete. Must be an existing lexicon in the region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVoices`.
    ///
    /// <p>Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice name. </p>
    /// <p>When synthesizing speech ( <code>SynthesizeSpeech</code> ), you provide the voice ID for the voice you want from the list of voices returned by <code>DescribeVoices</code>.</p>
    /// <p>For example, you want your news reader application to read news in a specific language, but giving a user the option to choose the voice. Using the <code>DescribeVoices</code> operation you can provide the user with a list of available voices to select from.</p>
    /// <p> You can optionally specify a language code to filter the available voices. For example, if you specify <code>en-US</code>, the operation returns a list of all available US English voices. </p>
    /// <p>This operation requires permissions to perform the <code>polly:DescribeVoices</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVoices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_voices_input::Builder,
    }
    impl DescribeVoices {
        /// Creates a new `DescribeVoices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVoicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVoicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>) used by Amazon Polly when processing input text for speech synthesis. </p>
        pub fn engine(mut self, input: crate::model::Engine) -> Self {
            self.inner = self.inner.engine(input);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>) used by Amazon Polly when processing input text for speech synthesis. </p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p> The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned. </p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p> The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned. </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
        pub fn include_additional_language_codes(mut self, input: bool) -> Self {
            self.inner = self.inner.include_additional_language_codes(input);
            self
        }
        /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
        pub fn set_include_additional_language_codes(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_additional_language_codes(input);
            self
        }
        /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLexicon`.
    ///
    /// <p>Returns the content of the specified pronunciation lexicon stored in an Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLexicon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_lexicon_input::Builder,
    }
    impl GetLexicon {
        /// Creates a new `GetLexicon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLexiconOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLexiconError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the lexicon.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of the lexicon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSpeechSynthesisTask`.
    ///
    /// <p>Retrieves a specific SpeechSynthesisTask object based on its TaskID. This object contains information about the given speech synthesis task, including the status of the task, and a link to the S3 bucket containing the output of the task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSpeechSynthesisTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_speech_synthesis_task_input::Builder,
    }
    impl GetSpeechSynthesisTask {
        /// Creates a new `GetSpeechSynthesisTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSpeechSynthesisTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSpeechSynthesisTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLexicons`.
    ///
    /// <p>Returns a list of pronunciation lexicons stored in an Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLexicons {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_lexicons_input::Builder,
    }
    impl ListLexicons {
        /// Creates a new `ListLexicons`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLexiconsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLexiconsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An opaque pagination token returned from previous <code>ListLexicons</code> operation. If present, indicates where to continue the list of lexicons.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque pagination token returned from previous <code>ListLexicons</code> operation. If present, indicates where to continue the list of lexicons.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSpeechSynthesisTasks`.
    ///
    /// <p>Returns a list of SpeechSynthesisTask objects ordered by their creation date. This operation can filter the tasks by their status, for example, allowing users to list only tasks that are completed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSpeechSynthesisTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_speech_synthesis_tasks_input::Builder,
    }
    impl ListSpeechSynthesisTasks {
        /// Creates a new `ListSpeechSynthesisTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSpeechSynthesisTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSpeechSynthesisTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSpeechSynthesisTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSpeechSynthesisTasksPaginator {
            crate::paginator::ListSpeechSynthesisTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of speech synthesis tasks returned in a List operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of speech synthesis tasks returned in a List operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use in the next request to continue the listing of speech synthesis tasks. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use in the next request to continue the listing of speech synthesis tasks. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Status of the speech synthesis tasks returned in a List operation</p>
        pub fn status(mut self, input: crate::model::TaskStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Status of the speech synthesis tasks returned in a List operation</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TaskStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLexicon`.
    ///
    /// <p>Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon with the same name already exists in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it might take some time before the lexicon is available to the SynthesizeSpeech operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLexicon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_lexicon_input::Builder,
    }
    impl PutLexicon {
        /// Creates a new `PutLexicon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLexiconOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLexiconError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the lexicon. The name must follow the regular express format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of the lexicon. The name must follow the regular express format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Content of the PLS lexicon as string data.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>Content of the PLS lexicon as string data.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSpeechSynthesisTask`.
    ///
    /// <p>Allows the creation of an asynchronous synthesis task, by starting a new <code>SpeechSynthesisTask</code>. This operation requires all the standard information needed for speech synthesis, plus the name of an Amazon S3 bucket for the service to store the output of the synthesis task and two optional parameters (<code>OutputS3KeyPrefix</code> and <code>SnsTopicArn</code>). Once the synthesis task is created, this operation will return a <code>SpeechSynthesisTask</code> object, which will include an identifier of this task as well as the current status. The <code>SpeechSynthesisTask</code> object is available for 72 hours after starting the asynchronous synthesis task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSpeechSynthesisTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_speech_synthesis_task_input::Builder,
    }
    impl StartSpeechSynthesisTask {
        /// Creates a new `StartSpeechSynthesisTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSpeechSynthesisTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSpeechSynthesisTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
        pub fn engine(mut self, input: crate::model::Engine) -> Self {
            self.inner = self.inner.engine(input);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// Appends an item to `LexiconNames`.
        ///
        /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
        ///
        /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. </p>
        pub fn lexicon_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lexicon_names(input.into());
            self
        }
        /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. </p>
        pub fn set_lexicon_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lexicon_names(input);
            self
        }
        /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json. </p>
        pub fn output_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(input);
            self
        }
        /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
        /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_bucket_name(input.into());
            self
        }
        /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_bucket_name(input);
            self
        }
        /// <p>The Amazon S3 key prefix for the output speech file.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_key_prefix(input.into());
            self
        }
        /// <p>The Amazon S3 key prefix for the output speech file.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_key_prefix(input);
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000". </p>
        pub fn sample_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_rate(input.into());
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000". </p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sample_rate(input);
            self
        }
        /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// Appends an item to `SpeechMarkTypes`.
        ///
        /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
        ///
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn speech_mark_types(mut self, input: crate::model::SpeechMarkType) -> Self {
            self.inner = self.inner.speech_mark_types(input);
            self
        }
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn set_speech_mark_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        ) -> Self {
            self.inner = self.inner.set_speech_mark_types(input);
            self
        }
        /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text. </p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text. </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text. </p>
        pub fn text_type(mut self, input: crate::model::TextType) -> Self {
            self.inner = self.inner.text_type(input);
            self
        }
        /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text. </p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.inner = self.inner.set_text_type(input);
            self
        }
        /// <p>Voice ID to use for the synthesis. </p>
        pub fn voice_id(mut self, input: crate::model::VoiceId) -> Self {
            self.inner = self.inner.voice_id(input);
            self
        }
        /// <p>Voice ID to use for the synthesis. </p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.inner = self.inner.set_voice_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SynthesizeSpeech`.
    ///
    /// <p>Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML. Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by English voices) unless phoneme mapping is used. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SynthesizeSpeech {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::synthesize_speech_input::Builder,
    }
    impl SynthesizeSpeech {
        /// Creates a new `SynthesizeSpeech`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SynthesizeSpeechOutput,
            aws_smithy_http::result::SdkError<crate::error::SynthesizeSpeechError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        ///
        /// Creates a presigned request for this operation.
        ///
        /// The `presigning_config` provides additional presigning-specific config values, such as the
        /// amount of time the request should be valid for after creation.
        ///
        /// Presigned requests can be given to other users or applications to access a resource or perform
        /// an operation without having access to the AWS security credentials.
        ///
        pub async fn presigned(
            self,
            presigning_config: crate::presigning::config::PresigningConfig,
        ) -> Result<
            crate::presigning::request::PresignedRequest,
            aws_smithy_http::result::SdkError<crate::error::SynthesizeSpeechError>,
        > {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            input.presigned(&self.handle.conf, presigning_config).await
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input text for speech synthesis. For information on Amazon Polly voices and which voices are available in standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
        /// <p> <b>NTTS-only voices</b> </p>
        /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is required and must be set to <code>neural</code>. If the engine is not specified, or is set to <code>standard</code>, this will result in an error. </p>
        /// <p>Type: String</p>
        /// <p>Valid Values: <code>standard</code> | <code>neural</code> </p>
        /// <p>Required: Yes</p>
        /// <p> <b>Standard voices</b> </p>
        /// <p>For standard voices, this is not required; the engine parameter defaults to <code>standard</code>. If the engine is not specified, or is set to <code>standard</code> and an NTTS-only voice is selected, this will result in an error. </p>
        pub fn engine(mut self, input: crate::model::Engine) -> Self {
            self.inner = self.inner.engine(input);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input text for speech synthesis. For information on Amazon Polly voices and which voices are available in standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
        /// <p> <b>NTTS-only voices</b> </p>
        /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is required and must be set to <code>neural</code>. If the engine is not specified, or is set to <code>standard</code>, this will result in an error. </p>
        /// <p>Type: String</p>
        /// <p>Valid Values: <code>standard</code> | <code>neural</code> </p>
        /// <p>Required: Yes</p>
        /// <p> <b>Standard voices</b> </p>
        /// <p>For standard voices, this is not required; the engine parameter defaults to <code>standard</code>. If the engine is not specified, or is set to <code>standard</code> and an NTTS-only voice is selected, this will result in an error. </p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// Appends an item to `LexiconNames`.
        ///
        /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
        ///
        /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
        pub fn lexicon_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lexicon_names(input.into());
            self
        }
        /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
        pub fn set_lexicon_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lexicon_names(input);
            self
        }
        /// <p> The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json. </p>
        /// <p>When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format. </p>
        pub fn output_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(input);
            self
        }
        /// <p> The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json. </p>
        /// <p>When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000". </p>
        pub fn sample_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_rate(input.into());
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000". </p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sample_rate(input);
            self
        }
        /// Appends an item to `SpeechMarkTypes`.
        ///
        /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
        ///
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn speech_mark_types(mut self, input: crate::model::SpeechMarkType) -> Self {
            self.inner = self.inner.speech_mark_types(input);
            self
        }
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn set_speech_mark_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        ) -> Self {
            self.inner = self.inner.set_speech_mark_types(input);
            self
        }
        /// <p> Input text to synthesize. If you specify <code>ssml</code> as the <code>TextType</code>, follow the SSML format for the input text. </p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p> Input text to synthesize. If you specify <code>ssml</code> as the <code>TextType</code>, follow the SSML format for the input text. </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p> Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using SSML</a>.</p>
        pub fn text_type(mut self, input: crate::model::TextType) -> Self {
            self.inner = self.inner.text_type(input);
            self
        }
        /// <p> Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using SSML</a>.</p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.inner = self.inner.set_text_type(input);
            self
        }
        /// <p> Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
        pub fn voice_id(mut self, input: crate::model::VoiceId) -> Self {
            self.inner = self.inner.voice_id(input);
            self
        }
        /// <p> Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.inner = self.inner.set_voice_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
