// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `DeleteLexicon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_lexicon`](crate::client::Client::delete_lexicon).
///
/// See [`crate::client::fluent_builders::DeleteLexicon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLexicon {
    _private: (),
}
impl DeleteLexicon {
    /// Creates a new builder-style object to manufacture [`DeleteLexiconInput`](crate::input::DeleteLexiconInput)
    pub fn builder() -> crate::input::delete_lexicon_input::Builder {
        crate::input::delete_lexicon_input::Builder::default()
    }
    /// Creates a new `DeleteLexicon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLexicon {
    type Output =
        std::result::Result<crate::output::DeleteLexiconOutput, crate::error::DeleteLexiconError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_lexicon_error(response)
        } else {
            crate::operation_deser::parse_delete_lexicon_response(response)
        }
    }
}

/// Operation shape for `DescribeVoices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_voices`](crate::client::Client::describe_voices).
///
/// See [`crate::client::fluent_builders::DescribeVoices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVoices {
    _private: (),
}
impl DescribeVoices {
    /// Creates a new builder-style object to manufacture [`DescribeVoicesInput`](crate::input::DescribeVoicesInput)
    pub fn builder() -> crate::input::describe_voices_input::Builder {
        crate::input::describe_voices_input::Builder::default()
    }
    /// Creates a new `DescribeVoices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVoices {
    type Output =
        std::result::Result<crate::output::DescribeVoicesOutput, crate::error::DescribeVoicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_voices_error(response)
        } else {
            crate::operation_deser::parse_describe_voices_response(response)
        }
    }
}

/// Operation shape for `GetLexicon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lexicon`](crate::client::Client::get_lexicon).
///
/// See [`crate::client::fluent_builders::GetLexicon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLexicon {
    _private: (),
}
impl GetLexicon {
    /// Creates a new builder-style object to manufacture [`GetLexiconInput`](crate::input::GetLexiconInput)
    pub fn builder() -> crate::input::get_lexicon_input::Builder {
        crate::input::get_lexicon_input::Builder::default()
    }
    /// Creates a new `GetLexicon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLexicon {
    type Output =
        std::result::Result<crate::output::GetLexiconOutput, crate::error::GetLexiconError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lexicon_error(response)
        } else {
            crate::operation_deser::parse_get_lexicon_response(response)
        }
    }
}

/// Operation shape for `GetSpeechSynthesisTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_speech_synthesis_task`](crate::client::Client::get_speech_synthesis_task).
///
/// See [`crate::client::fluent_builders::GetSpeechSynthesisTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSpeechSynthesisTask {
    _private: (),
}
impl GetSpeechSynthesisTask {
    /// Creates a new builder-style object to manufacture [`GetSpeechSynthesisTaskInput`](crate::input::GetSpeechSynthesisTaskInput)
    pub fn builder() -> crate::input::get_speech_synthesis_task_input::Builder {
        crate::input::get_speech_synthesis_task_input::Builder::default()
    }
    /// Creates a new `GetSpeechSynthesisTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSpeechSynthesisTask {
    type Output = std::result::Result<
        crate::output::GetSpeechSynthesisTaskOutput,
        crate::error::GetSpeechSynthesisTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_speech_synthesis_task_error(response)
        } else {
            crate::operation_deser::parse_get_speech_synthesis_task_response(response)
        }
    }
}

/// Operation shape for `ListLexicons`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lexicons`](crate::client::Client::list_lexicons).
///
/// See [`crate::client::fluent_builders::ListLexicons`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLexicons {
    _private: (),
}
impl ListLexicons {
    /// Creates a new builder-style object to manufacture [`ListLexiconsInput`](crate::input::ListLexiconsInput)
    pub fn builder() -> crate::input::list_lexicons_input::Builder {
        crate::input::list_lexicons_input::Builder::default()
    }
    /// Creates a new `ListLexicons` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLexicons {
    type Output =
        std::result::Result<crate::output::ListLexiconsOutput, crate::error::ListLexiconsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lexicons_error(response)
        } else {
            crate::operation_deser::parse_list_lexicons_response(response)
        }
    }
}

/// Operation shape for `ListSpeechSynthesisTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_speech_synthesis_tasks`](crate::client::Client::list_speech_synthesis_tasks).
///
/// See [`crate::client::fluent_builders::ListSpeechSynthesisTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSpeechSynthesisTasks {
    _private: (),
}
impl ListSpeechSynthesisTasks {
    /// Creates a new builder-style object to manufacture [`ListSpeechSynthesisTasksInput`](crate::input::ListSpeechSynthesisTasksInput)
    pub fn builder() -> crate::input::list_speech_synthesis_tasks_input::Builder {
        crate::input::list_speech_synthesis_tasks_input::Builder::default()
    }
    /// Creates a new `ListSpeechSynthesisTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSpeechSynthesisTasks {
    type Output = std::result::Result<
        crate::output::ListSpeechSynthesisTasksOutput,
        crate::error::ListSpeechSynthesisTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_speech_synthesis_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_speech_synthesis_tasks_response(response)
        }
    }
}

/// Operation shape for `PutLexicon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_lexicon`](crate::client::Client::put_lexicon).
///
/// See [`crate::client::fluent_builders::PutLexicon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLexicon {
    _private: (),
}
impl PutLexicon {
    /// Creates a new builder-style object to manufacture [`PutLexiconInput`](crate::input::PutLexiconInput)
    pub fn builder() -> crate::input::put_lexicon_input::Builder {
        crate::input::put_lexicon_input::Builder::default()
    }
    /// Creates a new `PutLexicon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLexicon {
    type Output =
        std::result::Result<crate::output::PutLexiconOutput, crate::error::PutLexiconError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_lexicon_error(response)
        } else {
            crate::operation_deser::parse_put_lexicon_response(response)
        }
    }
}

/// Operation shape for `StartSpeechSynthesisTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_speech_synthesis_task`](crate::client::Client::start_speech_synthesis_task).
///
/// See [`crate::client::fluent_builders::StartSpeechSynthesisTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSpeechSynthesisTask {
    _private: (),
}
impl StartSpeechSynthesisTask {
    /// Creates a new builder-style object to manufacture [`StartSpeechSynthesisTaskInput`](crate::input::StartSpeechSynthesisTaskInput)
    pub fn builder() -> crate::input::start_speech_synthesis_task_input::Builder {
        crate::input::start_speech_synthesis_task_input::Builder::default()
    }
    /// Creates a new `StartSpeechSynthesisTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSpeechSynthesisTask {
    type Output = std::result::Result<
        crate::output::StartSpeechSynthesisTaskOutput,
        crate::error::StartSpeechSynthesisTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_speech_synthesis_task_error(response)
        } else {
            crate::operation_deser::parse_start_speech_synthesis_task_response(response)
        }
    }
}

/// Operation shape for `SynthesizeSpeech`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`synthesize_speech`](crate::client::Client::synthesize_speech).
///
/// See [`crate::client::fluent_builders::SynthesizeSpeech`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SynthesizeSpeech {
    _private: (),
}
impl SynthesizeSpeech {
    /// Creates a new builder-style object to manufacture [`SynthesizeSpeechInput`](crate::input::SynthesizeSpeechInput)
    pub fn builder() -> crate::input::synthesize_speech_input::Builder {
        crate::input::synthesize_speech_input::Builder::default()
    }
    /// Creates a new `SynthesizeSpeech` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for SynthesizeSpeech {
    type Output = std::result::Result<
        crate::output::SynthesizeSpeechOutput,
        crate::error::SynthesizeSpeechError,
    >;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_synthesize_speech(response))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_synthesize_speech_error(response)
    }
}
