// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_lexicon_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteLexiconOutput, crate::error::DeleteLexiconError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLexiconError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLexiconError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LexiconNotFoundException" => crate::error::DeleteLexiconError {
            meta: generic,
            kind: crate::error::DeleteLexiconErrorKind::LexiconNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::lexicon_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lexicon_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DeleteLexiconError {
            meta: generic,
            kind: crate::error::DeleteLexiconErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLexiconError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_lexicon_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteLexiconOutput, crate::error::DeleteLexiconError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_lexicon_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_voices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeVoicesOutput, crate::error::DescribeVoicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeVoicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeVoicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::DescribeVoicesError {
            meta: generic,
            kind: crate::error::DescribeVoicesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVoicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::DescribeVoicesError {
            meta: generic,
            kind: crate::error::DescribeVoicesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVoicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeVoicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_voices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeVoicesOutput, crate::error::DescribeVoicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_voices_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_voices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeVoicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lexicon_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLexiconOutput, crate::error::GetLexiconError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLexiconError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLexiconError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LexiconNotFoundException" => crate::error::GetLexiconError {
            meta: generic,
            kind: crate::error::GetLexiconErrorKind::LexiconNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::lexicon_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lexicon_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::GetLexiconError {
            meta: generic,
            kind: crate::error::GetLexiconErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLexiconError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lexicon_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLexiconOutput, crate::error::GetLexiconError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_lexicon_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_lexicon(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLexiconError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_speech_synthesis_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSpeechSynthesisTaskOutput,
    crate::error::GetSpeechSynthesisTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSpeechSynthesisTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSpeechSynthesisTaskError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTaskIdException" => crate::error::GetSpeechSynthesisTaskError {
            meta: generic,
            kind: crate::error::GetSpeechSynthesisTaskErrorKind::InvalidTaskIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_task_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_task_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::GetSpeechSynthesisTaskError {
            meta: generic,
            kind: crate::error::GetSpeechSynthesisTaskErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SynthesisTaskNotFoundException" => crate::error::GetSpeechSynthesisTaskError {
            meta: generic,
            kind: crate::error::GetSpeechSynthesisTaskErrorKind::SynthesisTaskNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::synthesis_task_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_synthesis_task_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSpeechSynthesisTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_speech_synthesis_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSpeechSynthesisTaskOutput,
    crate::error::GetSpeechSynthesisTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_speech_synthesis_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_speech_synthesis_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSpeechSynthesisTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_lexicons_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLexiconsOutput, crate::error::ListLexiconsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLexiconsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLexiconsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListLexiconsError {
            meta: generic,
            kind: crate::error::ListLexiconsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLexiconsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListLexiconsError {
            meta: generic,
            kind: crate::error::ListLexiconsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLexiconsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLexiconsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_lexicons_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLexiconsOutput, crate::error::ListLexiconsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_lexicons_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_lexicons(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLexiconsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_speech_synthesis_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSpeechSynthesisTasksOutput,
    crate::error::ListSpeechSynthesisTasksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSpeechSynthesisTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSpeechSynthesisTasksError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListSpeechSynthesisTasksError {
            meta: generic,
            kind: crate::error::ListSpeechSynthesisTasksErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSpeechSynthesisTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::ListSpeechSynthesisTasksError {
            meta: generic,
            kind: crate::error::ListSpeechSynthesisTasksErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSpeechSynthesisTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSpeechSynthesisTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_speech_synthesis_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSpeechSynthesisTasksOutput,
    crate::error::ListSpeechSynthesisTasksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_speech_synthesis_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_speech_synthesis_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSpeechSynthesisTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lexicon_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutLexiconOutput, crate::error::PutLexiconError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutLexiconError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutLexiconError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidLexiconException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::InvalidLexiconException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_lexicon_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lexicon_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LexiconSizeExceededException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::LexiconSizeExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::lexicon_size_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lexicon_size_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MaxLexemeLengthExceededException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::MaxLexemeLengthExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::max_lexeme_length_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_max_lexeme_length_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MaxLexiconsNumberExceededException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::MaxLexiconsNumberExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::max_lexicons_number_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_max_lexicons_number_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedPlsAlphabetException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::UnsupportedPlsAlphabetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_pls_alphabet_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_pls_alphabet_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedPlsLanguageException" => crate::error::PutLexiconError {
            meta: generic,
            kind: crate::error::PutLexiconErrorKind::UnsupportedPlsLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_pls_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_pls_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLexiconError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutLexiconError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lexicon_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutLexiconOutput, crate::error::PutLexiconError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_lexicon_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_speech_synthesis_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSpeechSynthesisTaskOutput,
    crate::error::StartSpeechSynthesisTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartSpeechSynthesisTaskError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EngineNotSupportedException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::EngineNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::engine_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_engine_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3BucketException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::InvalidS3BucketException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_bucket_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_s3_bucket_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3KeyException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::InvalidS3KeyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_key_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_s3_key_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSampleRateException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::InvalidSampleRateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sample_rate_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sample_rate_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSnsTopicArnException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::InvalidSnsTopicArnException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sns_topic_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sns_topic_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSsmlException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::InvalidSsmlException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_ssml_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ssml_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LanguageNotSupportedException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::LanguageNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::language_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_language_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LexiconNotFoundException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::LexiconNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::lexicon_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lexicon_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MarksNotSupportedForFormatException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::MarksNotSupportedForFormatException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::marks_not_supported_for_format_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_marks_not_supported_for_format_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailureException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SsmlMarksNotSupportedForTextTypeException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::SsmlMarksNotSupportedForTextTypeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::ssml_marks_not_supported_for_text_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ssml_marks_not_supported_for_text_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TextLengthExceededException" => crate::error::StartSpeechSynthesisTaskError { meta: generic, kind: crate::error::StartSpeechSynthesisTaskErrorKind::TextLengthExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::text_length_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_length_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StartSpeechSynthesisTaskError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_speech_synthesis_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSpeechSynthesisTaskOutput,
    crate::error::StartSpeechSynthesisTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_speech_synthesis_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_speech_synthesis_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartSpeechSynthesisTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_synthesize_speech(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::SynthesizeSpeechOutput, crate::error::SynthesizeSpeechError>
{
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::synthesize_speech_output::Builder::default();
        let _ = response;
        output = output.set_audio_stream(
            Some(crate::http_serde::deser_payload_synthesize_speech_synthesize_speech_output_audio_stream(response.body_mut())?)
        );
        output = output.set_content_type(
            crate::http_serde::deser_header_synthesize_speech_synthesize_speech_output_content_type(response.headers())
                                        .map_err(|_|crate::error::SynthesizeSpeechError::unhandled("Failed to parse ContentType from header `Content-Type"))?
        );
        output = output.set_request_characters(
            crate::http_serde::deser_header_synthesize_speech_synthesize_speech_output_request_characters(response.headers())
                                        .map_err(|_|crate::error::SynthesizeSpeechError::unhandled("Failed to parse RequestCharacters from header `x-amzn-RequestCharacters"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_synthesize_speech_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SynthesizeSpeechOutput, crate::error::SynthesizeSpeechError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SynthesizeSpeechError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SynthesizeSpeechError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EngineNotSupportedException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::EngineNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::engine_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_engine_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSampleRateException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::InvalidSampleRateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_sample_rate_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sample_rate_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSsmlException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::InvalidSsmlException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_ssml_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ssml_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LanguageNotSupportedException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::LanguageNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::language_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_language_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LexiconNotFoundException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::LexiconNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::lexicon_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lexicon_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MarksNotSupportedForFormatException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::MarksNotSupportedForFormatException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::marks_not_supported_for_format_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_marks_not_supported_for_format_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailureException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SsmlMarksNotSupportedForTextTypeException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind:
                crate::error::SynthesizeSpeechErrorKind::SsmlMarksNotSupportedForTextTypeException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::ssml_marks_not_supported_for_text_type_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_ssml_marks_not_supported_for_text_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "TextLengthExceededException" => crate::error::SynthesizeSpeechError {
            meta: generic,
            kind: crate::error::SynthesizeSpeechErrorKind::TextLengthExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_length_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_length_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SynthesizeSpeechError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SynthesizeSpeechError::generic(generic),
    })
}
