// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteLexiconInput`](crate::input::DeleteLexiconInput)
pub mod delete_lexicon_input {
    /// A builder for [`DeleteLexiconInput`](crate::input::DeleteLexiconInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lexicon to delete. Must be an existing lexicon in
        /// the region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the lexicon to delete. Must be an existing lexicon in
        /// the region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLexiconInput`](crate::input::DeleteLexiconInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLexiconInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLexiconInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteLexiconInputOperationOutputAlias = crate::operation::DeleteLexicon;
#[doc(hidden)]
pub type DeleteLexiconInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLexiconInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLexicon`](crate::operation::DeleteLexicon)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLexicon,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLexiconInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_1, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/lexicons/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLexiconInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLexiconInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLexicon::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLexicon",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLexiconInput`](crate::input::DeleteLexiconInput)
    pub fn builder() -> crate::input::delete_lexicon_input::Builder {
        crate::input::delete_lexicon_input::Builder::default()
    }
}

/// See [`DescribeVoicesInput`](crate::input::DescribeVoicesInput)
pub mod describe_voices_input {
    /// A builder for [`DescribeVoicesInput`](crate::input::DescribeVoicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<crate::model::Engine>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) include_additional_language_codes: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// used by Amazon Polly when processing input text for speech synthesis. </p>
        pub fn engine(mut self, input: crate::model::Engine) -> Self {
            self.engine = Some(input);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// used by Amazon Polly when processing input text for speech synthesis. </p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.engine = input;
            self
        }
        /// <p> The language identification tag (ISO 639 code for the language
        /// name-ISO 3166 country code) for filtering the list of voices returned. If
        /// you don't specify this optional parameter, all available voices are
        /// returned. </p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p> The language identification tag (ISO 639 code for the language
        /// name-ISO 3166 country code) for filtering the list of voices returned. If
        /// you don't specify this optional parameter, all available voices are
        /// returned. </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>Boolean value indicating whether to return any bilingual voices that
        /// use the specified language as an additional language. For instance, if you
        /// request all languages that use US English (es-US), and there is an Italian
        /// voice that speaks both Italian (it-IT) and US English, that voice will be
        /// included if you specify <code>yes</code> but not if you specify
        /// <code>no</code>.</p>
        pub fn include_additional_language_codes(mut self, input: bool) -> Self {
            self.include_additional_language_codes = Some(input);
            self
        }
        /// <p>Boolean value indicating whether to return any bilingual voices that
        /// use the specified language as an additional language. For instance, if you
        /// request all languages that use US English (es-US), and there is an Italian
        /// voice that speaks both Italian (it-IT) and US English, that voice will be
        /// included if you specify <code>yes</code> but not if you specify
        /// <code>no</code>.</p>
        pub fn set_include_additional_language_codes(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_additional_language_codes = input;
            self
        }
        /// <p>An opaque pagination token returned from the previous
        /// <code>DescribeVoices</code> operation. If present, this indicates where
        /// to continue the listing.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque pagination token returned from the previous
        /// <code>DescribeVoices</code> operation. If present, this indicates where
        /// to continue the listing.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVoicesInput`](crate::input::DescribeVoicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVoicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVoicesInput {
                engine: self.engine,
                language_code: self.language_code,
                include_additional_language_codes: self
                    .include_additional_language_codes
                    .unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVoicesInputOperationOutputAlias = crate::operation::DescribeVoices;
#[doc(hidden)]
pub type DescribeVoicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVoicesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVoices`](crate::operation::DescribeVoices)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVoices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVoicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/voices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeVoicesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.engine {
                query.push_kv("Engine", &aws_smithy_http::query::fmt_string(&inner_2));
            }
            if let Some(inner_3) = &_input.language_code {
                query.push_kv(
                    "LanguageCode",
                    &aws_smithy_http::query::fmt_string(&inner_3),
                );
            }
            if _input.include_additional_language_codes {
                query.push_kv(
                    "IncludeAdditionalLanguageCodes",
                    &aws_smithy_types::primitive::Encoder::from(
                        _input.include_additional_language_codes,
                    )
                    .encode(),
                );
            }
            if let Some(inner_4) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_4));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVoicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVoicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVoices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVoices",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVoicesInput`](crate::input::DescribeVoicesInput)
    pub fn builder() -> crate::input::describe_voices_input::Builder {
        crate::input::describe_voices_input::Builder::default()
    }
}

/// See [`GetLexiconInput`](crate::input::GetLexiconInput)
pub mod get_lexicon_input {
    /// A builder for [`GetLexiconInput`](crate::input::GetLexiconInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the lexicon.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the lexicon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLexiconInput`](crate::input::GetLexiconInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLexiconInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLexiconInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetLexiconInputOperationOutputAlias = crate::operation::GetLexicon;
#[doc(hidden)]
pub type GetLexiconInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLexiconInput {
    /// Consumes the builder and constructs an Operation<[`GetLexicon`](crate::operation::GetLexicon)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLexicon,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLexiconInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_5, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/lexicons/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLexiconInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLexiconInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLexicon::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLexicon",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLexiconInput`](crate::input::GetLexiconInput)
    pub fn builder() -> crate::input::get_lexicon_input::Builder {
        crate::input::get_lexicon_input::Builder::default()
    }
}

/// See [`GetSpeechSynthesisTaskInput`](crate::input::GetSpeechSynthesisTaskInput)
pub mod get_speech_synthesis_task_input {
    /// A builder for [`GetSpeechSynthesisTaskInput`](crate::input::GetSpeechSynthesisTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSpeechSynthesisTaskInput`](crate::input::GetSpeechSynthesisTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSpeechSynthesisTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSpeechSynthesisTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSpeechSynthesisTaskInputOperationOutputAlias = crate::operation::GetSpeechSynthesisTask;
#[doc(hidden)]
pub type GetSpeechSynthesisTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSpeechSynthesisTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetSpeechSynthesisTask`](crate::operation::GetSpeechSynthesisTask)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSpeechSynthesisTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSpeechSynthesisTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.task_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    })?;
            let task_id = aws_smithy_http::label::fmt_string(input_6, false);
            if task_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "task_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/synthesisTasks/{TaskId}", TaskId = task_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSpeechSynthesisTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSpeechSynthesisTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSpeechSynthesisTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSpeechSynthesisTask",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSpeechSynthesisTaskInput`](crate::input::GetSpeechSynthesisTaskInput)
    pub fn builder() -> crate::input::get_speech_synthesis_task_input::Builder {
        crate::input::get_speech_synthesis_task_input::Builder::default()
    }
}

/// See [`ListLexiconsInput`](crate::input::ListLexiconsInput)
pub mod list_lexicons_input {
    /// A builder for [`ListLexiconsInput`](crate::input::ListLexiconsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An opaque pagination token returned from previous
        /// <code>ListLexicons</code> operation. If present, indicates where to
        /// continue the list of lexicons.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque pagination token returned from previous
        /// <code>ListLexicons</code> operation. If present, indicates where to
        /// continue the list of lexicons.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLexiconsInput`](crate::input::ListLexiconsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLexiconsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLexiconsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLexiconsInputOperationOutputAlias = crate::operation::ListLexicons;
#[doc(hidden)]
pub type ListLexiconsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLexiconsInput {
    /// Consumes the builder and constructs an Operation<[`ListLexicons`](crate::operation::ListLexicons)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLexicons,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLexiconsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/lexicons").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListLexiconsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLexiconsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLexiconsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLexicons::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLexicons",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLexiconsInput`](crate::input::ListLexiconsInput)
    pub fn builder() -> crate::input::list_lexicons_input::Builder {
        crate::input::list_lexicons_input::Builder::default()
    }
}

/// See [`ListSpeechSynthesisTasksInput`](crate::input::ListSpeechSynthesisTasksInput)
pub mod list_speech_synthesis_tasks_input {
    /// A builder for [`ListSpeechSynthesisTasksInput`](crate::input::ListSpeechSynthesisTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskStatus>,
    }
    impl Builder {
        /// <p>Maximum number of speech synthesis tasks returned in a List
        /// operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of speech synthesis tasks returned in a List
        /// operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use in the next request to continue the
        /// listing of speech synthesis tasks. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use in the next request to continue the
        /// listing of speech synthesis tasks. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Status of the speech synthesis tasks returned in a List
        /// operation</p>
        pub fn status(mut self, input: crate::model::TaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the speech synthesis tasks returned in a List
        /// operation</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TaskStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSpeechSynthesisTasksInput`](crate::input::ListSpeechSynthesisTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSpeechSynthesisTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSpeechSynthesisTasksInput {
                max_results: self.max_results,
                next_token: self.next_token,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSpeechSynthesisTasksInputOperationOutputAlias =
    crate::operation::ListSpeechSynthesisTasks;
#[doc(hidden)]
pub type ListSpeechSynthesisTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSpeechSynthesisTasksInput {
    /// Consumes the builder and constructs an Operation<[`ListSpeechSynthesisTasks`](crate::operation::ListSpeechSynthesisTasks)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSpeechSynthesisTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSpeechSynthesisTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/synthesisTasks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSpeechSynthesisTasksInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_8).encode(),
                );
            }
            if let Some(inner_9) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            if let Some(inner_10) = &_input.status {
                query.push_kv("Status", &aws_smithy_http::query::fmt_string(&inner_10));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSpeechSynthesisTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSpeechSynthesisTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSpeechSynthesisTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSpeechSynthesisTasks",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSpeechSynthesisTasksInput`](crate::input::ListSpeechSynthesisTasksInput)
    pub fn builder() -> crate::input::list_speech_synthesis_tasks_input::Builder {
        crate::input::list_speech_synthesis_tasks_input::Builder::default()
    }
}

/// See [`PutLexiconInput`](crate::input::PutLexiconInput)
pub mod put_lexicon_input {
    /// A builder for [`PutLexiconInput`](crate::input::PutLexiconInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the lexicon. The name must follow the regular express
        /// format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive
        /// alphanumeric string up to 20 characters long. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the lexicon. The name must follow the regular express
        /// format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive
        /// alphanumeric string up to 20 characters long. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Content of the PLS lexicon as string data.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>Content of the PLS lexicon as string data.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLexiconInput`](crate::input::PutLexiconInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLexiconInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLexiconInput {
                name: self.name,
                content: self.content,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLexiconInputOperationOutputAlias = crate::operation::PutLexicon;
#[doc(hidden)]
pub type PutLexiconInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutLexiconInput {
    /// Consumes the builder and constructs an Operation<[`PutLexicon`](crate::operation::PutLexicon)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLexicon,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLexiconInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_11, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/lexicons/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLexiconInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLexiconInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_lexicon(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLexicon::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLexicon",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLexiconInput`](crate::input::PutLexiconInput)
    pub fn builder() -> crate::input::put_lexicon_input::Builder {
        crate::input::put_lexicon_input::Builder::default()
    }
}

/// See [`StartSpeechSynthesisTaskInput`](crate::input::StartSpeechSynthesisTaskInput)
pub mod start_speech_synthesis_task_input {
    /// A builder for [`StartSpeechSynthesisTaskInput`](crate::input::StartSpeechSynthesisTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<crate::model::Engine>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) lexicon_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) output_format: std::option::Option<crate::model::OutputFormat>,
        pub(crate) output_s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) output_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sample_rate: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) speech_mark_types:
            std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) text_type: std::option::Option<crate::model::TextType>,
        pub(crate) voice_id: std::option::Option<crate::model::VoiceId>,
    }
    impl Builder {
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. Using a
        /// voice that is not supported for the engine selected will result in an
        /// error.</p>
        pub fn engine(mut self, input: crate::model::Engine) -> Self {
            self.engine = Some(input);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. Using a
        /// voice that is not supported for the engine selected will result in an
        /// error.</p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Optional language code for the Speech Synthesis request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>Optional language code for the Speech Synthesis request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Appends an item to `lexicon_names`.
        ///
        /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
        ///
        /// <p>List of one or more pronunciation lexicon names you want the service
        /// to apply during synthesis. Lexicons are applied only if the language of
        /// the lexicon is the same as the language of the voice. </p>
        pub fn lexicon_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lexicon_names.unwrap_or_default();
            v.push(input.into());
            self.lexicon_names = Some(v);
            self
        }
        /// <p>List of one or more pronunciation lexicon names you want the service
        /// to apply during synthesis. Lexicons are applied only if the language of
        /// the lexicon is the same as the language of the voice. </p>
        pub fn set_lexicon_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lexicon_names = input;
            self
        }
        /// <p>The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        pub fn output_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.output_format = Some(input);
            self
        }
        /// <p>The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.output_format = input;
            self
        }
        /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket_name = input;
            self
        }
        /// <p>The Amazon S3 key prefix for the output speech file.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 key prefix for the output speech file.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_key_prefix = input;
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn sample_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_rate = Some(input.into());
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sample_rate = input;
            self
        }
        /// <p>ARN for the SNS topic optionally used for providing status
        /// notification for a speech synthesis task.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>ARN for the SNS topic optionally used for providing status
        /// notification for a speech synthesis task.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Appends an item to `speech_mark_types`.
        ///
        /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
        ///
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn speech_mark_types(mut self, input: impl Into<crate::model::SpeechMarkType>) -> Self {
            let mut v = self.speech_mark_types.unwrap_or_default();
            v.push(input.into());
            self.speech_mark_types = Some(v);
            self
        }
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn set_speech_mark_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        ) -> Self {
            self.speech_mark_types = input;
            self
        }
        /// <p>The input text to synthesize. If you specify ssml as the TextType,
        /// follow the SSML format for the input text. </p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The input text to synthesize. If you specify ssml as the TextType,
        /// follow the SSML format for the input text. </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>Specifies whether the input text is plain text or SSML. The default
        /// value is plain text. </p>
        pub fn text_type(mut self, input: crate::model::TextType) -> Self {
            self.text_type = Some(input);
            self
        }
        /// <p>Specifies whether the input text is plain text or SSML. The default
        /// value is plain text. </p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.text_type = input;
            self
        }
        /// <p>Voice ID to use for the synthesis. </p>
        pub fn voice_id(mut self, input: crate::model::VoiceId) -> Self {
            self.voice_id = Some(input);
            self
        }
        /// <p>Voice ID to use for the synthesis. </p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.voice_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSpeechSynthesisTaskInput`](crate::input::StartSpeechSynthesisTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSpeechSynthesisTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSpeechSynthesisTaskInput {
                engine: self.engine,
                language_code: self.language_code,
                lexicon_names: self.lexicon_names,
                output_format: self.output_format,
                output_s3_bucket_name: self.output_s3_bucket_name,
                output_s3_key_prefix: self.output_s3_key_prefix,
                sample_rate: self.sample_rate,
                sns_topic_arn: self.sns_topic_arn,
                speech_mark_types: self.speech_mark_types,
                text: self.text,
                text_type: self.text_type,
                voice_id: self.voice_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSpeechSynthesisTaskInputOperationOutputAlias =
    crate::operation::StartSpeechSynthesisTask;
#[doc(hidden)]
pub type StartSpeechSynthesisTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSpeechSynthesisTaskInput {
    /// Consumes the builder and constructs an Operation<[`StartSpeechSynthesisTask`](crate::operation::StartSpeechSynthesisTask)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSpeechSynthesisTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSpeechSynthesisTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/synthesisTasks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSpeechSynthesisTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSpeechSynthesisTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_speech_synthesis_task(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSpeechSynthesisTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSpeechSynthesisTask",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSpeechSynthesisTaskInput`](crate::input::StartSpeechSynthesisTaskInput)
    pub fn builder() -> crate::input::start_speech_synthesis_task_input::Builder {
        crate::input::start_speech_synthesis_task_input::Builder::default()
    }
}

/// See [`SynthesizeSpeechInput`](crate::input::SynthesizeSpeechInput)
pub mod synthesize_speech_input {
    /// A builder for [`SynthesizeSpeechInput`](crate::input::SynthesizeSpeechInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<crate::model::Engine>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) lexicon_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) output_format: std::option::Option<crate::model::OutputFormat>,
        pub(crate) sample_rate: std::option::Option<std::string::String>,
        pub(crate) speech_mark_types:
            std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) text_type: std::option::Option<crate::model::TextType>,
        pub(crate) voice_id: std::option::Option<crate::model::VoiceId>,
    }
    impl Builder {
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. For
        /// information on Amazon Polly voices and which voices are available in
        /// standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
        /// <p>
        /// <b>NTTS-only voices</b>
        /// </p>
        /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is
        /// required and must be set to <code>neural</code>. If the engine is not
        /// specified, or is set to <code>standard</code>, this will result in an
        /// error. </p>
        /// <p>Type: String</p>
        /// <p>Valid Values: <code>standard</code> | <code>neural</code>
        /// </p>
        /// <p>Required: Yes</p>
        ///
        /// <p>
        /// <b>Standard voices</b>
        /// </p>
        /// <p>For standard voices, this is not required; the engine parameter
        /// defaults to <code>standard</code>. If the engine is not specified, or is
        /// set to <code>standard</code> and an NTTS-only voice is selected, this will
        /// result in an error. </p>
        pub fn engine(mut self, input: crate::model::Engine) -> Self {
            self.engine = Some(input);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. For
        /// information on Amazon Polly voices and which voices are available in
        /// standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
        /// <p>
        /// <b>NTTS-only voices</b>
        /// </p>
        /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is
        /// required and must be set to <code>neural</code>. If the engine is not
        /// specified, or is set to <code>standard</code>, this will result in an
        /// error. </p>
        /// <p>Type: String</p>
        /// <p>Valid Values: <code>standard</code> | <code>neural</code>
        /// </p>
        /// <p>Required: Yes</p>
        ///
        /// <p>
        /// <b>Standard voices</b>
        /// </p>
        /// <p>For standard voices, this is not required; the engine parameter
        /// defaults to <code>standard</code>. If the engine is not specified, or is
        /// set to <code>standard</code> and an NTTS-only voice is selected, this will
        /// result in an error. </p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Optional language code for the Synthesize Speech request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>Optional language code for the Synthesize Speech request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Appends an item to `lexicon_names`.
        ///
        /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
        ///
        /// <p>List of one or more pronunciation lexicon names you want the
        /// service to apply during synthesis. Lexicons are applied only if the
        /// language of the lexicon is the same as the language of the voice. For
        /// information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
        pub fn lexicon_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lexicon_names.unwrap_or_default();
            v.push(input.into());
            self.lexicon_names = Some(v);
            self
        }
        /// <p>List of one or more pronunciation lexicon names you want the
        /// service to apply during synthesis. Lexicons are applied only if the
        /// language of the lexicon is the same as the language of the voice. For
        /// information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
        pub fn set_lexicon_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lexicon_names = input;
            self
        }
        /// <p> The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        /// <p>When pcm is used, the content returned is audio/pcm in a signed
        /// 16-bit, 1 channel (mono), little-endian format. </p>
        pub fn output_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.output_format = Some(input);
            self
        }
        /// <p> The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        /// <p>When pcm is used, the content returned is audio/pcm in a signed
        /// 16-bit, 1 channel (mono), little-endian format. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.output_format = input;
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn sample_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_rate = Some(input.into());
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sample_rate = input;
            self
        }
        /// Appends an item to `speech_mark_types`.
        ///
        /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
        ///
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn speech_mark_types(mut self, input: impl Into<crate::model::SpeechMarkType>) -> Self {
            let mut v = self.speech_mark_types.unwrap_or_default();
            v.push(input.into());
            self.speech_mark_types = Some(v);
            self
        }
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn set_speech_mark_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        ) -> Self {
            self.speech_mark_types = input;
            self
        }
        /// <p> Input text to synthesize. If you specify <code>ssml</code> as the
        /// <code>TextType</code>, follow the SSML format for the input text.
        /// </p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p> Input text to synthesize. If you specify <code>ssml</code> as the
        /// <code>TextType</code>, follow the SSML format for the input text.
        /// </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p> Specifies whether the input text is plain text or SSML. The
        /// default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using
        /// SSML</a>.</p>
        pub fn text_type(mut self, input: crate::model::TextType) -> Self {
            self.text_type = Some(input);
            self
        }
        /// <p> Specifies whether the input text is plain text or SSML. The
        /// default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using
        /// SSML</a>.</p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.text_type = input;
            self
        }
        /// <p> Voice ID to use for the synthesis. You can get a list of available
        /// voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
        pub fn voice_id(mut self, input: crate::model::VoiceId) -> Self {
            self.voice_id = Some(input);
            self
        }
        /// <p> Voice ID to use for the synthesis. You can get a list of available
        /// voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.voice_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SynthesizeSpeechInput`](crate::input::SynthesizeSpeechInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SynthesizeSpeechInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SynthesizeSpeechInput {
                engine: self.engine,
                language_code: self.language_code,
                lexicon_names: self.lexicon_names,
                output_format: self.output_format,
                sample_rate: self.sample_rate,
                speech_mark_types: self.speech_mark_types,
                text: self.text,
                text_type: self.text_type,
                voice_id: self.voice_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SynthesizeSpeechInputOperationOutputAlias = crate::operation::SynthesizeSpeech;
#[doc(hidden)]
pub type SynthesizeSpeechInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SynthesizeSpeechInput {
    /// Consumes the builder and constructs an Operation<[`SynthesizeSpeech`](crate::operation::SynthesizeSpeech)>
    #[allow(clippy::let_and_return)]
    fn _make_presigned_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SynthesizeSpeech,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SynthesizeSpeechInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/speech").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::SynthesizeSpeechInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_12) = &_input.engine {
                query.push_kv("Engine", &aws_smithy_http::query::fmt_string(&inner_12));
            }
            if let Some(inner_13) = &_input.language_code {
                query.push_kv(
                    "LanguageCode",
                    &aws_smithy_http::query::fmt_string(&inner_13),
                );
            }
            if let Some(inner_14) = &_input.lexicon_names {
                for inner_15 in inner_14 {
                    query.push_kv(
                        "LexiconNames",
                        &aws_smithy_http::query::fmt_string(&inner_15),
                    );
                }
            }
            if let Some(inner_16) = &_input.output_format {
                query.push_kv(
                    "OutputFormat",
                    &aws_smithy_http::query::fmt_string(&inner_16),
                );
            }
            if let Some(inner_17) = &_input.sample_rate {
                query.push_kv("SampleRate", &aws_smithy_http::query::fmt_string(&inner_17));
            }
            if let Some(inner_18) = &_input.speech_mark_types {
                for inner_19 in inner_18 {
                    query.push_kv(
                        "SpeechMarkTypes",
                        &aws_smithy_http::query::fmt_string(&inner_19),
                    );
                }
            }
            if let Some(inner_20) = &_input.text {
                query.push_kv("Text", &aws_smithy_http::query::fmt_string(&inner_20));
            }
            if let Some(inner_21) = &_input.text_type {
                query.push_kv("TextType", &aws_smithy_http::query::fmt_string(&inner_21));
            }
            if let Some(inner_22) = &_input.voice_id {
                query.push_kv("VoiceId", &aws_smithy_http::query::fmt_string(&inner_22));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SynthesizeSpeechInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SynthesizeSpeechInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SynthesizeSpeech::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SynthesizeSpeech",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    ///
    /// Creates a presigned request for this operation.
    ///
    /// The credentials provider from the `config` will be used to generate the request's signature.
    /// The `presigning_config` provides additional presigning-specific config values, such as the
    /// amount of time the request should be valid for after creation.
    ///
    /// Presigned requests can be given to other users or applications to access a resource or perform
    /// an operation without having access to the AWS security credentials.
    ///
    #[cfg(feature = "client")]
    pub async fn presigned(
        self,
        config: &crate::config::Config,
        presigning_config: crate::presigning::config::PresigningConfig,
    ) -> Result<
        crate::presigning::request::PresignedRequest,
        aws_smithy_http::result::SdkError<crate::error::SynthesizeSpeechError>,
    > {
        let (mut request, _) = self
            ._make_presigned_operation(config)
            .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
            .into_request_response();
        {
            // Change signature type to query params and wire up presigning config
            let mut props = request.properties_mut();
            props.insert(presigning_config.start_time());
            props.insert(aws_sigv4::http_request::SignableBody::Bytes(b""));
            let mut config = props
                .get_mut::<aws_sig_auth::signer::OperationSigningConfig>()
                .expect("signing config added by make_operation()");
            config.signature_type = aws_sig_auth::signer::HttpSignatureType::HttpRequestQueryParams;
            config.expires_in = Some(presigning_config.expires());
        }
        let middleware = aws_hyper::AwsMiddleware::default();
        let mut svc = tower::builder::ServiceBuilder::new()
            .layer(&middleware)
            .service(crate::presigning::service::PresignedRequestService::new());

        use tower::{Service, ServiceExt};
        Ok(svc.ready().await?.call(request).await?)
    }
    /// Consumes the builder and constructs an Operation<[`SynthesizeSpeech`](crate::operation::SynthesizeSpeech)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SynthesizeSpeech,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SynthesizeSpeechInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/speech").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SynthesizeSpeechInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SynthesizeSpeechInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_synthesize_speech(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SynthesizeSpeech::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SynthesizeSpeech",
            "polly",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SynthesizeSpeechInput`](crate::input::SynthesizeSpeechInput)
    pub fn builder() -> crate::input::synthesize_speech_input::Builder {
        crate::input::synthesize_speech_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SynthesizeSpeechInput {
    /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
    /// for Amazon Polly to use when processing input text for speech synthesis. For
    /// information on Amazon Polly voices and which voices are available in
    /// standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
    /// <p>
    /// <b>NTTS-only voices</b>
    /// </p>
    /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is
    /// required and must be set to <code>neural</code>. If the engine is not
    /// specified, or is set to <code>standard</code>, this will result in an
    /// error. </p>
    /// <p>Type: String</p>
    /// <p>Valid Values: <code>standard</code> | <code>neural</code>
    /// </p>
    /// <p>Required: Yes</p>
    ///
    /// <p>
    /// <b>Standard voices</b>
    /// </p>
    /// <p>For standard voices, this is not required; the engine parameter
    /// defaults to <code>standard</code>. If the engine is not specified, or is
    /// set to <code>standard</code> and an NTTS-only voice is selected, this will
    /// result in an error. </p>
    pub engine: std::option::Option<crate::model::Engine>,
    /// <p>Optional language code for the Synthesize Speech request. This is only
    /// necessary if using a bilingual voice, such as Aditi, which can be used for
    /// either Indian English (en-IN) or Hindi (hi-IN). </p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
    /// uses the default language of the bilingual voice. The default language for
    /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
    /// parameter. For example, if no language code is specified, Aditi will use
    /// Indian English rather than Hindi.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>List of one or more pronunciation lexicon names you want the
    /// service to apply during synthesis. Lexicons are applied only if the
    /// language of the lexicon is the same as the language of the voice. For
    /// information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
    pub lexicon_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The format in which the returned output will be encoded. For audio
    /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
    /// be json. </p>
    /// <p>When pcm is used, the content returned is audio/pcm in a signed
    /// 16-bit, 1 channel (mono), little-endian format. </p>
    pub output_format: std::option::Option<crate::model::OutputFormat>,
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
    /// and "24000". The default value for standard voices is "22050". The default
    /// value for neural voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is
    /// "16000". </p>
    pub sample_rate: std::option::Option<std::string::String>,
    /// <p>The type of speech marks returned for the input text.</p>
    pub speech_mark_types: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
    /// <p> Input text to synthesize. If you specify <code>ssml</code> as the
    /// <code>TextType</code>, follow the SSML format for the input text.
    /// </p>
    pub text: std::option::Option<std::string::String>,
    /// <p> Specifies whether the input text is plain text or SSML. The
    /// default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using
    /// SSML</a>.</p>
    pub text_type: std::option::Option<crate::model::TextType>,
    /// <p> Voice ID to use for the synthesis. You can get a list of available
    /// voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
    pub voice_id: std::option::Option<crate::model::VoiceId>,
}
impl std::fmt::Debug for SynthesizeSpeechInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SynthesizeSpeechInput");
        formatter.field("engine", &self.engine);
        formatter.field("language_code", &self.language_code);
        formatter.field("lexicon_names", &self.lexicon_names);
        formatter.field("output_format", &self.output_format);
        formatter.field("sample_rate", &self.sample_rate);
        formatter.field("speech_mark_types", &self.speech_mark_types);
        formatter.field("text", &self.text);
        formatter.field("text_type", &self.text_type);
        formatter.field("voice_id", &self.voice_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSpeechSynthesisTaskInput {
    /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
    /// for Amazon Polly to use when processing input text for speech synthesis. Using a
    /// voice that is not supported for the engine selected will result in an
    /// error.</p>
    pub engine: std::option::Option<crate::model::Engine>,
    /// <p>Optional language code for the Speech Synthesis request. This is only
    /// necessary if using a bilingual voice, such as Aditi, which can be used for
    /// either Indian English (en-IN) or Hindi (hi-IN). </p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
    /// uses the default language of the bilingual voice. The default language for
    /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
    /// parameter. For example, if no language code is specified, Aditi will use
    /// Indian English rather than Hindi.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>List of one or more pronunciation lexicon names you want the service
    /// to apply during synthesis. Lexicons are applied only if the language of
    /// the lexicon is the same as the language of the voice. </p>
    pub lexicon_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The format in which the returned output will be encoded. For audio
    /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
    /// be json. </p>
    pub output_format: std::option::Option<crate::model::OutputFormat>,
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub output_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub output_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
    /// and "24000". The default value for standard voices is "22050". The default
    /// value for neural voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is
    /// "16000". </p>
    pub sample_rate: std::option::Option<std::string::String>,
    /// <p>ARN for the SNS topic optionally used for providing status
    /// notification for a speech synthesis task.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The type of speech marks returned for the input text.</p>
    pub speech_mark_types: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
    /// <p>The input text to synthesize. If you specify ssml as the TextType,
    /// follow the SSML format for the input text. </p>
    pub text: std::option::Option<std::string::String>,
    /// <p>Specifies whether the input text is plain text or SSML. The default
    /// value is plain text. </p>
    pub text_type: std::option::Option<crate::model::TextType>,
    /// <p>Voice ID to use for the synthesis. </p>
    pub voice_id: std::option::Option<crate::model::VoiceId>,
}
impl std::fmt::Debug for StartSpeechSynthesisTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSpeechSynthesisTaskInput");
        formatter.field("engine", &self.engine);
        formatter.field("language_code", &self.language_code);
        formatter.field("lexicon_names", &self.lexicon_names);
        formatter.field("output_format", &self.output_format);
        formatter.field("output_s3_bucket_name", &self.output_s3_bucket_name);
        formatter.field("output_s3_key_prefix", &self.output_s3_key_prefix);
        formatter.field("sample_rate", &self.sample_rate);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("speech_mark_types", &self.speech_mark_types);
        formatter.field("text", &self.text);
        formatter.field("text_type", &self.text_type);
        formatter.field("voice_id", &self.voice_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLexiconInput {
    /// <p>Name of the lexicon. The name must follow the regular express
    /// format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive
    /// alphanumeric string up to 20 characters long. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Content of the PLS lexicon as string data.</p>
    pub content: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutLexiconInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLexiconInput");
        formatter.field("name", &self.name);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSpeechSynthesisTasksInput {
    /// <p>Maximum number of speech synthesis tasks returned in a List
    /// operation.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use in the next request to continue the
    /// listing of speech synthesis tasks. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Status of the speech synthesis tasks returned in a List
    /// operation</p>
    pub status: std::option::Option<crate::model::TaskStatus>,
}
impl std::fmt::Debug for ListSpeechSynthesisTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSpeechSynthesisTasksInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLexiconsInput {
    /// <p>An opaque pagination token returned from previous
    /// <code>ListLexicons</code> operation. If present, indicates where to
    /// continue the list of lexicons.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLexiconsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLexiconsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSpeechSynthesisTaskInput {
    /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSpeechSynthesisTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSpeechSynthesisTaskInput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLexiconInput {
    /// <p>Name of the lexicon.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLexiconInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLexiconInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVoicesInput {
    /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
    /// used by Amazon Polly when processing input text for speech synthesis. </p>
    pub engine: std::option::Option<crate::model::Engine>,
    /// <p> The language identification tag (ISO 639 code for the language
    /// name-ISO 3166 country code) for filtering the list of voices returned. If
    /// you don't specify this optional parameter, all available voices are
    /// returned. </p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>Boolean value indicating whether to return any bilingual voices that
    /// use the specified language as an additional language. For instance, if you
    /// request all languages that use US English (es-US), and there is an Italian
    /// voice that speaks both Italian (it-IT) and US English, that voice will be
    /// included if you specify <code>yes</code> but not if you specify
    /// <code>no</code>.</p>
    pub include_additional_language_codes: bool,
    /// <p>An opaque pagination token returned from the previous
    /// <code>DescribeVoices</code> operation. If present, this indicates where
    /// to continue the listing.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeVoicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVoicesInput");
        formatter.field("engine", &self.engine);
        formatter.field("language_code", &self.language_code);
        formatter.field(
            "include_additional_language_codes",
            &self.include_additional_language_codes,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLexiconInput {
    /// <p>The name of the lexicon to delete. Must be an existing lexicon in
    /// the region.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLexiconInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLexiconInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
