// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DeleteLexicon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLexiconError {
    /// Kind of error that occurred.
    pub kind: DeleteLexiconErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLexicon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLexiconErrorKind {
    /// <p>Amazon Polly can't find the specified lexicon. This could be caused by a
    /// lexicon that is missing, its name is misspelled or specifying a lexicon
    /// that is in a different region.</p>
    /// <p>Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name is spelled
    /// correctly. Then try again.</p>
    LexiconNotFoundException(crate::error::LexiconNotFoundException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLexiconError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLexiconErrorKind::LexiconNotFoundException(_inner) => _inner.fmt(f),
            DeleteLexiconErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteLexiconErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLexiconError {
    fn code(&self) -> Option<&str> {
        DeleteLexiconError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLexiconError {
    /// Creates a new `DeleteLexiconError`.
    pub fn new(kind: DeleteLexiconErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLexiconError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLexiconErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLexiconError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLexiconErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLexiconErrorKind::LexiconNotFoundException`.
    pub fn is_lexicon_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLexiconErrorKind::LexiconNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLexiconErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLexiconErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteLexiconError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLexiconErrorKind::LexiconNotFoundException(_inner) => Some(_inner),
            DeleteLexiconErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteLexiconErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVoices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVoicesError {
    /// Kind of error that occurred.
    pub kind: DescribeVoicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVoices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVoicesErrorKind {
    /// <p>The NextToken is invalid. Verify that it's spelled correctly, and
    /// then try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVoicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVoicesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeVoicesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeVoicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVoicesError {
    fn code(&self) -> Option<&str> {
        DescribeVoicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVoicesError {
    /// Creates a new `DescribeVoicesError`.
    pub fn new(kind: DescribeVoicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVoicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVoicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVoicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVoicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeVoicesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVoicesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeVoicesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVoicesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DescribeVoicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVoicesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeVoicesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeVoicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLexicon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLexiconError {
    /// Kind of error that occurred.
    pub kind: GetLexiconErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLexicon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLexiconErrorKind {
    /// <p>Amazon Polly can't find the specified lexicon. This could be caused by a
    /// lexicon that is missing, its name is misspelled or specifying a lexicon
    /// that is in a different region.</p>
    /// <p>Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name is spelled
    /// correctly. Then try again.</p>
    LexiconNotFoundException(crate::error::LexiconNotFoundException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLexiconError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLexiconErrorKind::LexiconNotFoundException(_inner) => _inner.fmt(f),
            GetLexiconErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetLexiconErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLexiconError {
    fn code(&self) -> Option<&str> {
        GetLexiconError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLexiconError {
    /// Creates a new `GetLexiconError`.
    pub fn new(kind: GetLexiconErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLexiconError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLexiconErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLexiconError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLexiconErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLexiconErrorKind::LexiconNotFoundException`.
    pub fn is_lexicon_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLexiconErrorKind::LexiconNotFoundException(_))
    }
    /// Returns true if the error kind is `GetLexiconErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetLexiconErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for GetLexiconError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLexiconErrorKind::LexiconNotFoundException(_inner) => Some(_inner),
            GetLexiconErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetLexiconErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSpeechSynthesisTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSpeechSynthesisTaskError {
    /// Kind of error that occurred.
    pub kind: GetSpeechSynthesisTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSpeechSynthesisTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSpeechSynthesisTaskErrorKind {
    /// <p>The provided Task ID is not valid. Please provide a valid Task ID and
    /// try again.</p>
    InvalidTaskIdException(crate::error::InvalidTaskIdException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The Speech Synthesis task with requested Task ID cannot be
    /// found.</p>
    SynthesisTaskNotFoundException(crate::error::SynthesisTaskNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSpeechSynthesisTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSpeechSynthesisTaskErrorKind::InvalidTaskIdException(_inner) => _inner.fmt(f),
            GetSpeechSynthesisTaskErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetSpeechSynthesisTaskErrorKind::SynthesisTaskNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetSpeechSynthesisTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSpeechSynthesisTaskError {
    fn code(&self) -> Option<&str> {
        GetSpeechSynthesisTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSpeechSynthesisTaskError {
    /// Creates a new `GetSpeechSynthesisTaskError`.
    pub fn new(kind: GetSpeechSynthesisTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSpeechSynthesisTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSpeechSynthesisTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSpeechSynthesisTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSpeechSynthesisTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSpeechSynthesisTaskErrorKind::InvalidTaskIdException`.
    pub fn is_invalid_task_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSpeechSynthesisTaskErrorKind::InvalidTaskIdException(_)
        )
    }
    /// Returns true if the error kind is `GetSpeechSynthesisTaskErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSpeechSynthesisTaskErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetSpeechSynthesisTaskErrorKind::SynthesisTaskNotFoundException`.
    pub fn is_synthesis_task_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSpeechSynthesisTaskErrorKind::SynthesisTaskNotFoundException(_)
        )
    }
}
impl std::error::Error for GetSpeechSynthesisTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSpeechSynthesisTaskErrorKind::InvalidTaskIdException(_inner) => Some(_inner),
            GetSpeechSynthesisTaskErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetSpeechSynthesisTaskErrorKind::SynthesisTaskNotFoundException(_inner) => Some(_inner),
            GetSpeechSynthesisTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLexicons` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLexiconsError {
    /// Kind of error that occurred.
    pub kind: ListLexiconsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLexicons` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLexiconsErrorKind {
    /// <p>The NextToken is invalid. Verify that it's spelled correctly, and
    /// then try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLexiconsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLexiconsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListLexiconsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListLexiconsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLexiconsError {
    fn code(&self) -> Option<&str> {
        ListLexiconsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLexiconsError {
    /// Creates a new `ListLexiconsError`.
    pub fn new(kind: ListLexiconsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLexiconsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLexiconsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLexiconsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLexiconsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLexiconsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLexiconsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListLexiconsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLexiconsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListLexiconsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLexiconsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListLexiconsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListLexiconsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSpeechSynthesisTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSpeechSynthesisTasksError {
    /// Kind of error that occurred.
    pub kind: ListSpeechSynthesisTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSpeechSynthesisTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSpeechSynthesisTasksErrorKind {
    /// <p>The NextToken is invalid. Verify that it's spelled correctly, and
    /// then try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSpeechSynthesisTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSpeechSynthesisTasksErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListSpeechSynthesisTasksErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListSpeechSynthesisTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSpeechSynthesisTasksError {
    fn code(&self) -> Option<&str> {
        ListSpeechSynthesisTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSpeechSynthesisTasksError {
    /// Creates a new `ListSpeechSynthesisTasksError`.
    pub fn new(kind: ListSpeechSynthesisTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSpeechSynthesisTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSpeechSynthesisTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSpeechSynthesisTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSpeechSynthesisTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSpeechSynthesisTasksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeechSynthesisTasksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListSpeechSynthesisTasksErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeechSynthesisTasksErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListSpeechSynthesisTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSpeechSynthesisTasksErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListSpeechSynthesisTasksErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListSpeechSynthesisTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLexicon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLexiconError {
    /// Kind of error that occurred.
    pub kind: PutLexiconErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLexicon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLexiconErrorKind {
    /// <p>Amazon Polly can't find the specified lexicon. Verify that the lexicon's
    /// name is spelled correctly, and then try again.</p>
    InvalidLexiconException(crate::error::InvalidLexiconException),
    /// <p>The maximum size of the specified lexicon would be exceeded by this
    /// operation.</p>
    LexiconSizeExceededException(crate::error::LexiconSizeExceededException),
    /// <p>The maximum size of the lexeme would be exceeded by this
    /// operation.</p>
    MaxLexemeLengthExceededException(crate::error::MaxLexemeLengthExceededException),
    /// <p>The maximum number of lexicons would be exceeded by this
    /// operation.</p>
    MaxLexiconsNumberExceededException(crate::error::MaxLexiconsNumberExceededException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The alphabet specified by the lexicon is not a supported alphabet.
    /// Valid values are <code>x-sampa</code> and <code>ipa</code>.</p>
    UnsupportedPlsAlphabetException(crate::error::UnsupportedPlsAlphabetException),
    /// <p>The language specified in the lexicon is unsupported. For a list of
    /// supported languages, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html">Lexicon Attributes</a>.</p>
    UnsupportedPlsLanguageException(crate::error::UnsupportedPlsLanguageException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLexiconError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLexiconErrorKind::InvalidLexiconException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::LexiconSizeExceededException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::MaxLexemeLengthExceededException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::MaxLexiconsNumberExceededException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::UnsupportedPlsAlphabetException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::UnsupportedPlsLanguageException(_inner) => _inner.fmt(f),
            PutLexiconErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLexiconError {
    fn code(&self) -> Option<&str> {
        PutLexiconError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLexiconError {
    /// Creates a new `PutLexiconError`.
    pub fn new(kind: PutLexiconErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLexiconError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLexiconErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLexiconError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLexiconErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::InvalidLexiconException`.
    pub fn is_invalid_lexicon_exception(&self) -> bool {
        matches!(&self.kind, PutLexiconErrorKind::InvalidLexiconException(_))
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::LexiconSizeExceededException`.
    pub fn is_lexicon_size_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLexiconErrorKind::LexiconSizeExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::MaxLexemeLengthExceededException`.
    pub fn is_max_lexeme_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLexiconErrorKind::MaxLexemeLengthExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::MaxLexiconsNumberExceededException`.
    pub fn is_max_lexicons_number_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLexiconErrorKind::MaxLexiconsNumberExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, PutLexiconErrorKind::ServiceFailureException(_))
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::UnsupportedPlsAlphabetException`.
    pub fn is_unsupported_pls_alphabet_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLexiconErrorKind::UnsupportedPlsAlphabetException(_)
        )
    }
    /// Returns true if the error kind is `PutLexiconErrorKind::UnsupportedPlsLanguageException`.
    pub fn is_unsupported_pls_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLexiconErrorKind::UnsupportedPlsLanguageException(_)
        )
    }
}
impl std::error::Error for PutLexiconError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLexiconErrorKind::InvalidLexiconException(_inner) => Some(_inner),
            PutLexiconErrorKind::LexiconSizeExceededException(_inner) => Some(_inner),
            PutLexiconErrorKind::MaxLexemeLengthExceededException(_inner) => Some(_inner),
            PutLexiconErrorKind::MaxLexiconsNumberExceededException(_inner) => Some(_inner),
            PutLexiconErrorKind::ServiceFailureException(_inner) => Some(_inner),
            PutLexiconErrorKind::UnsupportedPlsAlphabetException(_inner) => Some(_inner),
            PutLexiconErrorKind::UnsupportedPlsLanguageException(_inner) => Some(_inner),
            PutLexiconErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSpeechSynthesisTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSpeechSynthesisTaskError {
    /// Kind of error that occurred.
    pub kind: StartSpeechSynthesisTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSpeechSynthesisTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSpeechSynthesisTaskErrorKind {
    /// <p>This engine is not compatible with the voice that you have designated.
    /// Choose a new voice that is compatible with the engine or change the engine
    /// and restart the operation.</p>
    EngineNotSupportedException(crate::error::EngineNotSupportedException),
    /// <p>The provided Amazon S3 bucket name is invalid. Please check your input
    /// with S3 bucket naming requirements and try again.</p>
    InvalidS3BucketException(crate::error::InvalidS3BucketException),
    /// <p>The provided Amazon S3 key prefix is invalid. Please provide a valid
    /// S3 object key name.</p>
    InvalidS3KeyException(crate::error::InvalidS3KeyException),
    /// <p>The specified sample rate is not valid.</p>
    InvalidSampleRateException(crate::error::InvalidSampleRateException),
    /// <p>The provided SNS topic ARN is invalid. Please provide a valid SNS
    /// topic ARN and try again.</p>
    InvalidSnsTopicArnException(crate::error::InvalidSnsTopicArnException),
    /// <p>The SSML you provided is invalid. Verify the SSML syntax, spelling
    /// of tags and values, and then try again.</p>
    InvalidSsmlException(crate::error::InvalidSsmlException),
    /// <p>The language specified is not currently supported by Amazon Polly in this
    /// capacity.</p>
    LanguageNotSupportedException(crate::error::LanguageNotSupportedException),
    /// <p>Amazon Polly can't find the specified lexicon. This could be caused by a
    /// lexicon that is missing, its name is misspelled or specifying a lexicon
    /// that is in a different region.</p>
    /// <p>Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name is spelled
    /// correctly. Then try again.</p>
    LexiconNotFoundException(crate::error::LexiconNotFoundException),
    /// <p>Speech marks are not supported for the <code>OutputFormat</code>
    /// selected. Speech marks are only available for content in <code>json</code>
    /// format.</p>
    MarksNotSupportedForFormatException(crate::error::MarksNotSupportedForFormatException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>SSML speech marks are not supported for plain text-type
    /// input.</p>
    SsmlMarksNotSupportedForTextTypeException(
        crate::error::SsmlMarksNotSupportedForTextTypeException,
    ),
    /// <p>The value of the "Text" parameter is longer than the accepted
    /// limits. For the <code>SynthesizeSpeech</code> API, the limit for input
    /// text is a maximum of 6000 characters total, of which no more than 3000 can
    /// be billed characters. For the <code>StartSpeechSynthesisTask</code> API,
    /// the maximum is 200,000 characters, of which no more than 100,000 can be
    /// billed characters. SSML tags are not counted as billed
    /// characters.</p>
    TextLengthExceededException(crate::error::TextLengthExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSpeechSynthesisTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSpeechSynthesisTaskErrorKind::EngineNotSupportedException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::InvalidS3BucketException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::InvalidS3KeyException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::InvalidSampleRateException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::InvalidSnsTopicArnException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::InvalidSsmlException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::LanguageNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            StartSpeechSynthesisTaskErrorKind::LexiconNotFoundException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::MarksNotSupportedForFormatException(_inner) => {
                _inner.fmt(f)
            }
            StartSpeechSynthesisTaskErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::SsmlMarksNotSupportedForTextTypeException(
                _inner,
            ) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::TextLengthExceededException(_inner) => _inner.fmt(f),
            StartSpeechSynthesisTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSpeechSynthesisTaskError {
    fn code(&self) -> Option<&str> {
        StartSpeechSynthesisTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSpeechSynthesisTaskError {
    /// Creates a new `StartSpeechSynthesisTaskError`.
    pub fn new(kind: StartSpeechSynthesisTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSpeechSynthesisTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSpeechSynthesisTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSpeechSynthesisTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSpeechSynthesisTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::EngineNotSupportedException`.
    pub fn is_engine_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::EngineNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::InvalidS3BucketException`.
    pub fn is_invalid_s3_bucket_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::InvalidS3BucketException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::InvalidS3KeyException`.
    pub fn is_invalid_s3_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::InvalidS3KeyException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::InvalidSampleRateException`.
    pub fn is_invalid_sample_rate_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::InvalidSampleRateException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::InvalidSnsTopicArnException`.
    pub fn is_invalid_sns_topic_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::InvalidSnsTopicArnException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::InvalidSsmlException`.
    pub fn is_invalid_ssml_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::InvalidSsmlException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::LanguageNotSupportedException`.
    pub fn is_language_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::LanguageNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::LexiconNotFoundException`.
    pub fn is_lexicon_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::LexiconNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::MarksNotSupportedForFormatException`.
    pub fn is_marks_not_supported_for_format_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::MarksNotSupportedForFormatException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::SsmlMarksNotSupportedForTextTypeException`.
    pub fn is_ssml_marks_not_supported_for_text_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::SsmlMarksNotSupportedForTextTypeException(_)
        )
    }
    /// Returns true if the error kind is `StartSpeechSynthesisTaskErrorKind::TextLengthExceededException`.
    pub fn is_text_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeechSynthesisTaskErrorKind::TextLengthExceededException(_)
        )
    }
}
impl std::error::Error for StartSpeechSynthesisTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSpeechSynthesisTaskErrorKind::EngineNotSupportedException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::InvalidS3BucketException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::InvalidS3KeyException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::InvalidSampleRateException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::InvalidSnsTopicArnException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::InvalidSsmlException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::LanguageNotSupportedException(_inner) => {
                Some(_inner)
            }
            StartSpeechSynthesisTaskErrorKind::LexiconNotFoundException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::MarksNotSupportedForFormatException(_inner) => {
                Some(_inner)
            }
            StartSpeechSynthesisTaskErrorKind::ServiceFailureException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::SsmlMarksNotSupportedForTextTypeException(
                _inner,
            ) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::TextLengthExceededException(_inner) => Some(_inner),
            StartSpeechSynthesisTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SynthesizeSpeech` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SynthesizeSpeechError {
    /// Kind of error that occurred.
    pub kind: SynthesizeSpeechErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SynthesizeSpeech` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SynthesizeSpeechErrorKind {
    /// <p>This engine is not compatible with the voice that you have designated.
    /// Choose a new voice that is compatible with the engine or change the engine
    /// and restart the operation.</p>
    EngineNotSupportedException(crate::error::EngineNotSupportedException),
    /// <p>The specified sample rate is not valid.</p>
    InvalidSampleRateException(crate::error::InvalidSampleRateException),
    /// <p>The SSML you provided is invalid. Verify the SSML syntax, spelling
    /// of tags and values, and then try again.</p>
    InvalidSsmlException(crate::error::InvalidSsmlException),
    /// <p>The language specified is not currently supported by Amazon Polly in this
    /// capacity.</p>
    LanguageNotSupportedException(crate::error::LanguageNotSupportedException),
    /// <p>Amazon Polly can't find the specified lexicon. This could be caused by a
    /// lexicon that is missing, its name is misspelled or specifying a lexicon
    /// that is in a different region.</p>
    /// <p>Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name is spelled
    /// correctly. Then try again.</p>
    LexiconNotFoundException(crate::error::LexiconNotFoundException),
    /// <p>Speech marks are not supported for the <code>OutputFormat</code>
    /// selected. Speech marks are only available for content in <code>json</code>
    /// format.</p>
    MarksNotSupportedForFormatException(crate::error::MarksNotSupportedForFormatException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>SSML speech marks are not supported for plain text-type
    /// input.</p>
    SsmlMarksNotSupportedForTextTypeException(
        crate::error::SsmlMarksNotSupportedForTextTypeException,
    ),
    /// <p>The value of the "Text" parameter is longer than the accepted
    /// limits. For the <code>SynthesizeSpeech</code> API, the limit for input
    /// text is a maximum of 6000 characters total, of which no more than 3000 can
    /// be billed characters. For the <code>StartSpeechSynthesisTask</code> API,
    /// the maximum is 200,000 characters, of which no more than 100,000 can be
    /// billed characters. SSML tags are not counted as billed
    /// characters.</p>
    TextLengthExceededException(crate::error::TextLengthExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SynthesizeSpeechError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SynthesizeSpeechErrorKind::EngineNotSupportedException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::InvalidSampleRateException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::InvalidSsmlException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::LanguageNotSupportedException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::LexiconNotFoundException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::MarksNotSupportedForFormatException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::SsmlMarksNotSupportedForTextTypeException(_inner) => {
                _inner.fmt(f)
            }
            SynthesizeSpeechErrorKind::TextLengthExceededException(_inner) => _inner.fmt(f),
            SynthesizeSpeechErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SynthesizeSpeechError {
    fn code(&self) -> Option<&str> {
        SynthesizeSpeechError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SynthesizeSpeechError {
    /// Creates a new `SynthesizeSpeechError`.
    pub fn new(kind: SynthesizeSpeechErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SynthesizeSpeechError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SynthesizeSpeechErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SynthesizeSpeechError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SynthesizeSpeechErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::EngineNotSupportedException`.
    pub fn is_engine_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::EngineNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::InvalidSampleRateException`.
    pub fn is_invalid_sample_rate_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::InvalidSampleRateException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::InvalidSsmlException`.
    pub fn is_invalid_ssml_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::InvalidSsmlException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::LanguageNotSupportedException`.
    pub fn is_language_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::LanguageNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::LexiconNotFoundException`.
    pub fn is_lexicon_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::LexiconNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::MarksNotSupportedForFormatException`.
    pub fn is_marks_not_supported_for_format_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::MarksNotSupportedForFormatException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::SsmlMarksNotSupportedForTextTypeException`.
    pub fn is_ssml_marks_not_supported_for_text_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::SsmlMarksNotSupportedForTextTypeException(_)
        )
    }
    /// Returns true if the error kind is `SynthesizeSpeechErrorKind::TextLengthExceededException`.
    pub fn is_text_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SynthesizeSpeechErrorKind::TextLengthExceededException(_)
        )
    }
}
impl std::error::Error for SynthesizeSpeechError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SynthesizeSpeechErrorKind::EngineNotSupportedException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::InvalidSampleRateException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::InvalidSsmlException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::LanguageNotSupportedException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::LexiconNotFoundException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::MarksNotSupportedForFormatException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::ServiceFailureException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::SsmlMarksNotSupportedForTextTypeException(_inner) => {
                Some(_inner)
            }
            SynthesizeSpeechErrorKind::TextLengthExceededException(_inner) => Some(_inner),
            SynthesizeSpeechErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The value of the "Text" parameter is longer than the accepted
/// limits. For the <code>SynthesizeSpeech</code> API, the limit for input
/// text is a maximum of 6000 characters total, of which no more than 3000 can
/// be billed characters. For the <code>StartSpeechSynthesisTask</code> API,
/// the maximum is 200,000 characters, of which no more than 100,000 can be
/// billed characters. SSML tags are not counted as billed
/// characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextLengthExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TextLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextLengthExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TextLengthExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TextLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TextLengthExceededException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TextLengthExceededException {}
/// See [`TextLengthExceededException`](crate::error::TextLengthExceededException)
pub mod text_length_exceeded_exception {
    /// A builder for [`TextLengthExceededException`](crate::error::TextLengthExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TextLengthExceededException`](crate::error::TextLengthExceededException)
        pub fn build(self) -> crate::error::TextLengthExceededException {
            crate::error::TextLengthExceededException {
                message: self.message,
            }
        }
    }
}
impl TextLengthExceededException {
    /// Creates a new builder-style object to manufacture [`TextLengthExceededException`](crate::error::TextLengthExceededException)
    pub fn builder() -> crate::error::text_length_exceeded_exception::Builder {
        crate::error::text_length_exceeded_exception::Builder::default()
    }
}

/// <p>SSML speech marks are not supported for plain text-type
/// input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmlMarksNotSupportedForTextTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SsmlMarksNotSupportedForTextTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmlMarksNotSupportedForTextTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SsmlMarksNotSupportedForTextTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SsmlMarksNotSupportedForTextTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SsmlMarksNotSupportedForTextTypeException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for SsmlMarksNotSupportedForTextTypeException {}
/// See [`SsmlMarksNotSupportedForTextTypeException`](crate::error::SsmlMarksNotSupportedForTextTypeException)
pub mod ssml_marks_not_supported_for_text_type_exception {
    /// A builder for [`SsmlMarksNotSupportedForTextTypeException`](crate::error::SsmlMarksNotSupportedForTextTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmlMarksNotSupportedForTextTypeException`](crate::error::SsmlMarksNotSupportedForTextTypeException)
        pub fn build(self) -> crate::error::SsmlMarksNotSupportedForTextTypeException {
            crate::error::SsmlMarksNotSupportedForTextTypeException {
                message: self.message,
            }
        }
    }
}
impl SsmlMarksNotSupportedForTextTypeException {
    /// Creates a new builder-style object to manufacture [`SsmlMarksNotSupportedForTextTypeException`](crate::error::SsmlMarksNotSupportedForTextTypeException)
    pub fn builder() -> crate::error::ssml_marks_not_supported_for_text_type_exception::Builder {
        crate::error::ssml_marks_not_supported_for_text_type_exception::Builder::default()
    }
}

/// <p>An unknown condition has caused a service failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceFailureException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceFailureException {}
/// See [`ServiceFailureException`](crate::error::ServiceFailureException)
pub mod service_failure_exception {
    /// A builder for [`ServiceFailureException`](crate::error::ServiceFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceFailureException`](crate::error::ServiceFailureException)
        pub fn build(self) -> crate::error::ServiceFailureException {
            crate::error::ServiceFailureException {
                message: self.message,
            }
        }
    }
}
impl ServiceFailureException {
    /// Creates a new builder-style object to manufacture [`ServiceFailureException`](crate::error::ServiceFailureException)
    pub fn builder() -> crate::error::service_failure_exception::Builder {
        crate::error::service_failure_exception::Builder::default()
    }
}

/// <p>Speech marks are not supported for the <code>OutputFormat</code>
/// selected. Speech marks are only available for content in <code>json</code>
/// format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarksNotSupportedForFormatException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MarksNotSupportedForFormatException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarksNotSupportedForFormatException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MarksNotSupportedForFormatException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MarksNotSupportedForFormatException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MarksNotSupportedForFormatException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for MarksNotSupportedForFormatException {}
/// See [`MarksNotSupportedForFormatException`](crate::error::MarksNotSupportedForFormatException)
pub mod marks_not_supported_for_format_exception {
    /// A builder for [`MarksNotSupportedForFormatException`](crate::error::MarksNotSupportedForFormatException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MarksNotSupportedForFormatException`](crate::error::MarksNotSupportedForFormatException)
        pub fn build(self) -> crate::error::MarksNotSupportedForFormatException {
            crate::error::MarksNotSupportedForFormatException {
                message: self.message,
            }
        }
    }
}
impl MarksNotSupportedForFormatException {
    /// Creates a new builder-style object to manufacture [`MarksNotSupportedForFormatException`](crate::error::MarksNotSupportedForFormatException)
    pub fn builder() -> crate::error::marks_not_supported_for_format_exception::Builder {
        crate::error::marks_not_supported_for_format_exception::Builder::default()
    }
}

/// <p>Amazon Polly can't find the specified lexicon. This could be caused by a
/// lexicon that is missing, its name is misspelled or specifying a lexicon
/// that is in a different region.</p>
/// <p>Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name is spelled
/// correctly. Then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LexiconNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LexiconNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LexiconNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LexiconNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LexiconNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LexiconNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LexiconNotFoundException {}
/// See [`LexiconNotFoundException`](crate::error::LexiconNotFoundException)
pub mod lexicon_not_found_exception {
    /// A builder for [`LexiconNotFoundException`](crate::error::LexiconNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LexiconNotFoundException`](crate::error::LexiconNotFoundException)
        pub fn build(self) -> crate::error::LexiconNotFoundException {
            crate::error::LexiconNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LexiconNotFoundException {
    /// Creates a new builder-style object to manufacture [`LexiconNotFoundException`](crate::error::LexiconNotFoundException)
    pub fn builder() -> crate::error::lexicon_not_found_exception::Builder {
        crate::error::lexicon_not_found_exception::Builder::default()
    }
}

/// <p>The language specified is not currently supported by Amazon Polly in this
/// capacity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LanguageNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LanguageNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LanguageNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LanguageNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LanguageNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LanguageNotSupportedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LanguageNotSupportedException {}
/// See [`LanguageNotSupportedException`](crate::error::LanguageNotSupportedException)
pub mod language_not_supported_exception {
    /// A builder for [`LanguageNotSupportedException`](crate::error::LanguageNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LanguageNotSupportedException`](crate::error::LanguageNotSupportedException)
        pub fn build(self) -> crate::error::LanguageNotSupportedException {
            crate::error::LanguageNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl LanguageNotSupportedException {
    /// Creates a new builder-style object to manufacture [`LanguageNotSupportedException`](crate::error::LanguageNotSupportedException)
    pub fn builder() -> crate::error::language_not_supported_exception::Builder {
        crate::error::language_not_supported_exception::Builder::default()
    }
}

/// <p>The SSML you provided is invalid. Verify the SSML syntax, spelling
/// of tags and values, and then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSsmlException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSsmlException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSsmlException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSsmlException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSsmlException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSsmlException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSsmlException {}
/// See [`InvalidSsmlException`](crate::error::InvalidSsmlException)
pub mod invalid_ssml_exception {
    /// A builder for [`InvalidSsmlException`](crate::error::InvalidSsmlException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSsmlException`](crate::error::InvalidSsmlException)
        pub fn build(self) -> crate::error::InvalidSsmlException {
            crate::error::InvalidSsmlException {
                message: self.message,
            }
        }
    }
}
impl InvalidSsmlException {
    /// Creates a new builder-style object to manufacture [`InvalidSsmlException`](crate::error::InvalidSsmlException)
    pub fn builder() -> crate::error::invalid_ssml_exception::Builder {
        crate::error::invalid_ssml_exception::Builder::default()
    }
}

/// <p>The specified sample rate is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSampleRateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSampleRateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSampleRateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSampleRateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSampleRateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSampleRateException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSampleRateException {}
/// See [`InvalidSampleRateException`](crate::error::InvalidSampleRateException)
pub mod invalid_sample_rate_exception {
    /// A builder for [`InvalidSampleRateException`](crate::error::InvalidSampleRateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSampleRateException`](crate::error::InvalidSampleRateException)
        pub fn build(self) -> crate::error::InvalidSampleRateException {
            crate::error::InvalidSampleRateException {
                message: self.message,
            }
        }
    }
}
impl InvalidSampleRateException {
    /// Creates a new builder-style object to manufacture [`InvalidSampleRateException`](crate::error::InvalidSampleRateException)
    pub fn builder() -> crate::error::invalid_sample_rate_exception::Builder {
        crate::error::invalid_sample_rate_exception::Builder::default()
    }
}

/// <p>This engine is not compatible with the voice that you have designated.
/// Choose a new voice that is compatible with the engine or change the engine
/// and restart the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EngineNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EngineNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EngineNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EngineNotSupportedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for EngineNotSupportedException {}
/// See [`EngineNotSupportedException`](crate::error::EngineNotSupportedException)
pub mod engine_not_supported_exception {
    /// A builder for [`EngineNotSupportedException`](crate::error::EngineNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineNotSupportedException`](crate::error::EngineNotSupportedException)
        pub fn build(self) -> crate::error::EngineNotSupportedException {
            crate::error::EngineNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl EngineNotSupportedException {
    /// Creates a new builder-style object to manufacture [`EngineNotSupportedException`](crate::error::EngineNotSupportedException)
    pub fn builder() -> crate::error::engine_not_supported_exception::Builder {
        crate::error::engine_not_supported_exception::Builder::default()
    }
}

/// <p>The provided SNS topic ARN is invalid. Please provide a valid SNS
/// topic ARN and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnsTopicArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnsTopicArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnsTopicArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnsTopicArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnsTopicArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSnsTopicArnException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnsTopicArnException {}
/// See [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
pub mod invalid_sns_topic_arn_exception {
    /// A builder for [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
        pub fn build(self) -> crate::error::InvalidSnsTopicArnException {
            crate::error::InvalidSnsTopicArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidSnsTopicArnException {
    /// Creates a new builder-style object to manufacture [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
    pub fn builder() -> crate::error::invalid_sns_topic_arn_exception::Builder {
        crate::error::invalid_sns_topic_arn_exception::Builder::default()
    }
}

/// <p>The provided Amazon S3 key prefix is invalid. Please provide a valid
/// S3 object key name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3KeyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3KeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3KeyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3KeyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3KeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3KeyException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3KeyException {}
/// See [`InvalidS3KeyException`](crate::error::InvalidS3KeyException)
pub mod invalid_s3_key_exception {
    /// A builder for [`InvalidS3KeyException`](crate::error::InvalidS3KeyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3KeyException`](crate::error::InvalidS3KeyException)
        pub fn build(self) -> crate::error::InvalidS3KeyException {
            crate::error::InvalidS3KeyException {
                message: self.message,
            }
        }
    }
}
impl InvalidS3KeyException {
    /// Creates a new builder-style object to manufacture [`InvalidS3KeyException`](crate::error::InvalidS3KeyException)
    pub fn builder() -> crate::error::invalid_s3_key_exception::Builder {
        crate::error::invalid_s3_key_exception::Builder::default()
    }
}

/// <p>The provided Amazon S3 bucket name is invalid. Please check your input
/// with S3 bucket naming requirements and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3BucketException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3BucketException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3BucketException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3BucketException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3BucketException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3BucketException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3BucketException {}
/// See [`InvalidS3BucketException`](crate::error::InvalidS3BucketException)
pub mod invalid_s3_bucket_exception {
    /// A builder for [`InvalidS3BucketException`](crate::error::InvalidS3BucketException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3BucketException`](crate::error::InvalidS3BucketException)
        pub fn build(self) -> crate::error::InvalidS3BucketException {
            crate::error::InvalidS3BucketException {
                message: self.message,
            }
        }
    }
}
impl InvalidS3BucketException {
    /// Creates a new builder-style object to manufacture [`InvalidS3BucketException`](crate::error::InvalidS3BucketException)
    pub fn builder() -> crate::error::invalid_s3_bucket_exception::Builder {
        crate::error::invalid_s3_bucket_exception::Builder::default()
    }
}

/// <p>The language specified in the lexicon is unsupported. For a list of
/// supported languages, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html">Lexicon Attributes</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedPlsLanguageException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedPlsLanguageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedPlsLanguageException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedPlsLanguageException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedPlsLanguageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedPlsLanguageException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedPlsLanguageException {}
/// See [`UnsupportedPlsLanguageException`](crate::error::UnsupportedPlsLanguageException)
pub mod unsupported_pls_language_exception {
    /// A builder for [`UnsupportedPlsLanguageException`](crate::error::UnsupportedPlsLanguageException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedPlsLanguageException`](crate::error::UnsupportedPlsLanguageException)
        pub fn build(self) -> crate::error::UnsupportedPlsLanguageException {
            crate::error::UnsupportedPlsLanguageException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedPlsLanguageException {
    /// Creates a new builder-style object to manufacture [`UnsupportedPlsLanguageException`](crate::error::UnsupportedPlsLanguageException)
    pub fn builder() -> crate::error::unsupported_pls_language_exception::Builder {
        crate::error::unsupported_pls_language_exception::Builder::default()
    }
}

/// <p>The alphabet specified by the lexicon is not a supported alphabet.
/// Valid values are <code>x-sampa</code> and <code>ipa</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedPlsAlphabetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedPlsAlphabetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedPlsAlphabetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedPlsAlphabetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedPlsAlphabetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedPlsAlphabetException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedPlsAlphabetException {}
/// See [`UnsupportedPlsAlphabetException`](crate::error::UnsupportedPlsAlphabetException)
pub mod unsupported_pls_alphabet_exception {
    /// A builder for [`UnsupportedPlsAlphabetException`](crate::error::UnsupportedPlsAlphabetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedPlsAlphabetException`](crate::error::UnsupportedPlsAlphabetException)
        pub fn build(self) -> crate::error::UnsupportedPlsAlphabetException {
            crate::error::UnsupportedPlsAlphabetException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedPlsAlphabetException {
    /// Creates a new builder-style object to manufacture [`UnsupportedPlsAlphabetException`](crate::error::UnsupportedPlsAlphabetException)
    pub fn builder() -> crate::error::unsupported_pls_alphabet_exception::Builder {
        crate::error::unsupported_pls_alphabet_exception::Builder::default()
    }
}

/// <p>The maximum number of lexicons would be exceeded by this
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxLexiconsNumberExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxLexiconsNumberExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxLexiconsNumberExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxLexiconsNumberExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxLexiconsNumberExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxLexiconsNumberExceededException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxLexiconsNumberExceededException {}
/// See [`MaxLexiconsNumberExceededException`](crate::error::MaxLexiconsNumberExceededException)
pub mod max_lexicons_number_exceeded_exception {
    /// A builder for [`MaxLexiconsNumberExceededException`](crate::error::MaxLexiconsNumberExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxLexiconsNumberExceededException`](crate::error::MaxLexiconsNumberExceededException)
        pub fn build(self) -> crate::error::MaxLexiconsNumberExceededException {
            crate::error::MaxLexiconsNumberExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxLexiconsNumberExceededException {
    /// Creates a new builder-style object to manufacture [`MaxLexiconsNumberExceededException`](crate::error::MaxLexiconsNumberExceededException)
    pub fn builder() -> crate::error::max_lexicons_number_exceeded_exception::Builder {
        crate::error::max_lexicons_number_exceeded_exception::Builder::default()
    }
}

/// <p>The maximum size of the lexeme would be exceeded by this
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxLexemeLengthExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxLexemeLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxLexemeLengthExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxLexemeLengthExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxLexemeLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxLexemeLengthExceededException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxLexemeLengthExceededException {}
/// See [`MaxLexemeLengthExceededException`](crate::error::MaxLexemeLengthExceededException)
pub mod max_lexeme_length_exceeded_exception {
    /// A builder for [`MaxLexemeLengthExceededException`](crate::error::MaxLexemeLengthExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxLexemeLengthExceededException`](crate::error::MaxLexemeLengthExceededException)
        pub fn build(self) -> crate::error::MaxLexemeLengthExceededException {
            crate::error::MaxLexemeLengthExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxLexemeLengthExceededException {
    /// Creates a new builder-style object to manufacture [`MaxLexemeLengthExceededException`](crate::error::MaxLexemeLengthExceededException)
    pub fn builder() -> crate::error::max_lexeme_length_exceeded_exception::Builder {
        crate::error::max_lexeme_length_exceeded_exception::Builder::default()
    }
}

/// <p>The maximum size of the specified lexicon would be exceeded by this
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LexiconSizeExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LexiconSizeExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LexiconSizeExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LexiconSizeExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LexiconSizeExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LexiconSizeExceededException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for LexiconSizeExceededException {}
/// See [`LexiconSizeExceededException`](crate::error::LexiconSizeExceededException)
pub mod lexicon_size_exceeded_exception {
    /// A builder for [`LexiconSizeExceededException`](crate::error::LexiconSizeExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LexiconSizeExceededException`](crate::error::LexiconSizeExceededException)
        pub fn build(self) -> crate::error::LexiconSizeExceededException {
            crate::error::LexiconSizeExceededException {
                message: self.message,
            }
        }
    }
}
impl LexiconSizeExceededException {
    /// Creates a new builder-style object to manufacture [`LexiconSizeExceededException`](crate::error::LexiconSizeExceededException)
    pub fn builder() -> crate::error::lexicon_size_exceeded_exception::Builder {
        crate::error::lexicon_size_exceeded_exception::Builder::default()
    }
}

/// <p>Amazon Polly can't find the specified lexicon. Verify that the lexicon's
/// name is spelled correctly, and then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLexiconException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLexiconException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLexiconException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLexiconException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLexiconException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLexiconException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLexiconException {}
/// See [`InvalidLexiconException`](crate::error::InvalidLexiconException)
pub mod invalid_lexicon_exception {
    /// A builder for [`InvalidLexiconException`](crate::error::InvalidLexiconException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLexiconException`](crate::error::InvalidLexiconException)
        pub fn build(self) -> crate::error::InvalidLexiconException {
            crate::error::InvalidLexiconException {
                message: self.message,
            }
        }
    }
}
impl InvalidLexiconException {
    /// Creates a new builder-style object to manufacture [`InvalidLexiconException`](crate::error::InvalidLexiconException)
    pub fn builder() -> crate::error::invalid_lexicon_exception::Builder {
        crate::error::invalid_lexicon_exception::Builder::default()
    }
}

/// <p>The NextToken is invalid. Verify that it's spelled correctly, and
/// then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The Speech Synthesis task with requested Task ID cannot be
/// found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SynthesisTaskNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SynthesisTaskNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SynthesisTaskNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SynthesisTaskNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SynthesisTaskNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SynthesisTaskNotFoundException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for SynthesisTaskNotFoundException {}
/// See [`SynthesisTaskNotFoundException`](crate::error::SynthesisTaskNotFoundException)
pub mod synthesis_task_not_found_exception {
    /// A builder for [`SynthesisTaskNotFoundException`](crate::error::SynthesisTaskNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SynthesisTaskNotFoundException`](crate::error::SynthesisTaskNotFoundException)
        pub fn build(self) -> crate::error::SynthesisTaskNotFoundException {
            crate::error::SynthesisTaskNotFoundException {
                message: self.message,
            }
        }
    }
}
impl SynthesisTaskNotFoundException {
    /// Creates a new builder-style object to manufacture [`SynthesisTaskNotFoundException`](crate::error::SynthesisTaskNotFoundException)
    pub fn builder() -> crate::error::synthesis_task_not_found_exception::Builder {
        crate::error::synthesis_task_not_found_exception::Builder::default()
    }
}

/// <p>The provided Task ID is not valid. Please provide a valid Task ID and
/// try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTaskIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTaskIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTaskIdException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTaskIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTaskIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTaskIdException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTaskIdException {}
/// See [`InvalidTaskIdException`](crate::error::InvalidTaskIdException)
pub mod invalid_task_id_exception {
    /// A builder for [`InvalidTaskIdException`](crate::error::InvalidTaskIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTaskIdException`](crate::error::InvalidTaskIdException)
        pub fn build(self) -> crate::error::InvalidTaskIdException {
            crate::error::InvalidTaskIdException {
                message: self.message,
            }
        }
    }
}
impl InvalidTaskIdException {
    /// Creates a new builder-style object to manufacture [`InvalidTaskIdException`](crate::error::InvalidTaskIdException)
    pub fn builder() -> crate::error::invalid_task_id_exception::Builder {
        crate::error::invalid_task_id_exception::Builder::default()
    }
}
