// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Parrot_v1`.
///
/// This client allows ergonomic access to a `Parrot_v1`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `DeleteLexicon` operation.
    ///
    /// See [`DeleteLexicon`](crate::client::fluent_builders::DeleteLexicon) for more information about the
    /// operation and its arguments.
    pub fn delete_lexicon(&self) -> fluent_builders::DeleteLexicon<C, M, R> {
        fluent_builders::DeleteLexicon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVoices` operation.
    ///
    /// See [`DescribeVoices`](crate::client::fluent_builders::DescribeVoices) for more information about the
    /// operation and its arguments.
    pub fn describe_voices(&self) -> fluent_builders::DescribeVoices<C, M, R> {
        fluent_builders::DescribeVoices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLexicon` operation.
    ///
    /// See [`GetLexicon`](crate::client::fluent_builders::GetLexicon) for more information about the
    /// operation and its arguments.
    pub fn get_lexicon(&self) -> fluent_builders::GetLexicon<C, M, R> {
        fluent_builders::GetLexicon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSpeechSynthesisTask` operation.
    ///
    /// See [`GetSpeechSynthesisTask`](crate::client::fluent_builders::GetSpeechSynthesisTask) for more information about the
    /// operation and its arguments.
    pub fn get_speech_synthesis_task(&self) -> fluent_builders::GetSpeechSynthesisTask<C, M, R> {
        fluent_builders::GetSpeechSynthesisTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLexicons` operation.
    ///
    /// See [`ListLexicons`](crate::client::fluent_builders::ListLexicons) for more information about the
    /// operation and its arguments.
    pub fn list_lexicons(&self) -> fluent_builders::ListLexicons<C, M, R> {
        fluent_builders::ListLexicons::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSpeechSynthesisTasks` operation.
    ///
    /// See [`ListSpeechSynthesisTasks`](crate::client::fluent_builders::ListSpeechSynthesisTasks) for more information about the
    /// operation and its arguments.
    pub fn list_speech_synthesis_tasks(
        &self,
    ) -> fluent_builders::ListSpeechSynthesisTasks<C, M, R> {
        fluent_builders::ListSpeechSynthesisTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLexicon` operation.
    ///
    /// See [`PutLexicon`](crate::client::fluent_builders::PutLexicon) for more information about the
    /// operation and its arguments.
    pub fn put_lexicon(&self) -> fluent_builders::PutLexicon<C, M, R> {
        fluent_builders::PutLexicon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSpeechSynthesisTask` operation.
    ///
    /// See [`StartSpeechSynthesisTask`](crate::client::fluent_builders::StartSpeechSynthesisTask) for more information about the
    /// operation and its arguments.
    pub fn start_speech_synthesis_task(
        &self,
    ) -> fluent_builders::StartSpeechSynthesisTask<C, M, R> {
        fluent_builders::StartSpeechSynthesisTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SynthesizeSpeech` operation.
    ///
    /// See [`SynthesizeSpeech`](crate::client::fluent_builders::SynthesizeSpeech) for more information about the
    /// operation and its arguments.
    pub fn synthesize_speech(&self) -> fluent_builders::SynthesizeSpeech<C, M, R> {
        fluent_builders::SynthesizeSpeech::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DeleteLexicon`.
    ///
    /// <p>Deletes the specified pronunciation lexicon stored in an Amazon Web Services Region. A lexicon which has been deleted is not available for
    /// speech synthesis, nor is it possible to retrieve it using either the
    /// <code>GetLexicon</code> or <code>ListLexicon</code> APIs.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLexicon<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lexicon_input::Builder,
    }
    impl<C, M, R> DeleteLexicon<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLexicon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLexiconOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLexiconError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLexiconInputOperationOutputAlias,
                crate::output::DeleteLexiconOutput,
                crate::error::DeleteLexiconError,
                crate::input::DeleteLexiconInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the lexicon to delete. Must be an existing lexicon in
        /// the region.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the lexicon to delete. Must be an existing lexicon in
        /// the region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVoices`.
    ///
    /// <p>Returns the list of voices that are available for use when
    /// requesting speech synthesis. Each voice speaks a specified language, is
    /// either male or female, and is identified by an ID, which is the ASCII
    /// version of the voice name. </p>
    ///
    /// <p>When synthesizing speech ( <code>SynthesizeSpeech</code> ), you
    /// provide the voice ID for the voice you want from the list of voices
    /// returned by <code>DescribeVoices</code>.</p>
    ///
    /// <p>For example, you want your news reader application to read news in
    /// a specific language, but giving a user the option to choose the voice.
    /// Using the <code>DescribeVoices</code> operation you can provide the user
    /// with a list of available voices to select from.</p>
    ///
    /// <p> You can optionally specify a language code to filter the available
    /// voices. For example, if you specify <code>en-US</code>, the operation
    /// returns a list of all available US English voices. </p>
    /// <p>This operation requires permissions to perform the
    /// <code>polly:DescribeVoices</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVoices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_voices_input::Builder,
    }
    impl<C, M, R> DescribeVoices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVoices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVoicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVoicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVoicesInputOperationOutputAlias,
                crate::output::DescribeVoicesOutput,
                crate::error::DescribeVoicesError,
                crate::input::DescribeVoicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// used by Amazon Polly when processing input text for speech synthesis. </p>
        pub fn engine(mut self, inp: crate::model::Engine) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// used by Amazon Polly when processing input text for speech synthesis. </p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p> The language identification tag (ISO 639 code for the language
        /// name-ISO 3166 country code) for filtering the list of voices returned. If
        /// you don't specify this optional parameter, all available voices are
        /// returned. </p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p> The language identification tag (ISO 639 code for the language
        /// name-ISO 3166 country code) for filtering the list of voices returned. If
        /// you don't specify this optional parameter, all available voices are
        /// returned. </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>Boolean value indicating whether to return any bilingual voices that
        /// use the specified language as an additional language. For instance, if you
        /// request all languages that use US English (es-US), and there is an Italian
        /// voice that speaks both Italian (it-IT) and US English, that voice will be
        /// included if you specify <code>yes</code> but not if you specify
        /// <code>no</code>.</p>
        pub fn include_additional_language_codes(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_additional_language_codes(inp);
            self
        }
        /// <p>Boolean value indicating whether to return any bilingual voices that
        /// use the specified language as an additional language. For instance, if you
        /// request all languages that use US English (es-US), and there is an Italian
        /// voice that speaks both Italian (it-IT) and US English, that voice will be
        /// included if you specify <code>yes</code> but not if you specify
        /// <code>no</code>.</p>
        pub fn set_include_additional_language_codes(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_additional_language_codes(input);
            self
        }
        /// <p>An opaque pagination token returned from the previous
        /// <code>DescribeVoices</code> operation. If present, this indicates where
        /// to continue the listing.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque pagination token returned from the previous
        /// <code>DescribeVoices</code> operation. If present, this indicates where
        /// to continue the listing.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLexicon`.
    ///
    /// <p>Returns the content of the specified pronunciation lexicon stored
    /// in an Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLexicon<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lexicon_input::Builder,
    }
    impl<C, M, R> GetLexicon<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLexicon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLexiconOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLexiconError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLexiconInputOperationOutputAlias,
                crate::output::GetLexiconOutput,
                crate::error::GetLexiconError,
                crate::input::GetLexiconInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the lexicon.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the lexicon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSpeechSynthesisTask`.
    ///
    /// <p>Retrieves a specific SpeechSynthesisTask object based on its TaskID.
    /// This object contains information about the given speech synthesis task,
    /// including the status of the task, and a link to the S3 bucket containing
    /// the output of the task.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSpeechSynthesisTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_speech_synthesis_task_input::Builder,
    }
    impl<C, M, R> GetSpeechSynthesisTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSpeechSynthesisTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSpeechSynthesisTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSpeechSynthesisTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSpeechSynthesisTaskInputOperationOutputAlias,
                crate::output::GetSpeechSynthesisTaskOutput,
                crate::error::GetSpeechSynthesisTaskError,
                crate::input::GetSpeechSynthesisTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
        pub fn task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(inp);
            self
        }
        /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLexicons`.
    ///
    /// <p>Returns a list of pronunciation lexicons stored in an Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLexicons<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lexicons_input::Builder,
    }
    impl<C, M, R> ListLexicons<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLexicons`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLexiconsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLexiconsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLexiconsInputOperationOutputAlias,
                crate::output::ListLexiconsOutput,
                crate::error::ListLexiconsError,
                crate::input::ListLexiconsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An opaque pagination token returned from previous
        /// <code>ListLexicons</code> operation. If present, indicates where to
        /// continue the list of lexicons.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque pagination token returned from previous
        /// <code>ListLexicons</code> operation. If present, indicates where to
        /// continue the list of lexicons.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSpeechSynthesisTasks`.
    ///
    /// <p>Returns a list of SpeechSynthesisTask objects ordered by their
    /// creation date. This operation can filter the tasks by their status, for
    /// example, allowing users to list only tasks that are completed.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSpeechSynthesisTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_speech_synthesis_tasks_input::Builder,
    }
    impl<C, M, R> ListSpeechSynthesisTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSpeechSynthesisTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSpeechSynthesisTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSpeechSynthesisTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSpeechSynthesisTasksInputOperationOutputAlias,
                crate::output::ListSpeechSynthesisTasksOutput,
                crate::error::ListSpeechSynthesisTasksError,
                crate::input::ListSpeechSynthesisTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of speech synthesis tasks returned in a List
        /// operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of speech synthesis tasks returned in a List
        /// operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use in the next request to continue the
        /// listing of speech synthesis tasks. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use in the next request to continue the
        /// listing of speech synthesis tasks. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Status of the speech synthesis tasks returned in a List
        /// operation</p>
        pub fn status(mut self, inp: crate::model::TaskStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>Status of the speech synthesis tasks returned in a List
        /// operation</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TaskStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLexicon`.
    ///
    /// <p>Stores a pronunciation lexicon in an Amazon Web Services Region. If
    /// a lexicon with the same name already exists in the region, it is
    /// overwritten by the new lexicon. Lexicon operations have eventual
    /// consistency, therefore, it might take some time before the lexicon is
    /// available to the SynthesizeSpeech operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLexicon<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_lexicon_input::Builder,
    }
    impl<C, M, R> PutLexicon<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLexicon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLexiconOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLexiconError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLexiconInputOperationOutputAlias,
                crate::output::PutLexiconOutput,
                crate::error::PutLexiconError,
                crate::input::PutLexiconInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the lexicon. The name must follow the regular express
        /// format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive
        /// alphanumeric string up to 20 characters long. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the lexicon. The name must follow the regular express
        /// format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive
        /// alphanumeric string up to 20 characters long. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Content of the PLS lexicon as string data.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>Content of the PLS lexicon as string data.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSpeechSynthesisTask`.
    ///
    /// <p>Allows the creation of an asynchronous synthesis task, by starting a
    /// new <code>SpeechSynthesisTask</code>. This operation requires all the
    /// standard information needed for speech synthesis, plus the name of an
    /// Amazon S3 bucket for the service to store the output of the synthesis task
    /// and two optional parameters (<code>OutputS3KeyPrefix</code> and
    /// <code>SnsTopicArn</code>). Once the synthesis task is created, this
    /// operation will return a <code>SpeechSynthesisTask</code> object, which
    /// will include an identifier of this task as well as the current status. The
    /// <code>SpeechSynthesisTask</code> object is available for 72 hours after
    /// starting the asynchronous synthesis task.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSpeechSynthesisTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_speech_synthesis_task_input::Builder,
    }
    impl<C, M, R> StartSpeechSynthesisTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSpeechSynthesisTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSpeechSynthesisTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSpeechSynthesisTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSpeechSynthesisTaskInputOperationOutputAlias,
                crate::output::StartSpeechSynthesisTaskOutput,
                crate::error::StartSpeechSynthesisTaskError,
                crate::input::StartSpeechSynthesisTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. Using a
        /// voice that is not supported for the engine selected will result in an
        /// error.</p>
        pub fn engine(mut self, inp: crate::model::Engine) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. Using a
        /// voice that is not supported for the engine selected will result in an
        /// error.</p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>Optional language code for the Speech Synthesis request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>Optional language code for the Speech Synthesis request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// Appends an item to `LexiconNames`.
        ///
        /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
        ///
        /// <p>List of one or more pronunciation lexicon names you want the service
        /// to apply during synthesis. Lexicons are applied only if the language of
        /// the lexicon is the same as the language of the voice. </p>
        pub fn lexicon_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lexicon_names(inp);
            self
        }
        /// <p>List of one or more pronunciation lexicon names you want the service
        /// to apply during synthesis. Lexicons are applied only if the language of
        /// the lexicon is the same as the language of the voice. </p>
        pub fn set_lexicon_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lexicon_names(input);
            self
        }
        /// <p>The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        pub fn output_format(mut self, inp: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(inp);
            self
        }
        /// <p>The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
        /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
        pub fn output_s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_bucket_name(inp);
            self
        }
        /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_bucket_name(input);
            self
        }
        /// <p>The Amazon S3 key prefix for the output speech file.</p>
        pub fn output_s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_key_prefix(inp);
            self
        }
        /// <p>The Amazon S3 key prefix for the output speech file.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_key_prefix(input);
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn sample_rate(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_rate(inp);
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sample_rate(input);
            self
        }
        /// <p>ARN for the SNS topic optionally used for providing status
        /// notification for a speech synthesis task.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>ARN for the SNS topic optionally used for providing status
        /// notification for a speech synthesis task.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// Appends an item to `SpeechMarkTypes`.
        ///
        /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
        ///
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn speech_mark_types(mut self, inp: impl Into<crate::model::SpeechMarkType>) -> Self {
            self.inner = self.inner.speech_mark_types(inp);
            self
        }
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn set_speech_mark_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        ) -> Self {
            self.inner = self.inner.set_speech_mark_types(input);
            self
        }
        /// <p>The input text to synthesize. If you specify ssml as the TextType,
        /// follow the SSML format for the input text. </p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>The input text to synthesize. If you specify ssml as the TextType,
        /// follow the SSML format for the input text. </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>Specifies whether the input text is plain text or SSML. The default
        /// value is plain text. </p>
        pub fn text_type(mut self, inp: crate::model::TextType) -> Self {
            self.inner = self.inner.text_type(inp);
            self
        }
        /// <p>Specifies whether the input text is plain text or SSML. The default
        /// value is plain text. </p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.inner = self.inner.set_text_type(input);
            self
        }
        /// <p>Voice ID to use for the synthesis. </p>
        pub fn voice_id(mut self, inp: crate::model::VoiceId) -> Self {
            self.inner = self.inner.voice_id(inp);
            self
        }
        /// <p>Voice ID to use for the synthesis. </p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.inner = self.inner.set_voice_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SynthesizeSpeech`.
    ///
    /// <p>Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes.
    /// SSML input must be valid, well-formed SSML. Some alphabets might not be
    /// available with all the voices (for example, Cyrillic might not be read at
    /// all by English voices) unless phoneme mapping is used. For more
    /// information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SynthesizeSpeech<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::synthesize_speech_input::Builder,
    }
    impl<C, M, R> SynthesizeSpeech<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SynthesizeSpeech`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SynthesizeSpeechOutput,
            aws_smithy_http::result::SdkError<crate::error::SynthesizeSpeechError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SynthesizeSpeechInputOperationOutputAlias,
                crate::output::SynthesizeSpeechOutput,
                crate::error::SynthesizeSpeechError,
                crate::input::SynthesizeSpeechInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        ///
        /// Creates a presigned request for this operation.
        ///
        /// The `presigning_config` provides additional presigning-specific config values, such as the
        /// amount of time the request should be valid for after creation.
        ///
        /// Presigned requests can be given to other users or applications to access a resource or perform
        /// an operation without having access to the AWS security credentials.
        ///
        pub async fn presigned(
            self,
            presigning_config: crate::presigning::config::PresigningConfig,
        ) -> Result<
            crate::presigning::request::PresignedRequest,
            aws_smithy_http::result::SdkError<crate::error::SynthesizeSpeechError>,
        > {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            input.presigned(&self.handle.conf, presigning_config).await
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. For
        /// information on Amazon Polly voices and which voices are available in
        /// standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
        /// <p>
        /// <b>NTTS-only voices</b>
        /// </p>
        /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is
        /// required and must be set to <code>neural</code>. If the engine is not
        /// specified, or is set to <code>standard</code>, this will result in an
        /// error. </p>
        /// <p>Type: String</p>
        /// <p>Valid Values: <code>standard</code> | <code>neural</code>
        /// </p>
        /// <p>Required: Yes</p>
        ///
        /// <p>
        /// <b>Standard voices</b>
        /// </p>
        /// <p>For standard voices, this is not required; the engine parameter
        /// defaults to <code>standard</code>. If the engine is not specified, or is
        /// set to <code>standard</code> and an NTTS-only voice is selected, this will
        /// result in an error. </p>
        pub fn engine(mut self, inp: crate::model::Engine) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>Specifies the engine (<code>standard</code> or <code>neural</code>)
        /// for Amazon Polly to use when processing input text for speech synthesis. For
        /// information on Amazon Polly voices and which voices are available in
        /// standard-only, NTTS-only, and both standard and NTTS formats, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p>
        /// <p>
        /// <b>NTTS-only voices</b>
        /// </p>
        /// <p>When using NTTS-only voices such as Kevin (en-US), this parameter is
        /// required and must be set to <code>neural</code>. If the engine is not
        /// specified, or is set to <code>standard</code>, this will result in an
        /// error. </p>
        /// <p>Type: String</p>
        /// <p>Valid Values: <code>standard</code> | <code>neural</code>
        /// </p>
        /// <p>Required: Yes</p>
        ///
        /// <p>
        /// <b>Standard voices</b>
        /// </p>
        /// <p>For standard voices, this is not required; the engine parameter
        /// defaults to <code>standard</code>. If the engine is not specified, or is
        /// set to <code>standard</code> and an NTTS-only voice is selected, this will
        /// result in an error. </p>
        pub fn set_engine(mut self, input: std::option::Option<crate::model::Engine>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>Optional language code for the Synthesize Speech request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>Optional language code for the Synthesize Speech request. This is only
        /// necessary if using a bilingual voice, such as Aditi, which can be used for
        /// either Indian English (en-IN) or Hindi (hi-IN). </p>
        /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly
        /// uses the default language of the bilingual voice. The default language for
        /// any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code>
        /// parameter. For example, if no language code is specified, Aditi will use
        /// Indian English rather than Hindi.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// Appends an item to `LexiconNames`.
        ///
        /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
        ///
        /// <p>List of one or more pronunciation lexicon names you want the
        /// service to apply during synthesis. Lexicons are applied only if the
        /// language of the lexicon is the same as the language of the voice. For
        /// information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
        pub fn lexicon_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lexicon_names(inp);
            self
        }
        /// <p>List of one or more pronunciation lexicon names you want the
        /// service to apply during synthesis. Lexicons are applied only if the
        /// language of the lexicon is the same as the language of the voice. For
        /// information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p>
        pub fn set_lexicon_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lexicon_names(input);
            self
        }
        /// <p> The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        /// <p>When pcm is used, the content returned is audio/pcm in a signed
        /// 16-bit, 1 channel (mono), little-endian format. </p>
        pub fn output_format(mut self, inp: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(inp);
            self
        }
        /// <p> The format in which the returned output will be encoded. For audio
        /// stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will
        /// be json. </p>
        /// <p>When pcm is used, the content returned is audio/pcm in a signed
        /// 16-bit, 1 channel (mono), little-endian format. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn sample_rate(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_rate(inp);
            self
        }
        /// <p>The audio frequency specified in Hz.</p>
        /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
        /// and "24000". The default value for standard voices is "22050". The default
        /// value for neural voices is "24000".</p>
        /// <p>Valid values for pcm are "8000" and "16000" The default value is
        /// "16000". </p>
        pub fn set_sample_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sample_rate(input);
            self
        }
        /// Appends an item to `SpeechMarkTypes`.
        ///
        /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
        ///
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn speech_mark_types(mut self, inp: impl Into<crate::model::SpeechMarkType>) -> Self {
            self.inner = self.inner.speech_mark_types(inp);
            self
        }
        /// <p>The type of speech marks returned for the input text.</p>
        pub fn set_speech_mark_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeechMarkType>>,
        ) -> Self {
            self.inner = self.inner.set_speech_mark_types(input);
            self
        }
        /// <p> Input text to synthesize. If you specify <code>ssml</code> as the
        /// <code>TextType</code>, follow the SSML format for the input text.
        /// </p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p> Input text to synthesize. If you specify <code>ssml</code> as the
        /// <code>TextType</code>, follow the SSML format for the input text.
        /// </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p> Specifies whether the input text is plain text or SSML. The
        /// default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using
        /// SSML</a>.</p>
        pub fn text_type(mut self, inp: crate::model::TextType) -> Self {
            self.inner = self.inner.text_type(inp);
            self
        }
        /// <p> Specifies whether the input text is plain text or SSML. The
        /// default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using
        /// SSML</a>.</p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.inner = self.inner.set_text_type(input);
            self
        }
        /// <p> Voice ID to use for the synthesis. You can get a list of available
        /// voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
        pub fn voice_id(mut self, inp: crate::model::VoiceId) -> Self {
            self.inner = self.inner.voice_id(inp);
            self
        }
        /// <p> Voice ID to use for the synthesis. You can get a list of available
        /// voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation. </p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.inner = self.inner.set_voice_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
