// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePoolOutput {
    /// <p>The ARN of the pool.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the pool.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The current status of the pool update request.</p>
    pub status: std::option::Option<crate::model::PoolStatus>,
    /// <p>The type of message for the pool to use.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList associated with the pool.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub shared_routes_enabled: bool,
    /// <p>When set to true the pool can't be deleted.</p>
    pub deletion_protection_enabled: bool,
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdatePoolOutput {
    /// <p>The ARN of the pool.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The unique identifier of the pool.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The current status of the pool update request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PoolStatus> {
        self.status.as_ref()
    }
    /// <p>The type of message for the pool to use.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList associated with the pool.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub fn shared_routes_enabled(&self) -> bool {
        self.shared_routes_enabled
    }
    /// <p>When set to true the pool can't be deleted.</p>
    pub fn deletion_protection_enabled(&self) -> bool {
        self.deletion_protection_enabled
    }
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for UpdatePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePoolOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("status", &self.status);
        formatter.field("message_type", &self.message_type);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("shared_routes_enabled", &self.shared_routes_enabled);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`UpdatePoolOutput`](crate::output::UpdatePoolOutput)
pub mod update_pool_output {
    /// A builder for [`UpdatePoolOutput`](crate::output::UpdatePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PoolStatus>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) shared_routes_enabled: std::option::Option<bool>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the pool.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the pool.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The unique identifier of the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The current status of the pool update request.</p>
        pub fn status(mut self, input: crate::model::PoolStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the pool update request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::PoolStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of message for the pool to use.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message for the pool to use.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList associated with the pool.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList associated with the pool.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn shared_routes_enabled(mut self, input: bool) -> Self {
            self.shared_routes_enabled = Some(input);
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn set_shared_routes_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.shared_routes_enabled = input;
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePoolOutput`](crate::output::UpdatePoolOutput)
        pub fn build(self) -> crate::output::UpdatePoolOutput {
            crate::output::UpdatePoolOutput {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                status: self.status,
                message_type: self.message_type,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                shared_routes_enabled: self.shared_routes_enabled.unwrap_or_default(),
                deletion_protection_enabled: self.deletion_protection_enabled.unwrap_or_default(),
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl UpdatePoolOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePoolOutput`](crate::output::UpdatePoolOutput)
    pub fn builder() -> crate::output::update_pool_output::Builder {
        crate::output::update_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePhoneNumberOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated phone number.</p>
    pub phone_number_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the phone number.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The phone number that was updated.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<crate::model::NumberStatus>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>Specifies if the number could be used for text messages, voice or both.</p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    /// <p>The type of number that was requested.</p>
    pub number_type: std::option::Option<crate::model::NumberType>,
    /// <p>The monthly leasing price of the phone number, in US dollars.</p>
    pub monthly_leasing_price: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>This is true if self managed opt-out are enabled.</p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList associated with the phone number.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>When set to true the phone number can't be deleted.</p>
    pub deletion_protection_enabled: bool,
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdatePhoneNumberOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated phone number.</p>
    pub fn phone_number_arn(&self) -> std::option::Option<&str> {
        self.phone_number_arn.as_deref()
    }
    /// <p>The unique identifier of the phone number.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The phone number that was updated.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The current status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NumberStatus> {
        self.status.as_ref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>Specifies if the number could be used for text messages, voice or both.</p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
    /// <p>The type of number that was requested.</p>
    pub fn number_type(&self) -> std::option::Option<&crate::model::NumberType> {
        self.number_type.as_ref()
    }
    /// <p>The monthly leasing price of the phone number, in US dollars.</p>
    pub fn monthly_leasing_price(&self) -> std::option::Option<&str> {
        self.monthly_leasing_price.as_deref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>This is true if self managed opt-out are enabled.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList associated with the phone number.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>When set to true the phone number can't be deleted.</p>
    pub fn deletion_protection_enabled(&self) -> bool {
        self.deletion_protection_enabled
    }
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for UpdatePhoneNumberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePhoneNumberOutput");
        formatter.field("phone_number_arn", &self.phone_number_arn);
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("status", &self.status);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_type", &self.message_type);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.field("number_type", &self.number_type);
        formatter.field("monthly_leasing_price", &self.monthly_leasing_price);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`UpdatePhoneNumberOutput`](crate::output::UpdatePhoneNumberOutput)
pub mod update_phone_number_output {
    /// A builder for [`UpdatePhoneNumberOutput`](crate::output::UpdatePhoneNumberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_arn: std::option::Option<std::string::String>,
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NumberStatus>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        pub(crate) number_type: std::option::Option<crate::model::NumberType>,
        pub(crate) monthly_leasing_price: std::option::Option<std::string::String>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated phone number.</p>
        pub fn phone_number_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated phone number.</p>
        pub fn set_phone_number_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_arn = input;
            self
        }
        /// <p>The unique identifier of the phone number.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the phone number.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The phone number that was updated.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number that was updated.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: crate::model::NumberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NumberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Specifies if the number could be used for text messages, voice or both.</p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>Specifies if the number could be used for text messages, voice or both.</p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// <p>The type of number that was requested.</p>
        pub fn number_type(mut self, input: crate::model::NumberType) -> Self {
            self.number_type = Some(input);
            self
        }
        /// <p>The type of number that was requested.</p>
        pub fn set_number_type(
            mut self,
            input: std::option::Option<crate::model::NumberType>,
        ) -> Self {
            self.number_type = input;
            self
        }
        /// <p>The monthly leasing price of the phone number, in US dollars.</p>
        pub fn monthly_leasing_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.monthly_leasing_price = Some(input.into());
            self
        }
        /// <p>The monthly leasing price of the phone number, in US dollars.</p>
        pub fn set_monthly_leasing_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monthly_leasing_price = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>This is true if self managed opt-out are enabled.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>This is true if self managed opt-out are enabled.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList associated with the phone number.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList associated with the phone number.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>When set to true the phone number can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>When set to true the phone number can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePhoneNumberOutput`](crate::output::UpdatePhoneNumberOutput)
        pub fn build(self) -> crate::output::UpdatePhoneNumberOutput {
            crate::output::UpdatePhoneNumberOutput {
                phone_number_arn: self.phone_number_arn,
                phone_number_id: self.phone_number_id,
                phone_number: self.phone_number,
                status: self.status,
                iso_country_code: self.iso_country_code,
                message_type: self.message_type,
                number_capabilities: self.number_capabilities,
                number_type: self.number_type,
                monthly_leasing_price: self.monthly_leasing_price,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                deletion_protection_enabled: self.deletion_protection_enabled.unwrap_or_default(),
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl UpdatePhoneNumberOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePhoneNumberOutput`](crate::output::UpdatePhoneNumberOutput)
    pub fn builder() -> crate::output::update_phone_number_output::Builder {
        crate::output::update_phone_number_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventDestinationOutput {
    /// <p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An EventDestination object containing the details of where events will be logged. </p>
    pub event_destination: std::option::Option<crate::model::EventDestination>,
}
impl UpdateEventDestinationOutput {
    /// <p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An EventDestination object containing the details of where events will be logged. </p>
    pub fn event_destination(&self) -> std::option::Option<&crate::model::EventDestination> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for UpdateEventDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventDestinationOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}
/// See [`UpdateEventDestinationOutput`](crate::output::UpdateEventDestinationOutput)
pub mod update_event_destination_output {
    /// A builder for [`UpdateEventDestinationOutput`](crate::output::UpdateEventDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestination>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>An EventDestination object containing the details of where events will be logged. </p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>An EventDestination object containing the details of where events will be logged. </p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventDestinationOutput`](crate::output::UpdateEventDestinationOutput)
        pub fn build(self) -> crate::output::UpdateEventDestinationOutput {
            crate::output::UpdateEventDestinationOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
            }
        }
    }
}
impl UpdateEventDestinationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEventDestinationOutput`](crate::output::UpdateEventDestinationOutput)
    pub fn builder() -> crate::output::update_event_destination_output::Builder {
        crate::output::update_event_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVoiceMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit to enforce on sending voice messages.</p>
    pub monthly_limit: std::option::Option<i64>,
}
impl SetVoiceMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit to enforce on sending voice messages.</p>
    pub fn monthly_limit(&self) -> std::option::Option<i64> {
        self.monthly_limit
    }
}
impl std::fmt::Debug for SetVoiceMessageSpendLimitOverrideOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVoiceMessageSpendLimitOverrideOutput");
        formatter.field("monthly_limit", &self.monthly_limit);
        formatter.finish()
    }
}
/// See [`SetVoiceMessageSpendLimitOverrideOutput`](crate::output::SetVoiceMessageSpendLimitOverrideOutput)
pub mod set_voice_message_spend_limit_override_output {
    /// A builder for [`SetVoiceMessageSpendLimitOverrideOutput`](crate::output::SetVoiceMessageSpendLimitOverrideOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current monthly limit to enforce on sending voice messages.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.monthly_limit = Some(input);
            self
        }
        /// <p>The current monthly limit to enforce on sending voice messages.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.monthly_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`SetVoiceMessageSpendLimitOverrideOutput`](crate::output::SetVoiceMessageSpendLimitOverrideOutput)
        pub fn build(self) -> crate::output::SetVoiceMessageSpendLimitOverrideOutput {
            crate::output::SetVoiceMessageSpendLimitOverrideOutput {
                monthly_limit: self.monthly_limit,
            }
        }
    }
}
impl SetVoiceMessageSpendLimitOverrideOutput {
    /// Creates a new builder-style object to manufacture [`SetVoiceMessageSpendLimitOverrideOutput`](crate::output::SetVoiceMessageSpendLimitOverrideOutput)
    pub fn builder() -> crate::output::set_voice_message_spend_limit_override_output::Builder {
        crate::output::set_voice_message_spend_limit_override_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTextMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit to enforce on sending text messages.</p>
    pub monthly_limit: std::option::Option<i64>,
}
impl SetTextMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit to enforce on sending text messages.</p>
    pub fn monthly_limit(&self) -> std::option::Option<i64> {
        self.monthly_limit
    }
}
impl std::fmt::Debug for SetTextMessageSpendLimitOverrideOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTextMessageSpendLimitOverrideOutput");
        formatter.field("monthly_limit", &self.monthly_limit);
        formatter.finish()
    }
}
/// See [`SetTextMessageSpendLimitOverrideOutput`](crate::output::SetTextMessageSpendLimitOverrideOutput)
pub mod set_text_message_spend_limit_override_output {
    /// A builder for [`SetTextMessageSpendLimitOverrideOutput`](crate::output::SetTextMessageSpendLimitOverrideOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current monthly limit to enforce on sending text messages.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.monthly_limit = Some(input);
            self
        }
        /// <p>The current monthly limit to enforce on sending text messages.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.monthly_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTextMessageSpendLimitOverrideOutput`](crate::output::SetTextMessageSpendLimitOverrideOutput)
        pub fn build(self) -> crate::output::SetTextMessageSpendLimitOverrideOutput {
            crate::output::SetTextMessageSpendLimitOverrideOutput {
                monthly_limit: self.monthly_limit,
            }
        }
    }
}
impl SetTextMessageSpendLimitOverrideOutput {
    /// Creates a new builder-style object to manufacture [`SetTextMessageSpendLimitOverrideOutput`](crate::output::SetTextMessageSpendLimitOverrideOutput)
    pub fn builder() -> crate::output::set_text_message_spend_limit_override_output::Builder {
        crate::output::set_text_message_spend_limit_override_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultSenderIdOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set that was updated.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The default sender ID to set for the ConfigurationSet.</p>
    pub sender_id: std::option::Option<std::string::String>,
}
impl SetDefaultSenderIdOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set that was updated.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The default sender ID to set for the ConfigurationSet.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
}
impl std::fmt::Debug for SetDefaultSenderIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultSenderIdOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("sender_id", &self.sender_id);
        formatter.finish()
    }
}
/// See [`SetDefaultSenderIdOutput`](crate::output::SetDefaultSenderIdOutput)
pub mod set_default_sender_id_output {
    /// A builder for [`SetDefaultSenderIdOutput`](crate::output::SetDefaultSenderIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set that was updated.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that was updated.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The default sender ID to set for the ConfigurationSet.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The default sender ID to set for the ConfigurationSet.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDefaultSenderIdOutput`](crate::output::SetDefaultSenderIdOutput)
        pub fn build(self) -> crate::output::SetDefaultSenderIdOutput {
            crate::output::SetDefaultSenderIdOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                sender_id: self.sender_id,
            }
        }
    }
}
impl SetDefaultSenderIdOutput {
    /// Creates a new builder-style object to manufacture [`SetDefaultSenderIdOutput`](crate::output::SetDefaultSenderIdOutput)
    pub fn builder() -> crate::output::set_default_sender_id_output::Builder {
        crate::output::set_default_sender_id_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultMessageTypeOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set that was updated.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The new default message type of the configuration set.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
}
impl SetDefaultMessageTypeOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set that was updated.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The new default message type of the configuration set.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
}
impl std::fmt::Debug for SetDefaultMessageTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultMessageTypeOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message_type", &self.message_type);
        formatter.finish()
    }
}
/// See [`SetDefaultMessageTypeOutput`](crate::output::SetDefaultMessageTypeOutput)
pub mod set_default_message_type_output {
    /// A builder for [`SetDefaultMessageTypeOutput`](crate::output::SetDefaultMessageTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set that was updated.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that was updated.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The new default message type of the configuration set.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The new default message type of the configuration set.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDefaultMessageTypeOutput`](crate::output::SetDefaultMessageTypeOutput)
        pub fn build(self) -> crate::output::SetDefaultMessageTypeOutput {
            crate::output::SetDefaultMessageTypeOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                message_type: self.message_type,
            }
        }
    }
}
impl SetDefaultMessageTypeOutput {
    /// Creates a new builder-style object to manufacture [`SetDefaultMessageTypeOutput`](crate::output::SetDefaultMessageTypeOutput)
    pub fn builder() -> crate::output::set_default_message_type_output::Builder {
        crate::output::set_default_message_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendVoiceMessageOutput {
    /// <p>The unique identifier for the message.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendVoiceMessageOutput {
    /// <p>The unique identifier for the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendVoiceMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendVoiceMessageOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendVoiceMessageOutput`](crate::output::SendVoiceMessageOutput)
pub mod send_voice_message_output {
    /// A builder for [`SendVoiceMessageOutput`](crate::output::SendVoiceMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendVoiceMessageOutput`](crate::output::SendVoiceMessageOutput)
        pub fn build(self) -> crate::output::SendVoiceMessageOutput {
            crate::output::SendVoiceMessageOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendVoiceMessageOutput {
    /// Creates a new builder-style object to manufacture [`SendVoiceMessageOutput`](crate::output::SendVoiceMessageOutput)
    pub fn builder() -> crate::output::send_voice_message_output::Builder {
        crate::output::send_voice_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTextMessageOutput {
    /// <p>The unique identifier for the message.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendTextMessageOutput {
    /// <p>The unique identifier for the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendTextMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTextMessageOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendTextMessageOutput`](crate::output::SendTextMessageOutput)
pub mod send_text_message_output {
    /// A builder for [`SendTextMessageOutput`](crate::output::SendTextMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTextMessageOutput`](crate::output::SendTextMessageOutput)
        pub fn build(self) -> crate::output::SendTextMessageOutput {
            crate::output::SendTextMessageOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendTextMessageOutput {
    /// Creates a new builder-style object to manufacture [`SendTextMessageOutput`](crate::output::SendTextMessageOutput)
    pub fn builder() -> crate::output::send_text_message_output::Builder {
        crate::output::send_text_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestPhoneNumberOutput {
    /// <p>The Amazon Resource Name (ARN) of the requested phone number.</p>
    pub phone_number_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the new phone number.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The new phone number that was requested.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<crate::model::NumberStatus>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>Indicates if the phone number will be used for text messages, voice messages or both. </p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    /// <p>The type of number that was released.</p>
    pub number_type: std::option::Option<crate::model::RequestableNumberType>,
    /// <p>The monthly price, in US dollars, to lease the phone number.</p>
    pub monthly_leasing_price: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: bool,
    /// <p>The ARN used to identify the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList that is associated with the requested phone number.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
    pub deletion_protection_enabled: bool,
    /// <p>The unique identifier of the pool associated with the phone number </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>An array of key and value pair tags that are associated with the phone number.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl RequestPhoneNumberOutput {
    /// <p>The Amazon Resource Name (ARN) of the requested phone number.</p>
    pub fn phone_number_arn(&self) -> std::option::Option<&str> {
        self.phone_number_arn.as_deref()
    }
    /// <p>The unique identifier of the new phone number.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The new phone number that was requested.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The current status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NumberStatus> {
        self.status.as_ref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>Indicates if the phone number will be used for text messages, voice messages or both. </p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
    /// <p>The type of number that was released.</p>
    pub fn number_type(&self) -> std::option::Option<&crate::model::RequestableNumberType> {
        self.number_type.as_ref()
    }
    /// <p>The monthly price, in US dollars, to lease the phone number.</p>
    pub fn monthly_leasing_price(&self) -> std::option::Option<&str> {
        self.monthly_leasing_price.as_deref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The ARN used to identify the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList that is associated with the requested phone number.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
    pub fn deletion_protection_enabled(&self) -> bool {
        self.deletion_protection_enabled
    }
    /// <p>The unique identifier of the pool associated with the phone number </p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>An array of key and value pair tags that are associated with the phone number.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for RequestPhoneNumberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestPhoneNumberOutput");
        formatter.field("phone_number_arn", &self.phone_number_arn);
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("status", &self.status);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_type", &self.message_type);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.field("number_type", &self.number_type);
        formatter.field("monthly_leasing_price", &self.monthly_leasing_price);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("pool_id", &self.pool_id);
        formatter.field("tags", &self.tags);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`RequestPhoneNumberOutput`](crate::output::RequestPhoneNumberOutput)
pub mod request_phone_number_output {
    /// A builder for [`RequestPhoneNumberOutput`](crate::output::RequestPhoneNumberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_arn: std::option::Option<std::string::String>,
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NumberStatus>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        pub(crate) number_type: std::option::Option<crate::model::RequestableNumberType>,
        pub(crate) monthly_leasing_price: std::option::Option<std::string::String>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the requested phone number.</p>
        pub fn phone_number_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the requested phone number.</p>
        pub fn set_phone_number_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_arn = input;
            self
        }
        /// <p>The unique identifier of the new phone number.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the new phone number.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The new phone number that was requested.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The new phone number that was requested.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: crate::model::NumberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NumberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Indicates if the phone number will be used for text messages, voice messages or both. </p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>Indicates if the phone number will be used for text messages, voice messages or both. </p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// <p>The type of number that was released.</p>
        pub fn number_type(mut self, input: crate::model::RequestableNumberType) -> Self {
            self.number_type = Some(input);
            self
        }
        /// <p>The type of number that was released.</p>
        pub fn set_number_type(
            mut self,
            input: std::option::Option<crate::model::RequestableNumberType>,
        ) -> Self {
            self.number_type = input;
            self
        }
        /// <p>The monthly price, in US dollars, to lease the phone number.</p>
        pub fn monthly_leasing_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.monthly_leasing_price = Some(input.into());
            self
        }
        /// <p>The monthly price, in US dollars, to lease the phone number.</p>
        pub fn set_monthly_leasing_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monthly_leasing_price = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The ARN used to identify the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN used to identify the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList that is associated with the requested phone number.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList that is associated with the requested phone number.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// <p>The unique identifier of the pool associated with the phone number </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the pool associated with the phone number </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that are associated with the phone number.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of key and value pair tags that are associated with the phone number.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestPhoneNumberOutput`](crate::output::RequestPhoneNumberOutput)
        pub fn build(self) -> crate::output::RequestPhoneNumberOutput {
            crate::output::RequestPhoneNumberOutput {
                phone_number_arn: self.phone_number_arn,
                phone_number_id: self.phone_number_id,
                phone_number: self.phone_number,
                status: self.status,
                iso_country_code: self.iso_country_code,
                message_type: self.message_type,
                number_capabilities: self.number_capabilities,
                number_type: self.number_type,
                monthly_leasing_price: self.monthly_leasing_price,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                deletion_protection_enabled: self.deletion_protection_enabled.unwrap_or_default(),
                pool_id: self.pool_id,
                tags: self.tags,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl RequestPhoneNumberOutput {
    /// Creates a new builder-style object to manufacture [`RequestPhoneNumberOutput`](crate::output::RequestPhoneNumberOutput)
    pub fn builder() -> crate::output::request_phone_number_output::Builder {
        crate::output::request_phone_number_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReleasePhoneNumberOutput {
    /// <p>The PhoneNumberArn of the phone number that was released.</p>
    pub phone_number_arn: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberId of the phone number that was released.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The phone number that was released.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<crate::model::NumberStatus>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The message type that was associated with the phone number.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>Specifies if the number could be used for text messages, voice, or both.</p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    /// <p>The type of number that was released.</p>
    pub number_type: std::option::Option<crate::model::NumberType>,
    /// <p>The monthly price of the phone number, in US dollars.</p>
    pub monthly_leasing_price: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList that was associated with the phone number.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReleasePhoneNumberOutput {
    /// <p>The PhoneNumberArn of the phone number that was released.</p>
    pub fn phone_number_arn(&self) -> std::option::Option<&str> {
        self.phone_number_arn.as_deref()
    }
    /// <p>The PhoneNumberId of the phone number that was released.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The phone number that was released.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The current status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NumberStatus> {
        self.status.as_ref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The message type that was associated with the phone number.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>Specifies if the number could be used for text messages, voice, or both.</p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
    /// <p>The type of number that was released.</p>
    pub fn number_type(&self) -> std::option::Option<&crate::model::NumberType> {
        self.number_type.as_ref()
    }
    /// <p>The monthly price of the phone number, in US dollars.</p>
    pub fn monthly_leasing_price(&self) -> std::option::Option<&str> {
        self.monthly_leasing_price.as_deref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList that was associated with the phone number.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ReleasePhoneNumberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReleasePhoneNumberOutput");
        formatter.field("phone_number_arn", &self.phone_number_arn);
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("status", &self.status);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_type", &self.message_type);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.field("number_type", &self.number_type);
        formatter.field("monthly_leasing_price", &self.monthly_leasing_price);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`ReleasePhoneNumberOutput`](crate::output::ReleasePhoneNumberOutput)
pub mod release_phone_number_output {
    /// A builder for [`ReleasePhoneNumberOutput`](crate::output::ReleasePhoneNumberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_arn: std::option::Option<std::string::String>,
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NumberStatus>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        pub(crate) number_type: std::option::Option<crate::model::NumberType>,
        pub(crate) monthly_leasing_price: std::option::Option<std::string::String>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The PhoneNumberArn of the phone number that was released.</p>
        pub fn phone_number_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_arn = Some(input.into());
            self
        }
        /// <p>The PhoneNumberArn of the phone number that was released.</p>
        pub fn set_phone_number_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_arn = input;
            self
        }
        /// <p>The PhoneNumberId of the phone number that was released.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId of the phone number that was released.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The phone number that was released.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number that was released.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: crate::model::NumberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NumberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>The message type that was associated with the phone number.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The message type that was associated with the phone number.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Specifies if the number could be used for text messages, voice, or both.</p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>Specifies if the number could be used for text messages, voice, or both.</p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// <p>The type of number that was released.</p>
        pub fn number_type(mut self, input: crate::model::NumberType) -> Self {
            self.number_type = Some(input);
            self
        }
        /// <p>The type of number that was released.</p>
        pub fn set_number_type(
            mut self,
            input: std::option::Option<crate::model::NumberType>,
        ) -> Self {
            self.number_type = input;
            self
        }
        /// <p>The monthly price of the phone number, in US dollars.</p>
        pub fn monthly_leasing_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.monthly_leasing_price = Some(input.into());
            self
        }
        /// <p>The monthly price of the phone number, in US dollars.</p>
        pub fn set_monthly_leasing_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monthly_leasing_price = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList that was associated with the phone number.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList that was associated with the phone number.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ReleasePhoneNumberOutput`](crate::output::ReleasePhoneNumberOutput)
        pub fn build(self) -> crate::output::ReleasePhoneNumberOutput {
            crate::output::ReleasePhoneNumberOutput {
                phone_number_arn: self.phone_number_arn,
                phone_number_id: self.phone_number_id,
                phone_number: self.phone_number,
                status: self.status,
                iso_country_code: self.iso_country_code,
                message_type: self.message_type,
                number_capabilities: self.number_capabilities,
                number_type: self.number_type,
                monthly_leasing_price: self.monthly_leasing_price,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl ReleasePhoneNumberOutput {
    /// Creates a new builder-style object to manufacture [`ReleasePhoneNumberOutput`](crate::output::ReleasePhoneNumberOutput)
    pub fn builder() -> crate::output::release_phone_number_output::Builder {
        crate::output::release_phone_number_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutOptedOutNumberOutput {
    /// <p>The OptOutListArn that the phone number was removed from.</p>
    pub opt_out_list_arn: std::option::Option<std::string::String>,
    /// <p>The OptOutListName that the phone number was removed from.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The phone number that was added to the OptOutList.</p>
    pub opted_out_number: std::option::Option<std::string::String>,
    /// <p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub opted_out_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>This is true if it was the end user who requested their phone number be removed. </p>
    pub end_user_opted_out: bool,
}
impl PutOptedOutNumberOutput {
    /// <p>The OptOutListArn that the phone number was removed from.</p>
    pub fn opt_out_list_arn(&self) -> std::option::Option<&str> {
        self.opt_out_list_arn.as_deref()
    }
    /// <p>The OptOutListName that the phone number was removed from.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The phone number that was added to the OptOutList.</p>
    pub fn opted_out_number(&self) -> std::option::Option<&str> {
        self.opted_out_number.as_deref()
    }
    /// <p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn opted_out_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.opted_out_timestamp.as_ref()
    }
    /// <p>This is true if it was the end user who requested their phone number be removed. </p>
    pub fn end_user_opted_out(&self) -> bool {
        self.end_user_opted_out
    }
}
impl std::fmt::Debug for PutOptedOutNumberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutOptedOutNumberOutput");
        formatter.field("opt_out_list_arn", &self.opt_out_list_arn);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("opted_out_number", &self.opted_out_number);
        formatter.field("opted_out_timestamp", &self.opted_out_timestamp);
        formatter.field("end_user_opted_out", &self.end_user_opted_out);
        formatter.finish()
    }
}
/// See [`PutOptedOutNumberOutput`](crate::output::PutOptedOutNumberOutput)
pub mod put_opted_out_number_output {
    /// A builder for [`PutOptedOutNumberOutput`](crate::output::PutOptedOutNumberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_arn: std::option::Option<std::string::String>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) opted_out_number: std::option::Option<std::string::String>,
        pub(crate) opted_out_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_user_opted_out: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The OptOutListArn that the phone number was removed from.</p>
        pub fn opt_out_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_arn = Some(input.into());
            self
        }
        /// <p>The OptOutListArn that the phone number was removed from.</p>
        pub fn set_opt_out_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_arn = input;
            self
        }
        /// <p>The OptOutListName that the phone number was removed from.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutListName that the phone number was removed from.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The phone number that was added to the OptOutList.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.opted_out_number = Some(input.into());
            self
        }
        /// <p>The phone number that was added to the OptOutList.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opted_out_number = input;
            self
        }
        /// <p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn opted_out_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.opted_out_timestamp = Some(input);
            self
        }
        /// <p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_opted_out_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.opted_out_timestamp = input;
            self
        }
        /// <p>This is true if it was the end user who requested their phone number be removed. </p>
        pub fn end_user_opted_out(mut self, input: bool) -> Self {
            self.end_user_opted_out = Some(input);
            self
        }
        /// <p>This is true if it was the end user who requested their phone number be removed. </p>
        pub fn set_end_user_opted_out(mut self, input: std::option::Option<bool>) -> Self {
            self.end_user_opted_out = input;
            self
        }
        /// Consumes the builder and constructs a [`PutOptedOutNumberOutput`](crate::output::PutOptedOutNumberOutput)
        pub fn build(self) -> crate::output::PutOptedOutNumberOutput {
            crate::output::PutOptedOutNumberOutput {
                opt_out_list_arn: self.opt_out_list_arn,
                opt_out_list_name: self.opt_out_list_name,
                opted_out_number: self.opted_out_number,
                opted_out_timestamp: self.opted_out_timestamp,
                end_user_opted_out: self.end_user_opted_out.unwrap_or_default(),
            }
        }
    }
}
impl PutOptedOutNumberOutput {
    /// Creates a new builder-style object to manufacture [`PutOptedOutNumberOutput`](crate::output::PutOptedOutNumberOutput)
    pub fn builder() -> crate::output::put_opted_out_number_output::Builder {
        crate::output::put_opted_out_number_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutKeywordOutput {
    /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
    pub origination_identity_arn: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The keyword that was added.</p>
    pub keyword: std::option::Option<std::string::String>,
    /// <p>The message associated with the keyword.</p>
    pub keyword_message: std::option::Option<std::string::String>,
    /// <p>The action to perform when the keyword is used.</p>
    pub keyword_action: std::option::Option<crate::model::KeywordAction>,
}
impl PutKeywordOutput {
    /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
    pub fn origination_identity_arn(&self) -> std::option::Option<&str> {
        self.origination_identity_arn.as_deref()
    }
    /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The keyword that was added.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
    /// <p>The message associated with the keyword.</p>
    pub fn keyword_message(&self) -> std::option::Option<&str> {
        self.keyword_message.as_deref()
    }
    /// <p>The action to perform when the keyword is used.</p>
    pub fn keyword_action(&self) -> std::option::Option<&crate::model::KeywordAction> {
        self.keyword_action.as_ref()
    }
}
impl std::fmt::Debug for PutKeywordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutKeywordOutput");
        formatter.field("origination_identity_arn", &self.origination_identity_arn);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("keyword", &self.keyword);
        formatter.field("keyword_message", &self.keyword_message);
        formatter.field("keyword_action", &self.keyword_action);
        formatter.finish()
    }
}
/// See [`PutKeywordOutput`](crate::output::PutKeywordOutput)
pub mod put_keyword_output {
    /// A builder for [`PutKeywordOutput`](crate::output::PutKeywordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity_arn: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) keyword: std::option::Option<std::string::String>,
        pub(crate) keyword_message: std::option::Option<std::string::String>,
        pub(crate) keyword_action: std::option::Option<crate::model::KeywordAction>,
    }
    impl Builder {
        /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
        pub fn origination_identity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity_arn = Some(input.into());
            self
        }
        /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
        pub fn set_origination_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity_arn = input;
            self
        }
        /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The keyword that was added.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>The keyword that was added.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// <p>The message associated with the keyword.</p>
        pub fn keyword_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword_message = Some(input.into());
            self
        }
        /// <p>The message associated with the keyword.</p>
        pub fn set_keyword_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyword_message = input;
            self
        }
        /// <p>The action to perform when the keyword is used.</p>
        pub fn keyword_action(mut self, input: crate::model::KeywordAction) -> Self {
            self.keyword_action = Some(input);
            self
        }
        /// <p>The action to perform when the keyword is used.</p>
        pub fn set_keyword_action(
            mut self,
            input: std::option::Option<crate::model::KeywordAction>,
        ) -> Self {
            self.keyword_action = input;
            self
        }
        /// Consumes the builder and constructs a [`PutKeywordOutput`](crate::output::PutKeywordOutput)
        pub fn build(self) -> crate::output::PutKeywordOutput {
            crate::output::PutKeywordOutput {
                origination_identity_arn: self.origination_identity_arn,
                origination_identity: self.origination_identity,
                keyword: self.keyword,
                keyword_message: self.keyword_message,
                keyword_action: self.keyword_action,
            }
        }
    }
}
impl PutKeywordOutput {
    /// Creates a new builder-style object to manufacture [`PutKeywordOutput`](crate::output::PutKeywordOutput)
    pub fn builder() -> crate::output::put_keyword_output::Builder {
        crate::output::put_keyword_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of key and value pair tags that are associated with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of key and value pair tags that are associated with the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that are associated with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of key and value pair tags that are associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoolOriginationIdentitiesOutput {
    /// <p>The Amazon Resource Name (ARN) for the pool.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The unique PoolId of the pool.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>An array of any OriginationIdentityMetadata objects.</p>
    pub origination_identities:
        std::option::Option<std::vec::Vec<crate::model::OriginationIdentityMetadata>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPoolOriginationIdentitiesOutput {
    /// <p>The Amazon Resource Name (ARN) for the pool.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The unique PoolId of the pool.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>An array of any OriginationIdentityMetadata objects.</p>
    pub fn origination_identities(
        &self,
    ) -> std::option::Option<&[crate::model::OriginationIdentityMetadata]> {
        self.origination_identities.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPoolOriginationIdentitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoolOriginationIdentitiesOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("origination_identities", &self.origination_identities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPoolOriginationIdentitiesOutput`](crate::output::ListPoolOriginationIdentitiesOutput)
pub mod list_pool_origination_identities_output {
    /// A builder for [`ListPoolOriginationIdentitiesOutput`](crate::output::ListPoolOriginationIdentitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) origination_identities:
            std::option::Option<std::vec::Vec<crate::model::OriginationIdentityMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the pool.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the pool.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The unique PoolId of the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique PoolId of the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// Appends an item to `origination_identities`.
        ///
        /// To override the contents of this collection use [`set_origination_identities`](Self::set_origination_identities).
        ///
        /// <p>An array of any OriginationIdentityMetadata objects.</p>
        pub fn origination_identities(
            mut self,
            input: crate::model::OriginationIdentityMetadata,
        ) -> Self {
            let mut v = self.origination_identities.unwrap_or_default();
            v.push(input);
            self.origination_identities = Some(v);
            self
        }
        /// <p>An array of any OriginationIdentityMetadata objects.</p>
        pub fn set_origination_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OriginationIdentityMetadata>>,
        ) -> Self {
            self.origination_identities = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoolOriginationIdentitiesOutput`](crate::output::ListPoolOriginationIdentitiesOutput)
        pub fn build(self) -> crate::output::ListPoolOriginationIdentitiesOutput {
            crate::output::ListPoolOriginationIdentitiesOutput {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                origination_identities: self.origination_identities,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPoolOriginationIdentitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListPoolOriginationIdentitiesOutput`](crate::output::ListPoolOriginationIdentitiesOutput)
    pub fn builder() -> crate::output::list_pool_origination_identities_output::Builder {
        crate::output::list_pool_origination_identities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateOriginationIdentityOutput {
    /// <p>The Amazon Resource Name (ARN) of the pool.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The PoolId of the pool no longer associated with the origination identity.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
    pub origination_identity_arn: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
    pub iso_country_code: std::option::Option<std::string::String>,
}
impl DisassociateOriginationIdentityOutput {
    /// <p>The Amazon Resource Name (ARN) of the pool.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The PoolId of the pool no longer associated with the origination identity.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
    pub fn origination_identity_arn(&self) -> std::option::Option<&str> {
        self.origination_identity_arn.as_deref()
    }
    /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
}
impl std::fmt::Debug for DisassociateOriginationIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateOriginationIdentityOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("origination_identity_arn", &self.origination_identity_arn);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.finish()
    }
}
/// See [`DisassociateOriginationIdentityOutput`](crate::output::DisassociateOriginationIdentityOutput)
pub mod disassociate_origination_identity_output {
    /// A builder for [`DisassociateOriginationIdentityOutput`](crate::output::DisassociateOriginationIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) origination_identity_arn: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pool.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pool.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The PoolId of the pool no longer associated with the origination identity.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The PoolId of the pool no longer associated with the origination identity.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
        pub fn origination_identity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity_arn = Some(input.into());
            self
        }
        /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
        pub fn set_origination_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity_arn = input;
            self
        }
        /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateOriginationIdentityOutput`](crate::output::DisassociateOriginationIdentityOutput)
        pub fn build(self) -> crate::output::DisassociateOriginationIdentityOutput {
            crate::output::DisassociateOriginationIdentityOutput {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                origination_identity_arn: self.origination_identity_arn,
                origination_identity: self.origination_identity,
                iso_country_code: self.iso_country_code,
            }
        }
    }
}
impl DisassociateOriginationIdentityOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateOriginationIdentityOutput`](crate::output::DisassociateOriginationIdentityOutput)
    pub fn builder() -> crate::output::disassociate_origination_identity_output::Builder {
        crate::output::disassociate_origination_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSpendLimitsOutput {
    /// <p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>
    pub spend_limits: std::option::Option<std::vec::Vec<crate::model::SpendLimit>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSpendLimitsOutput {
    /// <p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>
    pub fn spend_limits(&self) -> std::option::Option<&[crate::model::SpendLimit]> {
        self.spend_limits.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSpendLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSpendLimitsOutput");
        formatter.field("spend_limits", &self.spend_limits);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSpendLimitsOutput`](crate::output::DescribeSpendLimitsOutput)
pub mod describe_spend_limits_output {
    /// A builder for [`DescribeSpendLimitsOutput`](crate::output::DescribeSpendLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spend_limits: std::option::Option<std::vec::Vec<crate::model::SpendLimit>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `spend_limits`.
        ///
        /// To override the contents of this collection use [`set_spend_limits`](Self::set_spend_limits).
        ///
        /// <p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>
        pub fn spend_limits(mut self, input: crate::model::SpendLimit) -> Self {
            let mut v = self.spend_limits.unwrap_or_default();
            v.push(input);
            self.spend_limits = Some(v);
            self
        }
        /// <p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>
        pub fn set_spend_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpendLimit>>,
        ) -> Self {
            self.spend_limits = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSpendLimitsOutput`](crate::output::DescribeSpendLimitsOutput)
        pub fn build(self) -> crate::output::DescribeSpendLimitsOutput {
            crate::output::DescribeSpendLimitsOutput {
                spend_limits: self.spend_limits,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSpendLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSpendLimitsOutput`](crate::output::DescribeSpendLimitsOutput)
    pub fn builder() -> crate::output::describe_spend_limits_output::Builder {
        crate::output::describe_spend_limits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSenderIdsOutput {
    /// <p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>
    pub sender_ids: std::option::Option<std::vec::Vec<crate::model::SenderIdInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSenderIdsOutput {
    /// <p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>
    pub fn sender_ids(&self) -> std::option::Option<&[crate::model::SenderIdInformation]> {
        self.sender_ids.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSenderIdsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSenderIdsOutput");
        formatter.field("sender_ids", &self.sender_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSenderIdsOutput`](crate::output::DescribeSenderIdsOutput)
pub mod describe_sender_ids_output {
    /// A builder for [`DescribeSenderIdsOutput`](crate::output::DescribeSenderIdsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sender_ids:
            std::option::Option<std::vec::Vec<crate::model::SenderIdInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sender_ids`.
        ///
        /// To override the contents of this collection use [`set_sender_ids`](Self::set_sender_ids).
        ///
        /// <p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>
        pub fn sender_ids(mut self, input: crate::model::SenderIdInformation) -> Self {
            let mut v = self.sender_ids.unwrap_or_default();
            v.push(input);
            self.sender_ids = Some(v);
            self
        }
        /// <p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>
        pub fn set_sender_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SenderIdInformation>>,
        ) -> Self {
            self.sender_ids = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSenderIdsOutput`](crate::output::DescribeSenderIdsOutput)
        pub fn build(self) -> crate::output::DescribeSenderIdsOutput {
            crate::output::DescribeSenderIdsOutput {
                sender_ids: self.sender_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSenderIdsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSenderIdsOutput`](crate::output::DescribeSenderIdsOutput)
    pub fn builder() -> crate::output::describe_sender_ids_output::Builder {
        crate::output::describe_sender_ids_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePoolsOutput {
    /// <p>An array of PoolInformation objects that contain the details for the requested pools. </p>
    pub pools: std::option::Option<std::vec::Vec<crate::model::PoolInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePoolsOutput {
    /// <p>An array of PoolInformation objects that contain the details for the requested pools. </p>
    pub fn pools(&self) -> std::option::Option<&[crate::model::PoolInformation]> {
        self.pools.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePoolsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePoolsOutput");
        formatter.field("pools", &self.pools);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePoolsOutput`](crate::output::DescribePoolsOutput)
pub mod describe_pools_output {
    /// A builder for [`DescribePoolsOutput`](crate::output::DescribePoolsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pools: std::option::Option<std::vec::Vec<crate::model::PoolInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pools`.
        ///
        /// To override the contents of this collection use [`set_pools`](Self::set_pools).
        ///
        /// <p>An array of PoolInformation objects that contain the details for the requested pools. </p>
        pub fn pools(mut self, input: crate::model::PoolInformation) -> Self {
            let mut v = self.pools.unwrap_or_default();
            v.push(input);
            self.pools = Some(v);
            self
        }
        /// <p>An array of PoolInformation objects that contain the details for the requested pools. </p>
        pub fn set_pools(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PoolInformation>>,
        ) -> Self {
            self.pools = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePoolsOutput`](crate::output::DescribePoolsOutput)
        pub fn build(self) -> crate::output::DescribePoolsOutput {
            crate::output::DescribePoolsOutput {
                pools: self.pools,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePoolsOutput {
    /// Creates a new builder-style object to manufacture [`DescribePoolsOutput`](crate::output::DescribePoolsOutput)
    pub fn builder() -> crate::output::describe_pools_output::Builder {
        crate::output::describe_pools_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePhoneNumbersOutput {
    /// <p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>
    pub phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumberInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePhoneNumbersOutput {
    /// <p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>
    pub fn phone_numbers(&self) -> std::option::Option<&[crate::model::PhoneNumberInformation]> {
        self.phone_numbers.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePhoneNumbersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePhoneNumbersOutput");
        formatter.field("phone_numbers", &self.phone_numbers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePhoneNumbersOutput`](crate::output::DescribePhoneNumbersOutput)
pub mod describe_phone_numbers_output {
    /// A builder for [`DescribePhoneNumbersOutput`](crate::output::DescribePhoneNumbersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_numbers:
            std::option::Option<std::vec::Vec<crate::model::PhoneNumberInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>
        pub fn phone_numbers(mut self, input: crate::model::PhoneNumberInformation) -> Self {
            let mut v = self.phone_numbers.unwrap_or_default();
            v.push(input);
            self.phone_numbers = Some(v);
            self
        }
        /// <p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberInformation>>,
        ) -> Self {
            self.phone_numbers = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePhoneNumbersOutput`](crate::output::DescribePhoneNumbersOutput)
        pub fn build(self) -> crate::output::DescribePhoneNumbersOutput {
            crate::output::DescribePhoneNumbersOutput {
                phone_numbers: self.phone_numbers,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePhoneNumbersOutput {
    /// Creates a new builder-style object to manufacture [`DescribePhoneNumbersOutput`](crate::output::DescribePhoneNumbersOutput)
    pub fn builder() -> crate::output::describe_phone_numbers_output::Builder {
        crate::output::describe_phone_numbers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOptOutListsOutput {
    /// <p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>
    pub opt_out_lists: std::option::Option<std::vec::Vec<crate::model::OptOutListInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOptOutListsOutput {
    /// <p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>
    pub fn opt_out_lists(&self) -> std::option::Option<&[crate::model::OptOutListInformation]> {
        self.opt_out_lists.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOptOutListsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOptOutListsOutput");
        formatter.field("opt_out_lists", &self.opt_out_lists);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeOptOutListsOutput`](crate::output::DescribeOptOutListsOutput)
pub mod describe_opt_out_lists_output {
    /// A builder for [`DescribeOptOutListsOutput`](crate::output::DescribeOptOutListsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_lists:
            std::option::Option<std::vec::Vec<crate::model::OptOutListInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `opt_out_lists`.
        ///
        /// To override the contents of this collection use [`set_opt_out_lists`](Self::set_opt_out_lists).
        ///
        /// <p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>
        pub fn opt_out_lists(mut self, input: crate::model::OptOutListInformation) -> Self {
            let mut v = self.opt_out_lists.unwrap_or_default();
            v.push(input);
            self.opt_out_lists = Some(v);
            self
        }
        /// <p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>
        pub fn set_opt_out_lists(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptOutListInformation>>,
        ) -> Self {
            self.opt_out_lists = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOptOutListsOutput`](crate::output::DescribeOptOutListsOutput)
        pub fn build(self) -> crate::output::DescribeOptOutListsOutput {
            crate::output::DescribeOptOutListsOutput {
                opt_out_lists: self.opt_out_lists,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeOptOutListsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOptOutListsOutput`](crate::output::DescribeOptOutListsOutput)
    pub fn builder() -> crate::output::describe_opt_out_lists_output::Builder {
        crate::output::describe_opt_out_lists_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOptedOutNumbersOutput {
    /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
    pub opt_out_list_arn: std::option::Option<std::string::String>,
    /// <p>The name of the OptOutList.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>
    pub opted_out_numbers:
        std::option::Option<std::vec::Vec<crate::model::OptedOutNumberInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOptedOutNumbersOutput {
    /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
    pub fn opt_out_list_arn(&self) -> std::option::Option<&str> {
        self.opt_out_list_arn.as_deref()
    }
    /// <p>The name of the OptOutList.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>
    pub fn opted_out_numbers(
        &self,
    ) -> std::option::Option<&[crate::model::OptedOutNumberInformation]> {
        self.opted_out_numbers.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOptedOutNumbersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOptedOutNumbersOutput");
        formatter.field("opt_out_list_arn", &self.opt_out_list_arn);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("opted_out_numbers", &self.opted_out_numbers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeOptedOutNumbersOutput`](crate::output::DescribeOptedOutNumbersOutput)
pub mod describe_opted_out_numbers_output {
    /// A builder for [`DescribeOptedOutNumbersOutput`](crate::output::DescribeOptedOutNumbersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_arn: std::option::Option<std::string::String>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) opted_out_numbers:
            std::option::Option<std::vec::Vec<crate::model::OptedOutNumberInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
        pub fn opt_out_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
        pub fn set_opt_out_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_arn = input;
            self
        }
        /// <p>The name of the OptOutList.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// Appends an item to `opted_out_numbers`.
        ///
        /// To override the contents of this collection use [`set_opted_out_numbers`](Self::set_opted_out_numbers).
        ///
        /// <p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>
        pub fn opted_out_numbers(mut self, input: crate::model::OptedOutNumberInformation) -> Self {
            let mut v = self.opted_out_numbers.unwrap_or_default();
            v.push(input);
            self.opted_out_numbers = Some(v);
            self
        }
        /// <p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>
        pub fn set_opted_out_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptedOutNumberInformation>>,
        ) -> Self {
            self.opted_out_numbers = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOptedOutNumbersOutput`](crate::output::DescribeOptedOutNumbersOutput)
        pub fn build(self) -> crate::output::DescribeOptedOutNumbersOutput {
            crate::output::DescribeOptedOutNumbersOutput {
                opt_out_list_arn: self.opt_out_list_arn,
                opt_out_list_name: self.opt_out_list_name,
                opted_out_numbers: self.opted_out_numbers,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeOptedOutNumbersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOptedOutNumbersOutput`](crate::output::DescribeOptedOutNumbersOutput)
    pub fn builder() -> crate::output::describe_opted_out_numbers_output::Builder {
        crate::output::describe_opted_out_numbers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeKeywordsOutput {
    /// <p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>
    pub origination_identity_arn: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>An array of KeywordInformation objects that contain the results.</p>
    pub keywords: std::option::Option<std::vec::Vec<crate::model::KeywordInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeKeywordsOutput {
    /// <p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>
    pub fn origination_identity_arn(&self) -> std::option::Option<&str> {
        self.origination_identity_arn.as_deref()
    }
    /// <p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>An array of KeywordInformation objects that contain the results.</p>
    pub fn keywords(&self) -> std::option::Option<&[crate::model::KeywordInformation]> {
        self.keywords.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeKeywordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeKeywordsOutput");
        formatter.field("origination_identity_arn", &self.origination_identity_arn);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("keywords", &self.keywords);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeKeywordsOutput`](crate::output::DescribeKeywordsOutput)
pub mod describe_keywords_output {
    /// A builder for [`DescribeKeywordsOutput`](crate::output::DescribeKeywordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity_arn: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::vec::Vec<crate::model::KeywordInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>
        pub fn origination_identity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity_arn = Some(input.into());
            self
        }
        /// <p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>
        pub fn set_origination_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity_arn = input;
            self
        }
        /// <p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array of KeywordInformation objects that contain the results.</p>
        pub fn keywords(mut self, input: crate::model::KeywordInformation) -> Self {
            let mut v = self.keywords.unwrap_or_default();
            v.push(input);
            self.keywords = Some(v);
            self
        }
        /// <p>An array of KeywordInformation objects that contain the results.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeywordInformation>>,
        ) -> Self {
            self.keywords = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeKeywordsOutput`](crate::output::DescribeKeywordsOutput)
        pub fn build(self) -> crate::output::DescribeKeywordsOutput {
            crate::output::DescribeKeywordsOutput {
                origination_identity_arn: self.origination_identity_arn,
                origination_identity: self.origination_identity,
                keywords: self.keywords,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeKeywordsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeKeywordsOutput`](crate::output::DescribeKeywordsOutput)
    pub fn builder() -> crate::output::describe_keywords_output::Builder {
        crate::output::describe_keywords_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationSetsOutput {
    /// <p>An array of ConfigurationSets objects.</p>
    pub configuration_sets:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationSetInformation>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConfigurationSetsOutput {
    /// <p>An array of ConfigurationSets objects.</p>
    pub fn configuration_sets(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationSetInformation]> {
        self.configuration_sets.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationSetsOutput");
        formatter.field("configuration_sets", &self.configuration_sets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationSetsOutput`](crate::output::DescribeConfigurationSetsOutput)
pub mod describe_configuration_sets_output {
    /// A builder for [`DescribeConfigurationSetsOutput`](crate::output::DescribeConfigurationSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_sets:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationSetInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `configuration_sets`.
        ///
        /// To override the contents of this collection use [`set_configuration_sets`](Self::set_configuration_sets).
        ///
        /// <p>An array of ConfigurationSets objects.</p>
        pub fn configuration_sets(
            mut self,
            input: crate::model::ConfigurationSetInformation,
        ) -> Self {
            let mut v = self.configuration_sets.unwrap_or_default();
            v.push(input);
            self.configuration_sets = Some(v);
            self
        }
        /// <p>An array of ConfigurationSets objects.</p>
        pub fn set_configuration_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetInformation>>,
        ) -> Self {
            self.configuration_sets = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationSetsOutput`](crate::output::DescribeConfigurationSetsOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationSetsOutput {
            crate::output::DescribeConfigurationSetsOutput {
                configuration_sets: self.configuration_sets,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeConfigurationSetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSetsOutput`](crate::output::DescribeConfigurationSetsOutput)
    pub fn builder() -> crate::output::describe_configuration_sets_output::Builder {
        crate::output::describe_configuration_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountLimitsOutput {
    /// <p>An array of AccountLimit objects that show the current spend limits.</p>
    pub account_limits: std::option::Option<std::vec::Vec<crate::model::AccountLimit>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAccountLimitsOutput {
    /// <p>An array of AccountLimit objects that show the current spend limits.</p>
    pub fn account_limits(&self) -> std::option::Option<&[crate::model::AccountLimit]> {
        self.account_limits.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountLimitsOutput");
        formatter.field("account_limits", &self.account_limits);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
pub mod describe_account_limits_output {
    /// A builder for [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_limits: std::option::Option<std::vec::Vec<crate::model::AccountLimit>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_limits`.
        ///
        /// To override the contents of this collection use [`set_account_limits`](Self::set_account_limits).
        ///
        /// <p>An array of AccountLimit objects that show the current spend limits.</p>
        pub fn account_limits(mut self, input: crate::model::AccountLimit) -> Self {
            let mut v = self.account_limits.unwrap_or_default();
            v.push(input);
            self.account_limits = Some(v);
            self
        }
        /// <p>An array of AccountLimit objects that show the current spend limits.</p>
        pub fn set_account_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountLimit>>,
        ) -> Self {
            self.account_limits = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
        pub fn build(self) -> crate::output::DescribeAccountLimitsOutput {
            crate::output::DescribeAccountLimitsOutput {
                account_limits: self.account_limits,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAccountLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
    pub fn builder() -> crate::output::describe_account_limits_output::Builder {
        crate::output::describe_account_limits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesOutput {
    /// <p>An array of AccountAttributes objects.</p>
    pub account_attributes: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAccountAttributesOutput {
    /// <p>An array of AccountAttributes objects.</p>
    pub fn account_attributes(&self) -> std::option::Option<&[crate::model::AccountAttribute]> {
        self.account_attributes.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesOutput");
        formatter.field("account_attributes", &self.account_attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
pub mod describe_account_attributes_output {
    /// A builder for [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_attributes:
            std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_attributes`.
        ///
        /// To override the contents of this collection use [`set_account_attributes`](Self::set_account_attributes).
        ///
        /// <p>An array of AccountAttributes objects.</p>
        pub fn account_attributes(mut self, input: crate::model::AccountAttribute) -> Self {
            let mut v = self.account_attributes.unwrap_or_default();
            v.push(input);
            self.account_attributes = Some(v);
            self
        }
        /// <p>An array of AccountAttributes objects.</p>
        pub fn set_account_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
        ) -> Self {
            self.account_attributes = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
        pub fn build(self) -> crate::output::DescribeAccountAttributesOutput {
            crate::output::DescribeAccountAttributesOutput {
                account_attributes: self.account_attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAccountAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    pub fn builder() -> crate::output::describe_account_attributes_output::Builder {
        crate::output::describe_account_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVoiceMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit, in US dollars.</p>
    pub monthly_limit: std::option::Option<i64>,
}
impl DeleteVoiceMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit, in US dollars.</p>
    pub fn monthly_limit(&self) -> std::option::Option<i64> {
        self.monthly_limit
    }
}
impl std::fmt::Debug for DeleteVoiceMessageSpendLimitOverrideOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVoiceMessageSpendLimitOverrideOutput");
        formatter.field("monthly_limit", &self.monthly_limit);
        formatter.finish()
    }
}
/// See [`DeleteVoiceMessageSpendLimitOverrideOutput`](crate::output::DeleteVoiceMessageSpendLimitOverrideOutput)
pub mod delete_voice_message_spend_limit_override_output {
    /// A builder for [`DeleteVoiceMessageSpendLimitOverrideOutput`](crate::output::DeleteVoiceMessageSpendLimitOverrideOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current monthly limit, in US dollars.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.monthly_limit = Some(input);
            self
        }
        /// <p>The current monthly limit, in US dollars.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.monthly_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceMessageSpendLimitOverrideOutput`](crate::output::DeleteVoiceMessageSpendLimitOverrideOutput)
        pub fn build(self) -> crate::output::DeleteVoiceMessageSpendLimitOverrideOutput {
            crate::output::DeleteVoiceMessageSpendLimitOverrideOutput {
                monthly_limit: self.monthly_limit,
            }
        }
    }
}
impl DeleteVoiceMessageSpendLimitOverrideOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceMessageSpendLimitOverrideOutput`](crate::output::DeleteVoiceMessageSpendLimitOverrideOutput)
    pub fn builder() -> crate::output::delete_voice_message_spend_limit_override_output::Builder {
        crate::output::delete_voice_message_spend_limit_override_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTextMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit, in US dollars.</p>
    pub monthly_limit: std::option::Option<i64>,
}
impl DeleteTextMessageSpendLimitOverrideOutput {
    /// <p>The current monthly limit, in US dollars.</p>
    pub fn monthly_limit(&self) -> std::option::Option<i64> {
        self.monthly_limit
    }
}
impl std::fmt::Debug for DeleteTextMessageSpendLimitOverrideOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTextMessageSpendLimitOverrideOutput");
        formatter.field("monthly_limit", &self.monthly_limit);
        formatter.finish()
    }
}
/// See [`DeleteTextMessageSpendLimitOverrideOutput`](crate::output::DeleteTextMessageSpendLimitOverrideOutput)
pub mod delete_text_message_spend_limit_override_output {
    /// A builder for [`DeleteTextMessageSpendLimitOverrideOutput`](crate::output::DeleteTextMessageSpendLimitOverrideOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current monthly limit, in US dollars.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.monthly_limit = Some(input);
            self
        }
        /// <p>The current monthly limit, in US dollars.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.monthly_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTextMessageSpendLimitOverrideOutput`](crate::output::DeleteTextMessageSpendLimitOverrideOutput)
        pub fn build(self) -> crate::output::DeleteTextMessageSpendLimitOverrideOutput {
            crate::output::DeleteTextMessageSpendLimitOverrideOutput {
                monthly_limit: self.monthly_limit,
            }
        }
    }
}
impl DeleteTextMessageSpendLimitOverrideOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTextMessageSpendLimitOverrideOutput`](crate::output::DeleteTextMessageSpendLimitOverrideOutput)
    pub fn builder() -> crate::output::delete_text_message_spend_limit_override_output::Builder {
        crate::output::delete_text_message_spend_limit_override_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePoolOutput {
    /// <p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The PoolId of the pool that was deleted.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The current status of the pool.</p>
    /// <ul>
    /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
    /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
    /// <li> <p>DELETING: The pool is being deleted.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PoolStatus>,
    /// <p>The message type that was associated with the deleted pool.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList that was associated with the deleted pool.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub shared_routes_enabled: bool,
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeletePoolOutput {
    /// <p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The PoolId of the pool that was deleted.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The current status of the pool.</p>
    /// <ul>
    /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
    /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
    /// <li> <p>DELETING: The pool is being deleted.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PoolStatus> {
        self.status.as_ref()
    }
    /// <p>The message type that was associated with the deleted pool.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList that was associated with the deleted pool.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub fn shared_routes_enabled(&self) -> bool {
        self.shared_routes_enabled
    }
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DeletePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePoolOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("status", &self.status);
        formatter.field("message_type", &self.message_type);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("shared_routes_enabled", &self.shared_routes_enabled);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`DeletePoolOutput`](crate::output::DeletePoolOutput)
pub mod delete_pool_output {
    /// A builder for [`DeletePoolOutput`](crate::output::DeletePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PoolStatus>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) shared_routes_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The PoolId of the pool that was deleted.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The PoolId of the pool that was deleted.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The current status of the pool.</p>
        /// <ul>
        /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
        /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
        /// <li> <p>DELETING: The pool is being deleted.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PoolStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the pool.</p>
        /// <ul>
        /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
        /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
        /// <li> <p>DELETING: The pool is being deleted.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::PoolStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The message type that was associated with the deleted pool.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The message type that was associated with the deleted pool.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList that was associated with the deleted pool.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList that was associated with the deleted pool.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn shared_routes_enabled(mut self, input: bool) -> Self {
            self.shared_routes_enabled = Some(input);
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn set_shared_routes_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.shared_routes_enabled = input;
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePoolOutput`](crate::output::DeletePoolOutput)
        pub fn build(self) -> crate::output::DeletePoolOutput {
            crate::output::DeletePoolOutput {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                status: self.status,
                message_type: self.message_type,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                shared_routes_enabled: self.shared_routes_enabled.unwrap_or_default(),
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl DeletePoolOutput {
    /// Creates a new builder-style object to manufacture [`DeletePoolOutput`](crate::output::DeletePoolOutput)
    pub fn builder() -> crate::output::delete_pool_output::Builder {
        crate::output::delete_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOptOutListOutput {
    /// <p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>
    pub opt_out_list_arn: std::option::Option<std::string::String>,
    /// <p>The name of the OptOutList that was removed.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteOptOutListOutput {
    /// <p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>
    pub fn opt_out_list_arn(&self) -> std::option::Option<&str> {
        self.opt_out_list_arn.as_deref()
    }
    /// <p>The name of the OptOutList that was removed.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DeleteOptOutListOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOptOutListOutput");
        formatter.field("opt_out_list_arn", &self.opt_out_list_arn);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`DeleteOptOutListOutput`](crate::output::DeleteOptOutListOutput)
pub mod delete_opt_out_list_output {
    /// A builder for [`DeleteOptOutListOutput`](crate::output::DeleteOptOutListOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_arn: std::option::Option<std::string::String>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>
        pub fn opt_out_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>
        pub fn set_opt_out_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_arn = input;
            self
        }
        /// <p>The name of the OptOutList that was removed.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList that was removed.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOptOutListOutput`](crate::output::DeleteOptOutListOutput)
        pub fn build(self) -> crate::output::DeleteOptOutListOutput {
            crate::output::DeleteOptOutListOutput {
                opt_out_list_arn: self.opt_out_list_arn,
                opt_out_list_name: self.opt_out_list_name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl DeleteOptOutListOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOptOutListOutput`](crate::output::DeleteOptOutListOutput)
    pub fn builder() -> crate::output::delete_opt_out_list_output::Builder {
        crate::output::delete_opt_out_list_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOptedOutNumberOutput {
    /// <p>The OptOutListArn that the phone number was removed from.</p>
    pub opt_out_list_arn: std::option::Option<std::string::String>,
    /// <p>The OptOutListName that the phone number was removed from.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The phone number that was removed from the OptOutList.</p>
    pub opted_out_number: std::option::Option<std::string::String>,
    /// <p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub opted_out_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>This is true if it was the end user who requested their phone number be removed. </p>
    pub end_user_opted_out: bool,
}
impl DeleteOptedOutNumberOutput {
    /// <p>The OptOutListArn that the phone number was removed from.</p>
    pub fn opt_out_list_arn(&self) -> std::option::Option<&str> {
        self.opt_out_list_arn.as_deref()
    }
    /// <p>The OptOutListName that the phone number was removed from.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The phone number that was removed from the OptOutList.</p>
    pub fn opted_out_number(&self) -> std::option::Option<&str> {
        self.opted_out_number.as_deref()
    }
    /// <p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn opted_out_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.opted_out_timestamp.as_ref()
    }
    /// <p>This is true if it was the end user who requested their phone number be removed. </p>
    pub fn end_user_opted_out(&self) -> bool {
        self.end_user_opted_out
    }
}
impl std::fmt::Debug for DeleteOptedOutNumberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOptedOutNumberOutput");
        formatter.field("opt_out_list_arn", &self.opt_out_list_arn);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("opted_out_number", &self.opted_out_number);
        formatter.field("opted_out_timestamp", &self.opted_out_timestamp);
        formatter.field("end_user_opted_out", &self.end_user_opted_out);
        formatter.finish()
    }
}
/// See [`DeleteOptedOutNumberOutput`](crate::output::DeleteOptedOutNumberOutput)
pub mod delete_opted_out_number_output {
    /// A builder for [`DeleteOptedOutNumberOutput`](crate::output::DeleteOptedOutNumberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_arn: std::option::Option<std::string::String>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) opted_out_number: std::option::Option<std::string::String>,
        pub(crate) opted_out_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_user_opted_out: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The OptOutListArn that the phone number was removed from.</p>
        pub fn opt_out_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_arn = Some(input.into());
            self
        }
        /// <p>The OptOutListArn that the phone number was removed from.</p>
        pub fn set_opt_out_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_arn = input;
            self
        }
        /// <p>The OptOutListName that the phone number was removed from.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutListName that the phone number was removed from.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The phone number that was removed from the OptOutList.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.opted_out_number = Some(input.into());
            self
        }
        /// <p>The phone number that was removed from the OptOutList.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opted_out_number = input;
            self
        }
        /// <p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn opted_out_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.opted_out_timestamp = Some(input);
            self
        }
        /// <p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_opted_out_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.opted_out_timestamp = input;
            self
        }
        /// <p>This is true if it was the end user who requested their phone number be removed. </p>
        pub fn end_user_opted_out(mut self, input: bool) -> Self {
            self.end_user_opted_out = Some(input);
            self
        }
        /// <p>This is true if it was the end user who requested their phone number be removed. </p>
        pub fn set_end_user_opted_out(mut self, input: std::option::Option<bool>) -> Self {
            self.end_user_opted_out = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOptedOutNumberOutput`](crate::output::DeleteOptedOutNumberOutput)
        pub fn build(self) -> crate::output::DeleteOptedOutNumberOutput {
            crate::output::DeleteOptedOutNumberOutput {
                opt_out_list_arn: self.opt_out_list_arn,
                opt_out_list_name: self.opt_out_list_name,
                opted_out_number: self.opted_out_number,
                opted_out_timestamp: self.opted_out_timestamp,
                end_user_opted_out: self.end_user_opted_out.unwrap_or_default(),
            }
        }
    }
}
impl DeleteOptedOutNumberOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOptedOutNumberOutput`](crate::output::DeleteOptedOutNumberOutput)
    pub fn builder() -> crate::output::delete_opted_out_number_output::Builder {
        crate::output::delete_opted_out_number_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeywordOutput {
    /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
    pub origination_identity_arn: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The keyword that was deleted.</p>
    pub keyword: std::option::Option<std::string::String>,
    /// <p>The message that was associated with the deleted keyword.</p>
    pub keyword_message: std::option::Option<std::string::String>,
    /// <p>The action that was associated with the deleted keyword.</p>
    pub keyword_action: std::option::Option<crate::model::KeywordAction>,
}
impl DeleteKeywordOutput {
    /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
    pub fn origination_identity_arn(&self) -> std::option::Option<&str> {
        self.origination_identity_arn.as_deref()
    }
    /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The keyword that was deleted.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
    /// <p>The message that was associated with the deleted keyword.</p>
    pub fn keyword_message(&self) -> std::option::Option<&str> {
        self.keyword_message.as_deref()
    }
    /// <p>The action that was associated with the deleted keyword.</p>
    pub fn keyword_action(&self) -> std::option::Option<&crate::model::KeywordAction> {
        self.keyword_action.as_ref()
    }
}
impl std::fmt::Debug for DeleteKeywordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeywordOutput");
        formatter.field("origination_identity_arn", &self.origination_identity_arn);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("keyword", &self.keyword);
        formatter.field("keyword_message", &self.keyword_message);
        formatter.field("keyword_action", &self.keyword_action);
        formatter.finish()
    }
}
/// See [`DeleteKeywordOutput`](crate::output::DeleteKeywordOutput)
pub mod delete_keyword_output {
    /// A builder for [`DeleteKeywordOutput`](crate::output::DeleteKeywordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity_arn: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) keyword: std::option::Option<std::string::String>,
        pub(crate) keyword_message: std::option::Option<std::string::String>,
        pub(crate) keyword_action: std::option::Option<crate::model::KeywordAction>,
    }
    impl Builder {
        /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
        pub fn origination_identity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity_arn = Some(input.into());
            self
        }
        /// <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
        pub fn set_origination_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity_arn = input;
            self
        }
        /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The keyword that was deleted.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>The keyword that was deleted.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// <p>The message that was associated with the deleted keyword.</p>
        pub fn keyword_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword_message = Some(input.into());
            self
        }
        /// <p>The message that was associated with the deleted keyword.</p>
        pub fn set_keyword_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyword_message = input;
            self
        }
        /// <p>The action that was associated with the deleted keyword.</p>
        pub fn keyword_action(mut self, input: crate::model::KeywordAction) -> Self {
            self.keyword_action = Some(input);
            self
        }
        /// <p>The action that was associated with the deleted keyword.</p>
        pub fn set_keyword_action(
            mut self,
            input: std::option::Option<crate::model::KeywordAction>,
        ) -> Self {
            self.keyword_action = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeywordOutput`](crate::output::DeleteKeywordOutput)
        pub fn build(self) -> crate::output::DeleteKeywordOutput {
            crate::output::DeleteKeywordOutput {
                origination_identity_arn: self.origination_identity_arn,
                origination_identity: self.origination_identity,
                keyword: self.keyword,
                keyword_message: self.keyword_message,
                keyword_action: self.keyword_action,
            }
        }
    }
}
impl DeleteKeywordOutput {
    /// Creates a new builder-style object to manufacture [`DeleteKeywordOutput`](crate::output::DeleteKeywordOutput)
    pub fn builder() -> crate::output::delete_keyword_output::Builder {
        crate::output::delete_keyword_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventDestinationOutput {
    /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set the event destination was deleted from.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The event destination object that was deleted.</p>
    pub event_destination: std::option::Option<crate::model::EventDestination>,
}
impl DeleteEventDestinationOutput {
    /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set the event destination was deleted from.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The event destination object that was deleted.</p>
    pub fn event_destination(&self) -> std::option::Option<&crate::model::EventDestination> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for DeleteEventDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventDestinationOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}
/// See [`DeleteEventDestinationOutput`](crate::output::DeleteEventDestinationOutput)
pub mod delete_event_destination_output {
    /// A builder for [`DeleteEventDestinationOutput`](crate::output::DeleteEventDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestination>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set the event destination was deleted from.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set the event destination was deleted from.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The event destination object that was deleted.</p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>The event destination object that was deleted.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventDestinationOutput`](crate::output::DeleteEventDestinationOutput)
        pub fn build(self) -> crate::output::DeleteEventDestinationOutput {
            crate::output::DeleteEventDestinationOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
            }
        }
    }
}
impl DeleteEventDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventDestinationOutput`](crate::output::DeleteEventDestinationOutput)
    pub fn builder() -> crate::output::delete_event_destination_output::Builder {
        crate::output::delete_event_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDefaultSenderIdOutput {
    /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The current sender ID for the configuration set.</p>
    pub sender_id: std::option::Option<std::string::String>,
}
impl DeleteDefaultSenderIdOutput {
    /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The current sender ID for the configuration set.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDefaultSenderIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDefaultSenderIdOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("sender_id", &self.sender_id);
        formatter.finish()
    }
}
/// See [`DeleteDefaultSenderIdOutput`](crate::output::DeleteDefaultSenderIdOutput)
pub mod delete_default_sender_id_output {
    /// A builder for [`DeleteDefaultSenderIdOutput`](crate::output::DeleteDefaultSenderIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The current sender ID for the configuration set.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The current sender ID for the configuration set.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDefaultSenderIdOutput`](crate::output::DeleteDefaultSenderIdOutput)
        pub fn build(self) -> crate::output::DeleteDefaultSenderIdOutput {
            crate::output::DeleteDefaultSenderIdOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                sender_id: self.sender_id,
            }
        }
    }
}
impl DeleteDefaultSenderIdOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDefaultSenderIdOutput`](crate::output::DeleteDefaultSenderIdOutput)
    pub fn builder() -> crate::output::delete_default_sender_id_output::Builder {
        crate::output::delete_default_sender_id_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDefaultMessageTypeOutput {
    /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The current message type for the configuration set.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
}
impl DeleteDefaultMessageTypeOutput {
    /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The current message type for the configuration set.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
}
impl std::fmt::Debug for DeleteDefaultMessageTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDefaultMessageTypeOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message_type", &self.message_type);
        formatter.finish()
    }
}
/// See [`DeleteDefaultMessageTypeOutput`](crate::output::DeleteDefaultMessageTypeOutput)
pub mod delete_default_message_type_output {
    /// A builder for [`DeleteDefaultMessageTypeOutput`](crate::output::DeleteDefaultMessageTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The current message type for the configuration set.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The current message type for the configuration set.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDefaultMessageTypeOutput`](crate::output::DeleteDefaultMessageTypeOutput)
        pub fn build(self) -> crate::output::DeleteDefaultMessageTypeOutput {
            crate::output::DeleteDefaultMessageTypeOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                message_type: self.message_type,
            }
        }
    }
}
impl DeleteDefaultMessageTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDefaultMessageTypeOutput`](crate::output::DeleteDefaultMessageTypeOutput)
    pub fn builder() -> crate::output::delete_default_message_type_output::Builder {
        crate::output::delete_default_message_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the deleted configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>
    pub event_destinations: std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
    /// <p>The default message type of the configuration set that was deleted.</p>
    pub default_message_type: std::option::Option<crate::model::MessageType>,
    /// <p>The default Sender ID of the configuration set that was deleted.</p>
    pub default_sender_id: std::option::Option<std::string::String>,
    /// <p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteConfigurationSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the deleted configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>
    pub fn event_destinations(&self) -> std::option::Option<&[crate::model::EventDestination]> {
        self.event_destinations.as_deref()
    }
    /// <p>The default message type of the configuration set that was deleted.</p>
    pub fn default_message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.default_message_type.as_ref()
    }
    /// <p>The default Sender ID of the configuration set that was deleted.</p>
    pub fn default_sender_id(&self) -> std::option::Option<&str> {
        self.default_sender_id.as_deref()
    }
    /// <p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destinations", &self.event_destinations);
        formatter.field("default_message_type", &self.default_message_type);
        formatter.field("default_sender_id", &self.default_sender_id);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
pub mod delete_configuration_set_output {
    /// A builder for [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destinations:
            std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
        pub(crate) default_message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) default_sender_id: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the deleted configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the deleted configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `event_destinations`.
        ///
        /// To override the contents of this collection use [`set_event_destinations`](Self::set_event_destinations).
        ///
        /// <p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>
        pub fn event_destinations(mut self, input: crate::model::EventDestination) -> Self {
            let mut v = self.event_destinations.unwrap_or_default();
            v.push(input);
            self.event_destinations = Some(v);
            self
        }
        /// <p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>
        pub fn set_event_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
        ) -> Self {
            self.event_destinations = input;
            self
        }
        /// <p>The default message type of the configuration set that was deleted.</p>
        pub fn default_message_type(mut self, input: crate::model::MessageType) -> Self {
            self.default_message_type = Some(input);
            self
        }
        /// <p>The default message type of the configuration set that was deleted.</p>
        pub fn set_default_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.default_message_type = input;
            self
        }
        /// <p>The default Sender ID of the configuration set that was deleted.</p>
        pub fn default_sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_sender_id = Some(input.into());
            self
        }
        /// <p>The default Sender ID of the configuration set that was deleted.</p>
        pub fn set_default_sender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_sender_id = input;
            self
        }
        /// <p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
        pub fn build(self) -> crate::output::DeleteConfigurationSetOutput {
            crate::output::DeleteConfigurationSetOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                event_destinations: self.event_destinations,
                default_message_type: self.default_message_type,
                default_sender_id: self.default_sender_id,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl DeleteConfigurationSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
    pub fn builder() -> crate::output::delete_configuration_set_output::Builder {
        crate::output::delete_configuration_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePoolOutput {
    /// <p>The Amazon Resource Name (ARN) for the pool.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the pool.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The current status of the pool.</p>
    /// <ul>
    /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
    /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
    /// <li> <p>DELETING: The pool is being deleted.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PoolStatus>,
    /// <p>The type of message for the pool to use.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList associated with the pool.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub shared_routes_enabled: bool,
    /// <p>When set to true deletion protection is enabled. By default this is set to false. </p>
    pub deletion_protection_enabled: bool,
    /// <p>An array of tags (key and value pairs) associated with the pool.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreatePoolOutput {
    /// <p>The Amazon Resource Name (ARN) for the pool.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The unique identifier for the pool.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The current status of the pool.</p>
    /// <ul>
    /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
    /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
    /// <li> <p>DELETING: The pool is being deleted.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PoolStatus> {
        self.status.as_ref()
    }
    /// <p>The type of message for the pool to use.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList associated with the pool.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub fn shared_routes_enabled(&self) -> bool {
        self.shared_routes_enabled
    }
    /// <p>When set to true deletion protection is enabled. By default this is set to false. </p>
    pub fn deletion_protection_enabled(&self) -> bool {
        self.deletion_protection_enabled
    }
    /// <p>An array of tags (key and value pairs) associated with the pool.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for CreatePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePoolOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("status", &self.status);
        formatter.field("message_type", &self.message_type);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("shared_routes_enabled", &self.shared_routes_enabled);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("tags", &self.tags);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`CreatePoolOutput`](crate::output::CreatePoolOutput)
pub mod create_pool_output {
    /// A builder for [`CreatePoolOutput`](crate::output::CreatePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PoolStatus>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) shared_routes_enabled: std::option::Option<bool>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the pool.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the pool.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The unique identifier for the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The current status of the pool.</p>
        /// <ul>
        /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
        /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
        /// <li> <p>DELETING: The pool is being deleted.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PoolStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the pool.</p>
        /// <ul>
        /// <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>
        /// <li> <p>ACTIVE: The pool is active and available for use.</p> </li>
        /// <li> <p>DELETING: The pool is being deleted.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::PoolStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of message for the pool to use.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message for the pool to use.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList associated with the pool.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList associated with the pool.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn shared_routes_enabled(mut self, input: bool) -> Self {
            self.shared_routes_enabled = Some(input);
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn set_shared_routes_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.shared_routes_enabled = input;
            self
        }
        /// <p>When set to true deletion protection is enabled. By default this is set to false. </p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>When set to true deletion protection is enabled. By default this is set to false. </p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) associated with the pool.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags (key and value pairs) associated with the pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePoolOutput`](crate::output::CreatePoolOutput)
        pub fn build(self) -> crate::output::CreatePoolOutput {
            crate::output::CreatePoolOutput {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                status: self.status,
                message_type: self.message_type,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                shared_routes_enabled: self.shared_routes_enabled.unwrap_or_default(),
                deletion_protection_enabled: self.deletion_protection_enabled.unwrap_or_default(),
                tags: self.tags,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl CreatePoolOutput {
    /// Creates a new builder-style object to manufacture [`CreatePoolOutput`](crate::output::CreatePoolOutput)
    pub fn builder() -> crate::output::create_pool_output::Builder {
        crate::output::create_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOptOutListOutput {
    /// <p>The Amazon Resource Name (ARN) for the OptOutList.</p>
    pub opt_out_list_arn: std::option::Option<std::string::String>,
    /// <p>The name of the new OptOutList.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>An array of tags (key and value pairs) associated with the new OptOutList.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateOptOutListOutput {
    /// <p>The Amazon Resource Name (ARN) for the OptOutList.</p>
    pub fn opt_out_list_arn(&self) -> std::option::Option<&str> {
        self.opt_out_list_arn.as_deref()
    }
    /// <p>The name of the new OptOutList.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>An array of tags (key and value pairs) associated with the new OptOutList.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for CreateOptOutListOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOptOutListOutput");
        formatter.field("opt_out_list_arn", &self.opt_out_list_arn);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("tags", &self.tags);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`CreateOptOutListOutput`](crate::output::CreateOptOutListOutput)
pub mod create_opt_out_list_output {
    /// A builder for [`CreateOptOutListOutput`](crate::output::CreateOptOutListOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_arn: std::option::Option<std::string::String>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the OptOutList.</p>
        pub fn opt_out_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the OptOutList.</p>
        pub fn set_opt_out_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_arn = input;
            self
        }
        /// <p>The name of the new OptOutList.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the new OptOutList.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) associated with the new OptOutList.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags (key and value pairs) associated with the new OptOutList.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOptOutListOutput`](crate::output::CreateOptOutListOutput)
        pub fn build(self) -> crate::output::CreateOptOutListOutput {
            crate::output::CreateOptOutListOutput {
                opt_out_list_arn: self.opt_out_list_arn,
                opt_out_list_name: self.opt_out_list_name,
                tags: self.tags,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl CreateOptOutListOutput {
    /// Creates a new builder-style object to manufacture [`CreateOptOutListOutput`](crate::output::CreateOptOutListOutput)
    pub fn builder() -> crate::output::create_opt_out_list_output::Builder {
        crate::output::create_opt_out_list_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventDestinationOutput {
    /// <p>The ARN of the configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The details of the destination where events are logged.</p>
    pub event_destination: std::option::Option<crate::model::EventDestination>,
}
impl CreateEventDestinationOutput {
    /// <p>The ARN of the configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The details of the destination where events are logged.</p>
    pub fn event_destination(&self) -> std::option::Option<&crate::model::EventDestination> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for CreateEventDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventDestinationOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}
/// See [`CreateEventDestinationOutput`](crate::output::CreateEventDestinationOutput)
pub mod create_event_destination_output {
    /// A builder for [`CreateEventDestinationOutput`](crate::output::CreateEventDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestination>,
    }
    impl Builder {
        /// <p>The ARN of the configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The details of the destination where events are logged.</p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>The details of the destination where events are logged.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventDestinationOutput`](crate::output::CreateEventDestinationOutput)
        pub fn build(self) -> crate::output::CreateEventDestinationOutput {
            crate::output::CreateEventDestinationOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
            }
        }
    }
}
impl CreateEventDestinationOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventDestinationOutput`](crate::output::CreateEventDestinationOutput)
    pub fn builder() -> crate::output::create_event_destination_output::Builder {
        crate::output::create_event_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the new configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An array of key and value pair tags that's associated with the configuration set.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateConfigurationSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the new configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An array of key and value pair tags that's associated with the configuration set.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetOutput");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("tags", &self.tags);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
pub mod create_configuration_set_output {
    /// A builder for [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the new configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the new configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that's associated with the configuration set.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of key and value pair tags that's associated with the configuration set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
        pub fn build(self) -> crate::output::CreateConfigurationSetOutput {
            crate::output::CreateConfigurationSetOutput {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                tags: self.tags,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl CreateConfigurationSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
    pub fn builder() -> crate::output::create_configuration_set_output::Builder {
        crate::output::create_configuration_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateOriginationIdentityOutput {
    /// <p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The PoolId of the pool that is now associated with the origination identity.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
    pub origination_identity_arn: std::option::Option<std::string::String>,
    /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
}
impl AssociateOriginationIdentityOutput {
    /// <p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The PoolId of the pool that is now associated with the origination identity.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
    pub fn origination_identity_arn(&self) -> std::option::Option<&str> {
        self.origination_identity_arn.as_deref()
    }
    /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
}
impl std::fmt::Debug for AssociateOriginationIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateOriginationIdentityOutput");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("origination_identity_arn", &self.origination_identity_arn);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.finish()
    }
}
/// See [`AssociateOriginationIdentityOutput`](crate::output::AssociateOriginationIdentityOutput)
pub mod associate_origination_identity_output {
    /// A builder for [`AssociateOriginationIdentityOutput`](crate::output::AssociateOriginationIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) origination_identity_arn: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The PoolId of the pool that is now associated with the origination identity.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The PoolId of the pool that is now associated with the origination identity.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
        pub fn origination_identity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity_arn = Some(input.into());
            self
        }
        /// <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
        pub fn set_origination_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity_arn = input;
            self
        }
        /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId or SenderId of the origination identity.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateOriginationIdentityOutput`](crate::output::AssociateOriginationIdentityOutput)
        pub fn build(self) -> crate::output::AssociateOriginationIdentityOutput {
            crate::output::AssociateOriginationIdentityOutput {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                origination_identity_arn: self.origination_identity_arn,
                origination_identity: self.origination_identity,
                iso_country_code: self.iso_country_code,
            }
        }
    }
}
impl AssociateOriginationIdentityOutput {
    /// Creates a new builder-style object to manufacture [`AssociateOriginationIdentityOutput`](crate::output::AssociateOriginationIdentityOutput)
    pub fn builder() -> crate::output::associate_origination_identity_output::Builder {
        crate::output::associate_origination_identity_output::Builder::default()
    }
}
