// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateOriginationIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_origination_identity`](crate::client::Client::associate_origination_identity).
///
/// See [`crate::client::fluent_builders::AssociateOriginationIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateOriginationIdentity {
    _private: (),
}
impl AssociateOriginationIdentity {
    /// Creates a new builder-style object to manufacture [`AssociateOriginationIdentityInput`](crate::input::AssociateOriginationIdentityInput)
    pub fn builder() -> crate::input::associate_origination_identity_input::Builder {
        crate::input::associate_origination_identity_input::Builder::default()
    }
    /// Creates a new `AssociateOriginationIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateOriginationIdentity {
    type Output = std::result::Result<
        crate::output::AssociateOriginationIdentityOutput,
        crate::error::AssociateOriginationIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_origination_identity_error(response)
        } else {
            crate::operation_deser::parse_associate_origination_identity_response(response)
        }
    }
}

/// Operation shape for `CreateConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_set`](crate::client::Client::create_configuration_set).
///
/// See [`crate::client::fluent_builders::CreateConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationSet {
    _private: (),
}
impl CreateConfigurationSet {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationSet {
    type Output = std::result::Result<
        crate::output::CreateConfigurationSetOutput,
        crate::error::CreateConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_set_response(response)
        }
    }
}

/// Operation shape for `CreateEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_destination`](crate::client::Client::create_event_destination).
///
/// See [`crate::client::fluent_builders::CreateEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventDestination {
    _private: (),
}
impl CreateEventDestination {
    /// Creates a new builder-style object to manufacture [`CreateEventDestinationInput`](crate::input::CreateEventDestinationInput)
    pub fn builder() -> crate::input::create_event_destination_input::Builder {
        crate::input::create_event_destination_input::Builder::default()
    }
    /// Creates a new `CreateEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventDestination {
    type Output = std::result::Result<
        crate::output::CreateEventDestinationOutput,
        crate::error::CreateEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_destination_error(response)
        } else {
            crate::operation_deser::parse_create_event_destination_response(response)
        }
    }
}

/// Operation shape for `CreateOptOutList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_opt_out_list`](crate::client::Client::create_opt_out_list).
///
/// See [`crate::client::fluent_builders::CreateOptOutList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOptOutList {
    _private: (),
}
impl CreateOptOutList {
    /// Creates a new builder-style object to manufacture [`CreateOptOutListInput`](crate::input::CreateOptOutListInput)
    pub fn builder() -> crate::input::create_opt_out_list_input::Builder {
        crate::input::create_opt_out_list_input::Builder::default()
    }
    /// Creates a new `CreateOptOutList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOptOutList {
    type Output = std::result::Result<
        crate::output::CreateOptOutListOutput,
        crate::error::CreateOptOutListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_opt_out_list_error(response)
        } else {
            crate::operation_deser::parse_create_opt_out_list_response(response)
        }
    }
}

/// Operation shape for `CreatePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pool`](crate::client::Client::create_pool).
///
/// See [`crate::client::fluent_builders::CreatePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePool {
    _private: (),
}
impl CreatePool {
    /// Creates a new builder-style object to manufacture [`CreatePoolInput`](crate::input::CreatePoolInput)
    pub fn builder() -> crate::input::create_pool_input::Builder {
        crate::input::create_pool_input::Builder::default()
    }
    /// Creates a new `CreatePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePool {
    type Output =
        std::result::Result<crate::output::CreatePoolOutput, crate::error::CreatePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pool_error(response)
        } else {
            crate::operation_deser::parse_create_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_set`](crate::client::Client::delete_configuration_set).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationSet {
    _private: (),
}
impl DeleteConfigurationSet {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationSet {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationSetOutput,
        crate::error::DeleteConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_set_response(response)
        }
    }
}

/// Operation shape for `DeleteDefaultMessageType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_default_message_type`](crate::client::Client::delete_default_message_type).
///
/// See [`crate::client::fluent_builders::DeleteDefaultMessageType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDefaultMessageType {
    _private: (),
}
impl DeleteDefaultMessageType {
    /// Creates a new builder-style object to manufacture [`DeleteDefaultMessageTypeInput`](crate::input::DeleteDefaultMessageTypeInput)
    pub fn builder() -> crate::input::delete_default_message_type_input::Builder {
        crate::input::delete_default_message_type_input::Builder::default()
    }
    /// Creates a new `DeleteDefaultMessageType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDefaultMessageType {
    type Output = std::result::Result<
        crate::output::DeleteDefaultMessageTypeOutput,
        crate::error::DeleteDefaultMessageTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_default_message_type_error(response)
        } else {
            crate::operation_deser::parse_delete_default_message_type_response(response)
        }
    }
}

/// Operation shape for `DeleteDefaultSenderId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_default_sender_id`](crate::client::Client::delete_default_sender_id).
///
/// See [`crate::client::fluent_builders::DeleteDefaultSenderId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDefaultSenderId {
    _private: (),
}
impl DeleteDefaultSenderId {
    /// Creates a new builder-style object to manufacture [`DeleteDefaultSenderIdInput`](crate::input::DeleteDefaultSenderIdInput)
    pub fn builder() -> crate::input::delete_default_sender_id_input::Builder {
        crate::input::delete_default_sender_id_input::Builder::default()
    }
    /// Creates a new `DeleteDefaultSenderId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDefaultSenderId {
    type Output = std::result::Result<
        crate::output::DeleteDefaultSenderIdOutput,
        crate::error::DeleteDefaultSenderIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_default_sender_id_error(response)
        } else {
            crate::operation_deser::parse_delete_default_sender_id_response(response)
        }
    }
}

/// Operation shape for `DeleteEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_destination`](crate::client::Client::delete_event_destination).
///
/// See [`crate::client::fluent_builders::DeleteEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventDestination {
    _private: (),
}
impl DeleteEventDestination {
    /// Creates a new builder-style object to manufacture [`DeleteEventDestinationInput`](crate::input::DeleteEventDestinationInput)
    pub fn builder() -> crate::input::delete_event_destination_input::Builder {
        crate::input::delete_event_destination_input::Builder::default()
    }
    /// Creates a new `DeleteEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventDestination {
    type Output = std::result::Result<
        crate::output::DeleteEventDestinationOutput,
        crate::error::DeleteEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_event_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteKeyword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_keyword`](crate::client::Client::delete_keyword).
///
/// See [`crate::client::fluent_builders::DeleteKeyword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKeyword {
    _private: (),
}
impl DeleteKeyword {
    /// Creates a new builder-style object to manufacture [`DeleteKeywordInput`](crate::input::DeleteKeywordInput)
    pub fn builder() -> crate::input::delete_keyword_input::Builder {
        crate::input::delete_keyword_input::Builder::default()
    }
    /// Creates a new `DeleteKeyword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKeyword {
    type Output =
        std::result::Result<crate::output::DeleteKeywordOutput, crate::error::DeleteKeywordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_keyword_error(response)
        } else {
            crate::operation_deser::parse_delete_keyword_response(response)
        }
    }
}

/// Operation shape for `DeleteOptedOutNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_opted_out_number`](crate::client::Client::delete_opted_out_number).
///
/// See [`crate::client::fluent_builders::DeleteOptedOutNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOptedOutNumber {
    _private: (),
}
impl DeleteOptedOutNumber {
    /// Creates a new builder-style object to manufacture [`DeleteOptedOutNumberInput`](crate::input::DeleteOptedOutNumberInput)
    pub fn builder() -> crate::input::delete_opted_out_number_input::Builder {
        crate::input::delete_opted_out_number_input::Builder::default()
    }
    /// Creates a new `DeleteOptedOutNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOptedOutNumber {
    type Output = std::result::Result<
        crate::output::DeleteOptedOutNumberOutput,
        crate::error::DeleteOptedOutNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_opted_out_number_error(response)
        } else {
            crate::operation_deser::parse_delete_opted_out_number_response(response)
        }
    }
}

/// Operation shape for `DeleteOptOutList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_opt_out_list`](crate::client::Client::delete_opt_out_list).
///
/// See [`crate::client::fluent_builders::DeleteOptOutList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOptOutList {
    _private: (),
}
impl DeleteOptOutList {
    /// Creates a new builder-style object to manufacture [`DeleteOptOutListInput`](crate::input::DeleteOptOutListInput)
    pub fn builder() -> crate::input::delete_opt_out_list_input::Builder {
        crate::input::delete_opt_out_list_input::Builder::default()
    }
    /// Creates a new `DeleteOptOutList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOptOutList {
    type Output = std::result::Result<
        crate::output::DeleteOptOutListOutput,
        crate::error::DeleteOptOutListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_opt_out_list_error(response)
        } else {
            crate::operation_deser::parse_delete_opt_out_list_response(response)
        }
    }
}

/// Operation shape for `DeletePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pool`](crate::client::Client::delete_pool).
///
/// See [`crate::client::fluent_builders::DeletePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePool {
    _private: (),
}
impl DeletePool {
    /// Creates a new builder-style object to manufacture [`DeletePoolInput`](crate::input::DeletePoolInput)
    pub fn builder() -> crate::input::delete_pool_input::Builder {
        crate::input::delete_pool_input::Builder::default()
    }
    /// Creates a new `DeletePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePool {
    type Output =
        std::result::Result<crate::output::DeletePoolOutput, crate::error::DeletePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteTextMessageSpendLimitOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_text_message_spend_limit_override`](crate::client::Client::delete_text_message_spend_limit_override).
///
/// See [`crate::client::fluent_builders::DeleteTextMessageSpendLimitOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTextMessageSpendLimitOverride {
    _private: (),
}
impl DeleteTextMessageSpendLimitOverride {
    /// Creates a new builder-style object to manufacture [`DeleteTextMessageSpendLimitOverrideInput`](crate::input::DeleteTextMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::delete_text_message_spend_limit_override_input::Builder {
        crate::input::delete_text_message_spend_limit_override_input::Builder::default()
    }
    /// Creates a new `DeleteTextMessageSpendLimitOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTextMessageSpendLimitOverride {
    type Output = std::result::Result<
        crate::output::DeleteTextMessageSpendLimitOverrideOutput,
        crate::error::DeleteTextMessageSpendLimitOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_text_message_spend_limit_override_error(response)
        } else {
            crate::operation_deser::parse_delete_text_message_spend_limit_override_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteVoiceMessageSpendLimitOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_message_spend_limit_override`](crate::client::Client::delete_voice_message_spend_limit_override).
///
/// See [`crate::client::fluent_builders::DeleteVoiceMessageSpendLimitOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceMessageSpendLimitOverride {
    _private: (),
}
impl DeleteVoiceMessageSpendLimitOverride {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceMessageSpendLimitOverrideInput`](crate::input::DeleteVoiceMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::delete_voice_message_spend_limit_override_input::Builder {
        crate::input::delete_voice_message_spend_limit_override_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceMessageSpendLimitOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceMessageSpendLimitOverride {
    type Output = std::result::Result<
        crate::output::DeleteVoiceMessageSpendLimitOverrideOutput,
        crate::error::DeleteVoiceMessageSpendLimitOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_voice_message_spend_limit_override_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_message_spend_limit_override_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeAccountAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_attributes`](crate::client::Client::describe_account_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAccountAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAttributes {
    _private: (),
}
impl DescribeAccountAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAccountAttributesOutput,
        crate::error::DescribeAccountAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_account_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_limits`](crate::client::Client::describe_account_limits).
///
/// See [`crate::client::fluent_builders::DescribeAccountLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountLimits {
    _private: (),
}
impl DescribeAccountLimits {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
    /// Creates a new `DescribeAccountLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountLimits {
    type Output = std::result::Result<
        crate::output::DescribeAccountLimitsOutput,
        crate::error::DescribeAccountLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_account_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_sets`](crate::client::Client::describe_configuration_sets).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationSets {
    _private: (),
}
impl DescribeConfigurationSets {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSetsInput`](crate::input::DescribeConfigurationSetsInput)
    pub fn builder() -> crate::input::describe_configuration_sets_input::Builder {
        crate::input::describe_configuration_sets_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationSets {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationSetsOutput,
        crate::error::DescribeConfigurationSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_sets_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_sets_response(response)
        }
    }
}

/// Operation shape for `DescribeKeywords`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_keywords`](crate::client::Client::describe_keywords).
///
/// See [`crate::client::fluent_builders::DescribeKeywords`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeKeywords {
    _private: (),
}
impl DescribeKeywords {
    /// Creates a new builder-style object to manufacture [`DescribeKeywordsInput`](crate::input::DescribeKeywordsInput)
    pub fn builder() -> crate::input::describe_keywords_input::Builder {
        crate::input::describe_keywords_input::Builder::default()
    }
    /// Creates a new `DescribeKeywords` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeKeywords {
    type Output = std::result::Result<
        crate::output::DescribeKeywordsOutput,
        crate::error::DescribeKeywordsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_keywords_error(response)
        } else {
            crate::operation_deser::parse_describe_keywords_response(response)
        }
    }
}

/// Operation shape for `DescribeOptedOutNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_opted_out_numbers`](crate::client::Client::describe_opted_out_numbers).
///
/// See [`crate::client::fluent_builders::DescribeOptedOutNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOptedOutNumbers {
    _private: (),
}
impl DescribeOptedOutNumbers {
    /// Creates a new builder-style object to manufacture [`DescribeOptedOutNumbersInput`](crate::input::DescribeOptedOutNumbersInput)
    pub fn builder() -> crate::input::describe_opted_out_numbers_input::Builder {
        crate::input::describe_opted_out_numbers_input::Builder::default()
    }
    /// Creates a new `DescribeOptedOutNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOptedOutNumbers {
    type Output = std::result::Result<
        crate::output::DescribeOptedOutNumbersOutput,
        crate::error::DescribeOptedOutNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_opted_out_numbers_error(response)
        } else {
            crate::operation_deser::parse_describe_opted_out_numbers_response(response)
        }
    }
}

/// Operation shape for `DescribeOptOutLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_opt_out_lists`](crate::client::Client::describe_opt_out_lists).
///
/// See [`crate::client::fluent_builders::DescribeOptOutLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOptOutLists {
    _private: (),
}
impl DescribeOptOutLists {
    /// Creates a new builder-style object to manufacture [`DescribeOptOutListsInput`](crate::input::DescribeOptOutListsInput)
    pub fn builder() -> crate::input::describe_opt_out_lists_input::Builder {
        crate::input::describe_opt_out_lists_input::Builder::default()
    }
    /// Creates a new `DescribeOptOutLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOptOutLists {
    type Output = std::result::Result<
        crate::output::DescribeOptOutListsOutput,
        crate::error::DescribeOptOutListsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_opt_out_lists_error(response)
        } else {
            crate::operation_deser::parse_describe_opt_out_lists_response(response)
        }
    }
}

/// Operation shape for `DescribePhoneNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_phone_numbers`](crate::client::Client::describe_phone_numbers).
///
/// See [`crate::client::fluent_builders::DescribePhoneNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePhoneNumbers {
    _private: (),
}
impl DescribePhoneNumbers {
    /// Creates a new builder-style object to manufacture [`DescribePhoneNumbersInput`](crate::input::DescribePhoneNumbersInput)
    pub fn builder() -> crate::input::describe_phone_numbers_input::Builder {
        crate::input::describe_phone_numbers_input::Builder::default()
    }
    /// Creates a new `DescribePhoneNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePhoneNumbers {
    type Output = std::result::Result<
        crate::output::DescribePhoneNumbersOutput,
        crate::error::DescribePhoneNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_phone_numbers_error(response)
        } else {
            crate::operation_deser::parse_describe_phone_numbers_response(response)
        }
    }
}

/// Operation shape for `DescribePools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pools`](crate::client::Client::describe_pools).
///
/// See [`crate::client::fluent_builders::DescribePools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePools {
    _private: (),
}
impl DescribePools {
    /// Creates a new builder-style object to manufacture [`DescribePoolsInput`](crate::input::DescribePoolsInput)
    pub fn builder() -> crate::input::describe_pools_input::Builder {
        crate::input::describe_pools_input::Builder::default()
    }
    /// Creates a new `DescribePools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePools {
    type Output =
        std::result::Result<crate::output::DescribePoolsOutput, crate::error::DescribePoolsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pools_error(response)
        } else {
            crate::operation_deser::parse_describe_pools_response(response)
        }
    }
}

/// Operation shape for `DescribeSenderIds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_sender_ids`](crate::client::Client::describe_sender_ids).
///
/// See [`crate::client::fluent_builders::DescribeSenderIds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSenderIds {
    _private: (),
}
impl DescribeSenderIds {
    /// Creates a new builder-style object to manufacture [`DescribeSenderIdsInput`](crate::input::DescribeSenderIdsInput)
    pub fn builder() -> crate::input::describe_sender_ids_input::Builder {
        crate::input::describe_sender_ids_input::Builder::default()
    }
    /// Creates a new `DescribeSenderIds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSenderIds {
    type Output = std::result::Result<
        crate::output::DescribeSenderIdsOutput,
        crate::error::DescribeSenderIdsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_sender_ids_error(response)
        } else {
            crate::operation_deser::parse_describe_sender_ids_response(response)
        }
    }
}

/// Operation shape for `DescribeSpendLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spend_limits`](crate::client::Client::describe_spend_limits).
///
/// See [`crate::client::fluent_builders::DescribeSpendLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpendLimits {
    _private: (),
}
impl DescribeSpendLimits {
    /// Creates a new builder-style object to manufacture [`DescribeSpendLimitsInput`](crate::input::DescribeSpendLimitsInput)
    pub fn builder() -> crate::input::describe_spend_limits_input::Builder {
        crate::input::describe_spend_limits_input::Builder::default()
    }
    /// Creates a new `DescribeSpendLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpendLimits {
    type Output = std::result::Result<
        crate::output::DescribeSpendLimitsOutput,
        crate::error::DescribeSpendLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spend_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_spend_limits_response(response)
        }
    }
}

/// Operation shape for `DisassociateOriginationIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_origination_identity`](crate::client::Client::disassociate_origination_identity).
///
/// See [`crate::client::fluent_builders::DisassociateOriginationIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateOriginationIdentity {
    _private: (),
}
impl DisassociateOriginationIdentity {
    /// Creates a new builder-style object to manufacture [`DisassociateOriginationIdentityInput`](crate::input::DisassociateOriginationIdentityInput)
    pub fn builder() -> crate::input::disassociate_origination_identity_input::Builder {
        crate::input::disassociate_origination_identity_input::Builder::default()
    }
    /// Creates a new `DisassociateOriginationIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateOriginationIdentity {
    type Output = std::result::Result<
        crate::output::DisassociateOriginationIdentityOutput,
        crate::error::DisassociateOriginationIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_origination_identity_error(response)
        } else {
            crate::operation_deser::parse_disassociate_origination_identity_response(response)
        }
    }
}

/// Operation shape for `ListPoolOriginationIdentities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pool_origination_identities`](crate::client::Client::list_pool_origination_identities).
///
/// See [`crate::client::fluent_builders::ListPoolOriginationIdentities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPoolOriginationIdentities {
    _private: (),
}
impl ListPoolOriginationIdentities {
    /// Creates a new builder-style object to manufacture [`ListPoolOriginationIdentitiesInput`](crate::input::ListPoolOriginationIdentitiesInput)
    pub fn builder() -> crate::input::list_pool_origination_identities_input::Builder {
        crate::input::list_pool_origination_identities_input::Builder::default()
    }
    /// Creates a new `ListPoolOriginationIdentities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPoolOriginationIdentities {
    type Output = std::result::Result<
        crate::output::ListPoolOriginationIdentitiesOutput,
        crate::error::ListPoolOriginationIdentitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pool_origination_identities_error(response)
        } else {
            crate::operation_deser::parse_list_pool_origination_identities_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutKeyword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_keyword`](crate::client::Client::put_keyword).
///
/// See [`crate::client::fluent_builders::PutKeyword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutKeyword {
    _private: (),
}
impl PutKeyword {
    /// Creates a new builder-style object to manufacture [`PutKeywordInput`](crate::input::PutKeywordInput)
    pub fn builder() -> crate::input::put_keyword_input::Builder {
        crate::input::put_keyword_input::Builder::default()
    }
    /// Creates a new `PutKeyword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutKeyword {
    type Output =
        std::result::Result<crate::output::PutKeywordOutput, crate::error::PutKeywordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_keyword_error(response)
        } else {
            crate::operation_deser::parse_put_keyword_response(response)
        }
    }
}

/// Operation shape for `PutOptedOutNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_opted_out_number`](crate::client::Client::put_opted_out_number).
///
/// See [`crate::client::fluent_builders::PutOptedOutNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutOptedOutNumber {
    _private: (),
}
impl PutOptedOutNumber {
    /// Creates a new builder-style object to manufacture [`PutOptedOutNumberInput`](crate::input::PutOptedOutNumberInput)
    pub fn builder() -> crate::input::put_opted_out_number_input::Builder {
        crate::input::put_opted_out_number_input::Builder::default()
    }
    /// Creates a new `PutOptedOutNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutOptedOutNumber {
    type Output = std::result::Result<
        crate::output::PutOptedOutNumberOutput,
        crate::error::PutOptedOutNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_opted_out_number_error(response)
        } else {
            crate::operation_deser::parse_put_opted_out_number_response(response)
        }
    }
}

/// Operation shape for `ReleasePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`release_phone_number`](crate::client::Client::release_phone_number).
///
/// See [`crate::client::fluent_builders::ReleasePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReleasePhoneNumber {
    _private: (),
}
impl ReleasePhoneNumber {
    /// Creates a new builder-style object to manufacture [`ReleasePhoneNumberInput`](crate::input::ReleasePhoneNumberInput)
    pub fn builder() -> crate::input::release_phone_number_input::Builder {
        crate::input::release_phone_number_input::Builder::default()
    }
    /// Creates a new `ReleasePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReleasePhoneNumber {
    type Output = std::result::Result<
        crate::output::ReleasePhoneNumberOutput,
        crate::error::ReleasePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_release_phone_number_error(response)
        } else {
            crate::operation_deser::parse_release_phone_number_response(response)
        }
    }
}

/// Operation shape for `RequestPhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`request_phone_number`](crate::client::Client::request_phone_number).
///
/// See [`crate::client::fluent_builders::RequestPhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RequestPhoneNumber {
    _private: (),
}
impl RequestPhoneNumber {
    /// Creates a new builder-style object to manufacture [`RequestPhoneNumberInput`](crate::input::RequestPhoneNumberInput)
    pub fn builder() -> crate::input::request_phone_number_input::Builder {
        crate::input::request_phone_number_input::Builder::default()
    }
    /// Creates a new `RequestPhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RequestPhoneNumber {
    type Output = std::result::Result<
        crate::output::RequestPhoneNumberOutput,
        crate::error::RequestPhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_request_phone_number_error(response)
        } else {
            crate::operation_deser::parse_request_phone_number_response(response)
        }
    }
}

/// Operation shape for `SendTextMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_text_message`](crate::client::Client::send_text_message).
///
/// See [`crate::client::fluent_builders::SendTextMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendTextMessage {
    _private: (),
}
impl SendTextMessage {
    /// Creates a new builder-style object to manufacture [`SendTextMessageInput`](crate::input::SendTextMessageInput)
    pub fn builder() -> crate::input::send_text_message_input::Builder {
        crate::input::send_text_message_input::Builder::default()
    }
    /// Creates a new `SendTextMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendTextMessage {
    type Output = std::result::Result<
        crate::output::SendTextMessageOutput,
        crate::error::SendTextMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_text_message_error(response)
        } else {
            crate::operation_deser::parse_send_text_message_response(response)
        }
    }
}

/// Operation shape for `SendVoiceMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_voice_message`](crate::client::Client::send_voice_message).
///
/// See [`crate::client::fluent_builders::SendVoiceMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendVoiceMessage {
    _private: (),
}
impl SendVoiceMessage {
    /// Creates a new builder-style object to manufacture [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
    pub fn builder() -> crate::input::send_voice_message_input::Builder {
        crate::input::send_voice_message_input::Builder::default()
    }
    /// Creates a new `SendVoiceMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendVoiceMessage {
    type Output = std::result::Result<
        crate::output::SendVoiceMessageOutput,
        crate::error::SendVoiceMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_voice_message_error(response)
        } else {
            crate::operation_deser::parse_send_voice_message_response(response)
        }
    }
}

/// Operation shape for `SetDefaultMessageType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_default_message_type`](crate::client::Client::set_default_message_type).
///
/// See [`crate::client::fluent_builders::SetDefaultMessageType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetDefaultMessageType {
    _private: (),
}
impl SetDefaultMessageType {
    /// Creates a new builder-style object to manufacture [`SetDefaultMessageTypeInput`](crate::input::SetDefaultMessageTypeInput)
    pub fn builder() -> crate::input::set_default_message_type_input::Builder {
        crate::input::set_default_message_type_input::Builder::default()
    }
    /// Creates a new `SetDefaultMessageType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetDefaultMessageType {
    type Output = std::result::Result<
        crate::output::SetDefaultMessageTypeOutput,
        crate::error::SetDefaultMessageTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_default_message_type_error(response)
        } else {
            crate::operation_deser::parse_set_default_message_type_response(response)
        }
    }
}

/// Operation shape for `SetDefaultSenderId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_default_sender_id`](crate::client::Client::set_default_sender_id).
///
/// See [`crate::client::fluent_builders::SetDefaultSenderId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetDefaultSenderId {
    _private: (),
}
impl SetDefaultSenderId {
    /// Creates a new builder-style object to manufacture [`SetDefaultSenderIdInput`](crate::input::SetDefaultSenderIdInput)
    pub fn builder() -> crate::input::set_default_sender_id_input::Builder {
        crate::input::set_default_sender_id_input::Builder::default()
    }
    /// Creates a new `SetDefaultSenderId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetDefaultSenderId {
    type Output = std::result::Result<
        crate::output::SetDefaultSenderIdOutput,
        crate::error::SetDefaultSenderIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_default_sender_id_error(response)
        } else {
            crate::operation_deser::parse_set_default_sender_id_response(response)
        }
    }
}

/// Operation shape for `SetTextMessageSpendLimitOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_text_message_spend_limit_override`](crate::client::Client::set_text_message_spend_limit_override).
///
/// See [`crate::client::fluent_builders::SetTextMessageSpendLimitOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTextMessageSpendLimitOverride {
    _private: (),
}
impl SetTextMessageSpendLimitOverride {
    /// Creates a new builder-style object to manufacture [`SetTextMessageSpendLimitOverrideInput`](crate::input::SetTextMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::set_text_message_spend_limit_override_input::Builder {
        crate::input::set_text_message_spend_limit_override_input::Builder::default()
    }
    /// Creates a new `SetTextMessageSpendLimitOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTextMessageSpendLimitOverride {
    type Output = std::result::Result<
        crate::output::SetTextMessageSpendLimitOverrideOutput,
        crate::error::SetTextMessageSpendLimitOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_text_message_spend_limit_override_error(response)
        } else {
            crate::operation_deser::parse_set_text_message_spend_limit_override_response(response)
        }
    }
}

/// Operation shape for `SetVoiceMessageSpendLimitOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_voice_message_spend_limit_override`](crate::client::Client::set_voice_message_spend_limit_override).
///
/// See [`crate::client::fluent_builders::SetVoiceMessageSpendLimitOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetVoiceMessageSpendLimitOverride {
    _private: (),
}
impl SetVoiceMessageSpendLimitOverride {
    /// Creates a new builder-style object to manufacture [`SetVoiceMessageSpendLimitOverrideInput`](crate::input::SetVoiceMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::set_voice_message_spend_limit_override_input::Builder {
        crate::input::set_voice_message_spend_limit_override_input::Builder::default()
    }
    /// Creates a new `SetVoiceMessageSpendLimitOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetVoiceMessageSpendLimitOverride {
    type Output = std::result::Result<
        crate::output::SetVoiceMessageSpendLimitOverrideOutput,
        crate::error::SetVoiceMessageSpendLimitOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_voice_message_spend_limit_override_error(response)
        } else {
            crate::operation_deser::parse_set_voice_message_spend_limit_override_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_event_destination`](crate::client::Client::update_event_destination).
///
/// See [`crate::client::fluent_builders::UpdateEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEventDestination {
    _private: (),
}
impl UpdateEventDestination {
    /// Creates a new builder-style object to manufacture [`UpdateEventDestinationInput`](crate::input::UpdateEventDestinationInput)
    pub fn builder() -> crate::input::update_event_destination_input::Builder {
        crate::input::update_event_destination_input::Builder::default()
    }
    /// Creates a new `UpdateEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEventDestination {
    type Output = std::result::Result<
        crate::output::UpdateEventDestinationOutput,
        crate::error::UpdateEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_event_destination_error(response)
        } else {
            crate::operation_deser::parse_update_event_destination_response(response)
        }
    }
}

/// Operation shape for `UpdatePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_phone_number`](crate::client::Client::update_phone_number).
///
/// See [`crate::client::fluent_builders::UpdatePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePhoneNumber {
    _private: (),
}
impl UpdatePhoneNumber {
    /// Creates a new builder-style object to manufacture [`UpdatePhoneNumberInput`](crate::input::UpdatePhoneNumberInput)
    pub fn builder() -> crate::input::update_phone_number_input::Builder {
        crate::input::update_phone_number_input::Builder::default()
    }
    /// Creates a new `UpdatePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePhoneNumber {
    type Output = std::result::Result<
        crate::output::UpdatePhoneNumberOutput,
        crate::error::UpdatePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_phone_number_error(response)
        } else {
            crate::operation_deser::parse_update_phone_number_response(response)
        }
    }
}

/// Operation shape for `UpdatePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pool`](crate::client::Client::update_pool).
///
/// See [`crate::client::fluent_builders::UpdatePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePool {
    _private: (),
}
impl UpdatePool {
    /// Creates a new builder-style object to manufacture [`UpdatePoolInput`](crate::input::UpdatePoolInput)
    pub fn builder() -> crate::input::update_pool_input::Builder {
        crate::input::update_pool_input::Builder::default()
    }
    /// Creates a new `UpdatePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePool {
    type Output =
        std::result::Result<crate::output::UpdatePoolOutput, crate::error::UpdatePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pool_error(response)
        } else {
            crate::operation_deser::parse_update_pool_response(response)
        }
    }
}
