// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Pinpoint SMS Voice V2
///
/// Client for invoking operations on Amazon Pinpoint SMS Voice V2. Each operation on Amazon Pinpoint SMS Voice V2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_pinpointsmsvoicev2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_pinpointsmsvoicev2::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_pinpointsmsvoicev2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateOriginationIdentity`](crate::client::fluent_builders::AssociateOriginationIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::set_pool_id): <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::set_origination_identity): <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    ///   - [`iso_country_code(impl Into<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::iso_country_code) / [`set_iso_country_code(Option<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::set_iso_country_code): <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateOriginationIdentity::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`AssociateOriginationIdentityOutput`](crate::output::AssociateOriginationIdentityOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::AssociateOriginationIdentityOutput::pool_arn): <p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>
    ///   - [`pool_id(Option<String>)`](crate::output::AssociateOriginationIdentityOutput::pool_id): <p>The PoolId of the pool that is now associated with the origination identity.</p>
    ///   - [`origination_identity_arn(Option<String>)`](crate::output::AssociateOriginationIdentityOutput::origination_identity_arn): <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
    ///   - [`origination_identity(Option<String>)`](crate::output::AssociateOriginationIdentityOutput::origination_identity): <p>The PhoneNumberId or SenderId of the origination identity.</p>
    ///   - [`iso_country_code(Option<String>)`](crate::output::AssociateOriginationIdentityOutput::iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    /// - On failure, responds with [`SdkError<AssociateOriginationIdentityError>`](crate::error::AssociateOriginationIdentityError)
    pub fn associate_origination_identity(&self) -> fluent_builders::AssociateOriginationIdentity {
        fluent_builders::AssociateOriginationIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSet::set_configuration_set_name): <p>The name to use for the new configuration set.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConfigurationSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConfigurationSet::set_tags): <p>An array of key and value pair tags that's associated with the new configuration set. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSet::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSet::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::CreateConfigurationSetOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::CreateConfigurationSetOutput::configuration_set_name): <p>The name of the new configuration set.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateConfigurationSetOutput::tags): <p>An array of key and value pair tags that's associated with the configuration set.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::CreateConfigurationSetOutput::created_timestamp): <p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<CreateConfigurationSetError>`](crate::error::CreateConfigurationSetError)
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventDestination`](crate::client::fluent_builders::CreateEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateEventDestination::set_configuration_set_name): <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::CreateEventDestination::set_event_destination_name): <p>The name that identifies the event destination.</p>
    ///   - [`matching_event_types(Vec<EventType>)`](crate::client::fluent_builders::CreateEventDestination::matching_event_types) / [`set_matching_event_types(Option<Vec<EventType>>)`](crate::client::fluent_builders::CreateEventDestination::set_matching_event_types): <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
    ///   - [`cloud_watch_logs_destination(CloudWatchLogsDestination)`](crate::client::fluent_builders::CreateEventDestination::cloud_watch_logs_destination) / [`set_cloud_watch_logs_destination(Option<CloudWatchLogsDestination>)`](crate::client::fluent_builders::CreateEventDestination::set_cloud_watch_logs_destination): <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
    ///   - [`kinesis_firehose_destination(KinesisFirehoseDestination)`](crate::client::fluent_builders::CreateEventDestination::kinesis_firehose_destination) / [`set_kinesis_firehose_destination(Option<KinesisFirehoseDestination>)`](crate::client::fluent_builders::CreateEventDestination::set_kinesis_firehose_destination): <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
    ///   - [`sns_destination(SnsDestination)`](crate::client::fluent_builders::CreateEventDestination::sns_destination) / [`set_sns_destination(Option<SnsDestination>)`](crate::client::fluent_builders::CreateEventDestination::set_sns_destination): <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateEventDestination::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateEventDestination::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`CreateEventDestinationOutput`](crate::output::CreateEventDestinationOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::CreateEventDestinationOutput::configuration_set_arn): <p>The ARN of the configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::CreateEventDestinationOutput::configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`event_destination(Option<EventDestination>)`](crate::output::CreateEventDestinationOutput::event_destination): <p>The details of the destination where events are logged.</p>
    /// - On failure, responds with [`SdkError<CreateEventDestinationError>`](crate::error::CreateEventDestinationError)
    pub fn create_event_destination(&self) -> fluent_builders::CreateEventDestination {
        fluent_builders::CreateEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOptOutList`](crate::client::fluent_builders::CreateOptOutList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::CreateOptOutList::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::CreateOptOutList::set_opt_out_list_name): <p>The name of the new OptOutList.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateOptOutList::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateOptOutList::set_tags): <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateOptOutList::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateOptOutList::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`CreateOptOutListOutput`](crate::output::CreateOptOutListOutput) with field(s):
    ///   - [`opt_out_list_arn(Option<String>)`](crate::output::CreateOptOutListOutput::opt_out_list_arn): <p>The Amazon Resource Name (ARN) for the OptOutList.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::CreateOptOutListOutput::opt_out_list_name): <p>The name of the new OptOutList.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateOptOutListOutput::tags): <p>An array of tags (key and value pairs) associated with the new OptOutList.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::CreateOptOutListOutput::created_timestamp): <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<CreateOptOutListError>`](crate::error::CreateOptOutListError)
    pub fn create_opt_out_list(&self) -> fluent_builders::CreateOptOutList {
        fluent_builders::CreateOptOutList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePool`](crate::client::fluent_builders::CreatePool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::CreatePool::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::CreatePool::set_origination_identity): <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    ///   - [`iso_country_code(impl Into<String>)`](crate::client::fluent_builders::CreatePool::iso_country_code) / [`set_iso_country_code(Option<String>)`](crate::client::fluent_builders::CreatePool::set_iso_country_code): <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
    ///   - [`message_type(MessageType)`](crate::client::fluent_builders::CreatePool::message_type) / [`set_message_type(Option<MessageType>)`](crate::client::fluent_builders::CreatePool::set_message_type): <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::client::fluent_builders::CreatePool::deletion_protection_enabled) / [`set_deletion_protection_enabled(Option<bool>)`](crate::client::fluent_builders::CreatePool::set_deletion_protection_enabled): <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePool::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePool::set_tags): <p>An array of tags (key and value pairs) associated with the pool.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreatePool::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreatePool::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`CreatePoolOutput`](crate::output::CreatePoolOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::CreatePoolOutput::pool_arn): <p>The Amazon Resource Name (ARN) for the pool.</p>
    ///   - [`pool_id(Option<String>)`](crate::output::CreatePoolOutput::pool_id): <p>The unique identifier for the pool.</p>
    ///   - [`status(Option<PoolStatus>)`](crate::output::CreatePoolOutput::status): <p>The current status of the pool.</p>  <ul>   <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>   <li> <p>ACTIVE: The pool is active and available for use.</p> </li>   <li> <p>DELETING: The pool is being deleted.</p> </li>  </ul>
    ///   - [`message_type(Option<MessageType>)`](crate::output::CreatePoolOutput::message_type): <p>The type of message for the pool to use.</p>
    ///   - [`two_way_enabled(bool)`](crate::output::CreatePoolOutput::two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(Option<String>)`](crate::output::CreatePoolOutput::two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::output::CreatePoolOutput::self_managed_opt_outs_enabled): <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::CreatePoolOutput::opt_out_list_name): <p>The name of the OptOutList associated with the pool.</p>
    ///   - [`shared_routes_enabled(bool)`](crate::output::CreatePoolOutput::shared_routes_enabled): <p>Indicates whether shared routes are enabled for the pool.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::output::CreatePoolOutput::deletion_protection_enabled): <p>When set to true deletion protection is enabled. By default this is set to false. </p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreatePoolOutput::tags): <p>An array of tags (key and value pairs) associated with the pool.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::CreatePoolOutput::created_timestamp): <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<CreatePoolError>`](crate::error::CreatePoolError)
    pub fn create_pool(&self) -> fluent_builders::CreatePool {
        fluent_builders::CreatePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::set_configuration_set_name): <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    /// - On success, responds with [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::DeleteConfigurationSetOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::DeleteConfigurationSetOutput::configuration_set_name): <p>The name of the deleted configuration set.</p>
    ///   - [`event_destinations(Option<Vec<EventDestination>>)`](crate::output::DeleteConfigurationSetOutput::event_destinations): <p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>
    ///   - [`default_message_type(Option<MessageType>)`](crate::output::DeleteConfigurationSetOutput::default_message_type): <p>The default message type of the configuration set that was deleted.</p>
    ///   - [`default_sender_id(Option<String>)`](crate::output::DeleteConfigurationSetOutput::default_sender_id): <p>The default Sender ID of the configuration set that was deleted.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::DeleteConfigurationSetOutput::created_timestamp): <p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<DeleteConfigurationSetError>`](crate::error::DeleteConfigurationSetError)
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDefaultMessageType`](crate::client::fluent_builders::DeleteDefaultMessageType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDefaultMessageType::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteDefaultMessageType::set_configuration_set_name): <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    /// - On success, responds with [`DeleteDefaultMessageTypeOutput`](crate::output::DeleteDefaultMessageTypeOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::DeleteDefaultMessageTypeOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::DeleteDefaultMessageTypeOutput::configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`message_type(Option<MessageType>)`](crate::output::DeleteDefaultMessageTypeOutput::message_type): <p>The current message type for the configuration set.</p>
    /// - On failure, responds with [`SdkError<DeleteDefaultMessageTypeError>`](crate::error::DeleteDefaultMessageTypeError)
    pub fn delete_default_message_type(&self) -> fluent_builders::DeleteDefaultMessageType {
        fluent_builders::DeleteDefaultMessageType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDefaultSenderId`](crate::client::fluent_builders::DeleteDefaultSenderId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDefaultSenderId::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteDefaultSenderId::set_configuration_set_name): <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    /// - On success, responds with [`DeleteDefaultSenderIdOutput`](crate::output::DeleteDefaultSenderIdOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::DeleteDefaultSenderIdOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::DeleteDefaultSenderIdOutput::configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`sender_id(Option<String>)`](crate::output::DeleteDefaultSenderIdOutput::sender_id): <p>The current sender ID for the configuration set.</p>
    /// - On failure, responds with [`SdkError<DeleteDefaultSenderIdError>`](crate::error::DeleteDefaultSenderIdError)
    pub fn delete_default_sender_id(&self) -> fluent_builders::DeleteDefaultSenderId {
        fluent_builders::DeleteDefaultSenderId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventDestination`](crate::client::fluent_builders::DeleteEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteEventDestination::set_configuration_set_name): <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::DeleteEventDestination::set_event_destination_name): <p>The name of the event destination to delete.</p>
    /// - On success, responds with [`DeleteEventDestinationOutput`](crate::output::DeleteEventDestinationOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::DeleteEventDestinationOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::DeleteEventDestinationOutput::configuration_set_name): <p>The name of the configuration set the event destination was deleted from.</p>
    ///   - [`event_destination(Option<EventDestination>)`](crate::output::DeleteEventDestinationOutput::event_destination): <p>The event destination object that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteEventDestinationError>`](crate::error::DeleteEventDestinationError)
    pub fn delete_event_destination(&self) -> fluent_builders::DeleteEventDestination {
        fluent_builders::DeleteEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteKeyword`](crate::client::fluent_builders::DeleteKeyword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyword::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::DeleteKeyword::set_origination_identity): <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
    ///   - [`keyword(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyword::keyword) / [`set_keyword(Option<String>)`](crate::client::fluent_builders::DeleteKeyword::set_keyword): <p>The keyword to delete.</p>
    /// - On success, responds with [`DeleteKeywordOutput`](crate::output::DeleteKeywordOutput) with field(s):
    ///   - [`origination_identity_arn(Option<String>)`](crate::output::DeleteKeywordOutput::origination_identity_arn): <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
    ///   - [`origination_identity(Option<String>)`](crate::output::DeleteKeywordOutput::origination_identity): <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
    ///   - [`keyword(Option<String>)`](crate::output::DeleteKeywordOutput::keyword): <p>The keyword that was deleted.</p>
    ///   - [`keyword_message(Option<String>)`](crate::output::DeleteKeywordOutput::keyword_message): <p>The message that was associated with the deleted keyword.</p>
    ///   - [`keyword_action(Option<KeywordAction>)`](crate::output::DeleteKeywordOutput::keyword_action): <p>The action that was associated with the deleted keyword.</p>
    /// - On failure, responds with [`SdkError<DeleteKeywordError>`](crate::error::DeleteKeywordError)
    pub fn delete_keyword(&self) -> fluent_builders::DeleteKeyword {
        fluent_builders::DeleteKeyword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOptedOutNumber`](crate::client::fluent_builders::DeleteOptedOutNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::DeleteOptedOutNumber::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::DeleteOptedOutNumber::set_opt_out_list_name): <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
    ///   - [`opted_out_number(impl Into<String>)`](crate::client::fluent_builders::DeleteOptedOutNumber::opted_out_number) / [`set_opted_out_number(Option<String>)`](crate::client::fluent_builders::DeleteOptedOutNumber::set_opted_out_number): <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
    /// - On success, responds with [`DeleteOptedOutNumberOutput`](crate::output::DeleteOptedOutNumberOutput) with field(s):
    ///   - [`opt_out_list_arn(Option<String>)`](crate::output::DeleteOptedOutNumberOutput::opt_out_list_arn): <p>The OptOutListArn that the phone number was removed from.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::DeleteOptedOutNumberOutput::opt_out_list_name): <p>The OptOutListName that the phone number was removed from.</p>
    ///   - [`opted_out_number(Option<String>)`](crate::output::DeleteOptedOutNumberOutput::opted_out_number): <p>The phone number that was removed from the OptOutList.</p>
    ///   - [`opted_out_timestamp(Option<DateTime>)`](crate::output::DeleteOptedOutNumberOutput::opted_out_timestamp): <p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    ///   - [`end_user_opted_out(bool)`](crate::output::DeleteOptedOutNumberOutput::end_user_opted_out): <p>This is true if it was the end user who requested their phone number be removed. </p>
    /// - On failure, responds with [`SdkError<DeleteOptedOutNumberError>`](crate::error::DeleteOptedOutNumberError)
    pub fn delete_opted_out_number(&self) -> fluent_builders::DeleteOptedOutNumber {
        fluent_builders::DeleteOptedOutNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOptOutList`](crate::client::fluent_builders::DeleteOptOutList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::DeleteOptOutList::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::DeleteOptOutList::set_opt_out_list_name): <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
    /// - On success, responds with [`DeleteOptOutListOutput`](crate::output::DeleteOptOutListOutput) with field(s):
    ///   - [`opt_out_list_arn(Option<String>)`](crate::output::DeleteOptOutListOutput::opt_out_list_arn): <p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::DeleteOptOutListOutput::opt_out_list_name): <p>The name of the OptOutList that was removed.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::DeleteOptOutListOutput::created_timestamp): <p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<DeleteOptOutListError>`](crate::error::DeleteOptOutListError)
    pub fn delete_opt_out_list(&self) -> fluent_builders::DeleteOptOutList {
        fluent_builders::DeleteOptOutList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePool`](crate::client::fluent_builders::DeletePool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::DeletePool::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::DeletePool::set_pool_id): <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
    /// - On success, responds with [`DeletePoolOutput`](crate::output::DeletePoolOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::DeletePoolOutput::pool_arn): <p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>
    ///   - [`pool_id(Option<String>)`](crate::output::DeletePoolOutput::pool_id): <p>The PoolId of the pool that was deleted.</p>
    ///   - [`status(Option<PoolStatus>)`](crate::output::DeletePoolOutput::status): <p>The current status of the pool.</p>  <ul>   <li> <p>CREATING: The pool is currently being created and isn't yet available for use.</p> </li>   <li> <p>ACTIVE: The pool is active and available for use.</p> </li>   <li> <p>DELETING: The pool is being deleted.</p> </li>  </ul>
    ///   - [`message_type(Option<MessageType>)`](crate::output::DeletePoolOutput::message_type): <p>The message type that was associated with the deleted pool.</p>
    ///   - [`two_way_enabled(bool)`](crate::output::DeletePoolOutput::two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(Option<String>)`](crate::output::DeletePoolOutput::two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::output::DeletePoolOutput::self_managed_opt_outs_enabled): <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::DeletePoolOutput::opt_out_list_name): <p>The name of the OptOutList that was associated with the deleted pool.</p>
    ///   - [`shared_routes_enabled(bool)`](crate::output::DeletePoolOutput::shared_routes_enabled): <p>Indicates whether shared routes are enabled for the pool.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::DeletePoolOutput::created_timestamp): <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<DeletePoolError>`](crate::error::DeletePoolError)
    pub fn delete_pool(&self) -> fluent_builders::DeletePool {
        fluent_builders::DeletePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTextMessageSpendLimitOverride`](crate::client::fluent_builders::DeleteTextMessageSpendLimitOverride) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteTextMessageSpendLimitOverride::send) it.

    /// - On success, responds with [`DeleteTextMessageSpendLimitOverrideOutput`](crate::output::DeleteTextMessageSpendLimitOverrideOutput) with field(s):
    ///   - [`monthly_limit(Option<i64>)`](crate::output::DeleteTextMessageSpendLimitOverrideOutput::monthly_limit): <p>The current monthly limit, in US dollars.</p>
    /// - On failure, responds with [`SdkError<DeleteTextMessageSpendLimitOverrideError>`](crate::error::DeleteTextMessageSpendLimitOverrideError)
    pub fn delete_text_message_spend_limit_override(
        &self,
    ) -> fluent_builders::DeleteTextMessageSpendLimitOverride {
        fluent_builders::DeleteTextMessageSpendLimitOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceMessageSpendLimitOverride`](crate::client::fluent_builders::DeleteVoiceMessageSpendLimitOverride) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteVoiceMessageSpendLimitOverride::send) it.

    /// - On success, responds with [`DeleteVoiceMessageSpendLimitOverrideOutput`](crate::output::DeleteVoiceMessageSpendLimitOverrideOutput) with field(s):
    ///   - [`monthly_limit(Option<i64>)`](crate::output::DeleteVoiceMessageSpendLimitOverrideOutput::monthly_limit): <p>The current monthly limit, in US dollars.</p>
    /// - On failure, responds with [`SdkError<DeleteVoiceMessageSpendLimitOverrideError>`](crate::error::DeleteVoiceMessageSpendLimitOverrideError)
    pub fn delete_voice_message_spend_limit_override(
        &self,
    ) -> fluent_builders::DeleteVoiceMessageSpendLimitOverride {
        fluent_builders::DeleteVoiceMessageSpendLimitOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAccountAttributes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountAttributes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAccountAttributes::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAccountAttributes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAccountAttributes::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput) with field(s):
    ///   - [`account_attributes(Option<Vec<AccountAttribute>>)`](crate::output::DescribeAccountAttributesOutput::account_attributes): <p>An array of AccountAttributes objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAccountAttributesOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAttributesError>`](crate::error::DescribeAccountAttributesError)
    pub fn describe_account_attributes(&self) -> fluent_builders::DescribeAccountAttributes {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountLimits`](crate::client::fluent_builders::DescribeAccountLimits) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAccountLimits::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountLimits::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAccountLimits::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAccountLimits::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAccountLimits::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput) with field(s):
    ///   - [`account_limits(Option<Vec<AccountLimit>>)`](crate::output::DescribeAccountLimitsOutput::account_limits): <p>An array of AccountLimit objects that show the current spend limits.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAccountLimitsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountLimitsError>`](crate::error::DescribeAccountLimitsError)
    pub fn describe_account_limits(&self) -> fluent_builders::DescribeAccountLimits {
        fluent_builders::DescribeAccountLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfigurationSets`](crate::client::fluent_builders::DescribeConfigurationSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeConfigurationSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_names(Vec<String>)`](crate::client::fluent_builders::DescribeConfigurationSets::configuration_set_names) / [`set_configuration_set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeConfigurationSets::set_configuration_set_names): <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
    ///   - [`filters(Vec<ConfigurationSetFilter>)`](crate::client::fluent_builders::DescribeConfigurationSets::filters) / [`set_filters(Option<Vec<ConfigurationSetFilter>>)`](crate::client::fluent_builders::DescribeConfigurationSets::set_filters): <p>An array of filters to apply to the results that are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationSets::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeConfigurationSets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeConfigurationSets::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeConfigurationSetsOutput`](crate::output::DescribeConfigurationSetsOutput) with field(s):
    ///   - [`configuration_sets(Option<Vec<ConfigurationSetInformation>>)`](crate::output::DescribeConfigurationSetsOutput::configuration_sets): <p>An array of ConfigurationSets objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeConfigurationSetsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationSetsError>`](crate::error::DescribeConfigurationSetsError)
    pub fn describe_configuration_sets(&self) -> fluent_builders::DescribeConfigurationSets {
        fluent_builders::DescribeConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeKeywords`](crate::client::fluent_builders::DescribeKeywords) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeKeywords::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::DescribeKeywords::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::DescribeKeywords::set_origination_identity): <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    ///   - [`keywords(Vec<String>)`](crate::client::fluent_builders::DescribeKeywords::keywords) / [`set_keywords(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeKeywords::set_keywords): <p>An array of keywords to search for.</p>
    ///   - [`filters(Vec<KeywordFilter>)`](crate::client::fluent_builders::DescribeKeywords::filters) / [`set_filters(Option<Vec<KeywordFilter>>)`](crate::client::fluent_builders::DescribeKeywords::set_filters): <p>An array of keyword filters to filter the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeKeywords::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeKeywords::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeKeywords::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeKeywords::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeKeywordsOutput`](crate::output::DescribeKeywordsOutput) with field(s):
    ///   - [`origination_identity_arn(Option<String>)`](crate::output::DescribeKeywordsOutput::origination_identity_arn): <p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>
    ///   - [`origination_identity(Option<String>)`](crate::output::DescribeKeywordsOutput::origination_identity): <p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>
    ///   - [`keywords(Option<Vec<KeywordInformation>>)`](crate::output::DescribeKeywordsOutput::keywords): <p>An array of KeywordInformation objects that contain the results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeKeywordsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeKeywordsError>`](crate::error::DescribeKeywordsError)
    pub fn describe_keywords(&self) -> fluent_builders::DescribeKeywords {
        fluent_builders::DescribeKeywords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOptedOutNumbers`](crate::client::fluent_builders::DescribeOptedOutNumbers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOptedOutNumbers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::set_opt_out_list_name): <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
    ///   - [`opted_out_numbers(Vec<String>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::opted_out_numbers) / [`set_opted_out_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::set_opted_out_numbers): <p>An array of phone numbers to search for in the OptOutList.</p>
    ///   - [`filters(Vec<OptedOutFilter>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::filters) / [`set_filters(Option<Vec<OptedOutFilter>>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::set_filters): <p>An array of OptedOutFilter objects to filter the results on.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeOptedOutNumbers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeOptedOutNumbers::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeOptedOutNumbersOutput`](crate::output::DescribeOptedOutNumbersOutput) with field(s):
    ///   - [`opt_out_list_arn(Option<String>)`](crate::output::DescribeOptedOutNumbersOutput::opt_out_list_arn): <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::DescribeOptedOutNumbersOutput::opt_out_list_name): <p>The name of the OptOutList.</p>
    ///   - [`opted_out_numbers(Option<Vec<OptedOutNumberInformation>>)`](crate::output::DescribeOptedOutNumbersOutput::opted_out_numbers): <p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeOptedOutNumbersOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeOptedOutNumbersError>`](crate::error::DescribeOptedOutNumbersError)
    pub fn describe_opted_out_numbers(&self) -> fluent_builders::DescribeOptedOutNumbers {
        fluent_builders::DescribeOptedOutNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOptOutLists`](crate::client::fluent_builders::DescribeOptOutLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOptOutLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`opt_out_list_names(Vec<String>)`](crate::client::fluent_builders::DescribeOptOutLists::opt_out_list_names) / [`set_opt_out_list_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOptOutLists::set_opt_out_list_names): <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeOptOutLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeOptOutLists::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeOptOutLists::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeOptOutLists::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeOptOutListsOutput`](crate::output::DescribeOptOutListsOutput) with field(s):
    ///   - [`opt_out_lists(Option<Vec<OptOutListInformation>>)`](crate::output::DescribeOptOutListsOutput::opt_out_lists): <p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeOptOutListsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeOptOutListsError>`](crate::error::DescribeOptOutListsError)
    pub fn describe_opt_out_lists(&self) -> fluent_builders::DescribeOptOutLists {
        fluent_builders::DescribeOptOutLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePhoneNumbers`](crate::client::fluent_builders::DescribePhoneNumbers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePhoneNumbers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_ids(Vec<String>)`](crate::client::fluent_builders::DescribePhoneNumbers::phone_number_ids) / [`set_phone_number_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePhoneNumbers::set_phone_number_ids): <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
    ///   - [`filters(Vec<PhoneNumberFilter>)`](crate::client::fluent_builders::DescribePhoneNumbers::filters) / [`set_filters(Option<Vec<PhoneNumberFilter>>)`](crate::client::fluent_builders::DescribePhoneNumbers::set_filters): <p>An array of PhoneNumberFilter objects to filter the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePhoneNumbers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePhoneNumbers::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePhoneNumbers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePhoneNumbers::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribePhoneNumbersOutput`](crate::output::DescribePhoneNumbersOutput) with field(s):
    ///   - [`phone_numbers(Option<Vec<PhoneNumberInformation>>)`](crate::output::DescribePhoneNumbersOutput::phone_numbers): <p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePhoneNumbersOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribePhoneNumbersError>`](crate::error::DescribePhoneNumbersError)
    pub fn describe_phone_numbers(&self) -> fluent_builders::DescribePhoneNumbers {
        fluent_builders::DescribePhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePools`](crate::client::fluent_builders::DescribePools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_ids(Vec<String>)`](crate::client::fluent_builders::DescribePools::pool_ids) / [`set_pool_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePools::set_pool_ids): <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
    ///   - [`filters(Vec<PoolFilter>)`](crate::client::fluent_builders::DescribePools::filters) / [`set_filters(Option<Vec<PoolFilter>>)`](crate::client::fluent_builders::DescribePools::set_filters): <p>An array of PoolFilter objects to filter the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePools::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePools::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePools::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribePoolsOutput`](crate::output::DescribePoolsOutput) with field(s):
    ///   - [`pools(Option<Vec<PoolInformation>>)`](crate::output::DescribePoolsOutput::pools): <p>An array of PoolInformation objects that contain the details for the requested pools. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePoolsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribePoolsError>`](crate::error::DescribePoolsError)
    pub fn describe_pools(&self) -> fluent_builders::DescribePools {
        fluent_builders::DescribePools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSenderIds`](crate::client::fluent_builders::DescribeSenderIds) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSenderIds::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sender_ids(Vec<SenderIdAndCountry>)`](crate::client::fluent_builders::DescribeSenderIds::sender_ids) / [`set_sender_ids(Option<Vec<SenderIdAndCountry>>)`](crate::client::fluent_builders::DescribeSenderIds::set_sender_ids): <p>An array of SenderIdAndCountry objects to search for.</p>
    ///   - [`filters(Vec<SenderIdFilter>)`](crate::client::fluent_builders::DescribeSenderIds::filters) / [`set_filters(Option<Vec<SenderIdFilter>>)`](crate::client::fluent_builders::DescribeSenderIds::set_filters): <p>An array of SenderIdFilter objects to filter the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSenderIds::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSenderIds::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSenderIds::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSenderIds::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeSenderIdsOutput`](crate::output::DescribeSenderIdsOutput) with field(s):
    ///   - [`sender_ids(Option<Vec<SenderIdInformation>>)`](crate::output::DescribeSenderIdsOutput::sender_ids): <p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSenderIdsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeSenderIdsError>`](crate::error::DescribeSenderIdsError)
    pub fn describe_sender_ids(&self) -> fluent_builders::DescribeSenderIds {
        fluent_builders::DescribeSenderIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpendLimits`](crate::client::fluent_builders::DescribeSpendLimits) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSpendLimits::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSpendLimits::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSpendLimits::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSpendLimits::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSpendLimits::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`DescribeSpendLimitsOutput`](crate::output::DescribeSpendLimitsOutput) with field(s):
    ///   - [`spend_limits(Option<Vec<SpendLimit>>)`](crate::output::DescribeSpendLimitsOutput::spend_limits): <p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSpendLimitsOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<DescribeSpendLimitsError>`](crate::error::DescribeSpendLimitsError)
    pub fn describe_spend_limits(&self) -> fluent_builders::DescribeSpendLimits {
        fluent_builders::DescribeSpendLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateOriginationIdentity`](crate::client::fluent_builders::DisassociateOriginationIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::set_pool_id): <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::set_origination_identity): <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
    ///   - [`iso_country_code(impl Into<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::iso_country_code) / [`set_iso_country_code(Option<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::set_iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DisassociateOriginationIdentity::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`DisassociateOriginationIdentityOutput`](crate::output::DisassociateOriginationIdentityOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::DisassociateOriginationIdentityOutput::pool_arn): <p>The Amazon Resource Name (ARN) of the pool.</p>
    ///   - [`pool_id(Option<String>)`](crate::output::DisassociateOriginationIdentityOutput::pool_id): <p>The PoolId of the pool no longer associated with the origination identity.</p>
    ///   - [`origination_identity_arn(Option<String>)`](crate::output::DisassociateOriginationIdentityOutput::origination_identity_arn): <p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>
    ///   - [`origination_identity(Option<String>)`](crate::output::DisassociateOriginationIdentityOutput::origination_identity): <p>The PhoneNumberId or SenderId of the origination identity.</p>
    ///   - [`iso_country_code(Option<String>)`](crate::output::DisassociateOriginationIdentityOutput::iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
    /// - On failure, responds with [`SdkError<DisassociateOriginationIdentityError>`](crate::error::DisassociateOriginationIdentityError)
    pub fn disassociate_origination_identity(
        &self,
    ) -> fluent_builders::DisassociateOriginationIdentity {
        fluent_builders::DisassociateOriginationIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPoolOriginationIdentities`](crate::client::fluent_builders::ListPoolOriginationIdentities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPoolOriginationIdentities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::set_pool_id): <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
    ///   - [`filters(Vec<PoolOriginationIdentitiesFilter>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::filters) / [`set_filters(Option<Vec<PoolOriginationIdentitiesFilter>>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::set_filters): <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::set_next_token): <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPoolOriginationIdentities::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPoolOriginationIdentities::set_max_results): <p>The maximum number of results to return per each request.</p>
    /// - On success, responds with [`ListPoolOriginationIdentitiesOutput`](crate::output::ListPoolOriginationIdentitiesOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::ListPoolOriginationIdentitiesOutput::pool_arn): <p>The Amazon Resource Name (ARN) for the pool.</p>
    ///   - [`pool_id(Option<String>)`](crate::output::ListPoolOriginationIdentitiesOutput::pool_id): <p>The unique PoolId of the pool.</p>
    ///   - [`origination_identities(Option<Vec<OriginationIdentityMetadata>>)`](crate::output::ListPoolOriginationIdentitiesOutput::origination_identities): <p>An array of any OriginationIdentityMetadata objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPoolOriginationIdentitiesOutput::next_token): <p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListPoolOriginationIdentitiesError>`](crate::error::ListPoolOriginationIdentitiesError)
    pub fn list_pool_origination_identities(
        &self,
    ) -> fluent_builders::ListPoolOriginationIdentities {
        fluent_builders::ListPoolOriginationIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::ListTagsForResourceOutput::resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array of key and value pair tags that are associated with the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutKeyword`](crate::client::fluent_builders::PutKeyword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::PutKeyword::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::PutKeyword::set_origination_identity): <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    ///   - [`keyword(impl Into<String>)`](crate::client::fluent_builders::PutKeyword::keyword) / [`set_keyword(Option<String>)`](crate::client::fluent_builders::PutKeyword::set_keyword): <p>The new keyword to add.</p>
    ///   - [`keyword_message(impl Into<String>)`](crate::client::fluent_builders::PutKeyword::keyword_message) / [`set_keyword_message(Option<String>)`](crate::client::fluent_builders::PutKeyword::set_keyword_message): <p>The message associated with the keyword.</p>  <ul>   <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>   <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>   <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>  </ul>
    ///   - [`keyword_action(KeywordAction)`](crate::client::fluent_builders::PutKeyword::keyword_action) / [`set_keyword_action(Option<KeywordAction>)`](crate::client::fluent_builders::PutKeyword::set_keyword_action): <p>The action to perform for the new keyword when it is received.</p>
    /// - On success, responds with [`PutKeywordOutput`](crate::output::PutKeywordOutput) with field(s):
    ///   - [`origination_identity_arn(Option<String>)`](crate::output::PutKeywordOutput::origination_identity_arn): <p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>
    ///   - [`origination_identity(Option<String>)`](crate::output::PutKeywordOutput::origination_identity): <p>The PhoneNumberId or PoolId that the keyword was associated with.</p>
    ///   - [`keyword(Option<String>)`](crate::output::PutKeywordOutput::keyword): <p>The keyword that was added.</p>
    ///   - [`keyword_message(Option<String>)`](crate::output::PutKeywordOutput::keyword_message): <p>The message associated with the keyword.</p>
    ///   - [`keyword_action(Option<KeywordAction>)`](crate::output::PutKeywordOutput::keyword_action): <p>The action to perform when the keyword is used.</p>
    /// - On failure, responds with [`SdkError<PutKeywordError>`](crate::error::PutKeywordError)
    pub fn put_keyword(&self) -> fluent_builders::PutKeyword {
        fluent_builders::PutKeyword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutOptedOutNumber`](crate::client::fluent_builders::PutOptedOutNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::PutOptedOutNumber::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::PutOptedOutNumber::set_opt_out_list_name): <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
    ///   - [`opted_out_number(impl Into<String>)`](crate::client::fluent_builders::PutOptedOutNumber::opted_out_number) / [`set_opted_out_number(Option<String>)`](crate::client::fluent_builders::PutOptedOutNumber::set_opted_out_number): <p>The phone number to add to the OptOutList in E.164 format.</p>
    /// - On success, responds with [`PutOptedOutNumberOutput`](crate::output::PutOptedOutNumberOutput) with field(s):
    ///   - [`opt_out_list_arn(Option<String>)`](crate::output::PutOptedOutNumberOutput::opt_out_list_arn): <p>The OptOutListArn that the phone number was removed from.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::PutOptedOutNumberOutput::opt_out_list_name): <p>The OptOutListName that the phone number was removed from.</p>
    ///   - [`opted_out_number(Option<String>)`](crate::output::PutOptedOutNumberOutput::opted_out_number): <p>The phone number that was added to the OptOutList.</p>
    ///   - [`opted_out_timestamp(Option<DateTime>)`](crate::output::PutOptedOutNumberOutput::opted_out_timestamp): <p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    ///   - [`end_user_opted_out(bool)`](crate::output::PutOptedOutNumberOutput::end_user_opted_out): <p>This is true if it was the end user who requested their phone number be removed. </p>
    /// - On failure, responds with [`SdkError<PutOptedOutNumberError>`](crate::error::PutOptedOutNumberError)
    pub fn put_opted_out_number(&self) -> fluent_builders::PutOptedOutNumber {
        fluent_builders::PutOptedOutNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReleasePhoneNumber`](crate::client::fluent_builders::ReleasePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_id(impl Into<String>)`](crate::client::fluent_builders::ReleasePhoneNumber::phone_number_id) / [`set_phone_number_id(Option<String>)`](crate::client::fluent_builders::ReleasePhoneNumber::set_phone_number_id): <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
    /// - On success, responds with [`ReleasePhoneNumberOutput`](crate::output::ReleasePhoneNumberOutput) with field(s):
    ///   - [`phone_number_arn(Option<String>)`](crate::output::ReleasePhoneNumberOutput::phone_number_arn): <p>The PhoneNumberArn of the phone number that was released.</p>
    ///   - [`phone_number_id(Option<String>)`](crate::output::ReleasePhoneNumberOutput::phone_number_id): <p>The PhoneNumberId of the phone number that was released.</p>
    ///   - [`phone_number(Option<String>)`](crate::output::ReleasePhoneNumberOutput::phone_number): <p>The phone number that was released.</p>
    ///   - [`status(Option<NumberStatus>)`](crate::output::ReleasePhoneNumberOutput::status): <p>The current status of the request.</p>
    ///   - [`iso_country_code(Option<String>)`](crate::output::ReleasePhoneNumberOutput::iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>
    ///   - [`message_type(Option<MessageType>)`](crate::output::ReleasePhoneNumberOutput::message_type): <p>The message type that was associated with the phone number.</p>
    ///   - [`number_capabilities(Option<Vec<NumberCapability>>)`](crate::output::ReleasePhoneNumberOutput::number_capabilities): <p>Specifies if the number could be used for text messages, voice, or both.</p>
    ///   - [`number_type(Option<NumberType>)`](crate::output::ReleasePhoneNumberOutput::number_type): <p>The type of number that was released.</p>
    ///   - [`monthly_leasing_price(Option<String>)`](crate::output::ReleasePhoneNumberOutput::monthly_leasing_price): <p>The monthly price of the phone number, in US dollars.</p>
    ///   - [`two_way_enabled(bool)`](crate::output::ReleasePhoneNumberOutput::two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(Option<String>)`](crate::output::ReleasePhoneNumberOutput::two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::output::ReleasePhoneNumberOutput::self_managed_opt_outs_enabled): <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::ReleasePhoneNumberOutput::opt_out_list_name): <p>The name of the OptOutList that was associated with the phone number.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::ReleasePhoneNumberOutput::created_timestamp): <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<ReleasePhoneNumberError>`](crate::error::ReleasePhoneNumberError)
    pub fn release_phone_number(&self) -> fluent_builders::ReleasePhoneNumber {
        fluent_builders::ReleasePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RequestPhoneNumber`](crate::client::fluent_builders::RequestPhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`iso_country_code(impl Into<String>)`](crate::client::fluent_builders::RequestPhoneNumber::iso_country_code) / [`set_iso_country_code(Option<String>)`](crate::client::fluent_builders::RequestPhoneNumber::set_iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    ///   - [`message_type(MessageType)`](crate::client::fluent_builders::RequestPhoneNumber::message_type) / [`set_message_type(Option<MessageType>)`](crate::client::fluent_builders::RequestPhoneNumber::set_message_type): <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    ///   - [`number_capabilities(Vec<NumberCapability>)`](crate::client::fluent_builders::RequestPhoneNumber::number_capabilities) / [`set_number_capabilities(Option<Vec<NumberCapability>>)`](crate::client::fluent_builders::RequestPhoneNumber::set_number_capabilities): <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
    ///   - [`number_type(RequestableNumberType)`](crate::client::fluent_builders::RequestPhoneNumber::number_type) / [`set_number_type(Option<RequestableNumberType>)`](crate::client::fluent_builders::RequestPhoneNumber::set_number_type): <p>The type of phone number to request.</p>
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::RequestPhoneNumber::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::RequestPhoneNumber::set_opt_out_list_name): <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::RequestPhoneNumber::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::RequestPhoneNumber::set_pool_id): <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
    ///   - [`registration_id(impl Into<String>)`](crate::client::fluent_builders::RequestPhoneNumber::registration_id) / [`set_registration_id(Option<String>)`](crate::client::fluent_builders::RequestPhoneNumber::set_registration_id): <p>Use this field to attach your phone number for an external registration process.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::client::fluent_builders::RequestPhoneNumber::deletion_protection_enabled) / [`set_deletion_protection_enabled(Option<bool>)`](crate::client::fluent_builders::RequestPhoneNumber::set_deletion_protection_enabled): <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RequestPhoneNumber::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RequestPhoneNumber::set_tags): <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::RequestPhoneNumber::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::RequestPhoneNumber::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    /// - On success, responds with [`RequestPhoneNumberOutput`](crate::output::RequestPhoneNumberOutput) with field(s):
    ///   - [`phone_number_arn(Option<String>)`](crate::output::RequestPhoneNumberOutput::phone_number_arn): <p>The Amazon Resource Name (ARN) of the requested phone number.</p>
    ///   - [`phone_number_id(Option<String>)`](crate::output::RequestPhoneNumberOutput::phone_number_id): <p>The unique identifier of the new phone number.</p>
    ///   - [`phone_number(Option<String>)`](crate::output::RequestPhoneNumberOutput::phone_number): <p>The new phone number that was requested.</p>
    ///   - [`status(Option<NumberStatus>)`](crate::output::RequestPhoneNumberOutput::status): <p>The current status of the request.</p>
    ///   - [`iso_country_code(Option<String>)`](crate::output::RequestPhoneNumberOutput::iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    ///   - [`message_type(Option<MessageType>)`](crate::output::RequestPhoneNumberOutput::message_type): <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    ///   - [`number_capabilities(Option<Vec<NumberCapability>>)`](crate::output::RequestPhoneNumberOutput::number_capabilities): <p>Indicates if the phone number will be used for text messages, voice messages or both. </p>
    ///   - [`number_type(Option<RequestableNumberType>)`](crate::output::RequestPhoneNumberOutput::number_type): <p>The type of number that was released.</p>
    ///   - [`monthly_leasing_price(Option<String>)`](crate::output::RequestPhoneNumberOutput::monthly_leasing_price): <p>The monthly price, in US dollars, to lease the phone number.</p>
    ///   - [`two_way_enabled(bool)`](crate::output::RequestPhoneNumberOutput::two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(Option<String>)`](crate::output::RequestPhoneNumberOutput::two_way_channel_arn): <p>The ARN used to identify the two way channel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::output::RequestPhoneNumberOutput::self_managed_opt_outs_enabled): <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::RequestPhoneNumberOutput::opt_out_list_name): <p>The name of the OptOutList that is associated with the requested phone number.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::output::RequestPhoneNumberOutput::deletion_protection_enabled): <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
    ///   - [`pool_id(Option<String>)`](crate::output::RequestPhoneNumberOutput::pool_id): <p>The unique identifier of the pool associated with the phone number </p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::RequestPhoneNumberOutput::tags): <p>An array of key and value pair tags that are associated with the phone number.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::RequestPhoneNumberOutput::created_timestamp): <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<RequestPhoneNumberError>`](crate::error::RequestPhoneNumberError)
    pub fn request_phone_number(&self) -> fluent_builders::RequestPhoneNumber {
        fluent_builders::RequestPhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendTextMessage`](crate::client::fluent_builders::SendTextMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_phone_number(impl Into<String>)`](crate::client::fluent_builders::SendTextMessage::destination_phone_number) / [`set_destination_phone_number(Option<String>)`](crate::client::fluent_builders::SendTextMessage::set_destination_phone_number): <p>The destination phone number in E.164 format.</p>
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::SendTextMessage::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::SendTextMessage::set_origination_identity): <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
    ///   - [`message_body(impl Into<String>)`](crate::client::fluent_builders::SendTextMessage::message_body) / [`set_message_body(Option<String>)`](crate::client::fluent_builders::SendTextMessage::set_message_body): <p>The body of the text message.</p>
    ///   - [`message_type(MessageType)`](crate::client::fluent_builders::SendTextMessage::message_type) / [`set_message_type(Option<MessageType>)`](crate::client::fluent_builders::SendTextMessage::set_message_type): <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    ///   - [`keyword(impl Into<String>)`](crate::client::fluent_builders::SendTextMessage::keyword) / [`set_keyword(Option<String>)`](crate::client::fluent_builders::SendTextMessage::set_keyword): <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendTextMessage::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendTextMessage::set_configuration_set_name): <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
    ///   - [`max_price(impl Into<String>)`](crate::client::fluent_builders::SendTextMessage::max_price) / [`set_max_price(Option<String>)`](crate::client::fluent_builders::SendTextMessage::set_max_price): <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
    ///   - [`time_to_live(i32)`](crate::client::fluent_builders::SendTextMessage::time_to_live) / [`set_time_to_live(Option<i32>)`](crate::client::fluent_builders::SendTextMessage::set_time_to_live): <p>How long the text message is valid for. By default this is 72 hours.</p>
    ///   - [`context(HashMap<String, String>)`](crate::client::fluent_builders::SendTextMessage::context) / [`set_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SendTextMessage::set_context): <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
    ///   - [`destination_country_parameters(HashMap<DestinationCountryParameterKey, String>)`](crate::client::fluent_builders::SendTextMessage::destination_country_parameters) / [`set_destination_country_parameters(Option<HashMap<DestinationCountryParameterKey, String>>)`](crate::client::fluent_builders::SendTextMessage::set_destination_country_parameters): <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::SendTextMessage::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::SendTextMessage::set_dry_run): <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
    /// - On success, responds with [`SendTextMessageOutput`](crate::output::SendTextMessageOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendTextMessageOutput::message_id): <p>The unique identifier for the message.</p>
    /// - On failure, responds with [`SdkError<SendTextMessageError>`](crate::error::SendTextMessageError)
    pub fn send_text_message(&self) -> fluent_builders::SendTextMessage {
        fluent_builders::SendTextMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendVoiceMessage`](crate::client::fluent_builders::SendVoiceMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_phone_number(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::destination_phone_number) / [`set_destination_phone_number(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_destination_phone_number): <p>The destination phone number in E.164 format.</p>
    ///   - [`origination_identity(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::origination_identity) / [`set_origination_identity(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_origination_identity): <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
    ///   - [`message_body(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::message_body) / [`set_message_body(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_message_body): <p>The text to convert to a voice message.</p>
    ///   - [`message_body_text_type(VoiceMessageBodyTextType)`](crate::client::fluent_builders::SendVoiceMessage::message_body_text_type) / [`set_message_body_text_type(Option<VoiceMessageBodyTextType>)`](crate::client::fluent_builders::SendVoiceMessage::set_message_body_text_type): <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>  <ul>   <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>   <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>  </ul>
    ///   - [`voice_id(VoiceId)`](crate::client::fluent_builders::SendVoiceMessage::voice_id) / [`set_voice_id(Option<VoiceId>)`](crate::client::fluent_builders::SendVoiceMessage::set_voice_id): <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_configuration_set_name): <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
    ///   - [`max_price_per_minute(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::max_price_per_minute) / [`set_max_price_per_minute(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_max_price_per_minute): <p>The maximum amount to spend per voice message, in US dollars.</p>
    ///   - [`time_to_live(i32)`](crate::client::fluent_builders::SendVoiceMessage::time_to_live) / [`set_time_to_live(Option<i32>)`](crate::client::fluent_builders::SendVoiceMessage::set_time_to_live): <p>How long the voice message is valid for. By default this is 72 hours.</p>
    ///   - [`context(HashMap<String, String>)`](crate::client::fluent_builders::SendVoiceMessage::context) / [`set_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SendVoiceMessage::set_context): <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::SendVoiceMessage::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::SendVoiceMessage::set_dry_run): <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
    /// - On success, responds with [`SendVoiceMessageOutput`](crate::output::SendVoiceMessageOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendVoiceMessageOutput::message_id): <p>The unique identifier for the message.</p>
    /// - On failure, responds with [`SdkError<SendVoiceMessageError>`](crate::error::SendVoiceMessageError)
    pub fn send_voice_message(&self) -> fluent_builders::SendVoiceMessage {
        fluent_builders::SendVoiceMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetDefaultMessageType`](crate::client::fluent_builders::SetDefaultMessageType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SetDefaultMessageType::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SetDefaultMessageType::set_configuration_set_name): <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
    ///   - [`message_type(MessageType)`](crate::client::fluent_builders::SetDefaultMessageType::message_type) / [`set_message_type(Option<MessageType>)`](crate::client::fluent_builders::SetDefaultMessageType::set_message_type): <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    /// - On success, responds with [`SetDefaultMessageTypeOutput`](crate::output::SetDefaultMessageTypeOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::SetDefaultMessageTypeOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::SetDefaultMessageTypeOutput::configuration_set_name): <p>The name of the configuration set that was updated.</p>
    ///   - [`message_type(Option<MessageType>)`](crate::output::SetDefaultMessageTypeOutput::message_type): <p>The new default message type of the configuration set.</p>
    /// - On failure, responds with [`SdkError<SetDefaultMessageTypeError>`](crate::error::SetDefaultMessageTypeError)
    pub fn set_default_message_type(&self) -> fluent_builders::SetDefaultMessageType {
        fluent_builders::SetDefaultMessageType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetDefaultSenderId`](crate::client::fluent_builders::SetDefaultSenderId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SetDefaultSenderId::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SetDefaultSenderId::set_configuration_set_name): <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
    ///   - [`sender_id(impl Into<String>)`](crate::client::fluent_builders::SetDefaultSenderId::sender_id) / [`set_sender_id(Option<String>)`](crate::client::fluent_builders::SetDefaultSenderId::set_sender_id): <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
    /// - On success, responds with [`SetDefaultSenderIdOutput`](crate::output::SetDefaultSenderIdOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::SetDefaultSenderIdOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) of the updated configuration set.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::SetDefaultSenderIdOutput::configuration_set_name): <p>The name of the configuration set that was updated.</p>
    ///   - [`sender_id(Option<String>)`](crate::output::SetDefaultSenderIdOutput::sender_id): <p>The default sender ID to set for the ConfigurationSet.</p>
    /// - On failure, responds with [`SdkError<SetDefaultSenderIdError>`](crate::error::SetDefaultSenderIdError)
    pub fn set_default_sender_id(&self) -> fluent_builders::SetDefaultSenderId {
        fluent_builders::SetDefaultSenderId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetTextMessageSpendLimitOverride`](crate::client::fluent_builders::SetTextMessageSpendLimitOverride) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`monthly_limit(i64)`](crate::client::fluent_builders::SetTextMessageSpendLimitOverride::monthly_limit) / [`set_monthly_limit(Option<i64>)`](crate::client::fluent_builders::SetTextMessageSpendLimitOverride::set_monthly_limit): <p>The new monthly limit to enforce on text messages.</p>
    /// - On success, responds with [`SetTextMessageSpendLimitOverrideOutput`](crate::output::SetTextMessageSpendLimitOverrideOutput) with field(s):
    ///   - [`monthly_limit(Option<i64>)`](crate::output::SetTextMessageSpendLimitOverrideOutput::monthly_limit): <p>The current monthly limit to enforce on sending text messages.</p>
    /// - On failure, responds with [`SdkError<SetTextMessageSpendLimitOverrideError>`](crate::error::SetTextMessageSpendLimitOverrideError)
    pub fn set_text_message_spend_limit_override(
        &self,
    ) -> fluent_builders::SetTextMessageSpendLimitOverride {
        fluent_builders::SetTextMessageSpendLimitOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetVoiceMessageSpendLimitOverride`](crate::client::fluent_builders::SetVoiceMessageSpendLimitOverride) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`monthly_limit(i64)`](crate::client::fluent_builders::SetVoiceMessageSpendLimitOverride::monthly_limit) / [`set_monthly_limit(Option<i64>)`](crate::client::fluent_builders::SetVoiceMessageSpendLimitOverride::set_monthly_limit): <p>The new monthly limit to enforce on voice messages.</p>
    /// - On success, responds with [`SetVoiceMessageSpendLimitOverrideOutput`](crate::output::SetVoiceMessageSpendLimitOverrideOutput) with field(s):
    ///   - [`monthly_limit(Option<i64>)`](crate::output::SetVoiceMessageSpendLimitOverrideOutput::monthly_limit): <p>The current monthly limit to enforce on sending voice messages.</p>
    /// - On failure, responds with [`SdkError<SetVoiceMessageSpendLimitOverrideError>`](crate::error::SetVoiceMessageSpendLimitOverrideError)
    pub fn set_voice_message_spend_limit_override(
        &self,
    ) -> fluent_builders::SetVoiceMessageSpendLimitOverride {
        fluent_builders::SetVoiceMessageSpendLimitOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>An array of key and value pair tags that are associated with the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>An array of tag key values to unassociate with the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventDestination`](crate::client::fluent_builders::UpdateEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateEventDestination::set_configuration_set_name): <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::UpdateEventDestination::set_event_destination_name): <p>The name to use for the event destination.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateEventDestination::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateEventDestination::set_enabled): <p>When set to true logging is enabled.</p>
    ///   - [`matching_event_types(Vec<EventType>)`](crate::client::fluent_builders::UpdateEventDestination::matching_event_types) / [`set_matching_event_types(Option<Vec<EventType>>)`](crate::client::fluent_builders::UpdateEventDestination::set_matching_event_types): <p>An array of event types that determine which events to log.</p>
    ///   - [`cloud_watch_logs_destination(CloudWatchLogsDestination)`](crate::client::fluent_builders::UpdateEventDestination::cloud_watch_logs_destination) / [`set_cloud_watch_logs_destination(Option<CloudWatchLogsDestination>)`](crate::client::fluent_builders::UpdateEventDestination::set_cloud_watch_logs_destination): <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
    ///   - [`kinesis_firehose_destination(KinesisFirehoseDestination)`](crate::client::fluent_builders::UpdateEventDestination::kinesis_firehose_destination) / [`set_kinesis_firehose_destination(Option<KinesisFirehoseDestination>)`](crate::client::fluent_builders::UpdateEventDestination::set_kinesis_firehose_destination): <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
    ///   - [`sns_destination(SnsDestination)`](crate::client::fluent_builders::UpdateEventDestination::sns_destination) / [`set_sns_destination(Option<SnsDestination>)`](crate::client::fluent_builders::UpdateEventDestination::set_sns_destination): <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
    /// - On success, responds with [`UpdateEventDestinationOutput`](crate::output::UpdateEventDestinationOutput) with field(s):
    ///   - [`configuration_set_arn(Option<String>)`](crate::output::UpdateEventDestinationOutput::configuration_set_arn): <p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::UpdateEventDestinationOutput::configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`event_destination(Option<EventDestination>)`](crate::output::UpdateEventDestinationOutput::event_destination): <p>An EventDestination object containing the details of where events will be logged. </p>
    /// - On failure, responds with [`SdkError<UpdateEventDestinationError>`](crate::error::UpdateEventDestinationError)
    pub fn update_event_destination(&self) -> fluent_builders::UpdateEventDestination {
        fluent_builders::UpdateEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePhoneNumber`](crate::client::fluent_builders::UpdatePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::phone_number_id) / [`set_phone_number_id(Option<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_phone_number_id): <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
    ///   - [`two_way_enabled(bool)`](crate::client::fluent_builders::UpdatePhoneNumber::two_way_enabled) / [`set_two_way_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::two_way_channel_arn) / [`set_two_way_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::client::fluent_builders::UpdatePhoneNumber::self_managed_opt_outs_enabled) / [`set_self_managed_opt_outs_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_self_managed_opt_outs_enabled): <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_opt_out_list_name): <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::client::fluent_builders::UpdatePhoneNumber::deletion_protection_enabled) / [`set_deletion_protection_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_deletion_protection_enabled): <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
    /// - On success, responds with [`UpdatePhoneNumberOutput`](crate::output::UpdatePhoneNumberOutput) with field(s):
    ///   - [`phone_number_arn(Option<String>)`](crate::output::UpdatePhoneNumberOutput::phone_number_arn): <p>The Amazon Resource Name (ARN) of the updated phone number.</p>
    ///   - [`phone_number_id(Option<String>)`](crate::output::UpdatePhoneNumberOutput::phone_number_id): <p>The unique identifier of the phone number.</p>
    ///   - [`phone_number(Option<String>)`](crate::output::UpdatePhoneNumberOutput::phone_number): <p>The phone number that was updated.</p>
    ///   - [`status(Option<NumberStatus>)`](crate::output::UpdatePhoneNumberOutput::status): <p>The current status of the request.</p>
    ///   - [`iso_country_code(Option<String>)`](crate::output::UpdatePhoneNumberOutput::iso_country_code): <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    ///   - [`message_type(Option<MessageType>)`](crate::output::UpdatePhoneNumberOutput::message_type): <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    ///   - [`number_capabilities(Option<Vec<NumberCapability>>)`](crate::output::UpdatePhoneNumberOutput::number_capabilities): <p>Specifies if the number could be used for text messages, voice or both.</p>
    ///   - [`number_type(Option<NumberType>)`](crate::output::UpdatePhoneNumberOutput::number_type): <p>The type of number that was requested.</p>
    ///   - [`monthly_leasing_price(Option<String>)`](crate::output::UpdatePhoneNumberOutput::monthly_leasing_price): <p>The monthly leasing price of the phone number, in US dollars.</p>
    ///   - [`two_way_enabled(bool)`](crate::output::UpdatePhoneNumberOutput::two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(Option<String>)`](crate::output::UpdatePhoneNumberOutput::two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::output::UpdatePhoneNumberOutput::self_managed_opt_outs_enabled): <p>This is true if self managed opt-out are enabled.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::UpdatePhoneNumberOutput::opt_out_list_name): <p>The name of the OptOutList associated with the phone number.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::output::UpdatePhoneNumberOutput::deletion_protection_enabled): <p>When set to true the phone number can't be deleted.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::UpdatePhoneNumberOutput::created_timestamp): <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<UpdatePhoneNumberError>`](crate::error::UpdatePhoneNumberError)
    pub fn update_phone_number(&self) -> fluent_builders::UpdatePhoneNumber {
        fluent_builders::UpdatePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePool`](crate::client::fluent_builders::UpdatePool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePool::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::UpdatePool::set_pool_id): <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
    ///   - [`two_way_enabled(bool)`](crate::client::fluent_builders::UpdatePool::two_way_enabled) / [`set_two_way_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePool::set_two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePool::two_way_channel_arn) / [`set_two_way_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdatePool::set_two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::client::fluent_builders::UpdatePool::self_managed_opt_outs_enabled) / [`set_self_managed_opt_outs_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePool::set_self_managed_opt_outs_enabled): <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePool::opt_out_list_name) / [`set_opt_out_list_name(Option<String>)`](crate::client::fluent_builders::UpdatePool::set_opt_out_list_name): <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
    ///   - [`shared_routes_enabled(bool)`](crate::client::fluent_builders::UpdatePool::shared_routes_enabled) / [`set_shared_routes_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePool::set_shared_routes_enabled): <p>Indicates whether shared routes are enabled for the pool.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::client::fluent_builders::UpdatePool::deletion_protection_enabled) / [`set_deletion_protection_enabled(Option<bool>)`](crate::client::fluent_builders::UpdatePool::set_deletion_protection_enabled): <p>When set to true the pool can't be deleted.</p>
    /// - On success, responds with [`UpdatePoolOutput`](crate::output::UpdatePoolOutput) with field(s):
    ///   - [`pool_arn(Option<String>)`](crate::output::UpdatePoolOutput::pool_arn): <p>The ARN of the pool.</p>
    ///   - [`pool_id(Option<String>)`](crate::output::UpdatePoolOutput::pool_id): <p>The unique identifier of the pool.</p>
    ///   - [`status(Option<PoolStatus>)`](crate::output::UpdatePoolOutput::status): <p>The current status of the pool update request.</p>
    ///   - [`message_type(Option<MessageType>)`](crate::output::UpdatePoolOutput::message_type): <p>The type of message for the pool to use.</p>
    ///   - [`two_way_enabled(bool)`](crate::output::UpdatePoolOutput::two_way_enabled): <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    ///   - [`two_way_channel_arn(Option<String>)`](crate::output::UpdatePoolOutput::two_way_channel_arn): <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    ///   - [`self_managed_opt_outs_enabled(bool)`](crate::output::UpdatePoolOutput::self_managed_opt_outs_enabled): <p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    ///   - [`opt_out_list_name(Option<String>)`](crate::output::UpdatePoolOutput::opt_out_list_name): <p>The name of the OptOutList associated with the pool.</p>
    ///   - [`shared_routes_enabled(bool)`](crate::output::UpdatePoolOutput::shared_routes_enabled): <p>Indicates whether shared routes are enabled for the pool.</p>
    ///   - [`deletion_protection_enabled(bool)`](crate::output::UpdatePoolOutput::deletion_protection_enabled): <p>When set to true the pool can't be deleted.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::UpdatePoolOutput::created_timestamp): <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    /// - On failure, responds with [`SdkError<UpdatePoolError>`](crate::error::UpdatePoolError)
    pub fn update_pool(&self) -> fluent_builders::UpdatePool {
        fluent_builders::UpdatePool::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateOriginationIdentity`.
    ///
    /// <p>Associates the specified origination identity with a pool.</p>
    /// <p>If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.</p>
    /// <p>If the origination identity configuration doesn't match the pool's configuration, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateOriginationIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_origination_identity_input::Builder,
    }
    impl AssociateOriginationIdentity {
        /// Creates a new `AssociateOriginationIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateOriginationIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateOriginationIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iso_country_code(input.into());
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iso_country_code(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// <p>Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.</p>
    /// <p>A configuration set is a set of rules that you apply to the SMS and voice messages that you send.</p>
    /// <p>When you send a message, you can optionally specify a single configuration set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl CreateConfigurationSet {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the new configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name to use for the new configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that's associated with the new configuration set. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key and value pair tags that's associated with the new configuration set. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventDestination`.
    ///
    /// <p>Creates a new event destination in a configuration set.</p>
    /// <p>An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.</p>
    /// <p>Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_destination_input::Builder,
    }
    impl CreateEventDestination {
        /// Creates a new `CreateEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name that identifies the event destination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name that identifies the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// Appends an item to `MatchingEventTypes`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
        pub fn matching_event_types(mut self, input: crate::model::EventType) -> Self {
            self.inner = self.inner.matching_event_types(input);
            self
        }
        /// <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.inner = self.inner.set_matching_event_types(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.inner = self.inner.kinesis_firehose_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_firehose_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.inner = self.inner.sns_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.inner = self.inner.set_sns_destination(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOptOutList`.
    ///
    /// <p>Creates a new opt-out list.</p>
    /// <p>If the opt-out list name already exists, an Error is returned.</p>
    /// <p>An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out keywords, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS opt out </a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOptOutList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_opt_out_list_input::Builder,
    }
    impl CreateOptOutList {
        /// Creates a new `CreateOptOutList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOptOutListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOptOutListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new OptOutList.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The name of the new OptOutList.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePool`.
    ///
    /// <p>Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>
    /// <p>The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't inherited from the origination identity and defaults to false.</p>
    /// <p>If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pool_input::Builder,
    }
    impl CreatePool {
        /// Creates a new `CreatePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iso_country_code(input.into());
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iso_country_code(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.inner = self.inner.message_type(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.inner = self.inner.set_message_type(input);
            self
        }
        /// <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection_enabled(input);
            self
        }
        /// <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) associated with the pool.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tags (key and value pairs) associated with the pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// <p>Deletes an existing configuration set.</p>
    /// <p>A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration set, you can specify a destination for specific types of events related to voice and SMS messages. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl DeleteConfigurationSet {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDefaultMessageType`.
    ///
    /// <p>Deletes an existing default message type on a configuration set.</p>
    /// <p> A message type is a type of messages that you plan to send. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to your entire Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDefaultMessageType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_default_message_type_input::Builder,
    }
    impl DeleteDefaultMessageType {
        /// Creates a new `DeleteDefaultMessageType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDefaultMessageTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDefaultMessageTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDefaultSenderId`.
    ///
    /// <p>Deletes an existing default sender ID on a configuration set.</p>
    /// <p>A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support for sender ID capabilities varies by country or region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDefaultSenderId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_default_sender_id_input::Builder,
    }
    impl DeleteDefaultSenderId {
        /// Creates a new `DeleteDefaultSenderId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDefaultSenderIdOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDefaultSenderIdError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventDestination`.
    ///
    /// <p>Deletes an existing event destination.</p>
    /// <p>An event destination is a location where you send response information about the messages that you send. For example, when a message is delivered successfully, you can send information about that event to an Amazon CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_destination_input::Builder,
    }
    impl DeleteEventDestination {
        /// Creates a new `DeleteEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeyword`.
    ///
    /// <p>Deletes an existing keyword from an origination phone number or pool.</p>
    /// <p>A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p>
    /// <p>Keywords "HELP" and "STOP" can't be deleted or modified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteKeyword {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_keyword_input::Builder,
    }
    impl DeleteKeyword {
        /// Creates a new `DeleteKeyword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeywordOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeywordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The keyword to delete.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyword(input.into());
            self
        }
        /// <p>The keyword to delete.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keyword(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOptedOutNumber`.
    ///
    /// <p>Deletes an existing opted out destination phone number from the specified opt-out list.</p>
    /// <p>Each destination phone number can only be deleted once every 30 days.</p>
    /// <p>If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOptedOutNumber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_opted_out_number_input::Builder,
    }
    impl DeleteOptedOutNumber {
        /// Creates a new `DeleteOptedOutNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOptedOutNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOptedOutNumberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opted_out_number(input.into());
            self
        }
        /// <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opted_out_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOptOutList`.
    ///
    /// <p>Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.</p>
    /// <p>If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOptOutList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_opt_out_list_input::Builder,
    }
    impl DeleteOptOutList {
        /// Creates a new `DeleteOptOutList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOptOutListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOptOutListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePool`.
    ///
    /// <p>Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.</p>
    /// <p>If the pool status isn't active or if deletion protection is enabled, an Error is returned.</p>
    /// <p>A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pool_input::Builder,
    }
    impl DeletePool {
        /// Creates a new `DeletePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTextMessageSpendLimitOverride`.
    ///
    /// <p>Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTextMessageSpendLimitOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_text_message_spend_limit_override_input::Builder,
    }
    impl DeleteTextMessageSpendLimitOverride {
        /// Creates a new `DeleteTextMessageSpendLimitOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTextMessageSpendLimitOverrideOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteTextMessageSpendLimitOverrideError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceMessageSpendLimitOverride`.
    ///
    /// <p>Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceMessageSpendLimitOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_voice_message_spend_limit_override_input::Builder,
    }
    impl DeleteVoiceMessageSpendLimitOverride {
        /// Creates a new `DeleteVoiceMessageSpendLimitOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceMessageSpendLimitOverrideOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteVoiceMessageSpendLimitOverrideError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you're ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.</p>
    /// <p>New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end recipients and SMS or voice recipients from fraud and abuse. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl DescribeAccountAttributes {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAccountAttributesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAccountAttributesPaginator {
            crate::paginator::DescribeAccountAttributesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountLimits`.
    ///
    /// <p>Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.</p>
    /// <p>When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_limits_input::Builder,
    }
    impl DescribeAccountLimits {
        /// Creates a new `DescribeAccountLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAccountLimitsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAccountLimitsPaginator {
            crate::paginator::DescribeAccountLimitsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationSets`.
    ///
    /// <p>Describes the specified configuration sets or all in your account.</p>
    /// <p>If you specify configuration set names, the output includes information for only the specified configuration sets. If you specify filters, the output includes information for only those configuration sets that meet the filter criteria. If you don't specify configuration set names or filters, the output includes information for all configuration sets.</p>
    /// <p>If you specify a configuration set name that isn't valid, an error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_configuration_sets_input::Builder,
    }
    impl DescribeConfigurationSets {
        /// Creates a new `DescribeConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConfigurationSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeConfigurationSetsPaginator {
            crate::paginator::DescribeConfigurationSetsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ConfigurationSetNames`.
        ///
        /// To override the contents of this collection use [`set_configuration_set_names`](Self::set_configuration_set_names).
        ///
        /// <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_names(input.into());
            self
        }
        /// <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_names(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters to apply to the results that are returned.</p>
        pub fn filters(mut self, input: crate::model::ConfigurationSetFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of filters to apply to the results that are returned.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeKeywords`.
    ///
    /// <p>Describes the specified keywords or all keywords on your origination phone number or pool.</p>
    /// <p>A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p>
    /// <p>If you specify a keyword that isn't valid, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeKeywords {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_keywords_input::Builder,
    }
    impl DescribeKeywords {
        /// Creates a new `DescribeKeywords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeKeywordsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeKeywordsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeKeywordsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeKeywordsPaginator {
            crate::paginator::DescribeKeywordsPaginator::new(self.handle, self.inner)
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// Appends an item to `Keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array of keywords to search for.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(input.into());
            self
        }
        /// <p>An array of keywords to search for.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of keyword filters to filter the results.</p>
        pub fn filters(mut self, input: crate::model::KeywordFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of keyword filters to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOptedOutNumbers`.
    ///
    /// <p>Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.</p>
    /// <p>If you specify opted out numbers, the output includes information for only the specified opted out numbers. If you specify filters, the output includes information for only those opted out numbers that meet the filter criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out destination numbers in your opt-out list.</p>
    /// <p>If you specify an opted out number that isn't valid, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOptedOutNumbers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_opted_out_numbers_input::Builder,
    }
    impl DescribeOptedOutNumbers {
        /// Creates a new `DescribeOptedOutNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOptedOutNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOptedOutNumbersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOptedOutNumbersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeOptedOutNumbersPaginator {
            crate::paginator::DescribeOptedOutNumbersPaginator::new(self.handle, self.inner)
        }
        /// <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// Appends an item to `OptedOutNumbers`.
        ///
        /// To override the contents of this collection use [`set_opted_out_numbers`](Self::set_opted_out_numbers).
        ///
        /// <p>An array of phone numbers to search for in the OptOutList.</p>
        pub fn opted_out_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opted_out_numbers(input.into());
            self
        }
        /// <p>An array of phone numbers to search for in the OptOutList.</p>
        pub fn set_opted_out_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_opted_out_numbers(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of OptedOutFilter objects to filter the results on.</p>
        pub fn filters(mut self, input: crate::model::OptedOutFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of OptedOutFilter objects to filter the results on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptedOutFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOptOutLists`.
    ///
    /// <p>Describes the specified opt-out list or all opt-out lists in your account.</p>
    /// <p>If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the output includes information for all opt-out lists.</p>
    /// <p>If you specify an opt-out list name that isn't valid, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOptOutLists {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_opt_out_lists_input::Builder,
    }
    impl DescribeOptOutLists {
        /// Creates a new `DescribeOptOutLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOptOutListsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOptOutListsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOptOutListsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeOptOutListsPaginator {
            crate::paginator::DescribeOptOutListsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `OptOutListNames`.
        ///
        /// To override the contents of this collection use [`set_opt_out_list_names`](Self::set_opt_out_list_names).
        ///
        /// <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
        pub fn opt_out_list_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_names(input.into());
            self
        }
        /// <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
        pub fn set_opt_out_list_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_names(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePhoneNumbers`.
    ///
    /// <p>Describes the specified origination phone number, or all the phone numbers in your account.</p>
    /// <p>If you specify phone number IDs, the output includes information for only the specified phone numbers. If you specify filters, the output includes information for only those phone numbers that meet the filter criteria. If you don't specify phone number IDs or filters, the output includes information for all phone numbers.</p>
    /// <p>If you specify a phone number ID that isn't valid, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePhoneNumbers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_phone_numbers_input::Builder,
    }
    impl DescribePhoneNumbers {
        /// Creates a new `DescribePhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePhoneNumbersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePhoneNumbersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePhoneNumbersPaginator {
            crate::paginator::DescribePhoneNumbersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `PhoneNumberIds`.
        ///
        /// To override the contents of this collection use [`set_phone_number_ids`](Self::set_phone_number_ids).
        ///
        /// <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn phone_number_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_ids(input.into());
            self
        }
        /// <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn set_phone_number_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of PhoneNumberFilter objects to filter the results.</p>
        pub fn filters(mut self, input: crate::model::PhoneNumberFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of PhoneNumberFilter objects to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePools`.
    ///
    /// <p>Retrieves the specified pools or all pools associated with your Amazon Web Services account.</p>
    /// <p>If you specify pool IDs, the output includes information for only the specified pools. If you specify filters, the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs or filters, the output includes information for all pools.</p>
    /// <p>If you specify a pool ID that isn't valid, an Error is returned.</p>
    /// <p>A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePools {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pools_input::Builder,
    }
    impl DescribePools {
        /// Creates a new `DescribePools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePoolsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePoolsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePoolsPaginator {
            crate::paginator::DescribePoolsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `PoolIds`.
        ///
        /// To override the contents of this collection use [`set_pool_ids`](Self::set_pool_ids).
        ///
        /// <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
        pub fn pool_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_ids(input.into());
            self
        }
        /// <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
        pub fn set_pool_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pool_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of PoolFilter objects to filter the results.</p>
        pub fn filters(mut self, input: crate::model::PoolFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of PoolFilter objects to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PoolFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSenderIds`.
    ///
    /// <p>Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.</p>
    /// <p>If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't specify SenderIds or filters, the output includes information for all SenderIds.</p>
    /// <p>f you specify a sender ID that isn't valid, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSenderIds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_sender_ids_input::Builder,
    }
    impl DescribeSenderIds {
        /// Creates a new `DescribeSenderIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSenderIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSenderIdsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSenderIdsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSenderIdsPaginator {
            crate::paginator::DescribeSenderIdsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `SenderIds`.
        ///
        /// To override the contents of this collection use [`set_sender_ids`](Self::set_sender_ids).
        ///
        /// <p>An array of SenderIdAndCountry objects to search for.</p>
        pub fn sender_ids(mut self, input: crate::model::SenderIdAndCountry) -> Self {
            self.inner = self.inner.sender_ids(input);
            self
        }
        /// <p>An array of SenderIdAndCountry objects to search for.</p>
        pub fn set_sender_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SenderIdAndCountry>>,
        ) -> Self {
            self.inner = self.inner.set_sender_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of SenderIdFilter objects to filter the results.</p>
        pub fn filters(mut self, input: crate::model::SenderIdFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of SenderIdFilter objects to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SenderIdFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSpendLimits`.
    ///
    /// <p>Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.</p>
    /// <p>When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region. For more information on increasing your monthly spend limit, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSpendLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_spend_limits_input::Builder,
    }
    impl DescribeSpendLimits {
        /// Creates a new `DescribeSpendLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSpendLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSpendLimitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSpendLimitsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSpendLimitsPaginator {
            crate::paginator::DescribeSpendLimitsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateOriginationIdentity`.
    ///
    /// <p>Removes the specified origination identity from an existing pool.</p>
    /// <p>If the origination identity isn't associated with the specified pool, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateOriginationIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_origination_identity_input::Builder,
    }
    impl DisassociateOriginationIdentity {
        /// Creates a new `DisassociateOriginationIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateOriginationIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateOriginationIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iso_country_code(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iso_country_code(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPoolOriginationIdentities`.
    ///
    /// <p>Lists all associated origination identities in your pool.</p>
    /// <p>If you specify filters, the output includes information for only those origination identities that meet the filter criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPoolOriginationIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pool_origination_identities_input::Builder,
    }
    impl ListPoolOriginationIdentities {
        /// Creates a new `ListPoolOriginationIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoolOriginationIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoolOriginationIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPoolOriginationIdentitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPoolOriginationIdentitiesPaginator {
            crate::paginator::ListPoolOriginationIdentitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
        pub fn filters(mut self, input: crate::model::PoolOriginationIdentitiesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PoolOriginationIdentitiesFilter>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags associated with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutKeyword`.
    ///
    /// <p>Creates or updates a keyword configuration on an origination phone number or pool.</p>
    /// <p> A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p>
    /// <p>If you specify a keyword that isn't valid, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutKeyword {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_keyword_input::Builder,
    }
    impl PutKeyword {
        /// Creates a new `PutKeyword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutKeywordOutput,
            aws_smithy_http::result::SdkError<crate::error::PutKeywordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The new keyword to add.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyword(input.into());
            self
        }
        /// <p>The new keyword to add.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keyword(input);
            self
        }
        /// <p>The message associated with the keyword.</p>
        /// <ul>
        /// <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>
        /// <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>
        /// <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>
        /// </ul>
        pub fn keyword_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyword_message(input.into());
            self
        }
        /// <p>The message associated with the keyword.</p>
        /// <ul>
        /// <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>
        /// <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>
        /// <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>
        /// </ul>
        pub fn set_keyword_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyword_message(input);
            self
        }
        /// <p>The action to perform for the new keyword when it is received.</p>
        pub fn keyword_action(mut self, input: crate::model::KeywordAction) -> Self {
            self.inner = self.inner.keyword_action(input);
            self
        }
        /// <p>The action to perform for the new keyword when it is received.</p>
        pub fn set_keyword_action(
            mut self,
            input: std::option::Option<crate::model::KeywordAction>,
        ) -> Self {
            self.inner = self.inner.set_keyword_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutOptedOutNumber`.
    ///
    /// <p>Creates an opted out destination phone number in the opt-out list.</p>
    /// <p>If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutOptedOutNumber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_opted_out_number_input::Builder,
    }
    impl PutOptedOutNumber {
        /// Creates a new `PutOptedOutNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutOptedOutNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::PutOptedOutNumberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// <p>The phone number to add to the OptOutList in E.164 format.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opted_out_number(input.into());
            self
        }
        /// <p>The phone number to add to the OptOutList in E.164 format.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opted_out_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReleasePhoneNumber`.
    ///
    /// <p>Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.</p>
    /// <p>If the origination phone number has deletion protection enabled or is associated with a pool, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReleasePhoneNumber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::release_phone_number_input::Builder,
    }
    impl ReleasePhoneNumber {
        /// Creates a new `ReleasePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReleasePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::ReleasePhoneNumberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(input.into());
            self
        }
        /// <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestPhoneNumber`.
    ///
    /// <p>Request an origination phone number for use in your account. For more information on phone number request see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html"> Requesting a number </a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RequestPhoneNumber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::request_phone_number_input::Builder,
    }
    impl RequestPhoneNumber {
        /// Creates a new `RequestPhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestPhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestPhoneNumberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iso_country_code(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iso_country_code(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.inner = self.inner.message_type(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.inner = self.inner.set_message_type(input);
            self
        }
        /// Appends an item to `NumberCapabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            self.inner = self.inner.number_capabilities(input);
            self
        }
        /// <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.inner = self.inner.set_number_capabilities(input);
            self
        }
        /// <p>The type of phone number to request.</p>
        pub fn number_type(mut self, input: crate::model::RequestableNumberType) -> Self {
            self.inner = self.inner.number_type(input);
            self
        }
        /// <p>The type of phone number to request.</p>
        pub fn set_number_type(
            mut self,
            input: std::option::Option<crate::model::RequestableNumberType>,
        ) -> Self {
            self.inner = self.inner.set_number_type(input);
            self
        }
        /// <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>Use this field to attach your phone number for an external registration process.</p>
        pub fn registration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registration_id(input.into());
            self
        }
        /// <p>Use this field to attach your phone number for an external registration process.</p>
        pub fn set_registration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registration_id(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection_enabled(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTextMessage`.
    ///
    /// <p>Creates a new text message and sends it to a recipient's phone number.</p>
    /// <p>SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination country of your messages, as well as the type of phone number (origination number) that you use to send the message. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html">Message Parts per Second (MPS) limits</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendTextMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_text_message_input::Builder,
    }
    impl SendTextMessage {
        /// Creates a new `SendTextMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTextMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTextMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The destination phone number in E.164 format.</p>
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_phone_number(input.into());
            self
        }
        /// <p>The destination phone number in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_phone_number(input);
            self
        }
        /// <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The body of the text message.</p>
        pub fn message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_body(input.into());
            self
        }
        /// <p>The body of the text message.</p>
        pub fn set_message_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_body(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.inner = self.inner.message_type(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.inner = self.inner.set_message_type(input);
            self
        }
        /// <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyword(input.into());
            self
        }
        /// <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_keyword(input);
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
        pub fn max_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_price(input.into());
            self
        }
        /// <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
        pub fn set_max_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_price(input);
            self
        }
        /// <p>How long the text message is valid for. By default this is 72 hours.</p>
        pub fn time_to_live(mut self, input: i32) -> Self {
            self.inner = self.inner.time_to_live(input);
            self
        }
        /// <p>How long the text message is valid for. By default this is 72 hours.</p>
        pub fn set_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_to_live(input);
            self
        }
        /// Adds a key-value pair to `Context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.context(k.into(), v.into());
            self
        }
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_context(input);
            self
        }
        /// Adds a key-value pair to `DestinationCountryParameters`.
        ///
        /// To override the contents of this collection use [`set_destination_country_parameters`](Self::set_destination_country_parameters).
        ///
        /// <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
        pub fn destination_country_parameters(
            mut self,
            k: crate::model::DestinationCountryParameterKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_country_parameters(k, v.into());
            self
        }
        /// <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
        pub fn set_destination_country_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DestinationCountryParameterKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_destination_country_parameters(input);
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendVoiceMessage`.
    ///
    /// <p>Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses <a href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendVoiceMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_voice_message_input::Builder,
    }
    impl SendVoiceMessage {
        /// Creates a new `SendVoiceMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendVoiceMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendVoiceMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The destination phone number in E.164 format.</p>
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_phone_number(input.into());
            self
        }
        /// <p>The destination phone number in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_phone_number(input);
            self
        }
        /// <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_identity(input.into());
            self
        }
        /// <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_identity(input);
            self
        }
        /// <p>The text to convert to a voice message.</p>
        pub fn message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_body(input.into());
            self
        }
        /// <p>The text to convert to a voice message.</p>
        pub fn set_message_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_body(input);
            self
        }
        /// <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>
        /// <ul>
        /// <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>
        /// <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>
        /// </ul>
        pub fn message_body_text_type(
            mut self,
            input: crate::model::VoiceMessageBodyTextType,
        ) -> Self {
            self.inner = self.inner.message_body_text_type(input);
            self
        }
        /// <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>
        /// <ul>
        /// <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>
        /// <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>
        /// </ul>
        pub fn set_message_body_text_type(
            mut self,
            input: std::option::Option<crate::model::VoiceMessageBodyTextType>,
        ) -> Self {
            self.inner = self.inner.set_message_body_text_type(input);
            self
        }
        /// <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
        pub fn voice_id(mut self, input: crate::model::VoiceId) -> Self {
            self.inner = self.inner.voice_id(input);
            self
        }
        /// <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.inner = self.inner.set_voice_id(input);
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The maximum amount to spend per voice message, in US dollars.</p>
        pub fn max_price_per_minute(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_price_per_minute(input.into());
            self
        }
        /// <p>The maximum amount to spend per voice message, in US dollars.</p>
        pub fn set_max_price_per_minute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_price_per_minute(input);
            self
        }
        /// <p>How long the voice message is valid for. By default this is 72 hours.</p>
        pub fn time_to_live(mut self, input: i32) -> Self {
            self.inner = self.inner.time_to_live(input);
            self
        }
        /// <p>How long the voice message is valid for. By default this is 72 hours.</p>
        pub fn set_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_to_live(input);
            self
        }
        /// Adds a key-value pair to `Context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.context(k.into(), v.into());
            self
        }
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_context(input);
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetDefaultMessageType`.
    ///
    /// <p>Sets the default message type on a configuration set.</p>
    /// <p>Choose the category of SMS messages that you plan to send from this account. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to your entire Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetDefaultMessageType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_default_message_type_input::Builder,
    }
    impl SetDefaultMessageType {
        /// Creates a new `SetDefaultMessageType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetDefaultMessageTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::SetDefaultMessageTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.inner = self.inner.message_type(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.inner = self.inner.set_message_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetDefaultSenderId`.
    ///
    /// <p>Sets default sender ID on a configuration set.</p>
    /// <p>When sending a text message to a destination country that supports sender IDs, the default sender ID on the configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are available in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetDefaultSenderId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_default_sender_id_input::Builder,
    }
    impl SetDefaultSenderId {
        /// Creates a new `SetDefaultSenderId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetDefaultSenderIdOutput,
            aws_smithy_http::result::SdkError<crate::error::SetDefaultSenderIdError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sender_id(input.into());
            self
        }
        /// <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sender_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTextMessageSpendLimitOverride`.
    ///
    /// <p>Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetTextMessageSpendLimitOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_text_message_spend_limit_override_input::Builder,
    }
    impl SetTextMessageSpendLimitOverride {
        /// Creates a new `SetTextMessageSpendLimitOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTextMessageSpendLimitOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTextMessageSpendLimitOverrideError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new monthly limit to enforce on text messages.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.inner = self.inner.monthly_limit(input);
            self
        }
        /// <p>The new monthly limit to enforce on text messages.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_monthly_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetVoiceMessageSpendLimitOverride`.
    ///
    /// <p>Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetVoiceMessageSpendLimitOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_voice_message_spend_limit_override_input::Builder,
    }
    impl SetVoiceMessageSpendLimitOverride {
        /// Creates a new `SetVoiceMessageSpendLimitOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetVoiceMessageSpendLimitOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::SetVoiceMessageSpendLimitOverrideError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new monthly limit to enforce on voice messages.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.inner = self.inner.monthly_limit(input);
            self
        }
        /// <p>The new monthly limit to enforce on voice messages.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_monthly_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that are associated with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key and value pair tags that are associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag key values to unassociate with the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>An array of tag key values to unassociate with the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventDestination`.
    ///
    /// <p>Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.</p>
    /// <p>You may want to update an event destination to change its matching event types or updating the destination resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_event_destination_input::Builder,
    }
    impl UpdateEventDestination {
        /// Creates a new `UpdateEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name to use for the event destination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name to use for the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>When set to true logging is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>When set to true logging is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `MatchingEventTypes`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>An array of event types that determine which events to log.</p>
        pub fn matching_event_types(mut self, input: crate::model::EventType) -> Self {
            self.inner = self.inner.matching_event_types(input);
            self
        }
        /// <p>An array of event types that determine which events to log.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.inner = self.inner.set_matching_event_types(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.inner = self.inner.kinesis_firehose_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_firehose_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.inner = self.inner.sns_destination(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.inner = self.inner.set_sns_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePhoneNumber`.
    ///
    /// <p>Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.</p>
    /// <p>If the origination phone number is associated with a pool, an Error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePhoneNumber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_phone_number_input::Builder,
    }
    impl UpdatePhoneNumber {
        /// Creates a new `UpdatePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePhoneNumberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(input.into());
            self
        }
        /// <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.two_way_enabled(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_two_way_enabled(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.two_way_channel_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_two_way_channel_arn(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.self_managed_opt_outs_enabled(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_self_managed_opt_outs_enabled(input);
            self
        }
        /// <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection_enabled(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePool`.
    ///
    /// <p>Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pool_input::Builder,
    }
    impl UpdatePool {
        /// Creates a new `UpdatePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_id(input.into());
            self
        }
        /// <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_id(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.two_way_enabled(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_two_way_enabled(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.two_way_channel_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_two_way_channel_arn(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.self_managed_opt_outs_enabled(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_self_managed_opt_outs_enabled(input);
            self
        }
        /// <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_out_list_name(input.into());
            self
        }
        /// <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_opt_out_list_name(input);
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn shared_routes_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.shared_routes_enabled(input);
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn set_shared_routes_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_shared_routes_enabled(input);
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection_enabled(input);
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection_enabled(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
