// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The field associated with the validation exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message associated with the validation exception with information to help determine its cause.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message associated with the validation exception with information to help determine its cause.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message associated with the validation exception with information to help determine its cause.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the validation exception with information to help determine its cause.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotAddOptedOutNumber,
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    CountryCodeMismatch,
    #[allow(missing_docs)] // documentation missing in model
    DestinationCountryBlocked,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    InvalidArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidFilterValues,
    #[allow(missing_docs)] // documentation missing in model
    InvalidIdentityForDestinationCountry,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNextToken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidParameter,
    #[allow(missing_docs)] // documentation missing in model
    MissingParameter,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    ParametersCannotBeUsedTogether,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberCannotBeOptedIn,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberCannotBeReleased,
    #[allow(missing_docs)] // documentation missing in model
    PriceOverThreshold,
    #[allow(missing_docs)] // documentation missing in model
    RequestedSpendLimitHigherThanServiceLimit,
    #[allow(missing_docs)] // documentation missing in model
    SenderIdNotRegistered,
    #[allow(missing_docs)] // documentation missing in model
    SenderIdNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayNotEnabled,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayNotSupportedInCountry,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayNotSupportedInRegion,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayTopicNotPresent,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_ADD_OPTED_OUT_NUMBER" => ValidationExceptionReason::CannotAddOptedOutNumber,
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "COUNTRY_CODE_MISMATCH" => ValidationExceptionReason::CountryCodeMismatch,
            "DESTINATION_COUNTRY_BLOCKED" => ValidationExceptionReason::DestinationCountryBlocked,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "INVALID_ARN" => ValidationExceptionReason::InvalidArn,
            "INVALID_FILTER_VALUES" => ValidationExceptionReason::InvalidFilterValues,
            "INVALID_IDENTITY_FOR_DESTINATION_COUNTRY" => {
                ValidationExceptionReason::InvalidIdentityForDestinationCountry
            }
            "INVALID_NEXT_TOKEN" => ValidationExceptionReason::InvalidNextToken,
            "INVALID_PARAMETER" => ValidationExceptionReason::InvalidParameter,
            "MISSING_PARAMETER" => ValidationExceptionReason::MissingParameter,
            "OTHER" => ValidationExceptionReason::Other,
            "PARAMETERS_CANNOT_BE_USED_TOGETHER" => {
                ValidationExceptionReason::ParametersCannotBeUsedTogether
            }
            "PHONE_NUMBER_CANNOT_BE_OPTED_IN" => {
                ValidationExceptionReason::PhoneNumberCannotBeOptedIn
            }
            "PHONE_NUMBER_CANNOT_BE_RELEASED" => {
                ValidationExceptionReason::PhoneNumberCannotBeReleased
            }
            "PRICE_OVER_THRESHOLD" => ValidationExceptionReason::PriceOverThreshold,
            "REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT" => {
                ValidationExceptionReason::RequestedSpendLimitHigherThanServiceLimit
            }
            "SENDER_ID_NOT_REGISTERED" => ValidationExceptionReason::SenderIdNotRegistered,
            "SENDER_ID_NOT_SUPPORTED" => ValidationExceptionReason::SenderIdNotSupported,
            "TWO_WAY_NOT_ENABLED" => ValidationExceptionReason::TwoWayNotEnabled,
            "TWO_WAY_NOT_SUPPORTED_IN_COUNTRY" => {
                ValidationExceptionReason::TwoWayNotSupportedInCountry
            }
            "TWO_WAY_NOT_SUPPORTED_IN_REGION" => {
                ValidationExceptionReason::TwoWayNotSupportedInRegion
            }
            "TWO_WAY_TOPIC_NOT_PRESENT" => ValidationExceptionReason::TwoWayTopicNotPresent,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotAddOptedOutNumber => "CANNOT_ADD_OPTED_OUT_NUMBER",
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::CountryCodeMismatch => "COUNTRY_CODE_MISMATCH",
            ValidationExceptionReason::DestinationCountryBlocked => "DESTINATION_COUNTRY_BLOCKED",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::InvalidArn => "INVALID_ARN",
            ValidationExceptionReason::InvalidFilterValues => "INVALID_FILTER_VALUES",
            ValidationExceptionReason::InvalidIdentityForDestinationCountry => {
                "INVALID_IDENTITY_FOR_DESTINATION_COUNTRY"
            }
            ValidationExceptionReason::InvalidNextToken => "INVALID_NEXT_TOKEN",
            ValidationExceptionReason::InvalidParameter => "INVALID_PARAMETER",
            ValidationExceptionReason::MissingParameter => "MISSING_PARAMETER",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::ParametersCannotBeUsedTogether => {
                "PARAMETERS_CANNOT_BE_USED_TOGETHER"
            }
            ValidationExceptionReason::PhoneNumberCannotBeOptedIn => {
                "PHONE_NUMBER_CANNOT_BE_OPTED_IN"
            }
            ValidationExceptionReason::PhoneNumberCannotBeReleased => {
                "PHONE_NUMBER_CANNOT_BE_RELEASED"
            }
            ValidationExceptionReason::PriceOverThreshold => "PRICE_OVER_THRESHOLD",
            ValidationExceptionReason::RequestedSpendLimitHigherThanServiceLimit => {
                "REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT"
            }
            ValidationExceptionReason::SenderIdNotRegistered => "SENDER_ID_NOT_REGISTERED",
            ValidationExceptionReason::SenderIdNotSupported => "SENDER_ID_NOT_SUPPORTED",
            ValidationExceptionReason::TwoWayNotEnabled => "TWO_WAY_NOT_ENABLED",
            ValidationExceptionReason::TwoWayNotSupportedInCountry => {
                "TWO_WAY_NOT_SUPPORTED_IN_COUNTRY"
            }
            ValidationExceptionReason::TwoWayNotSupportedInRegion => {
                "TWO_WAY_NOT_SUPPORTED_IN_REGION"
            }
            ValidationExceptionReason::TwoWayTopicNotPresent => "TWO_WAY_TOPIC_NOT_PRESENT",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_ADD_OPTED_OUT_NUMBER",
            "CANNOT_PARSE",
            "COUNTRY_CODE_MISMATCH",
            "DESTINATION_COUNTRY_BLOCKED",
            "FIELD_VALIDATION_FAILED",
            "INVALID_ARN",
            "INVALID_FILTER_VALUES",
            "INVALID_IDENTITY_FOR_DESTINATION_COUNTRY",
            "INVALID_NEXT_TOKEN",
            "INVALID_PARAMETER",
            "MISSING_PARAMETER",
            "OTHER",
            "PARAMETERS_CANNOT_BE_USED_TOGETHER",
            "PHONE_NUMBER_CANNOT_BE_OPTED_IN",
            "PHONE_NUMBER_CANNOT_BE_RELEASED",
            "PRICE_OVER_THRESHOLD",
            "REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT",
            "SENDER_ID_NOT_REGISTERED",
            "SENDER_ID_NOT_SUPPORTED",
            "TWO_WAY_NOT_ENABLED",
            "TWO_WAY_NOT_SUPPORTED_IN_COUNTRY",
            "TWO_WAY_NOT_SUPPORTED_IN_REGION",
            "TWO_WAY_TOPIC_NOT_PRESENT",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSet,
    #[allow(missing_docs)] // documentation missing in model
    EventDestination,
    #[allow(missing_docs)] // documentation missing in model
    Keyword,
    #[allow(missing_docs)] // documentation missing in model
    OptOutList,
    #[allow(missing_docs)] // documentation missing in model
    OptedOutNumber,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    Pool,
    #[allow(missing_docs)] // documentation missing in model
    Registration,
    #[allow(missing_docs)] // documentation missing in model
    SenderId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "account" => ResourceType::Account,
            "configuration-set" => ResourceType::ConfigurationSet,
            "event-destination" => ResourceType::EventDestination,
            "keyword" => ResourceType::Keyword,
            "opt-out-list" => ResourceType::OptOutList,
            "opted-out-number" => ResourceType::OptedOutNumber,
            "phone-number" => ResourceType::PhoneNumber,
            "pool" => ResourceType::Pool,
            "registration" => ResourceType::Registration,
            "sender-id" => ResourceType::SenderId,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Account => "account",
            ResourceType::ConfigurationSet => "configuration-set",
            ResourceType::EventDestination => "event-destination",
            ResourceType::Keyword => "keyword",
            ResourceType::OptOutList => "opt-out-list",
            ResourceType::OptedOutNumber => "opted-out-number",
            ResourceType::PhoneNumber => "phone-number",
            ResourceType::Pool => "pool",
            ResourceType::Registration => "registration",
            ResourceType::SenderId => "sender-id",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "account",
            "configuration-set",
            "event-destination",
            "keyword",
            "opt-out-list",
            "opted-out-number",
            "phone-number",
            "pool",
            "registration",
            "sender-id",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConflictExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    DeletionProtectionEnabled,
    #[allow(missing_docs)] // documentation missing in model
    DestinationPhoneNumberNotVerified,
    #[allow(missing_docs)] // documentation missing in model
    DestinationPhoneNumberOptedOut,
    #[allow(missing_docs)] // documentation missing in model
    EventDestinationMismatch,
    #[allow(missing_docs)] // documentation missing in model
    KeywordMismatch,
    #[allow(missing_docs)] // documentation missing in model
    LastPhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    MessageTypeMismatch,
    #[allow(missing_docs)] // documentation missing in model
    NoOriginationIdentitiesFound,
    #[allow(missing_docs)] // documentation missing in model
    OptOutListMismatch,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberAssociatedToPool,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberNotAssociatedToPool,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberNotInRegistrationRegion,
    #[allow(missing_docs)] // documentation missing in model
    ResourceAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    ResourceDeletionNotAllowed,
    #[allow(missing_docs)] // documentation missing in model
    ResourceModificationNotAllowed,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotActive,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotEmpty,
    #[allow(missing_docs)] // documentation missing in model
    SelfManagedOptOutsMismatch,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayConfigMismatch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConflictExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "DELETION_PROTECTION_ENABLED" => ConflictExceptionReason::DeletionProtectionEnabled,
            "DESTINATION_PHONE_NUMBER_NOT_VERIFIED" => {
                ConflictExceptionReason::DestinationPhoneNumberNotVerified
            }
            "DESTINATION_PHONE_NUMBER_OPTED_OUT" => {
                ConflictExceptionReason::DestinationPhoneNumberOptedOut
            }
            "EVENT_DESTINATION_MISMATCH" => ConflictExceptionReason::EventDestinationMismatch,
            "KEYWORD_MISMATCH" => ConflictExceptionReason::KeywordMismatch,
            "LAST_PHONE_NUMBER" => ConflictExceptionReason::LastPhoneNumber,
            "MESSAGE_TYPE_MISMATCH" => ConflictExceptionReason::MessageTypeMismatch,
            "NO_ORIGINATION_IDENTITIES_FOUND" => {
                ConflictExceptionReason::NoOriginationIdentitiesFound
            }
            "OPT_OUT_LIST_MISMATCH" => ConflictExceptionReason::OptOutListMismatch,
            "PHONE_NUMBER_ASSOCIATED_TO_POOL" => {
                ConflictExceptionReason::PhoneNumberAssociatedToPool
            }
            "PHONE_NUMBER_NOT_ASSOCIATED_TO_POOL" => {
                ConflictExceptionReason::PhoneNumberNotAssociatedToPool
            }
            "PHONE_NUMBER_NOT_IN_REGISTRATION_REGION" => {
                ConflictExceptionReason::PhoneNumberNotInRegistrationRegion
            }
            "RESOURCE_ALREADY_EXISTS" => ConflictExceptionReason::ResourceAlreadyExists,
            "RESOURCE_DELETION_NOT_ALLOWED" => ConflictExceptionReason::ResourceDeletionNotAllowed,
            "RESOURCE_MODIFICATION_NOT_ALLOWED" => {
                ConflictExceptionReason::ResourceModificationNotAllowed
            }
            "RESOURCE_NOT_ACTIVE" => ConflictExceptionReason::ResourceNotActive,
            "RESOURCE_NOT_EMPTY" => ConflictExceptionReason::ResourceNotEmpty,
            "SELF_MANAGED_OPT_OUTS_MISMATCH" => ConflictExceptionReason::SelfManagedOptOutsMismatch,
            "TWO_WAY_CONFIG_MISMATCH" => ConflictExceptionReason::TwoWayConfigMismatch,
            other => ConflictExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConflictExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConflictExceptionReason::from(s))
    }
}
impl ConflictExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConflictExceptionReason::DeletionProtectionEnabled => "DELETION_PROTECTION_ENABLED",
            ConflictExceptionReason::DestinationPhoneNumberNotVerified => {
                "DESTINATION_PHONE_NUMBER_NOT_VERIFIED"
            }
            ConflictExceptionReason::DestinationPhoneNumberOptedOut => {
                "DESTINATION_PHONE_NUMBER_OPTED_OUT"
            }
            ConflictExceptionReason::EventDestinationMismatch => "EVENT_DESTINATION_MISMATCH",
            ConflictExceptionReason::KeywordMismatch => "KEYWORD_MISMATCH",
            ConflictExceptionReason::LastPhoneNumber => "LAST_PHONE_NUMBER",
            ConflictExceptionReason::MessageTypeMismatch => "MESSAGE_TYPE_MISMATCH",
            ConflictExceptionReason::NoOriginationIdentitiesFound => {
                "NO_ORIGINATION_IDENTITIES_FOUND"
            }
            ConflictExceptionReason::OptOutListMismatch => "OPT_OUT_LIST_MISMATCH",
            ConflictExceptionReason::PhoneNumberAssociatedToPool => {
                "PHONE_NUMBER_ASSOCIATED_TO_POOL"
            }
            ConflictExceptionReason::PhoneNumberNotAssociatedToPool => {
                "PHONE_NUMBER_NOT_ASSOCIATED_TO_POOL"
            }
            ConflictExceptionReason::PhoneNumberNotInRegistrationRegion => {
                "PHONE_NUMBER_NOT_IN_REGISTRATION_REGION"
            }
            ConflictExceptionReason::ResourceAlreadyExists => "RESOURCE_ALREADY_EXISTS",
            ConflictExceptionReason::ResourceDeletionNotAllowed => "RESOURCE_DELETION_NOT_ALLOWED",
            ConflictExceptionReason::ResourceModificationNotAllowed => {
                "RESOURCE_MODIFICATION_NOT_ALLOWED"
            }
            ConflictExceptionReason::ResourceNotActive => "RESOURCE_NOT_ACTIVE",
            ConflictExceptionReason::ResourceNotEmpty => "RESOURCE_NOT_EMPTY",
            ConflictExceptionReason::SelfManagedOptOutsMismatch => "SELF_MANAGED_OPT_OUTS_MISMATCH",
            ConflictExceptionReason::TwoWayConfigMismatch => "TWO_WAY_CONFIG_MISMATCH",
            ConflictExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETION_PROTECTION_ENABLED",
            "DESTINATION_PHONE_NUMBER_NOT_VERIFIED",
            "DESTINATION_PHONE_NUMBER_OPTED_OUT",
            "EVENT_DESTINATION_MISMATCH",
            "KEYWORD_MISMATCH",
            "LAST_PHONE_NUMBER",
            "MESSAGE_TYPE_MISMATCH",
            "NO_ORIGINATION_IDENTITIES_FOUND",
            "OPT_OUT_LIST_MISMATCH",
            "PHONE_NUMBER_ASSOCIATED_TO_POOL",
            "PHONE_NUMBER_NOT_ASSOCIATED_TO_POOL",
            "PHONE_NUMBER_NOT_IN_REGISTRATION_REGION",
            "RESOURCE_ALREADY_EXISTS",
            "RESOURCE_DELETION_NOT_ALLOWED",
            "RESOURCE_MODIFICATION_NOT_ALLOWED",
            "RESOURCE_NOT_ACTIVE",
            "RESOURCE_NOT_EMPTY",
            "SELF_MANAGED_OPT_OUTS_MISMATCH",
            "TWO_WAY_CONFIG_MISMATCH",
        ]
    }
}
impl AsRef<str> for ConflictExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessDeniedExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    AccountDisabled,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientAccountReputation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessDeniedExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_DISABLED" => AccessDeniedExceptionReason::AccountDisabled,
            "INSUFFICIENT_ACCOUNT_REPUTATION" => {
                AccessDeniedExceptionReason::InsufficientAccountReputation
            }
            other => AccessDeniedExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessDeniedExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessDeniedExceptionReason::from(s))
    }
}
impl AccessDeniedExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessDeniedExceptionReason::AccountDisabled => "ACCOUNT_DISABLED",
            AccessDeniedExceptionReason::InsufficientAccountReputation => {
                "INSUFFICIENT_ACCOUNT_REPUTATION"
            }
            AccessDeniedExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_DISABLED", "INSUFFICIENT_ACCOUNT_REPUTATION"]
    }
}
impl AsRef<str> for AccessDeniedExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageType {
    #[allow(missing_docs)] // documentation missing in model
    Promotional,
    #[allow(missing_docs)] // documentation missing in model
    Transactional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageType {
    fn from(s: &str) -> Self {
        match s {
            "PROMOTIONAL" => MessageType::Promotional,
            "TRANSACTIONAL" => MessageType::Transactional,
            other => MessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageType::from(s))
    }
}
impl MessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageType::Promotional => "PROMOTIONAL",
            MessageType::Transactional => "TRANSACTIONAL",
            MessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROMOTIONAL", "TRANSACTIONAL"]
    }
}
impl AsRef<str> for MessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PoolStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PoolStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => PoolStatus::Active,
            "CREATING" => PoolStatus::Creating,
            "DELETING" => PoolStatus::Deleting,
            other => PoolStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PoolStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PoolStatus::from(s))
    }
}
impl PoolStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PoolStatus::Active => "ACTIVE",
            PoolStatus::Creating => "CREATING",
            PoolStatus::Deleting => "DELETING",
            PoolStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for PoolStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NumberType {
    #[allow(missing_docs)] // documentation missing in model
    LongCode,
    #[allow(missing_docs)] // documentation missing in model
    ShortCode,
    #[allow(missing_docs)] // documentation missing in model
    TenDlc,
    #[allow(missing_docs)] // documentation missing in model
    TollFree,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NumberType {
    fn from(s: &str) -> Self {
        match s {
            "LONG_CODE" => NumberType::LongCode,
            "SHORT_CODE" => NumberType::ShortCode,
            "TEN_DLC" => NumberType::TenDlc,
            "TOLL_FREE" => NumberType::TollFree,
            other => NumberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NumberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NumberType::from(s))
    }
}
impl NumberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NumberType::LongCode => "LONG_CODE",
            NumberType::ShortCode => "SHORT_CODE",
            NumberType::TenDlc => "TEN_DLC",
            NumberType::TollFree => "TOLL_FREE",
            NumberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LONG_CODE", "SHORT_CODE", "TEN_DLC", "TOLL_FREE"]
    }
}
impl AsRef<str> for NumberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NumberCapability {
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NumberCapability {
    fn from(s: &str) -> Self {
        match s {
            "SMS" => NumberCapability::Sms,
            "VOICE" => NumberCapability::Voice,
            other => NumberCapability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NumberCapability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NumberCapability::from(s))
    }
}
impl NumberCapability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NumberCapability::Sms => "SMS",
            NumberCapability::Voice => "VOICE",
            NumberCapability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SMS", "VOICE"]
    }
}
impl AsRef<str> for NumberCapability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NumberStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Associating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disassociating,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NumberStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => NumberStatus::Active,
            "ASSOCIATING" => NumberStatus::Associating,
            "DELETED" => NumberStatus::Deleted,
            "DISASSOCIATING" => NumberStatus::Disassociating,
            "PENDING" => NumberStatus::Pending,
            other => NumberStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NumberStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NumberStatus::from(s))
    }
}
impl NumberStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NumberStatus::Active => "ACTIVE",
            NumberStatus::Associating => "ASSOCIATING",
            NumberStatus::Deleted => "DELETED",
            NumberStatus::Disassociating => "DISASSOCIATING",
            NumberStatus::Pending => "PENDING",
            NumberStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "ASSOCIATING",
            "DELETED",
            "DISASSOCIATING",
            "PENDING",
        ]
    }
}
impl AsRef<str> for NumberStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an event destination.</p>
/// <p>Event destinations are associated with configuration sets, which enable you to publish message sending events to Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestination {
    /// <p>The name of the EventDestination.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    /// <p>When set to true events will be logged.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>An array of event types that determine which events to log.</p>
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.</p>
    pub cloud_watch_logs_destination: std::option::Option<crate::model::CloudWatchLogsDestination>,
    /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// <p>An object that contains information about an event destination that sends logging events to Amazon SNS.</p>
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
}
impl EventDestination {
    /// <p>The name of the EventDestination.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
    /// <p>When set to true events will be logged.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>An array of event types that determine which events to log.</p>
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// <p>An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.</p>
    pub fn cloud_watch_logs_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestination> {
        self.cloud_watch_logs_destination.as_ref()
    }
    /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// <p>An object that contains information about an event destination that sends logging events to Amazon SNS.</p>
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
}
impl std::fmt::Debug for EventDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestination");
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("enabled", &self.enabled);
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field(
            "cloud_watch_logs_destination",
            &self.cloud_watch_logs_destination,
        );
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("sns_destination", &self.sns_destination);
        formatter.finish()
    }
}
/// See [`EventDestination`](crate::model::EventDestination)
pub mod event_destination {
    /// A builder for [`EventDestination`](crate::model::EventDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) cloud_watch_logs_destination:
            std::option::Option<crate::model::CloudWatchLogsDestination>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
    }
    impl Builder {
        /// <p>The name of the EventDestination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name of the EventDestination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// <p>When set to true events will be logged.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>When set to true events will be logged.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>An array of event types that determine which events to log.</p>
        pub fn matching_event_types(mut self, input: crate::model::EventType) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input);
            self.matching_event_types = Some(v);
            self
        }
        /// <p>An array of event types that determine which events to log.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// <p>An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.</p>
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.cloud_watch_logs_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.</p>
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.cloud_watch_logs_destination = input;
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// <p>An object that contains information about an event destination that sends logging events to Amazon SNS.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends logging events to Amazon SNS.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestination`](crate::model::EventDestination)
        pub fn build(self) -> crate::model::EventDestination {
            crate::model::EventDestination {
                event_destination_name: self.event_destination_name,
                enabled: self.enabled,
                matching_event_types: self.matching_event_types,
                cloud_watch_logs_destination: self.cloud_watch_logs_destination,
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                sns_destination: self.sns_destination,
            }
        }
    }
}
impl EventDestination {
    /// Creates a new builder-style object to manufacture [`EventDestination`](crate::model::EventDestination)
    pub fn builder() -> crate::model::event_destination::Builder {
        crate::model::event_destination::Builder::default()
    }
}

/// <p>An object that defines an Amazon SNS destination for events. You can use Amazon SNS to send notification when certain events occur.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsDestination {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl SnsDestination {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SnsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsDestination");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`SnsDestination`](crate::model::SnsDestination)
pub mod sns_destination {
    /// A builder for [`SnsDestination`](crate::model::SnsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsDestination`](crate::model::SnsDestination)
        pub fn build(self) -> crate::model::SnsDestination {
            crate::model::SnsDestination {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl SnsDestination {
    /// Creates a new builder-style object to manufacture [`SnsDestination`](crate::model::SnsDestination)
    pub fn builder() -> crate::model::sns_destination::Builder {
        crate::model::sns_destination::Builder::default()
    }
}

/// <p>Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the Identity and Access Management (IAM) role associated with an Kinesis Data Firehose event destination.</p>
/// <p>Event destinations, such as Kinesis Data Firehose, are associated with configuration sets, which enable you to publish message sending events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseDestination {
    /// <p>The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
    pub delivery_stream_arn: std::option::Option<std::string::String>,
}
impl KinesisFirehoseDestination {
    /// <p>The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
    pub fn delivery_stream_arn(&self) -> std::option::Option<&str> {
        self.delivery_stream_arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisFirehoseDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseDestination");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("delivery_stream_arn", &self.delivery_stream_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
pub mod kinesis_firehose_destination {
    /// A builder for [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
        pub fn delivery_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
        pub fn set_delivery_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
        pub fn build(self) -> crate::model::KinesisFirehoseDestination {
            crate::model::KinesisFirehoseDestination {
                iam_role_arn: self.iam_role_arn,
                delivery_stream_arn: self.delivery_stream_arn,
            }
        }
    }
}
impl KinesisFirehoseDestination {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    pub fn builder() -> crate::model::kinesis_firehose_destination::Builder {
        crate::model::kinesis_firehose_destination::Builder::default()
    }
}

/// <p>Contains the destination configuration to use when publishing message sending events. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsDestination {
    /// <p>The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon CloudWatch log group that you want to record events in. </p>
    pub log_group_arn: std::option::Option<std::string::String>,
}
impl CloudWatchLogsDestination {
    /// <p>The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The name of the Amazon CloudWatch log group that you want to record events in. </p>
    pub fn log_group_arn(&self) -> std::option::Option<&str> {
        self.log_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsDestination");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("log_group_arn", &self.log_group_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
pub mod cloud_watch_logs_destination {
    /// A builder for [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) log_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The name of the Amazon CloudWatch log group that you want to record events in. </p>
        pub fn log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_arn = Some(input.into());
            self
        }
        /// <p>The name of the Amazon CloudWatch log group that you want to record events in. </p>
        pub fn set_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
        pub fn build(self) -> crate::model::CloudWatchLogsDestination {
            crate::model::CloudWatchLogsDestination {
                iam_role_arn: self.iam_role_arn,
                log_group_arn: self.log_group_arn,
            }
        }
    }
}
impl CloudWatchLogsDestination {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
    pub fn builder() -> crate::model::cloud_watch_logs_destination::Builder {
        crate::model::cloud_watch_logs_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    TextAll,
    #[allow(missing_docs)] // documentation missing in model
    TextBlocked,
    #[allow(missing_docs)] // documentation missing in model
    TextCarrierBlocked,
    #[allow(missing_docs)] // documentation missing in model
    TextCarrierUnreachable,
    #[allow(missing_docs)] // documentation missing in model
    TextDelivered,
    #[allow(missing_docs)] // documentation missing in model
    TextInvalid,
    #[allow(missing_docs)] // documentation missing in model
    TextInvalidMessage,
    #[allow(missing_docs)] // documentation missing in model
    TextPending,
    #[allow(missing_docs)] // documentation missing in model
    TextQueued,
    #[allow(missing_docs)] // documentation missing in model
    TextSent,
    #[allow(missing_docs)] // documentation missing in model
    TextSpam,
    #[allow(missing_docs)] // documentation missing in model
    TextSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    TextTtlExpired,
    #[allow(missing_docs)] // documentation missing in model
    TextUnknown,
    #[allow(missing_docs)] // documentation missing in model
    TextUnreachable,
    #[allow(missing_docs)] // documentation missing in model
    VoiceAll,
    #[allow(missing_docs)] // documentation missing in model
    VoiceAnswered,
    #[allow(missing_docs)] // documentation missing in model
    VoiceBusy,
    #[allow(missing_docs)] // documentation missing in model
    VoiceCompleted,
    #[allow(missing_docs)] // documentation missing in model
    VoiceFailed,
    #[allow(missing_docs)] // documentation missing in model
    VoiceInitiated,
    #[allow(missing_docs)] // documentation missing in model
    VoiceNoAnswer,
    #[allow(missing_docs)] // documentation missing in model
    VoiceRinging,
    #[allow(missing_docs)] // documentation missing in model
    VoiceTtlExpired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => EventType::All,
            "TEXT_ALL" => EventType::TextAll,
            "TEXT_BLOCKED" => EventType::TextBlocked,
            "TEXT_CARRIER_BLOCKED" => EventType::TextCarrierBlocked,
            "TEXT_CARRIER_UNREACHABLE" => EventType::TextCarrierUnreachable,
            "TEXT_DELIVERED" => EventType::TextDelivered,
            "TEXT_INVALID" => EventType::TextInvalid,
            "TEXT_INVALID_MESSAGE" => EventType::TextInvalidMessage,
            "TEXT_PENDING" => EventType::TextPending,
            "TEXT_QUEUED" => EventType::TextQueued,
            "TEXT_SENT" => EventType::TextSent,
            "TEXT_SPAM" => EventType::TextSpam,
            "TEXT_SUCCESSFUL" => EventType::TextSuccessful,
            "TEXT_TTL_EXPIRED" => EventType::TextTtlExpired,
            "TEXT_UNKNOWN" => EventType::TextUnknown,
            "TEXT_UNREACHABLE" => EventType::TextUnreachable,
            "VOICE_ALL" => EventType::VoiceAll,
            "VOICE_ANSWERED" => EventType::VoiceAnswered,
            "VOICE_BUSY" => EventType::VoiceBusy,
            "VOICE_COMPLETED" => EventType::VoiceCompleted,
            "VOICE_FAILED" => EventType::VoiceFailed,
            "VOICE_INITIATED" => EventType::VoiceInitiated,
            "VOICE_NO_ANSWER" => EventType::VoiceNoAnswer,
            "VOICE_RINGING" => EventType::VoiceRinging,
            "VOICE_TTL_EXPIRED" => EventType::VoiceTtlExpired,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::All => "ALL",
            EventType::TextAll => "TEXT_ALL",
            EventType::TextBlocked => "TEXT_BLOCKED",
            EventType::TextCarrierBlocked => "TEXT_CARRIER_BLOCKED",
            EventType::TextCarrierUnreachable => "TEXT_CARRIER_UNREACHABLE",
            EventType::TextDelivered => "TEXT_DELIVERED",
            EventType::TextInvalid => "TEXT_INVALID",
            EventType::TextInvalidMessage => "TEXT_INVALID_MESSAGE",
            EventType::TextPending => "TEXT_PENDING",
            EventType::TextQueued => "TEXT_QUEUED",
            EventType::TextSent => "TEXT_SENT",
            EventType::TextSpam => "TEXT_SPAM",
            EventType::TextSuccessful => "TEXT_SUCCESSFUL",
            EventType::TextTtlExpired => "TEXT_TTL_EXPIRED",
            EventType::TextUnknown => "TEXT_UNKNOWN",
            EventType::TextUnreachable => "TEXT_UNREACHABLE",
            EventType::VoiceAll => "VOICE_ALL",
            EventType::VoiceAnswered => "VOICE_ANSWERED",
            EventType::VoiceBusy => "VOICE_BUSY",
            EventType::VoiceCompleted => "VOICE_COMPLETED",
            EventType::VoiceFailed => "VOICE_FAILED",
            EventType::VoiceInitiated => "VOICE_INITIATED",
            EventType::VoiceNoAnswer => "VOICE_NO_ANSWER",
            EventType::VoiceRinging => "VOICE_RINGING",
            EventType::VoiceTtlExpired => "VOICE_TTL_EXPIRED",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "TEXT_ALL",
            "TEXT_BLOCKED",
            "TEXT_CARRIER_BLOCKED",
            "TEXT_CARRIER_UNREACHABLE",
            "TEXT_DELIVERED",
            "TEXT_INVALID",
            "TEXT_INVALID_MESSAGE",
            "TEXT_PENDING",
            "TEXT_QUEUED",
            "TEXT_SENT",
            "TEXT_SPAM",
            "TEXT_SUCCESSFUL",
            "TEXT_TTL_EXPIRED",
            "TEXT_UNKNOWN",
            "TEXT_UNREACHABLE",
            "VOICE_ALL",
            "VOICE_ANSWERED",
            "VOICE_BUSY",
            "VOICE_COMPLETED",
            "VOICE_FAILED",
            "VOICE_INITIATED",
            "VOICE_NO_ANSWER",
            "VOICE_RINGING",
            "VOICE_TTL_EXPIRED",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceQuotaExceededExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSetsPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    DailyDestinationCallLimit,
    #[allow(missing_docs)] // documentation missing in model
    EventDestinationsPerConfigurationSet,
    #[allow(missing_docs)] // documentation missing in model
    KeywordsPerPhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    KeywordsPerPool,
    #[allow(missing_docs)] // documentation missing in model
    MonthlySpendLimitReachedForText,
    #[allow(missing_docs)] // documentation missing in model
    MonthlySpendLimitReachedForVoice,
    #[allow(missing_docs)] // documentation missing in model
    OptOutListsPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    OriginationIdentitiesPerPool,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumbersPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumbersPerRegistration,
    #[allow(missing_docs)] // documentation missing in model
    PoolsPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    TagsPerResource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceQuotaExceededExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURATION_SETS_PER_ACCOUNT" => {
                ServiceQuotaExceededExceptionReason::ConfigurationSetsPerAccount
            }
            "DAILY_DESTINATION_CALL_LIMIT" => {
                ServiceQuotaExceededExceptionReason::DailyDestinationCallLimit
            }
            "EVENT_DESTINATIONS_PER_CONFIGURATION_SET" => {
                ServiceQuotaExceededExceptionReason::EventDestinationsPerConfigurationSet
            }
            "KEYWORDS_PER_PHONE_NUMBER" => {
                ServiceQuotaExceededExceptionReason::KeywordsPerPhoneNumber
            }
            "KEYWORDS_PER_POOL" => ServiceQuotaExceededExceptionReason::KeywordsPerPool,
            "MONTHLY_SPEND_LIMIT_REACHED_FOR_TEXT" => {
                ServiceQuotaExceededExceptionReason::MonthlySpendLimitReachedForText
            }
            "MONTHLY_SPEND_LIMIT_REACHED_FOR_VOICE" => {
                ServiceQuotaExceededExceptionReason::MonthlySpendLimitReachedForVoice
            }
            "OPT_OUT_LISTS_PER_ACCOUNT" => {
                ServiceQuotaExceededExceptionReason::OptOutListsPerAccount
            }
            "ORIGINATION_IDENTITIES_PER_POOL" => {
                ServiceQuotaExceededExceptionReason::OriginationIdentitiesPerPool
            }
            "PHONE_NUMBERS_PER_ACCOUNT" => {
                ServiceQuotaExceededExceptionReason::PhoneNumbersPerAccount
            }
            "PHONE_NUMBERS_PER_REGISTRATION" => {
                ServiceQuotaExceededExceptionReason::PhoneNumbersPerRegistration
            }
            "POOLS_PER_ACCOUNT" => ServiceQuotaExceededExceptionReason::PoolsPerAccount,
            "TAGS_PER_RESOURCE" => ServiceQuotaExceededExceptionReason::TagsPerResource,
            other => ServiceQuotaExceededExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceQuotaExceededExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceQuotaExceededExceptionReason::from(s))
    }
}
impl ServiceQuotaExceededExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceQuotaExceededExceptionReason::ConfigurationSetsPerAccount => {
                "CONFIGURATION_SETS_PER_ACCOUNT"
            }
            ServiceQuotaExceededExceptionReason::DailyDestinationCallLimit => {
                "DAILY_DESTINATION_CALL_LIMIT"
            }
            ServiceQuotaExceededExceptionReason::EventDestinationsPerConfigurationSet => {
                "EVENT_DESTINATIONS_PER_CONFIGURATION_SET"
            }
            ServiceQuotaExceededExceptionReason::KeywordsPerPhoneNumber => {
                "KEYWORDS_PER_PHONE_NUMBER"
            }
            ServiceQuotaExceededExceptionReason::KeywordsPerPool => "KEYWORDS_PER_POOL",
            ServiceQuotaExceededExceptionReason::MonthlySpendLimitReachedForText => {
                "MONTHLY_SPEND_LIMIT_REACHED_FOR_TEXT"
            }
            ServiceQuotaExceededExceptionReason::MonthlySpendLimitReachedForVoice => {
                "MONTHLY_SPEND_LIMIT_REACHED_FOR_VOICE"
            }
            ServiceQuotaExceededExceptionReason::OptOutListsPerAccount => {
                "OPT_OUT_LISTS_PER_ACCOUNT"
            }
            ServiceQuotaExceededExceptionReason::OriginationIdentitiesPerPool => {
                "ORIGINATION_IDENTITIES_PER_POOL"
            }
            ServiceQuotaExceededExceptionReason::PhoneNumbersPerAccount => {
                "PHONE_NUMBERS_PER_ACCOUNT"
            }
            ServiceQuotaExceededExceptionReason::PhoneNumbersPerRegistration => {
                "PHONE_NUMBERS_PER_REGISTRATION"
            }
            ServiceQuotaExceededExceptionReason::PoolsPerAccount => "POOLS_PER_ACCOUNT",
            ServiceQuotaExceededExceptionReason::TagsPerResource => "TAGS_PER_RESOURCE",
            ServiceQuotaExceededExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIGURATION_SETS_PER_ACCOUNT",
            "DAILY_DESTINATION_CALL_LIMIT",
            "EVENT_DESTINATIONS_PER_CONFIGURATION_SET",
            "KEYWORDS_PER_PHONE_NUMBER",
            "KEYWORDS_PER_POOL",
            "MONTHLY_SPEND_LIMIT_REACHED_FOR_TEXT",
            "MONTHLY_SPEND_LIMIT_REACHED_FOR_VOICE",
            "OPT_OUT_LISTS_PER_ACCOUNT",
            "ORIGINATION_IDENTITIES_PER_POOL",
            "PHONE_NUMBERS_PER_ACCOUNT",
            "PHONE_NUMBERS_PER_REGISTRATION",
            "POOLS_PER_ACCOUNT",
            "TAGS_PER_RESOURCE",
        ]
    }
}
impl AsRef<str> for ServiceQuotaExceededExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The list of tags to be added to the specified topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The string value associated with the key of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The string value associated with the key of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The string value associated with the key of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The string value associated with the key of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VoiceId {
    #[allow(missing_docs)] // documentation missing in model
    Amy,
    #[allow(missing_docs)] // documentation missing in model
    Astrid,
    #[allow(missing_docs)] // documentation missing in model
    Bianca,
    #[allow(missing_docs)] // documentation missing in model
    Brian,
    #[allow(missing_docs)] // documentation missing in model
    Camila,
    #[allow(missing_docs)] // documentation missing in model
    Carla,
    #[allow(missing_docs)] // documentation missing in model
    Carmen,
    #[allow(missing_docs)] // documentation missing in model
    Celine,
    #[allow(missing_docs)] // documentation missing in model
    Chantal,
    #[allow(missing_docs)] // documentation missing in model
    Conchita,
    #[allow(missing_docs)] // documentation missing in model
    Cristiano,
    #[allow(missing_docs)] // documentation missing in model
    Dora,
    #[allow(missing_docs)] // documentation missing in model
    Emma,
    #[allow(missing_docs)] // documentation missing in model
    Enrique,
    #[allow(missing_docs)] // documentation missing in model
    Ewa,
    #[allow(missing_docs)] // documentation missing in model
    Filiz,
    #[allow(missing_docs)] // documentation missing in model
    Geraint,
    #[allow(missing_docs)] // documentation missing in model
    Giorgio,
    #[allow(missing_docs)] // documentation missing in model
    Gwyneth,
    #[allow(missing_docs)] // documentation missing in model
    Hans,
    #[allow(missing_docs)] // documentation missing in model
    Ines,
    #[allow(missing_docs)] // documentation missing in model
    Ivy,
    #[allow(missing_docs)] // documentation missing in model
    Jacek,
    #[allow(missing_docs)] // documentation missing in model
    Jan,
    #[allow(missing_docs)] // documentation missing in model
    Joanna,
    #[allow(missing_docs)] // documentation missing in model
    Joey,
    #[allow(missing_docs)] // documentation missing in model
    Justin,
    #[allow(missing_docs)] // documentation missing in model
    Karl,
    #[allow(missing_docs)] // documentation missing in model
    Kendra,
    #[allow(missing_docs)] // documentation missing in model
    Kimberly,
    #[allow(missing_docs)] // documentation missing in model
    Lea,
    #[allow(missing_docs)] // documentation missing in model
    Liv,
    #[allow(missing_docs)] // documentation missing in model
    Lotte,
    #[allow(missing_docs)] // documentation missing in model
    Lucia,
    #[allow(missing_docs)] // documentation missing in model
    Lupe,
    #[allow(missing_docs)] // documentation missing in model
    Mads,
    #[allow(missing_docs)] // documentation missing in model
    Maja,
    #[allow(missing_docs)] // documentation missing in model
    Marlene,
    #[allow(missing_docs)] // documentation missing in model
    Mathieu,
    #[allow(missing_docs)] // documentation missing in model
    Matthew,
    #[allow(missing_docs)] // documentation missing in model
    Maxim,
    #[allow(missing_docs)] // documentation missing in model
    Mia,
    #[allow(missing_docs)] // documentation missing in model
    Miguel,
    #[allow(missing_docs)] // documentation missing in model
    Mizuki,
    #[allow(missing_docs)] // documentation missing in model
    Naja,
    #[allow(missing_docs)] // documentation missing in model
    Nicole,
    #[allow(missing_docs)] // documentation missing in model
    Penelope,
    #[allow(missing_docs)] // documentation missing in model
    Raveena,
    #[allow(missing_docs)] // documentation missing in model
    Ricardo,
    #[allow(missing_docs)] // documentation missing in model
    Ruben,
    #[allow(missing_docs)] // documentation missing in model
    Russell,
    #[allow(missing_docs)] // documentation missing in model
    Salli,
    #[allow(missing_docs)] // documentation missing in model
    Seoyeon,
    #[allow(missing_docs)] // documentation missing in model
    Takumi,
    #[allow(missing_docs)] // documentation missing in model
    Tatyana,
    #[allow(missing_docs)] // documentation missing in model
    Vicki,
    #[allow(missing_docs)] // documentation missing in model
    Vitoria,
    #[allow(missing_docs)] // documentation missing in model
    Zeina,
    #[allow(missing_docs)] // documentation missing in model
    Zhiyu,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VoiceId {
    fn from(s: &str) -> Self {
        match s {
            "AMY" => VoiceId::Amy,
            "ASTRID" => VoiceId::Astrid,
            "BIANCA" => VoiceId::Bianca,
            "BRIAN" => VoiceId::Brian,
            "CAMILA" => VoiceId::Camila,
            "CARLA" => VoiceId::Carla,
            "CARMEN" => VoiceId::Carmen,
            "CELINE" => VoiceId::Celine,
            "CHANTAL" => VoiceId::Chantal,
            "CONCHITA" => VoiceId::Conchita,
            "CRISTIANO" => VoiceId::Cristiano,
            "DORA" => VoiceId::Dora,
            "EMMA" => VoiceId::Emma,
            "ENRIQUE" => VoiceId::Enrique,
            "EWA" => VoiceId::Ewa,
            "FILIZ" => VoiceId::Filiz,
            "GERAINT" => VoiceId::Geraint,
            "GIORGIO" => VoiceId::Giorgio,
            "GWYNETH" => VoiceId::Gwyneth,
            "HANS" => VoiceId::Hans,
            "INES" => VoiceId::Ines,
            "IVY" => VoiceId::Ivy,
            "JACEK" => VoiceId::Jacek,
            "JAN" => VoiceId::Jan,
            "JOANNA" => VoiceId::Joanna,
            "JOEY" => VoiceId::Joey,
            "JUSTIN" => VoiceId::Justin,
            "KARL" => VoiceId::Karl,
            "KENDRA" => VoiceId::Kendra,
            "KIMBERLY" => VoiceId::Kimberly,
            "LEA" => VoiceId::Lea,
            "LIV" => VoiceId::Liv,
            "LOTTE" => VoiceId::Lotte,
            "LUCIA" => VoiceId::Lucia,
            "LUPE" => VoiceId::Lupe,
            "MADS" => VoiceId::Mads,
            "MAJA" => VoiceId::Maja,
            "MARLENE" => VoiceId::Marlene,
            "MATHIEU" => VoiceId::Mathieu,
            "MATTHEW" => VoiceId::Matthew,
            "MAXIM" => VoiceId::Maxim,
            "MIA" => VoiceId::Mia,
            "MIGUEL" => VoiceId::Miguel,
            "MIZUKI" => VoiceId::Mizuki,
            "NAJA" => VoiceId::Naja,
            "NICOLE" => VoiceId::Nicole,
            "PENELOPE" => VoiceId::Penelope,
            "RAVEENA" => VoiceId::Raveena,
            "RICARDO" => VoiceId::Ricardo,
            "RUBEN" => VoiceId::Ruben,
            "RUSSELL" => VoiceId::Russell,
            "SALLI" => VoiceId::Salli,
            "SEOYEON" => VoiceId::Seoyeon,
            "TAKUMI" => VoiceId::Takumi,
            "TATYANA" => VoiceId::Tatyana,
            "VICKI" => VoiceId::Vicki,
            "VITORIA" => VoiceId::Vitoria,
            "ZEINA" => VoiceId::Zeina,
            "ZHIYU" => VoiceId::Zhiyu,
            other => VoiceId::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VoiceId {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VoiceId::from(s))
    }
}
impl VoiceId {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VoiceId::Amy => "AMY",
            VoiceId::Astrid => "ASTRID",
            VoiceId::Bianca => "BIANCA",
            VoiceId::Brian => "BRIAN",
            VoiceId::Camila => "CAMILA",
            VoiceId::Carla => "CARLA",
            VoiceId::Carmen => "CARMEN",
            VoiceId::Celine => "CELINE",
            VoiceId::Chantal => "CHANTAL",
            VoiceId::Conchita => "CONCHITA",
            VoiceId::Cristiano => "CRISTIANO",
            VoiceId::Dora => "DORA",
            VoiceId::Emma => "EMMA",
            VoiceId::Enrique => "ENRIQUE",
            VoiceId::Ewa => "EWA",
            VoiceId::Filiz => "FILIZ",
            VoiceId::Geraint => "GERAINT",
            VoiceId::Giorgio => "GIORGIO",
            VoiceId::Gwyneth => "GWYNETH",
            VoiceId::Hans => "HANS",
            VoiceId::Ines => "INES",
            VoiceId::Ivy => "IVY",
            VoiceId::Jacek => "JACEK",
            VoiceId::Jan => "JAN",
            VoiceId::Joanna => "JOANNA",
            VoiceId::Joey => "JOEY",
            VoiceId::Justin => "JUSTIN",
            VoiceId::Karl => "KARL",
            VoiceId::Kendra => "KENDRA",
            VoiceId::Kimberly => "KIMBERLY",
            VoiceId::Lea => "LEA",
            VoiceId::Liv => "LIV",
            VoiceId::Lotte => "LOTTE",
            VoiceId::Lucia => "LUCIA",
            VoiceId::Lupe => "LUPE",
            VoiceId::Mads => "MADS",
            VoiceId::Maja => "MAJA",
            VoiceId::Marlene => "MARLENE",
            VoiceId::Mathieu => "MATHIEU",
            VoiceId::Matthew => "MATTHEW",
            VoiceId::Maxim => "MAXIM",
            VoiceId::Mia => "MIA",
            VoiceId::Miguel => "MIGUEL",
            VoiceId::Mizuki => "MIZUKI",
            VoiceId::Naja => "NAJA",
            VoiceId::Nicole => "NICOLE",
            VoiceId::Penelope => "PENELOPE",
            VoiceId::Raveena => "RAVEENA",
            VoiceId::Ricardo => "RICARDO",
            VoiceId::Ruben => "RUBEN",
            VoiceId::Russell => "RUSSELL",
            VoiceId::Salli => "SALLI",
            VoiceId::Seoyeon => "SEOYEON",
            VoiceId::Takumi => "TAKUMI",
            VoiceId::Tatyana => "TATYANA",
            VoiceId::Vicki => "VICKI",
            VoiceId::Vitoria => "VITORIA",
            VoiceId::Zeina => "ZEINA",
            VoiceId::Zhiyu => "ZHIYU",
            VoiceId::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMY",
            "ASTRID",
            "BIANCA",
            "BRIAN",
            "CAMILA",
            "CARLA",
            "CARMEN",
            "CELINE",
            "CHANTAL",
            "CONCHITA",
            "CRISTIANO",
            "DORA",
            "EMMA",
            "ENRIQUE",
            "EWA",
            "FILIZ",
            "GERAINT",
            "GIORGIO",
            "GWYNETH",
            "HANS",
            "INES",
            "IVY",
            "JACEK",
            "JAN",
            "JOANNA",
            "JOEY",
            "JUSTIN",
            "KARL",
            "KENDRA",
            "KIMBERLY",
            "LEA",
            "LIV",
            "LOTTE",
            "LUCIA",
            "LUPE",
            "MADS",
            "MAJA",
            "MARLENE",
            "MATHIEU",
            "MATTHEW",
            "MAXIM",
            "MIA",
            "MIGUEL",
            "MIZUKI",
            "NAJA",
            "NICOLE",
            "PENELOPE",
            "RAVEENA",
            "RICARDO",
            "RUBEN",
            "RUSSELL",
            "SALLI",
            "SEOYEON",
            "TAKUMI",
            "TATYANA",
            "VICKI",
            "VITORIA",
            "ZEINA",
            "ZHIYU",
        ]
    }
}
impl AsRef<str> for VoiceId {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VoiceMessageBodyTextType {
    #[allow(missing_docs)] // documentation missing in model
    Ssml,
    #[allow(missing_docs)] // documentation missing in model
    Text,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VoiceMessageBodyTextType {
    fn from(s: &str) -> Self {
        match s {
            "SSML" => VoiceMessageBodyTextType::Ssml,
            "TEXT" => VoiceMessageBodyTextType::Text,
            other => VoiceMessageBodyTextType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VoiceMessageBodyTextType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VoiceMessageBodyTextType::from(s))
    }
}
impl VoiceMessageBodyTextType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VoiceMessageBodyTextType::Ssml => "SSML",
            VoiceMessageBodyTextType::Text => "TEXT",
            VoiceMessageBodyTextType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSML", "TEXT"]
    }
}
impl AsRef<str> for VoiceMessageBodyTextType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DestinationCountryParameterKey {
    #[allow(missing_docs)] // documentation missing in model
    InEntityId,
    #[allow(missing_docs)] // documentation missing in model
    InTemplateId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DestinationCountryParameterKey {
    fn from(s: &str) -> Self {
        match s {
            "IN_ENTITY_ID" => DestinationCountryParameterKey::InEntityId,
            "IN_TEMPLATE_ID" => DestinationCountryParameterKey::InTemplateId,
            other => DestinationCountryParameterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DestinationCountryParameterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DestinationCountryParameterKey::from(s))
    }
}
impl DestinationCountryParameterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DestinationCountryParameterKey::InEntityId => "IN_ENTITY_ID",
            DestinationCountryParameterKey::InTemplateId => "IN_TEMPLATE_ID",
            DestinationCountryParameterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IN_ENTITY_ID", "IN_TEMPLATE_ID"]
    }
}
impl AsRef<str> for DestinationCountryParameterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestableNumberType {
    #[allow(missing_docs)] // documentation missing in model
    LongCode,
    #[allow(missing_docs)] // documentation missing in model
    TenDlc,
    #[allow(missing_docs)] // documentation missing in model
    TollFree,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestableNumberType {
    fn from(s: &str) -> Self {
        match s {
            "LONG_CODE" => RequestableNumberType::LongCode,
            "TEN_DLC" => RequestableNumberType::TenDlc,
            "TOLL_FREE" => RequestableNumberType::TollFree,
            other => RequestableNumberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestableNumberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestableNumberType::from(s))
    }
}
impl RequestableNumberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestableNumberType::LongCode => "LONG_CODE",
            RequestableNumberType::TenDlc => "TEN_DLC",
            RequestableNumberType::TollFree => "TOLL_FREE",
            RequestableNumberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LONG_CODE", "TEN_DLC", "TOLL_FREE"]
    }
}
impl AsRef<str> for RequestableNumberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeywordAction {
    #[allow(missing_docs)] // documentation missing in model
    AutomaticResponse,
    #[allow(missing_docs)] // documentation missing in model
    OptIn,
    #[allow(missing_docs)] // documentation missing in model
    OptOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeywordAction {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC_RESPONSE" => KeywordAction::AutomaticResponse,
            "OPT_IN" => KeywordAction::OptIn,
            "OPT_OUT" => KeywordAction::OptOut,
            other => KeywordAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeywordAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeywordAction::from(s))
    }
}
impl KeywordAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeywordAction::AutomaticResponse => "AUTOMATIC_RESPONSE",
            KeywordAction::OptIn => "OPT_IN",
            KeywordAction::OptOut => "OPT_OUT",
            KeywordAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC_RESPONSE", "OPT_IN", "OPT_OUT"]
    }
}
impl AsRef<str> for KeywordAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The metadata for an origination identity associated with a pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginationIdentityMetadata {
    /// <p>The Amazon Resource Name (ARN) associated with the origination identity.</p>
    pub origination_identity_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the origination identity.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
}
impl OriginationIdentityMetadata {
    /// <p>The Amazon Resource Name (ARN) associated with the origination identity.</p>
    pub fn origination_identity_arn(&self) -> std::option::Option<&str> {
        self.origination_identity_arn.as_deref()
    }
    /// <p>The unique identifier of the origination identity.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
}
impl std::fmt::Debug for OriginationIdentityMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginationIdentityMetadata");
        formatter.field("origination_identity_arn", &self.origination_identity_arn);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.finish()
    }
}
/// See [`OriginationIdentityMetadata`](crate::model::OriginationIdentityMetadata)
pub mod origination_identity_metadata {
    /// A builder for [`OriginationIdentityMetadata`](crate::model::OriginationIdentityMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity_arn: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the origination identity.</p>
        pub fn origination_identity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the origination identity.</p>
        pub fn set_origination_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity_arn = input;
            self
        }
        /// <p>The unique identifier of the origination identity.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The unique identifier of the origination identity.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginationIdentityMetadata`](crate::model::OriginationIdentityMetadata)
        pub fn build(self) -> crate::model::OriginationIdentityMetadata {
            crate::model::OriginationIdentityMetadata {
                origination_identity_arn: self.origination_identity_arn,
                origination_identity: self.origination_identity,
                iso_country_code: self.iso_country_code,
                number_capabilities: self.number_capabilities,
            }
        }
    }
}
impl OriginationIdentityMetadata {
    /// Creates a new builder-style object to manufacture [`OriginationIdentityMetadata`](crate::model::OriginationIdentityMetadata)
    pub fn builder() -> crate::model::origination_identity_metadata::Builder {
        crate::model::origination_identity_metadata::Builder::default()
    }
}

/// <p>Information about origination identities associated with a pool that meets a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PoolOriginationIdentitiesFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::PoolOriginationIdentitiesFilterName>,
    /// <p>An array values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PoolOriginationIdentitiesFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::PoolOriginationIdentitiesFilterName> {
        self.name.as_ref()
    }
    /// <p>An array values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for PoolOriginationIdentitiesFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PoolOriginationIdentitiesFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PoolOriginationIdentitiesFilter`](crate::model::PoolOriginationIdentitiesFilter)
pub mod pool_origination_identities_filter {
    /// A builder for [`PoolOriginationIdentitiesFilter`](crate::model::PoolOriginationIdentitiesFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::PoolOriginationIdentitiesFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::PoolOriginationIdentitiesFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::PoolOriginationIdentitiesFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PoolOriginationIdentitiesFilter`](crate::model::PoolOriginationIdentitiesFilter)
        pub fn build(self) -> crate::model::PoolOriginationIdentitiesFilter {
            crate::model::PoolOriginationIdentitiesFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl PoolOriginationIdentitiesFilter {
    /// Creates a new builder-style object to manufacture [`PoolOriginationIdentitiesFilter`](crate::model::PoolOriginationIdentitiesFilter)
    pub fn builder() -> crate::model::pool_origination_identities_filter::Builder {
        crate::model::pool_origination_identities_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PoolOriginationIdentitiesFilterName {
    #[allow(missing_docs)] // documentation missing in model
    IsoCountryCode,
    #[allow(missing_docs)] // documentation missing in model
    NumberCapability,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PoolOriginationIdentitiesFilterName {
    fn from(s: &str) -> Self {
        match s {
            "iso-country-code" => PoolOriginationIdentitiesFilterName::IsoCountryCode,
            "number-capability" => PoolOriginationIdentitiesFilterName::NumberCapability,
            other => PoolOriginationIdentitiesFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PoolOriginationIdentitiesFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PoolOriginationIdentitiesFilterName::from(s))
    }
}
impl PoolOriginationIdentitiesFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PoolOriginationIdentitiesFilterName::IsoCountryCode => "iso-country-code",
            PoolOriginationIdentitiesFilterName::NumberCapability => "number-capability",
            PoolOriginationIdentitiesFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["iso-country-code", "number-capability"]
    }
}
impl AsRef<str> for PoolOriginationIdentitiesFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages. For more information on increasing your monthly spend limit, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpendLimit {
    /// <p>The name for the SpendLimit.</p>
    pub name: std::option::Option<crate::model::SpendLimitName>,
    /// <p>The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit, <code>Overridden</code> must be set to true.</p>
    pub enforced_limit: i64,
    /// <p> The maximum amount of money that you are able to spend to send messages each month, in US dollars.</p>
    pub max_limit: i64,
    /// <p>When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.</p>
    pub overridden: bool,
}
impl SpendLimit {
    /// <p>The name for the SpendLimit.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SpendLimitName> {
        self.name.as_ref()
    }
    /// <p>The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit, <code>Overridden</code> must be set to true.</p>
    pub fn enforced_limit(&self) -> i64 {
        self.enforced_limit
    }
    /// <p> The maximum amount of money that you are able to spend to send messages each month, in US dollars.</p>
    pub fn max_limit(&self) -> i64 {
        self.max_limit
    }
    /// <p>When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.</p>
    pub fn overridden(&self) -> bool {
        self.overridden
    }
}
impl std::fmt::Debug for SpendLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpendLimit");
        formatter.field("name", &self.name);
        formatter.field("enforced_limit", &self.enforced_limit);
        formatter.field("max_limit", &self.max_limit);
        formatter.field("overridden", &self.overridden);
        formatter.finish()
    }
}
/// See [`SpendLimit`](crate::model::SpendLimit)
pub mod spend_limit {
    /// A builder for [`SpendLimit`](crate::model::SpendLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SpendLimitName>,
        pub(crate) enforced_limit: std::option::Option<i64>,
        pub(crate) max_limit: std::option::Option<i64>,
        pub(crate) overridden: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name for the SpendLimit.</p>
        pub fn name(mut self, input: crate::model::SpendLimitName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name for the SpendLimit.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SpendLimitName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit, <code>Overridden</code> must be set to true.</p>
        pub fn enforced_limit(mut self, input: i64) -> Self {
            self.enforced_limit = Some(input);
            self
        }
        /// <p>The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit, <code>Overridden</code> must be set to true.</p>
        pub fn set_enforced_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.enforced_limit = input;
            self
        }
        /// <p> The maximum amount of money that you are able to spend to send messages each month, in US dollars.</p>
        pub fn max_limit(mut self, input: i64) -> Self {
            self.max_limit = Some(input);
            self
        }
        /// <p> The maximum amount of money that you are able to spend to send messages each month, in US dollars.</p>
        pub fn set_max_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.max_limit = input;
            self
        }
        /// <p>When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.</p>
        pub fn overridden(mut self, input: bool) -> Self {
            self.overridden = Some(input);
            self
        }
        /// <p>When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.</p>
        pub fn set_overridden(mut self, input: std::option::Option<bool>) -> Self {
            self.overridden = input;
            self
        }
        /// Consumes the builder and constructs a [`SpendLimit`](crate::model::SpendLimit)
        pub fn build(self) -> crate::model::SpendLimit {
            crate::model::SpendLimit {
                name: self.name,
                enforced_limit: self.enforced_limit.unwrap_or_default(),
                max_limit: self.max_limit.unwrap_or_default(),
                overridden: self.overridden.unwrap_or_default(),
            }
        }
    }
}
impl SpendLimit {
    /// Creates a new builder-style object to manufacture [`SpendLimit`](crate::model::SpendLimit)
    pub fn builder() -> crate::model::spend_limit::Builder {
        crate::model::spend_limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpendLimitName {
    #[allow(missing_docs)] // documentation missing in model
    TextMessageMonthlySpendLimit,
    #[allow(missing_docs)] // documentation missing in model
    VoiceMessageMonthlySpendLimit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpendLimitName {
    fn from(s: &str) -> Self {
        match s {
            "TEXT_MESSAGE_MONTHLY_SPEND_LIMIT" => SpendLimitName::TextMessageMonthlySpendLimit,
            "VOICE_MESSAGE_MONTHLY_SPEND_LIMIT" => SpendLimitName::VoiceMessageMonthlySpendLimit,
            other => SpendLimitName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpendLimitName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpendLimitName::from(s))
    }
}
impl SpendLimitName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpendLimitName::TextMessageMonthlySpendLimit => "TEXT_MESSAGE_MONTHLY_SPEND_LIMIT",
            SpendLimitName::VoiceMessageMonthlySpendLimit => "VOICE_MESSAGE_MONTHLY_SPEND_LIMIT",
            SpendLimitName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "TEXT_MESSAGE_MONTHLY_SPEND_LIMIT",
            "VOICE_MESSAGE_MONTHLY_SPEND_LIMIT",
        ]
    }
}
impl AsRef<str> for SpendLimitName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The information for all SenderIds in an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SenderIdInformation {
    /// <p>The Amazon Resource Name (ARN) associated with the SenderId.</p>
    pub sender_id_arn: std::option::Option<std::string::String>,
    /// <p>The alphanumeric sender ID in a specific country that you'd like to describe.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_types: std::option::Option<std::vec::Vec<crate::model::MessageType>>,
    /// <p>The monthly leasing price, in US dollars.</p>
    pub monthly_leasing_price: std::option::Option<std::string::String>,
}
impl SenderIdInformation {
    /// <p>The Amazon Resource Name (ARN) associated with the SenderId.</p>
    pub fn sender_id_arn(&self) -> std::option::Option<&str> {
        self.sender_id_arn.as_deref()
    }
    /// <p>The alphanumeric sender ID in a specific country that you'd like to describe.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_types(&self) -> std::option::Option<&[crate::model::MessageType]> {
        self.message_types.as_deref()
    }
    /// <p>The monthly leasing price, in US dollars.</p>
    pub fn monthly_leasing_price(&self) -> std::option::Option<&str> {
        self.monthly_leasing_price.as_deref()
    }
}
impl std::fmt::Debug for SenderIdInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SenderIdInformation");
        formatter.field("sender_id_arn", &self.sender_id_arn);
        formatter.field("sender_id", &self.sender_id);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_types", &self.message_types);
        formatter.field("monthly_leasing_price", &self.monthly_leasing_price);
        formatter.finish()
    }
}
/// See [`SenderIdInformation`](crate::model::SenderIdInformation)
pub mod sender_id_information {
    /// A builder for [`SenderIdInformation`](crate::model::SenderIdInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sender_id_arn: std::option::Option<std::string::String>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_types: std::option::Option<std::vec::Vec<crate::model::MessageType>>,
        pub(crate) monthly_leasing_price: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the SenderId.</p>
        pub fn sender_id_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the SenderId.</p>
        pub fn set_sender_id_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sender_id_arn = input;
            self
        }
        /// <p>The alphanumeric sender ID in a specific country that you'd like to describe.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The alphanumeric sender ID in a specific country that you'd like to describe.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// Appends an item to `message_types`.
        ///
        /// To override the contents of this collection use [`set_message_types`](Self::set_message_types).
        ///
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_types(mut self, input: crate::model::MessageType) -> Self {
            let mut v = self.message_types.unwrap_or_default();
            v.push(input);
            self.message_types = Some(v);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageType>>,
        ) -> Self {
            self.message_types = input;
            self
        }
        /// <p>The monthly leasing price, in US dollars.</p>
        pub fn monthly_leasing_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.monthly_leasing_price = Some(input.into());
            self
        }
        /// <p>The monthly leasing price, in US dollars.</p>
        pub fn set_monthly_leasing_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monthly_leasing_price = input;
            self
        }
        /// Consumes the builder and constructs a [`SenderIdInformation`](crate::model::SenderIdInformation)
        pub fn build(self) -> crate::model::SenderIdInformation {
            crate::model::SenderIdInformation {
                sender_id_arn: self.sender_id_arn,
                sender_id: self.sender_id,
                iso_country_code: self.iso_country_code,
                message_types: self.message_types,
                monthly_leasing_price: self.monthly_leasing_price,
            }
        }
    }
}
impl SenderIdInformation {
    /// Creates a new builder-style object to manufacture [`SenderIdInformation`](crate::model::SenderIdInformation)
    pub fn builder() -> crate::model::sender_id_information::Builder {
        crate::model::sender_id_information::Builder::default()
    }
}

/// <p>The information for a sender ID that meets a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SenderIdFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::SenderIdFilterName>,
    /// <p>An array of values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SenderIdFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SenderIdFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for SenderIdFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SenderIdFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SenderIdFilter`](crate::model::SenderIdFilter)
pub mod sender_id_filter {
    /// A builder for [`SenderIdFilter`](crate::model::SenderIdFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SenderIdFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::SenderIdFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SenderIdFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array of values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array of values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SenderIdFilter`](crate::model::SenderIdFilter)
        pub fn build(self) -> crate::model::SenderIdFilter {
            crate::model::SenderIdFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl SenderIdFilter {
    /// Creates a new builder-style object to manufacture [`SenderIdFilter`](crate::model::SenderIdFilter)
    pub fn builder() -> crate::model::sender_id_filter::Builder {
        crate::model::sender_id_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SenderIdFilterName {
    #[allow(missing_docs)] // documentation missing in model
    IsoCountryCode,
    #[allow(missing_docs)] // documentation missing in model
    MessageType,
    #[allow(missing_docs)] // documentation missing in model
    SenderId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SenderIdFilterName {
    fn from(s: &str) -> Self {
        match s {
            "iso-country-code" => SenderIdFilterName::IsoCountryCode,
            "message-type" => SenderIdFilterName::MessageType,
            "sender-id" => SenderIdFilterName::SenderId,
            other => SenderIdFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SenderIdFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SenderIdFilterName::from(s))
    }
}
impl SenderIdFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SenderIdFilterName::IsoCountryCode => "iso-country-code",
            SenderIdFilterName::MessageType => "message-type",
            SenderIdFilterName::SenderId => "sender-id",
            SenderIdFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["iso-country-code", "message-type", "sender-id"]
    }
}
impl AsRef<str> for SenderIdFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The alphanumeric sender ID in a specific country that you want to describe. For more information on sender IDs see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-sender-id.html">Requesting sender IDs for SMS messaging with Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SenderIdAndCountry {
    /// <p>The unique identifier of the sender.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
}
impl SenderIdAndCountry {
    /// <p>The unique identifier of the sender.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
}
impl std::fmt::Debug for SenderIdAndCountry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SenderIdAndCountry");
        formatter.field("sender_id", &self.sender_id);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.finish()
    }
}
/// See [`SenderIdAndCountry`](crate::model::SenderIdAndCountry)
pub mod sender_id_and_country {
    /// A builder for [`SenderIdAndCountry`](crate::model::SenderIdAndCountry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the sender.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the sender.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// Consumes the builder and constructs a [`SenderIdAndCountry`](crate::model::SenderIdAndCountry)
        pub fn build(self) -> crate::model::SenderIdAndCountry {
            crate::model::SenderIdAndCountry {
                sender_id: self.sender_id,
                iso_country_code: self.iso_country_code,
            }
        }
    }
}
impl SenderIdAndCountry {
    /// Creates a new builder-style object to manufacture [`SenderIdAndCountry`](crate::model::SenderIdAndCountry)
    pub fn builder() -> crate::model::sender_id_and_country::Builder {
        crate::model::sender_id_and_country::Builder::default()
    }
}

/// <p>The information for a pool in an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PoolInformation {
    /// <p>The Amazon Resource Name (ARN) for the pool.</p>
    pub pool_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the pool.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The current status of the pool.</p>
    pub status: std::option::Option<crate::model::PoolStatus>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList associated with the pool.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>Allows you to enable shared routes on your pool.</p>
    /// <p>By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other Amazon Pinpoint users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.</p>
    pub shared_routes_enabled: bool,
    /// <p>When set to true the pool can't be deleted.</p>
    pub deletion_protection_enabled: bool,
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl PoolInformation {
    /// <p>The Amazon Resource Name (ARN) for the pool.</p>
    pub fn pool_arn(&self) -> std::option::Option<&str> {
        self.pool_arn.as_deref()
    }
    /// <p>The unique identifier for the pool.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The current status of the pool.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PoolStatus> {
        self.status.as_ref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList associated with the pool.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>Allows you to enable shared routes on your pool.</p>
    /// <p>By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other Amazon Pinpoint users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.</p>
    pub fn shared_routes_enabled(&self) -> bool {
        self.shared_routes_enabled
    }
    /// <p>When set to true the pool can't be deleted.</p>
    pub fn deletion_protection_enabled(&self) -> bool {
        self.deletion_protection_enabled
    }
    /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PoolInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PoolInformation");
        formatter.field("pool_arn", &self.pool_arn);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("status", &self.status);
        formatter.field("message_type", &self.message_type);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("shared_routes_enabled", &self.shared_routes_enabled);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`PoolInformation`](crate::model::PoolInformation)
pub mod pool_information {
    /// A builder for [`PoolInformation`](crate::model::PoolInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_arn: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PoolStatus>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) shared_routes_enabled: std::option::Option<bool>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the pool.</p>
        pub fn pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the pool.</p>
        pub fn set_pool_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_arn = input;
            self
        }
        /// <p>The unique identifier for the pool.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the pool.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The current status of the pool.</p>
        pub fn status(mut self, input: crate::model::PoolStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the pool.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::PoolStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList associated with the pool.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList associated with the pool.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>Allows you to enable shared routes on your pool.</p>
        /// <p>By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other Amazon Pinpoint users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.</p>
        pub fn shared_routes_enabled(mut self, input: bool) -> Self {
            self.shared_routes_enabled = Some(input);
            self
        }
        /// <p>Allows you to enable shared routes on your pool.</p>
        /// <p>By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other Amazon Pinpoint users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.</p>
        pub fn set_shared_routes_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.shared_routes_enabled = input;
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PoolInformation`](crate::model::PoolInformation)
        pub fn build(self) -> crate::model::PoolInformation {
            crate::model::PoolInformation {
                pool_arn: self.pool_arn,
                pool_id: self.pool_id,
                status: self.status,
                message_type: self.message_type,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                shared_routes_enabled: self.shared_routes_enabled.unwrap_or_default(),
                deletion_protection_enabled: self.deletion_protection_enabled.unwrap_or_default(),
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl PoolInformation {
    /// Creates a new builder-style object to manufacture [`PoolInformation`](crate::model::PoolInformation)
    pub fn builder() -> crate::model::pool_information::Builder {
        crate::model::pool_information::Builder::default()
    }
}

/// <p>The information for a pool that meets a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PoolFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::PoolFilterName>,
    /// <p>An array values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PoolFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::PoolFilterName> {
        self.name.as_ref()
    }
    /// <p>An array values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for PoolFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PoolFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PoolFilter`](crate::model::PoolFilter)
pub mod pool_filter {
    /// A builder for [`PoolFilter`](crate::model::PoolFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::PoolFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::PoolFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::PoolFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PoolFilter`](crate::model::PoolFilter)
        pub fn build(self) -> crate::model::PoolFilter {
            crate::model::PoolFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl PoolFilter {
    /// Creates a new builder-style object to manufacture [`PoolFilter`](crate::model::PoolFilter)
    pub fn builder() -> crate::model::pool_filter::Builder {
        crate::model::pool_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PoolFilterName {
    #[allow(missing_docs)] // documentation missing in model
    DeletionProtectionEnabled,
    #[allow(missing_docs)] // documentation missing in model
    MessageType,
    #[allow(missing_docs)] // documentation missing in model
    OptOutListName,
    #[allow(missing_docs)] // documentation missing in model
    SelfManagedOptOutsEnabled,
    #[allow(missing_docs)] // documentation missing in model
    SharedRoutesEnabled,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayEnabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PoolFilterName {
    fn from(s: &str) -> Self {
        match s {
            "deletion-protection-enabled" => PoolFilterName::DeletionProtectionEnabled,
            "message-type" => PoolFilterName::MessageType,
            "opt-out-list-name" => PoolFilterName::OptOutListName,
            "self-managed-opt-outs-enabled" => PoolFilterName::SelfManagedOptOutsEnabled,
            "shared-routes-enabled" => PoolFilterName::SharedRoutesEnabled,
            "status" => PoolFilterName::Status,
            "two-way-enabled" => PoolFilterName::TwoWayEnabled,
            other => PoolFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PoolFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PoolFilterName::from(s))
    }
}
impl PoolFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PoolFilterName::DeletionProtectionEnabled => "deletion-protection-enabled",
            PoolFilterName::MessageType => "message-type",
            PoolFilterName::OptOutListName => "opt-out-list-name",
            PoolFilterName::SelfManagedOptOutsEnabled => "self-managed-opt-outs-enabled",
            PoolFilterName::SharedRoutesEnabled => "shared-routes-enabled",
            PoolFilterName::Status => "status",
            PoolFilterName::TwoWayEnabled => "two-way-enabled",
            PoolFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "deletion-protection-enabled",
            "message-type",
            "opt-out-list-name",
            "self-managed-opt-outs-enabled",
            "shared-routes-enabled",
            "status",
            "two-way-enabled",
        ]
    }
}
impl AsRef<str> for PoolFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The information for a phone number in an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberInformation {
    /// <p>The Amazon Resource Name (ARN) associated with the phone number.</p>
    pub phone_number_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the phone number.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The phone number in E.164 format.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The current status of the phone number.</p>
    pub status: std::option::Option<crate::model::NumberStatus>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    /// <p>The type of phone number.</p>
    pub number_type: std::option::Option<crate::model::NumberType>,
    /// <p>The price, in US dollars, to lease the phone number.</p>
    pub monthly_leasing_price: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
    pub two_way_enabled: bool,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
    pub self_managed_opt_outs_enabled: bool,
    /// <p>The name of the OptOutList associated with the phone number.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>When set to true the phone number can't be deleted.</p>
    pub deletion_protection_enabled: bool,
    /// <p>The unique identifier of the pool associated with the phone number.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl PhoneNumberInformation {
    /// <p>The Amazon Resource Name (ARN) associated with the phone number.</p>
    pub fn phone_number_arn(&self) -> std::option::Option<&str> {
        self.phone_number_arn.as_deref()
    }
    /// <p>The unique identifier for the phone number.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The phone number in E.164 format.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The current status of the phone number.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NumberStatus> {
        self.status.as_ref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
    /// <p>The type of phone number.</p>
    pub fn number_type(&self) -> std::option::Option<&crate::model::NumberType> {
        self.number_type.as_ref()
    }
    /// <p>The price, in US dollars, to lease the phone number.</p>
    pub fn monthly_leasing_price(&self) -> std::option::Option<&str> {
        self.monthly_leasing_price.as_deref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
    pub fn two_way_enabled(&self) -> bool {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
    pub fn self_managed_opt_outs_enabled(&self) -> bool {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The name of the OptOutList associated with the phone number.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>When set to true the phone number can't be deleted.</p>
    pub fn deletion_protection_enabled(&self) -> bool {
        self.deletion_protection_enabled
    }
    /// <p>The unique identifier of the pool associated with the phone number.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PhoneNumberInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberInformation");
        formatter.field("phone_number_arn", &self.phone_number_arn);
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("status", &self.status);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_type", &self.message_type);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.field("number_type", &self.number_type);
        formatter.field("monthly_leasing_price", &self.monthly_leasing_price);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("pool_id", &self.pool_id);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
pub mod phone_number_information {
    /// A builder for [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_arn: std::option::Option<std::string::String>,
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NumberStatus>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        pub(crate) number_type: std::option::Option<crate::model::NumberType>,
        pub(crate) monthly_leasing_price: std::option::Option<std::string::String>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the phone number.</p>
        pub fn phone_number_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the phone number.</p>
        pub fn set_phone_number_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_arn = input;
            self
        }
        /// <p>The unique identifier for the phone number.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the phone number.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The phone number in E.164 format.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number in E.164 format.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The current status of the phone number.</p>
        pub fn status(mut self, input: crate::model::NumberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the phone number.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NumberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>Describes if the origination identity can be used for text messages, voice calls or both.</p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// <p>The type of phone number.</p>
        pub fn number_type(mut self, input: crate::model::NumberType) -> Self {
            self.number_type = Some(input);
            self
        }
        /// <p>The type of phone number.</p>
        pub fn set_number_type(
            mut self,
            input: std::option::Option<crate::model::NumberType>,
        ) -> Self {
            self.number_type = input;
            self
        }
        /// <p>The price, in US dollars, to lease the phone number.</p>
        pub fn monthly_leasing_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.monthly_leasing_price = Some(input.into());
            self
        }
        /// <p>The price, in US dollars, to lease the phone number.</p>
        pub fn set_monthly_leasing_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monthly_leasing_price = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The name of the OptOutList associated with the phone number.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList associated with the phone number.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>When set to true the phone number can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>When set to true the phone number can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// <p>The unique identifier of the pool associated with the phone number.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the pool associated with the phone number.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
        pub fn build(self) -> crate::model::PhoneNumberInformation {
            crate::model::PhoneNumberInformation {
                phone_number_arn: self.phone_number_arn,
                phone_number_id: self.phone_number_id,
                phone_number: self.phone_number,
                status: self.status,
                iso_country_code: self.iso_country_code,
                message_type: self.message_type,
                number_capabilities: self.number_capabilities,
                number_type: self.number_type,
                monthly_leasing_price: self.monthly_leasing_price,
                two_way_enabled: self.two_way_enabled.unwrap_or_default(),
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self
                    .self_managed_opt_outs_enabled
                    .unwrap_or_default(),
                opt_out_list_name: self.opt_out_list_name,
                deletion_protection_enabled: self.deletion_protection_enabled.unwrap_or_default(),
                pool_id: self.pool_id,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl PhoneNumberInformation {
    /// Creates a new builder-style object to manufacture [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
    pub fn builder() -> crate::model::phone_number_information::Builder {
        crate::model::phone_number_information::Builder::default()
    }
}

/// <p>The information for a phone number that meets a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::PhoneNumberFilterName>,
    /// <p>An array values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PhoneNumberFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::PhoneNumberFilterName> {
        self.name.as_ref()
    }
    /// <p>An array values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for PhoneNumberFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PhoneNumberFilter`](crate::model::PhoneNumberFilter)
pub mod phone_number_filter {
    /// A builder for [`PhoneNumberFilter`](crate::model::PhoneNumberFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::PhoneNumberFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::PhoneNumberFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberFilter`](crate::model::PhoneNumberFilter)
        pub fn build(self) -> crate::model::PhoneNumberFilter {
            crate::model::PhoneNumberFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl PhoneNumberFilter {
    /// Creates a new builder-style object to manufacture [`PhoneNumberFilter`](crate::model::PhoneNumberFilter)
    pub fn builder() -> crate::model::phone_number_filter::Builder {
        crate::model::phone_number_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberFilterName {
    #[allow(missing_docs)] // documentation missing in model
    DeletionProtectionEnabled,
    #[allow(missing_docs)] // documentation missing in model
    IsoCountryCode,
    #[allow(missing_docs)] // documentation missing in model
    MessageType,
    #[allow(missing_docs)] // documentation missing in model
    NumberCapability,
    #[allow(missing_docs)] // documentation missing in model
    NumberType,
    #[allow(missing_docs)] // documentation missing in model
    OptOutListName,
    #[allow(missing_docs)] // documentation missing in model
    SelfManagedOptOutsEnabled,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    TwoWayEnabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberFilterName {
    fn from(s: &str) -> Self {
        match s {
            "deletion-protection-enabled" => PhoneNumberFilterName::DeletionProtectionEnabled,
            "iso-country-code" => PhoneNumberFilterName::IsoCountryCode,
            "message-type" => PhoneNumberFilterName::MessageType,
            "number-capability" => PhoneNumberFilterName::NumberCapability,
            "number-type" => PhoneNumberFilterName::NumberType,
            "opt-out-list-name" => PhoneNumberFilterName::OptOutListName,
            "self-managed-opt-outs-enabled" => PhoneNumberFilterName::SelfManagedOptOutsEnabled,
            "status" => PhoneNumberFilterName::Status,
            "two-way-enabled" => PhoneNumberFilterName::TwoWayEnabled,
            other => PhoneNumberFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberFilterName::from(s))
    }
}
impl PhoneNumberFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberFilterName::DeletionProtectionEnabled => "deletion-protection-enabled",
            PhoneNumberFilterName::IsoCountryCode => "iso-country-code",
            PhoneNumberFilterName::MessageType => "message-type",
            PhoneNumberFilterName::NumberCapability => "number-capability",
            PhoneNumberFilterName::NumberType => "number-type",
            PhoneNumberFilterName::OptOutListName => "opt-out-list-name",
            PhoneNumberFilterName::SelfManagedOptOutsEnabled => "self-managed-opt-outs-enabled",
            PhoneNumberFilterName::Status => "status",
            PhoneNumberFilterName::TwoWayEnabled => "two-way-enabled",
            PhoneNumberFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "deletion-protection-enabled",
            "iso-country-code",
            "message-type",
            "number-capability",
            "number-type",
            "opt-out-list-name",
            "self-managed-opt-outs-enabled",
            "status",
            "two-way-enabled",
        ]
    }
}
impl AsRef<str> for PhoneNumberFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The information for all OptOutList in an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptOutListInformation {
    /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
    pub opt_out_list_arn: std::option::Option<std::string::String>,
    /// <p>The name of the OptOutList.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The time when the OutOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl OptOutListInformation {
    /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
    pub fn opt_out_list_arn(&self) -> std::option::Option<&str> {
        self.opt_out_list_arn.as_deref()
    }
    /// <p>The name of the OptOutList.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The time when the OutOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for OptOutListInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptOutListInformation");
        formatter.field("opt_out_list_arn", &self.opt_out_list_arn);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`OptOutListInformation`](crate::model::OptOutListInformation)
pub mod opt_out_list_information {
    /// A builder for [`OptOutListInformation`](crate::model::OptOutListInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_arn: std::option::Option<std::string::String>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
        pub fn opt_out_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OptOutList.</p>
        pub fn set_opt_out_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_arn = input;
            self
        }
        /// <p>The name of the OptOutList.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The time when the OutOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the OutOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`OptOutListInformation`](crate::model::OptOutListInformation)
        pub fn build(self) -> crate::model::OptOutListInformation {
            crate::model::OptOutListInformation {
                opt_out_list_arn: self.opt_out_list_arn,
                opt_out_list_name: self.opt_out_list_name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl OptOutListInformation {
    /// Creates a new builder-style object to manufacture [`OptOutListInformation`](crate::model::OptOutListInformation)
    pub fn builder() -> crate::model::opt_out_list_information::Builder {
        crate::model::opt_out_list_information::Builder::default()
    }
}

/// <p>The information for an opted out number in an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptedOutNumberInformation {
    /// <p>The phone number that is opted out.</p>
    pub opted_out_number: std::option::Option<std::string::String>,
    /// <p>The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub opted_out_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>This is set to true if it was the end recipient that opted out.</p>
    pub end_user_opted_out: bool,
}
impl OptedOutNumberInformation {
    /// <p>The phone number that is opted out.</p>
    pub fn opted_out_number(&self) -> std::option::Option<&str> {
        self.opted_out_number.as_deref()
    }
    /// <p>The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn opted_out_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.opted_out_timestamp.as_ref()
    }
    /// <p>This is set to true if it was the end recipient that opted out.</p>
    pub fn end_user_opted_out(&self) -> bool {
        self.end_user_opted_out
    }
}
impl std::fmt::Debug for OptedOutNumberInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptedOutNumberInformation");
        formatter.field("opted_out_number", &self.opted_out_number);
        formatter.field("opted_out_timestamp", &self.opted_out_timestamp);
        formatter.field("end_user_opted_out", &self.end_user_opted_out);
        formatter.finish()
    }
}
/// See [`OptedOutNumberInformation`](crate::model::OptedOutNumberInformation)
pub mod opted_out_number_information {
    /// A builder for [`OptedOutNumberInformation`](crate::model::OptedOutNumberInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opted_out_number: std::option::Option<std::string::String>,
        pub(crate) opted_out_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_user_opted_out: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The phone number that is opted out.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.opted_out_number = Some(input.into());
            self
        }
        /// <p>The phone number that is opted out.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opted_out_number = input;
            self
        }
        /// <p>The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn opted_out_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.opted_out_timestamp = Some(input);
            self
        }
        /// <p>The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_opted_out_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.opted_out_timestamp = input;
            self
        }
        /// <p>This is set to true if it was the end recipient that opted out.</p>
        pub fn end_user_opted_out(mut self, input: bool) -> Self {
            self.end_user_opted_out = Some(input);
            self
        }
        /// <p>This is set to true if it was the end recipient that opted out.</p>
        pub fn set_end_user_opted_out(mut self, input: std::option::Option<bool>) -> Self {
            self.end_user_opted_out = input;
            self
        }
        /// Consumes the builder and constructs a [`OptedOutNumberInformation`](crate::model::OptedOutNumberInformation)
        pub fn build(self) -> crate::model::OptedOutNumberInformation {
            crate::model::OptedOutNumberInformation {
                opted_out_number: self.opted_out_number,
                opted_out_timestamp: self.opted_out_timestamp,
                end_user_opted_out: self.end_user_opted_out.unwrap_or_default(),
            }
        }
    }
}
impl OptedOutNumberInformation {
    /// Creates a new builder-style object to manufacture [`OptedOutNumberInformation`](crate::model::OptedOutNumberInformation)
    pub fn builder() -> crate::model::opted_out_number_information::Builder {
        crate::model::opted_out_number_information::Builder::default()
    }
}

/// <p>The information for opted out numbers that meet a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptedOutFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::OptedOutFilterName>,
    /// <p>An array of values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl OptedOutFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::OptedOutFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for OptedOutFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptedOutFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`OptedOutFilter`](crate::model::OptedOutFilter)
pub mod opted_out_filter {
    /// A builder for [`OptedOutFilter`](crate::model::OptedOutFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::OptedOutFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::OptedOutFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::OptedOutFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array of values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array of values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`OptedOutFilter`](crate::model::OptedOutFilter)
        pub fn build(self) -> crate::model::OptedOutFilter {
            crate::model::OptedOutFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl OptedOutFilter {
    /// Creates a new builder-style object to manufacture [`OptedOutFilter`](crate::model::OptedOutFilter)
    pub fn builder() -> crate::model::opted_out_filter::Builder {
        crate::model::opted_out_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptedOutFilterName {
    #[allow(missing_docs)] // documentation missing in model
    EndUserOptedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptedOutFilterName {
    fn from(s: &str) -> Self {
        match s {
            "end-user-opted-out" => OptedOutFilterName::EndUserOptedOut,
            other => OptedOutFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptedOutFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptedOutFilterName::from(s))
    }
}
impl OptedOutFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptedOutFilterName::EndUserOptedOut => "end-user-opted-out",
            OptedOutFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["end-user-opted-out"]
    }
}
impl AsRef<str> for OptedOutFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The information for all keywords in a pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeywordInformation {
    /// <p>The keyword as a string.</p>
    pub keyword: std::option::Option<std::string::String>,
    /// <p>A custom message that can be used with the keyword.</p>
    pub keyword_message: std::option::Option<std::string::String>,
    /// <p>The action to perform for the keyword.</p>
    pub keyword_action: std::option::Option<crate::model::KeywordAction>,
}
impl KeywordInformation {
    /// <p>The keyword as a string.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
    /// <p>A custom message that can be used with the keyword.</p>
    pub fn keyword_message(&self) -> std::option::Option<&str> {
        self.keyword_message.as_deref()
    }
    /// <p>The action to perform for the keyword.</p>
    pub fn keyword_action(&self) -> std::option::Option<&crate::model::KeywordAction> {
        self.keyword_action.as_ref()
    }
}
impl std::fmt::Debug for KeywordInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeywordInformation");
        formatter.field("keyword", &self.keyword);
        formatter.field("keyword_message", &self.keyword_message);
        formatter.field("keyword_action", &self.keyword_action);
        formatter.finish()
    }
}
/// See [`KeywordInformation`](crate::model::KeywordInformation)
pub mod keyword_information {
    /// A builder for [`KeywordInformation`](crate::model::KeywordInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyword: std::option::Option<std::string::String>,
        pub(crate) keyword_message: std::option::Option<std::string::String>,
        pub(crate) keyword_action: std::option::Option<crate::model::KeywordAction>,
    }
    impl Builder {
        /// <p>The keyword as a string.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>The keyword as a string.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// <p>A custom message that can be used with the keyword.</p>
        pub fn keyword_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword_message = Some(input.into());
            self
        }
        /// <p>A custom message that can be used with the keyword.</p>
        pub fn set_keyword_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyword_message = input;
            self
        }
        /// <p>The action to perform for the keyword.</p>
        pub fn keyword_action(mut self, input: crate::model::KeywordAction) -> Self {
            self.keyword_action = Some(input);
            self
        }
        /// <p>The action to perform for the keyword.</p>
        pub fn set_keyword_action(
            mut self,
            input: std::option::Option<crate::model::KeywordAction>,
        ) -> Self {
            self.keyword_action = input;
            self
        }
        /// Consumes the builder and constructs a [`KeywordInformation`](crate::model::KeywordInformation)
        pub fn build(self) -> crate::model::KeywordInformation {
            crate::model::KeywordInformation {
                keyword: self.keyword,
                keyword_message: self.keyword_message,
                keyword_action: self.keyword_action,
            }
        }
    }
}
impl KeywordInformation {
    /// Creates a new builder-style object to manufacture [`KeywordInformation`](crate::model::KeywordInformation)
    pub fn builder() -> crate::model::keyword_information::Builder {
        crate::model::keyword_information::Builder::default()
    }
}

/// <p>The information for keywords that meet a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeywordFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::KeywordFilterName>,
    /// <p>An array values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl KeywordFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::KeywordFilterName> {
        self.name.as_ref()
    }
    /// <p>An array values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for KeywordFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeywordFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`KeywordFilter`](crate::model::KeywordFilter)
pub mod keyword_filter {
    /// A builder for [`KeywordFilter`](crate::model::KeywordFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::KeywordFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::KeywordFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::KeywordFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`KeywordFilter`](crate::model::KeywordFilter)
        pub fn build(self) -> crate::model::KeywordFilter {
            crate::model::KeywordFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl KeywordFilter {
    /// Creates a new builder-style object to manufacture [`KeywordFilter`](crate::model::KeywordFilter)
    pub fn builder() -> crate::model::keyword_filter::Builder {
        crate::model::keyword_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeywordFilterName {
    #[allow(missing_docs)] // documentation missing in model
    KeywordAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeywordFilterName {
    fn from(s: &str) -> Self {
        match s {
            "keyword-action" => KeywordFilterName::KeywordAction,
            other => KeywordFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeywordFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeywordFilterName::from(s))
    }
}
impl KeywordFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeywordFilterName::KeywordAction => "keyword-action",
            KeywordFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["keyword-action"]
    }
}
impl AsRef<str> for KeywordFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information related to a given configuration set in your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSetInformation {
    /// <p>The Resource Name (ARN) of the ConfigurationSet.</p>
    pub configuration_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the ConfigurationSet.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An array of EventDestination objects that describe any events to log and where to log them.</p>
    pub event_destinations: std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub default_message_type: std::option::Option<crate::model::MessageType>,
    /// <p>The default sender ID used by the ConfigurationSet.</p>
    pub default_sender_id: std::option::Option<std::string::String>,
    /// <p>The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConfigurationSetInformation {
    /// <p>The Resource Name (ARN) of the ConfigurationSet.</p>
    pub fn configuration_set_arn(&self) -> std::option::Option<&str> {
        self.configuration_set_arn.as_deref()
    }
    /// <p>The name of the ConfigurationSet.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An array of EventDestination objects that describe any events to log and where to log them.</p>
    pub fn event_destinations(&self) -> std::option::Option<&[crate::model::EventDestination]> {
        self.event_destinations.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn default_message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.default_message_type.as_ref()
    }
    /// <p>The default sender ID used by the ConfigurationSet.</p>
    pub fn default_sender_id(&self) -> std::option::Option<&str> {
        self.default_sender_id.as_deref()
    }
    /// <p>The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ConfigurationSetInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSetInformation");
        formatter.field("configuration_set_arn", &self.configuration_set_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destinations", &self.event_destinations);
        formatter.field("default_message_type", &self.default_message_type);
        formatter.field("default_sender_id", &self.default_sender_id);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`ConfigurationSetInformation`](crate::model::ConfigurationSetInformation)
pub mod configuration_set_information {
    /// A builder for [`ConfigurationSetInformation`](crate::model::ConfigurationSetInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destinations:
            std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
        pub(crate) default_message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) default_sender_id: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Resource Name (ARN) of the ConfigurationSet.</p>
        pub fn configuration_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_arn = Some(input.into());
            self
        }
        /// <p>The Resource Name (ARN) of the ConfigurationSet.</p>
        pub fn set_configuration_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_arn = input;
            self
        }
        /// <p>The name of the ConfigurationSet.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the ConfigurationSet.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `event_destinations`.
        ///
        /// To override the contents of this collection use [`set_event_destinations`](Self::set_event_destinations).
        ///
        /// <p>An array of EventDestination objects that describe any events to log and where to log them.</p>
        pub fn event_destinations(mut self, input: crate::model::EventDestination) -> Self {
            let mut v = self.event_destinations.unwrap_or_default();
            v.push(input);
            self.event_destinations = Some(v);
            self
        }
        /// <p>An array of EventDestination objects that describe any events to log and where to log them.</p>
        pub fn set_event_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
        ) -> Self {
            self.event_destinations = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn default_message_type(mut self, input: crate::model::MessageType) -> Self {
            self.default_message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_default_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.default_message_type = input;
            self
        }
        /// <p>The default sender ID used by the ConfigurationSet.</p>
        pub fn default_sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_sender_id = Some(input.into());
            self
        }
        /// <p>The default sender ID used by the ConfigurationSet.</p>
        pub fn set_default_sender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_sender_id = input;
            self
        }
        /// <p>The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSetInformation`](crate::model::ConfigurationSetInformation)
        pub fn build(self) -> crate::model::ConfigurationSetInformation {
            crate::model::ConfigurationSetInformation {
                configuration_set_arn: self.configuration_set_arn,
                configuration_set_name: self.configuration_set_name,
                event_destinations: self.event_destinations,
                default_message_type: self.default_message_type,
                default_sender_id: self.default_sender_id,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl ConfigurationSetInformation {
    /// Creates a new builder-style object to manufacture [`ConfigurationSetInformation`](crate::model::ConfigurationSetInformation)
    pub fn builder() -> crate::model::configuration_set_information::Builder {
        crate::model::configuration_set_information::Builder::default()
    }
}

/// <p>The information for configuration sets that meet a specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSetFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub name: std::option::Option<crate::model::ConfigurationSetFilterName>,
    /// <p>An array values to filter for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConfigurationSetFilter {
    /// <p>The name of the attribute to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::ConfigurationSetFilterName> {
        self.name.as_ref()
    }
    /// <p>An array values to filter for.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ConfigurationSetFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSetFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ConfigurationSetFilter`](crate::model::ConfigurationSetFilter)
pub mod configuration_set_filter {
    /// A builder for [`ConfigurationSetFilter`](crate::model::ConfigurationSetFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ConfigurationSetFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the attribute to filter on.</p>
        pub fn name(mut self, input: crate::model::ConfigurationSetFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to filter on.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSetFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array values to filter for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array values to filter for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSetFilter`](crate::model::ConfigurationSetFilter)
        pub fn build(self) -> crate::model::ConfigurationSetFilter {
            crate::model::ConfigurationSetFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl ConfigurationSetFilter {
    /// Creates a new builder-style object to manufacture [`ConfigurationSetFilter`](crate::model::ConfigurationSetFilter)
    pub fn builder() -> crate::model::configuration_set_filter::Builder {
        crate::model::configuration_set_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationSetFilterName {
    #[allow(missing_docs)] // documentation missing in model
    DefaultMessageType,
    #[allow(missing_docs)] // documentation missing in model
    DefaultSenderId,
    #[allow(missing_docs)] // documentation missing in model
    EventDestinationName,
    #[allow(missing_docs)] // documentation missing in model
    MatchingEventTypes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationSetFilterName {
    fn from(s: &str) -> Self {
        match s {
            "default-message-type" => ConfigurationSetFilterName::DefaultMessageType,
            "default-sender-id" => ConfigurationSetFilterName::DefaultSenderId,
            "event-destination-name" => ConfigurationSetFilterName::EventDestinationName,
            "matching-event-types" => ConfigurationSetFilterName::MatchingEventTypes,
            other => ConfigurationSetFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationSetFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationSetFilterName::from(s))
    }
}
impl ConfigurationSetFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationSetFilterName::DefaultMessageType => "default-message-type",
            ConfigurationSetFilterName::DefaultSenderId => "default-sender-id",
            ConfigurationSetFilterName::EventDestinationName => "event-destination-name",
            ConfigurationSetFilterName::MatchingEventTypes => "matching-event-types",
            ConfigurationSetFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "default-message-type",
            "default-sender-id",
            "event-destination-name",
            "matching-event-types",
        ]
    }
}
impl AsRef<str> for ConfigurationSetFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The current resource quotas associated with an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLimit {
    /// <p>The name of the attribute to apply the account limit to.</p>
    pub name: std::option::Option<crate::model::AccountLimitName>,
    /// <p>The current amount that has been spent, in US dollars.</p>
    pub used: i64,
    /// <p>The Amazon Web Services set limit for that resource type, in US dollars.</p>
    pub max: i64,
}
impl AccountLimit {
    /// <p>The name of the attribute to apply the account limit to.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::AccountLimitName> {
        self.name.as_ref()
    }
    /// <p>The current amount that has been spent, in US dollars.</p>
    pub fn used(&self) -> i64 {
        self.used
    }
    /// <p>The Amazon Web Services set limit for that resource type, in US dollars.</p>
    pub fn max(&self) -> i64 {
        self.max
    }
}
impl std::fmt::Debug for AccountLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLimit");
        formatter.field("name", &self.name);
        formatter.field("used", &self.used);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`AccountLimit`](crate::model::AccountLimit)
pub mod account_limit {
    /// A builder for [`AccountLimit`](crate::model::AccountLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::AccountLimitName>,
        pub(crate) used: std::option::Option<i64>,
        pub(crate) max: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the attribute to apply the account limit to.</p>
        pub fn name(mut self, input: crate::model::AccountLimitName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the attribute to apply the account limit to.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::AccountLimitName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The current amount that has been spent, in US dollars.</p>
        pub fn used(mut self, input: i64) -> Self {
            self.used = Some(input);
            self
        }
        /// <p>The current amount that has been spent, in US dollars.</p>
        pub fn set_used(mut self, input: std::option::Option<i64>) -> Self {
            self.used = input;
            self
        }
        /// <p>The Amazon Web Services set limit for that resource type, in US dollars.</p>
        pub fn max(mut self, input: i64) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The Amazon Web Services set limit for that resource type, in US dollars.</p>
        pub fn set_max(mut self, input: std::option::Option<i64>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLimit`](crate::model::AccountLimit)
        pub fn build(self) -> crate::model::AccountLimit {
            crate::model::AccountLimit {
                name: self.name,
                used: self.used.unwrap_or_default(),
                max: self.max.unwrap_or_default(),
            }
        }
    }
}
impl AccountLimit {
    /// Creates a new builder-style object to manufacture [`AccountLimit`](crate::model::AccountLimit)
    pub fn builder() -> crate::model::account_limit::Builder {
        crate::model::account_limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountLimitName {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSets,
    #[allow(missing_docs)] // documentation missing in model
    OptOutLists,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumbers,
    #[allow(missing_docs)] // documentation missing in model
    Pools,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountLimitName {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURATION_SETS" => AccountLimitName::ConfigurationSets,
            "OPT_OUT_LISTS" => AccountLimitName::OptOutLists,
            "PHONE_NUMBERS" => AccountLimitName::PhoneNumbers,
            "POOLS" => AccountLimitName::Pools,
            other => AccountLimitName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountLimitName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountLimitName::from(s))
    }
}
impl AccountLimitName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountLimitName::ConfigurationSets => "CONFIGURATION_SETS",
            AccountLimitName::OptOutLists => "OPT_OUT_LISTS",
            AccountLimitName::PhoneNumbers => "PHONE_NUMBERS",
            AccountLimitName::Pools => "POOLS",
            AccountLimitName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIGURATION_SETS",
            "OPT_OUT_LISTS",
            "PHONE_NUMBERS",
            "POOLS",
        ]
    }
}
impl AsRef<str> for AccountLimitName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Displays the attributes associated with a single Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAttribute {
    /// <p>The name of the account attribute.</p>
    pub name: std::option::Option<crate::model::AccountAttributeName>,
    /// <p>The value associated with the account attribute name.</p>
    pub value: std::option::Option<std::string::String>,
}
impl AccountAttribute {
    /// <p>The name of the account attribute.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::AccountAttributeName> {
        self.name.as_ref()
    }
    /// <p>The value associated with the account attribute name.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for AccountAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAttribute");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AccountAttribute`](crate::model::AccountAttribute)
pub mod account_attribute {
    /// A builder for [`AccountAttribute`](crate::model::AccountAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::AccountAttributeName>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the account attribute.</p>
        pub fn name(mut self, input: crate::model::AccountAttributeName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the account attribute.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::AccountAttributeName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value associated with the account attribute name.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with the account attribute name.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAttribute`](crate::model::AccountAttribute)
        pub fn build(self) -> crate::model::AccountAttribute {
            crate::model::AccountAttribute {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl AccountAttribute {
    /// Creates a new builder-style object to manufacture [`AccountAttribute`](crate::model::AccountAttribute)
    pub fn builder() -> crate::model::account_attribute::Builder {
        crate::model::account_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    AccountTier,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_TIER" => AccountAttributeName::AccountTier,
            other => AccountAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountAttributeName::from(s))
    }
}
impl AccountAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountAttributeName::AccountTier => "ACCOUNT_TIER",
            AccountAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_TIER"]
    }
}
impl AsRef<str> for AccountAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
