// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateOriginationIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateOriginationIdentityError {
    /// Kind of error that occurred.
    pub kind: AssociateOriginationIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateOriginationIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateOriginationIdentityErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateOriginationIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateOriginationIdentityErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateOriginationIdentityErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateOriginationIdentityErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateOriginationIdentityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateOriginationIdentityErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateOriginationIdentityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateOriginationIdentityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateOriginationIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateOriginationIdentityError {
    fn code(&self) -> Option<&str> {
        AssociateOriginationIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            AssociateOriginationIdentityErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            AssociateOriginationIdentityErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl AssociateOriginationIdentityError {
    /// Creates a new `AssociateOriginationIdentityError`.
    pub fn new(kind: AssociateOriginationIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateOriginationIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateOriginationIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateOriginationIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateOriginationIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOriginationIdentityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOriginationIdentityErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateOriginationIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateOriginationIdentityErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateOriginationIdentityErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateOriginationIdentityErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateOriginationIdentityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateOriginationIdentityErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            AssociateOriginationIdentityErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateOriginationIdentityErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateOriginationIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateConfigurationSetErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateConfigurationSetErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateConfigurationSetError {
    /// Creates a new `CreateConfigurationSetError`.
    pub fn new(kind: CreateConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventDestinationErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventDestinationError {
    fn code(&self) -> Option<&str> {
        CreateEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateEventDestinationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateEventDestinationErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateEventDestinationError {
    /// Creates a new `CreateEventDestinationError`.
    pub fn new(kind: CreateEventDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDestinationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEventDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOptOutList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOptOutListError {
    /// Kind of error that occurred.
    pub kind: CreateOptOutListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOptOutList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOptOutListErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOptOutListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOptOutListErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateOptOutListErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateOptOutListErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateOptOutListErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateOptOutListErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateOptOutListErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateOptOutListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOptOutListError {
    fn code(&self) -> Option<&str> {
        CreateOptOutListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateOptOutListErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateOptOutListErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateOptOutListError {
    /// Creates a new `CreateOptOutListError`.
    pub fn new(kind: CreateOptOutListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOptOutListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOptOutListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOptOutListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOptOutListErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOptOutListErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptOutListErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOptOutListErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateOptOutListErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateOptOutListErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptOutListErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOptOutListErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptOutListErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOptOutListErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptOutListErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOptOutListErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptOutListErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateOptOutListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOptOutListErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateOptOutListErrorKind::ConflictException(_inner) => Some(_inner),
            CreateOptOutListErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateOptOutListErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateOptOutListErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateOptOutListErrorKind::ValidationException(_inner) => Some(_inner),
            CreateOptOutListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePoolError {
    /// Kind of error that occurred.
    pub kind: CreatePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePoolErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePoolErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePoolError {
    fn code(&self) -> Option<&str> {
        CreatePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreatePoolErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreatePoolErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl CreatePoolError {
    /// Creates a new `CreatePoolError`.
    pub fn new(kind: CreatePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePoolErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreatePoolErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreatePoolErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePoolErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePoolErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreatePoolErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreatePoolErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePoolErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePoolErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePoolErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePoolErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePoolErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePoolErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreatePoolErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePoolErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteConfigurationSetErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteConfigurationSetErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteConfigurationSetError {
    /// Creates a new `DeleteConfigurationSetError`.
    pub fn new(kind: DeleteConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDefaultMessageType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDefaultMessageTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteDefaultMessageTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDefaultMessageType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDefaultMessageTypeErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDefaultMessageTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDefaultMessageTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDefaultMessageTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDefaultMessageTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDefaultMessageTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDefaultMessageTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDefaultMessageTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDefaultMessageTypeError {
    fn code(&self) -> Option<&str> {
        DeleteDefaultMessageTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteDefaultMessageTypeErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteDefaultMessageTypeErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteDefaultMessageTypeError {
    /// Creates a new `DeleteDefaultMessageTypeError`.
    pub fn new(kind: DeleteDefaultMessageTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDefaultMessageTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDefaultMessageTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDefaultMessageTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDefaultMessageTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDefaultMessageTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultMessageTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultMessageTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultMessageTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultMessageTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultMessageTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultMessageTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultMessageTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultMessageTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultMessageTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDefaultMessageTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDefaultMessageTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDefaultMessageTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDefaultMessageTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDefaultMessageTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDefaultMessageTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDefaultMessageTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDefaultSenderId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDefaultSenderIdError {
    /// Kind of error that occurred.
    pub kind: DeleteDefaultSenderIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDefaultSenderId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDefaultSenderIdErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDefaultSenderIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDefaultSenderIdErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDefaultSenderIdErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDefaultSenderIdErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDefaultSenderIdErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDefaultSenderIdErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDefaultSenderIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDefaultSenderIdError {
    fn code(&self) -> Option<&str> {
        DeleteDefaultSenderIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteDefaultSenderIdErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteDefaultSenderIdErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteDefaultSenderIdError {
    /// Creates a new `DeleteDefaultSenderIdError`.
    pub fn new(kind: DeleteDefaultSenderIdErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDefaultSenderIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDefaultSenderIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDefaultSenderIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDefaultSenderIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDefaultSenderIdErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultSenderIdErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultSenderIdErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultSenderIdErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultSenderIdErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultSenderIdErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultSenderIdErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultSenderIdErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDefaultSenderIdErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDefaultSenderIdErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDefaultSenderIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDefaultSenderIdErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDefaultSenderIdErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDefaultSenderIdErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDefaultSenderIdErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDefaultSenderIdErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDefaultSenderIdErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventDestinationErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEventDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEventDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEventDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEventDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteEventDestinationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteEventDestinationErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteEventDestinationError {
    /// Creates a new `DeleteEventDestinationError`.
    pub fn new(kind: DeleteEventDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDestinationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDestinationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEventDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEventDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEventDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEventDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEventDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteKeyword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteKeywordError {
    /// Kind of error that occurred.
    pub kind: DeleteKeywordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteKeyword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteKeywordErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteKeywordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteKeywordErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteKeywordErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteKeywordErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteKeywordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteKeywordErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteKeywordErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteKeywordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteKeywordError {
    fn code(&self) -> Option<&str> {
        DeleteKeywordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteKeywordErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteKeywordErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteKeywordError {
    /// Creates a new `DeleteKeywordError`.
    pub fn new(kind: DeleteKeywordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteKeywordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteKeywordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteKeywordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteKeywordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteKeywordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeywordErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeywordErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeywordErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeywordErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeywordErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeywordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeywordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeywordErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeywordErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeywordErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeywordErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteKeywordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteKeywordErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteKeywordErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteKeywordErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteKeywordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteKeywordErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteKeywordErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteKeywordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOptedOutNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOptedOutNumberError {
    /// Kind of error that occurred.
    pub kind: DeleteOptedOutNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOptedOutNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOptedOutNumberErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOptedOutNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOptedOutNumberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteOptedOutNumberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteOptedOutNumberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteOptedOutNumberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteOptedOutNumberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteOptedOutNumberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteOptedOutNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOptedOutNumberError {
    fn code(&self) -> Option<&str> {
        DeleteOptedOutNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteOptedOutNumberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteOptedOutNumberErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteOptedOutNumberError {
    /// Creates a new `DeleteOptedOutNumberError`.
    pub fn new(kind: DeleteOptedOutNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOptedOutNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOptedOutNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOptedOutNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOptedOutNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOptedOutNumberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptedOutNumberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptedOutNumberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptedOutNumberErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptedOutNumberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptedOutNumberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptedOutNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptedOutNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptedOutNumberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptedOutNumberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptedOutNumberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptedOutNumberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteOptedOutNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOptedOutNumberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteOptedOutNumberErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteOptedOutNumberErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteOptedOutNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteOptedOutNumberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteOptedOutNumberErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteOptedOutNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOptOutList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOptOutListError {
    /// Kind of error that occurred.
    pub kind: DeleteOptOutListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOptOutList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOptOutListErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOptOutListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOptOutListErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteOptOutListErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteOptOutListErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteOptOutListErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteOptOutListErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteOptOutListErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteOptOutListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOptOutListError {
    fn code(&self) -> Option<&str> {
        DeleteOptOutListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteOptOutListErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteOptOutListErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteOptOutListError {
    /// Creates a new `DeleteOptOutListError`.
    pub fn new(kind: DeleteOptOutListErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOptOutListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOptOutListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOptOutListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOptOutListErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOptOutListErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptOutListErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptOutListErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteOptOutListErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteOptOutListErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptOutListErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptOutListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptOutListErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptOutListErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptOutListErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptOutListErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptOutListErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteOptOutListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOptOutListErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteOptOutListErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteOptOutListErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteOptOutListErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteOptOutListErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteOptOutListErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteOptOutListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePoolError {
    /// Kind of error that occurred.
    pub kind: DeletePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePoolErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePoolErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePoolErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePoolErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePoolErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePoolErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePoolErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePoolError {
    fn code(&self) -> Option<&str> {
        DeletePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeletePoolErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeletePoolErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl DeletePoolError {
    /// Creates a new `DeletePoolError`.
    pub fn new(kind: DeletePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePoolErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePoolErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeletePoolErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePoolErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePoolErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeletePoolErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeletePoolErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePoolErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePoolErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeletePoolErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeletePoolErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePoolErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePoolErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePoolErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePoolErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePoolErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePoolErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePoolErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTextMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTextMessageSpendLimitOverrideError {
    /// Kind of error that occurred.
    pub kind: DeleteTextMessageSpendLimitOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTextMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTextMessageSpendLimitOverrideErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTextMessageSpendLimitOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTextMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTextMessageSpendLimitOverrideError {
    fn code(&self) -> Option<&str> {
        DeleteTextMessageSpendLimitOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteTextMessageSpendLimitOverrideErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteTextMessageSpendLimitOverrideError {
    /// Creates a new `DeleteTextMessageSpendLimitOverrideError`.
    pub fn new(
        kind: DeleteTextMessageSpendLimitOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTextMessageSpendLimitOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTextMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTextMessageSpendLimitOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTextMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTextMessageSpendLimitOverrideErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTextMessageSpendLimitOverrideErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTextMessageSpendLimitOverrideErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTextMessageSpendLimitOverrideErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTextMessageSpendLimitOverrideErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTextMessageSpendLimitOverrideErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTextMessageSpendLimitOverrideErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTextMessageSpendLimitOverrideErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteTextMessageSpendLimitOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTextMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteTextMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteVoiceMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceMessageSpendLimitOverrideError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceMessageSpendLimitOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceMessageSpendLimitOverrideErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceMessageSpendLimitOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceMessageSpendLimitOverrideError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceMessageSpendLimitOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteVoiceMessageSpendLimitOverrideError {
    /// Creates a new `DeleteVoiceMessageSpendLimitOverrideError`.
    pub fn new(
        kind: DeleteVoiceMessageSpendLimitOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceMessageSpendLimitOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceMessageSpendLimitOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceMessageSpendLimitOverrideErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceMessageSpendLimitOverrideErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceMessageSpendLimitOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAttributesErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountAttributesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAccountAttributesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccountAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeAccountAttributesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeAccountAttributesError {
    /// Creates a new `DescribeAccountAttributesError`.
    pub fn new(kind: DescribeAccountAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAttributesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAttributesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAttributesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAttributesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAccountAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountAttributesErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAccountAttributesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountLimitsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountLimitsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountLimitsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAccountLimitsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccountLimitsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeAccountLimitsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeAccountLimitsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeAccountLimitsError {
    /// Creates a new `DescribeAccountLimitsError`.
    pub fn new(kind: DescribeAccountLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountLimitsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountLimitsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountLimitsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountLimitsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountLimitsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountLimitsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountLimitsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountLimitsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAccountLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountLimitsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountLimitsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAccountLimitsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountLimitsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationSetsError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationSetsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeConfigurationSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeConfigurationSetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeConfigurationSetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeConfigurationSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeConfigurationSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationSetsError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeConfigurationSetsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeConfigurationSetsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeConfigurationSetsError {
    /// Creates a new `DescribeConfigurationSetsError`.
    pub fn new(kind: DescribeConfigurationSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationSetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationSetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSetsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeConfigurationSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeConfigurationSetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeConfigurationSetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeConfigurationSetsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeConfigurationSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeKeywords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeKeywordsError {
    /// Kind of error that occurred.
    pub kind: DescribeKeywordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeKeywords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeKeywordsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeKeywordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeKeywordsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeKeywordsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeKeywordsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeKeywordsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeKeywordsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeKeywordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeKeywordsError {
    fn code(&self) -> Option<&str> {
        DescribeKeywordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeKeywordsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeKeywordsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeKeywordsError {
    /// Creates a new `DescribeKeywordsError`.
    pub fn new(kind: DescribeKeywordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeKeywordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeKeywordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeKeywordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeKeywordsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeKeywordsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeywordsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeywordsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeywordsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeywordsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeywordsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeywordsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeywordsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeywordsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeywordsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeKeywordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeKeywordsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeKeywordsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeKeywordsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeKeywordsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeKeywordsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeKeywordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOptedOutNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOptedOutNumbersError {
    /// Kind of error that occurred.
    pub kind: DescribeOptedOutNumbersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOptedOutNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOptedOutNumbersErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOptedOutNumbersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOptedOutNumbersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeOptedOutNumbersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeOptedOutNumbersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeOptedOutNumbersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeOptedOutNumbersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeOptedOutNumbersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOptedOutNumbersError {
    fn code(&self) -> Option<&str> {
        DescribeOptedOutNumbersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeOptedOutNumbersErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeOptedOutNumbersErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeOptedOutNumbersError {
    /// Creates a new `DescribeOptedOutNumbersError`.
    pub fn new(kind: DescribeOptedOutNumbersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOptedOutNumbersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOptedOutNumbersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOptedOutNumbersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOptedOutNumbersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOptedOutNumbersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptedOutNumbersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptedOutNumbersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptedOutNumbersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptedOutNumbersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptedOutNumbersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptedOutNumbersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptedOutNumbersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptedOutNumbersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptedOutNumbersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeOptedOutNumbersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOptedOutNumbersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeOptedOutNumbersErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeOptedOutNumbersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeOptedOutNumbersErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeOptedOutNumbersErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeOptedOutNumbersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOptOutLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOptOutListsError {
    /// Kind of error that occurred.
    pub kind: DescribeOptOutListsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOptOutLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOptOutListsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOptOutListsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOptOutListsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeOptOutListsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeOptOutListsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeOptOutListsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeOptOutListsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeOptOutListsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOptOutListsError {
    fn code(&self) -> Option<&str> {
        DescribeOptOutListsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeOptOutListsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeOptOutListsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeOptOutListsError {
    /// Creates a new `DescribeOptOutListsError`.
    pub fn new(kind: DescribeOptOutListsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOptOutListsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOptOutListsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOptOutListsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOptOutListsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOptOutListsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptOutListsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptOutListsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptOutListsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptOutListsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptOutListsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptOutListsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptOutListsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOptOutListsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptOutListsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeOptOutListsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOptOutListsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeOptOutListsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeOptOutListsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeOptOutListsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeOptOutListsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeOptOutListsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePhoneNumbersError {
    /// Kind of error that occurred.
    pub kind: DescribePhoneNumbersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePhoneNumbersErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePhoneNumbersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePhoneNumbersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePhoneNumbersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePhoneNumbersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePhoneNumbersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePhoneNumbersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePhoneNumbersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePhoneNumbersError {
    fn code(&self) -> Option<&str> {
        DescribePhoneNumbersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribePhoneNumbersErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribePhoneNumbersErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribePhoneNumbersError {
    /// Creates a new `DescribePhoneNumbersError`.
    pub fn new(kind: DescribePhoneNumbersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePhoneNumbersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePhoneNumbersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePhoneNumbersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePhoneNumbersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePhoneNumbersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePhoneNumbersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePhoneNumbersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePhoneNumbersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePhoneNumbersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePhoneNumbersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePhoneNumbersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePhoneNumbersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePhoneNumbersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePhoneNumbersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePhoneNumbersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePhoneNumbersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePhoneNumbersErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePhoneNumbersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePhoneNumbersErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePhoneNumbersErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePhoneNumbersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePoolsError {
    /// Kind of error that occurred.
    pub kind: DescribePoolsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePoolsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePoolsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePoolsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePoolsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePoolsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePoolsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePoolsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePoolsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePoolsError {
    fn code(&self) -> Option<&str> {
        DescribePoolsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribePoolsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribePoolsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribePoolsError {
    /// Creates a new `DescribePoolsError`.
    pub fn new(kind: DescribePoolsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePoolsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePoolsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePoolsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePoolsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePoolsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribePoolsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribePoolsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePoolsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePoolsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePoolsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePoolsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribePoolsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribePoolsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribePoolsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribePoolsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePoolsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePoolsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePoolsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePoolsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePoolsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePoolsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSenderIds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSenderIdsError {
    /// Kind of error that occurred.
    pub kind: DescribeSenderIdsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSenderIds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSenderIdsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSenderIdsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSenderIdsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeSenderIdsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSenderIdsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSenderIdsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSenderIdsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSenderIdsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSenderIdsError {
    fn code(&self) -> Option<&str> {
        DescribeSenderIdsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeSenderIdsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeSenderIdsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeSenderIdsError {
    /// Creates a new `DescribeSenderIdsError`.
    pub fn new(kind: DescribeSenderIdsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSenderIdsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSenderIdsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSenderIdsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSenderIdsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSenderIdsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSenderIdsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSenderIdsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSenderIdsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSenderIdsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSenderIdsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSenderIdsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSenderIdsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSenderIdsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSenderIdsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSenderIdsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSenderIdsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeSenderIdsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSenderIdsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSenderIdsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSenderIdsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSenderIdsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSpendLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSpendLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeSpendLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSpendLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSpendLimitsErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSpendLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSpendLimitsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeSpendLimitsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSpendLimitsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSpendLimitsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSpendLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSpendLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeSpendLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeSpendLimitsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeSpendLimitsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeSpendLimitsError {
    /// Creates a new `DescribeSpendLimitsError`.
    pub fn new(kind: DescribeSpendLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSpendLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSpendLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSpendLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSpendLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSpendLimitsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpendLimitsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpendLimitsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpendLimitsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpendLimitsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpendLimitsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpendLimitsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpendLimitsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSpendLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSpendLimitsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeSpendLimitsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSpendLimitsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSpendLimitsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSpendLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateOriginationIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateOriginationIdentityError {
    /// Kind of error that occurred.
    pub kind: DisassociateOriginationIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateOriginationIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateOriginationIdentityErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateOriginationIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateOriginationIdentityErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateOriginationIdentityErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateOriginationIdentityErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateOriginationIdentityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateOriginationIdentityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateOriginationIdentityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateOriginationIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateOriginationIdentityError {
    fn code(&self) -> Option<&str> {
        DisassociateOriginationIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DisassociateOriginationIdentityErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DisassociateOriginationIdentityErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DisassociateOriginationIdentityError {
    /// Creates a new `DisassociateOriginationIdentityError`.
    pub fn new(
        kind: DisassociateOriginationIdentityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateOriginationIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateOriginationIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateOriginationIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateOriginationIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateOriginationIdentityErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOriginationIdentityErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOriginationIdentityErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOriginationIdentityErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOriginationIdentityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOriginationIdentityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOriginationIdentityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOriginationIdentityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOriginationIdentityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOriginationIdentityErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOriginationIdentityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOriginationIdentityErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateOriginationIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateOriginationIdentityErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateOriginationIdentityErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateOriginationIdentityErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateOriginationIdentityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateOriginationIdentityErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateOriginationIdentityErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateOriginationIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPoolOriginationIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoolOriginationIdentitiesError {
    /// Kind of error that occurred.
    pub kind: ListPoolOriginationIdentitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPoolOriginationIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoolOriginationIdentitiesErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoolOriginationIdentitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoolOriginationIdentitiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPoolOriginationIdentitiesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListPoolOriginationIdentitiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListPoolOriginationIdentitiesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPoolOriginationIdentitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPoolOriginationIdentitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoolOriginationIdentitiesError {
    fn code(&self) -> Option<&str> {
        ListPoolOriginationIdentitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListPoolOriginationIdentitiesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListPoolOriginationIdentitiesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListPoolOriginationIdentitiesError {
    /// Creates a new `ListPoolOriginationIdentitiesError`.
    pub fn new(
        kind: ListPoolOriginationIdentitiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoolOriginationIdentitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoolOriginationIdentitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoolOriginationIdentitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoolOriginationIdentitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoolOriginationIdentitiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoolOriginationIdentitiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoolOriginationIdentitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoolOriginationIdentitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoolOriginationIdentitiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoolOriginationIdentitiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoolOriginationIdentitiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoolOriginationIdentitiesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoolOriginationIdentitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoolOriginationIdentitiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPoolOriginationIdentitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoolOriginationIdentitiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPoolOriginationIdentitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPoolOriginationIdentitiesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListPoolOriginationIdentitiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPoolOriginationIdentitiesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPoolOriginationIdentitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListTagsForResourceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutKeyword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutKeywordError {
    /// Kind of error that occurred.
    pub kind: PutKeywordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutKeyword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutKeywordErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutKeywordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutKeywordErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutKeywordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutKeywordError {
    fn code(&self) -> Option<&str> {
        PutKeywordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            PutKeywordErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            PutKeywordErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl PutKeywordError {
    /// Creates a new `PutKeywordError`.
    pub fn new(kind: PutKeywordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutKeywordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutKeywordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutKeywordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutKeywordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutKeywordErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutKeywordErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutKeywordErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKeywordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKeywordErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutKeywordErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `PutKeywordErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutKeywordErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutKeywordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutKeywordErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutKeywordErrorKind::ConflictException(_inner) => Some(_inner),
            PutKeywordErrorKind::InternalServerException(_inner) => Some(_inner),
            PutKeywordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutKeywordErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutKeywordErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutKeywordErrorKind::ValidationException(_inner) => Some(_inner),
            PutKeywordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutOptedOutNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutOptedOutNumberError {
    /// Kind of error that occurred.
    pub kind: PutOptedOutNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutOptedOutNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutOptedOutNumberErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutOptedOutNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutOptedOutNumberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutOptedOutNumberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutOptedOutNumberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutOptedOutNumberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutOptedOutNumberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutOptedOutNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutOptedOutNumberError {
    fn code(&self) -> Option<&str> {
        PutOptedOutNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            PutOptedOutNumberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            PutOptedOutNumberErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl PutOptedOutNumberError {
    /// Creates a new `PutOptedOutNumberError`.
    pub fn new(kind: PutOptedOutNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutOptedOutNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutOptedOutNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutOptedOutNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutOptedOutNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutOptedOutNumberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOptedOutNumberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOptedOutNumberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOptedOutNumberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOptedOutNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOptedOutNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOptedOutNumberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOptedOutNumberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOptedOutNumberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOptedOutNumberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutOptedOutNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutOptedOutNumberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutOptedOutNumberErrorKind::InternalServerException(_inner) => Some(_inner),
            PutOptedOutNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutOptedOutNumberErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutOptedOutNumberErrorKind::ValidationException(_inner) => Some(_inner),
            PutOptedOutNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReleasePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReleasePhoneNumberError {
    /// Kind of error that occurred.
    pub kind: ReleasePhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReleasePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReleasePhoneNumberErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReleasePhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReleasePhoneNumberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ReleasePhoneNumberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ReleasePhoneNumberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ReleasePhoneNumberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ReleasePhoneNumberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ReleasePhoneNumberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ReleasePhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReleasePhoneNumberError {
    fn code(&self) -> Option<&str> {
        ReleasePhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ReleasePhoneNumberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ReleasePhoneNumberErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ReleasePhoneNumberError {
    /// Creates a new `ReleasePhoneNumberError`.
    pub fn new(kind: ReleasePhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReleasePhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReleasePhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReleasePhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReleasePhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReleasePhoneNumberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleasePhoneNumberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleasePhoneNumberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleasePhoneNumberErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleasePhoneNumberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleasePhoneNumberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleasePhoneNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleasePhoneNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleasePhoneNumberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleasePhoneNumberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleasePhoneNumberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleasePhoneNumberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ReleasePhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReleasePhoneNumberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ReleasePhoneNumberErrorKind::ConflictException(_inner) => Some(_inner),
            ReleasePhoneNumberErrorKind::InternalServerException(_inner) => Some(_inner),
            ReleasePhoneNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ReleasePhoneNumberErrorKind::ThrottlingException(_inner) => Some(_inner),
            ReleasePhoneNumberErrorKind::ValidationException(_inner) => Some(_inner),
            ReleasePhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RequestPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RequestPhoneNumberError {
    /// Kind of error that occurred.
    pub kind: RequestPhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RequestPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RequestPhoneNumberErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RequestPhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RequestPhoneNumberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RequestPhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RequestPhoneNumberError {
    fn code(&self) -> Option<&str> {
        RequestPhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            RequestPhoneNumberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            RequestPhoneNumberErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl RequestPhoneNumberError {
    /// Creates a new `RequestPhoneNumberError`.
    pub fn new(kind: RequestPhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RequestPhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RequestPhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RequestPhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RequestPhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestPhoneNumberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestPhoneNumberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RequestPhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RequestPhoneNumberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::ConflictException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::InternalServerException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::ThrottlingException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::ValidationException(_inner) => Some(_inner),
            RequestPhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendTextMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendTextMessageError {
    /// Kind of error that occurred.
    pub kind: SendTextMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendTextMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendTextMessageErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendTextMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendTextMessageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SendTextMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendTextMessageError {
    fn code(&self) -> Option<&str> {
        SendTextMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SendTextMessageErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SendTextMessageErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SendTextMessageError {
    /// Creates a new `SendTextMessageError`.
    pub fn new(kind: SendTextMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendTextMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendTextMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendTextMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendTextMessageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTextMessageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, SendTextMessageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTextMessageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTextMessageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTextMessageErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SendTextMessageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SendTextMessageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, SendTextMessageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for SendTextMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendTextMessageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendTextMessageErrorKind::ConflictException(_inner) => Some(_inner),
            SendTextMessageErrorKind::InternalServerException(_inner) => Some(_inner),
            SendTextMessageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendTextMessageErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            SendTextMessageErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendTextMessageErrorKind::ValidationException(_inner) => Some(_inner),
            SendTextMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendVoiceMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendVoiceMessageError {
    /// Kind of error that occurred.
    pub kind: SendVoiceMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendVoiceMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendVoiceMessageErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendVoiceMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendVoiceMessageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendVoiceMessageError {
    fn code(&self) -> Option<&str> {
        SendVoiceMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SendVoiceMessageErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SendVoiceMessageErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SendVoiceMessageError {
    /// Creates a new `SendVoiceMessageError`.
    pub fn new(kind: SendVoiceMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendVoiceMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendVoiceMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendVoiceMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendVoiceMessageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, SendVoiceMessageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SendVoiceMessageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SendVoiceMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendVoiceMessageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::ConflictException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::InternalServerException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::ValidationException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetDefaultMessageType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetDefaultMessageTypeError {
    /// Kind of error that occurred.
    pub kind: SetDefaultMessageTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetDefaultMessageType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetDefaultMessageTypeErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetDefaultMessageTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetDefaultMessageTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SetDefaultMessageTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SetDefaultMessageTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetDefaultMessageTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SetDefaultMessageTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SetDefaultMessageTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetDefaultMessageTypeError {
    fn code(&self) -> Option<&str> {
        SetDefaultMessageTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SetDefaultMessageTypeErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SetDefaultMessageTypeErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SetDefaultMessageTypeError {
    /// Creates a new `SetDefaultMessageTypeError`.
    pub fn new(kind: SetDefaultMessageTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetDefaultMessageTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetDefaultMessageTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetDefaultMessageTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetDefaultMessageTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetDefaultMessageTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultMessageTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultMessageTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultMessageTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultMessageTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultMessageTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultMessageTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultMessageTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultMessageTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultMessageTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SetDefaultMessageTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetDefaultMessageTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SetDefaultMessageTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            SetDefaultMessageTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetDefaultMessageTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            SetDefaultMessageTypeErrorKind::ValidationException(_inner) => Some(_inner),
            SetDefaultMessageTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetDefaultSenderId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetDefaultSenderIdError {
    /// Kind of error that occurred.
    pub kind: SetDefaultSenderIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetDefaultSenderId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetDefaultSenderIdErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetDefaultSenderIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetDefaultSenderIdErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SetDefaultSenderIdErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SetDefaultSenderIdErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetDefaultSenderIdErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SetDefaultSenderIdErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SetDefaultSenderIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetDefaultSenderIdError {
    fn code(&self) -> Option<&str> {
        SetDefaultSenderIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SetDefaultSenderIdErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SetDefaultSenderIdErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SetDefaultSenderIdError {
    /// Creates a new `SetDefaultSenderIdError`.
    pub fn new(kind: SetDefaultSenderIdErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetDefaultSenderIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetDefaultSenderIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetDefaultSenderIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetDefaultSenderIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetDefaultSenderIdErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultSenderIdErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultSenderIdErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultSenderIdErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultSenderIdErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultSenderIdErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultSenderIdErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultSenderIdErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultSenderIdErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultSenderIdErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SetDefaultSenderIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetDefaultSenderIdErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SetDefaultSenderIdErrorKind::InternalServerException(_inner) => Some(_inner),
            SetDefaultSenderIdErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetDefaultSenderIdErrorKind::ThrottlingException(_inner) => Some(_inner),
            SetDefaultSenderIdErrorKind::ValidationException(_inner) => Some(_inner),
            SetDefaultSenderIdErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetTextMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetTextMessageSpendLimitOverrideError {
    /// Kind of error that occurred.
    pub kind: SetTextMessageSpendLimitOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetTextMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetTextMessageSpendLimitOverrideErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetTextMessageSpendLimitOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetTextMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            SetTextMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            SetTextMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SetTextMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SetTextMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetTextMessageSpendLimitOverrideError {
    fn code(&self) -> Option<&str> {
        SetTextMessageSpendLimitOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SetTextMessageSpendLimitOverrideErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SetTextMessageSpendLimitOverrideErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SetTextMessageSpendLimitOverrideError {
    /// Creates a new `SetTextMessageSpendLimitOverrideError`.
    pub fn new(
        kind: SetTextMessageSpendLimitOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetTextMessageSpendLimitOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetTextMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetTextMessageSpendLimitOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetTextMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetTextMessageSpendLimitOverrideErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTextMessageSpendLimitOverrideErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTextMessageSpendLimitOverrideErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTextMessageSpendLimitOverrideErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTextMessageSpendLimitOverrideErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTextMessageSpendLimitOverrideErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTextMessageSpendLimitOverrideErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTextMessageSpendLimitOverrideErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SetTextMessageSpendLimitOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetTextMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            SetTextMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            SetTextMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => Some(_inner),
            SetTextMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => Some(_inner),
            SetTextMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetVoiceMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetVoiceMessageSpendLimitOverrideError {
    /// Kind of error that occurred.
    pub kind: SetVoiceMessageSpendLimitOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetVoiceMessageSpendLimitOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetVoiceMessageSpendLimitOverrideErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetVoiceMessageSpendLimitOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetVoiceMessageSpendLimitOverrideError {
    fn code(&self) -> Option<&str> {
        SetVoiceMessageSpendLimitOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SetVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SetVoiceMessageSpendLimitOverrideError {
    /// Creates a new `SetVoiceMessageSpendLimitOverrideError`.
    pub fn new(
        kind: SetVoiceMessageSpendLimitOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetVoiceMessageSpendLimitOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetVoiceMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetVoiceMessageSpendLimitOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetVoiceMessageSpendLimitOverrideErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVoiceMessageSpendLimitOverrideErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVoiceMessageSpendLimitOverrideErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVoiceMessageSpendLimitOverrideErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SetVoiceMessageSpendLimitOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetVoiceMessageSpendLimitOverrideErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            SetVoiceMessageSpendLimitOverrideErrorKind::ThrottlingException(_inner) => Some(_inner),
            SetVoiceMessageSpendLimitOverrideErrorKind::ValidationException(_inner) => Some(_inner),
            SetVoiceMessageSpendLimitOverrideErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            TagResourceErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UntagResourceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventDestinationErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEventDestinationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEventDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEventDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEventDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEventDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateEventDestinationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateEventDestinationErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateEventDestinationError {
    /// Creates a new `UpdateEventDestinationError`.
    pub fn new(kind: UpdateEventDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEventDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDestinationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDestinationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDestinationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDestinationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEventDestinationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEventDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEventDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEventDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEventDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEventDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePhoneNumberError {
    /// Kind of error that occurred.
    pub kind: UpdatePhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePhoneNumberErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePhoneNumberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePhoneNumberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePhoneNumberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePhoneNumberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePhoneNumberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePhoneNumberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePhoneNumberError {
    fn code(&self) -> Option<&str> {
        UpdatePhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdatePhoneNumberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdatePhoneNumberErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdatePhoneNumberError {
    /// Creates a new `UpdatePhoneNumberError`.
    pub fn new(kind: UpdatePhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePhoneNumberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePhoneNumberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePhoneNumberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdatePhoneNumberErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdatePhoneNumberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePhoneNumberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePhoneNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePhoneNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePhoneNumberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePhoneNumberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePhoneNumberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePhoneNumberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePhoneNumberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePhoneNumberErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePhoneNumberErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePhoneNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePhoneNumberErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePhoneNumberErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePoolError {
    /// Kind of error that occurred.
    pub kind: UpdatePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePoolErrorKind {
    /// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A validation exception for a field.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePoolErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePoolErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePoolErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePoolErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePoolErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePoolErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePoolError {
    fn code(&self) -> Option<&str> {
        UpdatePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdatePoolErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdatePoolErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl UpdatePoolError {
    /// Creates a new `UpdatePoolError`.
    pub fn new(kind: UpdatePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePoolErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdatePoolErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdatePoolErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdatePoolErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdatePoolErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdatePoolErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdatePoolErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePoolErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePoolErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdatePoolErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdatePoolErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdatePoolErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdatePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePoolErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePoolErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePoolErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePoolErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePoolErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePoolErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A validation exception for a field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The field that failed validation.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason for the exception.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The field that failed validation.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The field that failed validation.</p>
        pub fn fields(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input);
            self.fields = Some(v);
            self
        }
        /// <p>The field that failed validation.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>An error that occurred because too many requests were sent during a certain amount of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ThrottlingError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>A requested resource couldn't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of resource that caused the exception.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The unique identifier of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The type of resource that caused the exception.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The unique identifier of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of resource that caused the exception.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource that caused the exception.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The unique identifier of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InternalServerException {
    /// <p>The unique identifier of the request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier of the request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn't valid for the current state or configuration of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::ConflictExceptionReason>,
    /// <p>The type of resource that caused the exception.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The unique identifier of the request.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The reason for the exception.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ConflictExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The type of resource that caused the exception.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The unique identifier of the request.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ConflictExceptionReason>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::ConflictExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ConflictExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>The type of resource that caused the exception.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource that caused the exception.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The unique identifier of the request.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the request.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                reason: self.reason,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The request was denied because you don't have sufficient permissions to access the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::AccessDeniedExceptionReason>,
}
impl AccessDeniedException {
    /// <p>The reason for the exception.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::AccessDeniedExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::AccessDeniedExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::AccessDeniedExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AccessDeniedExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request would cause a service quota to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::ServiceQuotaExceededExceptionReason>,
}
impl ServiceQuotaExceededException {
    /// <p>The reason for the exception.</p>
    pub fn reason(
        &self,
    ) -> std::option::Option<&crate::model::ServiceQuotaExceededExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ServiceQuotaExceededExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::ServiceQuotaExceededExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ServiceQuotaExceededExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
