// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateOriginationIdentityInput`](crate::input::AssociateOriginationIdentityInput)
pub mod associate_origination_identity_input {
    /// A builder for [`AssociateOriginationIdentityInput`](crate::input::AssociateOriginationIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateOriginationIdentityInput`](crate::input::AssociateOriginationIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateOriginationIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateOriginationIdentityInput {
                pool_id: self.pool_id,
                origination_identity: self.origination_identity,
                iso_country_code: self.iso_country_code,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateOriginationIdentityInputOperationOutputAlias =
    crate::operation::AssociateOriginationIdentity;
#[doc(hidden)]
pub type AssociateOriginationIdentityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateOriginationIdentityInput {
    /// Consumes the builder and constructs an Operation<[`AssociateOriginationIdentity`](crate::operation::AssociateOriginationIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateOriginationIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateOriginationIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateOriginationIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.AssociateOriginationIdentity",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_origination_identity(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateOriginationIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateOriginationIdentity",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateOriginationIdentityInput`](crate::input::AssociateOriginationIdentityInput)
    pub fn builder() -> crate::input::associate_origination_identity_input::Builder {
        crate::input::associate_origination_identity_input::Builder::default()
    }
}

/// See [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
pub mod create_configuration_set_input {
    /// A builder for [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the new configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name to use for the new configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that's associated with the new configuration set. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of key and value pair tags that's associated with the new configuration set. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationOutputAlias = crate::operation::CreateConfigurationSet;
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSet`](crate::operation::CreateConfigurationSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateConfigurationSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateConfigurationSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.CreateConfigurationSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSet",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
}

/// See [`CreateEventDestinationInput`](crate::input::CreateEventDestinationInput)
pub mod create_event_destination_input {
    /// A builder for [`CreateEventDestinationInput`](crate::input::CreateEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) cloud_watch_logs_destination:
            std::option::Option<crate::model::CloudWatchLogsDestination>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The name that identifies the event destination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name that identifies the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
        pub fn matching_event_types(mut self, input: crate::model::EventType) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input);
            self.matching_event_types = Some(v);
            self
        }
        /// <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.cloud_watch_logs_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.cloud_watch_logs_destination = input;
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventDestinationInput`](crate::input::CreateEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                matching_event_types: self.matching_event_types,
                cloud_watch_logs_destination: self.cloud_watch_logs_destination,
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                sns_destination: self.sns_destination,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventDestinationInputOperationOutputAlias = crate::operation::CreateEventDestination;
#[doc(hidden)]
pub type CreateEventDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventDestination`](crate::operation::CreateEventDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEventDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEventDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.CreateEventDestination",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_event_destination(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventDestination",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEventDestinationInput`](crate::input::CreateEventDestinationInput)
    pub fn builder() -> crate::input::create_event_destination_input::Builder {
        crate::input::create_event_destination_input::Builder::default()
    }
}

/// See [`CreateOptOutListInput`](crate::input::CreateOptOutListInput)
pub mod create_opt_out_list_input {
    /// A builder for [`CreateOptOutListInput`](crate::input::CreateOptOutListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new OptOutList.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the new OptOutList.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOptOutListInput`](crate::input::CreateOptOutListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOptOutListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOptOutListInput {
                opt_out_list_name: self.opt_out_list_name,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOptOutListInputOperationOutputAlias = crate::operation::CreateOptOutList;
#[doc(hidden)]
pub type CreateOptOutListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOptOutListInput {
    /// Consumes the builder and constructs an Operation<[`CreateOptOutList`](crate::operation::CreateOptOutList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOptOutList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOptOutListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOptOutListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.CreateOptOutList",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_opt_out_list(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOptOutList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOptOutList",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOptOutListInput`](crate::input::CreateOptOutListInput)
    pub fn builder() -> crate::input::create_opt_out_list_input::Builder {
        crate::input::create_opt_out_list_input::Builder::default()
    }
}

/// See [`CreatePoolInput`](crate::input::CreatePoolInput)
pub mod create_pool_input {
    /// A builder for [`CreatePoolInput`](crate::input::CreatePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) associated with the pool.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags (key and value pairs) associated with the pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePoolInput`](crate::input::CreatePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePoolInput {
                origination_identity: self.origination_identity,
                iso_country_code: self.iso_country_code,
                message_type: self.message_type,
                deletion_protection_enabled: self.deletion_protection_enabled,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePoolInputOperationOutputAlias = crate::operation::CreatePool;
#[doc(hidden)]
pub type CreatePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePoolInput {
    /// Consumes the builder and constructs an Operation<[`CreatePool`](crate::operation::CreatePool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.CreatePool",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePool",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePoolInput`](crate::input::CreatePoolInput)
    pub fn builder() -> crate::input::create_pool_input::Builder {
        crate::input::create_pool_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
pub mod delete_configuration_set_input {
    /// A builder for [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationOutputAlias = crate::operation::DeleteConfigurationSet;
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSet`](crate::operation::DeleteConfigurationSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigurationSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigurationSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteConfigurationSet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_set(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSet",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
}

/// See [`DeleteDefaultMessageTypeInput`](crate::input::DeleteDefaultMessageTypeInput)
pub mod delete_default_message_type_input {
    /// A builder for [`DeleteDefaultMessageTypeInput`](crate::input::DeleteDefaultMessageTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDefaultMessageTypeInput`](crate::input::DeleteDefaultMessageTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDefaultMessageTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDefaultMessageTypeInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDefaultMessageTypeInputOperationOutputAlias =
    crate::operation::DeleteDefaultMessageType;
#[doc(hidden)]
pub type DeleteDefaultMessageTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDefaultMessageTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDefaultMessageType`](crate::operation::DeleteDefaultMessageType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDefaultMessageType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDefaultMessageTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDefaultMessageTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteDefaultMessageType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_default_message_type(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDefaultMessageType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDefaultMessageType",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDefaultMessageTypeInput`](crate::input::DeleteDefaultMessageTypeInput)
    pub fn builder() -> crate::input::delete_default_message_type_input::Builder {
        crate::input::delete_default_message_type_input::Builder::default()
    }
}

/// See [`DeleteDefaultSenderIdInput`](crate::input::DeleteDefaultSenderIdInput)
pub mod delete_default_sender_id_input {
    /// A builder for [`DeleteDefaultSenderIdInput`](crate::input::DeleteDefaultSenderIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDefaultSenderIdInput`](crate::input::DeleteDefaultSenderIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDefaultSenderIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDefaultSenderIdInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDefaultSenderIdInputOperationOutputAlias = crate::operation::DeleteDefaultSenderId;
#[doc(hidden)]
pub type DeleteDefaultSenderIdInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDefaultSenderIdInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDefaultSenderId`](crate::operation::DeleteDefaultSenderId)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDefaultSenderId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDefaultSenderIdInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDefaultSenderIdInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteDefaultSenderId",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_default_sender_id(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDefaultSenderId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDefaultSenderId",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDefaultSenderIdInput`](crate::input::DeleteDefaultSenderIdInput)
    pub fn builder() -> crate::input::delete_default_sender_id_input::Builder {
        crate::input::delete_default_sender_id_input::Builder::default()
    }
}

/// See [`DeleteEventDestinationInput`](crate::input::DeleteEventDestinationInput)
pub mod delete_event_destination_input {
    /// A builder for [`DeleteEventDestinationInput`](crate::input::DeleteEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventDestinationInput`](crate::input::DeleteEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventDestinationInputOperationOutputAlias = crate::operation::DeleteEventDestination;
#[doc(hidden)]
pub type DeleteEventDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventDestination`](crate::operation::DeleteEventDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEventDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEventDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteEventDestination",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_event_destination(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventDestination",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventDestinationInput`](crate::input::DeleteEventDestinationInput)
    pub fn builder() -> crate::input::delete_event_destination_input::Builder {
        crate::input::delete_event_destination_input::Builder::default()
    }
}

/// See [`DeleteKeywordInput`](crate::input::DeleteKeywordInput)
pub mod delete_keyword_input {
    /// A builder for [`DeleteKeywordInput`](crate::input::DeleteKeywordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) keyword: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The keyword to delete.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>The keyword to delete.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeywordInput`](crate::input::DeleteKeywordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKeywordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKeywordInput {
                origination_identity: self.origination_identity,
                keyword: self.keyword,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKeywordInputOperationOutputAlias = crate::operation::DeleteKeyword;
#[doc(hidden)]
pub type DeleteKeywordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteKeywordInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKeyword`](crate::operation::DeleteKeyword)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKeyword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteKeywordInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteKeywordInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteKeyword",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_keyword(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKeyword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKeyword",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteKeywordInput`](crate::input::DeleteKeywordInput)
    pub fn builder() -> crate::input::delete_keyword_input::Builder {
        crate::input::delete_keyword_input::Builder::default()
    }
}

/// See [`DeleteOptedOutNumberInput`](crate::input::DeleteOptedOutNumberInput)
pub mod delete_opted_out_number_input {
    /// A builder for [`DeleteOptedOutNumberInput`](crate::input::DeleteOptedOutNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) opted_out_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.opted_out_number = Some(input.into());
            self
        }
        /// <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opted_out_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOptedOutNumberInput`](crate::input::DeleteOptedOutNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOptedOutNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOptedOutNumberInput {
                opt_out_list_name: self.opt_out_list_name,
                opted_out_number: self.opted_out_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOptedOutNumberInputOperationOutputAlias = crate::operation::DeleteOptedOutNumber;
#[doc(hidden)]
pub type DeleteOptedOutNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOptedOutNumberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOptedOutNumber`](crate::operation::DeleteOptedOutNumber)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOptedOutNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOptedOutNumberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOptedOutNumberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteOptedOutNumber",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_opted_out_number(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOptedOutNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOptedOutNumber",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOptedOutNumberInput`](crate::input::DeleteOptedOutNumberInput)
    pub fn builder() -> crate::input::delete_opted_out_number_input::Builder {
        crate::input::delete_opted_out_number_input::Builder::default()
    }
}

/// See [`DeleteOptOutListInput`](crate::input::DeleteOptOutListInput)
pub mod delete_opt_out_list_input {
    /// A builder for [`DeleteOptOutListInput`](crate::input::DeleteOptOutListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOptOutListInput`](crate::input::DeleteOptOutListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOptOutListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOptOutListInput {
                opt_out_list_name: self.opt_out_list_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOptOutListInputOperationOutputAlias = crate::operation::DeleteOptOutList;
#[doc(hidden)]
pub type DeleteOptOutListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOptOutListInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOptOutList`](crate::operation::DeleteOptOutList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOptOutList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOptOutListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOptOutListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteOptOutList",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_opt_out_list(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOptOutList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOptOutList",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOptOutListInput`](crate::input::DeleteOptOutListInput)
    pub fn builder() -> crate::input::delete_opt_out_list_input::Builder {
        crate::input::delete_opt_out_list_input::Builder::default()
    }
}

/// See [`DeletePoolInput`](crate::input::DeletePoolInput)
pub mod delete_pool_input {
    /// A builder for [`DeletePoolInput`](crate::input::DeletePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePoolInput`](crate::input::DeletePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePoolInput {
                pool_id: self.pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePoolInputOperationOutputAlias = crate::operation::DeletePool;
#[doc(hidden)]
pub type DeletePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePoolInput {
    /// Consumes the builder and constructs an Operation<[`DeletePool`](crate::operation::DeletePool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeletePool",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePool",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePoolInput`](crate::input::DeletePoolInput)
    pub fn builder() -> crate::input::delete_pool_input::Builder {
        crate::input::delete_pool_input::Builder::default()
    }
}

/// See [`DeleteTextMessageSpendLimitOverrideInput`](crate::input::DeleteTextMessageSpendLimitOverrideInput)
pub mod delete_text_message_spend_limit_override_input {
    /// A builder for [`DeleteTextMessageSpendLimitOverrideInput`](crate::input::DeleteTextMessageSpendLimitOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTextMessageSpendLimitOverrideInput`](crate::input::DeleteTextMessageSpendLimitOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTextMessageSpendLimitOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTextMessageSpendLimitOverrideInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteTextMessageSpendLimitOverrideInputOperationOutputAlias =
    crate::operation::DeleteTextMessageSpendLimitOverride;
#[doc(hidden)]
pub type DeleteTextMessageSpendLimitOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTextMessageSpendLimitOverrideInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTextMessageSpendLimitOverride`](crate::operation::DeleteTextMessageSpendLimitOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTextMessageSpendLimitOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTextMessageSpendLimitOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTextMessageSpendLimitOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteTextMessageSpendLimitOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_text_message_spend_limit_override(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTextMessageSpendLimitOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTextMessageSpendLimitOverride",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTextMessageSpendLimitOverrideInput`](crate::input::DeleteTextMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::delete_text_message_spend_limit_override_input::Builder {
        crate::input::delete_text_message_spend_limit_override_input::Builder::default()
    }
}

/// See [`DeleteVoiceMessageSpendLimitOverrideInput`](crate::input::DeleteVoiceMessageSpendLimitOverrideInput)
pub mod delete_voice_message_spend_limit_override_input {
    /// A builder for [`DeleteVoiceMessageSpendLimitOverrideInput`](crate::input::DeleteVoiceMessageSpendLimitOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVoiceMessageSpendLimitOverrideInput`](crate::input::DeleteVoiceMessageSpendLimitOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceMessageSpendLimitOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceMessageSpendLimitOverrideInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceMessageSpendLimitOverrideInputOperationOutputAlias =
    crate::operation::DeleteVoiceMessageSpendLimitOverride;
#[doc(hidden)]
pub type DeleteVoiceMessageSpendLimitOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceMessageSpendLimitOverrideInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceMessageSpendLimitOverride`](crate::operation::DeleteVoiceMessageSpendLimitOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceMessageSpendLimitOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVoiceMessageSpendLimitOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVoiceMessageSpendLimitOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DeleteVoiceMessageSpendLimitOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_voice_message_spend_limit_override(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceMessageSpendLimitOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceMessageSpendLimitOverride",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceMessageSpendLimitOverrideInput`](crate::input::DeleteVoiceMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::delete_voice_message_spend_limit_override_input::Builder {
        crate::input::delete_voice_message_spend_limit_override_input::Builder::default()
    }
}

/// See [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
pub mod describe_account_attributes_input {
    /// A builder for [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAttributesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationOutputAlias =
    crate::operation::DescribeAccountAttributes;
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAttributes`](crate::operation::DescribeAccountAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeAccountAttributes",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_attributes(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAttributes",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
}

/// See [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
pub mod describe_account_limits_input {
    /// A builder for [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountLimitsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationOutputAlias = crate::operation::DescribeAccountLimits;
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountLimits`](crate::operation::DescribeAccountLimits)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountLimits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountLimitsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountLimitsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeAccountLimits",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_limits(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountLimits",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
}

/// See [`DescribeConfigurationSetsInput`](crate::input::DescribeConfigurationSetsInput)
pub mod describe_configuration_sets_input {
    /// A builder for [`DescribeConfigurationSetsInput`](crate::input::DescribeConfigurationSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationSetFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `configuration_set_names`.
        ///
        /// To override the contents of this collection use [`set_configuration_set_names`](Self::set_configuration_set_names).
        ///
        /// <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.configuration_set_names.unwrap_or_default();
            v.push(input.into());
            self.configuration_set_names = Some(v);
            self
        }
        /// <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.configuration_set_names = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters to apply to the results that are returned.</p>
        pub fn filters(mut self, input: crate::model::ConfigurationSetFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of filters to apply to the results that are returned.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationSetsInput`](crate::input::DescribeConfigurationSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationSetsInput {
                configuration_set_names: self.configuration_set_names,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationSetsInputOperationOutputAlias =
    crate::operation::DescribeConfigurationSets;
#[doc(hidden)]
pub type DescribeConfigurationSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationSetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationSets`](crate::operation::DescribeConfigurationSets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationSetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationSetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeConfigurationSets",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_sets(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationSets",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSetsInput`](crate::input::DescribeConfigurationSetsInput)
    pub fn builder() -> crate::input::describe_configuration_sets_input::Builder {
        crate::input::describe_configuration_sets_input::Builder::default()
    }
}

/// See [`DescribeKeywordsInput`](crate::input::DescribeKeywordsInput)
pub mod describe_keywords_input {
    /// A builder for [`DescribeKeywordsInput`](crate::input::DescribeKeywordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) keywords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array of keywords to search for.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keywords.unwrap_or_default();
            v.push(input.into());
            self.keywords = Some(v);
            self
        }
        /// <p>An array of keywords to search for.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keywords = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of keyword filters to filter the results.</p>
        pub fn filters(mut self, input: crate::model::KeywordFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of keyword filters to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeKeywordsInput`](crate::input::DescribeKeywordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeKeywordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeKeywordsInput {
                origination_identity: self.origination_identity,
                keywords: self.keywords,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeKeywordsInputOperationOutputAlias = crate::operation::DescribeKeywords;
#[doc(hidden)]
pub type DescribeKeywordsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeKeywordsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeKeywords`](crate::operation::DescribeKeywords)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeKeywords,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeKeywordsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeKeywordsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeKeywords",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_keywords(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeKeywords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeKeywords",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeKeywordsInput`](crate::input::DescribeKeywordsInput)
    pub fn builder() -> crate::input::describe_keywords_input::Builder {
        crate::input::describe_keywords_input::Builder::default()
    }
}

/// See [`DescribeOptedOutNumbersInput`](crate::input::DescribeOptedOutNumbersInput)
pub mod describe_opted_out_numbers_input {
    /// A builder for [`DescribeOptedOutNumbersInput`](crate::input::DescribeOptedOutNumbersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) opted_out_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::OptedOutFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// Appends an item to `opted_out_numbers`.
        ///
        /// To override the contents of this collection use [`set_opted_out_numbers`](Self::set_opted_out_numbers).
        ///
        /// <p>An array of phone numbers to search for in the OptOutList.</p>
        pub fn opted_out_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.opted_out_numbers.unwrap_or_default();
            v.push(input.into());
            self.opted_out_numbers = Some(v);
            self
        }
        /// <p>An array of phone numbers to search for in the OptOutList.</p>
        pub fn set_opted_out_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.opted_out_numbers = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of OptedOutFilter objects to filter the results on.</p>
        pub fn filters(mut self, input: crate::model::OptedOutFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of OptedOutFilter objects to filter the results on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptedOutFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOptedOutNumbersInput`](crate::input::DescribeOptedOutNumbersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOptedOutNumbersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOptedOutNumbersInput {
                opt_out_list_name: self.opt_out_list_name,
                opted_out_numbers: self.opted_out_numbers,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOptedOutNumbersInputOperationOutputAlias =
    crate::operation::DescribeOptedOutNumbers;
#[doc(hidden)]
pub type DescribeOptedOutNumbersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOptedOutNumbersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOptedOutNumbers`](crate::operation::DescribeOptedOutNumbers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOptedOutNumbers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOptedOutNumbersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOptedOutNumbersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeOptedOutNumbers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_opted_out_numbers(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOptedOutNumbers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOptedOutNumbers",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOptedOutNumbersInput`](crate::input::DescribeOptedOutNumbersInput)
    pub fn builder() -> crate::input::describe_opted_out_numbers_input::Builder {
        crate::input::describe_opted_out_numbers_input::Builder::default()
    }
}

/// See [`DescribeOptOutListsInput`](crate::input::DescribeOptOutListsInput)
pub mod describe_opt_out_lists_input {
    /// A builder for [`DescribeOptOutListsInput`](crate::input::DescribeOptOutListsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `opt_out_list_names`.
        ///
        /// To override the contents of this collection use [`set_opt_out_list_names`](Self::set_opt_out_list_names).
        ///
        /// <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
        pub fn opt_out_list_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.opt_out_list_names.unwrap_or_default();
            v.push(input.into());
            self.opt_out_list_names = Some(v);
            self
        }
        /// <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
        pub fn set_opt_out_list_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.opt_out_list_names = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOptOutListsInput`](crate::input::DescribeOptOutListsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOptOutListsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOptOutListsInput {
                opt_out_list_names: self.opt_out_list_names,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOptOutListsInputOperationOutputAlias = crate::operation::DescribeOptOutLists;
#[doc(hidden)]
pub type DescribeOptOutListsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOptOutListsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOptOutLists`](crate::operation::DescribeOptOutLists)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOptOutLists,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOptOutListsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOptOutListsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeOptOutLists",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_opt_out_lists(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOptOutLists::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOptOutLists",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOptOutListsInput`](crate::input::DescribeOptOutListsInput)
    pub fn builder() -> crate::input::describe_opt_out_lists_input::Builder {
        crate::input::describe_opt_out_lists_input::Builder::default()
    }
}

/// See [`DescribePhoneNumbersInput`](crate::input::DescribePhoneNumbersInput)
pub mod describe_phone_numbers_input {
    /// A builder for [`DescribePhoneNumbersInput`](crate::input::DescribePhoneNumbersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::PhoneNumberFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `phone_number_ids`.
        ///
        /// To override the contents of this collection use [`set_phone_number_ids`](Self::set_phone_number_ids).
        ///
        /// <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn phone_number_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.phone_number_ids.unwrap_or_default();
            v.push(input.into());
            self.phone_number_ids = Some(v);
            self
        }
        /// <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn set_phone_number_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phone_number_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of PhoneNumberFilter objects to filter the results.</p>
        pub fn filters(mut self, input: crate::model::PhoneNumberFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of PhoneNumberFilter objects to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePhoneNumbersInput`](crate::input::DescribePhoneNumbersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePhoneNumbersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePhoneNumbersInput {
                phone_number_ids: self.phone_number_ids,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePhoneNumbersInputOperationOutputAlias = crate::operation::DescribePhoneNumbers;
#[doc(hidden)]
pub type DescribePhoneNumbersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePhoneNumbersInput {
    /// Consumes the builder and constructs an Operation<[`DescribePhoneNumbers`](crate::operation::DescribePhoneNumbers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePhoneNumbers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePhoneNumbersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePhoneNumbersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribePhoneNumbers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_phone_numbers(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePhoneNumbers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePhoneNumbers",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePhoneNumbersInput`](crate::input::DescribePhoneNumbersInput)
    pub fn builder() -> crate::input::describe_phone_numbers_input::Builder {
        crate::input::describe_phone_numbers_input::Builder::default()
    }
}

/// See [`DescribePoolsInput`](crate::input::DescribePoolsInput)
pub mod describe_pools_input {
    /// A builder for [`DescribePoolsInput`](crate::input::DescribePoolsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::PoolFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `pool_ids`.
        ///
        /// To override the contents of this collection use [`set_pool_ids`](Self::set_pool_ids).
        ///
        /// <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
        pub fn pool_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pool_ids.unwrap_or_default();
            v.push(input.into());
            self.pool_ids = Some(v);
            self
        }
        /// <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
        pub fn set_pool_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pool_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of PoolFilter objects to filter the results.</p>
        pub fn filters(mut self, input: crate::model::PoolFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of PoolFilter objects to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PoolFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePoolsInput`](crate::input::DescribePoolsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePoolsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePoolsInput {
                pool_ids: self.pool_ids,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePoolsInputOperationOutputAlias = crate::operation::DescribePools;
#[doc(hidden)]
pub type DescribePoolsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePoolsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePools`](crate::operation::DescribePools)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePools,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePoolsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePoolsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribePools",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_pools(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePools::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePools",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePoolsInput`](crate::input::DescribePoolsInput)
    pub fn builder() -> crate::input::describe_pools_input::Builder {
        crate::input::describe_pools_input::Builder::default()
    }
}

/// See [`DescribeSenderIdsInput`](crate::input::DescribeSenderIdsInput)
pub mod describe_sender_ids_input {
    /// A builder for [`DescribeSenderIdsInput`](crate::input::DescribeSenderIdsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sender_ids: std::option::Option<std::vec::Vec<crate::model::SenderIdAndCountry>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SenderIdFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `sender_ids`.
        ///
        /// To override the contents of this collection use [`set_sender_ids`](Self::set_sender_ids).
        ///
        /// <p>An array of SenderIdAndCountry objects to search for.</p>
        pub fn sender_ids(mut self, input: crate::model::SenderIdAndCountry) -> Self {
            let mut v = self.sender_ids.unwrap_or_default();
            v.push(input);
            self.sender_ids = Some(v);
            self
        }
        /// <p>An array of SenderIdAndCountry objects to search for.</p>
        pub fn set_sender_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SenderIdAndCountry>>,
        ) -> Self {
            self.sender_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of SenderIdFilter objects to filter the results.</p>
        pub fn filters(mut self, input: crate::model::SenderIdFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of SenderIdFilter objects to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SenderIdFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSenderIdsInput`](crate::input::DescribeSenderIdsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSenderIdsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSenderIdsInput {
                sender_ids: self.sender_ids,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSenderIdsInputOperationOutputAlias = crate::operation::DescribeSenderIds;
#[doc(hidden)]
pub type DescribeSenderIdsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSenderIdsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSenderIds`](crate::operation::DescribeSenderIds)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSenderIds,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSenderIdsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSenderIdsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeSenderIds",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_sender_ids(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSenderIds::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSenderIds",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSenderIdsInput`](crate::input::DescribeSenderIdsInput)
    pub fn builder() -> crate::input::describe_sender_ids_input::Builder {
        crate::input::describe_sender_ids_input::Builder::default()
    }
}

/// See [`DescribeSpendLimitsInput`](crate::input::DescribeSpendLimitsInput)
pub mod describe_spend_limits_input {
    /// A builder for [`DescribeSpendLimitsInput`](crate::input::DescribeSpendLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSpendLimitsInput`](crate::input::DescribeSpendLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSpendLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSpendLimitsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSpendLimitsInputOperationOutputAlias = crate::operation::DescribeSpendLimits;
#[doc(hidden)]
pub type DescribeSpendLimitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSpendLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSpendLimits`](crate::operation::DescribeSpendLimits)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSpendLimits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSpendLimitsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSpendLimitsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DescribeSpendLimits",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_spend_limits(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSpendLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSpendLimits",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSpendLimitsInput`](crate::input::DescribeSpendLimitsInput)
    pub fn builder() -> crate::input::describe_spend_limits_input::Builder {
        crate::input::describe_spend_limits_input::Builder::default()
    }
}

/// See [`DisassociateOriginationIdentityInput`](crate::input::DisassociateOriginationIdentityInput)
pub mod disassociate_origination_identity_input {
    /// A builder for [`DisassociateOriginationIdentityInput`](crate::input::DisassociateOriginationIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateOriginationIdentityInput`](crate::input::DisassociateOriginationIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateOriginationIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateOriginationIdentityInput {
                pool_id: self.pool_id,
                origination_identity: self.origination_identity,
                iso_country_code: self.iso_country_code,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateOriginationIdentityInputOperationOutputAlias =
    crate::operation::DisassociateOriginationIdentity;
#[doc(hidden)]
pub type DisassociateOriginationIdentityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateOriginationIdentityInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateOriginationIdentity`](crate::operation::DisassociateOriginationIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateOriginationIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateOriginationIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateOriginationIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.DisassociateOriginationIdentity",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_origination_identity(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateOriginationIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateOriginationIdentity",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateOriginationIdentityInput`](crate::input::DisassociateOriginationIdentityInput)
    pub fn builder() -> crate::input::disassociate_origination_identity_input::Builder {
        crate::input::disassociate_origination_identity_input::Builder::default()
    }
}

/// See [`ListPoolOriginationIdentitiesInput`](crate::input::ListPoolOriginationIdentitiesInput)
pub mod list_pool_origination_identities_input {
    /// A builder for [`ListPoolOriginationIdentitiesInput`](crate::input::ListPoolOriginationIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::PoolOriginationIdentitiesFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
        pub fn filters(mut self, input: crate::model::PoolOriginationIdentitiesFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PoolOriginationIdentitiesFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoolOriginationIdentitiesInput`](crate::input::ListPoolOriginationIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPoolOriginationIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPoolOriginationIdentitiesInput {
                pool_id: self.pool_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPoolOriginationIdentitiesInputOperationOutputAlias =
    crate::operation::ListPoolOriginationIdentities;
#[doc(hidden)]
pub type ListPoolOriginationIdentitiesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListPoolOriginationIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListPoolOriginationIdentities`](crate::operation::ListPoolOriginationIdentities)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPoolOriginationIdentities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPoolOriginationIdentitiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPoolOriginationIdentitiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.ListPoolOriginationIdentities",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pool_origination_identities(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPoolOriginationIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPoolOriginationIdentities",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPoolOriginationIdentitiesInput`](crate::input::ListPoolOriginationIdentitiesInput)
    pub fn builder() -> crate::input::list_pool_origination_identities_input::Builder {
        crate::input::list_pool_origination_identities_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutKeywordInput`](crate::input::PutKeywordInput)
pub mod put_keyword_input {
    /// A builder for [`PutKeywordInput`](crate::input::PutKeywordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) keyword: std::option::Option<std::string::String>,
        pub(crate) keyword_message: std::option::Option<std::string::String>,
        pub(crate) keyword_action: std::option::Option<crate::model::KeywordAction>,
    }
    impl Builder {
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The new keyword to add.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>The new keyword to add.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// <p>The message associated with the keyword.</p>
        /// <ul>
        /// <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>
        /// <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>
        /// <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>
        /// </ul>
        pub fn keyword_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword_message = Some(input.into());
            self
        }
        /// <p>The message associated with the keyword.</p>
        /// <ul>
        /// <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>
        /// <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>
        /// <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>
        /// </ul>
        pub fn set_keyword_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyword_message = input;
            self
        }
        /// <p>The action to perform for the new keyword when it is received.</p>
        pub fn keyword_action(mut self, input: crate::model::KeywordAction) -> Self {
            self.keyword_action = Some(input);
            self
        }
        /// <p>The action to perform for the new keyword when it is received.</p>
        pub fn set_keyword_action(
            mut self,
            input: std::option::Option<crate::model::KeywordAction>,
        ) -> Self {
            self.keyword_action = input;
            self
        }
        /// Consumes the builder and constructs a [`PutKeywordInput`](crate::input::PutKeywordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutKeywordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutKeywordInput {
                origination_identity: self.origination_identity,
                keyword: self.keyword,
                keyword_message: self.keyword_message,
                keyword_action: self.keyword_action,
            })
        }
    }
}
#[doc(hidden)]
pub type PutKeywordInputOperationOutputAlias = crate::operation::PutKeyword;
#[doc(hidden)]
pub type PutKeywordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutKeywordInput {
    /// Consumes the builder and constructs an Operation<[`PutKeyword`](crate::operation::PutKeyword)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutKeyword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutKeywordInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutKeywordInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.PutKeyword",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_keyword(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutKeyword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutKeyword",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutKeywordInput`](crate::input::PutKeywordInput)
    pub fn builder() -> crate::input::put_keyword_input::Builder {
        crate::input::put_keyword_input::Builder::default()
    }
}

/// See [`PutOptedOutNumberInput`](crate::input::PutOptedOutNumberInput)
pub mod put_opted_out_number_input {
    /// A builder for [`PutOptedOutNumberInput`](crate::input::PutOptedOutNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) opted_out_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The phone number to add to the OptOutList in E.164 format.</p>
        pub fn opted_out_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.opted_out_number = Some(input.into());
            self
        }
        /// <p>The phone number to add to the OptOutList in E.164 format.</p>
        pub fn set_opted_out_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opted_out_number = input;
            self
        }
        /// Consumes the builder and constructs a [`PutOptedOutNumberInput`](crate::input::PutOptedOutNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutOptedOutNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutOptedOutNumberInput {
                opt_out_list_name: self.opt_out_list_name,
                opted_out_number: self.opted_out_number,
            })
        }
    }
}
#[doc(hidden)]
pub type PutOptedOutNumberInputOperationOutputAlias = crate::operation::PutOptedOutNumber;
#[doc(hidden)]
pub type PutOptedOutNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutOptedOutNumberInput {
    /// Consumes the builder and constructs an Operation<[`PutOptedOutNumber`](crate::operation::PutOptedOutNumber)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutOptedOutNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutOptedOutNumberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutOptedOutNumberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.PutOptedOutNumber",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_opted_out_number(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutOptedOutNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutOptedOutNumber",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutOptedOutNumberInput`](crate::input::PutOptedOutNumberInput)
    pub fn builder() -> crate::input::put_opted_out_number_input::Builder {
        crate::input::put_opted_out_number_input::Builder::default()
    }
}

/// See [`ReleasePhoneNumberInput`](crate::input::ReleasePhoneNumberInput)
pub mod release_phone_number_input {
    /// A builder for [`ReleasePhoneNumberInput`](crate::input::ReleasePhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReleasePhoneNumberInput`](crate::input::ReleasePhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ReleasePhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ReleasePhoneNumberInput {
                phone_number_id: self.phone_number_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ReleasePhoneNumberInputOperationOutputAlias = crate::operation::ReleasePhoneNumber;
#[doc(hidden)]
pub type ReleasePhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ReleasePhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`ReleasePhoneNumber`](crate::operation::ReleasePhoneNumber)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ReleasePhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ReleasePhoneNumberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ReleasePhoneNumberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.ReleasePhoneNumber",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_release_phone_number(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ReleasePhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ReleasePhoneNumber",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ReleasePhoneNumberInput`](crate::input::ReleasePhoneNumberInput)
    pub fn builder() -> crate::input::release_phone_number_input::Builder {
        crate::input::release_phone_number_input::Builder::default()
    }
}

/// See [`RequestPhoneNumberInput`](crate::input::RequestPhoneNumberInput)
pub mod request_phone_number_input {
    /// A builder for [`RequestPhoneNumberInput`](crate::input::RequestPhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iso_country_code: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        pub(crate) number_type: std::option::Option<crate::model::RequestableNumberType>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) registration_id: std::option::Option<std::string::String>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn iso_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
        pub fn set_iso_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso_country_code = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// <p>The type of phone number to request.</p>
        pub fn number_type(mut self, input: crate::model::RequestableNumberType) -> Self {
            self.number_type = Some(input);
            self
        }
        /// <p>The type of phone number to request.</p>
        pub fn set_number_type(
            mut self,
            input: std::option::Option<crate::model::RequestableNumberType>,
        ) -> Self {
            self.number_type = input;
            self
        }
        /// <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>Use this field to attach your phone number for an external registration process.</p>
        pub fn registration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registration_id = Some(input.into());
            self
        }
        /// <p>Use this field to attach your phone number for an external registration process.</p>
        pub fn set_registration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registration_id = input;
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestPhoneNumberInput`](crate::input::RequestPhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RequestPhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RequestPhoneNumberInput {
                iso_country_code: self.iso_country_code,
                message_type: self.message_type,
                number_capabilities: self.number_capabilities,
                number_type: self.number_type,
                opt_out_list_name: self.opt_out_list_name,
                pool_id: self.pool_id,
                registration_id: self.registration_id,
                deletion_protection_enabled: self.deletion_protection_enabled,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type RequestPhoneNumberInputOperationOutputAlias = crate::operation::RequestPhoneNumber;
#[doc(hidden)]
pub type RequestPhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RequestPhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`RequestPhoneNumber`](crate::operation::RequestPhoneNumber)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RequestPhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::RequestPhoneNumberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RequestPhoneNumberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.RequestPhoneNumber",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_request_phone_number(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RequestPhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RequestPhoneNumber",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RequestPhoneNumberInput`](crate::input::RequestPhoneNumberInput)
    pub fn builder() -> crate::input::request_phone_number_input::Builder {
        crate::input::request_phone_number_input::Builder::default()
    }
}

/// See [`SendTextMessageInput`](crate::input::SendTextMessageInput)
pub mod send_text_message_input {
    /// A builder for [`SendTextMessageInput`](crate::input::SendTextMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_phone_number: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) message_body: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) keyword: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) max_price: std::option::Option<std::string::String>,
        pub(crate) time_to_live: std::option::Option<i32>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) destination_country_parameters: std::option::Option<
            std::collections::HashMap<
                crate::model::DestinationCountryParameterKey,
                std::string::String,
            >,
        >,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The destination phone number in E.164 format.</p>
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_phone_number = Some(input.into());
            self
        }
        /// <p>The destination phone number in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_phone_number = input;
            self
        }
        /// <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The body of the text message.</p>
        pub fn message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_body = Some(input.into());
            self
        }
        /// <p>The body of the text message.</p>
        pub fn set_message_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_body = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
        pub fn max_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_price = Some(input.into());
            self
        }
        /// <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
        pub fn set_max_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_price = input;
            self
        }
        /// <p>How long the text message is valid for. By default this is 72 hours.</p>
        pub fn time_to_live(mut self, input: i32) -> Self {
            self.time_to_live = Some(input);
            self
        }
        /// <p>How long the text message is valid for. By default this is 72 hours.</p>
        pub fn set_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// Adds a key-value pair to `destination_country_parameters`.
        ///
        /// To override the contents of this collection use [`set_destination_country_parameters`](Self::set_destination_country_parameters).
        ///
        /// <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
        pub fn destination_country_parameters(
            mut self,
            k: crate::model::DestinationCountryParameterKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.destination_country_parameters.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.destination_country_parameters = Some(hash_map);
            self
        }
        /// <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
        pub fn set_destination_country_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DestinationCountryParameterKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.destination_country_parameters = input;
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTextMessageInput`](crate::input::SendTextMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendTextMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendTextMessageInput {
                destination_phone_number: self.destination_phone_number,
                origination_identity: self.origination_identity,
                message_body: self.message_body,
                message_type: self.message_type,
                keyword: self.keyword,
                configuration_set_name: self.configuration_set_name,
                max_price: self.max_price,
                time_to_live: self.time_to_live,
                context: self.context,
                destination_country_parameters: self.destination_country_parameters,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SendTextMessageInputOperationOutputAlias = crate::operation::SendTextMessage;
#[doc(hidden)]
pub type SendTextMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendTextMessageInput {
    /// Consumes the builder and constructs an Operation<[`SendTextMessage`](crate::operation::SendTextMessage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendTextMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendTextMessageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendTextMessageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.SendTextMessage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_text_message(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendTextMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendTextMessage",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendTextMessageInput`](crate::input::SendTextMessageInput)
    pub fn builder() -> crate::input::send_text_message_input::Builder {
        crate::input::send_text_message_input::Builder::default()
    }
}

/// See [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
pub mod send_voice_message_input {
    /// A builder for [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_phone_number: std::option::Option<std::string::String>,
        pub(crate) origination_identity: std::option::Option<std::string::String>,
        pub(crate) message_body: std::option::Option<std::string::String>,
        pub(crate) message_body_text_type:
            std::option::Option<crate::model::VoiceMessageBodyTextType>,
        pub(crate) voice_id: std::option::Option<crate::model::VoiceId>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) max_price_per_minute: std::option::Option<std::string::String>,
        pub(crate) time_to_live: std::option::Option<i32>,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The destination phone number in E.164 format.</p>
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_phone_number = Some(input.into());
            self
        }
        /// <p>The destination phone number in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_phone_number = input;
            self
        }
        /// <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
        pub fn origination_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_identity = Some(input.into());
            self
        }
        /// <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
        pub fn set_origination_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_identity = input;
            self
        }
        /// <p>The text to convert to a voice message.</p>
        pub fn message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_body = Some(input.into());
            self
        }
        /// <p>The text to convert to a voice message.</p>
        pub fn set_message_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_body = input;
            self
        }
        /// <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>
        /// <ul>
        /// <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>
        /// <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>
        /// </ul>
        pub fn message_body_text_type(
            mut self,
            input: crate::model::VoiceMessageBodyTextType,
        ) -> Self {
            self.message_body_text_type = Some(input);
            self
        }
        /// <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>
        /// <ul>
        /// <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>
        /// <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>
        /// </ul>
        pub fn set_message_body_text_type(
            mut self,
            input: std::option::Option<crate::model::VoiceMessageBodyTextType>,
        ) -> Self {
            self.message_body_text_type = input;
            self
        }
        /// <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
        pub fn voice_id(mut self, input: crate::model::VoiceId) -> Self {
            self.voice_id = Some(input);
            self
        }
        /// <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
        pub fn set_voice_id(mut self, input: std::option::Option<crate::model::VoiceId>) -> Self {
            self.voice_id = input;
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The maximum amount to spend per voice message, in US dollars.</p>
        pub fn max_price_per_minute(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_price_per_minute = Some(input.into());
            self
        }
        /// <p>The maximum amount to spend per voice message, in US dollars.</p>
        pub fn set_max_price_per_minute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_price_per_minute = input;
            self
        }
        /// <p>How long the voice message is valid for. By default this is 72 hours.</p>
        pub fn time_to_live(mut self, input: i32) -> Self {
            self.time_to_live = Some(input);
            self
        }
        /// <p>How long the voice message is valid for. By default this is 72 hours.</p>
        pub fn set_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendVoiceMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendVoiceMessageInput {
                destination_phone_number: self.destination_phone_number,
                origination_identity: self.origination_identity,
                message_body: self.message_body,
                message_body_text_type: self.message_body_text_type,
                voice_id: self.voice_id,
                configuration_set_name: self.configuration_set_name,
                max_price_per_minute: self.max_price_per_minute,
                time_to_live: self.time_to_live,
                context: self.context,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SendVoiceMessageInputOperationOutputAlias = crate::operation::SendVoiceMessage;
#[doc(hidden)]
pub type SendVoiceMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendVoiceMessageInput {
    /// Consumes the builder and constructs an Operation<[`SendVoiceMessage`](crate::operation::SendVoiceMessage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendVoiceMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendVoiceMessageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendVoiceMessageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.SendVoiceMessage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_voice_message(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendVoiceMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendVoiceMessage",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
    pub fn builder() -> crate::input::send_voice_message_input::Builder {
        crate::input::send_voice_message_input::Builder::default()
    }
}

/// See [`SetDefaultMessageTypeInput`](crate::input::SetDefaultMessageTypeInput)
pub mod set_default_message_type_input {
    /// A builder for [`SetDefaultMessageTypeInput`](crate::input::SetDefaultMessageTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
    }
    impl Builder {
        /// <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDefaultMessageTypeInput`](crate::input::SetDefaultMessageTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetDefaultMessageTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetDefaultMessageTypeInput {
                configuration_set_name: self.configuration_set_name,
                message_type: self.message_type,
            })
        }
    }
}
#[doc(hidden)]
pub type SetDefaultMessageTypeInputOperationOutputAlias = crate::operation::SetDefaultMessageType;
#[doc(hidden)]
pub type SetDefaultMessageTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetDefaultMessageTypeInput {
    /// Consumes the builder and constructs an Operation<[`SetDefaultMessageType`](crate::operation::SetDefaultMessageType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetDefaultMessageType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetDefaultMessageTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetDefaultMessageTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.SetDefaultMessageType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_default_message_type(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetDefaultMessageType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetDefaultMessageType",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetDefaultMessageTypeInput`](crate::input::SetDefaultMessageTypeInput)
    pub fn builder() -> crate::input::set_default_message_type_input::Builder {
        crate::input::set_default_message_type_input::Builder::default()
    }
}

/// See [`SetDefaultSenderIdInput`](crate::input::SetDefaultSenderIdInput)
pub mod set_default_sender_id_input {
    /// A builder for [`SetDefaultSenderIdInput`](crate::input::SetDefaultSenderIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDefaultSenderIdInput`](crate::input::SetDefaultSenderIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetDefaultSenderIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetDefaultSenderIdInput {
                configuration_set_name: self.configuration_set_name,
                sender_id: self.sender_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SetDefaultSenderIdInputOperationOutputAlias = crate::operation::SetDefaultSenderId;
#[doc(hidden)]
pub type SetDefaultSenderIdInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetDefaultSenderIdInput {
    /// Consumes the builder and constructs an Operation<[`SetDefaultSenderId`](crate::operation::SetDefaultSenderId)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetDefaultSenderId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetDefaultSenderIdInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetDefaultSenderIdInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.SetDefaultSenderId",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_default_sender_id(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetDefaultSenderId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetDefaultSenderId",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetDefaultSenderIdInput`](crate::input::SetDefaultSenderIdInput)
    pub fn builder() -> crate::input::set_default_sender_id_input::Builder {
        crate::input::set_default_sender_id_input::Builder::default()
    }
}

/// See [`SetTextMessageSpendLimitOverrideInput`](crate::input::SetTextMessageSpendLimitOverrideInput)
pub mod set_text_message_spend_limit_override_input {
    /// A builder for [`SetTextMessageSpendLimitOverrideInput`](crate::input::SetTextMessageSpendLimitOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The new monthly limit to enforce on text messages.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.monthly_limit = Some(input);
            self
        }
        /// <p>The new monthly limit to enforce on text messages.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.monthly_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTextMessageSpendLimitOverrideInput`](crate::input::SetTextMessageSpendLimitOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTextMessageSpendLimitOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTextMessageSpendLimitOverrideInput {
                monthly_limit: self.monthly_limit,
            })
        }
    }
}
#[doc(hidden)]
pub type SetTextMessageSpendLimitOverrideInputOperationOutputAlias =
    crate::operation::SetTextMessageSpendLimitOverride;
#[doc(hidden)]
pub type SetTextMessageSpendLimitOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl SetTextMessageSpendLimitOverrideInput {
    /// Consumes the builder and constructs an Operation<[`SetTextMessageSpendLimitOverride`](crate::operation::SetTextMessageSpendLimitOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTextMessageSpendLimitOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetTextMessageSpendLimitOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetTextMessageSpendLimitOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.SetTextMessageSpendLimitOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_text_message_spend_limit_override(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTextMessageSpendLimitOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTextMessageSpendLimitOverride",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetTextMessageSpendLimitOverrideInput`](crate::input::SetTextMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::set_text_message_spend_limit_override_input::Builder {
        crate::input::set_text_message_spend_limit_override_input::Builder::default()
    }
}

/// See [`SetVoiceMessageSpendLimitOverrideInput`](crate::input::SetVoiceMessageSpendLimitOverrideInput)
pub mod set_voice_message_spend_limit_override_input {
    /// A builder for [`SetVoiceMessageSpendLimitOverrideInput`](crate::input::SetVoiceMessageSpendLimitOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The new monthly limit to enforce on voice messages.</p>
        pub fn monthly_limit(mut self, input: i64) -> Self {
            self.monthly_limit = Some(input);
            self
        }
        /// <p>The new monthly limit to enforce on voice messages.</p>
        pub fn set_monthly_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.monthly_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`SetVoiceMessageSpendLimitOverrideInput`](crate::input::SetVoiceMessageSpendLimitOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetVoiceMessageSpendLimitOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetVoiceMessageSpendLimitOverrideInput {
                monthly_limit: self.monthly_limit,
            })
        }
    }
}
#[doc(hidden)]
pub type SetVoiceMessageSpendLimitOverrideInputOperationOutputAlias =
    crate::operation::SetVoiceMessageSpendLimitOverride;
#[doc(hidden)]
pub type SetVoiceMessageSpendLimitOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl SetVoiceMessageSpendLimitOverrideInput {
    /// Consumes the builder and constructs an Operation<[`SetVoiceMessageSpendLimitOverride`](crate::operation::SetVoiceMessageSpendLimitOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetVoiceMessageSpendLimitOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetVoiceMessageSpendLimitOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetVoiceMessageSpendLimitOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.SetVoiceMessageSpendLimitOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_voice_message_spend_limit_override(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetVoiceMessageSpendLimitOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetVoiceMessageSpendLimitOverride",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetVoiceMessageSpendLimitOverrideInput`](crate::input::SetVoiceMessageSpendLimitOverrideInput)
    pub fn builder() -> crate::input::set_voice_message_spend_limit_override_input::Builder {
        crate::input::set_voice_message_spend_limit_override_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key and value pair tags that are associated with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of key and value pair tags that are associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag key values to unassociate with the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>An array of tag key values to unassociate with the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateEventDestinationInput`](crate::input::UpdateEventDestinationInput)
pub mod update_event_destination_input {
    /// A builder for [`UpdateEventDestinationInput`](crate::input::UpdateEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) cloud_watch_logs_destination:
            std::option::Option<crate::model::CloudWatchLogsDestination>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
    }
    impl Builder {
        /// <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The name to use for the event destination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name to use for the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// <p>When set to true logging is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>When set to true logging is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>An array of event types that determine which events to log.</p>
        pub fn matching_event_types(mut self, input: crate::model::EventType) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input);
            self.matching_event_types = Some(v);
            self
        }
        /// <p>An array of event types that determine which events to log.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.cloud_watch_logs_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.cloud_watch_logs_destination = input;
            self
        }
        /// <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventDestinationInput`](crate::input::UpdateEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                enabled: self.enabled,
                matching_event_types: self.matching_event_types,
                cloud_watch_logs_destination: self.cloud_watch_logs_destination,
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                sns_destination: self.sns_destination,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEventDestinationInputOperationOutputAlias = crate::operation::UpdateEventDestination;
#[doc(hidden)]
pub type UpdateEventDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEventDestination`](crate::operation::UpdateEventDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEventDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEventDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEventDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.UpdateEventDestination",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_event_destination(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEventDestination",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEventDestinationInput`](crate::input::UpdateEventDestinationInput)
    pub fn builder() -> crate::input::update_event_destination_input::Builder {
        crate::input::update_event_destination_input::Builder::default()
    }
}

/// See [`UpdatePhoneNumberInput`](crate::input::UpdatePhoneNumberInput)
pub mod update_phone_number_input {
    /// A builder for [`UpdatePhoneNumberInput`](crate::input::UpdatePhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePhoneNumberInput`](crate::input::UpdatePhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePhoneNumberInput {
                phone_number_id: self.phone_number_id,
                two_way_enabled: self.two_way_enabled,
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self.self_managed_opt_outs_enabled,
                opt_out_list_name: self.opt_out_list_name,
                deletion_protection_enabled: self.deletion_protection_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePhoneNumberInputOperationOutputAlias = crate::operation::UpdatePhoneNumber;
#[doc(hidden)]
pub type UpdatePhoneNumberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePhoneNumber`](crate::operation::UpdatePhoneNumber)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePhoneNumber,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePhoneNumberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePhoneNumberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.UpdatePhoneNumber",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_phone_number(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePhoneNumber",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePhoneNumberInput`](crate::input::UpdatePhoneNumberInput)
    pub fn builder() -> crate::input::update_phone_number_input::Builder {
        crate::input::update_phone_number_input::Builder::default()
    }
}

/// See [`UpdatePoolInput`](crate::input::UpdatePoolInput)
pub mod update_pool_input {
    /// A builder for [`UpdatePoolInput`](crate::input::UpdatePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_id: std::option::Option<std::string::String>,
        pub(crate) two_way_enabled: std::option::Option<bool>,
        pub(crate) two_way_channel_arn: std::option::Option<std::string::String>,
        pub(crate) self_managed_opt_outs_enabled: std::option::Option<bool>,
        pub(crate) opt_out_list_name: std::option::Option<std::string::String>,
        pub(crate) shared_routes_enabled: std::option::Option<bool>,
        pub(crate) deletion_protection_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
        pub fn pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
        pub fn set_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_id = input;
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn two_way_enabled(mut self, input: bool) -> Self {
            self.two_way_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
        pub fn set_two_way_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.two_way_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn two_way_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.two_way_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
        pub fn set_two_way_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.two_way_channel_arn = input;
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn self_managed_opt_outs_enabled(mut self, input: bool) -> Self {
            self.self_managed_opt_outs_enabled = Some(input);
            self
        }
        /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
        pub fn set_self_managed_opt_outs_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.self_managed_opt_outs_enabled = input;
            self
        }
        /// <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
        pub fn opt_out_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out_list_name = Some(input.into());
            self
        }
        /// <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
        pub fn set_opt_out_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_out_list_name = input;
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn shared_routes_enabled(mut self, input: bool) -> Self {
            self.shared_routes_enabled = Some(input);
            self
        }
        /// <p>Indicates whether shared routes are enabled for the pool.</p>
        pub fn set_shared_routes_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.shared_routes_enabled = input;
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn deletion_protection_enabled(mut self, input: bool) -> Self {
            self.deletion_protection_enabled = Some(input);
            self
        }
        /// <p>When set to true the pool can't be deleted.</p>
        pub fn set_deletion_protection_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePoolInput`](crate::input::UpdatePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePoolInput {
                pool_id: self.pool_id,
                two_way_enabled: self.two_way_enabled,
                two_way_channel_arn: self.two_way_channel_arn,
                self_managed_opt_outs_enabled: self.self_managed_opt_outs_enabled,
                opt_out_list_name: self.opt_out_list_name,
                shared_routes_enabled: self.shared_routes_enabled,
                deletion_protection_enabled: self.deletion_protection_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePoolInputOperationOutputAlias = crate::operation::UpdatePool;
#[doc(hidden)]
pub type UpdatePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePoolInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePool`](crate::operation::UpdatePool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PinpointSMSVoiceV2.UpdatePool",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePool",
            "pinpointsmsvoicev2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePoolInput`](crate::input::UpdatePoolInput)
    pub fn builder() -> crate::input::update_pool_input::Builder {
        crate::input::update_pool_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePoolInput {
    /// <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: std::option::Option<bool>,
    /// <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub shared_routes_enabled: std::option::Option<bool>,
    /// <p>When set to true the pool can't be deleted.</p>
    pub deletion_protection_enabled: std::option::Option<bool>,
}
impl UpdatePoolInput {
    /// <p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> std::option::Option<bool> {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> std::option::Option<bool> {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>Indicates whether shared routes are enabled for the pool.</p>
    pub fn shared_routes_enabled(&self) -> std::option::Option<bool> {
        self.shared_routes_enabled
    }
    /// <p>When set to true the pool can't be deleted.</p>
    pub fn deletion_protection_enabled(&self) -> std::option::Option<bool> {
        self.deletion_protection_enabled
    }
}
impl std::fmt::Debug for UpdatePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePoolInput");
        formatter.field("pool_id", &self.pool_id);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("shared_routes_enabled", &self.shared_routes_enabled);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePhoneNumberInput {
    /// <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub two_way_enabled: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub two_way_channel_arn: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub self_managed_opt_outs_enabled: std::option::Option<bool>,
    /// <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
    pub deletion_protection_enabled: std::option::Option<bool>,
}
impl UpdatePhoneNumberInput {
    /// <p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>
    pub fn two_way_enabled(&self) -> std::option::Option<bool> {
        self.two_way_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the two way channel.</p>
    pub fn two_way_channel_arn(&self) -> std::option::Option<&str> {
        self.two_way_channel_arn.as_deref()
    }
    /// <p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.</p>
    pub fn self_managed_opt_outs_enabled(&self) -> std::option::Option<bool> {
        self.self_managed_opt_outs_enabled
    }
    /// <p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>By default this is set to false. When set to true the phone number can't be deleted. </p>
    pub fn deletion_protection_enabled(&self) -> std::option::Option<bool> {
        self.deletion_protection_enabled
    }
}
impl std::fmt::Debug for UpdatePhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePhoneNumberInput");
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("two_way_enabled", &self.two_way_enabled);
        formatter.field("two_way_channel_arn", &self.two_way_channel_arn);
        formatter.field(
            "self_managed_opt_outs_enabled",
            &self.self_managed_opt_outs_enabled,
        );
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventDestinationInput {
    /// <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The name to use for the event destination.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    /// <p>When set to true logging is enabled.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>An array of event types that determine which events to log.</p>
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
    pub cloud_watch_logs_destination: std::option::Option<crate::model::CloudWatchLogsDestination>,
    /// <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
}
impl UpdateEventDestinationInput {
    /// <p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The name to use for the event destination.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
    /// <p>When set to true logging is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>An array of event types that determine which events to log.</p>
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// <p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>
    pub fn cloud_watch_logs_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestination> {
        self.cloud_watch_logs_destination.as_ref()
    }
    /// <p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// <p>An object that contains information about an event destination that sends data to Amazon SNS.</p>
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
}
impl std::fmt::Debug for UpdateEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("enabled", &self.enabled);
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field(
            "cloud_watch_logs_destination",
            &self.cloud_watch_logs_destination,
        );
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("sns_destination", &self.sns_destination);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of tag key values to unassociate with the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of tag key values to unassociate with the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of key and value pair tags that are associated with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of key and value pair tags that are associated with the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVoiceMessageSpendLimitOverrideInput {
    /// <p>The new monthly limit to enforce on voice messages.</p>
    pub monthly_limit: std::option::Option<i64>,
}
impl SetVoiceMessageSpendLimitOverrideInput {
    /// <p>The new monthly limit to enforce on voice messages.</p>
    pub fn monthly_limit(&self) -> std::option::Option<i64> {
        self.monthly_limit
    }
}
impl std::fmt::Debug for SetVoiceMessageSpendLimitOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVoiceMessageSpendLimitOverrideInput");
        formatter.field("monthly_limit", &self.monthly_limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTextMessageSpendLimitOverrideInput {
    /// <p>The new monthly limit to enforce on text messages.</p>
    pub monthly_limit: std::option::Option<i64>,
}
impl SetTextMessageSpendLimitOverrideInput {
    /// <p>The new monthly limit to enforce on text messages.</p>
    pub fn monthly_limit(&self) -> std::option::Option<i64> {
        self.monthly_limit
    }
}
impl std::fmt::Debug for SetTextMessageSpendLimitOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTextMessageSpendLimitOverrideInput");
        formatter.field("monthly_limit", &self.monthly_limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultSenderIdInput {
    /// <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
    pub sender_id: std::option::Option<std::string::String>,
}
impl SetDefaultSenderIdInput {
    /// <p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <code>SendTextMessage</code> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as 'NOTICE'.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
}
impl std::fmt::Debug for SetDefaultSenderIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultSenderIdInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("sender_id", &self.sender_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultMessageTypeInput {
    /// <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
}
impl SetDefaultMessageTypeInput {
    /// <p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
}
impl std::fmt::Debug for SetDefaultMessageTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultMessageTypeInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message_type", &self.message_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendVoiceMessageInput {
    /// <p>The destination phone number in E.164 format.</p>
    pub destination_phone_number: std::option::Option<std::string::String>,
    /// <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The text to convert to a voice message.</p>
    pub message_body: std::option::Option<std::string::String>,
    /// <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>
    /// <ul>
    /// <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>
    /// <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>
    /// </ul>
    pub message_body_text_type: std::option::Option<crate::model::VoiceMessageBodyTextType>,
    /// <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
    pub voice_id: std::option::Option<crate::model::VoiceId>,
    /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The maximum amount to spend per voice message, in US dollars.</p>
    pub max_price_per_minute: std::option::Option<std::string::String>,
    /// <p>How long the voice message is valid for. By default this is 72 hours.</p>
    pub time_to_live: std::option::Option<i32>,
    /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
    pub dry_run: bool,
}
impl SendVoiceMessageInput {
    /// <p>The destination phone number in E.164 format.</p>
    pub fn destination_phone_number(&self) -> std::option::Option<&str> {
        self.destination_phone_number.as_deref()
    }
    /// <p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The text to convert to a voice message.</p>
    pub fn message_body(&self) -> std::option::Option<&str> {
        self.message_body.as_deref()
    }
    /// <p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p>
    /// <ul>
    /// <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li>
    /// <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li>
    /// </ul>
    pub fn message_body_text_type(
        &self,
    ) -> std::option::Option<&crate::model::VoiceMessageBodyTextType> {
        self.message_body_text_type.as_ref()
    }
    /// <p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>
    pub fn voice_id(&self) -> std::option::Option<&crate::model::VoiceId> {
        self.voice_id.as_ref()
    }
    /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The maximum amount to spend per voice message, in US dollars.</p>
    pub fn max_price_per_minute(&self) -> std::option::Option<&str> {
        self.max_price_per_minute.as_deref()
    }
    /// <p>How long the voice message is valid for. By default this is 72 hours.</p>
    pub fn time_to_live(&self) -> std::option::Option<i32> {
        self.time_to_live
    }
    /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
    pub fn context(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.context.as_ref()
    }
    /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for SendVoiceMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendVoiceMessageInput");
        formatter.field("destination_phone_number", &self.destination_phone_number);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("message_body", &self.message_body);
        formatter.field("message_body_text_type", &self.message_body_text_type);
        formatter.field("voice_id", &self.voice_id);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("max_price_per_minute", &self.max_price_per_minute);
        formatter.field("time_to_live", &self.time_to_live);
        formatter.field("context", &self.context);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTextMessageInput {
    /// <p>The destination phone number in E.164 format.</p>
    pub destination_phone_number: std::option::Option<std::string::String>,
    /// <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The body of the text message.</p>
    pub message_body: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
    pub keyword: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
    pub max_price: std::option::Option<std::string::String>,
    /// <p>How long the text message is valid for. By default this is 72 hours.</p>
    pub time_to_live: std::option::Option<i32>,
    /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
    pub destination_country_parameters: std::option::Option<
        std::collections::HashMap<
            crate::model::DestinationCountryParameterKey,
            std::string::String,
        >,
    >,
    /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
    pub dry_run: bool,
}
impl SendTextMessageInput {
    /// <p>The destination phone number in E.164 format.</p>
    pub fn destination_phone_number(&self) -> std::option::Option<&str> {
        self.destination_phone_number.as_deref()
    }
    /// <p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The body of the text message.</p>
    pub fn message_body(&self) -> std::option::Option<&str> {
        self.message_body.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
    /// <p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>
    pub fn max_price(&self) -> std::option::Option<&str> {
        self.max_price.as_deref()
    }
    /// <p>How long the text message is valid for. By default this is 72 hours.</p>
    pub fn time_to_live(&self) -> std::option::Option<i32> {
        self.time_to_live
    }
    /// <p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>
    pub fn context(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.context.as_ref()
    }
    /// <p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>
    pub fn destination_country_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::DestinationCountryParameterKey,
            std::string::String,
        >,
    > {
        self.destination_country_parameters.as_ref()
    }
    /// <p>When set to true, the message is checked and validated, but isn't sent to the end recipient.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for SendTextMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTextMessageInput");
        formatter.field("destination_phone_number", &self.destination_phone_number);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("message_body", &self.message_body);
        formatter.field("message_type", &self.message_type);
        formatter.field("keyword", &self.keyword);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("max_price", &self.max_price);
        formatter.field("time_to_live", &self.time_to_live);
        formatter.field("context", &self.context);
        formatter.field(
            "destination_country_parameters",
            &self.destination_country_parameters,
        );
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestPhoneNumberInput {
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    /// <p>The type of phone number to request.</p>
    pub number_type: std::option::Option<crate::model::RequestableNumberType>,
    /// <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>Use this field to attach your phone number for an external registration process.</p>
    pub registration_id: std::option::Option<std::string::String>,
    /// <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
    pub deletion_protection_enabled: std::option::Option<bool>,
    /// <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl RequestPhoneNumberInput {
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
    /// <p>The type of phone number to request.</p>
    pub fn number_type(&self) -> std::option::Option<&crate::model::RequestableNumberType> {
        self.number_type.as_ref()
    }
    /// <p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>Use this field to attach your phone number for an external registration process.</p>
    pub fn registration_id(&self) -> std::option::Option<&str> {
        self.registration_id.as_deref()
    }
    /// <p>By default this is set to false. When set to true the phone number can't be deleted.</p>
    pub fn deletion_protection_enabled(&self) -> std::option::Option<bool> {
        self.deletion_protection_enabled
    }
    /// <p>An array of tags (key and value pairs) associate with the requested phone number. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for RequestPhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestPhoneNumberInput");
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_type", &self.message_type);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.field("number_type", &self.number_type);
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("pool_id", &self.pool_id);
        formatter.field("registration_id", &self.registration_id);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReleasePhoneNumberInput {
    /// <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
}
impl ReleasePhoneNumberInput {
    /// <p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <code>DescribePhoneNumbers</code> to get the values for PhoneNumberId and PhoneNumberArn.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
}
impl std::fmt::Debug for ReleasePhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReleasePhoneNumberInput");
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutOptedOutNumberInput {
    /// <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The phone number to add to the OptOutList in E.164 format.</p>
    pub opted_out_number: std::option::Option<std::string::String>,
}
impl PutOptedOutNumberInput {
    /// <p>The OptOutListName or OptOutListArn to add the phone number to.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The phone number to add to the OptOutList in E.164 format.</p>
    pub fn opted_out_number(&self) -> std::option::Option<&str> {
        self.opted_out_number.as_deref()
    }
}
impl std::fmt::Debug for PutOptedOutNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutOptedOutNumberInput");
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("opted_out_number", &self.opted_out_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutKeywordInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The new keyword to add.</p>
    pub keyword: std::option::Option<std::string::String>,
    /// <p>The message associated with the keyword.</p>
    /// <ul>
    /// <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>
    /// <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>
    /// <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>
    /// </ul>
    pub keyword_message: std::option::Option<std::string::String>,
    /// <p>The action to perform for the new keyword when it is received.</p>
    pub keyword_action: std::option::Option<crate::model::KeywordAction>,
}
impl PutKeywordInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> get the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The new keyword to add.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
    /// <p>The message associated with the keyword.</p>
    /// <ul>
    /// <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li>
    /// <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li>
    /// <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li>
    /// </ul>
    pub fn keyword_message(&self) -> std::option::Option<&str> {
        self.keyword_message.as_deref()
    }
    /// <p>The action to perform for the new keyword when it is received.</p>
    pub fn keyword_action(&self) -> std::option::Option<&crate::model::KeywordAction> {
        self.keyword_action.as_ref()
    }
}
impl std::fmt::Debug for PutKeywordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutKeywordInput");
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("keyword", &self.keyword);
        formatter.field("keyword_message", &self.keyword_message);
        formatter.field("keyword_action", &self.keyword_action);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to query for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoolOriginationIdentitiesInput {
    /// <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::PoolOriginationIdentitiesFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPoolOriginationIdentitiesInput {
    /// <p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::PoolOriginationIdentitiesFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPoolOriginationIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoolOriginationIdentitiesInput");
        formatter.field("pool_id", &self.pool_id);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateOriginationIdentityInput {
    /// <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateOriginationIdentityInput {
    /// <p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> find the values for PhoneNumberId and PhoneNumberArn, or use <code>DescribeSenderIds</code> to get the values for SenderId and SenderIdArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateOriginationIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateOriginationIdentityInput");
        formatter.field("pool_id", &self.pool_id);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSpendLimitsInput {
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeSpendLimitsInput {
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeSpendLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSpendLimitsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSenderIdsInput {
    /// <p>An array of SenderIdAndCountry objects to search for.</p>
    pub sender_ids: std::option::Option<std::vec::Vec<crate::model::SenderIdAndCountry>>,
    /// <p>An array of SenderIdFilter objects to filter the results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SenderIdFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeSenderIdsInput {
    /// <p>An array of SenderIdAndCountry objects to search for.</p>
    pub fn sender_ids(&self) -> std::option::Option<&[crate::model::SenderIdAndCountry]> {
        self.sender_ids.as_deref()
    }
    /// <p>An array of SenderIdFilter objects to filter the results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::SenderIdFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeSenderIdsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSenderIdsInput");
        formatter.field("sender_ids", &self.sender_ids);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePoolsInput {
    /// <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
    pub pool_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of PoolFilter objects to filter the results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::PoolFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribePoolsInput {
    /// <p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>
    pub fn pool_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.pool_ids.as_deref()
    }
    /// <p>An array of PoolFilter objects to filter the results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::PoolFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribePoolsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePoolsInput");
        formatter.field("pool_ids", &self.pool_ids);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePhoneNumbersInput {
    /// <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
    pub phone_number_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of PhoneNumberFilter objects to filter the results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::PhoneNumberFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribePhoneNumbersInput {
    /// <p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>
    pub fn phone_number_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.phone_number_ids.as_deref()
    }
    /// <p>An array of PhoneNumberFilter objects to filter the results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::PhoneNumberFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribePhoneNumbersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePhoneNumbersInput");
        formatter.field("phone_number_ids", &self.phone_number_ids);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOptOutListsInput {
    /// <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
    pub opt_out_list_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeOptOutListsInput {
    /// <p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>
    pub fn opt_out_list_names(&self) -> std::option::Option<&[std::string::String]> {
        self.opt_out_list_names.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeOptOutListsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOptOutListsInput");
        formatter.field("opt_out_list_names", &self.opt_out_list_names);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOptedOutNumbersInput {
    /// <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>An array of phone numbers to search for in the OptOutList.</p>
    pub opted_out_numbers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of OptedOutFilter objects to filter the results on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::OptedOutFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeOptedOutNumbersInput {
    /// <p>The OptOutListName or OptOutListArn of the OptOutList. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>An array of phone numbers to search for in the OptOutList.</p>
    pub fn opted_out_numbers(&self) -> std::option::Option<&[std::string::String]> {
        self.opted_out_numbers.as_deref()
    }
    /// <p>An array of OptedOutFilter objects to filter the results on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::OptedOutFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeOptedOutNumbersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOptedOutNumbersInput");
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("opted_out_numbers", &self.opted_out_numbers);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeKeywordsInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>An array of keywords to search for.</p>
    pub keywords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of keyword filters to filter the results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeKeywordsInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>An array of keywords to search for.</p>
    pub fn keywords(&self) -> std::option::Option<&[std::string::String]> {
        self.keywords.as_deref()
    }
    /// <p>An array of keyword filters to filter the results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::KeywordFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeKeywordsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeKeywordsInput");
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("keywords", &self.keywords);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationSetsInput {
    /// <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
    pub configuration_set_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of filters to apply to the results that are returned.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetFilter>>,
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeConfigurationSetsInput {
    /// <p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>
    pub fn configuration_set_names(&self) -> std::option::Option<&[std::string::String]> {
        self.configuration_set_names.as_deref()
    }
    /// <p>An array of filters to apply to the results that are returned.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ConfigurationSetFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeConfigurationSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationSetsInput");
        formatter.field("configuration_set_names", &self.configuration_set_names);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountLimitsInput {
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAccountLimitsInput {
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAccountLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountLimitsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesInput {
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAccountAttributesInput {
    /// <p>The token to be used for the next set of paginated results. You don't need to supply a value for this field in the initial request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAccountAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVoiceMessageSpendLimitOverrideInput {}
impl std::fmt::Debug for DeleteVoiceMessageSpendLimitOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVoiceMessageSpendLimitOverrideInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTextMessageSpendLimitOverrideInput {}
impl std::fmt::Debug for DeleteTextMessageSpendLimitOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTextMessageSpendLimitOverrideInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePoolInput {
    /// <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
    pub pool_id: std::option::Option<std::string::String>,
}
impl DeletePoolInput {
    /// <p>The PoolId or PoolArn of the pool to delete. You can use <code>DescribePools</code> to find the values for PoolId and PoolArn .</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePoolInput");
        formatter.field("pool_id", &self.pool_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOptOutListInput {
    /// <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
}
impl DeleteOptOutListInput {
    /// <p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <code>DescribeOptOutLists</code> to find the values for OptOutListName and OptOutListArn.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteOptOutListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOptOutListInput");
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOptedOutNumberInput {
    /// <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
    pub opted_out_number: std::option::Option<std::string::String>,
}
impl DeleteOptedOutNumberInput {
    /// <p>The OptOutListName or OptOutListArn to remove the phone number from.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>The phone number, in E.164 format, to remove from the OptOutList.</p>
    pub fn opted_out_number(&self) -> std::option::Option<&str> {
        self.opted_out_number.as_deref()
    }
}
impl std::fmt::Debug for DeleteOptedOutNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOptedOutNumberInput");
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("opted_out_number", &self.opted_out_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeywordInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The keyword to delete.</p>
    pub keyword: std::option::Option<std::string::String>,
}
impl DeleteKeywordInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn and <code>DescribePools</code> to find the values of PoolId and PoolArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The keyword to delete.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
}
impl std::fmt::Debug for DeleteKeywordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeywordInput");
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("keyword", &self.keyword);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventDestinationInput {
    /// <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the event destination to delete.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
}
impl DeleteEventDestinationInput {
    /// <p>The name of the configuration set or the configuration set's Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The name of the event destination to delete.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDefaultSenderIdInput {
    /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteDefaultSenderIdInput {
    /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDefaultSenderIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDefaultSenderIdInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDefaultMessageTypeInput {
    /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteDefaultMessageTypeInput {
    /// <p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDefaultMessageTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDefaultMessageTypeInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetInput {
    /// <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetInput {
    /// <p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePoolInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
    pub deletion_protection_enabled: std::option::Option<bool>,
    /// <p>An array of tags (key and value pairs) associated with the pool.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreatePoolInput {
    /// <p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>By default this is set to false. When set to true the pool can't be deleted. You can change this value using the <code>UpdatePool</code> action.</p>
    pub fn deletion_protection_enabled(&self) -> std::option::Option<bool> {
        self.deletion_protection_enabled
    }
    /// <p>An array of tags (key and value pairs) associated with the pool.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreatePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePoolInput");
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("message_type", &self.message_type);
        formatter.field(
            "deletion_protection_enabled",
            &self.deletion_protection_enabled,
        );
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOptOutListInput {
    /// <p>The name of the new OptOutList.</p>
    pub opt_out_list_name: std::option::Option<std::string::String>,
    /// <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateOptOutListInput {
    /// <p>The name of the new OptOutList.</p>
    pub fn opt_out_list_name(&self) -> std::option::Option<&str> {
        self.opt_out_list_name.as_deref()
    }
    /// <p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateOptOutListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOptOutListInput");
        formatter.field("opt_out_list_name", &self.opt_out_list_name);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventDestinationInput {
    /// <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The name that identifies the event destination.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    /// <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
    pub cloud_watch_logs_destination: std::option::Option<crate::model::CloudWatchLogsDestination>,
    /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateEventDestinationInput {
    /// <p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <code>DescribeConfigurationSets</code> action.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The name that identifies the event destination.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
    /// <p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// <p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>
    pub fn cloud_watch_logs_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestination> {
        self.cloud_watch_logs_destination.as_ref()
    }
    /// <p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// <p>An object that contains information about an event destination for logging to Amazon SNS.</p>
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field(
            "cloud_watch_logs_destination",
            &self.cloud_watch_logs_destination,
        );
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("sns_destination", &self.sns_destination);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetInput {
    /// <p>The name to use for the new configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An array of key and value pair tags that's associated with the new configuration set. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateConfigurationSetInput {
    /// <p>The name to use for the new configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An array of key and value pair tags that's associated with the new configuration set. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateOriginationIdentityInput {
    /// <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
    pub pool_id: std::option::Option<std::string::String>,
    /// <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub origination_identity: std::option::Option<std::string::String>,
    /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
    pub iso_country_code: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AssociateOriginationIdentityInput {
    /// <p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <code>DescribePools</code>.</p>
    pub fn pool_id(&self) -> std::option::Option<&str> {
        self.pool_id.as_deref()
    }
    /// <p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <code>DescribePhoneNumbers</code> to find the values for PhoneNumberId and PhoneNumberArn, while <code>DescribeSenderIds</code> can be used to get the values for SenderId and SenderIdArn.</p>
    pub fn origination_identity(&self) -> std::option::Option<&str> {
        self.origination_identity.as_deref()
    }
    /// <p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>
    pub fn iso_country_code(&self) -> std::option::Option<&str> {
        self.iso_country_code.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateOriginationIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateOriginationIdentityInput");
        formatter.field("pool_id", &self.pool_id);
        formatter.field("origination_identity", &self.origination_identity);
        formatter.field("iso_country_code", &self.iso_country_code);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
