// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Pinpoint SMS and Voice Service
///
/// Client for invoking operations on Amazon Pinpoint SMS and Voice Service. Each operation on Amazon Pinpoint SMS and Voice Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_pinpointsmsvoice::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_pinpointsmsvoice::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_pinpointsmsvoice::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSet::set_configuration_set_name): The name that you want to give the configuration set.
    /// - On success, responds with [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetError>`](crate::error::CreateConfigurationSetError)
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSetEventDestination`](crate::client::fluent_builders::CreateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_configuration_set_name): ConfigurationSetName
    ///   - [`event_destination(EventDestinationDefinition)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestinationDefinition>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination): An object that defines a single event destination.
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination_name): A name that identifies the event destination.
    /// - On success, responds with [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetEventDestinationError>`](crate::error::CreateConfigurationSetEventDestinationError)
    pub fn create_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::CreateConfigurationSetEventDestination {
        fluent_builders::CreateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::set_configuration_set_name): ConfigurationSetName
    /// - On success, responds with [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetError>`](crate::error::DeleteConfigurationSetError)
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSetEventDestination`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_configuration_set_name): ConfigurationSetName
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_event_destination_name): EventDestinationName
    /// - On success, responds with [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetEventDestinationError>`](crate::error::DeleteConfigurationSetEventDestinationError)
    pub fn delete_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetEventDestination {
        fluent_builders::DeleteConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfigurationSetEventDestinations`](crate::client::fluent_builders::GetConfigurationSetEventDestinations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationSetEventDestinations::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::GetConfigurationSetEventDestinations::set_configuration_set_name): ConfigurationSetName
    /// - On success, responds with [`GetConfigurationSetEventDestinationsOutput`](crate::output::GetConfigurationSetEventDestinationsOutput) with field(s):
    ///   - [`event_destinations(Option<Vec<EventDestination>>)`](crate::output::GetConfigurationSetEventDestinationsOutput::event_destinations): An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
    /// - On failure, responds with [`SdkError<GetConfigurationSetEventDestinationsError>`](crate::error::GetConfigurationSetEventDestinationsError)
    pub fn get_configuration_set_event_destinations(
        &self,
    ) -> fluent_builders::GetConfigurationSetEventDestinations {
        fluent_builders::GetConfigurationSetEventDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationSets`](crate::client::fluent_builders::ListConfigurationSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationSets::set_next_token): A token returned from a previous call to the API that indicates the position in the list of results.
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationSets::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::ListConfigurationSets::set_page_size): Used to specify the number of items that should be returned in the response.
    /// - On success, responds with [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput) with field(s):
    ///   - [`configuration_sets(Option<Vec<String>>)`](crate::output::ListConfigurationSetsOutput::configuration_sets): An object that contains a list of configuration sets for your account in the current region.
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationSetsOutput::next_token): A token returned from a previous call to ListConfigurationSets to indicate the position in the list of configuration sets.
    /// - On failure, responds with [`SdkError<ListConfigurationSetsError>`](crate::error::ListConfigurationSetsError)
    pub fn list_configuration_sets(&self) -> fluent_builders::ListConfigurationSets {
        fluent_builders::ListConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendVoiceMessage`](crate::client::fluent_builders::SendVoiceMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`caller_id(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::caller_id) / [`set_caller_id(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_caller_id): The phone number that appears on recipients' devices when they receive the message.
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_configuration_set_name): The name of the configuration set that you want to use to send the message.
    ///   - [`content(VoiceMessageContent)`](crate::client::fluent_builders::SendVoiceMessage::content) / [`set_content(Option<VoiceMessageContent>)`](crate::client::fluent_builders::SendVoiceMessage::set_content): An object that contains a voice message and information about the recipient that you want to send it to.
    ///   - [`destination_phone_number(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::destination_phone_number) / [`set_destination_phone_number(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_destination_phone_number): The phone number that you want to send the voice message to.
    ///   - [`origination_phone_number(impl Into<String>)`](crate::client::fluent_builders::SendVoiceMessage::origination_phone_number) / [`set_origination_phone_number(Option<String>)`](crate::client::fluent_builders::SendVoiceMessage::set_origination_phone_number): The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
    /// - On success, responds with [`SendVoiceMessageOutput`](crate::output::SendVoiceMessageOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendVoiceMessageOutput::message_id): A unique identifier for the voice message.
    /// - On failure, responds with [`SdkError<SendVoiceMessageError>`](crate::error::SendVoiceMessageError)
    pub fn send_voice_message(&self) -> fluent_builders::SendVoiceMessage {
        fluent_builders::SendVoiceMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetEventDestination`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_configuration_set_name): ConfigurationSetName
    ///   - [`event_destination(EventDestinationDefinition)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestinationDefinition>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination): An object that defines a single event destination.
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination_name): EventDestinationName
    /// - On success, responds with [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetEventDestinationError>`](crate::error::UpdateConfigurationSetEventDestinationError)
    pub fn update_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetEventDestination {
        fluent_builders::UpdateConfigurationSetEventDestination::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl CreateConfigurationSet {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name that you want to give the configuration set.
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// The name that you want to give the configuration set.
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetEventDestination`.
    ///
    /// Create a new event destination in a configuration set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_event_destination_input::Builder,
    }
    impl CreateConfigurationSetEventDestination {
        /// Creates a new `CreateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// An object that defines a single event destination.
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// An object that defines a single event destination.
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
        /// A name that identifies the event destination.
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// A name that identifies the event destination.
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// Deletes an existing configuration set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl DeleteConfigurationSet {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetEventDestination`.
    ///
    /// Deletes an event destination in a configuration set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_event_destination_input::Builder,
    }
    impl DeleteConfigurationSetEventDestination {
        /// Creates a new `DeleteConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// EventDestinationName
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// EventDestinationName
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSetEventDestinations`.
    ///
    /// Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfigurationSetEventDestinations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_set_event_destinations_input::Builder,
    }
    impl GetConfigurationSetEventDestinations {
        /// Creates a new `GetConfigurationSetEventDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetEventDestinationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetConfigurationSetEventDestinationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationSets`.
    ///
    /// List all of the configuration sets associated with your Amazon Pinpoint account in the current region.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configuration_sets_input::Builder,
    }
    impl ListConfigurationSets {
        /// Creates a new `ListConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A token returned from a previous call to the API that indicates the position in the list of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token returned from a previous call to the API that indicates the position in the list of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Used to specify the number of items that should be returned in the response.
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// Used to specify the number of items that should be returned in the response.
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendVoiceMessage`.
    ///
    /// Create a new voice message and send it to a recipient's phone number.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendVoiceMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_voice_message_input::Builder,
    }
    impl SendVoiceMessage {
        /// Creates a new `SendVoiceMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendVoiceMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendVoiceMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The phone number that appears on recipients' devices when they receive the message.
        pub fn caller_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_id(input.into());
            self
        }
        /// The phone number that appears on recipients' devices when they receive the message.
        pub fn set_caller_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_caller_id(input);
            self
        }
        /// The name of the configuration set that you want to use to send the message.
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// The name of the configuration set that you want to use to send the message.
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// An object that contains a voice message and information about the recipient that you want to send it to.
        pub fn content(mut self, input: crate::model::VoiceMessageContent) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// An object that contains a voice message and information about the recipient that you want to send it to.
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::VoiceMessageContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// The phone number that you want to send the voice message to.
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_phone_number(input.into());
            self
        }
        /// The phone number that you want to send the voice message to.
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_phone_number(input);
            self
        }
        /// The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
        pub fn origination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origination_phone_number(input.into());
            self
        }
        /// The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
        pub fn set_origination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origination_phone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetEventDestination`.
    ///
    /// Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_event_destination_input::Builder,
    }
    impl UpdateConfigurationSetEventDestination {
        /// Creates a new `UpdateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// An object that defines a single event destination.
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// An object that defines a single event destination.
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
        /// EventDestinationName
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// EventDestinationName
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
