// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// An object that defines a single event destination.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestinationDefinition {
    /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
    pub cloud_watch_logs_destination: std::option::Option<crate::model::CloudWatchLogsDestination>,
    /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
    pub enabled: bool,
    /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// An object that contains information about an event destination that sends data to Amazon SNS.
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
}
impl EventDestinationDefinition {
    /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
    pub fn cloud_watch_logs_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestination> {
        self.cloud_watch_logs_destination.as_ref()
    }
    /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// An object that contains information about an event destination that sends data to Amazon SNS.
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
}
impl std::fmt::Debug for EventDestinationDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestinationDefinition");
        formatter.field(
            "cloud_watch_logs_destination",
            &self.cloud_watch_logs_destination,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field("sns_destination", &self.sns_destination);
        formatter.finish()
    }
}
/// See [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
pub mod event_destination_definition {
    /// A builder for [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs_destination:
            std::option::Option<crate::model::CloudWatchLogsDestination>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
    }
    impl Builder {
        /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.cloud_watch_logs_destination = Some(input);
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.cloud_watch_logs_destination = input;
            self
        }
        /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
        pub fn matching_event_types(mut self, input: impl Into<crate::model::EventType>) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input.into());
            self.matching_event_types = Some(v);
            self
        }
        /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon SNS.
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon SNS.
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
        pub fn build(self) -> crate::model::EventDestinationDefinition {
            crate::model::EventDestinationDefinition {
                cloud_watch_logs_destination: self.cloud_watch_logs_destination,
                enabled: self.enabled.unwrap_or_default(),
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                matching_event_types: self.matching_event_types,
                sns_destination: self.sns_destination,
            }
        }
    }
}
impl EventDestinationDefinition {
    /// Creates a new builder-style object to manufacture [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
    pub fn builder() -> crate::model::event_destination_definition::Builder {
        crate::model::event_destination_definition::Builder::default()
    }
}

/// An object that contains information about an event destination that sends data to Amazon SNS.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsDestination {
    /// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.
    pub topic_arn: std::option::Option<std::string::String>,
}
impl SnsDestination {
    /// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SnsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsDestination");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`SnsDestination`](crate::model::SnsDestination)
pub mod sns_destination {
    /// A builder for [`SnsDestination`](crate::model::SnsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsDestination`](crate::model::SnsDestination)
        pub fn build(self) -> crate::model::SnsDestination {
            crate::model::SnsDestination {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl SnsDestination {
    /// Creates a new builder-style object to manufacture [`SnsDestination`](crate::model::SnsDestination)
    pub fn builder() -> crate::model::sns_destination::Builder {
        crate::model::sns_destination::Builder::default()
    }
}

/// The types of events that are sent to the event destination.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    Answered,
    #[allow(missing_docs)] // documentation missing in model
    Busy,
    #[allow(missing_docs)] // documentation missing in model
    CompletedCall,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InitiatedCall,
    #[allow(missing_docs)] // documentation missing in model
    NoAnswer,
    #[allow(missing_docs)] // documentation missing in model
    Ringing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "ANSWERED" => EventType::Answered,
            "BUSY" => EventType::Busy,
            "COMPLETED_CALL" => EventType::CompletedCall,
            "FAILED" => EventType::Failed,
            "INITIATED_CALL" => EventType::InitiatedCall,
            "NO_ANSWER" => EventType::NoAnswer,
            "RINGING" => EventType::Ringing,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::Answered => "ANSWERED",
            EventType::Busy => "BUSY",
            EventType::CompletedCall => "COMPLETED_CALL",
            EventType::Failed => "FAILED",
            EventType::InitiatedCall => "INITIATED_CALL",
            EventType::NoAnswer => "NO_ANSWER",
            EventType::Ringing => "RINGING",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANSWERED",
            "BUSY",
            "COMPLETED_CALL",
            "FAILED",
            "INITIATED_CALL",
            "NO_ANSWER",
            "RINGING",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseDestination {
    /// The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose stream.
    pub delivery_stream_arn: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in the event destination.
    pub iam_role_arn: std::option::Option<std::string::String>,
}
impl KinesisFirehoseDestination {
    /// The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose stream.
    pub fn delivery_stream_arn(&self) -> std::option::Option<&str> {
        self.delivery_stream_arn.as_deref()
    }
    /// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in the event destination.
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisFirehoseDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseDestination");
        formatter.field("delivery_stream_arn", &self.delivery_stream_arn);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
pub mod kinesis_firehose_destination {
    /// A builder for [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_arn: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose stream.
        pub fn delivery_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose stream.
        pub fn set_delivery_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_arn = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in the event destination.
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in the event destination.
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
        pub fn build(self) -> crate::model::KinesisFirehoseDestination {
            crate::model::KinesisFirehoseDestination {
                delivery_stream_arn: self.delivery_stream_arn,
                iam_role_arn: self.iam_role_arn,
            }
        }
    }
}
impl KinesisFirehoseDestination {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    pub fn builder() -> crate::model::kinesis_firehose_destination::Builder {
        crate::model::kinesis_firehose_destination::Builder::default()
    }
}

/// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsDestination {
    /// The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// The name of the Amazon CloudWatch Log Group that you want to record events in.
    pub log_group_arn: std::option::Option<std::string::String>,
}
impl CloudWatchLogsDestination {
    /// The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// The name of the Amazon CloudWatch Log Group that you want to record events in.
    pub fn log_group_arn(&self) -> std::option::Option<&str> {
        self.log_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsDestination");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("log_group_arn", &self.log_group_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
pub mod cloud_watch_logs_destination {
    /// A builder for [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) log_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// The name of the Amazon CloudWatch Log Group that you want to record events in.
        pub fn log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_arn = Some(input.into());
            self
        }
        /// The name of the Amazon CloudWatch Log Group that you want to record events in.
        pub fn set_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
        pub fn build(self) -> crate::model::CloudWatchLogsDestination {
            crate::model::CloudWatchLogsDestination {
                iam_role_arn: self.iam_role_arn,
                log_group_arn: self.log_group_arn,
            }
        }
    }
}
impl CloudWatchLogsDestination {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsDestination`](crate::model::CloudWatchLogsDestination)
    pub fn builder() -> crate::model::cloud_watch_logs_destination::Builder {
        crate::model::cloud_watch_logs_destination::Builder::default()
    }
}

/// An object that contains a voice message and information about the recipient that you want to send it to.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceMessageContent {
    /// An object that defines a message that contains text formatted using Amazon Pinpoint Voice Instructions markup.
    pub call_instructions_message: std::option::Option<crate::model::CallInstructionsMessageType>,
    /// An object that defines a message that contains unformatted text.
    pub plain_text_message: std::option::Option<crate::model::PlainTextMessageType>,
    /// An object that defines a message that contains SSML-formatted text.
    pub ssml_message: std::option::Option<crate::model::SsmlMessageType>,
}
impl VoiceMessageContent {
    /// An object that defines a message that contains text formatted using Amazon Pinpoint Voice Instructions markup.
    pub fn call_instructions_message(
        &self,
    ) -> std::option::Option<&crate::model::CallInstructionsMessageType> {
        self.call_instructions_message.as_ref()
    }
    /// An object that defines a message that contains unformatted text.
    pub fn plain_text_message(&self) -> std::option::Option<&crate::model::PlainTextMessageType> {
        self.plain_text_message.as_ref()
    }
    /// An object that defines a message that contains SSML-formatted text.
    pub fn ssml_message(&self) -> std::option::Option<&crate::model::SsmlMessageType> {
        self.ssml_message.as_ref()
    }
}
impl std::fmt::Debug for VoiceMessageContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceMessageContent");
        formatter.field("call_instructions_message", &self.call_instructions_message);
        formatter.field("plain_text_message", &self.plain_text_message);
        formatter.field("ssml_message", &self.ssml_message);
        formatter.finish()
    }
}
/// See [`VoiceMessageContent`](crate::model::VoiceMessageContent)
pub mod voice_message_content {
    /// A builder for [`VoiceMessageContent`](crate::model::VoiceMessageContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) call_instructions_message:
            std::option::Option<crate::model::CallInstructionsMessageType>,
        pub(crate) plain_text_message: std::option::Option<crate::model::PlainTextMessageType>,
        pub(crate) ssml_message: std::option::Option<crate::model::SsmlMessageType>,
    }
    impl Builder {
        /// An object that defines a message that contains text formatted using Amazon Pinpoint Voice Instructions markup.
        pub fn call_instructions_message(
            mut self,
            input: crate::model::CallInstructionsMessageType,
        ) -> Self {
            self.call_instructions_message = Some(input);
            self
        }
        /// An object that defines a message that contains text formatted using Amazon Pinpoint Voice Instructions markup.
        pub fn set_call_instructions_message(
            mut self,
            input: std::option::Option<crate::model::CallInstructionsMessageType>,
        ) -> Self {
            self.call_instructions_message = input;
            self
        }
        /// An object that defines a message that contains unformatted text.
        pub fn plain_text_message(mut self, input: crate::model::PlainTextMessageType) -> Self {
            self.plain_text_message = Some(input);
            self
        }
        /// An object that defines a message that contains unformatted text.
        pub fn set_plain_text_message(
            mut self,
            input: std::option::Option<crate::model::PlainTextMessageType>,
        ) -> Self {
            self.plain_text_message = input;
            self
        }
        /// An object that defines a message that contains SSML-formatted text.
        pub fn ssml_message(mut self, input: crate::model::SsmlMessageType) -> Self {
            self.ssml_message = Some(input);
            self
        }
        /// An object that defines a message that contains SSML-formatted text.
        pub fn set_ssml_message(
            mut self,
            input: std::option::Option<crate::model::SsmlMessageType>,
        ) -> Self {
            self.ssml_message = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceMessageContent`](crate::model::VoiceMessageContent)
        pub fn build(self) -> crate::model::VoiceMessageContent {
            crate::model::VoiceMessageContent {
                call_instructions_message: self.call_instructions_message,
                plain_text_message: self.plain_text_message,
                ssml_message: self.ssml_message,
            }
        }
    }
}
impl VoiceMessageContent {
    /// Creates a new builder-style object to manufacture [`VoiceMessageContent`](crate::model::VoiceMessageContent)
    pub fn builder() -> crate::model::voice_message_content::Builder {
        crate::model::voice_message_content::Builder::default()
    }
}

/// An object that defines a message that contains SSML-formatted text.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmlMessageType {
    /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
    pub language_code: std::option::Option<std::string::String>,
    /// The SSML-formatted text to deliver to the recipient.
    pub text: std::option::Option<std::string::String>,
    /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
    pub voice_id: std::option::Option<std::string::String>,
}
impl SsmlMessageType {
    /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
    /// The SSML-formatted text to deliver to the recipient.
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
}
impl std::fmt::Debug for SsmlMessageType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmlMessageType");
        formatter.field("language_code", &self.language_code);
        formatter.field("text", &self.text);
        formatter.field("voice_id", &self.voice_id);
        formatter.finish()
    }
}
/// See [`SsmlMessageType`](crate::model::SsmlMessageType)
pub mod ssml_message_type {
    /// A builder for [`SsmlMessageType`](crate::model::SsmlMessageType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// The SSML-formatted text to deliver to the recipient.
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// The SSML-formatted text to deliver to the recipient.
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmlMessageType`](crate::model::SsmlMessageType)
        pub fn build(self) -> crate::model::SsmlMessageType {
            crate::model::SsmlMessageType {
                language_code: self.language_code,
                text: self.text,
                voice_id: self.voice_id,
            }
        }
    }
}
impl SsmlMessageType {
    /// Creates a new builder-style object to manufacture [`SsmlMessageType`](crate::model::SsmlMessageType)
    pub fn builder() -> crate::model::ssml_message_type::Builder {
        crate::model::ssml_message_type::Builder::default()
    }
}

/// An object that defines a message that contains unformatted text.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlainTextMessageType {
    /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
    pub language_code: std::option::Option<std::string::String>,
    /// The plain (not SSML-formatted) text to deliver to the recipient.
    pub text: std::option::Option<std::string::String>,
    /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
    pub voice_id: std::option::Option<std::string::String>,
}
impl PlainTextMessageType {
    /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
    /// The plain (not SSML-formatted) text to deliver to the recipient.
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
}
impl std::fmt::Debug for PlainTextMessageType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlainTextMessageType");
        formatter.field("language_code", &self.language_code);
        formatter.field("text", &self.text);
        formatter.field("voice_id", &self.voice_id);
        formatter.finish()
    }
}
/// See [`PlainTextMessageType`](crate::model::PlainTextMessageType)
pub mod plain_text_message_type {
    /// A builder for [`PlainTextMessageType`](crate::model::PlainTextMessageType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// The plain (not SSML-formatted) text to deliver to the recipient.
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// The plain (not SSML-formatted) text to deliver to the recipient.
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see the Amazon Polly Developer Guide.
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PlainTextMessageType`](crate::model::PlainTextMessageType)
        pub fn build(self) -> crate::model::PlainTextMessageType {
            crate::model::PlainTextMessageType {
                language_code: self.language_code,
                text: self.text,
                voice_id: self.voice_id,
            }
        }
    }
}
impl PlainTextMessageType {
    /// Creates a new builder-style object to manufacture [`PlainTextMessageType`](crate::model::PlainTextMessageType)
    pub fn builder() -> crate::model::plain_text_message_type::Builder {
        crate::model::plain_text_message_type::Builder::default()
    }
}

/// An object that defines a message that contains text formatted using Amazon Pinpoint Voice Instructions markup.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CallInstructionsMessageType {
    /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
    pub text: std::option::Option<std::string::String>,
}
impl CallInstructionsMessageType {
    /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
}
impl std::fmt::Debug for CallInstructionsMessageType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CallInstructionsMessageType");
        formatter.field("text", &self.text);
        formatter.finish()
    }
}
/// See [`CallInstructionsMessageType`](crate::model::CallInstructionsMessageType)
pub mod call_instructions_message_type {
    /// A builder for [`CallInstructionsMessageType`](crate::model::CallInstructionsMessageType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly Developer Guide.
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`CallInstructionsMessageType`](crate::model::CallInstructionsMessageType)
        pub fn build(self) -> crate::model::CallInstructionsMessageType {
            crate::model::CallInstructionsMessageType { text: self.text }
        }
    }
}
impl CallInstructionsMessageType {
    /// Creates a new builder-style object to manufacture [`CallInstructionsMessageType`](crate::model::CallInstructionsMessageType)
    pub fn builder() -> crate::model::call_instructions_message_type::Builder {
        crate::model::call_instructions_message_type::Builder::default()
    }
}

/// An object that defines an event destination.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestination {
    /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
    pub cloud_watch_logs_destination: std::option::Option<crate::model::CloudWatchLogsDestination>,
    /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
    pub enabled: bool,
    /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// A name that identifies the event destination configuration.
    pub name: std::option::Option<std::string::String>,
    /// An object that contains information about an event destination that sends data to Amazon SNS.
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
}
impl EventDestination {
    /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
    pub fn cloud_watch_logs_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestination> {
        self.cloud_watch_logs_destination.as_ref()
    }
    /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// A name that identifies the event destination configuration.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// An object that contains information about an event destination that sends data to Amazon SNS.
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
}
impl std::fmt::Debug for EventDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestination");
        formatter.field(
            "cloud_watch_logs_destination",
            &self.cloud_watch_logs_destination,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field("name", &self.name);
        formatter.field("sns_destination", &self.sns_destination);
        formatter.finish()
    }
}
/// See [`EventDestination`](crate::model::EventDestination)
pub mod event_destination {
    /// A builder for [`EventDestination`](crate::model::EventDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs_destination:
            std::option::Option<crate::model::CloudWatchLogsDestination>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
    }
    impl Builder {
        /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
        pub fn cloud_watch_logs_destination(
            mut self,
            input: crate::model::CloudWatchLogsDestination,
        ) -> Self {
            self.cloud_watch_logs_destination = Some(input);
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
        pub fn set_cloud_watch_logs_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestination>,
        ) -> Self {
            self.cloud_watch_logs_destination = input;
            self
        }
        /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon Pinpoint sends response data to the specified event destination.
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
        pub fn matching_event_types(mut self, input: impl Into<crate::model::EventType>) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input.into());
            self.matching_event_types = Some(v);
            self
        }
        /// An array of EventDestination objects. Each EventDestination object includes ARNs and other information that define an event destination.
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// A name that identifies the event destination configuration.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// A name that identifies the event destination configuration.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon SNS.
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// An object that contains information about an event destination that sends data to Amazon SNS.
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestination`](crate::model::EventDestination)
        pub fn build(self) -> crate::model::EventDestination {
            crate::model::EventDestination {
                cloud_watch_logs_destination: self.cloud_watch_logs_destination,
                enabled: self.enabled.unwrap_or_default(),
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                matching_event_types: self.matching_event_types,
                name: self.name,
                sns_destination: self.sns_destination,
            }
        }
    }
}
impl EventDestination {
    /// Creates a new builder-style object to manufacture [`EventDestination`](crate::model::EventDestination)
    pub fn builder() -> crate::model::event_destination::Builder {
        crate::model::event_destination::Builder::default()
    }
}
