// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
pub mod create_configuration_set_input {
    /// A builder for [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name that you want to give the configuration set.
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// The name that you want to give the configuration set.
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationOutputAlias = crate::operation::CreateConfigurationSet;
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSet`](crate::operation::CreateConfigurationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/sms-voice/configuration-sets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSet",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
}

/// See [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
pub mod create_configuration_set_event_destination_input {
    /// A builder for [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// An object that defines a single event destination.
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// An object that defines a single event destination.
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// A name that identifies the event destination.
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// A name that identifies the event destination.
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
                event_destination_name: self.event_destination_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::CreateConfigurationSetEventDestination;
#[doc(hidden)]
pub type CreateConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSetEventDestination`](crate::operation::CreateConfigurationSetEventDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSetEventDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationSetEventDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.configuration_set_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_set_name = aws_smithy_http::label::fmt_string(input_1, false);
            if configuration_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_set_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations",
                ConfigurationSetName = configuration_set_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationSetEventDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationSetEventDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set_event_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSetEventDestination",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::create_configuration_set_event_destination_input::Builder {
        crate::input::create_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
pub mod delete_configuration_set_input {
    /// A builder for [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationOutputAlias = crate::operation::DeleteConfigurationSet;
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSet`](crate::operation::DeleteConfigurationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigurationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.configuration_set_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_set_name = aws_smithy_http::label::fmt_string(input_2, false);
            if configuration_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_set_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/sms-voice/configuration-sets/{ConfigurationSetName}",
                ConfigurationSetName = configuration_set_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigurationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigurationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSet",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
pub mod delete_configuration_set_event_destination_input {
    /// A builder for [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// EventDestinationName
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// EventDestinationName
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::DeleteConfigurationSetEventDestination;
#[doc(hidden)]
pub type DeleteConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSetEventDestination`](crate::operation::DeleteConfigurationSetEventDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSetEventDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigurationSetEventDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.configuration_set_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_set_name = aws_smithy_http::label::fmt_string(input_3, false);
            if configuration_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_set_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.event_destination_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_destination_name",
                        details: "cannot be empty or unset",
                    })?;
            let event_destination_name = aws_smithy_http::label::fmt_string(input_4, false);
            if event_destination_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "event_destination_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}", ConfigurationSetName = configuration_set_name, EventDestinationName = event_destination_name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigurationSetEventDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigurationSetEventDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSetEventDestination",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::delete_configuration_set_event_destination_input::Builder {
        crate::input::delete_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
pub mod get_configuration_set_event_destinations_input {
    /// A builder for [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConfigurationSetEventDestinationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConfigurationSetEventDestinationsInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigurationSetEventDestinationsInputOperationOutputAlias =
    crate::operation::GetConfigurationSetEventDestinations;
#[doc(hidden)]
pub type GetConfigurationSetEventDestinationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetConfigurationSetEventDestinationsInput {
    /// Consumes the builder and constructs an Operation<[`GetConfigurationSetEventDestinations`](crate::operation::GetConfigurationSetEventDestinations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfigurationSetEventDestinations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConfigurationSetEventDestinationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.configuration_set_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_set_name = aws_smithy_http::label::fmt_string(input_5, false);
            if configuration_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_set_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations",
                ConfigurationSetName = configuration_set_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConfigurationSetEventDestinationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConfigurationSetEventDestinationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConfigurationSetEventDestinations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConfigurationSetEventDestinations",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
    pub fn builder() -> crate::input::get_configuration_set_event_destinations_input::Builder {
        crate::input::get_configuration_set_event_destinations_input::Builder::default()
    }
}

/// See [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
pub mod list_configuration_sets_input {
    /// A builder for [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A token returned from a previous call to the API that indicates the position in the list of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token returned from a previous call to the API that indicates the position in the list of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Used to specify the number of items that should be returned in the response.
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// Used to specify the number of items that should be returned in the response.
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationSetsInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationSetsInputOperationOutputAlias = crate::operation::ListConfigurationSets;
#[doc(hidden)]
pub type ListConfigurationSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConfigurationSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurationSets`](crate::operation::ListConfigurationSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurationSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigurationSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/sms-voice/configuration-sets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListConfigurationSetsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_6));
            }
            if let Some(inner_7) = &_input.page_size {
                query.push_kv("PageSize", &aws_smithy_http::query::fmt_string(&inner_7));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigurationSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigurationSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurationSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurationSets",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    pub fn builder() -> crate::input::list_configuration_sets_input::Builder {
        crate::input::list_configuration_sets_input::Builder::default()
    }
}

/// See [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
pub mod send_voice_message_input {
    /// A builder for [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_id: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<crate::model::VoiceMessageContent>,
        pub(crate) destination_phone_number: std::option::Option<std::string::String>,
        pub(crate) origination_phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The phone number that appears on recipients' devices when they receive the message.
        pub fn caller_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_id = Some(input.into());
            self
        }
        /// The phone number that appears on recipients' devices when they receive the message.
        pub fn set_caller_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.caller_id = input;
            self
        }
        /// The name of the configuration set that you want to use to send the message.
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// The name of the configuration set that you want to use to send the message.
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// An object that contains a voice message and information about the recipient that you want to send it to.
        pub fn content(mut self, input: crate::model::VoiceMessageContent) -> Self {
            self.content = Some(input);
            self
        }
        /// An object that contains a voice message and information about the recipient that you want to send it to.
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::VoiceMessageContent>,
        ) -> Self {
            self.content = input;
            self
        }
        /// The phone number that you want to send the voice message to.
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_phone_number = Some(input.into());
            self
        }
        /// The phone number that you want to send the voice message to.
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_phone_number = input;
            self
        }
        /// The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
        pub fn origination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_phone_number = Some(input.into());
            self
        }
        /// The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
        pub fn set_origination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendVoiceMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendVoiceMessageInput {
                caller_id: self.caller_id,
                configuration_set_name: self.configuration_set_name,
                content: self.content,
                destination_phone_number: self.destination_phone_number,
                origination_phone_number: self.origination_phone_number,
            })
        }
    }
}
#[doc(hidden)]
pub type SendVoiceMessageInputOperationOutputAlias = crate::operation::SendVoiceMessage;
#[doc(hidden)]
pub type SendVoiceMessageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendVoiceMessageInput {
    /// Consumes the builder and constructs an Operation<[`SendVoiceMessage`](crate::operation::SendVoiceMessage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendVoiceMessage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendVoiceMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/sms-voice/voice/message").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendVoiceMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendVoiceMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_voice_message(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendVoiceMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendVoiceMessage",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendVoiceMessageInput`](crate::input::SendVoiceMessageInput)
    pub fn builder() -> crate::input::send_voice_message_input::Builder {
        crate::input::send_voice_message_input::Builder::default()
    }
}

/// See [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
pub mod update_configuration_set_event_destination_input {
    /// A builder for [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ConfigurationSetName
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// ConfigurationSetName
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// An object that defines a single event destination.
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// An object that defines a single event destination.
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// EventDestinationName
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// EventDestinationName
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
                event_destination_name: self.event_destination_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::UpdateConfigurationSetEventDestination;
#[doc(hidden)]
pub type UpdateConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationSetEventDestination`](crate::operation::UpdateConfigurationSetEventDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationSetEventDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationSetEventDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.configuration_set_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_set_name = aws_smithy_http::label::fmt_string(input_8, false);
            if configuration_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_set_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.event_destination_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_destination_name",
                        details: "cannot be empty or unset",
                    })?;
            let event_destination_name = aws_smithy_http::label::fmt_string(input_9, false);
            if event_destination_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "event_destination_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}", ConfigurationSetName = configuration_set_name, EventDestinationName = event_destination_name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationSetEventDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationSetEventDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_set_event_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationSetEventDestination",
            "pinpointsmsvoice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::update_configuration_set_event_destination_input::Builder {
        crate::input::update_configuration_set_event_destination_input::Builder::default()
    }
}

/// UpdateConfigurationSetEventDestinationRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetEventDestinationInput {
    /// ConfigurationSetName
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// An object that defines a single event destination.
    pub event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
    /// EventDestinationName
    pub event_destination_name: std::option::Option<std::string::String>,
}
impl UpdateConfigurationSetEventDestinationInput {
    /// ConfigurationSetName
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// An object that defines a single event destination.
    pub fn event_destination(
        &self,
    ) -> std::option::Option<&crate::model::EventDestinationDefinition> {
        self.event_destination.as_ref()
    }
    /// EventDestinationName
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.finish()
    }
}

/// SendVoiceMessageRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendVoiceMessageInput {
    /// The phone number that appears on recipients' devices when they receive the message.
    pub caller_id: std::option::Option<std::string::String>,
    /// The name of the configuration set that you want to use to send the message.
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// An object that contains a voice message and information about the recipient that you want to send it to.
    pub content: std::option::Option<crate::model::VoiceMessageContent>,
    /// The phone number that you want to send the voice message to.
    pub destination_phone_number: std::option::Option<std::string::String>,
    /// The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
    pub origination_phone_number: std::option::Option<std::string::String>,
}
impl SendVoiceMessageInput {
    /// The phone number that appears on recipients' devices when they receive the message.
    pub fn caller_id(&self) -> std::option::Option<&str> {
        self.caller_id.as_deref()
    }
    /// The name of the configuration set that you want to use to send the message.
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// An object that contains a voice message and information about the recipient that you want to send it to.
    pub fn content(&self) -> std::option::Option<&crate::model::VoiceMessageContent> {
        self.content.as_ref()
    }
    /// The phone number that you want to send the voice message to.
    pub fn destination_phone_number(&self) -> std::option::Option<&str> {
        self.destination_phone_number.as_deref()
    }
    /// The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
    pub fn origination_phone_number(&self) -> std::option::Option<&str> {
        self.origination_phone_number.as_deref()
    }
}
impl std::fmt::Debug for SendVoiceMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendVoiceMessageInput");
        formatter.field("caller_id", &self.caller_id);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("content", &self.content);
        formatter.field("destination_phone_number", &self.destination_phone_number);
        formatter.field("origination_phone_number", &self.origination_phone_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationSetsInput {
    /// A token returned from a previous call to the API that indicates the position in the list of results.
    pub next_token: std::option::Option<std::string::String>,
    /// Used to specify the number of items that should be returned in the response.
    pub page_size: std::option::Option<std::string::String>,
}
impl ListConfigurationSetsInput {
    /// A token returned from a previous call to the API that indicates the position in the list of results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Used to specify the number of items that should be returned in the response.
    pub fn page_size(&self) -> std::option::Option<&str> {
        self.page_size.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationSetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationSetEventDestinationsInput {
    /// ConfigurationSetName
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl GetConfigurationSetEventDestinationsInput {
    /// ConfigurationSetName
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for GetConfigurationSetEventDestinationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationSetEventDestinationsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetEventDestinationInput {
    /// ConfigurationSetName
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// EventDestinationName
    pub event_destination_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetEventDestinationInput {
    /// ConfigurationSetName
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// EventDestinationName
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetInput {
    /// ConfigurationSetName
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetInput {
    /// ConfigurationSetName
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// Create a new event destination in a configuration set.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetEventDestinationInput {
    /// ConfigurationSetName
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// An object that defines a single event destination.
    pub event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
    /// A name that identifies the event destination.
    pub event_destination_name: std::option::Option<std::string::String>,
}
impl CreateConfigurationSetEventDestinationInput {
    /// ConfigurationSetName
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// An object that defines a single event destination.
    pub fn event_destination(
        &self,
    ) -> std::option::Option<&crate::model::EventDestinationDefinition> {
        self.event_destination.as_ref()
    }
    /// A name that identifies the event destination.
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.finish()
    }
}

/// A request to create a new configuration set.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetInput {
    /// The name that you want to give the configuration set.
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl CreateConfigurationSetInput {
    /// The name that you want to give the configuration set.
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}
