// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetErrorKind {
    /// The resource specified in your request already exists.
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// There are too many instances of the specified resource type.
    LimitExceededException(crate::error::LimitExceededException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetError {
    /// Creates a new `CreateConfigurationSetError`.
    pub fn new(kind: CreateConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetEventDestinationErrorKind {
    /// The resource specified in your request already exists.
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// There are too many instances of the specified resource type.
    LimitExceededException(crate::error::LimitExceededException),
    /// The resource you attempted to access doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetEventDestinationError {
    /// Creates a new `CreateConfigurationSetEventDestinationError`.
    pub fn new(
        kind: CreateConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetErrorKind {
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// The resource you attempted to access doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetError {
    /// Creates a new `DeleteConfigurationSetError`.
    pub fn new(kind: DeleteConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConfigurationSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetEventDestinationErrorKind {
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// The resource you attempted to access doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            DeleteConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetEventDestinationError {
    /// Creates a new `DeleteConfigurationSetEventDestinationError`.
    pub fn new(
        kind: DeleteConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            DeleteConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetConfigurationSetEventDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigurationSetEventDestinationsError {
    /// Kind of error that occurred.
    pub kind: GetConfigurationSetEventDestinationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfigurationSetEventDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigurationSetEventDestinationsErrorKind {
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// The resource you attempted to access doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigurationSetEventDestinationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigurationSetEventDestinationsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetConfigurationSetEventDestinationsErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            GetConfigurationSetEventDestinationsErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetConfigurationSetEventDestinationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigurationSetEventDestinationsError {
    fn code(&self) -> Option<&str> {
        GetConfigurationSetEventDestinationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigurationSetEventDestinationsError {
    /// Creates a new `GetConfigurationSetEventDestinationsError`.
    pub fn new(
        kind: GetConfigurationSetEventDestinationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigurationSetEventDestinationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigurationSetEventDestinationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigurationSetEventDestinationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigurationSetEventDestinationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetConfigurationSetEventDestinationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetConfigurationSetEventDestinationsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetConfigurationSetEventDestinationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetConfigurationSetEventDestinationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigurationSetEventDestinationsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetConfigurationSetEventDestinationsErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            GetConfigurationSetEventDestinationsErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetConfigurationSetEventDestinationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationSetsError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationSetsErrorKind {
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationSetsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListConfigurationSetsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListConfigurationSetsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListConfigurationSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationSetsError {
    fn code(&self) -> Option<&str> {
        ListConfigurationSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationSetsError {
    /// Creates a new `ListConfigurationSetsError`.
    pub fn new(kind: ListConfigurationSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListConfigurationSetsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationSetsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListConfigurationSetsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationSetsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListConfigurationSetsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationSetsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListConfigurationSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationSetsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListConfigurationSetsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListConfigurationSetsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListConfigurationSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendVoiceMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendVoiceMessageError {
    /// Kind of error that occurred.
    pub kind: SendVoiceMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendVoiceMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendVoiceMessageErrorKind {
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendVoiceMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendVoiceMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SendVoiceMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendVoiceMessageError {
    fn code(&self) -> Option<&str> {
        SendVoiceMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendVoiceMessageError {
    /// Creates a new `SendVoiceMessageError`.
    pub fn new(kind: SendVoiceMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendVoiceMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendVoiceMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendVoiceMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendVoiceMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendVoiceMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `SendVoiceMessageErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `SendVoiceMessageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendVoiceMessageErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for SendVoiceMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendVoiceMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SendVoiceMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationSetEventDestinationErrorKind {
    /// The input you provided is invalid.
    BadRequestException(crate::error::BadRequestException),
    /// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// The resource you attempted to access doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// You've issued too many requests to the resource. Wait a few minutes, and then try again.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            UpdateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationSetEventDestinationError {
    /// Creates a new `UpdateConfigurationSetEventDestinationError`.
    pub fn new(
        kind: UpdateConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationSetEventDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            UpdateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// You've issued too many requests to the resource. Wait a few minutes, and then try again.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// The resource you attempted to access doesn't exist.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// The API encountered an unexpected error and couldn't complete the request. You might be able to successfully issue the request again in the future.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceErrorException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceErrorException {}
/// See [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
pub mod internal_service_error_exception {
    /// A builder for [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
        pub fn build(self) -> crate::error::InternalServiceErrorException {
            crate::error::InternalServiceErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    pub fn builder() -> crate::error::internal_service_error_exception::Builder {
        crate::error::internal_service_error_exception::Builder::default()
    }
}

/// The input you provided is invalid.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// There are too many instances of the specified resource type.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// The resource specified in your request already exists.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}
