// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Pinpoint Email Service
///
/// Client for invoking operations on Amazon Pinpoint Email Service. Each operation on Amazon Pinpoint Email Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_pinpointemail::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_pinpointemail::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_pinpointemail::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSet::set_configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`tracking_options(TrackingOptions)`](crate::client::fluent_builders::CreateConfigurationSet::tracking_options) / [`set_tracking_options(Option<TrackingOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_tracking_options): <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
    ///   - [`delivery_options(DeliveryOptions)`](crate::client::fluent_builders::CreateConfigurationSet::delivery_options) / [`set_delivery_options(Option<DeliveryOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_delivery_options): <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
    ///   - [`reputation_options(ReputationOptions)`](crate::client::fluent_builders::CreateConfigurationSet::reputation_options) / [`set_reputation_options(Option<ReputationOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_reputation_options): <p>An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.</p>
    ///   - [`sending_options(SendingOptions)`](crate::client::fluent_builders::CreateConfigurationSet::sending_options) / [`set_sending_options(Option<SendingOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_sending_options): <p>An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConfigurationSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConfigurationSet::set_tags): <p>An array of objects that define the tags (keys and values) that you want to associate with the configuration set.</p>
    /// - On success, responds with [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetError>`](crate::error::CreateConfigurationSetError)
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSetEventDestination`](crate::client::fluent_builders::CreateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that you want to add an event destination to.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination_name): <p>A name that identifies the event destination within the configuration set.</p>
    ///   - [`event_destination(EventDestinationDefinition)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestinationDefinition>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination): <p>An object that defines the event destination.</p>
    /// - On success, responds with [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetEventDestinationError>`](crate::error::CreateConfigurationSetEventDestinationError)
    pub fn create_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::CreateConfigurationSetEventDestination {
        fluent_builders::CreateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDedicatedIpPool`](crate::client::fluent_builders::CreateDedicatedIpPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::CreateDedicatedIpPool::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::CreateDedicatedIpPool::set_pool_name): <p>The name of the dedicated IP pool.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDedicatedIpPool::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDedicatedIpPool::set_tags): <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
    /// - On success, responds with [`CreateDedicatedIpPoolOutput`](crate::output::CreateDedicatedIpPoolOutput)

    /// - On failure, responds with [`SdkError<CreateDedicatedIpPoolError>`](crate::error::CreateDedicatedIpPoolError)
    pub fn create_dedicated_ip_pool(&self) -> fluent_builders::CreateDedicatedIpPool {
        fluent_builders::CreateDedicatedIpPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeliverabilityTestReport`](crate::client::fluent_builders::CreateDeliverabilityTestReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::report_name) / [`set_report_name(Option<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_report_name): <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_from_email_address): <p>The email address that the predictive inbox placement test email was sent from.</p>
    ///   - [`content(EmailContent)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::content) / [`set_content(Option<EmailContent>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_content): <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_tags): <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
    /// - On success, responds with [`CreateDeliverabilityTestReportOutput`](crate::output::CreateDeliverabilityTestReportOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::CreateDeliverabilityTestReportOutput::report_id): <p>A unique string that identifies the predictive inbox placement test.</p>
    ///   - [`deliverability_test_status(Option<DeliverabilityTestStatus>)`](crate::output::CreateDeliverabilityTestReportOutput::deliverability_test_status): <p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>
    /// - On failure, responds with [`SdkError<CreateDeliverabilityTestReportError>`](crate::error::CreateDeliverabilityTestReportError)
    pub fn create_deliverability_test_report(
        &self,
    ) -> fluent_builders::CreateDeliverabilityTestReport {
        fluent_builders::CreateDeliverabilityTestReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEmailIdentity`](crate::client::fluent_builders::CreateEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::CreateEmailIdentity::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::CreateEmailIdentity::set_email_identity): <p>The email address or domain that you want to verify.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEmailIdentity::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEmailIdentity::set_tags): <p>An array of objects that define the tags (keys and values) that you want to associate with the email identity.</p>
    /// - On success, responds with [`CreateEmailIdentityOutput`](crate::output::CreateEmailIdentityOutput) with field(s):
    ///   - [`identity_type(Option<IdentityType>)`](crate::output::CreateEmailIdentityOutput::identity_type): <p>The email identity type.</p>
    ///   - [`verified_for_sending_status(bool)`](crate::output::CreateEmailIdentityOutput::verified_for_sending_status): <p>Specifies whether or not the identity is verified. In Amazon Pinpoint, you can only send email from verified email addresses or domains. For more information about verifying identities, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint User Guide</a>.</p>
    ///   - [`dkim_attributes(Option<DkimAttributes>)`](crate::output::CreateEmailIdentityOutput::dkim_attributes): <p>An object that contains information about the DKIM attributes for the identity. This object includes the tokens that you use to create the CNAME records that are required to complete the DKIM verification process.</p>
    /// - On failure, responds with [`SdkError<CreateEmailIdentityError>`](crate::error::CreateEmailIdentityError)
    pub fn create_email_identity(&self) -> fluent_builders::CreateEmailIdentity {
        fluent_builders::CreateEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::set_configuration_set_name): <p>The name of the configuration set that you want to delete.</p>
    /// - On success, responds with [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetError>`](crate::error::DeleteConfigurationSetError)
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSetEventDestination`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that contains the event destination that you want to delete.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_event_destination_name): <p>The name of the event destination that you want to delete.</p>
    /// - On success, responds with [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetEventDestinationError>`](crate::error::DeleteConfigurationSetEventDestinationError)
    pub fn delete_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetEventDestination {
        fluent_builders::DeleteConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDedicatedIpPool`](crate::client::fluent_builders::DeleteDedicatedIpPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDedicatedIpPool::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::DeleteDedicatedIpPool::set_pool_name): <p>The name of the dedicated IP pool that you want to delete.</p>
    /// - On success, responds with [`DeleteDedicatedIpPoolOutput`](crate::output::DeleteDedicatedIpPoolOutput)

    /// - On failure, responds with [`SdkError<DeleteDedicatedIpPoolError>`](crate::error::DeleteDedicatedIpPoolError)
    pub fn delete_dedicated_ip_pool(&self) -> fluent_builders::DeleteDedicatedIpPool {
        fluent_builders::DeleteDedicatedIpPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailIdentity`](crate::client::fluent_builders::DeleteEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailIdentity::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::DeleteEmailIdentity::set_email_identity): <p>The identity (that is, the email address or domain) that you want to delete from your Amazon Pinpoint account.</p>
    /// - On success, responds with [`DeleteEmailIdentityOutput`](crate::output::DeleteEmailIdentityOutput)

    /// - On failure, responds with [`SdkError<DeleteEmailIdentityError>`](crate::error::DeleteEmailIdentityError)
    pub fn delete_email_identity(&self) -> fluent_builders::DeleteEmailIdentity {
        fluent_builders::DeleteEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccount`](crate::client::fluent_builders::GetAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccount::send) it.

    /// - On success, responds with [`GetAccountOutput`](crate::output::GetAccountOutput) with field(s):
    ///   - [`send_quota(Option<SendQuota>)`](crate::output::GetAccountOutput::send_quota): <p>An object that contains information about the per-day and per-second sending limits for your Amazon Pinpoint account in the current AWS Region.</p>
    ///   - [`sending_enabled(bool)`](crate::output::GetAccountOutput::sending_enabled): <p>Indicates whether or not email sending is enabled for your Amazon Pinpoint account in the current AWS Region.</p>
    ///   - [`dedicated_ip_auto_warmup_enabled(bool)`](crate::output::GetAccountOutput::dedicated_ip_auto_warmup_enabled): <p>Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated with your account.</p>
    ///   - [`enforcement_status(Option<String>)`](crate::output::GetAccountOutput::enforcement_status): <p>The reputation status of your Amazon Pinpoint account. The status can be one of the following:</p>  <ul>   <li> <p> <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.</p> </li>   <li> <p> <code>PROBATION</code> – We've identified some issues with your Amazon Pinpoint account. We're placing your account under review while you work on correcting these issues.</p> </li>   <li> <p> <code>SHUTDOWN</code> – Your account's ability to send email is currently paused because of an issue with the email sent from your account. When you correct the issue, you can contact us and request that your account's ability to send email is resumed.</p> </li>  </ul>
    ///   - [`production_access_enabled(bool)`](crate::output::GetAccountOutput::production_access_enabled): <p>Indicates whether or not your account has production access in the current AWS Region.</p>  <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>  <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
    /// - On failure, responds with [`SdkError<GetAccountError>`](crate::error::GetAccountError)
    pub fn get_account(&self) -> fluent_builders::GetAccount {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBlacklistReports`](crate::client::fluent_builders::GetBlacklistReports) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`blacklist_item_names(Vec<String>)`](crate::client::fluent_builders::GetBlacklistReports::blacklist_item_names) / [`set_blacklist_item_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetBlacklistReports::set_blacklist_item_names): <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon Pinpoint or Amazon SES.</p>
    /// - On success, responds with [`GetBlacklistReportsOutput`](crate::output::GetBlacklistReportsOutput) with field(s):
    ///   - [`blacklist_report(Option<HashMap<String, Vec<BlacklistEntry>>>)`](crate::output::GetBlacklistReportsOutput::blacklist_report): <p>An object that contains information about a blacklist that one of your dedicated IP addresses appears on.</p>
    /// - On failure, responds with [`SdkError<GetBlacklistReportsError>`](crate::error::GetBlacklistReportsError)
    pub fn get_blacklist_reports(&self) -> fluent_builders::GetBlacklistReports {
        fluent_builders::GetBlacklistReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfigurationSet`](crate::client::fluent_builders::GetConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::GetConfigurationSet::set_configuration_set_name): <p>The name of the configuration set that you want to obtain more information about.</p>
    /// - On success, responds with [`GetConfigurationSetOutput`](crate::output::GetConfigurationSetOutput) with field(s):
    ///   - [`configuration_set_name(Option<String>)`](crate::output::GetConfigurationSetOutput::configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`tracking_options(Option<TrackingOptions>)`](crate::output::GetConfigurationSetOutput::tracking_options): <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
    ///   - [`delivery_options(Option<DeliveryOptions>)`](crate::output::GetConfigurationSetOutput::delivery_options): <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
    ///   - [`reputation_options(Option<ReputationOptions>)`](crate::output::GetConfigurationSetOutput::reputation_options): <p>An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.</p>
    ///   - [`sending_options(Option<SendingOptions>)`](crate::output::GetConfigurationSetOutput::sending_options): <p>An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetConfigurationSetOutput::tags): <p>An array of objects that define the tags (keys and values) that are associated with the configuration set.</p>
    /// - On failure, responds with [`SdkError<GetConfigurationSetError>`](crate::error::GetConfigurationSetError)
    pub fn get_configuration_set(&self) -> fluent_builders::GetConfigurationSet {
        fluent_builders::GetConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfigurationSetEventDestinations`](crate::client::fluent_builders::GetConfigurationSetEventDestinations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationSetEventDestinations::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::GetConfigurationSetEventDestinations::set_configuration_set_name): <p>The name of the configuration set that contains the event destination.</p>
    /// - On success, responds with [`GetConfigurationSetEventDestinationsOutput`](crate::output::GetConfigurationSetEventDestinationsOutput) with field(s):
    ///   - [`event_destinations(Option<Vec<EventDestination>>)`](crate::output::GetConfigurationSetEventDestinationsOutput::event_destinations): <p>An array that includes all of the events destinations that have been configured for the configuration set.</p>
    /// - On failure, responds with [`SdkError<GetConfigurationSetEventDestinationsError>`](crate::error::GetConfigurationSetEventDestinationsError)
    pub fn get_configuration_set_event_destinations(
        &self,
    ) -> fluent_builders::GetConfigurationSetEventDestinations {
        fluent_builders::GetConfigurationSetEventDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDedicatedIp`](crate::client::fluent_builders::GetDedicatedIp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip(impl Into<String>)`](crate::client::fluent_builders::GetDedicatedIp::ip) / [`set_ip(Option<String>)`](crate::client::fluent_builders::GetDedicatedIp::set_ip): <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Pinpoint account.</p>
    /// - On success, responds with [`GetDedicatedIpOutput`](crate::output::GetDedicatedIpOutput) with field(s):
    ///   - [`dedicated_ip(Option<DedicatedIp>)`](crate::output::GetDedicatedIpOutput::dedicated_ip): <p>An object that contains information about a dedicated IP address.</p>
    /// - On failure, responds with [`SdkError<GetDedicatedIpError>`](crate::error::GetDedicatedIpError)
    pub fn get_dedicated_ip(&self) -> fluent_builders::GetDedicatedIp {
        fluent_builders::GetDedicatedIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDedicatedIps`](crate::client::fluent_builders::GetDedicatedIps) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDedicatedIps::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::GetDedicatedIps::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::GetDedicatedIps::set_pool_name): <p>The name of the IP pool that the dedicated IP address is associated with.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDedicatedIps::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDedicatedIps::set_next_token): <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetDedicatedIps::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::GetDedicatedIps::set_page_size): <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`GetDedicatedIpsOutput`](crate::output::GetDedicatedIpsOutput) with field(s):
    ///   - [`dedicated_ips(Option<Vec<DedicatedIp>>)`](crate::output::GetDedicatedIpsOutput::dedicated_ips): <p>A list of dedicated IP addresses that are reserved for use by your Amazon Pinpoint account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDedicatedIpsOutput::next_token): <p>A token that indicates that there are additional dedicated IP addresses to list. To view additional addresses, issue another request to <code>GetDedicatedIps</code>, passing this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<GetDedicatedIpsError>`](crate::error::GetDedicatedIpsError)
    pub fn get_dedicated_ips(&self) -> fluent_builders::GetDedicatedIps {
        fluent_builders::GetDedicatedIps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeliverabilityDashboardOptions`](crate::client::fluent_builders::GetDeliverabilityDashboardOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetDeliverabilityDashboardOptions::send) it.

    /// - On success, responds with [`GetDeliverabilityDashboardOptionsOutput`](crate::output::GetDeliverabilityDashboardOptionsOutput) with field(s):
    ///   - [`dashboard_enabled(bool)`](crate::output::GetDeliverabilityDashboardOptionsOutput::dashboard_enabled): <p>Specifies whether the Deliverability dashboard is enabled for your Amazon Pinpoint account. If this value is <code>true</code>, the dashboard is enabled.</p>
    ///   - [`subscription_expiry_date(Option<DateTime>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::subscription_expiry_date): <p>The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is null if you have an active subscription that isn’t due to expire at the end of the month.</p>
    ///   - [`account_status(Option<DeliverabilityDashboardAccountStatus>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::account_status): <p>The current status of your Deliverability dashboard subscription. If this value is <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar month.</p>
    ///   - [`active_subscribed_domains(Option<Vec<DomainDeliverabilityTrackingOption>>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::active_subscribed_domains): <p>An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar month.</p>
    ///   - [`pending_expiration_subscribed_domains(Option<Vec<DomainDeliverabilityTrackingOption>>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::pending_expiration_subscribed_domains): <p>An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.</p>
    /// - On failure, responds with [`SdkError<GetDeliverabilityDashboardOptionsError>`](crate::error::GetDeliverabilityDashboardOptionsError)
    pub fn get_deliverability_dashboard_options(
        &self,
    ) -> fluent_builders::GetDeliverabilityDashboardOptions {
        fluent_builders::GetDeliverabilityDashboardOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeliverabilityTestReport`](crate::client::fluent_builders::GetDeliverabilityTestReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::GetDeliverabilityTestReport::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::GetDeliverabilityTestReport::set_report_id): <p>A unique string that identifies the predictive inbox placement test.</p>
    /// - On success, responds with [`GetDeliverabilityTestReportOutput`](crate::output::GetDeliverabilityTestReportOutput) with field(s):
    ///   - [`deliverability_test_report(Option<DeliverabilityTestReport>)`](crate::output::GetDeliverabilityTestReportOutput::deliverability_test_report): <p>An object that contains the results of the predictive inbox placement test.</p>
    ///   - [`overall_placement(Option<PlacementStatistics>)`](crate::output::GetDeliverabilityTestReportOutput::overall_placement): <p>An object that specifies how many test messages that were sent during the predictive inbox placement test were delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how many weren't delivered.</p>
    ///   - [`isp_placements(Option<Vec<IspPlacement>>)`](crate::output::GetDeliverabilityTestReportOutput::isp_placements): <p>An object that describes how the test email was handled by several email providers, including Gmail, Hotmail, Yahoo, AOL, and others.</p>
    ///   - [`message(Option<String>)`](crate::output::GetDeliverabilityTestReportOutput::message): <p>An object that contains the message that you sent when you performed this predictive inbox placement test.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetDeliverabilityTestReportOutput::tags): <p>An array of objects that define the tags (keys and values) that are associated with the predictive inbox placement test.</p>
    /// - On failure, responds with [`SdkError<GetDeliverabilityTestReportError>`](crate::error::GetDeliverabilityTestReportError)
    pub fn get_deliverability_test_report(&self) -> fluent_builders::GetDeliverabilityTestReport {
        fluent_builders::GetDeliverabilityTestReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainDeliverabilityCampaign`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign::set_campaign_id): <p>The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetDomainDeliverabilityCampaignOutput`](crate::output::GetDomainDeliverabilityCampaignOutput) with field(s):
    ///   - [`domain_deliverability_campaign(Option<DomainDeliverabilityCampaign>)`](crate::output::GetDomainDeliverabilityCampaignOutput::domain_deliverability_campaign): <p>An object that contains the deliverability data for the campaign.</p>
    /// - On failure, responds with [`SdkError<GetDomainDeliverabilityCampaignError>`](crate::error::GetDomainDeliverabilityCampaignError)
    pub fn get_domain_deliverability_campaign(
        &self,
    ) -> fluent_builders::GetDomainDeliverabilityCampaign {
        fluent_builders::GetDomainDeliverabilityCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainStatisticsReport`](crate::client::fluent_builders::GetDomainStatisticsReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetDomainStatisticsReport::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetDomainStatisticsReport::set_domain): <p>The domain that you want to obtain deliverability metrics for.</p>
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::GetDomainStatisticsReport::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::GetDomainStatisticsReport::set_start_date): <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::GetDomainStatisticsReport::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::GetDomainStatisticsReport::set_end_date): <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
    /// - On success, responds with [`GetDomainStatisticsReportOutput`](crate::output::GetDomainStatisticsReportOutput) with field(s):
    ///   - [`overall_volume(Option<OverallVolume>)`](crate::output::GetDomainStatisticsReportOutput::overall_volume): <p>An object that contains deliverability metrics for the domain that you specified. The data in this object is a summary of all of the data that was collected from the <code>StartDate</code> to the <code>EndDate</code>.</p>
    ///   - [`daily_volumes(Option<Vec<DailyVolume>>)`](crate::output::GetDomainStatisticsReportOutput::daily_volumes): <p>An object that contains deliverability metrics for the domain that you specified. This object contains data for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.</p>
    /// - On failure, responds with [`SdkError<GetDomainStatisticsReportError>`](crate::error::GetDomainStatisticsReportError)
    pub fn get_domain_statistics_report(&self) -> fluent_builders::GetDomainStatisticsReport {
        fluent_builders::GetDomainStatisticsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEmailIdentity`](crate::client::fluent_builders::GetEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::GetEmailIdentity::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::GetEmailIdentity::set_email_identity): <p>The email identity that you want to retrieve details for.</p>
    /// - On success, responds with [`GetEmailIdentityOutput`](crate::output::GetEmailIdentityOutput) with field(s):
    ///   - [`identity_type(Option<IdentityType>)`](crate::output::GetEmailIdentityOutput::identity_type): <p>The email identity type.</p>
    ///   - [`feedback_forwarding_status(bool)`](crate::output::GetEmailIdentityOutput::feedback_forwarding_status): <p>The feedback forwarding configuration for the identity.</p>  <p>If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.</p>  <p>When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).</p>
    ///   - [`verified_for_sending_status(bool)`](crate::output::GetEmailIdentityOutput::verified_for_sending_status): <p>Specifies whether or not the identity is verified. In Amazon Pinpoint, you can only send email from verified email addresses or domains. For more information about verifying identities, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint User Guide</a>.</p>
    ///   - [`dkim_attributes(Option<DkimAttributes>)`](crate::output::GetEmailIdentityOutput::dkim_attributes): <p>An object that contains information about the DKIM attributes for the identity. This object includes the tokens that you use to create the CNAME records that are required to complete the DKIM verification process.</p>
    ///   - [`mail_from_attributes(Option<MailFromAttributes>)`](crate::output::GetEmailIdentityOutput::mail_from_attributes): <p>An object that contains information about the Mail-From attributes for the email identity.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetEmailIdentityOutput::tags): <p>An array of objects that define the tags (keys and values) that are associated with the email identity.</p>
    /// - On failure, responds with [`SdkError<GetEmailIdentityError>`](crate::error::GetEmailIdentityError)
    pub fn get_email_identity(&self) -> fluent_builders::GetEmailIdentity {
        fluent_builders::GetEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationSets`](crate::client::fluent_builders::ListConfigurationSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConfigurationSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationSets::set_next_token): <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListConfigurationSets::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListConfigurationSets::set_page_size): <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput) with field(s):
    ///   - [`configuration_sets(Option<Vec<String>>)`](crate::output::ListConfigurationSetsOutput::configuration_sets): <p>An array that contains all of the configuration sets in your Amazon Pinpoint account in the current AWS Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationSetsOutput::next_token): <p>A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to <code>ListConfigurationSets</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationSetsError>`](crate::error::ListConfigurationSetsError)
    pub fn list_configuration_sets(&self) -> fluent_builders::ListConfigurationSets {
        fluent_builders::ListConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDedicatedIpPools`](crate::client::fluent_builders::ListDedicatedIpPools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDedicatedIpPools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDedicatedIpPools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDedicatedIpPools::set_next_token): <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDedicatedIpPools::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDedicatedIpPools::set_page_size): <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListDedicatedIpPoolsOutput`](crate::output::ListDedicatedIpPoolsOutput) with field(s):
    ///   - [`dedicated_ip_pools(Option<Vec<String>>)`](crate::output::ListDedicatedIpPoolsOutput::dedicated_ip_pools): <p>A list of all of the dedicated IP pools that are associated with your Amazon Pinpoint account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDedicatedIpPoolsOutput::next_token): <p>A token that indicates that there are additional IP pools to list. To view additional IP pools, issue another request to <code>ListDedicatedIpPools</code>, passing this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListDedicatedIpPoolsError>`](crate::error::ListDedicatedIpPoolsError)
    pub fn list_dedicated_ip_pools(&self) -> fluent_builders::ListDedicatedIpPools {
        fluent_builders::ListDedicatedIpPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeliverabilityTestReports`](crate::client::fluent_builders::ListDeliverabilityTestReports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeliverabilityTestReports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeliverabilityTestReports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeliverabilityTestReports::set_next_token): <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDeliverabilityTestReports::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDeliverabilityTestReports::set_page_size): <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>  <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    /// - On success, responds with [`ListDeliverabilityTestReportsOutput`](crate::output::ListDeliverabilityTestReportsOutput) with field(s):
    ///   - [`deliverability_test_reports(Option<Vec<DeliverabilityTestReport>>)`](crate::output::ListDeliverabilityTestReportsOutput::deliverability_test_reports): <p>An object that contains a lists of predictive inbox placement tests that you've performed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeliverabilityTestReportsOutput::next_token): <p>A token that indicates that there are additional predictive inbox placement tests to list. To view additional predictive inbox placement tests, issue another request to <code>ListDeliverabilityTestReports</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListDeliverabilityTestReportsError>`](crate::error::ListDeliverabilityTestReportsError)
    pub fn list_deliverability_test_reports(
        &self,
    ) -> fluent_builders::ListDeliverabilityTestReports {
        fluent_builders::ListDeliverabilityTestReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainDeliverabilityCampaigns`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_start_date): <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_end_date): <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
    ///   - [`subscribed_domain(impl Into<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::subscribed_domain) / [`set_subscribed_domain(Option<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_subscribed_domain): <p>The domain to obtain deliverability data for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_next_token): <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_page_size): <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListDomainDeliverabilityCampaignsOutput`](crate::output::ListDomainDeliverabilityCampaignsOutput) with field(s):
    ///   - [`domain_deliverability_campaigns(Option<Vec<DomainDeliverabilityCampaign>>)`](crate::output::ListDomainDeliverabilityCampaignsOutput::domain_deliverability_campaigns): <p>An array of responses, one for each campaign that used the domain to send email during the specified time range.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainDeliverabilityCampaignsOutput::next_token): <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of the campaign in the list of campaigns.</p>
    /// - On failure, responds with [`SdkError<ListDomainDeliverabilityCampaignsError>`](crate::error::ListDomainDeliverabilityCampaignsError)
    pub fn list_domain_deliverability_campaigns(
        &self,
    ) -> fluent_builders::ListDomainDeliverabilityCampaigns {
        fluent_builders::ListDomainDeliverabilityCampaigns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEmailIdentities`](crate::client::fluent_builders::ListEmailIdentities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEmailIdentities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEmailIdentities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEmailIdentities::set_next_token): <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListEmailIdentities::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListEmailIdentities::set_page_size): <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>  <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    /// - On success, responds with [`ListEmailIdentitiesOutput`](crate::output::ListEmailIdentitiesOutput) with field(s):
    ///   - [`email_identities(Option<Vec<IdentityInfo>>)`](crate::output::ListEmailIdentitiesOutput::email_identities): <p>An array that includes all of the identities associated with your Amazon Pinpoint account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEmailIdentitiesOutput::next_token): <p>A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListEmailIdentitiesError>`](crate::error::ListEmailIdentitiesError)
    pub fn list_email_identities(&self) -> fluent_builders::ListEmailIdentities {
        fluent_builders::ListEmailIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array that lists all the tags that are associated with the resource. Each tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>)</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountDedicatedIpWarmupAttributes`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_warmup_enabled(bool)`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes::auto_warmup_enabled) / [`set_auto_warmup_enabled(bool)`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes::set_auto_warmup_enabled): <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
    /// - On success, responds with [`PutAccountDedicatedIpWarmupAttributesOutput`](crate::output::PutAccountDedicatedIpWarmupAttributesOutput)

    /// - On failure, responds with [`SdkError<PutAccountDedicatedIpWarmupAttributesError>`](crate::error::PutAccountDedicatedIpWarmupAttributesError)
    pub fn put_account_dedicated_ip_warmup_attributes(
        &self,
    ) -> fluent_builders::PutAccountDedicatedIpWarmupAttributes {
        fluent_builders::PutAccountDedicatedIpWarmupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountSendingAttributes`](crate::client::fluent_builders::PutAccountSendingAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sending_enabled(bool)`](crate::client::fluent_builders::PutAccountSendingAttributes::sending_enabled) / [`set_sending_enabled(bool)`](crate::client::fluent_builders::PutAccountSendingAttributes::set_sending_enabled): <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>   <p>If AWS paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>  </note>
    /// - On success, responds with [`PutAccountSendingAttributesOutput`](crate::output::PutAccountSendingAttributesOutput)

    /// - On failure, responds with [`SdkError<PutAccountSendingAttributesError>`](crate::error::PutAccountSendingAttributesError)
    pub fn put_account_sending_attributes(&self) -> fluent_builders::PutAccountSendingAttributes {
        fluent_builders::PutAccountSendingAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetDeliveryOptions`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_configuration_set_name): <p>The name of the configuration set that you want to associate with a dedicated IP pool.</p>
    ///   - [`tls_policy(TlsPolicy)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::tls_policy) / [`set_tls_policy(Option<TlsPolicy>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_tls_policy): <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
    ///   - [`sending_pool_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::sending_pool_name) / [`set_sending_pool_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_sending_pool_name): <p>The name of the dedicated IP pool that you want to associate with the configuration set.</p>
    /// - On success, responds with [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetDeliveryOptionsError>`](crate::error::PutConfigurationSetDeliveryOptionsError)
    pub fn put_configuration_set_delivery_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetDeliveryOptions {
        fluent_builders::PutConfigurationSetDeliveryOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetReputationOptions`](crate::client::fluent_builders::PutConfigurationSetReputationOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::set_configuration_set_name): <p>The name of the configuration set that you want to enable or disable reputation metric tracking for.</p>
    ///   - [`reputation_metrics_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::reputation_metrics_enabled) / [`set_reputation_metrics_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::set_reputation_metrics_enabled): <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
    /// - On success, responds with [`PutConfigurationSetReputationOptionsOutput`](crate::output::PutConfigurationSetReputationOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetReputationOptionsError>`](crate::error::PutConfigurationSetReputationOptionsError)
    pub fn put_configuration_set_reputation_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetReputationOptions {
        fluent_builders::PutConfigurationSetReputationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetSendingOptions`](crate::client::fluent_builders::PutConfigurationSetSendingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::set_configuration_set_name): <p>The name of the configuration set that you want to enable or disable email sending for.</p>
    ///   - [`sending_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::sending_enabled) / [`set_sending_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::set_sending_enabled): <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
    /// - On success, responds with [`PutConfigurationSetSendingOptionsOutput`](crate::output::PutConfigurationSetSendingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetSendingOptionsError>`](crate::error::PutConfigurationSetSendingOptionsError)
    pub fn put_configuration_set_sending_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetSendingOptions {
        fluent_builders::PutConfigurationSetSendingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetTrackingOptions`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::set_configuration_set_name): <p>The name of the configuration set that you want to add a custom tracking domain to.</p>
    ///   - [`custom_redirect_domain(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::custom_redirect_domain) / [`set_custom_redirect_domain(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::set_custom_redirect_domain): <p>The domain that you want to use to track open and click events.</p>
    /// - On success, responds with [`PutConfigurationSetTrackingOptionsOutput`](crate::output::PutConfigurationSetTrackingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetTrackingOptionsError>`](crate::error::PutConfigurationSetTrackingOptionsError)
    pub fn put_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetTrackingOptions {
        fluent_builders::PutConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDedicatedIpInPool`](crate::client::fluent_builders::PutDedicatedIpInPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip(impl Into<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::ip) / [`set_ip(Option<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::set_ip): <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Pinpoint account.</p>
    ///   - [`destination_pool_name(impl Into<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::destination_pool_name) / [`set_destination_pool_name(Option<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::set_destination_pool_name): <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
    /// - On success, responds with [`PutDedicatedIpInPoolOutput`](crate::output::PutDedicatedIpInPoolOutput)

    /// - On failure, responds with [`SdkError<PutDedicatedIpInPoolError>`](crate::error::PutDedicatedIpInPoolError)
    pub fn put_dedicated_ip_in_pool(&self) -> fluent_builders::PutDedicatedIpInPool {
        fluent_builders::PutDedicatedIpInPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDedicatedIpWarmupAttributes`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip(impl Into<String>)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::ip) / [`set_ip(Option<String>)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::set_ip): <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
    ///   - [`warmup_percentage(i32)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::warmup_percentage) / [`set_warmup_percentage(Option<i32>)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::set_warmup_percentage): <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
    /// - On success, responds with [`PutDedicatedIpWarmupAttributesOutput`](crate::output::PutDedicatedIpWarmupAttributesOutput)

    /// - On failure, responds with [`SdkError<PutDedicatedIpWarmupAttributesError>`](crate::error::PutDedicatedIpWarmupAttributesError)
    pub fn put_dedicated_ip_warmup_attributes(
        &self,
    ) -> fluent_builders::PutDedicatedIpWarmupAttributes {
        fluent_builders::PutDedicatedIpWarmupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDeliverabilityDashboardOption`](crate::client::fluent_builders::PutDeliverabilityDashboardOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dashboard_enabled(bool)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::dashboard_enabled) / [`set_dashboard_enabled(bool)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::set_dashboard_enabled): <p>Specifies whether to enable the Deliverability dashboard for your Amazon Pinpoint account. To enable the dashboard, set this value to <code>true</code>.</p>
    ///   - [`subscribed_domains(Vec<DomainDeliverabilityTrackingOption>)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::subscribed_domains) / [`set_subscribed_domains(Option<Vec<DomainDeliverabilityTrackingOption>>)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::set_subscribed_domains): <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
    /// - On success, responds with [`PutDeliverabilityDashboardOptionOutput`](crate::output::PutDeliverabilityDashboardOptionOutput)

    /// - On failure, responds with [`SdkError<PutDeliverabilityDashboardOptionError>`](crate::error::PutDeliverabilityDashboardOptionError)
    pub fn put_deliverability_dashboard_option(
        &self,
    ) -> fluent_builders::PutDeliverabilityDashboardOption {
        fluent_builders::PutDeliverabilityDashboardOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityDkimAttributes`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::set_email_identity): <p>The email identity that you want to change the DKIM settings for.</p>
    ///   - [`signing_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::signing_enabled) / [`set_signing_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::set_signing_enabled): <p>Sets the DKIM signing configuration for the identity.</p>  <p>When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.</p>
    /// - On success, responds with [`PutEmailIdentityDkimAttributesOutput`](crate::output::PutEmailIdentityDkimAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityDkimAttributesError>`](crate::error::PutEmailIdentityDkimAttributesError)
    pub fn put_email_identity_dkim_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityDkimAttributes {
        fluent_builders::PutEmailIdentityDkimAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityFeedbackAttributes`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::set_email_identity): <p>The email identity that you want to configure bounce and complaint feedback forwarding for.</p>
    ///   - [`email_forwarding_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::email_forwarding_enabled) / [`set_email_forwarding_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::set_email_forwarding_enabled): <p>Sets the feedback forwarding configuration for the identity.</p>  <p>If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.</p>  <p>When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).</p>
    /// - On success, responds with [`PutEmailIdentityFeedbackAttributesOutput`](crate::output::PutEmailIdentityFeedbackAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityFeedbackAttributesError>`](crate::error::PutEmailIdentityFeedbackAttributesError)
    pub fn put_email_identity_feedback_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityFeedbackAttributes {
        fluent_builders::PutEmailIdentityFeedbackAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityMailFromAttributes`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::set_email_identity): <p>The verified email identity that you want to set up the custom MAIL FROM domain for.</p>
    ///   - [`mail_from_domain(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::mail_from_domain) / [`set_mail_from_domain(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::set_mail_from_domain): <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>  <ul>   <li> <p>It has to be a subdomain of the verified identity.</p> </li>   <li> <p>It can't be used to receive email.</p> </li>   <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>  </ul>
    ///   - [`behavior_on_mx_failure(BehaviorOnMxFailure)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::behavior_on_mx_failure) / [`set_behavior_on_mx_failure(Option<BehaviorOnMxFailure>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::set_behavior_on_mx_failure): <p>The action that you want Amazon Pinpoint to take if it can't read the required MX record when you send an email. When you set this value to <code>UseDefaultValue</code>, Amazon Pinpoint uses <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, Amazon Pinpoint returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>  <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
    /// - On success, responds with [`PutEmailIdentityMailFromAttributesOutput`](crate::output::PutEmailIdentityMailFromAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityMailFromAttributesError>`](crate::error::PutEmailIdentityMailFromAttributesError)
    pub fn put_email_identity_mail_from_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityMailFromAttributes {
        fluent_builders::PutEmailIdentityMailFromAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendEmail`](crate::client::fluent_builders::SendEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::SendEmail::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::SendEmail::set_from_email_address): <p>The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. </p>
    ///   - [`destination(Destination)`](crate::client::fluent_builders::SendEmail::destination) / [`set_destination(Option<Destination>)`](crate::client::fluent_builders::SendEmail::set_destination): <p>An object that contains the recipients of the email message.</p>
    ///   - [`reply_to_addresses(Vec<String>)`](crate::client::fluent_builders::SendEmail::reply_to_addresses) / [`set_reply_to_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::SendEmail::set_reply_to_addresses): <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    ///   - [`feedback_forwarding_email_address(impl Into<String>)`](crate::client::fluent_builders::SendEmail::feedback_forwarding_email_address) / [`set_feedback_forwarding_email_address(Option<String>)`](crate::client::fluent_builders::SendEmail::set_feedback_forwarding_email_address): <p>The address that Amazon Pinpoint should send bounce and complaint notifications to.</p>
    ///   - [`content(EmailContent)`](crate::client::fluent_builders::SendEmail::content) / [`set_content(Option<EmailContent>)`](crate::client::fluent_builders::SendEmail::set_content): <p>An object that contains the body of the message. You can send either a Simple message or a Raw message.</p>
    ///   - [`email_tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendEmail::email_tags) / [`set_email_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendEmail::set_email_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendEmail::set_configuration_set_name): <p>The name of the configuration set that you want to use when sending the email.</p>
    /// - On success, responds with [`SendEmailOutput`](crate::output::SendEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendEmailOutput::message_id): <p>A unique identifier for the message that is generated when Amazon Pinpoint accepts the message.</p> <note>   <p>It is possible for Amazon Pinpoint to accept a message without sending it. This can happen when the message you're trying to send has an attachment doesn't pass a virus check, or when you send a templated email that contains invalid personalization content, for example.</p>  </note>
    /// - On failure, responds with [`SdkError<SendEmailError>`](crate::error::SendEmailError)
    pub fn send_email(&self) -> fluent_builders::SendEmail {
        fluent_builders::SendEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>  <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v1/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetEventDestination`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that contains the event destination that you want to modify.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination_name): <p>The name of the event destination that you want to modify.</p>
    ///   - [`event_destination(EventDestinationDefinition)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestinationDefinition>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination): <p>An object that defines the event destination.</p>
    /// - On success, responds with [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetEventDestinationError>`](crate::error::UpdateConfigurationSetEventDestinationError)
    pub fn update_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetEventDestination {
        fluent_builders::UpdateConfigurationSetEventDestination::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// <p>Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl CreateConfigurationSet {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(input);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
        pub fn delivery_options(mut self, input: crate::model::DeliveryOptions) -> Self {
            self.inner = self.inner.delivery_options(input);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.inner = self.inner.set_delivery_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.</p>
        pub fn reputation_options(mut self, input: crate::model::ReputationOptions) -> Self {
            self.inner = self.inner.reputation_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.</p>
        pub fn set_reputation_options(
            mut self,
            input: std::option::Option<crate::model::ReputationOptions>,
        ) -> Self {
            self.inner = self.inner.set_reputation_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.</p>
        pub fn sending_options(mut self, input: crate::model::SendingOptions) -> Self {
            self.inner = self.inner.sending_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.</p>
        pub fn set_sending_options(
            mut self,
            input: std::option::Option<crate::model::SendingOptions>,
        ) -> Self {
            self.inner = self.inner.set_sending_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the configuration set.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the configuration set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetEventDestination`.
    ///
    /// <p>Create an event destination. In Amazon Pinpoint, <i>events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    /// <p>A single configuration set can include more than one event destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_event_destination_input::Builder,
    }
    impl CreateConfigurationSetEventDestination {
        /// Creates a new `CreateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to add an event destination to.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to add an event destination to.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDedicatedIpPool`.
    ///
    /// <p>Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDedicatedIpPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dedicated_ip_pool_input::Builder,
    }
    impl CreateDedicatedIpPool {
        /// Creates a new `CreateDedicatedIpPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDedicatedIpPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDedicatedIpPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeliverabilityTestReport`.
    ///
    /// <p>Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon Pinpoint then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeliverabilityTestReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deliverability_test_report_input::Builder,
    }
    impl CreateDeliverabilityTestReport {
        /// Creates a new `CreateDeliverabilityTestReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeliverabilityTestReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeliverabilityTestReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
        pub fn report_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_name(input.into());
            self
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
        pub fn set_report_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_name(input);
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailIdentity`.
    ///
    /// <p>Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address.</p>
    /// <p>When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email. </p>
    /// <p>When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_email_identity_input::Builder,
    }
    impl CreateEmailIdentity {
        /// Creates a new `CreateEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address or domain that you want to verify.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email address or domain that you want to verify.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the email identity.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the email identity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// <p>Delete an existing configuration set.</p>
    /// <p>In Amazon Pinpoint, <i>configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl DeleteConfigurationSet {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to delete.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetEventDestination`.
    ///
    /// <p>Delete an event destination.</p>
    /// <p>In Amazon Pinpoint, <i>events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_event_destination_input::Builder,
    }
    impl DeleteConfigurationSetEventDestination {
        /// Creates a new `DeleteConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination that you want to delete.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination that you want to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination that you want to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name of the event destination that you want to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDedicatedIpPool`.
    ///
    /// <p>Delete a dedicated IP pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDedicatedIpPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dedicated_ip_pool_input::Builder,
    }
    impl DeleteDedicatedIpPool {
        /// Creates a new `DeleteDedicatedIpPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDedicatedIpPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDedicatedIpPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailIdentity`.
    ///
    /// <p>Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_email_identity_input::Builder,
    }
    impl DeleteEmailIdentity {
        /// Creates a new `DeleteEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity (that is, the email address or domain) that you want to delete from your Amazon Pinpoint account.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The identity (that is, the email address or domain) that you want to delete from your Amazon Pinpoint account.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_input::Builder,
    }
    impl GetAccount {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetBlacklistReports`.
    ///
    /// <p>Retrieve a list of the blacklists that your dedicated IP addresses appear on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBlacklistReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_blacklist_reports_input::Builder,
    }
    impl GetBlacklistReports {
        /// Creates a new `GetBlacklistReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlacklistReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlacklistReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `BlacklistItemNames`.
        ///
        /// To override the contents of this collection use [`set_blacklist_item_names`](Self::set_blacklist_item_names).
        ///
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon Pinpoint or Amazon SES.</p>
        pub fn blacklist_item_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blacklist_item_names(input.into());
            self
        }
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon Pinpoint or Amazon SES.</p>
        pub fn set_blacklist_item_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_blacklist_item_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSet`.
    ///
    /// <p>Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.</p>
    /// <p>In Amazon Pinpoint, <i>configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_set_input::Builder,
    }
    impl GetConfigurationSet {
        /// Creates a new `GetConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to obtain more information about.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to obtain more information about.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSetEventDestinations`.
    ///
    /// <p>Retrieve a list of event destinations that are associated with a configuration set.</p>
    /// <p>In Amazon Pinpoint, <i>events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfigurationSetEventDestinations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_set_event_destinations_input::Builder,
    }
    impl GetConfigurationSetEventDestinations {
        /// Creates a new `GetConfigurationSetEventDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetEventDestinationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetConfigurationSetEventDestinationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDedicatedIp`.
    ///
    /// <p>Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDedicatedIp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dedicated_ip_input::Builder,
    }
    impl GetDedicatedIp {
        /// Creates a new `GetDedicatedIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDedicatedIpOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDedicatedIpError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Pinpoint account.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(input.into());
            self
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Pinpoint account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDedicatedIps`.
    ///
    /// <p>List the dedicated IP addresses that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDedicatedIps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dedicated_ips_input::Builder,
    }
    impl GetDedicatedIps {
        /// Creates a new `GetDedicatedIps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDedicatedIpsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDedicatedIpsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDedicatedIpsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDedicatedIpsPaginator {
            crate::paginator::GetDedicatedIpsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeliverabilityDashboardOptions`.
    ///
    /// <p>Retrieve information about the status of the Deliverability dashboard for your Amazon Pinpoint account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.</p>
    /// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon Pinpoint. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeliverabilityDashboardOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deliverability_dashboard_options_input::Builder,
    }
    impl GetDeliverabilityDashboardOptions {
        /// Creates a new `GetDeliverabilityDashboardOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeliverabilityDashboardOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeliverabilityDashboardOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDeliverabilityTestReport`.
    ///
    /// <p>Retrieve the results of a predictive inbox placement test.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeliverabilityTestReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deliverability_test_report_input::Builder,
    }
    impl GetDeliverabilityTestReport {
        /// Creates a new `GetDeliverabilityTestReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeliverabilityTestReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeliverabilityTestReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainDeliverabilityCampaign`.
    ///
    /// <p>Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (<code>PutDeliverabilityDashboardOption</code> operation).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainDeliverabilityCampaign {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_deliverability_campaign_input::Builder,
    }
    impl GetDomainDeliverabilityCampaign {
        /// Creates a new `GetDomainDeliverabilityCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainDeliverabilityCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainDeliverabilityCampaignError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainStatisticsReport`.
    ///
    /// <p>Retrieve inbox placement and engagement rates for the domains that you use to send email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainStatisticsReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_statistics_report_input::Builder,
    }
    impl GetDomainStatisticsReport {
        /// Creates a new `GetDomainStatisticsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainStatisticsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainStatisticsReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailIdentity`.
    ///
    /// <p>Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_email_identity_input::Builder,
    }
    impl GetEmailIdentity {
        /// Creates a new `GetEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity that you want to retrieve details for.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity that you want to retrieve details for.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationSets`.
    ///
    /// <p>List all of the configuration sets associated with your Amazon Pinpoint account in the current region.</p>
    /// <p>In Amazon Pinpoint, <i>configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configuration_sets_input::Builder,
    }
    impl ListConfigurationSets {
        /// Creates a new `ListConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConfigurationSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConfigurationSetsPaginator {
            crate::paginator::ListConfigurationSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDedicatedIpPools`.
    ///
    /// <p>List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDedicatedIpPools {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dedicated_ip_pools_input::Builder,
    }
    impl ListDedicatedIpPools {
        /// Creates a new `ListDedicatedIpPools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDedicatedIpPoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDedicatedIpPoolsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDedicatedIpPoolsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDedicatedIpPoolsPaginator {
            crate::paginator::ListDedicatedIpPoolsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeliverabilityTestReports`.
    ///
    /// <p>Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeliverabilityTestReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deliverability_test_reports_input::Builder,
    }
    impl ListDeliverabilityTestReports {
        /// Creates a new `ListDeliverabilityTestReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeliverabilityTestReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeliverabilityTestReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeliverabilityTestReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeliverabilityTestReportsPaginator {
            crate::paginator::ListDeliverabilityTestReportsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainDeliverabilityCampaigns`.
    ///
    /// <p>Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard (<code>PutDeliverabilityDashboardOption</code> operation) for the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainDeliverabilityCampaigns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domain_deliverability_campaigns_input::Builder,
    }
    impl ListDomainDeliverabilityCampaigns {
        /// Creates a new `ListDomainDeliverabilityCampaigns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainDeliverabilityCampaignsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainDeliverabilityCampaignsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainDeliverabilityCampaignsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDomainDeliverabilityCampaignsPaginator {
            crate::paginator::ListDomainDeliverabilityCampaignsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn subscribed_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscribed_domain(input.into());
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn set_subscribed_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscribed_domain(input);
            self
        }
        /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEmailIdentities`.
    ///
    /// <p>Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEmailIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_email_identities_input::Builder,
    }
    impl ListEmailIdentities {
        /// Creates a new `ListEmailIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEmailIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEmailIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEmailIdentitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEmailIdentitiesPaginator {
            crate::paginator::ListEmailIdentitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieve a list of the tags (keys and values) that are associated with a specified resource. A&nbsp;<i>tag</i>&nbsp;is a label that you optionally define and associate with a resource in Amazon Pinpoint. Each tag consists of a required&nbsp;<i>tag key</i>&nbsp;and an optional associated&nbsp;<i>tag value</i>. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountDedicatedIpWarmupAttributes`.
    ///
    /// <p>Enable or disable the automatic warm-up feature for dedicated IP addresses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountDedicatedIpWarmupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder,
    }
    impl PutAccountDedicatedIpWarmupAttributes {
        /// Creates a new `PutAccountDedicatedIpWarmupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountDedicatedIpWarmupAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccountDedicatedIpWarmupAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
        pub fn auto_warmup_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_warmup_enabled(input);
            self
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
        pub fn set_auto_warmup_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_warmup_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSendingAttributes`.
    ///
    /// <p>Enable or disable the ability of your account to send email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountSendingAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_sending_attributes_input::Builder,
    }
    impl PutAccountSendingAttributes {
        /// Creates a new `PutAccountSendingAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSendingAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSendingAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
        /// <p>If AWS paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
        /// </note>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.sending_enabled(input);
            self
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
        /// <p>If AWS paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
        /// </note>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sending_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetDeliveryOptions`.
    ///
    /// <p>Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetDeliveryOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_delivery_options_input::Builder,
    }
    impl PutConfigurationSetDeliveryOptions {
        /// Creates a new `PutConfigurationSetDeliveryOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetDeliveryOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetDeliveryOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to associate with a dedicated IP pool.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to associate with a dedicated IP pool.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn tls_policy(mut self, input: crate::model::TlsPolicy) -> Self {
            self.inner = self.inner.tls_policy(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.inner = self.inner.set_tls_policy(input);
            self
        }
        /// <p>The name of the dedicated IP pool that you want to associate with the configuration set.</p>
        pub fn sending_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sending_pool_name(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool that you want to associate with the configuration set.</p>
        pub fn set_sending_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sending_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetReputationOptions`.
    ///
    /// <p>Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetReputationOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_reputation_options_input::Builder,
    }
    impl PutConfigurationSetReputationOptions {
        /// Creates a new `PutConfigurationSetReputationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetReputationOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetReputationOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to enable or disable reputation metric tracking for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to enable or disable reputation metric tracking for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
        pub fn reputation_metrics_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.reputation_metrics_enabled(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
        pub fn set_reputation_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reputation_metrics_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetSendingOptions`.
    ///
    /// <p>Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetSendingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_sending_options_input::Builder,
    }
    impl PutConfigurationSetSendingOptions {
        /// Creates a new `PutConfigurationSetSendingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetSendingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConfigurationSetSendingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to enable or disable email sending for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to enable or disable email sending for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.sending_enabled(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sending_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetTrackingOptions`.
    ///
    /// <p>Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetTrackingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_tracking_options_input::Builder,
    }
    impl PutConfigurationSetTrackingOptions {
        /// Creates a new `PutConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetTrackingOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to add a custom tracking domain to.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to add a custom tracking domain to.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The domain that you want to use to track open and click events.</p>
        pub fn custom_redirect_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_redirect_domain(input.into());
            self
        }
        /// <p>The domain that you want to use to track open and click events.</p>
        pub fn set_custom_redirect_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_redirect_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDedicatedIpInPool`.
    ///
    /// <p>Move a dedicated IP address to an existing dedicated IP pool.</p> <note>
    /// <p>The dedicated IP address that you specify must already exist, and must be associated with your Amazon Pinpoint account. </p>
    /// <p>The dedicated IP pool you specify must already exist. You can create a new pool by using the <code>CreateDedicatedIpPool</code> operation.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDedicatedIpInPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_dedicated_ip_in_pool_input::Builder,
    }
    impl PutDedicatedIpInPool {
        /// Creates a new `PutDedicatedIpInPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDedicatedIpInPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDedicatedIpInPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Pinpoint account.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(input.into());
            self
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Pinpoint account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
        pub fn destination_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_pool_name(input.into());
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
        pub fn set_destination_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDedicatedIpWarmupAttributes`.
    ///
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDedicatedIpWarmupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_dedicated_ip_warmup_attributes_input::Builder,
    }
    impl PutDedicatedIpWarmupAttributes {
        /// Creates a new `PutDedicatedIpWarmupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDedicatedIpWarmupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDedicatedIpWarmupAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(input.into());
            self
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
        pub fn warmup_percentage(mut self, input: i32) -> Self {
            self.inner = self.inner.warmup_percentage(input);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
        pub fn set_warmup_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_warmup_percentage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDeliverabilityDashboardOption`.
    ///
    /// <p>Enable or disable the Deliverability dashboard for your Amazon Pinpoint account. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.</p>
    /// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon Pinpoint. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDeliverabilityDashboardOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_deliverability_dashboard_option_input::Builder,
    }
    impl PutDeliverabilityDashboardOption {
        /// Creates a new `PutDeliverabilityDashboardOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDeliverabilityDashboardOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDeliverabilityDashboardOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to enable the Deliverability dashboard for your Amazon Pinpoint account. To enable the dashboard, set this value to <code>true</code>.</p>
        pub fn dashboard_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.dashboard_enabled(input);
            self
        }
        /// <p>Specifies whether to enable the Deliverability dashboard for your Amazon Pinpoint account. To enable the dashboard, set this value to <code>true</code>.</p>
        pub fn set_dashboard_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dashboard_enabled(input);
            self
        }
        /// Appends an item to `SubscribedDomains`.
        ///
        /// To override the contents of this collection use [`set_subscribed_domains`](Self::set_subscribed_domains).
        ///
        /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
        pub fn subscribed_domains(
            mut self,
            input: crate::model::DomainDeliverabilityTrackingOption,
        ) -> Self {
            self.inner = self.inner.subscribed_domains(input);
            self
        }
        /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
        pub fn set_subscribed_domains(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DomainDeliverabilityTrackingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_subscribed_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityDkimAttributes`.
    ///
    /// <p>Used to enable or disable DKIM authentication for an email identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityDkimAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_dkim_attributes_input::Builder,
    }
    impl PutEmailIdentityDkimAttributes {
        /// Creates a new `PutEmailIdentityDkimAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityDkimAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEmailIdentityDkimAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity that you want to change the DKIM settings for.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity that you want to change the DKIM settings for.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.</p>
        pub fn signing_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.signing_enabled(input);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.</p>
        pub fn set_signing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_signing_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityFeedbackAttributes`.
    ///
    /// <p>Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.</p>
    /// <p>When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.</p>
    /// <p>When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityFeedbackAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_feedback_attributes_input::Builder,
    }
    impl PutEmailIdentityFeedbackAttributes {
        /// Creates a new `PutEmailIdentityFeedbackAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityFeedbackAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityFeedbackAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity that you want to configure bounce and complaint feedback forwarding for.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity that you want to configure bounce and complaint feedback forwarding for.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.</p>
        /// <p>When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).</p>
        pub fn email_forwarding_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.email_forwarding_enabled(input);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.</p>
        /// <p>When you set this value to <code>false</code>, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).</p>
        pub fn set_email_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_email_forwarding_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityMailFromAttributes`.
    ///
    /// <p>Used to enable or disable the custom Mail-From domain configuration for an email identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityMailFromAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_mail_from_attributes_input::Builder,
    }
    impl PutEmailIdentityMailFromAttributes {
        /// Creates a new `PutEmailIdentityMailFromAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityMailFromAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityMailFromAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The verified email identity that you want to set up the custom MAIL FROM domain for.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The verified email identity that you want to set up the custom MAIL FROM domain for.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
        /// <li> <p>It can't be used to receive email.</p> </li>
        /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
        /// </ul>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mail_from_domain(input.into());
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
        /// <li> <p>It can't be used to receive email.</p> </li>
        /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
        /// </ul>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mail_from_domain(input);
            self
        }
        /// <p>The action that you want Amazon Pinpoint to take if it can't read the required MX record when you send an email. When you set this value to <code>UseDefaultValue</code>, Amazon Pinpoint uses <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, Amazon Pinpoint returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.inner = self.inner.behavior_on_mx_failure(input);
            self
        }
        /// <p>The action that you want Amazon Pinpoint to take if it can't read the required MX record when you send an email. When you set this value to <code>UseDefaultValue</code>, Amazon Pinpoint uses <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, Amazon Pinpoint returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.inner = self.inner.set_behavior_on_mx_failure(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEmail`.
    ///
    /// <p>Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:</p>
    /// <ul>
    /// <li> <p> <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon Pinpoint assembles the message for you.</p> </li>
    /// <li> <p> <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_email_input::Builder,
    }
    impl SendEmail {
        /// Creates a new `SendEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. </p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. </p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(input.into());
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The address that Amazon Pinpoint should send bounce and complaint notifications to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.feedback_forwarding_email_address(input.into());
            self
        }
        /// <p>The address that Amazon Pinpoint should send bounce and complaint notifications to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feedback_forwarding_email_address(input);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message or a Raw message.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message or a Raw message.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `EmailTags`.
        ///
        /// To override the contents of this collection use [`set_email_tags`](Self::set_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
        pub fn email_tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.email_tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
        pub fn set_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_email_tags(input);
            self
        }
        /// <p>The name of the configuration set that you want to use when sending the email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add one or more tags (keys and values) to a specified resource. A <i>tag</i>&nbsp;is a label that you optionally define and associate with a resource in Amazon Pinpoint. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.</p>
    /// <p>Each tag consists of a required&nbsp;<i>tag key</i>&nbsp;and an associated&nbsp;<i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove one or more tags (keys and values) from a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v1/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v1/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetEventDestination`.
    ///
    /// <p>Update the configuration of an event destination for a configuration set.</p>
    /// <p>In Amazon Pinpoint, <i>events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_event_destination_input::Builder,
    }
    impl UpdateConfigurationSetEventDestination {
        /// Creates a new `UpdateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination that you want to modify.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination that you want to modify.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination that you want to modify.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name of the event destination that you want to modify.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
