// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_set`](crate::client::Client::create_configuration_set).
///
/// See [`crate::client::fluent_builders::CreateConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationSet {
    _private: (),
}
impl CreateConfigurationSet {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationSet {
    type Output = std::result::Result<
        crate::output::CreateConfigurationSetOutput,
        crate::error::CreateConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_set_response(response)
        }
    }
}

/// Operation shape for `CreateConfigurationSetEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_set_event_destination`](crate::client::Client::create_configuration_set_event_destination).
///
/// See [`crate::client::fluent_builders::CreateConfigurationSetEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationSetEventDestination {
    _private: (),
}
impl CreateConfigurationSetEventDestination {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::create_configuration_set_event_destination_input::Builder {
        crate::input::create_configuration_set_event_destination_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationSetEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationSetEventDestination {
    type Output = std::result::Result<
        crate::output::CreateConfigurationSetEventDestinationOutput,
        crate::error::CreateConfigurationSetEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_set_event_destination_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_set_event_destination_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateDedicatedIpPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dedicated_ip_pool`](crate::client::Client::create_dedicated_ip_pool).
///
/// See [`crate::client::fluent_builders::CreateDedicatedIpPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDedicatedIpPool {
    _private: (),
}
impl CreateDedicatedIpPool {
    /// Creates a new builder-style object to manufacture [`CreateDedicatedIpPoolInput`](crate::input::CreateDedicatedIpPoolInput)
    pub fn builder() -> crate::input::create_dedicated_ip_pool_input::Builder {
        crate::input::create_dedicated_ip_pool_input::Builder::default()
    }
    /// Creates a new `CreateDedicatedIpPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDedicatedIpPool {
    type Output = std::result::Result<
        crate::output::CreateDedicatedIpPoolOutput,
        crate::error::CreateDedicatedIpPoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dedicated_ip_pool_error(response)
        } else {
            crate::operation_deser::parse_create_dedicated_ip_pool_response(response)
        }
    }
}

/// Operation shape for `CreateDeliverabilityTestReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deliverability_test_report`](crate::client::Client::create_deliverability_test_report).
///
/// See [`crate::client::fluent_builders::CreateDeliverabilityTestReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeliverabilityTestReport {
    _private: (),
}
impl CreateDeliverabilityTestReport {
    /// Creates a new builder-style object to manufacture [`CreateDeliverabilityTestReportInput`](crate::input::CreateDeliverabilityTestReportInput)
    pub fn builder() -> crate::input::create_deliverability_test_report_input::Builder {
        crate::input::create_deliverability_test_report_input::Builder::default()
    }
    /// Creates a new `CreateDeliverabilityTestReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeliverabilityTestReport {
    type Output = std::result::Result<
        crate::output::CreateDeliverabilityTestReportOutput,
        crate::error::CreateDeliverabilityTestReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_deliverability_test_report_error(response)
        } else {
            crate::operation_deser::parse_create_deliverability_test_report_response(response)
        }
    }
}

/// Operation shape for `CreateEmailIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_email_identity`](crate::client::Client::create_email_identity).
///
/// See [`crate::client::fluent_builders::CreateEmailIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEmailIdentity {
    _private: (),
}
impl CreateEmailIdentity {
    /// Creates a new builder-style object to manufacture [`CreateEmailIdentityInput`](crate::input::CreateEmailIdentityInput)
    pub fn builder() -> crate::input::create_email_identity_input::Builder {
        crate::input::create_email_identity_input::Builder::default()
    }
    /// Creates a new `CreateEmailIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEmailIdentity {
    type Output = std::result::Result<
        crate::output::CreateEmailIdentityOutput,
        crate::error::CreateEmailIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_email_identity_error(response)
        } else {
            crate::operation_deser::parse_create_email_identity_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_set`](crate::client::Client::delete_configuration_set).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationSet {
    _private: (),
}
impl DeleteConfigurationSet {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationSet {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationSetOutput,
        crate::error::DeleteConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_set_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationSetEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_set_event_destination`](crate::client::Client::delete_configuration_set_event_destination).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationSetEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationSetEventDestination {
    _private: (),
}
impl DeleteConfigurationSetEventDestination {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::delete_configuration_set_event_destination_input::Builder {
        crate::input::delete_configuration_set_event_destination_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationSetEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationSetEventDestination {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationSetEventDestinationOutput,
        crate::error::DeleteConfigurationSetEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_set_event_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_set_event_destination_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteDedicatedIpPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dedicated_ip_pool`](crate::client::Client::delete_dedicated_ip_pool).
///
/// See [`crate::client::fluent_builders::DeleteDedicatedIpPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDedicatedIpPool {
    _private: (),
}
impl DeleteDedicatedIpPool {
    /// Creates a new builder-style object to manufacture [`DeleteDedicatedIpPoolInput`](crate::input::DeleteDedicatedIpPoolInput)
    pub fn builder() -> crate::input::delete_dedicated_ip_pool_input::Builder {
        crate::input::delete_dedicated_ip_pool_input::Builder::default()
    }
    /// Creates a new `DeleteDedicatedIpPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDedicatedIpPool {
    type Output = std::result::Result<
        crate::output::DeleteDedicatedIpPoolOutput,
        crate::error::DeleteDedicatedIpPoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dedicated_ip_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_dedicated_ip_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteEmailIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_email_identity`](crate::client::Client::delete_email_identity).
///
/// See [`crate::client::fluent_builders::DeleteEmailIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEmailIdentity {
    _private: (),
}
impl DeleteEmailIdentity {
    /// Creates a new builder-style object to manufacture [`DeleteEmailIdentityInput`](crate::input::DeleteEmailIdentityInput)
    pub fn builder() -> crate::input::delete_email_identity_input::Builder {
        crate::input::delete_email_identity_input::Builder::default()
    }
    /// Creates a new `DeleteEmailIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEmailIdentity {
    type Output = std::result::Result<
        crate::output::DeleteEmailIdentityOutput,
        crate::error::DeleteEmailIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_email_identity_error(response)
        } else {
            crate::operation_deser::parse_delete_email_identity_response(response)
        }
    }
}

/// Operation shape for `GetAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account`](crate::client::Client::get_account).
///
/// See [`crate::client::fluent_builders::GetAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccount {
    _private: (),
}
impl GetAccount {
    /// Creates a new builder-style object to manufacture [`GetAccountInput`](crate::input::GetAccountInput)
    pub fn builder() -> crate::input::get_account_input::Builder {
        crate::input::get_account_input::Builder::default()
    }
    /// Creates a new `GetAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccount {
    type Output =
        std::result::Result<crate::output::GetAccountOutput, crate::error::GetAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_error(response)
        } else {
            crate::operation_deser::parse_get_account_response(response)
        }
    }
}

/// Operation shape for `GetBlacklistReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_blacklist_reports`](crate::client::Client::get_blacklist_reports).
///
/// See [`crate::client::fluent_builders::GetBlacklistReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlacklistReports {
    _private: (),
}
impl GetBlacklistReports {
    /// Creates a new builder-style object to manufacture [`GetBlacklistReportsInput`](crate::input::GetBlacklistReportsInput)
    pub fn builder() -> crate::input::get_blacklist_reports_input::Builder {
        crate::input::get_blacklist_reports_input::Builder::default()
    }
    /// Creates a new `GetBlacklistReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlacklistReports {
    type Output = std::result::Result<
        crate::output::GetBlacklistReportsOutput,
        crate::error::GetBlacklistReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_blacklist_reports_error(response)
        } else {
            crate::operation_deser::parse_get_blacklist_reports_response(response)
        }
    }
}

/// Operation shape for `GetConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_configuration_set`](crate::client::Client::get_configuration_set).
///
/// See [`crate::client::fluent_builders::GetConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConfigurationSet {
    _private: (),
}
impl GetConfigurationSet {
    /// Creates a new builder-style object to manufacture [`GetConfigurationSetInput`](crate::input::GetConfigurationSetInput)
    pub fn builder() -> crate::input::get_configuration_set_input::Builder {
        crate::input::get_configuration_set_input::Builder::default()
    }
    /// Creates a new `GetConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConfigurationSet {
    type Output = std::result::Result<
        crate::output::GetConfigurationSetOutput,
        crate::error::GetConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_get_configuration_set_response(response)
        }
    }
}

/// Operation shape for `GetConfigurationSetEventDestinations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_configuration_set_event_destinations`](crate::client::Client::get_configuration_set_event_destinations).
///
/// See [`crate::client::fluent_builders::GetConfigurationSetEventDestinations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConfigurationSetEventDestinations {
    _private: (),
}
impl GetConfigurationSetEventDestinations {
    /// Creates a new builder-style object to manufacture [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
    pub fn builder() -> crate::input::get_configuration_set_event_destinations_input::Builder {
        crate::input::get_configuration_set_event_destinations_input::Builder::default()
    }
    /// Creates a new `GetConfigurationSetEventDestinations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConfigurationSetEventDestinations {
    type Output = std::result::Result<
        crate::output::GetConfigurationSetEventDestinationsOutput,
        crate::error::GetConfigurationSetEventDestinationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_configuration_set_event_destinations_error(response)
        } else {
            crate::operation_deser::parse_get_configuration_set_event_destinations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetDedicatedIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dedicated_ip`](crate::client::Client::get_dedicated_ip).
///
/// See [`crate::client::fluent_builders::GetDedicatedIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDedicatedIp {
    _private: (),
}
impl GetDedicatedIp {
    /// Creates a new builder-style object to manufacture [`GetDedicatedIpInput`](crate::input::GetDedicatedIpInput)
    pub fn builder() -> crate::input::get_dedicated_ip_input::Builder {
        crate::input::get_dedicated_ip_input::Builder::default()
    }
    /// Creates a new `GetDedicatedIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDedicatedIp {
    type Output =
        std::result::Result<crate::output::GetDedicatedIpOutput, crate::error::GetDedicatedIpError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dedicated_ip_error(response)
        } else {
            crate::operation_deser::parse_get_dedicated_ip_response(response)
        }
    }
}

/// Operation shape for `GetDedicatedIps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dedicated_ips`](crate::client::Client::get_dedicated_ips).
///
/// See [`crate::client::fluent_builders::GetDedicatedIps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDedicatedIps {
    _private: (),
}
impl GetDedicatedIps {
    /// Creates a new builder-style object to manufacture [`GetDedicatedIpsInput`](crate::input::GetDedicatedIpsInput)
    pub fn builder() -> crate::input::get_dedicated_ips_input::Builder {
        crate::input::get_dedicated_ips_input::Builder::default()
    }
    /// Creates a new `GetDedicatedIps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDedicatedIps {
    type Output = std::result::Result<
        crate::output::GetDedicatedIpsOutput,
        crate::error::GetDedicatedIpsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dedicated_ips_error(response)
        } else {
            crate::operation_deser::parse_get_dedicated_ips_response(response)
        }
    }
}

/// Operation shape for `GetDeliverabilityDashboardOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deliverability_dashboard_options`](crate::client::Client::get_deliverability_dashboard_options).
///
/// See [`crate::client::fluent_builders::GetDeliverabilityDashboardOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeliverabilityDashboardOptions {
    _private: (),
}
impl GetDeliverabilityDashboardOptions {
    /// Creates a new builder-style object to manufacture [`GetDeliverabilityDashboardOptionsInput`](crate::input::GetDeliverabilityDashboardOptionsInput)
    pub fn builder() -> crate::input::get_deliverability_dashboard_options_input::Builder {
        crate::input::get_deliverability_dashboard_options_input::Builder::default()
    }
    /// Creates a new `GetDeliverabilityDashboardOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeliverabilityDashboardOptions {
    type Output = std::result::Result<
        crate::output::GetDeliverabilityDashboardOptionsOutput,
        crate::error::GetDeliverabilityDashboardOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deliverability_dashboard_options_error(response)
        } else {
            crate::operation_deser::parse_get_deliverability_dashboard_options_response(response)
        }
    }
}

/// Operation shape for `GetDeliverabilityTestReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deliverability_test_report`](crate::client::Client::get_deliverability_test_report).
///
/// See [`crate::client::fluent_builders::GetDeliverabilityTestReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeliverabilityTestReport {
    _private: (),
}
impl GetDeliverabilityTestReport {
    /// Creates a new builder-style object to manufacture [`GetDeliverabilityTestReportInput`](crate::input::GetDeliverabilityTestReportInput)
    pub fn builder() -> crate::input::get_deliverability_test_report_input::Builder {
        crate::input::get_deliverability_test_report_input::Builder::default()
    }
    /// Creates a new `GetDeliverabilityTestReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeliverabilityTestReport {
    type Output = std::result::Result<
        crate::output::GetDeliverabilityTestReportOutput,
        crate::error::GetDeliverabilityTestReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deliverability_test_report_error(response)
        } else {
            crate::operation_deser::parse_get_deliverability_test_report_response(response)
        }
    }
}

/// Operation shape for `GetDomainDeliverabilityCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_deliverability_campaign`](crate::client::Client::get_domain_deliverability_campaign).
///
/// See [`crate::client::fluent_builders::GetDomainDeliverabilityCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainDeliverabilityCampaign {
    _private: (),
}
impl GetDomainDeliverabilityCampaign {
    /// Creates a new builder-style object to manufacture [`GetDomainDeliverabilityCampaignInput`](crate::input::GetDomainDeliverabilityCampaignInput)
    pub fn builder() -> crate::input::get_domain_deliverability_campaign_input::Builder {
        crate::input::get_domain_deliverability_campaign_input::Builder::default()
    }
    /// Creates a new `GetDomainDeliverabilityCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainDeliverabilityCampaign {
    type Output = std::result::Result<
        crate::output::GetDomainDeliverabilityCampaignOutput,
        crate::error::GetDomainDeliverabilityCampaignError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_deliverability_campaign_error(response)
        } else {
            crate::operation_deser::parse_get_domain_deliverability_campaign_response(response)
        }
    }
}

/// Operation shape for `GetDomainStatisticsReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_statistics_report`](crate::client::Client::get_domain_statistics_report).
///
/// See [`crate::client::fluent_builders::GetDomainStatisticsReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainStatisticsReport {
    _private: (),
}
impl GetDomainStatisticsReport {
    /// Creates a new builder-style object to manufacture [`GetDomainStatisticsReportInput`](crate::input::GetDomainStatisticsReportInput)
    pub fn builder() -> crate::input::get_domain_statistics_report_input::Builder {
        crate::input::get_domain_statistics_report_input::Builder::default()
    }
    /// Creates a new `GetDomainStatisticsReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainStatisticsReport {
    type Output = std::result::Result<
        crate::output::GetDomainStatisticsReportOutput,
        crate::error::GetDomainStatisticsReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_statistics_report_error(response)
        } else {
            crate::operation_deser::parse_get_domain_statistics_report_response(response)
        }
    }
}

/// Operation shape for `GetEmailIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_email_identity`](crate::client::Client::get_email_identity).
///
/// See [`crate::client::fluent_builders::GetEmailIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEmailIdentity {
    _private: (),
}
impl GetEmailIdentity {
    /// Creates a new builder-style object to manufacture [`GetEmailIdentityInput`](crate::input::GetEmailIdentityInput)
    pub fn builder() -> crate::input::get_email_identity_input::Builder {
        crate::input::get_email_identity_input::Builder::default()
    }
    /// Creates a new `GetEmailIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEmailIdentity {
    type Output = std::result::Result<
        crate::output::GetEmailIdentityOutput,
        crate::error::GetEmailIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_email_identity_error(response)
        } else {
            crate::operation_deser::parse_get_email_identity_response(response)
        }
    }
}

/// Operation shape for `ListConfigurationSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_configuration_sets`](crate::client::Client::list_configuration_sets).
///
/// See [`crate::client::fluent_builders::ListConfigurationSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConfigurationSets {
    _private: (),
}
impl ListConfigurationSets {
    /// Creates a new builder-style object to manufacture [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    pub fn builder() -> crate::input::list_configuration_sets_input::Builder {
        crate::input::list_configuration_sets_input::Builder::default()
    }
    /// Creates a new `ListConfigurationSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConfigurationSets {
    type Output = std::result::Result<
        crate::output::ListConfigurationSetsOutput,
        crate::error::ListConfigurationSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_configuration_sets_error(response)
        } else {
            crate::operation_deser::parse_list_configuration_sets_response(response)
        }
    }
}

/// Operation shape for `ListDedicatedIpPools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dedicated_ip_pools`](crate::client::Client::list_dedicated_ip_pools).
///
/// See [`crate::client::fluent_builders::ListDedicatedIpPools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDedicatedIpPools {
    _private: (),
}
impl ListDedicatedIpPools {
    /// Creates a new builder-style object to manufacture [`ListDedicatedIpPoolsInput`](crate::input::ListDedicatedIpPoolsInput)
    pub fn builder() -> crate::input::list_dedicated_ip_pools_input::Builder {
        crate::input::list_dedicated_ip_pools_input::Builder::default()
    }
    /// Creates a new `ListDedicatedIpPools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDedicatedIpPools {
    type Output = std::result::Result<
        crate::output::ListDedicatedIpPoolsOutput,
        crate::error::ListDedicatedIpPoolsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dedicated_ip_pools_error(response)
        } else {
            crate::operation_deser::parse_list_dedicated_ip_pools_response(response)
        }
    }
}

/// Operation shape for `ListDeliverabilityTestReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_deliverability_test_reports`](crate::client::Client::list_deliverability_test_reports).
///
/// See [`crate::client::fluent_builders::ListDeliverabilityTestReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeliverabilityTestReports {
    _private: (),
}
impl ListDeliverabilityTestReports {
    /// Creates a new builder-style object to manufacture [`ListDeliverabilityTestReportsInput`](crate::input::ListDeliverabilityTestReportsInput)
    pub fn builder() -> crate::input::list_deliverability_test_reports_input::Builder {
        crate::input::list_deliverability_test_reports_input::Builder::default()
    }
    /// Creates a new `ListDeliverabilityTestReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeliverabilityTestReports {
    type Output = std::result::Result<
        crate::output::ListDeliverabilityTestReportsOutput,
        crate::error::ListDeliverabilityTestReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_deliverability_test_reports_error(response)
        } else {
            crate::operation_deser::parse_list_deliverability_test_reports_response(response)
        }
    }
}

/// Operation shape for `ListDomainDeliverabilityCampaigns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domain_deliverability_campaigns`](crate::client::Client::list_domain_deliverability_campaigns).
///
/// See [`crate::client::fluent_builders::ListDomainDeliverabilityCampaigns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainDeliverabilityCampaigns {
    _private: (),
}
impl ListDomainDeliverabilityCampaigns {
    /// Creates a new builder-style object to manufacture [`ListDomainDeliverabilityCampaignsInput`](crate::input::ListDomainDeliverabilityCampaignsInput)
    pub fn builder() -> crate::input::list_domain_deliverability_campaigns_input::Builder {
        crate::input::list_domain_deliverability_campaigns_input::Builder::default()
    }
    /// Creates a new `ListDomainDeliverabilityCampaigns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainDeliverabilityCampaigns {
    type Output = std::result::Result<
        crate::output::ListDomainDeliverabilityCampaignsOutput,
        crate::error::ListDomainDeliverabilityCampaignsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domain_deliverability_campaigns_error(response)
        } else {
            crate::operation_deser::parse_list_domain_deliverability_campaigns_response(response)
        }
    }
}

/// Operation shape for `ListEmailIdentities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_email_identities`](crate::client::Client::list_email_identities).
///
/// See [`crate::client::fluent_builders::ListEmailIdentities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEmailIdentities {
    _private: (),
}
impl ListEmailIdentities {
    /// Creates a new builder-style object to manufacture [`ListEmailIdentitiesInput`](crate::input::ListEmailIdentitiesInput)
    pub fn builder() -> crate::input::list_email_identities_input::Builder {
        crate::input::list_email_identities_input::Builder::default()
    }
    /// Creates a new `ListEmailIdentities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEmailIdentities {
    type Output = std::result::Result<
        crate::output::ListEmailIdentitiesOutput,
        crate::error::ListEmailIdentitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_email_identities_error(response)
        } else {
            crate::operation_deser::parse_list_email_identities_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutAccountDedicatedIpWarmupAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_account_dedicated_ip_warmup_attributes`](crate::client::Client::put_account_dedicated_ip_warmup_attributes).
///
/// See [`crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccountDedicatedIpWarmupAttributes {
    _private: (),
}
impl PutAccountDedicatedIpWarmupAttributes {
    /// Creates a new builder-style object to manufacture [`PutAccountDedicatedIpWarmupAttributesInput`](crate::input::PutAccountDedicatedIpWarmupAttributesInput)
    pub fn builder() -> crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder {
        crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder::default()
    }
    /// Creates a new `PutAccountDedicatedIpWarmupAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccountDedicatedIpWarmupAttributes {
    type Output = std::result::Result<
        crate::output::PutAccountDedicatedIpWarmupAttributesOutput,
        crate::error::PutAccountDedicatedIpWarmupAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_account_dedicated_ip_warmup_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_account_dedicated_ip_warmup_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutAccountSendingAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_account_sending_attributes`](crate::client::Client::put_account_sending_attributes).
///
/// See [`crate::client::fluent_builders::PutAccountSendingAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccountSendingAttributes {
    _private: (),
}
impl PutAccountSendingAttributes {
    /// Creates a new builder-style object to manufacture [`PutAccountSendingAttributesInput`](crate::input::PutAccountSendingAttributesInput)
    pub fn builder() -> crate::input::put_account_sending_attributes_input::Builder {
        crate::input::put_account_sending_attributes_input::Builder::default()
    }
    /// Creates a new `PutAccountSendingAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccountSendingAttributes {
    type Output = std::result::Result<
        crate::output::PutAccountSendingAttributesOutput,
        crate::error::PutAccountSendingAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_account_sending_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_account_sending_attributes_response(response)
        }
    }
}

/// Operation shape for `PutConfigurationSetDeliveryOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_set_delivery_options`](crate::client::Client::put_configuration_set_delivery_options).
///
/// See [`crate::client::fluent_builders::PutConfigurationSetDeliveryOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationSetDeliveryOptions {
    _private: (),
}
impl PutConfigurationSetDeliveryOptions {
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_delivery_options_input::Builder {
        crate::input::put_configuration_set_delivery_options_input::Builder::default()
    }
    /// Creates a new `PutConfigurationSetDeliveryOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationSetDeliveryOptions {
    type Output = std::result::Result<
        crate::output::PutConfigurationSetDeliveryOptionsOutput,
        crate::error::PutConfigurationSetDeliveryOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_set_delivery_options_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_set_delivery_options_response(response)
        }
    }
}

/// Operation shape for `PutConfigurationSetReputationOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_set_reputation_options`](crate::client::Client::put_configuration_set_reputation_options).
///
/// See [`crate::client::fluent_builders::PutConfigurationSetReputationOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationSetReputationOptions {
    _private: (),
}
impl PutConfigurationSetReputationOptions {
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetReputationOptionsInput`](crate::input::PutConfigurationSetReputationOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_reputation_options_input::Builder {
        crate::input::put_configuration_set_reputation_options_input::Builder::default()
    }
    /// Creates a new `PutConfigurationSetReputationOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationSetReputationOptions {
    type Output = std::result::Result<
        crate::output::PutConfigurationSetReputationOptionsOutput,
        crate::error::PutConfigurationSetReputationOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_set_reputation_options_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_set_reputation_options_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutConfigurationSetSendingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_set_sending_options`](crate::client::Client::put_configuration_set_sending_options).
///
/// See [`crate::client::fluent_builders::PutConfigurationSetSendingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationSetSendingOptions {
    _private: (),
}
impl PutConfigurationSetSendingOptions {
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetSendingOptionsInput`](crate::input::PutConfigurationSetSendingOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_sending_options_input::Builder {
        crate::input::put_configuration_set_sending_options_input::Builder::default()
    }
    /// Creates a new `PutConfigurationSetSendingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationSetSendingOptions {
    type Output = std::result::Result<
        crate::output::PutConfigurationSetSendingOptionsOutput,
        crate::error::PutConfigurationSetSendingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_set_sending_options_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_set_sending_options_response(response)
        }
    }
}

/// Operation shape for `PutConfigurationSetTrackingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_set_tracking_options`](crate::client::Client::put_configuration_set_tracking_options).
///
/// See [`crate::client::fluent_builders::PutConfigurationSetTrackingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationSetTrackingOptions {
    _private: (),
}
impl PutConfigurationSetTrackingOptions {
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetTrackingOptionsInput`](crate::input::PutConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_tracking_options_input::Builder {
        crate::input::put_configuration_set_tracking_options_input::Builder::default()
    }
    /// Creates a new `PutConfigurationSetTrackingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationSetTrackingOptions {
    type Output = std::result::Result<
        crate::output::PutConfigurationSetTrackingOptionsOutput,
        crate::error::PutConfigurationSetTrackingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_set_tracking_options_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_set_tracking_options_response(response)
        }
    }
}

/// Operation shape for `PutDedicatedIpInPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_dedicated_ip_in_pool`](crate::client::Client::put_dedicated_ip_in_pool).
///
/// See [`crate::client::fluent_builders::PutDedicatedIpInPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDedicatedIpInPool {
    _private: (),
}
impl PutDedicatedIpInPool {
    /// Creates a new builder-style object to manufacture [`PutDedicatedIpInPoolInput`](crate::input::PutDedicatedIpInPoolInput)
    pub fn builder() -> crate::input::put_dedicated_ip_in_pool_input::Builder {
        crate::input::put_dedicated_ip_in_pool_input::Builder::default()
    }
    /// Creates a new `PutDedicatedIpInPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDedicatedIpInPool {
    type Output = std::result::Result<
        crate::output::PutDedicatedIpInPoolOutput,
        crate::error::PutDedicatedIpInPoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_dedicated_ip_in_pool_error(response)
        } else {
            crate::operation_deser::parse_put_dedicated_ip_in_pool_response(response)
        }
    }
}

/// Operation shape for `PutDedicatedIpWarmupAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_dedicated_ip_warmup_attributes`](crate::client::Client::put_dedicated_ip_warmup_attributes).
///
/// See [`crate::client::fluent_builders::PutDedicatedIpWarmupAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDedicatedIpWarmupAttributes {
    _private: (),
}
impl PutDedicatedIpWarmupAttributes {
    /// Creates a new builder-style object to manufacture [`PutDedicatedIpWarmupAttributesInput`](crate::input::PutDedicatedIpWarmupAttributesInput)
    pub fn builder() -> crate::input::put_dedicated_ip_warmup_attributes_input::Builder {
        crate::input::put_dedicated_ip_warmup_attributes_input::Builder::default()
    }
    /// Creates a new `PutDedicatedIpWarmupAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDedicatedIpWarmupAttributes {
    type Output = std::result::Result<
        crate::output::PutDedicatedIpWarmupAttributesOutput,
        crate::error::PutDedicatedIpWarmupAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_dedicated_ip_warmup_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_dedicated_ip_warmup_attributes_response(response)
        }
    }
}

/// Operation shape for `PutDeliverabilityDashboardOption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_deliverability_dashboard_option`](crate::client::Client::put_deliverability_dashboard_option).
///
/// See [`crate::client::fluent_builders::PutDeliverabilityDashboardOption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDeliverabilityDashboardOption {
    _private: (),
}
impl PutDeliverabilityDashboardOption {
    /// Creates a new builder-style object to manufacture [`PutDeliverabilityDashboardOptionInput`](crate::input::PutDeliverabilityDashboardOptionInput)
    pub fn builder() -> crate::input::put_deliverability_dashboard_option_input::Builder {
        crate::input::put_deliverability_dashboard_option_input::Builder::default()
    }
    /// Creates a new `PutDeliverabilityDashboardOption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDeliverabilityDashboardOption {
    type Output = std::result::Result<
        crate::output::PutDeliverabilityDashboardOptionOutput,
        crate::error::PutDeliverabilityDashboardOptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_deliverability_dashboard_option_error(response)
        } else {
            crate::operation_deser::parse_put_deliverability_dashboard_option_response(response)
        }
    }
}

/// Operation shape for `PutEmailIdentityDkimAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_email_identity_dkim_attributes`](crate::client::Client::put_email_identity_dkim_attributes).
///
/// See [`crate::client::fluent_builders::PutEmailIdentityDkimAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEmailIdentityDkimAttributes {
    _private: (),
}
impl PutEmailIdentityDkimAttributes {
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityDkimAttributesInput`](crate::input::PutEmailIdentityDkimAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_dkim_attributes_input::Builder {
        crate::input::put_email_identity_dkim_attributes_input::Builder::default()
    }
    /// Creates a new `PutEmailIdentityDkimAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEmailIdentityDkimAttributes {
    type Output = std::result::Result<
        crate::output::PutEmailIdentityDkimAttributesOutput,
        crate::error::PutEmailIdentityDkimAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_email_identity_dkim_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_email_identity_dkim_attributes_response(response)
        }
    }
}

/// Operation shape for `PutEmailIdentityFeedbackAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_email_identity_feedback_attributes`](crate::client::Client::put_email_identity_feedback_attributes).
///
/// See [`crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEmailIdentityFeedbackAttributes {
    _private: (),
}
impl PutEmailIdentityFeedbackAttributes {
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityFeedbackAttributesInput`](crate::input::PutEmailIdentityFeedbackAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_feedback_attributes_input::Builder {
        crate::input::put_email_identity_feedback_attributes_input::Builder::default()
    }
    /// Creates a new `PutEmailIdentityFeedbackAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEmailIdentityFeedbackAttributes {
    type Output = std::result::Result<
        crate::output::PutEmailIdentityFeedbackAttributesOutput,
        crate::error::PutEmailIdentityFeedbackAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_email_identity_feedback_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_email_identity_feedback_attributes_response(response)
        }
    }
}

/// Operation shape for `PutEmailIdentityMailFromAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_email_identity_mail_from_attributes`](crate::client::Client::put_email_identity_mail_from_attributes).
///
/// See [`crate::client::fluent_builders::PutEmailIdentityMailFromAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEmailIdentityMailFromAttributes {
    _private: (),
}
impl PutEmailIdentityMailFromAttributes {
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityMailFromAttributesInput`](crate::input::PutEmailIdentityMailFromAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_mail_from_attributes_input::Builder {
        crate::input::put_email_identity_mail_from_attributes_input::Builder::default()
    }
    /// Creates a new `PutEmailIdentityMailFromAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEmailIdentityMailFromAttributes {
    type Output = std::result::Result<
        crate::output::PutEmailIdentityMailFromAttributesOutput,
        crate::error::PutEmailIdentityMailFromAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_email_identity_mail_from_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_email_identity_mail_from_attributes_response(response)
        }
    }
}

/// Operation shape for `SendEmail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_email`](crate::client::Client::send_email).
///
/// See [`crate::client::fluent_builders::SendEmail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendEmail {
    _private: (),
}
impl SendEmail {
    /// Creates a new builder-style object to manufacture [`SendEmailInput`](crate::input::SendEmailInput)
    pub fn builder() -> crate::input::send_email_input::Builder {
        crate::input::send_email_input::Builder::default()
    }
    /// Creates a new `SendEmail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendEmail {
    type Output = std::result::Result<crate::output::SendEmailOutput, crate::error::SendEmailError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_email_error(response)
        } else {
            crate::operation_deser::parse_send_email_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateConfigurationSetEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_set_event_destination`](crate::client::Client::update_configuration_set_event_destination).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationSetEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationSetEventDestination {
    _private: (),
}
impl UpdateConfigurationSetEventDestination {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::update_configuration_set_event_destination_input::Builder {
        crate::input::update_configuration_set_event_destination_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationSetEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConfigurationSetEventDestination {
    type Output = std::result::Result<
        crate::output::UpdateConfigurationSetEventDestinationOutput,
        crate::error::UpdateConfigurationSetEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_set_event_destination_error(response)
        } else {
            crate::operation_deser::parse_update_configuration_set_event_destination_response(
                response,
            )
        }
    }
}
