// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetErrorKind {
    /// <p>The resource specified in your request already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetError {
    /// Creates a new `CreateConfigurationSetError`.
    pub fn new(kind: CreateConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetEventDestinationErrorKind {
    /// <p>The resource specified in your request already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetEventDestinationError {
    /// Creates a new `CreateConfigurationSetEventDestinationError`.
    pub fn new(
        kind: CreateConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetEventDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetEventDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetEventDestinationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetEventDestinationErrorKind::AlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateDedicatedIpPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDedicatedIpPoolError {
    /// Kind of error that occurred.
    pub kind: CreateDedicatedIpPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDedicatedIpPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDedicatedIpPoolErrorKind {
    /// <p>The resource specified in your request already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDedicatedIpPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDedicatedIpPoolErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDedicatedIpPoolErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDedicatedIpPoolErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateDedicatedIpPoolErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDedicatedIpPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDedicatedIpPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDedicatedIpPoolError {
    fn code(&self) -> Option<&str> {
        CreateDedicatedIpPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDedicatedIpPoolError {
    /// Creates a new `CreateDedicatedIpPoolError`.
    pub fn new(kind: CreateDedicatedIpPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDedicatedIpPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDedicatedIpPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDedicatedIpPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDedicatedIpPoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDedicatedIpPoolErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDedicatedIpPoolErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDedicatedIpPoolErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDedicatedIpPoolErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDedicatedIpPoolErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDedicatedIpPoolErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDedicatedIpPoolErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDedicatedIpPoolErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDedicatedIpPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDedicatedIpPoolErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateDedicatedIpPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDedicatedIpPoolErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateDedicatedIpPoolErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDedicatedIpPoolErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateDedicatedIpPoolErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDedicatedIpPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDedicatedIpPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeliverabilityTestReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeliverabilityTestReportError {
    /// Kind of error that occurred.
    pub kind: CreateDeliverabilityTestReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeliverabilityTestReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeliverabilityTestReportErrorKind {
    /// <p>The message can't be sent because the account's ability to send email has been
    /// permanently restricted.</p>
    AccountSuspendedException(crate::error::AccountSuspendedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The message can't be sent because the sending domain isn't verified.</p>
    MailFromDomainNotVerifiedException(crate::error::MailFromDomainNotVerifiedException),
    /// <p>The message can't be sent because it contains invalid content.</p>
    MessageRejected(crate::error::MessageRejected),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The message can't be sent because the account's ability to send email is currently
    /// paused.</p>
    SendingPausedException(crate::error::SendingPausedException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeliverabilityTestReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeliverabilityTestReportErrorKind::AccountSuspendedException(_inner) => {
                _inner.fmt(f)
            }
            CreateDeliverabilityTestReportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDeliverabilityTestReportErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateDeliverabilityTestReportErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateDeliverabilityTestReportErrorKind::MailFromDomainNotVerifiedException(_inner) => {
                _inner.fmt(f)
            }
            CreateDeliverabilityTestReportErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            CreateDeliverabilityTestReportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDeliverabilityTestReportErrorKind::SendingPausedException(_inner) => {
                _inner.fmt(f)
            }
            CreateDeliverabilityTestReportErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreateDeliverabilityTestReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeliverabilityTestReportError {
    fn code(&self) -> Option<&str> {
        CreateDeliverabilityTestReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeliverabilityTestReportError {
    /// Creates a new `CreateDeliverabilityTestReportError`.
    pub fn new(
        kind: CreateDeliverabilityTestReportErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeliverabilityTestReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeliverabilityTestReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeliverabilityTestReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeliverabilityTestReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::AccountSuspendedException`.
    pub fn is_account_suspended_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::AccountSuspendedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::MailFromDomainNotVerifiedException`.
    pub fn is_mail_from_domain_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::MailFromDomainNotVerifiedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::MessageRejected(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::SendingPausedException`.
    pub fn is_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::SendingPausedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeliverabilityTestReportErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeliverabilityTestReportErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateDeliverabilityTestReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeliverabilityTestReportErrorKind::AccountSuspendedException(_inner) => {
                Some(_inner)
            }
            CreateDeliverabilityTestReportErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDeliverabilityTestReportErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreateDeliverabilityTestReportErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDeliverabilityTestReportErrorKind::MailFromDomainNotVerifiedException(_inner) => {
                Some(_inner)
            }
            CreateDeliverabilityTestReportErrorKind::MessageRejected(_inner) => Some(_inner),
            CreateDeliverabilityTestReportErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDeliverabilityTestReportErrorKind::SendingPausedException(_inner) => Some(_inner),
            CreateDeliverabilityTestReportErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            CreateDeliverabilityTestReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEmailIdentityError {
    /// Kind of error that occurred.
    pub kind: CreateEmailIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEmailIdentityErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEmailIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEmailIdentityErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateEmailIdentityErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateEmailIdentityErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateEmailIdentityErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEmailIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEmailIdentityError {
    fn code(&self) -> Option<&str> {
        CreateEmailIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEmailIdentityError {
    /// Creates a new `CreateEmailIdentityError`.
    pub fn new(kind: CreateEmailIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEmailIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEmailIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEmailIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEmailIdentityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEmailIdentityErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailIdentityErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailIdentityErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailIdentityErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailIdentityErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailIdentityErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailIdentityErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailIdentityErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateEmailIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEmailIdentityErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateEmailIdentityErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateEmailIdentityErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateEmailIdentityErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEmailIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetError {
    /// Creates a new `DeleteConfigurationSetError`.
    pub fn new(kind: DeleteConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetEventDestinationErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetEventDestinationError {
    /// Creates a new `DeleteConfigurationSetEventDestinationError`.
    pub fn new(
        kind: DeleteConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteDedicatedIpPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDedicatedIpPoolError {
    /// Kind of error that occurred.
    pub kind: DeleteDedicatedIpPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDedicatedIpPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDedicatedIpPoolErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDedicatedIpPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDedicatedIpPoolErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDedicatedIpPoolErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDedicatedIpPoolErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDedicatedIpPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDedicatedIpPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDedicatedIpPoolError {
    fn code(&self) -> Option<&str> {
        DeleteDedicatedIpPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDedicatedIpPoolError {
    /// Creates a new `DeleteDedicatedIpPoolError`.
    pub fn new(kind: DeleteDedicatedIpPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDedicatedIpPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDedicatedIpPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDedicatedIpPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDedicatedIpPoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDedicatedIpPoolErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDedicatedIpPoolErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDedicatedIpPoolErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDedicatedIpPoolErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDedicatedIpPoolErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDedicatedIpPoolErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDedicatedIpPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDedicatedIpPoolErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteDedicatedIpPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDedicatedIpPoolErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDedicatedIpPoolErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteDedicatedIpPoolErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDedicatedIpPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDedicatedIpPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEmailIdentityError {
    /// Kind of error that occurred.
    pub kind: DeleteEmailIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEmailIdentityErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEmailIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEmailIdentityErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEmailIdentityErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteEmailIdentityErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEmailIdentityErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEmailIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEmailIdentityError {
    fn code(&self) -> Option<&str> {
        DeleteEmailIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEmailIdentityError {
    /// Creates a new `DeleteEmailIdentityError`.
    pub fn new(kind: DeleteEmailIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEmailIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEmailIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEmailIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEmailIdentityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEmailIdentityErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailIdentityErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailIdentityErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailIdentityErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailIdentityErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailIdentityErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailIdentityErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailIdentityErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEmailIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEmailIdentityErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEmailIdentityErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteEmailIdentityErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEmailIdentityErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEmailIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountError {
    /// Kind of error that occurred.
    pub kind: GetAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountError {
    fn code(&self) -> Option<&str> {
        GetAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountError {
    /// Creates a new `GetAccountError`.
    pub fn new(kind: GetAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlacklistReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlacklistReportsError {
    /// Kind of error that occurred.
    pub kind: GetBlacklistReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlacklistReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlacklistReportsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlacklistReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlacklistReportsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBlacklistReportsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBlacklistReportsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBlacklistReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlacklistReportsError {
    fn code(&self) -> Option<&str> {
        GetBlacklistReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlacklistReportsError {
    /// Creates a new `GetBlacklistReportsError`.
    pub fn new(kind: GetBlacklistReportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlacklistReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlacklistReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlacklistReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlacklistReportsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlacklistReportsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlacklistReportsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlacklistReportsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlacklistReportsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlacklistReportsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlacklistReportsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetBlacklistReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlacklistReportsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBlacklistReportsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBlacklistReportsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBlacklistReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: GetConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigurationSetErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigurationSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetConfigurationSetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetConfigurationSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigurationSetError {
    fn code(&self) -> Option<&str> {
        GetConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigurationSetError {
    /// Creates a new `GetConfigurationSetError`.
    pub fn new(kind: GetConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConfigurationSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationSetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigurationSetErrorKind::BadRequestException(_inner) => Some(_inner),
            GetConfigurationSetErrorKind::NotFoundException(_inner) => Some(_inner),
            GetConfigurationSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConfigurationSetEventDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigurationSetEventDestinationsError {
    /// Kind of error that occurred.
    pub kind: GetConfigurationSetEventDestinationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfigurationSetEventDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigurationSetEventDestinationsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigurationSetEventDestinationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigurationSetEventDestinationsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetConfigurationSetEventDestinationsErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetConfigurationSetEventDestinationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigurationSetEventDestinationsError {
    fn code(&self) -> Option<&str> {
        GetConfigurationSetEventDestinationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigurationSetEventDestinationsError {
    /// Creates a new `GetConfigurationSetEventDestinationsError`.
    pub fn new(
        kind: GetConfigurationSetEventDestinationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigurationSetEventDestinationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigurationSetEventDestinationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigurationSetEventDestinationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigurationSetEventDestinationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConfigurationSetEventDestinationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationSetEventDestinationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetConfigurationSetEventDestinationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigurationSetEventDestinationsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetConfigurationSetEventDestinationsErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetConfigurationSetEventDestinationsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetConfigurationSetEventDestinationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetDedicatedIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDedicatedIpError {
    /// Kind of error that occurred.
    pub kind: GetDedicatedIpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDedicatedIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDedicatedIpErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDedicatedIpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDedicatedIpErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDedicatedIpErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDedicatedIpErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDedicatedIpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDedicatedIpError {
    fn code(&self) -> Option<&str> {
        GetDedicatedIpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDedicatedIpError {
    /// Creates a new `GetDedicatedIpError`.
    pub fn new(kind: GetDedicatedIpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDedicatedIpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDedicatedIpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDedicatedIpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDedicatedIpErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDedicatedIpErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDedicatedIpErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetDedicatedIpErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDedicatedIpErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDedicatedIpErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDedicatedIpErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDedicatedIpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDedicatedIpErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDedicatedIpErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDedicatedIpErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDedicatedIpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDedicatedIps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDedicatedIpsError {
    /// Kind of error that occurred.
    pub kind: GetDedicatedIpsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDedicatedIps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDedicatedIpsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDedicatedIpsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDedicatedIpsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDedicatedIpsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDedicatedIpsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDedicatedIpsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDedicatedIpsError {
    fn code(&self) -> Option<&str> {
        GetDedicatedIpsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDedicatedIpsError {
    /// Creates a new `GetDedicatedIpsError`.
    pub fn new(kind: GetDedicatedIpsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDedicatedIpsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDedicatedIpsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDedicatedIpsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDedicatedIpsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDedicatedIpsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDedicatedIpsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetDedicatedIpsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDedicatedIpsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDedicatedIpsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDedicatedIpsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDedicatedIpsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDedicatedIpsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDedicatedIpsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDedicatedIpsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDedicatedIpsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeliverabilityDashboardOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeliverabilityDashboardOptionsError {
    /// Kind of error that occurred.
    pub kind: GetDeliverabilityDashboardOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeliverabilityDashboardOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeliverabilityDashboardOptionsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeliverabilityDashboardOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeliverabilityDashboardOptionsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetDeliverabilityDashboardOptionsErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetDeliverabilityDashboardOptionsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetDeliverabilityDashboardOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeliverabilityDashboardOptionsError {
    fn code(&self) -> Option<&str> {
        GetDeliverabilityDashboardOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeliverabilityDashboardOptionsError {
    /// Creates a new `GetDeliverabilityDashboardOptionsError`.
    pub fn new(
        kind: GetDeliverabilityDashboardOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeliverabilityDashboardOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeliverabilityDashboardOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeliverabilityDashboardOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeliverabilityDashboardOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeliverabilityDashboardOptionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeliverabilityDashboardOptionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeliverabilityDashboardOptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeliverabilityDashboardOptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeliverabilityDashboardOptionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeliverabilityDashboardOptionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDeliverabilityDashboardOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeliverabilityDashboardOptionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeliverabilityDashboardOptionsErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            GetDeliverabilityDashboardOptionsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetDeliverabilityDashboardOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeliverabilityTestReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeliverabilityTestReportError {
    /// Kind of error that occurred.
    pub kind: GetDeliverabilityTestReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeliverabilityTestReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeliverabilityTestReportErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeliverabilityTestReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeliverabilityTestReportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDeliverabilityTestReportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeliverabilityTestReportErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDeliverabilityTestReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeliverabilityTestReportError {
    fn code(&self) -> Option<&str> {
        GetDeliverabilityTestReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeliverabilityTestReportError {
    /// Creates a new `GetDeliverabilityTestReportError`.
    pub fn new(kind: GetDeliverabilityTestReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeliverabilityTestReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeliverabilityTestReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeliverabilityTestReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeliverabilityTestReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeliverabilityTestReportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeliverabilityTestReportErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeliverabilityTestReportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeliverabilityTestReportErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeliverabilityTestReportErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeliverabilityTestReportErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDeliverabilityTestReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeliverabilityTestReportErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeliverabilityTestReportErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeliverabilityTestReportErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDeliverabilityTestReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainDeliverabilityCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainDeliverabilityCampaignError {
    /// Kind of error that occurred.
    pub kind: GetDomainDeliverabilityCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainDeliverabilityCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainDeliverabilityCampaignErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainDeliverabilityCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainDeliverabilityCampaignErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainDeliverabilityCampaignErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainDeliverabilityCampaignErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetDomainDeliverabilityCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainDeliverabilityCampaignError {
    fn code(&self) -> Option<&str> {
        GetDomainDeliverabilityCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainDeliverabilityCampaignError {
    /// Creates a new `GetDomainDeliverabilityCampaignError`.
    pub fn new(
        kind: GetDomainDeliverabilityCampaignErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainDeliverabilityCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainDeliverabilityCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainDeliverabilityCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainDeliverabilityCampaignErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainDeliverabilityCampaignErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainDeliverabilityCampaignErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainDeliverabilityCampaignErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainDeliverabilityCampaignErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainDeliverabilityCampaignErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainDeliverabilityCampaignErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDomainDeliverabilityCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainDeliverabilityCampaignErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainDeliverabilityCampaignErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainDeliverabilityCampaignErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetDomainDeliverabilityCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainStatisticsReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainStatisticsReportError {
    /// Kind of error that occurred.
    pub kind: GetDomainStatisticsReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainStatisticsReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainStatisticsReportErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainStatisticsReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainStatisticsReportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainStatisticsReportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainStatisticsReportErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDomainStatisticsReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainStatisticsReportError {
    fn code(&self) -> Option<&str> {
        GetDomainStatisticsReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainStatisticsReportError {
    /// Creates a new `GetDomainStatisticsReportError`.
    pub fn new(kind: GetDomainStatisticsReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainStatisticsReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainStatisticsReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainStatisticsReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainStatisticsReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainStatisticsReportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainStatisticsReportErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainStatisticsReportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainStatisticsReportErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainStatisticsReportErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainStatisticsReportErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetDomainStatisticsReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainStatisticsReportErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainStatisticsReportErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainStatisticsReportErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDomainStatisticsReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEmailIdentityError {
    /// Kind of error that occurred.
    pub kind: GetEmailIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEmailIdentityErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEmailIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEmailIdentityErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEmailIdentityErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEmailIdentityErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetEmailIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEmailIdentityError {
    fn code(&self) -> Option<&str> {
        GetEmailIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEmailIdentityError {
    /// Creates a new `GetEmailIdentityError`.
    pub fn new(kind: GetEmailIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEmailIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEmailIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEmailIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEmailIdentityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEmailIdentityErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailIdentityErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailIdentityErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEmailIdentityErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetEmailIdentityErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailIdentityErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetEmailIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEmailIdentityErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEmailIdentityErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEmailIdentityErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetEmailIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationSetsError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationSetsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationSetsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListConfigurationSetsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListConfigurationSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationSetsError {
    fn code(&self) -> Option<&str> {
        ListConfigurationSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationSetsError {
    /// Creates a new `ListConfigurationSetsError`.
    pub fn new(kind: ListConfigurationSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConfigurationSetsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationSetsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationSetsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationSetsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListConfigurationSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationSetsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListConfigurationSetsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListConfigurationSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDedicatedIpPools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDedicatedIpPoolsError {
    /// Kind of error that occurred.
    pub kind: ListDedicatedIpPoolsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDedicatedIpPools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDedicatedIpPoolsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDedicatedIpPoolsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDedicatedIpPoolsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDedicatedIpPoolsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListDedicatedIpPoolsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDedicatedIpPoolsError {
    fn code(&self) -> Option<&str> {
        ListDedicatedIpPoolsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDedicatedIpPoolsError {
    /// Creates a new `ListDedicatedIpPoolsError`.
    pub fn new(kind: ListDedicatedIpPoolsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDedicatedIpPoolsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDedicatedIpPoolsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDedicatedIpPoolsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDedicatedIpPoolsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDedicatedIpPoolsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDedicatedIpPoolsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDedicatedIpPoolsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDedicatedIpPoolsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDedicatedIpPoolsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDedicatedIpPoolsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDedicatedIpPoolsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListDedicatedIpPoolsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeliverabilityTestReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeliverabilityTestReportsError {
    /// Kind of error that occurred.
    pub kind: ListDeliverabilityTestReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeliverabilityTestReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeliverabilityTestReportsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeliverabilityTestReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeliverabilityTestReportsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDeliverabilityTestReportsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDeliverabilityTestReportsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListDeliverabilityTestReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeliverabilityTestReportsError {
    fn code(&self) -> Option<&str> {
        ListDeliverabilityTestReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeliverabilityTestReportsError {
    /// Creates a new `ListDeliverabilityTestReportsError`.
    pub fn new(
        kind: ListDeliverabilityTestReportsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeliverabilityTestReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeliverabilityTestReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeliverabilityTestReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeliverabilityTestReportsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeliverabilityTestReportsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeliverabilityTestReportsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeliverabilityTestReportsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeliverabilityTestReportsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeliverabilityTestReportsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeliverabilityTestReportsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDeliverabilityTestReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeliverabilityTestReportsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDeliverabilityTestReportsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDeliverabilityTestReportsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListDeliverabilityTestReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainDeliverabilityCampaigns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainDeliverabilityCampaignsError {
    /// Kind of error that occurred.
    pub kind: ListDomainDeliverabilityCampaignsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainDeliverabilityCampaigns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainDeliverabilityCampaignsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainDeliverabilityCampaignsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainDeliverabilityCampaignsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDomainDeliverabilityCampaignsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDomainDeliverabilityCampaignsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListDomainDeliverabilityCampaignsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainDeliverabilityCampaignsError {
    fn code(&self) -> Option<&str> {
        ListDomainDeliverabilityCampaignsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainDeliverabilityCampaignsError {
    /// Creates a new `ListDomainDeliverabilityCampaignsError`.
    pub fn new(
        kind: ListDomainDeliverabilityCampaignsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainDeliverabilityCampaignsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainDeliverabilityCampaignsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainDeliverabilityCampaignsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainDeliverabilityCampaignsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainDeliverabilityCampaignsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainDeliverabilityCampaignsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainDeliverabilityCampaignsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainDeliverabilityCampaignsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainDeliverabilityCampaignsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainDeliverabilityCampaignsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDomainDeliverabilityCampaignsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainDeliverabilityCampaignsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDomainDeliverabilityCampaignsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDomainDeliverabilityCampaignsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListDomainDeliverabilityCampaignsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEmailIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEmailIdentitiesError {
    /// Kind of error that occurred.
    pub kind: ListEmailIdentitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEmailIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEmailIdentitiesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEmailIdentitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEmailIdentitiesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListEmailIdentitiesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEmailIdentitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEmailIdentitiesError {
    fn code(&self) -> Option<&str> {
        ListEmailIdentitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEmailIdentitiesError {
    /// Creates a new `ListEmailIdentitiesError`.
    pub fn new(kind: ListEmailIdentitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEmailIdentitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEmailIdentitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEmailIdentitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEmailIdentitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEmailIdentitiesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEmailIdentitiesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEmailIdentitiesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEmailIdentitiesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEmailIdentitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEmailIdentitiesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListEmailIdentitiesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEmailIdentitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAccountDedicatedIpWarmupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccountDedicatedIpWarmupAttributesError {
    /// Kind of error that occurred.
    pub kind: PutAccountDedicatedIpWarmupAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccountDedicatedIpWarmupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccountDedicatedIpWarmupAttributesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccountDedicatedIpWarmupAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccountDedicatedIpWarmupAttributesErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutAccountDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutAccountDedicatedIpWarmupAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccountDedicatedIpWarmupAttributesError {
    fn code(&self) -> Option<&str> {
        PutAccountDedicatedIpWarmupAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccountDedicatedIpWarmupAttributesError {
    /// Creates a new `PutAccountDedicatedIpWarmupAttributesError`.
    pub fn new(
        kind: PutAccountDedicatedIpWarmupAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccountDedicatedIpWarmupAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccountDedicatedIpWarmupAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccountDedicatedIpWarmupAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccountDedicatedIpWarmupAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAccountDedicatedIpWarmupAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountDedicatedIpWarmupAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccountDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutAccountDedicatedIpWarmupAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccountDedicatedIpWarmupAttributesErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            PutAccountDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutAccountDedicatedIpWarmupAttributesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutAccountSendingAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccountSendingAttributesError {
    /// Kind of error that occurred.
    pub kind: PutAccountSendingAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccountSendingAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccountSendingAttributesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccountSendingAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccountSendingAttributesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutAccountSendingAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutAccountSendingAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccountSendingAttributesError {
    fn code(&self) -> Option<&str> {
        PutAccountSendingAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccountSendingAttributesError {
    /// Creates a new `PutAccountSendingAttributesError`.
    pub fn new(kind: PutAccountSendingAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccountSendingAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccountSendingAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccountSendingAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccountSendingAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAccountSendingAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountSendingAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccountSendingAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountSendingAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutAccountSendingAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccountSendingAttributesErrorKind::BadRequestException(_inner) => Some(_inner),
            PutAccountSendingAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutAccountSendingAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigurationSetDeliveryOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationSetDeliveryOptionsError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationSetDeliveryOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationSetDeliveryOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationSetDeliveryOptionsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationSetDeliveryOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationSetDeliveryOptionsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetDeliveryOptionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutConfigurationSetDeliveryOptionsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationSetDeliveryOptionsError {
    fn code(&self) -> Option<&str> {
        PutConfigurationSetDeliveryOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationSetDeliveryOptionsError {
    /// Creates a new `PutConfigurationSetDeliveryOptionsError`.
    pub fn new(
        kind: PutConfigurationSetDeliveryOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationSetDeliveryOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationSetDeliveryOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigurationSetDeliveryOptionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetDeliveryOptionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetDeliveryOptionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetDeliveryOptionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetDeliveryOptionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetDeliveryOptionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutConfigurationSetDeliveryOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationSetDeliveryOptionsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetDeliveryOptionsErrorKind::NotFoundException(_inner) => Some(_inner),
            PutConfigurationSetDeliveryOptionsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigurationSetReputationOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationSetReputationOptionsError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationSetReputationOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationSetReputationOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationSetReputationOptionsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationSetReputationOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationSetReputationOptionsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetReputationOptionsErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetReputationOptionsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetReputationOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationSetReputationOptionsError {
    fn code(&self) -> Option<&str> {
        PutConfigurationSetReputationOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationSetReputationOptionsError {
    /// Creates a new `PutConfigurationSetReputationOptionsError`.
    pub fn new(
        kind: PutConfigurationSetReputationOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationSetReputationOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationSetReputationOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationSetReputationOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationSetReputationOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigurationSetReputationOptionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetReputationOptionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetReputationOptionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetReputationOptionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetReputationOptionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetReputationOptionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutConfigurationSetReputationOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationSetReputationOptionsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetReputationOptionsErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetReputationOptionsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetReputationOptionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutConfigurationSetSendingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationSetSendingOptionsError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationSetSendingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationSetSendingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationSetSendingOptionsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationSetSendingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationSetSendingOptionsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetSendingOptionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutConfigurationSetSendingOptionsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetSendingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationSetSendingOptionsError {
    fn code(&self) -> Option<&str> {
        PutConfigurationSetSendingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationSetSendingOptionsError {
    /// Creates a new `PutConfigurationSetSendingOptionsError`.
    pub fn new(
        kind: PutConfigurationSetSendingOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationSetSendingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationSetSendingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationSetSendingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationSetSendingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigurationSetSendingOptionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetSendingOptionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetSendingOptionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetSendingOptionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetSendingOptionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetSendingOptionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutConfigurationSetSendingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationSetSendingOptionsErrorKind::BadRequestException(_inner) => Some(_inner),
            PutConfigurationSetSendingOptionsErrorKind::NotFoundException(_inner) => Some(_inner),
            PutConfigurationSetSendingOptionsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetSendingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationSetTrackingOptionsError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationSetTrackingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationSetTrackingOptionsErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationSetTrackingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationSetTrackingOptionsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetTrackingOptionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutConfigurationSetTrackingOptionsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationSetTrackingOptionsError {
    fn code(&self) -> Option<&str> {
        PutConfigurationSetTrackingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationSetTrackingOptionsError {
    /// Creates a new `PutConfigurationSetTrackingOptionsError`.
    pub fn new(
        kind: PutConfigurationSetTrackingOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationSetTrackingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationSetTrackingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigurationSetTrackingOptionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetTrackingOptionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetTrackingOptionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetTrackingOptionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationSetTrackingOptionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetTrackingOptionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutConfigurationSetTrackingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationSetTrackingOptionsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetTrackingOptionsErrorKind::NotFoundException(_inner) => Some(_inner),
            PutConfigurationSetTrackingOptionsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDedicatedIpInPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDedicatedIpInPoolError {
    /// Kind of error that occurred.
    pub kind: PutDedicatedIpInPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDedicatedIpInPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDedicatedIpInPoolErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDedicatedIpInPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDedicatedIpInPoolErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutDedicatedIpInPoolErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutDedicatedIpInPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutDedicatedIpInPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDedicatedIpInPoolError {
    fn code(&self) -> Option<&str> {
        PutDedicatedIpInPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDedicatedIpInPoolError {
    /// Creates a new `PutDedicatedIpInPoolError`.
    pub fn new(kind: PutDedicatedIpInPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDedicatedIpInPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDedicatedIpInPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDedicatedIpInPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDedicatedIpInPoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDedicatedIpInPoolErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDedicatedIpInPoolErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDedicatedIpInPoolErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDedicatedIpInPoolErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDedicatedIpInPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDedicatedIpInPoolErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutDedicatedIpInPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDedicatedIpInPoolErrorKind::BadRequestException(_inner) => Some(_inner),
            PutDedicatedIpInPoolErrorKind::NotFoundException(_inner) => Some(_inner),
            PutDedicatedIpInPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutDedicatedIpInPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDedicatedIpWarmupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDedicatedIpWarmupAttributesError {
    /// Kind of error that occurred.
    pub kind: PutDedicatedIpWarmupAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDedicatedIpWarmupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDedicatedIpWarmupAttributesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDedicatedIpWarmupAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDedicatedIpWarmupAttributesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutDedicatedIpWarmupAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutDedicatedIpWarmupAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDedicatedIpWarmupAttributesError {
    fn code(&self) -> Option<&str> {
        PutDedicatedIpWarmupAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDedicatedIpWarmupAttributesError {
    /// Creates a new `PutDedicatedIpWarmupAttributesError`.
    pub fn new(
        kind: PutDedicatedIpWarmupAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDedicatedIpWarmupAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDedicatedIpWarmupAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDedicatedIpWarmupAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDedicatedIpWarmupAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDedicatedIpWarmupAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDedicatedIpWarmupAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDedicatedIpWarmupAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDedicatedIpWarmupAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutDedicatedIpWarmupAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDedicatedIpWarmupAttributesErrorKind::BadRequestException(_inner) => Some(_inner),
            PutDedicatedIpWarmupAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            PutDedicatedIpWarmupAttributesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutDedicatedIpWarmupAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDeliverabilityDashboardOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDeliverabilityDashboardOptionError {
    /// Kind of error that occurred.
    pub kind: PutDeliverabilityDashboardOptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDeliverabilityDashboardOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDeliverabilityDashboardOptionErrorKind {
    /// <p>The resource specified in your request already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDeliverabilityDashboardOptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDeliverabilityDashboardOptionErrorKind::AlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliverabilityDashboardOptionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutDeliverabilityDashboardOptionErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliverabilityDashboardOptionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutDeliverabilityDashboardOptionErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliverabilityDashboardOptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDeliverabilityDashboardOptionError {
    fn code(&self) -> Option<&str> {
        PutDeliverabilityDashboardOptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDeliverabilityDashboardOptionError {
    /// Creates a new `PutDeliverabilityDashboardOptionError`.
    pub fn new(
        kind: PutDeliverabilityDashboardOptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDeliverabilityDashboardOptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDeliverabilityDashboardOptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDeliverabilityDashboardOptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDeliverabilityDashboardOptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDeliverabilityDashboardOptionErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliverabilityDashboardOptionErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliverabilityDashboardOptionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliverabilityDashboardOptionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliverabilityDashboardOptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliverabilityDashboardOptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliverabilityDashboardOptionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliverabilityDashboardOptionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliverabilityDashboardOptionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliverabilityDashboardOptionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutDeliverabilityDashboardOptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDeliverabilityDashboardOptionErrorKind::AlreadyExistsException(_inner) => {
                Some(_inner)
            }
            PutDeliverabilityDashboardOptionErrorKind::BadRequestException(_inner) => Some(_inner),
            PutDeliverabilityDashboardOptionErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            PutDeliverabilityDashboardOptionErrorKind::NotFoundException(_inner) => Some(_inner),
            PutDeliverabilityDashboardOptionErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutDeliverabilityDashboardOptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEmailIdentityDkimAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEmailIdentityDkimAttributesError {
    /// Kind of error that occurred.
    pub kind: PutEmailIdentityDkimAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEmailIdentityDkimAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEmailIdentityDkimAttributesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEmailIdentityDkimAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEmailIdentityDkimAttributesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutEmailIdentityDkimAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutEmailIdentityDkimAttributesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutEmailIdentityDkimAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEmailIdentityDkimAttributesError {
    fn code(&self) -> Option<&str> {
        PutEmailIdentityDkimAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEmailIdentityDkimAttributesError {
    /// Creates a new `PutEmailIdentityDkimAttributesError`.
    pub fn new(
        kind: PutEmailIdentityDkimAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEmailIdentityDkimAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEmailIdentityDkimAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEmailIdentityDkimAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEmailIdentityDkimAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEmailIdentityDkimAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityDkimAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEmailIdentityDkimAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityDkimAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEmailIdentityDkimAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityDkimAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutEmailIdentityDkimAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEmailIdentityDkimAttributesErrorKind::BadRequestException(_inner) => Some(_inner),
            PutEmailIdentityDkimAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            PutEmailIdentityDkimAttributesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutEmailIdentityDkimAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEmailIdentityFeedbackAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEmailIdentityFeedbackAttributesError {
    /// Kind of error that occurred.
    pub kind: PutEmailIdentityFeedbackAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEmailIdentityFeedbackAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEmailIdentityFeedbackAttributesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEmailIdentityFeedbackAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEmailIdentityFeedbackAttributesErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutEmailIdentityFeedbackAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutEmailIdentityFeedbackAttributesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutEmailIdentityFeedbackAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEmailIdentityFeedbackAttributesError {
    fn code(&self) -> Option<&str> {
        PutEmailIdentityFeedbackAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEmailIdentityFeedbackAttributesError {
    /// Creates a new `PutEmailIdentityFeedbackAttributesError`.
    pub fn new(
        kind: PutEmailIdentityFeedbackAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEmailIdentityFeedbackAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEmailIdentityFeedbackAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEmailIdentityFeedbackAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEmailIdentityFeedbackAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEmailIdentityFeedbackAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityFeedbackAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEmailIdentityFeedbackAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityFeedbackAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEmailIdentityFeedbackAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityFeedbackAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutEmailIdentityFeedbackAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEmailIdentityFeedbackAttributesErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            PutEmailIdentityFeedbackAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            PutEmailIdentityFeedbackAttributesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutEmailIdentityFeedbackAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEmailIdentityMailFromAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEmailIdentityMailFromAttributesError {
    /// Kind of error that occurred.
    pub kind: PutEmailIdentityMailFromAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEmailIdentityMailFromAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEmailIdentityMailFromAttributesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEmailIdentityMailFromAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEmailIdentityMailFromAttributesErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutEmailIdentityMailFromAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutEmailIdentityMailFromAttributesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutEmailIdentityMailFromAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEmailIdentityMailFromAttributesError {
    fn code(&self) -> Option<&str> {
        PutEmailIdentityMailFromAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEmailIdentityMailFromAttributesError {
    /// Creates a new `PutEmailIdentityMailFromAttributesError`.
    pub fn new(
        kind: PutEmailIdentityMailFromAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEmailIdentityMailFromAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEmailIdentityMailFromAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEmailIdentityMailFromAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEmailIdentityMailFromAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEmailIdentityMailFromAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityMailFromAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEmailIdentityMailFromAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityMailFromAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEmailIdentityMailFromAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEmailIdentityMailFromAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutEmailIdentityMailFromAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEmailIdentityMailFromAttributesErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            PutEmailIdentityMailFromAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            PutEmailIdentityMailFromAttributesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutEmailIdentityMailFromAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendEmailError {
    /// Kind of error that occurred.
    pub kind: SendEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendEmailErrorKind {
    /// <p>The message can't be sent because the account's ability to send email has been
    /// permanently restricted.</p>
    AccountSuspendedException(crate::error::AccountSuspendedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are too many instances of the specified resource type.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The message can't be sent because the sending domain isn't verified.</p>
    MailFromDomainNotVerifiedException(crate::error::MailFromDomainNotVerifiedException),
    /// <p>The message can't be sent because it contains invalid content.</p>
    MessageRejected(crate::error::MessageRejected),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The message can't be sent because the account's ability to send email is currently
    /// paused.</p>
    SendingPausedException(crate::error::SendingPausedException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendEmailErrorKind::AccountSuspendedException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            SendEmailErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::SendingPausedException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendEmailError {
    fn code(&self) -> Option<&str> {
        SendEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendEmailError {
    /// Creates a new `SendEmailError`.
    pub fn new(kind: SendEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::AccountSuspendedException`.
    pub fn is_account_suspended_exception(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::AccountSuspendedException(_))
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::MailFromDomainNotVerifiedException`.
    pub fn is_mail_from_domain_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendEmailErrorKind::MailFromDomainNotVerifiedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::MessageRejected(_))
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::SendingPausedException`.
    pub fn is_sending_paused_exception(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::SendingPausedException(_))
    }
    /// Returns `true` if the error kind is `SendEmailErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for SendEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendEmailErrorKind::AccountSuspendedException(_inner) => Some(_inner),
            SendEmailErrorKind::BadRequestException(_inner) => Some(_inner),
            SendEmailErrorKind::LimitExceededException(_inner) => Some(_inner),
            SendEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => Some(_inner),
            SendEmailErrorKind::MessageRejected(_inner) => Some(_inner),
            SendEmailErrorKind::NotFoundException(_inner) => Some(_inner),
            SendEmailErrorKind::SendingPausedException(_inner) => Some(_inner),
            SendEmailErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SendEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource is being modified by another operation or thread.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationSetEventDestinationErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource you attempted to access doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Too many requests have been made to the operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationSetEventDestinationError {
    /// Creates a new `UpdateConfigurationSetEventDestinationError`.
    pub fn new(
        kind: UpdateConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationSetEventDestinationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationSetEventDestinationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationSetEventDestinationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// <p>Too many requests have been made to the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The resource you attempted to access doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The input you provided is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The resource is being modified by another operation or thread.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The message can't be sent because the account's ability to send email is currently
/// paused.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendingPausedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SendingPausedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendingPausedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SendingPausedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SendingPausedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SendingPausedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for SendingPausedException {}
/// See [`SendingPausedException`](crate::error::SendingPausedException)
pub mod sending_paused_exception {
    /// A builder for [`SendingPausedException`](crate::error::SendingPausedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SendingPausedException`](crate::error::SendingPausedException)
        pub fn build(self) -> crate::error::SendingPausedException {
            crate::error::SendingPausedException {
                message: self.message,
            }
        }
    }
}
impl SendingPausedException {
    /// Creates a new builder-style object to manufacture [`SendingPausedException`](crate::error::SendingPausedException)
    pub fn builder() -> crate::error::sending_paused_exception::Builder {
        crate::error::sending_paused_exception::Builder::default()
    }
}

/// <p>The message can't be sent because it contains invalid content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageRejected {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MessageRejected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageRejected");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MessageRejected {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MessageRejected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MessageRejected")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for MessageRejected {}
/// See [`MessageRejected`](crate::error::MessageRejected)
pub mod message_rejected {
    /// A builder for [`MessageRejected`](crate::error::MessageRejected)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageRejected`](crate::error::MessageRejected)
        pub fn build(self) -> crate::error::MessageRejected {
            crate::error::MessageRejected {
                message: self.message,
            }
        }
    }
}
impl MessageRejected {
    /// Creates a new builder-style object to manufacture [`MessageRejected`](crate::error::MessageRejected)
    pub fn builder() -> crate::error::message_rejected::Builder {
        crate::error::message_rejected::Builder::default()
    }
}

/// <p>The message can't be sent because the sending domain isn't verified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailFromDomainNotVerifiedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MailFromDomainNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailFromDomainNotVerifiedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MailFromDomainNotVerifiedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MailFromDomainNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MailFromDomainNotVerifiedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for MailFromDomainNotVerifiedException {}
/// See [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
pub mod mail_from_domain_not_verified_exception {
    /// A builder for [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
        pub fn build(self) -> crate::error::MailFromDomainNotVerifiedException {
            crate::error::MailFromDomainNotVerifiedException {
                message: self.message,
            }
        }
    }
}
impl MailFromDomainNotVerifiedException {
    /// Creates a new builder-style object to manufacture [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
    pub fn builder() -> crate::error::mail_from_domain_not_verified_exception::Builder {
        crate::error::mail_from_domain_not_verified_exception::Builder::default()
    }
}

/// <p>There are too many instances of the specified resource type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The message can't be sent because the account's ability to send email has been
/// permanently restricted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountSuspendedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountSuspendedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountSuspendedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountSuspendedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountSuspendedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountSuspendedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountSuspendedException {}
/// See [`AccountSuspendedException`](crate::error::AccountSuspendedException)
pub mod account_suspended_exception {
    /// A builder for [`AccountSuspendedException`](crate::error::AccountSuspendedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountSuspendedException`](crate::error::AccountSuspendedException)
        pub fn build(self) -> crate::error::AccountSuspendedException {
            crate::error::AccountSuspendedException {
                message: self.message,
            }
        }
    }
}
impl AccountSuspendedException {
    /// Creates a new builder-style object to manufacture [`AccountSuspendedException`](crate::error::AccountSuspendedException)
    pub fn builder() -> crate::error::account_suspended_exception::Builder {
        crate::error::account_suspended_exception::Builder::default()
    }
}

/// <p>The resource specified in your request already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}
