// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Pinpoint
///
/// Client for invoking operations on Amazon Pinpoint. Each operation on Amazon Pinpoint is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_pinpoint::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_pinpoint::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_pinpoint::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateApp`](crate::client::fluent_builders::CreateApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_application_request(CreateApplicationRequest)`](crate::client::fluent_builders::CreateApp::create_application_request) / [`set_create_application_request(Option<CreateApplicationRequest>)`](crate::client::fluent_builders::CreateApp::set_create_application_request): <p>Specifies the display name of an application and the tags to associate with the application.</p>
    /// - On success, responds with [`CreateAppOutput`](crate::output::CreateAppOutput) with field(s):
    ///   - [`application_response(Option<ApplicationResponse>)`](crate::output::CreateAppOutput::application_response): <p>Provides information about an application.</p>
    /// - On failure, responds with [`SdkError<CreateAppError>`](crate::error::CreateAppError)
    pub fn create_app(&self) -> fluent_builders::CreateApp<C, M, R> {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCampaign`](crate::client::fluent_builders::CreateCampaign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateCampaign::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateCampaign::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`write_campaign_request(WriteCampaignRequest)`](crate::client::fluent_builders::CreateCampaign::write_campaign_request) / [`set_write_campaign_request(Option<WriteCampaignRequest>)`](crate::client::fluent_builders::CreateCampaign::set_write_campaign_request): <p>Specifies the configuration and other settings for a campaign.</p>
    /// - On success, responds with [`CreateCampaignOutput`](crate::output::CreateCampaignOutput) with field(s):
    ///   - [`campaign_response(Option<CampaignResponse>)`](crate::output::CreateCampaignOutput::campaign_response): <p>Provides information about the status, configuration, and other settings for a campaign.</p>
    /// - On failure, responds with [`SdkError<CreateCampaignError>`](crate::error::CreateCampaignError)
    pub fn create_campaign(&self) -> fluent_builders::CreateCampaign<C, M, R> {
        fluent_builders::CreateCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEmailTemplate`](crate::client::fluent_builders::CreateEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_template_request(EmailTemplateRequest)`](crate::client::fluent_builders::CreateEmailTemplate::email_template_request) / [`set_email_template_request(Option<EmailTemplateRequest>)`](crate::client::fluent_builders::CreateEmailTemplate::set_email_template_request): <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateEmailTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    /// - On success, responds with [`CreateEmailTemplateOutput`](crate::output::CreateEmailTemplateOutput) with field(s):
    ///   - [`create_template_message_body(Option<CreateTemplateMessageBody>)`](crate::output::CreateEmailTemplateOutput::create_template_message_body): <p>Provides information about a request to create a message template.</p>
    /// - On failure, responds with [`SdkError<CreateEmailTemplateError>`](crate::error::CreateEmailTemplateError)
    pub fn create_email_template(&self) -> fluent_builders::CreateEmailTemplate<C, M, R> {
        fluent_builders::CreateEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateExportJob`](crate::client::fluent_builders::CreateExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateExportJob::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateExportJob::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`export_job_request(ExportJobRequest)`](crate::client::fluent_builders::CreateExportJob::export_job_request) / [`set_export_job_request(Option<ExportJobRequest>)`](crate::client::fluent_builders::CreateExportJob::set_export_job_request): <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
    /// - On success, responds with [`CreateExportJobOutput`](crate::output::CreateExportJobOutput) with field(s):
    ///   - [`export_job_response(Option<ExportJobResponse>)`](crate::output::CreateExportJobOutput::export_job_response): <p>Provides information about the status and settings of a job that exports endpoint definitions to a file. The file can be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded directly to a computer by using the Amazon Pinpoint console.</p>
    /// - On failure, responds with [`SdkError<CreateExportJobError>`](crate::error::CreateExportJobError)
    pub fn create_export_job(&self) -> fluent_builders::CreateExportJob<C, M, R> {
        fluent_builders::CreateExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImportJob`](crate::client::fluent_builders::CreateImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateImportJob::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateImportJob::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`import_job_request(ImportJobRequest)`](crate::client::fluent_builders::CreateImportJob::import_job_request) / [`set_import_job_request(Option<ImportJobRequest>)`](crate::client::fluent_builders::CreateImportJob::set_import_job_request): <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
    /// - On success, responds with [`CreateImportJobOutput`](crate::output::CreateImportJobOutput) with field(s):
    ///   - [`import_job_response(Option<ImportJobResponse>)`](crate::output::CreateImportJobOutput::import_job_response): <p>Provides information about the status and settings of a job that imports endpoint definitions from one or more files. The files can be stored in an Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer by using the Amazon Pinpoint console.</p>
    /// - On failure, responds with [`SdkError<CreateImportJobError>`](crate::error::CreateImportJobError)
    pub fn create_import_job(&self) -> fluent_builders::CreateImportJob<C, M, R> {
        fluent_builders::CreateImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInAppTemplate`](crate::client::fluent_builders::CreateInAppTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`in_app_template_request(InAppTemplateRequest)`](crate::client::fluent_builders::CreateInAppTemplate::in_app_template_request) / [`set_in_app_template_request(Option<InAppTemplateRequest>)`](crate::client::fluent_builders::CreateInAppTemplate::set_in_app_template_request): <p>InApp Template Request.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateInAppTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateInAppTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    /// - On success, responds with [`CreateInAppTemplateOutput`](crate::output::CreateInAppTemplateOutput) with field(s):
    ///   - [`template_create_message_body(Option<TemplateCreateMessageBody>)`](crate::output::CreateInAppTemplateOutput::template_create_message_body): <p>Provides information about a request to create a message template.</p>
    /// - On failure, responds with [`SdkError<CreateInAppTemplateError>`](crate::error::CreateInAppTemplateError)
    pub fn create_in_app_template(&self) -> fluent_builders::CreateInAppTemplate<C, M, R> {
        fluent_builders::CreateInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJourney`](crate::client::fluent_builders::CreateJourney) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateJourney::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateJourney::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`write_journey_request(WriteJourneyRequest)`](crate::client::fluent_builders::CreateJourney::write_journey_request) / [`set_write_journey_request(Option<WriteJourneyRequest>)`](crate::client::fluent_builders::CreateJourney::set_write_journey_request): <p>Specifies the configuration and other settings for a journey.</p>
    /// - On success, responds with [`CreateJourneyOutput`](crate::output::CreateJourneyOutput) with field(s):
    ///   - [`journey_response(Option<JourneyResponse>)`](crate::output::CreateJourneyOutput::journey_response): <p>Provides information about the status, configuration, and other settings for a journey.</p>
    /// - On failure, responds with [`SdkError<CreateJourneyError>`](crate::error::CreateJourneyError)
    pub fn create_journey(&self) -> fluent_builders::CreateJourney<C, M, R> {
        fluent_builders::CreateJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePushTemplate`](crate::client::fluent_builders::CreatePushTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`push_notification_template_request(PushNotificationTemplateRequest)`](crate::client::fluent_builders::CreatePushTemplate::push_notification_template_request) / [`set_push_notification_template_request(Option<PushNotificationTemplateRequest>)`](crate::client::fluent_builders::CreatePushTemplate::set_push_notification_template_request): <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreatePushTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreatePushTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    /// - On success, responds with [`CreatePushTemplateOutput`](crate::output::CreatePushTemplateOutput) with field(s):
    ///   - [`create_template_message_body(Option<CreateTemplateMessageBody>)`](crate::output::CreatePushTemplateOutput::create_template_message_body): <p>Provides information about a request to create a message template.</p>
    /// - On failure, responds with [`SdkError<CreatePushTemplateError>`](crate::error::CreatePushTemplateError)
    pub fn create_push_template(&self) -> fluent_builders::CreatePushTemplate<C, M, R> {
        fluent_builders::CreatePushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecommenderConfiguration`](crate::client::fluent_builders::CreateRecommenderConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_recommender_configuration(CreateRecommenderConfigurationShape)`](crate::client::fluent_builders::CreateRecommenderConfiguration::create_recommender_configuration) / [`set_create_recommender_configuration(Option<CreateRecommenderConfigurationShape>)`](crate::client::fluent_builders::CreateRecommenderConfiguration::set_create_recommender_configuration): <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
    /// - On success, responds with [`CreateRecommenderConfigurationOutput`](crate::output::CreateRecommenderConfigurationOutput) with field(s):
    ///   - [`recommender_configuration_response(Option<RecommenderConfigurationResponse>)`](crate::output::CreateRecommenderConfigurationOutput::recommender_configuration_response): <p>Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.</p>
    /// - On failure, responds with [`SdkError<CreateRecommenderConfigurationError>`](crate::error::CreateRecommenderConfigurationError)
    pub fn create_recommender_configuration(
        &self,
    ) -> fluent_builders::CreateRecommenderConfiguration<C, M, R> {
        fluent_builders::CreateRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSegment`](crate::client::fluent_builders::CreateSegment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateSegment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateSegment::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`write_segment_request(WriteSegmentRequest)`](crate::client::fluent_builders::CreateSegment::write_segment_request) / [`set_write_segment_request(Option<WriteSegmentRequest>)`](crate::client::fluent_builders::CreateSegment::set_write_segment_request): <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
    /// - On success, responds with [`CreateSegmentOutput`](crate::output::CreateSegmentOutput) with field(s):
    ///   - [`segment_response(Option<SegmentResponse>)`](crate::output::CreateSegmentOutput::segment_response): <p>Provides information about the configuration, dimension, and other settings for a segment.</p>
    /// - On failure, responds with [`SdkError<CreateSegmentError>`](crate::error::CreateSegmentError)
    pub fn create_segment(&self) -> fluent_builders::CreateSegment<C, M, R> {
        fluent_builders::CreateSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSmsTemplate`](crate::client::fluent_builders::CreateSmsTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sms_template_request(SmsTemplateRequest)`](crate::client::fluent_builders::CreateSmsTemplate::sms_template_request) / [`set_sms_template_request(Option<SmsTemplateRequest>)`](crate::client::fluent_builders::CreateSmsTemplate::set_sms_template_request): <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateSmsTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateSmsTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    /// - On success, responds with [`CreateSmsTemplateOutput`](crate::output::CreateSmsTemplateOutput) with field(s):
    ///   - [`create_template_message_body(Option<CreateTemplateMessageBody>)`](crate::output::CreateSmsTemplateOutput::create_template_message_body): <p>Provides information about a request to create a message template.</p>
    /// - On failure, responds with [`SdkError<CreateSmsTemplateError>`](crate::error::CreateSmsTemplateError)
    pub fn create_sms_template(&self) -> fluent_builders::CreateSmsTemplate<C, M, R> {
        fluent_builders::CreateSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVoiceTemplate`](crate::client::fluent_builders::CreateVoiceTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateVoiceTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateVoiceTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`voice_template_request(VoiceTemplateRequest)`](crate::client::fluent_builders::CreateVoiceTemplate::voice_template_request) / [`set_voice_template_request(Option<VoiceTemplateRequest>)`](crate::client::fluent_builders::CreateVoiceTemplate::set_voice_template_request): <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
    /// - On success, responds with [`CreateVoiceTemplateOutput`](crate::output::CreateVoiceTemplateOutput) with field(s):
    ///   - [`create_template_message_body(Option<CreateTemplateMessageBody>)`](crate::output::CreateVoiceTemplateOutput::create_template_message_body): <p>Provides information about a request to create a message template.</p>
    /// - On failure, responds with [`SdkError<CreateVoiceTemplateError>`](crate::error::CreateVoiceTemplateError)
    pub fn create_voice_template(&self) -> fluent_builders::CreateVoiceTemplate<C, M, R> {
        fluent_builders::CreateVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAdmChannel`](crate::client::fluent_builders::DeleteAdmChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAdmChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteAdmChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteAdmChannelOutput`](crate::output::DeleteAdmChannelOutput) with field(s):
    ///   - [`adm_channel_response(Option<AdmChannelResponse>)`](crate::output::DeleteAdmChannelOutput::adm_channel_response): <p>Provides information about the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteAdmChannelError>`](crate::error::DeleteAdmChannelError)
    pub fn delete_adm_channel(&self) -> fluent_builders::DeleteAdmChannel<C, M, R> {
        fluent_builders::DeleteAdmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApnsChannel`](crate::client::fluent_builders::DeleteApnsChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApnsChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApnsChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteApnsChannelOutput`](crate::output::DeleteApnsChannelOutput) with field(s):
    ///   - [`apns_channel_response(Option<ApnsChannelResponse>)`](crate::output::DeleteApnsChannelOutput::apns_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteApnsChannelError>`](crate::error::DeleteApnsChannelError)
    pub fn delete_apns_channel(&self) -> fluent_builders::DeleteApnsChannel<C, M, R> {
        fluent_builders::DeleteApnsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApnsSandboxChannel`](crate::client::fluent_builders::DeleteApnsSandboxChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApnsSandboxChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApnsSandboxChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteApnsSandboxChannelOutput`](crate::output::DeleteApnsSandboxChannelOutput) with field(s):
    ///   - [`apns_sandbox_channel_response(Option<ApnsSandboxChannelResponse>)`](crate::output::DeleteApnsSandboxChannelOutput::apns_sandbox_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteApnsSandboxChannelError>`](crate::error::DeleteApnsSandboxChannelError)
    pub fn delete_apns_sandbox_channel(
        &self,
    ) -> fluent_builders::DeleteApnsSandboxChannel<C, M, R> {
        fluent_builders::DeleteApnsSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApnsVoipChannel`](crate::client::fluent_builders::DeleteApnsVoipChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApnsVoipChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApnsVoipChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteApnsVoipChannelOutput`](crate::output::DeleteApnsVoipChannelOutput) with field(s):
    ///   - [`apns_voip_channel_response(Option<ApnsVoipChannelResponse>)`](crate::output::DeleteApnsVoipChannelOutput::apns_voip_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteApnsVoipChannelError>`](crate::error::DeleteApnsVoipChannelError)
    pub fn delete_apns_voip_channel(&self) -> fluent_builders::DeleteApnsVoipChannel<C, M, R> {
        fluent_builders::DeleteApnsVoipChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApnsVoipSandboxChannel`](crate::client::fluent_builders::DeleteApnsVoipSandboxChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApnsVoipSandboxChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApnsVoipSandboxChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteApnsVoipSandboxChannelOutput`](crate::output::DeleteApnsVoipSandboxChannelOutput) with field(s):
    ///   - [`apns_voip_sandbox_channel_response(Option<ApnsVoipSandboxChannelResponse>)`](crate::output::DeleteApnsVoipSandboxChannelOutput::apns_voip_sandbox_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteApnsVoipSandboxChannelError>`](crate::error::DeleteApnsVoipSandboxChannelError)
    pub fn delete_apns_voip_sandbox_channel(
        &self,
    ) -> fluent_builders::DeleteApnsVoipSandboxChannel<C, M, R> {
        fluent_builders::DeleteApnsVoipSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApp`](crate::client::fluent_builders::DeleteApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApp::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApp::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteAppOutput`](crate::output::DeleteAppOutput) with field(s):
    ///   - [`application_response(Option<ApplicationResponse>)`](crate::output::DeleteAppOutput::application_response): <p>Provides information about an application.</p>
    /// - On failure, responds with [`SdkError<DeleteAppError>`](crate::error::DeleteAppError)
    pub fn delete_app(&self) -> fluent_builders::DeleteApp<C, M, R> {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBaiduChannel`](crate::client::fluent_builders::DeleteBaiduChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBaiduChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteBaiduChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteBaiduChannelOutput`](crate::output::DeleteBaiduChannelOutput) with field(s):
    ///   - [`baidu_channel_response(Option<BaiduChannelResponse>)`](crate::output::DeleteBaiduChannelOutput::baidu_channel_response): <p>Provides information about the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteBaiduChannelError>`](crate::error::DeleteBaiduChannelError)
    pub fn delete_baidu_channel(&self) -> fluent_builders::DeleteBaiduChannel<C, M, R> {
        fluent_builders::DeleteBaiduChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCampaign`](crate::client::fluent_builders::DeleteCampaign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCampaign::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteCampaign::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCampaign::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::DeleteCampaign::set_campaign_id): <p>The unique identifier for the campaign.</p>
    /// - On success, responds with [`DeleteCampaignOutput`](crate::output::DeleteCampaignOutput) with field(s):
    ///   - [`campaign_response(Option<CampaignResponse>)`](crate::output::DeleteCampaignOutput::campaign_response): <p>Provides information about the status, configuration, and other settings for a campaign.</p>
    /// - On failure, responds with [`SdkError<DeleteCampaignError>`](crate::error::DeleteCampaignError)
    pub fn delete_campaign(&self) -> fluent_builders::DeleteCampaign<C, M, R> {
        fluent_builders::DeleteCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailChannel`](crate::client::fluent_builders::DeleteEmailChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteEmailChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteEmailChannelOutput`](crate::output::DeleteEmailChannelOutput) with field(s):
    ///   - [`email_channel_response(Option<EmailChannelResponse>)`](crate::output::DeleteEmailChannelOutput::email_channel_response): <p>Provides information about the status and settings of the email channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteEmailChannelError>`](crate::error::DeleteEmailChannelError)
    pub fn delete_email_channel(&self) -> fluent_builders::DeleteEmailChannel<C, M, R> {
        fluent_builders::DeleteEmailChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailTemplate`](crate::client::fluent_builders::DeleteEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteEmailTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteEmailTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`DeleteEmailTemplateOutput`](crate::output::DeleteEmailTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::DeleteEmailTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<DeleteEmailTemplateError>`](crate::error::DeleteEmailTemplateError)
    pub fn delete_email_template(&self) -> fluent_builders::DeleteEmailTemplate<C, M, R> {
        fluent_builders::DeleteEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEndpoint::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteEndpoint::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEndpoint::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::DeleteEndpoint::set_endpoint_id): <p>The unique identifier for the endpoint.</p>
    /// - On success, responds with [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput) with field(s):
    ///   - [`endpoint_response(Option<EndpointResponse>)`](crate::output::DeleteEndpointOutput::endpoint_response): <p>Provides information about the channel type and other settings for an endpoint.</p>
    /// - On failure, responds with [`SdkError<DeleteEndpointError>`](crate::error::DeleteEndpointError)
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint<C, M, R> {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventStream`](crate::client::fluent_builders::DeleteEventStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEventStream::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteEventStream::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteEventStreamOutput`](crate::output::DeleteEventStreamOutput) with field(s):
    ///   - [`event_stream(Option<EventStream>)`](crate::output::DeleteEventStreamOutput::event_stream): <p>Specifies settings for publishing event data to an Amazon Kinesis data stream or an Amazon Kinesis Data Firehose delivery stream.</p>
    /// - On failure, responds with [`SdkError<DeleteEventStreamError>`](crate::error::DeleteEventStreamError)
    pub fn delete_event_stream(&self) -> fluent_builders::DeleteEventStream<C, M, R> {
        fluent_builders::DeleteEventStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGcmChannel`](crate::client::fluent_builders::DeleteGcmChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGcmChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteGcmChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteGcmChannelOutput`](crate::output::DeleteGcmChannelOutput) with field(s):
    ///   - [`gcm_channel_response(Option<GcmChannelResponse>)`](crate::output::DeleteGcmChannelOutput::gcm_channel_response): <p>Provides information about the status and settings of the GCM channel for an application. The GCM channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
    /// - On failure, responds with [`SdkError<DeleteGcmChannelError>`](crate::error::DeleteGcmChannelError)
    pub fn delete_gcm_channel(&self) -> fluent_builders::DeleteGcmChannel<C, M, R> {
        fluent_builders::DeleteGcmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInAppTemplate`](crate::client::fluent_builders::DeleteInAppTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteInAppTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteInAppTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteInAppTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteInAppTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`DeleteInAppTemplateOutput`](crate::output::DeleteInAppTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::DeleteInAppTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<DeleteInAppTemplateError>`](crate::error::DeleteInAppTemplateError)
    pub fn delete_in_app_template(&self) -> fluent_builders::DeleteInAppTemplate<C, M, R> {
        fluent_builders::DeleteInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJourney`](crate::client::fluent_builders::DeleteJourney) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJourney::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteJourney::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJourney::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::DeleteJourney::set_journey_id): <p>The unique identifier for the journey.</p>
    /// - On success, responds with [`DeleteJourneyOutput`](crate::output::DeleteJourneyOutput) with field(s):
    ///   - [`journey_response(Option<JourneyResponse>)`](crate::output::DeleteJourneyOutput::journey_response): <p>Provides information about the status, configuration, and other settings for a journey.</p>
    /// - On failure, responds with [`SdkError<DeleteJourneyError>`](crate::error::DeleteJourneyError)
    pub fn delete_journey(&self) -> fluent_builders::DeleteJourney<C, M, R> {
        fluent_builders::DeleteJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePushTemplate`](crate::client::fluent_builders::DeletePushTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeletePushTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeletePushTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeletePushTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeletePushTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`DeletePushTemplateOutput`](crate::output::DeletePushTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::DeletePushTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<DeletePushTemplateError>`](crate::error::DeletePushTemplateError)
    pub fn delete_push_template(&self) -> fluent_builders::DeletePushTemplate<C, M, R> {
        fluent_builders::DeletePushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecommenderConfiguration`](crate::client::fluent_builders::DeleteRecommenderConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recommender_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRecommenderConfiguration::recommender_id) / [`set_recommender_id(Option<String>)`](crate::client::fluent_builders::DeleteRecommenderConfiguration::set_recommender_id): <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteRecommenderConfigurationOutput`](crate::output::DeleteRecommenderConfigurationOutput) with field(s):
    ///   - [`recommender_configuration_response(Option<RecommenderConfigurationResponse>)`](crate::output::DeleteRecommenderConfigurationOutput::recommender_configuration_response): <p>Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.</p>
    /// - On failure, responds with [`SdkError<DeleteRecommenderConfigurationError>`](crate::error::DeleteRecommenderConfigurationError)
    pub fn delete_recommender_configuration(
        &self,
    ) -> fluent_builders::DeleteRecommenderConfiguration<C, M, R> {
        fluent_builders::DeleteRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSegment`](crate::client::fluent_builders::DeleteSegment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSegment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteSegment::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSegment::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::DeleteSegment::set_segment_id): <p>The unique identifier for the segment.</p>
    /// - On success, responds with [`DeleteSegmentOutput`](crate::output::DeleteSegmentOutput) with field(s):
    ///   - [`segment_response(Option<SegmentResponse>)`](crate::output::DeleteSegmentOutput::segment_response): <p>Provides information about the configuration, dimension, and other settings for a segment.</p>
    /// - On failure, responds with [`SdkError<DeleteSegmentError>`](crate::error::DeleteSegmentError)
    pub fn delete_segment(&self) -> fluent_builders::DeleteSegment<C, M, R> {
        fluent_builders::DeleteSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSmsChannel`](crate::client::fluent_builders::DeleteSmsChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSmsChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteSmsChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteSmsChannelOutput`](crate::output::DeleteSmsChannelOutput) with field(s):
    ///   - [`sms_channel_response(Option<SmsChannelResponse>)`](crate::output::DeleteSmsChannelOutput::sms_channel_response): <p>Provides information about the status and settings of the SMS channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteSmsChannelError>`](crate::error::DeleteSmsChannelError)
    pub fn delete_sms_channel(&self) -> fluent_builders::DeleteSmsChannel<C, M, R> {
        fluent_builders::DeleteSmsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSmsTemplate`](crate::client::fluent_builders::DeleteSmsTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSmsTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteSmsTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteSmsTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteSmsTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`DeleteSmsTemplateOutput`](crate::output::DeleteSmsTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::DeleteSmsTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<DeleteSmsTemplateError>`](crate::error::DeleteSmsTemplateError)
    pub fn delete_sms_template(&self) -> fluent_builders::DeleteSmsTemplate<C, M, R> {
        fluent_builders::DeleteSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserEndpoints`](crate::client::fluent_builders::DeleteUserEndpoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserEndpoints::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteUserEndpoints::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserEndpoints::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteUserEndpoints::set_user_id): <p>The unique identifier for the user.</p>
    /// - On success, responds with [`DeleteUserEndpointsOutput`](crate::output::DeleteUserEndpointsOutput) with field(s):
    ///   - [`endpoints_response(Option<EndpointsResponse>)`](crate::output::DeleteUserEndpointsOutput::endpoints_response): <p>Provides information about all the endpoints that are associated with a user ID.</p>
    /// - On failure, responds with [`SdkError<DeleteUserEndpointsError>`](crate::error::DeleteUserEndpointsError)
    pub fn delete_user_endpoints(&self) -> fluent_builders::DeleteUserEndpoints<C, M, R> {
        fluent_builders::DeleteUserEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceChannel`](crate::client::fluent_builders::DeleteVoiceChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`DeleteVoiceChannelOutput`](crate::output::DeleteVoiceChannelOutput) with field(s):
    ///   - [`voice_channel_response(Option<VoiceChannelResponse>)`](crate::output::DeleteVoiceChannelOutput::voice_channel_response): <p>Provides information about the status and settings of the voice channel for an application.</p>
    /// - On failure, responds with [`SdkError<DeleteVoiceChannelError>`](crate::error::DeleteVoiceChannelError)
    pub fn delete_voice_channel(&self) -> fluent_builders::DeleteVoiceChannel<C, M, R> {
        fluent_builders::DeleteVoiceChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceTemplate`](crate::client::fluent_builders::DeleteVoiceTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteVoiceTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteVoiceTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`DeleteVoiceTemplateOutput`](crate::output::DeleteVoiceTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::DeleteVoiceTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<DeleteVoiceTemplateError>`](crate::error::DeleteVoiceTemplateError)
    pub fn delete_voice_template(&self) -> fluent_builders::DeleteVoiceTemplate<C, M, R> {
        fluent_builders::DeleteVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAdmChannel`](crate::client::fluent_builders::GetAdmChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetAdmChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetAdmChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetAdmChannelOutput`](crate::output::GetAdmChannelOutput) with field(s):
    ///   - [`adm_channel_response(Option<AdmChannelResponse>)`](crate::output::GetAdmChannelOutput::adm_channel_response): <p>Provides information about the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetAdmChannelError>`](crate::error::GetAdmChannelError)
    pub fn get_adm_channel(&self) -> fluent_builders::GetAdmChannel<C, M, R> {
        fluent_builders::GetAdmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApnsChannel`](crate::client::fluent_builders::GetApnsChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApnsChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApnsChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetApnsChannelOutput`](crate::output::GetApnsChannelOutput) with field(s):
    ///   - [`apns_channel_response(Option<ApnsChannelResponse>)`](crate::output::GetApnsChannelOutput::apns_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetApnsChannelError>`](crate::error::GetApnsChannelError)
    pub fn get_apns_channel(&self) -> fluent_builders::GetApnsChannel<C, M, R> {
        fluent_builders::GetApnsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApnsSandboxChannel`](crate::client::fluent_builders::GetApnsSandboxChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApnsSandboxChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApnsSandboxChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetApnsSandboxChannelOutput`](crate::output::GetApnsSandboxChannelOutput) with field(s):
    ///   - [`apns_sandbox_channel_response(Option<ApnsSandboxChannelResponse>)`](crate::output::GetApnsSandboxChannelOutput::apns_sandbox_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetApnsSandboxChannelError>`](crate::error::GetApnsSandboxChannelError)
    pub fn get_apns_sandbox_channel(&self) -> fluent_builders::GetApnsSandboxChannel<C, M, R> {
        fluent_builders::GetApnsSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApnsVoipChannel`](crate::client::fluent_builders::GetApnsVoipChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApnsVoipChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApnsVoipChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetApnsVoipChannelOutput`](crate::output::GetApnsVoipChannelOutput) with field(s):
    ///   - [`apns_voip_channel_response(Option<ApnsVoipChannelResponse>)`](crate::output::GetApnsVoipChannelOutput::apns_voip_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetApnsVoipChannelError>`](crate::error::GetApnsVoipChannelError)
    pub fn get_apns_voip_channel(&self) -> fluent_builders::GetApnsVoipChannel<C, M, R> {
        fluent_builders::GetApnsVoipChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApnsVoipSandboxChannel`](crate::client::fluent_builders::GetApnsVoipSandboxChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApnsVoipSandboxChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApnsVoipSandboxChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetApnsVoipSandboxChannelOutput`](crate::output::GetApnsVoipSandboxChannelOutput) with field(s):
    ///   - [`apns_voip_sandbox_channel_response(Option<ApnsVoipSandboxChannelResponse>)`](crate::output::GetApnsVoipSandboxChannelOutput::apns_voip_sandbox_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetApnsVoipSandboxChannelError>`](crate::error::GetApnsVoipSandboxChannelError)
    pub fn get_apns_voip_sandbox_channel(
        &self,
    ) -> fluent_builders::GetApnsVoipSandboxChannel<C, M, R> {
        fluent_builders::GetApnsVoipSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApp`](crate::client::fluent_builders::GetApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApp::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApp::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetAppOutput`](crate::output::GetAppOutput) with field(s):
    ///   - [`application_response(Option<ApplicationResponse>)`](crate::output::GetAppOutput::application_response): <p>Provides information about an application.</p>
    /// - On failure, responds with [`SdkError<GetAppError>`](crate::error::GetAppError)
    pub fn get_app(&self) -> fluent_builders::GetApp<C, M, R> {
        fluent_builders::GetApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplicationDateRangeKpi`](crate::client::fluent_builders::GetApplicationDateRangeKpi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::set_end_time): <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
    ///   - [`kpi_name(impl Into<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::kpi_name) / [`set_kpi_name(Option<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::set_kpi_name): <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetApplicationDateRangeKpi::set_start_time): <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
    /// - On success, responds with [`GetApplicationDateRangeKpiOutput`](crate::output::GetApplicationDateRangeKpiOutput) with field(s):
    ///   - [`application_date_range_kpi_response(Option<ApplicationDateRangeKpiResponse>)`](crate::output::GetApplicationDateRangeKpiOutput::application_date_range_kpi_response): <p>Provides the results of a query that retrieved the data for a standard metric that applies to an application, and provides information about that query.</p>
    /// - On failure, responds with [`SdkError<GetApplicationDateRangeKpiError>`](crate::error::GetApplicationDateRangeKpiError)
    pub fn get_application_date_range_kpi(
        &self,
    ) -> fluent_builders::GetApplicationDateRangeKpi<C, M, R> {
        fluent_builders::GetApplicationDateRangeKpi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplicationSettings`](crate::client::fluent_builders::GetApplicationSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApplicationSettings::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApplicationSettings::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetApplicationSettingsOutput`](crate::output::GetApplicationSettingsOutput) with field(s):
    ///   - [`application_settings_resource(Option<ApplicationSettingsResource>)`](crate::output::GetApplicationSettingsOutput::application_settings_resource): <p>Provides information about an application, including the default settings for an application.</p>
    /// - On failure, responds with [`SdkError<GetApplicationSettingsError>`](crate::error::GetApplicationSettingsError)
    pub fn get_application_settings(&self) -> fluent_builders::GetApplicationSettings<C, M, R> {
        fluent_builders::GetApplicationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApps`](crate::client::fluent_builders::GetApps) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetApps::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetApps::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetApps::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetApps::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetAppsOutput`](crate::output::GetAppsOutput) with field(s):
    ///   - [`applications_response(Option<ApplicationsResponse>)`](crate::output::GetAppsOutput::applications_response): <p>Provides information about all of your applications.</p>
    /// - On failure, responds with [`SdkError<GetAppsError>`](crate::error::GetAppsError)
    pub fn get_apps(&self) -> fluent_builders::GetApps<C, M, R> {
        fluent_builders::GetApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBaiduChannel`](crate::client::fluent_builders::GetBaiduChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetBaiduChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetBaiduChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetBaiduChannelOutput`](crate::output::GetBaiduChannelOutput) with field(s):
    ///   - [`baidu_channel_response(Option<BaiduChannelResponse>)`](crate::output::GetBaiduChannelOutput::baidu_channel_response): <p>Provides information about the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetBaiduChannelError>`](crate::error::GetBaiduChannelError)
    pub fn get_baidu_channel(&self) -> fluent_builders::GetBaiduChannel<C, M, R> {
        fluent_builders::GetBaiduChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCampaign`](crate::client::fluent_builders::GetCampaign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaign::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCampaign::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaign::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetCampaign::set_campaign_id): <p>The unique identifier for the campaign.</p>
    /// - On success, responds with [`GetCampaignOutput`](crate::output::GetCampaignOutput) with field(s):
    ///   - [`campaign_response(Option<CampaignResponse>)`](crate::output::GetCampaignOutput::campaign_response): <p>Provides information about the status, configuration, and other settings for a campaign.</p>
    /// - On failure, responds with [`SdkError<GetCampaignError>`](crate::error::GetCampaignError)
    pub fn get_campaign(&self) -> fluent_builders::GetCampaign<C, M, R> {
        fluent_builders::GetCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCampaignActivities`](crate::client::fluent_builders::GetCampaignActivities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignActivities::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCampaignActivities::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignActivities::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetCampaignActivities::set_campaign_id): <p>The unique identifier for the campaign.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetCampaignActivities::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetCampaignActivities::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetCampaignActivities::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetCampaignActivities::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetCampaignActivitiesOutput`](crate::output::GetCampaignActivitiesOutput) with field(s):
    ///   - [`activities_response(Option<ActivitiesResponse>)`](crate::output::GetCampaignActivitiesOutput::activities_response): <p>Provides information about the activities that were performed by a campaign.</p>
    /// - On failure, responds with [`SdkError<GetCampaignActivitiesError>`](crate::error::GetCampaignActivitiesError)
    pub fn get_campaign_activities(&self) -> fluent_builders::GetCampaignActivities<C, M, R> {
        fluent_builders::GetCampaignActivities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCampaignDateRangeKpi`](crate::client::fluent_builders::GetCampaignDateRangeKpi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_campaign_id): <p>The unique identifier for the campaign.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_end_time): <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
    ///   - [`kpi_name(impl Into<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::kpi_name) / [`set_kpi_name(Option<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_kpi_name): <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetCampaignDateRangeKpi::set_start_time): <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
    /// - On success, responds with [`GetCampaignDateRangeKpiOutput`](crate::output::GetCampaignDateRangeKpiOutput) with field(s):
    ///   - [`campaign_date_range_kpi_response(Option<CampaignDateRangeKpiResponse>)`](crate::output::GetCampaignDateRangeKpiOutput::campaign_date_range_kpi_response): <p>Provides the results of a query that retrieved the data for a standard metric that applies to a campaign, and provides information about that query.</p>
    /// - On failure, responds with [`SdkError<GetCampaignDateRangeKpiError>`](crate::error::GetCampaignDateRangeKpiError)
    pub fn get_campaign_date_range_kpi(&self) -> fluent_builders::GetCampaignDateRangeKpi<C, M, R> {
        fluent_builders::GetCampaignDateRangeKpi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCampaigns`](crate::client::fluent_builders::GetCampaigns) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaigns::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCampaigns::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetCampaigns::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetCampaigns::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetCampaigns::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetCampaigns::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetCampaignsOutput`](crate::output::GetCampaignsOutput) with field(s):
    ///   - [`campaigns_response(Option<CampaignsResponse>)`](crate::output::GetCampaignsOutput::campaigns_response): <p>Provides information about the configuration and other settings for all the campaigns that are associated with an application.</p>
    /// - On failure, responds with [`SdkError<GetCampaignsError>`](crate::error::GetCampaignsError)
    pub fn get_campaigns(&self) -> fluent_builders::GetCampaigns<C, M, R> {
        fluent_builders::GetCampaigns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCampaignVersion`](crate::client::fluent_builders::GetCampaignVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersion::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCampaignVersion::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersion::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetCampaignVersion::set_campaign_id): <p>The unique identifier for the campaign.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetCampaignVersion::set_version): <p>The unique version number (Version property) for the campaign version.</p>
    /// - On success, responds with [`GetCampaignVersionOutput`](crate::output::GetCampaignVersionOutput) with field(s):
    ///   - [`campaign_response(Option<CampaignResponse>)`](crate::output::GetCampaignVersionOutput::campaign_response): <p>Provides information about the status, configuration, and other settings for a campaign.</p>
    /// - On failure, responds with [`SdkError<GetCampaignVersionError>`](crate::error::GetCampaignVersionError)
    pub fn get_campaign_version(&self) -> fluent_builders::GetCampaignVersion<C, M, R> {
        fluent_builders::GetCampaignVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCampaignVersions`](crate::client::fluent_builders::GetCampaignVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersions::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCampaignVersions::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersions::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetCampaignVersions::set_campaign_id): <p>The unique identifier for the campaign.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersions::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetCampaignVersions::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetCampaignVersions::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetCampaignVersions::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetCampaignVersionsOutput`](crate::output::GetCampaignVersionsOutput) with field(s):
    ///   - [`campaigns_response(Option<CampaignsResponse>)`](crate::output::GetCampaignVersionsOutput::campaigns_response): <p>Provides information about the configuration and other settings for all the campaigns that are associated with an application.</p>
    /// - On failure, responds with [`SdkError<GetCampaignVersionsError>`](crate::error::GetCampaignVersionsError)
    pub fn get_campaign_versions(&self) -> fluent_builders::GetCampaignVersions<C, M, R> {
        fluent_builders::GetCampaignVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChannels`](crate::client::fluent_builders::GetChannels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetChannels::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetChannels::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetChannelsOutput`](crate::output::GetChannelsOutput) with field(s):
    ///   - [`channels_response(Option<ChannelsResponse>)`](crate::output::GetChannelsOutput::channels_response): <p>Provides information about the general settings and status of all channels for an application, including channels that aren't enabled for the application.</p>
    /// - On failure, responds with [`SdkError<GetChannelsError>`](crate::error::GetChannelsError)
    pub fn get_channels(&self) -> fluent_builders::GetChannels<C, M, R> {
        fluent_builders::GetChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEmailChannel`](crate::client::fluent_builders::GetEmailChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetEmailChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetEmailChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetEmailChannelOutput`](crate::output::GetEmailChannelOutput) with field(s):
    ///   - [`email_channel_response(Option<EmailChannelResponse>)`](crate::output::GetEmailChannelOutput::email_channel_response): <p>Provides information about the status and settings of the email channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetEmailChannelError>`](crate::error::GetEmailChannelError)
    pub fn get_email_channel(&self) -> fluent_builders::GetEmailChannel<C, M, R> {
        fluent_builders::GetEmailChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEmailTemplate`](crate::client::fluent_builders::GetEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetEmailTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetEmailTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetEmailTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`GetEmailTemplateOutput`](crate::output::GetEmailTemplateOutput) with field(s):
    ///   - [`email_template_response(Option<EmailTemplateResponse>)`](crate::output::GetEmailTemplateOutput::email_template_response): <p>Provides information about the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
    /// - On failure, responds with [`SdkError<GetEmailTemplateError>`](crate::error::GetEmailTemplateError)
    pub fn get_email_template(&self) -> fluent_builders::GetEmailTemplate<C, M, R> {
        fluent_builders::GetEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEndpoint`](crate::client::fluent_builders::GetEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetEndpoint::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetEndpoint::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::GetEndpoint::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::GetEndpoint::set_endpoint_id): <p>The unique identifier for the endpoint.</p>
    /// - On success, responds with [`GetEndpointOutput`](crate::output::GetEndpointOutput) with field(s):
    ///   - [`endpoint_response(Option<EndpointResponse>)`](crate::output::GetEndpointOutput::endpoint_response): <p>Provides information about the channel type and other settings for an endpoint.</p>
    /// - On failure, responds with [`SdkError<GetEndpointError>`](crate::error::GetEndpointError)
    pub fn get_endpoint(&self) -> fluent_builders::GetEndpoint<C, M, R> {
        fluent_builders::GetEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventStream`](crate::client::fluent_builders::GetEventStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetEventStream::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetEventStream::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetEventStreamOutput`](crate::output::GetEventStreamOutput) with field(s):
    ///   - [`event_stream(Option<EventStream>)`](crate::output::GetEventStreamOutput::event_stream): <p>Specifies settings for publishing event data to an Amazon Kinesis data stream or an Amazon Kinesis Data Firehose delivery stream.</p>
    /// - On failure, responds with [`SdkError<GetEventStreamError>`](crate::error::GetEventStreamError)
    pub fn get_event_stream(&self) -> fluent_builders::GetEventStream<C, M, R> {
        fluent_builders::GetEventStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExportJob`](crate::client::fluent_builders::GetExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetExportJob::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetExportJob::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetExportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetExportJob::set_job_id): <p>The unique identifier for the job.</p>
    /// - On success, responds with [`GetExportJobOutput`](crate::output::GetExportJobOutput) with field(s):
    ///   - [`export_job_response(Option<ExportJobResponse>)`](crate::output::GetExportJobOutput::export_job_response): <p>Provides information about the status and settings of a job that exports endpoint definitions to a file. The file can be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded directly to a computer by using the Amazon Pinpoint console.</p>
    /// - On failure, responds with [`SdkError<GetExportJobError>`](crate::error::GetExportJobError)
    pub fn get_export_job(&self) -> fluent_builders::GetExportJob<C, M, R> {
        fluent_builders::GetExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExportJobs`](crate::client::fluent_builders::GetExportJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetExportJobs::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetExportJobs::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetExportJobs::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetExportJobs::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetExportJobs::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetExportJobs::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetExportJobsOutput`](crate::output::GetExportJobsOutput) with field(s):
    ///   - [`export_jobs_response(Option<ExportJobsResponse>)`](crate::output::GetExportJobsOutput::export_jobs_response): <p>Provides information about all the export jobs that are associated with an application or segment. An export job is a job that exports endpoint definitions to a file.</p>
    /// - On failure, responds with [`SdkError<GetExportJobsError>`](crate::error::GetExportJobsError)
    pub fn get_export_jobs(&self) -> fluent_builders::GetExportJobs<C, M, R> {
        fluent_builders::GetExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGcmChannel`](crate::client::fluent_builders::GetGcmChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetGcmChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetGcmChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetGcmChannelOutput`](crate::output::GetGcmChannelOutput) with field(s):
    ///   - [`gcm_channel_response(Option<GcmChannelResponse>)`](crate::output::GetGcmChannelOutput::gcm_channel_response): <p>Provides information about the status and settings of the GCM channel for an application. The GCM channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
    /// - On failure, responds with [`SdkError<GetGcmChannelError>`](crate::error::GetGcmChannelError)
    pub fn get_gcm_channel(&self) -> fluent_builders::GetGcmChannel<C, M, R> {
        fluent_builders::GetGcmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImportJob`](crate::client::fluent_builders::GetImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetImportJob::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetImportJob::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetImportJob::set_job_id): <p>The unique identifier for the job.</p>
    /// - On success, responds with [`GetImportJobOutput`](crate::output::GetImportJobOutput) with field(s):
    ///   - [`import_job_response(Option<ImportJobResponse>)`](crate::output::GetImportJobOutput::import_job_response): <p>Provides information about the status and settings of a job that imports endpoint definitions from one or more files. The files can be stored in an Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer by using the Amazon Pinpoint console.</p>
    /// - On failure, responds with [`SdkError<GetImportJobError>`](crate::error::GetImportJobError)
    pub fn get_import_job(&self) -> fluent_builders::GetImportJob<C, M, R> {
        fluent_builders::GetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImportJobs`](crate::client::fluent_builders::GetImportJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetImportJobs::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetImportJobs::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetImportJobs::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetImportJobs::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetImportJobs::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetImportJobs::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetImportJobsOutput`](crate::output::GetImportJobsOutput) with field(s):
    ///   - [`import_jobs_response(Option<ImportJobsResponse>)`](crate::output::GetImportJobsOutput::import_jobs_response): <p>Provides information about the status and settings of all the import jobs that are associated with an application or segment. An import job is a job that imports endpoint definitions from one or more files.</p>
    /// - On failure, responds with [`SdkError<GetImportJobsError>`](crate::error::GetImportJobsError)
    pub fn get_import_jobs(&self) -> fluent_builders::GetImportJobs<C, M, R> {
        fluent_builders::GetImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInAppMessages`](crate::client::fluent_builders::GetInAppMessages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetInAppMessages::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetInAppMessages::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::GetInAppMessages::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::GetInAppMessages::set_endpoint_id): <p>The unique identifier for the endpoint.</p>
    /// - On success, responds with [`GetInAppMessagesOutput`](crate::output::GetInAppMessagesOutput) with field(s):
    ///   - [`in_app_messages_response(Option<InAppMessagesResponse>)`](crate::output::GetInAppMessagesOutput::in_app_messages_response): <p>Get in-app messages response object.</p>
    /// - On failure, responds with [`SdkError<GetInAppMessagesError>`](crate::error::GetInAppMessagesError)
    pub fn get_in_app_messages(&self) -> fluent_builders::GetInAppMessages<C, M, R> {
        fluent_builders::GetInAppMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInAppTemplate`](crate::client::fluent_builders::GetInAppTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetInAppTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetInAppTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetInAppTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetInAppTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`GetInAppTemplateOutput`](crate::output::GetInAppTemplateOutput) with field(s):
    ///   - [`in_app_template_response(Option<InAppTemplateResponse>)`](crate::output::GetInAppTemplateOutput::in_app_template_response): <p>In-App Template Response.</p>
    /// - On failure, responds with [`SdkError<GetInAppTemplateError>`](crate::error::GetInAppTemplateError)
    pub fn get_in_app_template(&self) -> fluent_builders::GetInAppTemplate<C, M, R> {
        fluent_builders::GetInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJourney`](crate::client::fluent_builders::GetJourney) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetJourney::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetJourney::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::GetJourney::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::GetJourney::set_journey_id): <p>The unique identifier for the journey.</p>
    /// - On success, responds with [`GetJourneyOutput`](crate::output::GetJourneyOutput) with field(s):
    ///   - [`journey_response(Option<JourneyResponse>)`](crate::output::GetJourneyOutput::journey_response): <p>Provides information about the status, configuration, and other settings for a journey.</p>
    /// - On failure, responds with [`SdkError<GetJourneyError>`](crate::error::GetJourneyError)
    pub fn get_journey(&self) -> fluent_builders::GetJourney<C, M, R> {
        fluent_builders::GetJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJourneyDateRangeKpi`](crate::client::fluent_builders::GetJourneyDateRangeKpi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_end_time): <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_journey_id): <p>The unique identifier for the journey.</p>
    ///   - [`kpi_name(impl Into<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::kpi_name) / [`set_kpi_name(Option<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_kpi_name): <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetJourneyDateRangeKpi::set_start_time): <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
    /// - On success, responds with [`GetJourneyDateRangeKpiOutput`](crate::output::GetJourneyDateRangeKpiOutput) with field(s):
    ///   - [`journey_date_range_kpi_response(Option<JourneyDateRangeKpiResponse>)`](crate::output::GetJourneyDateRangeKpiOutput::journey_date_range_kpi_response): <p>Provides the results of a query that retrieved the data for a standard engagement metric that applies to a journey, and provides information about that query.</p>
    /// - On failure, responds with [`SdkError<GetJourneyDateRangeKpiError>`](crate::error::GetJourneyDateRangeKpiError)
    pub fn get_journey_date_range_kpi(&self) -> fluent_builders::GetJourneyDateRangeKpi<C, M, R> {
        fluent_builders::GetJourneyDateRangeKpi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJourneyExecutionActivityMetrics`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`journey_activity_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::journey_activity_id) / [`set_journey_activity_id(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::set_journey_activity_id): <p>The unique identifier for the journey activity.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::set_journey_id): <p>The unique identifier for the journey.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    /// - On success, responds with [`GetJourneyExecutionActivityMetricsOutput`](crate::output::GetJourneyExecutionActivityMetricsOutput) with field(s):
    ///   - [`journey_execution_activity_metrics_response(Option<JourneyExecutionActivityMetricsResponse>)`](crate::output::GetJourneyExecutionActivityMetricsOutput::journey_execution_activity_metrics_response): <p>Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey activity, and provides information about that query.</p>
    /// - On failure, responds with [`SdkError<GetJourneyExecutionActivityMetricsError>`](crate::error::GetJourneyExecutionActivityMetricsError)
    pub fn get_journey_execution_activity_metrics(
        &self,
    ) -> fluent_builders::GetJourneyExecutionActivityMetrics<C, M, R> {
        fluent_builders::GetJourneyExecutionActivityMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJourneyExecutionMetrics`](crate::client::fluent_builders::GetJourneyExecutionMetrics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::set_journey_id): <p>The unique identifier for the journey.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetJourneyExecutionMetrics::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    /// - On success, responds with [`GetJourneyExecutionMetricsOutput`](crate::output::GetJourneyExecutionMetricsOutput) with field(s):
    ///   - [`journey_execution_metrics_response(Option<JourneyExecutionMetricsResponse>)`](crate::output::GetJourneyExecutionMetricsOutput::journey_execution_metrics_response): <p>Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey, and provides information about that query.</p>
    /// - On failure, responds with [`SdkError<GetJourneyExecutionMetricsError>`](crate::error::GetJourneyExecutionMetricsError)
    pub fn get_journey_execution_metrics(
        &self,
    ) -> fluent_builders::GetJourneyExecutionMetrics<C, M, R> {
        fluent_builders::GetJourneyExecutionMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPushTemplate`](crate::client::fluent_builders::GetPushTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetPushTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetPushTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetPushTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetPushTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`GetPushTemplateOutput`](crate::output::GetPushTemplateOutput) with field(s):
    ///   - [`push_notification_template_response(Option<PushNotificationTemplateResponse>)`](crate::output::GetPushTemplateOutput::push_notification_template_response): <p>Provides information about the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
    /// - On failure, responds with [`SdkError<GetPushTemplateError>`](crate::error::GetPushTemplateError)
    pub fn get_push_template(&self) -> fluent_builders::GetPushTemplate<C, M, R> {
        fluent_builders::GetPushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecommenderConfiguration`](crate::client::fluent_builders::GetRecommenderConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recommender_id(impl Into<String>)`](crate::client::fluent_builders::GetRecommenderConfiguration::recommender_id) / [`set_recommender_id(Option<String>)`](crate::client::fluent_builders::GetRecommenderConfiguration::set_recommender_id): <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetRecommenderConfigurationOutput`](crate::output::GetRecommenderConfigurationOutput) with field(s):
    ///   - [`recommender_configuration_response(Option<RecommenderConfigurationResponse>)`](crate::output::GetRecommenderConfigurationOutput::recommender_configuration_response): <p>Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.</p>
    /// - On failure, responds with [`SdkError<GetRecommenderConfigurationError>`](crate::error::GetRecommenderConfigurationError)
    pub fn get_recommender_configuration(
        &self,
    ) -> fluent_builders::GetRecommenderConfiguration<C, M, R> {
        fluent_builders::GetRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecommenderConfigurations`](crate::client::fluent_builders::GetRecommenderConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetRecommenderConfigurations::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetRecommenderConfigurations::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetRecommenderConfigurations::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetRecommenderConfigurations::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetRecommenderConfigurationsOutput`](crate::output::GetRecommenderConfigurationsOutput) with field(s):
    ///   - [`list_recommender_configurations_response(Option<ListRecommenderConfigurationsResponse>)`](crate::output::GetRecommenderConfigurationsOutput::list_recommender_configurations_response): <p>Provides information about all the recommender model configurations that are associated with your Amazon Pinpoint account.</p>
    /// - On failure, responds with [`SdkError<GetRecommenderConfigurationsError>`](crate::error::GetRecommenderConfigurationsError)
    pub fn get_recommender_configurations(
        &self,
    ) -> fluent_builders::GetRecommenderConfigurations<C, M, R> {
        fluent_builders::GetRecommenderConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegment`](crate::client::fluent_builders::GetSegment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSegment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSegment::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::GetSegment::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::GetSegment::set_segment_id): <p>The unique identifier for the segment.</p>
    /// - On success, responds with [`GetSegmentOutput`](crate::output::GetSegmentOutput) with field(s):
    ///   - [`segment_response(Option<SegmentResponse>)`](crate::output::GetSegmentOutput::segment_response): <p>Provides information about the configuration, dimension, and other settings for a segment.</p>
    /// - On failure, responds with [`SdkError<GetSegmentError>`](crate::error::GetSegmentError)
    pub fn get_segment(&self) -> fluent_builders::GetSegment<C, M, R> {
        fluent_builders::GetSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegmentExportJobs`](crate::client::fluent_builders::GetSegmentExportJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::set_segment_id): <p>The unique identifier for the segment.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetSegmentExportJobs::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetSegmentExportJobsOutput`](crate::output::GetSegmentExportJobsOutput) with field(s):
    ///   - [`export_jobs_response(Option<ExportJobsResponse>)`](crate::output::GetSegmentExportJobsOutput::export_jobs_response): <p>Provides information about all the export jobs that are associated with an application or segment. An export job is a job that exports endpoint definitions to a file.</p>
    /// - On failure, responds with [`SdkError<GetSegmentExportJobsError>`](crate::error::GetSegmentExportJobsError)
    pub fn get_segment_export_jobs(&self) -> fluent_builders::GetSegmentExportJobs<C, M, R> {
        fluent_builders::GetSegmentExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegmentImportJobs`](crate::client::fluent_builders::GetSegmentImportJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::set_segment_id): <p>The unique identifier for the segment.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetSegmentImportJobs::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetSegmentImportJobsOutput`](crate::output::GetSegmentImportJobsOutput) with field(s):
    ///   - [`import_jobs_response(Option<ImportJobsResponse>)`](crate::output::GetSegmentImportJobsOutput::import_jobs_response): <p>Provides information about the status and settings of all the import jobs that are associated with an application or segment. An import job is a job that imports endpoint definitions from one or more files.</p>
    /// - On failure, responds with [`SdkError<GetSegmentImportJobsError>`](crate::error::GetSegmentImportJobsError)
    pub fn get_segment_import_jobs(&self) -> fluent_builders::GetSegmentImportJobs<C, M, R> {
        fluent_builders::GetSegmentImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegments`](crate::client::fluent_builders::GetSegments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSegments::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSegments::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetSegments::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetSegments::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetSegments::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetSegments::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetSegmentsOutput`](crate::output::GetSegmentsOutput) with field(s):
    ///   - [`segments_response(Option<SegmentsResponse>)`](crate::output::GetSegmentsOutput::segments_response): <p>Provides information about all the segments that are associated with an application.</p>
    /// - On failure, responds with [`SdkError<GetSegmentsError>`](crate::error::GetSegmentsError)
    pub fn get_segments(&self) -> fluent_builders::GetSegments<C, M, R> {
        fluent_builders::GetSegments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegmentVersion`](crate::client::fluent_builders::GetSegmentVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersion::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSegmentVersion::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersion::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::GetSegmentVersion::set_segment_id): <p>The unique identifier for the segment.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetSegmentVersion::set_version): <p>The unique version number (Version property) for the campaign version.</p>
    /// - On success, responds with [`GetSegmentVersionOutput`](crate::output::GetSegmentVersionOutput) with field(s):
    ///   - [`segment_response(Option<SegmentResponse>)`](crate::output::GetSegmentVersionOutput::segment_response): <p>Provides information about the configuration, dimension, and other settings for a segment.</p>
    /// - On failure, responds with [`SdkError<GetSegmentVersionError>`](crate::error::GetSegmentVersionError)
    pub fn get_segment_version(&self) -> fluent_builders::GetSegmentVersion<C, M, R> {
        fluent_builders::GetSegmentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegmentVersions`](crate::client::fluent_builders::GetSegmentVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersions::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSegmentVersions::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersions::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::GetSegmentVersions::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersions::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::GetSegmentVersions::set_segment_id): <p>The unique identifier for the segment.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetSegmentVersions::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetSegmentVersions::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`GetSegmentVersionsOutput`](crate::output::GetSegmentVersionsOutput) with field(s):
    ///   - [`segments_response(Option<SegmentsResponse>)`](crate::output::GetSegmentVersionsOutput::segments_response): <p>Provides information about all the segments that are associated with an application.</p>
    /// - On failure, responds with [`SdkError<GetSegmentVersionsError>`](crate::error::GetSegmentVersionsError)
    pub fn get_segment_versions(&self) -> fluent_builders::GetSegmentVersions<C, M, R> {
        fluent_builders::GetSegmentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSmsChannel`](crate::client::fluent_builders::GetSmsChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetSmsChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetSmsChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetSmsChannelOutput`](crate::output::GetSmsChannelOutput) with field(s):
    ///   - [`sms_channel_response(Option<SmsChannelResponse>)`](crate::output::GetSmsChannelOutput::sms_channel_response): <p>Provides information about the status and settings of the SMS channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetSmsChannelError>`](crate::error::GetSmsChannelError)
    pub fn get_sms_channel(&self) -> fluent_builders::GetSmsChannel<C, M, R> {
        fluent_builders::GetSmsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSmsTemplate`](crate::client::fluent_builders::GetSmsTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetSmsTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetSmsTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetSmsTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetSmsTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`GetSmsTemplateOutput`](crate::output::GetSmsTemplateOutput) with field(s):
    ///   - [`sms_template_response(Option<SmsTemplateResponse>)`](crate::output::GetSmsTemplateOutput::sms_template_response): <p>Provides information about the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
    /// - On failure, responds with [`SdkError<GetSmsTemplateError>`](crate::error::GetSmsTemplateError)
    pub fn get_sms_template(&self) -> fluent_builders::GetSmsTemplate<C, M, R> {
        fluent_builders::GetSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUserEndpoints`](crate::client::fluent_builders::GetUserEndpoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetUserEndpoints::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetUserEndpoints::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetUserEndpoints::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetUserEndpoints::set_user_id): <p>The unique identifier for the user.</p>
    /// - On success, responds with [`GetUserEndpointsOutput`](crate::output::GetUserEndpointsOutput) with field(s):
    ///   - [`endpoints_response(Option<EndpointsResponse>)`](crate::output::GetUserEndpointsOutput::endpoints_response): <p>Provides information about all the endpoints that are associated with a user ID.</p>
    /// - On failure, responds with [`SdkError<GetUserEndpointsError>`](crate::error::GetUserEndpointsError)
    pub fn get_user_endpoints(&self) -> fluent_builders::GetUserEndpoints<C, M, R> {
        fluent_builders::GetUserEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceChannel`](crate::client::fluent_builders::GetVoiceChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetVoiceChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`GetVoiceChannelOutput`](crate::output::GetVoiceChannelOutput) with field(s):
    ///   - [`voice_channel_response(Option<VoiceChannelResponse>)`](crate::output::GetVoiceChannelOutput::voice_channel_response): <p>Provides information about the status and settings of the voice channel for an application.</p>
    /// - On failure, responds with [`SdkError<GetVoiceChannelError>`](crate::error::GetVoiceChannelError)
    pub fn get_voice_channel(&self) -> fluent_builders::GetVoiceChannel<C, M, R> {
        fluent_builders::GetVoiceChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceTemplate`](crate::client::fluent_builders::GetVoiceTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetVoiceTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetVoiceTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetVoiceTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetVoiceTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`GetVoiceTemplateOutput`](crate::output::GetVoiceTemplateOutput) with field(s):
    ///   - [`voice_template_response(Option<VoiceTemplateResponse>)`](crate::output::GetVoiceTemplateOutput::voice_template_response): <p>Provides information about the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
    /// - On failure, responds with [`SdkError<GetVoiceTemplateError>`](crate::error::GetVoiceTemplateError)
    pub fn get_voice_template(&self) -> fluent_builders::GetVoiceTemplate<C, M, R> {
        fluent_builders::GetVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJourneys`](crate::client::fluent_builders::ListJourneys) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListJourneys::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListJourneys::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::ListJourneys::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::ListJourneys::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::ListJourneys::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::ListJourneys::set_token): <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`ListJourneysOutput`](crate::output::ListJourneysOutput) with field(s):
    ///   - [`journeys_response(Option<JourneysResponse>)`](crate::output::ListJourneysOutput::journeys_response): <p>Provides information about the status, configuration, and other settings for all the journeys that are associated with an application.</p>
    /// - On failure, responds with [`SdkError<ListJourneysError>`](crate::error::ListJourneysError)
    pub fn list_journeys(&self) -> fluent_builders::ListJourneys<C, M, R> {
        fluent_builders::ListJourneys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags_model(Option<TagsModel>)`](crate::output::ListTagsForResourceOutput::tags_model): <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTemplates`](crate::client::fluent_builders::ListTemplates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_prefix): <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
    ///   - [`template_type(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::template_type) / [`set_template_type(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_template_type): <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
    /// - On success, responds with [`ListTemplatesOutput`](crate::output::ListTemplatesOutput) with field(s):
    ///   - [`templates_response(Option<TemplatesResponse>)`](crate::output::ListTemplatesOutput::templates_response): <p>Provides information about all the message templates that are associated with your Amazon Pinpoint account.</p>
    /// - On failure, responds with [`SdkError<ListTemplatesError>`](crate::error::ListTemplatesError)
    pub fn list_templates(&self) -> fluent_builders::ListTemplates<C, M, R> {
        fluent_builders::ListTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTemplateVersions`](crate::client::fluent_builders::ListTemplateVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_next_token): <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`page_size(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::page_size) / [`set_page_size(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_page_size): <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`template_type(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::template_type) / [`set_template_type(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_template_type): <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
    /// - On success, responds with [`ListTemplateVersionsOutput`](crate::output::ListTemplateVersionsOutput) with field(s):
    ///   - [`template_versions_response(Option<TemplateVersionsResponse>)`](crate::output::ListTemplateVersionsOutput::template_versions_response): <p>Provides information about all the versions of a specific message template.</p>
    /// - On failure, responds with [`SdkError<ListTemplateVersionsError>`](crate::error::ListTemplateVersionsError)
    pub fn list_template_versions(&self) -> fluent_builders::ListTemplateVersions<C, M, R> {
        fluent_builders::ListTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PhoneNumberValidate`](crate::client::fluent_builders::PhoneNumberValidate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`number_validate_request(NumberValidateRequest)`](crate::client::fluent_builders::PhoneNumberValidate::number_validate_request) / [`set_number_validate_request(Option<NumberValidateRequest>)`](crate::client::fluent_builders::PhoneNumberValidate::set_number_validate_request): <p>Specifies a phone number to validate and retrieve information about.</p>
    /// - On success, responds with [`PhoneNumberValidateOutput`](crate::output::PhoneNumberValidateOutput) with field(s):
    ///   - [`number_validate_response(Option<NumberValidateResponse>)`](crate::output::PhoneNumberValidateOutput::number_validate_response): <p>Provides information about a phone number.</p>
    /// - On failure, responds with [`SdkError<PhoneNumberValidateError>`](crate::error::PhoneNumberValidateError)
    pub fn phone_number_validate(&self) -> fluent_builders::PhoneNumberValidate<C, M, R> {
        fluent_builders::PhoneNumberValidate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEvents`](crate::client::fluent_builders::PutEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::PutEvents::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::PutEvents::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`events_request(EventsRequest)`](crate::client::fluent_builders::PutEvents::events_request) / [`set_events_request(Option<EventsRequest>)`](crate::client::fluent_builders::PutEvents::set_events_request): <p>Specifies a batch of events to process.</p>
    /// - On success, responds with [`PutEventsOutput`](crate::output::PutEventsOutput) with field(s):
    ///   - [`events_response(Option<EventsResponse>)`](crate::output::PutEventsOutput::events_response): <p>Provides information about endpoints and the events that they're associated with.</p>
    /// - On failure, responds with [`SdkError<PutEventsError>`](crate::error::PutEventsError)
    pub fn put_events(&self) -> fluent_builders::PutEvents<C, M, R> {
        fluent_builders::PutEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEventStream`](crate::client::fluent_builders::PutEventStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::PutEventStream::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::PutEventStream::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`write_event_stream(WriteEventStream)`](crate::client::fluent_builders::PutEventStream::write_event_stream) / [`set_write_event_stream(Option<WriteEventStream>)`](crate::client::fluent_builders::PutEventStream::set_write_event_stream): <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
    /// - On success, responds with [`PutEventStreamOutput`](crate::output::PutEventStreamOutput) with field(s):
    ///   - [`event_stream(Option<EventStream>)`](crate::output::PutEventStreamOutput::event_stream): <p>Specifies settings for publishing event data to an Amazon Kinesis data stream or an Amazon Kinesis Data Firehose delivery stream.</p>
    /// - On failure, responds with [`SdkError<PutEventStreamError>`](crate::error::PutEventStreamError)
    pub fn put_event_stream(&self) -> fluent_builders::PutEventStream<C, M, R> {
        fluent_builders::PutEventStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveAttributes`](crate::client::fluent_builders::RemoveAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::RemoveAttributes::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::RemoveAttributes::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`attribute_type(impl Into<String>)`](crate::client::fluent_builders::RemoveAttributes::attribute_type) / [`set_attribute_type(Option<String>)`](crate::client::fluent_builders::RemoveAttributes::set_attribute_type): <p>The type of attribute or attributes to remove. Valid values are:</p>  <ul>  <li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li>   <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li>   <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li> </ul>
    ///   - [`update_attributes_request(UpdateAttributesRequest)`](crate::client::fluent_builders::RemoveAttributes::update_attributes_request) / [`set_update_attributes_request(Option<UpdateAttributesRequest>)`](crate::client::fluent_builders::RemoveAttributes::set_update_attributes_request): <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
    /// - On success, responds with [`RemoveAttributesOutput`](crate::output::RemoveAttributesOutput) with field(s):
    ///   - [`attributes_resource(Option<AttributesResource>)`](crate::output::RemoveAttributesOutput::attributes_resource): <p>Provides information about the type and the names of attributes that were removed from all the endpoints that are associated with an application.</p>
    /// - On failure, responds with [`SdkError<RemoveAttributesError>`](crate::error::RemoveAttributesError)
    pub fn remove_attributes(&self) -> fluent_builders::RemoveAttributes<C, M, R> {
        fluent_builders::RemoveAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendMessages`](crate::client::fluent_builders::SendMessages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::SendMessages::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::SendMessages::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`message_request(MessageRequest)`](crate::client::fluent_builders::SendMessages::message_request) / [`set_message_request(Option<MessageRequest>)`](crate::client::fluent_builders::SendMessages::set_message_request): <p>Specifies the configuration and other settings for a message.</p>
    /// - On success, responds with [`SendMessagesOutput`](crate::output::SendMessagesOutput) with field(s):
    ///   - [`message_response(Option<MessageResponse>)`](crate::output::SendMessagesOutput::message_response): <p>Provides information about the results of a request to send a message to an endpoint address.</p>
    /// - On failure, responds with [`SdkError<SendMessagesError>`](crate::error::SendMessagesError)
    pub fn send_messages(&self) -> fluent_builders::SendMessages<C, M, R> {
        fluent_builders::SendMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendOTPMessage`](crate::client::fluent_builders::SendOTPMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::SendOTPMessage::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::SendOTPMessage::set_application_id): <p>The unique ID of your Amazon Pinpoint application.</p>
    ///   - [`send_otp_message_request_parameters(SendOtpMessageRequestParameters)`](crate::client::fluent_builders::SendOTPMessage::send_otp_message_request_parameters) / [`set_send_otp_message_request_parameters(Option<SendOtpMessageRequestParameters>)`](crate::client::fluent_builders::SendOTPMessage::set_send_otp_message_request_parameters): <p>Send OTP message request parameters.</p>
    /// - On success, responds with [`SendOtpMessageOutput`](crate::output::SendOtpMessageOutput) with field(s):
    ///   - [`message_response(Option<MessageResponse>)`](crate::output::SendOtpMessageOutput::message_response): <p>Provides information about the results of a request to send a message to an endpoint address.</p>
    /// - On failure, responds with [`SdkError<SendOTPMessageError>`](crate::error::SendOTPMessageError)
    pub fn send_otp_message(&self) -> fluent_builders::SendOTPMessage<C, M, R> {
        fluent_builders::SendOTPMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendUsersMessages`](crate::client::fluent_builders::SendUsersMessages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::SendUsersMessages::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::SendUsersMessages::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`send_users_message_request(SendUsersMessageRequest)`](crate::client::fluent_builders::SendUsersMessages::send_users_message_request) / [`set_send_users_message_request(Option<SendUsersMessageRequest>)`](crate::client::fluent_builders::SendUsersMessages::set_send_users_message_request): <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
    /// - On success, responds with [`SendUsersMessagesOutput`](crate::output::SendUsersMessagesOutput) with field(s):
    ///   - [`send_users_message_response(Option<SendUsersMessageResponse>)`](crate::output::SendUsersMessagesOutput::send_users_message_response): <p>Provides information about which users and endpoints a message was sent to.</p>
    /// - On failure, responds with [`SdkError<SendUsersMessagesError>`](crate::error::SendUsersMessagesError)
    pub fn send_users_messages(&self) -> fluent_builders::SendUsersMessages<C, M, R> {
        fluent_builders::SendUsersMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags_model(TagsModel)`](crate::client::fluent_builders::TagResource::tags_model) / [`set_tags_model(Option<TagsModel>)`](crate::client::fluent_builders::TagResource::set_tags_model): <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAdmChannel`](crate::client::fluent_builders::UpdateAdmChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`adm_channel_request(AdmChannelRequest)`](crate::client::fluent_builders::UpdateAdmChannel::adm_channel_request) / [`set_adm_channel_request(Option<AdmChannelRequest>)`](crate::client::fluent_builders::UpdateAdmChannel::set_adm_channel_request): <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAdmChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateAdmChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`UpdateAdmChannelOutput`](crate::output::UpdateAdmChannelOutput) with field(s):
    ///   - [`adm_channel_response(Option<AdmChannelResponse>)`](crate::output::UpdateAdmChannelOutput::adm_channel_response): <p>Provides information about the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateAdmChannelError>`](crate::error::UpdateAdmChannelError)
    pub fn update_adm_channel(&self) -> fluent_builders::UpdateAdmChannel<C, M, R> {
        fluent_builders::UpdateAdmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApnsChannel`](crate::client::fluent_builders::UpdateApnsChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`apns_channel_request(ApnsChannelRequest)`](crate::client::fluent_builders::UpdateApnsChannel::apns_channel_request) / [`set_apns_channel_request(Option<ApnsChannelRequest>)`](crate::client::fluent_builders::UpdateApnsChannel::set_apns_channel_request): <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApnsChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApnsChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`UpdateApnsChannelOutput`](crate::output::UpdateApnsChannelOutput) with field(s):
    ///   - [`apns_channel_response(Option<ApnsChannelResponse>)`](crate::output::UpdateApnsChannelOutput::apns_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateApnsChannelError>`](crate::error::UpdateApnsChannelError)
    pub fn update_apns_channel(&self) -> fluent_builders::UpdateApnsChannel<C, M, R> {
        fluent_builders::UpdateApnsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApnsSandboxChannel`](crate::client::fluent_builders::UpdateApnsSandboxChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`apns_sandbox_channel_request(ApnsSandboxChannelRequest)`](crate::client::fluent_builders::UpdateApnsSandboxChannel::apns_sandbox_channel_request) / [`set_apns_sandbox_channel_request(Option<ApnsSandboxChannelRequest>)`](crate::client::fluent_builders::UpdateApnsSandboxChannel::set_apns_sandbox_channel_request): <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApnsSandboxChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApnsSandboxChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`UpdateApnsSandboxChannelOutput`](crate::output::UpdateApnsSandboxChannelOutput) with field(s):
    ///   - [`apns_sandbox_channel_response(Option<ApnsSandboxChannelResponse>)`](crate::output::UpdateApnsSandboxChannelOutput::apns_sandbox_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateApnsSandboxChannelError>`](crate::error::UpdateApnsSandboxChannelError)
    pub fn update_apns_sandbox_channel(
        &self,
    ) -> fluent_builders::UpdateApnsSandboxChannel<C, M, R> {
        fluent_builders::UpdateApnsSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApnsVoipChannel`](crate::client::fluent_builders::UpdateApnsVoipChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`apns_voip_channel_request(ApnsVoipChannelRequest)`](crate::client::fluent_builders::UpdateApnsVoipChannel::apns_voip_channel_request) / [`set_apns_voip_channel_request(Option<ApnsVoipChannelRequest>)`](crate::client::fluent_builders::UpdateApnsVoipChannel::set_apns_voip_channel_request): <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApnsVoipChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApnsVoipChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`UpdateApnsVoipChannelOutput`](crate::output::UpdateApnsVoipChannelOutput) with field(s):
    ///   - [`apns_voip_channel_response(Option<ApnsVoipChannelResponse>)`](crate::output::UpdateApnsVoipChannelOutput::apns_voip_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateApnsVoipChannelError>`](crate::error::UpdateApnsVoipChannelError)
    pub fn update_apns_voip_channel(&self) -> fluent_builders::UpdateApnsVoipChannel<C, M, R> {
        fluent_builders::UpdateApnsVoipChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApnsVoipSandboxChannel`](crate::client::fluent_builders::UpdateApnsVoipSandboxChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`apns_voip_sandbox_channel_request(ApnsVoipSandboxChannelRequest)`](crate::client::fluent_builders::UpdateApnsVoipSandboxChannel::apns_voip_sandbox_channel_request) / [`set_apns_voip_sandbox_channel_request(Option<ApnsVoipSandboxChannelRequest>)`](crate::client::fluent_builders::UpdateApnsVoipSandboxChannel::set_apns_voip_sandbox_channel_request): <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApnsVoipSandboxChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApnsVoipSandboxChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    /// - On success, responds with [`UpdateApnsVoipSandboxChannelOutput`](crate::output::UpdateApnsVoipSandboxChannelOutput) with field(s):
    ///   - [`apns_voip_sandbox_channel_response(Option<ApnsVoipSandboxChannelResponse>)`](crate::output::UpdateApnsVoipSandboxChannelOutput::apns_voip_sandbox_channel_response): <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateApnsVoipSandboxChannelError>`](crate::error::UpdateApnsVoipSandboxChannelError)
    pub fn update_apns_voip_sandbox_channel(
        &self,
    ) -> fluent_builders::UpdateApnsVoipSandboxChannel<C, M, R> {
        fluent_builders::UpdateApnsVoipSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplicationSettings`](crate::client::fluent_builders::UpdateApplicationSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationSettings::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApplicationSettings::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`write_application_settings_request(WriteApplicationSettingsRequest)`](crate::client::fluent_builders::UpdateApplicationSettings::write_application_settings_request) / [`set_write_application_settings_request(Option<WriteApplicationSettingsRequest>)`](crate::client::fluent_builders::UpdateApplicationSettings::set_write_application_settings_request): <p>Specifies the default settings for an application.</p>
    /// - On success, responds with [`UpdateApplicationSettingsOutput`](crate::output::UpdateApplicationSettingsOutput) with field(s):
    ///   - [`application_settings_resource(Option<ApplicationSettingsResource>)`](crate::output::UpdateApplicationSettingsOutput::application_settings_resource): <p>Provides information about an application, including the default settings for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateApplicationSettingsError>`](crate::error::UpdateApplicationSettingsError)
    pub fn update_application_settings(
        &self,
    ) -> fluent_builders::UpdateApplicationSettings<C, M, R> {
        fluent_builders::UpdateApplicationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBaiduChannel`](crate::client::fluent_builders::UpdateBaiduChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBaiduChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateBaiduChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`baidu_channel_request(BaiduChannelRequest)`](crate::client::fluent_builders::UpdateBaiduChannel::baidu_channel_request) / [`set_baidu_channel_request(Option<BaiduChannelRequest>)`](crate::client::fluent_builders::UpdateBaiduChannel::set_baidu_channel_request): <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
    /// - On success, responds with [`UpdateBaiduChannelOutput`](crate::output::UpdateBaiduChannelOutput) with field(s):
    ///   - [`baidu_channel_response(Option<BaiduChannelResponse>)`](crate::output::UpdateBaiduChannelOutput::baidu_channel_response): <p>Provides information about the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateBaiduChannelError>`](crate::error::UpdateBaiduChannelError)
    pub fn update_baidu_channel(&self) -> fluent_builders::UpdateBaiduChannel<C, M, R> {
        fluent_builders::UpdateBaiduChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCampaign`](crate::client::fluent_builders::UpdateCampaign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCampaign::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateCampaign::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCampaign::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::UpdateCampaign::set_campaign_id): <p>The unique identifier for the campaign.</p>
    ///   - [`write_campaign_request(WriteCampaignRequest)`](crate::client::fluent_builders::UpdateCampaign::write_campaign_request) / [`set_write_campaign_request(Option<WriteCampaignRequest>)`](crate::client::fluent_builders::UpdateCampaign::set_write_campaign_request): <p>Specifies the configuration and other settings for a campaign.</p>
    /// - On success, responds with [`UpdateCampaignOutput`](crate::output::UpdateCampaignOutput) with field(s):
    ///   - [`campaign_response(Option<CampaignResponse>)`](crate::output::UpdateCampaignOutput::campaign_response): <p>Provides information about the status, configuration, and other settings for a campaign.</p>
    /// - On failure, responds with [`SdkError<UpdateCampaignError>`](crate::error::UpdateCampaignError)
    pub fn update_campaign(&self) -> fluent_builders::UpdateCampaign<C, M, R> {
        fluent_builders::UpdateCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEmailChannel`](crate::client::fluent_builders::UpdateEmailChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateEmailChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`email_channel_request(EmailChannelRequest)`](crate::client::fluent_builders::UpdateEmailChannel::email_channel_request) / [`set_email_channel_request(Option<EmailChannelRequest>)`](crate::client::fluent_builders::UpdateEmailChannel::set_email_channel_request): <p>Specifies the status and settings of the email channel for an application.</p>
    /// - On success, responds with [`UpdateEmailChannelOutput`](crate::output::UpdateEmailChannelOutput) with field(s):
    ///   - [`email_channel_response(Option<EmailChannelResponse>)`](crate::output::UpdateEmailChannelOutput::email_channel_response): <p>Provides information about the status and settings of the email channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateEmailChannelError>`](crate::error::UpdateEmailChannelError)
    pub fn update_email_channel(&self) -> fluent_builders::UpdateEmailChannel<C, M, R> {
        fluent_builders::UpdateEmailChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEmailTemplate`](crate::client::fluent_builders::UpdateEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_new_version(bool)`](crate::client::fluent_builders::UpdateEmailTemplate::create_new_version) / [`set_create_new_version(bool)`](crate::client::fluent_builders::UpdateEmailTemplate::set_create_new_version): <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    ///   - [`email_template_request(EmailTemplateRequest)`](crate::client::fluent_builders::UpdateEmailTemplate::email_template_request) / [`set_email_template_request(Option<EmailTemplateRequest>)`](crate::client::fluent_builders::UpdateEmailTemplate::set_email_template_request): <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateEmailTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateEmailTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`UpdateEmailTemplateOutput`](crate::output::UpdateEmailTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateEmailTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateEmailTemplateError>`](crate::error::UpdateEmailTemplateError)
    pub fn update_email_template(&self) -> fluent_builders::UpdateEmailTemplate<C, M, R> {
        fluent_builders::UpdateEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEndpoint`](crate::client::fluent_builders::UpdateEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpoint::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateEndpoint::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpoint::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::UpdateEndpoint::set_endpoint_id): <p>The unique identifier for the endpoint.</p>
    ///   - [`endpoint_request(EndpointRequest)`](crate::client::fluent_builders::UpdateEndpoint::endpoint_request) / [`set_endpoint_request(Option<EndpointRequest>)`](crate::client::fluent_builders::UpdateEndpoint::set_endpoint_request): <p>Specifies the channel type and other settings for an endpoint.</p>
    /// - On success, responds with [`UpdateEndpointOutput`](crate::output::UpdateEndpointOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateEndpointOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateEndpointError>`](crate::error::UpdateEndpointError)
    pub fn update_endpoint(&self) -> fluent_builders::UpdateEndpoint<C, M, R> {
        fluent_builders::UpdateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEndpointsBatch`](crate::client::fluent_builders::UpdateEndpointsBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpointsBatch::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateEndpointsBatch::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`endpoint_batch_request(EndpointBatchRequest)`](crate::client::fluent_builders::UpdateEndpointsBatch::endpoint_batch_request) / [`set_endpoint_batch_request(Option<EndpointBatchRequest>)`](crate::client::fluent_builders::UpdateEndpointsBatch::set_endpoint_batch_request): <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
    /// - On success, responds with [`UpdateEndpointsBatchOutput`](crate::output::UpdateEndpointsBatchOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateEndpointsBatchOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateEndpointsBatchError>`](crate::error::UpdateEndpointsBatchError)
    pub fn update_endpoints_batch(&self) -> fluent_builders::UpdateEndpointsBatch<C, M, R> {
        fluent_builders::UpdateEndpointsBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGcmChannel`](crate::client::fluent_builders::UpdateGcmChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGcmChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateGcmChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`gcm_channel_request(GcmChannelRequest)`](crate::client::fluent_builders::UpdateGcmChannel::gcm_channel_request) / [`set_gcm_channel_request(Option<GcmChannelRequest>)`](crate::client::fluent_builders::UpdateGcmChannel::set_gcm_channel_request): <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
    /// - On success, responds with [`UpdateGcmChannelOutput`](crate::output::UpdateGcmChannelOutput) with field(s):
    ///   - [`gcm_channel_response(Option<GcmChannelResponse>)`](crate::output::UpdateGcmChannelOutput::gcm_channel_response): <p>Provides information about the status and settings of the GCM channel for an application. The GCM channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
    /// - On failure, responds with [`SdkError<UpdateGcmChannelError>`](crate::error::UpdateGcmChannelError)
    pub fn update_gcm_channel(&self) -> fluent_builders::UpdateGcmChannel<C, M, R> {
        fluent_builders::UpdateGcmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInAppTemplate`](crate::client::fluent_builders::UpdateInAppTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_new_version(bool)`](crate::client::fluent_builders::UpdateInAppTemplate::create_new_version) / [`set_create_new_version(bool)`](crate::client::fluent_builders::UpdateInAppTemplate::set_create_new_version): <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    ///   - [`in_app_template_request(InAppTemplateRequest)`](crate::client::fluent_builders::UpdateInAppTemplate::in_app_template_request) / [`set_in_app_template_request(Option<InAppTemplateRequest>)`](crate::client::fluent_builders::UpdateInAppTemplate::set_in_app_template_request): <p>InApp Template Request.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateInAppTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateInAppTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateInAppTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateInAppTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`UpdateInAppTemplateOutput`](crate::output::UpdateInAppTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateInAppTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateInAppTemplateError>`](crate::error::UpdateInAppTemplateError)
    pub fn update_in_app_template(&self) -> fluent_builders::UpdateInAppTemplate<C, M, R> {
        fluent_builders::UpdateInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJourney`](crate::client::fluent_builders::UpdateJourney) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJourney::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateJourney::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJourney::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::UpdateJourney::set_journey_id): <p>The unique identifier for the journey.</p>
    ///   - [`write_journey_request(WriteJourneyRequest)`](crate::client::fluent_builders::UpdateJourney::write_journey_request) / [`set_write_journey_request(Option<WriteJourneyRequest>)`](crate::client::fluent_builders::UpdateJourney::set_write_journey_request): <p>Specifies the configuration and other settings for a journey.</p>
    /// - On success, responds with [`UpdateJourneyOutput`](crate::output::UpdateJourneyOutput) with field(s):
    ///   - [`journey_response(Option<JourneyResponse>)`](crate::output::UpdateJourneyOutput::journey_response): <p>Provides information about the status, configuration, and other settings for a journey.</p>
    /// - On failure, responds with [`SdkError<UpdateJourneyError>`](crate::error::UpdateJourneyError)
    pub fn update_journey(&self) -> fluent_builders::UpdateJourney<C, M, R> {
        fluent_builders::UpdateJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJourneyState`](crate::client::fluent_builders::UpdateJourneyState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJourneyState::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateJourneyState::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`journey_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJourneyState::journey_id) / [`set_journey_id(Option<String>)`](crate::client::fluent_builders::UpdateJourneyState::set_journey_id): <p>The unique identifier for the journey.</p>
    ///   - [`journey_state_request(JourneyStateRequest)`](crate::client::fluent_builders::UpdateJourneyState::journey_state_request) / [`set_journey_state_request(Option<JourneyStateRequest>)`](crate::client::fluent_builders::UpdateJourneyState::set_journey_state_request): <p>Changes the status of a journey.</p>
    /// - On success, responds with [`UpdateJourneyStateOutput`](crate::output::UpdateJourneyStateOutput) with field(s):
    ///   - [`journey_response(Option<JourneyResponse>)`](crate::output::UpdateJourneyStateOutput::journey_response): <p>Provides information about the status, configuration, and other settings for a journey.</p>
    /// - On failure, responds with [`SdkError<UpdateJourneyStateError>`](crate::error::UpdateJourneyStateError)
    pub fn update_journey_state(&self) -> fluent_builders::UpdateJourneyState<C, M, R> {
        fluent_builders::UpdateJourneyState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePushTemplate`](crate::client::fluent_builders::UpdatePushTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_new_version(bool)`](crate::client::fluent_builders::UpdatePushTemplate::create_new_version) / [`set_create_new_version(bool)`](crate::client::fluent_builders::UpdatePushTemplate::set_create_new_version): <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    ///   - [`push_notification_template_request(PushNotificationTemplateRequest)`](crate::client::fluent_builders::UpdatePushTemplate::push_notification_template_request) / [`set_push_notification_template_request(Option<PushNotificationTemplateRequest>)`](crate::client::fluent_builders::UpdatePushTemplate::set_push_notification_template_request): <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePushTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdatePushTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdatePushTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdatePushTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`UpdatePushTemplateOutput`](crate::output::UpdatePushTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdatePushTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdatePushTemplateError>`](crate::error::UpdatePushTemplateError)
    pub fn update_push_template(&self) -> fluent_builders::UpdatePushTemplate<C, M, R> {
        fluent_builders::UpdatePushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRecommenderConfiguration`](crate::client::fluent_builders::UpdateRecommenderConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recommender_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRecommenderConfiguration::recommender_id) / [`set_recommender_id(Option<String>)`](crate::client::fluent_builders::UpdateRecommenderConfiguration::set_recommender_id): <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`update_recommender_configuration(UpdateRecommenderConfigurationShape)`](crate::client::fluent_builders::UpdateRecommenderConfiguration::update_recommender_configuration) / [`set_update_recommender_configuration(Option<UpdateRecommenderConfigurationShape>)`](crate::client::fluent_builders::UpdateRecommenderConfiguration::set_update_recommender_configuration): <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
    /// - On success, responds with [`UpdateRecommenderConfigurationOutput`](crate::output::UpdateRecommenderConfigurationOutput) with field(s):
    ///   - [`recommender_configuration_response(Option<RecommenderConfigurationResponse>)`](crate::output::UpdateRecommenderConfigurationOutput::recommender_configuration_response): <p>Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.</p>
    /// - On failure, responds with [`SdkError<UpdateRecommenderConfigurationError>`](crate::error::UpdateRecommenderConfigurationError)
    pub fn update_recommender_configuration(
        &self,
    ) -> fluent_builders::UpdateRecommenderConfiguration<C, M, R> {
        fluent_builders::UpdateRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSegment`](crate::client::fluent_builders::UpdateSegment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSegment::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateSegment::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`segment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSegment::segment_id) / [`set_segment_id(Option<String>)`](crate::client::fluent_builders::UpdateSegment::set_segment_id): <p>The unique identifier for the segment.</p>
    ///   - [`write_segment_request(WriteSegmentRequest)`](crate::client::fluent_builders::UpdateSegment::write_segment_request) / [`set_write_segment_request(Option<WriteSegmentRequest>)`](crate::client::fluent_builders::UpdateSegment::set_write_segment_request): <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
    /// - On success, responds with [`UpdateSegmentOutput`](crate::output::UpdateSegmentOutput) with field(s):
    ///   - [`segment_response(Option<SegmentResponse>)`](crate::output::UpdateSegmentOutput::segment_response): <p>Provides information about the configuration, dimension, and other settings for a segment.</p>
    /// - On failure, responds with [`SdkError<UpdateSegmentError>`](crate::error::UpdateSegmentError)
    pub fn update_segment(&self) -> fluent_builders::UpdateSegment<C, M, R> {
        fluent_builders::UpdateSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSmsChannel`](crate::client::fluent_builders::UpdateSmsChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSmsChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateSmsChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`sms_channel_request(SmsChannelRequest)`](crate::client::fluent_builders::UpdateSmsChannel::sms_channel_request) / [`set_sms_channel_request(Option<SmsChannelRequest>)`](crate::client::fluent_builders::UpdateSmsChannel::set_sms_channel_request): <p>Specifies the status and settings of the SMS channel for an application.</p>
    /// - On success, responds with [`UpdateSmsChannelOutput`](crate::output::UpdateSmsChannelOutput) with field(s):
    ///   - [`sms_channel_response(Option<SmsChannelResponse>)`](crate::output::UpdateSmsChannelOutput::sms_channel_response): <p>Provides information about the status and settings of the SMS channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateSmsChannelError>`](crate::error::UpdateSmsChannelError)
    pub fn update_sms_channel(&self) -> fluent_builders::UpdateSmsChannel<C, M, R> {
        fluent_builders::UpdateSmsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSmsTemplate`](crate::client::fluent_builders::UpdateSmsTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_new_version(bool)`](crate::client::fluent_builders::UpdateSmsTemplate::create_new_version) / [`set_create_new_version(bool)`](crate::client::fluent_builders::UpdateSmsTemplate::set_create_new_version): <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    ///   - [`sms_template_request(SmsTemplateRequest)`](crate::client::fluent_builders::UpdateSmsTemplate::sms_template_request) / [`set_sms_template_request(Option<SmsTemplateRequest>)`](crate::client::fluent_builders::UpdateSmsTemplate::set_sms_template_request): <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSmsTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateSmsTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateSmsTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateSmsTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    /// - On success, responds with [`UpdateSmsTemplateOutput`](crate::output::UpdateSmsTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateSmsTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateSmsTemplateError>`](crate::error::UpdateSmsTemplateError)
    pub fn update_sms_template(&self) -> fluent_builders::UpdateSmsTemplate<C, M, R> {
        fluent_builders::UpdateSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTemplateActiveVersion`](crate::client::fluent_builders::UpdateTemplateActiveVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_active_version_request(TemplateActiveVersionRequest)`](crate::client::fluent_builders::UpdateTemplateActiveVersion::template_active_version_request) / [`set_template_active_version_request(Option<TemplateActiveVersionRequest>)`](crate::client::fluent_builders::UpdateTemplateActiveVersion::set_template_active_version_request): <p>Specifies which version of a message template to use as the active version of the template.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplateActiveVersion::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateTemplateActiveVersion::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`template_type(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplateActiveVersion::template_type) / [`set_template_type(Option<String>)`](crate::client::fluent_builders::UpdateTemplateActiveVersion::set_template_type): <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
    /// - On success, responds with [`UpdateTemplateActiveVersionOutput`](crate::output::UpdateTemplateActiveVersionOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateTemplateActiveVersionOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateTemplateActiveVersionError>`](crate::error::UpdateTemplateActiveVersionError)
    pub fn update_template_active_version(
        &self,
    ) -> fluent_builders::UpdateTemplateActiveVersion<C, M, R> {
        fluent_builders::UpdateTemplateActiveVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVoiceChannel`](crate::client::fluent_builders::UpdateVoiceChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceChannel::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateVoiceChannel::set_application_id): <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    ///   - [`voice_channel_request(VoiceChannelRequest)`](crate::client::fluent_builders::UpdateVoiceChannel::voice_channel_request) / [`set_voice_channel_request(Option<VoiceChannelRequest>)`](crate::client::fluent_builders::UpdateVoiceChannel::set_voice_channel_request): <p>Specifies the status and settings of the voice channel for an application.</p>
    /// - On success, responds with [`UpdateVoiceChannelOutput`](crate::output::UpdateVoiceChannelOutput) with field(s):
    ///   - [`voice_channel_response(Option<VoiceChannelResponse>)`](crate::output::UpdateVoiceChannelOutput::voice_channel_response): <p>Provides information about the status and settings of the voice channel for an application.</p>
    /// - On failure, responds with [`SdkError<UpdateVoiceChannelError>`](crate::error::UpdateVoiceChannelError)
    pub fn update_voice_channel(&self) -> fluent_builders::UpdateVoiceChannel<C, M, R> {
        fluent_builders::UpdateVoiceChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVoiceTemplate`](crate::client::fluent_builders::UpdateVoiceTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_new_version(bool)`](crate::client::fluent_builders::UpdateVoiceTemplate::create_new_version) / [`set_create_new_version(bool)`](crate::client::fluent_builders::UpdateVoiceTemplate::set_create_new_version): <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateVoiceTemplate::set_template_name): <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceTemplate::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateVoiceTemplate::set_version): <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the   <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>  <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>  <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>  <ul>  <li><p>For a get operation, retrieves information about the active version of the template.</p></li>   <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>   <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li> </ul>
    ///   - [`voice_template_request(VoiceTemplateRequest)`](crate::client::fluent_builders::UpdateVoiceTemplate::voice_template_request) / [`set_voice_template_request(Option<VoiceTemplateRequest>)`](crate::client::fluent_builders::UpdateVoiceTemplate::set_voice_template_request): <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
    /// - On success, responds with [`UpdateVoiceTemplateOutput`](crate::output::UpdateVoiceTemplateOutput) with field(s):
    ///   - [`message_body(Option<MessageBody>)`](crate::output::UpdateVoiceTemplateOutput::message_body): <p>Provides information about an API request or response.</p>
    /// - On failure, responds with [`SdkError<UpdateVoiceTemplateError>`](crate::error::UpdateVoiceTemplateError)
    pub fn update_voice_template(&self) -> fluent_builders::UpdateVoiceTemplate<C, M, R> {
        fluent_builders::UpdateVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyOTPMessage`](crate::client::fluent_builders::VerifyOTPMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::VerifyOTPMessage::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::VerifyOTPMessage::set_application_id): <p>The unique ID of your Amazon Pinpoint application.</p>
    ///   - [`verify_otp_message_request_parameters(VerifyOtpMessageRequestParameters)`](crate::client::fluent_builders::VerifyOTPMessage::verify_otp_message_request_parameters) / [`set_verify_otp_message_request_parameters(Option<VerifyOtpMessageRequestParameters>)`](crate::client::fluent_builders::VerifyOTPMessage::set_verify_otp_message_request_parameters): <p>Verify OTP message request.</p>
    /// - On success, responds with [`VerifyOtpMessageOutput`](crate::output::VerifyOtpMessageOutput) with field(s):
    ///   - [`verification_response(Option<VerificationResponse>)`](crate::output::VerifyOtpMessageOutput::verification_response): <p>Verify OTP Message Response.</p>
    /// - On failure, responds with [`SdkError<VerifyOTPMessageError>`](crate::error::VerifyOTPMessageError)
    pub fn verify_otp_message(&self) -> fluent_builders::VerifyOTPMessage<C, M, R> {
        fluent_builders::VerifyOTPMessage::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p>Creates an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_input::Builder,
    }
    impl<C, M, R> CreateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInputOperationOutputAlias,
                crate::output::CreateAppOutput,
                crate::error::CreateAppError,
                crate::input::CreateAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the display name of an application and the tags to associate with the application.</p>
        pub fn create_application_request(
            mut self,
            input: crate::model::CreateApplicationRequest,
        ) -> Self {
            self.inner = self.inner.create_application_request(input);
            self
        }
        /// <p>Specifies the display name of an application and the tags to associate with the application.</p>
        pub fn set_create_application_request(
            mut self,
            input: std::option::Option<crate::model::CreateApplicationRequest>,
        ) -> Self {
            self.inner = self.inner.set_create_application_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCampaign`.
    ///
    /// <p>Creates a new campaign for an application or updates the settings of an existing campaign for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_campaign_input::Builder,
    }
    impl<C, M, R> CreateCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCampaignInputOperationOutputAlias,
                crate::output::CreateCampaignOutput,
                crate::error::CreateCampaignError,
                crate::input::CreateCampaignInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn write_campaign_request(mut self, input: crate::model::WriteCampaignRequest) -> Self {
            self.inner = self.inner.write_campaign_request(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn set_write_campaign_request(
            mut self,
            input: std::option::Option<crate::model::WriteCampaignRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_campaign_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through the email channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_email_template_input::Builder,
    }
    impl<C, M, R> CreateEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEmailTemplateInputOperationOutputAlias,
                crate::output::CreateEmailTemplateOutput,
                crate::error::CreateEmailTemplateError,
                crate::input::CreateEmailTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn email_template_request(mut self, input: crate::model::EmailTemplateRequest) -> Self {
            self.inner = self.inner.email_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn set_email_template_request(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_email_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExportJob`.
    ///
    /// <p>Creates an export job for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_export_job_input::Builder,
    }
    impl<C, M, R> CreateExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateExportJobInputOperationOutputAlias,
                crate::output::CreateExportJobOutput,
                crate::error::CreateExportJobError,
                crate::input::CreateExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn export_job_request(mut self, input: crate::model::ExportJobRequest) -> Self {
            self.inner = self.inner.export_job_request(input);
            self
        }
        /// <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_export_job_request(
            mut self,
            input: std::option::Option<crate::model::ExportJobRequest>,
        ) -> Self {
            self.inner = self.inner.set_export_job_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImportJob`.
    ///
    /// <p>Creates an import job for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_import_job_input::Builder,
    }
    impl<C, M, R> CreateImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImportJobInputOperationOutputAlias,
                crate::output::CreateImportJobOutput,
                crate::error::CreateImportJobError,
                crate::input::CreateImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn import_job_request(mut self, input: crate::model::ImportJobRequest) -> Self {
            self.inner = self.inner.import_job_request(input);
            self
        }
        /// <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_import_job_request(
            mut self,
            input: std::option::Option<crate::model::ImportJobRequest>,
        ) -> Self {
            self.inner = self.inner.set_import_job_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInAppTemplate`.
    ///
    /// <p>Creates a new message template for messages using the in-app message channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_in_app_template_input::Builder,
    }
    impl<C, M, R> CreateInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInAppTemplateInputOperationOutputAlias,
                crate::output::CreateInAppTemplateOutput,
                crate::error::CreateInAppTemplateError,
                crate::input::CreateInAppTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>InApp Template Request.</p>
        pub fn in_app_template_request(
            mut self,
            input: crate::model::InAppTemplateRequest,
        ) -> Self {
            self.inner = self.inner.in_app_template_request(input);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn set_in_app_template_request(
            mut self,
            input: std::option::Option<crate::model::InAppTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_in_app_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJourney`.
    ///
    /// <p>Creates a journey for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_journey_input::Builder,
    }
    impl<C, M, R> CreateJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJourneyInputOperationOutputAlias,
                crate::output::CreateJourneyOutput,
                crate::error::CreateJourneyError,
                crate::input::CreateJourneyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn write_journey_request(mut self, input: crate::model::WriteJourneyRequest) -> Self {
            self.inner = self.inner.write_journey_request(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn set_write_journey_request(
            mut self,
            input: std::option::Option<crate::model::WriteJourneyRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_journey_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePushTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through a push notification channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_push_template_input::Builder,
    }
    impl<C, M, R> CreatePushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePushTemplateInputOperationOutputAlias,
                crate::output::CreatePushTemplateOutput,
                crate::error::CreatePushTemplateError,
                crate::input::CreatePushTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn push_notification_template_request(
            mut self,
            input: crate::model::PushNotificationTemplateRequest,
        ) -> Self {
            self.inner = self.inner.push_notification_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn set_push_notification_template_request(
            mut self,
            input: std::option::Option<crate::model::PushNotificationTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_push_notification_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecommenderConfiguration`.
    ///
    /// <p>Creates an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recommender_configuration_input::Builder,
    }
    impl<C, M, R> CreateRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecommenderConfigurationInputOperationOutputAlias,
                crate::output::CreateRecommenderConfigurationOutput,
                crate::error::CreateRecommenderConfigurationError,
                crate::input::CreateRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn create_recommender_configuration(
            mut self,
            input: crate::model::CreateRecommenderConfigurationShape,
        ) -> Self {
            self.inner = self.inner.create_recommender_configuration(input);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn set_create_recommender_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateRecommenderConfigurationShape>,
        ) -> Self {
            self.inner = self.inner.set_create_recommender_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSegment`.
    ///
    /// <p>Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_segment_input::Builder,
    }
    impl<C, M, R> CreateSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSegmentInputOperationOutputAlias,
                crate::output::CreateSegmentOutput,
                crate::error::CreateSegmentError,
                crate::input::CreateSegmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn write_segment_request(mut self, input: crate::model::WriteSegmentRequest) -> Self {
            self.inner = self.inner.write_segment_request(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn set_write_segment_request(
            mut self,
            input: std::option::Option<crate::model::WriteSegmentRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_segment_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSmsTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through the SMS channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sms_template_input::Builder,
    }
    impl<C, M, R> CreateSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSmsTemplateInputOperationOutputAlias,
                crate::output::CreateSmsTemplateOutput,
                crate::error::CreateSmsTemplateError,
                crate::input::CreateSmsTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn sms_template_request(mut self, input: crate::model::SmsTemplateRequest) -> Self {
            self.inner = self.inner.sms_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn set_sms_template_request(
            mut self,
            input: std::option::Option<crate::model::SmsTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_sms_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVoiceTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through the voice channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_voice_template_input::Builder,
    }
    impl<C, M, R> CreateVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVoiceTemplateInputOperationOutputAlias,
                crate::output::CreateVoiceTemplateOutput,
                crate::error::CreateVoiceTemplateError,
                crate::input::CreateVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn voice_template_request(mut self, input: crate::model::VoiceTemplateRequest) -> Self {
            self.inner = self.inner.voice_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn set_voice_template_request(
            mut self,
            input: std::option::Option<crate::model::VoiceTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_voice_template_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAdmChannel`.
    ///
    /// <p>Disables the ADM channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAdmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_adm_channel_input::Builder,
    }
    impl<C, M, R> DeleteAdmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAdmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAdmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAdmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAdmChannelInputOperationOutputAlias,
                crate::output::DeleteAdmChannelOutput,
                crate::error::DeleteAdmChannelError,
                crate::input::DeleteAdmChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsChannel`.
    ///
    /// <p>Disables the APNs channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApnsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsChannelInputOperationOutputAlias,
                crate::output::DeleteApnsChannelOutput,
                crate::error::DeleteApnsChannelError,
                crate::input::DeleteApnsChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsSandboxChannel`.
    ///
    /// <p>Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApnsSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_sandbox_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsSandboxChannelInputOperationOutputAlias,
                crate::output::DeleteApnsSandboxChannelOutput,
                crate::error::DeleteApnsSandboxChannelError,
                crate::input::DeleteApnsSandboxChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsVoipChannel`.
    ///
    /// <p>Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApnsVoipChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_voip_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsVoipChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsVoipChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsVoipChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsVoipChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsVoipChannelInputOperationOutputAlias,
                crate::output::DeleteApnsVoipChannelOutput,
                crate::error::DeleteApnsVoipChannelError,
                crate::input::DeleteApnsVoipChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsVoipSandboxChannel`.
    ///
    /// <p>Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApnsVoipSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_voip_sandbox_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsVoipSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsVoipSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsVoipSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsVoipSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsVoipSandboxChannelInputOperationOutputAlias,
                crate::output::DeleteApnsVoipSandboxChannelOutput,
                crate::error::DeleteApnsVoipSandboxChannelError,
                crate::input::DeleteApnsVoipSandboxChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p>Deletes an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl<C, M, R> DeleteApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInputOperationOutputAlias,
                crate::output::DeleteAppOutput,
                crate::error::DeleteAppError,
                crate::input::DeleteAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBaiduChannel`.
    ///
    /// <p>Disables the Baidu channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBaiduChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_baidu_channel_input::Builder,
    }
    impl<C, M, R> DeleteBaiduChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBaiduChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBaiduChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBaiduChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBaiduChannelInputOperationOutputAlias,
                crate::output::DeleteBaiduChannelOutput,
                crate::error::DeleteBaiduChannelError,
                crate::input::DeleteBaiduChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCampaign`.
    ///
    /// <p>Deletes a campaign from an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_campaign_input::Builder,
    }
    impl<C, M, R> DeleteCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCampaignInputOperationOutputAlias,
                crate::output::DeleteCampaignOutput,
                crate::error::DeleteCampaignError,
                crate::input::DeleteCampaignInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailChannel`.
    ///
    /// <p>Disables the email channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_channel_input::Builder,
    }
    impl<C, M, R> DeleteEmailChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailChannelInputOperationOutputAlias,
                crate::output::DeleteEmailChannelOutput,
                crate::error::DeleteEmailChannelError,
                crate::input::DeleteEmailChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through the email channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_template_input::Builder,
    }
    impl<C, M, R> DeleteEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailTemplateInputOperationOutputAlias,
                crate::output::DeleteEmailTemplateOutput,
                crate::error::DeleteEmailTemplateError,
                crate::input::DeleteEmailTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes an endpoint from an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointInputOperationOutputAlias,
                crate::output::DeleteEndpointOutput,
                crate::error::DeleteEndpointError,
                crate::input::DeleteEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventStream`.
    ///
    /// <p>Deletes the event stream for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_stream_input::Builder,
    }
    impl<C, M, R> DeleteEventStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventStreamInputOperationOutputAlias,
                crate::output::DeleteEventStreamOutput,
                crate::error::DeleteEventStreamError,
                crate::input::DeleteEventStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGcmChannel`.
    ///
    /// <p>Disables the GCM channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGcmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gcm_channel_input::Builder,
    }
    impl<C, M, R> DeleteGcmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGcmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGcmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGcmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGcmChannelInputOperationOutputAlias,
                crate::output::DeleteGcmChannelOutput,
                crate::error::DeleteGcmChannelError,
                crate::input::DeleteGcmChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInAppTemplate`.
    ///
    /// <p>Deletes a message template for messages sent using the in-app message channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_in_app_template_input::Builder,
    }
    impl<C, M, R> DeleteInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInAppTemplateInputOperationOutputAlias,
                crate::output::DeleteInAppTemplateOutput,
                crate::error::DeleteInAppTemplateError,
                crate::input::DeleteInAppTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJourney`.
    ///
    /// <p>Deletes a journey from an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_journey_input::Builder,
    }
    impl<C, M, R> DeleteJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJourneyInputOperationOutputAlias,
                crate::output::DeleteJourneyOutput,
                crate::error::DeleteJourneyError,
                crate::input::DeleteJourneyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePushTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through a push notification channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_push_template_input::Builder,
    }
    impl<C, M, R> DeletePushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePushTemplateInputOperationOutputAlias,
                crate::output::DeletePushTemplateOutput,
                crate::error::DeletePushTemplateError,
                crate::input::DeletePushTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecommenderConfiguration`.
    ///
    /// <p>Deletes an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recommender_configuration_input::Builder,
    }
    impl<C, M, R> DeleteRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecommenderConfigurationInputOperationOutputAlias,
                crate::output::DeleteRecommenderConfigurationOutput,
                crate::error::DeleteRecommenderConfigurationError,
                crate::input::DeleteRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_id(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSegment`.
    ///
    /// <p>Deletes a segment from an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_segment_input::Builder,
    }
    impl<C, M, R> DeleteSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSegmentInputOperationOutputAlias,
                crate::output::DeleteSegmentOutput,
                crate::error::DeleteSegmentError,
                crate::input::DeleteSegmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSmsChannel`.
    ///
    /// <p>Disables the SMS channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSmsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sms_channel_input::Builder,
    }
    impl<C, M, R> DeleteSmsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSmsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSmsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSmsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSmsChannelInputOperationOutputAlias,
                crate::output::DeleteSmsChannelOutput,
                crate::error::DeleteSmsChannelError,
                crate::input::DeleteSmsChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSmsTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through the SMS channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sms_template_input::Builder,
    }
    impl<C, M, R> DeleteSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSmsTemplateInputOperationOutputAlias,
                crate::output::DeleteSmsTemplateOutput,
                crate::error::DeleteSmsTemplateError,
                crate::input::DeleteSmsTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserEndpoints`.
    ///
    /// <p>Deletes all the endpoints that are associated with a specific user ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_endpoints_input::Builder,
    }
    impl<C, M, R> DeleteUserEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserEndpointsInputOperationOutputAlias,
                crate::output::DeleteUserEndpointsOutput,
                crate::error::DeleteUserEndpointsError,
                crate::input::DeleteUserEndpointsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceChannel`.
    ///
    /// <p>Disables the voice channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_channel_input::Builder,
    }
    impl<C, M, R> DeleteVoiceChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceChannelInputOperationOutputAlias,
                crate::output::DeleteVoiceChannelOutput,
                crate::error::DeleteVoiceChannelError,
                crate::input::DeleteVoiceChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through the voice channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_template_input::Builder,
    }
    impl<C, M, R> DeleteVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceTemplateInputOperationOutputAlias,
                crate::output::DeleteVoiceTemplateOutput,
                crate::error::DeleteVoiceTemplateError,
                crate::input::DeleteVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAdmChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the ADM channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAdmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_adm_channel_input::Builder,
    }
    impl<C, M, R> GetAdmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAdmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAdmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAdmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAdmChannelInputOperationOutputAlias,
                crate::output::GetAdmChannelOutput,
                crate::error::GetAdmChannelError,
                crate::input::GetAdmChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApnsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_channel_input::Builder,
    }
    impl<C, M, R> GetApnsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsChannelInputOperationOutputAlias,
                crate::output::GetApnsChannelOutput,
                crate::error::GetApnsChannelError,
                crate::input::GetApnsChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsSandboxChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs sandbox channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApnsSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_sandbox_channel_input::Builder,
    }
    impl<C, M, R> GetApnsSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsSandboxChannelInputOperationOutputAlias,
                crate::output::GetApnsSandboxChannelOutput,
                crate::error::GetApnsSandboxChannelError,
                crate::input::GetApnsSandboxChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsVoipChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs VoIP channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApnsVoipChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_voip_channel_input::Builder,
    }
    impl<C, M, R> GetApnsVoipChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsVoipChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsVoipChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsVoipChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsVoipChannelInputOperationOutputAlias,
                crate::output::GetApnsVoipChannelOutput,
                crate::error::GetApnsVoipChannelError,
                crate::input::GetApnsVoipChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsVoipSandboxChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApnsVoipSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_voip_sandbox_channel_input::Builder,
    }
    impl<C, M, R> GetApnsVoipSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsVoipSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsVoipSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsVoipSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsVoipSandboxChannelInputOperationOutputAlias,
                crate::output::GetApnsVoipSandboxChannelOutput,
                crate::error::GetApnsVoipSandboxChannelError,
                crate::input::GetApnsVoipSandboxChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApp`.
    ///
    /// <p>Retrieves information about an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_input::Builder,
    }
    impl<C, M, R> GetApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInputOperationOutputAlias,
                crate::output::GetAppOutput,
                crate::error::GetAppError,
                crate::input::GetAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationDateRangeKpi`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplicationDateRangeKpi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_date_range_kpi_input::Builder,
    }
    impl<C, M, R> GetApplicationDateRangeKpi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationDateRangeKpi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationDateRangeKpiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationDateRangeKpiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationDateRangeKpiInputOperationOutputAlias,
                crate::output::GetApplicationDateRangeKpiOutput,
                crate::error::GetApplicationDateRangeKpiError,
                crate::input::GetApplicationDateRangeKpiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kpi_name(input.into());
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kpi_name(input);
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationSettings`.
    ///
    /// <p>Retrieves information about the settings for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplicationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_settings_input::Builder,
    }
    impl<C, M, R> GetApplicationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationSettingsInputOperationOutputAlias,
                crate::output::GetApplicationSettingsOutput,
                crate::error::GetApplicationSettingsError,
                crate::input::GetApplicationSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApps`.
    ///
    /// <p>Retrieves information about all the applications that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApps<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apps_input::Builder,
    }
    impl<C, M, R> GetApps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppsInputOperationOutputAlias,
                crate::output::GetAppsOutput,
                crate::error::GetAppsError,
                crate::input::GetAppsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBaiduChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the Baidu channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBaiduChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_baidu_channel_input::Builder,
    }
    impl<C, M, R> GetBaiduChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBaiduChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBaiduChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBaiduChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBaiduChannelInputOperationOutputAlias,
                crate::output::GetBaiduChannelOutput,
                crate::error::GetBaiduChannelError,
                crate::input::GetBaiduChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaign`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for a campaign.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_input::Builder,
    }
    impl<C, M, R> GetCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignInputOperationOutputAlias,
                crate::output::GetCampaignOutput,
                crate::error::GetCampaignError,
                crate::input::GetCampaignInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignActivities`.
    ///
    /// <p>Retrieves information about all the activities for a campaign.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCampaignActivities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_activities_input::Builder,
    }
    impl<C, M, R> GetCampaignActivities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignActivities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignActivitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignActivitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignActivitiesInputOperationOutputAlias,
                crate::output::GetCampaignActivitiesOutput,
                crate::error::GetCampaignActivitiesError,
                crate::input::GetCampaignActivitiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignDateRangeKpi`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCampaignDateRangeKpi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_date_range_kpi_input::Builder,
    }
    impl<C, M, R> GetCampaignDateRangeKpi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignDateRangeKpi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignDateRangeKpiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignDateRangeKpiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignDateRangeKpiInputOperationOutputAlias,
                crate::output::GetCampaignDateRangeKpiOutput,
                crate::error::GetCampaignDateRangeKpiError,
                crate::input::GetCampaignDateRangeKpiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kpi_name(input.into());
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kpi_name(input);
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaigns`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCampaigns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaigns_input::Builder,
    }
    impl<C, M, R> GetCampaigns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaigns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignsInputOperationOutputAlias,
                crate::output::GetCampaignsOutput,
                crate::error::GetCampaignsError,
                crate::input::GetCampaignsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignVersion`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for a specific version of a campaign.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCampaignVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_version_input::Builder,
    }
    impl<C, M, R> GetCampaignVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignVersionInputOperationOutputAlias,
                crate::output::GetCampaignVersionOutput,
                crate::error::GetCampaignVersionError,
                crate::input::GetCampaignVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignVersions`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for all versions of a campaign.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCampaignVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_versions_input::Builder,
    }
    impl<C, M, R> GetCampaignVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignVersionsInputOperationOutputAlias,
                crate::output::GetCampaignVersionsOutput,
                crate::error::GetCampaignVersionsError,
                crate::input::GetCampaignVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannels`.
    ///
    /// <p>Retrieves information about the history and status of each channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channels_input::Builder,
    }
    impl<C, M, R> GetChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelsInputOperationOutputAlias,
                crate::output::GetChannelsOutput,
                crate::error::GetChannelsError,
                crate::input::GetChannelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the email channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEmailChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_channel_input::Builder,
    }
    impl<C, M, R> GetEmailChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailChannelInputOperationOutputAlias,
                crate::output::GetEmailChannelOutput,
                crate::error::GetEmailChannelError,
                crate::input::GetEmailChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through the email channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_template_input::Builder,
    }
    impl<C, M, R> GetEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailTemplateInputOperationOutputAlias,
                crate::output::GetEmailTemplateOutput,
                crate::error::GetEmailTemplateError,
                crate::input::GetEmailTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEndpoint`.
    ///
    /// <p>Retrieves information about the settings and attributes of a specific endpoint for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_endpoint_input::Builder,
    }
    impl<C, M, R> GetEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEndpointInputOperationOutputAlias,
                crate::output::GetEndpointOutput,
                crate::error::GetEndpointError,
                crate::input::GetEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventStream`.
    ///
    /// <p>Retrieves information about the event stream settings for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_stream_input::Builder,
    }
    impl<C, M, R> GetEventStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventStreamInputOperationOutputAlias,
                crate::output::GetEventStreamOutput,
                crate::error::GetEventStreamError,
                crate::input::GetEventStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExportJob`.
    ///
    /// <p>Retrieves information about the status and settings of a specific export job for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_job_input::Builder,
    }
    impl<C, M, R> GetExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportJobInputOperationOutputAlias,
                crate::output::GetExportJobOutput,
                crate::error::GetExportJobError,
                crate::input::GetExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of all the export jobs for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_jobs_input::Builder,
    }
    impl<C, M, R> GetExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportJobsInputOperationOutputAlias,
                crate::output::GetExportJobsOutput,
                crate::error::GetExportJobsError,
                crate::input::GetExportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGcmChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the GCM channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGcmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gcm_channel_input::Builder,
    }
    impl<C, M, R> GetGcmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGcmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGcmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGcmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGcmChannelInputOperationOutputAlias,
                crate::output::GetGcmChannelOutput,
                crate::error::GetGcmChannelError,
                crate::input::GetGcmChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportJob`.
    ///
    /// <p>Retrieves information about the status and settings of a specific import job for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_job_input::Builder,
    }
    impl<C, M, R> GetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportJobInputOperationOutputAlias,
                crate::output::GetImportJobOutput,
                crate::error::GetImportJobError,
                crate::input::GetImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of all the import jobs for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_jobs_input::Builder,
    }
    impl<C, M, R> GetImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportJobsInputOperationOutputAlias,
                crate::output::GetImportJobsOutput,
                crate::error::GetImportJobsError,
                crate::input::GetImportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInAppMessages`.
    ///
    /// <p>Retrieves the in-app messages targeted for the provided endpoint ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInAppMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_in_app_messages_input::Builder,
    }
    impl<C, M, R> GetInAppMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInAppMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInAppMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInAppMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInAppMessagesInputOperationOutputAlias,
                crate::output::GetInAppMessagesOutput,
                crate::error::GetInAppMessagesError,
                crate::input::GetInAppMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInAppTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages sent through the in-app channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_in_app_template_input::Builder,
    }
    impl<C, M, R> GetInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInAppTemplateInputOperationOutputAlias,
                crate::output::GetInAppTemplateOutput,
                crate::error::GetInAppTemplateError,
                crate::input::GetInAppTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourney`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for a journey.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_input::Builder,
    }
    impl<C, M, R> GetJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyInputOperationOutputAlias,
                crate::output::GetJourneyOutput,
                crate::error::GetJourneyError,
                crate::input::GetJourneyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourneyDateRangeKpi`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJourneyDateRangeKpi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_date_range_kpi_input::Builder,
    }
    impl<C, M, R> GetJourneyDateRangeKpi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourneyDateRangeKpi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyDateRangeKpiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJourneyDateRangeKpiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyDateRangeKpiInputOperationOutputAlias,
                crate::output::GetJourneyDateRangeKpiOutput,
                crate::error::GetJourneyDateRangeKpiError,
                crate::input::GetJourneyDateRangeKpiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kpi_name(input.into());
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kpi_name(input);
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourneyExecutionActivityMetrics`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJourneyExecutionActivityMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_execution_activity_metrics_input::Builder,
    }
    impl<C, M, R> GetJourneyExecutionActivityMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourneyExecutionActivityMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyExecutionActivityMetricsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetJourneyExecutionActivityMetricsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyExecutionActivityMetricsInputOperationOutputAlias,
                crate::output::GetJourneyExecutionActivityMetricsOutput,
                crate::error::GetJourneyExecutionActivityMetricsError,
                crate::input::GetJourneyExecutionActivityMetricsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey activity.</p>
        pub fn journey_activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_activity_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey activity.</p>
        pub fn set_journey_activity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_journey_activity_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourneyExecutionMetrics`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJourneyExecutionMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_execution_metrics_input::Builder,
    }
    impl<C, M, R> GetJourneyExecutionMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourneyExecutionMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyExecutionMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJourneyExecutionMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyExecutionMetricsInputOperationOutputAlias,
                crate::output::GetJourneyExecutionMetricsOutput,
                crate::error::GetJourneyExecutionMetricsError,
                crate::input::GetJourneyExecutionMetricsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPushTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through a push notification channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_push_template_input::Builder,
    }
    impl<C, M, R> GetPushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPushTemplateInputOperationOutputAlias,
                crate::output::GetPushTemplateOutput,
                crate::error::GetPushTemplateError,
                crate::input::GetPushTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecommenderConfiguration`.
    ///
    /// <p>Retrieves information about an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recommender_configuration_input::Builder,
    }
    impl<C, M, R> GetRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecommenderConfigurationInputOperationOutputAlias,
                crate::output::GetRecommenderConfigurationOutput,
                crate::error::GetRecommenderConfigurationError,
                crate::input::GetRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_id(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecommenderConfigurations`.
    ///
    /// <p>Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecommenderConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recommender_configurations_input::Builder,
    }
    impl<C, M, R> GetRecommenderConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecommenderConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommenderConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommenderConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecommenderConfigurationsInputOperationOutputAlias,
                crate::output::GetRecommenderConfigurationsOutput,
                crate::error::GetRecommenderConfigurationsError,
                crate::input::GetRecommenderConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegment`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_input::Builder,
    }
    impl<C, M, R> GetSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentInputOperationOutputAlias,
                crate::output::GetSegmentOutput,
                crate::error::GetSegmentError,
                crate::input::GetSegmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentExportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of the export jobs for a segment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegmentExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_export_jobs_input::Builder,
    }
    impl<C, M, R> GetSegmentExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentExportJobsInputOperationOutputAlias,
                crate::output::GetSegmentExportJobsOutput,
                crate::error::GetSegmentExportJobsError,
                crate::input::GetSegmentExportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentImportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of the import jobs for a segment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegmentImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_import_jobs_input::Builder,
    }
    impl<C, M, R> GetSegmentImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentImportJobsInputOperationOutputAlias,
                crate::output::GetSegmentImportJobsOutput,
                crate::error::GetSegmentImportJobsError,
                crate::input::GetSegmentImportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegments`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segments_input::Builder,
    }
    impl<C, M, R> GetSegments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentsInputOperationOutputAlias,
                crate::output::GetSegmentsOutput,
                crate::error::GetSegmentsError,
                crate::input::GetSegmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentVersion`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegmentVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_version_input::Builder,
    }
    impl<C, M, R> GetSegmentVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentVersionInputOperationOutputAlias,
                crate::output::GetSegmentVersionOutput,
                crate::error::GetSegmentVersionError,
                crate::input::GetSegmentVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentVersions`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegmentVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_versions_input::Builder,
    }
    impl<C, M, R> GetSegmentVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentVersionsInputOperationOutputAlias,
                crate::output::GetSegmentVersionsOutput,
                crate::error::GetSegmentVersionsError,
                crate::input::GetSegmentVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSmsChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the SMS channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSmsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sms_channel_input::Builder,
    }
    impl<C, M, R> GetSmsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSmsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSmsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSmsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSmsChannelInputOperationOutputAlias,
                crate::output::GetSmsChannelOutput,
                crate::error::GetSmsChannelError,
                crate::input::GetSmsChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSmsTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through the SMS channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sms_template_input::Builder,
    }
    impl<C, M, R> GetSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSmsTemplateInputOperationOutputAlias,
                crate::output::GetSmsTemplateOutput,
                crate::error::GetSmsTemplateError,
                crate::input::GetSmsTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserEndpoints`.
    ///
    /// <p>Retrieves information about all the endpoints that are associated with a specific user ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUserEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_endpoints_input::Builder,
    }
    impl<C, M, R> GetUserEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserEndpointsInputOperationOutputAlias,
                crate::output::GetUserEndpointsOutput,
                crate::error::GetUserEndpointsError,
                crate::input::GetUserEndpointsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the voice channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_channel_input::Builder,
    }
    impl<C, M, R> GetVoiceChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceChannelInputOperationOutputAlias,
                crate::output::GetVoiceChannelOutput,
                crate::error::GetVoiceChannelError,
                crate::input::GetVoiceChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through the voice channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_template_input::Builder,
    }
    impl<C, M, R> GetVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceTemplateInputOperationOutputAlias,
                crate::output::GetVoiceTemplateOutput,
                crate::error::GetVoiceTemplateError,
                crate::input::GetVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJourneys`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJourneys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journeys_input::Builder,
    }
    impl<C, M, R> ListJourneys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJourneys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJourneysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJourneysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJourneysInputOperationOutputAlias,
                crate::output::ListJourneysOutput,
                crate::error::ListJourneysError,
                crate::input::ListJourneysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplates`.
    ///
    /// <p>Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_templates_input::Builder,
    }
    impl<C, M, R> ListTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplatesInputOperationOutputAlias,
                crate::output::ListTemplatesOutput,
                crate::error::ListTemplatesError,
                crate::input::ListTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
        pub fn template_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_type(input.into());
            self
        }
        /// <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplateVersions`.
    ///
    /// <p>Retrieves information about all the versions of a specific message template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_template_versions_input::Builder,
    }
    impl<C, M, R> ListTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplateVersionsInputOperationOutputAlias,
                crate::output::ListTemplateVersionsOutput,
                crate::error::ListTemplateVersionsError,
                crate::input::ListTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn template_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_type(input.into());
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PhoneNumberValidate`.
    ///
    /// <p>Retrieves information about a phone number.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PhoneNumberValidate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::phone_number_validate_input::Builder,
    }
    impl<C, M, R> PhoneNumberValidate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PhoneNumberValidate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PhoneNumberValidateOutput,
            aws_smithy_http::result::SdkError<crate::error::PhoneNumberValidateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PhoneNumberValidateInputOperationOutputAlias,
                crate::output::PhoneNumberValidateOutput,
                crate::error::PhoneNumberValidateError,
                crate::input::PhoneNumberValidateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies a phone number to validate and retrieve information about.</p>
        pub fn number_validate_request(
            mut self,
            input: crate::model::NumberValidateRequest,
        ) -> Self {
            self.inner = self.inner.number_validate_request(input);
            self
        }
        /// <p>Specifies a phone number to validate and retrieve information about.</p>
        pub fn set_number_validate_request(
            mut self,
            input: std::option::Option<crate::model::NumberValidateRequest>,
        ) -> Self {
            self.inner = self.inner.set_number_validate_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEvents`.
    ///
    /// <p>Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_events_input::Builder,
    }
    impl<C, M, R> PutEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventsInputOperationOutputAlias,
                crate::output::PutEventsOutput,
                crate::error::PutEventsError,
                crate::input::PutEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies a batch of events to process.</p>
        pub fn events_request(mut self, input: crate::model::EventsRequest) -> Self {
            self.inner = self.inner.events_request(input);
            self
        }
        /// <p>Specifies a batch of events to process.</p>
        pub fn set_events_request(
            mut self,
            input: std::option::Option<crate::model::EventsRequest>,
        ) -> Self {
            self.inner = self.inner.set_events_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventStream`.
    ///
    /// <p>Creates a new event stream for an application or updates the settings of an existing event stream for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEventStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_event_stream_input::Builder,
    }
    impl<C, M, R> PutEventStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEventStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventStreamInputOperationOutputAlias,
                crate::output::PutEventStreamOutput,
                crate::error::PutEventStreamError,
                crate::input::PutEventStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
        pub fn write_event_stream(mut self, input: crate::model::WriteEventStream) -> Self {
            self.inner = self.inner.write_event_stream(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
        pub fn set_write_event_stream(
            mut self,
            input: std::option::Option<crate::model::WriteEventStream>,
        ) -> Self {
            self.inner = self.inner.set_write_event_stream(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAttributes`.
    ///
    /// <p>Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_attributes_input::Builder,
    }
    impl<C, M, R> RemoveAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveAttributesInputOperationOutputAlias,
                crate::output::RemoveAttributesOutput,
                crate::error::RemoveAttributesError,
                crate::input::RemoveAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The type of attribute or attributes to remove. Valid values are:</p>
        /// <ul>
        /// <li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li>
        /// <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li>
        /// <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li>
        /// </ul>
        pub fn attribute_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_type(input.into());
            self
        }
        /// <p>The type of attribute or attributes to remove. Valid values are:</p>
        /// <ul>
        /// <li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li>
        /// <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li>
        /// <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li>
        /// </ul>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_type(input);
            self
        }
        /// <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
        pub fn update_attributes_request(
            mut self,
            input: crate::model::UpdateAttributesRequest,
        ) -> Self {
            self.inner = self.inner.update_attributes_request(input);
            self
        }
        /// <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
        pub fn set_update_attributes_request(
            mut self,
            input: std::option::Option<crate::model::UpdateAttributesRequest>,
        ) -> Self {
            self.inner = self.inner.set_update_attributes_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendMessages`.
    ///
    /// <p>Creates and sends a direct message.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_messages_input::Builder,
    }
    impl<C, M, R> SendMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::SendMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendMessagesInputOperationOutputAlias,
                crate::output::SendMessagesOutput,
                crate::error::SendMessagesError,
                crate::input::SendMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message.</p>
        pub fn message_request(mut self, input: crate::model::MessageRequest) -> Self {
            self.inner = self.inner.message_request(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message.</p>
        pub fn set_message_request(
            mut self,
            input: std::option::Option<crate::model::MessageRequest>,
        ) -> Self {
            self.inner = self.inner.set_message_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendOTPMessage`.
    ///
    /// <p>Send an OTP message</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendOTPMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_otp_message_input::Builder,
    }
    impl<C, M, R> SendOTPMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendOTPMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendOtpMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendOTPMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendOtpMessageInputOperationOutputAlias,
                crate::output::SendOtpMessageOutput,
                crate::error::SendOTPMessageError,
                crate::input::SendOtpMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Send OTP message request parameters.</p>
        pub fn send_otp_message_request_parameters(
            mut self,
            input: crate::model::SendOtpMessageRequestParameters,
        ) -> Self {
            self.inner = self.inner.send_otp_message_request_parameters(input);
            self
        }
        /// <p>Send OTP message request parameters.</p>
        pub fn set_send_otp_message_request_parameters(
            mut self,
            input: std::option::Option<crate::model::SendOtpMessageRequestParameters>,
        ) -> Self {
            self.inner = self.inner.set_send_otp_message_request_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendUsersMessages`.
    ///
    /// <p>Creates and sends a message to a list of users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendUsersMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_users_messages_input::Builder,
    }
    impl<C, M, R> SendUsersMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendUsersMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendUsersMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::SendUsersMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendUsersMessagesInputOperationOutputAlias,
                crate::output::SendUsersMessagesOutput,
                crate::error::SendUsersMessagesError,
                crate::input::SendUsersMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
        pub fn send_users_message_request(
            mut self,
            input: crate::model::SendUsersMessageRequest,
        ) -> Self {
            self.inner = self.inner.send_users_message_request(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
        pub fn set_send_users_message_request(
            mut self,
            input: std::option::Option<crate::model::SendUsersMessageRequest>,
        ) -> Self {
            self.inner = self.inner.set_send_users_message_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags (keys and values) to an application, campaign, message template, or segment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
        pub fn tags_model(mut self, input: crate::model::TagsModel) -> Self {
            self.inner = self.inner.tags_model(input);
            self
        }
        /// <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
        pub fn set_tags_model(
            mut self,
            input: std::option::Option<crate::model::TagsModel>,
        ) -> Self {
            self.inner = self.inner.set_tags_model(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags (keys and values) from an application, campaign, message template, or segment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAdmChannel`.
    ///
    /// <p>Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAdmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_adm_channel_input::Builder,
    }
    impl<C, M, R> UpdateAdmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAdmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAdmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAdmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAdmChannelInputOperationOutputAlias,
                crate::output::UpdateAdmChannelOutput,
                crate::error::UpdateAdmChannelError,
                crate::input::UpdateAdmChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
        pub fn adm_channel_request(mut self, input: crate::model::AdmChannelRequest) -> Self {
            self.inner = self.inner.adm_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
        pub fn set_adm_channel_request(
            mut self,
            input: std::option::Option<crate::model::AdmChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_adm_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsChannel`.
    ///
    /// <p>Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApnsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsChannelInputOperationOutputAlias,
                crate::output::UpdateApnsChannelOutput,
                crate::error::UpdateApnsChannelError,
                crate::input::UpdateApnsChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
        pub fn apns_channel_request(mut self, input: crate::model::ApnsChannelRequest) -> Self {
            self.inner = self.inner.apns_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
        pub fn set_apns_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsSandboxChannel`.
    ///
    /// <p>Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApnsSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_sandbox_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsSandboxChannelInputOperationOutputAlias,
                crate::output::UpdateApnsSandboxChannelOutput,
                crate::error::UpdateApnsSandboxChannelError,
                crate::input::UpdateApnsSandboxChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
        pub fn apns_sandbox_channel_request(
            mut self,
            input: crate::model::ApnsSandboxChannelRequest,
        ) -> Self {
            self.inner = self.inner.apns_sandbox_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
        pub fn set_apns_sandbox_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsSandboxChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_sandbox_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsVoipChannel`.
    ///
    /// <p>Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApnsVoipChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_voip_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsVoipChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsVoipChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsVoipChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsVoipChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsVoipChannelInputOperationOutputAlias,
                crate::output::UpdateApnsVoipChannelOutput,
                crate::error::UpdateApnsVoipChannelError,
                crate::input::UpdateApnsVoipChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
        pub fn apns_voip_channel_request(
            mut self,
            input: crate::model::ApnsVoipChannelRequest,
        ) -> Self {
            self.inner = self.inner.apns_voip_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
        pub fn set_apns_voip_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsVoipChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_voip_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsVoipSandboxChannel`.
    ///
    /// <p>Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApnsVoipSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_voip_sandbox_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsVoipSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsVoipSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsVoipSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsVoipSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsVoipSandboxChannelInputOperationOutputAlias,
                crate::output::UpdateApnsVoipSandboxChannelOutput,
                crate::error::UpdateApnsVoipSandboxChannelError,
                crate::input::UpdateApnsVoipSandboxChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
        pub fn apns_voip_sandbox_channel_request(
            mut self,
            input: crate::model::ApnsVoipSandboxChannelRequest,
        ) -> Self {
            self.inner = self.inner.apns_voip_sandbox_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
        pub fn set_apns_voip_sandbox_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsVoipSandboxChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_voip_sandbox_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationSettings`.
    ///
    /// <p>Updates the settings for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplicationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_settings_input::Builder,
    }
    impl<C, M, R> UpdateApplicationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplicationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationSettingsInputOperationOutputAlias,
                crate::output::UpdateApplicationSettingsOutput,
                crate::error::UpdateApplicationSettingsError,
                crate::input::UpdateApplicationSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the default settings for an application.</p>
        pub fn write_application_settings_request(
            mut self,
            input: crate::model::WriteApplicationSettingsRequest,
        ) -> Self {
            self.inner = self.inner.write_application_settings_request(input);
            self
        }
        /// <p>Specifies the default settings for an application.</p>
        pub fn set_write_application_settings_request(
            mut self,
            input: std::option::Option<crate::model::WriteApplicationSettingsRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_application_settings_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBaiduChannel`.
    ///
    /// <p>Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBaiduChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_baidu_channel_input::Builder,
    }
    impl<C, M, R> UpdateBaiduChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBaiduChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBaiduChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBaiduChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBaiduChannelInputOperationOutputAlias,
                crate::output::UpdateBaiduChannelOutput,
                crate::error::UpdateBaiduChannelError,
                crate::input::UpdateBaiduChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
        pub fn baidu_channel_request(mut self, input: crate::model::BaiduChannelRequest) -> Self {
            self.inner = self.inner.baidu_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
        pub fn set_baidu_channel_request(
            mut self,
            input: std::option::Option<crate::model::BaiduChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_baidu_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCampaign`.
    ///
    /// <p>Updates the configuration and other settings for a campaign.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_campaign_input::Builder,
    }
    impl<C, M, R> UpdateCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCampaignInputOperationOutputAlias,
                crate::output::UpdateCampaignOutput,
                crate::error::UpdateCampaignError,
                crate::input::UpdateCampaignInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn write_campaign_request(mut self, input: crate::model::WriteCampaignRequest) -> Self {
            self.inner = self.inner.write_campaign_request(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn set_write_campaign_request(
            mut self,
            input: std::option::Option<crate::model::WriteCampaignRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_campaign_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailChannel`.
    ///
    /// <p>Enables the email channel for an application or updates the status and settings of the email channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEmailChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_email_channel_input::Builder,
    }
    impl<C, M, R> UpdateEmailChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmailChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmailChannelInputOperationOutputAlias,
                crate::output::UpdateEmailChannelOutput,
                crate::error::UpdateEmailChannelError,
                crate::input::UpdateEmailChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the email channel for an application.</p>
        pub fn email_channel_request(mut self, input: crate::model::EmailChannelRequest) -> Self {
            self.inner = self.inner.email_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the email channel for an application.</p>
        pub fn set_email_channel_request(
            mut self,
            input: std::option::Option<crate::model::EmailChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_email_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through the email channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_email_template_input::Builder,
    }
    impl<C, M, R> UpdateEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmailTemplateInputOperationOutputAlias,
                crate::output::UpdateEmailTemplateOutput,
                crate::error::UpdateEmailTemplateError,
                crate::input::UpdateEmailTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_new_version(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn email_template_request(mut self, input: crate::model::EmailTemplateRequest) -> Self {
            self.inner = self.inner.email_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn set_email_template_request(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_email_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpoint`.
    ///
    /// <p>Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEndpointInputOperationOutputAlias,
                crate::output::UpdateEndpointOutput,
                crate::error::UpdateEndpointError,
                crate::input::UpdateEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// <p>Specifies the channel type and other settings for an endpoint.</p>
        pub fn endpoint_request(mut self, input: crate::model::EndpointRequest) -> Self {
            self.inner = self.inner.endpoint_request(input);
            self
        }
        /// <p>Specifies the channel type and other settings for an endpoint.</p>
        pub fn set_endpoint_request(
            mut self,
            input: std::option::Option<crate::model::EndpointRequest>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpointsBatch`.
    ///
    /// <p>Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEndpointsBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_endpoints_batch_input::Builder,
    }
    impl<C, M, R> UpdateEndpointsBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEndpointsBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointsBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointsBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEndpointsBatchInputOperationOutputAlias,
                crate::output::UpdateEndpointsBatchOutput,
                crate::error::UpdateEndpointsBatchError,
                crate::input::UpdateEndpointsBatchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
        pub fn endpoint_batch_request(mut self, input: crate::model::EndpointBatchRequest) -> Self {
            self.inner = self.inner.endpoint_batch_request(input);
            self
        }
        /// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
        pub fn set_endpoint_batch_request(
            mut self,
            input: std::option::Option<crate::model::EndpointBatchRequest>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_batch_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGcmChannel`.
    ///
    /// <p>Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGcmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gcm_channel_input::Builder,
    }
    impl<C, M, R> UpdateGcmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGcmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGcmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGcmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGcmChannelInputOperationOutputAlias,
                crate::output::UpdateGcmChannelOutput,
                crate::error::UpdateGcmChannelError,
                crate::input::UpdateGcmChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
        pub fn gcm_channel_request(mut self, input: crate::model::GcmChannelRequest) -> Self {
            self.inner = self.inner.gcm_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
        pub fn set_gcm_channel_request(
            mut self,
            input: std::option::Option<crate::model::GcmChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_gcm_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInAppTemplate`.
    ///
    /// <p>Updates an existing message template for messages sent through the in-app message channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_in_app_template_input::Builder,
    }
    impl<C, M, R> UpdateInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInAppTemplateInputOperationOutputAlias,
                crate::output::UpdateInAppTemplateOutput,
                crate::error::UpdateInAppTemplateError,
                crate::input::UpdateInAppTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_new_version(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn in_app_template_request(
            mut self,
            input: crate::model::InAppTemplateRequest,
        ) -> Self {
            self.inner = self.inner.in_app_template_request(input);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn set_in_app_template_request(
            mut self,
            input: std::option::Option<crate::model::InAppTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_in_app_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJourney`.
    ///
    /// <p>Updates the configuration and other settings for a journey.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_journey_input::Builder,
    }
    impl<C, M, R> UpdateJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJourneyInputOperationOutputAlias,
                crate::output::UpdateJourneyOutput,
                crate::error::UpdateJourneyError,
                crate::input::UpdateJourneyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn write_journey_request(mut self, input: crate::model::WriteJourneyRequest) -> Self {
            self.inner = self.inner.write_journey_request(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn set_write_journey_request(
            mut self,
            input: std::option::Option<crate::model::WriteJourneyRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_journey_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJourneyState`.
    ///
    /// <p>Cancels (stops) an active journey.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateJourneyState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_journey_state_input::Builder,
    }
    impl<C, M, R> UpdateJourneyState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJourneyState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJourneyStateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJourneyStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJourneyStateInputOperationOutputAlias,
                crate::output::UpdateJourneyStateOutput,
                crate::error::UpdateJourneyStateError,
                crate::input::UpdateJourneyStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>Changes the status of a journey.</p>
        pub fn journey_state_request(mut self, input: crate::model::JourneyStateRequest) -> Self {
            self.inner = self.inner.journey_state_request(input);
            self
        }
        /// <p>Changes the status of a journey.</p>
        pub fn set_journey_state_request(
            mut self,
            input: std::option::Option<crate::model::JourneyStateRequest>,
        ) -> Self {
            self.inner = self.inner.set_journey_state_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePushTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through a push notification channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_push_template_input::Builder,
    }
    impl<C, M, R> UpdatePushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePushTemplateInputOperationOutputAlias,
                crate::output::UpdatePushTemplateOutput,
                crate::error::UpdatePushTemplateError,
                crate::input::UpdatePushTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_new_version(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn push_notification_template_request(
            mut self,
            input: crate::model::PushNotificationTemplateRequest,
        ) -> Self {
            self.inner = self.inner.push_notification_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn set_push_notification_template_request(
            mut self,
            input: std::option::Option<crate::model::PushNotificationTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_push_notification_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecommenderConfiguration`.
    ///
    /// <p>Updates an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recommender_configuration_input::Builder,
    }
    impl<C, M, R> UpdateRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecommenderConfigurationInputOperationOutputAlias,
                crate::output::UpdateRecommenderConfigurationOutput,
                crate::error::UpdateRecommenderConfigurationError,
                crate::input::UpdateRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_id(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_id(input);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn update_recommender_configuration(
            mut self,
            input: crate::model::UpdateRecommenderConfigurationShape,
        ) -> Self {
            self.inner = self.inner.update_recommender_configuration(input);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn set_update_recommender_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateRecommenderConfigurationShape>,
        ) -> Self {
            self.inner = self.inner.set_update_recommender_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSegment`.
    ///
    /// <p>Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_segment_input::Builder,
    }
    impl<C, M, R> UpdateSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSegmentInputOperationOutputAlias,
                crate::output::UpdateSegmentOutput,
                crate::error::UpdateSegmentError,
                crate::input::UpdateSegmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn write_segment_request(mut self, input: crate::model::WriteSegmentRequest) -> Self {
            self.inner = self.inner.write_segment_request(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn set_write_segment_request(
            mut self,
            input: std::option::Option<crate::model::WriteSegmentRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_segment_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSmsChannel`.
    ///
    /// <p>Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSmsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sms_channel_input::Builder,
    }
    impl<C, M, R> UpdateSmsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSmsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSmsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmsChannelInputOperationOutputAlias,
                crate::output::UpdateSmsChannelOutput,
                crate::error::UpdateSmsChannelError,
                crate::input::UpdateSmsChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the SMS channel for an application.</p>
        pub fn sms_channel_request(mut self, input: crate::model::SmsChannelRequest) -> Self {
            self.inner = self.inner.sms_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the SMS channel for an application.</p>
        pub fn set_sms_channel_request(
            mut self,
            input: std::option::Option<crate::model::SmsChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_sms_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSmsTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through the SMS channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sms_template_input::Builder,
    }
    impl<C, M, R> UpdateSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmsTemplateInputOperationOutputAlias,
                crate::output::UpdateSmsTemplateOutput,
                crate::error::UpdateSmsTemplateError,
                crate::input::UpdateSmsTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_new_version(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn sms_template_request(mut self, input: crate::model::SmsTemplateRequest) -> Self {
            self.inner = self.inner.sms_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn set_sms_template_request(
            mut self,
            input: std::option::Option<crate::model::SmsTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_sms_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplateActiveVersion`.
    ///
    /// <p>Changes the status of a specific version of a message template to <i>active</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTemplateActiveVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_active_version_input::Builder,
    }
    impl<C, M, R> UpdateTemplateActiveVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplateActiveVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateActiveVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateActiveVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateActiveVersionInputOperationOutputAlias,
                crate::output::UpdateTemplateActiveVersionOutput,
                crate::error::UpdateTemplateActiveVersionError,
                crate::input::UpdateTemplateActiveVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which version of a message template to use as the active version of the template.</p>
        pub fn template_active_version_request(
            mut self,
            input: crate::model::TemplateActiveVersionRequest,
        ) -> Self {
            self.inner = self.inner.template_active_version_request(input);
            self
        }
        /// <p>Specifies which version of a message template to use as the active version of the template.</p>
        pub fn set_template_active_version_request(
            mut self,
            input: std::option::Option<crate::model::TemplateActiveVersionRequest>,
        ) -> Self {
            self.inner = self.inner.set_template_active_version_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn template_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_type(input.into());
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVoiceChannel`.
    ///
    /// <p>Enables the voice channel for an application or updates the status and settings of the voice channel for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVoiceChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_voice_channel_input::Builder,
    }
    impl<C, M, R> UpdateVoiceChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVoiceChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVoiceChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVoiceChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVoiceChannelInputOperationOutputAlias,
                crate::output::UpdateVoiceChannelOutput,
                crate::error::UpdateVoiceChannelError,
                crate::input::UpdateVoiceChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the voice channel for an application.</p>
        pub fn voice_channel_request(mut self, input: crate::model::VoiceChannelRequest) -> Self {
            self.inner = self.inner.voice_channel_request(input);
            self
        }
        /// <p>Specifies the status and settings of the voice channel for an application.</p>
        pub fn set_voice_channel_request(
            mut self,
            input: std::option::Option<crate::model::VoiceChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_voice_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVoiceTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through the voice channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_voice_template_input::Builder,
    }
    impl<C, M, R> UpdateVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVoiceTemplateInputOperationOutputAlias,
                crate::output::UpdateVoiceTemplateOutput,
                crate::error::UpdateVoiceTemplateError,
                crate::input::UpdateVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_new_version(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn voice_template_request(mut self, input: crate::model::VoiceTemplateRequest) -> Self {
            self.inner = self.inner.voice_template_request(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn set_voice_template_request(
            mut self,
            input: std::option::Option<crate::model::VoiceTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_voice_template_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyOTPMessage`.
    ///
    /// <p>Verify an OTP</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyOTPMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_otp_message_input::Builder,
    }
    impl<C, M, R> VerifyOTPMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyOTPMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyOtpMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyOTPMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyOtpMessageInputOperationOutputAlias,
                crate::output::VerifyOtpMessageOutput,
                crate::error::VerifyOTPMessageError,
                crate::input::VerifyOtpMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Verify OTP message request.</p>
        pub fn verify_otp_message_request_parameters(
            mut self,
            input: crate::model::VerifyOtpMessageRequestParameters,
        ) -> Self {
            self.inner = self.inner.verify_otp_message_request_parameters(input);
            self
        }
        /// <p>Verify OTP message request.</p>
        pub fn set_verify_otp_message_request_parameters(
            mut self,
            input: std::option::Option<crate::model::VerifyOtpMessageRequestParameters>,
        ) -> Self {
            self.inner = self.inner.set_verify_otp_message_request_parameters(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
