// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app`](crate::client::Client::create_app).
///
/// See [`crate::client::fluent_builders::CreateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApp {
    _private: (),
}
impl CreateApp {
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
    /// Creates a new `CreateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApp {
    type Output = std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_app_error(response)
        } else {
            crate::operation_deser::parse_create_app_response(response)
        }
    }
}

/// Operation shape for `CreateCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_campaign`](crate::client::Client::create_campaign).
///
/// See [`crate::client::fluent_builders::CreateCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCampaign {
    _private: (),
}
impl CreateCampaign {
    /// Creates a new builder-style object to manufacture [`CreateCampaignInput`](crate::input::CreateCampaignInput)
    pub fn builder() -> crate::input::create_campaign_input::Builder {
        crate::input::create_campaign_input::Builder::default()
    }
    /// Creates a new `CreateCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCampaign {
    type Output =
        std::result::Result<crate::output::CreateCampaignOutput, crate::error::CreateCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_campaign_error(response)
        } else {
            crate::operation_deser::parse_create_campaign_response(response)
        }
    }
}

/// Operation shape for `CreateEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_email_template`](crate::client::Client::create_email_template).
///
/// See [`crate::client::fluent_builders::CreateEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEmailTemplate {
    _private: (),
}
impl CreateEmailTemplate {
    /// Creates a new builder-style object to manufacture [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
    pub fn builder() -> crate::input::create_email_template_input::Builder {
        crate::input::create_email_template_input::Builder::default()
    }
    /// Creates a new `CreateEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEmailTemplate {
    type Output = std::result::Result<
        crate::output::CreateEmailTemplateOutput,
        crate::error::CreateEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_email_template_error(response)
        } else {
            crate::operation_deser::parse_create_email_template_response(response)
        }
    }
}

/// Operation shape for `CreateExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_export_job`](crate::client::Client::create_export_job).
///
/// See [`crate::client::fluent_builders::CreateExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExportJob {
    _private: (),
}
impl CreateExportJob {
    /// Creates a new builder-style object to manufacture [`CreateExportJobInput`](crate::input::CreateExportJobInput)
    pub fn builder() -> crate::input::create_export_job_input::Builder {
        crate::input::create_export_job_input::Builder::default()
    }
    /// Creates a new `CreateExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExportJob {
    type Output = std::result::Result<
        crate::output::CreateExportJobOutput,
        crate::error::CreateExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_export_job_error(response)
        } else {
            crate::operation_deser::parse_create_export_job_response(response)
        }
    }
}

/// Operation shape for `CreateImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_import_job`](crate::client::Client::create_import_job).
///
/// See [`crate::client::fluent_builders::CreateImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImportJob {
    _private: (),
}
impl CreateImportJob {
    /// Creates a new builder-style object to manufacture [`CreateImportJobInput`](crate::input::CreateImportJobInput)
    pub fn builder() -> crate::input::create_import_job_input::Builder {
        crate::input::create_import_job_input::Builder::default()
    }
    /// Creates a new `CreateImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImportJob {
    type Output = std::result::Result<
        crate::output::CreateImportJobOutput,
        crate::error::CreateImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_import_job_error(response)
        } else {
            crate::operation_deser::parse_create_import_job_response(response)
        }
    }
}

/// Operation shape for `CreateInAppTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_in_app_template`](crate::client::Client::create_in_app_template).
///
/// See [`crate::client::fluent_builders::CreateInAppTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInAppTemplate {
    _private: (),
}
impl CreateInAppTemplate {
    /// Creates a new builder-style object to manufacture [`CreateInAppTemplateInput`](crate::input::CreateInAppTemplateInput)
    pub fn builder() -> crate::input::create_in_app_template_input::Builder {
        crate::input::create_in_app_template_input::Builder::default()
    }
    /// Creates a new `CreateInAppTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInAppTemplate {
    type Output = std::result::Result<
        crate::output::CreateInAppTemplateOutput,
        crate::error::CreateInAppTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_in_app_template_error(response)
        } else {
            crate::operation_deser::parse_create_in_app_template_response(response)
        }
    }
}

/// Operation shape for `CreateJourney`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_journey`](crate::client::Client::create_journey).
///
/// See [`crate::client::fluent_builders::CreateJourney`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJourney {
    _private: (),
}
impl CreateJourney {
    /// Creates a new builder-style object to manufacture [`CreateJourneyInput`](crate::input::CreateJourneyInput)
    pub fn builder() -> crate::input::create_journey_input::Builder {
        crate::input::create_journey_input::Builder::default()
    }
    /// Creates a new `CreateJourney` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJourney {
    type Output =
        std::result::Result<crate::output::CreateJourneyOutput, crate::error::CreateJourneyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_journey_error(response)
        } else {
            crate::operation_deser::parse_create_journey_response(response)
        }
    }
}

/// Operation shape for `CreatePushTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_push_template`](crate::client::Client::create_push_template).
///
/// See [`crate::client::fluent_builders::CreatePushTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePushTemplate {
    _private: (),
}
impl CreatePushTemplate {
    /// Creates a new builder-style object to manufacture [`CreatePushTemplateInput`](crate::input::CreatePushTemplateInput)
    pub fn builder() -> crate::input::create_push_template_input::Builder {
        crate::input::create_push_template_input::Builder::default()
    }
    /// Creates a new `CreatePushTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePushTemplate {
    type Output = std::result::Result<
        crate::output::CreatePushTemplateOutput,
        crate::error::CreatePushTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_push_template_error(response)
        } else {
            crate::operation_deser::parse_create_push_template_response(response)
        }
    }
}

/// Operation shape for `CreateRecommenderConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_recommender_configuration`](crate::client::Client::create_recommender_configuration).
///
/// See [`crate::client::fluent_builders::CreateRecommenderConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRecommenderConfiguration {
    _private: (),
}
impl CreateRecommenderConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateRecommenderConfigurationInput`](crate::input::CreateRecommenderConfigurationInput)
    pub fn builder() -> crate::input::create_recommender_configuration_input::Builder {
        crate::input::create_recommender_configuration_input::Builder::default()
    }
    /// Creates a new `CreateRecommenderConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRecommenderConfiguration {
    type Output = std::result::Result<
        crate::output::CreateRecommenderConfigurationOutput,
        crate::error::CreateRecommenderConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_recommender_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_recommender_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateSegment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_segment`](crate::client::Client::create_segment).
///
/// See [`crate::client::fluent_builders::CreateSegment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSegment {
    _private: (),
}
impl CreateSegment {
    /// Creates a new builder-style object to manufacture [`CreateSegmentInput`](crate::input::CreateSegmentInput)
    pub fn builder() -> crate::input::create_segment_input::Builder {
        crate::input::create_segment_input::Builder::default()
    }
    /// Creates a new `CreateSegment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSegment {
    type Output =
        std::result::Result<crate::output::CreateSegmentOutput, crate::error::CreateSegmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_segment_error(response)
        } else {
            crate::operation_deser::parse_create_segment_response(response)
        }
    }
}

/// Operation shape for `CreateSmsTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sms_template`](crate::client::Client::create_sms_template).
///
/// See [`crate::client::fluent_builders::CreateSmsTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSmsTemplate {
    _private: (),
}
impl CreateSmsTemplate {
    /// Creates a new builder-style object to manufacture [`CreateSmsTemplateInput`](crate::input::CreateSmsTemplateInput)
    pub fn builder() -> crate::input::create_sms_template_input::Builder {
        crate::input::create_sms_template_input::Builder::default()
    }
    /// Creates a new `CreateSmsTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSmsTemplate {
    type Output = std::result::Result<
        crate::output::CreateSmsTemplateOutput,
        crate::error::CreateSmsTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_sms_template_error(response)
        } else {
            crate::operation_deser::parse_create_sms_template_response(response)
        }
    }
}

/// Operation shape for `CreateVoiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_voice_template`](crate::client::Client::create_voice_template).
///
/// See [`crate::client::fluent_builders::CreateVoiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVoiceTemplate {
    _private: (),
}
impl CreateVoiceTemplate {
    /// Creates a new builder-style object to manufacture [`CreateVoiceTemplateInput`](crate::input::CreateVoiceTemplateInput)
    pub fn builder() -> crate::input::create_voice_template_input::Builder {
        crate::input::create_voice_template_input::Builder::default()
    }
    /// Creates a new `CreateVoiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVoiceTemplate {
    type Output = std::result::Result<
        crate::output::CreateVoiceTemplateOutput,
        crate::error::CreateVoiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_voice_template_error(response)
        } else {
            crate::operation_deser::parse_create_voice_template_response(response)
        }
    }
}

/// Operation shape for `DeleteAdmChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_adm_channel`](crate::client::Client::delete_adm_channel).
///
/// See [`crate::client::fluent_builders::DeleteAdmChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAdmChannel {
    _private: (),
}
impl DeleteAdmChannel {
    /// Creates a new builder-style object to manufacture [`DeleteAdmChannelInput`](crate::input::DeleteAdmChannelInput)
    pub fn builder() -> crate::input::delete_adm_channel_input::Builder {
        crate::input::delete_adm_channel_input::Builder::default()
    }
    /// Creates a new `DeleteAdmChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAdmChannel {
    type Output = std::result::Result<
        crate::output::DeleteAdmChannelOutput,
        crate::error::DeleteAdmChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_adm_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_adm_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteApnsChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_apns_channel`](crate::client::Client::delete_apns_channel).
///
/// See [`crate::client::fluent_builders::DeleteApnsChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApnsChannel {
    _private: (),
}
impl DeleteApnsChannel {
    /// Creates a new builder-style object to manufacture [`DeleteApnsChannelInput`](crate::input::DeleteApnsChannelInput)
    pub fn builder() -> crate::input::delete_apns_channel_input::Builder {
        crate::input::delete_apns_channel_input::Builder::default()
    }
    /// Creates a new `DeleteApnsChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApnsChannel {
    type Output = std::result::Result<
        crate::output::DeleteApnsChannelOutput,
        crate::error::DeleteApnsChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_apns_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_apns_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteApnsSandboxChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_apns_sandbox_channel`](crate::client::Client::delete_apns_sandbox_channel).
///
/// See [`crate::client::fluent_builders::DeleteApnsSandboxChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApnsSandboxChannel {
    _private: (),
}
impl DeleteApnsSandboxChannel {
    /// Creates a new builder-style object to manufacture [`DeleteApnsSandboxChannelInput`](crate::input::DeleteApnsSandboxChannelInput)
    pub fn builder() -> crate::input::delete_apns_sandbox_channel_input::Builder {
        crate::input::delete_apns_sandbox_channel_input::Builder::default()
    }
    /// Creates a new `DeleteApnsSandboxChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApnsSandboxChannel {
    type Output = std::result::Result<
        crate::output::DeleteApnsSandboxChannelOutput,
        crate::error::DeleteApnsSandboxChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_apns_sandbox_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_apns_sandbox_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteApnsVoipChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_apns_voip_channel`](crate::client::Client::delete_apns_voip_channel).
///
/// See [`crate::client::fluent_builders::DeleteApnsVoipChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApnsVoipChannel {
    _private: (),
}
impl DeleteApnsVoipChannel {
    /// Creates a new builder-style object to manufacture [`DeleteApnsVoipChannelInput`](crate::input::DeleteApnsVoipChannelInput)
    pub fn builder() -> crate::input::delete_apns_voip_channel_input::Builder {
        crate::input::delete_apns_voip_channel_input::Builder::default()
    }
    /// Creates a new `DeleteApnsVoipChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApnsVoipChannel {
    type Output = std::result::Result<
        crate::output::DeleteApnsVoipChannelOutput,
        crate::error::DeleteApnsVoipChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_apns_voip_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_apns_voip_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteApnsVoipSandboxChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_apns_voip_sandbox_channel`](crate::client::Client::delete_apns_voip_sandbox_channel).
///
/// See [`crate::client::fluent_builders::DeleteApnsVoipSandboxChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApnsVoipSandboxChannel {
    _private: (),
}
impl DeleteApnsVoipSandboxChannel {
    /// Creates a new builder-style object to manufacture [`DeleteApnsVoipSandboxChannelInput`](crate::input::DeleteApnsVoipSandboxChannelInput)
    pub fn builder() -> crate::input::delete_apns_voip_sandbox_channel_input::Builder {
        crate::input::delete_apns_voip_sandbox_channel_input::Builder::default()
    }
    /// Creates a new `DeleteApnsVoipSandboxChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApnsVoipSandboxChannel {
    type Output = std::result::Result<
        crate::output::DeleteApnsVoipSandboxChannelOutput,
        crate::error::DeleteApnsVoipSandboxChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_apns_voip_sandbox_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_apns_voip_sandbox_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app`](crate::client::Client::delete_app).
///
/// See [`crate::client::fluent_builders::DeleteApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApp {
    _private: (),
}
impl DeleteApp {
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
    /// Creates a new `DeleteApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApp {
    type Output = std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_error(response)
        } else {
            crate::operation_deser::parse_delete_app_response(response)
        }
    }
}

/// Operation shape for `DeleteBaiduChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_baidu_channel`](crate::client::Client::delete_baidu_channel).
///
/// See [`crate::client::fluent_builders::DeleteBaiduChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBaiduChannel {
    _private: (),
}
impl DeleteBaiduChannel {
    /// Creates a new builder-style object to manufacture [`DeleteBaiduChannelInput`](crate::input::DeleteBaiduChannelInput)
    pub fn builder() -> crate::input::delete_baidu_channel_input::Builder {
        crate::input::delete_baidu_channel_input::Builder::default()
    }
    /// Creates a new `DeleteBaiduChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBaiduChannel {
    type Output = std::result::Result<
        crate::output::DeleteBaiduChannelOutput,
        crate::error::DeleteBaiduChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_baidu_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_baidu_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_campaign`](crate::client::Client::delete_campaign).
///
/// See [`crate::client::fluent_builders::DeleteCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCampaign {
    _private: (),
}
impl DeleteCampaign {
    /// Creates a new builder-style object to manufacture [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
    pub fn builder() -> crate::input::delete_campaign_input::Builder {
        crate::input::delete_campaign_input::Builder::default()
    }
    /// Creates a new `DeleteCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCampaign {
    type Output =
        std::result::Result<crate::output::DeleteCampaignOutput, crate::error::DeleteCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_campaign_error(response)
        } else {
            crate::operation_deser::parse_delete_campaign_response(response)
        }
    }
}

/// Operation shape for `DeleteEmailChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_email_channel`](crate::client::Client::delete_email_channel).
///
/// See [`crate::client::fluent_builders::DeleteEmailChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEmailChannel {
    _private: (),
}
impl DeleteEmailChannel {
    /// Creates a new builder-style object to manufacture [`DeleteEmailChannelInput`](crate::input::DeleteEmailChannelInput)
    pub fn builder() -> crate::input::delete_email_channel_input::Builder {
        crate::input::delete_email_channel_input::Builder::default()
    }
    /// Creates a new `DeleteEmailChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEmailChannel {
    type Output = std::result::Result<
        crate::output::DeleteEmailChannelOutput,
        crate::error::DeleteEmailChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_email_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_email_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_email_template`](crate::client::Client::delete_email_template).
///
/// See [`crate::client::fluent_builders::DeleteEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEmailTemplate {
    _private: (),
}
impl DeleteEmailTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
    pub fn builder() -> crate::input::delete_email_template_input::Builder {
        crate::input::delete_email_template_input::Builder::default()
    }
    /// Creates a new `DeleteEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEmailTemplate {
    type Output = std::result::Result<
        crate::output::DeleteEmailTemplateOutput,
        crate::error::DeleteEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_email_template_error(response)
        } else {
            crate::operation_deser::parse_delete_email_template_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint`](crate::client::Client::delete_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpoint {
    _private: (),
}
impl DeleteEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpoint {
    type Output =
        std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteEventStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_stream`](crate::client::Client::delete_event_stream).
///
/// See [`crate::client::fluent_builders::DeleteEventStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventStream {
    _private: (),
}
impl DeleteEventStream {
    /// Creates a new builder-style object to manufacture [`DeleteEventStreamInput`](crate::input::DeleteEventStreamInput)
    pub fn builder() -> crate::input::delete_event_stream_input::Builder {
        crate::input::delete_event_stream_input::Builder::default()
    }
    /// Creates a new `DeleteEventStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventStream {
    type Output = std::result::Result<
        crate::output::DeleteEventStreamOutput,
        crate::error::DeleteEventStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_stream_error(response)
        } else {
            crate::operation_deser::parse_delete_event_stream_response(response)
        }
    }
}

/// Operation shape for `DeleteGcmChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_gcm_channel`](crate::client::Client::delete_gcm_channel).
///
/// See [`crate::client::fluent_builders::DeleteGcmChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGcmChannel {
    _private: (),
}
impl DeleteGcmChannel {
    /// Creates a new builder-style object to manufacture [`DeleteGcmChannelInput`](crate::input::DeleteGcmChannelInput)
    pub fn builder() -> crate::input::delete_gcm_channel_input::Builder {
        crate::input::delete_gcm_channel_input::Builder::default()
    }
    /// Creates a new `DeleteGcmChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGcmChannel {
    type Output = std::result::Result<
        crate::output::DeleteGcmChannelOutput,
        crate::error::DeleteGcmChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_gcm_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_gcm_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteInAppTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_in_app_template`](crate::client::Client::delete_in_app_template).
///
/// See [`crate::client::fluent_builders::DeleteInAppTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInAppTemplate {
    _private: (),
}
impl DeleteInAppTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteInAppTemplateInput`](crate::input::DeleteInAppTemplateInput)
    pub fn builder() -> crate::input::delete_in_app_template_input::Builder {
        crate::input::delete_in_app_template_input::Builder::default()
    }
    /// Creates a new `DeleteInAppTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInAppTemplate {
    type Output = std::result::Result<
        crate::output::DeleteInAppTemplateOutput,
        crate::error::DeleteInAppTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_in_app_template_error(response)
        } else {
            crate::operation_deser::parse_delete_in_app_template_response(response)
        }
    }
}

/// Operation shape for `DeleteJourney`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_journey`](crate::client::Client::delete_journey).
///
/// See [`crate::client::fluent_builders::DeleteJourney`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJourney {
    _private: (),
}
impl DeleteJourney {
    /// Creates a new builder-style object to manufacture [`DeleteJourneyInput`](crate::input::DeleteJourneyInput)
    pub fn builder() -> crate::input::delete_journey_input::Builder {
        crate::input::delete_journey_input::Builder::default()
    }
    /// Creates a new `DeleteJourney` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJourney {
    type Output =
        std::result::Result<crate::output::DeleteJourneyOutput, crate::error::DeleteJourneyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_journey_error(response)
        } else {
            crate::operation_deser::parse_delete_journey_response(response)
        }
    }
}

/// Operation shape for `DeletePushTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_push_template`](crate::client::Client::delete_push_template).
///
/// See [`crate::client::fluent_builders::DeletePushTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePushTemplate {
    _private: (),
}
impl DeletePushTemplate {
    /// Creates a new builder-style object to manufacture [`DeletePushTemplateInput`](crate::input::DeletePushTemplateInput)
    pub fn builder() -> crate::input::delete_push_template_input::Builder {
        crate::input::delete_push_template_input::Builder::default()
    }
    /// Creates a new `DeletePushTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePushTemplate {
    type Output = std::result::Result<
        crate::output::DeletePushTemplateOutput,
        crate::error::DeletePushTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_push_template_error(response)
        } else {
            crate::operation_deser::parse_delete_push_template_response(response)
        }
    }
}

/// Operation shape for `DeleteRecommenderConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recommender_configuration`](crate::client::Client::delete_recommender_configuration).
///
/// See [`crate::client::fluent_builders::DeleteRecommenderConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecommenderConfiguration {
    _private: (),
}
impl DeleteRecommenderConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteRecommenderConfigurationInput`](crate::input::DeleteRecommenderConfigurationInput)
    pub fn builder() -> crate::input::delete_recommender_configuration_input::Builder {
        crate::input::delete_recommender_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteRecommenderConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecommenderConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteRecommenderConfigurationOutput,
        crate::error::DeleteRecommenderConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_recommender_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_recommender_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteSegment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_segment`](crate::client::Client::delete_segment).
///
/// See [`crate::client::fluent_builders::DeleteSegment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSegment {
    _private: (),
}
impl DeleteSegment {
    /// Creates a new builder-style object to manufacture [`DeleteSegmentInput`](crate::input::DeleteSegmentInput)
    pub fn builder() -> crate::input::delete_segment_input::Builder {
        crate::input::delete_segment_input::Builder::default()
    }
    /// Creates a new `DeleteSegment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSegment {
    type Output =
        std::result::Result<crate::output::DeleteSegmentOutput, crate::error::DeleteSegmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_segment_error(response)
        } else {
            crate::operation_deser::parse_delete_segment_response(response)
        }
    }
}

/// Operation shape for `DeleteSmsChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_sms_channel`](crate::client::Client::delete_sms_channel).
///
/// See [`crate::client::fluent_builders::DeleteSmsChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSmsChannel {
    _private: (),
}
impl DeleteSmsChannel {
    /// Creates a new builder-style object to manufacture [`DeleteSmsChannelInput`](crate::input::DeleteSmsChannelInput)
    pub fn builder() -> crate::input::delete_sms_channel_input::Builder {
        crate::input::delete_sms_channel_input::Builder::default()
    }
    /// Creates a new `DeleteSmsChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSmsChannel {
    type Output = std::result::Result<
        crate::output::DeleteSmsChannelOutput,
        crate::error::DeleteSmsChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_sms_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_sms_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteSmsTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_sms_template`](crate::client::Client::delete_sms_template).
///
/// See [`crate::client::fluent_builders::DeleteSmsTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSmsTemplate {
    _private: (),
}
impl DeleteSmsTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteSmsTemplateInput`](crate::input::DeleteSmsTemplateInput)
    pub fn builder() -> crate::input::delete_sms_template_input::Builder {
        crate::input::delete_sms_template_input::Builder::default()
    }
    /// Creates a new `DeleteSmsTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSmsTemplate {
    type Output = std::result::Result<
        crate::output::DeleteSmsTemplateOutput,
        crate::error::DeleteSmsTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_sms_template_error(response)
        } else {
            crate::operation_deser::parse_delete_sms_template_response(response)
        }
    }
}

/// Operation shape for `DeleteUserEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_endpoints`](crate::client::Client::delete_user_endpoints).
///
/// See [`crate::client::fluent_builders::DeleteUserEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserEndpoints {
    _private: (),
}
impl DeleteUserEndpoints {
    /// Creates a new builder-style object to manufacture [`DeleteUserEndpointsInput`](crate::input::DeleteUserEndpointsInput)
    pub fn builder() -> crate::input::delete_user_endpoints_input::Builder {
        crate::input::delete_user_endpoints_input::Builder::default()
    }
    /// Creates a new `DeleteUserEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserEndpoints {
    type Output = std::result::Result<
        crate::output::DeleteUserEndpointsOutput,
        crate::error::DeleteUserEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_user_endpoints_error(response)
        } else {
            crate::operation_deser::parse_delete_user_endpoints_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_channel`](crate::client::Client::delete_voice_channel).
///
/// See [`crate::client::fluent_builders::DeleteVoiceChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceChannel {
    _private: (),
}
impl DeleteVoiceChannel {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceChannelInput`](crate::input::DeleteVoiceChannelInput)
    pub fn builder() -> crate::input::delete_voice_channel_input::Builder {
        crate::input::delete_voice_channel_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceChannel {
    type Output = std::result::Result<
        crate::output::DeleteVoiceChannelOutput,
        crate::error::DeleteVoiceChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_voice_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_template`](crate::client::Client::delete_voice_template).
///
/// See [`crate::client::fluent_builders::DeleteVoiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceTemplate {
    _private: (),
}
impl DeleteVoiceTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceTemplateInput`](crate::input::DeleteVoiceTemplateInput)
    pub fn builder() -> crate::input::delete_voice_template_input::Builder {
        crate::input::delete_voice_template_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceTemplate {
    type Output = std::result::Result<
        crate::output::DeleteVoiceTemplateOutput,
        crate::error::DeleteVoiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_voice_template_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_template_response(response)
        }
    }
}

/// Operation shape for `GetAdmChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_adm_channel`](crate::client::Client::get_adm_channel).
///
/// See [`crate::client::fluent_builders::GetAdmChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAdmChannel {
    _private: (),
}
impl GetAdmChannel {
    /// Creates a new builder-style object to manufacture [`GetAdmChannelInput`](crate::input::GetAdmChannelInput)
    pub fn builder() -> crate::input::get_adm_channel_input::Builder {
        crate::input::get_adm_channel_input::Builder::default()
    }
    /// Creates a new `GetAdmChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAdmChannel {
    type Output =
        std::result::Result<crate::output::GetAdmChannelOutput, crate::error::GetAdmChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_adm_channel_error(response)
        } else {
            crate::operation_deser::parse_get_adm_channel_response(response)
        }
    }
}

/// Operation shape for `GetApnsChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apns_channel`](crate::client::Client::get_apns_channel).
///
/// See [`crate::client::fluent_builders::GetApnsChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApnsChannel {
    _private: (),
}
impl GetApnsChannel {
    /// Creates a new builder-style object to manufacture [`GetApnsChannelInput`](crate::input::GetApnsChannelInput)
    pub fn builder() -> crate::input::get_apns_channel_input::Builder {
        crate::input::get_apns_channel_input::Builder::default()
    }
    /// Creates a new `GetApnsChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApnsChannel {
    type Output =
        std::result::Result<crate::output::GetApnsChannelOutput, crate::error::GetApnsChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apns_channel_error(response)
        } else {
            crate::operation_deser::parse_get_apns_channel_response(response)
        }
    }
}

/// Operation shape for `GetApnsSandboxChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apns_sandbox_channel`](crate::client::Client::get_apns_sandbox_channel).
///
/// See [`crate::client::fluent_builders::GetApnsSandboxChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApnsSandboxChannel {
    _private: (),
}
impl GetApnsSandboxChannel {
    /// Creates a new builder-style object to manufacture [`GetApnsSandboxChannelInput`](crate::input::GetApnsSandboxChannelInput)
    pub fn builder() -> crate::input::get_apns_sandbox_channel_input::Builder {
        crate::input::get_apns_sandbox_channel_input::Builder::default()
    }
    /// Creates a new `GetApnsSandboxChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApnsSandboxChannel {
    type Output = std::result::Result<
        crate::output::GetApnsSandboxChannelOutput,
        crate::error::GetApnsSandboxChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apns_sandbox_channel_error(response)
        } else {
            crate::operation_deser::parse_get_apns_sandbox_channel_response(response)
        }
    }
}

/// Operation shape for `GetApnsVoipChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apns_voip_channel`](crate::client::Client::get_apns_voip_channel).
///
/// See [`crate::client::fluent_builders::GetApnsVoipChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApnsVoipChannel {
    _private: (),
}
impl GetApnsVoipChannel {
    /// Creates a new builder-style object to manufacture [`GetApnsVoipChannelInput`](crate::input::GetApnsVoipChannelInput)
    pub fn builder() -> crate::input::get_apns_voip_channel_input::Builder {
        crate::input::get_apns_voip_channel_input::Builder::default()
    }
    /// Creates a new `GetApnsVoipChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApnsVoipChannel {
    type Output = std::result::Result<
        crate::output::GetApnsVoipChannelOutput,
        crate::error::GetApnsVoipChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apns_voip_channel_error(response)
        } else {
            crate::operation_deser::parse_get_apns_voip_channel_response(response)
        }
    }
}

/// Operation shape for `GetApnsVoipSandboxChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apns_voip_sandbox_channel`](crate::client::Client::get_apns_voip_sandbox_channel).
///
/// See [`crate::client::fluent_builders::GetApnsVoipSandboxChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApnsVoipSandboxChannel {
    _private: (),
}
impl GetApnsVoipSandboxChannel {
    /// Creates a new builder-style object to manufacture [`GetApnsVoipSandboxChannelInput`](crate::input::GetApnsVoipSandboxChannelInput)
    pub fn builder() -> crate::input::get_apns_voip_sandbox_channel_input::Builder {
        crate::input::get_apns_voip_sandbox_channel_input::Builder::default()
    }
    /// Creates a new `GetApnsVoipSandboxChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApnsVoipSandboxChannel {
    type Output = std::result::Result<
        crate::output::GetApnsVoipSandboxChannelOutput,
        crate::error::GetApnsVoipSandboxChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apns_voip_sandbox_channel_error(response)
        } else {
            crate::operation_deser::parse_get_apns_voip_sandbox_channel_response(response)
        }
    }
}

/// Operation shape for `GetApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app`](crate::client::Client::get_app).
///
/// See [`crate::client::fluent_builders::GetApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApp {
    _private: (),
}
impl GetApp {
    /// Creates a new builder-style object to manufacture [`GetAppInput`](crate::input::GetAppInput)
    pub fn builder() -> crate::input::get_app_input::Builder {
        crate::input::get_app_input::Builder::default()
    }
    /// Creates a new `GetApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApp {
    type Output = std::result::Result<crate::output::GetAppOutput, crate::error::GetAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_error(response)
        } else {
            crate::operation_deser::parse_get_app_response(response)
        }
    }
}

/// Operation shape for `GetApplicationDateRangeKpi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_application_date_range_kpi`](crate::client::Client::get_application_date_range_kpi).
///
/// See [`crate::client::fluent_builders::GetApplicationDateRangeKpi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApplicationDateRangeKpi {
    _private: (),
}
impl GetApplicationDateRangeKpi {
    /// Creates a new builder-style object to manufacture [`GetApplicationDateRangeKpiInput`](crate::input::GetApplicationDateRangeKpiInput)
    pub fn builder() -> crate::input::get_application_date_range_kpi_input::Builder {
        crate::input::get_application_date_range_kpi_input::Builder::default()
    }
    /// Creates a new `GetApplicationDateRangeKpi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApplicationDateRangeKpi {
    type Output = std::result::Result<
        crate::output::GetApplicationDateRangeKpiOutput,
        crate::error::GetApplicationDateRangeKpiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_application_date_range_kpi_error(response)
        } else {
            crate::operation_deser::parse_get_application_date_range_kpi_response(response)
        }
    }
}

/// Operation shape for `GetApplicationSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_application_settings`](crate::client::Client::get_application_settings).
///
/// See [`crate::client::fluent_builders::GetApplicationSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApplicationSettings {
    _private: (),
}
impl GetApplicationSettings {
    /// Creates a new builder-style object to manufacture [`GetApplicationSettingsInput`](crate::input::GetApplicationSettingsInput)
    pub fn builder() -> crate::input::get_application_settings_input::Builder {
        crate::input::get_application_settings_input::Builder::default()
    }
    /// Creates a new `GetApplicationSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApplicationSettings {
    type Output = std::result::Result<
        crate::output::GetApplicationSettingsOutput,
        crate::error::GetApplicationSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_application_settings_error(response)
        } else {
            crate::operation_deser::parse_get_application_settings_response(response)
        }
    }
}

/// Operation shape for `GetApps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_apps`](crate::client::Client::get_apps).
///
/// See [`crate::client::fluent_builders::GetApps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApps {
    _private: (),
}
impl GetApps {
    /// Creates a new builder-style object to manufacture [`GetAppsInput`](crate::input::GetAppsInput)
    pub fn builder() -> crate::input::get_apps_input::Builder {
        crate::input::get_apps_input::Builder::default()
    }
    /// Creates a new `GetApps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApps {
    type Output = std::result::Result<crate::output::GetAppsOutput, crate::error::GetAppsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_apps_error(response)
        } else {
            crate::operation_deser::parse_get_apps_response(response)
        }
    }
}

/// Operation shape for `GetBaiduChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_baidu_channel`](crate::client::Client::get_baidu_channel).
///
/// See [`crate::client::fluent_builders::GetBaiduChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBaiduChannel {
    _private: (),
}
impl GetBaiduChannel {
    /// Creates a new builder-style object to manufacture [`GetBaiduChannelInput`](crate::input::GetBaiduChannelInput)
    pub fn builder() -> crate::input::get_baidu_channel_input::Builder {
        crate::input::get_baidu_channel_input::Builder::default()
    }
    /// Creates a new `GetBaiduChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBaiduChannel {
    type Output = std::result::Result<
        crate::output::GetBaiduChannelOutput,
        crate::error::GetBaiduChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_baidu_channel_error(response)
        } else {
            crate::operation_deser::parse_get_baidu_channel_response(response)
        }
    }
}

/// Operation shape for `GetCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_campaign`](crate::client::Client::get_campaign).
///
/// See [`crate::client::fluent_builders::GetCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCampaign {
    _private: (),
}
impl GetCampaign {
    /// Creates a new builder-style object to manufacture [`GetCampaignInput`](crate::input::GetCampaignInput)
    pub fn builder() -> crate::input::get_campaign_input::Builder {
        crate::input::get_campaign_input::Builder::default()
    }
    /// Creates a new `GetCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCampaign {
    type Output =
        std::result::Result<crate::output::GetCampaignOutput, crate::error::GetCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_campaign_error(response)
        } else {
            crate::operation_deser::parse_get_campaign_response(response)
        }
    }
}

/// Operation shape for `GetCampaignActivities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_campaign_activities`](crate::client::Client::get_campaign_activities).
///
/// See [`crate::client::fluent_builders::GetCampaignActivities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCampaignActivities {
    _private: (),
}
impl GetCampaignActivities {
    /// Creates a new builder-style object to manufacture [`GetCampaignActivitiesInput`](crate::input::GetCampaignActivitiesInput)
    pub fn builder() -> crate::input::get_campaign_activities_input::Builder {
        crate::input::get_campaign_activities_input::Builder::default()
    }
    /// Creates a new `GetCampaignActivities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCampaignActivities {
    type Output = std::result::Result<
        crate::output::GetCampaignActivitiesOutput,
        crate::error::GetCampaignActivitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_campaign_activities_error(response)
        } else {
            crate::operation_deser::parse_get_campaign_activities_response(response)
        }
    }
}

/// Operation shape for `GetCampaignDateRangeKpi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_campaign_date_range_kpi`](crate::client::Client::get_campaign_date_range_kpi).
///
/// See [`crate::client::fluent_builders::GetCampaignDateRangeKpi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCampaignDateRangeKpi {
    _private: (),
}
impl GetCampaignDateRangeKpi {
    /// Creates a new builder-style object to manufacture [`GetCampaignDateRangeKpiInput`](crate::input::GetCampaignDateRangeKpiInput)
    pub fn builder() -> crate::input::get_campaign_date_range_kpi_input::Builder {
        crate::input::get_campaign_date_range_kpi_input::Builder::default()
    }
    /// Creates a new `GetCampaignDateRangeKpi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCampaignDateRangeKpi {
    type Output = std::result::Result<
        crate::output::GetCampaignDateRangeKpiOutput,
        crate::error::GetCampaignDateRangeKpiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_campaign_date_range_kpi_error(response)
        } else {
            crate::operation_deser::parse_get_campaign_date_range_kpi_response(response)
        }
    }
}

/// Operation shape for `GetCampaigns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_campaigns`](crate::client::Client::get_campaigns).
///
/// See [`crate::client::fluent_builders::GetCampaigns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCampaigns {
    _private: (),
}
impl GetCampaigns {
    /// Creates a new builder-style object to manufacture [`GetCampaignsInput`](crate::input::GetCampaignsInput)
    pub fn builder() -> crate::input::get_campaigns_input::Builder {
        crate::input::get_campaigns_input::Builder::default()
    }
    /// Creates a new `GetCampaigns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCampaigns {
    type Output =
        std::result::Result<crate::output::GetCampaignsOutput, crate::error::GetCampaignsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_campaigns_error(response)
        } else {
            crate::operation_deser::parse_get_campaigns_response(response)
        }
    }
}

/// Operation shape for `GetCampaignVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_campaign_version`](crate::client::Client::get_campaign_version).
///
/// See [`crate::client::fluent_builders::GetCampaignVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCampaignVersion {
    _private: (),
}
impl GetCampaignVersion {
    /// Creates a new builder-style object to manufacture [`GetCampaignVersionInput`](crate::input::GetCampaignVersionInput)
    pub fn builder() -> crate::input::get_campaign_version_input::Builder {
        crate::input::get_campaign_version_input::Builder::default()
    }
    /// Creates a new `GetCampaignVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCampaignVersion {
    type Output = std::result::Result<
        crate::output::GetCampaignVersionOutput,
        crate::error::GetCampaignVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_campaign_version_error(response)
        } else {
            crate::operation_deser::parse_get_campaign_version_response(response)
        }
    }
}

/// Operation shape for `GetCampaignVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_campaign_versions`](crate::client::Client::get_campaign_versions).
///
/// See [`crate::client::fluent_builders::GetCampaignVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCampaignVersions {
    _private: (),
}
impl GetCampaignVersions {
    /// Creates a new builder-style object to manufacture [`GetCampaignVersionsInput`](crate::input::GetCampaignVersionsInput)
    pub fn builder() -> crate::input::get_campaign_versions_input::Builder {
        crate::input::get_campaign_versions_input::Builder::default()
    }
    /// Creates a new `GetCampaignVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCampaignVersions {
    type Output = std::result::Result<
        crate::output::GetCampaignVersionsOutput,
        crate::error::GetCampaignVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_campaign_versions_error(response)
        } else {
            crate::operation_deser::parse_get_campaign_versions_response(response)
        }
    }
}

/// Operation shape for `GetChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_channels`](crate::client::Client::get_channels).
///
/// See [`crate::client::fluent_builders::GetChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChannels {
    _private: (),
}
impl GetChannels {
    /// Creates a new builder-style object to manufacture [`GetChannelsInput`](crate::input::GetChannelsInput)
    pub fn builder() -> crate::input::get_channels_input::Builder {
        crate::input::get_channels_input::Builder::default()
    }
    /// Creates a new `GetChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChannels {
    type Output =
        std::result::Result<crate::output::GetChannelsOutput, crate::error::GetChannelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_channels_error(response)
        } else {
            crate::operation_deser::parse_get_channels_response(response)
        }
    }
}

/// Operation shape for `GetEmailChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_email_channel`](crate::client::Client::get_email_channel).
///
/// See [`crate::client::fluent_builders::GetEmailChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEmailChannel {
    _private: (),
}
impl GetEmailChannel {
    /// Creates a new builder-style object to manufacture [`GetEmailChannelInput`](crate::input::GetEmailChannelInput)
    pub fn builder() -> crate::input::get_email_channel_input::Builder {
        crate::input::get_email_channel_input::Builder::default()
    }
    /// Creates a new `GetEmailChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEmailChannel {
    type Output = std::result::Result<
        crate::output::GetEmailChannelOutput,
        crate::error::GetEmailChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_email_channel_error(response)
        } else {
            crate::operation_deser::parse_get_email_channel_response(response)
        }
    }
}

/// Operation shape for `GetEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_email_template`](crate::client::Client::get_email_template).
///
/// See [`crate::client::fluent_builders::GetEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEmailTemplate {
    _private: (),
}
impl GetEmailTemplate {
    /// Creates a new builder-style object to manufacture [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
    pub fn builder() -> crate::input::get_email_template_input::Builder {
        crate::input::get_email_template_input::Builder::default()
    }
    /// Creates a new `GetEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEmailTemplate {
    type Output = std::result::Result<
        crate::output::GetEmailTemplateOutput,
        crate::error::GetEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_email_template_error(response)
        } else {
            crate::operation_deser::parse_get_email_template_response(response)
        }
    }
}

/// Operation shape for `GetEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_endpoint`](crate::client::Client::get_endpoint).
///
/// See [`crate::client::fluent_builders::GetEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEndpoint {
    _private: (),
}
impl GetEndpoint {
    /// Creates a new builder-style object to manufacture [`GetEndpointInput`](crate::input::GetEndpointInput)
    pub fn builder() -> crate::input::get_endpoint_input::Builder {
        crate::input::get_endpoint_input::Builder::default()
    }
    /// Creates a new `GetEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEndpoint {
    type Output =
        std::result::Result<crate::output::GetEndpointOutput, crate::error::GetEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetEventStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_event_stream`](crate::client::Client::get_event_stream).
///
/// See [`crate::client::fluent_builders::GetEventStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEventStream {
    _private: (),
}
impl GetEventStream {
    /// Creates a new builder-style object to manufacture [`GetEventStreamInput`](crate::input::GetEventStreamInput)
    pub fn builder() -> crate::input::get_event_stream_input::Builder {
        crate::input::get_event_stream_input::Builder::default()
    }
    /// Creates a new `GetEventStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEventStream {
    type Output =
        std::result::Result<crate::output::GetEventStreamOutput, crate::error::GetEventStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_event_stream_error(response)
        } else {
            crate::operation_deser::parse_get_event_stream_response(response)
        }
    }
}

/// Operation shape for `GetExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_export_job`](crate::client::Client::get_export_job).
///
/// See [`crate::client::fluent_builders::GetExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExportJob {
    _private: (),
}
impl GetExportJob {
    /// Creates a new builder-style object to manufacture [`GetExportJobInput`](crate::input::GetExportJobInput)
    pub fn builder() -> crate::input::get_export_job_input::Builder {
        crate::input::get_export_job_input::Builder::default()
    }
    /// Creates a new `GetExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExportJob {
    type Output =
        std::result::Result<crate::output::GetExportJobOutput, crate::error::GetExportJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_export_job_error(response)
        } else {
            crate::operation_deser::parse_get_export_job_response(response)
        }
    }
}

/// Operation shape for `GetExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_export_jobs`](crate::client::Client::get_export_jobs).
///
/// See [`crate::client::fluent_builders::GetExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExportJobs {
    _private: (),
}
impl GetExportJobs {
    /// Creates a new builder-style object to manufacture [`GetExportJobsInput`](crate::input::GetExportJobsInput)
    pub fn builder() -> crate::input::get_export_jobs_input::Builder {
        crate::input::get_export_jobs_input::Builder::default()
    }
    /// Creates a new `GetExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExportJobs {
    type Output =
        std::result::Result<crate::output::GetExportJobsOutput, crate::error::GetExportJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_export_jobs_response(response)
        }
    }
}

/// Operation shape for `GetGcmChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_gcm_channel`](crate::client::Client::get_gcm_channel).
///
/// See [`crate::client::fluent_builders::GetGcmChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGcmChannel {
    _private: (),
}
impl GetGcmChannel {
    /// Creates a new builder-style object to manufacture [`GetGcmChannelInput`](crate::input::GetGcmChannelInput)
    pub fn builder() -> crate::input::get_gcm_channel_input::Builder {
        crate::input::get_gcm_channel_input::Builder::default()
    }
    /// Creates a new `GetGcmChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGcmChannel {
    type Output =
        std::result::Result<crate::output::GetGcmChannelOutput, crate::error::GetGcmChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_gcm_channel_error(response)
        } else {
            crate::operation_deser::parse_get_gcm_channel_response(response)
        }
    }
}

/// Operation shape for `GetImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_import_job`](crate::client::Client::get_import_job).
///
/// See [`crate::client::fluent_builders::GetImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImportJob {
    _private: (),
}
impl GetImportJob {
    /// Creates a new builder-style object to manufacture [`GetImportJobInput`](crate::input::GetImportJobInput)
    pub fn builder() -> crate::input::get_import_job_input::Builder {
        crate::input::get_import_job_input::Builder::default()
    }
    /// Creates a new `GetImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImportJob {
    type Output =
        std::result::Result<crate::output::GetImportJobOutput, crate::error::GetImportJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_import_job_error(response)
        } else {
            crate::operation_deser::parse_get_import_job_response(response)
        }
    }
}

/// Operation shape for `GetImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_import_jobs`](crate::client::Client::get_import_jobs).
///
/// See [`crate::client::fluent_builders::GetImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImportJobs {
    _private: (),
}
impl GetImportJobs {
    /// Creates a new builder-style object to manufacture [`GetImportJobsInput`](crate::input::GetImportJobsInput)
    pub fn builder() -> crate::input::get_import_jobs_input::Builder {
        crate::input::get_import_jobs_input::Builder::default()
    }
    /// Creates a new `GetImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImportJobs {
    type Output =
        std::result::Result<crate::output::GetImportJobsOutput, crate::error::GetImportJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_import_jobs_response(response)
        }
    }
}

/// Operation shape for `GetInAppMessages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_in_app_messages`](crate::client::Client::get_in_app_messages).
///
/// See [`crate::client::fluent_builders::GetInAppMessages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInAppMessages {
    _private: (),
}
impl GetInAppMessages {
    /// Creates a new builder-style object to manufacture [`GetInAppMessagesInput`](crate::input::GetInAppMessagesInput)
    pub fn builder() -> crate::input::get_in_app_messages_input::Builder {
        crate::input::get_in_app_messages_input::Builder::default()
    }
    /// Creates a new `GetInAppMessages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInAppMessages {
    type Output = std::result::Result<
        crate::output::GetInAppMessagesOutput,
        crate::error::GetInAppMessagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_in_app_messages_error(response)
        } else {
            crate::operation_deser::parse_get_in_app_messages_response(response)
        }
    }
}

/// Operation shape for `GetInAppTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_in_app_template`](crate::client::Client::get_in_app_template).
///
/// See [`crate::client::fluent_builders::GetInAppTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInAppTemplate {
    _private: (),
}
impl GetInAppTemplate {
    /// Creates a new builder-style object to manufacture [`GetInAppTemplateInput`](crate::input::GetInAppTemplateInput)
    pub fn builder() -> crate::input::get_in_app_template_input::Builder {
        crate::input::get_in_app_template_input::Builder::default()
    }
    /// Creates a new `GetInAppTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInAppTemplate {
    type Output = std::result::Result<
        crate::output::GetInAppTemplateOutput,
        crate::error::GetInAppTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_in_app_template_error(response)
        } else {
            crate::operation_deser::parse_get_in_app_template_response(response)
        }
    }
}

/// Operation shape for `GetJourney`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_journey`](crate::client::Client::get_journey).
///
/// See [`crate::client::fluent_builders::GetJourney`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJourney {
    _private: (),
}
impl GetJourney {
    /// Creates a new builder-style object to manufacture [`GetJourneyInput`](crate::input::GetJourneyInput)
    pub fn builder() -> crate::input::get_journey_input::Builder {
        crate::input::get_journey_input::Builder::default()
    }
    /// Creates a new `GetJourney` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJourney {
    type Output =
        std::result::Result<crate::output::GetJourneyOutput, crate::error::GetJourneyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_journey_error(response)
        } else {
            crate::operation_deser::parse_get_journey_response(response)
        }
    }
}

/// Operation shape for `GetJourneyDateRangeKpi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_journey_date_range_kpi`](crate::client::Client::get_journey_date_range_kpi).
///
/// See [`crate::client::fluent_builders::GetJourneyDateRangeKpi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJourneyDateRangeKpi {
    _private: (),
}
impl GetJourneyDateRangeKpi {
    /// Creates a new builder-style object to manufacture [`GetJourneyDateRangeKpiInput`](crate::input::GetJourneyDateRangeKpiInput)
    pub fn builder() -> crate::input::get_journey_date_range_kpi_input::Builder {
        crate::input::get_journey_date_range_kpi_input::Builder::default()
    }
    /// Creates a new `GetJourneyDateRangeKpi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJourneyDateRangeKpi {
    type Output = std::result::Result<
        crate::output::GetJourneyDateRangeKpiOutput,
        crate::error::GetJourneyDateRangeKpiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_journey_date_range_kpi_error(response)
        } else {
            crate::operation_deser::parse_get_journey_date_range_kpi_response(response)
        }
    }
}

/// Operation shape for `GetJourneyExecutionActivityMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_journey_execution_activity_metrics`](crate::client::Client::get_journey_execution_activity_metrics).
///
/// See [`crate::client::fluent_builders::GetJourneyExecutionActivityMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJourneyExecutionActivityMetrics {
    _private: (),
}
impl GetJourneyExecutionActivityMetrics {
    /// Creates a new builder-style object to manufacture [`GetJourneyExecutionActivityMetricsInput`](crate::input::GetJourneyExecutionActivityMetricsInput)
    pub fn builder() -> crate::input::get_journey_execution_activity_metrics_input::Builder {
        crate::input::get_journey_execution_activity_metrics_input::Builder::default()
    }
    /// Creates a new `GetJourneyExecutionActivityMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJourneyExecutionActivityMetrics {
    type Output = std::result::Result<
        crate::output::GetJourneyExecutionActivityMetricsOutput,
        crate::error::GetJourneyExecutionActivityMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_journey_execution_activity_metrics_error(response)
        } else {
            crate::operation_deser::parse_get_journey_execution_activity_metrics_response(response)
        }
    }
}

/// Operation shape for `GetJourneyExecutionMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_journey_execution_metrics`](crate::client::Client::get_journey_execution_metrics).
///
/// See [`crate::client::fluent_builders::GetJourneyExecutionMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJourneyExecutionMetrics {
    _private: (),
}
impl GetJourneyExecutionMetrics {
    /// Creates a new builder-style object to manufacture [`GetJourneyExecutionMetricsInput`](crate::input::GetJourneyExecutionMetricsInput)
    pub fn builder() -> crate::input::get_journey_execution_metrics_input::Builder {
        crate::input::get_journey_execution_metrics_input::Builder::default()
    }
    /// Creates a new `GetJourneyExecutionMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJourneyExecutionMetrics {
    type Output = std::result::Result<
        crate::output::GetJourneyExecutionMetricsOutput,
        crate::error::GetJourneyExecutionMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_journey_execution_metrics_error(response)
        } else {
            crate::operation_deser::parse_get_journey_execution_metrics_response(response)
        }
    }
}

/// Operation shape for `GetPushTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_push_template`](crate::client::Client::get_push_template).
///
/// See [`crate::client::fluent_builders::GetPushTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPushTemplate {
    _private: (),
}
impl GetPushTemplate {
    /// Creates a new builder-style object to manufacture [`GetPushTemplateInput`](crate::input::GetPushTemplateInput)
    pub fn builder() -> crate::input::get_push_template_input::Builder {
        crate::input::get_push_template_input::Builder::default()
    }
    /// Creates a new `GetPushTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPushTemplate {
    type Output = std::result::Result<
        crate::output::GetPushTemplateOutput,
        crate::error::GetPushTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_push_template_error(response)
        } else {
            crate::operation_deser::parse_get_push_template_response(response)
        }
    }
}

/// Operation shape for `GetRecommenderConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recommender_configuration`](crate::client::Client::get_recommender_configuration).
///
/// See [`crate::client::fluent_builders::GetRecommenderConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecommenderConfiguration {
    _private: (),
}
impl GetRecommenderConfiguration {
    /// Creates a new builder-style object to manufacture [`GetRecommenderConfigurationInput`](crate::input::GetRecommenderConfigurationInput)
    pub fn builder() -> crate::input::get_recommender_configuration_input::Builder {
        crate::input::get_recommender_configuration_input::Builder::default()
    }
    /// Creates a new `GetRecommenderConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecommenderConfiguration {
    type Output = std::result::Result<
        crate::output::GetRecommenderConfigurationOutput,
        crate::error::GetRecommenderConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recommender_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_recommender_configuration_response(response)
        }
    }
}

/// Operation shape for `GetRecommenderConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recommender_configurations`](crate::client::Client::get_recommender_configurations).
///
/// See [`crate::client::fluent_builders::GetRecommenderConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecommenderConfigurations {
    _private: (),
}
impl GetRecommenderConfigurations {
    /// Creates a new builder-style object to manufacture [`GetRecommenderConfigurationsInput`](crate::input::GetRecommenderConfigurationsInput)
    pub fn builder() -> crate::input::get_recommender_configurations_input::Builder {
        crate::input::get_recommender_configurations_input::Builder::default()
    }
    /// Creates a new `GetRecommenderConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecommenderConfigurations {
    type Output = std::result::Result<
        crate::output::GetRecommenderConfigurationsOutput,
        crate::error::GetRecommenderConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recommender_configurations_error(response)
        } else {
            crate::operation_deser::parse_get_recommender_configurations_response(response)
        }
    }
}

/// Operation shape for `GetSegment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segment`](crate::client::Client::get_segment).
///
/// See [`crate::client::fluent_builders::GetSegment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegment {
    _private: (),
}
impl GetSegment {
    /// Creates a new builder-style object to manufacture [`GetSegmentInput`](crate::input::GetSegmentInput)
    pub fn builder() -> crate::input::get_segment_input::Builder {
        crate::input::get_segment_input::Builder::default()
    }
    /// Creates a new `GetSegment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegment {
    type Output =
        std::result::Result<crate::output::GetSegmentOutput, crate::error::GetSegmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segment_error(response)
        } else {
            crate::operation_deser::parse_get_segment_response(response)
        }
    }
}

/// Operation shape for `GetSegmentExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segment_export_jobs`](crate::client::Client::get_segment_export_jobs).
///
/// See [`crate::client::fluent_builders::GetSegmentExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegmentExportJobs {
    _private: (),
}
impl GetSegmentExportJobs {
    /// Creates a new builder-style object to manufacture [`GetSegmentExportJobsInput`](crate::input::GetSegmentExportJobsInput)
    pub fn builder() -> crate::input::get_segment_export_jobs_input::Builder {
        crate::input::get_segment_export_jobs_input::Builder::default()
    }
    /// Creates a new `GetSegmentExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegmentExportJobs {
    type Output = std::result::Result<
        crate::output::GetSegmentExportJobsOutput,
        crate::error::GetSegmentExportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segment_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_segment_export_jobs_response(response)
        }
    }
}

/// Operation shape for `GetSegmentImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segment_import_jobs`](crate::client::Client::get_segment_import_jobs).
///
/// See [`crate::client::fluent_builders::GetSegmentImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegmentImportJobs {
    _private: (),
}
impl GetSegmentImportJobs {
    /// Creates a new builder-style object to manufacture [`GetSegmentImportJobsInput`](crate::input::GetSegmentImportJobsInput)
    pub fn builder() -> crate::input::get_segment_import_jobs_input::Builder {
        crate::input::get_segment_import_jobs_input::Builder::default()
    }
    /// Creates a new `GetSegmentImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegmentImportJobs {
    type Output = std::result::Result<
        crate::output::GetSegmentImportJobsOutput,
        crate::error::GetSegmentImportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segment_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_segment_import_jobs_response(response)
        }
    }
}

/// Operation shape for `GetSegments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segments`](crate::client::Client::get_segments).
///
/// See [`crate::client::fluent_builders::GetSegments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegments {
    _private: (),
}
impl GetSegments {
    /// Creates a new builder-style object to manufacture [`GetSegmentsInput`](crate::input::GetSegmentsInput)
    pub fn builder() -> crate::input::get_segments_input::Builder {
        crate::input::get_segments_input::Builder::default()
    }
    /// Creates a new `GetSegments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegments {
    type Output =
        std::result::Result<crate::output::GetSegmentsOutput, crate::error::GetSegmentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segments_error(response)
        } else {
            crate::operation_deser::parse_get_segments_response(response)
        }
    }
}

/// Operation shape for `GetSegmentVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segment_version`](crate::client::Client::get_segment_version).
///
/// See [`crate::client::fluent_builders::GetSegmentVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegmentVersion {
    _private: (),
}
impl GetSegmentVersion {
    /// Creates a new builder-style object to manufacture [`GetSegmentVersionInput`](crate::input::GetSegmentVersionInput)
    pub fn builder() -> crate::input::get_segment_version_input::Builder {
        crate::input::get_segment_version_input::Builder::default()
    }
    /// Creates a new `GetSegmentVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegmentVersion {
    type Output = std::result::Result<
        crate::output::GetSegmentVersionOutput,
        crate::error::GetSegmentVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segment_version_error(response)
        } else {
            crate::operation_deser::parse_get_segment_version_response(response)
        }
    }
}

/// Operation shape for `GetSegmentVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segment_versions`](crate::client::Client::get_segment_versions).
///
/// See [`crate::client::fluent_builders::GetSegmentVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegmentVersions {
    _private: (),
}
impl GetSegmentVersions {
    /// Creates a new builder-style object to manufacture [`GetSegmentVersionsInput`](crate::input::GetSegmentVersionsInput)
    pub fn builder() -> crate::input::get_segment_versions_input::Builder {
        crate::input::get_segment_versions_input::Builder::default()
    }
    /// Creates a new `GetSegmentVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegmentVersions {
    type Output = std::result::Result<
        crate::output::GetSegmentVersionsOutput,
        crate::error::GetSegmentVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segment_versions_error(response)
        } else {
            crate::operation_deser::parse_get_segment_versions_response(response)
        }
    }
}

/// Operation shape for `GetSmsChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sms_channel`](crate::client::Client::get_sms_channel).
///
/// See [`crate::client::fluent_builders::GetSmsChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSmsChannel {
    _private: (),
}
impl GetSmsChannel {
    /// Creates a new builder-style object to manufacture [`GetSmsChannelInput`](crate::input::GetSmsChannelInput)
    pub fn builder() -> crate::input::get_sms_channel_input::Builder {
        crate::input::get_sms_channel_input::Builder::default()
    }
    /// Creates a new `GetSmsChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSmsChannel {
    type Output =
        std::result::Result<crate::output::GetSmsChannelOutput, crate::error::GetSmsChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sms_channel_error(response)
        } else {
            crate::operation_deser::parse_get_sms_channel_response(response)
        }
    }
}

/// Operation shape for `GetSmsTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sms_template`](crate::client::Client::get_sms_template).
///
/// See [`crate::client::fluent_builders::GetSmsTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSmsTemplate {
    _private: (),
}
impl GetSmsTemplate {
    /// Creates a new builder-style object to manufacture [`GetSmsTemplateInput`](crate::input::GetSmsTemplateInput)
    pub fn builder() -> crate::input::get_sms_template_input::Builder {
        crate::input::get_sms_template_input::Builder::default()
    }
    /// Creates a new `GetSmsTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSmsTemplate {
    type Output =
        std::result::Result<crate::output::GetSmsTemplateOutput, crate::error::GetSmsTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sms_template_error(response)
        } else {
            crate::operation_deser::parse_get_sms_template_response(response)
        }
    }
}

/// Operation shape for `GetUserEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_endpoints`](crate::client::Client::get_user_endpoints).
///
/// See [`crate::client::fluent_builders::GetUserEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserEndpoints {
    _private: (),
}
impl GetUserEndpoints {
    /// Creates a new builder-style object to manufacture [`GetUserEndpointsInput`](crate::input::GetUserEndpointsInput)
    pub fn builder() -> crate::input::get_user_endpoints_input::Builder {
        crate::input::get_user_endpoints_input::Builder::default()
    }
    /// Creates a new `GetUserEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserEndpoints {
    type Output = std::result::Result<
        crate::output::GetUserEndpointsOutput,
        crate::error::GetUserEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_endpoints_error(response)
        } else {
            crate::operation_deser::parse_get_user_endpoints_response(response)
        }
    }
}

/// Operation shape for `GetVoiceChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_channel`](crate::client::Client::get_voice_channel).
///
/// See [`crate::client::fluent_builders::GetVoiceChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceChannel {
    _private: (),
}
impl GetVoiceChannel {
    /// Creates a new builder-style object to manufacture [`GetVoiceChannelInput`](crate::input::GetVoiceChannelInput)
    pub fn builder() -> crate::input::get_voice_channel_input::Builder {
        crate::input::get_voice_channel_input::Builder::default()
    }
    /// Creates a new `GetVoiceChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceChannel {
    type Output = std::result::Result<
        crate::output::GetVoiceChannelOutput,
        crate::error::GetVoiceChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_channel_error(response)
        } else {
            crate::operation_deser::parse_get_voice_channel_response(response)
        }
    }
}

/// Operation shape for `GetVoiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_template`](crate::client::Client::get_voice_template).
///
/// See [`crate::client::fluent_builders::GetVoiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceTemplate {
    _private: (),
}
impl GetVoiceTemplate {
    /// Creates a new builder-style object to manufacture [`GetVoiceTemplateInput`](crate::input::GetVoiceTemplateInput)
    pub fn builder() -> crate::input::get_voice_template_input::Builder {
        crate::input::get_voice_template_input::Builder::default()
    }
    /// Creates a new `GetVoiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceTemplate {
    type Output = std::result::Result<
        crate::output::GetVoiceTemplateOutput,
        crate::error::GetVoiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_template_error(response)
        } else {
            crate::operation_deser::parse_get_voice_template_response(response)
        }
    }
}

/// Operation shape for `ListJourneys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_journeys`](crate::client::Client::list_journeys).
///
/// See [`crate::client::fluent_builders::ListJourneys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJourneys {
    _private: (),
}
impl ListJourneys {
    /// Creates a new builder-style object to manufacture [`ListJourneysInput`](crate::input::ListJourneysInput)
    pub fn builder() -> crate::input::list_journeys_input::Builder {
        crate::input::list_journeys_input::Builder::default()
    }
    /// Creates a new `ListJourneys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJourneys {
    type Output =
        std::result::Result<crate::output::ListJourneysOutput, crate::error::ListJourneysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_journeys_error(response)
        } else {
            crate::operation_deser::parse_list_journeys_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_templates`](crate::client::Client::list_templates).
///
/// See [`crate::client::fluent_builders::ListTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTemplates {
    _private: (),
}
impl ListTemplates {
    /// Creates a new builder-style object to manufacture [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    pub fn builder() -> crate::input::list_templates_input::Builder {
        crate::input::list_templates_input::Builder::default()
    }
    /// Creates a new `ListTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTemplates {
    type Output =
        std::result::Result<crate::output::ListTemplatesOutput, crate::error::ListTemplatesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_templates_error(response)
        } else {
            crate::operation_deser::parse_list_templates_response(response)
        }
    }
}

/// Operation shape for `ListTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_template_versions`](crate::client::Client::list_template_versions).
///
/// See [`crate::client::fluent_builders::ListTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTemplateVersions {
    _private: (),
}
impl ListTemplateVersions {
    /// Creates a new builder-style object to manufacture [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
    pub fn builder() -> crate::input::list_template_versions_input::Builder {
        crate::input::list_template_versions_input::Builder::default()
    }
    /// Creates a new `ListTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTemplateVersions {
    type Output = std::result::Result<
        crate::output::ListTemplateVersionsOutput,
        crate::error::ListTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_template_versions_error(response)
        } else {
            crate::operation_deser::parse_list_template_versions_response(response)
        }
    }
}

/// Operation shape for `PhoneNumberValidate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`phone_number_validate`](crate::client::Client::phone_number_validate).
///
/// See [`crate::client::fluent_builders::PhoneNumberValidate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PhoneNumberValidate {
    _private: (),
}
impl PhoneNumberValidate {
    /// Creates a new builder-style object to manufacture [`PhoneNumberValidateInput`](crate::input::PhoneNumberValidateInput)
    pub fn builder() -> crate::input::phone_number_validate_input::Builder {
        crate::input::phone_number_validate_input::Builder::default()
    }
    /// Creates a new `PhoneNumberValidate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PhoneNumberValidate {
    type Output = std::result::Result<
        crate::output::PhoneNumberValidateOutput,
        crate::error::PhoneNumberValidateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_phone_number_validate_error(response)
        } else {
            crate::operation_deser::parse_phone_number_validate_response(response)
        }
    }
}

/// Operation shape for `PutEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_events`](crate::client::Client::put_events).
///
/// See [`crate::client::fluent_builders::PutEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEvents {
    _private: (),
}
impl PutEvents {
    /// Creates a new builder-style object to manufacture [`PutEventsInput`](crate::input::PutEventsInput)
    pub fn builder() -> crate::input::put_events_input::Builder {
        crate::input::put_events_input::Builder::default()
    }
    /// Creates a new `PutEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEvents {
    type Output = std::result::Result<crate::output::PutEventsOutput, crate::error::PutEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_put_events_error(response)
        } else {
            crate::operation_deser::parse_put_events_response(response)
        }
    }
}

/// Operation shape for `PutEventStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_event_stream`](crate::client::Client::put_event_stream).
///
/// See [`crate::client::fluent_builders::PutEventStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEventStream {
    _private: (),
}
impl PutEventStream {
    /// Creates a new builder-style object to manufacture [`PutEventStreamInput`](crate::input::PutEventStreamInput)
    pub fn builder() -> crate::input::put_event_stream_input::Builder {
        crate::input::put_event_stream_input::Builder::default()
    }
    /// Creates a new `PutEventStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEventStream {
    type Output =
        std::result::Result<crate::output::PutEventStreamOutput, crate::error::PutEventStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_event_stream_error(response)
        } else {
            crate::operation_deser::parse_put_event_stream_response(response)
        }
    }
}

/// Operation shape for `RemoveAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_attributes`](crate::client::Client::remove_attributes).
///
/// See [`crate::client::fluent_builders::RemoveAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAttributes {
    _private: (),
}
impl RemoveAttributes {
    /// Creates a new builder-style object to manufacture [`RemoveAttributesInput`](crate::input::RemoveAttributesInput)
    pub fn builder() -> crate::input::remove_attributes_input::Builder {
        crate::input::remove_attributes_input::Builder::default()
    }
    /// Creates a new `RemoveAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAttributes {
    type Output = std::result::Result<
        crate::output::RemoveAttributesOutput,
        crate::error::RemoveAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_attributes_error(response)
        } else {
            crate::operation_deser::parse_remove_attributes_response(response)
        }
    }
}

/// Operation shape for `SendMessages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_messages`](crate::client::Client::send_messages).
///
/// See [`crate::client::fluent_builders::SendMessages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendMessages {
    _private: (),
}
impl SendMessages {
    /// Creates a new builder-style object to manufacture [`SendMessagesInput`](crate::input::SendMessagesInput)
    pub fn builder() -> crate::input::send_messages_input::Builder {
        crate::input::send_messages_input::Builder::default()
    }
    /// Creates a new `SendMessages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendMessages {
    type Output =
        std::result::Result<crate::output::SendMessagesOutput, crate::error::SendMessagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_messages_error(response)
        } else {
            crate::operation_deser::parse_send_messages_response(response)
        }
    }
}

/// Operation shape for `SendOTPMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_otp_message`](crate::client::Client::send_otp_message).
///
/// See [`crate::client::fluent_builders::SendOTPMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendOTPMessage {
    _private: (),
}
impl SendOTPMessage {
    /// Creates a new builder-style object to manufacture [`SendOtpMessageInput`](crate::input::SendOtpMessageInput)
    pub fn builder() -> crate::input::send_otp_message_input::Builder {
        crate::input::send_otp_message_input::Builder::default()
    }
    /// Creates a new `SendOTPMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendOTPMessage {
    type Output =
        std::result::Result<crate::output::SendOtpMessageOutput, crate::error::SendOTPMessageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_otp_message_error(response)
        } else {
            crate::operation_deser::parse_send_otp_message_response(response)
        }
    }
}

/// Operation shape for `SendUsersMessages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_users_messages`](crate::client::Client::send_users_messages).
///
/// See [`crate::client::fluent_builders::SendUsersMessages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendUsersMessages {
    _private: (),
}
impl SendUsersMessages {
    /// Creates a new builder-style object to manufacture [`SendUsersMessagesInput`](crate::input::SendUsersMessagesInput)
    pub fn builder() -> crate::input::send_users_messages_input::Builder {
        crate::input::send_users_messages_input::Builder::default()
    }
    /// Creates a new `SendUsersMessages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendUsersMessages {
    type Output = std::result::Result<
        crate::output::SendUsersMessagesOutput,
        crate::error::SendUsersMessagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_users_messages_error(response)
        } else {
            crate::operation_deser::parse_send_users_messages_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAdmChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_adm_channel`](crate::client::Client::update_adm_channel).
///
/// See [`crate::client::fluent_builders::UpdateAdmChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAdmChannel {
    _private: (),
}
impl UpdateAdmChannel {
    /// Creates a new builder-style object to manufacture [`UpdateAdmChannelInput`](crate::input::UpdateAdmChannelInput)
    pub fn builder() -> crate::input::update_adm_channel_input::Builder {
        crate::input::update_adm_channel_input::Builder::default()
    }
    /// Creates a new `UpdateAdmChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAdmChannel {
    type Output = std::result::Result<
        crate::output::UpdateAdmChannelOutput,
        crate::error::UpdateAdmChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_adm_channel_error(response)
        } else {
            crate::operation_deser::parse_update_adm_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateApnsChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_apns_channel`](crate::client::Client::update_apns_channel).
///
/// See [`crate::client::fluent_builders::UpdateApnsChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApnsChannel {
    _private: (),
}
impl UpdateApnsChannel {
    /// Creates a new builder-style object to manufacture [`UpdateApnsChannelInput`](crate::input::UpdateApnsChannelInput)
    pub fn builder() -> crate::input::update_apns_channel_input::Builder {
        crate::input::update_apns_channel_input::Builder::default()
    }
    /// Creates a new `UpdateApnsChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApnsChannel {
    type Output = std::result::Result<
        crate::output::UpdateApnsChannelOutput,
        crate::error::UpdateApnsChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_apns_channel_error(response)
        } else {
            crate::operation_deser::parse_update_apns_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateApnsSandboxChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_apns_sandbox_channel`](crate::client::Client::update_apns_sandbox_channel).
///
/// See [`crate::client::fluent_builders::UpdateApnsSandboxChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApnsSandboxChannel {
    _private: (),
}
impl UpdateApnsSandboxChannel {
    /// Creates a new builder-style object to manufacture [`UpdateApnsSandboxChannelInput`](crate::input::UpdateApnsSandboxChannelInput)
    pub fn builder() -> crate::input::update_apns_sandbox_channel_input::Builder {
        crate::input::update_apns_sandbox_channel_input::Builder::default()
    }
    /// Creates a new `UpdateApnsSandboxChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApnsSandboxChannel {
    type Output = std::result::Result<
        crate::output::UpdateApnsSandboxChannelOutput,
        crate::error::UpdateApnsSandboxChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_apns_sandbox_channel_error(response)
        } else {
            crate::operation_deser::parse_update_apns_sandbox_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateApnsVoipChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_apns_voip_channel`](crate::client::Client::update_apns_voip_channel).
///
/// See [`crate::client::fluent_builders::UpdateApnsVoipChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApnsVoipChannel {
    _private: (),
}
impl UpdateApnsVoipChannel {
    /// Creates a new builder-style object to manufacture [`UpdateApnsVoipChannelInput`](crate::input::UpdateApnsVoipChannelInput)
    pub fn builder() -> crate::input::update_apns_voip_channel_input::Builder {
        crate::input::update_apns_voip_channel_input::Builder::default()
    }
    /// Creates a new `UpdateApnsVoipChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApnsVoipChannel {
    type Output = std::result::Result<
        crate::output::UpdateApnsVoipChannelOutput,
        crate::error::UpdateApnsVoipChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_apns_voip_channel_error(response)
        } else {
            crate::operation_deser::parse_update_apns_voip_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateApnsVoipSandboxChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_apns_voip_sandbox_channel`](crate::client::Client::update_apns_voip_sandbox_channel).
///
/// See [`crate::client::fluent_builders::UpdateApnsVoipSandboxChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApnsVoipSandboxChannel {
    _private: (),
}
impl UpdateApnsVoipSandboxChannel {
    /// Creates a new builder-style object to manufacture [`UpdateApnsVoipSandboxChannelInput`](crate::input::UpdateApnsVoipSandboxChannelInput)
    pub fn builder() -> crate::input::update_apns_voip_sandbox_channel_input::Builder {
        crate::input::update_apns_voip_sandbox_channel_input::Builder::default()
    }
    /// Creates a new `UpdateApnsVoipSandboxChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApnsVoipSandboxChannel {
    type Output = std::result::Result<
        crate::output::UpdateApnsVoipSandboxChannelOutput,
        crate::error::UpdateApnsVoipSandboxChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_apns_voip_sandbox_channel_error(response)
        } else {
            crate::operation_deser::parse_update_apns_voip_sandbox_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateApplicationSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application_settings`](crate::client::Client::update_application_settings).
///
/// See [`crate::client::fluent_builders::UpdateApplicationSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplicationSettings {
    _private: (),
}
impl UpdateApplicationSettings {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationSettingsInput`](crate::input::UpdateApplicationSettingsInput)
    pub fn builder() -> crate::input::update_application_settings_input::Builder {
        crate::input::update_application_settings_input::Builder::default()
    }
    /// Creates a new `UpdateApplicationSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplicationSettings {
    type Output = std::result::Result<
        crate::output::UpdateApplicationSettingsOutput,
        crate::error::UpdateApplicationSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_settings_error(response)
        } else {
            crate::operation_deser::parse_update_application_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateBaiduChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_baidu_channel`](crate::client::Client::update_baidu_channel).
///
/// See [`crate::client::fluent_builders::UpdateBaiduChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBaiduChannel {
    _private: (),
}
impl UpdateBaiduChannel {
    /// Creates a new builder-style object to manufacture [`UpdateBaiduChannelInput`](crate::input::UpdateBaiduChannelInput)
    pub fn builder() -> crate::input::update_baidu_channel_input::Builder {
        crate::input::update_baidu_channel_input::Builder::default()
    }
    /// Creates a new `UpdateBaiduChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBaiduChannel {
    type Output = std::result::Result<
        crate::output::UpdateBaiduChannelOutput,
        crate::error::UpdateBaiduChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_baidu_channel_error(response)
        } else {
            crate::operation_deser::parse_update_baidu_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_campaign`](crate::client::Client::update_campaign).
///
/// See [`crate::client::fluent_builders::UpdateCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCampaign {
    _private: (),
}
impl UpdateCampaign {
    /// Creates a new builder-style object to manufacture [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
    pub fn builder() -> crate::input::update_campaign_input::Builder {
        crate::input::update_campaign_input::Builder::default()
    }
    /// Creates a new `UpdateCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCampaign {
    type Output =
        std::result::Result<crate::output::UpdateCampaignOutput, crate::error::UpdateCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_campaign_error(response)
        } else {
            crate::operation_deser::parse_update_campaign_response(response)
        }
    }
}

/// Operation shape for `UpdateEmailChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_email_channel`](crate::client::Client::update_email_channel).
///
/// See [`crate::client::fluent_builders::UpdateEmailChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEmailChannel {
    _private: (),
}
impl UpdateEmailChannel {
    /// Creates a new builder-style object to manufacture [`UpdateEmailChannelInput`](crate::input::UpdateEmailChannelInput)
    pub fn builder() -> crate::input::update_email_channel_input::Builder {
        crate::input::update_email_channel_input::Builder::default()
    }
    /// Creates a new `UpdateEmailChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEmailChannel {
    type Output = std::result::Result<
        crate::output::UpdateEmailChannelOutput,
        crate::error::UpdateEmailChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_email_channel_error(response)
        } else {
            crate::operation_deser::parse_update_email_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_email_template`](crate::client::Client::update_email_template).
///
/// See [`crate::client::fluent_builders::UpdateEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEmailTemplate {
    _private: (),
}
impl UpdateEmailTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
    pub fn builder() -> crate::input::update_email_template_input::Builder {
        crate::input::update_email_template_input::Builder::default()
    }
    /// Creates a new `UpdateEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEmailTemplate {
    type Output = std::result::Result<
        crate::output::UpdateEmailTemplateOutput,
        crate::error::UpdateEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_email_template_error(response)
        } else {
            crate::operation_deser::parse_update_email_template_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoint`](crate::client::Client::update_endpoint).
///
/// See [`crate::client::fluent_builders::UpdateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpoint {
    _private: (),
}
impl UpdateEndpoint {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    pub fn builder() -> crate::input::update_endpoint_input::Builder {
        crate::input::update_endpoint_input::Builder::default()
    }
    /// Creates a new `UpdateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpoint {
    type Output =
        std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_endpoint_error(response)
        } else {
            crate::operation_deser::parse_update_endpoint_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpointsBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoints_batch`](crate::client::Client::update_endpoints_batch).
///
/// See [`crate::client::fluent_builders::UpdateEndpointsBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpointsBatch {
    _private: (),
}
impl UpdateEndpointsBatch {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointsBatchInput`](crate::input::UpdateEndpointsBatchInput)
    pub fn builder() -> crate::input::update_endpoints_batch_input::Builder {
        crate::input::update_endpoints_batch_input::Builder::default()
    }
    /// Creates a new `UpdateEndpointsBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpointsBatch {
    type Output = std::result::Result<
        crate::output::UpdateEndpointsBatchOutput,
        crate::error::UpdateEndpointsBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_endpoints_batch_error(response)
        } else {
            crate::operation_deser::parse_update_endpoints_batch_response(response)
        }
    }
}

/// Operation shape for `UpdateGcmChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gcm_channel`](crate::client::Client::update_gcm_channel).
///
/// See [`crate::client::fluent_builders::UpdateGcmChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGcmChannel {
    _private: (),
}
impl UpdateGcmChannel {
    /// Creates a new builder-style object to manufacture [`UpdateGcmChannelInput`](crate::input::UpdateGcmChannelInput)
    pub fn builder() -> crate::input::update_gcm_channel_input::Builder {
        crate::input::update_gcm_channel_input::Builder::default()
    }
    /// Creates a new `UpdateGcmChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGcmChannel {
    type Output = std::result::Result<
        crate::output::UpdateGcmChannelOutput,
        crate::error::UpdateGcmChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gcm_channel_error(response)
        } else {
            crate::operation_deser::parse_update_gcm_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateInAppTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_in_app_template`](crate::client::Client::update_in_app_template).
///
/// See [`crate::client::fluent_builders::UpdateInAppTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInAppTemplate {
    _private: (),
}
impl UpdateInAppTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateInAppTemplateInput`](crate::input::UpdateInAppTemplateInput)
    pub fn builder() -> crate::input::update_in_app_template_input::Builder {
        crate::input::update_in_app_template_input::Builder::default()
    }
    /// Creates a new `UpdateInAppTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInAppTemplate {
    type Output = std::result::Result<
        crate::output::UpdateInAppTemplateOutput,
        crate::error::UpdateInAppTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_in_app_template_error(response)
        } else {
            crate::operation_deser::parse_update_in_app_template_response(response)
        }
    }
}

/// Operation shape for `UpdateJourney`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_journey`](crate::client::Client::update_journey).
///
/// See [`crate::client::fluent_builders::UpdateJourney`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJourney {
    _private: (),
}
impl UpdateJourney {
    /// Creates a new builder-style object to manufacture [`UpdateJourneyInput`](crate::input::UpdateJourneyInput)
    pub fn builder() -> crate::input::update_journey_input::Builder {
        crate::input::update_journey_input::Builder::default()
    }
    /// Creates a new `UpdateJourney` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJourney {
    type Output =
        std::result::Result<crate::output::UpdateJourneyOutput, crate::error::UpdateJourneyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_journey_error(response)
        } else {
            crate::operation_deser::parse_update_journey_response(response)
        }
    }
}

/// Operation shape for `UpdateJourneyState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_journey_state`](crate::client::Client::update_journey_state).
///
/// See [`crate::client::fluent_builders::UpdateJourneyState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJourneyState {
    _private: (),
}
impl UpdateJourneyState {
    /// Creates a new builder-style object to manufacture [`UpdateJourneyStateInput`](crate::input::UpdateJourneyStateInput)
    pub fn builder() -> crate::input::update_journey_state_input::Builder {
        crate::input::update_journey_state_input::Builder::default()
    }
    /// Creates a new `UpdateJourneyState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJourneyState {
    type Output = std::result::Result<
        crate::output::UpdateJourneyStateOutput,
        crate::error::UpdateJourneyStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_journey_state_error(response)
        } else {
            crate::operation_deser::parse_update_journey_state_response(response)
        }
    }
}

/// Operation shape for `UpdatePushTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_push_template`](crate::client::Client::update_push_template).
///
/// See [`crate::client::fluent_builders::UpdatePushTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePushTemplate {
    _private: (),
}
impl UpdatePushTemplate {
    /// Creates a new builder-style object to manufacture [`UpdatePushTemplateInput`](crate::input::UpdatePushTemplateInput)
    pub fn builder() -> crate::input::update_push_template_input::Builder {
        crate::input::update_push_template_input::Builder::default()
    }
    /// Creates a new `UpdatePushTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePushTemplate {
    type Output = std::result::Result<
        crate::output::UpdatePushTemplateOutput,
        crate::error::UpdatePushTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_push_template_error(response)
        } else {
            crate::operation_deser::parse_update_push_template_response(response)
        }
    }
}

/// Operation shape for `UpdateRecommenderConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_recommender_configuration`](crate::client::Client::update_recommender_configuration).
///
/// See [`crate::client::fluent_builders::UpdateRecommenderConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRecommenderConfiguration {
    _private: (),
}
impl UpdateRecommenderConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateRecommenderConfigurationInput`](crate::input::UpdateRecommenderConfigurationInput)
    pub fn builder() -> crate::input::update_recommender_configuration_input::Builder {
        crate::input::update_recommender_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateRecommenderConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRecommenderConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateRecommenderConfigurationOutput,
        crate::error::UpdateRecommenderConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_recommender_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_recommender_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateSegment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_segment`](crate::client::Client::update_segment).
///
/// See [`crate::client::fluent_builders::UpdateSegment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSegment {
    _private: (),
}
impl UpdateSegment {
    /// Creates a new builder-style object to manufacture [`UpdateSegmentInput`](crate::input::UpdateSegmentInput)
    pub fn builder() -> crate::input::update_segment_input::Builder {
        crate::input::update_segment_input::Builder::default()
    }
    /// Creates a new `UpdateSegment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSegment {
    type Output =
        std::result::Result<crate::output::UpdateSegmentOutput, crate::error::UpdateSegmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_segment_error(response)
        } else {
            crate::operation_deser::parse_update_segment_response(response)
        }
    }
}

/// Operation shape for `UpdateSmsChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_sms_channel`](crate::client::Client::update_sms_channel).
///
/// See [`crate::client::fluent_builders::UpdateSmsChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSmsChannel {
    _private: (),
}
impl UpdateSmsChannel {
    /// Creates a new builder-style object to manufacture [`UpdateSmsChannelInput`](crate::input::UpdateSmsChannelInput)
    pub fn builder() -> crate::input::update_sms_channel_input::Builder {
        crate::input::update_sms_channel_input::Builder::default()
    }
    /// Creates a new `UpdateSmsChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSmsChannel {
    type Output = std::result::Result<
        crate::output::UpdateSmsChannelOutput,
        crate::error::UpdateSmsChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_sms_channel_error(response)
        } else {
            crate::operation_deser::parse_update_sms_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateSmsTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_sms_template`](crate::client::Client::update_sms_template).
///
/// See [`crate::client::fluent_builders::UpdateSmsTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSmsTemplate {
    _private: (),
}
impl UpdateSmsTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateSmsTemplateInput`](crate::input::UpdateSmsTemplateInput)
    pub fn builder() -> crate::input::update_sms_template_input::Builder {
        crate::input::update_sms_template_input::Builder::default()
    }
    /// Creates a new `UpdateSmsTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSmsTemplate {
    type Output = std::result::Result<
        crate::output::UpdateSmsTemplateOutput,
        crate::error::UpdateSmsTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_sms_template_error(response)
        } else {
            crate::operation_deser::parse_update_sms_template_response(response)
        }
    }
}

/// Operation shape for `UpdateTemplateActiveVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_template_active_version`](crate::client::Client::update_template_active_version).
///
/// See [`crate::client::fluent_builders::UpdateTemplateActiveVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTemplateActiveVersion {
    _private: (),
}
impl UpdateTemplateActiveVersion {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateActiveVersionInput`](crate::input::UpdateTemplateActiveVersionInput)
    pub fn builder() -> crate::input::update_template_active_version_input::Builder {
        crate::input::update_template_active_version_input::Builder::default()
    }
    /// Creates a new `UpdateTemplateActiveVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTemplateActiveVersion {
    type Output = std::result::Result<
        crate::output::UpdateTemplateActiveVersionOutput,
        crate::error::UpdateTemplateActiveVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_template_active_version_error(response)
        } else {
            crate::operation_deser::parse_update_template_active_version_response(response)
        }
    }
}

/// Operation shape for `UpdateVoiceChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_voice_channel`](crate::client::Client::update_voice_channel).
///
/// See [`crate::client::fluent_builders::UpdateVoiceChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVoiceChannel {
    _private: (),
}
impl UpdateVoiceChannel {
    /// Creates a new builder-style object to manufacture [`UpdateVoiceChannelInput`](crate::input::UpdateVoiceChannelInput)
    pub fn builder() -> crate::input::update_voice_channel_input::Builder {
        crate::input::update_voice_channel_input::Builder::default()
    }
    /// Creates a new `UpdateVoiceChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVoiceChannel {
    type Output = std::result::Result<
        crate::output::UpdateVoiceChannelOutput,
        crate::error::UpdateVoiceChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_voice_channel_error(response)
        } else {
            crate::operation_deser::parse_update_voice_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateVoiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_voice_template`](crate::client::Client::update_voice_template).
///
/// See [`crate::client::fluent_builders::UpdateVoiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVoiceTemplate {
    _private: (),
}
impl UpdateVoiceTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateVoiceTemplateInput`](crate::input::UpdateVoiceTemplateInput)
    pub fn builder() -> crate::input::update_voice_template_input::Builder {
        crate::input::update_voice_template_input::Builder::default()
    }
    /// Creates a new `UpdateVoiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVoiceTemplate {
    type Output = std::result::Result<
        crate::output::UpdateVoiceTemplateOutput,
        crate::error::UpdateVoiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_voice_template_error(response)
        } else {
            crate::operation_deser::parse_update_voice_template_response(response)
        }
    }
}

/// Operation shape for `VerifyOTPMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_otp_message`](crate::client::Client::verify_otp_message).
///
/// See [`crate::client::fluent_builders::VerifyOTPMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyOTPMessage {
    _private: (),
}
impl VerifyOTPMessage {
    /// Creates a new builder-style object to manufacture [`VerifyOtpMessageInput`](crate::input::VerifyOtpMessageInput)
    pub fn builder() -> crate::input::verify_otp_message_input::Builder {
        crate::input::verify_otp_message_input::Builder::default()
    }
    /// Creates a new `VerifyOTPMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyOTPMessage {
    type Output = std::result::Result<
        crate::output::VerifyOtpMessageOutput,
        crate::error::VerifyOTPMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_otp_message_error(response)
        } else {
            crate::operation_deser::parse_verify_otp_message_response(response)
        }
    }
}
