// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAppInput`](crate::input::CreateAppInput)
pub mod create_app_input {
    /// A builder for [`CreateAppInput`](crate::input::CreateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_application_request:
            std::option::Option<crate::model::CreateApplicationRequest>,
    }
    impl Builder {
        /// <p>Specifies the display name of an application and the tags to associate with the application.</p>
        pub fn create_application_request(
            mut self,
            input: crate::model::CreateApplicationRequest,
        ) -> Self {
            self.create_application_request = Some(input);
            self
        }
        /// <p>Specifies the display name of an application and the tags to associate with the application.</p>
        pub fn set_create_application_request(
            mut self,
            input: std::option::Option<crate::model::CreateApplicationRequest>,
        ) -> Self {
            self.create_application_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInput`](crate::input::CreateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAppInput {
                create_application_request: self.create_application_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInputOperationOutputAlias = crate::operation::CreateApp;
#[doc(hidden)]
pub type CreateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInput {
    /// Consumes the builder and constructs an Operation<[`CreateApp`](crate::operation::CreateApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/apps").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_app_input(
                &self.create_application_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApp",
                    "pinpoint",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
}

/// See [`CreateCampaignInput`](crate::input::CreateCampaignInput)
pub mod create_campaign_input {
    /// A builder for [`CreateCampaignInput`](crate::input::CreateCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) write_campaign_request: std::option::Option<crate::model::WriteCampaignRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn write_campaign_request(mut self, input: crate::model::WriteCampaignRequest) -> Self {
            self.write_campaign_request = Some(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn set_write_campaign_request(
            mut self,
            input: std::option::Option<crate::model::WriteCampaignRequest>,
        ) -> Self {
            self.write_campaign_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCampaignInput`](crate::input::CreateCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCampaignInput {
                application_id: self.application_id,
                write_campaign_request: self.write_campaign_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCampaignInputOperationOutputAlias = crate::operation::CreateCampaign;
#[doc(hidden)]
pub type CreateCampaignInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCampaignInput {
    /// Consumes the builder and constructs an Operation<[`CreateCampaign`](crate::operation::CreateCampaign)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCampaign,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCampaignInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.application_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_1, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCampaignInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_campaign_input(
                &self.write_campaign_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCampaign",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCampaignInput`](crate::input::CreateCampaignInput)
    pub fn builder() -> crate::input::create_campaign_input::Builder {
        crate::input::create_campaign_input::Builder::default()
    }
}

/// See [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
pub mod create_email_template_input {
    /// A builder for [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_template_request: std::option::Option<crate::model::EmailTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn email_template_request(mut self, input: crate::model::EmailTemplateRequest) -> Self {
            self.email_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn set_email_template_request(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateRequest>,
        ) -> Self {
            self.email_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEmailTemplateInput {
                email_template_request: self.email_template_request,
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEmailTemplateInputOperationOutputAlias = crate::operation::CreateEmailTemplate;
#[doc(hidden)]
pub type CreateEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateEmailTemplate`](crate::operation::CreateEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.template_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_2, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/email",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_email_template_input(
                &self.email_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEmailTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
    pub fn builder() -> crate::input::create_email_template_input::Builder {
        crate::input::create_email_template_input::Builder::default()
    }
}

/// See [`CreateExportJobInput`](crate::input::CreateExportJobInput)
pub mod create_export_job_input {
    /// A builder for [`CreateExportJobInput`](crate::input::CreateExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) export_job_request: std::option::Option<crate::model::ExportJobRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn export_job_request(mut self, input: crate::model::ExportJobRequest) -> Self {
            self.export_job_request = Some(input);
            self
        }
        /// <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_export_job_request(
            mut self,
            input: std::option::Option<crate::model::ExportJobRequest>,
        ) -> Self {
            self.export_job_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExportJobInput`](crate::input::CreateExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateExportJobInput {
                application_id: self.application_id,
                export_job_request: self.export_job_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateExportJobInputOperationOutputAlias = crate::operation::CreateExportJob;
#[doc(hidden)]
pub type CreateExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateExportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateExportJob`](crate::operation::CreateExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.application_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_3, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/jobs/export",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_export_job_input(
                &self.export_job_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateExportJob",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateExportJobInput`](crate::input::CreateExportJobInput)
    pub fn builder() -> crate::input::create_export_job_input::Builder {
        crate::input::create_export_job_input::Builder::default()
    }
}

/// See [`CreateImportJobInput`](crate::input::CreateImportJobInput)
pub mod create_import_job_input {
    /// A builder for [`CreateImportJobInput`](crate::input::CreateImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) import_job_request: std::option::Option<crate::model::ImportJobRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn import_job_request(mut self, input: crate::model::ImportJobRequest) -> Self {
            self.import_job_request = Some(input);
            self
        }
        /// <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_import_job_request(
            mut self,
            input: std::option::Option<crate::model::ImportJobRequest>,
        ) -> Self {
            self.import_job_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImportJobInput`](crate::input::CreateImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImportJobInput {
                application_id: self.application_id,
                import_job_request: self.import_job_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImportJobInputOperationOutputAlias = crate::operation::CreateImportJob;
#[doc(hidden)]
pub type CreateImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateImportJob`](crate::operation::CreateImportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.application_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_4, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/jobs/import",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_import_job_input(
                &self.import_job_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImportJob",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImportJobInput`](crate::input::CreateImportJobInput)
    pub fn builder() -> crate::input::create_import_job_input::Builder {
        crate::input::create_import_job_input::Builder::default()
    }
}

/// See [`CreateInAppTemplateInput`](crate::input::CreateInAppTemplateInput)
pub mod create_in_app_template_input {
    /// A builder for [`CreateInAppTemplateInput`](crate::input::CreateInAppTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) in_app_template_request: std::option::Option<crate::model::InAppTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>InApp Template Request.</p>
        pub fn in_app_template_request(
            mut self,
            input: crate::model::InAppTemplateRequest,
        ) -> Self {
            self.in_app_template_request = Some(input);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn set_in_app_template_request(
            mut self,
            input: std::option::Option<crate::model::InAppTemplateRequest>,
        ) -> Self {
            self.in_app_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInAppTemplateInput`](crate::input::CreateInAppTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInAppTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInAppTemplateInput {
                in_app_template_request: self.in_app_template_request,
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInAppTemplateInputOperationOutputAlias = crate::operation::CreateInAppTemplate;
#[doc(hidden)]
pub type CreateInAppTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInAppTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateInAppTemplate`](crate::operation::CreateInAppTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInAppTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInAppTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.template_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_5, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/inapp",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInAppTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_in_app_template_input(
                &self.in_app_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInAppTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInAppTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInAppTemplateInput`](crate::input::CreateInAppTemplateInput)
    pub fn builder() -> crate::input::create_in_app_template_input::Builder {
        crate::input::create_in_app_template_input::Builder::default()
    }
}

/// See [`CreateJourneyInput`](crate::input::CreateJourneyInput)
pub mod create_journey_input {
    /// A builder for [`CreateJourneyInput`](crate::input::CreateJourneyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) write_journey_request: std::option::Option<crate::model::WriteJourneyRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn write_journey_request(mut self, input: crate::model::WriteJourneyRequest) -> Self {
            self.write_journey_request = Some(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn set_write_journey_request(
            mut self,
            input: std::option::Option<crate::model::WriteJourneyRequest>,
        ) -> Self {
            self.write_journey_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJourneyInput`](crate::input::CreateJourneyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateJourneyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateJourneyInput {
                application_id: self.application_id,
                write_journey_request: self.write_journey_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJourneyInputOperationOutputAlias = crate::operation::CreateJourney;
#[doc(hidden)]
pub type CreateJourneyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateJourneyInput {
    /// Consumes the builder and constructs an Operation<[`CreateJourney`](crate::operation::CreateJourney)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJourney,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateJourneyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.application_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_6, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateJourneyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_journey_input(
                &self.write_journey_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateJourney::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateJourney",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateJourneyInput`](crate::input::CreateJourneyInput)
    pub fn builder() -> crate::input::create_journey_input::Builder {
        crate::input::create_journey_input::Builder::default()
    }
}

/// See [`CreatePushTemplateInput`](crate::input::CreatePushTemplateInput)
pub mod create_push_template_input {
    /// A builder for [`CreatePushTemplateInput`](crate::input::CreatePushTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) push_notification_template_request:
            std::option::Option<crate::model::PushNotificationTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn push_notification_template_request(
            mut self,
            input: crate::model::PushNotificationTemplateRequest,
        ) -> Self {
            self.push_notification_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn set_push_notification_template_request(
            mut self,
            input: std::option::Option<crate::model::PushNotificationTemplateRequest>,
        ) -> Self {
            self.push_notification_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePushTemplateInput`](crate::input::CreatePushTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePushTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePushTemplateInput {
                push_notification_template_request: self.push_notification_template_request,
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePushTemplateInputOperationOutputAlias = crate::operation::CreatePushTemplate;
#[doc(hidden)]
pub type CreatePushTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePushTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreatePushTemplate`](crate::operation::CreatePushTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePushTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePushTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.template_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_7, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/push",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePushTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_push_template_input(
                &self.push_notification_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePushTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePushTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePushTemplateInput`](crate::input::CreatePushTemplateInput)
    pub fn builder() -> crate::input::create_push_template_input::Builder {
        crate::input::create_push_template_input::Builder::default()
    }
}

/// See [`CreateRecommenderConfigurationInput`](crate::input::CreateRecommenderConfigurationInput)
pub mod create_recommender_configuration_input {
    /// A builder for [`CreateRecommenderConfigurationInput`](crate::input::CreateRecommenderConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_recommender_configuration:
            std::option::Option<crate::model::CreateRecommenderConfigurationShape>,
    }
    impl Builder {
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn create_recommender_configuration(
            mut self,
            input: crate::model::CreateRecommenderConfigurationShape,
        ) -> Self {
            self.create_recommender_configuration = Some(input);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn set_create_recommender_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateRecommenderConfigurationShape>,
        ) -> Self {
            self.create_recommender_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecommenderConfigurationInput`](crate::input::CreateRecommenderConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRecommenderConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRecommenderConfigurationInput {
                create_recommender_configuration: self.create_recommender_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRecommenderConfigurationInputOperationOutputAlias =
    crate::operation::CreateRecommenderConfiguration;
#[doc(hidden)]
pub type CreateRecommenderConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateRecommenderConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateRecommenderConfiguration`](crate::operation::CreateRecommenderConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRecommenderConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRecommenderConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/recommenders").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRecommenderConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_recommender_configuration_input(
                &self.create_recommender_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRecommenderConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRecommenderConfiguration",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRecommenderConfigurationInput`](crate::input::CreateRecommenderConfigurationInput)
    pub fn builder() -> crate::input::create_recommender_configuration_input::Builder {
        crate::input::create_recommender_configuration_input::Builder::default()
    }
}

/// See [`CreateSegmentInput`](crate::input::CreateSegmentInput)
pub mod create_segment_input {
    /// A builder for [`CreateSegmentInput`](crate::input::CreateSegmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) write_segment_request: std::option::Option<crate::model::WriteSegmentRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn write_segment_request(mut self, input: crate::model::WriteSegmentRequest) -> Self {
            self.write_segment_request = Some(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn set_write_segment_request(
            mut self,
            input: std::option::Option<crate::model::WriteSegmentRequest>,
        ) -> Self {
            self.write_segment_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSegmentInput`](crate::input::CreateSegmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSegmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSegmentInput {
                application_id: self.application_id,
                write_segment_request: self.write_segment_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSegmentInputOperationOutputAlias = crate::operation::CreateSegment;
#[doc(hidden)]
pub type CreateSegmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSegmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateSegment`](crate::operation::CreateSegment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSegment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSegmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.application_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_8, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSegmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_segment_input(
                &self.write_segment_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSegment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSegment",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSegmentInput`](crate::input::CreateSegmentInput)
    pub fn builder() -> crate::input::create_segment_input::Builder {
        crate::input::create_segment_input::Builder::default()
    }
}

/// See [`CreateSmsTemplateInput`](crate::input::CreateSmsTemplateInput)
pub mod create_sms_template_input {
    /// A builder for [`CreateSmsTemplateInput`](crate::input::CreateSmsTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_template_request: std::option::Option<crate::model::SmsTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn sms_template_request(mut self, input: crate::model::SmsTemplateRequest) -> Self {
            self.sms_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn set_sms_template_request(
            mut self,
            input: std::option::Option<crate::model::SmsTemplateRequest>,
        ) -> Self {
            self.sms_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSmsTemplateInput`](crate::input::CreateSmsTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSmsTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSmsTemplateInput {
                sms_template_request: self.sms_template_request,
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSmsTemplateInputOperationOutputAlias = crate::operation::CreateSmsTemplate;
#[doc(hidden)]
pub type CreateSmsTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSmsTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateSmsTemplate`](crate::operation::CreateSmsTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSmsTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSmsTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.template_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_9, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/sms",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSmsTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_sms_template_input(
                &self.sms_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSmsTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSmsTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSmsTemplateInput`](crate::input::CreateSmsTemplateInput)
    pub fn builder() -> crate::input::create_sms_template_input::Builder {
        crate::input::create_sms_template_input::Builder::default()
    }
}

/// See [`CreateVoiceTemplateInput`](crate::input::CreateVoiceTemplateInput)
pub mod create_voice_template_input {
    /// A builder for [`CreateVoiceTemplateInput`](crate::input::CreateVoiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) voice_template_request: std::option::Option<crate::model::VoiceTemplateRequest>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn voice_template_request(mut self, input: crate::model::VoiceTemplateRequest) -> Self {
            self.voice_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn set_voice_template_request(
            mut self,
            input: std::option::Option<crate::model::VoiceTemplateRequest>,
        ) -> Self {
            self.voice_template_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVoiceTemplateInput`](crate::input::CreateVoiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVoiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVoiceTemplateInput {
                template_name: self.template_name,
                voice_template_request: self.voice_template_request,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVoiceTemplateInputOperationOutputAlias = crate::operation::CreateVoiceTemplate;
#[doc(hidden)]
pub type CreateVoiceTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVoiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateVoiceTemplate`](crate::operation::CreateVoiceTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVoiceTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateVoiceTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.template_name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_10, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/voice",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateVoiceTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_voice_template_input(
                &self.voice_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVoiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVoiceTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateVoiceTemplateInput`](crate::input::CreateVoiceTemplateInput)
    pub fn builder() -> crate::input::create_voice_template_input::Builder {
        crate::input::create_voice_template_input::Builder::default()
    }
}

/// See [`DeleteAdmChannelInput`](crate::input::DeleteAdmChannelInput)
pub mod delete_adm_channel_input {
    /// A builder for [`DeleteAdmChannelInput`](crate::input::DeleteAdmChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAdmChannelInput`](crate::input::DeleteAdmChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAdmChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAdmChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAdmChannelInputOperationOutputAlias = crate::operation::DeleteAdmChannel;
#[doc(hidden)]
pub type DeleteAdmChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAdmChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAdmChannel`](crate::operation::DeleteAdmChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAdmChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAdmChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.application_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_11, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/adm",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAdmChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAdmChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAdmChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAdmChannelInput`](crate::input::DeleteAdmChannelInput)
    pub fn builder() -> crate::input::delete_adm_channel_input::Builder {
        crate::input::delete_adm_channel_input::Builder::default()
    }
}

/// See [`DeleteApnsChannelInput`](crate::input::DeleteApnsChannelInput)
pub mod delete_apns_channel_input {
    /// A builder for [`DeleteApnsChannelInput`](crate::input::DeleteApnsChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApnsChannelInput`](crate::input::DeleteApnsChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApnsChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApnsChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApnsChannelInputOperationOutputAlias = crate::operation::DeleteApnsChannel;
#[doc(hidden)]
pub type DeleteApnsChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApnsChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApnsChannel`](crate::operation::DeleteApnsChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApnsChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApnsChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.application_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_12, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApnsChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApnsChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApnsChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApnsChannelInput`](crate::input::DeleteApnsChannelInput)
    pub fn builder() -> crate::input::delete_apns_channel_input::Builder {
        crate::input::delete_apns_channel_input::Builder::default()
    }
}

/// See [`DeleteApnsSandboxChannelInput`](crate::input::DeleteApnsSandboxChannelInput)
pub mod delete_apns_sandbox_channel_input {
    /// A builder for [`DeleteApnsSandboxChannelInput`](crate::input::DeleteApnsSandboxChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApnsSandboxChannelInput`](crate::input::DeleteApnsSandboxChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApnsSandboxChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApnsSandboxChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApnsSandboxChannelInputOperationOutputAlias =
    crate::operation::DeleteApnsSandboxChannel;
#[doc(hidden)]
pub type DeleteApnsSandboxChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApnsSandboxChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApnsSandboxChannel`](crate::operation::DeleteApnsSandboxChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApnsSandboxChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApnsSandboxChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.application_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_13, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_sandbox",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApnsSandboxChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApnsSandboxChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApnsSandboxChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApnsSandboxChannelInput`](crate::input::DeleteApnsSandboxChannelInput)
    pub fn builder() -> crate::input::delete_apns_sandbox_channel_input::Builder {
        crate::input::delete_apns_sandbox_channel_input::Builder::default()
    }
}

/// See [`DeleteApnsVoipChannelInput`](crate::input::DeleteApnsVoipChannelInput)
pub mod delete_apns_voip_channel_input {
    /// A builder for [`DeleteApnsVoipChannelInput`](crate::input::DeleteApnsVoipChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApnsVoipChannelInput`](crate::input::DeleteApnsVoipChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApnsVoipChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApnsVoipChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApnsVoipChannelInputOperationOutputAlias = crate::operation::DeleteApnsVoipChannel;
#[doc(hidden)]
pub type DeleteApnsVoipChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApnsVoipChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApnsVoipChannel`](crate::operation::DeleteApnsVoipChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApnsVoipChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApnsVoipChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.application_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_14, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_voip",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApnsVoipChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApnsVoipChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApnsVoipChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApnsVoipChannelInput`](crate::input::DeleteApnsVoipChannelInput)
    pub fn builder() -> crate::input::delete_apns_voip_channel_input::Builder {
        crate::input::delete_apns_voip_channel_input::Builder::default()
    }
}

/// See [`DeleteApnsVoipSandboxChannelInput`](crate::input::DeleteApnsVoipSandboxChannelInput)
pub mod delete_apns_voip_sandbox_channel_input {
    /// A builder for [`DeleteApnsVoipSandboxChannelInput`](crate::input::DeleteApnsVoipSandboxChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApnsVoipSandboxChannelInput`](crate::input::DeleteApnsVoipSandboxChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApnsVoipSandboxChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApnsVoipSandboxChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApnsVoipSandboxChannelInputOperationOutputAlias =
    crate::operation::DeleteApnsVoipSandboxChannel;
#[doc(hidden)]
pub type DeleteApnsVoipSandboxChannelInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApnsVoipSandboxChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApnsVoipSandboxChannel`](crate::operation::DeleteApnsVoipSandboxChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApnsVoipSandboxChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApnsVoipSandboxChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.application_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_15, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_voip_sandbox",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApnsVoipSandboxChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApnsVoipSandboxChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApnsVoipSandboxChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApnsVoipSandboxChannelInput`](crate::input::DeleteApnsVoipSandboxChannelInput)
    pub fn builder() -> crate::input::delete_apns_voip_sandbox_channel_input::Builder {
        crate::input::delete_apns_voip_sandbox_channel_input::Builder::default()
    }
}

/// See [`DeleteAppInput`](crate::input::DeleteAppInput)
pub mod delete_app_input {
    /// A builder for [`DeleteAppInput`](crate::input::DeleteAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInput`](crate::input::DeleteAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAppInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInputOperationOutputAlias = crate::operation::DeleteApp;
#[doc(hidden)]
pub type DeleteAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApp`](crate::operation::DeleteApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.application_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_16, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApp",
                    "pinpoint",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
}

/// See [`DeleteBaiduChannelInput`](crate::input::DeleteBaiduChannelInput)
pub mod delete_baidu_channel_input {
    /// A builder for [`DeleteBaiduChannelInput`](crate::input::DeleteBaiduChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBaiduChannelInput`](crate::input::DeleteBaiduChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBaiduChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBaiduChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBaiduChannelInputOperationOutputAlias = crate::operation::DeleteBaiduChannel;
#[doc(hidden)]
pub type DeleteBaiduChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBaiduChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBaiduChannel`](crate::operation::DeleteBaiduChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBaiduChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBaiduChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.application_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_17, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/baidu",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBaiduChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBaiduChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBaiduChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBaiduChannelInput`](crate::input::DeleteBaiduChannelInput)
    pub fn builder() -> crate::input::delete_baidu_channel_input::Builder {
        crate::input::delete_baidu_channel_input::Builder::default()
    }
}

/// See [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
pub mod delete_campaign_input {
    /// A builder for [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCampaignInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCampaignInputOperationOutputAlias = crate::operation::DeleteCampaign;
#[doc(hidden)]
pub type DeleteCampaignInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCampaignInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCampaign`](crate::operation::DeleteCampaign)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCampaign,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCampaignInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.application_id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_18, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_19 = &_input.campaign_id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_19, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}",
                    ApplicationId = application_id,
                    CampaignId = campaign_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCampaignInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCampaign",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
    pub fn builder() -> crate::input::delete_campaign_input::Builder {
        crate::input::delete_campaign_input::Builder::default()
    }
}

/// See [`DeleteEmailChannelInput`](crate::input::DeleteEmailChannelInput)
pub mod delete_email_channel_input {
    /// A builder for [`DeleteEmailChannelInput`](crate::input::DeleteEmailChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEmailChannelInput`](crate::input::DeleteEmailChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEmailChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEmailChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEmailChannelInputOperationOutputAlias = crate::operation::DeleteEmailChannel;
#[doc(hidden)]
pub type DeleteEmailChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEmailChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEmailChannel`](crate::operation::DeleteEmailChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEmailChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEmailChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.application_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_20, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/email",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEmailChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEmailChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEmailChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEmailChannelInput`](crate::input::DeleteEmailChannelInput)
    pub fn builder() -> crate::input::delete_email_channel_input::Builder {
        crate::input::delete_email_channel_input::Builder::default()
    }
}

/// See [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
pub mod delete_email_template_input {
    /// A builder for [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEmailTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEmailTemplateInputOperationOutputAlias = crate::operation::DeleteEmailTemplate;
#[doc(hidden)]
pub type DeleteEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEmailTemplate`](crate::operation::DeleteEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.template_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_21, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/email",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteEmailTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_22) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_22));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEmailTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
    pub fn builder() -> crate::input::delete_email_template_input::Builder {
        crate::input::delete_email_template_input::Builder::default()
    }
}

/// See [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
pub mod delete_endpoint_input {
    /// A builder for [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointInput {
                application_id: self.application_id,
                endpoint_id: self.endpoint_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointInputOperationOutputAlias = crate::operation::DeleteEndpoint;
#[doc(hidden)]
pub type DeleteEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpoint`](crate::operation::DeleteEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.application_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_23, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.endpoint_id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let endpoint_id = aws_smithy_http::label::fmt_string(input_24, false);
                if endpoint_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/endpoints/{EndpointId}",
                    ApplicationId = application_id,
                    EndpointId = endpoint_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpoint",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
}

/// See [`DeleteEventStreamInput`](crate::input::DeleteEventStreamInput)
pub mod delete_event_stream_input {
    /// A builder for [`DeleteEventStreamInput`](crate::input::DeleteEventStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventStreamInput`](crate::input::DeleteEventStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventStreamInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventStreamInputOperationOutputAlias = crate::operation::DeleteEventStream;
#[doc(hidden)]
pub type DeleteEventStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventStreamInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventStream`](crate::operation::DeleteEventStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEventStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.application_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_25, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/eventstream",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEventStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventStream",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventStreamInput`](crate::input::DeleteEventStreamInput)
    pub fn builder() -> crate::input::delete_event_stream_input::Builder {
        crate::input::delete_event_stream_input::Builder::default()
    }
}

/// See [`DeleteGcmChannelInput`](crate::input::DeleteGcmChannelInput)
pub mod delete_gcm_channel_input {
    /// A builder for [`DeleteGcmChannelInput`](crate::input::DeleteGcmChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGcmChannelInput`](crate::input::DeleteGcmChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGcmChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGcmChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGcmChannelInputOperationOutputAlias = crate::operation::DeleteGcmChannel;
#[doc(hidden)]
pub type DeleteGcmChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGcmChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGcmChannel`](crate::operation::DeleteGcmChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGcmChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGcmChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.application_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_26, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/gcm",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGcmChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGcmChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGcmChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGcmChannelInput`](crate::input::DeleteGcmChannelInput)
    pub fn builder() -> crate::input::delete_gcm_channel_input::Builder {
        crate::input::delete_gcm_channel_input::Builder::default()
    }
}

/// See [`DeleteInAppTemplateInput`](crate::input::DeleteInAppTemplateInput)
pub mod delete_in_app_template_input {
    /// A builder for [`DeleteInAppTemplateInput`](crate::input::DeleteInAppTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInAppTemplateInput`](crate::input::DeleteInAppTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInAppTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInAppTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInAppTemplateInputOperationOutputAlias = crate::operation::DeleteInAppTemplate;
#[doc(hidden)]
pub type DeleteInAppTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInAppTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInAppTemplate`](crate::operation::DeleteInAppTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInAppTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInAppTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.template_name;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_27, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/inapp",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteInAppTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_28));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInAppTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInAppTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInAppTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInAppTemplateInput`](crate::input::DeleteInAppTemplateInput)
    pub fn builder() -> crate::input::delete_in_app_template_input::Builder {
        crate::input::delete_in_app_template_input::Builder::default()
    }
}

/// See [`DeleteJourneyInput`](crate::input::DeleteJourneyInput)
pub mod delete_journey_input {
    /// A builder for [`DeleteJourneyInput`](crate::input::DeleteJourneyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJourneyInput`](crate::input::DeleteJourneyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteJourneyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteJourneyInput {
                application_id: self.application_id,
                journey_id: self.journey_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJourneyInputOperationOutputAlias = crate::operation::DeleteJourney;
#[doc(hidden)]
pub type DeleteJourneyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJourneyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJourney`](crate::operation::DeleteJourney)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJourney,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteJourneyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.application_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_29, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_30 = &_input.journey_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_30, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys/{JourneyId}",
                    ApplicationId = application_id,
                    JourneyId = journey_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteJourneyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteJourney::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteJourney",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteJourneyInput`](crate::input::DeleteJourneyInput)
    pub fn builder() -> crate::input::delete_journey_input::Builder {
        crate::input::delete_journey_input::Builder::default()
    }
}

/// See [`DeletePushTemplateInput`](crate::input::DeletePushTemplateInput)
pub mod delete_push_template_input {
    /// A builder for [`DeletePushTemplateInput`](crate::input::DeletePushTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePushTemplateInput`](crate::input::DeletePushTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePushTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePushTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePushTemplateInputOperationOutputAlias = crate::operation::DeletePushTemplate;
#[doc(hidden)]
pub type DeletePushTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePushTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeletePushTemplate`](crate::operation::DeletePushTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePushTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePushTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.template_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_31, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/push",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeletePushTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_32) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePushTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePushTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePushTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePushTemplateInput`](crate::input::DeletePushTemplateInput)
    pub fn builder() -> crate::input::delete_push_template_input::Builder {
        crate::input::delete_push_template_input::Builder::default()
    }
}

/// See [`DeleteRecommenderConfigurationInput`](crate::input::DeleteRecommenderConfigurationInput)
pub mod delete_recommender_configuration_input {
    /// A builder for [`DeleteRecommenderConfigurationInput`](crate::input::DeleteRecommenderConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecommenderConfigurationInput`](crate::input::DeleteRecommenderConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRecommenderConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRecommenderConfigurationInput {
                recommender_id: self.recommender_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRecommenderConfigurationInputOperationOutputAlias =
    crate::operation::DeleteRecommenderConfiguration;
#[doc(hidden)]
pub type DeleteRecommenderConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRecommenderConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRecommenderConfiguration`](crate::operation::DeleteRecommenderConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRecommenderConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRecommenderConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.recommender_id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "recommender_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let recommender_id = aws_smithy_http::label::fmt_string(input_33, false);
                if recommender_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recommender_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/recommenders/{RecommenderId}",
                    RecommenderId = recommender_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRecommenderConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRecommenderConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRecommenderConfiguration",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRecommenderConfigurationInput`](crate::input::DeleteRecommenderConfigurationInput)
    pub fn builder() -> crate::input::delete_recommender_configuration_input::Builder {
        crate::input::delete_recommender_configuration_input::Builder::default()
    }
}

/// See [`DeleteSegmentInput`](crate::input::DeleteSegmentInput)
pub mod delete_segment_input {
    /// A builder for [`DeleteSegmentInput`](crate::input::DeleteSegmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSegmentInput`](crate::input::DeleteSegmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSegmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSegmentInput {
                application_id: self.application_id,
                segment_id: self.segment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSegmentInputOperationOutputAlias = crate::operation::DeleteSegment;
#[doc(hidden)]
pub type DeleteSegmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSegmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSegment`](crate::operation::DeleteSegment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSegment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSegmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.application_id;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_34, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_35 = &_input.segment_id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_35, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}",
                    ApplicationId = application_id,
                    SegmentId = segment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSegmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSegment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSegment",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSegmentInput`](crate::input::DeleteSegmentInput)
    pub fn builder() -> crate::input::delete_segment_input::Builder {
        crate::input::delete_segment_input::Builder::default()
    }
}

/// See [`DeleteSmsChannelInput`](crate::input::DeleteSmsChannelInput)
pub mod delete_sms_channel_input {
    /// A builder for [`DeleteSmsChannelInput`](crate::input::DeleteSmsChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSmsChannelInput`](crate::input::DeleteSmsChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSmsChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSmsChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSmsChannelInputOperationOutputAlias = crate::operation::DeleteSmsChannel;
#[doc(hidden)]
pub type DeleteSmsChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSmsChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSmsChannel`](crate::operation::DeleteSmsChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSmsChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSmsChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.application_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_36, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/sms",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSmsChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSmsChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSmsChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSmsChannelInput`](crate::input::DeleteSmsChannelInput)
    pub fn builder() -> crate::input::delete_sms_channel_input::Builder {
        crate::input::delete_sms_channel_input::Builder::default()
    }
}

/// See [`DeleteSmsTemplateInput`](crate::input::DeleteSmsTemplateInput)
pub mod delete_sms_template_input {
    /// A builder for [`DeleteSmsTemplateInput`](crate::input::DeleteSmsTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSmsTemplateInput`](crate::input::DeleteSmsTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSmsTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSmsTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSmsTemplateInputOperationOutputAlias = crate::operation::DeleteSmsTemplate;
#[doc(hidden)]
pub type DeleteSmsTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSmsTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSmsTemplate`](crate::operation::DeleteSmsTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSmsTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSmsTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.template_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_37, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/sms",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteSmsTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_38) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_38));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSmsTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSmsTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSmsTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSmsTemplateInput`](crate::input::DeleteSmsTemplateInput)
    pub fn builder() -> crate::input::delete_sms_template_input::Builder {
        crate::input::delete_sms_template_input::Builder::default()
    }
}

/// See [`DeleteUserEndpointsInput`](crate::input::DeleteUserEndpointsInput)
pub mod delete_user_endpoints_input {
    /// A builder for [`DeleteUserEndpointsInput`](crate::input::DeleteUserEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserEndpointsInput`](crate::input::DeleteUserEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserEndpointsInput {
                application_id: self.application_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserEndpointsInputOperationOutputAlias = crate::operation::DeleteUserEndpoints;
#[doc(hidden)]
pub type DeleteUserEndpointsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserEndpoints`](crate::operation::DeleteUserEndpoints)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserEndpoints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteUserEndpointsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.application_id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_39, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_40 = &_input.user_id;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_40, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/users/{UserId}",
                    ApplicationId = application_id,
                    UserId = user_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteUserEndpointsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserEndpoints",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserEndpointsInput`](crate::input::DeleteUserEndpointsInput)
    pub fn builder() -> crate::input::delete_user_endpoints_input::Builder {
        crate::input::delete_user_endpoints_input::Builder::default()
    }
}

/// See [`DeleteVoiceChannelInput`](crate::input::DeleteVoiceChannelInput)
pub mod delete_voice_channel_input {
    /// A builder for [`DeleteVoiceChannelInput`](crate::input::DeleteVoiceChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceChannelInput`](crate::input::DeleteVoiceChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceChannelInputOperationOutputAlias = crate::operation::DeleteVoiceChannel;
#[doc(hidden)]
pub type DeleteVoiceChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceChannel`](crate::operation::DeleteVoiceChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVoiceChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.application_id;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_41, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/voice",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVoiceChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceChannelInput`](crate::input::DeleteVoiceChannelInput)
    pub fn builder() -> crate::input::delete_voice_channel_input::Builder {
        crate::input::delete_voice_channel_input::Builder::default()
    }
}

/// See [`DeleteVoiceTemplateInput`](crate::input::DeleteVoiceTemplateInput)
pub mod delete_voice_template_input {
    /// A builder for [`DeleteVoiceTemplateInput`](crate::input::DeleteVoiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVoiceTemplateInput`](crate::input::DeleteVoiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVoiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVoiceTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVoiceTemplateInputOperationOutputAlias = crate::operation::DeleteVoiceTemplate;
#[doc(hidden)]
pub type DeleteVoiceTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVoiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVoiceTemplate`](crate::operation::DeleteVoiceTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVoiceTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVoiceTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.template_name;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_42, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/voice",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteVoiceTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_43) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_43));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVoiceTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVoiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVoiceTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVoiceTemplateInput`](crate::input::DeleteVoiceTemplateInput)
    pub fn builder() -> crate::input::delete_voice_template_input::Builder {
        crate::input::delete_voice_template_input::Builder::default()
    }
}

/// See [`GetAdmChannelInput`](crate::input::GetAdmChannelInput)
pub mod get_adm_channel_input {
    /// A builder for [`GetAdmChannelInput`](crate::input::GetAdmChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAdmChannelInput`](crate::input::GetAdmChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAdmChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAdmChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAdmChannelInputOperationOutputAlias = crate::operation::GetAdmChannel;
#[doc(hidden)]
pub type GetAdmChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAdmChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetAdmChannel`](crate::operation::GetAdmChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAdmChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAdmChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.application_id;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_44, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/adm",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAdmChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAdmChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAdmChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAdmChannelInput`](crate::input::GetAdmChannelInput)
    pub fn builder() -> crate::input::get_adm_channel_input::Builder {
        crate::input::get_adm_channel_input::Builder::default()
    }
}

/// See [`GetApnsChannelInput`](crate::input::GetApnsChannelInput)
pub mod get_apns_channel_input {
    /// A builder for [`GetApnsChannelInput`](crate::input::GetApnsChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApnsChannelInput`](crate::input::GetApnsChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApnsChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApnsChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApnsChannelInputOperationOutputAlias = crate::operation::GetApnsChannel;
#[doc(hidden)]
pub type GetApnsChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApnsChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetApnsChannel`](crate::operation::GetApnsChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApnsChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApnsChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.application_id;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_45, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApnsChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApnsChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApnsChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApnsChannelInput`](crate::input::GetApnsChannelInput)
    pub fn builder() -> crate::input::get_apns_channel_input::Builder {
        crate::input::get_apns_channel_input::Builder::default()
    }
}

/// See [`GetApnsSandboxChannelInput`](crate::input::GetApnsSandboxChannelInput)
pub mod get_apns_sandbox_channel_input {
    /// A builder for [`GetApnsSandboxChannelInput`](crate::input::GetApnsSandboxChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApnsSandboxChannelInput`](crate::input::GetApnsSandboxChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApnsSandboxChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApnsSandboxChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApnsSandboxChannelInputOperationOutputAlias = crate::operation::GetApnsSandboxChannel;
#[doc(hidden)]
pub type GetApnsSandboxChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApnsSandboxChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetApnsSandboxChannel`](crate::operation::GetApnsSandboxChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApnsSandboxChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApnsSandboxChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.application_id;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_46, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_sandbox",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApnsSandboxChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApnsSandboxChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApnsSandboxChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApnsSandboxChannelInput`](crate::input::GetApnsSandboxChannelInput)
    pub fn builder() -> crate::input::get_apns_sandbox_channel_input::Builder {
        crate::input::get_apns_sandbox_channel_input::Builder::default()
    }
}

/// See [`GetApnsVoipChannelInput`](crate::input::GetApnsVoipChannelInput)
pub mod get_apns_voip_channel_input {
    /// A builder for [`GetApnsVoipChannelInput`](crate::input::GetApnsVoipChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApnsVoipChannelInput`](crate::input::GetApnsVoipChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApnsVoipChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApnsVoipChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApnsVoipChannelInputOperationOutputAlias = crate::operation::GetApnsVoipChannel;
#[doc(hidden)]
pub type GetApnsVoipChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApnsVoipChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetApnsVoipChannel`](crate::operation::GetApnsVoipChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApnsVoipChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApnsVoipChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.application_id;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_47, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_voip",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApnsVoipChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApnsVoipChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApnsVoipChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApnsVoipChannelInput`](crate::input::GetApnsVoipChannelInput)
    pub fn builder() -> crate::input::get_apns_voip_channel_input::Builder {
        crate::input::get_apns_voip_channel_input::Builder::default()
    }
}

/// See [`GetApnsVoipSandboxChannelInput`](crate::input::GetApnsVoipSandboxChannelInput)
pub mod get_apns_voip_sandbox_channel_input {
    /// A builder for [`GetApnsVoipSandboxChannelInput`](crate::input::GetApnsVoipSandboxChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApnsVoipSandboxChannelInput`](crate::input::GetApnsVoipSandboxChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApnsVoipSandboxChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApnsVoipSandboxChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApnsVoipSandboxChannelInputOperationOutputAlias =
    crate::operation::GetApnsVoipSandboxChannel;
#[doc(hidden)]
pub type GetApnsVoipSandboxChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApnsVoipSandboxChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetApnsVoipSandboxChannel`](crate::operation::GetApnsVoipSandboxChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApnsVoipSandboxChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApnsVoipSandboxChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.application_id;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_48, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_voip_sandbox",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApnsVoipSandboxChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApnsVoipSandboxChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApnsVoipSandboxChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApnsVoipSandboxChannelInput`](crate::input::GetApnsVoipSandboxChannelInput)
    pub fn builder() -> crate::input::get_apns_voip_sandbox_channel_input::Builder {
        crate::input::get_apns_voip_sandbox_channel_input::Builder::default()
    }
}

/// See [`GetAppInput`](crate::input::GetAppInput)
pub mod get_app_input {
    /// A builder for [`GetAppInput`](crate::input::GetAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppInput`](crate::input::GetAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAppInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppInputOperationOutputAlias = crate::operation::GetApp;
#[doc(hidden)]
pub type GetAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppInput {
    /// Consumes the builder and constructs an Operation<[`GetApp`](crate::operation::GetApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_49 = &_input.application_id;
                let input_49 = input_49.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_49, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetApp", "pinpoint",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAppInput`](crate::input::GetAppInput)
    pub fn builder() -> crate::input::get_app_input::Builder {
        crate::input::get_app_input::Builder::default()
    }
}

/// See [`GetApplicationDateRangeKpiInput`](crate::input::GetApplicationDateRangeKpiInput)
pub mod get_application_date_range_kpi_input {
    /// A builder for [`GetApplicationDateRangeKpiInput`](crate::input::GetApplicationDateRangeKpiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) kpi_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.kpi_name = Some(input.into());
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kpi_name = input;
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationDateRangeKpiInput`](crate::input::GetApplicationDateRangeKpiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApplicationDateRangeKpiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApplicationDateRangeKpiInput {
                application_id: self.application_id,
                end_time: self.end_time,
                kpi_name: self.kpi_name,
                next_token: self.next_token,
                page_size: self.page_size,
                start_time: self.start_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApplicationDateRangeKpiInputOperationOutputAlias =
    crate::operation::GetApplicationDateRangeKpi;
#[doc(hidden)]
pub type GetApplicationDateRangeKpiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApplicationDateRangeKpiInput {
    /// Consumes the builder and constructs an Operation<[`GetApplicationDateRangeKpi`](crate::operation::GetApplicationDateRangeKpi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApplicationDateRangeKpi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApplicationDateRangeKpiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.application_id;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_50, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_51 = &_input.kpi_name;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "kpi_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let kpi_name = aws_smithy_http::label::fmt_string(input_51, false);
                if kpi_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "kpi_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/kpis/daterange/{KpiName}",
                    ApplicationId = application_id,
                    KpiName = kpi_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetApplicationDateRangeKpiInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_52) = &_input.end_time {
                    query.push_kv(
                        "end-time",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_52,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_53) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if let Some(inner_54) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_54));
                }
                if let Some(inner_55) = &_input.start_time {
                    query.push_kv(
                        "start-time",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_55,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApplicationDateRangeKpiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApplicationDateRangeKpi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApplicationDateRangeKpi",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApplicationDateRangeKpiInput`](crate::input::GetApplicationDateRangeKpiInput)
    pub fn builder() -> crate::input::get_application_date_range_kpi_input::Builder {
        crate::input::get_application_date_range_kpi_input::Builder::default()
    }
}

/// See [`GetApplicationSettingsInput`](crate::input::GetApplicationSettingsInput)
pub mod get_application_settings_input {
    /// A builder for [`GetApplicationSettingsInput`](crate::input::GetApplicationSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationSettingsInput`](crate::input::GetApplicationSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApplicationSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApplicationSettingsInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApplicationSettingsInputOperationOutputAlias = crate::operation::GetApplicationSettings;
#[doc(hidden)]
pub type GetApplicationSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApplicationSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetApplicationSettings`](crate::operation::GetApplicationSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApplicationSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApplicationSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_56 = &_input.application_id;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_56, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/settings",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApplicationSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApplicationSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApplicationSettings",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApplicationSettingsInput`](crate::input::GetApplicationSettingsInput)
    pub fn builder() -> crate::input::get_application_settings_input::Builder {
        crate::input::get_application_settings_input::Builder::default()
    }
}

/// See [`GetAppsInput`](crate::input::GetAppsInput)
pub mod get_apps_input {
    /// A builder for [`GetAppsInput`](crate::input::GetAppsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppsInput`](crate::input::GetAppsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAppsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAppsInput {
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppsInputOperationOutputAlias = crate::operation::GetApps;
#[doc(hidden)]
pub type GetAppsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppsInput {
    /// Consumes the builder and constructs an Operation<[`GetApps`](crate::operation::GetApps)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAppsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/apps").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetAppsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_57) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_57));
                }
                if let Some(inner_58) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_58));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAppsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApps::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetApps", "pinpoint",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAppsInput`](crate::input::GetAppsInput)
    pub fn builder() -> crate::input::get_apps_input::Builder {
        crate::input::get_apps_input::Builder::default()
    }
}

/// See [`GetBaiduChannelInput`](crate::input::GetBaiduChannelInput)
pub mod get_baidu_channel_input {
    /// A builder for [`GetBaiduChannelInput`](crate::input::GetBaiduChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBaiduChannelInput`](crate::input::GetBaiduChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBaiduChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBaiduChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBaiduChannelInputOperationOutputAlias = crate::operation::GetBaiduChannel;
#[doc(hidden)]
pub type GetBaiduChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBaiduChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetBaiduChannel`](crate::operation::GetBaiduChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBaiduChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBaiduChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_59 = &_input.application_id;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_59, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/baidu",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBaiduChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBaiduChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBaiduChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBaiduChannelInput`](crate::input::GetBaiduChannelInput)
    pub fn builder() -> crate::input::get_baidu_channel_input::Builder {
        crate::input::get_baidu_channel_input::Builder::default()
    }
}

/// See [`GetCampaignInput`](crate::input::GetCampaignInput)
pub mod get_campaign_input {
    /// A builder for [`GetCampaignInput`](crate::input::GetCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCampaignInput`](crate::input::GetCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCampaignInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCampaignInputOperationOutputAlias = crate::operation::GetCampaign;
#[doc(hidden)]
pub type GetCampaignInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCampaignInput {
    /// Consumes the builder and constructs an Operation<[`GetCampaign`](crate::operation::GetCampaign)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCampaign,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCampaignInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_60 = &_input.application_id;
                let input_60 = input_60.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_60, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_61 = &_input.campaign_id;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_61, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}",
                    ApplicationId = application_id,
                    CampaignId = campaign_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCampaignInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCampaign",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCampaignInput`](crate::input::GetCampaignInput)
    pub fn builder() -> crate::input::get_campaign_input::Builder {
        crate::input::get_campaign_input::Builder::default()
    }
}

/// See [`GetCampaignActivitiesInput`](crate::input::GetCampaignActivitiesInput)
pub mod get_campaign_activities_input {
    /// A builder for [`GetCampaignActivitiesInput`](crate::input::GetCampaignActivitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCampaignActivitiesInput`](crate::input::GetCampaignActivitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCampaignActivitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCampaignActivitiesInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCampaignActivitiesInputOperationOutputAlias = crate::operation::GetCampaignActivities;
#[doc(hidden)]
pub type GetCampaignActivitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCampaignActivitiesInput {
    /// Consumes the builder and constructs an Operation<[`GetCampaignActivities`](crate::operation::GetCampaignActivities)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCampaignActivities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCampaignActivitiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_62 = &_input.application_id;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_62, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_63 = &_input.campaign_id;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_63, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}/activities",
                    ApplicationId = application_id,
                    CampaignId = campaign_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCampaignActivitiesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_64) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_64));
                }
                if let Some(inner_65) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_65));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCampaignActivitiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCampaignActivities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCampaignActivities",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCampaignActivitiesInput`](crate::input::GetCampaignActivitiesInput)
    pub fn builder() -> crate::input::get_campaign_activities_input::Builder {
        crate::input::get_campaign_activities_input::Builder::default()
    }
}

/// See [`GetCampaignDateRangeKpiInput`](crate::input::GetCampaignDateRangeKpiInput)
pub mod get_campaign_date_range_kpi_input {
    /// A builder for [`GetCampaignDateRangeKpiInput`](crate::input::GetCampaignDateRangeKpiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) kpi_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.kpi_name = Some(input.into());
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kpi_name = input;
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCampaignDateRangeKpiInput`](crate::input::GetCampaignDateRangeKpiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCampaignDateRangeKpiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCampaignDateRangeKpiInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
                end_time: self.end_time,
                kpi_name: self.kpi_name,
                next_token: self.next_token,
                page_size: self.page_size,
                start_time: self.start_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCampaignDateRangeKpiInputOperationOutputAlias =
    crate::operation::GetCampaignDateRangeKpi;
#[doc(hidden)]
pub type GetCampaignDateRangeKpiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCampaignDateRangeKpiInput {
    /// Consumes the builder and constructs an Operation<[`GetCampaignDateRangeKpi`](crate::operation::GetCampaignDateRangeKpi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCampaignDateRangeKpi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCampaignDateRangeKpiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_66 = &_input.application_id;
                let input_66 = input_66.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_66, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_67 = &_input.campaign_id;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_67, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_68 = &_input.kpi_name;
                let input_68 = input_68.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "kpi_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let kpi_name = aws_smithy_http::label::fmt_string(input_68, false);
                if kpi_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "kpi_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}/kpis/daterange/{KpiName}",
                    ApplicationId = application_id,
                    CampaignId = campaign_id,
                    KpiName = kpi_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCampaignDateRangeKpiInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_69) = &_input.end_time {
                    query.push_kv(
                        "end-time",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_69,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_70) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_70));
                }
                if let Some(inner_71) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_71));
                }
                if let Some(inner_72) = &_input.start_time {
                    query.push_kv(
                        "start-time",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_72,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCampaignDateRangeKpiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCampaignDateRangeKpi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCampaignDateRangeKpi",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCampaignDateRangeKpiInput`](crate::input::GetCampaignDateRangeKpiInput)
    pub fn builder() -> crate::input::get_campaign_date_range_kpi_input::Builder {
        crate::input::get_campaign_date_range_kpi_input::Builder::default()
    }
}

/// See [`GetCampaignsInput`](crate::input::GetCampaignsInput)
pub mod get_campaigns_input {
    /// A builder for [`GetCampaignsInput`](crate::input::GetCampaignsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCampaignsInput`](crate::input::GetCampaignsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCampaignsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCampaignsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCampaignsInputOperationOutputAlias = crate::operation::GetCampaigns;
#[doc(hidden)]
pub type GetCampaignsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCampaignsInput {
    /// Consumes the builder and constructs an Operation<[`GetCampaigns`](crate::operation::GetCampaigns)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCampaigns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCampaignsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_73 = &_input.application_id;
                let input_73 = input_73.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_73, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCampaignsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_74) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_74));
                }
                if let Some(inner_75) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_75));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCampaignsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCampaigns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCampaigns",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCampaignsInput`](crate::input::GetCampaignsInput)
    pub fn builder() -> crate::input::get_campaigns_input::Builder {
        crate::input::get_campaigns_input::Builder::default()
    }
}

/// See [`GetCampaignVersionInput`](crate::input::GetCampaignVersionInput)
pub mod get_campaign_version_input {
    /// A builder for [`GetCampaignVersionInput`](crate::input::GetCampaignVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCampaignVersionInput`](crate::input::GetCampaignVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCampaignVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCampaignVersionInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCampaignVersionInputOperationOutputAlias = crate::operation::GetCampaignVersion;
#[doc(hidden)]
pub type GetCampaignVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCampaignVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetCampaignVersion`](crate::operation::GetCampaignVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCampaignVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCampaignVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_76 = &_input.application_id;
                let input_76 = input_76.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_76, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_77 = &_input.campaign_id;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_77, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_78 = &_input.version;
                let input_78 = input_78.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version = aws_smithy_http::label::fmt_string(input_78, false);
                if version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}/versions/{Version}",
                    ApplicationId = application_id,
                    CampaignId = campaign_id,
                    Version = version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCampaignVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCampaignVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCampaignVersion",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCampaignVersionInput`](crate::input::GetCampaignVersionInput)
    pub fn builder() -> crate::input::get_campaign_version_input::Builder {
        crate::input::get_campaign_version_input::Builder::default()
    }
}

/// See [`GetCampaignVersionsInput`](crate::input::GetCampaignVersionsInput)
pub mod get_campaign_versions_input {
    /// A builder for [`GetCampaignVersionsInput`](crate::input::GetCampaignVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCampaignVersionsInput`](crate::input::GetCampaignVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCampaignVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCampaignVersionsInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCampaignVersionsInputOperationOutputAlias = crate::operation::GetCampaignVersions;
#[doc(hidden)]
pub type GetCampaignVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCampaignVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetCampaignVersions`](crate::operation::GetCampaignVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCampaignVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCampaignVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_79 = &_input.application_id;
                let input_79 = input_79.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_79, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_80 = &_input.campaign_id;
                let input_80 = input_80.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_80, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}/versions",
                    ApplicationId = application_id,
                    CampaignId = campaign_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCampaignVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_81) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_81));
                }
                if let Some(inner_82) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_82));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCampaignVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCampaignVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCampaignVersions",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCampaignVersionsInput`](crate::input::GetCampaignVersionsInput)
    pub fn builder() -> crate::input::get_campaign_versions_input::Builder {
        crate::input::get_campaign_versions_input::Builder::default()
    }
}

/// See [`GetChannelsInput`](crate::input::GetChannelsInput)
pub mod get_channels_input {
    /// A builder for [`GetChannelsInput`](crate::input::GetChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelsInput`](crate::input::GetChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChannelsInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChannelsInputOperationOutputAlias = crate::operation::GetChannels;
#[doc(hidden)]
pub type GetChannelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetChannelsInput {
    /// Consumes the builder and constructs an Operation<[`GetChannels`](crate::operation::GetChannels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChannels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetChannelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_83 = &_input.application_id;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_83, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetChannelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChannels",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetChannelsInput`](crate::input::GetChannelsInput)
    pub fn builder() -> crate::input::get_channels_input::Builder {
        crate::input::get_channels_input::Builder::default()
    }
}

/// See [`GetEmailChannelInput`](crate::input::GetEmailChannelInput)
pub mod get_email_channel_input {
    /// A builder for [`GetEmailChannelInput`](crate::input::GetEmailChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEmailChannelInput`](crate::input::GetEmailChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEmailChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEmailChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEmailChannelInputOperationOutputAlias = crate::operation::GetEmailChannel;
#[doc(hidden)]
pub type GetEmailChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEmailChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetEmailChannel`](crate::operation::GetEmailChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEmailChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEmailChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_84 = &_input.application_id;
                let input_84 = input_84.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_84, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/email",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEmailChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEmailChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEmailChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEmailChannelInput`](crate::input::GetEmailChannelInput)
    pub fn builder() -> crate::input::get_email_channel_input::Builder {
        crate::input::get_email_channel_input::Builder::default()
    }
}

/// See [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
pub mod get_email_template_input {
    /// A builder for [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEmailTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEmailTemplateInputOperationOutputAlias = crate::operation::GetEmailTemplate;
#[doc(hidden)]
pub type GetEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetEmailTemplate`](crate::operation::GetEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_85 = &_input.template_name;
                let input_85 = input_85.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_85, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/email",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetEmailTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_86) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_86));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEmailTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
    pub fn builder() -> crate::input::get_email_template_input::Builder {
        crate::input::get_email_template_input::Builder::default()
    }
}

/// See [`GetEndpointInput`](crate::input::GetEndpointInput)
pub mod get_endpoint_input {
    /// A builder for [`GetEndpointInput`](crate::input::GetEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEndpointInput`](crate::input::GetEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEndpointInput {
                application_id: self.application_id,
                endpoint_id: self.endpoint_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEndpointInputOperationOutputAlias = crate::operation::GetEndpoint;
#[doc(hidden)]
pub type GetEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetEndpoint`](crate::operation::GetEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_87 = &_input.application_id;
                let input_87 = input_87.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_87, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_88 = &_input.endpoint_id;
                let input_88 = input_88.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let endpoint_id = aws_smithy_http::label::fmt_string(input_88, false);
                if endpoint_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/endpoints/{EndpointId}",
                    ApplicationId = application_id,
                    EndpointId = endpoint_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEndpoint",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEndpointInput`](crate::input::GetEndpointInput)
    pub fn builder() -> crate::input::get_endpoint_input::Builder {
        crate::input::get_endpoint_input::Builder::default()
    }
}

/// See [`GetEventStreamInput`](crate::input::GetEventStreamInput)
pub mod get_event_stream_input {
    /// A builder for [`GetEventStreamInput`](crate::input::GetEventStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventStreamInput`](crate::input::GetEventStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventStreamInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventStreamInputOperationOutputAlias = crate::operation::GetEventStream;
#[doc(hidden)]
pub type GetEventStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEventStreamInput {
    /// Consumes the builder and constructs an Operation<[`GetEventStream`](crate::operation::GetEventStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEventStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_89 = &_input.application_id;
                let input_89 = input_89.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_89, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/eventstream",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEventStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventStream",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEventStreamInput`](crate::input::GetEventStreamInput)
    pub fn builder() -> crate::input::get_event_stream_input::Builder {
        crate::input::get_event_stream_input::Builder::default()
    }
}

/// See [`GetExportJobInput`](crate::input::GetExportJobInput)
pub mod get_export_job_input {
    /// A builder for [`GetExportJobInput`](crate::input::GetExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportJobInput`](crate::input::GetExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExportJobInput {
                application_id: self.application_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExportJobInputOperationOutputAlias = crate::operation::GetExportJob;
#[doc(hidden)]
pub type GetExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExportJobInput {
    /// Consumes the builder and constructs an Operation<[`GetExportJob`](crate::operation::GetExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_90 = &_input.application_id;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_90, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_91 = &_input.job_id;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_91, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/jobs/export/{JobId}",
                    ApplicationId = application_id,
                    JobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExportJob",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExportJobInput`](crate::input::GetExportJobInput)
    pub fn builder() -> crate::input::get_export_job_input::Builder {
        crate::input::get_export_job_input::Builder::default()
    }
}

/// See [`GetExportJobsInput`](crate::input::GetExportJobsInput)
pub mod get_export_jobs_input {
    /// A builder for [`GetExportJobsInput`](crate::input::GetExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportJobsInput`](crate::input::GetExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExportJobsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExportJobsInputOperationOutputAlias = crate::operation::GetExportJobs;
#[doc(hidden)]
pub type GetExportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetExportJobs`](crate::operation::GetExportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_92 = &_input.application_id;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_92, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/jobs/export",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetExportJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_93) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_93));
                }
                if let Some(inner_94) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_94));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExportJobs",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExportJobsInput`](crate::input::GetExportJobsInput)
    pub fn builder() -> crate::input::get_export_jobs_input::Builder {
        crate::input::get_export_jobs_input::Builder::default()
    }
}

/// See [`GetGcmChannelInput`](crate::input::GetGcmChannelInput)
pub mod get_gcm_channel_input {
    /// A builder for [`GetGcmChannelInput`](crate::input::GetGcmChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGcmChannelInput`](crate::input::GetGcmChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGcmChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGcmChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGcmChannelInputOperationOutputAlias = crate::operation::GetGcmChannel;
#[doc(hidden)]
pub type GetGcmChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGcmChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetGcmChannel`](crate::operation::GetGcmChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGcmChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGcmChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.application_id;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_95, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/gcm",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGcmChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGcmChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGcmChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGcmChannelInput`](crate::input::GetGcmChannelInput)
    pub fn builder() -> crate::input::get_gcm_channel_input::Builder {
        crate::input::get_gcm_channel_input::Builder::default()
    }
}

/// See [`GetImportJobInput`](crate::input::GetImportJobInput)
pub mod get_import_job_input {
    /// A builder for [`GetImportJobInput`](crate::input::GetImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImportJobInput`](crate::input::GetImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImportJobInput {
                application_id: self.application_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImportJobInputOperationOutputAlias = crate::operation::GetImportJob;
#[doc(hidden)]
pub type GetImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImportJobInput {
    /// Consumes the builder and constructs an Operation<[`GetImportJob`](crate::operation::GetImportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_96 = &_input.application_id;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_96, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_97 = &_input.job_id;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_97, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/jobs/import/{JobId}",
                    ApplicationId = application_id,
                    JobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImportJob",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImportJobInput`](crate::input::GetImportJobInput)
    pub fn builder() -> crate::input::get_import_job_input::Builder {
        crate::input::get_import_job_input::Builder::default()
    }
}

/// See [`GetImportJobsInput`](crate::input::GetImportJobsInput)
pub mod get_import_jobs_input {
    /// A builder for [`GetImportJobsInput`](crate::input::GetImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImportJobsInput`](crate::input::GetImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImportJobsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImportJobsInputOperationOutputAlias = crate::operation::GetImportJobs;
#[doc(hidden)]
pub type GetImportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetImportJobs`](crate::operation::GetImportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_98 = &_input.application_id;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_98, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/jobs/import",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetImportJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_99) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_99));
                }
                if let Some(inner_100) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_100));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImportJobs",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImportJobsInput`](crate::input::GetImportJobsInput)
    pub fn builder() -> crate::input::get_import_jobs_input::Builder {
        crate::input::get_import_jobs_input::Builder::default()
    }
}

/// See [`GetInAppMessagesInput`](crate::input::GetInAppMessagesInput)
pub mod get_in_app_messages_input {
    /// A builder for [`GetInAppMessagesInput`](crate::input::GetInAppMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInAppMessagesInput`](crate::input::GetInAppMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInAppMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInAppMessagesInput {
                application_id: self.application_id,
                endpoint_id: self.endpoint_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInAppMessagesInputOperationOutputAlias = crate::operation::GetInAppMessages;
#[doc(hidden)]
pub type GetInAppMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInAppMessagesInput {
    /// Consumes the builder and constructs an Operation<[`GetInAppMessages`](crate::operation::GetInAppMessages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInAppMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInAppMessagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_101 = &_input.application_id;
                let input_101 = input_101.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_101, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_102 = &_input.endpoint_id;
                let input_102 = input_102.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let endpoint_id = aws_smithy_http::label::fmt_string(input_102, false);
                if endpoint_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/endpoints/{EndpointId}/inappmessages",
                    ApplicationId = application_id,
                    EndpointId = endpoint_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInAppMessagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInAppMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInAppMessages",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInAppMessagesInput`](crate::input::GetInAppMessagesInput)
    pub fn builder() -> crate::input::get_in_app_messages_input::Builder {
        crate::input::get_in_app_messages_input::Builder::default()
    }
}

/// See [`GetInAppTemplateInput`](crate::input::GetInAppTemplateInput)
pub mod get_in_app_template_input {
    /// A builder for [`GetInAppTemplateInput`](crate::input::GetInAppTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInAppTemplateInput`](crate::input::GetInAppTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInAppTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInAppTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInAppTemplateInputOperationOutputAlias = crate::operation::GetInAppTemplate;
#[doc(hidden)]
pub type GetInAppTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInAppTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetInAppTemplate`](crate::operation::GetInAppTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInAppTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInAppTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_103 = &_input.template_name;
                let input_103 = input_103.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_103, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/inapp",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetInAppTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_104) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_104));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInAppTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInAppTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInAppTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInAppTemplateInput`](crate::input::GetInAppTemplateInput)
    pub fn builder() -> crate::input::get_in_app_template_input::Builder {
        crate::input::get_in_app_template_input::Builder::default()
    }
}

/// See [`GetJourneyInput`](crate::input::GetJourneyInput)
pub mod get_journey_input {
    /// A builder for [`GetJourneyInput`](crate::input::GetJourneyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJourneyInput`](crate::input::GetJourneyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJourneyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJourneyInput {
                application_id: self.application_id,
                journey_id: self.journey_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJourneyInputOperationOutputAlias = crate::operation::GetJourney;
#[doc(hidden)]
pub type GetJourneyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJourneyInput {
    /// Consumes the builder and constructs an Operation<[`GetJourney`](crate::operation::GetJourney)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJourney,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJourneyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_105 = &_input.application_id;
                let input_105 = input_105.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_105, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_106 = &_input.journey_id;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_106, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys/{JourneyId}",
                    ApplicationId = application_id,
                    JourneyId = journey_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJourneyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJourney::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJourney",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJourneyInput`](crate::input::GetJourneyInput)
    pub fn builder() -> crate::input::get_journey_input::Builder {
        crate::input::get_journey_input::Builder::default()
    }
}

/// See [`GetJourneyDateRangeKpiInput`](crate::input::GetJourneyDateRangeKpiInput)
pub mod get_journey_date_range_kpi_input {
    /// A builder for [`GetJourneyDateRangeKpiInput`](crate::input::GetJourneyDateRangeKpiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
        pub(crate) kpi_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.kpi_name = Some(input.into());
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kpi_name = input;
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJourneyDateRangeKpiInput`](crate::input::GetJourneyDateRangeKpiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJourneyDateRangeKpiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJourneyDateRangeKpiInput {
                application_id: self.application_id,
                end_time: self.end_time,
                journey_id: self.journey_id,
                kpi_name: self.kpi_name,
                next_token: self.next_token,
                page_size: self.page_size,
                start_time: self.start_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJourneyDateRangeKpiInputOperationOutputAlias = crate::operation::GetJourneyDateRangeKpi;
#[doc(hidden)]
pub type GetJourneyDateRangeKpiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJourneyDateRangeKpiInput {
    /// Consumes the builder and constructs an Operation<[`GetJourneyDateRangeKpi`](crate::operation::GetJourneyDateRangeKpi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJourneyDateRangeKpi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJourneyDateRangeKpiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_107 = &_input.application_id;
                let input_107 = input_107.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_107, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_108 = &_input.journey_id;
                let input_108 = input_108.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_108, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_109 = &_input.kpi_name;
                let input_109 = input_109.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "kpi_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let kpi_name = aws_smithy_http::label::fmt_string(input_109, false);
                if kpi_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "kpi_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys/{JourneyId}/kpis/daterange/{KpiName}",
                    ApplicationId = application_id,
                    JourneyId = journey_id,
                    KpiName = kpi_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetJourneyDateRangeKpiInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_110) = &_input.end_time {
                    query.push_kv(
                        "end-time",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_110,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_111) = &_input.next_token {
                    query.push_kv(
                        "next-token",
                        &aws_smithy_http::query::fmt_string(&inner_111),
                    );
                }
                if let Some(inner_112) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_112));
                }
                if let Some(inner_113) = &_input.start_time {
                    query.push_kv(
                        "start-time",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_113,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJourneyDateRangeKpiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJourneyDateRangeKpi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJourneyDateRangeKpi",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJourneyDateRangeKpiInput`](crate::input::GetJourneyDateRangeKpiInput)
    pub fn builder() -> crate::input::get_journey_date_range_kpi_input::Builder {
        crate::input::get_journey_date_range_kpi_input::Builder::default()
    }
}

/// See [`GetJourneyExecutionActivityMetricsInput`](crate::input::GetJourneyExecutionActivityMetricsInput)
pub mod get_journey_execution_activity_metrics_input {
    /// A builder for [`GetJourneyExecutionActivityMetricsInput`](crate::input::GetJourneyExecutionActivityMetricsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) journey_activity_id: std::option::Option<std::string::String>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the journey activity.</p>
        pub fn journey_activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_activity_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey activity.</p>
        pub fn set_journey_activity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.journey_activity_id = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJourneyExecutionActivityMetricsInput`](crate::input::GetJourneyExecutionActivityMetricsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJourneyExecutionActivityMetricsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJourneyExecutionActivityMetricsInput {
                application_id: self.application_id,
                journey_activity_id: self.journey_activity_id,
                journey_id: self.journey_id,
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJourneyExecutionActivityMetricsInputOperationOutputAlias =
    crate::operation::GetJourneyExecutionActivityMetrics;
#[doc(hidden)]
pub type GetJourneyExecutionActivityMetricsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetJourneyExecutionActivityMetricsInput {
    /// Consumes the builder and constructs an Operation<[`GetJourneyExecutionActivityMetrics`](crate::operation::GetJourneyExecutionActivityMetrics)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJourneyExecutionActivityMetrics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJourneyExecutionActivityMetricsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_114 = &_input.application_id;
                let input_114 = input_114.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_114, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_115 = &_input.journey_id;
                let input_115 = input_115.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_115, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_116 = &_input.journey_activity_id;
                let input_116 = input_116.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_activity_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_activity_id = aws_smithy_http::label::fmt_string(input_116, false);
                if journey_activity_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_activity_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apps/{ApplicationId}/journeys/{JourneyId}/activities/{JourneyActivityId}/execution-metrics", ApplicationId = application_id, JourneyId = journey_id, JourneyActivityId = journey_activity_id).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetJourneyExecutionActivityMetricsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_117) = &_input.next_token {
                    query.push_kv(
                        "next-token",
                        &aws_smithy_http::query::fmt_string(&inner_117),
                    );
                }
                if let Some(inner_118) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_118));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJourneyExecutionActivityMetricsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJourneyExecutionActivityMetrics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJourneyExecutionActivityMetrics",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJourneyExecutionActivityMetricsInput`](crate::input::GetJourneyExecutionActivityMetricsInput)
    pub fn builder() -> crate::input::get_journey_execution_activity_metrics_input::Builder {
        crate::input::get_journey_execution_activity_metrics_input::Builder::default()
    }
}

/// See [`GetJourneyExecutionMetricsInput`](crate::input::GetJourneyExecutionMetricsInput)
pub mod get_journey_execution_metrics_input {
    /// A builder for [`GetJourneyExecutionMetricsInput`](crate::input::GetJourneyExecutionMetricsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJourneyExecutionMetricsInput`](crate::input::GetJourneyExecutionMetricsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJourneyExecutionMetricsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJourneyExecutionMetricsInput {
                application_id: self.application_id,
                journey_id: self.journey_id,
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJourneyExecutionMetricsInputOperationOutputAlias =
    crate::operation::GetJourneyExecutionMetrics;
#[doc(hidden)]
pub type GetJourneyExecutionMetricsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJourneyExecutionMetricsInput {
    /// Consumes the builder and constructs an Operation<[`GetJourneyExecutionMetrics`](crate::operation::GetJourneyExecutionMetrics)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJourneyExecutionMetrics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJourneyExecutionMetricsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_119 = &_input.application_id;
                let input_119 = input_119.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_119, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_120 = &_input.journey_id;
                let input_120 = input_120.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_120, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys/{JourneyId}/execution-metrics",
                    ApplicationId = application_id,
                    JourneyId = journey_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetJourneyExecutionMetricsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_121) = &_input.next_token {
                    query.push_kv(
                        "next-token",
                        &aws_smithy_http::query::fmt_string(&inner_121),
                    );
                }
                if let Some(inner_122) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_122));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJourneyExecutionMetricsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJourneyExecutionMetrics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJourneyExecutionMetrics",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJourneyExecutionMetricsInput`](crate::input::GetJourneyExecutionMetricsInput)
    pub fn builder() -> crate::input::get_journey_execution_metrics_input::Builder {
        crate::input::get_journey_execution_metrics_input::Builder::default()
    }
}

/// See [`GetPushTemplateInput`](crate::input::GetPushTemplateInput)
pub mod get_push_template_input {
    /// A builder for [`GetPushTemplateInput`](crate::input::GetPushTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPushTemplateInput`](crate::input::GetPushTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPushTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPushTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPushTemplateInputOperationOutputAlias = crate::operation::GetPushTemplate;
#[doc(hidden)]
pub type GetPushTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPushTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetPushTemplate`](crate::operation::GetPushTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPushTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPushTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_123 = &_input.template_name;
                let input_123 = input_123.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_123, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/push",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetPushTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_124) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_124));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPushTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPushTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPushTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPushTemplateInput`](crate::input::GetPushTemplateInput)
    pub fn builder() -> crate::input::get_push_template_input::Builder {
        crate::input::get_push_template_input::Builder::default()
    }
}

/// See [`GetRecommenderConfigurationInput`](crate::input::GetRecommenderConfigurationInput)
pub mod get_recommender_configuration_input {
    /// A builder for [`GetRecommenderConfigurationInput`](crate::input::GetRecommenderConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommenderConfigurationInput`](crate::input::GetRecommenderConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecommenderConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecommenderConfigurationInput {
                recommender_id: self.recommender_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecommenderConfigurationInputOperationOutputAlias =
    crate::operation::GetRecommenderConfiguration;
#[doc(hidden)]
pub type GetRecommenderConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRecommenderConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetRecommenderConfiguration`](crate::operation::GetRecommenderConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecommenderConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRecommenderConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_125 = &_input.recommender_id;
                let input_125 = input_125.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "recommender_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let recommender_id = aws_smithy_http::label::fmt_string(input_125, false);
                if recommender_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recommender_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/recommenders/{RecommenderId}",
                    RecommenderId = recommender_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRecommenderConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecommenderConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecommenderConfiguration",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRecommenderConfigurationInput`](crate::input::GetRecommenderConfigurationInput)
    pub fn builder() -> crate::input::get_recommender_configuration_input::Builder {
        crate::input::get_recommender_configuration_input::Builder::default()
    }
}

/// See [`GetRecommenderConfigurationsInput`](crate::input::GetRecommenderConfigurationsInput)
pub mod get_recommender_configurations_input {
    /// A builder for [`GetRecommenderConfigurationsInput`](crate::input::GetRecommenderConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommenderConfigurationsInput`](crate::input::GetRecommenderConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecommenderConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecommenderConfigurationsInput {
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecommenderConfigurationsInputOperationOutputAlias =
    crate::operation::GetRecommenderConfigurations;
#[doc(hidden)]
pub type GetRecommenderConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRecommenderConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`GetRecommenderConfigurations`](crate::operation::GetRecommenderConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecommenderConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRecommenderConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/recommenders").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetRecommenderConfigurationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_126) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_126));
                }
                if let Some(inner_127) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_127));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRecommenderConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecommenderConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecommenderConfigurations",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRecommenderConfigurationsInput`](crate::input::GetRecommenderConfigurationsInput)
    pub fn builder() -> crate::input::get_recommender_configurations_input::Builder {
        crate::input::get_recommender_configurations_input::Builder::default()
    }
}

/// See [`GetSegmentInput`](crate::input::GetSegmentInput)
pub mod get_segment_input {
    /// A builder for [`GetSegmentInput`](crate::input::GetSegmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSegmentInput`](crate::input::GetSegmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSegmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSegmentInput {
                application_id: self.application_id,
                segment_id: self.segment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSegmentInputOperationOutputAlias = crate::operation::GetSegment;
#[doc(hidden)]
pub type GetSegmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSegmentInput {
    /// Consumes the builder and constructs an Operation<[`GetSegment`](crate::operation::GetSegment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSegment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSegmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_128 = &_input.application_id;
                let input_128 = input_128.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_128, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_129 = &_input.segment_id;
                let input_129 = input_129.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_129, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}",
                    ApplicationId = application_id,
                    SegmentId = segment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSegmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSegment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSegment",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSegmentInput`](crate::input::GetSegmentInput)
    pub fn builder() -> crate::input::get_segment_input::Builder {
        crate::input::get_segment_input::Builder::default()
    }
}

/// See [`GetSegmentExportJobsInput`](crate::input::GetSegmentExportJobsInput)
pub mod get_segment_export_jobs_input {
    /// A builder for [`GetSegmentExportJobsInput`](crate::input::GetSegmentExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSegmentExportJobsInput`](crate::input::GetSegmentExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSegmentExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSegmentExportJobsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                segment_id: self.segment_id,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSegmentExportJobsInputOperationOutputAlias = crate::operation::GetSegmentExportJobs;
#[doc(hidden)]
pub type GetSegmentExportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSegmentExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetSegmentExportJobs`](crate::operation::GetSegmentExportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSegmentExportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSegmentExportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_130 = &_input.application_id;
                let input_130 = input_130.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_130, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_131 = &_input.segment_id;
                let input_131 = input_131.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_131, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}/jobs/export",
                    ApplicationId = application_id,
                    SegmentId = segment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSegmentExportJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_132) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_132));
                }
                if let Some(inner_133) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_133));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSegmentExportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSegmentExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSegmentExportJobs",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSegmentExportJobsInput`](crate::input::GetSegmentExportJobsInput)
    pub fn builder() -> crate::input::get_segment_export_jobs_input::Builder {
        crate::input::get_segment_export_jobs_input::Builder::default()
    }
}

/// See [`GetSegmentImportJobsInput`](crate::input::GetSegmentImportJobsInput)
pub mod get_segment_import_jobs_input {
    /// A builder for [`GetSegmentImportJobsInput`](crate::input::GetSegmentImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSegmentImportJobsInput`](crate::input::GetSegmentImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSegmentImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSegmentImportJobsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                segment_id: self.segment_id,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSegmentImportJobsInputOperationOutputAlias = crate::operation::GetSegmentImportJobs;
#[doc(hidden)]
pub type GetSegmentImportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSegmentImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetSegmentImportJobs`](crate::operation::GetSegmentImportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSegmentImportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSegmentImportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_134 = &_input.application_id;
                let input_134 = input_134.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_134, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_135 = &_input.segment_id;
                let input_135 = input_135.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_135, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}/jobs/import",
                    ApplicationId = application_id,
                    SegmentId = segment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSegmentImportJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_136) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_136));
                }
                if let Some(inner_137) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_137));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSegmentImportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSegmentImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSegmentImportJobs",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSegmentImportJobsInput`](crate::input::GetSegmentImportJobsInput)
    pub fn builder() -> crate::input::get_segment_import_jobs_input::Builder {
        crate::input::get_segment_import_jobs_input::Builder::default()
    }
}

/// See [`GetSegmentsInput`](crate::input::GetSegmentsInput)
pub mod get_segments_input {
    /// A builder for [`GetSegmentsInput`](crate::input::GetSegmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSegmentsInput`](crate::input::GetSegmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSegmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSegmentsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSegmentsInputOperationOutputAlias = crate::operation::GetSegments;
#[doc(hidden)]
pub type GetSegmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSegmentsInput {
    /// Consumes the builder and constructs an Operation<[`GetSegments`](crate::operation::GetSegments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSegments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSegmentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_138 = &_input.application_id;
                let input_138 = input_138.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_138, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSegmentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_139) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_139));
                }
                if let Some(inner_140) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_140));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSegmentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSegments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSegments",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSegmentsInput`](crate::input::GetSegmentsInput)
    pub fn builder() -> crate::input::get_segments_input::Builder {
        crate::input::get_segments_input::Builder::default()
    }
}

/// See [`GetSegmentVersionInput`](crate::input::GetSegmentVersionInput)
pub mod get_segment_version_input {
    /// A builder for [`GetSegmentVersionInput`](crate::input::GetSegmentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSegmentVersionInput`](crate::input::GetSegmentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSegmentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSegmentVersionInput {
                application_id: self.application_id,
                segment_id: self.segment_id,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSegmentVersionInputOperationOutputAlias = crate::operation::GetSegmentVersion;
#[doc(hidden)]
pub type GetSegmentVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSegmentVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetSegmentVersion`](crate::operation::GetSegmentVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSegmentVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSegmentVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_141 = &_input.application_id;
                let input_141 = input_141.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_141, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_142 = &_input.segment_id;
                let input_142 = input_142.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_142, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_143 = &_input.version;
                let input_143 = input_143.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version = aws_smithy_http::label::fmt_string(input_143, false);
                if version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}/versions/{Version}",
                    ApplicationId = application_id,
                    SegmentId = segment_id,
                    Version = version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSegmentVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSegmentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSegmentVersion",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSegmentVersionInput`](crate::input::GetSegmentVersionInput)
    pub fn builder() -> crate::input::get_segment_version_input::Builder {
        crate::input::get_segment_version_input::Builder::default()
    }
}

/// See [`GetSegmentVersionsInput`](crate::input::GetSegmentVersionsInput)
pub mod get_segment_versions_input {
    /// A builder for [`GetSegmentVersionsInput`](crate::input::GetSegmentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSegmentVersionsInput`](crate::input::GetSegmentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSegmentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSegmentVersionsInput {
                application_id: self.application_id,
                page_size: self.page_size,
                segment_id: self.segment_id,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSegmentVersionsInputOperationOutputAlias = crate::operation::GetSegmentVersions;
#[doc(hidden)]
pub type GetSegmentVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSegmentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetSegmentVersions`](crate::operation::GetSegmentVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSegmentVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSegmentVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_144 = &_input.application_id;
                let input_144 = input_144.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_144, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_145 = &_input.segment_id;
                let input_145 = input_145.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_145, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}/versions",
                    ApplicationId = application_id,
                    SegmentId = segment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSegmentVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_146) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_146));
                }
                if let Some(inner_147) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_147));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSegmentVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSegmentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSegmentVersions",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSegmentVersionsInput`](crate::input::GetSegmentVersionsInput)
    pub fn builder() -> crate::input::get_segment_versions_input::Builder {
        crate::input::get_segment_versions_input::Builder::default()
    }
}

/// See [`GetSmsChannelInput`](crate::input::GetSmsChannelInput)
pub mod get_sms_channel_input {
    /// A builder for [`GetSmsChannelInput`](crate::input::GetSmsChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSmsChannelInput`](crate::input::GetSmsChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSmsChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSmsChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSmsChannelInputOperationOutputAlias = crate::operation::GetSmsChannel;
#[doc(hidden)]
pub type GetSmsChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSmsChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetSmsChannel`](crate::operation::GetSmsChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSmsChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSmsChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_148 = &_input.application_id;
                let input_148 = input_148.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_148, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/sms",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSmsChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSmsChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSmsChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSmsChannelInput`](crate::input::GetSmsChannelInput)
    pub fn builder() -> crate::input::get_sms_channel_input::Builder {
        crate::input::get_sms_channel_input::Builder::default()
    }
}

/// See [`GetSmsTemplateInput`](crate::input::GetSmsTemplateInput)
pub mod get_sms_template_input {
    /// A builder for [`GetSmsTemplateInput`](crate::input::GetSmsTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSmsTemplateInput`](crate::input::GetSmsTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSmsTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSmsTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSmsTemplateInputOperationOutputAlias = crate::operation::GetSmsTemplate;
#[doc(hidden)]
pub type GetSmsTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSmsTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetSmsTemplate`](crate::operation::GetSmsTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSmsTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSmsTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_149 = &_input.template_name;
                let input_149 = input_149.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_149, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/sms",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSmsTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_150) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_150));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSmsTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSmsTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSmsTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSmsTemplateInput`](crate::input::GetSmsTemplateInput)
    pub fn builder() -> crate::input::get_sms_template_input::Builder {
        crate::input::get_sms_template_input::Builder::default()
    }
}

/// See [`GetUserEndpointsInput`](crate::input::GetUserEndpointsInput)
pub mod get_user_endpoints_input {
    /// A builder for [`GetUserEndpointsInput`](crate::input::GetUserEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserEndpointsInput`](crate::input::GetUserEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUserEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUserEndpointsInput {
                application_id: self.application_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserEndpointsInputOperationOutputAlias = crate::operation::GetUserEndpoints;
#[doc(hidden)]
pub type GetUserEndpointsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`GetUserEndpoints`](crate::operation::GetUserEndpoints)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUserEndpoints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetUserEndpointsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_151 = &_input.application_id;
                let input_151 = input_151.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_151, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_152 = &_input.user_id;
                let input_152 = input_152.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_152, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/users/{UserId}",
                    ApplicationId = application_id,
                    UserId = user_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetUserEndpointsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUserEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUserEndpoints",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetUserEndpointsInput`](crate::input::GetUserEndpointsInput)
    pub fn builder() -> crate::input::get_user_endpoints_input::Builder {
        crate::input::get_user_endpoints_input::Builder::default()
    }
}

/// See [`GetVoiceChannelInput`](crate::input::GetVoiceChannelInput)
pub mod get_voice_channel_input {
    /// A builder for [`GetVoiceChannelInput`](crate::input::GetVoiceChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceChannelInput`](crate::input::GetVoiceChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceChannelInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceChannelInputOperationOutputAlias = crate::operation::GetVoiceChannel;
#[doc(hidden)]
pub type GetVoiceChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceChannel`](crate::operation::GetVoiceChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetVoiceChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_153 = &_input.application_id;
                let input_153 = input_153.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_153, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/voice",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetVoiceChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceChannelInput`](crate::input::GetVoiceChannelInput)
    pub fn builder() -> crate::input::get_voice_channel_input::Builder {
        crate::input::get_voice_channel_input::Builder::default()
    }
}

/// See [`GetVoiceTemplateInput`](crate::input::GetVoiceTemplateInput)
pub mod get_voice_template_input {
    /// A builder for [`GetVoiceTemplateInput`](crate::input::GetVoiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVoiceTemplateInput`](crate::input::GetVoiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVoiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVoiceTemplateInput {
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVoiceTemplateInputOperationOutputAlias = crate::operation::GetVoiceTemplate;
#[doc(hidden)]
pub type GetVoiceTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVoiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetVoiceTemplate`](crate::operation::GetVoiceTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVoiceTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetVoiceTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_154 = &_input.template_name;
                let input_154 = input_154.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_154, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/voice",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetVoiceTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_155) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_155));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetVoiceTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVoiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVoiceTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetVoiceTemplateInput`](crate::input::GetVoiceTemplateInput)
    pub fn builder() -> crate::input::get_voice_template_input::Builder {
        crate::input::get_voice_template_input::Builder::default()
    }
}

/// See [`ListJourneysInput`](crate::input::ListJourneysInput)
pub mod list_journeys_input {
    /// A builder for [`ListJourneysInput`](crate::input::ListJourneysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJourneysInput`](crate::input::ListJourneysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListJourneysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListJourneysInput {
                application_id: self.application_id,
                page_size: self.page_size,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJourneysInputOperationOutputAlias = crate::operation::ListJourneys;
#[doc(hidden)]
pub type ListJourneysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListJourneysInput {
    /// Consumes the builder and constructs an Operation<[`ListJourneys`](crate::operation::ListJourneys)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJourneys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListJourneysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_156 = &_input.application_id;
                let input_156 = input_156.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_156, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListJourneysInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_157) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_157));
                }
                if let Some(inner_158) = &_input.token {
                    query.push_kv("token", &aws_smithy_http::query::fmt_string(&inner_158));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListJourneysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListJourneys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListJourneys",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListJourneysInput`](crate::input::ListJourneysInput)
    pub fn builder() -> crate::input::list_journeys_input::Builder {
        crate::input::list_journeys_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_159 = &_input.resource_arn;
                let input_159 = input_159.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_159, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTemplatesInput`](crate::input::ListTemplatesInput)
pub mod list_templates_input {
    /// A builder for [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) template_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
        pub fn template_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_type = Some(input.into());
            self
        }
        /// <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplatesInput`](crate::input::ListTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTemplatesInput {
                next_token: self.next_token,
                page_size: self.page_size,
                prefix: self.prefix,
                template_type: self.template_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTemplatesInputOperationOutputAlias = crate::operation::ListTemplates;
#[doc(hidden)]
pub type ListTemplatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListTemplates`](crate::operation::ListTemplates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTemplatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/templates").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTemplatesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_160) = &_input.next_token {
                    query.push_kv(
                        "next-token",
                        &aws_smithy_http::query::fmt_string(&inner_160),
                    );
                }
                if let Some(inner_161) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_161));
                }
                if let Some(inner_162) = &_input.prefix {
                    query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_162));
                }
                if let Some(inner_163) = &_input.template_type {
                    query.push_kv(
                        "template-type",
                        &aws_smithy_http::query::fmt_string(&inner_163),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTemplatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTemplates",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    pub fn builder() -> crate::input::list_templates_input::Builder {
        crate::input::list_templates_input::Builder::default()
    }
}

/// See [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
pub mod list_template_versions_input {
    /// A builder for [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_size = Some(input.into());
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn template_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_type = Some(input.into());
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTemplateVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTemplateVersionsInput {
                next_token: self.next_token,
                page_size: self.page_size,
                template_name: self.template_name,
                template_type: self.template_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTemplateVersionsInputOperationOutputAlias = crate::operation::ListTemplateVersions;
#[doc(hidden)]
pub type ListTemplateVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTemplateVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTemplateVersions`](crate::operation::ListTemplateVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTemplateVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTemplateVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_164 = &_input.template_name;
                let input_164 = input_164.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_164, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_165 = &_input.template_type;
                let input_165 = input_165.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_type = aws_smithy_http::label::fmt_string(input_165, false);
                if template_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/{TemplateType}/versions",
                    TemplateName = template_name,
                    TemplateType = template_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTemplateVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_166) = &_input.next_token {
                    query.push_kv(
                        "next-token",
                        &aws_smithy_http::query::fmt_string(&inner_166),
                    );
                }
                if let Some(inner_167) = &_input.page_size {
                    query.push_kv("page-size", &aws_smithy_http::query::fmt_string(&inner_167));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTemplateVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTemplateVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTemplateVersions",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
    pub fn builder() -> crate::input::list_template_versions_input::Builder {
        crate::input::list_template_versions_input::Builder::default()
    }
}

/// See [`PhoneNumberValidateInput`](crate::input::PhoneNumberValidateInput)
pub mod phone_number_validate_input {
    /// A builder for [`PhoneNumberValidateInput`](crate::input::PhoneNumberValidateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_validate_request:
            std::option::Option<crate::model::NumberValidateRequest>,
    }
    impl Builder {
        /// <p>Specifies a phone number to validate and retrieve information about.</p>
        pub fn number_validate_request(
            mut self,
            input: crate::model::NumberValidateRequest,
        ) -> Self {
            self.number_validate_request = Some(input);
            self
        }
        /// <p>Specifies a phone number to validate and retrieve information about.</p>
        pub fn set_number_validate_request(
            mut self,
            input: std::option::Option<crate::model::NumberValidateRequest>,
        ) -> Self {
            self.number_validate_request = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberValidateInput`](crate::input::PhoneNumberValidateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PhoneNumberValidateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PhoneNumberValidateInput {
                number_validate_request: self.number_validate_request,
            })
        }
    }
}
#[doc(hidden)]
pub type PhoneNumberValidateInputOperationOutputAlias = crate::operation::PhoneNumberValidate;
#[doc(hidden)]
pub type PhoneNumberValidateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PhoneNumberValidateInput {
    /// Consumes the builder and constructs an Operation<[`PhoneNumberValidate`](crate::operation::PhoneNumberValidate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PhoneNumberValidate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PhoneNumberValidateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/phone/number/validate").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PhoneNumberValidateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_phone_number_validate_input(
                &self.number_validate_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PhoneNumberValidate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PhoneNumberValidate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PhoneNumberValidateInput`](crate::input::PhoneNumberValidateInput)
    pub fn builder() -> crate::input::phone_number_validate_input::Builder {
        crate::input::phone_number_validate_input::Builder::default()
    }
}

/// See [`PutEventsInput`](crate::input::PutEventsInput)
pub mod put_events_input {
    /// A builder for [`PutEventsInput`](crate::input::PutEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) events_request: std::option::Option<crate::model::EventsRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies a batch of events to process.</p>
        pub fn events_request(mut self, input: crate::model::EventsRequest) -> Self {
            self.events_request = Some(input);
            self
        }
        /// <p>Specifies a batch of events to process.</p>
        pub fn set_events_request(
            mut self,
            input: std::option::Option<crate::model::EventsRequest>,
        ) -> Self {
            self.events_request = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventsInput`](crate::input::PutEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutEventsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutEventsInput {
                application_id: self.application_id,
                events_request: self.events_request,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEventsInputOperationOutputAlias = crate::operation::PutEvents;
#[doc(hidden)]
pub type PutEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutEventsInput {
    /// Consumes the builder and constructs an Operation<[`PutEvents`](crate::operation::PutEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_168 = &_input.application_id;
                let input_168 = input_168.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_168, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/events",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_events_input(&self.events_request)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutEvents::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutEvents",
                    "pinpoint",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEventsInput`](crate::input::PutEventsInput)
    pub fn builder() -> crate::input::put_events_input::Builder {
        crate::input::put_events_input::Builder::default()
    }
}

/// See [`PutEventStreamInput`](crate::input::PutEventStreamInput)
pub mod put_event_stream_input {
    /// A builder for [`PutEventStreamInput`](crate::input::PutEventStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) write_event_stream: std::option::Option<crate::model::WriteEventStream>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
        pub fn write_event_stream(mut self, input: crate::model::WriteEventStream) -> Self {
            self.write_event_stream = Some(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
        pub fn set_write_event_stream(
            mut self,
            input: std::option::Option<crate::model::WriteEventStream>,
        ) -> Self {
            self.write_event_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventStreamInput`](crate::input::PutEventStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEventStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEventStreamInput {
                application_id: self.application_id,
                write_event_stream: self.write_event_stream,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEventStreamInputOperationOutputAlias = crate::operation::PutEventStream;
#[doc(hidden)]
pub type PutEventStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutEventStreamInput {
    /// Consumes the builder and constructs an Operation<[`PutEventStream`](crate::operation::PutEventStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEventStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEventStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_169 = &_input.application_id;
                let input_169 = input_169.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_169, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/eventstream",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEventStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_event_stream_input(
                &self.write_event_stream,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEventStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEventStream",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEventStreamInput`](crate::input::PutEventStreamInput)
    pub fn builder() -> crate::input::put_event_stream_input::Builder {
        crate::input::put_event_stream_input::Builder::default()
    }
}

/// See [`RemoveAttributesInput`](crate::input::RemoveAttributesInput)
pub mod remove_attributes_input {
    /// A builder for [`RemoveAttributesInput`](crate::input::RemoveAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) attribute_type: std::option::Option<std::string::String>,
        pub(crate) update_attributes_request:
            std::option::Option<crate::model::UpdateAttributesRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The type of attribute or attributes to remove. Valid values are:</p>
        /// <ul>
        /// <li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li>
        /// <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li>
        /// <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li>
        /// </ul>
        pub fn attribute_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_type = Some(input.into());
            self
        }
        /// <p>The type of attribute or attributes to remove. Valid values are:</p>
        /// <ul>
        /// <li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li>
        /// <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li>
        /// <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li>
        /// </ul>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
        pub fn update_attributes_request(
            mut self,
            input: crate::model::UpdateAttributesRequest,
        ) -> Self {
            self.update_attributes_request = Some(input);
            self
        }
        /// <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
        pub fn set_update_attributes_request(
            mut self,
            input: std::option::Option<crate::model::UpdateAttributesRequest>,
        ) -> Self {
            self.update_attributes_request = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAttributesInput`](crate::input::RemoveAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAttributesInput {
                application_id: self.application_id,
                attribute_type: self.attribute_type,
                update_attributes_request: self.update_attributes_request,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAttributesInputOperationOutputAlias = crate::operation::RemoveAttributes;
#[doc(hidden)]
pub type RemoveAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveAttributesInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAttributes`](crate::operation::RemoveAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_170 = &_input.application_id;
                let input_170 = input_170.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_170, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_171 = &_input.attribute_type;
                let input_171 = input_171.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "attribute_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let attribute_type = aws_smithy_http::label::fmt_string(input_171, false);
                if attribute_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attribute_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/attributes/{AttributeType}",
                    ApplicationId = application_id,
                    AttributeType = attribute_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_remove_attributes_input(
                &self.update_attributes_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAttributes",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveAttributesInput`](crate::input::RemoveAttributesInput)
    pub fn builder() -> crate::input::remove_attributes_input::Builder {
        crate::input::remove_attributes_input::Builder::default()
    }
}

/// See [`SendMessagesInput`](crate::input::SendMessagesInput)
pub mod send_messages_input {
    /// A builder for [`SendMessagesInput`](crate::input::SendMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) message_request: std::option::Option<crate::model::MessageRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the configuration and other settings for a message.</p>
        pub fn message_request(mut self, input: crate::model::MessageRequest) -> Self {
            self.message_request = Some(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message.</p>
        pub fn set_message_request(
            mut self,
            input: std::option::Option<crate::model::MessageRequest>,
        ) -> Self {
            self.message_request = input;
            self
        }
        /// Consumes the builder and constructs a [`SendMessagesInput`](crate::input::SendMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendMessagesInput {
                application_id: self.application_id,
                message_request: self.message_request,
            })
        }
    }
}
#[doc(hidden)]
pub type SendMessagesInputOperationOutputAlias = crate::operation::SendMessages;
#[doc(hidden)]
pub type SendMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendMessagesInput {
    /// Consumes the builder and constructs an Operation<[`SendMessages`](crate::operation::SendMessages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendMessagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_172 = &_input.application_id;
                let input_172 = input_172.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_172, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/messages",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendMessagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_send_messages_input(&self.message_request)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendMessages",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendMessagesInput`](crate::input::SendMessagesInput)
    pub fn builder() -> crate::input::send_messages_input::Builder {
        crate::input::send_messages_input::Builder::default()
    }
}

/// See [`SendOtpMessageInput`](crate::input::SendOtpMessageInput)
pub mod send_otp_message_input {
    /// A builder for [`SendOtpMessageInput`](crate::input::SendOtpMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) send_otp_message_request_parameters:
            std::option::Option<crate::model::SendOtpMessageRequestParameters>,
    }
    impl Builder {
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Send OTP message request parameters.</p>
        pub fn send_otp_message_request_parameters(
            mut self,
            input: crate::model::SendOtpMessageRequestParameters,
        ) -> Self {
            self.send_otp_message_request_parameters = Some(input);
            self
        }
        /// <p>Send OTP message request parameters.</p>
        pub fn set_send_otp_message_request_parameters(
            mut self,
            input: std::option::Option<crate::model::SendOtpMessageRequestParameters>,
        ) -> Self {
            self.send_otp_message_request_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`SendOtpMessageInput`](crate::input::SendOtpMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendOtpMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendOtpMessageInput {
                application_id: self.application_id,
                send_otp_message_request_parameters: self.send_otp_message_request_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type SendOtpMessageInputOperationOutputAlias = crate::operation::SendOTPMessage;
#[doc(hidden)]
pub type SendOtpMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendOtpMessageInput {
    /// Consumes the builder and constructs an Operation<[`SendOTPMessage`](crate::operation::SendOTPMessage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendOTPMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendOtpMessageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_173 = &_input.application_id;
                let input_173 = input_173.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_173, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/otp",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendOtpMessageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_send_otp_message_input(
                &self.send_otp_message_request_parameters,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendOTPMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendOTPMessage",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendOtpMessageInput`](crate::input::SendOtpMessageInput)
    pub fn builder() -> crate::input::send_otp_message_input::Builder {
        crate::input::send_otp_message_input::Builder::default()
    }
}

/// See [`SendUsersMessagesInput`](crate::input::SendUsersMessagesInput)
pub mod send_users_messages_input {
    /// A builder for [`SendUsersMessagesInput`](crate::input::SendUsersMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) send_users_message_request:
            std::option::Option<crate::model::SendUsersMessageRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
        pub fn send_users_message_request(
            mut self,
            input: crate::model::SendUsersMessageRequest,
        ) -> Self {
            self.send_users_message_request = Some(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
        pub fn set_send_users_message_request(
            mut self,
            input: std::option::Option<crate::model::SendUsersMessageRequest>,
        ) -> Self {
            self.send_users_message_request = input;
            self
        }
        /// Consumes the builder and constructs a [`SendUsersMessagesInput`](crate::input::SendUsersMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendUsersMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendUsersMessagesInput {
                application_id: self.application_id,
                send_users_message_request: self.send_users_message_request,
            })
        }
    }
}
#[doc(hidden)]
pub type SendUsersMessagesInputOperationOutputAlias = crate::operation::SendUsersMessages;
#[doc(hidden)]
pub type SendUsersMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendUsersMessagesInput {
    /// Consumes the builder and constructs an Operation<[`SendUsersMessages`](crate::operation::SendUsersMessages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendUsersMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendUsersMessagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_174 = &_input.application_id;
                let input_174 = input_174.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_174, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/users-messages",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendUsersMessagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_send_users_messages_input(
                &self.send_users_message_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendUsersMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendUsersMessages",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendUsersMessagesInput`](crate::input::SendUsersMessagesInput)
    pub fn builder() -> crate::input::send_users_messages_input::Builder {
        crate::input::send_users_messages_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags_model: std::option::Option<crate::model::TagsModel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
        pub fn tags_model(mut self, input: crate::model::TagsModel) -> Self {
            self.tags_model = Some(input);
            self
        }
        /// <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
        pub fn set_tags_model(
            mut self,
            input: std::option::Option<crate::model::TagsModel>,
        ) -> Self {
            self.tags_model = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags_model: self.tags_model,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_175 = &_input.resource_arn;
                let input_175 = input_175.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_175, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_tag_resource_input(&self.tags_model)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_176 = &_input.resource_arn;
                let input_176 = input_176.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_176, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_177) = &_input.tag_keys {
                    for inner_178 in inner_177 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_178));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAdmChannelInput`](crate::input::UpdateAdmChannelInput)
pub mod update_adm_channel_input {
    /// A builder for [`UpdateAdmChannelInput`](crate::input::UpdateAdmChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adm_channel_request: std::option::Option<crate::model::AdmChannelRequest>,
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
        pub fn adm_channel_request(mut self, input: crate::model::AdmChannelRequest) -> Self {
            self.adm_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
        pub fn set_adm_channel_request(
            mut self,
            input: std::option::Option<crate::model::AdmChannelRequest>,
        ) -> Self {
            self.adm_channel_request = input;
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAdmChannelInput`](crate::input::UpdateAdmChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAdmChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAdmChannelInput {
                adm_channel_request: self.adm_channel_request,
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAdmChannelInputOperationOutputAlias = crate::operation::UpdateAdmChannel;
#[doc(hidden)]
pub type UpdateAdmChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAdmChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAdmChannel`](crate::operation::UpdateAdmChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAdmChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateAdmChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_179 = &_input.application_id;
                let input_179 = input_179.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_179, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/adm",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateAdmChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_adm_channel_input(
                &self.adm_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAdmChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAdmChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateAdmChannelInput`](crate::input::UpdateAdmChannelInput)
    pub fn builder() -> crate::input::update_adm_channel_input::Builder {
        crate::input::update_adm_channel_input::Builder::default()
    }
}

/// See [`UpdateApnsChannelInput`](crate::input::UpdateApnsChannelInput)
pub mod update_apns_channel_input {
    /// A builder for [`UpdateApnsChannelInput`](crate::input::UpdateApnsChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apns_channel_request: std::option::Option<crate::model::ApnsChannelRequest>,
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
        pub fn apns_channel_request(mut self, input: crate::model::ApnsChannelRequest) -> Self {
            self.apns_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
        pub fn set_apns_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsChannelRequest>,
        ) -> Self {
            self.apns_channel_request = input;
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApnsChannelInput`](crate::input::UpdateApnsChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApnsChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApnsChannelInput {
                apns_channel_request: self.apns_channel_request,
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApnsChannelInputOperationOutputAlias = crate::operation::UpdateApnsChannel;
#[doc(hidden)]
pub type UpdateApnsChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApnsChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApnsChannel`](crate::operation::UpdateApnsChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApnsChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApnsChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_180 = &_input.application_id;
                let input_180 = input_180.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_180, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApnsChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_apns_channel_input(
                &self.apns_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApnsChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApnsChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApnsChannelInput`](crate::input::UpdateApnsChannelInput)
    pub fn builder() -> crate::input::update_apns_channel_input::Builder {
        crate::input::update_apns_channel_input::Builder::default()
    }
}

/// See [`UpdateApnsSandboxChannelInput`](crate::input::UpdateApnsSandboxChannelInput)
pub mod update_apns_sandbox_channel_input {
    /// A builder for [`UpdateApnsSandboxChannelInput`](crate::input::UpdateApnsSandboxChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apns_sandbox_channel_request:
            std::option::Option<crate::model::ApnsSandboxChannelRequest>,
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
        pub fn apns_sandbox_channel_request(
            mut self,
            input: crate::model::ApnsSandboxChannelRequest,
        ) -> Self {
            self.apns_sandbox_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
        pub fn set_apns_sandbox_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsSandboxChannelRequest>,
        ) -> Self {
            self.apns_sandbox_channel_request = input;
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApnsSandboxChannelInput`](crate::input::UpdateApnsSandboxChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApnsSandboxChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApnsSandboxChannelInput {
                apns_sandbox_channel_request: self.apns_sandbox_channel_request,
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApnsSandboxChannelInputOperationOutputAlias =
    crate::operation::UpdateApnsSandboxChannel;
#[doc(hidden)]
pub type UpdateApnsSandboxChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApnsSandboxChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApnsSandboxChannel`](crate::operation::UpdateApnsSandboxChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApnsSandboxChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApnsSandboxChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_181 = &_input.application_id;
                let input_181 = input_181.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_181, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_sandbox",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApnsSandboxChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_apns_sandbox_channel_input(
                &self.apns_sandbox_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApnsSandboxChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApnsSandboxChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApnsSandboxChannelInput`](crate::input::UpdateApnsSandboxChannelInput)
    pub fn builder() -> crate::input::update_apns_sandbox_channel_input::Builder {
        crate::input::update_apns_sandbox_channel_input::Builder::default()
    }
}

/// See [`UpdateApnsVoipChannelInput`](crate::input::UpdateApnsVoipChannelInput)
pub mod update_apns_voip_channel_input {
    /// A builder for [`UpdateApnsVoipChannelInput`](crate::input::UpdateApnsVoipChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apns_voip_channel_request:
            std::option::Option<crate::model::ApnsVoipChannelRequest>,
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
        pub fn apns_voip_channel_request(
            mut self,
            input: crate::model::ApnsVoipChannelRequest,
        ) -> Self {
            self.apns_voip_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
        pub fn set_apns_voip_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsVoipChannelRequest>,
        ) -> Self {
            self.apns_voip_channel_request = input;
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApnsVoipChannelInput`](crate::input::UpdateApnsVoipChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApnsVoipChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApnsVoipChannelInput {
                apns_voip_channel_request: self.apns_voip_channel_request,
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApnsVoipChannelInputOperationOutputAlias = crate::operation::UpdateApnsVoipChannel;
#[doc(hidden)]
pub type UpdateApnsVoipChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApnsVoipChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApnsVoipChannel`](crate::operation::UpdateApnsVoipChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApnsVoipChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApnsVoipChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_182 = &_input.application_id;
                let input_182 = input_182.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_182, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_voip",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApnsVoipChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_apns_voip_channel_input(
                &self.apns_voip_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApnsVoipChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApnsVoipChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApnsVoipChannelInput`](crate::input::UpdateApnsVoipChannelInput)
    pub fn builder() -> crate::input::update_apns_voip_channel_input::Builder {
        crate::input::update_apns_voip_channel_input::Builder::default()
    }
}

/// See [`UpdateApnsVoipSandboxChannelInput`](crate::input::UpdateApnsVoipSandboxChannelInput)
pub mod update_apns_voip_sandbox_channel_input {
    /// A builder for [`UpdateApnsVoipSandboxChannelInput`](crate::input::UpdateApnsVoipSandboxChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apns_voip_sandbox_channel_request:
            std::option::Option<crate::model::ApnsVoipSandboxChannelRequest>,
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
        pub fn apns_voip_sandbox_channel_request(
            mut self,
            input: crate::model::ApnsVoipSandboxChannelRequest,
        ) -> Self {
            self.apns_voip_sandbox_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
        pub fn set_apns_voip_sandbox_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsVoipSandboxChannelRequest>,
        ) -> Self {
            self.apns_voip_sandbox_channel_request = input;
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApnsVoipSandboxChannelInput`](crate::input::UpdateApnsVoipSandboxChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApnsVoipSandboxChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApnsVoipSandboxChannelInput {
                apns_voip_sandbox_channel_request: self.apns_voip_sandbox_channel_request,
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApnsVoipSandboxChannelInputOperationOutputAlias =
    crate::operation::UpdateApnsVoipSandboxChannel;
#[doc(hidden)]
pub type UpdateApnsVoipSandboxChannelInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApnsVoipSandboxChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApnsVoipSandboxChannel`](crate::operation::UpdateApnsVoipSandboxChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApnsVoipSandboxChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApnsVoipSandboxChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_183 = &_input.application_id;
                let input_183 = input_183.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_183, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/apns_voip_sandbox",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApnsVoipSandboxChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_apns_voip_sandbox_channel_input(
                &self.apns_voip_sandbox_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApnsVoipSandboxChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApnsVoipSandboxChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApnsVoipSandboxChannelInput`](crate::input::UpdateApnsVoipSandboxChannelInput)
    pub fn builder() -> crate::input::update_apns_voip_sandbox_channel_input::Builder {
        crate::input::update_apns_voip_sandbox_channel_input::Builder::default()
    }
}

/// See [`UpdateApplicationSettingsInput`](crate::input::UpdateApplicationSettingsInput)
pub mod update_application_settings_input {
    /// A builder for [`UpdateApplicationSettingsInput`](crate::input::UpdateApplicationSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) write_application_settings_request:
            std::option::Option<crate::model::WriteApplicationSettingsRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the default settings for an application.</p>
        pub fn write_application_settings_request(
            mut self,
            input: crate::model::WriteApplicationSettingsRequest,
        ) -> Self {
            self.write_application_settings_request = Some(input);
            self
        }
        /// <p>Specifies the default settings for an application.</p>
        pub fn set_write_application_settings_request(
            mut self,
            input: std::option::Option<crate::model::WriteApplicationSettingsRequest>,
        ) -> Self {
            self.write_application_settings_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationSettingsInput`](crate::input::UpdateApplicationSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationSettingsInput {
                application_id: self.application_id,
                write_application_settings_request: self.write_application_settings_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationSettingsInputOperationOutputAlias =
    crate::operation::UpdateApplicationSettings;
#[doc(hidden)]
pub type UpdateApplicationSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplicationSettings`](crate::operation::UpdateApplicationSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplicationSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApplicationSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_184 = &_input.application_id;
                let input_184 = input_184.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_184, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/settings",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApplicationSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_application_settings_input(
                &self.write_application_settings_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplicationSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplicationSettings",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationSettingsInput`](crate::input::UpdateApplicationSettingsInput)
    pub fn builder() -> crate::input::update_application_settings_input::Builder {
        crate::input::update_application_settings_input::Builder::default()
    }
}

/// See [`UpdateBaiduChannelInput`](crate::input::UpdateBaiduChannelInput)
pub mod update_baidu_channel_input {
    /// A builder for [`UpdateBaiduChannelInput`](crate::input::UpdateBaiduChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) baidu_channel_request: std::option::Option<crate::model::BaiduChannelRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
        pub fn baidu_channel_request(mut self, input: crate::model::BaiduChannelRequest) -> Self {
            self.baidu_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
        pub fn set_baidu_channel_request(
            mut self,
            input: std::option::Option<crate::model::BaiduChannelRequest>,
        ) -> Self {
            self.baidu_channel_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBaiduChannelInput`](crate::input::UpdateBaiduChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBaiduChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBaiduChannelInput {
                application_id: self.application_id,
                baidu_channel_request: self.baidu_channel_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBaiduChannelInputOperationOutputAlias = crate::operation::UpdateBaiduChannel;
#[doc(hidden)]
pub type UpdateBaiduChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBaiduChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBaiduChannel`](crate::operation::UpdateBaiduChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBaiduChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBaiduChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_185 = &_input.application_id;
                let input_185 = input_185.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_185, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/baidu",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBaiduChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_baidu_channel_input(
                &self.baidu_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBaiduChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBaiduChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBaiduChannelInput`](crate::input::UpdateBaiduChannelInput)
    pub fn builder() -> crate::input::update_baidu_channel_input::Builder {
        crate::input::update_baidu_channel_input::Builder::default()
    }
}

/// See [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
pub mod update_campaign_input {
    /// A builder for [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) write_campaign_request: std::option::Option<crate::model::WriteCampaignRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn write_campaign_request(mut self, input: crate::model::WriteCampaignRequest) -> Self {
            self.write_campaign_request = Some(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn set_write_campaign_request(
            mut self,
            input: std::option::Option<crate::model::WriteCampaignRequest>,
        ) -> Self {
            self.write_campaign_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCampaignInput {
                application_id: self.application_id,
                campaign_id: self.campaign_id,
                write_campaign_request: self.write_campaign_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCampaignInputOperationOutputAlias = crate::operation::UpdateCampaign;
#[doc(hidden)]
pub type UpdateCampaignInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCampaignInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCampaign`](crate::operation::UpdateCampaign)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCampaign,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateCampaignInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_186 = &_input.application_id;
                let input_186 = input_186.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_186, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_187 = &_input.campaign_id;
                let input_187 = input_187.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_187, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/campaigns/{CampaignId}",
                    ApplicationId = application_id,
                    CampaignId = campaign_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateCampaignInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_campaign_input(
                &self.write_campaign_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCampaign",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
    pub fn builder() -> crate::input::update_campaign_input::Builder {
        crate::input::update_campaign_input::Builder::default()
    }
}

/// See [`UpdateEmailChannelInput`](crate::input::UpdateEmailChannelInput)
pub mod update_email_channel_input {
    /// A builder for [`UpdateEmailChannelInput`](crate::input::UpdateEmailChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) email_channel_request: std::option::Option<crate::model::EmailChannelRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the status and settings of the email channel for an application.</p>
        pub fn email_channel_request(mut self, input: crate::model::EmailChannelRequest) -> Self {
            self.email_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the email channel for an application.</p>
        pub fn set_email_channel_request(
            mut self,
            input: std::option::Option<crate::model::EmailChannelRequest>,
        ) -> Self {
            self.email_channel_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEmailChannelInput`](crate::input::UpdateEmailChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEmailChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEmailChannelInput {
                application_id: self.application_id,
                email_channel_request: self.email_channel_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEmailChannelInputOperationOutputAlias = crate::operation::UpdateEmailChannel;
#[doc(hidden)]
pub type UpdateEmailChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEmailChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEmailChannel`](crate::operation::UpdateEmailChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEmailChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEmailChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_188 = &_input.application_id;
                let input_188 = input_188.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_188, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/email",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEmailChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_email_channel_input(
                &self.email_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEmailChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEmailChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEmailChannelInput`](crate::input::UpdateEmailChannelInput)
    pub fn builder() -> crate::input::update_email_channel_input::Builder {
        crate::input::update_email_channel_input::Builder::default()
    }
}

/// See [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
pub mod update_email_template_input {
    /// A builder for [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_new_version: std::option::Option<bool>,
        pub(crate) email_template_request: std::option::Option<crate::model::EmailTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.create_new_version = Some(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_new_version = input;
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn email_template_request(mut self, input: crate::model::EmailTemplateRequest) -> Self {
            self.email_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn set_email_template_request(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateRequest>,
        ) -> Self {
            self.email_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEmailTemplateInput {
                create_new_version: self.create_new_version.unwrap_or_default(),
                email_template_request: self.email_template_request,
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEmailTemplateInputOperationOutputAlias = crate::operation::UpdateEmailTemplate;
#[doc(hidden)]
pub type UpdateEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEmailTemplate`](crate::operation::UpdateEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_189 = &_input.template_name;
                let input_189 = input_189.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_189, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/email",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateEmailTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.create_new_version {
                    query.push_kv(
                        "create-new-version",
                        aws_smithy_types::primitive::Encoder::from(_input.create_new_version)
                            .encode(),
                    );
                }
                if let Some(inner_190) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_190));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_email_template_input(
                &self.email_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEmailTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
    pub fn builder() -> crate::input::update_email_template_input::Builder {
        crate::input::update_email_template_input::Builder::default()
    }
}

/// See [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
pub mod update_endpoint_input {
    /// A builder for [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_request: std::option::Option<crate::model::EndpointRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>Specifies the channel type and other settings for an endpoint.</p>
        pub fn endpoint_request(mut self, input: crate::model::EndpointRequest) -> Self {
            self.endpoint_request = Some(input);
            self
        }
        /// <p>Specifies the channel type and other settings for an endpoint.</p>
        pub fn set_endpoint_request(
            mut self,
            input: std::option::Option<crate::model::EndpointRequest>,
        ) -> Self {
            self.endpoint_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEndpointInput {
                application_id: self.application_id,
                endpoint_id: self.endpoint_id,
                endpoint_request: self.endpoint_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEndpointInputOperationOutputAlias = crate::operation::UpdateEndpoint;
#[doc(hidden)]
pub type UpdateEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEndpointInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEndpoint`](crate::operation::UpdateEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_191 = &_input.application_id;
                let input_191 = input_191.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_191, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_192 = &_input.endpoint_id;
                let input_192 = input_192.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let endpoint_id = aws_smithy_http::label::fmt_string(input_192, false);
                if endpoint_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/endpoints/{EndpointId}",
                    ApplicationId = application_id,
                    EndpointId = endpoint_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_endpoint_input(&self.endpoint_request)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEndpoint",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    pub fn builder() -> crate::input::update_endpoint_input::Builder {
        crate::input::update_endpoint_input::Builder::default()
    }
}

/// See [`UpdateEndpointsBatchInput`](crate::input::UpdateEndpointsBatchInput)
pub mod update_endpoints_batch_input {
    /// A builder for [`UpdateEndpointsBatchInput`](crate::input::UpdateEndpointsBatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_batch_request: std::option::Option<crate::model::EndpointBatchRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
        pub fn endpoint_batch_request(mut self, input: crate::model::EndpointBatchRequest) -> Self {
            self.endpoint_batch_request = Some(input);
            self
        }
        /// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
        pub fn set_endpoint_batch_request(
            mut self,
            input: std::option::Option<crate::model::EndpointBatchRequest>,
        ) -> Self {
            self.endpoint_batch_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndpointsBatchInput`](crate::input::UpdateEndpointsBatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEndpointsBatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEndpointsBatchInput {
                application_id: self.application_id,
                endpoint_batch_request: self.endpoint_batch_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEndpointsBatchInputOperationOutputAlias = crate::operation::UpdateEndpointsBatch;
#[doc(hidden)]
pub type UpdateEndpointsBatchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEndpointsBatchInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEndpointsBatch`](crate::operation::UpdateEndpointsBatch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEndpointsBatch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEndpointsBatchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_193 = &_input.application_id;
                let input_193 = input_193.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_193, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/endpoints",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEndpointsBatchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_endpoints_batch_input(
                &self.endpoint_batch_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEndpointsBatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEndpointsBatch",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEndpointsBatchInput`](crate::input::UpdateEndpointsBatchInput)
    pub fn builder() -> crate::input::update_endpoints_batch_input::Builder {
        crate::input::update_endpoints_batch_input::Builder::default()
    }
}

/// See [`UpdateGcmChannelInput`](crate::input::UpdateGcmChannelInput)
pub mod update_gcm_channel_input {
    /// A builder for [`UpdateGcmChannelInput`](crate::input::UpdateGcmChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) gcm_channel_request: std::option::Option<crate::model::GcmChannelRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
        pub fn gcm_channel_request(mut self, input: crate::model::GcmChannelRequest) -> Self {
            self.gcm_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
        pub fn set_gcm_channel_request(
            mut self,
            input: std::option::Option<crate::model::GcmChannelRequest>,
        ) -> Self {
            self.gcm_channel_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGcmChannelInput`](crate::input::UpdateGcmChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGcmChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGcmChannelInput {
                application_id: self.application_id,
                gcm_channel_request: self.gcm_channel_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGcmChannelInputOperationOutputAlias = crate::operation::UpdateGcmChannel;
#[doc(hidden)]
pub type UpdateGcmChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGcmChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGcmChannel`](crate::operation::UpdateGcmChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGcmChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateGcmChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_194 = &_input.application_id;
                let input_194 = input_194.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_194, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/gcm",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateGcmChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_gcm_channel_input(
                &self.gcm_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGcmChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGcmChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateGcmChannelInput`](crate::input::UpdateGcmChannelInput)
    pub fn builder() -> crate::input::update_gcm_channel_input::Builder {
        crate::input::update_gcm_channel_input::Builder::default()
    }
}

/// See [`UpdateInAppTemplateInput`](crate::input::UpdateInAppTemplateInput)
pub mod update_in_app_template_input {
    /// A builder for [`UpdateInAppTemplateInput`](crate::input::UpdateInAppTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_new_version: std::option::Option<bool>,
        pub(crate) in_app_template_request: std::option::Option<crate::model::InAppTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.create_new_version = Some(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_new_version = input;
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn in_app_template_request(
            mut self,
            input: crate::model::InAppTemplateRequest,
        ) -> Self {
            self.in_app_template_request = Some(input);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn set_in_app_template_request(
            mut self,
            input: std::option::Option<crate::model::InAppTemplateRequest>,
        ) -> Self {
            self.in_app_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInAppTemplateInput`](crate::input::UpdateInAppTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInAppTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInAppTemplateInput {
                create_new_version: self.create_new_version.unwrap_or_default(),
                in_app_template_request: self.in_app_template_request,
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInAppTemplateInputOperationOutputAlias = crate::operation::UpdateInAppTemplate;
#[doc(hidden)]
pub type UpdateInAppTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInAppTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInAppTemplate`](crate::operation::UpdateInAppTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInAppTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateInAppTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_195 = &_input.template_name;
                let input_195 = input_195.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_195, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/inapp",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateInAppTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.create_new_version {
                    query.push_kv(
                        "create-new-version",
                        aws_smithy_types::primitive::Encoder::from(_input.create_new_version)
                            .encode(),
                    );
                }
                if let Some(inner_196) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_196));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateInAppTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_in_app_template_input(
                &self.in_app_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInAppTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInAppTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateInAppTemplateInput`](crate::input::UpdateInAppTemplateInput)
    pub fn builder() -> crate::input::update_in_app_template_input::Builder {
        crate::input::update_in_app_template_input::Builder::default()
    }
}

/// See [`UpdateJourneyInput`](crate::input::UpdateJourneyInput)
pub mod update_journey_input {
    /// A builder for [`UpdateJourneyInput`](crate::input::UpdateJourneyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
        pub(crate) write_journey_request: std::option::Option<crate::model::WriteJourneyRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn write_journey_request(mut self, input: crate::model::WriteJourneyRequest) -> Self {
            self.write_journey_request = Some(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn set_write_journey_request(
            mut self,
            input: std::option::Option<crate::model::WriteJourneyRequest>,
        ) -> Self {
            self.write_journey_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJourneyInput`](crate::input::UpdateJourneyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateJourneyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateJourneyInput {
                application_id: self.application_id,
                journey_id: self.journey_id,
                write_journey_request: self.write_journey_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJourneyInputOperationOutputAlias = crate::operation::UpdateJourney;
#[doc(hidden)]
pub type UpdateJourneyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJourneyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJourney`](crate::operation::UpdateJourney)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJourney,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateJourneyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_197 = &_input.application_id;
                let input_197 = input_197.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_197, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_198 = &_input.journey_id;
                let input_198 = input_198.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_198, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys/{JourneyId}",
                    ApplicationId = application_id,
                    JourneyId = journey_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateJourneyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_journey_input(
                &self.write_journey_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateJourney::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateJourney",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateJourneyInput`](crate::input::UpdateJourneyInput)
    pub fn builder() -> crate::input::update_journey_input::Builder {
        crate::input::update_journey_input::Builder::default()
    }
}

/// See [`UpdateJourneyStateInput`](crate::input::UpdateJourneyStateInput)
pub mod update_journey_state_input {
    /// A builder for [`UpdateJourneyStateInput`](crate::input::UpdateJourneyStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) journey_id: std::option::Option<std::string::String>,
        pub(crate) journey_state_request: std::option::Option<crate::model::JourneyStateRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.journey_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.journey_id = input;
            self
        }
        /// <p>Changes the status of a journey.</p>
        pub fn journey_state_request(mut self, input: crate::model::JourneyStateRequest) -> Self {
            self.journey_state_request = Some(input);
            self
        }
        /// <p>Changes the status of a journey.</p>
        pub fn set_journey_state_request(
            mut self,
            input: std::option::Option<crate::model::JourneyStateRequest>,
        ) -> Self {
            self.journey_state_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJourneyStateInput`](crate::input::UpdateJourneyStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateJourneyStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateJourneyStateInput {
                application_id: self.application_id,
                journey_id: self.journey_id,
                journey_state_request: self.journey_state_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJourneyStateInputOperationOutputAlias = crate::operation::UpdateJourneyState;
#[doc(hidden)]
pub type UpdateJourneyStateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJourneyStateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJourneyState`](crate::operation::UpdateJourneyState)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJourneyState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateJourneyStateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_199 = &_input.application_id;
                let input_199 = input_199.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_199, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_200 = &_input.journey_id;
                let input_200 = input_200.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let journey_id = aws_smithy_http::label::fmt_string(input_200, false);
                if journey_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "journey_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/journeys/{JourneyId}/state",
                    ApplicationId = application_id,
                    JourneyId = journey_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateJourneyStateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_journey_state_input(
                &self.journey_state_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateJourneyState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateJourneyState",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateJourneyStateInput`](crate::input::UpdateJourneyStateInput)
    pub fn builder() -> crate::input::update_journey_state_input::Builder {
        crate::input::update_journey_state_input::Builder::default()
    }
}

/// See [`UpdatePushTemplateInput`](crate::input::UpdatePushTemplateInput)
pub mod update_push_template_input {
    /// A builder for [`UpdatePushTemplateInput`](crate::input::UpdatePushTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_new_version: std::option::Option<bool>,
        pub(crate) push_notification_template_request:
            std::option::Option<crate::model::PushNotificationTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.create_new_version = Some(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_new_version = input;
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn push_notification_template_request(
            mut self,
            input: crate::model::PushNotificationTemplateRequest,
        ) -> Self {
            self.push_notification_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn set_push_notification_template_request(
            mut self,
            input: std::option::Option<crate::model::PushNotificationTemplateRequest>,
        ) -> Self {
            self.push_notification_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePushTemplateInput`](crate::input::UpdatePushTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePushTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePushTemplateInput {
                create_new_version: self.create_new_version.unwrap_or_default(),
                push_notification_template_request: self.push_notification_template_request,
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePushTemplateInputOperationOutputAlias = crate::operation::UpdatePushTemplate;
#[doc(hidden)]
pub type UpdatePushTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePushTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePushTemplate`](crate::operation::UpdatePushTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePushTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePushTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_201 = &_input.template_name;
                let input_201 = input_201.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_201, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/push",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdatePushTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.create_new_version {
                    query.push_kv(
                        "create-new-version",
                        aws_smithy_types::primitive::Encoder::from(_input.create_new_version)
                            .encode(),
                    );
                }
                if let Some(inner_202) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_202));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePushTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_push_template_input(
                &self.push_notification_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePushTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePushTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePushTemplateInput`](crate::input::UpdatePushTemplateInput)
    pub fn builder() -> crate::input::update_push_template_input::Builder {
        crate::input::update_push_template_input::Builder::default()
    }
}

/// See [`UpdateRecommenderConfigurationInput`](crate::input::UpdateRecommenderConfigurationInput)
pub mod update_recommender_configuration_input {
    /// A builder for [`UpdateRecommenderConfigurationInput`](crate::input::UpdateRecommenderConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_id: std::option::Option<std::string::String>,
        pub(crate) update_recommender_configuration:
            std::option::Option<crate::model::UpdateRecommenderConfigurationShape>,
    }
    impl Builder {
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_id = input;
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn update_recommender_configuration(
            mut self,
            input: crate::model::UpdateRecommenderConfigurationShape,
        ) -> Self {
            self.update_recommender_configuration = Some(input);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn set_update_recommender_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateRecommenderConfigurationShape>,
        ) -> Self {
            self.update_recommender_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecommenderConfigurationInput`](crate::input::UpdateRecommenderConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRecommenderConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRecommenderConfigurationInput {
                recommender_id: self.recommender_id,
                update_recommender_configuration: self.update_recommender_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRecommenderConfigurationInputOperationOutputAlias =
    crate::operation::UpdateRecommenderConfiguration;
#[doc(hidden)]
pub type UpdateRecommenderConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRecommenderConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRecommenderConfiguration`](crate::operation::UpdateRecommenderConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRecommenderConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRecommenderConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_203 = &_input.recommender_id;
                let input_203 = input_203.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "recommender_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let recommender_id = aws_smithy_http::label::fmt_string(input_203, false);
                if recommender_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recommender_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/recommenders/{RecommenderId}",
                    RecommenderId = recommender_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRecommenderConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_recommender_configuration_input(
                &self.update_recommender_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRecommenderConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRecommenderConfiguration",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRecommenderConfigurationInput`](crate::input::UpdateRecommenderConfigurationInput)
    pub fn builder() -> crate::input::update_recommender_configuration_input::Builder {
        crate::input::update_recommender_configuration_input::Builder::default()
    }
}

/// See [`UpdateSegmentInput`](crate::input::UpdateSegmentInput)
pub mod update_segment_input {
    /// A builder for [`UpdateSegmentInput`](crate::input::UpdateSegmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) write_segment_request: std::option::Option<crate::model::WriteSegmentRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn write_segment_request(mut self, input: crate::model::WriteSegmentRequest) -> Self {
            self.write_segment_request = Some(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn set_write_segment_request(
            mut self,
            input: std::option::Option<crate::model::WriteSegmentRequest>,
        ) -> Self {
            self.write_segment_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSegmentInput`](crate::input::UpdateSegmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSegmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSegmentInput {
                application_id: self.application_id,
                segment_id: self.segment_id,
                write_segment_request: self.write_segment_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSegmentInputOperationOutputAlias = crate::operation::UpdateSegment;
#[doc(hidden)]
pub type UpdateSegmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSegmentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSegment`](crate::operation::UpdateSegment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSegment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSegmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_204 = &_input.application_id;
                let input_204 = input_204.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_204, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_205 = &_input.segment_id;
                let input_205 = input_205.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let segment_id = aws_smithy_http::label::fmt_string(input_205, false);
                if segment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "segment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/segments/{SegmentId}",
                    ApplicationId = application_id,
                    SegmentId = segment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSegmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_segment_input(
                &self.write_segment_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSegment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSegment",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSegmentInput`](crate::input::UpdateSegmentInput)
    pub fn builder() -> crate::input::update_segment_input::Builder {
        crate::input::update_segment_input::Builder::default()
    }
}

/// See [`UpdateSmsChannelInput`](crate::input::UpdateSmsChannelInput)
pub mod update_sms_channel_input {
    /// A builder for [`UpdateSmsChannelInput`](crate::input::UpdateSmsChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) sms_channel_request: std::option::Option<crate::model::SmsChannelRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the status and settings of the SMS channel for an application.</p>
        pub fn sms_channel_request(mut self, input: crate::model::SmsChannelRequest) -> Self {
            self.sms_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the SMS channel for an application.</p>
        pub fn set_sms_channel_request(
            mut self,
            input: std::option::Option<crate::model::SmsChannelRequest>,
        ) -> Self {
            self.sms_channel_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmsChannelInput`](crate::input::UpdateSmsChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSmsChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSmsChannelInput {
                application_id: self.application_id,
                sms_channel_request: self.sms_channel_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSmsChannelInputOperationOutputAlias = crate::operation::UpdateSmsChannel;
#[doc(hidden)]
pub type UpdateSmsChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSmsChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSmsChannel`](crate::operation::UpdateSmsChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSmsChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSmsChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_206 = &_input.application_id;
                let input_206 = input_206.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_206, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/sms",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSmsChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_sms_channel_input(
                &self.sms_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSmsChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSmsChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSmsChannelInput`](crate::input::UpdateSmsChannelInput)
    pub fn builder() -> crate::input::update_sms_channel_input::Builder {
        crate::input::update_sms_channel_input::Builder::default()
    }
}

/// See [`UpdateSmsTemplateInput`](crate::input::UpdateSmsTemplateInput)
pub mod update_sms_template_input {
    /// A builder for [`UpdateSmsTemplateInput`](crate::input::UpdateSmsTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_new_version: std::option::Option<bool>,
        pub(crate) sms_template_request: std::option::Option<crate::model::SmsTemplateRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.create_new_version = Some(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_new_version = input;
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn sms_template_request(mut self, input: crate::model::SmsTemplateRequest) -> Self {
            self.sms_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn set_sms_template_request(
            mut self,
            input: std::option::Option<crate::model::SmsTemplateRequest>,
        ) -> Self {
            self.sms_template_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSmsTemplateInput`](crate::input::UpdateSmsTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSmsTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSmsTemplateInput {
                create_new_version: self.create_new_version.unwrap_or_default(),
                sms_template_request: self.sms_template_request,
                template_name: self.template_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSmsTemplateInputOperationOutputAlias = crate::operation::UpdateSmsTemplate;
#[doc(hidden)]
pub type UpdateSmsTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSmsTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSmsTemplate`](crate::operation::UpdateSmsTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSmsTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSmsTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_207 = &_input.template_name;
                let input_207 = input_207.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_207, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/sms",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateSmsTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.create_new_version {
                    query.push_kv(
                        "create-new-version",
                        aws_smithy_types::primitive::Encoder::from(_input.create_new_version)
                            .encode(),
                    );
                }
                if let Some(inner_208) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_208));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSmsTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_sms_template_input(
                &self.sms_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSmsTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSmsTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSmsTemplateInput`](crate::input::UpdateSmsTemplateInput)
    pub fn builder() -> crate::input::update_sms_template_input::Builder {
        crate::input::update_sms_template_input::Builder::default()
    }
}

/// See [`UpdateTemplateActiveVersionInput`](crate::input::UpdateTemplateActiveVersionInput)
pub mod update_template_active_version_input {
    /// A builder for [`UpdateTemplateActiveVersionInput`](crate::input::UpdateTemplateActiveVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_active_version_request:
            std::option::Option<crate::model::TemplateActiveVersionRequest>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies which version of a message template to use as the active version of the template.</p>
        pub fn template_active_version_request(
            mut self,
            input: crate::model::TemplateActiveVersionRequest,
        ) -> Self {
            self.template_active_version_request = Some(input);
            self
        }
        /// <p>Specifies which version of a message template to use as the active version of the template.</p>
        pub fn set_template_active_version_request(
            mut self,
            input: std::option::Option<crate::model::TemplateActiveVersionRequest>,
        ) -> Self {
            self.template_active_version_request = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn template_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_type = Some(input.into());
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTemplateActiveVersionInput`](crate::input::UpdateTemplateActiveVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTemplateActiveVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTemplateActiveVersionInput {
                template_active_version_request: self.template_active_version_request,
                template_name: self.template_name,
                template_type: self.template_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTemplateActiveVersionInputOperationOutputAlias =
    crate::operation::UpdateTemplateActiveVersion;
#[doc(hidden)]
pub type UpdateTemplateActiveVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTemplateActiveVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTemplateActiveVersion`](crate::operation::UpdateTemplateActiveVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTemplateActiveVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateTemplateActiveVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_209 = &_input.template_name;
                let input_209 = input_209.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_209, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_210 = &_input.template_type;
                let input_210 = input_210.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_type = aws_smithy_http::label::fmt_string(input_210, false);
                if template_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/{TemplateType}/active-version",
                    TemplateName = template_name,
                    TemplateType = template_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateTemplateActiveVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_template_active_version_input(
                &self.template_active_version_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTemplateActiveVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTemplateActiveVersion",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateTemplateActiveVersionInput`](crate::input::UpdateTemplateActiveVersionInput)
    pub fn builder() -> crate::input::update_template_active_version_input::Builder {
        crate::input::update_template_active_version_input::Builder::default()
    }
}

/// See [`UpdateVoiceChannelInput`](crate::input::UpdateVoiceChannelInput)
pub mod update_voice_channel_input {
    /// A builder for [`UpdateVoiceChannelInput`](crate::input::UpdateVoiceChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) voice_channel_request: std::option::Option<crate::model::VoiceChannelRequest>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Specifies the status and settings of the voice channel for an application.</p>
        pub fn voice_channel_request(mut self, input: crate::model::VoiceChannelRequest) -> Self {
            self.voice_channel_request = Some(input);
            self
        }
        /// <p>Specifies the status and settings of the voice channel for an application.</p>
        pub fn set_voice_channel_request(
            mut self,
            input: std::option::Option<crate::model::VoiceChannelRequest>,
        ) -> Self {
            self.voice_channel_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVoiceChannelInput`](crate::input::UpdateVoiceChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVoiceChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVoiceChannelInput {
                application_id: self.application_id,
                voice_channel_request: self.voice_channel_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVoiceChannelInputOperationOutputAlias = crate::operation::UpdateVoiceChannel;
#[doc(hidden)]
pub type UpdateVoiceChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVoiceChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVoiceChannel`](crate::operation::UpdateVoiceChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVoiceChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVoiceChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_211 = &_input.application_id;
                let input_211 = input_211.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_211, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/channels/voice",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVoiceChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_voice_channel_input(
                &self.voice_channel_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVoiceChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVoiceChannel",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVoiceChannelInput`](crate::input::UpdateVoiceChannelInput)
    pub fn builder() -> crate::input::update_voice_channel_input::Builder {
        crate::input::update_voice_channel_input::Builder::default()
    }
}

/// See [`UpdateVoiceTemplateInput`](crate::input::UpdateVoiceTemplateInput)
pub mod update_voice_template_input {
    /// A builder for [`UpdateVoiceTemplateInput`](crate::input::UpdateVoiceTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_new_version: std::option::Option<bool>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) voice_template_request: std::option::Option<crate::model::VoiceTemplateRequest>,
    }
    impl Builder {
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, input: bool) -> Self {
            self.create_new_version = Some(input);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_new_version = input;
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
        /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
        /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
        /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
        /// <ul>
        /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
        /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
        /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn voice_template_request(mut self, input: crate::model::VoiceTemplateRequest) -> Self {
            self.voice_template_request = Some(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn set_voice_template_request(
            mut self,
            input: std::option::Option<crate::model::VoiceTemplateRequest>,
        ) -> Self {
            self.voice_template_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVoiceTemplateInput`](crate::input::UpdateVoiceTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVoiceTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVoiceTemplateInput {
                create_new_version: self.create_new_version.unwrap_or_default(),
                template_name: self.template_name,
                version: self.version,
                voice_template_request: self.voice_template_request,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVoiceTemplateInputOperationOutputAlias = crate::operation::UpdateVoiceTemplate;
#[doc(hidden)]
pub type UpdateVoiceTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVoiceTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVoiceTemplate`](crate::operation::UpdateVoiceTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVoiceTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVoiceTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_212 = &_input.template_name;
                let input_212 = input_212.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_212, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/templates/{TemplateName}/voice",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateVoiceTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.create_new_version {
                    query.push_kv(
                        "create-new-version",
                        aws_smithy_types::primitive::Encoder::from(_input.create_new_version)
                            .encode(),
                    );
                }
                if let Some(inner_213) = &_input.version {
                    query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_213));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVoiceTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_voice_template_input(
                &self.voice_template_request,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVoiceTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVoiceTemplate",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVoiceTemplateInput`](crate::input::UpdateVoiceTemplateInput)
    pub fn builder() -> crate::input::update_voice_template_input::Builder {
        crate::input::update_voice_template_input::Builder::default()
    }
}

/// See [`VerifyOtpMessageInput`](crate::input::VerifyOtpMessageInput)
pub mod verify_otp_message_input {
    /// A builder for [`VerifyOtpMessageInput`](crate::input::VerifyOtpMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) verify_otp_message_request_parameters:
            std::option::Option<crate::model::VerifyOtpMessageRequestParameters>,
    }
    impl Builder {
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique ID of your Amazon Pinpoint application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Verify OTP message request.</p>
        pub fn verify_otp_message_request_parameters(
            mut self,
            input: crate::model::VerifyOtpMessageRequestParameters,
        ) -> Self {
            self.verify_otp_message_request_parameters = Some(input);
            self
        }
        /// <p>Verify OTP message request.</p>
        pub fn set_verify_otp_message_request_parameters(
            mut self,
            input: std::option::Option<crate::model::VerifyOtpMessageRequestParameters>,
        ) -> Self {
            self.verify_otp_message_request_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyOtpMessageInput`](crate::input::VerifyOtpMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifyOtpMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifyOtpMessageInput {
                application_id: self.application_id,
                verify_otp_message_request_parameters: self.verify_otp_message_request_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifyOtpMessageInputOperationOutputAlias = crate::operation::VerifyOTPMessage;
#[doc(hidden)]
pub type VerifyOtpMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl VerifyOtpMessageInput {
    /// Consumes the builder and constructs an Operation<[`VerifyOTPMessage`](crate::operation::VerifyOTPMessage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifyOTPMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::VerifyOtpMessageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_214 = &_input.application_id;
                let input_214 = input_214.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let application_id = aws_smithy_http::label::fmt_string(input_214, false);
                if application_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apps/{ApplicationId}/verify-otp",
                    ApplicationId = application_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::VerifyOtpMessageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_verify_otp_message_input(
                &self.verify_otp_message_request_parameters,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifyOTPMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifyOTPMessage",
            "pinpoint",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`VerifyOtpMessageInput`](crate::input::VerifyOtpMessageInput)
    pub fn builder() -> crate::input::verify_otp_message_input::Builder {
        crate::input::verify_otp_message_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyOtpMessageInput {
    /// <p>The unique ID of your Amazon Pinpoint application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>Verify OTP message request.</p>
    pub verify_otp_message_request_parameters:
        std::option::Option<crate::model::VerifyOtpMessageRequestParameters>,
}
impl VerifyOtpMessageInput {
    /// <p>The unique ID of your Amazon Pinpoint application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>Verify OTP message request.</p>
    pub fn verify_otp_message_request_parameters(
        &self,
    ) -> std::option::Option<&crate::model::VerifyOtpMessageRequestParameters> {
        self.verify_otp_message_request_parameters.as_ref()
    }
}
impl std::fmt::Debug for VerifyOtpMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyOtpMessageInput");
        formatter.field("application_id", &self.application_id);
        formatter.field(
            "verify_otp_message_request_parameters",
            &self.verify_otp_message_request_parameters,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVoiceTemplateInput {
    /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
    /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    pub create_new_version: bool,
    /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
    /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
    /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
    /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
    /// <ul>
    /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
    /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
    /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
    /// </ul>
    pub version: std::option::Option<std::string::String>,
    /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
    pub voice_template_request: std::option::Option<crate::model::VoiceTemplateRequest>,
}
impl UpdateVoiceTemplateInput {
    /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p>
    /// <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
    pub fn create_new_version(&self) -> bool {
        self.create_new_version
    }
    /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the
    /// <link linkend="templates-template-name-template-type-versions">Template Versions resource.</p>
    /// <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p>
    /// <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p>
    /// <ul>
    /// <li><p>For a get operation, retrieves information about the active version of the template.</p></li>
    /// <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li>
    /// <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li>
    /// </ul>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
    pub fn voice_template_request(
        &self,
    ) -> std::option::Option<&crate::model::VoiceTemplateRequest> {
        self.voice_template_request.as_ref()
    }
}
impl std::fmt::Debug for UpdateVoiceTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVoiceTemplateInput");
        formatter.field("create_new_version", &self.create_new_version);
        formatter.field("template_name", &self.template_name);
        formatter.field("version", &self.version);
        formatter.field("voice_template_request", &self.voice_template_request);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVoiceChannelInput {
    /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>Specifies the status and settings of the voice channel for an application.</p>
    pub voice_channel_request: std::option::Option<crate::model::VoiceChannelRequest>,
}
impl UpdateVoiceChannelInput {
    /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>Specifies the status and settings of the voice channel for an application.</p>
    pub fn voice_channel_request(&self) -> std::option::Option<&crate::model::VoiceChannelRequest> {
        self.voice_channel_request.as_ref()
    }
}
impl std::fmt::Debug for UpdateVoiceChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVoiceChannelInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("voice_channel_request", &self.voice_channel_request);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTemplateActiveV