// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageBody {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl MessageBody {
    /// <p>The message that's returned from the API.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The unique identifier for the request or response.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for MessageBody {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageBody");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`MessageBody`](crate::model::MessageBody)
pub mod message_body {
    /// A builder for [`MessageBody`](crate::model::MessageBody)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageBody`](crate::model::MessageBody)
        pub fn build(self) -> crate::model::MessageBody {
            crate::model::MessageBody {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl MessageBody {
    /// Creates a new builder-style object to manufacture [`MessageBody`](crate::model::MessageBody)
    pub fn builder() -> crate::model::message_body::Builder {
        crate::model::message_body::Builder::default()
    }
}

/// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceTemplateRequest {
    /// <p>The text of the script to use in messages that are based on the message template, in plain text format.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub default_substitutions: std::option::Option<std::string::String>,
    /// <p>The code for the language to use when synthesizing the text of the script in messages that are based on the message template. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
    pub language_code: std::option::Option<std::string::String>,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A custom description of the message template.</p>
    pub template_description: std::option::Option<std::string::String>,
    /// <p>The name of the voice to use when delivering messages that are based on the message template. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
    pub voice_id: std::option::Option<std::string::String>,
}
impl VoiceTemplateRequest {
    /// <p>The text of the script to use in messages that are based on the message template, in plain text format.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub fn default_substitutions(&self) -> std::option::Option<&str> {
        self.default_substitutions.as_deref()
    }
    /// <p>The code for the language to use when synthesizing the text of the script in messages that are based on the message template. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A custom description of the message template.</p>
    pub fn template_description(&self) -> std::option::Option<&str> {
        self.template_description.as_deref()
    }
    /// <p>The name of the voice to use when delivering messages that are based on the message template. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
}
impl std::fmt::Debug for VoiceTemplateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceTemplateRequest");
        formatter.field("body", &self.body);
        formatter.field("default_substitutions", &self.default_substitutions);
        formatter.field("language_code", &self.language_code);
        formatter.field("tags", &self.tags);
        formatter.field("template_description", &self.template_description);
        formatter.field("voice_id", &self.voice_id);
        formatter.finish()
    }
}
/// See [`VoiceTemplateRequest`](crate::model::VoiceTemplateRequest)
pub mod voice_template_request {
    /// A builder for [`VoiceTemplateRequest`](crate::model::VoiceTemplateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) default_substitutions: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_description: std::option::Option<std::string::String>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text of the script to use in messages that are based on the message template, in plain text format.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The text of the script to use in messages that are based on the message template, in plain text format.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn default_substitutions(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_substitutions = Some(input.into());
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn set_default_substitutions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_substitutions = input;
            self
        }
        /// <p>The code for the language to use when synthesizing the text of the script in messages that are based on the message template. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The code for the language to use when synthesizing the text of the script in messages that are based on the message template. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn template_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_description = Some(input.into());
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn set_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_description = input;
            self
        }
        /// <p>The name of the voice to use when delivering messages that are based on the message template. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// <p>The name of the voice to use when delivering messages that are based on the message template. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceTemplateRequest`](crate::model::VoiceTemplateRequest)
        pub fn build(self) -> crate::model::VoiceTemplateRequest {
            crate::model::VoiceTemplateRequest {
                body: self.body,
                default_substitutions: self.default_substitutions,
                language_code: self.language_code,
                tags: self.tags,
                template_description: self.template_description,
                voice_id: self.voice_id,
            }
        }
    }
}
impl VoiceTemplateRequest {
    /// Creates a new builder-style object to manufacture [`VoiceTemplateRequest`](crate::model::VoiceTemplateRequest)
    pub fn builder() -> crate::model::voice_template_request::Builder {
        crate::model::voice_template_request::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the voice channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceChannelResponse {
    /// <p>The unique identifier for the application that the voice channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when the voice channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>Specifies whether the voice channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>(Deprecated) An identifier for the voice channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the voice channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the voice channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when the voice channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the voice channel, this value is VOICE.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current version of the voice channel.</p>
    pub version: i32,
}
impl VoiceChannelResponse {
    /// <p>The unique identifier for the application that the voice channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when the voice channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>Specifies whether the voice channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>(Deprecated) An identifier for the voice channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the voice channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the voice channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when the voice channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the voice channel, this value is VOICE.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current version of the voice channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for VoiceChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`VoiceChannelResponse`](crate::model::VoiceChannelResponse)
pub mod voice_channel_response {
    /// A builder for [`VoiceChannelResponse`](crate::model::VoiceChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the voice channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the voice channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the voice channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the voice channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Specifies whether the voice channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the voice channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>(Deprecated) An identifier for the voice channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the voice channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the voice channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the voice channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the voice channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the voice channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the voice channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the voice channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the voice channel, this value is VOICE.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the voice channel, this value is VOICE.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current version of the voice channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the voice channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceChannelResponse`](crate::model::VoiceChannelResponse)
        pub fn build(self) -> crate::model::VoiceChannelResponse {
            crate::model::VoiceChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl VoiceChannelResponse {
    /// Creates a new builder-style object to manufacture [`VoiceChannelResponse`](crate::model::VoiceChannelResponse)
    pub fn builder() -> crate::model::voice_channel_response::Builder {
        crate::model::voice_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the voice channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceChannelRequest {
    /// <p>Specifies whether to enable the voice channel for the application.</p>
    pub enabled: bool,
}
impl VoiceChannelRequest {
    /// <p>Specifies whether to enable the voice channel for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for VoiceChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceChannelRequest");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`VoiceChannelRequest`](crate::model::VoiceChannelRequest)
pub mod voice_channel_request {
    /// A builder for [`VoiceChannelRequest`](crate::model::VoiceChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether to enable the voice channel for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the voice channel for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceChannelRequest`](crate::model::VoiceChannelRequest)
        pub fn build(self) -> crate::model::VoiceChannelRequest {
            crate::model::VoiceChannelRequest {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl VoiceChannelRequest {
    /// Creates a new builder-style object to manufacture [`VoiceChannelRequest`](crate::model::VoiceChannelRequest)
    pub fn builder() -> crate::model::voice_channel_request::Builder {
        crate::model::voice_channel_request::Builder::default()
    }
}

/// <p>Specifies which version of a message template to use as the active version of the template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateActiveVersionRequest {
    /// <p>The version of the message template to use as the active version of the template. Valid values are: latest, for the most recent version of the template; or, the unique identifier for any existing version of the template. If you specify an identifier, the value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
    pub version: std::option::Option<std::string::String>,
}
impl TemplateActiveVersionRequest {
    /// <p>The version of the message template to use as the active version of the template. Valid values are: latest, for the most recent version of the template; or, the unique identifier for any existing version of the template. If you specify an identifier, the value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for TemplateActiveVersionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateActiveVersionRequest");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`TemplateActiveVersionRequest`](crate::model::TemplateActiveVersionRequest)
pub mod template_active_version_request {
    /// A builder for [`TemplateActiveVersionRequest`](crate::model::TemplateActiveVersionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version of the message template to use as the active version of the template. Valid values are: latest, for the most recent version of the template; or, the unique identifier for any existing version of the template. If you specify an identifier, the value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the message template to use as the active version of the template. Valid values are: latest, for the most recent version of the template; or, the unique identifier for any existing version of the template. If you specify an identifier, the value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateActiveVersionRequest`](crate::model::TemplateActiveVersionRequest)
        pub fn build(self) -> crate::model::TemplateActiveVersionRequest {
            crate::model::TemplateActiveVersionRequest {
                version: self.version,
            }
        }
    }
}
impl TemplateActiveVersionRequest {
    /// Creates a new builder-style object to manufacture [`TemplateActiveVersionRequest`](crate::model::TemplateActiveVersionRequest)
    pub fn builder() -> crate::model::template_active_version_request::Builder {
        crate::model::template_active_version_request::Builder::default()
    }
}

/// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsTemplateRequest {
    /// <p>The message body to use in text messages that are based on the message template.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub default_substitutions: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
    pub recommender_id: std::option::Option<std::string::String>,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A custom description of the message template.</p>
    pub template_description: std::option::Option<std::string::String>,
}
impl SmsTemplateRequest {
    /// <p>The message body to use in text messages that are based on the message template.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub fn default_substitutions(&self) -> std::option::Option<&str> {
        self.default_substitutions.as_deref()
    }
    /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
    pub fn recommender_id(&self) -> std::option::Option<&str> {
        self.recommender_id.as_deref()
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A custom description of the message template.</p>
    pub fn template_description(&self) -> std::option::Option<&str> {
        self.template_description.as_deref()
    }
}
impl std::fmt::Debug for SmsTemplateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsTemplateRequest");
        formatter.field("body", &self.body);
        formatter.field("default_substitutions", &self.default_substitutions);
        formatter.field("recommender_id", &self.recommender_id);
        formatter.field("tags", &self.tags);
        formatter.field("template_description", &self.template_description);
        formatter.finish()
    }
}
/// See [`SmsTemplateRequest`](crate::model::SmsTemplateRequest)
pub mod sms_template_request {
    /// A builder for [`SmsTemplateRequest`](crate::model::SmsTemplateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) default_substitutions: std::option::Option<std::string::String>,
        pub(crate) recommender_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message body to use in text messages that are based on the message template.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The message body to use in text messages that are based on the message template.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn default_substitutions(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_substitutions = Some(input.into());
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn set_default_substitutions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_substitutions = input;
            self
        }
        /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn template_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_description = Some(input.into());
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn set_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_description = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsTemplateRequest`](crate::model::SmsTemplateRequest)
        pub fn build(self) -> crate::model::SmsTemplateRequest {
            crate::model::SmsTemplateRequest {
                body: self.body,
                default_substitutions: self.default_substitutions,
                recommender_id: self.recommender_id,
                tags: self.tags,
                template_description: self.template_description,
            }
        }
    }
}
impl SmsTemplateRequest {
    /// Creates a new builder-style object to manufacture [`SmsTemplateRequest`](crate::model::SmsTemplateRequest)
    pub fn builder() -> crate::model::sms_template_request::Builder {
        crate::model::sms_template_request::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the SMS channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsChannelResponse {
    /// <p>The unique identifier for the application that the SMS channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when the SMS channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>Specifies whether the SMS channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>(Deprecated) An identifier for the SMS channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the SMS channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the SMS channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when the SMS channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the SMS channel, this value is SMS.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The maximum number of promotional messages that you can send through the SMS channel each second.</p>
    pub promotional_messages_per_second: i32,
    /// <p>The identity that displays on recipients' devices when they receive messages from the SMS channel.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The registered short code to use when you send messages through the SMS channel.</p>
    pub short_code: std::option::Option<std::string::String>,
    /// <p>The maximum number of transactional messages that you can send through the SMS channel each second.</p>
    pub transactional_messages_per_second: i32,
    /// <p>The current version of the SMS channel.</p>
    pub version: i32,
}
impl SmsChannelResponse {
    /// <p>The unique identifier for the application that the SMS channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when the SMS channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>Specifies whether the SMS channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>(Deprecated) An identifier for the SMS channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the SMS channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the SMS channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when the SMS channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the SMS channel, this value is SMS.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The maximum number of promotional messages that you can send through the SMS channel each second.</p>
    pub fn promotional_messages_per_second(&self) -> i32 {
        self.promotional_messages_per_second
    }
    /// <p>The identity that displays on recipients' devices when they receive messages from the SMS channel.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The registered short code to use when you send messages through the SMS channel.</p>
    pub fn short_code(&self) -> std::option::Option<&str> {
        self.short_code.as_deref()
    }
    /// <p>The maximum number of transactional messages that you can send through the SMS channel each second.</p>
    pub fn transactional_messages_per_second(&self) -> i32 {
        self.transactional_messages_per_second
    }
    /// <p>The current version of the SMS channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for SmsChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field(
            "promotional_messages_per_second",
            &self.promotional_messages_per_second,
        );
        formatter.field("sender_id", &self.sender_id);
        formatter.field("short_code", &self.short_code);
        formatter.field(
            "transactional_messages_per_second",
            &self.transactional_messages_per_second,
        );
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SmsChannelResponse`](crate::model::SmsChannelResponse)
pub mod sms_channel_response {
    /// A builder for [`SmsChannelResponse`](crate::model::SmsChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) promotional_messages_per_second: std::option::Option<i32>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) short_code: std::option::Option<std::string::String>,
        pub(crate) transactional_messages_per_second: std::option::Option<i32>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the SMS channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the SMS channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the SMS channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the SMS channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Specifies whether the SMS channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the SMS channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>(Deprecated) An identifier for the SMS channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the SMS channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the SMS channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the SMS channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the SMS channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the SMS channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the SMS channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the SMS channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the SMS channel, this value is SMS.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the SMS channel, this value is SMS.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The maximum number of promotional messages that you can send through the SMS channel each second.</p>
        pub fn promotional_messages_per_second(mut self, input: i32) -> Self {
            self.promotional_messages_per_second = Some(input);
            self
        }
        /// <p>The maximum number of promotional messages that you can send through the SMS channel each second.</p>
        pub fn set_promotional_messages_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.promotional_messages_per_second = input;
            self
        }
        /// <p>The identity that displays on recipients' devices when they receive messages from the SMS channel.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The identity that displays on recipients' devices when they receive messages from the SMS channel.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The registered short code to use when you send messages through the SMS channel.</p>
        pub fn short_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_code = Some(input.into());
            self
        }
        /// <p>The registered short code to use when you send messages through the SMS channel.</p>
        pub fn set_short_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_code = input;
            self
        }
        /// <p>The maximum number of transactional messages that you can send through the SMS channel each second.</p>
        pub fn transactional_messages_per_second(mut self, input: i32) -> Self {
            self.transactional_messages_per_second = Some(input);
            self
        }
        /// <p>The maximum number of transactional messages that you can send through the SMS channel each second.</p>
        pub fn set_transactional_messages_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.transactional_messages_per_second = input;
            self
        }
        /// <p>The current version of the SMS channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the SMS channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsChannelResponse`](crate::model::SmsChannelResponse)
        pub fn build(self) -> crate::model::SmsChannelResponse {
            crate::model::SmsChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                promotional_messages_per_second: self
                    .promotional_messages_per_second
                    .unwrap_or_default(),
                sender_id: self.sender_id,
                short_code: self.short_code,
                transactional_messages_per_second: self
                    .transactional_messages_per_second
                    .unwrap_or_default(),
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl SmsChannelResponse {
    /// Creates a new builder-style object to manufacture [`SmsChannelResponse`](crate::model::SmsChannelResponse)
    pub fn builder() -> crate::model::sms_channel_response::Builder {
        crate::model::sms_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the SMS channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsChannelRequest {
    /// <p>Specifies whether to enable the SMS channel for the application.</p>
    pub enabled: bool,
    /// <p>The identity that you want to display on recipients' devices when they receive messages from the SMS channel.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The registered short code that you want to use when you send messages through the SMS channel.</p>
    pub short_code: std::option::Option<std::string::String>,
}
impl SmsChannelRequest {
    /// <p>Specifies whether to enable the SMS channel for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The identity that you want to display on recipients' devices when they receive messages from the SMS channel.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The registered short code that you want to use when you send messages through the SMS channel.</p>
    pub fn short_code(&self) -> std::option::Option<&str> {
        self.short_code.as_deref()
    }
}
impl std::fmt::Debug for SmsChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsChannelRequest");
        formatter.field("enabled", &self.enabled);
        formatter.field("sender_id", &self.sender_id);
        formatter.field("short_code", &self.short_code);
        formatter.finish()
    }
}
/// See [`SmsChannelRequest`](crate::model::SmsChannelRequest)
pub mod sms_channel_request {
    /// A builder for [`SmsChannelRequest`](crate::model::SmsChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) short_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether to enable the SMS channel for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the SMS channel for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The identity that you want to display on recipients' devices when they receive messages from the SMS channel.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The identity that you want to display on recipients' devices when they receive messages from the SMS channel.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The registered short code that you want to use when you send messages through the SMS channel.</p>
        pub fn short_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_code = Some(input.into());
            self
        }
        /// <p>The registered short code that you want to use when you send messages through the SMS channel.</p>
        pub fn set_short_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_code = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsChannelRequest`](crate::model::SmsChannelRequest)
        pub fn build(self) -> crate::model::SmsChannelRequest {
            crate::model::SmsChannelRequest {
                enabled: self.enabled.unwrap_or_default(),
                sender_id: self.sender_id,
                short_code: self.short_code,
            }
        }
    }
}
impl SmsChannelRequest {
    /// Creates a new builder-style object to manufacture [`SmsChannelRequest`](crate::model::SmsChannelRequest)
    pub fn builder() -> crate::model::sms_channel_request::Builder {
        crate::model::sms_channel_request::Builder::default()
    }
}

/// <p>Provides information about the configuration, dimension, and other settings for a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentResponse {
    /// <p>The unique identifier for the application that the segment is associated with.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the segment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the segment was created.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The dimension settings for the segment.</p>
    pub dimensions: std::option::Option<crate::model::SegmentDimensions>,
    /// <p>The unique identifier for the segment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The settings for the import job that's associated with the segment.</p>
    pub import_definition: std::option::Option<crate::model::SegmentImportResource>,
    /// <p>The date and time when the segment was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The name of the segment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.</p>
    pub segment_groups: std::option::Option<crate::model::SegmentGroupList>,
    /// <p>The segment type. Valid values are:</p> <ul><li><p>DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that's reported by your app. Dynamic segments can change over time.</p></li> <li><p>IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don't change over time.</p></li></ul>
    pub segment_type: std::option::Option<crate::model::SegmentType>,
    /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The version number of the segment.</p>
    pub version: i32,
}
impl SegmentResponse {
    /// <p>The unique identifier for the application that the segment is associated with.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the segment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the segment was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The dimension settings for the segment.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::SegmentDimensions> {
        self.dimensions.as_ref()
    }
    /// <p>The unique identifier for the segment.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The settings for the import job that's associated with the segment.</p>
    pub fn import_definition(&self) -> std::option::Option<&crate::model::SegmentImportResource> {
        self.import_definition.as_ref()
    }
    /// <p>The date and time when the segment was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The name of the segment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.</p>
    pub fn segment_groups(&self) -> std::option::Option<&crate::model::SegmentGroupList> {
        self.segment_groups.as_ref()
    }
    /// <p>The segment type. Valid values are:</p> <ul><li><p>DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that's reported by your app. Dynamic segments can change over time.</p></li> <li><p>IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don't change over time.</p></li></ul>
    pub fn segment_type(&self) -> std::option::Option<&crate::model::SegmentType> {
        self.segment_type.as_ref()
    }
    /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The version number of the segment.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for SegmentResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("arn", &self.arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("id", &self.id);
        formatter.field("import_definition", &self.import_definition);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("name", &self.name);
        formatter.field("segment_groups", &self.segment_groups);
        formatter.field("segment_type", &self.segment_type);
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SegmentResponse`](crate::model::SegmentResponse)
pub mod segment_response {
    /// A builder for [`SegmentResponse`](crate::model::SegmentResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<crate::model::SegmentDimensions>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) import_definition: std::option::Option<crate::model::SegmentImportResource>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) segment_groups: std::option::Option<crate::model::SegmentGroupList>,
        pub(crate) segment_type: std::option::Option<crate::model::SegmentType>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the segment is associated with.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the segment is associated with.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the segment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the segment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the segment was created.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time when the segment was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The dimension settings for the segment.</p>
        pub fn dimensions(mut self, input: crate::model::SegmentDimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The dimension settings for the segment.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::SegmentDimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The settings for the import job that's associated with the segment.</p>
        pub fn import_definition(mut self, input: crate::model::SegmentImportResource) -> Self {
            self.import_definition = Some(input);
            self
        }
        /// <p>The settings for the import job that's associated with the segment.</p>
        pub fn set_import_definition(
            mut self,
            input: std::option::Option<crate::model::SegmentImportResource>,
        ) -> Self {
            self.import_definition = input;
            self
        }
        /// <p>The date and time when the segment was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time when the segment was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The name of the segment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the segment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.</p>
        pub fn segment_groups(mut self, input: crate::model::SegmentGroupList) -> Self {
            self.segment_groups = Some(input);
            self
        }
        /// <p>A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.</p>
        pub fn set_segment_groups(
            mut self,
            input: std::option::Option<crate::model::SegmentGroupList>,
        ) -> Self {
            self.segment_groups = input;
            self
        }
        /// <p>The segment type. Valid values are:</p> <ul><li><p>DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that's reported by your app. Dynamic segments can change over time.</p></li> <li><p>IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don't change over time.</p></li></ul>
        pub fn segment_type(mut self, input: crate::model::SegmentType) -> Self {
            self.segment_type = Some(input);
            self
        }
        /// <p>The segment type. Valid values are:</p> <ul><li><p>DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that's reported by your app. Dynamic segments can change over time.</p></li> <li><p>IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don't change over time.</p></li></ul>
        pub fn set_segment_type(
            mut self,
            input: std::option::Option<crate::model::SegmentType>,
        ) -> Self {
            self.segment_type = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The version number of the segment.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the segment.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentResponse`](crate::model::SegmentResponse)
        pub fn build(self) -> crate::model::SegmentResponse {
            crate::model::SegmentResponse {
                application_id: self.application_id,
                arn: self.arn,
                creation_date: self.creation_date,
                dimensions: self.dimensions,
                id: self.id,
                import_definition: self.import_definition,
                last_modified_date: self.last_modified_date,
                name: self.name,
                segment_groups: self.segment_groups,
                segment_type: self.segment_type,
                tags: self.tags,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl SegmentResponse {
    /// Creates a new builder-style object to manufacture [`SegmentResponse`](crate::model::SegmentResponse)
    pub fn builder() -> crate::model::segment_response::Builder {
        crate::model::segment_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SegmentType {
    #[allow(missing_docs)] // documentation missing in model
    Dimensional,
    #[allow(missing_docs)] // documentation missing in model
    Import,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SegmentType {
    fn from(s: &str) -> Self {
        match s {
            "DIMENSIONAL" => SegmentType::Dimensional,
            "IMPORT" => SegmentType::Import,
            other => SegmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SegmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SegmentType::from(s))
    }
}
impl SegmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SegmentType::Dimensional => "DIMENSIONAL",
            SegmentType::Import => "IMPORT",
            SegmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DIMENSIONAL", "IMPORT"]
    }
}
impl AsRef<str> for SegmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the settings that define the relationships between segment groups for a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentGroupList {
    /// <p>An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::SegmentGroup>>,
    /// <p>Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.</p>
    pub include: std::option::Option<crate::model::Include>,
}
impl SegmentGroupList {
    /// <p>An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::SegmentGroup]> {
        self.groups.as_deref()
    }
    /// <p>Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.</p>
    pub fn include(&self) -> std::option::Option<&crate::model::Include> {
        self.include.as_ref()
    }
}
impl std::fmt::Debug for SegmentGroupList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentGroupList");
        formatter.field("groups", &self.groups);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}
/// See [`SegmentGroupList`](crate::model::SegmentGroupList)
pub mod segment_group_list {
    /// A builder for [`SegmentGroupList`](crate::model::SegmentGroupList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::SegmentGroup>>,
        pub(crate) include: std::option::Option<crate::model::Include>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.</p>
        pub fn groups(mut self, input: impl Into<crate::model::SegmentGroup>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SegmentGroup>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.</p>
        pub fn include(mut self, input: crate::model::Include) -> Self {
            self.include = Some(input);
            self
        }
        /// <p>Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.</p>
        pub fn set_include(mut self, input: std::option::Option<crate::model::Include>) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentGroupList`](crate::model::SegmentGroupList)
        pub fn build(self) -> crate::model::SegmentGroupList {
            crate::model::SegmentGroupList {
                groups: self.groups,
                include: self.include,
            }
        }
    }
}
impl SegmentGroupList {
    /// Creates a new builder-style object to manufacture [`SegmentGroupList`](crate::model::SegmentGroupList)
    pub fn builder() -> crate::model::segment_group_list::Builder {
        crate::model::segment_group_list::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Include {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Include {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Include::All,
            "ANY" => Include::Any,
            "NONE" => Include::None,
            other => Include::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Include {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Include::from(s))
    }
}
impl Include {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Include::All => "ALL",
            Include::Any => "ANY",
            Include::None => "NONE",
            Include::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ANY", "NONE"]
    }
}
impl AsRef<str> for Include {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the base segments and dimensions for a segment, and the relationships between these base segments and dimensions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentGroup {
    /// <p>An array that defines the dimensions for the segment.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::SegmentDimensions>>,
    /// <p>The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p> <p>You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.</p>
    pub source_segments: std::option::Option<std::vec::Vec<crate::model::SegmentReference>>,
    /// <p>Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl SegmentGroup {
    /// <p>An array that defines the dimensions for the segment.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::SegmentDimensions]> {
        self.dimensions.as_deref()
    }
    /// <p>The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p> <p>You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.</p>
    pub fn source_segments(&self) -> std::option::Option<&[crate::model::SegmentReference]> {
        self.source_segments.as_deref()
    }
    /// <p>Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for SegmentGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentGroup");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("source_segments", &self.source_segments);
        formatter.field("source_type", &self.source_type);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`SegmentGroup`](crate::model::SegmentGroup)
pub mod segment_group {
    /// A builder for [`SegmentGroup`](crate::model::SegmentGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::SegmentDimensions>>,
        pub(crate) source_segments:
            std::option::Option<std::vec::Vec<crate::model::SegmentReference>>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>An array that defines the dimensions for the segment.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::SegmentDimensions>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>An array that defines the dimensions for the segment.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SegmentDimensions>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Appends an item to `source_segments`.
        ///
        /// To override the contents of this collection use [`set_source_segments`](Self::set_source_segments).
        ///
        /// <p>The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p> <p>You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.</p>
        pub fn source_segments(mut self, input: impl Into<crate::model::SegmentReference>) -> Self {
            let mut v = self.source_segments.unwrap_or_default();
            v.push(input.into());
            self.source_segments = Some(v);
            self
        }
        /// <p>The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p> <p>You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.</p>
        pub fn set_source_segments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SegmentReference>>,
        ) -> Self {
            self.source_segments = input;
            self
        }
        /// <p>Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentGroup`](crate::model::SegmentGroup)
        pub fn build(self) -> crate::model::SegmentGroup {
            crate::model::SegmentGroup {
                dimensions: self.dimensions,
                source_segments: self.source_segments,
                source_type: self.source_type,
                r#type: self.r#type,
            }
        }
    }
}
impl SegmentGroup {
    /// Creates a new builder-style object to manufacture [`SegmentGroup`](crate::model::SegmentGroup)
    pub fn builder() -> crate::model::segment_group::Builder {
        crate::model::segment_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Type::All,
            "ANY" => Type::Any,
            "NONE" => Type::None,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::All => "ALL",
            Type::Any => "ANY",
            Type::None => "NONE",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ANY", "NONE"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => SourceType::All,
            "ANY" => SourceType::Any,
            "NONE" => SourceType::None,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::All => "ALL",
            SourceType::Any => "ANY",
            SourceType::None => "NONE",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ANY", "NONE"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the segment identifier and version of a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentReference {
    /// <p>The unique identifier for the segment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version number of the segment.</p>
    pub version: i32,
}
impl SegmentReference {
    /// <p>The unique identifier for the segment.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version number of the segment.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for SegmentReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentReference");
        formatter.field("id", &self.id);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SegmentReference`](crate::model::SegmentReference)
pub mod segment_reference {
    /// A builder for [`SegmentReference`](crate::model::SegmentReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the segment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version number of the segment.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the segment.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentReference`](crate::model::SegmentReference)
        pub fn build(self) -> crate::model::SegmentReference {
            crate::model::SegmentReference {
                id: self.id,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl SegmentReference {
    /// Creates a new builder-style object to manufacture [`SegmentReference`](crate::model::SegmentReference)
    pub fn builder() -> crate::model::segment_reference::Builder {
        crate::model::segment_reference::Builder::default()
    }
}

/// <p>Specifies the dimension settings for a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentDimensions {
    /// <p>One or more custom attributes to use as criteria for the segment.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
    >,
    /// <p>The behavior-based criteria, such as how recently users have used your app, for the segment.</p>
    pub behavior: std::option::Option<crate::model::SegmentBehaviors>,
    /// <p>The demographic-based criteria, such as device platform, for the segment.</p>
    pub demographic: std::option::Option<crate::model::SegmentDemographics>,
    /// <p>The location-based criteria, such as region or GPS coordinates, for the segment.</p>
    pub location: std::option::Option<crate::model::SegmentLocation>,
    /// <p>One or more custom metrics to use as criteria for the segment.</p>
    pub metrics: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
    >,
    /// <p>One or more custom user attributes to use as criteria for the segment.</p>
    pub user_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
    >,
}
impl SegmentDimensions {
    /// <p>One or more custom attributes to use as criteria for the segment.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The behavior-based criteria, such as how recently users have used your app, for the segment.</p>
    pub fn behavior(&self) -> std::option::Option<&crate::model::SegmentBehaviors> {
        self.behavior.as_ref()
    }
    /// <p>The demographic-based criteria, such as device platform, for the segment.</p>
    pub fn demographic(&self) -> std::option::Option<&crate::model::SegmentDemographics> {
        self.demographic.as_ref()
    }
    /// <p>The location-based criteria, such as region or GPS coordinates, for the segment.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::SegmentLocation> {
        self.location.as_ref()
    }
    /// <p>One or more custom metrics to use as criteria for the segment.</p>
    pub fn metrics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
    > {
        self.metrics.as_ref()
    }
    /// <p>One or more custom user attributes to use as criteria for the segment.</p>
    pub fn user_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
    > {
        self.user_attributes.as_ref()
    }
}
impl std::fmt::Debug for SegmentDimensions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentDimensions");
        formatter.field("attributes", &self.attributes);
        formatter.field("behavior", &self.behavior);
        formatter.field("demographic", &self.demographic);
        formatter.field("location", &self.location);
        formatter.field("metrics", &self.metrics);
        formatter.field("user_attributes", &self.user_attributes);
        formatter.finish()
    }
}
/// See [`SegmentDimensions`](crate::model::SegmentDimensions)
pub mod segment_dimensions {
    /// A builder for [`SegmentDimensions`](crate::model::SegmentDimensions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
        >,
        pub(crate) behavior: std::option::Option<crate::model::SegmentBehaviors>,
        pub(crate) demographic: std::option::Option<crate::model::SegmentDemographics>,
        pub(crate) location: std::option::Option<crate::model::SegmentLocation>,
        pub(crate) metrics: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
        >,
        pub(crate) user_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more custom attributes to use as criteria for the segment.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeDimension>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more custom attributes to use as criteria for the segment.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The behavior-based criteria, such as how recently users have used your app, for the segment.</p>
        pub fn behavior(mut self, input: crate::model::SegmentBehaviors) -> Self {
            self.behavior = Some(input);
            self
        }
        /// <p>The behavior-based criteria, such as how recently users have used your app, for the segment.</p>
        pub fn set_behavior(
            mut self,
            input: std::option::Option<crate::model::SegmentBehaviors>,
        ) -> Self {
            self.behavior = input;
            self
        }
        /// <p>The demographic-based criteria, such as device platform, for the segment.</p>
        pub fn demographic(mut self, input: crate::model::SegmentDemographics) -> Self {
            self.demographic = Some(input);
            self
        }
        /// <p>The demographic-based criteria, such as device platform, for the segment.</p>
        pub fn set_demographic(
            mut self,
            input: std::option::Option<crate::model::SegmentDemographics>,
        ) -> Self {
            self.demographic = input;
            self
        }
        /// <p>The location-based criteria, such as region or GPS coordinates, for the segment.</p>
        pub fn location(mut self, input: crate::model::SegmentLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location-based criteria, such as region or GPS coordinates, for the segment.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::SegmentLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Adds a key-value pair to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>One or more custom metrics to use as criteria for the segment.</p>
        pub fn metrics(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MetricDimension>,
        ) -> Self {
            let mut hash_map = self.metrics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metrics = Some(hash_map);
            self
        }
        /// <p>One or more custom metrics to use as criteria for the segment.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
            >,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Adds a key-value pair to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>One or more custom user attributes to use as criteria for the segment.</p>
        pub fn user_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeDimension>,
        ) -> Self {
            let mut hash_map = self.user_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_attributes = Some(hash_map);
            self
        }
        /// <p>One or more custom user attributes to use as criteria for the segment.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
            >,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentDimensions`](crate::model::SegmentDimensions)
        pub fn build(self) -> crate::model::SegmentDimensions {
            crate::model::SegmentDimensions {
                attributes: self.attributes,
                behavior: self.behavior,
                demographic: self.demographic,
                location: self.location,
                metrics: self.metrics,
                user_attributes: self.user_attributes,
            }
        }
    }
}
impl SegmentDimensions {
    /// Creates a new builder-style object to manufacture [`SegmentDimensions`](crate::model::SegmentDimensions)
    pub fn builder() -> crate::model::segment_dimensions::Builder {
        crate::model::segment_dimensions::Builder::default()
    }
}

/// <p>Specifies attribute-based criteria for including or excluding endpoints from a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeDimension {
    /// <p>The type of segment dimension to use. Valid values are: <ul><li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li><li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li><li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li><li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li><li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li><li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li><li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li></p>
    pub attribute_type: std::option::Option<crate::model::AttributeType>,
    /// <p>The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AttributeDimension {
    /// <p>The type of segment dimension to use. Valid values are: <ul><li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li><li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li><li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li><li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li><li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li><li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li><li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li></p>
    pub fn attribute_type(&self) -> std::option::Option<&crate::model::AttributeType> {
        self.attribute_type.as_ref()
    }
    /// <p>The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for AttributeDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeDimension");
        formatter.field("attribute_type", &self.attribute_type);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`AttributeDimension`](crate::model::AttributeDimension)
pub mod attribute_dimension {
    /// A builder for [`AttributeDimension`](crate::model::AttributeDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_type: std::option::Option<crate::model::AttributeType>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of segment dimension to use. Valid values are: <ul><li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li><li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li><li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li><li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li><li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li><li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li><li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li></p>
        pub fn attribute_type(mut self, input: crate::model::AttributeType) -> Self {
            self.attribute_type = Some(input);
            self
        }
        /// <p>The type of segment dimension to use. Valid values are: <ul><li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li><li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li><li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li><li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li><li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li><li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li><li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li></p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::AttributeType>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeDimension`](crate::model::AttributeDimension)
        pub fn build(self) -> crate::model::AttributeDimension {
            crate::model::AttributeDimension {
                attribute_type: self.attribute_type,
                values: self.values,
            }
        }
    }
}
impl AttributeDimension {
    /// Creates a new builder-style object to manufacture [`AttributeDimension`](crate::model::AttributeDimension)
    pub fn builder() -> crate::model::attribute_dimension::Builder {
        crate::model::attribute_dimension::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttributeType {
    #[allow(missing_docs)] // documentation missing in model
    After,
    #[allow(missing_docs)] // documentation missing in model
    Before,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Exclusive,
    #[allow(missing_docs)] // documentation missing in model
    Inclusive,
    #[allow(missing_docs)] // documentation missing in model
    On,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttributeType {
    fn from(s: &str) -> Self {
        match s {
            "AFTER" => AttributeType::After,
            "BEFORE" => AttributeType::Before,
            "BETWEEN" => AttributeType::Between,
            "CONTAINS" => AttributeType::Contains,
            "EXCLUSIVE" => AttributeType::Exclusive,
            "INCLUSIVE" => AttributeType::Inclusive,
            "ON" => AttributeType::On,
            other => AttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttributeType::from(s))
    }
}
impl AttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttributeType::After => "AFTER",
            AttributeType::Before => "BEFORE",
            AttributeType::Between => "BETWEEN",
            AttributeType::Contains => "CONTAINS",
            AttributeType::Exclusive => "EXCLUSIVE",
            AttributeType::Inclusive => "INCLUSIVE",
            AttributeType::On => "ON",
            AttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFTER",
            "BEFORE",
            "BETWEEN",
            "CONTAINS",
            "EXCLUSIVE",
            "INCLUSIVE",
            "ON",
        ]
    }
}
impl AsRef<str> for AttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies metric-based criteria for including or excluding endpoints from a segment. These criteria derive from custom metrics that you define for endpoints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimension {
    /// <p>The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.</p>
    pub comparison_operator: std::option::Option<std::string::String>,
    /// <p>The value to compare.</p>
    pub value: f64,
}
impl MetricDimension {
    /// <p>The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.</p>
    pub fn comparison_operator(&self) -> std::option::Option<&str> {
        self.comparison_operator.as_deref()
    }
    /// <p>The value to compare.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for MetricDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimension");
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetricDimension`](crate::model::MetricDimension)
pub mod metric_dimension {
    /// A builder for [`MetricDimension`](crate::model::MetricDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison_operator: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.</p>
        pub fn comparison_operator(mut self, input: impl Into<std::string::String>) -> Self {
            self.comparison_operator = Some(input.into());
            self
        }
        /// <p>The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>The value to compare.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value to compare.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimension`](crate::model::MetricDimension)
        pub fn build(self) -> crate::model::MetricDimension {
            crate::model::MetricDimension {
                comparison_operator: self.comparison_operator,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl MetricDimension {
    /// Creates a new builder-style object to manufacture [`MetricDimension`](crate::model::MetricDimension)
    pub fn builder() -> crate::model::metric_dimension::Builder {
        crate::model::metric_dimension::Builder::default()
    }
}

/// <p>Specifies geographical dimension settings for a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentLocation {
    /// <p>The country or region code, in ISO 3166-1 alpha-2 format, for the segment.</p>
    pub country: std::option::Option<crate::model::SetDimension>,
    /// <p>The GPS location and range for the segment.</p>
    pub gps_point: std::option::Option<crate::model::GpsPointDimension>,
}
impl SegmentLocation {
    /// <p>The country or region code, in ISO 3166-1 alpha-2 format, for the segment.</p>
    pub fn country(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.country.as_ref()
    }
    /// <p>The GPS location and range for the segment.</p>
    pub fn gps_point(&self) -> std::option::Option<&crate::model::GpsPointDimension> {
        self.gps_point.as_ref()
    }
}
impl std::fmt::Debug for SegmentLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentLocation");
        formatter.field("country", &self.country);
        formatter.field("gps_point", &self.gps_point);
        formatter.finish()
    }
}
/// See [`SegmentLocation`](crate::model::SegmentLocation)
pub mod segment_location {
    /// A builder for [`SegmentLocation`](crate::model::SegmentLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country: std::option::Option<crate::model::SetDimension>,
        pub(crate) gps_point: std::option::Option<crate::model::GpsPointDimension>,
    }
    impl Builder {
        /// <p>The country or region code, in ISO 3166-1 alpha-2 format, for the segment.</p>
        pub fn country(mut self, input: crate::model::SetDimension) -> Self {
            self.country = Some(input);
            self
        }
        /// <p>The country or region code, in ISO 3166-1 alpha-2 format, for the segment.</p>
        pub fn set_country(
            mut self,
            input: std::option::Option<crate::model::SetDimension>,
        ) -> Self {
            self.country = input;
            self
        }
        /// <p>The GPS location and range for the segment.</p>
        pub fn gps_point(mut self, input: crate::model::GpsPointDimension) -> Self {
            self.gps_point = Some(input);
            self
        }
        /// <p>The GPS location and range for the segment.</p>
        pub fn set_gps_point(
            mut self,
            input: std::option::Option<crate::model::GpsPointDimension>,
        ) -> Self {
            self.gps_point = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentLocation`](crate::model::SegmentLocation)
        pub fn build(self) -> crate::model::SegmentLocation {
            crate::model::SegmentLocation {
                country: self.country,
                gps_point: self.gps_point,
            }
        }
    }
}
impl SegmentLocation {
    /// Creates a new builder-style object to manufacture [`SegmentLocation`](crate::model::SegmentLocation)
    pub fn builder() -> crate::model::segment_location::Builder {
        crate::model::segment_location::Builder::default()
    }
}

/// <p>Specifies GPS-based criteria for including or excluding endpoints from a segment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GpsPointDimension {
    /// <p>The GPS coordinates to measure distance from.</p>
    pub coordinates: std::option::Option<crate::model::GpsCoordinates>,
    /// <p>The range, in kilometers, from the GPS coordinates.</p>
    pub range_in_kilometers: f64,
}
impl GpsPointDimension {
    /// <p>The GPS coordinates to measure distance from.</p>
    pub fn coordinates(&self) -> std::option::Option<&crate::model::GpsCoordinates> {
        self.coordinates.as_ref()
    }
    /// <p>The range, in kilometers, from the GPS coordinates.</p>
    pub fn range_in_kilometers(&self) -> f64 {
        self.range_in_kilometers
    }
}
impl std::fmt::Debug for GpsPointDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GpsPointDimension");
        formatter.field("coordinates", &self.coordinates);
        formatter.field("range_in_kilometers", &self.range_in_kilometers);
        formatter.finish()
    }
}
/// See [`GpsPointDimension`](crate::model::GpsPointDimension)
pub mod gps_point_dimension {
    /// A builder for [`GpsPointDimension`](crate::model::GpsPointDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) coordinates: std::option::Option<crate::model::GpsCoordinates>,
        pub(crate) range_in_kilometers: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The GPS coordinates to measure distance from.</p>
        pub fn coordinates(mut self, input: crate::model::GpsCoordinates) -> Self {
            self.coordinates = Some(input);
            self
        }
        /// <p>The GPS coordinates to measure distance from.</p>
        pub fn set_coordinates(
            mut self,
            input: std::option::Option<crate::model::GpsCoordinates>,
        ) -> Self {
            self.coordinates = input;
            self
        }
        /// <p>The range, in kilometers, from the GPS coordinates.</p>
        pub fn range_in_kilometers(mut self, input: f64) -> Self {
            self.range_in_kilometers = Some(input);
            self
        }
        /// <p>The range, in kilometers, from the GPS coordinates.</p>
        pub fn set_range_in_kilometers(mut self, input: std::option::Option<f64>) -> Self {
            self.range_in_kilometers = input;
            self
        }
        /// Consumes the builder and constructs a [`GpsPointDimension`](crate::model::GpsPointDimension)
        pub fn build(self) -> crate::model::GpsPointDimension {
            crate::model::GpsPointDimension {
                coordinates: self.coordinates,
                range_in_kilometers: self.range_in_kilometers.unwrap_or_default(),
            }
        }
    }
}
impl GpsPointDimension {
    /// Creates a new builder-style object to manufacture [`GpsPointDimension`](crate::model::GpsPointDimension)
    pub fn builder() -> crate::model::gps_point_dimension::Builder {
        crate::model::gps_point_dimension::Builder::default()
    }
}

/// <p>Specifies the GPS coordinates of a location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GpsCoordinates {
    /// <p>The latitude coordinate of the location.</p>
    pub latitude: f64,
    /// <p>The longitude coordinate of the location.</p>
    pub longitude: f64,
}
impl GpsCoordinates {
    /// <p>The latitude coordinate of the location.</p>
    pub fn latitude(&self) -> f64 {
        self.latitude
    }
    /// <p>The longitude coordinate of the location.</p>
    pub fn longitude(&self) -> f64 {
        self.longitude
    }
}
impl std::fmt::Debug for GpsCoordinates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GpsCoordinates");
        formatter.field("latitude", &self.latitude);
        formatter.field("longitude", &self.longitude);
        formatter.finish()
    }
}
/// See [`GpsCoordinates`](crate::model::GpsCoordinates)
pub mod gps_coordinates {
    /// A builder for [`GpsCoordinates`](crate::model::GpsCoordinates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) latitude: std::option::Option<f64>,
        pub(crate) longitude: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The latitude coordinate of the location.</p>
        pub fn latitude(mut self, input: f64) -> Self {
            self.latitude = Some(input);
            self
        }
        /// <p>The latitude coordinate of the location.</p>
        pub fn set_latitude(mut self, input: std::option::Option<f64>) -> Self {
            self.latitude = input;
            self
        }
        /// <p>The longitude coordinate of the location.</p>
        pub fn longitude(mut self, input: f64) -> Self {
            self.longitude = Some(input);
            self
        }
        /// <p>The longitude coordinate of the location.</p>
        pub fn set_longitude(mut self, input: std::option::Option<f64>) -> Self {
            self.longitude = input;
            self
        }
        /// Consumes the builder and constructs a [`GpsCoordinates`](crate::model::GpsCoordinates)
        pub fn build(self) -> crate::model::GpsCoordinates {
            crate::model::GpsCoordinates {
                latitude: self.latitude.unwrap_or_default(),
                longitude: self.longitude.unwrap_or_default(),
            }
        }
    }
}
impl GpsCoordinates {
    /// Creates a new builder-style object to manufacture [`GpsCoordinates`](crate::model::GpsCoordinates)
    pub fn builder() -> crate::model::gps_coordinates::Builder {
        crate::model::gps_coordinates::Builder::default()
    }
}

/// <p>Specifies the dimension type and values for a segment dimension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDimension {
    /// <p>The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.</p>
    pub dimension_type: std::option::Option<crate::model::DimensionType>,
    /// <p>The criteria values to use for the segment dimension. Depending on the value of the DimensionType property, endpoints are included or excluded from the segment if their values match the criteria values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SetDimension {
    /// <p>The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.</p>
    pub fn dimension_type(&self) -> std::option::Option<&crate::model::DimensionType> {
        self.dimension_type.as_ref()
    }
    /// <p>The criteria values to use for the segment dimension. Depending on the value of the DimensionType property, endpoints are included or excluded from the segment if their values match the criteria values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for SetDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDimension");
        formatter.field("dimension_type", &self.dimension_type);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SetDimension`](crate::model::SetDimension)
pub mod set_dimension {
    /// A builder for [`SetDimension`](crate::model::SetDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_type: std::option::Option<crate::model::DimensionType>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.</p>
        pub fn dimension_type(mut self, input: crate::model::DimensionType) -> Self {
            self.dimension_type = Some(input);
            self
        }
        /// <p>The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.</p>
        pub fn set_dimension_type(
            mut self,
            input: std::option::Option<crate::model::DimensionType>,
        ) -> Self {
            self.dimension_type = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The criteria values to use for the segment dimension. Depending on the value of the DimensionType property, endpoints are included or excluded from the segment if their values match the criteria values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The criteria values to use for the segment dimension. Depending on the value of the DimensionType property, endpoints are included or excluded from the segment if their values match the criteria values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDimension`](crate::model::SetDimension)
        pub fn build(self) -> crate::model::SetDimension {
            crate::model::SetDimension {
                dimension_type: self.dimension_type,
                values: self.values,
            }
        }
    }
}
impl SetDimension {
    /// Creates a new builder-style object to manufacture [`SetDimension`](crate::model::SetDimension)
    pub fn builder() -> crate::model::set_dimension::Builder {
        crate::model::set_dimension::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DimensionType {
    #[allow(missing_docs)] // documentation missing in model
    Exclusive,
    #[allow(missing_docs)] // documentation missing in model
    Inclusive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DimensionType {
    fn from(s: &str) -> Self {
        match s {
            "EXCLUSIVE" => DimensionType::Exclusive,
            "INCLUSIVE" => DimensionType::Inclusive,
            other => DimensionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DimensionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DimensionType::from(s))
    }
}
impl DimensionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DimensionType::Exclusive => "EXCLUSIVE",
            DimensionType::Inclusive => "INCLUSIVE",
            DimensionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXCLUSIVE", "INCLUSIVE"]
    }
}
impl AsRef<str> for DimensionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies demographic-based dimension settings for including or excluding endpoints from a segment. These settings derive from characteristics of endpoint devices, such as platform, make, and model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentDemographics {
    /// <p>The app version criteria for the segment.</p>
    pub app_version: std::option::Option<crate::model::SetDimension>,
    /// <p>The channel criteria for the segment.</p>
    pub channel: std::option::Option<crate::model::SetDimension>,
    /// <p>The device type criteria for the segment.</p>
    pub device_type: std::option::Option<crate::model::SetDimension>,
    /// <p>The device make criteria for the segment.</p>
    pub make: std::option::Option<crate::model::SetDimension>,
    /// <p>The device model criteria for the segment.</p>
    pub model: std::option::Option<crate::model::SetDimension>,
    /// <p>The device platform criteria for the segment.</p>
    pub platform: std::option::Option<crate::model::SetDimension>,
}
impl SegmentDemographics {
    /// <p>The app version criteria for the segment.</p>
    pub fn app_version(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.app_version.as_ref()
    }
    /// <p>The channel criteria for the segment.</p>
    pub fn channel(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.channel.as_ref()
    }
    /// <p>The device type criteria for the segment.</p>
    pub fn device_type(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.device_type.as_ref()
    }
    /// <p>The device make criteria for the segment.</p>
    pub fn make(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.make.as_ref()
    }
    /// <p>The device model criteria for the segment.</p>
    pub fn model(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.model.as_ref()
    }
    /// <p>The device platform criteria for the segment.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.platform.as_ref()
    }
}
impl std::fmt::Debug for SegmentDemographics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentDemographics");
        formatter.field("app_version", &self.app_version);
        formatter.field("channel", &self.channel);
        formatter.field("device_type", &self.device_type);
        formatter.field("make", &self.make);
        formatter.field("model", &self.model);
        formatter.field("platform", &self.platform);
        formatter.finish()
    }
}
/// See [`SegmentDemographics`](crate::model::SegmentDemographics)
pub mod segment_demographics {
    /// A builder for [`SegmentDemographics`](crate::model::SegmentDemographics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_version: std::option::Option<crate::model::SetDimension>,
        pub(crate) channel: std::option::Option<crate::model::SetDimension>,
        pub(crate) device_type: std::option::Option<crate::model::SetDimension>,
        pub(crate) make: std::option::Option<crate::model::SetDimension>,
        pub(crate) model: std::option::Option<crate::model::SetDimension>,
        pub(crate) platform: std::option::Option<crate::model::SetDimension>,
    }
    impl Builder {
        /// <p>The app version criteria for the segment.</p>
        pub fn app_version(mut self, input: crate::model::SetDimension) -> Self {
            self.app_version = Some(input);
            self
        }
        /// <p>The app version criteria for the segment.</p>
        pub fn set_app_version(
            mut self,
            input: std::option::Option<crate::model::SetDimension>,
        ) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The channel criteria for the segment.</p>
        pub fn channel(mut self, input: crate::model::SetDimension) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The channel criteria for the segment.</p>
        pub fn set_channel(
            mut self,
            input: std::option::Option<crate::model::SetDimension>,
        ) -> Self {
            self.channel = input;
            self
        }
        /// <p>The device type criteria for the segment.</p>
        pub fn device_type(mut self, input: crate::model::SetDimension) -> Self {
            self.device_type = Some(input);
            self
        }
        /// <p>The device type criteria for the segment.</p>
        pub fn set_device_type(
            mut self,
            input: std::option::Option<crate::model::SetDimension>,
        ) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The device make criteria for the segment.</p>
        pub fn make(mut self, input: crate::model::SetDimension) -> Self {
            self.make = Some(input);
            self
        }
        /// <p>The device make criteria for the segment.</p>
        pub fn set_make(mut self, input: std::option::Option<crate::model::SetDimension>) -> Self {
            self.make = input;
            self
        }
        /// <p>The device model criteria for the segment.</p>
        pub fn model(mut self, input: crate::model::SetDimension) -> Self {
            self.model = Some(input);
            self
        }
        /// <p>The device model criteria for the segment.</p>
        pub fn set_model(mut self, input: std::option::Option<crate::model::SetDimension>) -> Self {
            self.model = input;
            self
        }
        /// <p>The device platform criteria for the segment.</p>
        pub fn platform(mut self, input: crate::model::SetDimension) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The device platform criteria for the segment.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::SetDimension>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentDemographics`](crate::model::SegmentDemographics)
        pub fn build(self) -> crate::model::SegmentDemographics {
            crate::model::SegmentDemographics {
                app_version: self.app_version,
                channel: self.channel,
                device_type: self.device_type,
                make: self.make,
                model: self.model,
                platform: self.platform,
            }
        }
    }
}
impl SegmentDemographics {
    /// Creates a new builder-style object to manufacture [`SegmentDemographics`](crate::model::SegmentDemographics)
    pub fn builder() -> crate::model::segment_demographics::Builder {
        crate::model::segment_demographics::Builder::default()
    }
}

/// <p>Specifies dimension settings for including or excluding endpoints from a segment based on how recently an endpoint was active.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentBehaviors {
    /// <p>The dimension settings that are based on how recently an endpoint was active.</p>
    pub recency: std::option::Option<crate::model::RecencyDimension>,
}
impl SegmentBehaviors {
    /// <p>The dimension settings that are based on how recently an endpoint was active.</p>
    pub fn recency(&self) -> std::option::Option<&crate::model::RecencyDimension> {
        self.recency.as_ref()
    }
}
impl std::fmt::Debug for SegmentBehaviors {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentBehaviors");
        formatter.field("recency", &self.recency);
        formatter.finish()
    }
}
/// See [`SegmentBehaviors`](crate::model::SegmentBehaviors)
pub mod segment_behaviors {
    /// A builder for [`SegmentBehaviors`](crate::model::SegmentBehaviors)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recency: std::option::Option<crate::model::RecencyDimension>,
    }
    impl Builder {
        /// <p>The dimension settings that are based on how recently an endpoint was active.</p>
        pub fn recency(mut self, input: crate::model::RecencyDimension) -> Self {
            self.recency = Some(input);
            self
        }
        /// <p>The dimension settings that are based on how recently an endpoint was active.</p>
        pub fn set_recency(
            mut self,
            input: std::option::Option<crate::model::RecencyDimension>,
        ) -> Self {
            self.recency = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentBehaviors`](crate::model::SegmentBehaviors)
        pub fn build(self) -> crate::model::SegmentBehaviors {
            crate::model::SegmentBehaviors {
                recency: self.recency,
            }
        }
    }
}
impl SegmentBehaviors {
    /// Creates a new builder-style object to manufacture [`SegmentBehaviors`](crate::model::SegmentBehaviors)
    pub fn builder() -> crate::model::segment_behaviors::Builder {
        crate::model::segment_behaviors::Builder::default()
    }
}

/// <p>Specifies criteria for including or excluding endpoints from a segment based on how recently an endpoint was active.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecencyDimension {
    /// <p>The duration to use when determining whether an endpoint is active or inactive.</p>
    pub duration: std::option::Option<crate::model::Duration>,
    /// <p>The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active within the specified duration are included in the segment.</p>
    pub recency_type: std::option::Option<crate::model::RecencyType>,
}
impl RecencyDimension {
    /// <p>The duration to use when determining whether an endpoint is active or inactive.</p>
    pub fn duration(&self) -> std::option::Option<&crate::model::Duration> {
        self.duration.as_ref()
    }
    /// <p>The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active within the specified duration are included in the segment.</p>
    pub fn recency_type(&self) -> std::option::Option<&crate::model::RecencyType> {
        self.recency_type.as_ref()
    }
}
impl std::fmt::Debug for RecencyDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecencyDimension");
        formatter.field("duration", &self.duration);
        formatter.field("recency_type", &self.recency_type);
        formatter.finish()
    }
}
/// See [`RecencyDimension`](crate::model::RecencyDimension)
pub mod recency_dimension {
    /// A builder for [`RecencyDimension`](crate::model::RecencyDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration: std::option::Option<crate::model::Duration>,
        pub(crate) recency_type: std::option::Option<crate::model::RecencyType>,
    }
    impl Builder {
        /// <p>The duration to use when determining whether an endpoint is active or inactive.</p>
        pub fn duration(mut self, input: crate::model::Duration) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration to use when determining whether an endpoint is active or inactive.</p>
        pub fn set_duration(mut self, input: std::option::Option<crate::model::Duration>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active within the specified duration are included in the segment.</p>
        pub fn recency_type(mut self, input: crate::model::RecencyType) -> Self {
            self.recency_type = Some(input);
            self
        }
        /// <p>The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren't active within the specified duration are included in the segment.</p>
        pub fn set_recency_type(
            mut self,
            input: std::option::Option<crate::model::RecencyType>,
        ) -> Self {
            self.recency_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecencyDimension`](crate::model::RecencyDimension)
        pub fn build(self) -> crate::model::RecencyDimension {
            crate::model::RecencyDimension {
                duration: self.duration,
                recency_type: self.recency_type,
            }
        }
    }
}
impl RecencyDimension {
    /// Creates a new builder-style object to manufacture [`RecencyDimension`](crate::model::RecencyDimension)
    pub fn builder() -> crate::model::recency_dimension::Builder {
        crate::model::recency_dimension::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecencyType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecencyType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RecencyType::Active,
            "INACTIVE" => RecencyType::Inactive,
            other => RecencyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecencyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecencyType::from(s))
    }
}
impl RecencyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecencyType::Active => "ACTIVE",
            RecencyType::Inactive => "INACTIVE",
            RecencyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for RecencyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Duration {
    #[allow(missing_docs)] // documentation missing in model
    Day14,
    #[allow(missing_docs)] // documentation missing in model
    Day30,
    #[allow(missing_docs)] // documentation missing in model
    Day7,
    #[allow(missing_docs)] // documentation missing in model
    Hr24,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Duration {
    fn from(s: &str) -> Self {
        match s {
            "DAY_14" => Duration::Day14,
            "DAY_30" => Duration::Day30,
            "DAY_7" => Duration::Day7,
            "HR_24" => Duration::Hr24,
            other => Duration::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Duration {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Duration::from(s))
    }
}
impl Duration {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Duration::Day14 => "DAY_14",
            Duration::Day30 => "DAY_30",
            Duration::Day7 => "DAY_7",
            Duration::Hr24 => "HR_24",
            Duration::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAY_14", "DAY_30", "DAY_7", "HR_24"]
    }
}
impl AsRef<str> for Duration {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the import job that created a segment. An import job is a job that creates a user segment by importing endpoint definitions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentImportResource {
    /// <p>The number of channel types in the endpoint definitions that were imported to create the segment.</p>
    pub channel_counts: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    /// <p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.</p>
    pub format: std::option::Option<crate::model::Format>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.</p>
    pub s3_url: std::option::Option<std::string::String>,
    /// <p>The number of endpoint definitions that were imported successfully to create the segment.</p>
    pub size: i32,
}
impl SegmentImportResource {
    /// <p>The number of channel types in the endpoint definitions that were imported to create the segment.</p>
    pub fn channel_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i32>> {
        self.channel_counts.as_ref()
    }
    /// <p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.</p>
    pub fn s3_url(&self) -> std::option::Option<&str> {
        self.s3_url.as_deref()
    }
    /// <p>The number of endpoint definitions that were imported successfully to create the segment.</p>
    pub fn size(&self) -> i32 {
        self.size
    }
}
impl std::fmt::Debug for SegmentImportResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentImportResource");
        formatter.field("channel_counts", &self.channel_counts);
        formatter.field("external_id", &self.external_id);
        formatter.field("format", &self.format);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("s3_url", &self.s3_url);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`SegmentImportResource`](crate::model::SegmentImportResource)
pub mod segment_import_resource {
    /// A builder for [`SegmentImportResource`](crate::model::SegmentImportResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_counts:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::Format>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) s3_url: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i32>,
    }
    impl Builder {
        /// Adds a key-value pair to `channel_counts`.
        ///
        /// To override the contents of this collection use [`set_channel_counts`](Self::set_channel_counts).
        ///
        /// <p>The number of channel types in the endpoint definitions that were imported to create the segment.</p>
        pub fn channel_counts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.channel_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.channel_counts = Some(hash_map);
            self
        }
        /// <p>The number of channel types in the endpoint definitions that were imported to create the segment.</p>
        pub fn set_channel_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.channel_counts = input;
            self
        }
        /// <p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.</p>
        pub fn s3_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_url = Some(input.into());
            self
        }
        /// <p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.</p>
        pub fn set_s3_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_url = input;
            self
        }
        /// <p>The number of endpoint definitions that were imported successfully to create the segment.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The number of endpoint definitions that were imported successfully to create the segment.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentImportResource`](crate::model::SegmentImportResource)
        pub fn build(self) -> crate::model::SegmentImportResource {
            crate::model::SegmentImportResource {
                channel_counts: self.channel_counts,
                external_id: self.external_id,
                format: self.format,
                role_arn: self.role_arn,
                s3_url: self.s3_url,
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl SegmentImportResource {
    /// Creates a new builder-style object to manufacture [`SegmentImportResource`](crate::model::SegmentImportResource)
    pub fn builder() -> crate::model::segment_import_resource::Builder {
        crate::model::segment_import_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Format {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Format {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => Format::Csv,
            "JSON" => Format::Json,
            other => Format::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Format {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Format::from(s))
    }
}
impl Format {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Format::Csv => "CSV",
            Format::Json => "JSON",
            Format::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON"]
    }
}
impl AsRef<str> for Format {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteSegmentRequest {
    /// <p>The criteria that define the dimensions for the segment.</p>
    pub dimensions: std::option::Option<crate::model::SegmentDimensions>,
    /// <p>The name of the segment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.</p>
    pub segment_groups: std::option::Option<crate::model::SegmentGroupList>,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl WriteSegmentRequest {
    /// <p>The criteria that define the dimensions for the segment.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::SegmentDimensions> {
        self.dimensions.as_ref()
    }
    /// <p>The name of the segment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.</p>
    pub fn segment_groups(&self) -> std::option::Option<&crate::model::SegmentGroupList> {
        self.segment_groups.as_ref()
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for WriteSegmentRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteSegmentRequest");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("name", &self.name);
        formatter.field("segment_groups", &self.segment_groups);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`WriteSegmentRequest`](crate::model::WriteSegmentRequest)
pub mod write_segment_request {
    /// A builder for [`WriteSegmentRequest`](crate::model::WriteSegmentRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<crate::model::SegmentDimensions>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) segment_groups: std::option::Option<crate::model::SegmentGroupList>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The criteria that define the dimensions for the segment.</p>
        pub fn dimensions(mut self, input: crate::model::SegmentDimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The criteria that define the dimensions for the segment.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::SegmentDimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The name of the segment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the segment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.</p>
        pub fn segment_groups(mut self, input: crate::model::SegmentGroupList) -> Self {
            self.segment_groups = Some(input);
            self
        }
        /// <p>The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.</p>
        pub fn set_segment_groups(
            mut self,
            input: std::option::Option<crate::model::SegmentGroupList>,
        ) -> Self {
            self.segment_groups = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteSegmentRequest`](crate::model::WriteSegmentRequest)
        pub fn build(self) -> crate::model::WriteSegmentRequest {
            crate::model::WriteSegmentRequest {
                dimensions: self.dimensions,
                name: self.name,
                segment_groups: self.segment_groups,
                tags: self.tags,
            }
        }
    }
}
impl WriteSegmentRequest {
    /// Creates a new builder-style object to manufacture [`WriteSegmentRequest`](crate::model::WriteSegmentRequest)
    pub fn builder() -> crate::model::write_segment_request::Builder {
        crate::model::write_segment_request::Builder::default()
    }
}

/// <p>Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommenderConfigurationResponse {
    /// <p>A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date, in extended ISO 8601 format, when the configuration was created for the recommender model.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The custom description of the configuration for the recommender model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the recommender model configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The custom name of the configuration for the recommender model.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
    pub recommendation_provider_id_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
    pub recommendation_provider_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.</p>
    pub recommendation_provider_uri: std::option::Option<std::string::String>,
    /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.</p>
    pub recommendation_transformer_uri: std::option::Option<std::string::String>,
    /// <p>The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
    pub recommendations_display_name: std::option::Option<std::string::String>,
    /// <p>The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.</p>
    pub recommendations_per_message: i32,
}
impl RecommenderConfigurationResponse {
    /// <p>A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>The date, in extended ISO 8601 format, when the configuration was created for the recommender model.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The custom description of the configuration for the recommender model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the recommender model configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The custom name of the configuration for the recommender model.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
    pub fn recommendation_provider_id_type(&self) -> std::option::Option<&str> {
        self.recommendation_provider_id_type.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
    pub fn recommendation_provider_role_arn(&self) -> std::option::Option<&str> {
        self.recommendation_provider_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.</p>
    pub fn recommendation_provider_uri(&self) -> std::option::Option<&str> {
        self.recommendation_provider_uri.as_deref()
    }
    /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.</p>
    pub fn recommendation_transformer_uri(&self) -> std::option::Option<&str> {
        self.recommendation_transformer_uri.as_deref()
    }
    /// <p>The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
    pub fn recommendations_display_name(&self) -> std::option::Option<&str> {
        self.recommendations_display_name.as_deref()
    }
    /// <p>The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.</p>
    pub fn recommendations_per_message(&self) -> i32 {
        self.recommendations_per_message
    }
}
impl std::fmt::Debug for RecommenderConfigurationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommenderConfigurationResponse");
        formatter.field("attributes", &self.attributes);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("name", &self.name);
        formatter.field(
            "recommendation_provider_id_type",
            &self.recommendation_provider_id_type,
        );
        formatter.field(
            "recommendation_provider_role_arn",
            &self.recommendation_provider_role_arn,
        );
        formatter.field(
            "recommendation_provider_uri",
            &self.recommendation_provider_uri,
        );
        formatter.field(
            "recommendation_transformer_uri",
            &self.recommendation_transformer_uri,
        );
        formatter.field(
            "recommendations_display_name",
            &self.recommendations_display_name,
        );
        formatter.field(
            "recommendations_per_message",
            &self.recommendations_per_message,
        );
        formatter.finish()
    }
}
/// See [`RecommenderConfigurationResponse`](crate::model::RecommenderConfigurationResponse)
pub mod recommender_configuration_response {
    /// A builder for [`RecommenderConfigurationResponse`](crate::model::RecommenderConfigurationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recommendation_provider_id_type: std::option::Option<std::string::String>,
        pub(crate) recommendation_provider_role_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_provider_uri: std::option::Option<std::string::String>,
        pub(crate) recommendation_transformer_uri: std::option::Option<std::string::String>,
        pub(crate) recommendations_display_name: std::option::Option<std::string::String>,
        pub(crate) recommendations_per_message: std::option::Option<i32>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The date, in extended ISO 8601 format, when the configuration was created for the recommender model.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date, in extended ISO 8601 format, when the configuration was created for the recommender model.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The custom description of the configuration for the recommender model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The custom description of the configuration for the recommender model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the recommender model configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The custom name of the configuration for the recommender model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name of the configuration for the recommender model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
        pub fn recommendation_provider_id_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_provider_id_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
        pub fn set_recommendation_provider_id_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_provider_id_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
        pub fn recommendation_provider_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_provider_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
        pub fn set_recommendation_provider_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_provider_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.</p>
        pub fn recommendation_provider_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_provider_uri = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.</p>
        pub fn set_recommendation_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_provider_uri = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.</p>
        pub fn recommendation_transformer_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_transformer_uri = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.</p>
        pub fn set_recommendation_transformer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_transformer_uri = input;
            self
        }
        /// <p>The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
        pub fn recommendations_display_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendations_display_name = Some(input.into());
            self
        }
        /// <p>The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.</p> <p>This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
        pub fn set_recommendations_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendations_display_name = input;
            self
        }
        /// <p>The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.</p>
        pub fn recommendations_per_message(mut self, input: i32) -> Self {
            self.recommendations_per_message = Some(input);
            self
        }
        /// <p>The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.</p>
        pub fn set_recommendations_per_message(mut self, input: std::option::Option<i32>) -> Self {
            self.recommendations_per_message = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommenderConfigurationResponse`](crate::model::RecommenderConfigurationResponse)
        pub fn build(self) -> crate::model::RecommenderConfigurationResponse {
            crate::model::RecommenderConfigurationResponse {
                attributes: self.attributes,
                creation_date: self.creation_date,
                description: self.description,
                id: self.id,
                last_modified_date: self.last_modified_date,
                name: self.name,
                recommendation_provider_id_type: self.recommendation_provider_id_type,
                recommendation_provider_role_arn: self.recommendation_provider_role_arn,
                recommendation_provider_uri: self.recommendation_provider_uri,
                recommendation_transformer_uri: self.recommendation_transformer_uri,
                recommendations_display_name: self.recommendations_display_name,
                recommendations_per_message: self.recommendations_per_message.unwrap_or_default(),
            }
        }
    }
}
impl RecommenderConfigurationResponse {
    /// Creates a new builder-style object to manufacture [`RecommenderConfigurationResponse`](crate::model::RecommenderConfigurationResponse)
    pub fn builder() -> crate::model::recommender_configuration_response::Builder {
        crate::model::recommender_configuration_response::Builder::default()
    }
}

/// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecommenderConfigurationShape {
    /// <p>A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:</p> <ul><li><p>An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.</p></li> <li><p>An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p></li></ul> <p>This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in your request.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
    pub recommendation_provider_id_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
    pub recommendation_provider_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.</p>
    pub recommendation_provider_uri: std::option::Option<std::string::String>,
    /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that's retrieved from the recommender model.</p>
    pub recommendation_transformer_uri: std::option::Option<std::string::String>,
    /// <p>A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p> <p>This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don't apply to attribute values.</p>
    pub recommendations_display_name: std::option::Option<std::string::String>,
    /// <p>The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.</p> <p>To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
    pub recommendations_per_message: i32,
}
impl UpdateRecommenderConfigurationShape {
    /// <p>A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:</p> <ul><li><p>An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.</p></li> <li><p>An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p></li></ul> <p>This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in your request.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
    pub fn recommendation_provider_id_type(&self) -> std::option::Option<&str> {
        self.recommendation_provider_id_type.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
    pub fn recommendation_provider_role_arn(&self) -> std::option::Option<&str> {
        self.recommendation_provider_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.</p>
    pub fn recommendation_provider_uri(&self) -> std::option::Option<&str> {
        self.recommendation_provider_uri.as_deref()
    }
    /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that's retrieved from the recommender model.</p>
    pub fn recommendation_transformer_uri(&self) -> std::option::Option<&str> {
        self.recommendation_transformer_uri.as_deref()
    }
    /// <p>A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p> <p>This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don't apply to attribute values.</p>
    pub fn recommendations_display_name(&self) -> std::option::Option<&str> {
        self.recommendations_display_name.as_deref()
    }
    /// <p>The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.</p> <p>To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
    pub fn recommendations_per_message(&self) -> i32 {
        self.recommendations_per_message
    }
}
impl std::fmt::Debug for UpdateRecommenderConfigurationShape {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecommenderConfigurationShape");
        formatter.field("attributes", &self.attributes);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field(
            "recommendation_provider_id_type",
            &self.recommendation_provider_id_type,
        );
        formatter.field(
            "recommendation_provider_role_arn",
            &self.recommendation_provider_role_arn,
        );
        formatter.field(
            "recommendation_provider_uri",
            &self.recommendation_provider_uri,
        );
        formatter.field(
            "recommendation_transformer_uri",
            &self.recommendation_transformer_uri,
        );
        formatter.field(
            "recommendations_display_name",
            &self.recommendations_display_name,
        );
        formatter.field(
            "recommendations_per_message",
            &self.recommendations_per_message,
        );
        formatter.finish()
    }
}
/// See [`UpdateRecommenderConfigurationShape`](crate::model::UpdateRecommenderConfigurationShape)
pub mod update_recommender_configuration_shape {
    /// A builder for [`UpdateRecommenderConfigurationShape`](crate::model::UpdateRecommenderConfigurationShape)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recommendation_provider_id_type: std::option::Option<std::string::String>,
        pub(crate) recommendation_provider_role_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_provider_uri: std::option::Option<std::string::String>,
        pub(crate) recommendation_transformer_uri: std::option::Option<std::string::String>,
        pub(crate) recommendations_display_name: std::option::Option<std::string::String>,
        pub(crate) recommendations_per_message: std::option::Option<i32>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:</p> <ul><li><p>An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.</p></li> <li><p>An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p></li></ul> <p>This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in your request.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:</p> <ul><li><p>An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.</p></li> <li><p>An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p></li></ul> <p>This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in your request.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
        pub fn recommendation_provider_id_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_provider_id_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.</p></li></ul>
        pub fn set_recommendation_provider_id_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_provider_id_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
        pub fn recommendation_provider_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_provider_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>
        pub fn set_recommendation_provider_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_provider_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.</p>
        pub fn recommendation_provider_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_provider_uri = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.</p>
        pub fn set_recommendation_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_provider_uri = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that's retrieved from the recommender model.</p>
        pub fn recommendation_transformer_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_transformer_uri = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that's retrieved from the recommender model.</p>
        pub fn set_recommendation_transformer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_transformer_uri = input;
            self
        }
        /// <p>A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p> <p>This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don't apply to attribute values.</p>
        pub fn recommendations_display_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendations_display_name = Some(input.into());
            self
        }
        /// <p>A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p> <p>This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don't apply to attribute values.</p>
        pub fn set_recommendations_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendations_display_name = input;
            self
        }
        /// <p>The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.</p> <p>To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
        pub fn recommendations_per_message(mut self, input: i32) -> Self {
            self.recommendations_per_message = Some(input);
            self
        }
        /// <p>The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.</p> <p>To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>
        pub fn set_recommendations_per_message(mut self, input: std::option::Option<i32>) -> Self {
            self.recommendations_per_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecommenderConfigurationShape`](crate::model::UpdateRecommenderConfigurationShape)
        pub fn build(self) -> crate::model::UpdateRecommenderConfigurationShape {
            crate::model::UpdateRecommenderConfigurationShape {
                attributes: self.attributes,
                description: self.description,
                name: self.name,
                recommendation_provider_id_type: self.recommendation_provider_id_type,
                recommendation_provider_role_arn: self.recommendation_provider_role_arn,
                recommendation_provider_uri: self.recommendation_provider_uri,
                recommendation_transformer_uri: self.recommendation_transformer_uri,
                recommendations_display_name: self.recommendations_display_name,
                recommendations_per_message: self.recommendations_per_message.unwrap_or_default(),
            }
        }
    }
}
impl UpdateRecommenderConfigurationShape {
    /// Creates a new builder-style object to manufacture [`UpdateRecommenderConfigurationShape`](crate::model::UpdateRecommenderConfigurationShape)
    pub fn builder() -> crate::model::update_recommender_configuration_shape::Builder {
        crate::model::update_recommender_configuration_shape::Builder::default()
    }
}

/// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PushNotificationTemplateRequest {
    /// <p>The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub adm: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
    /// <p>The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub apns: std::option::Option<crate::model::ApnsPushNotificationTemplate>,
    /// <p>The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub baidu: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
    /// <p>The default message template to use for push notification channels.</p>
    ///
    /// _Note: This member has been renamed from `default`._
    pub default_value: std::option::Option<crate::model::DefaultPushNotificationTemplate>,
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub default_substitutions: std::option::Option<std::string::String>,
    /// <p>The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub gcm: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
    /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
    pub recommender_id: std::option::Option<std::string::String>,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A custom description of the message template.</p>
    pub template_description: std::option::Option<std::string::String>,
}
impl PushNotificationTemplateRequest {
    /// <p>The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub fn adm(&self) -> std::option::Option<&crate::model::AndroidPushNotificationTemplate> {
        self.adm.as_ref()
    }
    /// <p>The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub fn apns(&self) -> std::option::Option<&crate::model::ApnsPushNotificationTemplate> {
        self.apns.as_ref()
    }
    /// <p>The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub fn baidu(&self) -> std::option::Option<&crate::model::AndroidPushNotificationTemplate> {
        self.baidu.as_ref()
    }
    /// <p>The default message template to use for push notification channels.</p>
    ///
    /// _Note: This member has been renamed from `default`._
    pub fn default_value(
        &self,
    ) -> std::option::Option<&crate::model::DefaultPushNotificationTemplate> {
        self.default_value.as_ref()
    }
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub fn default_substitutions(&self) -> std::option::Option<&str> {
        self.default_substitutions.as_deref()
    }
    /// <p>The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
    pub fn gcm(&self) -> std::option::Option<&crate::model::AndroidPushNotificationTemplate> {
        self.gcm.as_ref()
    }
    /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
    pub fn recommender_id(&self) -> std::option::Option<&str> {
        self.recommender_id.as_deref()
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A custom description of the message template.</p>
    pub fn template_description(&self) -> std::option::Option<&str> {
        self.template_description.as_deref()
    }
}
impl std::fmt::Debug for PushNotificationTemplateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PushNotificationTemplateRequest");
        formatter.field("adm", &self.adm);
        formatter.field("apns", &self.apns);
        formatter.field("baidu", &self.baidu);
        formatter.field("default_value", &self.default_value);
        formatter.field("default_substitutions", &self.default_substitutions);
        formatter.field("gcm", &self.gcm);
        formatter.field("recommender_id", &self.recommender_id);
        formatter.field("tags", &self.tags);
        formatter.field("template_description", &self.template_description);
        formatter.finish()
    }
}
/// See [`PushNotificationTemplateRequest`](crate::model::PushNotificationTemplateRequest)
pub mod push_notification_template_request {
    /// A builder for [`PushNotificationTemplateRequest`](crate::model::PushNotificationTemplateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adm: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
        pub(crate) apns: std::option::Option<crate::model::ApnsPushNotificationTemplate>,
        pub(crate) baidu: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
        pub(crate) default_value:
            std::option::Option<crate::model::DefaultPushNotificationTemplate>,
        pub(crate) default_substitutions: std::option::Option<std::string::String>,
        pub(crate) gcm: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
        pub(crate) recommender_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn adm(mut self, input: crate::model::AndroidPushNotificationTemplate) -> Self {
            self.adm = Some(input);
            self
        }
        /// <p>The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn set_adm(
            mut self,
            input: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
        ) -> Self {
            self.adm = input;
            self
        }
        /// <p>The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn apns(mut self, input: crate::model::ApnsPushNotificationTemplate) -> Self {
            self.apns = Some(input);
            self
        }
        /// <p>The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn set_apns(
            mut self,
            input: std::option::Option<crate::model::ApnsPushNotificationTemplate>,
        ) -> Self {
            self.apns = input;
            self
        }
        /// <p>The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn baidu(mut self, input: crate::model::AndroidPushNotificationTemplate) -> Self {
            self.baidu = Some(input);
            self
        }
        /// <p>The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn set_baidu(
            mut self,
            input: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
        ) -> Self {
            self.baidu = input;
            self
        }
        /// <p>The default message template to use for push notification channels.</p>
        pub fn default_value(
            mut self,
            input: crate::model::DefaultPushNotificationTemplate,
        ) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>The default message template to use for push notification channels.</p>
        pub fn set_default(
            mut self,
            input: std::option::Option<crate::model::DefaultPushNotificationTemplate>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn default_substitutions(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_substitutions = Some(input.into());
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn set_default_substitutions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_substitutions = input;
            self
        }
        /// <p>The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn gcm(mut self, input: crate::model::AndroidPushNotificationTemplate) -> Self {
            self.gcm = Some(input);
            self
        }
        /// <p>The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>
        pub fn set_gcm(
            mut self,
            input: std::option::Option<crate::model::AndroidPushNotificationTemplate>,
        ) -> Self {
            self.gcm = input;
            self
        }
        /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn template_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_description = Some(input.into());
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn set_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_description = input;
            self
        }
        /// Consumes the builder and constructs a [`PushNotificationTemplateRequest`](crate::model::PushNotificationTemplateRequest)
        pub fn build(self) -> crate::model::PushNotificationTemplateRequest {
            crate::model::PushNotificationTemplateRequest {
                adm: self.adm,
                apns: self.apns,
                baidu: self.baidu,
                default_value: self.default_value,
                default_substitutions: self.default_substitutions,
                gcm: self.gcm,
                recommender_id: self.recommender_id,
                tags: self.tags,
                template_description: self.template_description,
            }
        }
    }
}
impl PushNotificationTemplateRequest {
    /// Creates a new builder-style object to manufacture [`PushNotificationTemplateRequest`](crate::model::PushNotificationTemplateRequest)
    pub fn builder() -> crate::model::push_notification_template_request::Builder {
        crate::model::push_notification_template_request::Builder::default()
    }
}

/// <p>Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the ADM (Amazon Device Messaging), Baidu (Baidu Cloud Push), or GCM (Firebase Cloud Messaging, formerly Google Cloud Messaging) channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AndroidPushNotificationTemplate {
    /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The message body to use in a push notification that's based on the message template.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The URL of the large icon image to display in the content view of a push notification that's based on the message template.</p>
    pub image_icon_url: std::option::Option<std::string::String>,
    /// <p>The URL of an image to display in a push notification that's based on the message template.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>The raw, JSON-formatted string to use as the payload for a push notification that's based on the message template. If specified, this value overrides all other content for the message template.</p>
    pub raw_content: std::option::Option<std::string::String>,
    /// <p>The URL of the small icon image to display in the status bar and the content view of a push notification that's based on the message template.</p>
    pub small_image_icon_url: std::option::Option<std::string::String>,
    /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>
    pub sound: std::option::Option<std::string::String>,
    /// <p>The title to use in a push notification that's based on the message template. This title appears above the notification message on a recipient's device.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
    pub url: std::option::Option<std::string::String>,
}
impl AndroidPushNotificationTemplate {
    /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The message body to use in a push notification that's based on the message template.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The URL of the large icon image to display in the content view of a push notification that's based on the message template.</p>
    pub fn image_icon_url(&self) -> std::option::Option<&str> {
        self.image_icon_url.as_deref()
    }
    /// <p>The URL of an image to display in a push notification that's based on the message template.</p>
    pub fn image_url(&self) -> std::option::Option<&str> {
        self.image_url.as_deref()
    }
    /// <p>The raw, JSON-formatted string to use as the payload for a push notification that's based on the message template. If specified, this value overrides all other content for the message template.</p>
    pub fn raw_content(&self) -> std::option::Option<&str> {
        self.raw_content.as_deref()
    }
    /// <p>The URL of the small icon image to display in the status bar and the content view of a push notification that's based on the message template.</p>
    pub fn small_image_icon_url(&self) -> std::option::Option<&str> {
        self.small_image_icon_url.as_deref()
    }
    /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>
    pub fn sound(&self) -> std::option::Option<&str> {
        self.sound.as_deref()
    }
    /// <p>The title to use in a push notification that's based on the message template. This title appears above the notification message on a recipient's device.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for AndroidPushNotificationTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AndroidPushNotificationTemplate");
        formatter.field("action", &self.action);
        formatter.field("body", &self.body);
        formatter.field("image_icon_url", &self.image_icon_url);
        formatter.field("image_url", &self.image_url);
        formatter.field("raw_content", &self.raw_content);
        formatter.field("small_image_icon_url", &self.small_image_icon_url);
        formatter.field("sound", &self.sound);
        formatter.field("title", &self.title);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`AndroidPushNotificationTemplate`](crate::model::AndroidPushNotificationTemplate)
pub mod android_push_notification_template {
    /// A builder for [`AndroidPushNotificationTemplate`](crate::model::AndroidPushNotificationTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) image_icon_url: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) raw_content: std::option::Option<std::string::String>,
        pub(crate) small_image_icon_url: std::option::Option<std::string::String>,
        pub(crate) sound: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The message body to use in a push notification that's based on the message template.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The message body to use in a push notification that's based on the message template.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The URL of the large icon image to display in the content view of a push notification that's based on the message template.</p>
        pub fn image_icon_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_icon_url = Some(input.into());
            self
        }
        /// <p>The URL of the large icon image to display in the content view of a push notification that's based on the message template.</p>
        pub fn set_image_icon_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_icon_url = input;
            self
        }
        /// <p>The URL of an image to display in a push notification that's based on the message template.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The URL of an image to display in a push notification that's based on the message template.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for a push notification that's based on the message template. If specified, this value overrides all other content for the message template.</p>
        pub fn raw_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_content = Some(input.into());
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for a push notification that's based on the message template. If specified, this value overrides all other content for the message template.</p>
        pub fn set_raw_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_content = input;
            self
        }
        /// <p>The URL of the small icon image to display in the status bar and the content view of a push notification that's based on the message template.</p>
        pub fn small_image_icon_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.small_image_icon_url = Some(input.into());
            self
        }
        /// <p>The URL of the small icon image to display in the status bar and the content view of a push notification that's based on the message template.</p>
        pub fn set_small_image_icon_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.small_image_icon_url = input;
            self
        }
        /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>
        pub fn sound(mut self, input: impl Into<std::string::String>) -> Self {
            self.sound = Some(input.into());
            self
        }
        /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>
        pub fn set_sound(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sound = input;
            self
        }
        /// <p>The title to use in a push notification that's based on the message template. This title appears above the notification message on a recipient's device.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title to use in a push notification that's based on the message template. This title appears above the notification message on a recipient's device.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`AndroidPushNotificationTemplate`](crate::model::AndroidPushNotificationTemplate)
        pub fn build(self) -> crate::model::AndroidPushNotificationTemplate {
            crate::model::AndroidPushNotificationTemplate {
                action: self.action,
                body: self.body,
                image_icon_url: self.image_icon_url,
                image_url: self.image_url,
                raw_content: self.raw_content,
                small_image_icon_url: self.small_image_icon_url,
                sound: self.sound,
                title: self.title,
                url: self.url,
            }
        }
    }
}
impl AndroidPushNotificationTemplate {
    /// Creates a new builder-style object to manufacture [`AndroidPushNotificationTemplate`](crate::model::AndroidPushNotificationTemplate)
    pub fn builder() -> crate::model::android_push_notification_template::Builder {
        crate::model::android_push_notification_template::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Action {
    #[allow(missing_docs)] // documentation missing in model
    DeepLink,
    #[allow(missing_docs)] // documentation missing in model
    OpenApp,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Action {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_LINK" => Action::DeepLink,
            "OPEN_APP" => Action::OpenApp,
            "URL" => Action::Url,
            other => Action::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Action {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Action::from(s))
    }
}
impl Action {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Action::DeepLink => "DEEP_LINK",
            Action::OpenApp => "OPEN_APP",
            Action::Url => "URL",
            Action::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEEP_LINK", "OPEN_APP", "URL"]
    }
}
impl AsRef<str> for Action {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the default settings and content for a message template that can be used in messages that are sent through a push notification channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultPushNotificationTemplate {
    /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The message body to use in push notifications that are based on the message template.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p> <p>For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
    pub sound: std::option::Option<std::string::String>,
    /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
    pub url: std::option::Option<std::string::String>,
}
impl DefaultPushNotificationTemplate {
    /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The message body to use in push notifications that are based on the message template.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p> <p>For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
    pub fn sound(&self) -> std::option::Option<&str> {
        self.sound.as_deref()
    }
    /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for DefaultPushNotificationTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultPushNotificationTemplate");
        formatter.field("action", &self.action);
        formatter.field("body", &self.body);
        formatter.field("sound", &self.sound);
        formatter.field("title", &self.title);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`DefaultPushNotificationTemplate`](crate::model::DefaultPushNotificationTemplate)
pub mod default_push_notification_template {
    /// A builder for [`DefaultPushNotificationTemplate`](crate::model::DefaultPushNotificationTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) sound: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The message body to use in push notifications that are based on the message template.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The message body to use in push notifications that are based on the message template.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p> <p>For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
        pub fn sound(mut self, input: impl Into<std::string::String>) -> Self {
            self.sound = Some(input.into());
            self
        }
        /// <p>The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p> <p>For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
        pub fn set_sound(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sound = input;
            self
        }
        /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultPushNotificationTemplate`](crate::model::DefaultPushNotificationTemplate)
        pub fn build(self) -> crate::model::DefaultPushNotificationTemplate {
            crate::model::DefaultPushNotificationTemplate {
                action: self.action,
                body: self.body,
                sound: self.sound,
                title: self.title,
                url: self.url,
            }
        }
    }
}
impl DefaultPushNotificationTemplate {
    /// Creates a new builder-style object to manufacture [`DefaultPushNotificationTemplate`](crate::model::DefaultPushNotificationTemplate)
    pub fn builder() -> crate::model::default_push_notification_template::Builder {
        crate::model::default_push_notification_template::Builder::default()
    }
}

/// <p>Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the APNs (Apple Push Notification service) channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsPushNotificationTemplate {
    /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The message body to use in push notifications that are based on the message template.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The URL of an image or video to display in push notifications that are based on the message template.</p>
    pub media_url: std::option::Option<std::string::String>,
    /// <p>The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.</p>
    pub raw_content: std::option::Option<std::string::String>,
    /// <p>The key for the sound to play when the recipient receives a push notification that's based on the message template. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
    pub sound: std::option::Option<std::string::String>,
    /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
    pub url: std::option::Option<std::string::String>,
}
impl ApnsPushNotificationTemplate {
    /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The message body to use in push notifications that are based on the message template.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The URL of an image or video to display in push notifications that are based on the message template.</p>
    pub fn media_url(&self) -> std::option::Option<&str> {
        self.media_url.as_deref()
    }
    /// <p>The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.</p>
    pub fn raw_content(&self) -> std::option::Option<&str> {
        self.raw_content.as_deref()
    }
    /// <p>The key for the sound to play when the recipient receives a push notification that's based on the message template. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
    pub fn sound(&self) -> std::option::Option<&str> {
        self.sound.as_deref()
    }
    /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for ApnsPushNotificationTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApnsPushNotificationTemplate");
        formatter.field("action", &self.action);
        formatter.field("body", &self.body);
        formatter.field("media_url", &self.media_url);
        formatter.field("raw_content", &self.raw_content);
        formatter.field("sound", &self.sound);
        formatter.field("title", &self.title);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`ApnsPushNotificationTemplate`](crate::model::ApnsPushNotificationTemplate)
pub mod apns_push_notification_template {
    /// A builder for [`ApnsPushNotificationTemplate`](crate::model::ApnsPushNotificationTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) media_url: std::option::Option<std::string::String>,
        pub(crate) raw_content: std::option::Option<std::string::String>,
        pub(crate) sound: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The message body to use in push notifications that are based on the message template.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The message body to use in push notifications that are based on the message template.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The URL of an image or video to display in push notifications that are based on the message template.</p>
        pub fn media_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_url = Some(input.into());
            self
        }
        /// <p>The URL of an image or video to display in push notifications that are based on the message template.</p>
        pub fn set_media_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_url = input;
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.</p>
        pub fn raw_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_content = Some(input.into());
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.</p>
        pub fn set_raw_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_content = input;
            self
        }
        /// <p>The key for the sound to play when the recipient receives a push notification that's based on the message template. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
        pub fn sound(mut self, input: impl Into<std::string::String>) -> Self {
            self.sound = Some(input.into());
            self
        }
        /// <p>The key for the sound to play when the recipient receives a push notification that's based on the message template. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.</p>
        pub fn set_sound(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sound = input;
            self
        }
        /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`ApnsPushNotificationTemplate`](crate::model::ApnsPushNotificationTemplate)
        pub fn build(self) -> crate::model::ApnsPushNotificationTemplate {
            crate::model::ApnsPushNotificationTemplate {
                action: self.action,
                body: self.body,
                media_url: self.media_url,
                raw_content: self.raw_content,
                sound: self.sound,
                title: self.title,
                url: self.url,
            }
        }
    }
}
impl ApnsPushNotificationTemplate {
    /// Creates a new builder-style object to manufacture [`ApnsPushNotificationTemplate`](crate::model::ApnsPushNotificationTemplate)
    pub fn builder() -> crate::model::apns_push_notification_template::Builder {
        crate::model::apns_push_notification_template::Builder::default()
    }
}

/// <p>Provides information about the status, configuration, and other settings for a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyResponse {
    /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.</p>
    pub activities:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Activity>>,
    /// <p>The unique identifier for the application that the journey applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date, in ISO 8601 format, when the journey was created.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the journey.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The messaging and entry limits for the journey.</p>
    pub limits: std::option::Option<crate::model::JourneyLimits>,
    /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. If this value is true, the schedule uses each participant's local time.</p>
    pub local_time: bool,
    /// <p>The name of the journey.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
    pub quiet_time: std::option::Option<crate::model::QuietTime>,
    /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
    pub refresh_frequency: std::option::Option<std::string::String>,
    /// <p>The schedule settings for the journey.</p>
    pub schedule: std::option::Option<crate::model::JourneySchedule>,
    /// <p>The unique identifier for the first activity in the journey.</p>
    pub start_activity: std::option::Option<std::string::String>,
    /// <p>The segment that defines which users are participants in the journey.</p>
    pub start_condition: std::option::Option<crate::model::StartCondition>,
    /// <p>The current status of the journey. Possible values are:</p> <ul><li><p>DRAFT - The journey is being developed and hasn't been published yet.</p></li> <li><p>ACTIVE - The journey has been developed and published. Depending on the journey's schedule, the journey may currently be running or scheduled to start running at a later time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li> <li><p>COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.</p></li> <li><p>CANCELLED - The journey has been stopped. If a journey's status is CANCELLED, you can't add, change, or remove activities or segment settings from the journey.</p></li> <li><p>CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn't been specified for it. If a journey's status is CLOSED, you can't add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.</p></li></ul>
    pub state: std::option::Option<crate::model::State>,
    /// <p>This object is not used or supported.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
    pub wait_for_quiet_time: bool,
    /// <p>Specifies whether a journey should be refreshed on segment update.</p>
    pub refresh_on_segment_update: bool,
    /// <p>The channel-specific configurations for the journey.</p>
    pub journey_channel_settings: std::option::Option<crate::model::JourneyChannelSettings>,
}
impl JourneyResponse {
    /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.</p>
    pub fn activities(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Activity>>
    {
        self.activities.as_ref()
    }
    /// <p>The unique identifier for the application that the journey applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date, in ISO 8601 format, when the journey was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The unique identifier for the journey.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The messaging and entry limits for the journey.</p>
    pub fn limits(&self) -> std::option::Option<&crate::model::JourneyLimits> {
        self.limits.as_ref()
    }
    /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. If this value is true, the schedule uses each participant's local time.</p>
    pub fn local_time(&self) -> bool {
        self.local_time
    }
    /// <p>The name of the journey.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
    pub fn quiet_time(&self) -> std::option::Option<&crate::model::QuietTime> {
        self.quiet_time.as_ref()
    }
    /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
    pub fn refresh_frequency(&self) -> std::option::Option<&str> {
        self.refresh_frequency.as_deref()
    }
    /// <p>The schedule settings for the journey.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::JourneySchedule> {
        self.schedule.as_ref()
    }
    /// <p>The unique identifier for the first activity in the journey.</p>
    pub fn start_activity(&self) -> std::option::Option<&str> {
        self.start_activity.as_deref()
    }
    /// <p>The segment that defines which users are participants in the journey.</p>
    pub fn start_condition(&self) -> std::option::Option<&crate::model::StartCondition> {
        self.start_condition.as_ref()
    }
    /// <p>The current status of the journey. Possible values are:</p> <ul><li><p>DRAFT - The journey is being developed and hasn't been published yet.</p></li> <li><p>ACTIVE - The journey has been developed and published. Depending on the journey's schedule, the journey may currently be running or scheduled to start running at a later time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li> <li><p>COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.</p></li> <li><p>CANCELLED - The journey has been stopped. If a journey's status is CANCELLED, you can't add, change, or remove activities or segment settings from the journey.</p></li> <li><p>CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn't been specified for it. If a journey's status is CLOSED, you can't add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.</p></li></ul>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>This object is not used or supported.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
    pub fn wait_for_quiet_time(&self) -> bool {
        self.wait_for_quiet_time
    }
    /// <p>Specifies whether a journey should be refreshed on segment update.</p>
    pub fn refresh_on_segment_update(&self) -> bool {
        self.refresh_on_segment_update
    }
    /// <p>The channel-specific configurations for the journey.</p>
    pub fn journey_channel_settings(
        &self,
    ) -> std::option::Option<&crate::model::JourneyChannelSettings> {
        self.journey_channel_settings.as_ref()
    }
}
impl std::fmt::Debug for JourneyResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyResponse");
        formatter.field("activities", &self.activities);
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("id", &self.id);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("limits", &self.limits);
        formatter.field("local_time", &self.local_time);
        formatter.field("name", &self.name);
        formatter.field("quiet_time", &self.quiet_time);
        formatter.field("refresh_frequency", &self.refresh_frequency);
        formatter.field("schedule", &self.schedule);
        formatter.field("start_activity", &self.start_activity);
        formatter.field("start_condition", &self.start_condition);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("wait_for_quiet_time", &self.wait_for_quiet_time);
        formatter.field("refresh_on_segment_update", &self.refresh_on_segment_update);
        formatter.field("journey_channel_settings", &self.journey_channel_settings);
        formatter.finish()
    }
}
/// See [`JourneyResponse`](crate::model::JourneyResponse)
pub mod journey_response {
    /// A builder for [`JourneyResponse`](crate::model::JourneyResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activities: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Activity>,
        >,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) limits: std::option::Option<crate::model::JourneyLimits>,
        pub(crate) local_time: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) quiet_time: std::option::Option<crate::model::QuietTime>,
        pub(crate) refresh_frequency: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::JourneySchedule>,
        pub(crate) start_activity: std::option::Option<std::string::String>,
        pub(crate) start_condition: std::option::Option<crate::model::StartCondition>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) wait_for_quiet_time: std::option::Option<bool>,
        pub(crate) refresh_on_segment_update: std::option::Option<bool>,
        pub(crate) journey_channel_settings:
            std::option::Option<crate::model::JourneyChannelSettings>,
    }
    impl Builder {
        /// Adds a key-value pair to `activities`.
        ///
        /// To override the contents of this collection use [`set_activities`](Self::set_activities).
        ///
        /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.</p>
        pub fn activities(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Activity>,
        ) -> Self {
            let mut hash_map = self.activities.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.activities = Some(hash_map);
            self
        }
        /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.</p>
        pub fn set_activities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Activity>,
            >,
        ) -> Self {
            self.activities = input;
            self
        }
        /// <p>The unique identifier for the application that the journey applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the journey applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was created.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The messaging and entry limits for the journey.</p>
        pub fn limits(mut self, input: crate::model::JourneyLimits) -> Self {
            self.limits = Some(input);
            self
        }
        /// <p>The messaging and entry limits for the journey.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<crate::model::JourneyLimits>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. If this value is true, the schedule uses each participant's local time.</p>
        pub fn local_time(mut self, input: bool) -> Self {
            self.local_time = Some(input);
            self
        }
        /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. If this value is true, the schedule uses each participant's local time.</p>
        pub fn set_local_time(mut self, input: std::option::Option<bool>) -> Self {
            self.local_time = input;
            self
        }
        /// <p>The name of the journey.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the journey.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
        pub fn quiet_time(mut self, input: crate::model::QuietTime) -> Self {
            self.quiet_time = Some(input);
            self
        }
        /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
        pub fn set_quiet_time(
            mut self,
            input: std::option::Option<crate::model::QuietTime>,
        ) -> Self {
            self.quiet_time = input;
            self
        }
        /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
        pub fn refresh_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_frequency = Some(input.into());
            self
        }
        /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
        pub fn set_refresh_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_frequency = input;
            self
        }
        /// <p>The schedule settings for the journey.</p>
        pub fn schedule(mut self, input: crate::model::JourneySchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule settings for the journey.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::JourneySchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The unique identifier for the first activity in the journey.</p>
        pub fn start_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the first activity in the journey.</p>
        pub fn set_start_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_activity = input;
            self
        }
        /// <p>The segment that defines which users are participants in the journey.</p>
        pub fn start_condition(mut self, input: crate::model::StartCondition) -> Self {
            self.start_condition = Some(input);
            self
        }
        /// <p>The segment that defines which users are participants in the journey.</p>
        pub fn set_start_condition(
            mut self,
            input: std::option::Option<crate::model::StartCondition>,
        ) -> Self {
            self.start_condition = input;
            self
        }
        /// <p>The current status of the journey. Possible values are:</p> <ul><li><p>DRAFT - The journey is being developed and hasn't been published yet.</p></li> <li><p>ACTIVE - The journey has been developed and published. Depending on the journey's schedule, the journey may currently be running or scheduled to start running at a later time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li> <li><p>COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.</p></li> <li><p>CANCELLED - The journey has been stopped. If a journey's status is CANCELLED, you can't add, change, or remove activities or segment settings from the journey.</p></li> <li><p>CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn't been specified for it. If a journey's status is CLOSED, you can't add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.</p></li></ul>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current status of the journey. Possible values are:</p> <ul><li><p>DRAFT - The journey is being developed and hasn't been published yet.</p></li> <li><p>ACTIVE - The journey has been developed and published. Depending on the journey's schedule, the journey may currently be running or scheduled to start running at a later time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li> <li><p>COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.</p></li> <li><p>CANCELLED - The journey has been stopped. If a journey's status is CANCELLED, you can't add, change, or remove activities or segment settings from the journey.</p></li> <li><p>CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn't been specified for it. If a journey's status is CLOSED, you can't add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.</p></li></ul>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>This object is not used or supported.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>This object is not used or supported.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
        pub fn wait_for_quiet_time(mut self, input: bool) -> Self {
            self.wait_for_quiet_time = Some(input);
            self
        }
        /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
        pub fn set_wait_for_quiet_time(mut self, input: std::option::Option<bool>) -> Self {
            self.wait_for_quiet_time = input;
            self
        }
        /// <p>Specifies whether a journey should be refreshed on segment update.</p>
        pub fn refresh_on_segment_update(mut self, input: bool) -> Self {
            self.refresh_on_segment_update = Some(input);
            self
        }
        /// <p>Specifies whether a journey should be refreshed on segment update.</p>
        pub fn set_refresh_on_segment_update(mut self, input: std::option::Option<bool>) -> Self {
            self.refresh_on_segment_update = input;
            self
        }
        /// <p>The channel-specific configurations for the journey.</p>
        pub fn journey_channel_settings(
            mut self,
            input: crate::model::JourneyChannelSettings,
        ) -> Self {
            self.journey_channel_settings = Some(input);
            self
        }
        /// <p>The channel-specific configurations for the journey.</p>
        pub fn set_journey_channel_settings(
            mut self,
            input: std::option::Option<crate::model::JourneyChannelSettings>,
        ) -> Self {
            self.journey_channel_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyResponse`](crate::model::JourneyResponse)
        pub fn build(self) -> crate::model::JourneyResponse {
            crate::model::JourneyResponse {
                activities: self.activities,
                application_id: self.application_id,
                creation_date: self.creation_date,
                id: self.id,
                last_modified_date: self.last_modified_date,
                limits: self.limits,
                local_time: self.local_time.unwrap_or_default(),
                name: self.name,
                quiet_time: self.quiet_time,
                refresh_frequency: self.refresh_frequency,
                schedule: self.schedule,
                start_activity: self.start_activity,
                start_condition: self.start_condition,
                state: self.state,
                tags: self.tags,
                wait_for_quiet_time: self.wait_for_quiet_time.unwrap_or_default(),
                refresh_on_segment_update: self.refresh_on_segment_update.unwrap_or_default(),
                journey_channel_settings: self.journey_channel_settings,
            }
        }
    }
}
impl JourneyResponse {
    /// Creates a new builder-style object to manufacture [`JourneyResponse`](crate::model::JourneyResponse)
    pub fn builder() -> crate::model::journey_response::Builder {
        crate::model::journey_response::Builder::default()
    }
}

/// <p>The channel-specific configurations for the journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyChannelSettings {
    /// <p>Amazon Resource Name (ARN) of the Connect Campaign.</p>
    pub connect_campaign_arn: std::option::Option<std::string::String>,
    /// <p>IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.</p>
    pub connect_campaign_execution_role_arn: std::option::Option<std::string::String>,
}
impl JourneyChannelSettings {
    /// <p>Amazon Resource Name (ARN) of the Connect Campaign.</p>
    pub fn connect_campaign_arn(&self) -> std::option::Option<&str> {
        self.connect_campaign_arn.as_deref()
    }
    /// <p>IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.</p>
    pub fn connect_campaign_execution_role_arn(&self) -> std::option::Option<&str> {
        self.connect_campaign_execution_role_arn.as_deref()
    }
}
impl std::fmt::Debug for JourneyChannelSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyChannelSettings");
        formatter.field("connect_campaign_arn", &self.connect_campaign_arn);
        formatter.field(
            "connect_campaign_execution_role_arn",
            &self.connect_campaign_execution_role_arn,
        );
        formatter.finish()
    }
}
/// See [`JourneyChannelSettings`](crate::model::JourneyChannelSettings)
pub mod journey_channel_settings {
    /// A builder for [`JourneyChannelSettings`](crate::model::JourneyChannelSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connect_campaign_arn: std::option::Option<std::string::String>,
        pub(crate) connect_campaign_execution_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Connect Campaign.</p>
        pub fn connect_campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connect_campaign_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Connect Campaign.</p>
        pub fn set_connect_campaign_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_campaign_arn = input;
            self
        }
        /// <p>IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.</p>
        pub fn connect_campaign_execution_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.connect_campaign_execution_role_arn = Some(input.into());
            self
        }
        /// <p>IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.</p>
        pub fn set_connect_campaign_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connect_campaign_execution_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyChannelSettings`](crate::model::JourneyChannelSettings)
        pub fn build(self) -> crate::model::JourneyChannelSettings {
            crate::model::JourneyChannelSettings {
                connect_campaign_arn: self.connect_campaign_arn,
                connect_campaign_execution_role_arn: self.connect_campaign_execution_role_arn,
            }
        }
    }
}
impl JourneyChannelSettings {
    /// Creates a new builder-style object to manufacture [`JourneyChannelSettings`](crate::model::JourneyChannelSettings)
    pub fn builder() -> crate::model::journey_channel_settings::Builder {
        crate::model::journey_channel_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => State::Active,
            "CANCELLED" => State::Cancelled,
            "CLOSED" => State::Closed,
            "COMPLETED" => State::Completed,
            "DRAFT" => State::Draft,
            "PAUSED" => State::Paused,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Active => "ACTIVE",
            State::Cancelled => "CANCELLED",
            State::Closed => "CLOSED",
            State::Completed => "COMPLETED",
            State::Draft => "DRAFT",
            State::Paused => "PAUSED",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CANCELLED",
            "CLOSED",
            "COMPLETED",
            "DRAFT",
            "PAUSED",
        ]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the conditions for the first activity in a journey. This activity and its conditions determine which users are participants in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCondition {
    /// <p>The custom description of the condition.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the settings for an event that causes a journey activity to start.</p>
    pub event_start_condition: std::option::Option<crate::model::EventStartCondition>,
    /// <p>The segment that's associated with the first activity in the journey. This segment determines which users are participants in the journey.</p>
    pub segment_start_condition: std::option::Option<crate::model::SegmentCondition>,
}
impl StartCondition {
    /// <p>The custom description of the condition.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the settings for an event that causes a journey activity to start.</p>
    pub fn event_start_condition(&self) -> std::option::Option<&crate::model::EventStartCondition> {
        self.event_start_condition.as_ref()
    }
    /// <p>The segment that's associated with the first activity in the journey. This segment determines which users are participants in the journey.</p>
    pub fn segment_start_condition(&self) -> std::option::Option<&crate::model::SegmentCondition> {
        self.segment_start_condition.as_ref()
    }
}
impl std::fmt::Debug for StartCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCondition");
        formatter.field("description", &self.description);
        formatter.field("event_start_condition", &self.event_start_condition);
        formatter.field("segment_start_condition", &self.segment_start_condition);
        formatter.finish()
    }
}
/// See [`StartCondition`](crate::model::StartCondition)
pub mod start_condition {
    /// A builder for [`StartCondition`](crate::model::StartCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_start_condition: std::option::Option<crate::model::EventStartCondition>,
        pub(crate) segment_start_condition: std::option::Option<crate::model::SegmentCondition>,
    }
    impl Builder {
        /// <p>The custom description of the condition.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The custom description of the condition.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the settings for an event that causes a journey activity to start.</p>
        pub fn event_start_condition(mut self, input: crate::model::EventStartCondition) -> Self {
            self.event_start_condition = Some(input);
            self
        }
        /// <p>Specifies the settings for an event that causes a journey activity to start.</p>
        pub fn set_event_start_condition(
            mut self,
            input: std::option::Option<crate::model::EventStartCondition>,
        ) -> Self {
            self.event_start_condition = input;
            self
        }
        /// <p>The segment that's associated with the first activity in the journey. This segment determines which users are participants in the journey.</p>
        pub fn segment_start_condition(mut self, input: crate::model::SegmentCondition) -> Self {
            self.segment_start_condition = Some(input);
            self
        }
        /// <p>The segment that's associated with the first activity in the journey. This segment determines which users are participants in the journey.</p>
        pub fn set_segment_start_condition(
            mut self,
            input: std::option::Option<crate::model::SegmentCondition>,
        ) -> Self {
            self.segment_start_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`StartCondition`](crate::model::StartCondition)
        pub fn build(self) -> crate::model::StartCondition {
            crate::model::StartCondition {
                description: self.description,
                event_start_condition: self.event_start_condition,
                segment_start_condition: self.segment_start_condition,
            }
        }
    }
}
impl StartCondition {
    /// Creates a new builder-style object to manufacture [`StartCondition`](crate::model::StartCondition)
    pub fn builder() -> crate::model::start_condition::Builder {
        crate::model::start_condition::Builder::default()
    }
}

/// <p>Specifies a segment to associate with an activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentCondition {
    /// <p>The unique identifier for the segment to associate with the activity.</p>
    pub segment_id: std::option::Option<std::string::String>,
}
impl SegmentCondition {
    /// <p>The unique identifier for the segment to associate with the activity.</p>
    pub fn segment_id(&self) -> std::option::Option<&str> {
        self.segment_id.as_deref()
    }
}
impl std::fmt::Debug for SegmentCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentCondition");
        formatter.field("segment_id", &self.segment_id);
        formatter.finish()
    }
}
/// See [`SegmentCondition`](crate::model::SegmentCondition)
pub mod segment_condition {
    /// A builder for [`SegmentCondition`](crate::model::SegmentCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) segment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the segment to associate with the activity.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment to associate with the activity.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentCondition`](crate::model::SegmentCondition)
        pub fn build(self) -> crate::model::SegmentCondition {
            crate::model::SegmentCondition {
                segment_id: self.segment_id,
            }
        }
    }
}
impl SegmentCondition {
    /// Creates a new builder-style object to manufacture [`SegmentCondition`](crate::model::SegmentCondition)
    pub fn builder() -> crate::model::segment_condition::Builder {
        crate::model::segment_condition::Builder::default()
    }
}

/// <p>Specifies the settings for an event that causes a journey activity to start.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventStartCondition {
    /// <p>Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.</p>
    pub event_filter: std::option::Option<crate::model::EventFilter>,
    #[allow(missing_docs)] // documentation missing in model
    pub segment_id: std::option::Option<std::string::String>,
}
impl EventStartCondition {
    /// <p>Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.</p>
    pub fn event_filter(&self) -> std::option::Option<&crate::model::EventFilter> {
        self.event_filter.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn segment_id(&self) -> std::option::Option<&str> {
        self.segment_id.as_deref()
    }
}
impl std::fmt::Debug for EventStartCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventStartCondition");
        formatter.field("event_filter", &self.event_filter);
        formatter.field("segment_id", &self.segment_id);
        formatter.finish()
    }
}
/// See [`EventStartCondition`](crate::model::EventStartCondition)
pub mod event_start_condition {
    /// A builder for [`EventStartCondition`](crate::model::EventStartCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_filter: std::option::Option<crate::model::EventFilter>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.</p>
        pub fn event_filter(mut self, input: crate::model::EventFilter) -> Self {
            self.event_filter = Some(input);
            self
        }
        /// <p>Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.</p>
        pub fn set_event_filter(
            mut self,
            input: std::option::Option<crate::model::EventFilter>,
        ) -> Self {
            self.event_filter = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EventStartCondition`](crate::model::EventStartCondition)
        pub fn build(self) -> crate::model::EventStartCondition {
            crate::model::EventStartCondition {
                event_filter: self.event_filter,
                segment_id: self.segment_id,
            }
        }
    }
}
impl EventStartCondition {
    /// Creates a new builder-style object to manufacture [`EventStartCondition`](crate::model::EventStartCondition)
    pub fn builder() -> crate::model::event_start_condition::Builder {
        crate::model::event_start_condition::Builder::default()
    }
}

/// <p>Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventFilter {
    /// <p>The dimensions for the event filter to use for the campaign or the journey activity.</p>
    pub dimensions: std::option::Option<crate::model::EventDimensions>,
    /// <p>The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link  linkend="apps-application-id-events">Events resource</link>) occurs.</p>
    pub filter_type: std::option::Option<crate::model::FilterType>,
}
impl EventFilter {
    /// <p>The dimensions for the event filter to use for the campaign or the journey activity.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::EventDimensions> {
        self.dimensions.as_ref()
    }
    /// <p>The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link  linkend="apps-application-id-events">Events resource</link>) occurs.</p>
    pub fn filter_type(&self) -> std::option::Option<&crate::model::FilterType> {
        self.filter_type.as_ref()
    }
}
impl std::fmt::Debug for EventFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventFilter");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("filter_type", &self.filter_type);
        formatter.finish()
    }
}
/// See [`EventFilter`](crate::model::EventFilter)
pub mod event_filter {
    /// A builder for [`EventFilter`](crate::model::EventFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<crate::model::EventDimensions>,
        pub(crate) filter_type: std::option::Option<crate::model::FilterType>,
    }
    impl Builder {
        /// <p>The dimensions for the event filter to use for the campaign or the journey activity.</p>
        pub fn dimensions(mut self, input: crate::model::EventDimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The dimensions for the event filter to use for the campaign or the journey activity.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::EventDimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link  linkend="apps-application-id-events">Events resource</link>) occurs.</p>
        pub fn filter_type(mut self, input: crate::model::FilterType) -> Self {
            self.filter_type = Some(input);
            self
        }
        /// <p>The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link  linkend="apps-application-id-events">Events resource</link>) occurs.</p>
        pub fn set_filter_type(
            mut self,
            input: std::option::Option<crate::model::FilterType>,
        ) -> Self {
            self.filter_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EventFilter`](crate::model::EventFilter)
        pub fn build(self) -> crate::model::EventFilter {
            crate::model::EventFilter {
                dimensions: self.dimensions,
                filter_type: self.filter_type,
            }
        }
    }
}
impl EventFilter {
    /// Creates a new builder-style object to manufacture [`EventFilter`](crate::model::EventFilter)
    pub fn builder() -> crate::model::event_filter::Builder {
        crate::model::event_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterType {
    #[allow(missing_docs)] // documentation missing in model
    Endpoint,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterType {
    fn from(s: &str) -> Self {
        match s {
            "ENDPOINT" => FilterType::Endpoint,
            "SYSTEM" => FilterType::System,
            other => FilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterType::from(s))
    }
}
impl FilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterType::Endpoint => "ENDPOINT",
            FilterType::System => "SYSTEM",
            FilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENDPOINT", "SYSTEM"]
    }
}
impl AsRef<str> for FilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the dimensions for an event filter that determines when a campaign is sent or a journey activity is performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDimensions {
    /// <p>One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
    >,
    /// <p>The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
    pub event_type: std::option::Option<crate::model::SetDimension>,
    /// <p>One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.</p>
    pub metrics: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
    >,
}
impl EventDimensions {
    /// <p>One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::SetDimension> {
        self.event_type.as_ref()
    }
    /// <p>One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.</p>
    pub fn metrics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
    > {
        self.metrics.as_ref()
    }
}
impl std::fmt::Debug for EventDimensions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDimensions");
        formatter.field("attributes", &self.attributes);
        formatter.field("event_type", &self.event_type);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}
/// See [`EventDimensions`](crate::model::EventDimensions)
pub mod event_dimensions {
    /// A builder for [`EventDimensions`](crate::model::EventDimensions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
        >,
        pub(crate) event_type: std::option::Option<crate::model::SetDimension>,
        pub(crate) metrics: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeDimension>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeDimension>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
        pub fn event_type(mut self, input: crate::model::SetDimension) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::SetDimension>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// Adds a key-value pair to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.</p>
        pub fn metrics(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MetricDimension>,
        ) -> Self {
            let mut hash_map = self.metrics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metrics = Some(hash_map);
            self
        }
        /// <p>One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetricDimension>,
            >,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDimensions`](crate::model::EventDimensions)
        pub fn build(self) -> crate::model::EventDimensions {
            crate::model::EventDimensions {
                attributes: self.attributes,
                event_type: self.event_type,
                metrics: self.metrics,
            }
        }
    }
}
impl EventDimensions {
    /// Creates a new builder-style object to manufacture [`EventDimensions`](crate::model::EventDimensions)
    pub fn builder() -> crate::model::event_dimensions::Builder {
        crate::model::event_dimensions::Builder::default()
    }
}

/// <p>Specifies the schedule settings for a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneySchedule {
    /// <p>The scheduled time, in ISO 8601 format, when the journey ended or will end.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The scheduled time, in ISO 8601 format, when the journey began or will begin.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is true. Valid values are: UTC,
    /// UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
    /// UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30,
    /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02,
    /// UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09,
    /// UTC-09:30, UTC-10, and UTC-11.</p>
    pub timezone: std::option::Option<std::string::String>,
}
impl JourneySchedule {
    /// <p>The scheduled time, in ISO 8601 format, when the journey ended or will end.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The scheduled time, in ISO 8601 format, when the journey began or will begin.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is true. Valid values are: UTC,
    /// UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
    /// UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30,
    /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02,
    /// UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09,
    /// UTC-09:30, UTC-10, and UTC-11.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
}
impl std::fmt::Debug for JourneySchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneySchedule");
        formatter.field("end_time", &self.end_time);
        formatter.field("start_time", &self.start_time);
        formatter.field("timezone", &self.timezone);
        formatter.finish()
    }
}
/// See [`JourneySchedule`](crate::model::JourneySchedule)
pub mod journey_schedule {
    /// A builder for [`JourneySchedule`](crate::model::JourneySchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The scheduled time, in ISO 8601 format, when the journey ended or will end.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The scheduled time, in ISO 8601 format, when the journey ended or will end.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The scheduled time, in ISO 8601 format, when the journey began or will begin.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The scheduled time, in ISO 8601 format, when the journey began or will begin.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is true. Valid values are: UTC,
        /// UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
        /// UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30,
        /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02,
        /// UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09,
        /// UTC-09:30, UTC-10, and UTC-11.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The starting UTC offset for the journey schedule, if the value of the journey's LocalTime property is true. Valid values are: UTC,
        /// UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
        /// UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30,
        /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02,
        /// UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09,
        /// UTC-09:30, UTC-10, and UTC-11.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneySchedule`](crate::model::JourneySchedule)
        pub fn build(self) -> crate::model::JourneySchedule {
            crate::model::JourneySchedule {
                end_time: self.end_time,
                start_time: self.start_time,
                timezone: self.timezone,
            }
        }
    }
}
impl JourneySchedule {
    /// Creates a new builder-style object to manufacture [`JourneySchedule`](crate::model::JourneySchedule)
    pub fn builder() -> crate::model::journey_schedule::Builder {
        crate::model::journey_schedule::Builder::default()
    }
}

/// <p>Specifies the start and end times that define a time range when messages aren't sent to endpoints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuietTime {
    /// <p>The specific time when quiet time ends. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
    pub end: std::option::Option<std::string::String>,
    /// <p>The specific time when quiet time begins. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
    pub start: std::option::Option<std::string::String>,
}
impl QuietTime {
    /// <p>The specific time when quiet time ends. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
    pub fn end(&self) -> std::option::Option<&str> {
        self.end.as_deref()
    }
    /// <p>The specific time when quiet time begins. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
    pub fn start(&self) -> std::option::Option<&str> {
        self.start.as_deref()
    }
}
impl std::fmt::Debug for QuietTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuietTime");
        formatter.field("end", &self.end);
        formatter.field("start", &self.start);
        formatter.finish()
    }
}
/// See [`QuietTime`](crate::model::QuietTime)
pub mod quiet_time {
    /// A builder for [`QuietTime`](crate::model::QuietTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) start: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specific time when quiet time ends. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// <p>The specific time when quiet time ends. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// <p>The specific time when quiet time begins. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// <p>The specific time when quiet time begins. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Consumes the builder and constructs a [`QuietTime`](crate::model::QuietTime)
        pub fn build(self) -> crate::model::QuietTime {
            crate::model::QuietTime {
                end: self.end,
                start: self.start,
            }
        }
    }
}
impl QuietTime {
    /// Creates a new builder-style object to manufacture [`QuietTime`](crate::model::QuietTime)
    pub fn builder() -> crate::model::quiet_time::Builder {
        crate::model::quiet_time::Builder::default()
    }
}

/// <p>Specifies limits on the messages that a journey can send and the number of times participants can enter a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyLimits {
    /// <p>The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.</p>
    pub daily_cap: i32,
    /// <p>The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.</p>
    pub endpoint_reentry_cap: i32,
    /// <p>The maximum number of messages that the journey can send each second.</p>
    pub messages_per_second: i32,
    /// <p>Minimum time that must pass before an endpoint can re-enter a given journey. The duration should use an ISO 8601 format, such as PT1H. </p>
    pub endpoint_reentry_interval: std::option::Option<std::string::String>,
}
impl JourneyLimits {
    /// <p>The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.</p>
    pub fn daily_cap(&self) -> i32 {
        self.daily_cap
    }
    /// <p>The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.</p>
    pub fn endpoint_reentry_cap(&self) -> i32 {
        self.endpoint_reentry_cap
    }
    /// <p>The maximum number of messages that the journey can send each second.</p>
    pub fn messages_per_second(&self) -> i32 {
        self.messages_per_second
    }
    /// <p>Minimum time that must pass before an endpoint can re-enter a given journey. The duration should use an ISO 8601 format, such as PT1H. </p>
    pub fn endpoint_reentry_interval(&self) -> std::option::Option<&str> {
        self.endpoint_reentry_interval.as_deref()
    }
}
impl std::fmt::Debug for JourneyLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyLimits");
        formatter.field("daily_cap", &self.daily_cap);
        formatter.field("endpoint_reentry_cap", &self.endpoint_reentry_cap);
        formatter.field("messages_per_second", &self.messages_per_second);
        formatter.field("endpoint_reentry_interval", &self.endpoint_reentry_interval);
        formatter.finish()
    }
}
/// See [`JourneyLimits`](crate::model::JourneyLimits)
pub mod journey_limits {
    /// A builder for [`JourneyLimits`](crate::model::JourneyLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) daily_cap: std::option::Option<i32>,
        pub(crate) endpoint_reentry_cap: std::option::Option<i32>,
        pub(crate) messages_per_second: std::option::Option<i32>,
        pub(crate) endpoint_reentry_interval: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.</p>
        pub fn daily_cap(mut self, input: i32) -> Self {
            self.daily_cap = Some(input);
            self
        }
        /// <p>The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.</p>
        pub fn set_daily_cap(mut self, input: std::option::Option<i32>) -> Self {
            self.daily_cap = input;
            self
        }
        /// <p>The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.</p>
        pub fn endpoint_reentry_cap(mut self, input: i32) -> Self {
            self.endpoint_reentry_cap = Some(input);
            self
        }
        /// <p>The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.</p>
        pub fn set_endpoint_reentry_cap(mut self, input: std::option::Option<i32>) -> Self {
            self.endpoint_reentry_cap = input;
            self
        }
        /// <p>The maximum number of messages that the journey can send each second.</p>
        pub fn messages_per_second(mut self, input: i32) -> Self {
            self.messages_per_second = Some(input);
            self
        }
        /// <p>The maximum number of messages that the journey can send each second.</p>
        pub fn set_messages_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.messages_per_second = input;
            self
        }
        /// <p>Minimum time that must pass before an endpoint can re-enter a given journey. The duration should use an ISO 8601 format, such as PT1H. </p>
        pub fn endpoint_reentry_interval(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_reentry_interval = Some(input.into());
            self
        }
        /// <p>Minimum time that must pass before an endpoint can re-enter a given journey. The duration should use an ISO 8601 format, such as PT1H. </p>
        pub fn set_endpoint_reentry_interval(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_reentry_interval = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyLimits`](crate::model::JourneyLimits)
        pub fn build(self) -> crate::model::JourneyLimits {
            crate::model::JourneyLimits {
                daily_cap: self.daily_cap.unwrap_or_default(),
                endpoint_reentry_cap: self.endpoint_reentry_cap.unwrap_or_default(),
                messages_per_second: self.messages_per_second.unwrap_or_default(),
                endpoint_reentry_interval: self.endpoint_reentry_interval,
            }
        }
    }
}
impl JourneyLimits {
    /// Creates a new builder-style object to manufacture [`JourneyLimits`](crate::model::JourneyLimits)
    pub fn builder() -> crate::model::journey_limits::Builder {
        crate::model::journey_limits::Builder::default()
    }
}

/// <p>Specifies the configuration and other settings for an activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Activity {
    /// <p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>
    pub custom: std::option::Option<crate::model::CustomMessageActivity>,
    /// <p>The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p>
    pub conditional_split: std::option::Option<crate::model::ConditionalSplitActivity>,
    /// <p>The custom description of the activity.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The settings for an email activity. This type of activity sends an email message to participants.</p>
    pub email: std::option::Option<crate::model::EmailMessageActivity>,
    /// <p>The settings for a holdout activity. This type of activity stops a journey for a specified percentage of participants.</p>
    pub holdout: std::option::Option<crate::model::HoldoutActivity>,
    /// <p>The settings for a multivariate split activity. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p>
    pub multi_condition: std::option::Option<crate::model::MultiConditionalSplitActivity>,
    /// <p>The settings for a push notification activity. This type of activity sends a push notification to participants.</p>
    pub push: std::option::Option<crate::model::PushMessageActivity>,
    /// <p>The settings for a random split activity. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>
    pub random_split: std::option::Option<crate::model::RandomSplitActivity>,
    /// <p>The settings for an SMS activity. This type of activity sends a text message to participants.</p>
    pub sms: std::option::Option<crate::model::SmsMessageActivity>,
    /// <p>The settings for a wait activity. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>
    pub wait: std::option::Option<crate::model::WaitActivity>,
    /// <p>The settings for a connect activity. This type of activity initiates a contact center call to participants.</p>
    pub contact_center: std::option::Option<crate::model::ContactCenterActivity>,
}
impl Activity {
    /// <p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>
    pub fn custom(&self) -> std::option::Option<&crate::model::CustomMessageActivity> {
        self.custom.as_ref()
    }
    /// <p>The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p>
    pub fn conditional_split(
        &self,
    ) -> std::option::Option<&crate::model::ConditionalSplitActivity> {
        self.conditional_split.as_ref()
    }
    /// <p>The custom description of the activity.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The settings for an email activity. This type of activity sends an email message to participants.</p>
    pub fn email(&self) -> std::option::Option<&crate::model::EmailMessageActivity> {
        self.email.as_ref()
    }
    /// <p>The settings for a holdout activity. This type of activity stops a journey for a specified percentage of participants.</p>
    pub fn holdout(&self) -> std::option::Option<&crate::model::HoldoutActivity> {
        self.holdout.as_ref()
    }
    /// <p>The settings for a multivariate split activity. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p>
    pub fn multi_condition(
        &self,
    ) -> std::option::Option<&crate::model::MultiConditionalSplitActivity> {
        self.multi_condition.as_ref()
    }
    /// <p>The settings for a push notification activity. This type of activity sends a push notification to participants.</p>
    pub fn push(&self) -> std::option::Option<&crate::model::PushMessageActivity> {
        self.push.as_ref()
    }
    /// <p>The settings for a random split activity. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>
    pub fn random_split(&self) -> std::option::Option<&crate::model::RandomSplitActivity> {
        self.random_split.as_ref()
    }
    /// <p>The settings for an SMS activity. This type of activity sends a text message to participants.</p>
    pub fn sms(&self) -> std::option::Option<&crate::model::SmsMessageActivity> {
        self.sms.as_ref()
    }
    /// <p>The settings for a wait activity. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>
    pub fn wait(&self) -> std::option::Option<&crate::model::WaitActivity> {
        self.wait.as_ref()
    }
    /// <p>The settings for a connect activity. This type of activity initiates a contact center call to participants.</p>
    pub fn contact_center(&self) -> std::option::Option<&crate::model::ContactCenterActivity> {
        self.contact_center.as_ref()
    }
}
impl std::fmt::Debug for Activity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Activity");
        formatter.field("custom", &self.custom);
        formatter.field("conditional_split", &self.conditional_split);
        formatter.field("description", &self.description);
        formatter.field("email", &self.email);
        formatter.field("holdout", &self.holdout);
        formatter.field("multi_condition", &self.multi_condition);
        formatter.field("push", &self.push);
        formatter.field("random_split", &self.random_split);
        formatter.field("sms", &self.sms);
        formatter.field("wait", &self.wait);
        formatter.field("contact_center", &self.contact_center);
        formatter.finish()
    }
}
/// See [`Activity`](crate::model::Activity)
pub mod activity {
    /// A builder for [`Activity`](crate::model::Activity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom: std::option::Option<crate::model::CustomMessageActivity>,
        pub(crate) conditional_split: std::option::Option<crate::model::ConditionalSplitActivity>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<crate::model::EmailMessageActivity>,
        pub(crate) holdout: std::option::Option<crate::model::HoldoutActivity>,
        pub(crate) multi_condition:
            std::option::Option<crate::model::MultiConditionalSplitActivity>,
        pub(crate) push: std::option::Option<crate::model::PushMessageActivity>,
        pub(crate) random_split: std::option::Option<crate::model::RandomSplitActivity>,
        pub(crate) sms: std::option::Option<crate::model::SmsMessageActivity>,
        pub(crate) wait: std::option::Option<crate::model::WaitActivity>,
        pub(crate) contact_center: std::option::Option<crate::model::ContactCenterActivity>,
    }
    impl Builder {
        /// <p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>
        pub fn custom(mut self, input: crate::model::CustomMessageActivity) -> Self {
            self.custom = Some(input);
            self
        }
        /// <p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>
        pub fn set_custom(
            mut self,
            input: std::option::Option<crate::model::CustomMessageActivity>,
        ) -> Self {
            self.custom = input;
            self
        }
        /// <p>The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p>
        pub fn conditional_split(mut self, input: crate::model::ConditionalSplitActivity) -> Self {
            self.conditional_split = Some(input);
            self
        }
        /// <p>The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p>
        pub fn set_conditional_split(
            mut self,
            input: std::option::Option<crate::model::ConditionalSplitActivity>,
        ) -> Self {
            self.conditional_split = input;
            self
        }
        /// <p>The custom description of the activity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The custom description of the activity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The settings for an email activity. This type of activity sends an email message to participants.</p>
        pub fn email(mut self, input: crate::model::EmailMessageActivity) -> Self {
            self.email = Some(input);
            self
        }
        /// <p>The settings for an email activity. This type of activity sends an email message to participants.</p>
        pub fn set_email(
            mut self,
            input: std::option::Option<crate::model::EmailMessageActivity>,
        ) -> Self {
            self.email = input;
            self
        }
        /// <p>The settings for a holdout activity. This type of activity stops a journey for a specified percentage of participants.</p>
        pub fn holdout(mut self, input: crate::model::HoldoutActivity) -> Self {
            self.holdout = Some(input);
            self
        }
        /// <p>The settings for a holdout activity. This type of activity stops a journey for a specified percentage of participants.</p>
        pub fn set_holdout(
            mut self,
            input: std::option::Option<crate::model::HoldoutActivity>,
        ) -> Self {
            self.holdout = input;
            self
        }
        /// <p>The settings for a multivariate split activity. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p>
        pub fn multi_condition(
            mut self,
            input: crate::model::MultiConditionalSplitActivity,
        ) -> Self {
            self.multi_condition = Some(input);
            self
        }
        /// <p>The settings for a multivariate split activity. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p>
        pub fn set_multi_condition(
            mut self,
            input: std::option::Option<crate::model::MultiConditionalSplitActivity>,
        ) -> Self {
            self.multi_condition = input;
            self
        }
        /// <p>The settings for a push notification activity. This type of activity sends a push notification to participants.</p>
        pub fn push(mut self, input: crate::model::PushMessageActivity) -> Self {
            self.push = Some(input);
            self
        }
        /// <p>The settings for a push notification activity. This type of activity sends a push notification to participants.</p>
        pub fn set_push(
            mut self,
            input: std::option::Option<crate::model::PushMessageActivity>,
        ) -> Self {
            self.push = input;
            self
        }
        /// <p>The settings for a random split activity. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>
        pub fn random_split(mut self, input: crate::model::RandomSplitActivity) -> Self {
            self.random_split = Some(input);
            self
        }
        /// <p>The settings for a random split activity. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>
        pub fn set_random_split(
            mut self,
            input: std::option::Option<crate::model::RandomSplitActivity>,
        ) -> Self {
            self.random_split = input;
            self
        }
        /// <p>The settings for an SMS activity. This type of activity sends a text message to participants.</p>
        pub fn sms(mut self, input: crate::model::SmsMessageActivity) -> Self {
            self.sms = Some(input);
            self
        }
        /// <p>The settings for an SMS activity. This type of activity sends a text message to participants.</p>
        pub fn set_sms(
            mut self,
            input: std::option::Option<crate::model::SmsMessageActivity>,
        ) -> Self {
            self.sms = input;
            self
        }
        /// <p>The settings for a wait activity. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>
        pub fn wait(mut self, input: crate::model::WaitActivity) -> Self {
            self.wait = Some(input);
            self
        }
        /// <p>The settings for a wait activity. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>
        pub fn set_wait(mut self, input: std::option::Option<crate::model::WaitActivity>) -> Self {
            self.wait = input;
            self
        }
        /// <p>The settings for a connect activity. This type of activity initiates a contact center call to participants.</p>
        pub fn contact_center(mut self, input: crate::model::ContactCenterActivity) -> Self {
            self.contact_center = Some(input);
            self
        }
        /// <p>The settings for a connect activity. This type of activity initiates a contact center call to participants.</p>
        pub fn set_contact_center(
            mut self,
            input: std::option::Option<crate::model::ContactCenterActivity>,
        ) -> Self {
            self.contact_center = input;
            self
        }
        /// Consumes the builder and constructs a [`Activity`](crate::model::Activity)
        pub fn build(self) -> crate::model::Activity {
            crate::model::Activity {
                custom: self.custom,
                conditional_split: self.conditional_split,
                description: self.description,
                email: self.email,
                holdout: self.holdout,
                multi_condition: self.multi_condition,
                push: self.push,
                random_split: self.random_split,
                sms: self.sms,
                wait: self.wait,
                contact_center: self.contact_center,
            }
        }
    }
}
impl Activity {
    /// Creates a new builder-style object to manufacture [`Activity`](crate::model::Activity)
    pub fn builder() -> crate::model::activity::Builder {
        crate::model::activity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactCenterActivity {
    /// <p>The unique identifier for the next activity to perform after the this activity.</p>
    pub next_activity: std::option::Option<std::string::String>,
}
impl ContactCenterActivity {
    /// <p>The unique identifier for the next activity to perform after the this activity.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
}
impl std::fmt::Debug for ContactCenterActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactCenterActivity");
        formatter.field("next_activity", &self.next_activity);
        formatter.finish()
    }
}
/// See [`ContactCenterActivity`](crate::model::ContactCenterActivity)
pub mod contact_center_activity {
    /// A builder for [`ContactCenterActivity`](crate::model::ContactCenterActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_activity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the next activity to perform after the this activity.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform after the this activity.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactCenterActivity`](crate::model::ContactCenterActivity)
        pub fn build(self) -> crate::model::ContactCenterActivity {
            crate::model::ContactCenterActivity {
                next_activity: self.next_activity,
            }
        }
    }
}
impl ContactCenterActivity {
    /// Creates a new builder-style object to manufacture [`ContactCenterActivity`](crate::model::ContactCenterActivity)
    pub fn builder() -> crate::model::contact_center_activity::Builder {
        crate::model::contact_center_activity::Builder::default()
    }
}

/// <p>Specifies the settings for a wait activity in a journey. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WaitActivity {
    /// <p>The unique identifier for the next activity to perform, after performing the wait activity.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The amount of time to wait or the date and time when the activity moves participants to the next activity in the journey.</p>
    pub wait_time: std::option::Option<crate::model::WaitTime>,
}
impl WaitActivity {
    /// <p>The unique identifier for the next activity to perform, after performing the wait activity.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The amount of time to wait or the date and time when the activity moves participants to the next activity in the journey.</p>
    pub fn wait_time(&self) -> std::option::Option<&crate::model::WaitTime> {
        self.wait_time.as_ref()
    }
}
impl std::fmt::Debug for WaitActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WaitActivity");
        formatter.field("next_activity", &self.next_activity);
        formatter.field("wait_time", &self.wait_time);
        formatter.finish()
    }
}
/// See [`WaitActivity`](crate::model::WaitActivity)
pub mod wait_activity {
    /// A builder for [`WaitActivity`](crate::model::WaitActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) wait_time: std::option::Option<crate::model::WaitTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the next activity to perform, after performing the wait activity.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after performing the wait activity.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The amount of time to wait or the date and time when the activity moves participants to the next activity in the journey.</p>
        pub fn wait_time(mut self, input: crate::model::WaitTime) -> Self {
            self.wait_time = Some(input);
            self
        }
        /// <p>The amount of time to wait or the date and time when the activity moves participants to the next activity in the journey.</p>
        pub fn set_wait_time(mut self, input: std::option::Option<crate::model::WaitTime>) -> Self {
            self.wait_time = input;
            self
        }
        /// Consumes the builder and constructs a [`WaitActivity`](crate::model::WaitActivity)
        pub fn build(self) -> crate::model::WaitActivity {
            crate::model::WaitActivity {
                next_activity: self.next_activity,
                wait_time: self.wait_time,
            }
        }
    }
}
impl WaitActivity {
    /// Creates a new builder-style object to manufacture [`WaitActivity`](crate::model::WaitActivity)
    pub fn builder() -> crate::model::wait_activity::Builder {
        crate::model::wait_activity::Builder::default()
    }
}

/// <p>Specifies a duration or a date and time that indicates when Amazon Pinpoint determines whether an activity's conditions have been met or an activity moves participants to the next activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WaitTime {
    /// <p>The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's conditions have been met or moving participants to the next activity in the journey.</p>
    pub wait_for: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions have been met or the activity moves participants to the next activity in the journey.</p>
    pub wait_until: std::option::Option<std::string::String>,
}
impl WaitTime {
    /// <p>The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's conditions have been met or moving participants to the next activity in the journey.</p>
    pub fn wait_for(&self) -> std::option::Option<&str> {
        self.wait_for.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions have been met or the activity moves participants to the next activity in the journey.</p>
    pub fn wait_until(&self) -> std::option::Option<&str> {
        self.wait_until.as_deref()
    }
}
impl std::fmt::Debug for WaitTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WaitTime");
        formatter.field("wait_for", &self.wait_for);
        formatter.field("wait_until", &self.wait_until);
        formatter.finish()
    }
}
/// See [`WaitTime`](crate::model::WaitTime)
pub mod wait_time {
    /// A builder for [`WaitTime`](crate::model::WaitTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) wait_for: std::option::Option<std::string::String>,
        pub(crate) wait_until: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's conditions have been met or moving participants to the next activity in the journey.</p>
        pub fn wait_for(mut self, input: impl Into<std::string::String>) -> Self {
            self.wait_for = Some(input.into());
            self
        }
        /// <p>The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's conditions have been met or moving participants to the next activity in the journey.</p>
        pub fn set_wait_for(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.wait_for = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions have been met or the activity moves participants to the next activity in the journey.</p>
        pub fn wait_until(mut self, input: impl Into<std::string::String>) -> Self {
            self.wait_until = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions have been met or the activity moves participants to the next activity in the journey.</p>
        pub fn set_wait_until(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.wait_until = input;
            self
        }
        /// Consumes the builder and constructs a [`WaitTime`](crate::model::WaitTime)
        pub fn build(self) -> crate::model::WaitTime {
            crate::model::WaitTime {
                wait_for: self.wait_for,
                wait_until: self.wait_until,
            }
        }
    }
}
impl WaitTime {
    /// Creates a new builder-style object to manufacture [`WaitTime`](crate::model::WaitTime)
    pub fn builder() -> crate::model::wait_time::Builder {
        crate::model::wait_time::Builder::default()
    }
}

/// <p>Specifies the settings for an SMS activity in a journey. This type of activity sends a text message to participants.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsMessageActivity {
    /// <p>Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.</p>
    pub message_config: std::option::Option<crate::model::JourneySmsMessage>,
    /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub template_version: std::option::Option<std::string::String>,
}
impl SmsMessageActivity {
    /// <p>Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.</p>
    pub fn message_config(&self) -> std::option::Option<&crate::model::JourneySmsMessage> {
        self.message_config.as_ref()
    }
    /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub fn template_version(&self) -> std::option::Option<&str> {
        self.template_version.as_deref()
    }
}
impl std::fmt::Debug for SmsMessageActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsMessageActivity");
        formatter.field("message_config", &self.message_config);
        formatter.field("next_activity", &self.next_activity);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_version", &self.template_version);
        formatter.finish()
    }
}
/// See [`SmsMessageActivity`](crate::model::SmsMessageActivity)
pub mod sms_message_activity {
    /// A builder for [`SmsMessageActivity`](crate::model::SmsMessageActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_config: std::option::Option<crate::model::JourneySmsMessage>,
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.</p>
        pub fn message_config(mut self, input: crate::model::JourneySmsMessage) -> Self {
            self.message_config = Some(input);
            self
        }
        /// <p>Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.</p>
        pub fn set_message_config(
            mut self,
            input: std::option::Option<crate::model::JourneySmsMessage>,
        ) -> Self {
            self.message_config = input;
            self
        }
        /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsMessageActivity`](crate::model::SmsMessageActivity)
        pub fn build(self) -> crate::model::SmsMessageActivity {
            crate::model::SmsMessageActivity {
                message_config: self.message_config,
                next_activity: self.next_activity,
                template_name: self.template_name,
                template_version: self.template_version,
            }
        }
    }
}
impl SmsMessageActivity {
    /// Creates a new builder-style object to manufacture [`SmsMessageActivity`](crate::model::SmsMessageActivity)
    pub fn builder() -> crate::model::sms_message_activity::Builder {
        crate::model::sms_message_activity::Builder::default()
    }
}

/// <p>Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneySmsMessage {
    /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
    pub origination_number: std::option::Option<std::string::String>,
    /// <p>The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the Amazon Pinpoint User Guide.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
    pub template_id: std::option::Option<std::string::String>,
}
impl JourneySmsMessage {
    /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
    pub fn origination_number(&self) -> std::option::Option<&str> {
        self.origination_number.as_deref()
    }
    /// <p>The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the Amazon Pinpoint User Guide.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
}
impl std::fmt::Debug for JourneySmsMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneySmsMessage");
        formatter.field("message_type", &self.message_type);
        formatter.field("origination_number", &self.origination_number);
        formatter.field("sender_id", &self.sender_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("template_id", &self.template_id);
        formatter.finish()
    }
}
/// See [`JourneySmsMessage`](crate::model::JourneySmsMessage)
pub mod journey_sms_message {
    /// A builder for [`JourneySmsMessage`](crate::model::JourneySmsMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) origination_number: std::option::Option<std::string::String>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
        pub fn origination_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_number = Some(input.into());
            self
        }
        /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
        pub fn set_origination_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_number = input;
            self
        }
        /// <p>The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the Amazon Pinpoint User Guide.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the Amazon Pinpoint User Guide.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneySmsMessage`](crate::model::JourneySmsMessage)
        pub fn build(self) -> crate::model::JourneySmsMessage {
            crate::model::JourneySmsMessage {
                message_type: self.message_type,
                origination_number: self.origination_number,
                sender_id: self.sender_id,
                entity_id: self.entity_id,
                template_id: self.template_id,
            }
        }
    }
}
impl JourneySmsMessage {
    /// Creates a new builder-style object to manufacture [`JourneySmsMessage`](crate::model::JourneySmsMessage)
    pub fn builder() -> crate::model::journey_sms_message::Builder {
        crate::model::journey_sms_message::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageType {
    #[allow(missing_docs)] // documentation missing in model
    Promotional,
    #[allow(missing_docs)] // documentation missing in model
    Transactional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageType {
    fn from(s: &str) -> Self {
        match s {
            "PROMOTIONAL" => MessageType::Promotional,
            "TRANSACTIONAL" => MessageType::Transactional,
            other => MessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageType::from(s))
    }
}
impl MessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageType::Promotional => "PROMOTIONAL",
            MessageType::Transactional => "TRANSACTIONAL",
            MessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROMOTIONAL", "TRANSACTIONAL"]
    }
}
impl AsRef<str> for MessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the settings for a random split activity in a journey. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RandomSplitActivity {
    /// <p>The paths for the activity, including the percentage of participants to enter each path and the activity to perform for each path.</p>
    pub branches: std::option::Option<std::vec::Vec<crate::model::RandomSplitEntry>>,
}
impl RandomSplitActivity {
    /// <p>The paths for the activity, including the percentage of participants to enter each path and the activity to perform for each path.</p>
    pub fn branches(&self) -> std::option::Option<&[crate::model::RandomSplitEntry]> {
        self.branches.as_deref()
    }
}
impl std::fmt::Debug for RandomSplitActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RandomSplitActivity");
        formatter.field("branches", &self.branches);
        formatter.finish()
    }
}
/// See [`RandomSplitActivity`](crate::model::RandomSplitActivity)
pub mod random_split_activity {
    /// A builder for [`RandomSplitActivity`](crate::model::RandomSplitActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branches: std::option::Option<std::vec::Vec<crate::model::RandomSplitEntry>>,
    }
    impl Builder {
        /// Appends an item to `branches`.
        ///
        /// To override the contents of this collection use [`set_branches`](Self::set_branches).
        ///
        /// <p>The paths for the activity, including the percentage of participants to enter each path and the activity to perform for each path.</p>
        pub fn branches(mut self, input: impl Into<crate::model::RandomSplitEntry>) -> Self {
            let mut v = self.branches.unwrap_or_default();
            v.push(input.into());
            self.branches = Some(v);
            self
        }
        /// <p>The paths for the activity, including the percentage of participants to enter each path and the activity to perform for each path.</p>
        pub fn set_branches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RandomSplitEntry>>,
        ) -> Self {
            self.branches = input;
            self
        }
        /// Consumes the builder and constructs a [`RandomSplitActivity`](crate::model::RandomSplitActivity)
        pub fn build(self) -> crate::model::RandomSplitActivity {
            crate::model::RandomSplitActivity {
                branches: self.branches,
            }
        }
    }
}
impl RandomSplitActivity {
    /// Creates a new builder-style object to manufacture [`RandomSplitActivity`](crate::model::RandomSplitActivity)
    pub fn builder() -> crate::model::random_split_activity::Builder {
        crate::model::random_split_activity::Builder::default()
    }
}

/// <p>Specifies the settings for a path in a random split activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RandomSplitEntry {
    /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The percentage of participants to send down the activity path.</p> <p>To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.</p>
    pub percentage: i32,
}
impl RandomSplitEntry {
    /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The percentage of participants to send down the activity path.</p> <p>To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.</p>
    pub fn percentage(&self) -> i32 {
        self.percentage
    }
}
impl std::fmt::Debug for RandomSplitEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RandomSplitEntry");
        formatter.field("next_activity", &self.next_activity);
        formatter.field("percentage", &self.percentage);
        formatter.finish()
    }
}
/// See [`RandomSplitEntry`](crate::model::RandomSplitEntry)
pub mod random_split_entry {
    /// A builder for [`RandomSplitEntry`](crate::model::RandomSplitEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The percentage of participants to send down the activity path.</p> <p>To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.</p>
        pub fn percentage(mut self, input: i32) -> Self {
            self.percentage = Some(input);
            self
        }
        /// <p>The percentage of participants to send down the activity path.</p> <p>To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.</p>
        pub fn set_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`RandomSplitEntry`](crate::model::RandomSplitEntry)
        pub fn build(self) -> crate::model::RandomSplitEntry {
            crate::model::RandomSplitEntry {
                next_activity: self.next_activity,
                percentage: self.percentage.unwrap_or_default(),
            }
        }
    }
}
impl RandomSplitEntry {
    /// Creates a new builder-style object to manufacture [`RandomSplitEntry`](crate::model::RandomSplitEntry)
    pub fn builder() -> crate::model::random_split_entry::Builder {
        crate::model::random_split_entry::Builder::default()
    }
}

/// <p>Specifies the settings for a push notification activity in a journey. This type of activity sends a push notification to participants.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PushMessageActivity {
    /// <p>Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.</p>
    pub message_config: std::option::Option<crate::model::JourneyPushMessage>,
    /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The name of the push notification template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the version of the push notification template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub template_version: std::option::Option<std::string::String>,
}
impl PushMessageActivity {
    /// <p>Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.</p>
    pub fn message_config(&self) -> std::option::Option<&crate::model::JourneyPushMessage> {
        self.message_config.as_ref()
    }
    /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The name of the push notification template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The unique identifier for the version of the push notification template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub fn template_version(&self) -> std::option::Option<&str> {
        self.template_version.as_deref()
    }
}
impl std::fmt::Debug for PushMessageActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PushMessageActivity");
        formatter.field("message_config", &self.message_config);
        formatter.field("next_activity", &self.next_activity);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_version", &self.template_version);
        formatter.finish()
    }
}
/// See [`PushMessageActivity`](crate::model::PushMessageActivity)
pub mod push_message_activity {
    /// A builder for [`PushMessageActivity`](crate::model::PushMessageActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_config: std::option::Option<crate::model::JourneyPushMessage>,
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.</p>
        pub fn message_config(mut self, input: crate::model::JourneyPushMessage) -> Self {
            self.message_config = Some(input);
            self
        }
        /// <p>Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.</p>
        pub fn set_message_config(
            mut self,
            input: std::option::Option<crate::model::JourneyPushMessage>,
        ) -> Self {
            self.message_config = input;
            self
        }
        /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The name of the push notification template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the push notification template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the push notification template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the push notification template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`PushMessageActivity`](crate::model::PushMessageActivity)
        pub fn build(self) -> crate::model::PushMessageActivity {
            crate::model::PushMessageActivity {
                message_config: self.message_config,
                next_activity: self.next_activity,
                template_name: self.template_name,
                template_version: self.template_version,
            }
        }
    }
}
impl PushMessageActivity {
    /// Creates a new builder-style object to manufacture [`PushMessageActivity`](crate::model::PushMessageActivity)
    pub fn builder() -> crate::model::push_message_activity::Builder {
        crate::model::push_message_activity::Builder::default()
    }
}

/// <p>Specifies the message configuration for a push notification that's sent to participants in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyPushMessage {
    /// <p>The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
    pub time_to_live: std::option::Option<std::string::String>,
}
impl JourneyPushMessage {
    /// <p>The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
    pub fn time_to_live(&self) -> std::option::Option<&str> {
        self.time_to_live.as_deref()
    }
}
impl std::fmt::Debug for JourneyPushMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyPushMessage");
        formatter.field("time_to_live", &self.time_to_live);
        formatter.finish()
    }
}
/// See [`JourneyPushMessage`](crate::model::JourneyPushMessage)
pub mod journey_push_message {
    /// A builder for [`JourneyPushMessage`](crate::model::JourneyPushMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_to_live: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
        pub fn time_to_live(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_to_live = Some(input.into());
            self
        }
        /// <p>The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
        pub fn set_time_to_live(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_to_live = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyPushMessage`](crate::model::JourneyPushMessage)
        pub fn build(self) -> crate::model::JourneyPushMessage {
            crate::model::JourneyPushMessage {
                time_to_live: self.time_to_live,
            }
        }
    }
}
impl JourneyPushMessage {
    /// Creates a new builder-style object to manufacture [`JourneyPushMessage`](crate::model::JourneyPushMessage)
    pub fn builder() -> crate::model::journey_push_message::Builder {
        crate::model::journey_push_message::Builder::default()
    }
}

/// <p>Specifies the settings for a multivariate split activity in a journey. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p> <note><p>To create multivariate split activities that send participants down different paths based on push notification events (such as Open or Received events), your mobile app has to specify the User ID and Endpoint ID values. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/integrate.html">Integrating Amazon Pinpoint with your application</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p></note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiConditionalSplitActivity {
    /// <p>The paths for the activity, including the conditions for entering each path and the activity to perform for each path.</p>
    pub branches: std::option::Option<std::vec::Vec<crate::model::MultiConditionalBranch>>,
    /// <p>The unique identifier for the activity to perform for participants who don't meet any of the conditions specified for other paths in the activity.</p>
    pub default_activity: std::option::Option<std::string::String>,
    /// <p>The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
    pub evaluation_wait_time: std::option::Option<crate::model::WaitTime>,
}
impl MultiConditionalSplitActivity {
    /// <p>The paths for the activity, including the conditions for entering each path and the activity to perform for each path.</p>
    pub fn branches(&self) -> std::option::Option<&[crate::model::MultiConditionalBranch]> {
        self.branches.as_deref()
    }
    /// <p>The unique identifier for the activity to perform for participants who don't meet any of the conditions specified for other paths in the activity.</p>
    pub fn default_activity(&self) -> std::option::Option<&str> {
        self.default_activity.as_deref()
    }
    /// <p>The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
    pub fn evaluation_wait_time(&self) -> std::option::Option<&crate::model::WaitTime> {
        self.evaluation_wait_time.as_ref()
    }
}
impl std::fmt::Debug for MultiConditionalSplitActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiConditionalSplitActivity");
        formatter.field("branches", &self.branches);
        formatter.field("default_activity", &self.default_activity);
        formatter.field("evaluation_wait_time", &self.evaluation_wait_time);
        formatter.finish()
    }
}
/// See [`MultiConditionalSplitActivity`](crate::model::MultiConditionalSplitActivity)
pub mod multi_conditional_split_activity {
    /// A builder for [`MultiConditionalSplitActivity`](crate::model::MultiConditionalSplitActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branches:
            std::option::Option<std::vec::Vec<crate::model::MultiConditionalBranch>>,
        pub(crate) default_activity: std::option::Option<std::string::String>,
        pub(crate) evaluation_wait_time: std::option::Option<crate::model::WaitTime>,
    }
    impl Builder {
        /// Appends an item to `branches`.
        ///
        /// To override the contents of this collection use [`set_branches`](Self::set_branches).
        ///
        /// <p>The paths for the activity, including the conditions for entering each path and the activity to perform for each path.</p>
        pub fn branches(mut self, input: impl Into<crate::model::MultiConditionalBranch>) -> Self {
            let mut v = self.branches.unwrap_or_default();
            v.push(input.into());
            self.branches = Some(v);
            self
        }
        /// <p>The paths for the activity, including the conditions for entering each path and the activity to perform for each path.</p>
        pub fn set_branches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiConditionalBranch>>,
        ) -> Self {
            self.branches = input;
            self
        }
        /// <p>The unique identifier for the activity to perform for participants who don't meet any of the conditions specified for other paths in the activity.</p>
        pub fn default_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the activity to perform for participants who don't meet any of the conditions specified for other paths in the activity.</p>
        pub fn set_default_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_activity = input;
            self
        }
        /// <p>The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
        pub fn evaluation_wait_time(mut self, input: crate::model::WaitTime) -> Self {
            self.evaluation_wait_time = Some(input);
            self
        }
        /// <p>The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
        pub fn set_evaluation_wait_time(
            mut self,
            input: std::option::Option<crate::model::WaitTime>,
        ) -> Self {
            self.evaluation_wait_time = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiConditionalSplitActivity`](crate::model::MultiConditionalSplitActivity)
        pub fn build(self) -> crate::model::MultiConditionalSplitActivity {
            crate::model::MultiConditionalSplitActivity {
                branches: self.branches,
                default_activity: self.default_activity,
                evaluation_wait_time: self.evaluation_wait_time,
            }
        }
    }
}
impl MultiConditionalSplitActivity {
    /// Creates a new builder-style object to manufacture [`MultiConditionalSplitActivity`](crate::model::MultiConditionalSplitActivity)
    pub fn builder() -> crate::model::multi_conditional_split_activity::Builder {
        crate::model::multi_conditional_split_activity::Builder::default()
    }
}

/// <p>Specifies a condition to evaluate for an activity path in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiConditionalBranch {
    /// <p>The condition to evaluate for the activity path.</p>
    pub condition: std::option::Option<crate::model::SimpleCondition>,
    /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
    pub next_activity: std::option::Option<std::string::String>,
}
impl MultiConditionalBranch {
    /// <p>The condition to evaluate for the activity path.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::SimpleCondition> {
        self.condition.as_ref()
    }
    /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
}
impl std::fmt::Debug for MultiConditionalBranch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiConditionalBranch");
        formatter.field("condition", &self.condition);
        formatter.field("next_activity", &self.next_activity);
        formatter.finish()
    }
}
/// See [`MultiConditionalBranch`](crate::model::MultiConditionalBranch)
pub mod multi_conditional_branch {
    /// A builder for [`MultiConditionalBranch`](crate::model::MultiConditionalBranch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition: std::option::Option<crate::model::SimpleCondition>,
        pub(crate) next_activity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The condition to evaluate for the activity path.</p>
        pub fn condition(mut self, input: crate::model::SimpleCondition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The condition to evaluate for the activity path.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::SimpleCondition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiConditionalBranch`](crate::model::MultiConditionalBranch)
        pub fn build(self) -> crate::model::MultiConditionalBranch {
            crate::model::MultiConditionalBranch {
                condition: self.condition,
                next_activity: self.next_activity,
            }
        }
    }
}
impl MultiConditionalBranch {
    /// Creates a new builder-style object to manufacture [`MultiConditionalBranch`](crate::model::MultiConditionalBranch)
    pub fn builder() -> crate::model::multi_conditional_branch::Builder {
        crate::model::multi_conditional_branch::Builder::default()
    }
}

/// <p>Specifies a condition to evaluate for an activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimpleCondition {
    /// <p>The dimension settings for the event that's associated with the activity.</p>
    pub event_condition: std::option::Option<crate::model::EventCondition>,
    /// <p>The segment that's associated with the activity.</p>
    pub segment_condition: std::option::Option<crate::model::SegmentCondition>,
    /// <p>The dimension settings for the segment that's associated with the activity.</p>
    pub segment_dimensions: std::option::Option<crate::model::SegmentDimensions>,
}
impl SimpleCondition {
    /// <p>The dimension settings for the event that's associated with the activity.</p>
    pub fn event_condition(&self) -> std::option::Option<&crate::model::EventCondition> {
        self.event_condition.as_ref()
    }
    /// <p>The segment that's associated with the activity.</p>
    pub fn segment_condition(&self) -> std::option::Option<&crate::model::SegmentCondition> {
        self.segment_condition.as_ref()
    }
    /// <p>The dimension settings for the segment that's associated with the activity.</p>
    pub fn segment_dimensions(&self) -> std::option::Option<&crate::model::SegmentDimensions> {
        self.segment_dimensions.as_ref()
    }
}
impl std::fmt::Debug for SimpleCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimpleCondition");
        formatter.field("event_condition", &self.event_condition);
        formatter.field("segment_condition", &self.segment_condition);
        formatter.field("segment_dimensions", &self.segment_dimensions);
        formatter.finish()
    }
}
/// See [`SimpleCondition`](crate::model::SimpleCondition)
pub mod simple_condition {
    /// A builder for [`SimpleCondition`](crate::model::SimpleCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_condition: std::option::Option<crate::model::EventCondition>,
        pub(crate) segment_condition: std::option::Option<crate::model::SegmentCondition>,
        pub(crate) segment_dimensions: std::option::Option<crate::model::SegmentDimensions>,
    }
    impl Builder {
        /// <p>The dimension settings for the event that's associated with the activity.</p>
        pub fn event_condition(mut self, input: crate::model::EventCondition) -> Self {
            self.event_condition = Some(input);
            self
        }
        /// <p>The dimension settings for the event that's associated with the activity.</p>
        pub fn set_event_condition(
            mut self,
            input: std::option::Option<crate::model::EventCondition>,
        ) -> Self {
            self.event_condition = input;
            self
        }
        /// <p>The segment that's associated with the activity.</p>
        pub fn segment_condition(mut self, input: crate::model::SegmentCondition) -> Self {
            self.segment_condition = Some(input);
            self
        }
        /// <p>The segment that's associated with the activity.</p>
        pub fn set_segment_condition(
            mut self,
            input: std::option::Option<crate::model::SegmentCondition>,
        ) -> Self {
            self.segment_condition = input;
            self
        }
        /// <p>The dimension settings for the segment that's associated with the activity.</p>
        pub fn segment_dimensions(mut self, input: crate::model::SegmentDimensions) -> Self {
            self.segment_dimensions = Some(input);
            self
        }
        /// <p>The dimension settings for the segment that's associated with the activity.</p>
        pub fn set_segment_dimensions(
            mut self,
            input: std::option::Option<crate::model::SegmentDimensions>,
        ) -> Self {
            self.segment_dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`SimpleCondition`](crate::model::SimpleCondition)
        pub fn build(self) -> crate::model::SimpleCondition {
            crate::model::SimpleCondition {
                event_condition: self.event_condition,
                segment_condition: self.segment_condition,
                segment_dimensions: self.segment_dimensions,
            }
        }
    }
}
impl SimpleCondition {
    /// Creates a new builder-style object to manufacture [`SimpleCondition`](crate::model::SimpleCondition)
    pub fn builder() -> crate::model::simple_condition::Builder {
        crate::model::simple_condition::Builder::default()
    }
}

/// <p>Specifies the conditions to evaluate for an event that applies to an activity in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventCondition {
    /// <p>The dimensions for the event filter to use for the activity.</p>
    pub dimensions: std::option::Option<crate::model::EventDimensions>,
    /// <p>The message identifier (message_id) for the message to use when determining whether message events meet the condition.</p>
    pub message_activity: std::option::Option<std::string::String>,
}
impl EventCondition {
    /// <p>The dimensions for the event filter to use for the activity.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::EventDimensions> {
        self.dimensions.as_ref()
    }
    /// <p>The message identifier (message_id) for the message to use when determining whether message events meet the condition.</p>
    pub fn message_activity(&self) -> std::option::Option<&str> {
        self.message_activity.as_deref()
    }
}
impl std::fmt::Debug for EventCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventCondition");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("message_activity", &self.message_activity);
        formatter.finish()
    }
}
/// See [`EventCondition`](crate::model::EventCondition)
pub mod event_condition {
    /// A builder for [`EventCondition`](crate::model::EventCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<crate::model::EventDimensions>,
        pub(crate) message_activity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The dimensions for the event filter to use for the activity.</p>
        pub fn dimensions(mut self, input: crate::model::EventDimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The dimensions for the event filter to use for the activity.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::EventDimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The message identifier (message_id) for the message to use when determining whether message events meet the condition.</p>
        pub fn message_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_activity = Some(input.into());
            self
        }
        /// <p>The message identifier (message_id) for the message to use when determining whether message events meet the condition.</p>
        pub fn set_message_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_activity = input;
            self
        }
        /// Consumes the builder and constructs a [`EventCondition`](crate::model::EventCondition)
        pub fn build(self) -> crate::model::EventCondition {
            crate::model::EventCondition {
                dimensions: self.dimensions,
                message_activity: self.message_activity,
            }
        }
    }
}
impl EventCondition {
    /// Creates a new builder-style object to manufacture [`EventCondition`](crate::model::EventCondition)
    pub fn builder() -> crate::model::event_condition::Builder {
        crate::model::event_condition::Builder::default()
    }
}

/// <p>Specifies the settings for a holdout activity in a journey. This type of activity stops a journey for a specified percentage of participants.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoldoutActivity {
    /// <p>The unique identifier for the next activity to perform, after performing the holdout activity.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The percentage of participants who shouldn't continue the journey.</p> <p>To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.</p>
    pub percentage: i32,
}
impl HoldoutActivity {
    /// <p>The unique identifier for the next activity to perform, after performing the holdout activity.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The percentage of participants who shouldn't continue the journey.</p> <p>To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.</p>
    pub fn percentage(&self) -> i32 {
        self.percentage
    }
}
impl std::fmt::Debug for HoldoutActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoldoutActivity");
        formatter.field("next_activity", &self.next_activity);
        formatter.field("percentage", &self.percentage);
        formatter.finish()
    }
}
/// See [`HoldoutActivity`](crate::model::HoldoutActivity)
pub mod holdout_activity {
    /// A builder for [`HoldoutActivity`](crate::model::HoldoutActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the next activity to perform, after performing the holdout activity.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after performing the holdout activity.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The percentage of participants who shouldn't continue the journey.</p> <p>To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.</p>
        pub fn percentage(mut self, input: i32) -> Self {
            self.percentage = Some(input);
            self
        }
        /// <p>The percentage of participants who shouldn't continue the journey.</p> <p>To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.</p>
        pub fn set_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`HoldoutActivity`](crate::model::HoldoutActivity)
        pub fn build(self) -> crate::model::HoldoutActivity {
            crate::model::HoldoutActivity {
                next_activity: self.next_activity,
                percentage: self.percentage.unwrap_or_default(),
            }
        }
    }
}
impl HoldoutActivity {
    /// Creates a new builder-style object to manufacture [`HoldoutActivity`](crate::model::HoldoutActivity)
    pub fn builder() -> crate::model::holdout_activity::Builder {
        crate::model::holdout_activity::Builder::default()
    }
}

/// <p>Specifies the settings for an email activity in a journey. This type of activity sends an email message to participants.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailMessageActivity {
    /// <p>Specifies the sender address for an email message that's sent to participants in the journey.</p>
    pub message_config: std::option::Option<crate::model::JourneyEmailMessage>,
    /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The name of the email message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the version of the email template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub template_version: std::option::Option<std::string::String>,
}
impl EmailMessageActivity {
    /// <p>Specifies the sender address for an email message that's sent to participants in the journey.</p>
    pub fn message_config(&self) -> std::option::Option<&crate::model::JourneyEmailMessage> {
        self.message_config.as_ref()
    }
    /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The name of the email message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The unique identifier for the version of the email template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub fn template_version(&self) -> std::option::Option<&str> {
        self.template_version.as_deref()
    }
}
impl std::fmt::Debug for EmailMessageActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailMessageActivity");
        formatter.field("message_config", &self.message_config);
        formatter.field("next_activity", &self.next_activity);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_version", &self.template_version);
        formatter.finish()
    }
}
/// See [`EmailMessageActivity`](crate::model::EmailMessageActivity)
pub mod email_message_activity {
    /// A builder for [`EmailMessageActivity`](crate::model::EmailMessageActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_config: std::option::Option<crate::model::JourneyEmailMessage>,
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the sender address for an email message that's sent to participants in the journey.</p>
        pub fn message_config(mut self, input: crate::model::JourneyEmailMessage) -> Self {
            self.message_config = Some(input);
            self
        }
        /// <p>Specifies the sender address for an email message that's sent to participants in the journey.</p>
        pub fn set_message_config(
            mut self,
            input: std::option::Option<crate::model::JourneyEmailMessage>,
        ) -> Self {
            self.message_config = input;
            self
        }
        /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after the message is sent.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The name of the email message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the email message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the email template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the email template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailMessageActivity`](crate::model::EmailMessageActivity)
        pub fn build(self) -> crate::model::EmailMessageActivity {
            crate::model::EmailMessageActivity {
                message_config: self.message_config,
                next_activity: self.next_activity,
                template_name: self.template_name,
                template_version: self.template_version,
            }
        }
    }
}
impl EmailMessageActivity {
    /// Creates a new builder-style object to manufacture [`EmailMessageActivity`](crate::model::EmailMessageActivity)
    pub fn builder() -> crate::model::email_message_activity::Builder {
        crate::model::email_message_activity::Builder::default()
    }
}

/// <p>Specifies the "From" address for an email message that's sent to participants in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyEmailMessage {
    /// <p>The verified email address to send the email message from. The default address is the FromAddress specified for the email channel for the application.</p>
    pub from_address: std::option::Option<std::string::String>,
}
impl JourneyEmailMessage {
    /// <p>The verified email address to send the email message from. The default address is the FromAddress specified for the email channel for the application.</p>
    pub fn from_address(&self) -> std::option::Option<&str> {
        self.from_address.as_deref()
    }
}
impl std::fmt::Debug for JourneyEmailMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyEmailMessage");
        formatter.field("from_address", &self.from_address);
        formatter.finish()
    }
}
/// See [`JourneyEmailMessage`](crate::model::JourneyEmailMessage)
pub mod journey_email_message {
    /// A builder for [`JourneyEmailMessage`](crate::model::JourneyEmailMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The verified email address to send the email message from. The default address is the FromAddress specified for the email channel for the application.</p>
        pub fn from_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_address = Some(input.into());
            self
        }
        /// <p>The verified email address to send the email message from. The default address is the FromAddress specified for the email channel for the application.</p>
        pub fn set_from_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_address = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyEmailMessage`](crate::model::JourneyEmailMessage)
        pub fn build(self) -> crate::model::JourneyEmailMessage {
            crate::model::JourneyEmailMessage {
                from_address: self.from_address,
            }
        }
    }
}
impl JourneyEmailMessage {
    /// Creates a new builder-style object to manufacture [`JourneyEmailMessage`](crate::model::JourneyEmailMessage)
    pub fn builder() -> crate::model::journey_email_message::Builder {
        crate::model::journey_email_message::Builder::default()
    }
}

/// <p>Specifies the settings for a yes/no split activity in a journey. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p> <note><p>To create yes/no split activities that send participants down different paths based on push notification events (such as Open or Received events), your mobile app has to specify the User ID and Endpoint ID values. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/integrate.html">Integrating Amazon Pinpoint with your application</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p></note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionalSplitActivity {
    /// <p>The conditions that define the paths for the activity, and the relationship between the conditions.</p>
    pub condition: std::option::Option<crate::model::Condition>,
    /// <p>The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
    pub evaluation_wait_time: std::option::Option<crate::model::WaitTime>,
    /// <p>The unique identifier for the activity to perform if the conditions aren't met.</p>
    pub false_activity: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the activity to perform if the conditions are met.</p>
    pub true_activity: std::option::Option<std::string::String>,
}
impl ConditionalSplitActivity {
    /// <p>The conditions that define the paths for the activity, and the relationship between the conditions.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::Condition> {
        self.condition.as_ref()
    }
    /// <p>The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
    pub fn evaluation_wait_time(&self) -> std::option::Option<&crate::model::WaitTime> {
        self.evaluation_wait_time.as_ref()
    }
    /// <p>The unique identifier for the activity to perform if the conditions aren't met.</p>
    pub fn false_activity(&self) -> std::option::Option<&str> {
        self.false_activity.as_deref()
    }
    /// <p>The unique identifier for the activity to perform if the conditions are met.</p>
    pub fn true_activity(&self) -> std::option::Option<&str> {
        self.true_activity.as_deref()
    }
}
impl std::fmt::Debug for ConditionalSplitActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionalSplitActivity");
        formatter.field("condition", &self.condition);
        formatter.field("evaluation_wait_time", &self.evaluation_wait_time);
        formatter.field("false_activity", &self.false_activity);
        formatter.field("true_activity", &self.true_activity);
        formatter.finish()
    }
}
/// See [`ConditionalSplitActivity`](crate::model::ConditionalSplitActivity)
pub mod conditional_split_activity {
    /// A builder for [`ConditionalSplitActivity`](crate::model::ConditionalSplitActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition: std::option::Option<crate::model::Condition>,
        pub(crate) evaluation_wait_time: std::option::Option<crate::model::WaitTime>,
        pub(crate) false_activity: std::option::Option<std::string::String>,
        pub(crate) true_activity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The conditions that define the paths for the activity, and the relationship between the conditions.</p>
        pub fn condition(mut self, input: crate::model::Condition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The conditions that define the paths for the activity, and the relationship between the conditions.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::Condition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
        pub fn evaluation_wait_time(mut self, input: crate::model::WaitTime) -> Self {
            self.evaluation_wait_time = Some(input);
            self
        }
        /// <p>The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>
        pub fn set_evaluation_wait_time(
            mut self,
            input: std::option::Option<crate::model::WaitTime>,
        ) -> Self {
            self.evaluation_wait_time = input;
            self
        }
        /// <p>The unique identifier for the activity to perform if the conditions aren't met.</p>
        pub fn false_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.false_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the activity to perform if the conditions aren't met.</p>
        pub fn set_false_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.false_activity = input;
            self
        }
        /// <p>The unique identifier for the activity to perform if the conditions are met.</p>
        pub fn true_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.true_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the activity to perform if the conditions are met.</p>
        pub fn set_true_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.true_activity = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionalSplitActivity`](crate::model::ConditionalSplitActivity)
        pub fn build(self) -> crate::model::ConditionalSplitActivity {
            crate::model::ConditionalSplitActivity {
                condition: self.condition,
                evaluation_wait_time: self.evaluation_wait_time,
                false_activity: self.false_activity,
                true_activity: self.true_activity,
            }
        }
    }
}
impl ConditionalSplitActivity {
    /// Creates a new builder-style object to manufacture [`ConditionalSplitActivity`](crate::model::ConditionalSplitActivity)
    pub fn builder() -> crate::model::conditional_split_activity::Builder {
        crate::model::conditional_split_activity::Builder::default()
    }
}

/// <p>Specifies the conditions to evaluate for an activity in a journey, and how to evaluate those conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>The conditions to evaluate for the activity.</p>
    pub conditions: std::option::Option<std::vec::Vec<crate::model::SimpleCondition>>,
    /// <p>Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an activity, whether both or only one of the conditions must be met for the activity to be performed.</p>
    pub operator: std::option::Option<crate::model::Operator>,
}
impl Condition {
    /// <p>The conditions to evaluate for the activity.</p>
    pub fn conditions(&self) -> std::option::Option<&[crate::model::SimpleCondition]> {
        self.conditions.as_deref()
    }
    /// <p>Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an activity, whether both or only one of the conditions must be met for the activity to be performed.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::Operator> {
        self.operator.as_ref()
    }
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field("conditions", &self.conditions);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conditions: std::option::Option<std::vec::Vec<crate::model::SimpleCondition>>,
        pub(crate) operator: std::option::Option<crate::model::Operator>,
    }
    impl Builder {
        /// Appends an item to `conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions to evaluate for the activity.</p>
        pub fn conditions(mut self, input: impl Into<crate::model::SimpleCondition>) -> Self {
            let mut v = self.conditions.unwrap_or_default();
            v.push(input.into());
            self.conditions = Some(v);
            self
        }
        /// <p>The conditions to evaluate for the activity.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimpleCondition>>,
        ) -> Self {
            self.conditions = input;
            self
        }
        /// <p>Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an activity, whether both or only one of the conditions must be met for the activity to be performed.</p>
        pub fn operator(mut self, input: crate::model::Operator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an activity, whether both or only one of the conditions must be met for the activity to be performed.</p>
        pub fn set_operator(mut self, input: std::option::Option<crate::model::Operator>) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                conditions: self.conditions,
                operator: self.operator,
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operator {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Any,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operator {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Operator::All,
            "ANY" => Operator::Any,
            other => Operator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operator::from(s))
    }
}
impl Operator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operator::All => "ALL",
            Operator::Any => "ANY",
            Operator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ANY"]
    }
}
impl AsRef<str> for Operator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomMessageActivity {
    /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
    pub delivery_uri: std::option::Option<std::string::String>,
    /// <p>The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
    pub endpoint_types: std::option::Option<std::vec::Vec<crate::model::EndpointTypesElement>>,
    /// <p>Specifies the message data included in a custom channel message that's sent to participants in a journey.</p>
    pub message_config: std::option::Option<crate::model::JourneyCustomMessage>,
    /// <p>The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.</p>
    pub next_activity: std::option::Option<std::string::String>,
    /// <p>The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub template_version: std::option::Option<std::string::String>,
}
impl CustomMessageActivity {
    /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
    pub fn delivery_uri(&self) -> std::option::Option<&str> {
        self.delivery_uri.as_deref()
    }
    /// <p>The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
    pub fn endpoint_types(&self) -> std::option::Option<&[crate::model::EndpointTypesElement]> {
        self.endpoint_types.as_deref()
    }
    /// <p>Specifies the message data included in a custom channel message that's sent to participants in a journey.</p>
    pub fn message_config(&self) -> std::option::Option<&crate::model::JourneyCustomMessage> {
        self.message_config.as_ref()
    }
    /// <p>The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.</p>
    pub fn next_activity(&self) -> std::option::Option<&str> {
        self.next_activity.as_deref()
    }
    /// <p>The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub fn template_version(&self) -> std::option::Option<&str> {
        self.template_version.as_deref()
    }
}
impl std::fmt::Debug for CustomMessageActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomMessageActivity");
        formatter.field("delivery_uri", &self.delivery_uri);
        formatter.field("endpoint_types", &self.endpoint_types);
        formatter.field("message_config", &self.message_config);
        formatter.field("next_activity", &self.next_activity);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_version", &self.template_version);
        formatter.finish()
    }
}
/// See [`CustomMessageActivity`](crate::model::CustomMessageActivity)
pub mod custom_message_activity {
    /// A builder for [`CustomMessageActivity`](crate::model::CustomMessageActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_uri: std::option::Option<std::string::String>,
        pub(crate) endpoint_types:
            std::option::Option<std::vec::Vec<crate::model::EndpointTypesElement>>,
        pub(crate) message_config: std::option::Option<crate::model::JourneyCustomMessage>,
        pub(crate) next_activity: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
        pub fn delivery_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_uri = Some(input.into());
            self
        }
        /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
        pub fn set_delivery_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delivery_uri = input;
            self
        }
        /// Appends an item to `endpoint_types`.
        ///
        /// To override the contents of this collection use [`set_endpoint_types`](Self::set_endpoint_types).
        ///
        /// <p>The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
        pub fn endpoint_types(
            mut self,
            input: impl Into<crate::model::EndpointTypesElement>,
        ) -> Self {
            let mut v = self.endpoint_types.unwrap_or_default();
            v.push(input.into());
            self.endpoint_types = Some(v);
            self
        }
        /// <p>The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
        pub fn set_endpoint_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointTypesElement>>,
        ) -> Self {
            self.endpoint_types = input;
            self
        }
        /// <p>Specifies the message data included in a custom channel message that's sent to participants in a journey.</p>
        pub fn message_config(mut self, input: crate::model::JourneyCustomMessage) -> Self {
            self.message_config = Some(input);
            self
        }
        /// <p>Specifies the message data included in a custom channel message that's sent to participants in a journey.</p>
        pub fn set_message_config(
            mut self,
            input: std::option::Option<crate::model::JourneyCustomMessage>,
        ) -> Self {
            self.message_config = input;
            self
        }
        /// <p>The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.</p>
        pub fn next_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.</p>
        pub fn set_next_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_activity = input;
            self
        }
        /// <p>The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomMessageActivity`](crate::model::CustomMessageActivity)
        pub fn build(self) -> crate::model::CustomMessageActivity {
            crate::model::CustomMessageActivity {
                delivery_uri: self.delivery_uri,
                endpoint_types: self.endpoint_types,
                message_config: self.message_config,
                next_activity: self.next_activity,
                template_name: self.template_name,
                template_version: self.template_version,
            }
        }
    }
}
impl CustomMessageActivity {
    /// Creates a new builder-style object to manufacture [`CustomMessageActivity`](crate::model::CustomMessageActivity)
    pub fn builder() -> crate::model::custom_message_activity::Builder {
        crate::model::custom_message_activity::Builder::default()
    }
}

/// <p>Specifies the message content for a custom channel message that's sent to participants in a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyCustomMessage {
    /// <p>The message content that's passed to an AWS Lambda function or to a web hook.</p>
    pub data: std::option::Option<std::string::String>,
}
impl JourneyCustomMessage {
    /// <p>The message content that's passed to an AWS Lambda function or to a web hook.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
}
impl std::fmt::Debug for JourneyCustomMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyCustomMessage");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`JourneyCustomMessage`](crate::model::JourneyCustomMessage)
pub mod journey_custom_message {
    /// A builder for [`JourneyCustomMessage`](crate::model::JourneyCustomMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message content that's passed to an AWS Lambda function or to a web hook.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The message content that's passed to an AWS Lambda function or to a web hook.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyCustomMessage`](crate::model::JourneyCustomMessage)
        pub fn build(self) -> crate::model::JourneyCustomMessage {
            crate::model::JourneyCustomMessage { data: self.data }
        }
    }
}
impl JourneyCustomMessage {
    /// Creates a new builder-style object to manufacture [`JourneyCustomMessage`](crate::model::JourneyCustomMessage)
    pub fn builder() -> crate::model::journey_custom_message::Builder {
        crate::model::journey_custom_message::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointTypesElement {
    #[allow(missing_docs)] // documentation missing in model
    Adm,
    #[allow(missing_docs)] // documentation missing in model
    Apns,
    #[allow(missing_docs)] // documentation missing in model
    ApnsSandbox,
    #[allow(missing_docs)] // documentation missing in model
    ApnsVoip,
    #[allow(missing_docs)] // documentation missing in model
    ApnsVoipSandbox,
    #[allow(missing_docs)] // documentation missing in model
    Baidu,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Gcm,
    #[allow(missing_docs)] // documentation missing in model
    InApp,
    #[allow(missing_docs)] // documentation missing in model
    Push,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointTypesElement {
    fn from(s: &str) -> Self {
        match s {
            "ADM" => EndpointTypesElement::Adm,
            "APNS" => EndpointTypesElement::Apns,
            "APNS_SANDBOX" => EndpointTypesElement::ApnsSandbox,
            "APNS_VOIP" => EndpointTypesElement::ApnsVoip,
            "APNS_VOIP_SANDBOX" => EndpointTypesElement::ApnsVoipSandbox,
            "BAIDU" => EndpointTypesElement::Baidu,
            "CUSTOM" => EndpointTypesElement::Custom,
            "EMAIL" => EndpointTypesElement::Email,
            "GCM" => EndpointTypesElement::Gcm,
            "IN_APP" => EndpointTypesElement::InApp,
            "PUSH" => EndpointTypesElement::Push,
            "SMS" => EndpointTypesElement::Sms,
            "VOICE" => EndpointTypesElement::Voice,
            other => EndpointTypesElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointTypesElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointTypesElement::from(s))
    }
}
impl EndpointTypesElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointTypesElement::Adm => "ADM",
            EndpointTypesElement::Apns => "APNS",
            EndpointTypesElement::ApnsSandbox => "APNS_SANDBOX",
            EndpointTypesElement::ApnsVoip => "APNS_VOIP",
            EndpointTypesElement::ApnsVoipSandbox => "APNS_VOIP_SANDBOX",
            EndpointTypesElement::Baidu => "BAIDU",
            EndpointTypesElement::Custom => "CUSTOM",
            EndpointTypesElement::Email => "EMAIL",
            EndpointTypesElement::Gcm => "GCM",
            EndpointTypesElement::InApp => "IN_APP",
            EndpointTypesElement::Push => "PUSH",
            EndpointTypesElement::Sms => "SMS",
            EndpointTypesElement::Voice => "VOICE",
            EndpointTypesElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADM",
            "APNS",
            "APNS_SANDBOX",
            "APNS_VOIP",
            "APNS_VOIP_SANDBOX",
            "BAIDU",
            "CUSTOM",
            "EMAIL",
            "GCM",
            "IN_APP",
            "PUSH",
            "SMS",
            "VOICE",
        ]
    }
}
impl AsRef<str> for EndpointTypesElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Changes the status of a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JourneyStateRequest {
    /// <p>The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p> <p>If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those activities, until they are complete, and any activities that were complete when you cancelled the journey.</p> <p>After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.</p> <p>When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl JourneyStateRequest {
    /// <p>The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p> <p>If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those activities, until they are complete, and any activities that were complete when you cancelled the journey.</p> <p>After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.</p> <p>When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for JourneyStateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JourneyStateRequest");
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`JourneyStateRequest`](crate::model::JourneyStateRequest)
pub mod journey_state_request {
    /// A builder for [`JourneyStateRequest`](crate::model::JourneyStateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p> <p>If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those activities, until they are complete, and any activities that were complete when you cancelled the journey.</p> <p>After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.</p> <p>When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p> <p>If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those activities, until they are complete, and any activities that were complete when you cancelled the journey.</p> <p>After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.</p> <p>When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`JourneyStateRequest`](crate::model::JourneyStateRequest)
        pub fn build(self) -> crate::model::JourneyStateRequest {
            crate::model::JourneyStateRequest { state: self.state }
        }
    }
}
impl JourneyStateRequest {
    /// Creates a new builder-style object to manufacture [`JourneyStateRequest`](crate::model::JourneyStateRequest)
    pub fn builder() -> crate::model::journey_state_request::Builder {
        crate::model::journey_state_request::Builder::default()
    }
}

/// <p>Specifies the configuration and other settings for a journey.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteJourneyRequest {
    /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.</p>
    pub activities:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Activity>>,
    /// <p>The date, in ISO 8601 format, when the journey was created.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The messaging and entry limits for the journey.</p>
    pub limits: std::option::Option<crate::model::JourneyLimits>,
    /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. To base the schedule on each participant's local time, set this value to true.</p>
    pub local_time: bool,
    /// <p>The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any spaces.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
    pub quiet_time: std::option::Option<crate::model::QuietTime>,
    /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
    pub refresh_frequency: std::option::Option<std::string::String>,
    /// <p>The schedule settings for the journey.</p>
    pub schedule: std::option::Option<crate::model::JourneySchedule>,
    /// <p>The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.</p>
    pub start_activity: std::option::Option<std::string::String>,
    /// <p>The segment that defines which users are participants in the journey.</p>
    pub start_condition: std::option::Option<crate::model::StartCondition>,
    /// <p>The status of the journey. Valid values are:</p> <ul><li><p>DRAFT - Saves the journey and doesn't publish it.</p></li> <li><p>ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li></ul> <p>PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link  linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
    pub wait_for_quiet_time: bool,
    /// <p>Specifies whether a journey should be refreshed on segment update.</p>
    pub refresh_on_segment_update: bool,
}
impl WriteJourneyRequest {
    /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.</p>
    pub fn activities(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Activity>>
    {
        self.activities.as_ref()
    }
    /// <p>The date, in ISO 8601 format, when the journey was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The messaging and entry limits for the journey.</p>
    pub fn limits(&self) -> std::option::Option<&crate::model::JourneyLimits> {
        self.limits.as_ref()
    }
    /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. To base the schedule on each participant's local time, set this value to true.</p>
    pub fn local_time(&self) -> bool {
        self.local_time
    }
    /// <p>The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any spaces.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
    pub fn quiet_time(&self) -> std::option::Option<&crate::model::QuietTime> {
        self.quiet_time.as_ref()
    }
    /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
    pub fn refresh_frequency(&self) -> std::option::Option<&str> {
        self.refresh_frequency.as_deref()
    }
    /// <p>The schedule settings for the journey.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::JourneySchedule> {
        self.schedule.as_ref()
    }
    /// <p>The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.</p>
    pub fn start_activity(&self) -> std::option::Option<&str> {
        self.start_activity.as_deref()
    }
    /// <p>The segment that defines which users are participants in the journey.</p>
    pub fn start_condition(&self) -> std::option::Option<&crate::model::StartCondition> {
        self.start_condition.as_ref()
    }
    /// <p>The status of the journey. Valid values are:</p> <ul><li><p>DRAFT - Saves the journey and doesn't publish it.</p></li> <li><p>ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li></ul> <p>PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link  linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
    pub fn wait_for_quiet_time(&self) -> bool {
        self.wait_for_quiet_time
    }
    /// <p>Specifies whether a journey should be refreshed on segment update.</p>
    pub fn refresh_on_segment_update(&self) -> bool {
        self.refresh_on_segment_update
    }
}
impl std::fmt::Debug for WriteJourneyRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteJourneyRequest");
        formatter.field("activities", &self.activities);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("limits", &self.limits);
        formatter.field("local_time", &self.local_time);
        formatter.field("name", &self.name);
        formatter.field("quiet_time", &self.quiet_time);
        formatter.field("refresh_frequency", &self.refresh_frequency);
        formatter.field("schedule", &self.schedule);
        formatter.field("start_activity", &self.start_activity);
        formatter.field("start_condition", &self.start_condition);
        formatter.field("state", &self.state);
        formatter.field("wait_for_quiet_time", &self.wait_for_quiet_time);
        formatter.field("refresh_on_segment_update", &self.refresh_on_segment_update);
        formatter.finish()
    }
}
/// See [`WriteJourneyRequest`](crate::model::WriteJourneyRequest)
pub mod write_journey_request {
    /// A builder for [`WriteJourneyRequest`](crate::model::WriteJourneyRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activities: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Activity>,
        >,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) limits: std::option::Option<crate::model::JourneyLimits>,
        pub(crate) local_time: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) quiet_time: std::option::Option<crate::model::QuietTime>,
        pub(crate) refresh_frequency: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::JourneySchedule>,
        pub(crate) start_activity: std::option::Option<std::string::String>,
        pub(crate) start_condition: std::option::Option<crate::model::StartCondition>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) wait_for_quiet_time: std::option::Option<bool>,
        pub(crate) refresh_on_segment_update: std::option::Option<bool>,
    }
    impl Builder {
        /// Adds a key-value pair to `activities`.
        ///
        /// To override the contents of this collection use [`set_activities`](Self::set_activities).
        ///
        /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.</p>
        pub fn activities(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Activity>,
        ) -> Self {
            let mut hash_map = self.activities.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.activities = Some(hash_map);
            self
        }
        /// <p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.</p>
        pub fn set_activities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Activity>,
            >,
        ) -> Self {
            self.activities = input;
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was created.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date, in ISO 8601 format, when the journey was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The messaging and entry limits for the journey.</p>
        pub fn limits(mut self, input: crate::model::JourneyLimits) -> Self {
            self.limits = Some(input);
            self
        }
        /// <p>The messaging and entry limits for the journey.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<crate::model::JourneyLimits>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. To base the schedule on each participant's local time, set this value to true.</p>
        pub fn local_time(mut self, input: bool) -> Self {
            self.local_time = Some(input);
            self
        }
        /// <p>Specifies whether the journey's scheduled start and end times use each participant's local time. To base the schedule on each participant's local time, set this value to true.</p>
        pub fn set_local_time(mut self, input: std::option::Option<bool>) -> Self {
            self.local_time = input;
            self
        }
        /// <p>The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any spaces.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any spaces.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
        pub fn quiet_time(mut self, input: crate::model::QuietTime) -> Self {
            self.quiet_time = Some(input);
            self
        }
        /// <p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.</p>
        pub fn set_quiet_time(
            mut self,
            input: std::option::Option<crate::model::QuietTime>,
        ) -> Self {
            self.quiet_time = input;
            self
        }
        /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
        pub fn refresh_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_frequency = Some(input.into());
            self
        }
        /// <p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>
        pub fn set_refresh_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_frequency = input;
            self
        }
        /// <p>The schedule settings for the journey.</p>
        pub fn schedule(mut self, input: crate::model::JourneySchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule settings for the journey.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::JourneySchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.</p>
        pub fn start_activity(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_activity = Some(input.into());
            self
        }
        /// <p>The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.</p>
        pub fn set_start_activity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_activity = input;
            self
        }
        /// <p>The segment that defines which users are participants in the journey.</p>
        pub fn start_condition(mut self, input: crate::model::StartCondition) -> Self {
            self.start_condition = Some(input);
            self
        }
        /// <p>The segment that defines which users are participants in the journey.</p>
        pub fn set_start_condition(
            mut self,
            input: std::option::Option<crate::model::StartCondition>,
        ) -> Self {
            self.start_condition = input;
            self
        }
        /// <p>The status of the journey. Valid values are:</p> <ul><li><p>DRAFT - Saves the journey and doesn't publish it.</p></li> <li><p>ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li></ul> <p>PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link  linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status of the journey. Valid values are:</p> <ul><li><p>DRAFT - Saves the journey and doesn't publish it.</p></li> <li><p>ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.</p></li></ul> <p>PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link  linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
        pub fn wait_for_quiet_time(mut self, input: bool) -> Self {
            self.wait_for_quiet_time = Some(input);
            self
        }
        /// <p>Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.</p>
        pub fn set_wait_for_quiet_time(mut self, input: std::option::Option<bool>) -> Self {
            self.wait_for_quiet_time = input;
            self
        }
        /// <p>Specifies whether a journey should be refreshed on segment update.</p>
        pub fn refresh_on_segment_update(mut self, input: bool) -> Self {
            self.refresh_on_segment_update = Some(input);
            self
        }
        /// <p>Specifies whether a journey should be refreshed on segment update.</p>
        pub fn set_refresh_on_segment_update(mut self, input: std::option::Option<bool>) -> Self {
            self.refresh_on_segment_update = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteJourneyRequest`](crate::model::WriteJourneyRequest)
        pub fn build(self) -> crate::model::WriteJourneyRequest {
            crate::model::WriteJourneyRequest {
                activities: self.activities,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                limits: self.limits,
                local_time: self.local_time.unwrap_or_default(),
                name: self.name,
                quiet_time: self.quiet_time,
                refresh_frequency: self.refresh_frequency,
                schedule: self.schedule,
                start_activity: self.start_activity,
                start_condition: self.start_condition,
                state: self.state,
                wait_for_quiet_time: self.wait_for_quiet_time.unwrap_or_default(),
                refresh_on_segment_update: self.refresh_on_segment_update.unwrap_or_default(),
            }
        }
    }
}
impl WriteJourneyRequest {
    /// Creates a new builder-style object to manufacture [`WriteJourneyRequest`](crate::model::WriteJourneyRequest)
    pub fn builder() -> crate::model::write_journey_request::Builder {
        crate::model::write_journey_request::Builder::default()
    }
}

/// <p>InApp Template Request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InAppTemplateRequest {
    /// <p>The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and background color. ImageUrl and buttons are optional.</p>
    pub content: std::option::Option<std::vec::Vec<crate::model::InAppMessageContent>>,
    /// <p>Custom config to be sent to client.</p>
    pub custom_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The layout of the message.</p>
    pub layout: std::option::Option<crate::model::Layout>,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The description of the template.</p>
    pub template_description: std::option::Option<std::string::String>,
}
impl InAppTemplateRequest {
    /// <p>The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and background color. ImageUrl and buttons are optional.</p>
    pub fn content(&self) -> std::option::Option<&[crate::model::InAppMessageContent]> {
        self.content.as_deref()
    }
    /// <p>Custom config to be sent to client.</p>
    pub fn custom_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.custom_config.as_ref()
    }
    /// <p>The layout of the message.</p>
    pub fn layout(&self) -> std::option::Option<&crate::model::Layout> {
        self.layout.as_ref()
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The description of the template.</p>
    pub fn template_description(&self) -> std::option::Option<&str> {
        self.template_description.as_deref()
    }
}
impl std::fmt::Debug for InAppTemplateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InAppTemplateRequest");
        formatter.field("content", &self.content);
        formatter.field("custom_config", &self.custom_config);
        formatter.field("layout", &self.layout);
        formatter.field("tags", &self.tags);
        formatter.field("template_description", &self.template_description);
        formatter.finish()
    }
}
/// See [`InAppTemplateRequest`](crate::model::InAppTemplateRequest)
pub mod in_app_template_request {
    /// A builder for [`InAppTemplateRequest`](crate::model::InAppTemplateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::vec::Vec<crate::model::InAppMessageContent>>,
        pub(crate) custom_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) layout: std::option::Option<crate::model::Layout>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `content`.
        ///
        /// To override the contents of this collection use [`set_content`](Self::set_content).
        ///
        /// <p>The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and background color. ImageUrl and buttons are optional.</p>
        pub fn content(mut self, input: impl Into<crate::model::InAppMessageContent>) -> Self {
            let mut v = self.content.unwrap_or_default();
            v.push(input.into());
            self.content = Some(v);
            self
        }
        /// <p>The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and background color. ImageUrl and buttons are optional.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InAppMessageContent>>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `custom_config`.
        ///
        /// To override the contents of this collection use [`set_custom_config`](Self::set_custom_config).
        ///
        /// <p>Custom config to be sent to client.</p>
        pub fn custom_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_config = Some(hash_map);
            self
        }
        /// <p>Custom config to be sent to client.</p>
        pub fn set_custom_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_config = input;
            self
        }
        /// <p>The layout of the message.</p>
        pub fn layout(mut self, input: crate::model::Layout) -> Self {
            self.layout = Some(input);
            self
        }
        /// <p>The layout of the message.</p>
        pub fn set_layout(mut self, input: std::option::Option<crate::model::Layout>) -> Self {
            self.layout = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The description of the template.</p>
        pub fn template_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_description = Some(input.into());
            self
        }
        /// <p>The description of the template.</p>
        pub fn set_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_description = input;
            self
        }
        /// Consumes the builder and constructs a [`InAppTemplateRequest`](crate::model::InAppTemplateRequest)
        pub fn build(self) -> crate::model::InAppTemplateRequest {
            crate::model::InAppTemplateRequest {
                content: self.content,
                custom_config: self.custom_config,
                layout: self.layout,
                tags: self.tags,
                template_description: self.template_description,
            }
        }
    }
}
impl InAppTemplateRequest {
    /// Creates a new builder-style object to manufacture [`InAppTemplateRequest`](crate::model::InAppTemplateRequest)
    pub fn builder() -> crate::model::in_app_template_request::Builder {
        crate::model::in_app_template_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Layout {
    #[allow(missing_docs)] // documentation missing in model
    BottomBanner,
    #[allow(missing_docs)] // documentation missing in model
    Carousel,
    #[allow(missing_docs)] // documentation missing in model
    MiddleBanner,
    #[allow(missing_docs)] // documentation missing in model
    MobileFeed,
    #[allow(missing_docs)] // documentation missing in model
    Overlays,
    #[allow(missing_docs)] // documentation missing in model
    TopBanner,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Layout {
    fn from(s: &str) -> Self {
        match s {
            "BOTTOM_BANNER" => Layout::BottomBanner,
            "CAROUSEL" => Layout::Carousel,
            "MIDDLE_BANNER" => Layout::MiddleBanner,
            "MOBILE_FEED" => Layout::MobileFeed,
            "OVERLAYS" => Layout::Overlays,
            "TOP_BANNER" => Layout::TopBanner,
            other => Layout::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Layout {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Layout::from(s))
    }
}
impl Layout {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Layout::BottomBanner => "BOTTOM_BANNER",
            Layout::Carousel => "CAROUSEL",
            Layout::MiddleBanner => "MIDDLE_BANNER",
            Layout::MobileFeed => "MOBILE_FEED",
            Layout::Overlays => "OVERLAYS",
            Layout::TopBanner => "TOP_BANNER",
            Layout::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOTTOM_BANNER",
            "CAROUSEL",
            "MIDDLE_BANNER",
            "MOBILE_FEED",
            "OVERLAYS",
            "TOP_BANNER",
        ]
    }
}
impl AsRef<str> for Layout {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for the message content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InAppMessageContent {
    /// <p>The background color for the message.</p>
    pub background_color: std::option::Option<std::string::String>,
    /// <p>The configuration for the message body.</p>
    pub body_config: std::option::Option<crate::model::InAppMessageBodyConfig>,
    /// <p>The configuration for the message header.</p>
    pub header_config: std::option::Option<crate::model::InAppMessageHeaderConfig>,
    /// <p>The image url for the background of message.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>The first button inside the message.</p>
    pub primary_btn: std::option::Option<crate::model::InAppMessageButton>,
    /// <p>The second button inside message.</p>
    pub secondary_btn: std::option::Option<crate::model::InAppMessageButton>,
}
impl InAppMessageContent {
    /// <p>The background color for the message.</p>
    pub fn background_color(&self) -> std::option::Option<&str> {
        self.background_color.as_deref()
    }
    /// <p>The configuration for the message body.</p>
    pub fn body_config(&self) -> std::option::Option<&crate::model::InAppMessageBodyConfig> {
        self.body_config.as_ref()
    }
    /// <p>The configuration for the message header.</p>
    pub fn header_config(&self) -> std::option::Option<&crate::model::InAppMessageHeaderConfig> {
        self.header_config.as_ref()
    }
    /// <p>The image url for the background of message.</p>
    pub fn image_url(&self) -> std::option::Option<&str> {
        self.image_url.as_deref()
    }
    /// <p>The first button inside the message.</p>
    pub fn primary_btn(&self) -> std::option::Option<&crate::model::InAppMessageButton> {
        self.primary_btn.as_ref()
    }
    /// <p>The second button inside message.</p>
    pub fn secondary_btn(&self) -> std::option::Option<&crate::model::InAppMessageButton> {
        self.secondary_btn.as_ref()
    }
}
impl std::fmt::Debug for InAppMessageContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InAppMessageContent");
        formatter.field("background_color", &self.background_color);
        formatter.field("body_config", &self.body_config);
        formatter.field("header_config", &self.header_config);
        formatter.field("image_url", &self.image_url);
        formatter.field("primary_btn", &self.primary_btn);
        formatter.field("secondary_btn", &self.secondary_btn);
        formatter.finish()
    }
}
/// See [`InAppMessageContent`](crate::model::InAppMessageContent)
pub mod in_app_message_content {
    /// A builder for [`InAppMessageContent`](crate::model::InAppMessageContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) background_color: std::option::Option<std::string::String>,
        pub(crate) body_config: std::option::Option<crate::model::InAppMessageBodyConfig>,
        pub(crate) header_config: std::option::Option<crate::model::InAppMessageHeaderConfig>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) primary_btn: std::option::Option<crate::model::InAppMessageButton>,
        pub(crate) secondary_btn: std::option::Option<crate::model::InAppMessageButton>,
    }
    impl Builder {
        /// <p>The background color for the message.</p>
        pub fn background_color(mut self, input: impl Into<std::string::String>) -> Self {
            self.background_color = Some(input.into());
            self
        }
        /// <p>The background color for the message.</p>
        pub fn set_background_color(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.background_color = input;
            self
        }
        /// <p>The configuration for the message body.</p>
        pub fn body_config(mut self, input: crate::model::InAppMessageBodyConfig) -> Self {
            self.body_config = Some(input);
            self
        }
        /// <p>The configuration for the message body.</p>
        pub fn set_body_config(
            mut self,
            input: std::option::Option<crate::model::InAppMessageBodyConfig>,
        ) -> Self {
            self.body_config = input;
            self
        }
        /// <p>The configuration for the message header.</p>
        pub fn header_config(mut self, input: crate::model::InAppMessageHeaderConfig) -> Self {
            self.header_config = Some(input);
            self
        }
        /// <p>The configuration for the message header.</p>
        pub fn set_header_config(
            mut self,
            input: std::option::Option<crate::model::InAppMessageHeaderConfig>,
        ) -> Self {
            self.header_config = input;
            self
        }
        /// <p>The image url for the background of message.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The image url for the background of message.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// <p>The first button inside the message.</p>
        pub fn primary_btn(mut self, input: crate::model::InAppMessageButton) -> Self {
            self.primary_btn = Some(input);
            self
        }
        /// <p>The first button inside the message.</p>
        pub fn set_primary_btn(
            mut self,
            input: std::option::Option<crate::model::InAppMessageButton>,
        ) -> Self {
            self.primary_btn = input;
            self
        }
        /// <p>The second button inside message.</p>
        pub fn secondary_btn(mut self, input: crate::model::InAppMessageButton) -> Self {
            self.secondary_btn = Some(input);
            self
        }
        /// <p>The second button inside message.</p>
        pub fn set_secondary_btn(
            mut self,
            input: std::option::Option<crate::model::InAppMessageButton>,
        ) -> Self {
            self.secondary_btn = input;
            self
        }
        /// Consumes the builder and constructs a [`InAppMessageContent`](crate::model::InAppMessageContent)
        pub fn build(self) -> crate::model::InAppMessageContent {
            crate::model::InAppMessageContent {
                background_color: self.background_color,
                body_config: self.body_config,
                header_config: self.header_config,
                image_url: self.image_url,
                primary_btn: self.primary_btn,
                secondary_btn: self.secondary_btn,
            }
        }
    }
}
impl InAppMessageContent {
    /// Creates a new builder-style object to manufacture [`InAppMessageContent`](crate::model::InAppMessageContent)
    pub fn builder() -> crate::model::in_app_message_content::Builder {
        crate::model::in_app_message_content::Builder::default()
    }
}

/// <p>Button Config for an in-app message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InAppMessageButton {
    /// <p>Default button content.</p>
    pub android: std::option::Option<crate::model::OverrideButtonConfiguration>,
    /// <p>Default button content.</p>
    pub default_config: std::option::Option<crate::model::DefaultButtonConfiguration>,
    /// <p>Default button content.</p>
    pub ios: std::option::Option<crate::model::OverrideButtonConfiguration>,
    /// <p>Default button content.</p>
    pub web: std::option::Option<crate::model::OverrideButtonConfiguration>,
}
impl InAppMessageButton {
    /// <p>Default button content.</p>
    pub fn android(&self) -> std::option::Option<&crate::model::OverrideButtonConfiguration> {
        self.android.as_ref()
    }
    /// <p>Default button content.</p>
    pub fn default_config(&self) -> std::option::Option<&crate::model::DefaultButtonConfiguration> {
        self.default_config.as_ref()
    }
    /// <p>Default button content.</p>
    pub fn ios(&self) -> std::option::Option<&crate::model::OverrideButtonConfiguration> {
        self.ios.as_ref()
    }
    /// <p>Default button content.</p>
    pub fn web(&self) -> std::option::Option<&crate::model::OverrideButtonConfiguration> {
        self.web.as_ref()
    }
}
impl std::fmt::Debug for InAppMessageButton {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InAppMessageButton");
        formatter.field("android", &self.android);
        formatter.field("default_config", &self.default_config);
        formatter.field("ios", &self.ios);
        formatter.field("web", &self.web);
        formatter.finish()
    }
}
/// See [`InAppMessageButton`](crate::model::InAppMessageButton)
pub mod in_app_message_button {
    /// A builder for [`InAppMessageButton`](crate::model::InAppMessageButton)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) android: std::option::Option<crate::model::OverrideButtonConfiguration>,
        pub(crate) default_config: std::option::Option<crate::model::DefaultButtonConfiguration>,
        pub(crate) ios: std::option::Option<crate::model::OverrideButtonConfiguration>,
        pub(crate) web: std::option::Option<crate::model::OverrideButtonConfiguration>,
    }
    impl Builder {
        /// <p>Default button content.</p>
        pub fn android(mut self, input: crate::model::OverrideButtonConfiguration) -> Self {
            self.android = Some(input);
            self
        }
        /// <p>Default button content.</p>
        pub fn set_android(
            mut self,
            input: std::option::Option<crate::model::OverrideButtonConfiguration>,
        ) -> Self {
            self.android = input;
            self
        }
        /// <p>Default button content.</p>
        pub fn default_config(mut self, input: crate::model::DefaultButtonConfiguration) -> Self {
            self.default_config = Some(input);
            self
        }
        /// <p>Default button content.</p>
        pub fn set_default_config(
            mut self,
            input: std::option::Option<crate::model::DefaultButtonConfiguration>,
        ) -> Self {
            self.default_config = input;
            self
        }
        /// <p>Default button content.</p>
        pub fn ios(mut self, input: crate::model::OverrideButtonConfiguration) -> Self {
            self.ios = Some(input);
            self
        }
        /// <p>Default button content.</p>
        pub fn set_ios(
            mut self,
            input: std::option::Option<crate::model::OverrideButtonConfiguration>,
        ) -> Self {
            self.ios = input;
            self
        }
        /// <p>Default button content.</p>
        pub fn web(mut self, input: crate::model::OverrideButtonConfiguration) -> Self {
            self.web = Some(input);
            self
        }
        /// <p>Default button content.</p>
        pub fn set_web(
            mut self,
            input: std::option::Option<crate::model::OverrideButtonConfiguration>,
        ) -> Self {
            self.web = input;
            self
        }
        /// Consumes the builder and constructs a [`InAppMessageButton`](crate::model::InAppMessageButton)
        pub fn build(self) -> crate::model::InAppMessageButton {
            crate::model::InAppMessageButton {
                android: self.android,
                default_config: self.default_config,
                ios: self.ios,
                web: self.web,
            }
        }
    }
}
impl InAppMessageButton {
    /// Creates a new builder-style object to manufacture [`InAppMessageButton`](crate::model::InAppMessageButton)
    pub fn builder() -> crate::model::in_app_message_button::Builder {
        crate::model::in_app_message_button::Builder::default()
    }
}

/// <p>Override button configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OverrideButtonConfiguration {
    /// <p>Action triggered by the button.</p>
    pub button_action: std::option::Option<crate::model::ButtonAction>,
    /// <p>Button destination.</p>
    pub link: std::option::Option<std::string::String>,
}
impl OverrideButtonConfiguration {
    /// <p>Action triggered by the button.</p>
    pub fn button_action(&self) -> std::option::Option<&crate::model::ButtonAction> {
        self.button_action.as_ref()
    }
    /// <p>Button destination.</p>
    pub fn link(&self) -> std::option::Option<&str> {
        self.link.as_deref()
    }
}
impl std::fmt::Debug for OverrideButtonConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OverrideButtonConfiguration");
        formatter.field("button_action", &self.button_action);
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`OverrideButtonConfiguration`](crate::model::OverrideButtonConfiguration)
pub mod override_button_configuration {
    /// A builder for [`OverrideButtonConfiguration`](crate::model::OverrideButtonConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) button_action: std::option::Option<crate::model::ButtonAction>,
        pub(crate) link: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Action triggered by the button.</p>
        pub fn button_action(mut self, input: crate::model::ButtonAction) -> Self {
            self.button_action = Some(input);
            self
        }
        /// <p>Action triggered by the button.</p>
        pub fn set_button_action(
            mut self,
            input: std::option::Option<crate::model::ButtonAction>,
        ) -> Self {
            self.button_action = input;
            self
        }
        /// <p>Button destination.</p>
        pub fn link(mut self, input: impl Into<std::string::String>) -> Self {
            self.link = Some(input.into());
            self
        }
        /// <p>Button destination.</p>
        pub fn set_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`OverrideButtonConfiguration`](crate::model::OverrideButtonConfiguration)
        pub fn build(self) -> crate::model::OverrideButtonConfiguration {
            crate::model::OverrideButtonConfiguration {
                button_action: self.button_action,
                link: self.link,
            }
        }
    }
}
impl OverrideButtonConfiguration {
    /// Creates a new builder-style object to manufacture [`OverrideButtonConfiguration`](crate::model::OverrideButtonConfiguration)
    pub fn builder() -> crate::model::override_button_configuration::Builder {
        crate::model::override_button_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ButtonAction {
    #[allow(missing_docs)] // documentation missing in model
    Close,
    #[allow(missing_docs)] // documentation missing in model
    DeepLink,
    #[allow(missing_docs)] // documentation missing in model
    Link,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ButtonAction {
    fn from(s: &str) -> Self {
        match s {
            "CLOSE" => ButtonAction::Close,
            "DEEP_LINK" => ButtonAction::DeepLink,
            "LINK" => ButtonAction::Link,
            other => ButtonAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ButtonAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ButtonAction::from(s))
    }
}
impl ButtonAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ButtonAction::Close => "CLOSE",
            ButtonAction::DeepLink => "DEEP_LINK",
            ButtonAction::Link => "LINK",
            ButtonAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSE", "DEEP_LINK", "LINK"]
    }
}
impl AsRef<str> for ButtonAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Default button configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultButtonConfiguration {
    /// <p>The background color of the button.</p>
    pub background_color: std::option::Option<std::string::String>,
    /// <p>The border radius of the button.</p>
    pub border_radius: i32,
    /// <p>Action triggered by the button.</p>
    pub button_action: std::option::Option<crate::model::ButtonAction>,
    /// <p>Button destination.</p>
    pub link: std::option::Option<std::string::String>,
    /// <p>Button text.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The text color of the button.</p>
    pub text_color: std::option::Option<std::string::String>,
}
impl DefaultButtonConfiguration {
    /// <p>The background color of the button.</p>
    pub fn background_color(&self) -> std::option::Option<&str> {
        self.background_color.as_deref()
    }
    /// <p>The border radius of the button.</p>
    pub fn border_radius(&self) -> i32 {
        self.border_radius
    }
    /// <p>Action triggered by the button.</p>
    pub fn button_action(&self) -> std::option::Option<&crate::model::ButtonAction> {
        self.button_action.as_ref()
    }
    /// <p>Button destination.</p>
    pub fn link(&self) -> std::option::Option<&str> {
        self.link.as_deref()
    }
    /// <p>Button text.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The text color of the button.</p>
    pub fn text_color(&self) -> std::option::Option<&str> {
        self.text_color.as_deref()
    }
}
impl std::fmt::Debug for DefaultButtonConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultButtonConfiguration");
        formatter.field("background_color", &self.background_color);
        formatter.field("border_radius", &self.border_radius);
        formatter.field("button_action", &self.button_action);
        formatter.field("link", &self.link);
        formatter.field("text", &self.text);
        formatter.field("text_color", &self.text_color);
        formatter.finish()
    }
}
/// See [`DefaultButtonConfiguration`](crate::model::DefaultButtonConfiguration)
pub mod default_button_configuration {
    /// A builder for [`DefaultButtonConfiguration`](crate::model::DefaultButtonConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) background_color: std::option::Option<std::string::String>,
        pub(crate) border_radius: std::option::Option<i32>,
        pub(crate) button_action: std::option::Option<crate::model::ButtonAction>,
        pub(crate) link: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) text_color: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The background color of the button.</p>
        pub fn background_color(mut self, input: impl Into<std::string::String>) -> Self {
            self.background_color = Some(input.into());
            self
        }
        /// <p>The background color of the button.</p>
        pub fn set_background_color(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.background_color = input;
            self
        }
        /// <p>The border radius of the button.</p>
        pub fn border_radius(mut self, input: i32) -> Self {
            self.border_radius = Some(input);
            self
        }
        /// <p>The border radius of the button.</p>
        pub fn set_border_radius(mut self, input: std::option::Option<i32>) -> Self {
            self.border_radius = input;
            self
        }
        /// <p>Action triggered by the button.</p>
        pub fn button_action(mut self, input: crate::model::ButtonAction) -> Self {
            self.button_action = Some(input);
            self
        }
        /// <p>Action triggered by the button.</p>
        pub fn set_button_action(
            mut self,
            input: std::option::Option<crate::model::ButtonAction>,
        ) -> Self {
            self.button_action = input;
            self
        }
        /// <p>Button destination.</p>
        pub fn link(mut self, input: impl Into<std::string::String>) -> Self {
            self.link = Some(input.into());
            self
        }
        /// <p>Button destination.</p>
        pub fn set_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link = input;
            self
        }
        /// <p>Button text.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>Button text.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The text color of the button.</p>
        pub fn text_color(mut self, input: impl Into<std::string::String>) -> Self {
            self.text_color = Some(input.into());
            self
        }
        /// <p>The text color of the button.</p>
        pub fn set_text_color(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text_color = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultButtonConfiguration`](crate::model::DefaultButtonConfiguration)
        pub fn build(self) -> crate::model::DefaultButtonConfiguration {
            crate::model::DefaultButtonConfiguration {
                background_color: self.background_color,
                border_radius: self.border_radius.unwrap_or_default(),
                button_action: self.button_action,
                link: self.link,
                text: self.text,
                text_color: self.text_color,
            }
        }
    }
}
impl DefaultButtonConfiguration {
    /// Creates a new builder-style object to manufacture [`DefaultButtonConfiguration`](crate::model::DefaultButtonConfiguration)
    pub fn builder() -> crate::model::default_button_configuration::Builder {
        crate::model::default_button_configuration::Builder::default()
    }
}

/// <p>Text config for Message Header.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InAppMessageHeaderConfig {
    /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
    pub alignment: std::option::Option<crate::model::Alignment>,
    /// <p>Message Header.</p>
    pub header: std::option::Option<std::string::String>,
    /// <p>The text color.</p>
    pub text_color: std::option::Option<std::string::String>,
}
impl InAppMessageHeaderConfig {
    /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
    pub fn alignment(&self) -> std::option::Option<&crate::model::Alignment> {
        self.alignment.as_ref()
    }
    /// <p>Message Header.</p>
    pub fn header(&self) -> std::option::Option<&str> {
        self.header.as_deref()
    }
    /// <p>The text color.</p>
    pub fn text_color(&self) -> std::option::Option<&str> {
        self.text_color.as_deref()
    }
}
impl std::fmt::Debug for InAppMessageHeaderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InAppMessageHeaderConfig");
        formatter.field("alignment", &self.alignment);
        formatter.field("header", &self.header);
        formatter.field("text_color", &self.text_color);
        formatter.finish()
    }
}
/// See [`InAppMessageHeaderConfig`](crate::model::InAppMessageHeaderConfig)
pub mod in_app_message_header_config {
    /// A builder for [`InAppMessageHeaderConfig`](crate::model::InAppMessageHeaderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alignment: std::option::Option<crate::model::Alignment>,
        pub(crate) header: std::option::Option<std::string::String>,
        pub(crate) text_color: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
        pub fn alignment(mut self, input: crate::model::Alignment) -> Self {
            self.alignment = Some(input);
            self
        }
        /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
        pub fn set_alignment(
            mut self,
            input: std::option::Option<crate::model::Alignment>,
        ) -> Self {
            self.alignment = input;
            self
        }
        /// <p>Message Header.</p>
        pub fn header(mut self, input: impl Into<std::string::String>) -> Self {
            self.header = Some(input.into());
            self
        }
        /// <p>Message Header.</p>
        pub fn set_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header = input;
            self
        }
        /// <p>The text color.</p>
        pub fn text_color(mut self, input: impl Into<std::string::String>) -> Self {
            self.text_color = Some(input.into());
            self
        }
        /// <p>The text color.</p>
        pub fn set_text_color(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text_color = input;
            self
        }
        /// Consumes the builder and constructs a [`InAppMessageHeaderConfig`](crate::model::InAppMessageHeaderConfig)
        pub fn build(self) -> crate::model::InAppMessageHeaderConfig {
            crate::model::InAppMessageHeaderConfig {
                alignment: self.alignment,
                header: self.header,
                text_color: self.text_color,
            }
        }
    }
}
impl InAppMessageHeaderConfig {
    /// Creates a new builder-style object to manufacture [`InAppMessageHeaderConfig`](crate::model::InAppMessageHeaderConfig)
    pub fn builder() -> crate::model::in_app_message_header_config::Builder {
        crate::model::in_app_message_header_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Alignment {
    #[allow(missing_docs)] // documentation missing in model
    Center,
    #[allow(missing_docs)] // documentation missing in model
    Left,
    #[allow(missing_docs)] // documentation missing in model
    Right,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Alignment {
    fn from(s: &str) -> Self {
        match s {
            "CENTER" => Alignment::Center,
            "LEFT" => Alignment::Left,
            "RIGHT" => Alignment::Right,
            other => Alignment::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Alignment {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Alignment::from(s))
    }
}
impl Alignment {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Alignment::Center => "CENTER",
            Alignment::Left => "LEFT",
            Alignment::Right => "RIGHT",
            Alignment::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CENTER", "LEFT", "RIGHT"]
    }
}
impl AsRef<str> for Alignment {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Text config for Message Body.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InAppMessageBodyConfig {
    /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
    pub alignment: std::option::Option<crate::model::Alignment>,
    /// <p>Message Body.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The text color.</p>
    pub text_color: std::option::Option<std::string::String>,
}
impl InAppMessageBodyConfig {
    /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
    pub fn alignment(&self) -> std::option::Option<&crate::model::Alignment> {
        self.alignment.as_ref()
    }
    /// <p>Message Body.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The text color.</p>
    pub fn text_color(&self) -> std::option::Option<&str> {
        self.text_color.as_deref()
    }
}
impl std::fmt::Debug for InAppMessageBodyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InAppMessageBodyConfig");
        formatter.field("alignment", &self.alignment);
        formatter.field("body", &self.body);
        formatter.field("text_color", &self.text_color);
        formatter.finish()
    }
}
/// See [`InAppMessageBodyConfig`](crate::model::InAppMessageBodyConfig)
pub mod in_app_message_body_config {
    /// A builder for [`InAppMessageBodyConfig`](crate::model::InAppMessageBodyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alignment: std::option::Option<crate::model::Alignment>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) text_color: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
        pub fn alignment(mut self, input: crate::model::Alignment) -> Self {
            self.alignment = Some(input);
            self
        }
        /// <p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>
        pub fn set_alignment(
            mut self,
            input: std::option::Option<crate::model::Alignment>,
        ) -> Self {
            self.alignment = input;
            self
        }
        /// <p>Message Body.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>Message Body.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The text color.</p>
        pub fn text_color(mut self, input: impl Into<std::string::String>) -> Self {
            self.text_color = Some(input.into());
            self
        }
        /// <p>The text color.</p>
        pub fn set_text_color(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text_color = input;
            self
        }
        /// Consumes the builder and constructs a [`InAppMessageBodyConfig`](crate::model::InAppMessageBodyConfig)
        pub fn build(self) -> crate::model::InAppMessageBodyConfig {
            crate::model::InAppMessageBodyConfig {
                alignment: self.alignment,
                body: self.body,
                text_color: self.text_color,
            }
        }
    }
}
impl InAppMessageBodyConfig {
    /// Creates a new builder-style object to manufacture [`InAppMessageBodyConfig`](crate::model::InAppMessageBodyConfig)
    pub fn builder() -> crate::model::in_app_message_body_config::Builder {
        crate::model::in_app_message_body_config::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the GCM channel for an application. The GCM channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GcmChannelResponse {
    /// <p>The unique identifier for the application that the GCM channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the GCM channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
    pub credential: std::option::Option<std::string::String>,
    /// <p>Specifies whether the GCM channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>(Deprecated) An identifier for the GCM channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the GCM channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the GCM channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the GCM channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the GCM channel, this value is GCM.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current version of the GCM channel.</p>
    pub version: i32,
}
impl GcmChannelResponse {
    /// <p>The unique identifier for the application that the GCM channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time when the GCM channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
    pub fn credential(&self) -> std::option::Option<&str> {
        self.credential.as_deref()
    }
    /// <p>Specifies whether the GCM channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>(Deprecated) An identifier for the GCM channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the GCM channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the GCM channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time when the GCM channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the GCM channel, this value is GCM.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current version of the GCM channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for GcmChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GcmChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("credential", &self.credential);
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`GcmChannelResponse`](crate::model::GcmChannelResponse)
pub mod gcm_channel_response {
    /// A builder for [`GcmChannelResponse`](crate::model::GcmChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) credential: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the GCM channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the GCM channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time when the GCM channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time when the GCM channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
        pub fn credential(mut self, input: impl Into<std::string::String>) -> Self {
            self.credential = Some(input.into());
            self
        }
        /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
        pub fn set_credential(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credential = input;
            self
        }
        /// <p>Specifies whether the GCM channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the GCM channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>(Deprecated) An identifier for the GCM channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the GCM channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the GCM channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the GCM channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the GCM channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the GCM channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time when the GCM channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time when the GCM channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the GCM channel, this value is GCM.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the GCM channel, this value is GCM.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current version of the GCM channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the GCM channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GcmChannelResponse`](crate::model::GcmChannelResponse)
        pub fn build(self) -> crate::model::GcmChannelResponse {
            crate::model::GcmChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                credential: self.credential,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl GcmChannelResponse {
    /// Creates a new builder-style object to manufacture [`GcmChannelResponse`](crate::model::GcmChannelResponse)
    pub fn builder() -> crate::model::gcm_channel_response::Builder {
        crate::model::gcm_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GcmChannelRequest {
    /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
    pub api_key: std::option::Option<std::string::String>,
    /// <p>Specifies whether to enable the GCM channel for the application.</p>
    pub enabled: bool,
}
impl GcmChannelRequest {
    /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
    pub fn api_key(&self) -> std::option::Option<&str> {
        self.api_key.as_deref()
    }
    /// <p>Specifies whether to enable the GCM channel for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for GcmChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GcmChannelRequest");
        formatter.field("api_key", &self.api_key);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`GcmChannelRequest`](crate::model::GcmChannelRequest)
pub mod gcm_channel_request {
    /// A builder for [`GcmChannelRequest`](crate::model::GcmChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// <p>Specifies whether to enable the GCM channel for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the GCM channel for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`GcmChannelRequest`](crate::model::GcmChannelRequest)
        pub fn build(self) -> crate::model::GcmChannelRequest {
            crate::model::GcmChannelRequest {
                api_key: self.api_key,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl GcmChannelRequest {
    /// Creates a new builder-style object to manufacture [`GcmChannelRequest`](crate::model::GcmChannelRequest)
    pub fn builder() -> crate::model::gcm_channel_request::Builder {
        crate::model::gcm_channel_request::Builder::default()
    }
}

/// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointBatchRequest {
    /// <p>An array that defines the endpoints to create or update and, for each endpoint, the property values to set or change. An array can contain a maximum of 100 items.</p>
    pub item: std::option::Option<std::vec::Vec<crate::model::EndpointBatchItem>>,
}
impl EndpointBatchRequest {
    /// <p>An array that defines the endpoints to create or update and, for each endpoint, the property values to set or change. An array can contain a maximum of 100 items.</p>
    pub fn item(&self) -> std::option::Option<&[crate::model::EndpointBatchItem]> {
        self.item.as_deref()
    }
}
impl std::fmt::Debug for EndpointBatchRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointBatchRequest");
        formatter.field("item", &self.item);
        formatter.finish()
    }
}
/// See [`EndpointBatchRequest`](crate::model::EndpointBatchRequest)
pub mod endpoint_batch_request {
    /// A builder for [`EndpointBatchRequest`](crate::model::EndpointBatchRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<std::vec::Vec<crate::model::EndpointBatchItem>>,
    }
    impl Builder {
        /// Appends an item to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>An array that defines the endpoints to create or update and, for each endpoint, the property values to set or change. An array can contain a maximum of 100 items.</p>
        pub fn item(mut self, input: impl Into<crate::model::EndpointBatchItem>) -> Self {
            let mut v = self.item.unwrap_or_default();
            v.push(input.into());
            self.item = Some(v);
            self
        }
        /// <p>An array that defines the endpoints to create or update and, for each endpoint, the property values to set or change. An array can contain a maximum of 100 items.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointBatchItem>>,
        ) -> Self {
            self.item = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointBatchRequest`](crate::model::EndpointBatchRequest)
        pub fn build(self) -> crate::model::EndpointBatchRequest {
            crate::model::EndpointBatchRequest { item: self.item }
        }
    }
}
impl EndpointBatchRequest {
    /// Creates a new builder-style object to manufacture [`EndpointBatchRequest`](crate::model::EndpointBatchRequest)
    pub fn builder() -> crate::model::endpoint_batch_request::Builder {
        crate::model::endpoint_batch_request::Builder::default()
    }
}

/// <p>Specifies an endpoint to create or update and the settings and attributes to set or change for the endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointBatchItem {
    /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
    pub channel_type: std::option::Option<crate::model::ChannelType>,
    /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
    pub demographic: std::option::Option<crate::model::EndpointDemographic>,
    /// <p>The date and time, in ISO 8601 format, when the endpoint was created or updated.</p>
    pub effective_date: std::option::Option<std::string::String>,
    /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
    pub endpoint_status: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the endpoint in the context of the batch.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The geographic information for the endpoint.</p>
    pub location: std::option::Option<crate::model::EndpointLocation>,
    /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
    pub metrics: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
    pub opt_out: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request to create or update the endpoint.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
    pub user: std::option::Option<crate::model::EndpointUser>,
}
impl EndpointBatchItem {
    /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
    pub fn channel_type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.channel_type.as_ref()
    }
    /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
    pub fn demographic(&self) -> std::option::Option<&crate::model::EndpointDemographic> {
        self.demographic.as_ref()
    }
    /// <p>The date and time, in ISO 8601 format, when the endpoint was created or updated.</p>
    pub fn effective_date(&self) -> std::option::Option<&str> {
        self.effective_date.as_deref()
    }
    /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&str> {
        self.endpoint_status.as_deref()
    }
    /// <p>The unique identifier for the endpoint in the context of the batch.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The geographic information for the endpoint.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::EndpointLocation> {
        self.location.as_ref()
    }
    /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
    pub fn metrics(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.metrics.as_ref()
    }
    /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
    pub fn opt_out(&self) -> std::option::Option<&str> {
        self.opt_out.as_deref()
    }
    /// <p>The unique identifier for the request to create or update the endpoint.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::EndpointUser> {
        self.user.as_ref()
    }
}
impl std::fmt::Debug for EndpointBatchItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointBatchItem");
        formatter.field("address", &self.address);
        formatter.field("attributes", &self.attributes);
        formatter.field("channel_type", &self.channel_type);
        formatter.field("demographic", &self.demographic);
        formatter.field("effective_date", &self.effective_date);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("id", &self.id);
        formatter.field("location", &self.location);
        formatter.field("metrics", &self.metrics);
        formatter.field("opt_out", &self.opt_out);
        formatter.field("request_id", &self.request_id);
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`EndpointBatchItem`](crate::model::EndpointBatchItem)
pub mod endpoint_batch_item {
    /// A builder for [`EndpointBatchItem`](crate::model::EndpointBatchItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) channel_type: std::option::Option<crate::model::ChannelType>,
        pub(crate) demographic: std::option::Option<crate::model::EndpointDemographic>,
        pub(crate) effective_date: std::option::Option<std::string::String>,
        pub(crate) endpoint_status: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::EndpointLocation>,
        pub(crate) metrics:
            std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        pub(crate) opt_out: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) user: std::option::Option<crate::model::EndpointUser>,
    }
    impl Builder {
        /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
        pub fn channel_type(mut self, input: crate::model::ChannelType) -> Self {
            self.channel_type = Some(input);
            self
        }
        /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
        pub fn set_channel_type(
            mut self,
            input: std::option::Option<crate::model::ChannelType>,
        ) -> Self {
            self.channel_type = input;
            self
        }
        /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
        pub fn demographic(mut self, input: crate::model::EndpointDemographic) -> Self {
            self.demographic = Some(input);
            self
        }
        /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
        pub fn set_demographic(
            mut self,
            input: std::option::Option<crate::model::EndpointDemographic>,
        ) -> Self {
            self.demographic = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the endpoint was created or updated.</p>
        pub fn effective_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the endpoint was created or updated.</p>
        pub fn set_effective_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_date = input;
            self
        }
        /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
        pub fn endpoint_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_status = Some(input.into());
            self
        }
        /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>The unique identifier for the endpoint in the context of the batch.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the endpoint in the context of the batch.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The geographic information for the endpoint.</p>
        pub fn location(mut self, input: crate::model::EndpointLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The geographic information for the endpoint.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::EndpointLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Adds a key-value pair to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
        pub fn metrics(mut self, k: impl Into<std::string::String>, v: impl Into<f64>) -> Self {
            let mut hash_map = self.metrics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metrics = Some(hash_map);
            self
        }
        /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
        pub fn opt_out(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out = Some(input.into());
            self
        }
        /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
        pub fn set_opt_out(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opt_out = input;
            self
        }
        /// <p>The unique identifier for the request to create or update the endpoint.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request to create or update the endpoint.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
        pub fn user(mut self, input: crate::model::EndpointUser) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::EndpointUser>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointBatchItem`](crate::model::EndpointBatchItem)
        pub fn build(self) -> crate::model::EndpointBatchItem {
            crate::model::EndpointBatchItem {
                address: self.address,
                attributes: self.attributes,
                channel_type: self.channel_type,
                demographic: self.demographic,
                effective_date: self.effective_date,
                endpoint_status: self.endpoint_status,
                id: self.id,
                location: self.location,
                metrics: self.metrics,
                opt_out: self.opt_out,
                request_id: self.request_id,
                user: self.user,
            }
        }
    }
}
impl EndpointBatchItem {
    /// Creates a new builder-style object to manufacture [`EndpointBatchItem`](crate::model::EndpointBatchItem)
    pub fn builder() -> crate::model::endpoint_batch_item::Builder {
        crate::model::endpoint_batch_item::Builder::default()
    }
}

/// <p>Specifies data for one or more attributes that describe the user who's associated with an endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointUser {
    /// <p>One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
    pub user_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The unique identifier for the user.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl EndpointUser {
    /// <p>One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
    pub fn user_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.user_attributes.as_ref()
    }
    /// <p>The unique identifier for the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for EndpointUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointUser");
        formatter.field("user_attributes", &self.user_attributes);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`EndpointUser`](crate::model::EndpointUser)
pub mod endpoint_user {
    /// A builder for [`EndpointUser`](crate::model::EndpointUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
        pub fn user_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.user_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_attributes = Some(hash_map);
            self
        }
        /// <p>One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointUser`](crate::model::EndpointUser)
        pub fn build(self) -> crate::model::EndpointUser {
            crate::model::EndpointUser {
                user_attributes: self.user_attributes,
                user_id: self.user_id,
            }
        }
    }
}
impl EndpointUser {
    /// Creates a new builder-style object to manufacture [`EndpointUser`](crate::model::EndpointUser)
    pub fn builder() -> crate::model::endpoint_user::Builder {
        crate::model::endpoint_user::Builder::default()
    }
}

/// <p>Specifies geographic information about an endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointLocation {
    /// <p>The name of the city where the endpoint is located.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is located. For example, US for the United States.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The latitude coordinate of the endpoint location, rounded to one decimal place.</p>
    pub latitude: f64,
    /// <p>The longitude coordinate of the endpoint location, rounded to one decimal place.</p>
    pub longitude: f64,
    /// <p>The postal or ZIP code for the area where the endpoint is located.</p>
    pub postal_code: std::option::Option<std::string::String>,
    /// <p>The name of the region where the endpoint is located. For locations in the United States, this value is the name of a state.</p>
    pub region: std::option::Option<std::string::String>,
}
impl EndpointLocation {
    /// <p>The name of the city where the endpoint is located.</p>
    pub fn city(&self) -> std::option::Option<&str> {
        self.city.as_deref()
    }
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is located. For example, US for the United States.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>The latitude coordinate of the endpoint location, rounded to one decimal place.</p>
    pub fn latitude(&self) -> f64 {
        self.latitude
    }
    /// <p>The longitude coordinate of the endpoint location, rounded to one decimal place.</p>
    pub fn longitude(&self) -> f64 {
        self.longitude
    }
    /// <p>The postal or ZIP code for the area where the endpoint is located.</p>
    pub fn postal_code(&self) -> std::option::Option<&str> {
        self.postal_code.as_deref()
    }
    /// <p>The name of the region where the endpoint is located. For locations in the United States, this value is the name of a state.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for EndpointLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointLocation");
        formatter.field("city", &self.city);
        formatter.field("country", &self.country);
        formatter.field("latitude", &self.latitude);
        formatter.field("longitude", &self.longitude);
        formatter.field("postal_code", &self.postal_code);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`EndpointLocation`](crate::model::EndpointLocation)
pub mod endpoint_location {
    /// A builder for [`EndpointLocation`](crate::model::EndpointLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) latitude: std::option::Option<f64>,
        pub(crate) longitude: std::option::Option<f64>,
        pub(crate) postal_code: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the city where the endpoint is located.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The name of the city where the endpoint is located.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is located. For example, US for the United States.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is located. For example, US for the United States.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The latitude coordinate of the endpoint location, rounded to one decimal place.</p>
        pub fn latitude(mut self, input: f64) -> Self {
            self.latitude = Some(input);
            self
        }
        /// <p>The latitude coordinate of the endpoint location, rounded to one decimal place.</p>
        pub fn set_latitude(mut self, input: std::option::Option<f64>) -> Self {
            self.latitude = input;
            self
        }
        /// <p>The longitude coordinate of the endpoint location, rounded to one decimal place.</p>
        pub fn longitude(mut self, input: f64) -> Self {
            self.longitude = Some(input);
            self
        }
        /// <p>The longitude coordinate of the endpoint location, rounded to one decimal place.</p>
        pub fn set_longitude(mut self, input: std::option::Option<f64>) -> Self {
            self.longitude = input;
            self
        }
        /// <p>The postal or ZIP code for the area where the endpoint is located.</p>
        pub fn postal_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.postal_code = Some(input.into());
            self
        }
        /// <p>The postal or ZIP code for the area where the endpoint is located.</p>
        pub fn set_postal_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.postal_code = input;
            self
        }
        /// <p>The name of the region where the endpoint is located. For locations in the United States, this value is the name of a state.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the region where the endpoint is located. For locations in the United States, this value is the name of a state.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointLocation`](crate::model::EndpointLocation)
        pub fn build(self) -> crate::model::EndpointLocation {
            crate::model::EndpointLocation {
                city: self.city,
                country: self.country,
                latitude: self.latitude.unwrap_or_default(),
                longitude: self.longitude.unwrap_or_default(),
                postal_code: self.postal_code,
                region: self.region,
            }
        }
    }
}
impl EndpointLocation {
    /// Creates a new builder-style object to manufacture [`EndpointLocation`](crate::model::EndpointLocation)
    pub fn builder() -> crate::model::endpoint_location::Builder {
        crate::model::endpoint_location::Builder::default()
    }
}

/// <p>Specifies demographic information about an endpoint, such as the applicable time zone and platform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointDemographic {
    /// <p>The version of the app that's associated with the endpoint.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>The manufacturer of the endpoint device, such as apple or samsung.</p>
    pub make: std::option::Option<std::string::String>,
    /// <p>The model name or number of the endpoint device, such as iPhone or SM-G900F.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The model version of the endpoint device.</p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>The platform of the endpoint device, such as ios.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The platform version of the endpoint device.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.</p>
    pub timezone: std::option::Option<std::string::String>,
}
impl EndpointDemographic {
    /// <p>The version of the app that's associated with the endpoint.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
    /// <p>The manufacturer of the endpoint device, such as apple or samsung.</p>
    pub fn make(&self) -> std::option::Option<&str> {
        self.make.as_deref()
    }
    /// <p>The model name or number of the endpoint device, such as iPhone or SM-G900F.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The model version of the endpoint device.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>The platform of the endpoint device, such as ios.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The platform version of the endpoint device.</p>
    pub fn platform_version(&self) -> std::option::Option<&str> {
        self.platform_version.as_deref()
    }
    /// <p>The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
}
impl std::fmt::Debug for EndpointDemographic {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointDemographic");
        formatter.field("app_version", &self.app_version);
        formatter.field("locale", &self.locale);
        formatter.field("make", &self.make);
        formatter.field("model", &self.model);
        formatter.field("model_version", &self.model_version);
        formatter.field("platform", &self.platform);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("timezone", &self.timezone);
        formatter.finish()
    }
}
/// See [`EndpointDemographic`](crate::model::EndpointDemographic)
pub mod endpoint_demographic {
    /// A builder for [`EndpointDemographic`](crate::model::EndpointDemographic)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) make: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version of the app that's associated with the endpoint.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the app that's associated with the endpoint.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The manufacturer of the endpoint device, such as apple or samsung.</p>
        pub fn make(mut self, input: impl Into<std::string::String>) -> Self {
            self.make = Some(input.into());
            self
        }
        /// <p>The manufacturer of the endpoint device, such as apple or samsung.</p>
        pub fn set_make(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.make = input;
            self
        }
        /// <p>The model name or number of the endpoint device, such as iPhone or SM-G900F.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The model name or number of the endpoint device, such as iPhone or SM-G900F.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The model version of the endpoint device.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The model version of the endpoint device.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>The platform of the endpoint device, such as ios.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the endpoint device, such as ios.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The platform version of the endpoint device.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version of the endpoint device.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointDemographic`](crate::model::EndpointDemographic)
        pub fn build(self) -> crate::model::EndpointDemographic {
            crate::model::EndpointDemographic {
                app_version: self.app_version,
                locale: self.locale,
                make: self.make,
                model: self.model,
                model_version: self.model_version,
                platform: self.platform,
                platform_version: self.platform_version,
                timezone: self.timezone,
            }
        }
    }
}
impl EndpointDemographic {
    /// Creates a new builder-style object to manufacture [`EndpointDemographic`](crate::model::EndpointDemographic)
    pub fn builder() -> crate::model::endpoint_demographic::Builder {
        crate::model::endpoint_demographic::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelType {
    #[allow(missing_docs)] // documentation missing in model
    Adm,
    #[allow(missing_docs)] // documentation missing in model
    Apns,
    #[allow(missing_docs)] // documentation missing in model
    ApnsSandbox,
    #[allow(missing_docs)] // documentation missing in model
    ApnsVoip,
    #[allow(missing_docs)] // documentation missing in model
    ApnsVoipSandbox,
    #[allow(missing_docs)] // documentation missing in model
    Baidu,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Gcm,
    #[allow(missing_docs)] // documentation missing in model
    InApp,
    #[allow(missing_docs)] // documentation missing in model
    Push,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelType {
    fn from(s: &str) -> Self {
        match s {
            "ADM" => ChannelType::Adm,
            "APNS" => ChannelType::Apns,
            "APNS_SANDBOX" => ChannelType::ApnsSandbox,
            "APNS_VOIP" => ChannelType::ApnsVoip,
            "APNS_VOIP_SANDBOX" => ChannelType::ApnsVoipSandbox,
            "BAIDU" => ChannelType::Baidu,
            "CUSTOM" => ChannelType::Custom,
            "EMAIL" => ChannelType::Email,
            "GCM" => ChannelType::Gcm,
            "IN_APP" => ChannelType::InApp,
            "PUSH" => ChannelType::Push,
            "SMS" => ChannelType::Sms,
            "VOICE" => ChannelType::Voice,
            other => ChannelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelType::from(s))
    }
}
impl ChannelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelType::Adm => "ADM",
            ChannelType::Apns => "APNS",
            ChannelType::ApnsSandbox => "APNS_SANDBOX",
            ChannelType::ApnsVoip => "APNS_VOIP",
            ChannelType::ApnsVoipSandbox => "APNS_VOIP_SANDBOX",
            ChannelType::Baidu => "BAIDU",
            ChannelType::Custom => "CUSTOM",
            ChannelType::Email => "EMAIL",
            ChannelType::Gcm => "GCM",
            ChannelType::InApp => "IN_APP",
            ChannelType::Push => "PUSH",
            ChannelType::Sms => "SMS",
            ChannelType::Voice => "VOICE",
            ChannelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADM",
            "APNS",
            "APNS_SANDBOX",
            "APNS_VOIP",
            "APNS_VOIP_SANDBOX",
            "BAIDU",
            "CUSTOM",
            "EMAIL",
            "GCM",
            "IN_APP",
            "PUSH",
            "SMS",
            "VOICE",
        ]
    }
}
impl AsRef<str> for ChannelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the channel type and other settings for an endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointRequest {
    /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
    pub channel_type: std::option::Option<crate::model::ChannelType>,
    /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
    pub demographic: std::option::Option<crate::model::EndpointDemographic>,
    /// <p>The date and time, in ISO 8601 format, when the endpoint is updated.</p>
    pub effective_date: std::option::Option<std::string::String>,
    /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
    pub endpoint_status: std::option::Option<std::string::String>,
    /// <p>The geographic information for the endpoint.</p>
    pub location: std::option::Option<crate::model::EndpointLocation>,
    /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
    pub metrics: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
    pub opt_out: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the most recent request to update the endpoint.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
    pub user: std::option::Option<crate::model::EndpointUser>,
}
impl EndpointRequest {
    /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
    pub fn channel_type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.channel_type.as_ref()
    }
    /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
    pub fn demographic(&self) -> std::option::Option<&crate::model::EndpointDemographic> {
        self.demographic.as_ref()
    }
    /// <p>The date and time, in ISO 8601 format, when the endpoint is updated.</p>
    pub fn effective_date(&self) -> std::option::Option<&str> {
        self.effective_date.as_deref()
    }
    /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&str> {
        self.endpoint_status.as_deref()
    }
    /// <p>The geographic information for the endpoint.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::EndpointLocation> {
        self.location.as_ref()
    }
    /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
    pub fn metrics(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.metrics.as_ref()
    }
    /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
    pub fn opt_out(&self) -> std::option::Option<&str> {
        self.opt_out.as_deref()
    }
    /// <p>The unique identifier for the most recent request to update the endpoint.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::EndpointUser> {
        self.user.as_ref()
    }
}
impl std::fmt::Debug for EndpointRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointRequest");
        formatter.field("address", &self.address);
        formatter.field("attributes", &self.attributes);
        formatter.field("channel_type", &self.channel_type);
        formatter.field("demographic", &self.demographic);
        formatter.field("effective_date", &self.effective_date);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("location", &self.location);
        formatter.field("metrics", &self.metrics);
        formatter.field("opt_out", &self.opt_out);
        formatter.field("request_id", &self.request_id);
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`EndpointRequest`](crate::model::EndpointRequest)
pub mod endpoint_request {
    /// A builder for [`EndpointRequest`](crate::model::EndpointRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) channel_type: std::option::Option<crate::model::ChannelType>,
        pub(crate) demographic: std::option::Option<crate::model::EndpointDemographic>,
        pub(crate) effective_date: std::option::Option<std::string::String>,
        pub(crate) endpoint_status: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::EndpointLocation>,
        pub(crate) metrics:
            std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        pub(crate) opt_out: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) user: std::option::Option<crate::model::EndpointUser>,
    }
    impl Builder {
        /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
        pub fn channel_type(mut self, input: crate::model::ChannelType) -> Self {
            self.channel_type = Some(input);
            self
        }
        /// <p>The channel to use when sending messages or push notifications to the endpoint.</p>
        pub fn set_channel_type(
            mut self,
            input: std::option::Option<crate::model::ChannelType>,
        ) -> Self {
            self.channel_type = input;
            self
        }
        /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
        pub fn demographic(mut self, input: crate::model::EndpointDemographic) -> Self {
            self.demographic = Some(input);
            self
        }
        /// <p>The demographic information for the endpoint, such as the time zone and platform.</p>
        pub fn set_demographic(
            mut self,
            input: std::option::Option<crate::model::EndpointDemographic>,
        ) -> Self {
            self.demographic = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the endpoint is updated.</p>
        pub fn effective_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the endpoint is updated.</p>
        pub fn set_effective_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_date = input;
            self
        }
        /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
        pub fn endpoint_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_status = Some(input.into());
            self
        }
        /// <p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>The geographic information for the endpoint.</p>
        pub fn location(mut self, input: crate::model::EndpointLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The geographic information for the endpoint.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::EndpointLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Adds a key-value pair to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
        pub fn metrics(mut self, k: impl Into<std::string::String>, v: impl Into<f64>) -> Self {
            let mut hash_map = self.metrics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metrics = Some(hash_map);
            self
        }
        /// <p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
        pub fn opt_out(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_out = Some(input.into());
            self
        }
        /// <p>Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.</p>
        pub fn set_opt_out(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opt_out = input;
            self
        }
        /// <p>The unique identifier for the most recent request to update the endpoint.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the most recent request to update the endpoint.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
        pub fn user(mut self, input: crate::model::EndpointUser) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>One or more custom attributes that describe the user who's associated with the endpoint.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::EndpointUser>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointRequest`](crate::model::EndpointRequest)
        pub fn build(self) -> crate::model::EndpointRequest {
            crate::model::EndpointRequest {
                address: self.address,
                attributes: self.attributes,
                channel_type: self.channel_type,
                demographic: self.demographic,
                effective_date: self.effective_date,
                endpoint_status: self.endpoint_status,
                location: self.location,
                metrics: self.metrics,
                opt_out: self.opt_out,
                request_id: self.request_id,
                user: self.user,
            }
        }
    }
}
impl EndpointRequest {
    /// Creates a new builder-style object to manufacture [`EndpointRequest`](crate::model::EndpointRequest)
    pub fn builder() -> crate::model::endpoint_request::Builder {
        crate::model::endpoint_request::Builder::default()
    }
}

/// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailTemplateRequest {
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub default_substitutions: std::option::Option<std::string::String>,
    /// <p>The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.</p>
    pub html_part: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
    pub recommender_id: std::option::Option<std::string::String>,
    /// <p>The subject line, or title, to use in email messages that are based on the message template.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A custom description of the message template.</p>
    pub template_description: std::option::Option<std::string::String>,
    /// <p>The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.</p>
    pub text_part: std::option::Option<std::string::String>,
}
impl EmailTemplateRequest {
    /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
    pub fn default_substitutions(&self) -> std::option::Option<&str> {
        self.default_substitutions.as_deref()
    }
    /// <p>The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.</p>
    pub fn html_part(&self) -> std::option::Option<&str> {
        self.html_part.as_deref()
    }
    /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
    pub fn recommender_id(&self) -> std::option::Option<&str> {
        self.recommender_id.as_deref()
    }
    /// <p>The subject line, or title, to use in email messages that are based on the message template.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A custom description of the message template.</p>
    pub fn template_description(&self) -> std::option::Option<&str> {
        self.template_description.as_deref()
    }
    /// <p>The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.</p>
    pub fn text_part(&self) -> std::option::Option<&str> {
        self.text_part.as_deref()
    }
}
impl std::fmt::Debug for EmailTemplateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailTemplateRequest");
        formatter.field("default_substitutions", &self.default_substitutions);
        formatter.field("html_part", &self.html_part);
        formatter.field("recommender_id", &self.recommender_id);
        formatter.field("subject", &self.subject);
        formatter.field("tags", &self.tags);
        formatter.field("template_description", &self.template_description);
        formatter.field("text_part", &self.text_part);
        formatter.finish()
    }
}
/// See [`EmailTemplateRequest`](crate::model::EmailTemplateRequest)
pub mod email_template_request {
    /// A builder for [`EmailTemplateRequest`](crate::model::EmailTemplateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_substitutions: std::option::Option<std::string::String>,
        pub(crate) html_part: std::option::Option<std::string::String>,
        pub(crate) recommender_id: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_description: std::option::Option<std::string::String>,
        pub(crate) text_part: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn default_substitutions(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_substitutions = Some(input.into());
            self
        }
        /// <p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>
        pub fn set_default_substitutions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_substitutions = input;
            self
        }
        /// <p>The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.</p>
        pub fn html_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.html_part = Some(input.into());
            self
        }
        /// <p>The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.</p>
        pub fn set_html_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.html_part = input;
            self
        }
        /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
        pub fn recommender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_id = input;
            self
        }
        /// <p>The subject line, or title, to use in email messages that are based on the message template.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject line, or title, to use in email messages that are based on the message template.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn template_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_description = Some(input.into());
            self
        }
        /// <p>A custom description of the message template.</p>
        pub fn set_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_description = input;
            self
        }
        /// <p>The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.</p>
        pub fn text_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.text_part = Some(input.into());
            self
        }
        /// <p>The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.</p>
        pub fn set_text_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text_part = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailTemplateRequest`](crate::model::EmailTemplateRequest)
        pub fn build(self) -> crate::model::EmailTemplateRequest {
            crate::model::EmailTemplateRequest {
                default_substitutions: self.default_substitutions,
                html_part: self.html_part,
                recommender_id: self.recommender_id,
                subject: self.subject,
                tags: self.tags,
                template_description: self.template_description,
                text_part: self.text_part,
            }
        }
    }
}
impl EmailTemplateRequest {
    /// Creates a new builder-style object to manufacture [`EmailTemplateRequest`](crate::model::EmailTemplateRequest)
    pub fn builder() -> crate::model::email_template_request::Builder {
        crate::model::email_template_request::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the email channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailChannelResponse {
    /// <p>The unique identifier for the application that the email channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that's applied to messages that are sent through the channel.</p>
    pub configuration_set: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when the email channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>Specifies whether the email channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>The verified email address that email is sent from when you send email through the channel.</p>
    pub from_address: std::option::Option<std::string::String>,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>(Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's used when you send email through the channel.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>Specifies whether the email channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the email channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO 8601 format, when the email channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The maximum number of emails that can be sent through the channel each second.</p>
    pub messages_per_second: i32,
    /// <p>The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The current version of the email channel.</p>
    pub version: i32,
}
impl EmailChannelResponse {
    /// <p>The unique identifier for the application that the email channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that's applied to messages that are sent through the channel.</p>
    pub fn configuration_set(&self) -> std::option::Option<&str> {
        self.configuration_set.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when the email channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>Specifies whether the email channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The verified email address that email is sent from when you send email through the channel.</p>
    pub fn from_address(&self) -> std::option::Option<&str> {
        self.from_address.as_deref()
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>(Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's used when you send email through the channel.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>Specifies whether the email channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the email channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time, in ISO 8601 format, when the email channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The maximum number of emails that can be sent through the channel each second.</p>
    pub fn messages_per_second(&self) -> i32 {
        self.messages_per_second
    }
    /// <p>The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The current version of the email channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for EmailChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("configuration_set", &self.configuration_set);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("enabled", &self.enabled);
        formatter.field("from_address", &self.from_address);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("id", &self.id);
        formatter.field("identity", &self.identity);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("messages_per_second", &self.messages_per_second);
        formatter.field("platform", &self.platform);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`EmailChannelResponse`](crate::model::EmailChannelResponse)
pub mod email_channel_response {
    /// A builder for [`EmailChannelResponse`](crate::model::EmailChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) configuration_set: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) from_address: std::option::Option<std::string::String>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) messages_per_second: std::option::Option<i32>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the email channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the email channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that's applied to messages that are sent through the channel.</p>
        pub fn configuration_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that's applied to messages that are sent through the channel.</p>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the email channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the email channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Specifies whether the email channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the email channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The verified email address that email is sent from when you send email through the channel.</p>
        pub fn from_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_address = Some(input.into());
            self
        }
        /// <p>The verified email address that email is sent from when you send email through the channel.</p>
        pub fn set_from_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_address = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>(Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's used when you send email through the channel.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's used when you send email through the channel.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>Specifies whether the email channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the email channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the email channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the email channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the email channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the email channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The maximum number of emails that can be sent through the channel each second.</p>
        pub fn messages_per_second(mut self, input: i32) -> Self {
            self.messages_per_second = Some(input);
            self
        }
        /// <p>The maximum number of emails that can be sent through the channel each second.</p>
        pub fn set_messages_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.messages_per_second = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The current version of the email channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the email channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailChannelResponse`](crate::model::EmailChannelResponse)
        pub fn build(self) -> crate::model::EmailChannelResponse {
            crate::model::EmailChannelResponse {
                application_id: self.application_id,
                configuration_set: self.configuration_set,
                creation_date: self.creation_date,
                enabled: self.enabled.unwrap_or_default(),
                from_address: self.from_address,
                has_credential: self.has_credential.unwrap_or_default(),
                id: self.id,
                identity: self.identity,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                messages_per_second: self.messages_per_second.unwrap_or_default(),
                platform: self.platform,
                role_arn: self.role_arn,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl EmailChannelResponse {
    /// Creates a new builder-style object to manufacture [`EmailChannelResponse`](crate::model::EmailChannelResponse)
    pub fn builder() -> crate::model::email_channel_response::Builder {
        crate::model::email_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the email channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailChannelRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that you want to apply to messages that you send through the channel.</p>
    pub configuration_set: std::option::Option<std::string::String>,
    /// <p>Specifies whether to enable the email channel for the application.</p>
    pub enabled: bool,
    /// <p>The verified email address that you want to send email from when you send email through the channel.</p>
    pub from_address: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl EmailChannelRequest {
    /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that you want to apply to messages that you send through the channel.</p>
    pub fn configuration_set(&self) -> std::option::Option<&str> {
        self.configuration_set.as_deref()
    }
    /// <p>Specifies whether to enable the email channel for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The verified email address that you want to send email from when you send email through the channel.</p>
    pub fn from_address(&self) -> std::option::Option<&str> {
        self.from_address.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for EmailChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailChannelRequest");
        formatter.field("configuration_set", &self.configuration_set);
        formatter.field("enabled", &self.enabled);
        formatter.field("from_address", &self.from_address);
        formatter.field("identity", &self.identity);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`EmailChannelRequest`](crate::model::EmailChannelRequest)
pub mod email_channel_request {
    /// A builder for [`EmailChannelRequest`](crate::model::EmailChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) from_address: std::option::Option<std::string::String>,
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that you want to apply to messages that you send through the channel.</p>
        pub fn configuration_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that you want to apply to messages that you send through the channel.</p>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set = input;
            self
        }
        /// <p>Specifies whether to enable the email channel for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the email channel for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The verified email address that you want to send email from when you send email through the channel.</p>
        pub fn from_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_address = Some(input.into());
            self
        }
        /// <p>The verified email address that you want to send email from when you send email through the channel.</p>
        pub fn set_from_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_address = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailChannelRequest`](crate::model::EmailChannelRequest)
        pub fn build(self) -> crate::model::EmailChannelRequest {
            crate::model::EmailChannelRequest {
                configuration_set: self.configuration_set,
                enabled: self.enabled.unwrap_or_default(),
                from_address: self.from_address,
                identity: self.identity,
                role_arn: self.role_arn,
            }
        }
    }
}
impl EmailChannelRequest {
    /// Creates a new builder-style object to manufacture [`EmailChannelRequest`](crate::model::EmailChannelRequest)
    pub fn builder() -> crate::model::email_channel_request::Builder {
        crate::model::email_channel_request::Builder::default()
    }
}

/// <p>Provides information about the status, configuration, and other settings for a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignResponse {
    /// <p>An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.</p>
    pub additional_treatments: std::option::Option<std::vec::Vec<crate::model::TreatmentResource>>,
    /// <p>The unique identifier for the application that the campaign applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date, in ISO 8601 format, when the campaign was created.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The delivery configuration settings for sending the campaign through a custom channel.</p>
    pub custom_delivery_configuration:
        std::option::Option<crate::model::CustomDeliveryConfiguration>,
    /// <p>The current status of the campaign's default treatment. This value exists only for campaigns that have more than one treatment.</p>
    pub default_state: std::option::Option<crate::model::CampaignState>,
    /// <p>The custom description of the campaign.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
    pub holdout_percent: i32,
    /// <p>The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
    pub hook: std::option::Option<crate::model::CampaignHook>,
    /// <p>The unique identifier for the campaign.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
    pub is_paused: bool,
    /// <p>The date, in ISO 8601 format, when the campaign was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The messaging limits for the campaign.</p>
    pub limits: std::option::Option<crate::model::CampaignLimits>,
    /// <p>The message configuration settings for the campaign.</p>
    pub message_configuration: std::option::Option<crate::model::MessageConfiguration>,
    /// <p>The name of the campaign.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schedule settings for the campaign.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The unique identifier for the segment that's associated with the campaign.</p>
    pub segment_id: std::option::Option<std::string::String>,
    /// <p>The version number of the segment that's associated with the campaign.</p>
    pub segment_version: i32,
    /// <p>The current status of the campaign.</p>
    pub state: std::option::Option<crate::model::CampaignState>,
    /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The message template that’s used for the campaign.</p>
    pub template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
    /// <p>The custom description of the default treatment for the campaign.</p>
    pub treatment_description: std::option::Option<std::string::String>,
    /// <p>The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
    pub treatment_name: std::option::Option<std::string::String>,
    /// <p>The version number of the campaign.</p>
    pub version: i32,
    /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
    pub priority: i32,
}
impl CampaignResponse {
    /// <p>An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.</p>
    pub fn additional_treatments(&self) -> std::option::Option<&[crate::model::TreatmentResource]> {
        self.additional_treatments.as_deref()
    }
    /// <p>The unique identifier for the application that the campaign applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date, in ISO 8601 format, when the campaign was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The delivery configuration settings for sending the campaign through a custom channel.</p>
    pub fn custom_delivery_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDeliveryConfiguration> {
        self.custom_delivery_configuration.as_ref()
    }
    /// <p>The current status of the campaign's default treatment. This value exists only for campaigns that have more than one treatment.</p>
    pub fn default_state(&self) -> std::option::Option<&crate::model::CampaignState> {
        self.default_state.as_ref()
    }
    /// <p>The custom description of the campaign.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
    pub fn holdout_percent(&self) -> i32 {
        self.holdout_percent
    }
    /// <p>The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
    pub fn hook(&self) -> std::option::Option<&crate::model::CampaignHook> {
        self.hook.as_ref()
    }
    /// <p>The unique identifier for the campaign.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
    pub fn is_paused(&self) -> bool {
        self.is_paused
    }
    /// <p>The date, in ISO 8601 format, when the campaign was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The messaging limits for the campaign.</p>
    pub fn limits(&self) -> std::option::Option<&crate::model::CampaignLimits> {
        self.limits.as_ref()
    }
    /// <p>The message configuration settings for the campaign.</p>
    pub fn message_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MessageConfiguration> {
        self.message_configuration.as_ref()
    }
    /// <p>The name of the campaign.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schedule settings for the campaign.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p>The unique identifier for the segment that's associated with the campaign.</p>
    pub fn segment_id(&self) -> std::option::Option<&str> {
        self.segment_id.as_deref()
    }
    /// <p>The version number of the segment that's associated with the campaign.</p>
    pub fn segment_version(&self) -> i32 {
        self.segment_version
    }
    /// <p>The current status of the campaign.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CampaignState> {
        self.state.as_ref()
    }
    /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The message template that’s used for the campaign.</p>
    pub fn template_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TemplateConfiguration> {
        self.template_configuration.as_ref()
    }
    /// <p>The custom description of the default treatment for the campaign.</p>
    pub fn treatment_description(&self) -> std::option::Option<&str> {
        self.treatment_description.as_deref()
    }
    /// <p>The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
    pub fn treatment_name(&self) -> std::option::Option<&str> {
        self.treatment_name.as_deref()
    }
    /// <p>The version number of the campaign.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
    /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for CampaignResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignResponse");
        formatter.field("additional_treatments", &self.additional_treatments);
        formatter.field("application_id", &self.application_id);
        formatter.field("arn", &self.arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field(
            "custom_delivery_configuration",
            &self.custom_delivery_configuration,
        );
        formatter.field("default_state", &self.default_state);
        formatter.field("description", &self.description);
        formatter.field("holdout_percent", &self.holdout_percent);
        formatter.field("hook", &self.hook);
        formatter.field("id", &self.id);
        formatter.field("is_paused", &self.is_paused);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("limits", &self.limits);
        formatter.field("message_configuration", &self.message_configuration);
        formatter.field("name", &self.name);
        formatter.field("schedule", &self.schedule);
        formatter.field("segment_id", &self.segment_id);
        formatter.field("segment_version", &self.segment_version);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("template_configuration", &self.template_configuration);
        formatter.field("treatment_description", &self.treatment_description);
        formatter.field("treatment_name", &self.treatment_name);
        formatter.field("version", &self.version);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`CampaignResponse`](crate::model::CampaignResponse)
pub mod campaign_response {
    /// A builder for [`CampaignResponse`](crate::model::CampaignResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_treatments:
            std::option::Option<std::vec::Vec<crate::model::TreatmentResource>>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) custom_delivery_configuration:
            std::option::Option<crate::model::CustomDeliveryConfiguration>,
        pub(crate) default_state: std::option::Option<crate::model::CampaignState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) holdout_percent: std::option::Option<i32>,
        pub(crate) hook: std::option::Option<crate::model::CampaignHook>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_paused: std::option::Option<bool>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) limits: std::option::Option<crate::model::CampaignLimits>,
        pub(crate) message_configuration: std::option::Option<crate::model::MessageConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) segment_version: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::CampaignState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
        pub(crate) treatment_description: std::option::Option<std::string::String>,
        pub(crate) treatment_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `additional_treatments`.
        ///
        /// To override the contents of this collection use [`set_additional_treatments`](Self::set_additional_treatments).
        ///
        /// <p>An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.</p>
        pub fn additional_treatments(
            mut self,
            input: impl Into<crate::model::TreatmentResource>,
        ) -> Self {
            let mut v = self.additional_treatments.unwrap_or_default();
            v.push(input.into());
            self.additional_treatments = Some(v);
            self
        }
        /// <p>An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.</p>
        pub fn set_additional_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TreatmentResource>>,
        ) -> Self {
            self.additional_treatments = input;
            self
        }
        /// <p>The unique identifier for the application that the campaign applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the campaign applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date, in ISO 8601 format, when the campaign was created.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date, in ISO 8601 format, when the campaign was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The delivery configuration settings for sending the campaign through a custom channel.</p>
        pub fn custom_delivery_configuration(
            mut self,
            input: crate::model::CustomDeliveryConfiguration,
        ) -> Self {
            self.custom_delivery_configuration = Some(input);
            self
        }
        /// <p>The delivery configuration settings for sending the campaign through a custom channel.</p>
        pub fn set_custom_delivery_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDeliveryConfiguration>,
        ) -> Self {
            self.custom_delivery_configuration = input;
            self
        }
        /// <p>The current status of the campaign's default treatment. This value exists only for campaigns that have more than one treatment.</p>
        pub fn default_state(mut self, input: crate::model::CampaignState) -> Self {
            self.default_state = Some(input);
            self
        }
        /// <p>The current status of the campaign's default treatment. This value exists only for campaigns that have more than one treatment.</p>
        pub fn set_default_state(
            mut self,
            input: std::option::Option<crate::model::CampaignState>,
        ) -> Self {
            self.default_state = input;
            self
        }
        /// <p>The custom description of the campaign.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The custom description of the campaign.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
        pub fn holdout_percent(mut self, input: i32) -> Self {
            self.holdout_percent = Some(input);
            self
        }
        /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
        pub fn set_holdout_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.holdout_percent = input;
            self
        }
        /// <p>The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
        pub fn hook(mut self, input: crate::model::CampaignHook) -> Self {
            self.hook = Some(input);
            self
        }
        /// <p>The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
        pub fn set_hook(mut self, input: std::option::Option<crate::model::CampaignHook>) -> Self {
            self.hook = input;
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
        pub fn is_paused(mut self, input: bool) -> Self {
            self.is_paused = Some(input);
            self
        }
        /// <p>Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
        pub fn set_is_paused(mut self, input: std::option::Option<bool>) -> Self {
            self.is_paused = input;
            self
        }
        /// <p>The date, in ISO 8601 format, when the campaign was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date, in ISO 8601 format, when the campaign was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The messaging limits for the campaign.</p>
        pub fn limits(mut self, input: crate::model::CampaignLimits) -> Self {
            self.limits = Some(input);
            self
        }
        /// <p>The messaging limits for the campaign.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<crate::model::CampaignLimits>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>The message configuration settings for the campaign.</p>
        pub fn message_configuration(mut self, input: crate::model::MessageConfiguration) -> Self {
            self.message_configuration = Some(input);
            self
        }
        /// <p>The message configuration settings for the campaign.</p>
        pub fn set_message_configuration(
            mut self,
            input: std::option::Option<crate::model::MessageConfiguration>,
        ) -> Self {
            self.message_configuration = input;
            self
        }
        /// <p>The name of the campaign.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the campaign.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schedule settings for the campaign.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule settings for the campaign.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The unique identifier for the segment that's associated with the campaign.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment that's associated with the campaign.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>The version number of the segment that's associated with the campaign.</p>
        pub fn segment_version(mut self, input: i32) -> Self {
            self.segment_version = Some(input);
            self
        }
        /// <p>The version number of the segment that's associated with the campaign.</p>
        pub fn set_segment_version(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_version = input;
            self
        }
        /// <p>The current status of the campaign.</p>
        pub fn state(mut self, input: crate::model::CampaignState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current status of the campaign.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CampaignState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The message template that’s used for the campaign.</p>
        pub fn template_configuration(
            mut self,
            input: crate::model::TemplateConfiguration,
        ) -> Self {
            self.template_configuration = Some(input);
            self
        }
        /// <p>The message template that’s used for the campaign.</p>
        pub fn set_template_configuration(
            mut self,
            input: std::option::Option<crate::model::TemplateConfiguration>,
        ) -> Self {
            self.template_configuration = input;
            self
        }
        /// <p>The custom description of the default treatment for the campaign.</p>
        pub fn treatment_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_description = Some(input.into());
            self
        }
        /// <p>The custom description of the default treatment for the campaign.</p>
        pub fn set_treatment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_description = input;
            self
        }
        /// <p>The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
        pub fn treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_name = Some(input.into());
            self
        }
        /// <p>The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
        pub fn set_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_name = input;
            self
        }
        /// <p>The version number of the campaign.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the campaign.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignResponse`](crate::model::CampaignResponse)
        pub fn build(self) -> crate::model::CampaignResponse {
            crate::model::CampaignResponse {
                additional_treatments: self.additional_treatments,
                application_id: self.application_id,
                arn: self.arn,
                creation_date: self.creation_date,
                custom_delivery_configuration: self.custom_delivery_configuration,
                default_state: self.default_state,
                description: self.description,
                holdout_percent: self.holdout_percent.unwrap_or_default(),
                hook: self.hook,
                id: self.id,
                is_paused: self.is_paused.unwrap_or_default(),
                last_modified_date: self.last_modified_date,
                limits: self.limits,
                message_configuration: self.message_configuration,
                name: self.name,
                schedule: self.schedule,
                segment_id: self.segment_id,
                segment_version: self.segment_version.unwrap_or_default(),
                state: self.state,
                tags: self.tags,
                template_configuration: self.template_configuration,
                treatment_description: self.treatment_description,
                treatment_name: self.treatment_name,
                version: self.version.unwrap_or_default(),
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl CampaignResponse {
    /// Creates a new builder-style object to manufacture [`CampaignResponse`](crate::model::CampaignResponse)
    pub fn builder() -> crate::model::campaign_response::Builder {
        crate::model::campaign_response::Builder::default()
    }
}

/// <p>Specifies the message template to use for the message, for each type of channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateConfiguration {
    /// <p>The email template to use for the message.</p>
    pub email_template: std::option::Option<crate::model::Template>,
    /// <p>The push notification template to use for the message.</p>
    pub push_template: std::option::Option<crate::model::Template>,
    /// <p>The SMS template to use for the message.</p>
    pub sms_template: std::option::Option<crate::model::Template>,
    /// <p>The voice template to use for the message. This object isn't supported for campaigns.</p>
    pub voice_template: std::option::Option<crate::model::Template>,
}
impl TemplateConfiguration {
    /// <p>The email template to use for the message.</p>
    pub fn email_template(&self) -> std::option::Option<&crate::model::Template> {
        self.email_template.as_ref()
    }
    /// <p>The push notification template to use for the message.</p>
    pub fn push_template(&self) -> std::option::Option<&crate::model::Template> {
        self.push_template.as_ref()
    }
    /// <p>The SMS template to use for the message.</p>
    pub fn sms_template(&self) -> std::option::Option<&crate::model::Template> {
        self.sms_template.as_ref()
    }
    /// <p>The voice template to use for the message. This object isn't supported for campaigns.</p>
    pub fn voice_template(&self) -> std::option::Option<&crate::model::Template> {
        self.voice_template.as_ref()
    }
}
impl std::fmt::Debug for TemplateConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateConfiguration");
        formatter.field("email_template", &self.email_template);
        formatter.field("push_template", &self.push_template);
        formatter.field("sms_template", &self.sms_template);
        formatter.field("voice_template", &self.voice_template);
        formatter.finish()
    }
}
/// See [`TemplateConfiguration`](crate::model::TemplateConfiguration)
pub mod template_configuration {
    /// A builder for [`TemplateConfiguration`](crate::model::TemplateConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_template: std::option::Option<crate::model::Template>,
        pub(crate) push_template: std::option::Option<crate::model::Template>,
        pub(crate) sms_template: std::option::Option<crate::model::Template>,
        pub(crate) voice_template: std::option::Option<crate::model::Template>,
    }
    impl Builder {
        /// <p>The email template to use for the message.</p>
        pub fn email_template(mut self, input: crate::model::Template) -> Self {
            self.email_template = Some(input);
            self
        }
        /// <p>The email template to use for the message.</p>
        pub fn set_email_template(
            mut self,
            input: std::option::Option<crate::model::Template>,
        ) -> Self {
            self.email_template = input;
            self
        }
        /// <p>The push notification template to use for the message.</p>
        pub fn push_template(mut self, input: crate::model::Template) -> Self {
            self.push_template = Some(input);
            self
        }
        /// <p>The push notification template to use for the message.</p>
        pub fn set_push_template(
            mut self,
            input: std::option::Option<crate::model::Template>,
        ) -> Self {
            self.push_template = input;
            self
        }
        /// <p>The SMS template to use for the message.</p>
        pub fn sms_template(mut self, input: crate::model::Template) -> Self {
            self.sms_template = Some(input);
            self
        }
        /// <p>The SMS template to use for the message.</p>
        pub fn set_sms_template(
            mut self,
            input: std::option::Option<crate::model::Template>,
        ) -> Self {
            self.sms_template = input;
            self
        }
        /// <p>The voice template to use for the message. This object isn't supported for campaigns.</p>
        pub fn voice_template(mut self, input: crate::model::Template) -> Self {
            self.voice_template = Some(input);
            self
        }
        /// <p>The voice template to use for the message. This object isn't supported for campaigns.</p>
        pub fn set_voice_template(
            mut self,
            input: std::option::Option<crate::model::Template>,
        ) -> Self {
            self.voice_template = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateConfiguration`](crate::model::TemplateConfiguration)
        pub fn build(self) -> crate::model::TemplateConfiguration {
            crate::model::TemplateConfiguration {
                email_template: self.email_template,
                push_template: self.push_template,
                sms_template: self.sms_template,
                voice_template: self.voice_template,
            }
        }
    }
}
impl TemplateConfiguration {
    /// Creates a new builder-style object to manufacture [`TemplateConfiguration`](crate::model::TemplateConfiguration)
    pub fn builder() -> crate::model::template_configuration::Builder {
        crate::model::template_configuration::Builder::default()
    }
}

/// <p>Specifies the name and version of the message template to use for the message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Template {
    /// <p>The name of the message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub version: std::option::Option<std::string::String>,
}
impl Template {
    /// <p>The name of the message template to use for the message. If specified, this value must match the name of an existing message template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for Template {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Template");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`Template`](crate::model::Template)
pub mod template {
    /// A builder for [`Template`](crate::model::Template)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the message template to use for the message. If specified, this value must match the name of an existing message template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`Template`](crate::model::Template)
        pub fn build(self) -> crate::model::Template {
            crate::model::Template {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl Template {
    /// Creates a new builder-style object to manufacture [`Template`](crate::model::Template)
    pub fn builder() -> crate::model::template::Builder {
        crate::model::template::Builder::default()
    }
}

/// <p>Provides information about the status of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignState {
    /// <p>The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.</p> <p>If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has a status of DELETED.</p>
    pub campaign_status: std::option::Option<crate::model::CampaignStatus>,
}
impl CampaignState {
    /// <p>The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.</p> <p>If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has a status of DELETED.</p>
    pub fn campaign_status(&self) -> std::option::Option<&crate::model::CampaignStatus> {
        self.campaign_status.as_ref()
    }
}
impl std::fmt::Debug for CampaignState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignState");
        formatter.field("campaign_status", &self.campaign_status);
        formatter.finish()
    }
}
/// See [`CampaignState`](crate::model::CampaignState)
pub mod campaign_state {
    /// A builder for [`CampaignState`](crate::model::CampaignState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_status: std::option::Option<crate::model::CampaignStatus>,
    }
    impl Builder {
        /// <p>The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.</p> <p>If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has a status of DELETED.</p>
        pub fn campaign_status(mut self, input: crate::model::CampaignStatus) -> Self {
            self.campaign_status = Some(input);
            self
        }
        /// <p>The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.</p> <p>If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has a status of DELETED.</p>
        pub fn set_campaign_status(
            mut self,
            input: std::option::Option<crate::model::CampaignStatus>,
        ) -> Self {
            self.campaign_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignState`](crate::model::CampaignState)
        pub fn build(self) -> crate::model::CampaignState {
            crate::model::CampaignState {
                campaign_status: self.campaign_status,
            }
        }
    }
}
impl CampaignState {
    /// Creates a new builder-style object to manufacture [`CampaignState`](crate::model::CampaignState)
    pub fn builder() -> crate::model::campaign_state::Builder {
        crate::model::campaign_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CampaignStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Executing,
    #[allow(missing_docs)] // documentation missing in model
    Invalid,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    PendingNextRun,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CampaignStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => CampaignStatus::Completed,
            "DELETED" => CampaignStatus::Deleted,
            "EXECUTING" => CampaignStatus::Executing,
            "INVALID" => CampaignStatus::Invalid,
            "PAUSED" => CampaignStatus::Paused,
            "PENDING_NEXT_RUN" => CampaignStatus::PendingNextRun,
            "SCHEDULED" => CampaignStatus::Scheduled,
            other => CampaignStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CampaignStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CampaignStatus::from(s))
    }
}
impl CampaignStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CampaignStatus::Completed => "COMPLETED",
            CampaignStatus::Deleted => "DELETED",
            CampaignStatus::Executing => "EXECUTING",
            CampaignStatus::Invalid => "INVALID",
            CampaignStatus::Paused => "PAUSED",
            CampaignStatus::PendingNextRun => "PENDING_NEXT_RUN",
            CampaignStatus::Scheduled => "SCHEDULED",
            CampaignStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "DELETED",
            "EXECUTING",
            "INVALID",
            "PAUSED",
            "PENDING_NEXT_RUN",
            "SCHEDULED",
        ]
    }
}
impl AsRef<str> for CampaignStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the schedule settings for a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schedule {
    /// <p>The scheduled time, in ISO 8601 format, when the campaign ended or will end.</p>
    pub end_time: std::option::Option<std::string::String>,
    /// <p>The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.</p>
    pub event_filter: std::option::Option<crate::model::CampaignEventFilter>,
    /// <p>Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.</p>
    pub frequency: std::option::Option<crate::model::Frequency>,
    /// <p>Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the schedule on each recipient's local time, set this value to true.</p>
    pub is_local_time: bool,
    /// <p>The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.</p>
    pub quiet_time: std::option::Option<crate::model::QuietTime>,
    /// <p>The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05,
    /// UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30,
    /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06,
    /// UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.</p>
    pub timezone: std::option::Option<std::string::String>,
}
impl Schedule {
    /// <p>The scheduled time, in ISO 8601 format, when the campaign ended or will end.</p>
    pub fn end_time(&self) -> std::option::Option<&str> {
        self.end_time.as_deref()
    }
    /// <p>The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.</p>
    pub fn event_filter(&self) -> std::option::Option<&crate::model::CampaignEventFilter> {
        self.event_filter.as_ref()
    }
    /// <p>Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.</p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::Frequency> {
        self.frequency.as_ref()
    }
    /// <p>Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the schedule on each recipient's local time, set this value to true.</p>
    pub fn is_local_time(&self) -> bool {
        self.is_local_time
    }
    /// <p>The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.</p>
    pub fn quiet_time(&self) -> std::option::Option<&crate::model::QuietTime> {
        self.quiet_time.as_ref()
    }
    /// <p>The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05,
    /// UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30,
    /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06,
    /// UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
}
impl std::fmt::Debug for Schedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schedule");
        formatter.field("end_time", &self.end_time);
        formatter.field("event_filter", &self.event_filter);
        formatter.field("frequency", &self.frequency);
        formatter.field("is_local_time", &self.is_local_time);
        formatter.field("quiet_time", &self.quiet_time);
        formatter.field("start_time", &self.start_time);
        formatter.field("timezone", &self.timezone);
        formatter.finish()
    }
}
/// See [`Schedule`](crate::model::Schedule)
pub mod schedule {
    /// A builder for [`Schedule`](crate::model::Schedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) event_filter: std::option::Option<crate::model::CampaignEventFilter>,
        pub(crate) frequency: std::option::Option<crate::model::Frequency>,
        pub(crate) is_local_time: std::option::Option<bool>,
        pub(crate) quiet_time: std::option::Option<crate::model::QuietTime>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The scheduled time, in ISO 8601 format, when the campaign ended or will end.</p>
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// <p>The scheduled time, in ISO 8601 format, when the campaign ended or will end.</p>
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.</p>
        pub fn event_filter(mut self, input: crate::model::CampaignEventFilter) -> Self {
            self.event_filter = Some(input);
            self
        }
        /// <p>The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.</p>
        pub fn set_event_filter(
            mut self,
            input: std::option::Option<crate::model::CampaignEventFilter>,
        ) -> Self {
            self.event_filter = input;
            self
        }
        /// <p>Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.</p>
        pub fn frequency(mut self, input: crate::model::Frequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// <p>Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the schedule on each recipient's local time, set this value to true.</p>
        pub fn is_local_time(mut self, input: bool) -> Self {
            self.is_local_time = Some(input);
            self
        }
        /// <p>Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the schedule on each recipient's local time, set this value to true.</p>
        pub fn set_is_local_time(mut self, input: std::option::Option<bool>) -> Self {
            self.is_local_time = input;
            self
        }
        /// <p>The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.</p>
        pub fn quiet_time(mut self, input: crate::model::QuietTime) -> Self {
            self.quiet_time = Some(input);
            self
        }
        /// <p>The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.</p>
        pub fn set_quiet_time(
            mut self,
            input: std::option::Option<crate::model::QuietTime>,
        ) -> Self {
            self.quiet_time = input;
            self
        }
        /// <p>The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05,
        /// UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30,
        /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06,
        /// UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05,
        /// UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30,
        /// UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06,
        /// UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`Schedule`](crate::model::Schedule)
        pub fn build(self) -> crate::model::Schedule {
            crate::model::Schedule {
                end_time: self.end_time,
                event_filter: self.event_filter,
                frequency: self.frequency,
                is_local_time: self.is_local_time.unwrap_or_default(),
                quiet_time: self.quiet_time,
                start_time: self.start_time,
                timezone: self.timezone,
            }
        }
    }
}
impl Schedule {
    /// Creates a new builder-style object to manufacture [`Schedule`](crate::model::Schedule)
    pub fn builder() -> crate::model::schedule::Builder {
        crate::model::schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Frequency {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Hourly,
    #[allow(missing_docs)] // documentation missing in model
    InAppEvent,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Once,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Frequency {
    fn from(s: &str) -> Self {
        match s {
            "DAILY" => Frequency::Daily,
            "EVENT" => Frequency::Event,
            "HOURLY" => Frequency::Hourly,
            "IN_APP_EVENT" => Frequency::InAppEvent,
            "MONTHLY" => Frequency::Monthly,
            "ONCE" => Frequency::Once,
            "WEEKLY" => Frequency::Weekly,
            other => Frequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Frequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Frequency::from(s))
    }
}
impl Frequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Frequency::Daily => "DAILY",
            Frequency::Event => "EVENT",
            Frequency::Hourly => "HOURLY",
            Frequency::InAppEvent => "IN_APP_EVENT",
            Frequency::Monthly => "MONTHLY",
            Frequency::Once => "ONCE",
            Frequency::Weekly => "WEEKLY",
            Frequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DAILY",
            "EVENT",
            "HOURLY",
            "IN_APP_EVENT",
            "MONTHLY",
            "ONCE",
            "WEEKLY",
        ]
    }
}
impl AsRef<str> for Frequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the settings for events that cause a campaign to be sent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignEventFilter {
    /// <p>The dimension settings of the event filter for the campaign.</p>
    pub dimensions: std::option::Option<crate::model::EventDimensions>,
    /// <p>The type of event that causes the campaign to be sent. Valid values are: SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends the campaign when an endpoint event (<link  linkend="apps-application-id-events">Events</link> resource) occurs.</p>
    pub filter_type: std::option::Option<crate::model::FilterType>,
}
impl CampaignEventFilter {
    /// <p>The dimension settings of the event filter for the campaign.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::EventDimensions> {
        self.dimensions.as_ref()
    }
    /// <p>The type of event that causes the campaign to be sent. Valid values are: SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends the campaign when an endpoint event (<link  linkend="apps-application-id-events">Events</link> resource) occurs.</p>
    pub fn filter_type(&self) -> std::option::Option<&crate::model::FilterType> {
        self.filter_type.as_ref()
    }
}
impl std::fmt::Debug for CampaignEventFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignEventFilter");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("filter_type", &self.filter_type);
        formatter.finish()
    }
}
/// See [`CampaignEventFilter`](crate::model::CampaignEventFilter)
pub mod campaign_event_filter {
    /// A builder for [`CampaignEventFilter`](crate::model::CampaignEventFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<crate::model::EventDimensions>,
        pub(crate) filter_type: std::option::Option<crate::model::FilterType>,
    }
    impl Builder {
        /// <p>The dimension settings of the event filter for the campaign.</p>
        pub fn dimensions(mut self, input: crate::model::EventDimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The dimension settings of the event filter for the campaign.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::EventDimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The type of event that causes the campaign to be sent. Valid values are: SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends the campaign when an endpoint event (<link  linkend="apps-application-id-events">Events</link> resource) occurs.</p>
        pub fn filter_type(mut self, input: crate::model::FilterType) -> Self {
            self.filter_type = Some(input);
            self
        }
        /// <p>The type of event that causes the campaign to be sent. Valid values are: SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends the campaign when an endpoint event (<link  linkend="apps-application-id-events">Events</link> resource) occurs.</p>
        pub fn set_filter_type(
            mut self,
            input: std::option::Option<crate::model::FilterType>,
        ) -> Self {
            self.filter_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignEventFilter`](crate::model::CampaignEventFilter)
        pub fn build(self) -> crate::model::CampaignEventFilter {
            crate::model::CampaignEventFilter {
                dimensions: self.dimensions,
                filter_type: self.filter_type,
            }
        }
    }
}
impl CampaignEventFilter {
    /// Creates a new builder-style object to manufacture [`CampaignEventFilter`](crate::model::CampaignEventFilter)
    pub fn builder() -> crate::model::campaign_event_filter::Builder {
        crate::model::campaign_event_filter::Builder::default()
    }
}

/// <p>Specifies the message configuration settings for a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageConfiguration {
    /// <p>The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.</p>
    pub adm_message: std::option::Option<crate::model::Message>,
    /// <p>The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.</p>
    pub apns_message: std::option::Option<crate::model::Message>,
    /// <p>The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.</p>
    pub baidu_message: std::option::Option<crate::model::Message>,
    /// <p>The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.</p>
    pub custom_message: std::option::Option<crate::model::CampaignCustomMessage>,
    /// <p>The default message that the campaign sends through all the channels that are configured for the campaign.</p>
    pub default_message: std::option::Option<crate::model::Message>,
    /// <p>The message that the campaign sends through the email channel. If specified, this message overrides the default message.</p>
    pub email_message: std::option::Option<crate::model::CampaignEmailMessage>,
    /// <p>The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.</p>
    pub gcm_message: std::option::Option<crate::model::Message>,
    /// <p>The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.</p>
    pub sms_message: std::option::Option<crate::model::CampaignSmsMessage>,
    /// <p>The in-app message configuration.</p>
    pub in_app_message: std::option::Option<crate::model::CampaignInAppMessage>,
}
impl MessageConfiguration {
    /// <p>The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.</p>
    pub fn adm_message(&self) -> std::option::Option<&crate::model::Message> {
        self.adm_message.as_ref()
    }
    /// <p>The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.</p>
    pub fn apns_message(&self) -> std::option::Option<&crate::model::Message> {
        self.apns_message.as_ref()
    }
    /// <p>The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.</p>
    pub fn baidu_message(&self) -> std::option::Option<&crate::model::Message> {
        self.baidu_message.as_ref()
    }
    /// <p>The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.</p>
    pub fn custom_message(&self) -> std::option::Option<&crate::model::CampaignCustomMessage> {
        self.custom_message.as_ref()
    }
    /// <p>The default message that the campaign sends through all the channels that are configured for the campaign.</p>
    pub fn default_message(&self) -> std::option::Option<&crate::model::Message> {
        self.default_message.as_ref()
    }
    /// <p>The message that the campaign sends through the email channel. If specified, this message overrides the default message.</p>
    pub fn email_message(&self) -> std::option::Option<&crate::model::CampaignEmailMessage> {
        self.email_message.as_ref()
    }
    /// <p>The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.</p>
    pub fn gcm_message(&self) -> std::option::Option<&crate::model::Message> {
        self.gcm_message.as_ref()
    }
    /// <p>The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.</p>
    pub fn sms_message(&self) -> std::option::Option<&crate::model::CampaignSmsMessage> {
        self.sms_message.as_ref()
    }
    /// <p>The in-app message configuration.</p>
    pub fn in_app_message(&self) -> std::option::Option<&crate::model::CampaignInAppMessage> {
        self.in_app_message.as_ref()
    }
}
impl std::fmt::Debug for MessageConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageConfiguration");
        formatter.field("adm_message", &self.adm_message);
        formatter.field("apns_message", &self.apns_message);
        formatter.field("baidu_message", &self.baidu_message);
        formatter.field("custom_message", &self.custom_message);
        formatter.field("default_message", &self.default_message);
        formatter.field("email_message", &self.email_message);
        formatter.field("gcm_message", &self.gcm_message);
        formatter.field("sms_message", &self.sms_message);
        formatter.field("in_app_message", &self.in_app_message);
        formatter.finish()
    }
}
/// See [`MessageConfiguration`](crate::model::MessageConfiguration)
pub mod message_configuration {
    /// A builder for [`MessageConfiguration`](crate::model::MessageConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adm_message: std::option::Option<crate::model::Message>,
        pub(crate) apns_message: std::option::Option<crate::model::Message>,
        pub(crate) baidu_message: std::option::Option<crate::model::Message>,
        pub(crate) custom_message: std::option::Option<crate::model::CampaignCustomMessage>,
        pub(crate) default_message: std::option::Option<crate::model::Message>,
        pub(crate) email_message: std::option::Option<crate::model::CampaignEmailMessage>,
        pub(crate) gcm_message: std::option::Option<crate::model::Message>,
        pub(crate) sms_message: std::option::Option<crate::model::CampaignSmsMessage>,
        pub(crate) in_app_message: std::option::Option<crate::model::CampaignInAppMessage>,
    }
    impl Builder {
        /// <p>The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.</p>
        pub fn adm_message(mut self, input: crate::model::Message) -> Self {
            self.adm_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.</p>
        pub fn set_adm_message(
            mut self,
            input: std::option::Option<crate::model::Message>,
        ) -> Self {
            self.adm_message = input;
            self
        }
        /// <p>The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.</p>
        pub fn apns_message(mut self, input: crate::model::Message) -> Self {
            self.apns_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.</p>
        pub fn set_apns_message(
            mut self,
            input: std::option::Option<crate::model::Message>,
        ) -> Self {
            self.apns_message = input;
            self
        }
        /// <p>The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.</p>
        pub fn baidu_message(mut self, input: crate::model::Message) -> Self {
            self.baidu_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.</p>
        pub fn set_baidu_message(
            mut self,
            input: std::option::Option<crate::model::Message>,
        ) -> Self {
            self.baidu_message = input;
            self
        }
        /// <p>The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.</p>
        pub fn custom_message(mut self, input: crate::model::CampaignCustomMessage) -> Self {
            self.custom_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.</p>
        pub fn set_custom_message(
            mut self,
            input: std::option::Option<crate::model::CampaignCustomMessage>,
        ) -> Self {
            self.custom_message = input;
            self
        }
        /// <p>The default message that the campaign sends through all the channels that are configured for the campaign.</p>
        pub fn default_message(mut self, input: crate::model::Message) -> Self {
            self.default_message = Some(input);
            self
        }
        /// <p>The default message that the campaign sends through all the channels that are configured for the campaign.</p>
        pub fn set_default_message(
            mut self,
            input: std::option::Option<crate::model::Message>,
        ) -> Self {
            self.default_message = input;
            self
        }
        /// <p>The message that the campaign sends through the email channel. If specified, this message overrides the default message.</p>
        pub fn email_message(mut self, input: crate::model::CampaignEmailMessage) -> Self {
            self.email_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through the email channel. If specified, this message overrides the default message.</p>
        pub fn set_email_message(
            mut self,
            input: std::option::Option<crate::model::CampaignEmailMessage>,
        ) -> Self {
            self.email_message = input;
            self
        }
        /// <p>The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.</p>
        pub fn gcm_message(mut self, input: crate::model::Message) -> Self {
            self.gcm_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.</p>
        pub fn set_gcm_message(
            mut self,
            input: std::option::Option<crate::model::Message>,
        ) -> Self {
            self.gcm_message = input;
            self
        }
        /// <p>The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.</p>
        pub fn sms_message(mut self, input: crate::model::CampaignSmsMessage) -> Self {
            self.sms_message = Some(input);
            self
        }
        /// <p>The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.</p>
        pub fn set_sms_message(
            mut self,
            input: std::option::Option<crate::model::CampaignSmsMessage>,
        ) -> Self {
            self.sms_message = input;
            self
        }
        /// <p>The in-app message configuration.</p>
        pub fn in_app_message(mut self, input: crate::model::CampaignInAppMessage) -> Self {
            self.in_app_message = Some(input);
            self
        }
        /// <p>The in-app message configuration.</p>
        pub fn set_in_app_message(
            mut self,
            input: std::option::Option<crate::model::CampaignInAppMessage>,
        ) -> Self {
            self.in_app_message = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageConfiguration`](crate::model::MessageConfiguration)
        pub fn build(self) -> crate::model::MessageConfiguration {
            crate::model::MessageConfiguration {
                adm_message: self.adm_message,
                apns_message: self.apns_message,
                baidu_message: self.baidu_message,
                custom_message: self.custom_message,
                default_message: self.default_message,
                email_message: self.email_message,
                gcm_message: self.gcm_message,
                sms_message: self.sms_message,
                in_app_message: self.in_app_message,
            }
        }
    }
}
impl MessageConfiguration {
    /// Creates a new builder-style object to manufacture [`MessageConfiguration`](crate::model::MessageConfiguration)
    pub fn builder() -> crate::model::message_configuration::Builder {
        crate::model::message_configuration::Builder::default()
    }
}

/// <p>In-app message configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignInAppMessage {
    /// <p>The message body of the notification, the email body or the text message.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>In-app message content.</p>
    pub content: std::option::Option<std::vec::Vec<crate::model::InAppMessageContent>>,
    /// <p>Custom config to be sent to client.</p>
    pub custom_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>In-app message layout.</p>
    pub layout: std::option::Option<crate::model::Layout>,
}
impl CampaignInAppMessage {
    /// <p>The message body of the notification, the email body or the text message.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>In-app message content.</p>
    pub fn content(&self) -> std::option::Option<&[crate::model::InAppMessageContent]> {
        self.content.as_deref()
    }
    /// <p>Custom config to be sent to client.</p>
    pub fn custom_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.custom_config.as_ref()
    }
    /// <p>In-app message layout.</p>
    pub fn layout(&self) -> std::option::Option<&crate::model::Layout> {
        self.layout.as_ref()
    }
}
impl std::fmt::Debug for CampaignInAppMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignInAppMessage");
        formatter.field("body", &self.body);
        formatter.field("content", &self.content);
        formatter.field("custom_config", &self.custom_config);
        formatter.field("layout", &self.layout);
        formatter.finish()
    }
}
/// See [`CampaignInAppMessage`](crate::model::CampaignInAppMessage)
pub mod campaign_in_app_message {
    /// A builder for [`CampaignInAppMessage`](crate::model::CampaignInAppMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::vec::Vec<crate::model::InAppMessageContent>>,
        pub(crate) custom_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) layout: std::option::Option<crate::model::Layout>,
    }
    impl Builder {
        /// <p>The message body of the notification, the email body or the text message.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The message body of the notification, the email body or the text message.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Appends an item to `content`.
        ///
        /// To override the contents of this collection use [`set_content`](Self::set_content).
        ///
        /// <p>In-app message content.</p>
        pub fn content(mut self, input: impl Into<crate::model::InAppMessageContent>) -> Self {
            let mut v = self.content.unwrap_or_default();
            v.push(input.into());
            self.content = Some(v);
            self
        }
        /// <p>In-app message content.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InAppMessageContent>>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `custom_config`.
        ///
        /// To override the contents of this collection use [`set_custom_config`](Self::set_custom_config).
        ///
        /// <p>Custom config to be sent to client.</p>
        pub fn custom_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_config = Some(hash_map);
            self
        }
        /// <p>Custom config to be sent to client.</p>
        pub fn set_custom_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_config = input;
            self
        }
        /// <p>In-app message layout.</p>
        pub fn layout(mut self, input: crate::model::Layout) -> Self {
            self.layout = Some(input);
            self
        }
        /// <p>In-app message layout.</p>
        pub fn set_layout(mut self, input: std::option::Option<crate::model::Layout>) -> Self {
            self.layout = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignInAppMessage`](crate::model::CampaignInAppMessage)
        pub fn build(self) -> crate::model::CampaignInAppMessage {
            crate::model::CampaignInAppMessage {
                body: self.body,
                content: self.content,
                custom_config: self.custom_config,
                layout: self.layout,
            }
        }
    }
}
impl CampaignInAppMessage {
    /// Creates a new builder-style object to manufacture [`CampaignInAppMessage`](crate::model::CampaignInAppMessage)
    pub fn builder() -> crate::model::campaign_in_app_message::Builder {
        crate::model::campaign_in_app_message::Builder::default()
    }
}

/// <p>Specifies the content and settings for an SMS message that's sent to recipients of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignSmsMessage {
    /// <p>The body of the SMS message.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
    pub origination_number: std::option::Option<std::string::String>,
    /// <p>The sender ID to display on recipients' devices when they receive the SMS message.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
    pub template_id: std::option::Option<std::string::String>,
}
impl CampaignSmsMessage {
    /// <p>The body of the SMS message.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
    pub fn origination_number(&self) -> std::option::Option<&str> {
        self.origination_number.as_deref()
    }
    /// <p>The sender ID to display on recipients' devices when they receive the SMS message.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
}
impl std::fmt::Debug for CampaignSmsMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignSmsMessage");
        formatter.field("body", &self.body);
        formatter.field("message_type", &self.message_type);
        formatter.field("origination_number", &self.origination_number);
        formatter.field("sender_id", &self.sender_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("template_id", &self.template_id);
        formatter.finish()
    }
}
/// See [`CampaignSmsMessage`](crate::model::CampaignSmsMessage)
pub mod campaign_sms_message {
    /// A builder for [`CampaignSmsMessage`](crate::model::CampaignSmsMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) origination_number: std::option::Option<std::string::String>,
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The body of the SMS message.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The body of the SMS message.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
        pub fn origination_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.origination_number = Some(input.into());
            self
        }
        /// <p>The long code to send the SMS message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>
        pub fn set_origination_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origination_number = input;
            self
        }
        /// <p>The sender ID to display on recipients' devices when they receive the SMS message.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The sender ID to display on recipients' devices when they receive the SMS message.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The template ID received from the regulatory body for sending SMS in your country.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignSmsMessage`](crate::model::CampaignSmsMessage)
        pub fn build(self) -> crate::model::CampaignSmsMessage {
            crate::model::CampaignSmsMessage {
                body: self.body,
                message_type: self.message_type,
                origination_number: self.origination_number,
                sender_id: self.sender_id,
                entity_id: self.entity_id,
                template_id: self.template_id,
            }
        }
    }
}
impl CampaignSmsMessage {
    /// Creates a new builder-style object to manufacture [`CampaignSmsMessage`](crate::model::CampaignSmsMessage)
    pub fn builder() -> crate::model::campaign_sms_message::Builder {
        crate::model::campaign_sms_message::Builder::default()
    }
}

/// <p>Specifies the content and settings for a push notification that's sent to recipients of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The action to occur if a recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The body of the notification message. The maximum number of characters is 200.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The URL of the image to display as the push-notification icon, such as the icon for the app.</p>
    pub image_icon_url: std::option::Option<std::string::String>,
    /// <p>The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.</p>
    pub image_small_icon_url: std::option::Option<std::string::String>,
    /// <p>The URL of an image to display in the push notification.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>The JSON payload to use for a silent push notification.</p>
    pub json_body: std::option::Option<std::string::String>,
    /// <p>The URL of the image or video to display in the push notification.</p>
    pub media_url: std::option::Option<std::string::String>,
    /// <p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>
    pub raw_content: std::option::Option<std::string::String>,
    /// <p>Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.</p>
    pub silent_push: bool,
    /// <p>The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
    pub time_to_live: i32,
    /// <p>The title to display above the notification message on a recipient's device.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>
    pub url: std::option::Option<std::string::String>,
}
impl Message {
    /// <p>The action to occur if a recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The body of the notification message. The maximum number of characters is 200.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The URL of the image to display as the push-notification icon, such as the icon for the app.</p>
    pub fn image_icon_url(&self) -> std::option::Option<&str> {
        self.image_icon_url.as_deref()
    }
    /// <p>The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.</p>
    pub fn image_small_icon_url(&self) -> std::option::Option<&str> {
        self.image_small_icon_url.as_deref()
    }
    /// <p>The URL of an image to display in the push notification.</p>
    pub fn image_url(&self) -> std::option::Option<&str> {
        self.image_url.as_deref()
    }
    /// <p>The JSON payload to use for a silent push notification.</p>
    pub fn json_body(&self) -> std::option::Option<&str> {
        self.json_body.as_deref()
    }
    /// <p>The URL of the image or video to display in the push notification.</p>
    pub fn media_url(&self) -> std::option::Option<&str> {
        self.media_url.as_deref()
    }
    /// <p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>
    pub fn raw_content(&self) -> std::option::Option<&str> {
        self.raw_content.as_deref()
    }
    /// <p>Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.</p>
    pub fn silent_push(&self) -> bool {
        self.silent_push
    }
    /// <p>The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
    pub fn time_to_live(&self) -> i32 {
        self.time_to_live
    }
    /// <p>The title to display above the notification message on a recipient's device.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("action", &self.action);
        formatter.field("body", &self.body);
        formatter.field("image_icon_url", &self.image_icon_url);
        formatter.field("image_small_icon_url", &self.image_small_icon_url);
        formatter.field("image_url", &self.image_url);
        formatter.field("json_body", &self.json_body);
        formatter.field("media_url", &self.media_url);
        formatter.field("raw_content", &self.raw_content);
        formatter.field("silent_push", &self.silent_push);
        formatter.field("time_to_live", &self.time_to_live);
        formatter.field("title", &self.title);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) image_icon_url: std::option::Option<std::string::String>,
        pub(crate) image_small_icon_url: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) json_body: std::option::Option<std::string::String>,
        pub(crate) media_url: std::option::Option<std::string::String>,
        pub(crate) raw_content: std::option::Option<std::string::String>,
        pub(crate) silent_push: std::option::Option<bool>,
        pub(crate) time_to_live: std::option::Option<i32>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action to occur if a recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to occur if a recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</p></li> <li><p>URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</p></li></ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The body of the notification message. The maximum number of characters is 200.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The body of the notification message. The maximum number of characters is 200.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The URL of the image to display as the push-notification icon, such as the icon for the app.</p>
        pub fn image_icon_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_icon_url = Some(input.into());
            self
        }
        /// <p>The URL of the image to display as the push-notification icon, such as the icon for the app.</p>
        pub fn set_image_icon_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_icon_url = input;
            self
        }
        /// <p>The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.</p>
        pub fn image_small_icon_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_small_icon_url = Some(input.into());
            self
        }
        /// <p>The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.</p>
        pub fn set_image_small_icon_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_small_icon_url = input;
            self
        }
        /// <p>The URL of an image to display in the push notification.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The URL of an image to display in the push notification.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// <p>The JSON payload to use for a silent push notification.</p>
        pub fn json_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_body = Some(input.into());
            self
        }
        /// <p>The JSON payload to use for a silent push notification.</p>
        pub fn set_json_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.json_body = input;
            self
        }
        /// <p>The URL of the image or video to display in the push notification.</p>
        pub fn media_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_url = Some(input.into());
            self
        }
        /// <p>The URL of the image or video to display in the push notification.</p>
        pub fn set_media_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_url = input;
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>
        pub fn raw_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_content = Some(input.into());
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>
        pub fn set_raw_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_content = input;
            self
        }
        /// <p>Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.</p>
        pub fn silent_push(mut self, input: bool) -> Self {
            self.silent_push = Some(input);
            self
        }
        /// <p>Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.</p>
        pub fn set_silent_push(mut self, input: std::option::Option<bool>) -> Self {
            self.silent_push = input;
            self
        }
        /// <p>The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
        pub fn time_to_live(mut self, input: i32) -> Self {
            self.time_to_live = Some(input);
            self
        }
        /// <p>The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.</p> <p>This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>
        pub fn set_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live = input;
            self
        }
        /// <p>The title to display above the notification message on a recipient's device.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title to display above the notification message on a recipient's device.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                action: self.action,
                body: self.body,
                image_icon_url: self.image_icon_url,
                image_small_icon_url: self.image_small_icon_url,
                image_url: self.image_url,
                json_body: self.json_body,
                media_url: self.media_url,
                raw_content: self.raw_content,
                silent_push: self.silent_push.unwrap_or_default(),
                time_to_live: self.time_to_live.unwrap_or_default(),
                title: self.title,
                url: self.url,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>Specifies the content and "From" address for an email message that's sent to recipients of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignEmailMessage {
    /// <p>The body of the email for recipients whose email clients don't render HTML content.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.</p>
    pub from_address: std::option::Option<std::string::String>,
    /// <p>The body of the email, in HTML format, for recipients whose email clients render HTML content.</p>
    pub html_body: std::option::Option<std::string::String>,
    /// <p>The subject line, or title, of the email.</p>
    pub title: std::option::Option<std::string::String>,
}
impl CampaignEmailMessage {
    /// <p>The body of the email for recipients whose email clients don't render HTML content.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.</p>
    pub fn from_address(&self) -> std::option::Option<&str> {
        self.from_address.as_deref()
    }
    /// <p>The body of the email, in HTML format, for recipients whose email clients render HTML content.</p>
    pub fn html_body(&self) -> std::option::Option<&str> {
        self.html_body.as_deref()
    }
    /// <p>The subject line, or title, of the email.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
}
impl std::fmt::Debug for CampaignEmailMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignEmailMessage");
        formatter.field("body", &self.body);
        formatter.field("from_address", &self.from_address);
        formatter.field("html_body", &self.html_body);
        formatter.field("title", &self.title);
        formatter.finish()
    }
}
/// See [`CampaignEmailMessage`](crate::model::CampaignEmailMessage)
pub mod campaign_email_message {
    /// A builder for [`CampaignEmailMessage`](crate::model::CampaignEmailMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) from_address: std::option::Option<std::string::String>,
        pub(crate) html_body: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The body of the email for recipients whose email clients don't render HTML content.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The body of the email for recipients whose email clients don't render HTML content.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// <p>The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.</p>
        pub fn from_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_address = Some(input.into());
            self
        }
        /// <p>The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.</p>
        pub fn set_from_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_address = input;
            self
        }
        /// <p>The body of the email, in HTML format, for recipients whose email clients render HTML content.</p>
        pub fn html_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.html_body = Some(input.into());
            self
        }
        /// <p>The body of the email, in HTML format, for recipients whose email clients render HTML content.</p>
        pub fn set_html_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.html_body = input;
            self
        }
        /// <p>The subject line, or title, of the email.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The subject line, or title, of the email.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignEmailMessage`](crate::model::CampaignEmailMessage)
        pub fn build(self) -> crate::model::CampaignEmailMessage {
            crate::model::CampaignEmailMessage {
                body: self.body,
                from_address: self.from_address,
                html_body: self.html_body,
                title: self.title,
            }
        }
    }
}
impl CampaignEmailMessage {
    /// Creates a new builder-style object to manufacture [`CampaignEmailMessage`](crate::model::CampaignEmailMessage)
    pub fn builder() -> crate::model::campaign_email_message::Builder {
        crate::model::campaign_email_message::Builder::default()
    }
}

/// <p>Specifies the contents of a message that's sent through a custom channel to recipients of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignCustomMessage {
    /// <p>The raw, JSON-formatted string to use as the payload for the message. The maximum size is 5 KB.</p>
    pub data: std::option::Option<std::string::String>,
}
impl CampaignCustomMessage {
    /// <p>The raw, JSON-formatted string to use as the payload for the message. The maximum size is 5 KB.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
}
impl std::fmt::Debug for CampaignCustomMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignCustomMessage");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`CampaignCustomMessage`](crate::model::CampaignCustomMessage)
pub mod campaign_custom_message {
    /// A builder for [`CampaignCustomMessage`](crate::model::CampaignCustomMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The raw, JSON-formatted string to use as the payload for the message. The maximum size is 5 KB.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The raw, JSON-formatted string to use as the payload for the message. The maximum size is 5 KB.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignCustomMessage`](crate::model::CampaignCustomMessage)
        pub fn build(self) -> crate::model::CampaignCustomMessage {
            crate::model::CampaignCustomMessage { data: self.data }
        }
    }
}
impl CampaignCustomMessage {
    /// Creates a new builder-style object to manufacture [`CampaignCustomMessage`](crate::model::CampaignCustomMessage)
    pub fn builder() -> crate::model::campaign_custom_message::Builder {
        crate::model::campaign_custom_message::Builder::default()
    }
}

/// <p>For a campaign, specifies limits on the messages that the campaign can send. For an application, specifies the default limits for messages that campaigns in the application can send.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignLimits {
    /// <p>The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.</p>
    pub daily: i32,
    /// <p>The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.</p>
    pub maximum_duration: i32,
    /// <p>The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 50. The maximum value is 20,000.</p>
    pub messages_per_second: i32,
    /// <p>The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.</p>
    pub total: i32,
    /// <p>The maximum total number of messages that the campaign can send per user session.</p>
    pub session: i32,
}
impl CampaignLimits {
    /// <p>The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.</p>
    pub fn daily(&self) -> i32 {
        self.daily
    }
    /// <p>The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.</p>
    pub fn maximum_duration(&self) -> i32 {
        self.maximum_duration
    }
    /// <p>The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 50. The maximum value is 20,000.</p>
    pub fn messages_per_second(&self) -> i32 {
        self.messages_per_second
    }
    /// <p>The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.</p>
    pub fn total(&self) -> i32 {
        self.total
    }
    /// <p>The maximum total number of messages that the campaign can send per user session.</p>
    pub fn session(&self) -> i32 {
        self.session
    }
}
impl std::fmt::Debug for CampaignLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignLimits");
        formatter.field("daily", &self.daily);
        formatter.field("maximum_duration", &self.maximum_duration);
        formatter.field("messages_per_second", &self.messages_per_second);
        formatter.field("total", &self.total);
        formatter.field("session", &self.session);
        formatter.finish()
    }
}
/// See [`CampaignLimits`](crate::model::CampaignLimits)
pub mod campaign_limits {
    /// A builder for [`CampaignLimits`](crate::model::CampaignLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) daily: std::option::Option<i32>,
        pub(crate) maximum_duration: std::option::Option<i32>,
        pub(crate) messages_per_second: std::option::Option<i32>,
        pub(crate) total: std::option::Option<i32>,
        pub(crate) session: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.</p>
        pub fn daily(mut self, input: i32) -> Self {
            self.daily = Some(input);
            self
        }
        /// <p>The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.</p>
        pub fn set_daily(mut self, input: std::option::Option<i32>) -> Self {
            self.daily = input;
            self
        }
        /// <p>The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.</p>
        pub fn maximum_duration(mut self, input: i32) -> Self {
            self.maximum_duration = Some(input);
            self
        }
        /// <p>The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.</p>
        pub fn set_maximum_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_duration = input;
            self
        }
        /// <p>The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 50. The maximum value is 20,000.</p>
        pub fn messages_per_second(mut self, input: i32) -> Self {
            self.messages_per_second = Some(input);
            self
        }
        /// <p>The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 50. The maximum value is 20,000.</p>
        pub fn set_messages_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.messages_per_second = input;
            self
        }
        /// <p>The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.</p>
        pub fn total(mut self, input: i32) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.</p>
        pub fn set_total(mut self, input: std::option::Option<i32>) -> Self {
            self.total = input;
            self
        }
        /// <p>The maximum total number of messages that the campaign can send per user session.</p>
        pub fn session(mut self, input: i32) -> Self {
            self.session = Some(input);
            self
        }
        /// <p>The maximum total number of messages that the campaign can send per user session.</p>
        pub fn set_session(mut self, input: std::option::Option<i32>) -> Self {
            self.session = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignLimits`](crate::model::CampaignLimits)
        pub fn build(self) -> crate::model::CampaignLimits {
            crate::model::CampaignLimits {
                daily: self.daily.unwrap_or_default(),
                maximum_duration: self.maximum_duration.unwrap_or_default(),
                messages_per_second: self.messages_per_second.unwrap_or_default(),
                total: self.total.unwrap_or_default(),
                session: self.session.unwrap_or_default(),
            }
        }
    }
}
impl CampaignLimits {
    /// Creates a new builder-style object to manufacture [`CampaignLimits`](crate::model::CampaignLimits)
    pub fn builder() -> crate::model::campaign_limits::Builder {
        crate::model::campaign_limits::Builder::default()
    }
}

/// <p>Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignHook {
    /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.</p>
    pub lambda_function_name: std::option::Option<std::string::String>,
    /// <p>The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p> <ul><li><p>FILTER - Invoke the function to customize the segment that's used by a campaign.</p></li> <li><p>DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.</p></li></ul>
    pub mode: std::option::Option<crate::model::Mode>,
    /// <p>The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.</p>
    pub web_url: std::option::Option<std::string::String>,
}
impl CampaignHook {
    /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.</p>
    pub fn lambda_function_name(&self) -> std::option::Option<&str> {
        self.lambda_function_name.as_deref()
    }
    /// <p>The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p> <ul><li><p>FILTER - Invoke the function to customize the segment that's used by a campaign.</p></li> <li><p>DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.</p></li></ul>
    pub fn mode(&self) -> std::option::Option<&crate::model::Mode> {
        self.mode.as_ref()
    }
    /// <p>The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.</p>
    pub fn web_url(&self) -> std::option::Option<&str> {
        self.web_url.as_deref()
    }
}
impl std::fmt::Debug for CampaignHook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignHook");
        formatter.field("lambda_function_name", &self.lambda_function_name);
        formatter.field("mode", &self.mode);
        formatter.field("web_url", &self.web_url);
        formatter.finish()
    }
}
/// See [`CampaignHook`](crate::model::CampaignHook)
pub mod campaign_hook {
    /// A builder for [`CampaignHook`](crate::model::CampaignHook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_function_name: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::Mode>,
        pub(crate) web_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.</p>
        pub fn lambda_function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.</p>
        pub fn set_lambda_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_name = input;
            self
        }
        /// <p>The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p> <ul><li><p>FILTER - Invoke the function to customize the segment that's used by a campaign.</p></li> <li><p>DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.</p></li></ul>
        pub fn mode(mut self, input: crate::model::Mode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p> <ul><li><p>FILTER - Invoke the function to customize the segment that's used by a campaign.</p></li> <li><p>DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.</p></li></ul>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::Mode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.</p>
        pub fn web_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_url = Some(input.into());
            self
        }
        /// <p>The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.</p>
        pub fn set_web_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignHook`](crate::model::CampaignHook)
        pub fn build(self) -> crate::model::CampaignHook {
            crate::model::CampaignHook {
                lambda_function_name: self.lambda_function_name,
                mode: self.mode,
                web_url: self.web_url,
            }
        }
    }
}
impl CampaignHook {
    /// Creates a new builder-style object to manufacture [`CampaignHook`](crate::model::CampaignHook)
    pub fn builder() -> crate::model::campaign_hook::Builder {
        crate::model::campaign_hook::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mode {
    #[allow(missing_docs)] // documentation missing in model
    Delivery,
    #[allow(missing_docs)] // documentation missing in model
    Filter,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mode {
    fn from(s: &str) -> Self {
        match s {
            "DELIVERY" => Mode::Delivery,
            "FILTER" => Mode::Filter,
            other => Mode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mode::from(s))
    }
}
impl Mode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mode::Delivery => "DELIVERY",
            Mode::Filter => "FILTER",
            Mode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELIVERY", "FILTER"]
    }
}
impl AsRef<str> for Mode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the delivery configuration settings for sending a campaign or campaign treatment through a custom channel. This object is required if you use the CampaignCustomMessage object to define the message to send for the campaign or campaign treatment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomDeliveryConfiguration {
    /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
    pub delivery_uri: std::option::Option<std::string::String>,
    /// <p>The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
    pub endpoint_types: std::option::Option<std::vec::Vec<crate::model::EndpointTypesElement>>,
}
impl CustomDeliveryConfiguration {
    /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
    pub fn delivery_uri(&self) -> std::option::Option<&str> {
        self.delivery_uri.as_deref()
    }
    /// <p>The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
    pub fn endpoint_types(&self) -> std::option::Option<&[crate::model::EndpointTypesElement]> {
        self.endpoint_types.as_deref()
    }
}
impl std::fmt::Debug for CustomDeliveryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomDeliveryConfiguration");
        formatter.field("delivery_uri", &self.delivery_uri);
        formatter.field("endpoint_types", &self.endpoint_types);
        formatter.finish()
    }
}
/// See [`CustomDeliveryConfiguration`](crate::model::CustomDeliveryConfiguration)
pub mod custom_delivery_configuration {
    /// A builder for [`CustomDeliveryConfiguration`](crate::model::CustomDeliveryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_uri: std::option::Option<std::string::String>,
        pub(crate) endpoint_types:
            std::option::Option<std::vec::Vec<crate::model::EndpointTypesElement>>,
    }
    impl Builder {
        /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
        pub fn delivery_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_uri = Some(input.into());
            self
        }
        /// <p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>
        pub fn set_delivery_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delivery_uri = input;
            self
        }
        /// Appends an item to `endpoint_types`.
        ///
        /// To override the contents of this collection use [`set_endpoint_types`](Self::set_endpoint_types).
        ///
        /// <p>The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
        pub fn endpoint_types(
            mut self,
            input: impl Into<crate::model::EndpointTypesElement>,
        ) -> Self {
            let mut v = self.endpoint_types.unwrap_or_default();
            v.push(input.into());
            self.endpoint_types = Some(v);
            self
        }
        /// <p>The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>
        pub fn set_endpoint_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointTypesElement>>,
        ) -> Self {
            self.endpoint_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomDeliveryConfiguration`](crate::model::CustomDeliveryConfiguration)
        pub fn build(self) -> crate::model::CustomDeliveryConfiguration {
            crate::model::CustomDeliveryConfiguration {
                delivery_uri: self.delivery_uri,
                endpoint_types: self.endpoint_types,
            }
        }
    }
}
impl CustomDeliveryConfiguration {
    /// Creates a new builder-style object to manufacture [`CustomDeliveryConfiguration`](crate::model::CustomDeliveryConfiguration)
    pub fn builder() -> crate::model::custom_delivery_configuration::Builder {
        crate::model::custom_delivery_configuration::Builder::default()
    }
}

/// <p>Specifies the settings for a campaign treatment. A <i>treatment</i> is a variation of a campaign that's used for A/B testing of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TreatmentResource {
    /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
    pub custom_delivery_configuration:
        std::option::Option<crate::model::CustomDeliveryConfiguration>,
    /// <p>The unique identifier for the treatment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The message configuration settings for the treatment.</p>
    pub message_configuration: std::option::Option<crate::model::MessageConfiguration>,
    /// <p>The schedule settings for the treatment.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The allocated percentage of users (segment members) that the treatment is sent to.</p>
    pub size_percent: i32,
    /// <p>The current status of the treatment.</p>
    pub state: std::option::Option<crate::model::CampaignState>,
    /// <p>The message template to use for the treatment.</p>
    pub template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
    /// <p>The custom description of the treatment.</p>
    pub treatment_description: std::option::Option<std::string::String>,
    /// <p>The custom name of the treatment.</p>
    pub treatment_name: std::option::Option<std::string::String>,
}
impl TreatmentResource {
    /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
    pub fn custom_delivery_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDeliveryConfiguration> {
        self.custom_delivery_configuration.as_ref()
    }
    /// <p>The unique identifier for the treatment.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The message configuration settings for the treatment.</p>
    pub fn message_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MessageConfiguration> {
        self.message_configuration.as_ref()
    }
    /// <p>The schedule settings for the treatment.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p>The allocated percentage of users (segment members) that the treatment is sent to.</p>
    pub fn size_percent(&self) -> i32 {
        self.size_percent
    }
    /// <p>The current status of the treatment.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CampaignState> {
        self.state.as_ref()
    }
    /// <p>The message template to use for the treatment.</p>
    pub fn template_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TemplateConfiguration> {
        self.template_configuration.as_ref()
    }
    /// <p>The custom description of the treatment.</p>
    pub fn treatment_description(&self) -> std::option::Option<&str> {
        self.treatment_description.as_deref()
    }
    /// <p>The custom name of the treatment.</p>
    pub fn treatment_name(&self) -> std::option::Option<&str> {
        self.treatment_name.as_deref()
    }
}
impl std::fmt::Debug for TreatmentResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TreatmentResource");
        formatter.field(
            "custom_delivery_configuration",
            &self.custom_delivery_configuration,
        );
        formatter.field("id", &self.id);
        formatter.field("message_configuration", &self.message_configuration);
        formatter.field("schedule", &self.schedule);
        formatter.field("size_percent", &self.size_percent);
        formatter.field("state", &self.state);
        formatter.field("template_configuration", &self.template_configuration);
        formatter.field("treatment_description", &self.treatment_description);
        formatter.field("treatment_name", &self.treatment_name);
        formatter.finish()
    }
}
/// See [`TreatmentResource`](crate::model::TreatmentResource)
pub mod treatment_resource {
    /// A builder for [`TreatmentResource`](crate::model::TreatmentResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_delivery_configuration:
            std::option::Option<crate::model::CustomDeliveryConfiguration>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) message_configuration: std::option::Option<crate::model::MessageConfiguration>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) size_percent: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::CampaignState>,
        pub(crate) template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
        pub(crate) treatment_description: std::option::Option<std::string::String>,
        pub(crate) treatment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
        pub fn custom_delivery_configuration(
            mut self,
            input: crate::model::CustomDeliveryConfiguration,
        ) -> Self {
            self.custom_delivery_configuration = Some(input);
            self
        }
        /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
        pub fn set_custom_delivery_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDeliveryConfiguration>,
        ) -> Self {
            self.custom_delivery_configuration = input;
            self
        }
        /// <p>The unique identifier for the treatment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the treatment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The message configuration settings for the treatment.</p>
        pub fn message_configuration(mut self, input: crate::model::MessageConfiguration) -> Self {
            self.message_configuration = Some(input);
            self
        }
        /// <p>The message configuration settings for the treatment.</p>
        pub fn set_message_configuration(
            mut self,
            input: std::option::Option<crate::model::MessageConfiguration>,
        ) -> Self {
            self.message_configuration = input;
            self
        }
        /// <p>The schedule settings for the treatment.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule settings for the treatment.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The allocated percentage of users (segment members) that the treatment is sent to.</p>
        pub fn size_percent(mut self, input: i32) -> Self {
            self.size_percent = Some(input);
            self
        }
        /// <p>The allocated percentage of users (segment members) that the treatment is sent to.</p>
        pub fn set_size_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.size_percent = input;
            self
        }
        /// <p>The current status of the treatment.</p>
        pub fn state(mut self, input: crate::model::CampaignState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current status of the treatment.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CampaignState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The message template to use for the treatment.</p>
        pub fn template_configuration(
            mut self,
            input: crate::model::TemplateConfiguration,
        ) -> Self {
            self.template_configuration = Some(input);
            self
        }
        /// <p>The message template to use for the treatment.</p>
        pub fn set_template_configuration(
            mut self,
            input: std::option::Option<crate::model::TemplateConfiguration>,
        ) -> Self {
            self.template_configuration = input;
            self
        }
        /// <p>The custom description of the treatment.</p>
        pub fn treatment_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_description = Some(input.into());
            self
        }
        /// <p>The custom description of the treatment.</p>
        pub fn set_treatment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_description = input;
            self
        }
        /// <p>The custom name of the treatment.</p>
        pub fn treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_name = Some(input.into());
            self
        }
        /// <p>The custom name of the treatment.</p>
        pub fn set_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TreatmentResource`](crate::model::TreatmentResource)
        pub fn build(self) -> crate::model::TreatmentResource {
            crate::model::TreatmentResource {
                custom_delivery_configuration: self.custom_delivery_configuration,
                id: self.id,
                message_configuration: self.message_configuration,
                schedule: self.schedule,
                size_percent: self.size_percent.unwrap_or_default(),
                state: self.state,
                template_configuration: self.template_configuration,
                treatment_description: self.treatment_description,
                treatment_name: self.treatment_name,
            }
        }
    }
}
impl TreatmentResource {
    /// Creates a new builder-style object to manufacture [`TreatmentResource`](crate::model::TreatmentResource)
    pub fn builder() -> crate::model::treatment_resource::Builder {
        crate::model::treatment_resource::Builder::default()
    }
}

/// <p>Specifies the configuration and other settings for a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteCampaignRequest {
    /// <p>An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.</p>
    pub additional_treatments:
        std::option::Option<std::vec::Vec<crate::model::WriteTreatmentResource>>,
    /// <p>The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.</p>
    pub custom_delivery_configuration:
        std::option::Option<crate::model::CustomDeliveryConfiguration>,
    /// <p>A custom description of the campaign.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
    pub holdout_percent: i32,
    /// <p>The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
    pub hook: std::option::Option<crate::model::CampaignHook>,
    /// <p>Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
    pub is_paused: bool,
    /// <p>The messaging limits for the campaign.</p>
    pub limits: std::option::Option<crate::model::CampaignLimits>,
    /// <p>The message configuration settings for the campaign.</p>
    pub message_configuration: std::option::Option<crate::model::MessageConfiguration>,
    /// <p>A custom name for the campaign.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The schedule settings for the campaign.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The unique identifier for the segment to associate with the campaign.</p>
    pub segment_id: std::option::Option<std::string::String>,
    /// <p>The version of the segment to associate with the campaign.</p>
    pub segment_version: i32,
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The message template to use for the campaign.</p>
    pub template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
    /// <p>A custom description of the default treatment for the campaign.</p>
    pub treatment_description: std::option::Option<std::string::String>,
    /// <p>A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
    pub treatment_name: std::option::Option<std::string::String>,
    /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
    pub priority: i32,
}
impl WriteCampaignRequest {
    /// <p>An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.</p>
    pub fn additional_treatments(
        &self,
    ) -> std::option::Option<&[crate::model::WriteTreatmentResource]> {
        self.additional_treatments.as_deref()
    }
    /// <p>The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.</p>
    pub fn custom_delivery_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDeliveryConfiguration> {
        self.custom_delivery_configuration.as_ref()
    }
    /// <p>A custom description of the campaign.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
    pub fn holdout_percent(&self) -> i32 {
        self.holdout_percent
    }
    /// <p>The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
    pub fn hook(&self) -> std::option::Option<&crate::model::CampaignHook> {
        self.hook.as_ref()
    }
    /// <p>Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
    pub fn is_paused(&self) -> bool {
        self.is_paused
    }
    /// <p>The messaging limits for the campaign.</p>
    pub fn limits(&self) -> std::option::Option<&crate::model::CampaignLimits> {
        self.limits.as_ref()
    }
    /// <p>The message configuration settings for the campaign.</p>
    pub fn message_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MessageConfiguration> {
        self.message_configuration.as_ref()
    }
    /// <p>A custom name for the campaign.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The schedule settings for the campaign.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p>The unique identifier for the segment to associate with the campaign.</p>
    pub fn segment_id(&self) -> std::option::Option<&str> {
        self.segment_id.as_deref()
    }
    /// <p>The version of the segment to associate with the campaign.</p>
    pub fn segment_version(&self) -> i32 {
        self.segment_version
    }
    /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The message template to use for the campaign.</p>
    pub fn template_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TemplateConfiguration> {
        self.template_configuration.as_ref()
    }
    /// <p>A custom description of the default treatment for the campaign.</p>
    pub fn treatment_description(&self) -> std::option::Option<&str> {
        self.treatment_description.as_deref()
    }
    /// <p>A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
    pub fn treatment_name(&self) -> std::option::Option<&str> {
        self.treatment_name.as_deref()
    }
    /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for WriteCampaignRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteCampaignRequest");
        formatter.field("additional_treatments", &self.additional_treatments);
        formatter.field(
            "custom_delivery_configuration",
            &self.custom_delivery_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("holdout_percent", &self.holdout_percent);
        formatter.field("hook", &self.hook);
        formatter.field("is_paused", &self.is_paused);
        formatter.field("limits", &self.limits);
        formatter.field("message_configuration", &self.message_configuration);
        formatter.field("name", &self.name);
        formatter.field("schedule", &self.schedule);
        formatter.field("segment_id", &self.segment_id);
        formatter.field("segment_version", &self.segment_version);
        formatter.field("tags", &self.tags);
        formatter.field("template_configuration", &self.template_configuration);
        formatter.field("treatment_description", &self.treatment_description);
        formatter.field("treatment_name", &self.treatment_name);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`WriteCampaignRequest`](crate::model::WriteCampaignRequest)
pub mod write_campaign_request {
    /// A builder for [`WriteCampaignRequest`](crate::model::WriteCampaignRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_treatments:
            std::option::Option<std::vec::Vec<crate::model::WriteTreatmentResource>>,
        pub(crate) custom_delivery_configuration:
            std::option::Option<crate::model::CustomDeliveryConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) holdout_percent: std::option::Option<i32>,
        pub(crate) hook: std::option::Option<crate::model::CampaignHook>,
        pub(crate) is_paused: std::option::Option<bool>,
        pub(crate) limits: std::option::Option<crate::model::CampaignLimits>,
        pub(crate) message_configuration: std::option::Option<crate::model::MessageConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) segment_id: std::option::Option<std::string::String>,
        pub(crate) segment_version: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
        pub(crate) treatment_description: std::option::Option<std::string::String>,
        pub(crate) treatment_name: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `additional_treatments`.
        ///
        /// To override the contents of this collection use [`set_additional_treatments`](Self::set_additional_treatments).
        ///
        /// <p>An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.</p>
        pub fn additional_treatments(
            mut self,
            input: impl Into<crate::model::WriteTreatmentResource>,
        ) -> Self {
            let mut v = self.additional_treatments.unwrap_or_default();
            v.push(input.into());
            self.additional_treatments = Some(v);
            self
        }
        /// <p>An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.</p>
        pub fn set_additional_treatments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WriteTreatmentResource>>,
        ) -> Self {
            self.additional_treatments = input;
            self
        }
        /// <p>The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.</p>
        pub fn custom_delivery_configuration(
            mut self,
            input: crate::model::CustomDeliveryConfiguration,
        ) -> Self {
            self.custom_delivery_configuration = Some(input);
            self
        }
        /// <p>The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.</p>
        pub fn set_custom_delivery_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDeliveryConfiguration>,
        ) -> Self {
            self.custom_delivery_configuration = input;
            self
        }
        /// <p>A custom description of the campaign.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description of the campaign.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
        pub fn holdout_percent(mut self, input: i32) -> Self {
            self.holdout_percent = Some(input);
            self
        }
        /// <p>The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.</p>
        pub fn set_holdout_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.holdout_percent = input;
            self
        }
        /// <p>The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
        pub fn hook(mut self, input: crate::model::CampaignHook) -> Self {
            self.hook = Some(input);
            self
        }
        /// <p>The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.</p>
        pub fn set_hook(mut self, input: std::option::Option<crate::model::CampaignHook>) -> Self {
            self.hook = input;
            self
        }
        /// <p>Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
        pub fn is_paused(mut self, input: bool) -> Self {
            self.is_paused = Some(input);
            self
        }
        /// <p>Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this value to false.</p>
        pub fn set_is_paused(mut self, input: std::option::Option<bool>) -> Self {
            self.is_paused = input;
            self
        }
        /// <p>The messaging limits for the campaign.</p>
        pub fn limits(mut self, input: crate::model::CampaignLimits) -> Self {
            self.limits = Some(input);
            self
        }
        /// <p>The messaging limits for the campaign.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<crate::model::CampaignLimits>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>The message configuration settings for the campaign.</p>
        pub fn message_configuration(mut self, input: crate::model::MessageConfiguration) -> Self {
            self.message_configuration = Some(input);
            self
        }
        /// <p>The message configuration settings for the campaign.</p>
        pub fn set_message_configuration(
            mut self,
            input: std::option::Option<crate::model::MessageConfiguration>,
        ) -> Self {
            self.message_configuration = input;
            self
        }
        /// <p>A custom name for the campaign.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name for the campaign.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The schedule settings for the campaign.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule settings for the campaign.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The unique identifier for the segment to associate with the campaign.</p>
        pub fn segment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the segment to associate with the campaign.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.segment_id = input;
            self
        }
        /// <p>The version of the segment to associate with the campaign.</p>
        pub fn segment_version(mut self, input: i32) -> Self {
            self.segment_version = Some(input);
            self
        }
        /// <p>The version of the segment to associate with the campaign.</p>
        pub fn set_segment_version(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_version = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The message template to use for the campaign.</p>
        pub fn template_configuration(
            mut self,
            input: crate::model::TemplateConfiguration,
        ) -> Self {
            self.template_configuration = Some(input);
            self
        }
        /// <p>The message template to use for the campaign.</p>
        pub fn set_template_configuration(
            mut self,
            input: std::option::Option<crate::model::TemplateConfiguration>,
        ) -> Self {
            self.template_configuration = input;
            self
        }
        /// <p>A custom description of the default treatment for the campaign.</p>
        pub fn treatment_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_description = Some(input.into());
            self
        }
        /// <p>A custom description of the default treatment for the campaign.</p>
        pub fn set_treatment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_description = input;
            self
        }
        /// <p>A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
        pub fn treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_name = Some(input.into());
            self
        }
        /// <p>A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that's used for A/B testing.</p>
        pub fn set_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_name = input;
            self
        }
        /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteCampaignRequest`](crate::model::WriteCampaignRequest)
        pub fn build(self) -> crate::model::WriteCampaignRequest {
            crate::model::WriteCampaignRequest {
                additional_treatments: self.additional_treatments,
                custom_delivery_configuration: self.custom_delivery_configuration,
                description: self.description,
                holdout_percent: self.holdout_percent.unwrap_or_default(),
                hook: self.hook,
                is_paused: self.is_paused.unwrap_or_default(),
                limits: self.limits,
                message_configuration: self.message_configuration,
                name: self.name,
                schedule: self.schedule,
                segment_id: self.segment_id,
                segment_version: self.segment_version.unwrap_or_default(),
                tags: self.tags,
                template_configuration: self.template_configuration,
                treatment_description: self.treatment_description,
                treatment_name: self.treatment_name,
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl WriteCampaignRequest {
    /// Creates a new builder-style object to manufacture [`WriteCampaignRequest`](crate::model::WriteCampaignRequest)
    pub fn builder() -> crate::model::write_campaign_request::Builder {
        crate::model::write_campaign_request::Builder::default()
    }
}

/// <p>Specifies the settings for a campaign treatment. A <i>treatment</i> is a variation of a campaign that's used for A/B testing of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteTreatmentResource {
    /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
    pub custom_delivery_configuration:
        std::option::Option<crate::model::CustomDeliveryConfiguration>,
    /// <p>The message configuration settings for the treatment.</p>
    pub message_configuration: std::option::Option<crate::model::MessageConfiguration>,
    /// <p>The schedule settings for the treatment.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The allocated percentage of users (segment members) to send the treatment to.</p>
    pub size_percent: i32,
    /// <p>The message template to use for the treatment.</p>
    pub template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
    /// <p>A custom description of the treatment.</p>
    pub treatment_description: std::option::Option<std::string::String>,
    /// <p>A custom name for the treatment.</p>
    pub treatment_name: std::option::Option<std::string::String>,
}
impl WriteTreatmentResource {
    /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
    pub fn custom_delivery_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDeliveryConfiguration> {
        self.custom_delivery_configuration.as_ref()
    }
    /// <p>The message configuration settings for the treatment.</p>
    pub fn message_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MessageConfiguration> {
        self.message_configuration.as_ref()
    }
    /// <p>The schedule settings for the treatment.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p>The allocated percentage of users (segment members) to send the treatment to.</p>
    pub fn size_percent(&self) -> i32 {
        self.size_percent
    }
    /// <p>The message template to use for the treatment.</p>
    pub fn template_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TemplateConfiguration> {
        self.template_configuration.as_ref()
    }
    /// <p>A custom description of the treatment.</p>
    pub fn treatment_description(&self) -> std::option::Option<&str> {
        self.treatment_description.as_deref()
    }
    /// <p>A custom name for the treatment.</p>
    pub fn treatment_name(&self) -> std::option::Option<&str> {
        self.treatment_name.as_deref()
    }
}
impl std::fmt::Debug for WriteTreatmentResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteTreatmentResource");
        formatter.field(
            "custom_delivery_configuration",
            &self.custom_delivery_configuration,
        );
        formatter.field("message_configuration", &self.message_configuration);
        formatter.field("schedule", &self.schedule);
        formatter.field("size_percent", &self.size_percent);
        formatter.field("template_configuration", &self.template_configuration);
        formatter.field("treatment_description", &self.treatment_description);
        formatter.field("treatment_name", &self.treatment_name);
        formatter.finish()
    }
}
/// See [`WriteTreatmentResource`](crate::model::WriteTreatmentResource)
pub mod write_treatment_resource {
    /// A builder for [`WriteTreatmentResource`](crate::model::WriteTreatmentResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_delivery_configuration:
            std::option::Option<crate::model::CustomDeliveryConfiguration>,
        pub(crate) message_configuration: std::option::Option<crate::model::MessageConfiguration>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) size_percent: std::option::Option<i32>,
        pub(crate) template_configuration: std::option::Option<crate::model::TemplateConfiguration>,
        pub(crate) treatment_description: std::option::Option<std::string::String>,
        pub(crate) treatment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
        pub fn custom_delivery_configuration(
            mut self,
            input: crate::model::CustomDeliveryConfiguration,
        ) -> Self {
            self.custom_delivery_configuration = Some(input);
            self
        }
        /// <p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>
        pub fn set_custom_delivery_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDeliveryConfiguration>,
        ) -> Self {
            self.custom_delivery_configuration = input;
            self
        }
        /// <p>The message configuration settings for the treatment.</p>
        pub fn message_configuration(mut self, input: crate::model::MessageConfiguration) -> Self {
            self.message_configuration = Some(input);
            self
        }
        /// <p>The message configuration settings for the treatment.</p>
        pub fn set_message_configuration(
            mut self,
            input: std::option::Option<crate::model::MessageConfiguration>,
        ) -> Self {
            self.message_configuration = input;
            self
        }
        /// <p>The schedule settings for the treatment.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule settings for the treatment.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The allocated percentage of users (segment members) to send the treatment to.</p>
        pub fn size_percent(mut self, input: i32) -> Self {
            self.size_percent = Some(input);
            self
        }
        /// <p>The allocated percentage of users (segment members) to send the treatment to.</p>
        pub fn set_size_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.size_percent = input;
            self
        }
        /// <p>The message template to use for the treatment.</p>
        pub fn template_configuration(
            mut self,
            input: crate::model::TemplateConfiguration,
        ) -> Self {
            self.template_configuration = Some(input);
            self
        }
        /// <p>The message template to use for the treatment.</p>
        pub fn set_template_configuration(
            mut self,
            input: std::option::Option<crate::model::TemplateConfiguration>,
        ) -> Self {
            self.template_configuration = input;
            self
        }
        /// <p>A custom description of the treatment.</p>
        pub fn treatment_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_description = Some(input.into());
            self
        }
        /// <p>A custom description of the treatment.</p>
        pub fn set_treatment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_description = input;
            self
        }
        /// <p>A custom name for the treatment.</p>
        pub fn treatment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.treatment_name = Some(input.into());
            self
        }
        /// <p>A custom name for the treatment.</p>
        pub fn set_treatment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treatment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteTreatmentResource`](crate::model::WriteTreatmentResource)
        pub fn build(self) -> crate::model::WriteTreatmentResource {
            crate::model::WriteTreatmentResource {
                custom_delivery_configuration: self.custom_delivery_configuration,
                message_configuration: self.message_configuration,
                schedule: self.schedule,
                size_percent: self.size_percent.unwrap_or_default(),
                template_configuration: self.template_configuration,
                treatment_description: self.treatment_description,
                treatment_name: self.treatment_name,
            }
        }
    }
}
impl WriteTreatmentResource {
    /// Creates a new builder-style object to manufacture [`WriteTreatmentResource`](crate::model::WriteTreatmentResource)
    pub fn builder() -> crate::model::write_treatment_resource::Builder {
        crate::model::write_treatment_resource::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaiduChannelResponse {
    /// <p>The unique identifier for the application that the Baidu channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the Baidu channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
    pub credential: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Baidu channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>(Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Baidu channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the Baidu channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the Baidu channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current version of the Baidu channel.</p>
    pub version: i32,
}
impl BaiduChannelResponse {
    /// <p>The unique identifier for the application that the Baidu channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time when the Baidu channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
    pub fn credential(&self) -> std::option::Option<&str> {
        self.credential.as_deref()
    }
    /// <p>Specifies whether the Baidu channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>(Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the Baidu channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the Baidu channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time when the Baidu channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current version of the Baidu channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for BaiduChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaiduChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("credential", &self.credential);
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`BaiduChannelResponse`](crate::model::BaiduChannelResponse)
pub mod baidu_channel_response {
    /// A builder for [`BaiduChannelResponse`](crate::model::BaiduChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) credential: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the Baidu channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the Baidu channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time when the Baidu channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time when the Baidu channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
        pub fn credential(mut self, input: impl Into<std::string::String>) -> Self {
            self.credential = Some(input.into());
            self
        }
        /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
        pub fn set_credential(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credential = input;
            self
        }
        /// <p>Specifies whether the Baidu channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the Baidu channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>(Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the Baidu channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the Baidu channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the Baidu channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the Baidu channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time when the Baidu channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time when the Baidu channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current version of the Baidu channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the Baidu channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`BaiduChannelResponse`](crate::model::BaiduChannelResponse)
        pub fn build(self) -> crate::model::BaiduChannelResponse {
            crate::model::BaiduChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                credential: self.credential,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl BaiduChannelResponse {
    /// Creates a new builder-style object to manufacture [`BaiduChannelResponse`](crate::model::BaiduChannelResponse)
    pub fn builder() -> crate::model::baidu_channel_response::Builder {
        crate::model::baidu_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaiduChannelRequest {
    /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
    pub api_key: std::option::Option<std::string::String>,
    /// <p>Specifies whether to enable the Baidu channel for the application.</p>
    pub enabled: bool,
    /// <p>The secret key that you received from the Baidu Cloud Push service to communicate with the service.</p>
    pub secret_key: std::option::Option<std::string::String>,
}
impl BaiduChannelRequest {
    /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
    pub fn api_key(&self) -> std::option::Option<&str> {
        self.api_key.as_deref()
    }
    /// <p>Specifies whether to enable the Baidu channel for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The secret key that you received from the Baidu Cloud Push service to communicate with the service.</p>
    pub fn secret_key(&self) -> std::option::Option<&str> {
        self.secret_key.as_deref()
    }
}
impl std::fmt::Debug for BaiduChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaiduChannelRequest");
        formatter.field("api_key", &self.api_key);
        formatter.field("enabled", &self.enabled);
        formatter.field("secret_key", &self.secret_key);
        formatter.finish()
    }
}
/// See [`BaiduChannelRequest`](crate::model::BaiduChannelRequest)
pub mod baidu_channel_request {
    /// A builder for [`BaiduChannelRequest`](crate::model::BaiduChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) secret_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// <p>Specifies whether to enable the Baidu channel for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the Baidu channel for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The secret key that you received from the Baidu Cloud Push service to communicate with the service.</p>
        pub fn secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_key = Some(input.into());
            self
        }
        /// <p>The secret key that you received from the Baidu Cloud Push service to communicate with the service.</p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_key = input;
            self
        }
        /// Consumes the builder and constructs a [`BaiduChannelRequest`](crate::model::BaiduChannelRequest)
        pub fn build(self) -> crate::model::BaiduChannelRequest {
            crate::model::BaiduChannelRequest {
                api_key: self.api_key,
                enabled: self.enabled.unwrap_or_default(),
                secret_key: self.secret_key,
            }
        }
    }
}
impl BaiduChannelRequest {
    /// Creates a new builder-style object to manufacture [`BaiduChannelRequest`](crate::model::BaiduChannelRequest)
    pub fn builder() -> crate::model::baidu_channel_request::Builder {
        crate::model::baidu_channel_request::Builder::default()
    }
}

/// <p>Provides information about an application, including the default settings for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSettingsResource {
    /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p>
    pub campaign_hook: std::option::Option<crate::model::CampaignHook>,
    /// <p>The date and time, in ISO 8601 format, when the application's settings were last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The default sending limits for campaigns in the application.</p>
    pub limits: std::option::Option<crate::model::CampaignLimits>,
    /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p>
    pub quiet_time: std::option::Option<crate::model::QuietTime>,
}
impl ApplicationSettingsResource {
    /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p>
    pub fn campaign_hook(&self) -> std::option::Option<&crate::model::CampaignHook> {
        self.campaign_hook.as_ref()
    }
    /// <p>The date and time, in ISO 8601 format, when the application's settings were last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The default sending limits for campaigns in the application.</p>
    pub fn limits(&self) -> std::option::Option<&crate::model::CampaignLimits> {
        self.limits.as_ref()
    }
    /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p>
    pub fn quiet_time(&self) -> std::option::Option<&crate::model::QuietTime> {
        self.quiet_time.as_ref()
    }
}
impl std::fmt::Debug for ApplicationSettingsResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSettingsResource");
        formatter.field("application_id", &self.application_id);
        formatter.field("campaign_hook", &self.campaign_hook);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("limits", &self.limits);
        formatter.field("quiet_time", &self.quiet_time);
        formatter.finish()
    }
}
/// See [`ApplicationSettingsResource`](crate::model::ApplicationSettingsResource)
pub mod application_settings_resource {
    /// A builder for [`ApplicationSettingsResource`](crate::model::ApplicationSettingsResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) campaign_hook: std::option::Option<crate::model::CampaignHook>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) limits: std::option::Option<crate::model::CampaignLimits>,
        pub(crate) quiet_time: std::option::Option<crate::model::QuietTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p>
        pub fn campaign_hook(mut self, input: crate::model::CampaignHook) -> Self {
            self.campaign_hook = Some(input);
            self
        }
        /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p>
        pub fn set_campaign_hook(
            mut self,
            input: std::option::Option<crate::model::CampaignHook>,
        ) -> Self {
            self.campaign_hook = input;
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the application's settings were last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO 8601 format, when the application's settings were last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The default sending limits for campaigns in the application.</p>
        pub fn limits(mut self, input: crate::model::CampaignLimits) -> Self {
            self.limits = Some(input);
            self
        }
        /// <p>The default sending limits for campaigns in the application.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<crate::model::CampaignLimits>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p>
        pub fn quiet_time(mut self, input: crate::model::QuietTime) -> Self {
            self.quiet_time = Some(input);
            self
        }
        /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p>
        pub fn set_quiet_time(
            mut self,
            input: std::option::Option<crate::model::QuietTime>,
        ) -> Self {
            self.quiet_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSettingsResource`](crate::model::ApplicationSettingsResource)
        pub fn build(self) -> crate::model::ApplicationSettingsResource {
            crate::model::ApplicationSettingsResource {
                application_id: self.application_id,
                campaign_hook: self.campaign_hook,
                last_modified_date: self.last_modified_date,
                limits: self.limits,
                quiet_time: self.quiet_time,
            }
        }
    }
}
impl ApplicationSettingsResource {
    /// Creates a new builder-style object to manufacture [`ApplicationSettingsResource`](crate::model::ApplicationSettingsResource)
    pub fn builder() -> crate::model::application_settings_resource::Builder {
        crate::model::application_settings_resource::Builder::default()
    }
}

/// <p>Specifies the default settings for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteApplicationSettingsRequest {
    /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p> <p>To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.</p>
    pub campaign_hook: std::option::Option<crate::model::CampaignHook>,
    /// <p>Specifies whether to enable application-related alarms in Amazon CloudWatch.</p>
    pub cloud_watch_metrics_enabled: bool,
    #[allow(missing_docs)] // documentation missing in model
    pub event_tagging_enabled: bool,
    /// <p>The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.</p>
    pub limits: std::option::Option<crate::model::CampaignLimits>,
    /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p> <p>To override the default quiet time settings for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for the campaign or journey.</p>
    pub quiet_time: std::option::Option<crate::model::QuietTime>,
}
impl WriteApplicationSettingsRequest {
    /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p> <p>To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.</p>
    pub fn campaign_hook(&self) -> std::option::Option<&crate::model::CampaignHook> {
        self.campaign_hook.as_ref()
    }
    /// <p>Specifies whether to enable application-related alarms in Amazon CloudWatch.</p>
    pub fn cloud_watch_metrics_enabled(&self) -> bool {
        self.cloud_watch_metrics_enabled
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn event_tagging_enabled(&self) -> bool {
        self.event_tagging_enabled
    }
    /// <p>The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.</p>
    pub fn limits(&self) -> std::option::Option<&crate::model::CampaignLimits> {
        self.limits.as_ref()
    }
    /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p> <p>To override the default quiet time settings for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for the campaign or journey.</p>
    pub fn quiet_time(&self) -> std::option::Option<&crate::model::QuietTime> {
        self.quiet_time.as_ref()
    }
}
impl std::fmt::Debug for WriteApplicationSettingsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteApplicationSettingsRequest");
        formatter.field("campaign_hook", &self.campaign_hook);
        formatter.field(
            "cloud_watch_metrics_enabled",
            &self.cloud_watch_metrics_enabled,
        );
        formatter.field("event_tagging_enabled", &self.event_tagging_enabled);
        formatter.field("limits", &self.limits);
        formatter.field("quiet_time", &self.quiet_time);
        formatter.finish()
    }
}
/// See [`WriteApplicationSettingsRequest`](crate::model::WriteApplicationSettingsRequest)
pub mod write_application_settings_request {
    /// A builder for [`WriteApplicationSettingsRequest`](crate::model::WriteApplicationSettingsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_hook: std::option::Option<crate::model::CampaignHook>,
        pub(crate) cloud_watch_metrics_enabled: std::option::Option<bool>,
        pub(crate) event_tagging_enabled: std::option::Option<bool>,
        pub(crate) limits: std::option::Option<crate::model::CampaignLimits>,
        pub(crate) quiet_time: std::option::Option<crate::model::QuietTime>,
    }
    impl Builder {
        /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p> <p>To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.</p>
        pub fn campaign_hook(mut self, input: crate::model::CampaignHook) -> Self {
            self.campaign_hook = Some(input);
            self
        }
        /// <p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p> <p>To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.</p>
        pub fn set_campaign_hook(
            mut self,
            input: std::option::Option<crate::model::CampaignHook>,
        ) -> Self {
            self.campaign_hook = input;
            self
        }
        /// <p>Specifies whether to enable application-related alarms in Amazon CloudWatch.</p>
        pub fn cloud_watch_metrics_enabled(mut self, input: bool) -> Self {
            self.cloud_watch_metrics_enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable application-related alarms in Amazon CloudWatch.</p>
        pub fn set_cloud_watch_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cloud_watch_metrics_enabled = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn event_tagging_enabled(mut self, input: bool) -> Self {
            self.event_tagging_enabled = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_event_tagging_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.event_tagging_enabled = input;
            self
        }
        /// <p>The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.</p>
        pub fn limits(mut self, input: crate::model::CampaignLimits) -> Self {
            self.limits = Some(input);
            self
        }
        /// <p>The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<crate::model::CampaignLimits>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p> <p>To override the default quiet time settings for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for the campaign or journey.</p>
        pub fn quiet_time(mut self, input: crate::model::QuietTime) -> Self {
            self.quiet_time = Some(input);
            self
        }
        /// <p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p> <p>To override the default quiet time settings for a specific campaign or journey, use the <link  linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link  linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for the campaign or journey.</p>
        pub fn set_quiet_time(
            mut self,
            input: std::option::Option<crate::model::QuietTime>,
        ) -> Self {
            self.quiet_time = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteApplicationSettingsRequest`](crate::model::WriteApplicationSettingsRequest)
        pub fn build(self) -> crate::model::WriteApplicationSettingsRequest {
            crate::model::WriteApplicationSettingsRequest {
                campaign_hook: self.campaign_hook,
                cloud_watch_metrics_enabled: self.cloud_watch_metrics_enabled.unwrap_or_default(),
                event_tagging_enabled: self.event_tagging_enabled.unwrap_or_default(),
                limits: self.limits,
                quiet_time: self.quiet_time,
            }
        }
    }
}
impl WriteApplicationSettingsRequest {
    /// Creates a new builder-style object to manufacture [`WriteApplicationSettingsRequest`](crate::model::WriteApplicationSettingsRequest)
    pub fn builder() -> crate::model::write_application_settings_request::Builder {
        crate::model::write_application_settings_request::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsVoipSandboxChannelResponse {
    /// <p>The unique identifier for the application that the APNs VoIP sandbox channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the APNs VoIP sandbox channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
    pub default_authentication_method: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
    pub has_token_key: bool,
    /// <p>(Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs VoIP sandbox channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the APNs VoIP sandbox channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the APNs VoIP sandbox channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current version of the APNs VoIP sandbox channel.</p>
    pub version: i32,
}
impl ApnsVoipSandboxChannelResponse {
    /// <p>The unique identifier for the application that the APNs VoIP sandbox channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time when the APNs VoIP sandbox channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
    pub fn default_authentication_method(&self) -> std::option::Option<&str> {
        self.default_authentication_method.as_deref()
    }
    /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
    pub fn has_token_key(&self) -> bool {
        self.has_token_key
    }
    /// <p>(Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the APNs VoIP sandbox channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the APNs VoIP sandbox channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time when the APNs VoIP sandbox channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current version of the APNs VoIP sandbox channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for ApnsVoipSandboxChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApnsVoipSandboxChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field(
            "default_authentication_method",
            &self.default_authentication_method,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("has_token_key", &self.has_token_key);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ApnsVoipSandboxChannelResponse`](crate::model::ApnsVoipSandboxChannelResponse)
pub mod apns_voip_sandbox_channel_response {
    /// A builder for [`ApnsVoipSandboxChannelResponse`](crate::model::ApnsVoipSandboxChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) default_authentication_method: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) has_token_key: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the APNs VoIP sandbox channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the APNs VoIP sandbox channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time when the APNs VoIP sandbox channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time when the APNs VoIP sandbox channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
        pub fn default_authentication_method(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_authentication_method = Some(input.into());
            self
        }
        /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
        pub fn set_default_authentication_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_authentication_method = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
        pub fn has_token_key(mut self, input: bool) -> Self {
            self.has_token_key = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
        pub fn set_has_token_key(mut self, input: std::option::Option<bool>) -> Self {
            self.has_token_key = input;
            self
        }
        /// <p>(Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the APNs VoIP sandbox channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the APNs VoIP sandbox channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time when the APNs VoIP sandbox channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time when the APNs VoIP sandbox channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current version of the APNs VoIP sandbox channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the APNs VoIP sandbox channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ApnsVoipSandboxChannelResponse`](crate::model::ApnsVoipSandboxChannelResponse)
        pub fn build(self) -> crate::model::ApnsVoipSandboxChannelResponse {
            crate::model::ApnsVoipSandboxChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                default_authentication_method: self.default_authentication_method,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                has_token_key: self.has_token_key.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl ApnsVoipSandboxChannelResponse {
    /// Creates a new builder-style object to manufacture [`ApnsVoipSandboxChannelResponse`](crate::model::ApnsVoipSandboxChannelResponse)
    pub fn builder() -> crate::model::apns_voip_sandbox_channel_response::Builder {
        crate::model::apns_voip_sandbox_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsVoipSandboxChannelRequest {
    /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.</p>
    pub default_authentication_method: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>
    pub private_key: std::option::Option<std::string::String>,
    /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
    pub team_id: std::option::Option<std::string::String>,
    /// <p>The authentication key to use for APNs tokens.</p>
    pub token_key: std::option::Option<std::string::String>,
    /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.</p>
    pub token_key_id: std::option::Option<std::string::String>,
}
impl ApnsVoipSandboxChannelRequest {
    /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.</p>
    pub fn default_authentication_method(&self) -> std::option::Option<&str> {
        self.default_authentication_method.as_deref()
    }
    /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>
    pub fn private_key(&self) -> std::option::Option<&str> {
        self.private_key.as_deref()
    }
    /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
    pub fn team_id(&self) -> std::option::Option<&str> {
        self.team_id.as_deref()
    }
    /// <p>The authentication key to use for APNs tokens.</p>
    pub fn token_key(&self) -> std::option::Option<&str> {
        self.token_key.as_deref()
    }
    /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.</p>
    pub fn token_key_id(&self) -> std::option::Option<&str> {
        self.token_key_id.as_deref()
    }
}
impl std::fmt::Debug for ApnsVoipSandboxChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApnsVoipSandboxChannelRequest");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("certificate", &self.certificate);
        formatter.field(
            "default_authentication_method",
            &self.default_authentication_method,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field("private_key", &self.private_key);
        formatter.field("team_id", &self.team_id);
        formatter.field("token_key", &self.token_key);
        formatter.field("token_key_id", &self.token_key_id);
        formatter.finish()
    }
}
/// See [`ApnsVoipSandboxChannelRequest`](crate::model::ApnsVoipSandboxChannelRequest)
pub mod apns_voip_sandbox_channel_request {
    /// A builder for [`ApnsVoipSandboxChannelRequest`](crate::model::ApnsVoipSandboxChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) default_authentication_method: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) private_key: std::option::Option<std::string::String>,
        pub(crate) team_id: std::option::Option<std::string::String>,
        pub(crate) token_key: std::option::Option<std::string::String>,
        pub(crate) token_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.</p>
        pub fn default_authentication_method(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_authentication_method = Some(input.into());
            self
        }
        /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.</p>
        pub fn set_default_authentication_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_authentication_method = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
        pub fn team_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.team_id = Some(input.into());
            self
        }
        /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
        pub fn set_team_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.team_id = input;
            self
        }
        /// <p>The authentication key to use for APNs tokens.</p>
        pub fn token_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_key = Some(input.into());
            self
        }
        /// <p>The authentication key to use for APNs tokens.</p>
        pub fn set_token_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_key = input;
            self
        }
        /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.</p>
        pub fn token_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_key_id = Some(input.into());
            self
        }
        /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.</p>
        pub fn set_token_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApnsVoipSandboxChannelRequest`](crate::model::ApnsVoipSandboxChannelRequest)
        pub fn build(self) -> crate::model::ApnsVoipSandboxChannelRequest {
            crate::model::ApnsVoipSandboxChannelRequest {
                bundle_id: self.bundle_id,
                certificate: self.certificate,
                default_authentication_method: self.default_authentication_method,
                enabled: self.enabled.unwrap_or_default(),
                private_key: self.private_key,
                team_id: self.team_id,
                token_key: self.token_key,
                token_key_id: self.token_key_id,
            }
        }
    }
}
impl ApnsVoipSandboxChannelRequest {
    /// Creates a new builder-style object to manufacture [`ApnsVoipSandboxChannelRequest`](crate::model::ApnsVoipSandboxChannelRequest)
    pub fn builder() -> crate::model::apns_voip_sandbox_channel_request::Builder {
        crate::model::apns_voip_sandbox_channel_request::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsVoipChannelResponse {
    /// <p>The unique identifier for the application that the APNs VoIP channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the APNs VoIP channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.</p>
    pub default_authentication_method: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs VoIP channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
    pub has_token_key: bool,
    /// <p>(Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs VoIP channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the APNs VoIP channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the APNs VoIP channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current version of the APNs VoIP channel.</p>
    pub version: i32,
}
impl ApnsVoipChannelResponse {
    /// <p>The unique identifier for the application that the APNs VoIP channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time when the APNs VoIP channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.</p>
    pub fn default_authentication_method(&self) -> std::option::Option<&str> {
        self.default_authentication_method.as_deref()
    }
    /// <p>Specifies whether the APNs VoIP channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
    pub fn has_token_key(&self) -> bool {
        self.has_token_key
    }
    /// <p>(Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the APNs VoIP channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the APNs VoIP channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time when the APNs VoIP channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current version of the APNs VoIP channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for ApnsVoipChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApnsVoipChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field(
            "default_authentication_method",
            &self.default_authentication_method,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("has_token_key", &self.has_token_key);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ApnsVoipChannelResponse`](crate::model::ApnsVoipChannelResponse)
pub mod apns_voip_channel_response {
    /// A builder for [`ApnsVoipChannelResponse`](crate::model::ApnsVoipChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) default_authentication_method: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) has_token_key: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the APNs VoIP channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the APNs VoIP channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time when the APNs VoIP channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time when the APNs VoIP channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.</p>
        pub fn default_authentication_method(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_authentication_method = Some(input.into());
            self
        }
        /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.</p>
        pub fn set_default_authentication_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_authentication_method = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
        pub fn has_token_key(mut self, input: bool) -> Self {
            self.has_token_key = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
        pub fn set_has_token_key(mut self, input: std::option::Option<bool>) -> Self {
            self.has_token_key = input;
            self
        }
        /// <p>(Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the APNs VoIP channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the APNs VoIP channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the APNs VoIP channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the APNs VoIP channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time when the APNs VoIP channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time when the APNs VoIP channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current version of the APNs VoIP channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the APNs VoIP channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ApnsVoipChannelResponse`](crate::model::ApnsVoipChannelResponse)
        pub fn build(self) -> crate::model::ApnsVoipChannelResponse {
            crate::model::ApnsVoipChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                default_authentication_method: self.default_authentication_method,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                has_token_key: self.has_token_key.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl ApnsVoipChannelResponse {
    /// Creates a new builder-style object to manufacture [`ApnsVoipChannelResponse`](crate::model::ApnsVoipChannelResponse)
    pub fn builder() -> crate::model::apns_voip_channel_response::Builder {
        crate::model::apns_voip_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsVoipChannelRequest {
    /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or certificate.</p>
    pub default_authentication_method: std::option::Option<std::string::String>,
    /// <p>Specifies whether to enable the APNs VoIP channel for the application.</p>
    pub enabled: bool,
    /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.</p>
    pub private_key: std::option::Option<std::string::String>,
    /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
    pub team_id: std::option::Option<std::string::String>,
    /// <p>The authentication key to use for APNs tokens.</p>
    pub token_key: std::option::Option<std::string::String>,
    /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.</p>
    pub token_key_id: std::option::Option<std::string::String>,
}
impl ApnsVoipChannelRequest {
    /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or certificate.</p>
    pub fn default_authentication_method(&self) -> std::option::Option<&str> {
        self.default_authentication_method.as_deref()
    }
    /// <p>Specifies whether to enable the APNs VoIP channel for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.</p>
    pub fn private_key(&self) -> std::option::Option<&str> {
        self.private_key.as_deref()
    }
    /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
    pub fn team_id(&self) -> std::option::Option<&str> {
        self.team_id.as_deref()
    }
    /// <p>The authentication key to use for APNs tokens.</p>
    pub fn token_key(&self) -> std::option::Option<&str> {
        self.token_key.as_deref()
    }
    /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.</p>
    pub fn token_key_id(&self) -> std::option::Option<&str> {
        self.token_key_id.as_deref()
    }
}
impl std::fmt::Debug for ApnsVoipChannelRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApnsVoipChannelRequest");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("certificate", &self.certificate);
        formatter.field(
            "default_authentication_method",
            &self.default_authentication_method,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field("private_key", &self.private_key);
        formatter.field("team_id", &self.team_id);
        formatter.field("token_key", &self.token_key);
        formatter.field("token_key_id", &self.token_key_id);
        formatter.finish()
    }
}
/// See [`ApnsVoipChannelRequest`](crate::model::ApnsVoipChannelRequest)
pub mod apns_voip_channel_request {
    /// A builder for [`ApnsVoipChannelRequest`](crate::model::ApnsVoipChannelRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) default_authentication_method: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) private_key: std::option::Option<std::string::String>,
        pub(crate) team_id: std::option::Option<std::string::String>,
        pub(crate) token_key: std::option::Option<std::string::String>,
        pub(crate) token_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or certificate.</p>
        pub fn default_authentication_method(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_authentication_method = Some(input.into());
            self
        }
        /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or certificate.</p>
        pub fn set_default_authentication_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_authentication_method = input;
            self
        }
        /// <p>Specifies whether to enable the APNs VoIP channel for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the APNs VoIP channel for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
        pub fn team_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.team_id = Some(input.into());
            self
        }
        /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
        pub fn set_team_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.team_id = input;
            self
        }
        /// <p>The authentication key to use for APNs tokens.</p>
        pub fn token_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_key = Some(input.into());
            self
        }
        /// <p>The authentication key to use for APNs tokens.</p>
        pub fn set_token_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_key = input;
            self
        }
        /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.</p>
        pub fn token_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_key_id = Some(input.into());
            self
        }
        /// <p>The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.</p>
        pub fn set_token_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApnsVoipChannelRequest`](crate::model::ApnsVoipChannelRequest)
        pub fn build(self) -> crate::model::ApnsVoipChannelRequest {
            crate::model::ApnsVoipChannelRequest {
                bundle_id: self.bundle_id,
                certificate: self.certificate,
                default_authentication_method: self.default_authentication_method,
                enabled: self.enabled.unwrap_or_default(),
                private_key: self.private_key,
                team_id: self.team_id,
                token_key: self.token_key,
                token_key_id: self.token_key_id,
            }
        }
    }
}
impl ApnsVoipChannelRequest {
    /// Creates a new builder-style object to manufacture [`ApnsVoipChannelRequest`](crate::model::ApnsVoipChannelRequest)
    pub fn builder() -> crate::model::apns_voip_channel_request::Builder {
        crate::model::apns_voip_channel_request::Builder::default()
    }
}

/// <p>Provides information about the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsSandboxChannelResponse {
    /// <p>The unique identifier for the application that the APNs sandbox channel applies to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the APNs sandbox channel was enabled.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
    pub default_authentication_method: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs sandbox channel is enabled for the application.</p>
    pub enabled: bool,
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub has_credential: bool,
    /// <p>Specifies whether the APNs sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
    pub has_token_key: bool,
    /// <p>(Deprecated) An identifier for the APNs sandbox channel. This property is retained only for backward compatibility.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the APNs sandbox channel is archived.</p>
    pub is_archived: bool,
    /// <p>The user who last modified the APNs sandbox channel.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the APNs sandbox channel was last modified.</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The type of messaging or notification platform for the channel. For the APNs sandbox channel, this value is APNS_SANDBOX.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current version of the APNs sandbox channel.</p>
    pub version: i32,
}
impl ApnsSandboxChannelResponse {
    /// <p>The unique identifier for the application that the APNs sandbox channel applies to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time when the APNs sandbox channel was enabled.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
    pub fn default_authentication_method(&self) -> std::option::Option<&str> {
        self.default_authentication_method.as_deref()
    }
    /// <p>Specifies whether the APNs sandbox channel is enabled for the application.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>(Not used) This property is retained only for backward compatibility.</p>
    pub fn has_credential(&self) -> bool {
        self.has_credential
    }
    /// <p>Specifies whether the APNs sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
    pub fn has_token_key(&self) -> bool {
        self.has_token_key
    }
    /// <p>(Deprecated) An identifier for the APNs sandbox channel. This property is retained only for backward compatibility.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the APNs sandbox channel is archived.</p>
    pub fn is_archived(&self) -> bool {
        self.is_archived
    }
    /// <p>The user who last modified the APNs sandbox channel.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time when the APNs sandbox channel was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The type of messaging or notification platform for the channel. For the APNs sandbox channel, this value is APNS_SANDBOX.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current version of the APNs sandbox channel.</p>
    pub fn version(&self) -> i32 {
        self.version
    }
}
impl std::fmt::Debug for ApnsSandboxChannelResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApnsSandboxChannelResponse");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field(
            "default_authentication_method",
            &self.default_authentication_method,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field("has_credential", &self.has_credential);
        formatter.field("has_token_key", &self.has_token_key);
        formatter.field("id", &self.id);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("platform", &self.platform);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ApnsSandboxChannelResponse`](crate::model::ApnsSandboxChannelResponse)
pub mod apns_sandbox_channel_response {
    /// A builder for [`ApnsSandboxChannelResponse`](crate::model::ApnsSandboxChannelResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) default_authentication_method: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) has_credential: std::option::Option<bool>,
        pub(crate) has_token_key: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the application that the APNs sandbox channel applies to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the application that the APNs sandbox channel applies to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time when the APNs sandbox channel was enabled.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date and time when the APNs sandbox channel was enabled.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
        pub fn default_authentication_method(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_authentication_method = Some(input.into());
            self
        }
        /// <p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>
        pub fn set_default_authentication_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_authentication_method = input;
            self
        }
        /// <p>Specifies whether the APNs sandbox channel is enabled for the application.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the APNs sandbox channel is enabled for the application.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn has_credential(mut self, input: bool) -> Self {
            self.has_credential = Some(input);
            self
        }
        /// <p>(Not used) This property is retained only for backward compatibility.</p>
        pub fn set_has_credential(mut self, input: std::option::Option<bool>) -> Self {
            self.has_credential = input;
            self
        }
        /// <p>Specifies whether the APNs sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
        pub fn has_token_key(mut self, input: bool) -> Self {
            self.has_token_key = Some(input);
            self
        }
        /// <p>Specifies whether the APNs sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>
        pub fn set_has_token_key(mut self, input: std::option::Option<bool>) -> Self {
            self.has_token_key = input;
            self
        }
        /// <p>(Deprecated) An identifier for the APNs sandbox channel. This property is retained only for backward compatibility.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>(Deprecated) An identifier for the APNs sandbox channel. This property is retained only for backward compatibility.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the APNs sandbox channel is archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Specifies whether the APNs sandbox channel is archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// <p>The user who last modified the APNs sandbox channel.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The user who last modified the APNs sandbox channel.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time when the APNs sandbox channel was last modified.</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The date and time when the APNs sandbox channel was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the APNs sandbox channel, this value is APNS_SANDBOX.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The type of messaging or notification platform for the channel. For the APNs sandbox channel, this value is APNS_SANDBOX.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current version of the APNs sandbox channel.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the APNs sandbox channel.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ApnsSandboxChannelResponse`](crate::model::ApnsSandboxChannelResponse)
        pub fn build(self) -> crate::model::ApnsSandboxChannelResponse {
            crate::model::ApnsSandboxChannelResponse {
                application_id: self.application_id,
                creation_date: self.creation_date,
                default_authentication_method: self.default_authentication_method,
                enabled: self.enabled.unwrap_or_default(),
                has_credential: self.has_credential.unwrap_or_default(),
                has_token_key: self.has_token_key.unwrap_or_default(),
                id: self.id,
                is_archived: self.is_archived.unwrap_or_default(),
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                platform: self.platform,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl ApnsSandboxChannelResponse {
    /// Creates a new builder-style object to manufacture [`ApnsSandboxChannelResponse`](crate::model::ApnsSandboxChannelResponse)
    pub fn builder() -> crate::model::apns_sandbox_channel_response::Builder {
        crate::model::apns_sandbox_channel_response::Builder::default()
    }
}

/// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApnsSandboxChannelRequest {
    /// <p>The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment, key or certificate.</p>
    pub default_authentication_method: std::option::Option<std::string::String>,
    /// <p>Specifies whether to enable the APNs sandbox channel for the application.</p>
    pub enabled: bool,
    /// <p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>
    pub private_key: std::option::Option<std::string::String>,
    /// <p>The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>
    pub team_id: std::option::Option<std::string::String>,
    /// <p>The aut