// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppError {
    /// Kind of error that occurred.
    pub kind: CreateAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppError {
    fn code(&self) -> Option<&str> {
        CreateAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppError {
    /// Creates a new `CreateAppError`.
    pub fn new(kind: CreateAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::MethodNotAllowedException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for CreateAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAppErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAppErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateAppErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateAppErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAppErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            CreateAppErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCampaignError {
    /// Kind of error that occurred.
    pub kind: CreateCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCampaignErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCampaignErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCampaignError {
    fn code(&self) -> Option<&str> {
        CreateCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCampaignError {
    /// Creates a new `CreateCampaignError`.
    pub fn new(kind: CreateCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCampaignErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateCampaignErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateCampaignErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateCampaignErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCampaignErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateCampaignErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateCampaignErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateCampaignErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateCampaignErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateCampaignErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            CreateCampaignErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEmailTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEmailTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateEmailTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateEmailTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateEmailTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateEmailTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEmailTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEmailTemplateError {
    fn code(&self) -> Option<&str> {
        CreateEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEmailTemplateError {
    /// Creates a new `CreateEmailTemplateError`.
    pub fn new(kind: CreateEmailTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEmailTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEmailTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEmailTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEmailTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateEmailTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateEmailTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateEmailTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateEmailTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEmailTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExportJobError {
    /// Kind of error that occurred.
    pub kind: CreateExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExportJobErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExportJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExportJobError {
    fn code(&self) -> Option<&str> {
        CreateExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExportJobError {
    /// Creates a new `CreateExportJobError`.
    pub fn new(kind: CreateExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateExportJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateExportJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportJobErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportJobErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateExportJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportJobErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExportJobErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateExportJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateExportJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateExportJobErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateExportJobErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateExportJobErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            CreateExportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateImportJobError {
    /// Kind of error that occurred.
    pub kind: CreateImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateImportJobErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateImportJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateImportJobError {
    fn code(&self) -> Option<&str> {
        CreateImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateImportJobError {
    /// Creates a new `CreateImportJobError`.
    pub fn new(kind: CreateImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateImportJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateImportJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImportJobErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImportJobErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateImportJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImportJobErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateImportJobErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateImportJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateImportJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateImportJobErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateImportJobErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateImportJobErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            CreateImportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInAppTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateInAppTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInAppTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInAppTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInAppTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateInAppTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateInAppTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateInAppTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateInAppTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateInAppTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInAppTemplateError {
    fn code(&self) -> Option<&str> {
        CreateInAppTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInAppTemplateError {
    /// Creates a new `CreateInAppTemplateError`.
    pub fn new(kind: CreateInAppTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInAppTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInAppTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInAppTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInAppTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInAppTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInAppTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInAppTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInAppTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInAppTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInAppTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInAppTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInAppTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInAppTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInAppTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateInAppTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInAppTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateInAppTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateInAppTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateInAppTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateInAppTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateInAppTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJourneyError {
    /// Kind of error that occurred.
    pub kind: CreateJourneyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJourneyErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJourneyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJourneyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateJourneyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJourneyError {
    fn code(&self) -> Option<&str> {
        CreateJourneyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJourneyError {
    /// Creates a new `CreateJourneyError`.
    pub fn new(kind: CreateJourneyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJourneyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJourneyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJourneyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJourneyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateJourneyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateJourneyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJourneyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJourneyErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateJourneyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJourneyErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJourneyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJourneyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateJourneyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJourneyErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateJourneyErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateJourneyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateJourneyErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateJourneyErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateJourneyErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            CreateJourneyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateJourneyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePushTemplateError {
    /// Kind of error that occurred.
    pub kind: CreatePushTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePushTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePushTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePushTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreatePushTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreatePushTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreatePushTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreatePushTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreatePushTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePushTemplateError {
    fn code(&self) -> Option<&str> {
        CreatePushTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePushTemplateError {
    /// Creates a new `CreatePushTemplateError`.
    pub fn new(kind: CreatePushTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePushTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePushTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePushTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePushTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePushTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePushTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePushTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePushTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePushTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePushTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePushTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePushTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePushTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePushTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreatePushTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePushTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreatePushTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreatePushTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreatePushTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreatePushTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreatePushTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRecommenderConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateRecommenderConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRecommenderConfigurationErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRecommenderConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRecommenderConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRecommenderConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            CreateRecommenderConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            CreateRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreateRecommenderConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRecommenderConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateRecommenderConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRecommenderConfigurationError {
    /// Creates a new `CreateRecommenderConfigurationError`.
    pub fn new(
        kind: CreateRecommenderConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRecommenderConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRecommenderConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRecommenderConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRecommenderConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateRecommenderConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRecommenderConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRecommenderConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreateRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            CreateRecommenderConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => {
                Some(_inner)
            }
            CreateRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            CreateRecommenderConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSegmentError {
    /// Kind of error that occurred.
    pub kind: CreateSegmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSegmentErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSegmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSegmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateSegmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSegmentError {
    fn code(&self) -> Option<&str> {
        CreateSegmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSegmentError {
    /// Creates a new `CreateSegmentError`.
    pub fn new(kind: CreateSegmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSegmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSegmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSegmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSegmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateSegmentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateSegmentErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSegmentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSegmentErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateSegmentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSegmentErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSegmentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSegmentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateSegmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSegmentErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSegmentErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateSegmentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateSegmentErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateSegmentErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateSegmentErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            CreateSegmentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateSegmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSmsTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateSmsTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSmsTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSmsTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSmsTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSmsTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateSmsTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateSmsTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateSmsTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateSmsTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSmsTemplateError {
    fn code(&self) -> Option<&str> {
        CreateSmsTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSmsTemplateError {
    /// Creates a new `CreateSmsTemplateError`.
    pub fn new(kind: CreateSmsTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSmsTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSmsTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSmsTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSmsTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSmsTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSmsTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSmsTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSmsTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSmsTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSmsTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSmsTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSmsTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSmsTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSmsTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateSmsTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSmsTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSmsTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateSmsTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateSmsTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateSmsTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateSmsTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVoiceTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateVoiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVoiceTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVoiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVoiceTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVoiceTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVoiceTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateVoiceTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVoiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVoiceTemplateError {
    fn code(&self) -> Option<&str> {
        CreateVoiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVoiceTemplateError {
    /// Creates a new `CreateVoiceTemplateError`.
    pub fn new(kind: CreateVoiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVoiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVoiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVoiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVoiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVoiceTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateVoiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVoiceTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVoiceTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVoiceTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateVoiceTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVoiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAdmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAdmChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteAdmChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAdmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAdmChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAdmChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAdmChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAdmChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAdmChannelError {
    fn code(&self) -> Option<&str> {
        DeleteAdmChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAdmChannelError {
    /// Creates a new `DeleteAdmChannelError`.
    pub fn new(kind: DeleteAdmChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAdmChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAdmChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAdmChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAdmChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAdmChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteAdmChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAdmChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAdmChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAdmChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAdmChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAdmChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAdmChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteAdmChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAdmChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAdmChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApnsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApnsChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteApnsChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApnsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApnsChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApnsChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApnsChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApnsChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApnsChannelError {
    fn code(&self) -> Option<&str> {
        DeleteApnsChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApnsChannelError {
    /// Creates a new `DeleteApnsChannelError`.
    pub fn new(kind: DeleteApnsChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApnsChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApnsChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApnsChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApnsChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApnsChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteApnsChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApnsChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApnsChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApnsSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApnsSandboxChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteApnsSandboxChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApnsSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApnsSandboxChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApnsSandboxChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApnsSandboxChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApnsSandboxChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteApnsSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApnsSandboxChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteApnsSandboxChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApnsSandboxChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteApnsSandboxChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApnsSandboxChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApnsSandboxChannelError {
    fn code(&self) -> Option<&str> {
        DeleteApnsSandboxChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApnsSandboxChannelError {
    /// Creates a new `DeleteApnsSandboxChannelError`.
    pub fn new(kind: DeleteApnsSandboxChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApnsSandboxChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApnsSandboxChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApnsSandboxChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApnsSandboxChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsSandboxChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsSandboxChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteApnsSandboxChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApnsSandboxChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApnsSandboxChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApnsVoipChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApnsVoipChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteApnsVoipChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApnsVoipChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApnsVoipChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApnsVoipChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApnsVoipChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApnsVoipChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApnsVoipChannelError {
    fn code(&self) -> Option<&str> {
        DeleteApnsVoipChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApnsVoipChannelError {
    /// Creates a new `DeleteApnsVoipChannelError`.
    pub fn new(kind: DeleteApnsVoipChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApnsVoipChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApnsVoipChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApnsVoipChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApnsVoipChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteApnsVoipChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApnsVoipChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApnsVoipChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApnsVoipSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApnsVoipSandboxChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteApnsVoipSandboxChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApnsVoipSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApnsVoipSandboxChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApnsVoipSandboxChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApnsVoipSandboxChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApnsVoipSandboxChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApnsVoipSandboxChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApnsVoipSandboxChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApnsVoipSandboxChannelError {
    fn code(&self) -> Option<&str> {
        DeleteApnsVoipSandboxChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApnsVoipSandboxChannelError {
    /// Creates a new `DeleteApnsVoipSandboxChannelError`.
    pub fn new(kind: DeleteApnsVoipSandboxChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApnsVoipSandboxChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApnsVoipSandboxChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApnsVoipSandboxChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApnsVoipSandboxChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApnsVoipSandboxChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteApnsVoipSandboxChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApnsVoipSandboxChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApnsVoipSandboxChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DeleteApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            DeleteApnsVoipSandboxChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApnsVoipSandboxChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppError {
    /// Kind of error that occurred.
    pub kind: DeleteAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppError {
    fn code(&self) -> Option<&str> {
        DeleteAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppError {
    /// Creates a new `DeleteAppError`.
    pub fn new(kind: DeleteAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::MethodNotAllowedException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for DeleteAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAppErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAppErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteAppErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteAppErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAppErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteAppErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBaiduChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBaiduChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteBaiduChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBaiduChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBaiduChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBaiduChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBaiduChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteBaiduChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBaiduChannelError {
    fn code(&self) -> Option<&str> {
        DeleteBaiduChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBaiduChannelError {
    /// Creates a new `DeleteBaiduChannelError`.
    pub fn new(kind: DeleteBaiduChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBaiduChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBaiduChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBaiduChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBaiduChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBaiduChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBaiduChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteBaiduChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBaiduChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteBaiduChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCampaignError {
    /// Kind of error that occurred.
    pub kind: DeleteCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCampaignErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCampaignErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCampaignError {
    fn code(&self) -> Option<&str> {
        DeleteCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCampaignError {
    /// Creates a new `DeleteCampaignError`.
    pub fn new(kind: DeleteCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCampaignErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteCampaignErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteCampaignErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteCampaignErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCampaignErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEmailChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEmailChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteEmailChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEmailChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEmailChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEmailChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEmailChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEmailChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEmailChannelError {
    fn code(&self) -> Option<&str> {
        DeleteEmailChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEmailChannelError {
    /// Creates a new `DeleteEmailChannelError`.
    pub fn new(kind: DeleteEmailChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEmailChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEmailChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEmailChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEmailChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEmailChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEmailChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEmailChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEmailTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEmailTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEmailTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEmailTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEmailTemplateError {
    /// Creates a new `DeleteEmailTemplateError`.
    pub fn new(kind: DeleteEmailTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEmailTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEmailTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEmailTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEmailTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEndpointErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEndpointErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEndpointError {
    /// Creates a new `DeleteEndpointError`.
    pub fn new(kind: DeleteEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteEndpointErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteEndpointErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteEndpointErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEndpointErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteEventStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventStreamErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventStreamErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEventStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventStreamError {
    fn code(&self) -> Option<&str> {
        DeleteEventStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventStreamError {
    /// Creates a new `DeleteEventStreamError`.
    pub fn new(kind: DeleteEventStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventStreamErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventStreamErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventStreamErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventStreamErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventStreamErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventStreamErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventStreamErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEventStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventStreamErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEventStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGcmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGcmChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteGcmChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGcmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGcmChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGcmChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGcmChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteGcmChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGcmChannelError {
    fn code(&self) -> Option<&str> {
        DeleteGcmChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGcmChannelError {
    /// Creates a new `DeleteGcmChannelError`.
    pub fn new(kind: DeleteGcmChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGcmChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGcmChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGcmChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGcmChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGcmChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteGcmChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGcmChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGcmChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteGcmChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGcmChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGcmChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGcmChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteGcmChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGcmChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteGcmChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInAppTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteInAppTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInAppTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInAppTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInAppTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteInAppTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInAppTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteInAppTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInAppTemplateError {
    /// Creates a new `DeleteInAppTemplateError`.
    pub fn new(kind: DeleteInAppTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInAppTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInAppTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInAppTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInAppTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInAppTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInAppTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteInAppTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInAppTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteInAppTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJourneyError {
    /// Kind of error that occurred.
    pub kind: DeleteJourneyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJourneyErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJourneyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJourneyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteJourneyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJourneyError {
    fn code(&self) -> Option<&str> {
        DeleteJourneyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJourneyError {
    /// Creates a new `DeleteJourneyError`.
    pub fn new(kind: DeleteJourneyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJourneyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJourneyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJourneyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJourneyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteJourneyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteJourneyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJourneyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJourneyErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteJourneyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJourneyErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJourneyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJourneyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteJourneyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJourneyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteJourneyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePushTemplateError {
    /// Kind of error that occurred.
    pub kind: DeletePushTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePushTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePushTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePushTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeletePushTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePushTemplateError {
    fn code(&self) -> Option<&str> {
        DeletePushTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePushTemplateError {
    /// Creates a new `DeletePushTemplateError`.
    pub fn new(kind: DeletePushTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePushTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePushTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePushTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePushTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePushTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePushTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeletePushTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePushTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeletePushTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRecommenderConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteRecommenderConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRecommenderConfigurationErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRecommenderConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRecommenderConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRecommenderConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRecommenderConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRecommenderConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRecommenderConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteRecommenderConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRecommenderConfigurationError {
    /// Creates a new `DeleteRecommenderConfigurationError`.
    pub fn new(
        kind: DeleteRecommenderConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRecommenderConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRecommenderConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRecommenderConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRecommenderConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteRecommenderConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRecommenderConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRecommenderConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DeleteRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            DeleteRecommenderConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => {
                Some(_inner)
            }
            DeleteRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeleteRecommenderConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSegmentError {
    /// Kind of error that occurred.
    pub kind: DeleteSegmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSegmentErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSegmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSegmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteSegmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSegmentError {
    fn code(&self) -> Option<&str> {
        DeleteSegmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSegmentError {
    /// Creates a new `DeleteSegmentError`.
    pub fn new(kind: DeleteSegmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSegmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSegmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSegmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSegmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteSegmentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteSegmentErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSegmentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSegmentErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSegmentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSegmentErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSegmentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSegmentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteSegmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSegmentErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteSegmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSmsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSmsChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteSmsChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSmsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSmsChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSmsChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSmsChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteSmsChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSmsChannelError {
    fn code(&self) -> Option<&str> {
        DeleteSmsChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSmsChannelError {
    /// Creates a new `DeleteSmsChannelError`.
    pub fn new(kind: DeleteSmsChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSmsChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSmsChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSmsChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSmsChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteSmsChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSmsChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteSmsChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSmsChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteSmsChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSmsTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteSmsTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSmsTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSmsTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSmsTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteSmsTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSmsTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteSmsTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSmsTemplateError {
    /// Creates a new `DeleteSmsTemplateError`.
    pub fn new(kind: DeleteSmsTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSmsTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSmsTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSmsTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSmsTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSmsTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSmsTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSmsTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteSmsTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSmsTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteSmsTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserEndpointsError {
    /// Kind of error that occurred.
    pub kind: DeleteUserEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserEndpointsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserEndpointsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUserEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserEndpointsError {
    fn code(&self) -> Option<&str> {
        DeleteUserEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserEndpointsError {
    /// Creates a new `DeleteUserEndpointsError`.
    pub fn new(kind: DeleteUserEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserEndpointsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserEndpointsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteUserEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserEndpointsErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUserEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVoiceChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceChannelError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceChannelError {
    /// Creates a new `DeleteVoiceChannelError`.
    pub fn new(kind: DeleteVoiceChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVoiceChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVoiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceTemplateError {
    /// Creates a new `DeleteVoiceTemplateError`.
    pub fn new(kind: DeleteVoiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVoiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAdmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAdmChannelError {
    /// Kind of error that occurred.
    pub kind: GetAdmChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAdmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAdmChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAdmChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAdmChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAdmChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAdmChannelError {
    fn code(&self) -> Option<&str> {
        GetAdmChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAdmChannelError {
    /// Creates a new `GetAdmChannelError`.
    pub fn new(kind: GetAdmChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAdmChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAdmChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAdmChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAdmChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAdmChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetAdmChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdmChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdmChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAdmChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdmChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdmChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdmChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetAdmChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAdmChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAdmChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApnsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApnsChannelError {
    /// Kind of error that occurred.
    pub kind: GetApnsChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApnsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApnsChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApnsChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApnsChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApnsChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApnsChannelError {
    fn code(&self) -> Option<&str> {
        GetApnsChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApnsChannelError {
    /// Creates a new `GetApnsChannelError`.
    pub fn new(kind: GetApnsChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApnsChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApnsChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApnsChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApnsChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApnsChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetApnsChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApnsChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApnsChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApnsChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApnsChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApnsSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApnsSandboxChannelError {
    /// Kind of error that occurred.
    pub kind: GetApnsSandboxChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApnsSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApnsSandboxChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApnsSandboxChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApnsSandboxChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApnsSandboxChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApnsSandboxChannelError {
    fn code(&self) -> Option<&str> {
        GetApnsSandboxChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApnsSandboxChannelError {
    /// Creates a new `GetApnsSandboxChannelError`.
    pub fn new(kind: GetApnsSandboxChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApnsSandboxChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApnsSandboxChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApnsSandboxChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApnsSandboxChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsSandboxChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsSandboxChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApnsSandboxChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApnsSandboxChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApnsSandboxChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApnsVoipChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApnsVoipChannelError {
    /// Kind of error that occurred.
    pub kind: GetApnsVoipChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApnsVoipChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApnsVoipChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApnsVoipChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApnsVoipChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApnsVoipChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApnsVoipChannelError {
    fn code(&self) -> Option<&str> {
        GetApnsVoipChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApnsVoipChannelError {
    /// Creates a new `GetApnsVoipChannelError`.
    pub fn new(kind: GetApnsVoipChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApnsVoipChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApnsVoipChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApnsVoipChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApnsVoipChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApnsVoipChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApnsVoipChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApnsVoipChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApnsVoipSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApnsVoipSandboxChannelError {
    /// Kind of error that occurred.
    pub kind: GetApnsVoipSandboxChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApnsVoipSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApnsVoipSandboxChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApnsVoipSandboxChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApnsVoipSandboxChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApnsVoipSandboxChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetApnsVoipSandboxChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApnsVoipSandboxChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApnsVoipSandboxChannelError {
    fn code(&self) -> Option<&str> {
        GetApnsVoipSandboxChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApnsVoipSandboxChannelError {
    /// Creates a new `GetApnsVoipSandboxChannelError`.
    pub fn new(kind: GetApnsVoipSandboxChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApnsVoipSandboxChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApnsVoipSandboxChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApnsVoipSandboxChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApnsVoipSandboxChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApnsVoipSandboxChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApnsVoipSandboxChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApnsVoipSandboxChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApnsVoipSandboxChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetApnsVoipSandboxChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApnsVoipSandboxChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppError {
    /// Kind of error that occurred.
    pub kind: GetAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAppErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAppErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetAppErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetAppErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAppErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetAppErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppError {
    fn code(&self) -> Option<&str> {
        GetAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppError {
    /// Creates a new `GetAppError`.
    pub fn new(kind: GetAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::InternalServerErrorException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::MethodNotAllowedException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAppErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAppErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetAppErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetAppErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAppErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetAppErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplicationDateRangeKpi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationDateRangeKpiError {
    /// Kind of error that occurred.
    pub kind: GetApplicationDateRangeKpiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplicationDateRangeKpi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationDateRangeKpiErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationDateRangeKpiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationDateRangeKpiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApplicationDateRangeKpiErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApplicationDateRangeKpiErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetApplicationDateRangeKpiErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetApplicationDateRangeKpiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApplicationDateRangeKpiErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetApplicationDateRangeKpiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApplicationDateRangeKpiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationDateRangeKpiError {
    fn code(&self) -> Option<&str> {
        GetApplicationDateRangeKpiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationDateRangeKpiError {
    /// Creates a new `GetApplicationDateRangeKpiError`.
    pub fn new(kind: GetApplicationDateRangeKpiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationDateRangeKpiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationDateRangeKpiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationDateRangeKpiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationDateRangeKpiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationDateRangeKpiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationDateRangeKpiErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApplicationDateRangeKpiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationDateRangeKpiErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApplicationDateRangeKpiErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApplicationDateRangeKpiErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetApplicationDateRangeKpiErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetApplicationDateRangeKpiErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApplicationDateRangeKpiErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetApplicationDateRangeKpiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApplicationDateRangeKpiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplicationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationSettingsError {
    /// Kind of error that occurred.
    pub kind: GetApplicationSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplicationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationSettingsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApplicationSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationSettingsError {
    fn code(&self) -> Option<&str> {
        GetApplicationSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationSettingsError {
    /// Creates a new `GetApplicationSettingsError`.
    pub fn new(kind: GetApplicationSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationSettingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationSettingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApplicationSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApplicationSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppsError {
    /// Kind of error that occurred.
    pub kind: GetAppsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAppsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppsError {
    fn code(&self) -> Option<&str> {
        GetAppsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppsError {
    /// Creates a new `GetAppsError`.
    pub fn new(kind: GetAppsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAppsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetAppsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, GetAppsErrorKind::MethodNotAllowedException(_))
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAppsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, GetAppsErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `GetAppsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetAppsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetAppsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAppsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAppsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetAppsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetAppsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAppsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetAppsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAppsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBaiduChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBaiduChannelError {
    /// Kind of error that occurred.
    pub kind: GetBaiduChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBaiduChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBaiduChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBaiduChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBaiduChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBaiduChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBaiduChannelError {
    fn code(&self) -> Option<&str> {
        GetBaiduChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBaiduChannelError {
    /// Creates a new `GetBaiduChannelError`.
    pub fn new(kind: GetBaiduChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBaiduChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBaiduChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBaiduChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBaiduChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBaiduChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetBaiduChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBaiduChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBaiduChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBaiduChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBaiduChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBaiduChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBaiduChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetBaiduChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBaiduChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBaiduChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCampaignError {
    /// Kind of error that occurred.
    pub kind: GetCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCampaignErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCampaignErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCampaignError {
    fn code(&self) -> Option<&str> {
        GetCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCampaignError {
    /// Creates a new `GetCampaignError`.
    pub fn new(kind: GetCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCampaignErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetCampaignErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetCampaignErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetCampaignErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCampaignErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCampaignErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCampaignErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCampaignErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetCampaignErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCampaignErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetCampaignErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCampaignActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCampaignActivitiesError {
    /// Kind of error that occurred.
    pub kind: GetCampaignActivitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCampaignActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCampaignActivitiesErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCampaignActivitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCampaignActivitiesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCampaignActivitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCampaignActivitiesError {
    fn code(&self) -> Option<&str> {
        GetCampaignActivitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCampaignActivitiesError {
    /// Creates a new `GetCampaignActivitiesError`.
    pub fn new(kind: GetCampaignActivitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCampaignActivitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCampaignActivitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCampaignActivitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCampaignActivitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignActivitiesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignActivitiesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCampaignActivitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCampaignActivitiesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCampaignActivitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCampaignDateRangeKpi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCampaignDateRangeKpiError {
    /// Kind of error that occurred.
    pub kind: GetCampaignDateRangeKpiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCampaignDateRangeKpi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCampaignDateRangeKpiErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCampaignDateRangeKpiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCampaignDateRangeKpiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCampaignDateRangeKpiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCampaignDateRangeKpiError {
    fn code(&self) -> Option<&str> {
        GetCampaignDateRangeKpiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCampaignDateRangeKpiError {
    /// Creates a new `GetCampaignDateRangeKpiError`.
    pub fn new(kind: GetCampaignDateRangeKpiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCampaignDateRangeKpiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCampaignDateRangeKpiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCampaignDateRangeKpiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCampaignDateRangeKpiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignDateRangeKpiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignDateRangeKpiErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCampaignDateRangeKpiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCampaignDateRangeKpiErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCampaignDateRangeKpiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCampaigns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCampaignsError {
    /// Kind of error that occurred.
    pub kind: GetCampaignsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCampaigns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCampaignsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCampaignsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCampaignsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCampaignsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCampaignsError {
    fn code(&self) -> Option<&str> {
        GetCampaignsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCampaignsError {
    /// Creates a new `GetCampaignsError`.
    pub fn new(kind: GetCampaignsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCampaignsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCampaignsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCampaignsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCampaignsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetCampaignsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetCampaignsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetCampaignsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCampaignsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCampaignsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCampaignsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCampaignsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCampaignsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetCampaignsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCampaignsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetCampaignsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCampaignsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCampaignVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCampaignVersionError {
    /// Kind of error that occurred.
    pub kind: GetCampaignVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCampaignVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCampaignVersionErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCampaignVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCampaignVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCampaignVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCampaignVersionError {
    fn code(&self) -> Option<&str> {
        GetCampaignVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCampaignVersionError {
    /// Creates a new `GetCampaignVersionError`.
    pub fn new(kind: GetCampaignVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCampaignVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCampaignVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCampaignVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCampaignVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCampaignVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCampaignVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCampaignVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCampaignVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCampaignVersionsError {
    /// Kind of error that occurred.
    pub kind: GetCampaignVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCampaignVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCampaignVersionsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCampaignVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCampaignVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCampaignVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCampaignVersionsError {
    fn code(&self) -> Option<&str> {
        GetCampaignVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCampaignVersionsError {
    /// Creates a new `GetCampaignVersionsError`.
    pub fn new(kind: GetCampaignVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCampaignVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCampaignVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCampaignVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCampaignVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCampaignVersionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCampaignVersionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCampaignVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCampaignVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCampaignVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChannelsError {
    /// Kind of error that occurred.
    pub kind: GetChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChannelsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChannelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChannelsError {
    fn code(&self) -> Option<&str> {
        GetChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChannelsError {
    /// Creates a new `GetChannelsError`.
    pub fn new(kind: GetChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetChannelsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetChannelsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetChannelsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChannelsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetChannelsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetChannelsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetChannelsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetChannelsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetChannelsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetChannelsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEmailChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEmailChannelError {
    /// Kind of error that occurred.
    pub kind: GetEmailChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEmailChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEmailChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEmailChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEmailChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetEmailChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEmailChannelError {
    fn code(&self) -> Option<&str> {
        GetEmailChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEmailChannelError {
    /// Creates a new `GetEmailChannelError`.
    pub fn new(kind: GetEmailChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEmailChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEmailChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEmailChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEmailChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetEmailChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetEmailChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEmailChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetEmailChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEmailChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetEmailChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: GetEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEmailTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEmailTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetEmailTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEmailTemplateError {
    fn code(&self) -> Option<&str> {
        GetEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEmailTemplateError {
    /// Creates a new `GetEmailTemplateError`.
    pub fn new(kind: GetEmailTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetEmailTemplateErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEmailTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEmailTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEmailTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEmailTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetEmailTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEndpointError {
    /// Kind of error that occurred.
    pub kind: GetEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEndpointErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEndpointErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEndpointError {
    fn code(&self) -> Option<&str> {
        GetEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEndpointError {
    /// Creates a new `GetEndpointError`.
    pub fn new(kind: GetEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetEndpointErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetEndpointErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEndpointErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEndpointErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEndpointErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetEndpointErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetEndpointErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetEndpointErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEndpointErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventStreamError {
    /// Kind of error that occurred.
    pub kind: GetEventStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventStreamErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventStreamErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetEventStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventStreamError {
    fn code(&self) -> Option<&str> {
        GetEventStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventStreamError {
    /// Creates a new `GetEventStreamError`.
    pub fn new(kind: GetEventStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetEventStreamErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetEventStreamErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventStreamErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEventStreamErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventStreamErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventStreamErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventStreamErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetEventStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventStreamErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEventStreamErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetEventStreamErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetEventStreamErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetEventStreamErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEventStreamErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetEventStreamErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetEventStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExportJobError {
    /// Kind of error that occurred.
    pub kind: GetExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExportJobErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExportJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExportJobError {
    fn code(&self) -> Option<&str> {
        GetExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExportJobError {
    /// Creates a new `GetExportJobError`.
    pub fn new(kind: GetExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetExportJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetExportJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetExportJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExportJobErrorKind::BadRequestException(_inner) => Some(_inner),
            GetExportJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetExportJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetExportJobErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetExportJobErrorKind::NotFoundException(_inner) => Some(_inner),
            GetExportJobErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetExportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExportJobsError {
    /// Kind of error that occurred.
    pub kind: GetExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExportJobsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExportJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExportJobsError {
    fn code(&self) -> Option<&str> {
        GetExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExportJobsError {
    /// Creates a new `GetExportJobsError`.
    pub fn new(kind: GetExportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetExportJobsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetExportJobsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetExportJobsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExportJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetExportJobsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetExportJobsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetExportJobsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetExportJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetExportJobsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetExportJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGcmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGcmChannelError {
    /// Kind of error that occurred.
    pub kind: GetGcmChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGcmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGcmChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGcmChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGcmChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGcmChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGcmChannelError {
    fn code(&self) -> Option<&str> {
        GetGcmChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGcmChannelError {
    /// Creates a new `GetGcmChannelError`.
    pub fn new(kind: GetGcmChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGcmChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGcmChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGcmChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGcmChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetGcmChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetGcmChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGcmChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGcmChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGcmChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGcmChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGcmChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGcmChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetGcmChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGcmChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGcmChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetImportJobError {
    /// Kind of error that occurred.
    pub kind: GetImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetImportJobErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetImportJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetImportJobError {
    fn code(&self) -> Option<&str> {
        GetImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetImportJobError {
    /// Creates a new `GetImportJobError`.
    pub fn new(kind: GetImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetImportJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetImportJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetImportJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetImportJobErrorKind::BadRequestException(_inner) => Some(_inner),
            GetImportJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetImportJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetImportJobErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetImportJobErrorKind::NotFoundException(_inner) => Some(_inner),
            GetImportJobErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetImportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetImportJobsError {
    /// Kind of error that occurred.
    pub kind: GetImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetImportJobsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetImportJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetImportJobsError {
    fn code(&self) -> Option<&str> {
        GetImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetImportJobsError {
    /// Creates a new `GetImportJobsError`.
    pub fn new(kind: GetImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetImportJobsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetImportJobsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetImportJobsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetImportJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetImportJobsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetImportJobsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetImportJobsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetImportJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetImportJobsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetImportJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInAppMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInAppMessagesError {
    /// Kind of error that occurred.
    pub kind: GetInAppMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInAppMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInAppMessagesErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInAppMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInAppMessagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetInAppMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInAppMessagesError {
    fn code(&self) -> Option<&str> {
        GetInAppMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInAppMessagesError {
    /// Creates a new `GetInAppMessagesError`.
    pub fn new(kind: GetInAppMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInAppMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInAppMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInAppMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInAppMessagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppMessagesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetInAppMessagesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppMessagesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppMessagesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetInAppMessagesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppMessagesErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppMessagesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppMessagesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetInAppMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInAppMessagesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetInAppMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInAppTemplateError {
    /// Kind of error that occurred.
    pub kind: GetInAppTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInAppTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInAppTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInAppTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetInAppTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInAppTemplateError {
    fn code(&self) -> Option<&str> {
        GetInAppTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInAppTemplateError {
    /// Creates a new `GetInAppTemplateError`.
    pub fn new(kind: GetInAppTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInAppTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInAppTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInAppTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInAppTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetInAppTemplateErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetInAppTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInAppTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInAppTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetInAppTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInAppTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetInAppTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJourneyError {
    /// Kind of error that occurred.
    pub kind: GetJourneyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJourneyErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJourneyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJourneyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetJourneyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJourneyError {
    fn code(&self) -> Option<&str> {
        GetJourneyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJourneyError {
    /// Creates a new `GetJourneyError`.
    pub fn new(kind: GetJourneyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJourneyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJourneyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJourneyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJourneyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetJourneyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetJourneyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJourneyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, GetJourneyErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `GetJourneyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetJourneyErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetJourneyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJourneyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetJourneyErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetJourneyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetJourneyErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetJourneyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJourneyErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetJourneyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetJourneyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJourneyDateRangeKpi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJourneyDateRangeKpiError {
    /// Kind of error that occurred.
    pub kind: GetJourneyDateRangeKpiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJourneyDateRangeKpi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJourneyDateRangeKpiErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJourneyDateRangeKpiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJourneyDateRangeKpiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetJourneyDateRangeKpiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJourneyDateRangeKpiError {
    fn code(&self) -> Option<&str> {
        GetJourneyDateRangeKpiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJourneyDateRangeKpiError {
    /// Creates a new `GetJourneyDateRangeKpiError`.
    pub fn new(kind: GetJourneyDateRangeKpiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJourneyDateRangeKpiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJourneyDateRangeKpiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJourneyDateRangeKpiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJourneyDateRangeKpiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyDateRangeKpiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyDateRangeKpiErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetJourneyDateRangeKpiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJourneyDateRangeKpiErrorKind::BadRequestException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetJourneyDateRangeKpiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJourneyExecutionActivityMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJourneyExecutionActivityMetricsError {
    /// Kind of error that occurred.
    pub kind: GetJourneyExecutionActivityMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJourneyExecutionActivityMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJourneyExecutionActivityMetricsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJourneyExecutionActivityMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJourneyExecutionActivityMetricsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionActivityMetricsErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionActivityMetricsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionActivityMetricsErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionActivityMetricsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJourneyExecutionActivityMetricsErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionActivityMetricsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionActivityMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJourneyExecutionActivityMetricsError {
    fn code(&self) -> Option<&str> {
        GetJourneyExecutionActivityMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJourneyExecutionActivityMetricsError {
    /// Creates a new `GetJourneyExecutionActivityMetricsError`.
    pub fn new(
        kind: GetJourneyExecutionActivityMetricsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJourneyExecutionActivityMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJourneyExecutionActivityMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJourneyExecutionActivityMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJourneyExecutionActivityMetricsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionActivityMetricsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionActivityMetricsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetJourneyExecutionActivityMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJourneyExecutionActivityMetricsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetJourneyExecutionActivityMetricsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetJourneyExecutionActivityMetricsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetJourneyExecutionActivityMetricsErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            GetJourneyExecutionActivityMetricsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJourneyExecutionActivityMetricsErrorKind::PayloadTooLargeException(_inner) => {
                Some(_inner)
            }
            GetJourneyExecutionActivityMetricsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetJourneyExecutionActivityMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJourneyExecutionMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJourneyExecutionMetricsError {
    /// Kind of error that occurred.
    pub kind: GetJourneyExecutionMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJourneyExecutionMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJourneyExecutionMetricsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJourneyExecutionMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJourneyExecutionMetricsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetJourneyExecutionMetricsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetJourneyExecutionMetricsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetJourneyExecutionMetricsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetJourneyExecutionMetricsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJourneyExecutionMetricsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetJourneyExecutionMetricsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetJourneyExecutionMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJourneyExecutionMetricsError {
    fn code(&self) -> Option<&str> {
        GetJourneyExecutionMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJourneyExecutionMetricsError {
    /// Creates a new `GetJourneyExecutionMetricsError`.
    pub fn new(kind: GetJourneyExecutionMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJourneyExecutionMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJourneyExecutionMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJourneyExecutionMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJourneyExecutionMetricsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJourneyExecutionMetricsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJourneyExecutionMetricsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetJourneyExecutionMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJourneyExecutionMetricsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetJourneyExecutionMetricsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetJourneyExecutionMetricsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetJourneyExecutionMetricsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetJourneyExecutionMetricsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJourneyExecutionMetricsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetJourneyExecutionMetricsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetJourneyExecutionMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPushTemplateError {
    /// Kind of error that occurred.
    pub kind: GetPushTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPushTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPushTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPushTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetPushTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPushTemplateError {
    fn code(&self) -> Option<&str> {
        GetPushTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPushTemplateError {
    /// Creates a new `GetPushTemplateError`.
    pub fn new(kind: GetPushTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPushTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPushTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPushTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPushTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetPushTemplateErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetPushTemplateErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPushTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPushTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPushTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPushTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPushTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPushTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetPushTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPushTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetPushTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecommenderConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetRecommenderConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecommenderConfigurationErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecommenderConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecommenderConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommenderConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecommenderConfigurationError {
    fn code(&self) -> Option<&str> {
        GetRecommenderConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecommenderConfigurationError {
    /// Creates a new `GetRecommenderConfigurationError`.
    pub fn new(kind: GetRecommenderConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecommenderConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecommenderConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecommenderConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecommenderConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetRecommenderConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecommenderConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRecommenderConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetRecommenderConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRecommenderConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecommenderConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecommenderConfigurationsError {
    /// Kind of error that occurred.
    pub kind: GetRecommenderConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecommenderConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecommenderConfigurationsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecommenderConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecommenderConfigurationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommenderConfigurationsErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommenderConfigurationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRecommenderConfigurationsErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommenderConfigurationsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommenderConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecommenderConfigurationsError {
    fn code(&self) -> Option<&str> {
        GetRecommenderConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecommenderConfigurationsError {
    /// Creates a new `GetRecommenderConfigurationsError`.
    pub fn new(kind: GetRecommenderConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecommenderConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecommenderConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecommenderConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecommenderConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommenderConfigurationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommenderConfigurationsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetRecommenderConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecommenderConfigurationsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRecommenderConfigurationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetRecommenderConfigurationsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetRecommenderConfigurationsErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            GetRecommenderConfigurationsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRecommenderConfigurationsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetRecommenderConfigurationsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRecommenderConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSegmentError {
    /// Kind of error that occurred.
    pub kind: GetSegmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSegmentErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSegmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSegmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSegmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSegmentError {
    fn code(&self) -> Option<&str> {
        GetSegmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSegmentError {
    /// Creates a new `GetSegmentError`.
    pub fn new(kind: GetSegmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSegmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSegmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSegmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSegmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetSegmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSegmentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSegmentErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSegmentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSegmentErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSegmentErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSegmentErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSegmentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSegmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSegmentExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSegmentExportJobsError {
    /// Kind of error that occurred.
    pub kind: GetSegmentExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSegmentExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSegmentExportJobsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSegmentExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSegmentExportJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSegmentExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSegmentExportJobsError {
    fn code(&self) -> Option<&str> {
        GetSegmentExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSegmentExportJobsError {
    /// Creates a new `GetSegmentExportJobsError`.
    pub fn new(kind: GetSegmentExportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSegmentExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSegmentExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSegmentExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSegmentExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentExportJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentExportJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSegmentExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSegmentExportJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSegmentExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSegmentImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSegmentImportJobsError {
    /// Kind of error that occurred.
    pub kind: GetSegmentImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSegmentImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSegmentImportJobsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSegmentImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSegmentImportJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSegmentImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSegmentImportJobsError {
    fn code(&self) -> Option<&str> {
        GetSegmentImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSegmentImportJobsError {
    /// Creates a new `GetSegmentImportJobsError`.
    pub fn new(kind: GetSegmentImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSegmentImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSegmentImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSegmentImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSegmentImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentImportJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentImportJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSegmentImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSegmentImportJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSegmentImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSegments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSegmentsError {
    /// Kind of error that occurred.
    pub kind: GetSegmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSegments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSegmentsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSegmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSegmentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSegmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSegmentsError {
    fn code(&self) -> Option<&str> {
        GetSegmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSegmentsError {
    /// Creates a new `GetSegmentsError`.
    pub fn new(kind: GetSegmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSegmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSegmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSegmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSegmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSegmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSegmentsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSegmentsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSegmentsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSegmentsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSegmentsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSegmentsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSegmentsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSegmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSegmentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSegmentVersionError {
    /// Kind of error that occurred.
    pub kind: GetSegmentVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSegmentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSegmentVersionErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSegmentVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSegmentVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSegmentVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSegmentVersionError {
    fn code(&self) -> Option<&str> {
        GetSegmentVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSegmentVersionError {
    /// Creates a new `GetSegmentVersionError`.
    pub fn new(kind: GetSegmentVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSegmentVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSegmentVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSegmentVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSegmentVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSegmentVersionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSegmentVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSegmentVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSegmentVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSegmentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSegmentVersionsError {
    /// Kind of error that occurred.
    pub kind: GetSegmentVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSegmentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSegmentVersionsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSegmentVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSegmentVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSegmentVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSegmentVersionsError {
    fn code(&self) -> Option<&str> {
        GetSegmentVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSegmentVersionsError {
    /// Creates a new `GetSegmentVersionsError`.
    pub fn new(kind: GetSegmentVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSegmentVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSegmentVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSegmentVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSegmentVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSegmentVersionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSegmentVersionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSegmentVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSegmentVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSegmentVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSmsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSmsChannelError {
    /// Kind of error that occurred.
    pub kind: GetSmsChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSmsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSmsChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSmsChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSmsChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSmsChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSmsChannelError {
    fn code(&self) -> Option<&str> {
        GetSmsChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSmsChannelError {
    /// Creates a new `GetSmsChannelError`.
    pub fn new(kind: GetSmsChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSmsChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSmsChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSmsChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSmsChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSmsChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetSmsChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSmsChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSmsChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSmsChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSmsChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSmsChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSmsTemplateError {
    /// Kind of error that occurred.
    pub kind: GetSmsTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSmsTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSmsTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSmsTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSmsTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSmsTemplateError {
    fn code(&self) -> Option<&str> {
        GetSmsTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSmsTemplateError {
    /// Creates a new `GetSmsTemplateError`.
    pub fn new(kind: GetSmsTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSmsTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSmsTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSmsTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSmsTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSmsTemplateErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetSmsTemplateErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSmsTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSmsTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSmsTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetSmsTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSmsTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSmsTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserEndpointsError {
    /// Kind of error that occurred.
    pub kind: GetUserEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserEndpointsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserEndpointsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUserEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserEndpointsError {
    fn code(&self) -> Option<&str> {
        GetUserEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserEndpointsError {
    /// Creates a new `GetUserEndpointsError`.
    pub fn new(kind: GetUserEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserEndpointsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetUserEndpointsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserEndpointsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserEndpointsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUserEndpointsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserEndpointsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserEndpointsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserEndpointsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetUserEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserEndpointsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUserEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceChannelError {
    /// Kind of error that occurred.
    pub kind: GetVoiceChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetVoiceChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceChannelError {
    fn code(&self) -> Option<&str> {
        GetVoiceChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceChannelError {
    /// Creates a new `GetVoiceChannelError`.
    pub fn new(kind: GetVoiceChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetVoiceChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetVoiceChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetVoiceChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetVoiceChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetVoiceChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceTemplateError {
    /// Kind of error that occurred.
    pub kind: GetVoiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetVoiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceTemplateError {
    fn code(&self) -> Option<&str> {
        GetVoiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceTemplateError {
    /// Creates a new `GetVoiceTemplateError`.
    pub fn new(kind: GetVoiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetVoiceTemplateErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetVoiceTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetVoiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetVoiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJourneys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJourneysError {
    /// Kind of error that occurred.
    pub kind: ListJourneysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJourneys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJourneysErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJourneysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJourneysErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListJourneysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJourneysError {
    fn code(&self) -> Option<&str> {
        ListJourneysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJourneysError {
    /// Creates a new `ListJourneysError`.
    pub fn new(kind: ListJourneysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJourneysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJourneysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJourneysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJourneysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListJourneysErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListJourneysErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJourneysErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJourneysErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJourneysErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJourneysErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJourneysErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJourneysErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListJourneysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJourneysErrorKind::BadRequestException(_inner) => Some(_inner),
            ListJourneysErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListJourneysErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListJourneysErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListJourneysErrorKind::NotFoundException(_inner) => Some(_inner),
            ListJourneysErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            ListJourneysErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListJourneysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTemplatesErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTemplatesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTemplatesError {
    fn code(&self) -> Option<&str> {
        ListTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTemplatesError {
    /// Creates a new `ListTemplatesError`.
    pub fn new(kind: ListTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListTemplatesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListTemplatesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTemplatesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTemplatesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTemplatesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTemplatesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListTemplatesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTemplateVersionsError {
    /// Kind of error that occurred.
    pub kind: ListTemplateVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTemplateVersionsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTemplateVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTemplateVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTemplateVersionsError {
    fn code(&self) -> Option<&str> {
        ListTemplateVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTemplateVersionsError {
    /// Creates a new `ListTemplateVersionsError`.
    pub fn new(kind: ListTemplateVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTemplateVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTemplateVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTemplateVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTemplateVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTemplateVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTemplateVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PhoneNumberValidate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PhoneNumberValidateError {
    /// Kind of error that occurred.
    pub kind: PhoneNumberValidateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PhoneNumberValidate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PhoneNumberValidateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PhoneNumberValidateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PhoneNumberValidateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PhoneNumberValidateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PhoneNumberValidateError {
    fn code(&self) -> Option<&str> {
        PhoneNumberValidateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PhoneNumberValidateError {
    /// Creates a new `PhoneNumberValidateError`.
    pub fn new(kind: PhoneNumberValidateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PhoneNumberValidateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PhoneNumberValidateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PhoneNumberValidateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PhoneNumberValidateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `PhoneNumberValidateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PhoneNumberValidateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PhoneNumberValidateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PhoneNumberValidateErrorKind::BadRequestException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::ForbiddenException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::NotFoundException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PhoneNumberValidateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEventsError {
    /// Kind of error that occurred.
    pub kind: PutEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEventsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEventsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEventsError {
    fn code(&self) -> Option<&str> {
        PutEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEventsError {
    /// Creates a new `PutEventsError`.
    pub fn new(kind: PutEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::MethodNotAllowedException(_))
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::PayloadTooLargeException(_))
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for PutEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEventsErrorKind::BadRequestException(_inner) => Some(_inner),
            PutEventsErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutEventsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutEventsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            PutEventsErrorKind::NotFoundException(_inner) => Some(_inner),
            PutEventsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            PutEventsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEventStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEventStreamError {
    /// Kind of error that occurred.
    pub kind: PutEventStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEventStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEventStreamErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEventStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEventStreamErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutEventStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEventStreamError {
    fn code(&self) -> Option<&str> {
        PutEventStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEventStreamError {
    /// Creates a new `PutEventStreamError`.
    pub fn new(kind: PutEventStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEventStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEventStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEventStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEventStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutEventStreamErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, PutEventStreamErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventStreamErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutEventStreamErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventStreamErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventStreamErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventStreamErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutEventStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEventStreamErrorKind::BadRequestException(_inner) => Some(_inner),
            PutEventStreamErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutEventStreamErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutEventStreamErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            PutEventStreamErrorKind::NotFoundException(_inner) => Some(_inner),
            PutEventStreamErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            PutEventStreamErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutEventStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveAttributesError {
    /// Kind of error that occurred.
    pub kind: RemoveAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveAttributesErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveAttributesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveAttributesError {
    fn code(&self) -> Option<&str> {
        RemoveAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveAttributesError {
    /// Creates a new `RemoveAttributesError`.
    pub fn new(kind: RemoveAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, RemoveAttributesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RemoveAttributesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveAttributesErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::ForbiddenException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendMessagesError {
    /// Kind of error that occurred.
    pub kind: SendMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendMessagesErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendMessagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SendMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendMessagesError {
    fn code(&self) -> Option<&str> {
        SendMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendMessagesError {
    /// Creates a new `SendMessagesError`.
    pub fn new(kind: SendMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendMessagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, SendMessagesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, SendMessagesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendMessagesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendMessagesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SendMessagesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendMessagesErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessagesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendMessagesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for SendMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendMessagesErrorKind::BadRequestException(_inner) => Some(_inner),
            SendMessagesErrorKind::ForbiddenException(_inner) => Some(_inner),
            SendMessagesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            SendMessagesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            SendMessagesErrorKind::NotFoundException(_inner) => Some(_inner),
            SendMessagesErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            SendMessagesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SendMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendUsersMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendUsersMessagesError {
    /// Kind of error that occurred.
    pub kind: SendUsersMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendUsersMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendUsersMessagesErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendUsersMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendUsersMessagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SendUsersMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendUsersMessagesError {
    fn code(&self) -> Option<&str> {
        SendUsersMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendUsersMessagesError {
    /// Creates a new `SendUsersMessagesError`.
    pub fn new(kind: SendUsersMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendUsersMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendUsersMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendUsersMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendUsersMessagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendUsersMessagesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendUsersMessagesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendUsersMessagesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendUsersMessagesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SendUsersMessagesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendUsersMessagesErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `SendUsersMessagesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendUsersMessagesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for SendUsersMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendUsersMessagesErrorKind::BadRequestException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::ForbiddenException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::NotFoundException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SendUsersMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAdmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAdmChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateAdmChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAdmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAdmChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAdmChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAdmChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAdmChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAdmChannelError {
    fn code(&self) -> Option<&str> {
        UpdateAdmChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAdmChannelError {
    /// Creates a new `UpdateAdmChannelError`.
    pub fn new(kind: UpdateAdmChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAdmChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAdmChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAdmChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAdmChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAdmChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateAdmChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAdmChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAdmChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAdmChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAdmChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAdmChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAdmChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateAdmChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAdmChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAdmChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApnsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApnsChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateApnsChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApnsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApnsChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApnsChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApnsChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApnsChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApnsChannelError {
    fn code(&self) -> Option<&str> {
        UpdateApnsChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApnsChannelError {
    /// Creates a new `UpdateApnsChannelError`.
    pub fn new(kind: UpdateApnsChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApnsChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApnsChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApnsChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApnsChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApnsChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApnsChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApnsChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApnsChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApnsSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApnsSandboxChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateApnsSandboxChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApnsSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApnsSandboxChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApnsSandboxChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApnsSandboxChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApnsSandboxChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateApnsSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApnsSandboxChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateApnsSandboxChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApnsSandboxChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateApnsSandboxChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApnsSandboxChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApnsSandboxChannelError {
    fn code(&self) -> Option<&str> {
        UpdateApnsSandboxChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApnsSandboxChannelError {
    /// Creates a new `UpdateApnsSandboxChannelError`.
    pub fn new(kind: UpdateApnsSandboxChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApnsSandboxChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApnsSandboxChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApnsSandboxChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApnsSandboxChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsSandboxChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsSandboxChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApnsSandboxChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApnsSandboxChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApnsSandboxChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApnsVoipChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApnsVoipChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateApnsVoipChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApnsVoipChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApnsVoipChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApnsVoipChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApnsVoipChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApnsVoipChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApnsVoipChannelError {
    fn code(&self) -> Option<&str> {
        UpdateApnsVoipChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApnsVoipChannelError {
    /// Creates a new `UpdateApnsVoipChannelError`.
    pub fn new(kind: UpdateApnsVoipChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApnsVoipChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApnsVoipChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApnsVoipChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApnsVoipChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApnsVoipChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApnsVoipChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApnsVoipChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApnsVoipSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApnsVoipSandboxChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateApnsVoipSandboxChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApnsVoipSandboxChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApnsVoipSandboxChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApnsVoipSandboxChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApnsVoipSandboxChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApnsVoipSandboxChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApnsVoipSandboxChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApnsVoipSandboxChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApnsVoipSandboxChannelError {
    fn code(&self) -> Option<&str> {
        UpdateApnsVoipSandboxChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApnsVoipSandboxChannelError {
    /// Creates a new `UpdateApnsVoipSandboxChannelError`.
    pub fn new(kind: UpdateApnsVoipSandboxChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApnsVoipSandboxChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApnsVoipSandboxChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApnsVoipSandboxChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApnsVoipSandboxChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApnsVoipSandboxChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApnsVoipSandboxChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApnsVoipSandboxChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApnsVoipSandboxChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateApnsVoipSandboxChannelErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateApnsVoipSandboxChannelErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            UpdateApnsVoipSandboxChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApnsVoipSandboxChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateApnsVoipSandboxChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApnsVoipSandboxChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplicationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplicationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationSettingsErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApplicationSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateApplicationSettingsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApplicationSettingsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateApplicationSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApplicationSettingsErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateApplicationSettingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApplicationSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationSettingsError {
    /// Creates a new `UpdateApplicationSettingsError`.
    pub fn new(kind: UpdateApplicationSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationSettingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationSettingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApplicationSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateApplicationSettingsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateApplicationSettingsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateApplicationSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApplicationSettingsErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateApplicationSettingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApplicationSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBaiduChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBaiduChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateBaiduChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBaiduChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBaiduChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBaiduChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBaiduChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateBaiduChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBaiduChannelError {
    fn code(&self) -> Option<&str> {
        UpdateBaiduChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBaiduChannelError {
    /// Creates a new `UpdateBaiduChannelError`.
    pub fn new(kind: UpdateBaiduChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBaiduChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBaiduChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBaiduChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBaiduChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBaiduChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBaiduChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateBaiduChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBaiduChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateBaiduChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCampaignError {
    /// Kind of error that occurred.
    pub kind: UpdateCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCampaignErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCampaignErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCampaignError {
    fn code(&self) -> Option<&str> {
        UpdateCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCampaignError {
    /// Creates a new `UpdateCampaignError`.
    pub fn new(kind: UpdateCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCampaignErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateCampaignErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateCampaignErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateCampaignErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCampaignErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEmailChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEmailChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateEmailChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEmailChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEmailChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEmailChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEmailChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEmailChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEmailChannelError {
    fn code(&self) -> Option<&str> {
        UpdateEmailChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEmailChannelError {
    /// Creates a new `UpdateEmailChannelError`.
    pub fn new(kind: UpdateEmailChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEmailChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEmailChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEmailChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEmailChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEmailChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEmailChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEmailChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEmailTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEmailTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEmailTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEmailTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEmailTemplateError {
    /// Creates a new `UpdateEmailTemplateError`.
    pub fn new(kind: UpdateEmailTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmailTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmailTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEmailTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEmailTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEndpointError {
    /// Kind of error that occurred.
    pub kind: UpdateEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEndpointErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEndpointErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEndpointError {
    fn code(&self) -> Option<&str> {
        UpdateEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEndpointError {
    /// Creates a new `UpdateEndpointError`.
    pub fn new(kind: UpdateEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateEndpointErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateEndpointErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateEndpointErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEndpointErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEndpointsBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEndpointsBatchError {
    /// Kind of error that occurred.
    pub kind: UpdateEndpointsBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEndpointsBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEndpointsBatchErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEndpointsBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEndpointsBatchErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEndpointsBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEndpointsBatchError {
    fn code(&self) -> Option<&str> {
        UpdateEndpointsBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEndpointsBatchError {
    /// Creates a new `UpdateEndpointsBatchError`.
    pub fn new(kind: UpdateEndpointsBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEndpointsBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEndpointsBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEndpointsBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEndpointsBatchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointsBatchErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointsBatchErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEndpointsBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEndpointsBatchErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEndpointsBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGcmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGcmChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateGcmChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGcmChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGcmChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGcmChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGcmChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateGcmChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGcmChannelError {
    fn code(&self) -> Option<&str> {
        UpdateGcmChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGcmChannelError {
    /// Creates a new `UpdateGcmChannelError`.
    pub fn new(kind: UpdateGcmChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGcmChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGcmChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGcmChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGcmChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGcmChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateGcmChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGcmChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGcmChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGcmChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGcmChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGcmChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGcmChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateGcmChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGcmChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateGcmChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInAppTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateInAppTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInAppTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInAppTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInAppTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInAppTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateInAppTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInAppTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateInAppTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInAppTemplateError {
    /// Creates a new `UpdateInAppTemplateError`.
    pub fn new(kind: UpdateInAppTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInAppTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInAppTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInAppTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInAppTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInAppTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInAppTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateInAppTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInAppTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateInAppTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJourneyError {
    /// Kind of error that occurred.
    pub kind: UpdateJourneyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJourney` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJourneyErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJourneyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJourneyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateJourneyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJourneyError {
    fn code(&self) -> Option<&str> {
        UpdateJourneyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJourneyError {
    /// Creates a new `UpdateJourneyError`.
    pub fn new(kind: UpdateJourneyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJourneyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJourneyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJourneyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJourneyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateJourneyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateJourneyErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateJourneyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateJourneyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateJourneyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJourneyErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateJourneyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJourneyState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJourneyStateError {
    /// Kind of error that occurred.
    pub kind: UpdateJourneyStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJourneyState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJourneyStateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJourneyStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJourneyStateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateJourneyStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJourneyStateError {
    fn code(&self) -> Option<&str> {
        UpdateJourneyStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJourneyStateError {
    /// Creates a new `UpdateJourneyStateError`.
    pub fn new(kind: UpdateJourneyStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJourneyStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJourneyStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJourneyStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJourneyStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJourneyStateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJourneyStateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateJourneyStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJourneyStateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateJourneyStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePushTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdatePushTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePushTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePushTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePushTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePushTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdatePushTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePushTemplateError {
    fn code(&self) -> Option<&str> {
        UpdatePushTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePushTemplateError {
    /// Creates a new `UpdatePushTemplateError`.
    pub fn new(kind: UpdatePushTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePushTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePushTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePushTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePushTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePushTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePushTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdatePushTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePushTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdatePushTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRecommenderConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateRecommenderConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRecommenderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRecommenderConfigurationErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRecommenderConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRecommenderConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRecommenderConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecommenderConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecommenderConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRecommenderConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateRecommenderConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRecommenderConfigurationError {
    /// Creates a new `UpdateRecommenderConfigurationError`.
    pub fn new(
        kind: UpdateRecommenderConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRecommenderConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRecommenderConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRecommenderConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRecommenderConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateRecommenderConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRecommenderConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRecommenderConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateRecommenderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateRecommenderConfigurationErrorKind::MethodNotAllowedException(_inner) => {
                Some(_inner)
            }
            UpdateRecommenderConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRecommenderConfigurationErrorKind::PayloadTooLargeException(_inner) => {
                Some(_inner)
            }
            UpdateRecommenderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateRecommenderConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSegmentError {
    /// Kind of error that occurred.
    pub kind: UpdateSegmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSegment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSegmentErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSegmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSegmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateSegmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSegmentError {
    fn code(&self) -> Option<&str> {
        UpdateSegmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSegmentError {
    /// Creates a new `UpdateSegmentError`.
    pub fn new(kind: UpdateSegmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSegmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSegmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSegmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSegmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateSegmentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateSegmentErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSegmentErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSegmentErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateSegmentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSegmentErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSegmentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSegmentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateSegmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSegmentErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateSegmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSmsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSmsChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateSmsChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSmsChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSmsChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSmsChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSmsChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateSmsChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSmsChannelError {
    fn code(&self) -> Option<&str> {
        UpdateSmsChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSmsChannelError {
    /// Creates a new `UpdateSmsChannelError`.
    pub fn new(kind: UpdateSmsChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSmsChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSmsChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSmsChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSmsChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateSmsChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateSmsChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateSmsChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSmsChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateSmsChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSmsTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateSmsTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSmsTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSmsTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSmsTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSmsTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateSmsTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSmsTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateSmsTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSmsTemplateError {
    /// Creates a new `UpdateSmsTemplateError`.
    pub fn new(kind: UpdateSmsTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSmsTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSmsTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSmsTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSmsTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateSmsTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSmsTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSmsTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateSmsTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSmsTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateSmsTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTemplateActiveVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTemplateActiveVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateTemplateActiveVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTemplateActiveVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTemplateActiveVersionErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTemplateActiveVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTemplateActiveVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateTemplateActiveVersionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateTemplateActiveVersionErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTemplateActiveVersionErrorKind::MethodNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTemplateActiveVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateTemplateActiveVersionErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateTemplateActiveVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateTemplateActiveVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTemplateActiveVersionError {
    fn code(&self) -> Option<&str> {
        UpdateTemplateActiveVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTemplateActiveVersionError {
    /// Creates a new `UpdateTemplateActiveVersionError`.
    pub fn new(kind: UpdateTemplateActiveVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTemplateActiveVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTemplateActiveVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTemplateActiveVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTemplateActiveVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateActiveVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateActiveVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateTemplateActiveVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTemplateActiveVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateTemplateActiveVersionErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateTemplateActiveVersionErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateTemplateActiveVersionErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateTemplateActiveVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateTemplateActiveVersionErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateTemplateActiveVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateTemplateActiveVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVoiceChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVoiceChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateVoiceChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVoiceChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVoiceChannelErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVoiceChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVoiceChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVoiceChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVoiceChannelError {
    fn code(&self) -> Option<&str> {
        UpdateVoiceChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVoiceChannelError {
    /// Creates a new `UpdateVoiceChannelError`.
    pub fn new(kind: UpdateVoiceChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVoiceChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVoiceChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVoiceChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVoiceChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVoiceChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVoiceChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVoiceChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVoiceTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateVoiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVoiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVoiceTemplateErrorKind {
    /// <p>Provides information about an API request or response.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Provides information about an API request or response.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Provides information about an API request or response.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Provides information about an API request or response.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>Provides information about an API request or response.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Provides information about an API request or response.</p>
    PayloadTooLargeException(crate::error::PayloadTooLargeException),
    /// <p>Provides information about an API request or response.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVoiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVoiceTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::PayloadTooLargeException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVoiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVoiceTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateVoiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVoiceTemplateError {
    /// Creates a new `UpdateVoiceTemplateError`.
    pub fn new(kind: UpdateVoiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVoiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVoiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVoiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVoiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::PayloadTooLargeException`.
    pub fn is_payload_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::PayloadTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVoiceTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVoiceTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVoiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVoiceTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::PayloadTooLargeException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVoiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PayloadTooLargeException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PayloadTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PayloadTooLargeException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl PayloadTooLargeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PayloadTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PayloadTooLargeException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for PayloadTooLargeException {}
/// See [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
pub mod payload_too_large_exception {
    /// A builder for [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
        pub fn build(self) -> crate::error::PayloadTooLargeException {
            crate::error::PayloadTooLargeException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl PayloadTooLargeException {
    /// Creates a new builder-style object to manufacture [`PayloadTooLargeException`](crate::error::PayloadTooLargeException)
    pub fn builder() -> crate::error::payload_too_large_exception::Builder {
        crate::error::payload_too_large_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MethodNotAllowedException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MethodNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MethodNotAllowedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl MethodNotAllowedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MethodNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MethodNotAllowedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for MethodNotAllowedException {}
/// See [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
pub mod method_not_allowed_exception {
    /// A builder for [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
        pub fn build(self) -> crate::error::MethodNotAllowedException {
            crate::error::MethodNotAllowedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl MethodNotAllowedException {
    /// Creates a new builder-style object to manufacture [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
    pub fn builder() -> crate::error::method_not_allowed_exception::Builder {
        crate::error::method_not_allowed_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>Provides information about an API request or response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>The message that's returned from the API.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the request or response.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message that's returned from the API.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that's returned from the API.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request or response.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
