// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Pinpoint`.
///
/// This client allows ergonomic access to a `Pinpoint`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApp` operation.
    ///
    /// See [`CreateApp`](crate::client::fluent_builders::CreateApp) for more information about the
    /// operation and its arguments.
    pub fn create_app(&self) -> fluent_builders::CreateApp<C, M, R> {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCampaign` operation.
    ///
    /// See [`CreateCampaign`](crate::client::fluent_builders::CreateCampaign) for more information about the
    /// operation and its arguments.
    pub fn create_campaign(&self) -> fluent_builders::CreateCampaign<C, M, R> {
        fluent_builders::CreateCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEmailTemplate` operation.
    ///
    /// See [`CreateEmailTemplate`](crate::client::fluent_builders::CreateEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_email_template(&self) -> fluent_builders::CreateEmailTemplate<C, M, R> {
        fluent_builders::CreateEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateExportJob` operation.
    ///
    /// See [`CreateExportJob`](crate::client::fluent_builders::CreateExportJob) for more information about the
    /// operation and its arguments.
    pub fn create_export_job(&self) -> fluent_builders::CreateExportJob<C, M, R> {
        fluent_builders::CreateExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImportJob` operation.
    ///
    /// See [`CreateImportJob`](crate::client::fluent_builders::CreateImportJob) for more information about the
    /// operation and its arguments.
    pub fn create_import_job(&self) -> fluent_builders::CreateImportJob<C, M, R> {
        fluent_builders::CreateImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInAppTemplate` operation.
    ///
    /// See [`CreateInAppTemplate`](crate::client::fluent_builders::CreateInAppTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_in_app_template(&self) -> fluent_builders::CreateInAppTemplate<C, M, R> {
        fluent_builders::CreateInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJourney` operation.
    ///
    /// See [`CreateJourney`](crate::client::fluent_builders::CreateJourney) for more information about the
    /// operation and its arguments.
    pub fn create_journey(&self) -> fluent_builders::CreateJourney<C, M, R> {
        fluent_builders::CreateJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePushTemplate` operation.
    ///
    /// See [`CreatePushTemplate`](crate::client::fluent_builders::CreatePushTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_push_template(&self) -> fluent_builders::CreatePushTemplate<C, M, R> {
        fluent_builders::CreatePushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecommenderConfiguration` operation.
    ///
    /// See [`CreateRecommenderConfiguration`](crate::client::fluent_builders::CreateRecommenderConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_recommender_configuration(
        &self,
    ) -> fluent_builders::CreateRecommenderConfiguration<C, M, R> {
        fluent_builders::CreateRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSegment` operation.
    ///
    /// See [`CreateSegment`](crate::client::fluent_builders::CreateSegment) for more information about the
    /// operation and its arguments.
    pub fn create_segment(&self) -> fluent_builders::CreateSegment<C, M, R> {
        fluent_builders::CreateSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSmsTemplate` operation.
    ///
    /// See [`CreateSmsTemplate`](crate::client::fluent_builders::CreateSmsTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_sms_template(&self) -> fluent_builders::CreateSmsTemplate<C, M, R> {
        fluent_builders::CreateSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVoiceTemplate` operation.
    ///
    /// See [`CreateVoiceTemplate`](crate::client::fluent_builders::CreateVoiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_voice_template(&self) -> fluent_builders::CreateVoiceTemplate<C, M, R> {
        fluent_builders::CreateVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAdmChannel` operation.
    ///
    /// See [`DeleteAdmChannel`](crate::client::fluent_builders::DeleteAdmChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_adm_channel(&self) -> fluent_builders::DeleteAdmChannel<C, M, R> {
        fluent_builders::DeleteAdmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApnsChannel` operation.
    ///
    /// See [`DeleteApnsChannel`](crate::client::fluent_builders::DeleteApnsChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_apns_channel(&self) -> fluent_builders::DeleteApnsChannel<C, M, R> {
        fluent_builders::DeleteApnsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApnsSandboxChannel` operation.
    ///
    /// See [`DeleteApnsSandboxChannel`](crate::client::fluent_builders::DeleteApnsSandboxChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_apns_sandbox_channel(
        &self,
    ) -> fluent_builders::DeleteApnsSandboxChannel<C, M, R> {
        fluent_builders::DeleteApnsSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApnsVoipChannel` operation.
    ///
    /// See [`DeleteApnsVoipChannel`](crate::client::fluent_builders::DeleteApnsVoipChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_apns_voip_channel(&self) -> fluent_builders::DeleteApnsVoipChannel<C, M, R> {
        fluent_builders::DeleteApnsVoipChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApnsVoipSandboxChannel` operation.
    ///
    /// See [`DeleteApnsVoipSandboxChannel`](crate::client::fluent_builders::DeleteApnsVoipSandboxChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_apns_voip_sandbox_channel(
        &self,
    ) -> fluent_builders::DeleteApnsVoipSandboxChannel<C, M, R> {
        fluent_builders::DeleteApnsVoipSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApp` operation.
    ///
    /// See [`DeleteApp`](crate::client::fluent_builders::DeleteApp) for more information about the
    /// operation and its arguments.
    pub fn delete_app(&self) -> fluent_builders::DeleteApp<C, M, R> {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBaiduChannel` operation.
    ///
    /// See [`DeleteBaiduChannel`](crate::client::fluent_builders::DeleteBaiduChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_baidu_channel(&self) -> fluent_builders::DeleteBaiduChannel<C, M, R> {
        fluent_builders::DeleteBaiduChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCampaign` operation.
    ///
    /// See [`DeleteCampaign`](crate::client::fluent_builders::DeleteCampaign) for more information about the
    /// operation and its arguments.
    pub fn delete_campaign(&self) -> fluent_builders::DeleteCampaign<C, M, R> {
        fluent_builders::DeleteCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEmailChannel` operation.
    ///
    /// See [`DeleteEmailChannel`](crate::client::fluent_builders::DeleteEmailChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_email_channel(&self) -> fluent_builders::DeleteEmailChannel<C, M, R> {
        fluent_builders::DeleteEmailChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEmailTemplate` operation.
    ///
    /// See [`DeleteEmailTemplate`](crate::client::fluent_builders::DeleteEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_email_template(&self) -> fluent_builders::DeleteEmailTemplate<C, M, R> {
        fluent_builders::DeleteEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpoint` operation.
    ///
    /// See [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint<C, M, R> {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventStream` operation.
    ///
    /// See [`DeleteEventStream`](crate::client::fluent_builders::DeleteEventStream) for more information about the
    /// operation and its arguments.
    pub fn delete_event_stream(&self) -> fluent_builders::DeleteEventStream<C, M, R> {
        fluent_builders::DeleteEventStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGcmChannel` operation.
    ///
    /// See [`DeleteGcmChannel`](crate::client::fluent_builders::DeleteGcmChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_gcm_channel(&self) -> fluent_builders::DeleteGcmChannel<C, M, R> {
        fluent_builders::DeleteGcmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInAppTemplate` operation.
    ///
    /// See [`DeleteInAppTemplate`](crate::client::fluent_builders::DeleteInAppTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_in_app_template(&self) -> fluent_builders::DeleteInAppTemplate<C, M, R> {
        fluent_builders::DeleteInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJourney` operation.
    ///
    /// See [`DeleteJourney`](crate::client::fluent_builders::DeleteJourney) for more information about the
    /// operation and its arguments.
    pub fn delete_journey(&self) -> fluent_builders::DeleteJourney<C, M, R> {
        fluent_builders::DeleteJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePushTemplate` operation.
    ///
    /// See [`DeletePushTemplate`](crate::client::fluent_builders::DeletePushTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_push_template(&self) -> fluent_builders::DeletePushTemplate<C, M, R> {
        fluent_builders::DeletePushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecommenderConfiguration` operation.
    ///
    /// See [`DeleteRecommenderConfiguration`](crate::client::fluent_builders::DeleteRecommenderConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_recommender_configuration(
        &self,
    ) -> fluent_builders::DeleteRecommenderConfiguration<C, M, R> {
        fluent_builders::DeleteRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSegment` operation.
    ///
    /// See [`DeleteSegment`](crate::client::fluent_builders::DeleteSegment) for more information about the
    /// operation and its arguments.
    pub fn delete_segment(&self) -> fluent_builders::DeleteSegment<C, M, R> {
        fluent_builders::DeleteSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSmsChannel` operation.
    ///
    /// See [`DeleteSmsChannel`](crate::client::fluent_builders::DeleteSmsChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_sms_channel(&self) -> fluent_builders::DeleteSmsChannel<C, M, R> {
        fluent_builders::DeleteSmsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSmsTemplate` operation.
    ///
    /// See [`DeleteSmsTemplate`](crate::client::fluent_builders::DeleteSmsTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_sms_template(&self) -> fluent_builders::DeleteSmsTemplate<C, M, R> {
        fluent_builders::DeleteSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserEndpoints` operation.
    ///
    /// See [`DeleteUserEndpoints`](crate::client::fluent_builders::DeleteUserEndpoints) for more information about the
    /// operation and its arguments.
    pub fn delete_user_endpoints(&self) -> fluent_builders::DeleteUserEndpoints<C, M, R> {
        fluent_builders::DeleteUserEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceChannel` operation.
    ///
    /// See [`DeleteVoiceChannel`](crate::client::fluent_builders::DeleteVoiceChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_channel(&self) -> fluent_builders::DeleteVoiceChannel<C, M, R> {
        fluent_builders::DeleteVoiceChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceTemplate` operation.
    ///
    /// See [`DeleteVoiceTemplate`](crate::client::fluent_builders::DeleteVoiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_template(&self) -> fluent_builders::DeleteVoiceTemplate<C, M, R> {
        fluent_builders::DeleteVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAdmChannel` operation.
    ///
    /// See [`GetAdmChannel`](crate::client::fluent_builders::GetAdmChannel) for more information about the
    /// operation and its arguments.
    pub fn get_adm_channel(&self) -> fluent_builders::GetAdmChannel<C, M, R> {
        fluent_builders::GetAdmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApnsChannel` operation.
    ///
    /// See [`GetApnsChannel`](crate::client::fluent_builders::GetApnsChannel) for more information about the
    /// operation and its arguments.
    pub fn get_apns_channel(&self) -> fluent_builders::GetApnsChannel<C, M, R> {
        fluent_builders::GetApnsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApnsSandboxChannel` operation.
    ///
    /// See [`GetApnsSandboxChannel`](crate::client::fluent_builders::GetApnsSandboxChannel) for more information about the
    /// operation and its arguments.
    pub fn get_apns_sandbox_channel(&self) -> fluent_builders::GetApnsSandboxChannel<C, M, R> {
        fluent_builders::GetApnsSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApnsVoipChannel` operation.
    ///
    /// See [`GetApnsVoipChannel`](crate::client::fluent_builders::GetApnsVoipChannel) for more information about the
    /// operation and its arguments.
    pub fn get_apns_voip_channel(&self) -> fluent_builders::GetApnsVoipChannel<C, M, R> {
        fluent_builders::GetApnsVoipChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApnsVoipSandboxChannel` operation.
    ///
    /// See [`GetApnsVoipSandboxChannel`](crate::client::fluent_builders::GetApnsVoipSandboxChannel) for more information about the
    /// operation and its arguments.
    pub fn get_apns_voip_sandbox_channel(
        &self,
    ) -> fluent_builders::GetApnsVoipSandboxChannel<C, M, R> {
        fluent_builders::GetApnsVoipSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApp` operation.
    ///
    /// See [`GetApp`](crate::client::fluent_builders::GetApp) for more information about the
    /// operation and its arguments.
    pub fn get_app(&self) -> fluent_builders::GetApp<C, M, R> {
        fluent_builders::GetApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplicationDateRangeKpi` operation.
    ///
    /// See [`GetApplicationDateRangeKpi`](crate::client::fluent_builders::GetApplicationDateRangeKpi) for more information about the
    /// operation and its arguments.
    pub fn get_application_date_range_kpi(
        &self,
    ) -> fluent_builders::GetApplicationDateRangeKpi<C, M, R> {
        fluent_builders::GetApplicationDateRangeKpi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplicationSettings` operation.
    ///
    /// See [`GetApplicationSettings`](crate::client::fluent_builders::GetApplicationSettings) for more information about the
    /// operation and its arguments.
    pub fn get_application_settings(&self) -> fluent_builders::GetApplicationSettings<C, M, R> {
        fluent_builders::GetApplicationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApps` operation.
    ///
    /// See [`GetApps`](crate::client::fluent_builders::GetApps) for more information about the
    /// operation and its arguments.
    pub fn get_apps(&self) -> fluent_builders::GetApps<C, M, R> {
        fluent_builders::GetApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBaiduChannel` operation.
    ///
    /// See [`GetBaiduChannel`](crate::client::fluent_builders::GetBaiduChannel) for more information about the
    /// operation and its arguments.
    pub fn get_baidu_channel(&self) -> fluent_builders::GetBaiduChannel<C, M, R> {
        fluent_builders::GetBaiduChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCampaign` operation.
    ///
    /// See [`GetCampaign`](crate::client::fluent_builders::GetCampaign) for more information about the
    /// operation and its arguments.
    pub fn get_campaign(&self) -> fluent_builders::GetCampaign<C, M, R> {
        fluent_builders::GetCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCampaignActivities` operation.
    ///
    /// See [`GetCampaignActivities`](crate::client::fluent_builders::GetCampaignActivities) for more information about the
    /// operation and its arguments.
    pub fn get_campaign_activities(&self) -> fluent_builders::GetCampaignActivities<C, M, R> {
        fluent_builders::GetCampaignActivities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCampaignDateRangeKpi` operation.
    ///
    /// See [`GetCampaignDateRangeKpi`](crate::client::fluent_builders::GetCampaignDateRangeKpi) for more information about the
    /// operation and its arguments.
    pub fn get_campaign_date_range_kpi(&self) -> fluent_builders::GetCampaignDateRangeKpi<C, M, R> {
        fluent_builders::GetCampaignDateRangeKpi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCampaigns` operation.
    ///
    /// See [`GetCampaigns`](crate::client::fluent_builders::GetCampaigns) for more information about the
    /// operation and its arguments.
    pub fn get_campaigns(&self) -> fluent_builders::GetCampaigns<C, M, R> {
        fluent_builders::GetCampaigns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCampaignVersion` operation.
    ///
    /// See [`GetCampaignVersion`](crate::client::fluent_builders::GetCampaignVersion) for more information about the
    /// operation and its arguments.
    pub fn get_campaign_version(&self) -> fluent_builders::GetCampaignVersion<C, M, R> {
        fluent_builders::GetCampaignVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCampaignVersions` operation.
    ///
    /// See [`GetCampaignVersions`](crate::client::fluent_builders::GetCampaignVersions) for more information about the
    /// operation and its arguments.
    pub fn get_campaign_versions(&self) -> fluent_builders::GetCampaignVersions<C, M, R> {
        fluent_builders::GetCampaignVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChannels` operation.
    ///
    /// See [`GetChannels`](crate::client::fluent_builders::GetChannels) for more information about the
    /// operation and its arguments.
    pub fn get_channels(&self) -> fluent_builders::GetChannels<C, M, R> {
        fluent_builders::GetChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEmailChannel` operation.
    ///
    /// See [`GetEmailChannel`](crate::client::fluent_builders::GetEmailChannel) for more information about the
    /// operation and its arguments.
    pub fn get_email_channel(&self) -> fluent_builders::GetEmailChannel<C, M, R> {
        fluent_builders::GetEmailChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEmailTemplate` operation.
    ///
    /// See [`GetEmailTemplate`](crate::client::fluent_builders::GetEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_email_template(&self) -> fluent_builders::GetEmailTemplate<C, M, R> {
        fluent_builders::GetEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEndpoint` operation.
    ///
    /// See [`GetEndpoint`](crate::client::fluent_builders::GetEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_endpoint(&self) -> fluent_builders::GetEndpoint<C, M, R> {
        fluent_builders::GetEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventStream` operation.
    ///
    /// See [`GetEventStream`](crate::client::fluent_builders::GetEventStream) for more information about the
    /// operation and its arguments.
    pub fn get_event_stream(&self) -> fluent_builders::GetEventStream<C, M, R> {
        fluent_builders::GetEventStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExportJob` operation.
    ///
    /// See [`GetExportJob`](crate::client::fluent_builders::GetExportJob) for more information about the
    /// operation and its arguments.
    pub fn get_export_job(&self) -> fluent_builders::GetExportJob<C, M, R> {
        fluent_builders::GetExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExportJobs` operation.
    ///
    /// See [`GetExportJobs`](crate::client::fluent_builders::GetExportJobs) for more information about the
    /// operation and its arguments.
    pub fn get_export_jobs(&self) -> fluent_builders::GetExportJobs<C, M, R> {
        fluent_builders::GetExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGcmChannel` operation.
    ///
    /// See [`GetGcmChannel`](crate::client::fluent_builders::GetGcmChannel) for more information about the
    /// operation and its arguments.
    pub fn get_gcm_channel(&self) -> fluent_builders::GetGcmChannel<C, M, R> {
        fluent_builders::GetGcmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImportJob` operation.
    ///
    /// See [`GetImportJob`](crate::client::fluent_builders::GetImportJob) for more information about the
    /// operation and its arguments.
    pub fn get_import_job(&self) -> fluent_builders::GetImportJob<C, M, R> {
        fluent_builders::GetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImportJobs` operation.
    ///
    /// See [`GetImportJobs`](crate::client::fluent_builders::GetImportJobs) for more information about the
    /// operation and its arguments.
    pub fn get_import_jobs(&self) -> fluent_builders::GetImportJobs<C, M, R> {
        fluent_builders::GetImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInAppMessages` operation.
    ///
    /// See [`GetInAppMessages`](crate::client::fluent_builders::GetInAppMessages) for more information about the
    /// operation and its arguments.
    pub fn get_in_app_messages(&self) -> fluent_builders::GetInAppMessages<C, M, R> {
        fluent_builders::GetInAppMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInAppTemplate` operation.
    ///
    /// See [`GetInAppTemplate`](crate::client::fluent_builders::GetInAppTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_in_app_template(&self) -> fluent_builders::GetInAppTemplate<C, M, R> {
        fluent_builders::GetInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJourney` operation.
    ///
    /// See [`GetJourney`](crate::client::fluent_builders::GetJourney) for more information about the
    /// operation and its arguments.
    pub fn get_journey(&self) -> fluent_builders::GetJourney<C, M, R> {
        fluent_builders::GetJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJourneyDateRangeKpi` operation.
    ///
    /// See [`GetJourneyDateRangeKpi`](crate::client::fluent_builders::GetJourneyDateRangeKpi) for more information about the
    /// operation and its arguments.
    pub fn get_journey_date_range_kpi(&self) -> fluent_builders::GetJourneyDateRangeKpi<C, M, R> {
        fluent_builders::GetJourneyDateRangeKpi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJourneyExecutionActivityMetrics` operation.
    ///
    /// See [`GetJourneyExecutionActivityMetrics`](crate::client::fluent_builders::GetJourneyExecutionActivityMetrics) for more information about the
    /// operation and its arguments.
    pub fn get_journey_execution_activity_metrics(
        &self,
    ) -> fluent_builders::GetJourneyExecutionActivityMetrics<C, M, R> {
        fluent_builders::GetJourneyExecutionActivityMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJourneyExecutionMetrics` operation.
    ///
    /// See [`GetJourneyExecutionMetrics`](crate::client::fluent_builders::GetJourneyExecutionMetrics) for more information about the
    /// operation and its arguments.
    pub fn get_journey_execution_metrics(
        &self,
    ) -> fluent_builders::GetJourneyExecutionMetrics<C, M, R> {
        fluent_builders::GetJourneyExecutionMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPushTemplate` operation.
    ///
    /// See [`GetPushTemplate`](crate::client::fluent_builders::GetPushTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_push_template(&self) -> fluent_builders::GetPushTemplate<C, M, R> {
        fluent_builders::GetPushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecommenderConfiguration` operation.
    ///
    /// See [`GetRecommenderConfiguration`](crate::client::fluent_builders::GetRecommenderConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_recommender_configuration(
        &self,
    ) -> fluent_builders::GetRecommenderConfiguration<C, M, R> {
        fluent_builders::GetRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecommenderConfigurations` operation.
    ///
    /// See [`GetRecommenderConfigurations`](crate::client::fluent_builders::GetRecommenderConfigurations) for more information about the
    /// operation and its arguments.
    pub fn get_recommender_configurations(
        &self,
    ) -> fluent_builders::GetRecommenderConfigurations<C, M, R> {
        fluent_builders::GetRecommenderConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegment` operation.
    ///
    /// See [`GetSegment`](crate::client::fluent_builders::GetSegment) for more information about the
    /// operation and its arguments.
    pub fn get_segment(&self) -> fluent_builders::GetSegment<C, M, R> {
        fluent_builders::GetSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegmentExportJobs` operation.
    ///
    /// See [`GetSegmentExportJobs`](crate::client::fluent_builders::GetSegmentExportJobs) for more information about the
    /// operation and its arguments.
    pub fn get_segment_export_jobs(&self) -> fluent_builders::GetSegmentExportJobs<C, M, R> {
        fluent_builders::GetSegmentExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegmentImportJobs` operation.
    ///
    /// See [`GetSegmentImportJobs`](crate::client::fluent_builders::GetSegmentImportJobs) for more information about the
    /// operation and its arguments.
    pub fn get_segment_import_jobs(&self) -> fluent_builders::GetSegmentImportJobs<C, M, R> {
        fluent_builders::GetSegmentImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegments` operation.
    ///
    /// See [`GetSegments`](crate::client::fluent_builders::GetSegments) for more information about the
    /// operation and its arguments.
    pub fn get_segments(&self) -> fluent_builders::GetSegments<C, M, R> {
        fluent_builders::GetSegments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegmentVersion` operation.
    ///
    /// See [`GetSegmentVersion`](crate::client::fluent_builders::GetSegmentVersion) for more information about the
    /// operation and its arguments.
    pub fn get_segment_version(&self) -> fluent_builders::GetSegmentVersion<C, M, R> {
        fluent_builders::GetSegmentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegmentVersions` operation.
    ///
    /// See [`GetSegmentVersions`](crate::client::fluent_builders::GetSegmentVersions) for more information about the
    /// operation and its arguments.
    pub fn get_segment_versions(&self) -> fluent_builders::GetSegmentVersions<C, M, R> {
        fluent_builders::GetSegmentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSmsChannel` operation.
    ///
    /// See [`GetSmsChannel`](crate::client::fluent_builders::GetSmsChannel) for more information about the
    /// operation and its arguments.
    pub fn get_sms_channel(&self) -> fluent_builders::GetSmsChannel<C, M, R> {
        fluent_builders::GetSmsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSmsTemplate` operation.
    ///
    /// See [`GetSmsTemplate`](crate::client::fluent_builders::GetSmsTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_sms_template(&self) -> fluent_builders::GetSmsTemplate<C, M, R> {
        fluent_builders::GetSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUserEndpoints` operation.
    ///
    /// See [`GetUserEndpoints`](crate::client::fluent_builders::GetUserEndpoints) for more information about the
    /// operation and its arguments.
    pub fn get_user_endpoints(&self) -> fluent_builders::GetUserEndpoints<C, M, R> {
        fluent_builders::GetUserEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceChannel` operation.
    ///
    /// See [`GetVoiceChannel`](crate::client::fluent_builders::GetVoiceChannel) for more information about the
    /// operation and its arguments.
    pub fn get_voice_channel(&self) -> fluent_builders::GetVoiceChannel<C, M, R> {
        fluent_builders::GetVoiceChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceTemplate` operation.
    ///
    /// See [`GetVoiceTemplate`](crate::client::fluent_builders::GetVoiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_voice_template(&self) -> fluent_builders::GetVoiceTemplate<C, M, R> {
        fluent_builders::GetVoiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJourneys` operation.
    ///
    /// See [`ListJourneys`](crate::client::fluent_builders::ListJourneys) for more information about the
    /// operation and its arguments.
    pub fn list_journeys(&self) -> fluent_builders::ListJourneys<C, M, R> {
        fluent_builders::ListJourneys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTemplates` operation.
    ///
    /// See [`ListTemplates`](crate::client::fluent_builders::ListTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_templates(&self) -> fluent_builders::ListTemplates<C, M, R> {
        fluent_builders::ListTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTemplateVersions` operation.
    ///
    /// See [`ListTemplateVersions`](crate::client::fluent_builders::ListTemplateVersions) for more information about the
    /// operation and its arguments.
    pub fn list_template_versions(&self) -> fluent_builders::ListTemplateVersions<C, M, R> {
        fluent_builders::ListTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PhoneNumberValidate` operation.
    ///
    /// See [`PhoneNumberValidate`](crate::client::fluent_builders::PhoneNumberValidate) for more information about the
    /// operation and its arguments.
    pub fn phone_number_validate(&self) -> fluent_builders::PhoneNumberValidate<C, M, R> {
        fluent_builders::PhoneNumberValidate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEvents` operation.
    ///
    /// See [`PutEvents`](crate::client::fluent_builders::PutEvents) for more information about the
    /// operation and its arguments.
    pub fn put_events(&self) -> fluent_builders::PutEvents<C, M, R> {
        fluent_builders::PutEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEventStream` operation.
    ///
    /// See [`PutEventStream`](crate::client::fluent_builders::PutEventStream) for more information about the
    /// operation and its arguments.
    pub fn put_event_stream(&self) -> fluent_builders::PutEventStream<C, M, R> {
        fluent_builders::PutEventStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveAttributes` operation.
    ///
    /// See [`RemoveAttributes`](crate::client::fluent_builders::RemoveAttributes) for more information about the
    /// operation and its arguments.
    pub fn remove_attributes(&self) -> fluent_builders::RemoveAttributes<C, M, R> {
        fluent_builders::RemoveAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendMessages` operation.
    ///
    /// See [`SendMessages`](crate::client::fluent_builders::SendMessages) for more information about the
    /// operation and its arguments.
    pub fn send_messages(&self) -> fluent_builders::SendMessages<C, M, R> {
        fluent_builders::SendMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendUsersMessages` operation.
    ///
    /// See [`SendUsersMessages`](crate::client::fluent_builders::SendUsersMessages) for more information about the
    /// operation and its arguments.
    pub fn send_users_messages(&self) -> fluent_builders::SendUsersMessages<C, M, R> {
        fluent_builders::SendUsersMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAdmChannel` operation.
    ///
    /// See [`UpdateAdmChannel`](crate::client::fluent_builders::UpdateAdmChannel) for more information about the
    /// operation and its arguments.
    pub fn update_adm_channel(&self) -> fluent_builders::UpdateAdmChannel<C, M, R> {
        fluent_builders::UpdateAdmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApnsChannel` operation.
    ///
    /// See [`UpdateApnsChannel`](crate::client::fluent_builders::UpdateApnsChannel) for more information about the
    /// operation and its arguments.
    pub fn update_apns_channel(&self) -> fluent_builders::UpdateApnsChannel<C, M, R> {
        fluent_builders::UpdateApnsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApnsSandboxChannel` operation.
    ///
    /// See [`UpdateApnsSandboxChannel`](crate::client::fluent_builders::UpdateApnsSandboxChannel) for more information about the
    /// operation and its arguments.
    pub fn update_apns_sandbox_channel(
        &self,
    ) -> fluent_builders::UpdateApnsSandboxChannel<C, M, R> {
        fluent_builders::UpdateApnsSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApnsVoipChannel` operation.
    ///
    /// See [`UpdateApnsVoipChannel`](crate::client::fluent_builders::UpdateApnsVoipChannel) for more information about the
    /// operation and its arguments.
    pub fn update_apns_voip_channel(&self) -> fluent_builders::UpdateApnsVoipChannel<C, M, R> {
        fluent_builders::UpdateApnsVoipChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApnsVoipSandboxChannel` operation.
    ///
    /// See [`UpdateApnsVoipSandboxChannel`](crate::client::fluent_builders::UpdateApnsVoipSandboxChannel) for more information about the
    /// operation and its arguments.
    pub fn update_apns_voip_sandbox_channel(
        &self,
    ) -> fluent_builders::UpdateApnsVoipSandboxChannel<C, M, R> {
        fluent_builders::UpdateApnsVoipSandboxChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplicationSettings` operation.
    ///
    /// See [`UpdateApplicationSettings`](crate::client::fluent_builders::UpdateApplicationSettings) for more information about the
    /// operation and its arguments.
    pub fn update_application_settings(
        &self,
    ) -> fluent_builders::UpdateApplicationSettings<C, M, R> {
        fluent_builders::UpdateApplicationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBaiduChannel` operation.
    ///
    /// See [`UpdateBaiduChannel`](crate::client::fluent_builders::UpdateBaiduChannel) for more information about the
    /// operation and its arguments.
    pub fn update_baidu_channel(&self) -> fluent_builders::UpdateBaiduChannel<C, M, R> {
        fluent_builders::UpdateBaiduChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCampaign` operation.
    ///
    /// See [`UpdateCampaign`](crate::client::fluent_builders::UpdateCampaign) for more information about the
    /// operation and its arguments.
    pub fn update_campaign(&self) -> fluent_builders::UpdateCampaign<C, M, R> {
        fluent_builders::UpdateCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEmailChannel` operation.
    ///
    /// See [`UpdateEmailChannel`](crate::client::fluent_builders::UpdateEmailChannel) for more information about the
    /// operation and its arguments.
    pub fn update_email_channel(&self) -> fluent_builders::UpdateEmailChannel<C, M, R> {
        fluent_builders::UpdateEmailChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEmailTemplate` operation.
    ///
    /// See [`UpdateEmailTemplate`](crate::client::fluent_builders::UpdateEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_email_template(&self) -> fluent_builders::UpdateEmailTemplate<C, M, R> {
        fluent_builders::UpdateEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEndpoint` operation.
    ///
    /// See [`UpdateEndpoint`](crate::client::fluent_builders::UpdateEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_endpoint(&self) -> fluent_builders::UpdateEndpoint<C, M, R> {
        fluent_builders::UpdateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEndpointsBatch` operation.
    ///
    /// See [`UpdateEndpointsBatch`](crate::client::fluent_builders::UpdateEndpointsBatch) for more information about the
    /// operation and its arguments.
    pub fn update_endpoints_batch(&self) -> fluent_builders::UpdateEndpointsBatch<C, M, R> {
        fluent_builders::UpdateEndpointsBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGcmChannel` operation.
    ///
    /// See [`UpdateGcmChannel`](crate::client::fluent_builders::UpdateGcmChannel) for more information about the
    /// operation and its arguments.
    pub fn update_gcm_channel(&self) -> fluent_builders::UpdateGcmChannel<C, M, R> {
        fluent_builders::UpdateGcmChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInAppTemplate` operation.
    ///
    /// See [`UpdateInAppTemplate`](crate::client::fluent_builders::UpdateInAppTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_in_app_template(&self) -> fluent_builders::UpdateInAppTemplate<C, M, R> {
        fluent_builders::UpdateInAppTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJourney` operation.
    ///
    /// See [`UpdateJourney`](crate::client::fluent_builders::UpdateJourney) for more information about the
    /// operation and its arguments.
    pub fn update_journey(&self) -> fluent_builders::UpdateJourney<C, M, R> {
        fluent_builders::UpdateJourney::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJourneyState` operation.
    ///
    /// See [`UpdateJourneyState`](crate::client::fluent_builders::UpdateJourneyState) for more information about the
    /// operation and its arguments.
    pub fn update_journey_state(&self) -> fluent_builders::UpdateJourneyState<C, M, R> {
        fluent_builders::UpdateJourneyState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePushTemplate` operation.
    ///
    /// See [`UpdatePushTemplate`](crate::client::fluent_builders::UpdatePushTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_push_template(&self) -> fluent_builders::UpdatePushTemplate<C, M, R> {
        fluent_builders::UpdatePushTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecommenderConfiguration` operation.
    ///
    /// See [`UpdateRecommenderConfiguration`](crate::client::fluent_builders::UpdateRecommenderConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_recommender_configuration(
        &self,
    ) -> fluent_builders::UpdateRecommenderConfiguration<C, M, R> {
        fluent_builders::UpdateRecommenderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSegment` operation.
    ///
    /// See [`UpdateSegment`](crate::client::fluent_builders::UpdateSegment) for more information about the
    /// operation and its arguments.
    pub fn update_segment(&self) -> fluent_builders::UpdateSegment<C, M, R> {
        fluent_builders::UpdateSegment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSmsChannel` operation.
    ///
    /// See [`UpdateSmsChannel`](crate::client::fluent_builders::UpdateSmsChannel) for more information about the
    /// operation and its arguments.
    pub fn update_sms_channel(&self) -> fluent_builders::UpdateSmsChannel<C, M, R> {
        fluent_builders::UpdateSmsChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSmsTemplate` operation.
    ///
    /// See [`UpdateSmsTemplate`](crate::client::fluent_builders::UpdateSmsTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_sms_template(&self) -> fluent_builders::UpdateSmsTemplate<C, M, R> {
        fluent_builders::UpdateSmsTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTemplateActiveVersion` operation.
    ///
    /// See [`UpdateTemplateActiveVersion`](crate::client::fluent_builders::UpdateTemplateActiveVersion) for more information about the
    /// operation and its arguments.
    pub fn update_template_active_version(
        &self,
    ) -> fluent_builders::UpdateTemplateActiveVersion<C, M, R> {
        fluent_builders::UpdateTemplateActiveVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVoiceChannel` operation.
    ///
    /// See [`UpdateVoiceChannel`](crate::client::fluent_builders::UpdateVoiceChannel) for more information about the
    /// operation and its arguments.
    pub fn update_voice_channel(&self) -> fluent_builders::UpdateVoiceChannel<C, M, R> {
        fluent_builders::UpdateVoiceChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVoiceTemplate` operation.
    ///
    /// See [`UpdateVoiceTemplate`](crate::client::fluent_builders::UpdateVoiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_voice_template(&self) -> fluent_builders::UpdateVoiceTemplate<C, M, R> {
        fluent_builders::UpdateVoiceTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p>Creates an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_input::Builder,
    }
    impl<C, M, R> CreateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInputOperationOutputAlias,
                crate::output::CreateAppOutput,
                crate::error::CreateAppError,
                crate::input::CreateAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the display name of an application and the tags to associate with the application.</p>
        pub fn create_application_request(
            mut self,
            inp: crate::model::CreateApplicationRequest,
        ) -> Self {
            self.inner = self.inner.create_application_request(inp);
            self
        }
        /// <p>Specifies the display name of an application and the tags to associate with the application.</p>
        pub fn set_create_application_request(
            mut self,
            input: std::option::Option<crate::model::CreateApplicationRequest>,
        ) -> Self {
            self.inner = self.inner.set_create_application_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCampaign`.
    ///
    /// <p>Creates a new campaign for an application or updates the settings of an existing campaign for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_campaign_input::Builder,
    }
    impl<C, M, R> CreateCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCampaignInputOperationOutputAlias,
                crate::output::CreateCampaignOutput,
                crate::error::CreateCampaignError,
                crate::input::CreateCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn write_campaign_request(mut self, inp: crate::model::WriteCampaignRequest) -> Self {
            self.inner = self.inner.write_campaign_request(inp);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn set_write_campaign_request(
            mut self,
            input: std::option::Option<crate::model::WriteCampaignRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_campaign_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through the email channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_email_template_input::Builder,
    }
    impl<C, M, R> CreateEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEmailTemplateInputOperationOutputAlias,
                crate::output::CreateEmailTemplateOutput,
                crate::error::CreateEmailTemplateError,
                crate::input::CreateEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn email_template_request(mut self, inp: crate::model::EmailTemplateRequest) -> Self {
            self.inner = self.inner.email_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn set_email_template_request(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_email_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExportJob`.
    ///
    /// <p>Creates an export job for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_export_job_input::Builder,
    }
    impl<C, M, R> CreateExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateExportJobInputOperationOutputAlias,
                crate::output::CreateExportJobOutput,
                crate::error::CreateExportJobError,
                crate::input::CreateExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn export_job_request(mut self, inp: crate::model::ExportJobRequest) -> Self {
            self.inner = self.inner.export_job_request(inp);
            self
        }
        /// <p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_export_job_request(
            mut self,
            input: std::option::Option<crate::model::ExportJobRequest>,
        ) -> Self {
            self.inner = self.inner.set_export_job_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImportJob`.
    ///
    /// <p>Creates an import job for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_import_job_input::Builder,
    }
    impl<C, M, R> CreateImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImportJobInputOperationOutputAlias,
                crate::output::CreateImportJobOutput,
                crate::error::CreateImportJobError,
                crate::input::CreateImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn import_job_request(mut self, inp: crate::model::ImportJobRequest) -> Self {
            self.inner = self.inner.import_job_request(inp);
            self
        }
        /// <p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_import_job_request(
            mut self,
            input: std::option::Option<crate::model::ImportJobRequest>,
        ) -> Self {
            self.inner = self.inner.set_import_job_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInAppTemplate`.
    ///
    /// <p>Creates a new message template for messages using the in-app message channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_in_app_template_input::Builder,
    }
    impl<C, M, R> CreateInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInAppTemplateInputOperationOutputAlias,
                crate::output::CreateInAppTemplateOutput,
                crate::error::CreateInAppTemplateError,
                crate::input::CreateInAppTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>InApp Template Request.</p>
        pub fn in_app_template_request(mut self, inp: crate::model::InAppTemplateRequest) -> Self {
            self.inner = self.inner.in_app_template_request(inp);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn set_in_app_template_request(
            mut self,
            input: std::option::Option<crate::model::InAppTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_in_app_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJourney`.
    ///
    /// <p>Creates a journey for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_journey_input::Builder,
    }
    impl<C, M, R> CreateJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJourneyInputOperationOutputAlias,
                crate::output::CreateJourneyOutput,
                crate::error::CreateJourneyError,
                crate::input::CreateJourneyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn write_journey_request(mut self, inp: crate::model::WriteJourneyRequest) -> Self {
            self.inner = self.inner.write_journey_request(inp);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn set_write_journey_request(
            mut self,
            input: std::option::Option<crate::model::WriteJourneyRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_journey_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePushTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through a push notification channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_push_template_input::Builder,
    }
    impl<C, M, R> CreatePushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePushTemplateInputOperationOutputAlias,
                crate::output::CreatePushTemplateOutput,
                crate::error::CreatePushTemplateError,
                crate::input::CreatePushTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn push_notification_template_request(
            mut self,
            inp: crate::model::PushNotificationTemplateRequest,
        ) -> Self {
            self.inner = self.inner.push_notification_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn set_push_notification_template_request(
            mut self,
            input: std::option::Option<crate::model::PushNotificationTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_push_notification_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecommenderConfiguration`.
    ///
    /// <p>Creates an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recommender_configuration_input::Builder,
    }
    impl<C, M, R> CreateRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecommenderConfigurationInputOperationOutputAlias,
                crate::output::CreateRecommenderConfigurationOutput,
                crate::error::CreateRecommenderConfigurationError,
                crate::input::CreateRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn create_recommender_configuration(
            mut self,
            inp: crate::model::CreateRecommenderConfigurationShape,
        ) -> Self {
            self.inner = self.inner.create_recommender_configuration(inp);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn set_create_recommender_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateRecommenderConfigurationShape>,
        ) -> Self {
            self.inner = self.inner.set_create_recommender_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSegment`.
    ///
    /// <p>Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_segment_input::Builder,
    }
    impl<C, M, R> CreateSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSegmentInputOperationOutputAlias,
                crate::output::CreateSegmentOutput,
                crate::error::CreateSegmentError,
                crate::input::CreateSegmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn write_segment_request(mut self, inp: crate::model::WriteSegmentRequest) -> Self {
            self.inner = self.inner.write_segment_request(inp);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn set_write_segment_request(
            mut self,
            input: std::option::Option<crate::model::WriteSegmentRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_segment_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSmsTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through the SMS channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sms_template_input::Builder,
    }
    impl<C, M, R> CreateSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSmsTemplateInputOperationOutputAlias,
                crate::output::CreateSmsTemplateOutput,
                crate::error::CreateSmsTemplateError,
                crate::input::CreateSmsTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn sms_template_request(mut self, inp: crate::model::SmsTemplateRequest) -> Self {
            self.inner = self.inner.sms_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn set_sms_template_request(
            mut self,
            input: std::option::Option<crate::model::SmsTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_sms_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVoiceTemplate`.
    ///
    /// <p>Creates a message template for messages that are sent through the voice channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_voice_template_input::Builder,
    }
    impl<C, M, R> CreateVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVoiceTemplateInputOperationOutputAlias,
                crate::output::CreateVoiceTemplateOutput,
                crate::error::CreateVoiceTemplateError,
                crate::input::CreateVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn voice_template_request(mut self, inp: crate::model::VoiceTemplateRequest) -> Self {
            self.inner = self.inner.voice_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn set_voice_template_request(
            mut self,
            input: std::option::Option<crate::model::VoiceTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_voice_template_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAdmChannel`.
    ///
    /// <p>Disables the ADM channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAdmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_adm_channel_input::Builder,
    }
    impl<C, M, R> DeleteAdmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAdmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAdmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAdmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAdmChannelInputOperationOutputAlias,
                crate::output::DeleteAdmChannelOutput,
                crate::error::DeleteAdmChannelError,
                crate::input::DeleteAdmChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsChannel`.
    ///
    /// <p>Disables the APNs channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApnsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsChannelInputOperationOutputAlias,
                crate::output::DeleteApnsChannelOutput,
                crate::error::DeleteApnsChannelError,
                crate::input::DeleteApnsChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsSandboxChannel`.
    ///
    /// <p>Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApnsSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_sandbox_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsSandboxChannelInputOperationOutputAlias,
                crate::output::DeleteApnsSandboxChannelOutput,
                crate::error::DeleteApnsSandboxChannelError,
                crate::input::DeleteApnsSandboxChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsVoipChannel`.
    ///
    /// <p>Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApnsVoipChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_voip_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsVoipChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsVoipChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsVoipChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsVoipChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsVoipChannelInputOperationOutputAlias,
                crate::output::DeleteApnsVoipChannelOutput,
                crate::error::DeleteApnsVoipChannelError,
                crate::input::DeleteApnsVoipChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApnsVoipSandboxChannel`.
    ///
    /// <p>Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApnsVoipSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_apns_voip_sandbox_channel_input::Builder,
    }
    impl<C, M, R> DeleteApnsVoipSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApnsVoipSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApnsVoipSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApnsVoipSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApnsVoipSandboxChannelInputOperationOutputAlias,
                crate::output::DeleteApnsVoipSandboxChannelOutput,
                crate::error::DeleteApnsVoipSandboxChannelError,
                crate::input::DeleteApnsVoipSandboxChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p>Deletes an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApp<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl<C, M, R> DeleteApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInputOperationOutputAlias,
                crate::output::DeleteAppOutput,
                crate::error::DeleteAppError,
                crate::input::DeleteAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBaiduChannel`.
    ///
    /// <p>Disables the Baidu channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBaiduChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_baidu_channel_input::Builder,
    }
    impl<C, M, R> DeleteBaiduChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBaiduChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBaiduChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBaiduChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBaiduChannelInputOperationOutputAlias,
                crate::output::DeleteBaiduChannelOutput,
                crate::error::DeleteBaiduChannelError,
                crate::input::DeleteBaiduChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCampaign`.
    ///
    /// <p>Deletes a campaign from an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_campaign_input::Builder,
    }
    impl<C, M, R> DeleteCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCampaignInputOperationOutputAlias,
                crate::output::DeleteCampaignOutput,
                crate::error::DeleteCampaignError,
                crate::input::DeleteCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailChannel`.
    ///
    /// <p>Disables the email channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEmailChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_channel_input::Builder,
    }
    impl<C, M, R> DeleteEmailChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailChannelInputOperationOutputAlias,
                crate::output::DeleteEmailChannelOutput,
                crate::error::DeleteEmailChannelError,
                crate::input::DeleteEmailChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through the email channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_template_input::Builder,
    }
    impl<C, M, R> DeleteEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailTemplateInputOperationOutputAlias,
                crate::output::DeleteEmailTemplateOutput,
                crate::error::DeleteEmailTemplateError,
                crate::input::DeleteEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes an endpoint from an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointInputOperationOutputAlias,
                crate::output::DeleteEndpointOutput,
                crate::error::DeleteEndpointError,
                crate::input::DeleteEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventStream`.
    ///
    /// <p>Deletes the event stream for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_stream_input::Builder,
    }
    impl<C, M, R> DeleteEventStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventStreamInputOperationOutputAlias,
                crate::output::DeleteEventStreamOutput,
                crate::error::DeleteEventStreamError,
                crate::input::DeleteEventStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGcmChannel`.
    ///
    /// <p>Disables the GCM channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGcmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gcm_channel_input::Builder,
    }
    impl<C, M, R> DeleteGcmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGcmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGcmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGcmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGcmChannelInputOperationOutputAlias,
                crate::output::DeleteGcmChannelOutput,
                crate::error::DeleteGcmChannelError,
                crate::input::DeleteGcmChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInAppTemplate`.
    ///
    /// <p>Deletes a message template for messages sent using the in-app message channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_in_app_template_input::Builder,
    }
    impl<C, M, R> DeleteInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInAppTemplateInputOperationOutputAlias,
                crate::output::DeleteInAppTemplateOutput,
                crate::error::DeleteInAppTemplateError,
                crate::input::DeleteInAppTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJourney`.
    ///
    /// <p>Deletes a journey from an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_journey_input::Builder,
    }
    impl<C, M, R> DeleteJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJourneyInputOperationOutputAlias,
                crate::output::DeleteJourneyOutput,
                crate::error::DeleteJourneyError,
                crate::input::DeleteJourneyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePushTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through a push notification channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_push_template_input::Builder,
    }
    impl<C, M, R> DeletePushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePushTemplateInputOperationOutputAlias,
                crate::output::DeletePushTemplateOutput,
                crate::error::DeletePushTemplateError,
                crate::input::DeletePushTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecommenderConfiguration`.
    ///
    /// <p>Deletes an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recommender_configuration_input::Builder,
    }
    impl<C, M, R> DeleteRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecommenderConfigurationInputOperationOutputAlias,
                crate::output::DeleteRecommenderConfigurationOutput,
                crate::error::DeleteRecommenderConfigurationError,
                crate::input::DeleteRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_id(inp);
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSegment`.
    ///
    /// <p>Deletes a segment from an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_segment_input::Builder,
    }
    impl<C, M, R> DeleteSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSegmentInputOperationOutputAlias,
                crate::output::DeleteSegmentOutput,
                crate::error::DeleteSegmentError,
                crate::input::DeleteSegmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSmsChannel`.
    ///
    /// <p>Disables the SMS channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSmsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sms_channel_input::Builder,
    }
    impl<C, M, R> DeleteSmsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSmsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSmsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSmsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSmsChannelInputOperationOutputAlias,
                crate::output::DeleteSmsChannelOutput,
                crate::error::DeleteSmsChannelError,
                crate::input::DeleteSmsChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSmsTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through the SMS channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sms_template_input::Builder,
    }
    impl<C, M, R> DeleteSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSmsTemplateInputOperationOutputAlias,
                crate::output::DeleteSmsTemplateOutput,
                crate::error::DeleteSmsTemplateError,
                crate::input::DeleteSmsTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserEndpoints`.
    ///
    /// <p>Deletes all the endpoints that are associated with a specific user ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_endpoints_input::Builder,
    }
    impl<C, M, R> DeleteUserEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserEndpointsInputOperationOutputAlias,
                crate::output::DeleteUserEndpointsOutput,
                crate::error::DeleteUserEndpointsError,
                crate::input::DeleteUserEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceChannel`.
    ///
    /// <p>Disables the voice channel for an application and deletes any existing settings for the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_channel_input::Builder,
    }
    impl<C, M, R> DeleteVoiceChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceChannelInputOperationOutputAlias,
                crate::output::DeleteVoiceChannelOutput,
                crate::error::DeleteVoiceChannelError,
                crate::input::DeleteVoiceChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceTemplate`.
    ///
    /// <p>Deletes a message template for messages that were sent through the voice channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_template_input::Builder,
    }
    impl<C, M, R> DeleteVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceTemplateInputOperationOutputAlias,
                crate::output::DeleteVoiceTemplateOutput,
                crate::error::DeleteVoiceTemplateError,
                crate::input::DeleteVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAdmChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the ADM channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAdmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_adm_channel_input::Builder,
    }
    impl<C, M, R> GetAdmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAdmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAdmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAdmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAdmChannelInputOperationOutputAlias,
                crate::output::GetAdmChannelOutput,
                crate::error::GetAdmChannelError,
                crate::input::GetAdmChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApnsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_channel_input::Builder,
    }
    impl<C, M, R> GetApnsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsChannelInputOperationOutputAlias,
                crate::output::GetApnsChannelOutput,
                crate::error::GetApnsChannelError,
                crate::input::GetApnsChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsSandboxChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs sandbox channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApnsSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_sandbox_channel_input::Builder,
    }
    impl<C, M, R> GetApnsSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsSandboxChannelInputOperationOutputAlias,
                crate::output::GetApnsSandboxChannelOutput,
                crate::error::GetApnsSandboxChannelError,
                crate::input::GetApnsSandboxChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsVoipChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs VoIP channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApnsVoipChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_voip_channel_input::Builder,
    }
    impl<C, M, R> GetApnsVoipChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsVoipChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsVoipChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsVoipChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsVoipChannelInputOperationOutputAlias,
                crate::output::GetApnsVoipChannelOutput,
                crate::error::GetApnsVoipChannelError,
                crate::input::GetApnsVoipChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApnsVoipSandboxChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApnsVoipSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apns_voip_sandbox_channel_input::Builder,
    }
    impl<C, M, R> GetApnsVoipSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApnsVoipSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApnsVoipSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApnsVoipSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApnsVoipSandboxChannelInputOperationOutputAlias,
                crate::output::GetApnsVoipSandboxChannelOutput,
                crate::error::GetApnsVoipSandboxChannelError,
                crate::input::GetApnsVoipSandboxChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApp`.
    ///
    /// <p>Retrieves information about an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApp<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_input::Builder,
    }
    impl<C, M, R> GetApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInputOperationOutputAlias,
                crate::output::GetAppOutput,
                crate::error::GetAppError,
                crate::input::GetAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationDateRangeKpi`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplicationDateRangeKpi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_date_range_kpi_input::Builder,
    }
    impl<C, M, R> GetApplicationDateRangeKpi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationDateRangeKpi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationDateRangeKpiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationDateRangeKpiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationDateRangeKpiInputOperationOutputAlias,
                crate::output::GetApplicationDateRangeKpiOutput,
                crate::error::GetApplicationDateRangeKpiError,
                crate::input::GetApplicationDateRangeKpiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kpi_name(inp);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kpi_name(input);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationSettings`.
    ///
    /// <p>Retrieves information about the settings for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplicationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_settings_input::Builder,
    }
    impl<C, M, R> GetApplicationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationSettingsInputOperationOutputAlias,
                crate::output::GetApplicationSettingsOutput,
                crate::error::GetApplicationSettingsError,
                crate::input::GetApplicationSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApps`.
    ///
    /// <p>Retrieves information about all the applications that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApps<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_apps_input::Builder,
    }
    impl<C, M, R> GetApps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppsInputOperationOutputAlias,
                crate::output::GetAppsOutput,
                crate::error::GetAppsError,
                crate::input::GetAppsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBaiduChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the Baidu channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBaiduChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_baidu_channel_input::Builder,
    }
    impl<C, M, R> GetBaiduChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBaiduChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBaiduChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBaiduChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBaiduChannelInputOperationOutputAlias,
                crate::output::GetBaiduChannelOutput,
                crate::error::GetBaiduChannelError,
                crate::input::GetBaiduChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaign`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for a campaign.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_input::Builder,
    }
    impl<C, M, R> GetCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignInputOperationOutputAlias,
                crate::output::GetCampaignOutput,
                crate::error::GetCampaignError,
                crate::input::GetCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignActivities`.
    ///
    /// <p>Retrieves information about all the activities for a campaign.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCampaignActivities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_activities_input::Builder,
    }
    impl<C, M, R> GetCampaignActivities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignActivities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignActivitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignActivitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignActivitiesInputOperationOutputAlias,
                crate::output::GetCampaignActivitiesOutput,
                crate::error::GetCampaignActivitiesError,
                crate::input::GetCampaignActivitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignDateRangeKpi`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCampaignDateRangeKpi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_date_range_kpi_input::Builder,
    }
    impl<C, M, R> GetCampaignDateRangeKpi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignDateRangeKpi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignDateRangeKpiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignDateRangeKpiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignDateRangeKpiInputOperationOutputAlias,
                crate::output::GetCampaignDateRangeKpiOutput,
                crate::error::GetCampaignDateRangeKpiError,
                crate::input::GetCampaignDateRangeKpiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kpi_name(inp);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kpi_name(input);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaigns`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCampaigns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaigns_input::Builder,
    }
    impl<C, M, R> GetCampaigns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaigns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignsInputOperationOutputAlias,
                crate::output::GetCampaignsOutput,
                crate::error::GetCampaignsError,
                crate::input::GetCampaignsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignVersion`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for a specific version of a campaign.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCampaignVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_version_input::Builder,
    }
    impl<C, M, R> GetCampaignVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignVersionInputOperationOutputAlias,
                crate::output::GetCampaignVersionOutput,
                crate::error::GetCampaignVersionError,
                crate::input::GetCampaignVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCampaignVersions`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for all versions of a campaign.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCampaignVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_campaign_versions_input::Builder,
    }
    impl<C, M, R> GetCampaignVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCampaignVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCampaignVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCampaignVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCampaignVersionsInputOperationOutputAlias,
                crate::output::GetCampaignVersionsOutput,
                crate::error::GetCampaignVersionsError,
                crate::input::GetCampaignVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannels`.
    ///
    /// <p>Retrieves information about the history and status of each channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channels_input::Builder,
    }
    impl<C, M, R> GetChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelsInputOperationOutputAlias,
                crate::output::GetChannelsOutput,
                crate::error::GetChannelsError,
                crate::input::GetChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the email channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEmailChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_channel_input::Builder,
    }
    impl<C, M, R> GetEmailChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailChannelInputOperationOutputAlias,
                crate::output::GetEmailChannelOutput,
                crate::error::GetEmailChannelError,
                crate::input::GetEmailChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through the email channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_template_input::Builder,
    }
    impl<C, M, R> GetEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailTemplateInputOperationOutputAlias,
                crate::output::GetEmailTemplateOutput,
                crate::error::GetEmailTemplateError,
                crate::input::GetEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEndpoint`.
    ///
    /// <p>Retrieves information about the settings and attributes of a specific endpoint for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_endpoint_input::Builder,
    }
    impl<C, M, R> GetEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEndpointInputOperationOutputAlias,
                crate::output::GetEndpointOutput,
                crate::error::GetEndpointError,
                crate::input::GetEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventStream`.
    ///
    /// <p>Retrieves information about the event stream settings for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEventStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_stream_input::Builder,
    }
    impl<C, M, R> GetEventStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventStreamInputOperationOutputAlias,
                crate::output::GetEventStreamOutput,
                crate::error::GetEventStreamError,
                crate::input::GetEventStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExportJob`.
    ///
    /// <p>Retrieves information about the status and settings of a specific export job for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_job_input::Builder,
    }
    impl<C, M, R> GetExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportJobInputOperationOutputAlias,
                crate::output::GetExportJobOutput,
                crate::error::GetExportJobError,
                crate::input::GetExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of all the export jobs for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_jobs_input::Builder,
    }
    impl<C, M, R> GetExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportJobsInputOperationOutputAlias,
                crate::output::GetExportJobsOutput,
                crate::error::GetExportJobsError,
                crate::input::GetExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGcmChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the GCM channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGcmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gcm_channel_input::Builder,
    }
    impl<C, M, R> GetGcmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGcmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGcmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGcmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGcmChannelInputOperationOutputAlias,
                crate::output::GetGcmChannelOutput,
                crate::error::GetGcmChannelError,
                crate::input::GetGcmChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportJob`.
    ///
    /// <p>Retrieves information about the status and settings of a specific import job for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_job_input::Builder,
    }
    impl<C, M, R> GetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportJobInputOperationOutputAlias,
                crate::output::GetImportJobOutput,
                crate::error::GetImportJobError,
                crate::input::GetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of all the import jobs for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_jobs_input::Builder,
    }
    impl<C, M, R> GetImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportJobsInputOperationOutputAlias,
                crate::output::GetImportJobsOutput,
                crate::error::GetImportJobsError,
                crate::input::GetImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInAppMessages`.
    ///
    /// <p>Retrieves the in-app messages targeted for the provided endpoint ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInAppMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_in_app_messages_input::Builder,
    }
    impl<C, M, R> GetInAppMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInAppMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInAppMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInAppMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInAppMessagesInputOperationOutputAlias,
                crate::output::GetInAppMessagesOutput,
                crate::error::GetInAppMessagesError,
                crate::input::GetInAppMessagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInAppTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages sent through the in-app channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_in_app_template_input::Builder,
    }
    impl<C, M, R> GetInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInAppTemplateInputOperationOutputAlias,
                crate::output::GetInAppTemplateOutput,
                crate::error::GetInAppTemplateError,
                crate::input::GetInAppTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourney`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for a journey.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_input::Builder,
    }
    impl<C, M, R> GetJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyInputOperationOutputAlias,
                crate::output::GetJourneyOutput,
                crate::error::GetJourneyError,
                crate::input::GetJourneyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourneyDateRangeKpi`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJourneyDateRangeKpi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_date_range_kpi_input::Builder,
    }
    impl<C, M, R> GetJourneyDateRangeKpi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourneyDateRangeKpi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyDateRangeKpiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJourneyDateRangeKpiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyDateRangeKpiInputOperationOutputAlias,
                crate::output::GetJourneyDateRangeKpiOutput,
                crate::error::GetJourneyDateRangeKpiError,
                crate::input::GetJourneyDateRangeKpiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn kpi_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kpi_name(inp);
            self
        }
        /// <p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>
        pub fn set_kpi_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kpi_name(input);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourneyExecutionActivityMetrics`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJourneyExecutionActivityMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_execution_activity_metrics_input::Builder,
    }
    impl<C, M, R> GetJourneyExecutionActivityMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourneyExecutionActivityMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyExecutionActivityMetricsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetJourneyExecutionActivityMetricsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyExecutionActivityMetricsInputOperationOutputAlias,
                crate::output::GetJourneyExecutionActivityMetricsOutput,
                crate::error::GetJourneyExecutionActivityMetricsError,
                crate::input::GetJourneyExecutionActivityMetricsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey activity.</p>
        pub fn journey_activity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_activity_id(inp);
            self
        }
        /// <p>The unique identifier for the journey activity.</p>
        pub fn set_journey_activity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_journey_activity_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJourneyExecutionMetrics`.
    ///
    /// <p>Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJourneyExecutionMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_journey_execution_metrics_input::Builder,
    }
    impl<C, M, R> GetJourneyExecutionMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJourneyExecutionMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJourneyExecutionMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJourneyExecutionMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJourneyExecutionMetricsInputOperationOutputAlias,
                crate::output::GetJourneyExecutionMetricsOutput,
                crate::error::GetJourneyExecutionMetricsError,
                crate::input::GetJourneyExecutionMetricsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPushTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through a push notification channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_push_template_input::Builder,
    }
    impl<C, M, R> GetPushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPushTemplateInputOperationOutputAlias,
                crate::output::GetPushTemplateOutput,
                crate::error::GetPushTemplateError,
                crate::input::GetPushTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecommenderConfiguration`.
    ///
    /// <p>Retrieves information about an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recommender_configuration_input::Builder,
    }
    impl<C, M, R> GetRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecommenderConfigurationInputOperationOutputAlias,
                crate::output::GetRecommenderConfigurationOutput,
                crate::error::GetRecommenderConfigurationError,
                crate::input::GetRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_id(inp);
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecommenderConfigurations`.
    ///
    /// <p>Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRecommenderConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recommender_configurations_input::Builder,
    }
    impl<C, M, R> GetRecommenderConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecommenderConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommenderConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommenderConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecommenderConfigurationsInputOperationOutputAlias,
                crate::output::GetRecommenderConfigurationsOutput,
                crate::error::GetRecommenderConfigurationsError,
                crate::input::GetRecommenderConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegment`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_input::Builder,
    }
    impl<C, M, R> GetSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentInputOperationOutputAlias,
                crate::output::GetSegmentOutput,
                crate::error::GetSegmentError,
                crate::input::GetSegmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentExportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of the export jobs for a segment.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegmentExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_export_jobs_input::Builder,
    }
    impl<C, M, R> GetSegmentExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentExportJobsInputOperationOutputAlias,
                crate::output::GetSegmentExportJobsOutput,
                crate::error::GetSegmentExportJobsError,
                crate::input::GetSegmentExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentImportJobs`.
    ///
    /// <p>Retrieves information about the status and settings of the import jobs for a segment.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegmentImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_import_jobs_input::Builder,
    }
    impl<C, M, R> GetSegmentImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentImportJobsInputOperationOutputAlias,
                crate::output::GetSegmentImportJobsOutput,
                crate::error::GetSegmentImportJobsError,
                crate::input::GetSegmentImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegments`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segments_input::Builder,
    }
    impl<C, M, R> GetSegments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentsInputOperationOutputAlias,
                crate::output::GetSegmentsOutput,
                crate::error::GetSegmentsError,
                crate::input::GetSegmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentVersion`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegmentVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_version_input::Builder,
    }
    impl<C, M, R> GetSegmentVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentVersionInputOperationOutputAlias,
                crate::output::GetSegmentVersionOutput,
                crate::error::GetSegmentVersionError,
                crate::input::GetSegmentVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique version number (Version property) for the campaign version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentVersions`.
    ///
    /// <p>Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegmentVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_versions_input::Builder,
    }
    impl<C, M, R> GetSegmentVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentVersionsInputOperationOutputAlias,
                crate::output::GetSegmentVersionsOutput,
                crate::error::GetSegmentVersionsError,
                crate::input::GetSegmentVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSmsChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the SMS channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSmsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sms_channel_input::Builder,
    }
    impl<C, M, R> GetSmsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSmsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSmsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSmsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSmsChannelInputOperationOutputAlias,
                crate::output::GetSmsChannelOutput,
                crate::error::GetSmsChannelError,
                crate::input::GetSmsChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSmsTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through the SMS channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sms_template_input::Builder,
    }
    impl<C, M, R> GetSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSmsTemplateInputOperationOutputAlias,
                crate::output::GetSmsTemplateOutput,
                crate::error::GetSmsTemplateError,
                crate::input::GetSmsTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserEndpoints`.
    ///
    /// <p>Retrieves information about all the endpoints that are associated with a specific user ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUserEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_endpoints_input::Builder,
    }
    impl<C, M, R> GetUserEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserEndpointsInputOperationOutputAlias,
                crate::output::GetUserEndpointsOutput,
                crate::error::GetUserEndpointsError,
                crate::input::GetUserEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The unique identifier for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceChannel`.
    ///
    /// <p>Retrieves information about the status and settings of the voice channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_channel_input::Builder,
    }
    impl<C, M, R> GetVoiceChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceChannelInputOperationOutputAlias,
                crate::output::GetVoiceChannelOutput,
                crate::error::GetVoiceChannelError,
                crate::input::GetVoiceChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceTemplate`.
    ///
    /// <p>Retrieves the content and settings of a message template for messages that are sent through the voice channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_template_input::Builder,
    }
    impl<C, M, R> GetVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceTemplateInputOperationOutputAlias,
                crate::output::GetVoiceTemplateOutput,
                crate::error::GetVoiceTemplateError,
                crate::input::GetVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJourneys`.
    ///
    /// <p>Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJourneys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journeys_input::Builder,
    }
    impl<C, M, R> ListJourneys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJourneys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJourneysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJourneysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJourneysInputOperationOutputAlias,
                crate::output::ListJourneysOutput,
                crate::error::ListJourneysError,
                crate::input::ListJourneysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The NextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplates`.
    ///
    /// <p>Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_templates_input::Builder,
    }
    impl<C, M, R> ListTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplatesInputOperationOutputAlias,
                crate::output::ListTemplatesOutput,
                crate::error::ListTemplatesError,
                crate::input::ListTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
        pub fn prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(inp);
            self
        }
        /// <p>The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
        pub fn template_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplateVersions`.
    ///
    /// <p>Retrieves information about all the versions of a specific message template.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_template_versions_input::Builder,
    }
    impl<C, M, R> ListTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplateVersionsInputOperationOutputAlias,
                crate::output::ListTemplateVersionsOutput,
                crate::error::ListTemplateVersionsError,
                crate::input::ListTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn page_size(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics.</p>
        pub fn set_page_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn template_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PhoneNumberValidate`.
    ///
    /// <p>Retrieves information about a phone number.</p>
    #[derive(std::fmt::Debug)]
    pub struct PhoneNumberValidate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::phone_number_validate_input::Builder,
    }
    impl<C, M, R> PhoneNumberValidate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PhoneNumberValidate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PhoneNumberValidateOutput,
            aws_smithy_http::result::SdkError<crate::error::PhoneNumberValidateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PhoneNumberValidateInputOperationOutputAlias,
                crate::output::PhoneNumberValidateOutput,
                crate::error::PhoneNumberValidateError,
                crate::input::PhoneNumberValidateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies a phone number to validate and retrieve information about.</p>
        pub fn number_validate_request(mut self, inp: crate::model::NumberValidateRequest) -> Self {
            self.inner = self.inner.number_validate_request(inp);
            self
        }
        /// <p>Specifies a phone number to validate and retrieve information about.</p>
        pub fn set_number_validate_request(
            mut self,
            input: std::option::Option<crate::model::NumberValidateRequest>,
        ) -> Self {
            self.inner = self.inner.set_number_validate_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEvents`.
    ///
    /// <p>Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_events_input::Builder,
    }
    impl<C, M, R> PutEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventsInputOperationOutputAlias,
                crate::output::PutEventsOutput,
                crate::error::PutEventsError,
                crate::input::PutEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies a batch of events to process.</p>
        pub fn events_request(mut self, inp: crate::model::EventsRequest) -> Self {
            self.inner = self.inner.events_request(inp);
            self
        }
        /// <p>Specifies a batch of events to process.</p>
        pub fn set_events_request(
            mut self,
            input: std::option::Option<crate::model::EventsRequest>,
        ) -> Self {
            self.inner = self.inner.set_events_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventStream`.
    ///
    /// <p>Creates a new event stream for an application or updates the settings of an existing event stream for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEventStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_event_stream_input::Builder,
    }
    impl<C, M, R> PutEventStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEventStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventStreamInputOperationOutputAlias,
                crate::output::PutEventStreamOutput,
                crate::error::PutEventStreamError,
                crate::input::PutEventStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
        pub fn write_event_stream(mut self, inp: crate::model::WriteEventStream) -> Self {
            self.inner = self.inner.write_event_stream(inp);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>
        pub fn set_write_event_stream(
            mut self,
            input: std::option::Option<crate::model::WriteEventStream>,
        ) -> Self {
            self.inner = self.inner.set_write_event_stream(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAttributes`.
    ///
    /// <p>Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_attributes_input::Builder,
    }
    impl<C, M, R> RemoveAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveAttributesInputOperationOutputAlias,
                crate::output::RemoveAttributesOutput,
                crate::error::RemoveAttributesError,
                crate::input::RemoveAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The type of attribute or attributes to remove. Valid values are:</p> <ul><li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li> <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li> <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li></ul>
        pub fn attribute_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_type(inp);
            self
        }
        /// <p>The type of attribute or attributes to remove. Valid values are:</p> <ul><li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li> <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li> <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li></ul>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_type(input);
            self
        }
        /// <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
        pub fn update_attributes_request(
            mut self,
            inp: crate::model::UpdateAttributesRequest,
        ) -> Self {
            self.inner = self.inner.update_attributes_request(inp);
            self
        }
        /// <p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>
        pub fn set_update_attributes_request(
            mut self,
            input: std::option::Option<crate::model::UpdateAttributesRequest>,
        ) -> Self {
            self.inner = self.inner.set_update_attributes_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendMessages`.
    ///
    /// <p>Creates and sends a direct message.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_messages_input::Builder,
    }
    impl<C, M, R> SendMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::SendMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendMessagesInputOperationOutputAlias,
                crate::output::SendMessagesOutput,
                crate::error::SendMessagesError,
                crate::input::SendMessagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message.</p>
        pub fn message_request(mut self, inp: crate::model::MessageRequest) -> Self {
            self.inner = self.inner.message_request(inp);
            self
        }
        /// <p>Specifies the configuration and other settings for a message.</p>
        pub fn set_message_request(
            mut self,
            input: std::option::Option<crate::model::MessageRequest>,
        ) -> Self {
            self.inner = self.inner.set_message_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendUsersMessages`.
    ///
    /// <p>Creates and sends a message to a list of users.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendUsersMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_users_messages_input::Builder,
    }
    impl<C, M, R> SendUsersMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendUsersMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendUsersMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::SendUsersMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendUsersMessagesInputOperationOutputAlias,
                crate::output::SendUsersMessagesOutput,
                crate::error::SendUsersMessagesError,
                crate::input::SendUsersMessagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
        pub fn send_users_message_request(
            mut self,
            inp: crate::model::SendUsersMessageRequest,
        ) -> Self {
            self.inner = self.inner.send_users_message_request(inp);
            self
        }
        /// <p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>
        pub fn set_send_users_message_request(
            mut self,
            input: std::option::Option<crate::model::SendUsersMessageRequest>,
        ) -> Self {
            self.inner = self.inner.set_send_users_message_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags (keys and values) to an application, campaign, message template, or segment.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
        pub fn tags_model(mut self, inp: crate::model::TagsModel) -> Self {
            self.inner = self.inner.tags_model(inp);
            self
        }
        /// <p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>
        pub fn set_tags_model(
            mut self,
            input: std::option::Option<crate::model::TagsModel>,
        ) -> Self {
            self.inner = self.inner.set_tags_model(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags (keys and values) from an application, campaign, message template, or segment.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAdmChannel`.
    ///
    /// <p>Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAdmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_adm_channel_input::Builder,
    }
    impl<C, M, R> UpdateAdmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAdmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAdmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAdmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAdmChannelInputOperationOutputAlias,
                crate::output::UpdateAdmChannelOutput,
                crate::error::UpdateAdmChannelError,
                crate::input::UpdateAdmChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
        pub fn adm_channel_request(mut self, inp: crate::model::AdmChannelRequest) -> Self {
            self.inner = self.inner.adm_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>
        pub fn set_adm_channel_request(
            mut self,
            input: std::option::Option<crate::model::AdmChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_adm_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsChannel`.
    ///
    /// <p>Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApnsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsChannelInputOperationOutputAlias,
                crate::output::UpdateApnsChannelOutput,
                crate::error::UpdateApnsChannelError,
                crate::input::UpdateApnsChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
        pub fn apns_channel_request(mut self, inp: crate::model::ApnsChannelRequest) -> Self {
            self.inner = self.inner.apns_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>
        pub fn set_apns_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsSandboxChannel`.
    ///
    /// <p>Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApnsSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_sandbox_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsSandboxChannelInputOperationOutputAlias,
                crate::output::UpdateApnsSandboxChannelOutput,
                crate::error::UpdateApnsSandboxChannelError,
                crate::input::UpdateApnsSandboxChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
        pub fn apns_sandbox_channel_request(
            mut self,
            inp: crate::model::ApnsSandboxChannelRequest,
        ) -> Self {
            self.inner = self.inner.apns_sandbox_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>
        pub fn set_apns_sandbox_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsSandboxChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_sandbox_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsVoipChannel`.
    ///
    /// <p>Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApnsVoipChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_voip_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsVoipChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsVoipChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsVoipChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsVoipChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsVoipChannelInputOperationOutputAlias,
                crate::output::UpdateApnsVoipChannelOutput,
                crate::error::UpdateApnsVoipChannelError,
                crate::input::UpdateApnsVoipChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
        pub fn apns_voip_channel_request(
            mut self,
            inp: crate::model::ApnsVoipChannelRequest,
        ) -> Self {
            self.inner = self.inner.apns_voip_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>
        pub fn set_apns_voip_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsVoipChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_voip_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApnsVoipSandboxChannel`.
    ///
    /// <p>Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApnsVoipSandboxChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_apns_voip_sandbox_channel_input::Builder,
    }
    impl<C, M, R> UpdateApnsVoipSandboxChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApnsVoipSandboxChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApnsVoipSandboxChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApnsVoipSandboxChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApnsVoipSandboxChannelInputOperationOutputAlias,
                crate::output::UpdateApnsVoipSandboxChannelOutput,
                crate::error::UpdateApnsVoipSandboxChannelError,
                crate::input::UpdateApnsVoipSandboxChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
        pub fn apns_voip_sandbox_channel_request(
            mut self,
            inp: crate::model::ApnsVoipSandboxChannelRequest,
        ) -> Self {
            self.inner = self.inner.apns_voip_sandbox_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>
        pub fn set_apns_voip_sandbox_channel_request(
            mut self,
            input: std::option::Option<crate::model::ApnsVoipSandboxChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_apns_voip_sandbox_channel_request(input);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationSettings`.
    ///
    /// <p>Updates the settings for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplicationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_settings_input::Builder,
    }
    impl<C, M, R> UpdateApplicationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplicationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationSettingsInputOperationOutputAlias,
                crate::output::UpdateApplicationSettingsOutput,
                crate::error::UpdateApplicationSettingsError,
                crate::input::UpdateApplicationSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the default settings for an application.</p>
        pub fn write_application_settings_request(
            mut self,
            inp: crate::model::WriteApplicationSettingsRequest,
        ) -> Self {
            self.inner = self.inner.write_application_settings_request(inp);
            self
        }
        /// <p>Specifies the default settings for an application.</p>
        pub fn set_write_application_settings_request(
            mut self,
            input: std::option::Option<crate::model::WriteApplicationSettingsRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_application_settings_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBaiduChannel`.
    ///
    /// <p>Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBaiduChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_baidu_channel_input::Builder,
    }
    impl<C, M, R> UpdateBaiduChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBaiduChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBaiduChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBaiduChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBaiduChannelInputOperationOutputAlias,
                crate::output::UpdateBaiduChannelOutput,
                crate::error::UpdateBaiduChannelError,
                crate::input::UpdateBaiduChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
        pub fn baidu_channel_request(mut self, inp: crate::model::BaiduChannelRequest) -> Self {
            self.inner = self.inner.baidu_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>
        pub fn set_baidu_channel_request(
            mut self,
            input: std::option::Option<crate::model::BaiduChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_baidu_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCampaign`.
    ///
    /// <p>Updates the configuration and other settings for a campaign.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_campaign_input::Builder,
    }
    impl<C, M, R> UpdateCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCampaignInputOperationOutputAlias,
                crate::output::UpdateCampaignOutput,
                crate::error::UpdateCampaignError,
                crate::input::UpdateCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn write_campaign_request(mut self, inp: crate::model::WriteCampaignRequest) -> Self {
            self.inner = self.inner.write_campaign_request(inp);
            self
        }
        /// <p>Specifies the configuration and other settings for a campaign.</p>
        pub fn set_write_campaign_request(
            mut self,
            input: std::option::Option<crate::model::WriteCampaignRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_campaign_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailChannel`.
    ///
    /// <p>Enables the email channel for an application or updates the status and settings of the email channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEmailChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_email_channel_input::Builder,
    }
    impl<C, M, R> UpdateEmailChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmailChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmailChannelInputOperationOutputAlias,
                crate::output::UpdateEmailChannelOutput,
                crate::error::UpdateEmailChannelError,
                crate::input::UpdateEmailChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the email channel for an application.</p>
        pub fn email_channel_request(mut self, inp: crate::model::EmailChannelRequest) -> Self {
            self.inner = self.inner.email_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the email channel for an application.</p>
        pub fn set_email_channel_request(
            mut self,
            input: std::option::Option<crate::model::EmailChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_email_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through the email channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_email_template_input::Builder,
    }
    impl<C, M, R> UpdateEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmailTemplateInputOperationOutputAlias,
                crate::output::UpdateEmailTemplateOutput,
                crate::error::UpdateEmailTemplateError,
                crate::input::UpdateEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_new_version(inp);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn email_template_request(mut self, inp: crate::model::EmailTemplateRequest) -> Self {
            self.inner = self.inner.email_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>
        pub fn set_email_template_request(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_email_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpoint`.
    ///
    /// <p>Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEndpointInputOperationOutputAlias,
                crate::output::UpdateEndpointOutput,
                crate::error::UpdateEndpointError,
                crate::input::UpdateEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The unique identifier for the endpoint.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// <p>Specifies the channel type and other settings for an endpoint.</p>
        pub fn endpoint_request(mut self, inp: crate::model::EndpointRequest) -> Self {
            self.inner = self.inner.endpoint_request(inp);
            self
        }
        /// <p>Specifies the channel type and other settings for an endpoint.</p>
        pub fn set_endpoint_request(
            mut self,
            input: std::option::Option<crate::model::EndpointRequest>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpointsBatch`.
    ///
    /// <p>Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEndpointsBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_endpoints_batch_input::Builder,
    }
    impl<C, M, R> UpdateEndpointsBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEndpointsBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointsBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointsBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEndpointsBatchInputOperationOutputAlias,
                crate::output::UpdateEndpointsBatchOutput,
                crate::error::UpdateEndpointsBatchError,
                crate::input::UpdateEndpointsBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
        pub fn endpoint_batch_request(mut self, inp: crate::model::EndpointBatchRequest) -> Self {
            self.inner = self.inner.endpoint_batch_request(inp);
            self
        }
        /// <p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>
        pub fn set_endpoint_batch_request(
            mut self,
            input: std::option::Option<crate::model::EndpointBatchRequest>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_batch_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGcmChannel`.
    ///
    /// <p>Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGcmChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gcm_channel_input::Builder,
    }
    impl<C, M, R> UpdateGcmChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGcmChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGcmChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGcmChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGcmChannelInputOperationOutputAlias,
                crate::output::UpdateGcmChannelOutput,
                crate::error::UpdateGcmChannelError,
                crate::input::UpdateGcmChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
        pub fn gcm_channel_request(mut self, inp: crate::model::GcmChannelRequest) -> Self {
            self.inner = self.inner.gcm_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>
        pub fn set_gcm_channel_request(
            mut self,
            input: std::option::Option<crate::model::GcmChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_gcm_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInAppTemplate`.
    ///
    /// <p>Updates an existing message template for messages sent through the in-app message channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInAppTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_in_app_template_input::Builder,
    }
    impl<C, M, R> UpdateInAppTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInAppTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInAppTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInAppTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInAppTemplateInputOperationOutputAlias,
                crate::output::UpdateInAppTemplateOutput,
                crate::error::UpdateInAppTemplateError,
                crate::input::UpdateInAppTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_new_version(inp);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn in_app_template_request(mut self, inp: crate::model::InAppTemplateRequest) -> Self {
            self.inner = self.inner.in_app_template_request(inp);
            self
        }
        /// <p>InApp Template Request.</p>
        pub fn set_in_app_template_request(
            mut self,
            input: std::option::Option<crate::model::InAppTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_in_app_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJourney`.
    ///
    /// <p>Updates the configuration and other settings for a journey.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateJourney<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_journey_input::Builder,
    }
    impl<C, M, R> UpdateJourney<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJourney`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJourneyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJourneyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJourneyInputOperationOutputAlias,
                crate::output::UpdateJourneyOutput,
                crate::error::UpdateJourneyError,
                crate::input::UpdateJourneyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn write_journey_request(mut self, inp: crate::model::WriteJourneyRequest) -> Self {
            self.inner = self.inner.write_journey_request(inp);
            self
        }
        /// <p>Specifies the configuration and other settings for a journey.</p>
        pub fn set_write_journey_request(
            mut self,
            input: std::option::Option<crate::model::WriteJourneyRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_journey_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJourneyState`.
    ///
    /// <p>Cancels (stops) an active journey.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateJourneyState<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_journey_state_input::Builder,
    }
    impl<C, M, R> UpdateJourneyState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJourneyState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJourneyStateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJourneyStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJourneyStateInputOperationOutputAlias,
                crate::output::UpdateJourneyStateOutput,
                crate::error::UpdateJourneyStateError,
                crate::input::UpdateJourneyStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn journey_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.journey_id(inp);
            self
        }
        /// <p>The unique identifier for the journey.</p>
        pub fn set_journey_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_journey_id(input);
            self
        }
        /// <p>Changes the status of a journey.</p>
        pub fn journey_state_request(mut self, inp: crate::model::JourneyStateRequest) -> Self {
            self.inner = self.inner.journey_state_request(inp);
            self
        }
        /// <p>Changes the status of a journey.</p>
        pub fn set_journey_state_request(
            mut self,
            input: std::option::Option<crate::model::JourneyStateRequest>,
        ) -> Self {
            self.inner = self.inner.set_journey_state_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePushTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through a push notification channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePushTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_push_template_input::Builder,
    }
    impl<C, M, R> UpdatePushTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePushTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePushTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePushTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePushTemplateInputOperationOutputAlias,
                crate::output::UpdatePushTemplateOutput,
                crate::error::UpdatePushTemplateError,
                crate::input::UpdatePushTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_new_version(inp);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn push_notification_template_request(
            mut self,
            inp: crate::model::PushNotificationTemplateRequest,
        ) -> Self {
            self.inner = self.inner.push_notification_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>
        pub fn set_push_notification_template_request(
            mut self,
            input: std::option::Option<crate::model::PushNotificationTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_push_notification_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecommenderConfiguration`.
    ///
    /// <p>Updates an Amazon Pinpoint configuration for a recommender model.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecommenderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recommender_configuration_input::Builder,
    }
    impl<C, M, R> UpdateRecommenderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecommenderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecommenderConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecommenderConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecommenderConfigurationInputOperationOutputAlias,
                crate::output::UpdateRecommenderConfigurationOutput,
                crate::error::UpdateRecommenderConfigurationError,
                crate::input::UpdateRecommenderConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn recommender_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_id(inp);
            self
        }
        /// <p>The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_recommender_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_id(input);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn update_recommender_configuration(
            mut self,
            inp: crate::model::UpdateRecommenderConfigurationShape,
        ) -> Self {
            self.inner = self.inner.update_recommender_configuration(inp);
            self
        }
        /// <p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>
        pub fn set_update_recommender_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateRecommenderConfigurationShape>,
        ) -> Self {
            self.inner = self.inner.set_update_recommender_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSegment`.
    ///
    /// <p>Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSegment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_segment_input::Builder,
    }
    impl<C, M, R> UpdateSegment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSegment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSegmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSegmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSegmentInputOperationOutputAlias,
                crate::output::UpdateSegmentOutput,
                crate::error::UpdateSegmentError,
                crate::input::UpdateSegmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn segment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.segment_id(inp);
            self
        }
        /// <p>The unique identifier for the segment.</p>
        pub fn set_segment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_segment_id(input);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn write_segment_request(mut self, inp: crate::model::WriteSegmentRequest) -> Self {
            self.inner = self.inner.write_segment_request(inp);
            self
        }
        /// <p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>
        pub fn set_write_segment_request(
            mut self,
            input: std::option::Option<crate::model::WriteSegmentRequest>,
        ) -> Self {
            self.inner = self.inner.set_write_segment_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSmsChannel`.
    ///
    /// <p>Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSmsChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sms_channel_input::Builder,
    }
    impl<C, M, R> UpdateSmsChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSmsChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmsChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSmsChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmsChannelInputOperationOutputAlias,
                crate::output::UpdateSmsChannelOutput,
                crate::error::UpdateSmsChannelError,
                crate::input::UpdateSmsChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the SMS channel for an application.</p>
        pub fn sms_channel_request(mut self, inp: crate::model::SmsChannelRequest) -> Self {
            self.inner = self.inner.sms_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the SMS channel for an application.</p>
        pub fn set_sms_channel_request(
            mut self,
            input: std::option::Option<crate::model::SmsChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_sms_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSmsTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through the SMS channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSmsTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sms_template_input::Builder,
    }
    impl<C, M, R> UpdateSmsTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSmsTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSmsTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSmsTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSmsTemplateInputOperationOutputAlias,
                crate::output::UpdateSmsTemplateOutput,
                crate::error::UpdateSmsTemplateError,
                crate::input::UpdateSmsTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_new_version(inp);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn sms_template_request(mut self, inp: crate::model::SmsTemplateRequest) -> Self {
            self.inner = self.inner.sms_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>
        pub fn set_sms_template_request(
            mut self,
            input: std::option::Option<crate::model::SmsTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_sms_template_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplateActiveVersion`.
    ///
    /// <p>Changes the status of a specific version of a message template to <i>active</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTemplateActiveVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_active_version_input::Builder,
    }
    impl<C, M, R> UpdateTemplateActiveVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplateActiveVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateActiveVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateActiveVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateActiveVersionInputOperationOutputAlias,
                crate::output::UpdateTemplateActiveVersionOutput,
                crate::error::UpdateTemplateActiveVersionError,
                crate::input::UpdateTemplateActiveVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which version of a message template to use as the active version of the template.</p>
        pub fn template_active_version_request(
            mut self,
            inp: crate::model::TemplateActiveVersionRequest,
        ) -> Self {
            self.inner = self.inner.template_active_version_request(inp);
            self
        }
        /// <p>Specifies which version of a message template to use as the active version of the template.</p>
        pub fn set_template_active_version_request(
            mut self,
            input: std::option::Option<crate::model::TemplateActiveVersionRequest>,
        ) -> Self {
            self.inner = self.inner.set_template_active_version_request(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn template_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVoiceChannel`.
    ///
    /// <p>Enables the voice channel for an application or updates the status and settings of the voice channel for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVoiceChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_voice_channel_input::Builder,
    }
    impl<C, M, R> UpdateVoiceChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVoiceChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVoiceChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVoiceChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVoiceChannelInputOperationOutputAlias,
                crate::output::UpdateVoiceChannelOutput,
                crate::error::UpdateVoiceChannelError,
                crate::input::UpdateVoiceChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Specifies the status and settings of the voice channel for an application.</p>
        pub fn voice_channel_request(mut self, inp: crate::model::VoiceChannelRequest) -> Self {
            self.inner = self.inner.voice_channel_request(inp);
            self
        }
        /// <p>Specifies the status and settings of the voice channel for an application.</p>
        pub fn set_voice_channel_request(
            mut self,
            input: std::option::Option<crate::model::VoiceChannelRequest>,
        ) -> Self {
            self.inner = self.inner.set_voice_channel_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVoiceTemplate`.
    ///
    /// <p>Updates an existing message template for messages that are sent through the voice channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVoiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_voice_template_input::Builder,
    }
    impl<C, M, R> UpdateVoiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVoiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVoiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVoiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVoiceTemplateInputOperationOutputAlias,
                crate::output::UpdateVoiceTemplateOutput,
                crate::error::UpdateVoiceTemplateError,
                crate::input::UpdateVoiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn create_new_version(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_new_version(inp);
            self
        }
        /// <p>Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur.</p>
        pub fn set_create_new_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_new_version(input);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the <link  linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur.</p> <p>If you don't specify a value for this parameter, Amazon Pinpoint does the following:</p> <ul><li><p>For a get operation, retrieves information about the active version of the template.</p></li> <li><p>For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false.</p></li> <li><p>For a delete operation, deletes the template, including all versions of the template.</p></li></ul>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn voice_template_request(mut self, inp: crate::model::VoiceTemplateRequest) -> Self {
            self.inner = self.inner.voice_template_request(inp);
            self
        }
        /// <p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>
        pub fn set_voice_template_request(
            mut self,
            input: std::option::Option<crate::model::VoiceTemplateRequest>,
        ) -> Self {
            self.inner = self.inner.set_voice_template_request(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
