// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DescribeDimensionKeysInput`](crate::input::DescribeDimensionKeysInput)
pub mod describe_dimension_keys_input {
    /// A builder for [`DescribeDimensionKeysInput`](crate::input::DescribeDimensionKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_type: std::option::Option<crate::model::ServiceType>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) period_in_seconds: std::option::Option<i32>,
        pub(crate) group_by: std::option::Option<crate::model::DimensionGroup>,
        pub(crate) partition_by: std::option::Option<crate::model::DimensionGroup>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
        /// <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code> </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
        /// <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code> </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You must specify a <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data points equal to or greater than <code>StartTime</code> are returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You must specify a <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data points equal to or greater than <code>StartTime</code> are returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>1</code> (one second)</p> </li>
        /// <li> <p> <code>60</code> (one minute)</p> </li>
        /// <li> <p> <code>300</code> (five minutes)</p> </li>
        /// <li> <p> <code>3600</code> (one hour)</p> </li>
        /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
        pub fn period_in_seconds(mut self, input: i32) -> Self {
            self.period_in_seconds = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>1</code> (one second)</p> </li>
        /// <li> <p> <code>60</code> (one minute)</p> </li>
        /// <li> <p> <code>300</code> (five minutes)</p> </li>
        /// <li> <p> <code>3600</code> (one hour)</p> </li>
        /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
        pub fn set_period_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.period_in_seconds = input;
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn group_by(mut self, input: crate::model::DimensionGroup) -> Self {
            self.group_by = Some(input);
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<crate::model::DimensionGroup>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// <p>For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>
        pub fn partition_by(mut self, input: crate::model::DimensionGroup) -> Self {
            self.partition_by = Some(input);
            self
        }
        /// <p>For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>
        pub fn set_partition_by(
            mut self,
            input: std::option::Option<crate::model::DimensionGroup>,
        ) -> Self {
            self.partition_by = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>One or more filters to apply in the request. Restrictions:</p>
        /// <ul>
        /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code> parameters.</p> </li>
        /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
        /// </ul>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.filter = Some(hash_map);
            self
        }
        /// <p>One or more filters to apply in the request. Restrictions:</p>
        /// <ul>
        /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code> parameters.</p> </li>
        /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
        /// </ul>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDimensionKeysInput`](crate::input::DescribeDimensionKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDimensionKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDimensionKeysInput {
                service_type: self.service_type,
                identifier: self.identifier,
                start_time: self.start_time,
                end_time: self.end_time,
                metric: self.metric,
                period_in_seconds: self.period_in_seconds,
                group_by: self.group_by,
                partition_by: self.partition_by,
                filter: self.filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDimensionKeysInputOperationOutputAlias = crate::operation::DescribeDimensionKeys;
#[doc(hidden)]
pub type DescribeDimensionKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDimensionKeysInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDimensionKeys`](crate::operation::DescribeDimensionKeys)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDimensionKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDimensionKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDimensionKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDimensionKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PerformanceInsightsv20180227.DescribeDimensionKeys",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_dimension_keys(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDimensionKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDimensionKeys",
            "pi",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDimensionKeysInput`](crate::input::DescribeDimensionKeysInput)
    pub fn builder() -> crate::input::describe_dimension_keys_input::Builder {
        crate::input::describe_dimension_keys_input::Builder::default()
    }
}

/// See [`GetDimensionKeyDetailsInput`](crate::input::GetDimensionKeyDetailsInput)
pub mod get_dimension_key_details_input {
    /// A builder for [`GetDimensionKeyDetailsInput`](crate::input::GetDimensionKeyDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_type: std::option::Option<crate::model::ServiceType>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) group_identifier: std::option::Option<std::string::String>,
        pub(crate) requested_dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// <p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the specified group for the dimension group ID.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the specified group for the dimension group ID.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>, the group ID is <code>db.sql.id</code>.</p>
        pub fn group_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>, the group ID is <code>db.sql.id</code>.</p>
        pub fn set_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_identifier = input;
            self
        }
        /// Appends an item to `requested_dimensions`.
        ///
        /// To override the contents of this collection use [`set_requested_dimensions`](Self::set_requested_dimensions).
        ///
        /// <p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group.</p>
        pub fn requested_dimensions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.requested_dimensions.unwrap_or_default();
            v.push(input.into());
            self.requested_dimensions = Some(v);
            self
        }
        /// <p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group.</p>
        pub fn set_requested_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.requested_dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDimensionKeyDetailsInput`](crate::input::GetDimensionKeyDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDimensionKeyDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDimensionKeyDetailsInput {
                service_type: self.service_type,
                identifier: self.identifier,
                group: self.group,
                group_identifier: self.group_identifier,
                requested_dimensions: self.requested_dimensions,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDimensionKeyDetailsInputOperationOutputAlias = crate::operation::GetDimensionKeyDetails;
#[doc(hidden)]
pub type GetDimensionKeyDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDimensionKeyDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetDimensionKeyDetails`](crate::operation::GetDimensionKeyDetails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDimensionKeyDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDimensionKeyDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDimensionKeyDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDimensionKeyDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PerformanceInsightsv20180227.GetDimensionKeyDetails",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_dimension_key_details(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDimensionKeyDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDimensionKeyDetails",
            "pi",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDimensionKeyDetailsInput`](crate::input::GetDimensionKeyDetailsInput)
    pub fn builder() -> crate::input::get_dimension_key_details_input::Builder {
        crate::input::get_dimension_key_details_input::Builder::default()
    }
}

/// See [`GetResourceMetricsInput`](crate::input::GetResourceMetricsInput)
pub mod get_resource_metrics_input {
    /// A builder for [`GetResourceMetricsInput`](crate::input::GetResourceMetricsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_type: std::option::Option<crate::model::ServiceType>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) metric_queries: std::option::Option<std::vec::Vec<crate::model::MetricQuery>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) period_in_seconds: std::option::Option<i32>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
        /// <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
        /// <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Appends an item to `metric_queries`.
        ///
        /// To override the contents of this collection use [`set_metric_queries`](Self::set_metric_queries).
        ///
        /// <p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and can optionally specify aggregation and filtering criteria.</p>
        pub fn metric_queries(mut self, input: crate::model::MetricQuery) -> Self {
            let mut v = self.metric_queries.unwrap_or_default();
            v.push(input);
            self.metric_queries = Some(v);
            self
        }
        /// <p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and can optionally specify aggregation and filtering criteria.</p>
        pub fn set_metric_queries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricQuery>>,
        ) -> Self {
            self.metric_queries = input;
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You can't specify a <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data points equal to or greater than <code>StartTime</code> will be returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You can't specify a <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data points equal to or greater than <code>StartTime</code> will be returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>1</code> (one second)</p> </li>
        /// <li> <p> <code>60</code> (one minute)</p> </li>
        /// <li> <p> <code>300</code> (five minutes)</p> </li>
        /// <li> <p> <code>3600</code> (one hour)</p> </li>
        /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
        pub fn period_in_seconds(mut self, input: i32) -> Self {
            self.period_in_seconds = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>1</code> (one second)</p> </li>
        /// <li> <p> <code>60</code> (one minute)</p> </li>
        /// <li> <p> <code>300</code> (five minutes)</p> </li>
        /// <li> <p> <code>3600</code> (one hour)</p> </li>
        /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
        pub fn set_period_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.period_in_seconds = input;
            self
        }
        /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceMetricsInput`](crate::input::GetResourceMetricsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceMetricsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceMetricsInput {
                service_type: self.service_type,
                identifier: self.identifier,
                metric_queries: self.metric_queries,
                start_time: self.start_time,
                end_time: self.end_time,
                period_in_seconds: self.period_in_seconds,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceMetricsInputOperationOutputAlias = crate::operation::GetResourceMetrics;
#[doc(hidden)]
pub type GetResourceMetricsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourceMetricsInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceMetrics`](crate::operation::GetResourceMetrics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceMetrics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceMetricsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceMetricsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceMetricsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PerformanceInsightsv20180227.GetResourceMetrics",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_metrics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceMetrics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceMetrics",
            "pi",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceMetricsInput`](crate::input::GetResourceMetricsInput)
    pub fn builder() -> crate::input::get_resource_metrics_input::Builder {
        crate::input::get_resource_metrics_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceMetricsInput {
    /// <p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
    pub service_type: std::option::Option<crate::model::ServiceType>,
    /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
    /// <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and can optionally specify aggregation and filtering criteria.</p>
    pub metric_queries: std::option::Option<std::vec::Vec<crate::model::MetricQuery>>,
    /// <p>The date and time specifying the beginning of the requested time series data. You can't specify a <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data points equal to or greater than <code>StartTime</code> will be returned.</p>
    /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
    /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>1</code> (one second)</p> </li>
    /// <li> <p> <code>60</code> (one minute)</p> </li>
    /// <li> <p> <code>300</code> (five minutes)</p> </li>
    /// <li> <p> <code>3600</code> (one hour)</p> </li>
    /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
    pub period_in_seconds: std::option::Option<i32>,
    /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceMetricsInput {
    /// <p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.service_type.as_ref()
    }
    /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
    /// <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and can optionally specify aggregation and filtering criteria.</p>
    pub fn metric_queries(&self) -> std::option::Option<&[crate::model::MetricQuery]> {
        self.metric_queries.as_deref()
    }
    /// <p>The date and time specifying the beginning of the requested time series data. You can't specify a <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data points equal to or greater than <code>StartTime</code> will be returned.</p>
    /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
    /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>1</code> (one second)</p> </li>
    /// <li> <p> <code>60</code> (one minute)</p> </li>
    /// <li> <p> <code>300</code> (five minutes)</p> </li>
    /// <li> <p> <code>3600</code> (one hour)</p> </li>
    /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
    pub fn period_in_seconds(&self) -> std::option::Option<i32> {
        self.period_in_seconds
    }
    /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceMetricsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceMetricsInput");
        formatter.field("service_type", &self.service_type);
        formatter.field("identifier", &self.identifier);
        formatter.field("metric_queries", &self.metric_queries);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("period_in_seconds", &self.period_in_seconds);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDimensionKeyDetailsInput {
    /// <p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>
    pub service_type: std::option::Option<crate::model::ServiceType>,
    /// <p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the specified group for the dimension group ID.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>, the group ID is <code>db.sql.id</code>.</p>
    pub group_identifier: std::option::Option<std::string::String>,
    /// <p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group.</p>
    pub requested_dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetDimensionKeyDetailsInput {
    /// <p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.service_type.as_ref()
    }
    /// <p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the specified group for the dimension group ID.</p>
    pub fn group(&self) -> std::option::Option<&str> {
        self.group.as_deref()
    }
    /// <p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>, the group ID is <code>db.sql.id</code>.</p>
    pub fn group_identifier(&self) -> std::option::Option<&str> {
        self.group_identifier.as_deref()
    }
    /// <p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group.</p>
    pub fn requested_dimensions(&self) -> std::option::Option<&[std::string::String]> {
        self.requested_dimensions.as_deref()
    }
}
impl std::fmt::Debug for GetDimensionKeyDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDimensionKeyDetailsInput");
        formatter.field("service_type", &self.service_type);
        formatter.field("identifier", &self.identifier);
        formatter.field("group", &self.group);
        formatter.field("group_identifier", &self.group_identifier);
        formatter.field("requested_dimensions", &self.requested_dimensions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDimensionKeysInput {
    /// <p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
    pub service_type: std::option::Option<crate::model::ServiceType>,
    /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
    /// <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code> </p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The date and time specifying the beginning of the requested time series data. You must specify a <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data points equal to or greater than <code>StartTime</code> are returned.</p>
    /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are returned.</p>
    /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>1</code> (one second)</p> </li>
    /// <li> <p> <code>60</code> (one minute)</p> </li>
    /// <li> <p> <code>300</code> (five minutes)</p> </li>
    /// <li> <p> <code>3600</code> (one hour)</p> </li>
    /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
    pub period_in_seconds: std::option::Option<i32>,
    /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
    pub group_by: std::option::Option<crate::model::DimensionGroup>,
    /// <p>For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>
    pub partition_by: std::option::Option<crate::model::DimensionGroup>,
    /// <p>One or more filters to apply in the request. Restrictions:</p>
    /// <ul>
    /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code> parameters.</p> </li>
    /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
    /// </ul>
    pub filter:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDimensionKeysInput {
    /// <p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.service_type.as_ref()
    }
    /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p>
    /// <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code> </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The date and time specifying the beginning of the requested time series data. You must specify a <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data points equal to or greater than <code>StartTime</code> are returned.</p>
    /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are returned.</p>
    /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>1</code> (one second)</p> </li>
    /// <li> <p> <code>60</code> (one minute)</p> </li>
    /// <li> <p> <code>300</code> (five minutes)</p> </li>
    /// <li> <p> <code>3600</code> (one hour)</p> </li>
    /// <li> <p> <code>86400</code> (twenty-four hours)</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning roughly 100-200 data points in the response.</p>
    pub fn period_in_seconds(&self) -> std::option::Option<i32> {
        self.period_in_seconds
    }
    /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
    pub fn group_by(&self) -> std::option::Option<&crate::model::DimensionGroup> {
        self.group_by.as_ref()
    }
    /// <p>For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>
    pub fn partition_by(&self) -> std::option::Option<&crate::model::DimensionGroup> {
        self.partition_by.as_ref()
    }
    /// <p>One or more filters to apply in the request. Restrictions:</p>
    /// <ul>
    /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code> parameters.</p> </li>
    /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
    /// </ul>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.filter.as_ref()
    }
    /// <p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDimensionKeysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDimensionKeysInput");
        formatter.field("service_type", &self.service_type);
        formatter.field("identifier", &self.identifier);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("metric", &self.metric);
        formatter.field("period_in_seconds", &self.period_in_seconds);
        formatter.field("group_by", &self.group_by);
        formatter.field("partition_by", &self.partition_by);
        formatter.field("filter", &self.filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
