// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object that contains the full name, description, and unit of a metric. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseResourceMetric {
    /// <p>The full name of the metric.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The description of the metric.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unit of the metric.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl ResponseResourceMetric {
    /// <p>The full name of the metric.</p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The description of the metric.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unit of the metric.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for ResponseResourceMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseResourceMetric");
        formatter.field("metric", &self.metric);
        formatter.field("description", &self.description);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`ResponseResourceMetric`](crate::model::ResponseResourceMetric)
pub mod response_resource_metric {
    /// A builder for [`ResponseResourceMetric`](crate::model::ResponseResourceMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full name of the metric.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The full name of the metric.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The description of the metric.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the metric.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseResourceMetric`](crate::model::ResponseResourceMetric)
        pub fn build(self) -> crate::model::ResponseResourceMetric {
            crate::model::ResponseResourceMetric {
                metric: self.metric,
                description: self.description,
                unit: self.unit,
            }
        }
    }
}
impl ResponseResourceMetric {
    /// Creates a new builder-style object to manufacture [`ResponseResourceMetric`](crate::model::ResponseResourceMetric)
    pub fn builder() -> crate::model::response_resource_metric::Builder {
        crate::model::response_resource_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceType {
    #[allow(missing_docs)] // documentation missing in model
    Docdb,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceType {
    fn from(s: &str) -> Self {
        match s {
            "DOCDB" => ServiceType::Docdb,
            "RDS" => ServiceType::Rds,
            other => ServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceType::from(s))
    }
}
impl ServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceType::Docdb => "DOCDB",
            ServiceType::Rds => "RDS",
            ServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOCDB", "RDS"]
    }
}
impl AsRef<str> for ServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The available dimension information for a metric type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimensionGroups {
    /// <p>The metric type to which the dimension information belongs.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The available dimension groups for a metric type.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::DimensionGroupDetail>>,
}
impl MetricDimensionGroups {
    /// <p>The metric type to which the dimension information belongs.</p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The available dimension groups for a metric type.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::DimensionGroupDetail]> {
        self.groups.as_deref()
    }
}
impl std::fmt::Debug for MetricDimensionGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimensionGroups");
        formatter.field("metric", &self.metric);
        formatter.field("groups", &self.groups);
        formatter.finish()
    }
}
/// See [`MetricDimensionGroups`](crate::model::MetricDimensionGroups)
pub mod metric_dimension_groups {
    /// A builder for [`MetricDimensionGroups`](crate::model::MetricDimensionGroups)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::DimensionGroupDetail>>,
    }
    impl Builder {
        /// <p>The metric type to which the dimension information belongs.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The metric type to which the dimension information belongs.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The available dimension groups for a metric type.</p>
        pub fn groups(mut self, input: crate::model::DimensionGroupDetail) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>The available dimension groups for a metric type.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionGroupDetail>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimensionGroups`](crate::model::MetricDimensionGroups)
        pub fn build(self) -> crate::model::MetricDimensionGroups {
            crate::model::MetricDimensionGroups {
                metric: self.metric,
                groups: self.groups,
            }
        }
    }
}
impl MetricDimensionGroups {
    /// Creates a new builder-style object to manufacture [`MetricDimensionGroups`](crate::model::MetricDimensionGroups)
    pub fn builder() -> crate::model::metric_dimension_groups::Builder {
        crate::model::metric_dimension_groups::Builder::default()
    }
}

/// <p>Information about dimensions within a dimension group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionGroupDetail {
    /// <p>The name of the dimension group.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The dimensions within a dimension group.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::DimensionDetail>>,
}
impl DimensionGroupDetail {
    /// <p>The name of the dimension group.</p>
    pub fn group(&self) -> std::option::Option<&str> {
        self.group.as_deref()
    }
    /// <p>The dimensions within a dimension group.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::DimensionDetail]> {
        self.dimensions.as_deref()
    }
}
impl std::fmt::Debug for DimensionGroupDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionGroupDetail");
        formatter.field("group", &self.group);
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`DimensionGroupDetail`](crate::model::DimensionGroupDetail)
pub mod dimension_group_detail {
    /// A builder for [`DimensionGroupDetail`](crate::model::DimensionGroupDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::DimensionDetail>>,
    }
    impl Builder {
        /// <p>The name of the dimension group.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the dimension group.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions within a dimension group.</p>
        pub fn dimensions(mut self, input: crate::model::DimensionDetail) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input);
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions within a dimension group.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionDetail>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionGroupDetail`](crate::model::DimensionGroupDetail)
        pub fn build(self) -> crate::model::DimensionGroupDetail {
            crate::model::DimensionGroupDetail {
                group: self.group,
                dimensions: self.dimensions,
            }
        }
    }
}
impl DimensionGroupDetail {
    /// Creates a new builder-style object to manufacture [`DimensionGroupDetail`](crate::model::DimensionGroupDetail)
    pub fn builder() -> crate::model::dimension_group_detail::Builder {
        crate::model::dimension_group_detail::Builder::default()
    }
}

/// <p>The information about a dimension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionDetail {
    /// <p>The identifier of a dimension.</p>
    pub identifier: std::option::Option<std::string::String>,
}
impl DimensionDetail {
    /// <p>The identifier of a dimension.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for DimensionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionDetail");
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}
/// See [`DimensionDetail`](crate::model::DimensionDetail)
pub mod dimension_detail {
    /// A builder for [`DimensionDetail`](crate::model::DimensionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of a dimension.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier of a dimension.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionDetail`](crate::model::DimensionDetail)
        pub fn build(self) -> crate::model::DimensionDetail {
            crate::model::DimensionDetail {
                identifier: self.identifier,
            }
        }
    }
}
impl DimensionDetail {
    /// Creates a new builder-style object to manufacture [`DimensionDetail`](crate::model::DimensionDetail)
    pub fn builder() -> crate::model::dimension_detail::Builder {
        crate::model::dimension_detail::Builder::default()
    }
}

/// <p>A time-ordered series of data points, corresponding to a dimension of a Performance Insights metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricKeyDataPoints {
    /// <p>The dimensions to which the data points apply.</p>
    pub key: std::option::Option<crate::model::ResponseResourceMetricKey>,
    /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
    pub data_points: std::option::Option<std::vec::Vec<crate::model::DataPoint>>,
}
impl MetricKeyDataPoints {
    /// <p>The dimensions to which the data points apply.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::ResponseResourceMetricKey> {
        self.key.as_ref()
    }
    /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
    pub fn data_points(&self) -> std::option::Option<&[crate::model::DataPoint]> {
        self.data_points.as_deref()
    }
}
impl std::fmt::Debug for MetricKeyDataPoints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricKeyDataPoints");
        formatter.field("key", &self.key);
        formatter.field("data_points", &self.data_points);
        formatter.finish()
    }
}
/// See [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
pub mod metric_key_data_points {
    /// A builder for [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::ResponseResourceMetricKey>,
        pub(crate) data_points: std::option::Option<std::vec::Vec<crate::model::DataPoint>>,
    }
    impl Builder {
        /// <p>The dimensions to which the data points apply.</p>
        pub fn key(mut self, input: crate::model::ResponseResourceMetricKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The dimensions to which the data points apply.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::ResponseResourceMetricKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `data_points`.
        ///
        /// To override the contents of this collection use [`set_data_points`](Self::set_data_points).
        ///
        /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
        pub fn data_points(mut self, input: crate::model::DataPoint) -> Self {
            let mut v = self.data_points.unwrap_or_default();
            v.push(input);
            self.data_points = Some(v);
            self
        }
        /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
        pub fn set_data_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataPoint>>,
        ) -> Self {
            self.data_points = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
        pub fn build(self) -> crate::model::MetricKeyDataPoints {
            crate::model::MetricKeyDataPoints {
                key: self.key,
                data_points: self.data_points,
            }
        }
    }
}
impl MetricKeyDataPoints {
    /// Creates a new builder-style object to manufacture [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
    pub fn builder() -> crate::model::metric_key_data_points::Builder {
        crate::model::metric_key_data_points::Builder::default()
    }
}

/// <p>A timestamp, and a single numerical value, which together represent a measurement at a particular point in time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataPoint {
    /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
    pub value: std::option::Option<f64>,
}
impl DataPoint {
    /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
}
impl std::fmt::Debug for DataPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataPoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DataPoint`](crate::model::DataPoint)
pub mod data_point {
    /// A builder for [`DataPoint`](crate::model::DataPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DataPoint`](crate::model::DataPoint)
        pub fn build(self) -> crate::model::DataPoint {
            crate::model::DataPoint {
                timestamp: self.timestamp,
                value: self.value,
            }
        }
    }
}
impl DataPoint {
    /// Creates a new builder-style object to manufacture [`DataPoint`](crate::model::DataPoint)
    pub fn builder() -> crate::model::data_point::Builder {
        crate::model::data_point::Builder::default()
    }
}

/// <p>An object describing a Performance Insights metric and one or more dimensions for that metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseResourceMetricKey {
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
    /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The valid dimensions for the metric.</p>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ResponseResourceMetricKey {
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
    /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The valid dimensions for the metric.</p>
    pub fn dimensions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.dimensions.as_ref()
    }
}
impl std::fmt::Debug for ResponseResourceMetricKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseResourceMetricKey");
        formatter.field("metric", &self.metric);
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
pub mod response_resource_metric_key {
    /// A builder for [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
        /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
        /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The valid dimensions for the metric.</p>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>The valid dimensions for the metric.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
        pub fn build(self) -> crate::model::ResponseResourceMetricKey {
            crate::model::ResponseResourceMetricKey {
                metric: self.metric,
                dimensions: self.dimensions,
            }
        }
    }
}
impl ResponseResourceMetricKey {
    /// Creates a new builder-style object to manufacture [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
    pub fn builder() -> crate::model::response_resource_metric_key::Builder {
        crate::model::response_resource_metric_key::Builder::default()
    }
}

/// <p>A single query to be processed. You must provide the metric to query. If no other parameters are specified, Performance Insights returns all data points for the specified metric. Optionally, you can request that the data points be aggregated by dimension group (<code>GroupBy</code>), and return only those data points that match your criteria (<code>Filter</code>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricQuery {
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
    /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
    pub group_by: std::option::Option<crate::model::DimensionGroup>,
    /// <p>One or more filters to apply in the request. Restrictions:</p>
    /// <ul>
    /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
    /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
    /// </ul>
    pub filter:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl MetricQuery {
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
    /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only.</p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
    pub fn group_by(&self) -> std::option::Option<&crate::model::DimensionGroup> {
        self.group_by.as_ref()
    }
    /// <p>One or more filters to apply in the request. Restrictions:</p>
    /// <ul>
    /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
    /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
    /// </ul>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for MetricQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricQuery");
        formatter.field("metric", &self.metric);
        formatter.field("group_by", &self.group_by);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`MetricQuery`](crate::model::MetricQuery)
pub mod metric_query {
    /// A builder for [`MetricQuery`](crate::model::MetricQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) group_by: std::option::Option<crate::model::DimensionGroup>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
        /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li>
        /// <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn group_by(mut self, input: crate::model::DimensionGroup) -> Self {
            self.group_by = Some(input);
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<crate::model::DimensionGroup>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>One or more filters to apply in the request. Restrictions:</p>
        /// <ul>
        /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
        /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
        /// </ul>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.filter = Some(hash_map);
            self
        }
        /// <p>One or more filters to apply in the request. Restrictions:</p>
        /// <ul>
        /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
        /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
        /// </ul>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricQuery`](crate::model::MetricQuery)
        pub fn build(self) -> crate::model::MetricQuery {
            crate::model::MetricQuery {
                metric: self.metric,
                group_by: self.group_by,
                filter: self.filter,
            }
        }
    }
}
impl MetricQuery {
    /// Creates a new builder-style object to manufacture [`MetricQuery`](crate::model::MetricQuery)
    pub fn builder() -> crate::model::metric_query::Builder {
        crate::model::metric_query::Builder::default()
    }
}

/// <p>A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code> dimension group consists of the following dimensions:</p>
/// <ul>
/// <li> <p> <code>db.sql.id</code> - The hash of a running SQL statement, generated by Performance Insights.</p> </li>
/// <li> <p> <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with <code>pi-</code>.</p> </li>
/// <li> <p> <code>db.sql.statement</code> - The full text of the SQL statement that is running, for example, <code>SELECT * FROM employees</code>.</p> </li>
/// <li> <p> <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights.</p> </li>
/// </ul> <note>
/// <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionGroup {
    /// <p>The name of the dimension group. Valid values are as follows:</p>
    /// <ul>
    /// <li> <p> <code>db</code> - The name of the database to which the client is connected. The following values are permitted:</p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Aurora MySQL</p> </li>
    /// <li> <p>Amazon RDS MySQL</p> </li>
    /// <li> <p>Amazon RDS MariaDB</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database. The following values are permitted:</p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines).</p> </li>
    /// <li> <p> <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).</p> </li>
    /// <li> <p> <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).</p> </li>
    /// </ul>
    pub group: std::option::Option<std::string::String>,
    /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.</p>
    /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
    /// <ul>
    /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database. Valid values are as follows: </p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines).</p> </li>
    /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines).</p> </li>
    /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:</p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Aurora MySQL</p> </li>
    /// <li> <p>Amazon RDS MySQL</p> </li>
    /// <li> <p>Amazon RDS MariaDB</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.tokenized_id</code> </p> </li>
    /// <li> <p> <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
    /// <li> <p> <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.</p> </li>
    /// <li> <p> <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID isn't available (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).</p> </li>
    /// </ul>
    pub dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to fetch for this dimension group.</p>
    pub limit: std::option::Option<i32>,
}
impl DimensionGroup {
    /// <p>The name of the dimension group. Valid values are as follows:</p>
    /// <ul>
    /// <li> <p> <code>db</code> - The name of the database to which the client is connected. The following values are permitted:</p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Aurora MySQL</p> </li>
    /// <li> <p>Amazon RDS MySQL</p> </li>
    /// <li> <p>Amazon RDS MariaDB</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database. The following values are permitted:</p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines).</p> </li>
    /// <li> <p> <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).</p> </li>
    /// <li> <p> <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).</p> </li>
    /// </ul>
    pub fn group(&self) -> std::option::Option<&str> {
        self.group.as_deref()
    }
    /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.</p>
    /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
    /// <ul>
    /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database. Valid values are as follows: </p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines).</p> </li>
    /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines).</p> </li>
    /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:</p>
    /// <ul>
    /// <li> <p>Aurora PostgreSQL</p> </li>
    /// <li> <p>Amazon RDS PostgreSQL</p> </li>
    /// <li> <p>Aurora MySQL</p> </li>
    /// <li> <p>Amazon RDS MySQL</p> </li>
    /// <li> <p>Amazon RDS MariaDB</p> </li>
    /// <li> <p>Amazon DocumentDB</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.tokenized_id</code> </p> </li>
    /// <li> <p> <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
    /// <li> <p> <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.</p> </li>
    /// <li> <p> <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID isn't available (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
    /// <li> <p> <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).</p> </li>
    /// </ul>
    pub fn dimensions(&self) -> std::option::Option<&[std::string::String]> {
        self.dimensions.as_deref()
    }
    /// <p>The maximum number of items to fetch for this dimension group.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DimensionGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionGroup");
        formatter.field("group", &self.group);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
/// See [`DimensionGroup`](crate::model::DimensionGroup)
pub mod dimension_group {
    /// A builder for [`DimensionGroup`](crate::model::DimensionGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the dimension group. Valid values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>db</code> - The name of the database to which the client is connected. The following values are permitted:</p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Aurora MySQL</p> </li>
        /// <li> <p>Amazon RDS MySQL</p> </li>
        /// <li> <p>Amazon RDS MariaDB</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database. The following values are permitted:</p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines).</p> </li>
        /// <li> <p> <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).</p> </li>
        /// <li> <p> <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).</p> </li>
        /// </ul>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the dimension group. Valid values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>db</code> - The name of the database to which the client is connected. The following values are permitted:</p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Aurora MySQL</p> </li>
        /// <li> <p>Amazon RDS MySQL</p> </li>
        /// <li> <p>Amazon RDS MariaDB</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database. The following values are permitted:</p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines).</p> </li>
        /// <li> <p> <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).</p> </li>
        /// <li> <p> <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).</p> </li>
        /// </ul>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.</p>
        /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
        /// <ul>
        /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database. Valid values are as follows: </p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines).</p> </li>
        /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines).</p> </li>
        /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:</p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Aurora MySQL</p> </li>
        /// <li> <p>Amazon RDS MySQL</p> </li>
        /// <li> <p>Amazon RDS MariaDB</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.tokenized_id</code> </p> </li>
        /// <li> <p> <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
        /// <li> <p> <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.</p> </li>
        /// <li> <p> <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID isn't available (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).</p> </li>
        /// </ul>
        pub fn dimensions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.</p>
        /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
        /// <ul>
        /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database. Valid values are as follows: </p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines).</p> </li>
        /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines).</p> </li>
        /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:</p>
        /// <ul>
        /// <li> <p>Aurora PostgreSQL</p> </li>
        /// <li> <p>Amazon RDS PostgreSQL</p> </li>
        /// <li> <p>Aurora MySQL</p> </li>
        /// <li> <p>Amazon RDS MySQL</p> </li>
        /// <li> <p>Amazon RDS MariaDB</p> </li>
        /// <li> <p>Amazon DocumentDB</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.tokenized_id</code> </p> </li>
        /// <li> <p> <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
        /// <li> <p> <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.</p> </li>
        /// <li> <p> <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID isn't available (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines except Amazon DocumentDB).</p> </li>
        /// <li> <p> <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).</p> </li>
        /// </ul>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The maximum number of items to fetch for this dimension group.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to fetch for this dimension group.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionGroup`](crate::model::DimensionGroup)
        pub fn build(self) -> crate::model::DimensionGroup {
            crate::model::DimensionGroup {
                group: self.group,
                dimensions: self.dimensions,
                limit: self.limit,
            }
        }
    }
}
impl DimensionGroup {
    /// Creates a new builder-style object to manufacture [`DimensionGroup`](crate::model::DimensionGroup)
    pub fn builder() -> crate::model::dimension_group::Builder {
        crate::model::dimension_group::Builder::default()
    }
}

/// <p>The metadata for a feature. For example, the metadata might indicate that a feature is turned on or off on a specific DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeatureMetadata {
    /// <p>The status of the feature on the DB instance. Possible values include the following:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - The feature is enabled on the instance.</p> </li>
    /// <li> <p> <code>DISABLED</code> - The feature is disabled on the instance.</p> </li>
    /// <li> <p> <code>UNSUPPORTED</code> - The feature isn't supported on the instance.</p> </li>
    /// <li> <p> <code>ENABLED_PENDING_REBOOT</code> - The feature is enabled on the instance but requires a reboot to take effect.</p> </li>
    /// <li> <p> <code>DISABLED_PENDING_REBOOT</code> - The feature is disabled on the instance but requires a reboot to take effect.</p> </li>
    /// <li> <p> <code>UNKNOWN</code> - The feature status couldn't be determined.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::FeatureStatus>,
}
impl FeatureMetadata {
    /// <p>The status of the feature on the DB instance. Possible values include the following:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - The feature is enabled on the instance.</p> </li>
    /// <li> <p> <code>DISABLED</code> - The feature is disabled on the instance.</p> </li>
    /// <li> <p> <code>UNSUPPORTED</code> - The feature isn't supported on the instance.</p> </li>
    /// <li> <p> <code>ENABLED_PENDING_REBOOT</code> - The feature is enabled on the instance but requires a reboot to take effect.</p> </li>
    /// <li> <p> <code>DISABLED_PENDING_REBOOT</code> - The feature is disabled on the instance but requires a reboot to take effect.</p> </li>
    /// <li> <p> <code>UNKNOWN</code> - The feature status couldn't be determined.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::FeatureStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for FeatureMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeatureMetadata");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`FeatureMetadata`](crate::model::FeatureMetadata)
pub mod feature_metadata {
    /// A builder for [`FeatureMetadata`](crate::model::FeatureMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::FeatureStatus>,
    }
    impl Builder {
        /// <p>The status of the feature on the DB instance. Possible values include the following:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - The feature is enabled on the instance.</p> </li>
        /// <li> <p> <code>DISABLED</code> - The feature is disabled on the instance.</p> </li>
        /// <li> <p> <code>UNSUPPORTED</code> - The feature isn't supported on the instance.</p> </li>
        /// <li> <p> <code>ENABLED_PENDING_REBOOT</code> - The feature is enabled on the instance but requires a reboot to take effect.</p> </li>
        /// <li> <p> <code>DISABLED_PENDING_REBOOT</code> - The feature is disabled on the instance but requires a reboot to take effect.</p> </li>
        /// <li> <p> <code>UNKNOWN</code> - The feature status couldn't be determined.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::FeatureStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the feature on the DB instance. Possible values include the following:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - The feature is enabled on the instance.</p> </li>
        /// <li> <p> <code>DISABLED</code> - The feature is disabled on the instance.</p> </li>
        /// <li> <p> <code>UNSUPPORTED</code> - The feature isn't supported on the instance.</p> </li>
        /// <li> <p> <code>ENABLED_PENDING_REBOOT</code> - The feature is enabled on the instance but requires a reboot to take effect.</p> </li>
        /// <li> <p> <code>DISABLED_PENDING_REBOOT</code> - The feature is disabled on the instance but requires a reboot to take effect.</p> </li>
        /// <li> <p> <code>UNKNOWN</code> - The feature status couldn't be determined.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FeatureStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`FeatureMetadata`](crate::model::FeatureMetadata)
        pub fn build(self) -> crate::model::FeatureMetadata {
            crate::model::FeatureMetadata {
                status: self.status,
            }
        }
    }
}
impl FeatureMetadata {
    /// Creates a new builder-style object to manufacture [`FeatureMetadata`](crate::model::FeatureMetadata)
    pub fn builder() -> crate::model::feature_metadata::Builder {
        crate::model::feature_metadata::Builder::default()
    }
}

/// _Note: `FeatureStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeatureStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    DisabledPendingReboot,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    EnabledPendingReboot,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Unsupported,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeatureStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => FeatureStatus::Disabled,
            "DISABLED_PENDING_REBOOT" => FeatureStatus::DisabledPendingReboot,
            "ENABLED" => FeatureStatus::Enabled,
            "ENABLED_PENDING_REBOOT" => FeatureStatus::EnabledPendingReboot,
            "UNKNOWN" => FeatureStatus::UnknownValue,
            "UNSUPPORTED" => FeatureStatus::Unsupported,
            other => FeatureStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeatureStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeatureStatus::from(s))
    }
}
impl FeatureStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeatureStatus::Disabled => "DISABLED",
            FeatureStatus::DisabledPendingReboot => "DISABLED_PENDING_REBOOT",
            FeatureStatus::Enabled => "ENABLED",
            FeatureStatus::EnabledPendingReboot => "ENABLED_PENDING_REBOOT",
            FeatureStatus::UnknownValue => "UNKNOWN",
            FeatureStatus::Unsupported => "UNSUPPORTED",
            FeatureStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISABLED",
            "DISABLED_PENDING_REBOOT",
            "ENABLED",
            "ENABLED_PENDING_REBOOT",
            "UNKNOWN",
            "UNSUPPORTED",
        ]
    }
}
impl AsRef<str> for FeatureStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that describes the details for a specified dimension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionKeyDetail {
    /// <p>The value of the dimension detail data. Depending on the return status, this value is either the full or truncated SQL query for the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
    /// <p>The full name of the dimension. The full name includes the group name and key name. The following values are valid:</p>
    /// <ul>
    /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
    /// </ul>
    pub dimension: std::option::Option<std::string::String>,
    /// <p>The status of the dimension detail data. Possible values include the following:</p>
    /// <ul>
    /// <li> <p> <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p> </li>
    /// <li> <p> <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is required. If the requested detail data has the status <code>PROCESSING</code>, Performance Insights returns the truncated query.</p> </li>
    /// <li> <p> <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DetailStatus>,
}
impl DimensionKeyDetail {
    /// <p>The value of the dimension detail data. Depending on the return status, this value is either the full or truncated SQL query for the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
    /// </ul>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The full name of the dimension. The full name includes the group name and key name. The following values are valid:</p>
    /// <ul>
    /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
    /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
    /// </ul>
    pub fn dimension(&self) -> std::option::Option<&str> {
        self.dimension.as_deref()
    }
    /// <p>The status of the dimension detail data. Possible values include the following:</p>
    /// <ul>
    /// <li> <p> <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p> </li>
    /// <li> <p> <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is required. If the requested detail data has the status <code>PROCESSING</code>, Performance Insights returns the truncated query.</p> </li>
    /// <li> <p> <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DetailStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DimensionKeyDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionKeyDetail");
        formatter.field("value", &self.value);
        formatter.field("dimension", &self.dimension);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
pub mod dimension_key_detail {
    /// A builder for [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) dimension: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DetailStatus>,
    }
    impl Builder {
        /// <p>The value of the dimension detail data. Depending on the return status, this value is either the full or truncated SQL query for the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension detail data. Depending on the return status, this value is either the full or truncated SQL query for the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The full name of the dimension. The full name includes the group name and key name. The following values are valid:</p>
        /// <ul>
        /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
        /// </ul>
        pub fn dimension(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension = Some(input.into());
            self
        }
        /// <p>The full name of the dimension. The full name includes the group name and key name. The following values are valid:</p>
        /// <ul>
        /// <li> <p> <code>db.query.statement</code> (Amazon DocumentDB)</p> </li>
        /// <li> <p> <code>db.sql.statement</code> (Amazon RDS and Aurora)</p> </li>
        /// </ul>
        pub fn set_dimension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dimension = input;
            self
        }
        /// <p>The status of the dimension detail data. Possible values include the following:</p>
        /// <ul>
        /// <li> <p> <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p> </li>
        /// <li> <p> <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is required. If the requested detail data has the status <code>PROCESSING</code>, Performance Insights returns the truncated query.</p> </li>
        /// <li> <p> <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DetailStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the dimension detail data. Possible values include the following:</p>
        /// <ul>
        /// <li> <p> <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p> </li>
        /// <li> <p> <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is required. If the requested detail data has the status <code>PROCESSING</code>, Performance Insights returns the truncated query.</p> </li>
        /// <li> <p> <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetailStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
        pub fn build(self) -> crate::model::DimensionKeyDetail {
            crate::model::DimensionKeyDetail {
                value: self.value,
                dimension: self.dimension,
                status: self.status,
            }
        }
    }
}
impl DimensionKeyDetail {
    /// Creates a new builder-style object to manufacture [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
    pub fn builder() -> crate::model::dimension_key_detail::Builder {
        crate::model::dimension_key_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetailStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetailStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DetailStatus::Available,
            "PROCESSING" => DetailStatus::Processing,
            "UNAVAILABLE" => DetailStatus::Unavailable,
            other => DetailStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetailStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetailStatus::from(s))
    }
}
impl DetailStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetailStatus::Available => "AVAILABLE",
            DetailStatus::Processing => "PROCESSING",
            DetailStatus::Unavailable => "UNAVAILABLE",
            DetailStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "PROCESSING", "UNAVAILABLE"]
    }
}
impl AsRef<str> for DetailStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that includes the requested dimension key values and aggregated metric values within a dimension group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionKeyDescription {
    /// <p>A map of name-value pairs for the dimensions in the group.</p>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The aggregated metric value for the dimensions, over the requested time range.</p>
    pub total: std::option::Option<f64>,
    /// <p>A map that contains the value for each additional metric.</p>
    pub additional_metrics:
        std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
    pub partitions: std::option::Option<std::vec::Vec<f64>>,
}
impl DimensionKeyDescription {
    /// <p>A map of name-value pairs for the dimensions in the group.</p>
    pub fn dimensions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.dimensions.as_ref()
    }
    /// <p>The aggregated metric value for the dimensions, over the requested time range.</p>
    pub fn total(&self) -> std::option::Option<f64> {
        self.total
    }
    /// <p>A map that contains the value for each additional metric.</p>
    pub fn additional_metrics(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.additional_metrics.as_ref()
    }
    /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
    pub fn partitions(&self) -> std::option::Option<&[f64]> {
        self.partitions.as_deref()
    }
}
impl std::fmt::Debug for DimensionKeyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionKeyDescription");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("total", &self.total);
        formatter.field("additional_metrics", &self.additional_metrics);
        formatter.field("partitions", &self.partitions);
        formatter.finish()
    }
}
/// See [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
pub mod dimension_key_description {
    /// A builder for [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) total: std::option::Option<f64>,
        pub(crate) additional_metrics:
            std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        pub(crate) partitions: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A map of name-value pairs for the dimensions in the group.</p>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>A map of name-value pairs for the dimensions in the group.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The aggregated metric value for the dimensions, over the requested time range.</p>
        pub fn total(mut self, input: f64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The aggregated metric value for the dimensions, over the requested time range.</p>
        pub fn set_total(mut self, input: std::option::Option<f64>) -> Self {
            self.total = input;
            self
        }
        /// Adds a key-value pair to `additional_metrics`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics`](Self::set_additional_metrics).
        ///
        /// <p>A map that contains the value for each additional metric.</p>
        pub fn additional_metrics(mut self, k: impl Into<std::string::String>, v: f64) -> Self {
            let mut hash_map = self.additional_metrics.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.additional_metrics = Some(hash_map);
            self
        }
        /// <p>A map that contains the value for each additional metric.</p>
        pub fn set_additional_metrics(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.additional_metrics = input;
            self
        }
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
        pub fn partitions(mut self, input: f64) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input);
            self.partitions = Some(v);
            self
        }
        /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
        pub fn set_partitions(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
        pub fn build(self) -> crate::model::DimensionKeyDescription {
            crate::model::DimensionKeyDescription {
                dimensions: self.dimensions,
                total: self.total,
                additional_metrics: self.additional_metrics,
                partitions: self.partitions,
            }
        }
    }
}
impl DimensionKeyDescription {
    /// Creates a new builder-style object to manufacture [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
    pub fn builder() -> crate::model::dimension_key_description::Builder {
        crate::model::dimension_key_description::Builder::default()
    }
}

/// <p>If <code>PartitionBy</code> was specified in a <code>DescribeDimensionKeys</code> request, the dimensions are returned in an array. Each element in the array specifies one dimension. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponsePartitionKey {
    /// <p>A dimension map that contains the dimensions for this partition.</p>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ResponsePartitionKey {
    /// <p>A dimension map that contains the dimensions for this partition.</p>
    pub fn dimensions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.dimensions.as_ref()
    }
}
impl std::fmt::Debug for ResponsePartitionKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponsePartitionKey");
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
pub mod response_partition_key {
    /// A builder for [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A dimension map that contains the dimensions for this partition.</p>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>A dimension map that contains the dimensions for this partition.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
        pub fn build(self) -> crate::model::ResponsePartitionKey {
            crate::model::ResponsePartitionKey {
                dimensions: self.dimensions,
            }
        }
    }
}
impl ResponsePartitionKey {
    /// Creates a new builder-style object to manufacture [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
    pub fn builder() -> crate::model::response_partition_key::Builder {
        crate::model::response_partition_key::Builder::default()
    }
}
