// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `PerformanceInsightsv20180227`.
///
/// This client allows ergonomic access to a `PerformanceInsightsv20180227`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `DescribeDimensionKeys` operation.
    ///
    /// See [`DescribeDimensionKeys`](crate::client::fluent_builders::DescribeDimensionKeys) for more information about the
    /// operation and its arguments.
    pub fn describe_dimension_keys(&self) -> fluent_builders::DescribeDimensionKeys<C, M, R> {
        fluent_builders::DescribeDimensionKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDimensionKeyDetails` operation.
    ///
    /// See [`GetDimensionKeyDetails`](crate::client::fluent_builders::GetDimensionKeyDetails) for more information about the
    /// operation and its arguments.
    pub fn get_dimension_key_details(&self) -> fluent_builders::GetDimensionKeyDetails<C, M, R> {
        fluent_builders::GetDimensionKeyDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceMetrics` operation.
    ///
    /// See [`GetResourceMetrics`](crate::client::fluent_builders::GetResourceMetrics) for more information about the
    /// operation and its arguments.
    pub fn get_resource_metrics(&self) -> fluent_builders::GetResourceMetrics<C, M, R> {
        fluent_builders::GetResourceMetrics::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DescribeDimensionKeys`.
    ///
    /// <p>For a specific time period, retrieve the top <code>N</code> dimension keys for a
    /// metric.</p>
    /// <note>
    /// <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
    /// only the first 500 bytes are returned.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDimensionKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dimension_keys_input::Builder,
    }
    impl<C, M, R> DescribeDimensionKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDimensionKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDimensionKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDimensionKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDimensionKeysInputOperationOutputAlias,
                crate::output::DescribeDimensionKeysOutput,
                crate::error::DescribeDimensionKeysError,
                crate::input::DescribeDimensionKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is
        /// <code>RDS</code>.</p>
        pub fn service_type(mut self, inp: crate::model::ServiceType) -> Self {
            self.inner = self.inner.service_type(inp);
            self
        }
        /// <p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is
        /// <code>RDS</code>.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
        /// this data source.</p>
        /// <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example,
        /// specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
        /// </p>
        pub fn identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(inp);
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
        /// this data source.</p>
        /// <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example,
        /// specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
        /// </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You must specify a
        /// <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means
        /// that data points equal to or greater than <code>StartTime</code> are returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for
        /// <code>EndTime</code>.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You must specify a
        /// <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means
        /// that data points equal to or greater than <code>StartTime</code> are returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for
        /// <code>EndTime</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The date and time specifying the end of the requested time series data. The value specified is
        /// <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are
        /// returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for
        /// <code>StartTime</code>.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The date and time specifying the end of the requested time series data. The value specified is
        /// <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are
        /// returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for
        /// <code>StartTime</code>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
        /// for the database engine.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
        /// database engine.</p>
        /// </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
        /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
        /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
        /// For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn metric(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric(inp);
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
        /// for the database engine.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
        /// database engine.</p>
        /// </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
        /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
        /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
        /// For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric(input);
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
        /// one second, or as long as one day (86400 seconds).  Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> (one second)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>60</code> (one minute)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>300</code> (five minutes)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3600</code> (one hour)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>86400</code> (twenty-four hours)</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning
        /// roughly 100-200 data points in the response.</p>
        pub fn period_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.period_in_seconds(inp);
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
        /// one second, or as long as one day (86400 seconds).  Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> (one second)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>60</code> (one minute)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>300</code> (five minutes)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3600</code> (one hour)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>86400</code> (twenty-four hours)</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning
        /// roughly 100-200 data points in the response.</p>
        pub fn set_period_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period_in_seconds(input);
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group.
        /// Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group.
        /// You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn group_by(mut self, inp: crate::model::DimensionGroup) -> Self {
            self.inner = self.inner.group_by(inp);
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group.
        /// Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group.
        /// You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<crate::model::DimensionGroup>,
        ) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>For each dimension specified in
        /// <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>
        pub fn partition_by(mut self, inp: crate::model::DimensionGroup) -> Self {
            self.inner = self.inner.partition_by(inp);
            self
        }
        /// <p>For each dimension specified in
        /// <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>
        pub fn set_partition_by(
            mut self,
            input: std::option::Option<crate::model::DimensionGroup>,
        ) -> Self {
            self.inner = self.inner.set_partition_by(input);
            self
        }
        /// Adds a key-value pair to `Filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>One or more filters to apply in the request.  Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
        /// <code>Partition</code> parameters.</p>
        /// </li>
        /// <li>
        /// <p>A single filter for any other dimension in this dimension group.</p>
        /// </li>
        /// </ul>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filter(k, v);
            self
        }
        /// <p>One or more filters to apply in the request.  Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
        /// <code>Partition</code> parameters.</p>
        /// </li>
        /// <li>
        /// <p>A single filter for any other dimension in this dimension group.</p>
        /// </li>
        /// </ul>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The maximum number of items to return in the response.
        /// If more items exist than the specified <code>MaxRecords</code> value, a pagination
        /// token is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return in the response.
        /// If more items exist than the specified <code>MaxRecords</code> value, a pagination
        /// token is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDimensionKeyDetails`.
    ///
    /// <p>Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify a
    /// SQL ID, <code>GetDimensionKeyDetails</code> retrieves the full text of the dimension <code>db.sql.statement</code>
    /// associated with this ID. This operation is useful because <code>GetResourceMetrics</code> and
    /// <code>DescribeDimensionKeys</code> don't support retrieval of large SQL statement text.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDimensionKeyDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dimension_key_details_input::Builder,
    }
    impl<C, M, R> GetDimensionKeyDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDimensionKeyDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDimensionKeyDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDimensionKeyDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDimensionKeyDetailsInputOperationOutputAlias,
                crate::output::GetDimensionKeyDetailsOutput,
                crate::error::GetDimensionKeyDetailsError,
                crate::input::GetDimensionKeyDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>
        pub fn service_type(mut self, inp: crate::model::ServiceType) -> Self {
            self.inner = self.inner.service_type(inp);
            self
        }
        /// <p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
        /// <p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS
        /// Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify
        /// <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>
        pub fn identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(inp);
            self
        }
        /// <p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS
        /// Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify
        /// <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the
        /// specified group for the dimension group ID.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the
        /// specified group for the dimension group ID.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>,
        /// the group ID is <code>db.sql.id</code>.</p>
        pub fn group_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_identifier(inp);
            self
        }
        /// <p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>,
        /// the group ID is <code>db.sql.id</code>.</p>
        pub fn set_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_group_identifier(input);
            self
        }
        /// Appends an item to `RequestedDimensions`.
        ///
        /// To override the contents of this collection use [`set_requested_dimensions`](Self::set_requested_dimensions).
        ///
        /// <p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group
        /// <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short
        /// dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all
        /// dimension data within the specified dimension group.</p>
        pub fn requested_dimensions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requested_dimensions(inp);
            self
        }
        /// <p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group
        /// <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short
        /// dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all
        /// dimension data within the specified dimension group.</p>
        pub fn set_requested_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_requested_dimensions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceMetrics`.
    ///
    /// <p>Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide
    /// specific dimension groups and dimensions, and provide aggregation and filtering criteria for
    /// each group.</p>
    /// <note>
    /// <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
    /// only the first 500 bytes are returned.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_metrics_input::Builder,
    }
    impl<C, M, R> GetResourceMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceMetricsInputOperationOutputAlias,
                crate::output::GetResourceMetricsOutput,
                crate::error::GetResourceMetricsError,
                crate::input::GetResourceMetricsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is
        /// <code>RDS</code>.</p>
        pub fn service_type(mut self, inp: crate::model::ServiceType) -> Self {
            self.inner = self.inner.service_type(inp);
            self
        }
        /// <p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is
        /// <code>RDS</code>.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
        /// this data source.</p>
        /// <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
        /// <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>
        pub fn identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(inp);
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
        /// this data source.</p>
        /// <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
        /// <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// Appends an item to `MetricQueries`.
        ///
        /// To override the contents of this collection use [`set_metric_queries`](Self::set_metric_queries).
        ///
        /// <p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and
        /// can optionally specify aggregation and filtering criteria.</p>
        pub fn metric_queries(mut self, inp: impl Into<crate::model::MetricQuery>) -> Self {
            self.inner = self.inner.metric_queries(inp);
            self
        }
        /// <p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and
        /// can optionally specify aggregation and filtering criteria.</p>
        pub fn set_metric_queries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricQuery>>,
        ) -> Self {
            self.inner = self.inner.set_metric_queries(input);
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You can't
        /// specify a <code>StartTime</code> that's earlier than 7 days ago. The value specified is
        /// <i>inclusive</i> - data points equal to or greater than <code>StartTime</code>
        /// will be returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The date and time specifying the beginning of the requested time series data. You can't
        /// specify a <code>StartTime</code> that's earlier than 7 days ago. The value specified is
        /// <i>inclusive</i> - data points equal to or greater than <code>StartTime</code>
        /// will be returned.</p>
        /// <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The date and time specifying the end of the requested time series data.  The value specified is
        /// <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The date and time specifying the end of the requested time series data.  The value specified is
        /// <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
        /// <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
        /// one second, or as long as one day (86400 seconds).  Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> (one second)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>60</code> (one minute)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>300</code> (five minutes)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3600</code> (one hour)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>86400</code> (twenty-four hours)</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for
        /// you, with a goal of returning roughly 100-200 data points in the response.</p>
        pub fn period_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.period_in_seconds(inp);
            self
        }
        /// <p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
        /// one second, or as long as one day (86400 seconds).  Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> (one second)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>60</code> (one minute)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>300</code> (five minutes)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3600</code> (one hour)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>86400</code> (twenty-four hours)</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for
        /// you, with a goal of returning roughly 100-200 data points in the response.</p>
        pub fn set_period_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period_in_seconds(input);
            self
        }
        /// <p>The maximum number of items to return in the response.
        /// If more items exist than the specified <code>MaxRecords</code> value, a pagination
        /// token is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return in the response.
        /// If more items exist than the specified <code>MaxRecords</code> value, a pagination
        /// token is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
