// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceMetricsOutput {
    /// <p>The start time for the returned metrics, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
    /// equal to the value of the user-specified <code>StartTime</code>.</p>
    pub aligned_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time for the returned metrics, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
    /// or equal to the value of the user-specified <code>Endtime</code>.</p>
    pub aligned_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
    /// this data source.</p>
    /// <p>To use a DB instance as a data source, you specify its
    /// <code>DbiResourceId</code> value - for example:  
    /// <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
    /// </p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>An array of metric results,, where each array element contains all of the data points for a particular dimension.</p>
    pub metric_list: std::option::Option<std::vec::Vec<crate::model::MetricKeyDataPoints>>,
    /// <p>An optional pagination token provided by a previous request. If
    /// this parameter is specified, the response includes only records beyond the token, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceMetricsOutput {
    /// <p>The start time for the returned metrics, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
    /// equal to the value of the user-specified <code>StartTime</code>.</p>
    pub fn aligned_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.aligned_start_time.as_ref()
    }
    /// <p>The end time for the returned metrics, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
    /// or equal to the value of the user-specified <code>Endtime</code>.</p>
    pub fn aligned_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.aligned_end_time.as_ref()
    }
    /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
    /// this data source.</p>
    /// <p>To use a DB instance as a data source, you specify its
    /// <code>DbiResourceId</code> value - for example:  
    /// <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
    /// </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>An array of metric results,, where each array element contains all of the data points for a particular dimension.</p>
    pub fn metric_list(&self) -> std::option::Option<&[crate::model::MetricKeyDataPoints]> {
        self.metric_list.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request. If
    /// this parameter is specified, the response includes only records beyond the token, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceMetricsOutput");
        formatter.field("aligned_start_time", &self.aligned_start_time);
        formatter.field("aligned_end_time", &self.aligned_end_time);
        formatter.field("identifier", &self.identifier);
        formatter.field("metric_list", &self.metric_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetResourceMetricsOutput`](crate::output::GetResourceMetricsOutput)
pub mod get_resource_metrics_output {
    /// A builder for [`GetResourceMetricsOutput`](crate::output::GetResourceMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aligned_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) aligned_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) metric_list:
            std::option::Option<std::vec::Vec<crate::model::MetricKeyDataPoints>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start time for the returned metrics, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
        /// equal to the value of the user-specified <code>StartTime</code>.</p>
        pub fn aligned_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.aligned_start_time = Some(input);
            self
        }
        /// <p>The start time for the returned metrics, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
        /// equal to the value of the user-specified <code>StartTime</code>.</p>
        pub fn set_aligned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.aligned_start_time = input;
            self
        }
        /// <p>The end time for the returned metrics, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
        /// or equal to the value of the user-specified <code>Endtime</code>.</p>
        pub fn aligned_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.aligned_end_time = Some(input);
            self
        }
        /// <p>The end time for the returned metrics, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
        /// or equal to the value of the user-specified <code>Endtime</code>.</p>
        pub fn set_aligned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.aligned_end_time = input;
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
        /// this data source.</p>
        /// <p>To use a DB instance as a data source, you specify its
        /// <code>DbiResourceId</code> value - for example:  
        /// <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
        /// </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
        /// this data source.</p>
        /// <p>To use a DB instance as a data source, you specify its
        /// <code>DbiResourceId</code> value - for example:  
        /// <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
        /// </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Appends an item to `metric_list`.
        ///
        /// To override the contents of this collection use [`set_metric_list`](Self::set_metric_list).
        ///
        /// <p>An array of metric results,, where each array element contains all of the data points for a particular dimension.</p>
        pub fn metric_list(mut self, input: impl Into<crate::model::MetricKeyDataPoints>) -> Self {
            let mut v = self.metric_list.unwrap_or_default();
            v.push(input.into());
            self.metric_list = Some(v);
            self
        }
        /// <p>An array of metric results,, where each array element contains all of the data points for a particular dimension.</p>
        pub fn set_metric_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricKeyDataPoints>>,
        ) -> Self {
            self.metric_list = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceMetricsOutput`](crate::output::GetResourceMetricsOutput)
        pub fn build(self) -> crate::output::GetResourceMetricsOutput {
            crate::output::GetResourceMetricsOutput {
                aligned_start_time: self.aligned_start_time,
                aligned_end_time: self.aligned_end_time,
                identifier: self.identifier,
                metric_list: self.metric_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetResourceMetricsOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceMetricsOutput`](crate::output::GetResourceMetricsOutput)
    pub fn builder() -> crate::output::get_resource_metrics_output::Builder {
        crate::output::get_resource_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDimensionKeyDetailsOutput {
    /// <p>The details for the requested dimensions.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::DimensionKeyDetail>>,
}
impl GetDimensionKeyDetailsOutput {
    /// <p>The details for the requested dimensions.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::DimensionKeyDetail]> {
        self.dimensions.as_deref()
    }
}
impl std::fmt::Debug for GetDimensionKeyDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDimensionKeyDetailsOutput");
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`GetDimensionKeyDetailsOutput`](crate::output::GetDimensionKeyDetailsOutput)
pub mod get_dimension_key_details_output {
    /// A builder for [`GetDimensionKeyDetailsOutput`](crate::output::GetDimensionKeyDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::DimensionKeyDetail>>,
    }
    impl Builder {
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The details for the requested dimensions.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::DimensionKeyDetail>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>The details for the requested dimensions.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionKeyDetail>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDimensionKeyDetailsOutput`](crate::output::GetDimensionKeyDetailsOutput)
        pub fn build(self) -> crate::output::GetDimensionKeyDetailsOutput {
            crate::output::GetDimensionKeyDetailsOutput {
                dimensions: self.dimensions,
            }
        }
    }
}
impl GetDimensionKeyDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetDimensionKeyDetailsOutput`](crate::output::GetDimensionKeyDetailsOutput)
    pub fn builder() -> crate::output::get_dimension_key_details_output::Builder {
        crate::output::get_dimension_key_details_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDimensionKeysOutput {
    /// <p>The start time for the returned dimension keys, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
    /// equal to the value of the user-specified <code>StartTime</code>.</p>
    pub aligned_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time for the returned dimension keys, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
    /// or equal to the value of the user-specified <code>Endtime</code>.</p>
    pub aligned_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of dimension keys by the specified partitions.</p>
    pub partition_keys: std::option::Option<std::vec::Vec<crate::model::ResponsePartitionKey>>,
    /// <p>The dimension keys that were requested.</p>
    pub keys: std::option::Option<std::vec::Vec<crate::model::DimensionKeyDescription>>,
    /// <p>An optional pagination token provided by a previous request. If
    /// this parameter is specified, the response includes only records beyond the token, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDimensionKeysOutput {
    /// <p>The start time for the returned dimension keys, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
    /// equal to the value of the user-specified <code>StartTime</code>.</p>
    pub fn aligned_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.aligned_start_time.as_ref()
    }
    /// <p>The end time for the returned dimension keys, after alignment to a granular boundary (as
    /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
    /// or equal to the value of the user-specified <code>Endtime</code>.</p>
    pub fn aligned_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.aligned_end_time.as_ref()
    }
    /// <p>If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of dimension keys by the specified partitions.</p>
    pub fn partition_keys(&self) -> std::option::Option<&[crate::model::ResponsePartitionKey]> {
        self.partition_keys.as_deref()
    }
    /// <p>The dimension keys that were requested.</p>
    pub fn keys(&self) -> std::option::Option<&[crate::model::DimensionKeyDescription]> {
        self.keys.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request. If
    /// this parameter is specified, the response includes only records beyond the token, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDimensionKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDimensionKeysOutput");
        formatter.field("aligned_start_time", &self.aligned_start_time);
        formatter.field("aligned_end_time", &self.aligned_end_time);
        formatter.field("partition_keys", &self.partition_keys);
        formatter.field("keys", &self.keys);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDimensionKeysOutput`](crate::output::DescribeDimensionKeysOutput)
pub mod describe_dimension_keys_output {
    /// A builder for [`DescribeDimensionKeysOutput`](crate::output::DescribeDimensionKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aligned_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) aligned_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) partition_keys:
            std::option::Option<std::vec::Vec<crate::model::ResponsePartitionKey>>,
        pub(crate) keys: std::option::Option<std::vec::Vec<crate::model::DimensionKeyDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start time for the returned dimension keys, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
        /// equal to the value of the user-specified <code>StartTime</code>.</p>
        pub fn aligned_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.aligned_start_time = Some(input);
            self
        }
        /// <p>The start time for the returned dimension keys, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or
        /// equal to the value of the user-specified <code>StartTime</code>.</p>
        pub fn set_aligned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.aligned_start_time = input;
            self
        }
        /// <p>The end time for the returned dimension keys, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
        /// or equal to the value of the user-specified <code>Endtime</code>.</p>
        pub fn aligned_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.aligned_end_time = Some(input);
            self
        }
        /// <p>The end time for the returned dimension keys, after alignment to a granular boundary (as
        /// specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than
        /// or equal to the value of the user-specified <code>Endtime</code>.</p>
        pub fn set_aligned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.aligned_end_time = input;
            self
        }
        /// Appends an item to `partition_keys`.
        ///
        /// To override the contents of this collection use [`set_partition_keys`](Self::set_partition_keys).
        ///
        /// <p>If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of dimension keys by the specified partitions.</p>
        pub fn partition_keys(
            mut self,
            input: impl Into<crate::model::ResponsePartitionKey>,
        ) -> Self {
            let mut v = self.partition_keys.unwrap_or_default();
            v.push(input.into());
            self.partition_keys = Some(v);
            self
        }
        /// <p>If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of dimension keys by the specified partitions.</p>
        pub fn set_partition_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResponsePartitionKey>>,
        ) -> Self {
            self.partition_keys = input;
            self
        }
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The dimension keys that were requested.</p>
        pub fn keys(mut self, input: impl Into<crate::model::DimensionKeyDescription>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>The dimension keys that were requested.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionKeyDescription>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If
        /// this parameter is specified, the response includes only records beyond the token, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDimensionKeysOutput`](crate::output::DescribeDimensionKeysOutput)
        pub fn build(self) -> crate::output::DescribeDimensionKeysOutput {
            crate::output::DescribeDimensionKeysOutput {
                aligned_start_time: self.aligned_start_time,
                aligned_end_time: self.aligned_end_time,
                partition_keys: self.partition_keys,
                keys: self.keys,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDimensionKeysOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDimensionKeysOutput`](crate::output::DescribeDimensionKeysOutput)
    pub fn builder() -> crate::output::describe_dimension_keys_output::Builder {
        crate::output::describe_dimension_keys_output::Builder::default()
    }
}
