// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A time-ordered series of data points, corresponding to a dimension of a Performance Insights
/// metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricKeyDataPoints {
    /// <p>The dimension(s) to which the data points apply.</p>
    pub key: std::option::Option<crate::model::ResponseResourceMetricKey>,
    /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
    pub data_points: std::option::Option<std::vec::Vec<crate::model::DataPoint>>,
}
impl std::fmt::Debug for MetricKeyDataPoints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricKeyDataPoints");
        formatter.field("key", &self.key);
        formatter.field("data_points", &self.data_points);
        formatter.finish()
    }
}
/// See [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
pub mod metric_key_data_points {
    /// A builder for [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::ResponseResourceMetricKey>,
        pub(crate) data_points: std::option::Option<std::vec::Vec<crate::model::DataPoint>>,
    }
    impl Builder {
        /// <p>The dimension(s) to which the data points apply.</p>
        pub fn key(mut self, input: crate::model::ResponseResourceMetricKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The dimension(s) to which the data points apply.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::ResponseResourceMetricKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `data_points`.
        ///
        /// To override the contents of this collection use [`set_data_points`](Self::set_data_points).
        ///
        /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
        pub fn data_points(mut self, input: impl Into<crate::model::DataPoint>) -> Self {
            let mut v = self.data_points.unwrap_or_default();
            v.push(input.into());
            self.data_points = Some(v);
            self
        }
        /// <p>An array of timestamp-value pairs, representing measurements over a period of time.</p>
        pub fn set_data_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataPoint>>,
        ) -> Self {
            self.data_points = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
        pub fn build(self) -> crate::model::MetricKeyDataPoints {
            crate::model::MetricKeyDataPoints {
                key: self.key,
                data_points: self.data_points,
            }
        }
    }
}
impl MetricKeyDataPoints {
    /// Creates a new builder-style object to manufacture [`MetricKeyDataPoints`](crate::model::MetricKeyDataPoints)
    pub fn builder() -> crate::model::metric_key_data_points::Builder {
        crate::model::metric_key_data_points::Builder::default()
    }
}

/// <p>A timestamp, and a single numerical value, which together represent a measurement at a particular point in time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataPoint {
    /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
    pub value: std::option::Option<f64>,
}
impl std::fmt::Debug for DataPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataPoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DataPoint`](crate::model::DataPoint)
pub mod data_point {
    /// A builder for [`DataPoint`](crate::model::DataPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time, in epoch format, associated with a particular <code>Value</code>.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The actual value associated with a particular <code>Timestamp</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DataPoint`](crate::model::DataPoint)
        pub fn build(self) -> crate::model::DataPoint {
            crate::model::DataPoint {
                timestamp: self.timestamp,
                value: self.value,
            }
        }
    }
}
impl DataPoint {
    /// Creates a new builder-style object to manufacture [`DataPoint`](crate::model::DataPoint)
    pub fn builder() -> crate::model::data_point::Builder {
        crate::model::data_point::Builder::default()
    }
}

/// <p>An object describing a Performance Insights metric and one or more dimensions for that metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseResourceMetricKey {
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
    /// for the database engine.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
    /// database engine.</p>
    /// </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
    /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
    /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
    /// For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The valid dimensions for the metric.</p>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ResponseResourceMetricKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseResourceMetricKey");
        formatter.field("metric", &self.metric);
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
pub mod response_resource_metric_key {
    /// A builder for [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
        /// for the database engine.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
        /// database engine.</p>
        /// </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
        /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
        /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
        /// For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
        /// for the database engine.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
        /// database engine.</p>
        /// </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
        /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
        /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
        /// For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The valid dimensions for the metric.</p>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>The valid dimensions for the metric.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
        pub fn build(self) -> crate::model::ResponseResourceMetricKey {
            crate::model::ResponseResourceMetricKey {
                metric: self.metric,
                dimensions: self.dimensions,
            }
        }
    }
}
impl ResponseResourceMetricKey {
    /// Creates a new builder-style object to manufacture [`ResponseResourceMetricKey`](crate::model::ResponseResourceMetricKey)
    pub fn builder() -> crate::model::response_resource_metric_key::Builder {
        crate::model::response_resource_metric_key::Builder::default()
    }
}

/// <p>A single query to be processed. You must provide the metric to query. If no other
/// parameters are specified, Performance Insights returns all of the data points for that metric. You can
/// optionally request that the data points be aggregated by dimension group (
/// <code>GroupBy</code>), and return only those data points that match your criteria (<code>Filter</code>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricQuery {
    /// <p>The name of a Performance Insights metric to be measured.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
    /// for the database engine.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
    /// database engine.</p>
    /// </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
    /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
    /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
    /// For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>A specification for how to aggregate the data points from a query result. You must
    /// specify a valid dimension group.  Performance Insights will return all of the dimensions within that group,
    /// unless you provide the names of specific dimensions within that group. You can also request
    /// that Performance Insights return a limited number of values for a dimension.</p>
    pub group_by: std::option::Option<crate::model::DimensionGroup>,
    /// <p>One or more filters to apply in the request.  Restrictions:</p>
    /// <ul>
    /// <li>
    /// <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p>
    /// </li>
    /// <li>
    /// <p>A single filter for any other dimension in this dimension group.</p>
    /// </li>
    /// </ul>
    pub filter:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for MetricQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricQuery");
        formatter.field("metric", &self.metric);
        formatter.field("group_by", &self.group_by);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`MetricQuery`](crate::model::MetricQuery)
pub mod metric_query {
    /// A builder for [`MetricQuery`](crate::model::MetricQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) group_by: std::option::Option<crate::model::DimensionGroup>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
        /// for the database engine.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
        /// database engine.</p>
        /// </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
        /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
        /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
        /// For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The name of a Performance Insights metric to be measured.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.load.avg</code> - a scaled representation of the number of active sessions
        /// for the database engine.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sampledload.avg</code> - the raw number of active sessions for the
        /// database engine.</p>
        /// </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code>
        /// are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code>
        /// showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>.
        /// For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must
        /// specify a valid dimension group.  Performance Insights will return all of the dimensions within that group,
        /// unless you provide the names of specific dimensions within that group. You can also request
        /// that Performance Insights return a limited number of values for a dimension.</p>
        pub fn group_by(mut self, input: crate::model::DimensionGroup) -> Self {
            self.group_by = Some(input);
            self
        }
        /// <p>A specification for how to aggregate the data points from a query result. You must
        /// specify a valid dimension group.  Performance Insights will return all of the dimensions within that group,
        /// unless you provide the names of specific dimensions within that group. You can also request
        /// that Performance Insights return a limited number of values for a dimension.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<crate::model::DimensionGroup>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>One or more filters to apply in the request.  Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p>
        /// </li>
        /// <li>
        /// <p>A single filter for any other dimension in this dimension group.</p>
        /// </li>
        /// </ul>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.filter = Some(hash_map);
            self
        }
        /// <p>One or more filters to apply in the request.  Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p>
        /// </li>
        /// <li>
        /// <p>A single filter for any other dimension in this dimension group.</p>
        /// </li>
        /// </ul>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricQuery`](crate::model::MetricQuery)
        pub fn build(self) -> crate::model::MetricQuery {
            crate::model::MetricQuery {
                metric: self.metric,
                group_by: self.group_by,
                filter: self.filter,
            }
        }
    }
}
impl MetricQuery {
    /// Creates a new builder-style object to manufacture [`MetricQuery`](crate::model::MetricQuery)
    pub fn builder() -> crate::model::metric_query::Builder {
        crate::model::metric_query::Builder::default()
    }
}

/// <p>A logical grouping of Performance Insights metrics for a related subject area. For example, the
/// <code>db.sql</code> dimension group consists of the following dimensions:
/// <code>db.sql.id</code>, <code>db.sql.db_id</code>, <code>db.sql.statement</code>, and
/// <code>db.sql.tokenized_id</code>.</p>
/// <note>
/// <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
/// only the first 500 bytes are returned.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionGroup {
    /// <p>The name of the dimension group.  Valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, RDS
    /// PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.application</code> - The name of the application that is connected to the database (only Aurora
    /// PostgreSQL and RDS PostgreSQL)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.host</code> - The host name of the connected client (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql</code> - The SQL that is currently executing (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql_tokenized</code> - The SQL digest (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.wait_event</code> - The event for which the database backend is waiting  (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.user</code> - The user logged in to the database (all engines)</p>
    /// </li>
    /// </ul>
    pub group: std::option::Option<std::string::String>,
    /// <p>A list of specific dimensions from a dimension group. If this parameter is not present,
    /// then it signifies that all of the dimensions in the group were requested, or are present in
    /// the response.</p>
    /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db.application.name</code> - The name of the application that is connected to the database (only
    /// Aurora PostgreSQL and RDS PostgreSQL)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.host.id</code> - The host ID of the connected client (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.host.name</code> - The host name of the connected client (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.name</code> - The name of the database to which the client is connected (only Aurora
    /// PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql.tokenized_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
    /// engines)</p>
    /// </li>
    /// </ul>
    pub dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to fetch for this dimension group.</p>
    pub limit: std::option::Option<i32>,
}
impl std::fmt::Debug for DimensionGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionGroup");
        formatter.field("group", &self.group);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
/// See [`DimensionGroup`](crate::model::DimensionGroup)
pub mod dimension_group {
    /// A builder for [`DimensionGroup`](crate::model::DimensionGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the dimension group.  Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, RDS
        /// PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.application</code> - The name of the application that is connected to the database (only Aurora
        /// PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.host</code> - The host name of the connected client (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql</code> - The SQL that is currently executing (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized</code> - The SQL digest (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event</code> - The event for which the database backend is waiting  (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.user</code> - The user logged in to the database (all engines)</p>
        /// </li>
        /// </ul>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the dimension group.  Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, RDS
        /// PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.application</code> - The name of the application that is connected to the database (only Aurora
        /// PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.host</code> - The host name of the connected client (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql</code> - The SQL that is currently executing (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized</code> - The SQL digest (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event</code> - The event for which the database backend is waiting  (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.user</code> - The user logged in to the database (all engines)</p>
        /// </li>
        /// </ul>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A list of specific dimensions from a dimension group. If this parameter is not present,
        /// then it signifies that all of the dimensions in the group were requested, or are present in
        /// the response.</p>
        /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.application.name</code> - The name of the application that is connected to the database (only
        /// Aurora PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.host.id</code> - The host ID of the connected client (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.host.name</code> - The host name of the connected client (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.name</code> - The name of the database to which the client is connected (only Aurora
        /// PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.tokenized_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
        /// engines)</p>
        /// </li>
        /// </ul>
        pub fn dimensions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>A list of specific dimensions from a dimension group. If this parameter is not present,
        /// then it signifies that all of the dimensions in the group were requested, or are present in
        /// the response.</p>
        /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db.application.name</code> - The name of the application that is connected to the database (only
        /// Aurora PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.host.id</code> - The host ID of the connected client (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.host.name</code> - The host name of the connected client (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.name</code> - The name of the database to which the client is connected (only Aurora
        /// PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql.tokenized_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
        /// engines)</p>
        /// </li>
        /// </ul>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The maximum number of items to fetch for this dimension group.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to fetch for this dimension group.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionGroup`](crate::model::DimensionGroup)
        pub fn build(self) -> crate::model::DimensionGroup {
            crate::model::DimensionGroup {
                group: self.group,
                dimensions: self.dimensions,
                limit: self.limit,
            }
        }
    }
}
impl DimensionGroup {
    /// Creates a new builder-style object to manufacture [`DimensionGroup`](crate::model::DimensionGroup)
    pub fn builder() -> crate::model::dimension_group::Builder {
        crate::model::dimension_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceType {
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceType {
    fn from(s: &str) -> Self {
        match s {
            "RDS" => ServiceType::Rds,
            other => ServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceType::from(s))
    }
}
impl ServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceType::Rds => "RDS",
            ServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RDS"]
    }
}
impl AsRef<str> for ServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that describes the details for a specified dimension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionKeyDetail {
    /// <p>The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is either the
    /// full or truncated SQL query, depending on the return status.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The full name of the dimension. The full name includes the group name and key name. The only valid value is
    /// <code>db.sql.statement</code>. </p>
    pub dimension: std::option::Option<std::string::String>,
    /// <p>The status of the dimension detail data. Possible values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is
    /// required. If the requested detail data for <code>db.sql.statement</code> has the status <code>PROCESSING</code>,
    /// Performance Insights returns the truncated query.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DetailStatus>,
}
impl std::fmt::Debug for DimensionKeyDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionKeyDetail");
        formatter.field("value", &self.value);
        formatter.field("dimension", &self.dimension);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
pub mod dimension_key_detail {
    /// A builder for [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) dimension: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DetailStatus>,
    }
    impl Builder {
        /// <p>The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is either the
        /// full or truncated SQL query, depending on the return status.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is either the
        /// full or truncated SQL query, depending on the return status.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The full name of the dimension. The full name includes the group name and key name. The only valid value is
        /// <code>db.sql.statement</code>. </p>
        pub fn dimension(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension = Some(input.into());
            self
        }
        /// <p>The full name of the dimension. The full name includes the group name and key name. The only valid value is
        /// <code>db.sql.statement</code>. </p>
        pub fn set_dimension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dimension = input;
            self
        }
        /// <p>The status of the dimension detail data. Possible values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is
        /// required. If the requested detail data for <code>db.sql.statement</code> has the status <code>PROCESSING</code>,
        /// Performance Insights returns the truncated query.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DetailStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the dimension detail data. Possible values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is
        /// required. If the requested detail data for <code>db.sql.statement</code> has the status <code>PROCESSING</code>,
        /// Performance Insights returns the truncated query.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetailStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
        pub fn build(self) -> crate::model::DimensionKeyDetail {
            crate::model::DimensionKeyDetail {
                value: self.value,
                dimension: self.dimension,
                status: self.status,
            }
        }
    }
}
impl DimensionKeyDetail {
    /// Creates a new builder-style object to manufacture [`DimensionKeyDetail`](crate::model::DimensionKeyDetail)
    pub fn builder() -> crate::model::dimension_key_detail::Builder {
        crate::model::dimension_key_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetailStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetailStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DetailStatus::Available,
            "PROCESSING" => DetailStatus::Processing,
            "UNAVAILABLE" => DetailStatus::Unavailable,
            other => DetailStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetailStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetailStatus::from(s))
    }
}
impl DetailStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetailStatus::Available => "AVAILABLE",
            DetailStatus::Processing => "PROCESSING",
            DetailStatus::Unavailable => "UNAVAILABLE",
            DetailStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "PROCESSING", "UNAVAILABLE"]
    }
}
impl AsRef<str> for DetailStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An array of descriptions and aggregated values for
/// each dimension within a dimension group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionKeyDescription {
    /// <p>A map of name-value pairs for the dimensions in the group.</p>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The aggregated metric value for the dimension(s), over the requested time range.</p>
    pub total: std::option::Option<f64>,
    /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
    pub partitions: std::option::Option<std::vec::Vec<f64>>,
}
impl std::fmt::Debug for DimensionKeyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionKeyDescription");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("total", &self.total);
        formatter.field("partitions", &self.partitions);
        formatter.finish()
    }
}
/// See [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
pub mod dimension_key_description {
    /// A builder for [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) total: std::option::Option<f64>,
        pub(crate) partitions: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A map of name-value pairs for the dimensions in the group.</p>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>A map of name-value pairs for the dimensions in the group.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The aggregated metric value for the dimension(s), over the requested time range.</p>
        pub fn total(mut self, input: f64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The aggregated metric value for the dimension(s), over the requested time range.</p>
        pub fn set_total(mut self, input: std::option::Option<f64>) -> Self {
            self.total = input;
            self
        }
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
        pub fn partitions(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input.into());
            self.partitions = Some(v);
            self
        }
        /// <p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>
        pub fn set_partitions(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
        pub fn build(self) -> crate::model::DimensionKeyDescription {
            crate::model::DimensionKeyDescription {
                dimensions: self.dimensions,
                total: self.total,
                partitions: self.partitions,
            }
        }
    }
}
impl DimensionKeyDescription {
    /// Creates a new builder-style object to manufacture [`DimensionKeyDescription`](crate::model::DimensionKeyDescription)
    pub fn builder() -> crate::model::dimension_key_description::Builder {
        crate::model::dimension_key_description::Builder::default()
    }
}

/// <p>If <code>PartitionBy</code> was specified in a <code>DescribeDimensionKeys</code>
/// request, the dimensions are returned in an array. Each element in the array specifies one
/// dimension. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponsePartitionKey {
    /// <p>A dimension map that contains the dimension(s) for this partition.</p>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ResponsePartitionKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponsePartitionKey");
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
pub mod response_partition_key {
    /// A builder for [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A dimension map that contains the dimension(s) for this partition.</p>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>A dimension map that contains the dimension(s) for this partition.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
        pub fn build(self) -> crate::model::ResponsePartitionKey {
            crate::model::ResponsePartitionKey {
                dimensions: self.dimensions,
            }
        }
    }
}
impl ResponsePartitionKey {
    /// Creates a new builder-style object to manufacture [`ResponsePartitionKey`](crate::model::ResponsePartitionKey)
    pub fn builder() -> crate::model::response_partition_key::Builder {
        crate::model::response_partition_key::Builder::default()
    }
}
