// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object that identifies an item.</p>
/// <p>The  and  APIs return a list of
/// <code>PredictedItem</code>s.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictedItem {
    /// <p>The recommended item ID.</p>
    pub item_id: std::option::Option<std::string::String>,
    /// <p>A numeric representation of the model's certainty that the item will be the next user
    /// selection. For more information on scoring logic, see <a>how-scores-work</a>.</p>
    pub score: std::option::Option<f64>,
}
impl std::fmt::Debug for PredictedItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictedItem");
        formatter.field("item_id", &self.item_id);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`PredictedItem`](crate::model::PredictedItem)
pub mod predicted_item {
    /// A builder for [`PredictedItem`](crate::model::PredictedItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item_id: std::option::Option<std::string::String>,
        pub(crate) score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The recommended item ID.</p>
        pub fn item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.item_id = Some(input.into());
            self
        }
        /// <p>The recommended item ID.</p>
        pub fn set_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.item_id = input;
            self
        }
        /// <p>A numeric representation of the model's certainty that the item will be the next user
        /// selection. For more information on scoring logic, see <a>how-scores-work</a>.</p>
        pub fn score(mut self, input: f64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>A numeric representation of the model's certainty that the item will be the next user
        /// selection. For more information on scoring logic, see <a>how-scores-work</a>.</p>
        pub fn set_score(mut self, input: std::option::Option<f64>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictedItem`](crate::model::PredictedItem)
        pub fn build(self) -> crate::model::PredictedItem {
            crate::model::PredictedItem {
                item_id: self.item_id,
                score: self.score,
            }
        }
    }
}
impl PredictedItem {
    /// Creates a new builder-style object to manufacture [`PredictedItem`](crate::model::PredictedItem)
    pub fn builder() -> crate::model::predicted_item::Builder {
        crate::model::predicted_item::Builder::default()
    }
}
