// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The configuration details of the recommender.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommenderConfig {
    /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).</p>
    pub item_exploration_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support.</p>
    pub min_recommendation_requests_per_second: std::option::Option<i32>,
}
impl RecommenderConfig {
    /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).</p>
    pub fn item_exploration_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.item_exploration_config.as_ref()
    }
    /// <p>Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support.</p>
    pub fn min_recommendation_requests_per_second(&self) -> std::option::Option<i32> {
        self.min_recommendation_requests_per_second
    }
}
impl std::fmt::Debug for RecommenderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommenderConfig");
        formatter.field("item_exploration_config", &self.item_exploration_config);
        formatter.field(
            "min_recommendation_requests_per_second",
            &self.min_recommendation_requests_per_second,
        );
        formatter.finish()
    }
}
/// See [`RecommenderConfig`](crate::model::RecommenderConfig)
pub mod recommender_config {
    /// A builder for [`RecommenderConfig`](crate::model::RecommenderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item_exploration_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) min_recommendation_requests_per_second: std::option::Option<i32>,
    }
    impl Builder {
        /// Adds a key-value pair to `item_exploration_config`.
        ///
        /// To override the contents of this collection use [`set_item_exploration_config`](Self::set_item_exploration_config).
        ///
        /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).</p>
        pub fn item_exploration_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.item_exploration_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item_exploration_config = Some(hash_map);
            self
        }
        /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).</p>
        pub fn set_item_exploration_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.item_exploration_config = input;
            self
        }
        /// <p>Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support.</p>
        pub fn min_recommendation_requests_per_second(mut self, input: i32) -> Self {
            self.min_recommendation_requests_per_second = Some(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support.</p>
        pub fn set_min_recommendation_requests_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.min_recommendation_requests_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommenderConfig`](crate::model::RecommenderConfig)
        pub fn build(self) -> crate::model::RecommenderConfig {
            crate::model::RecommenderConfig {
                item_exploration_config: self.item_exploration_config,
                min_recommendation_requests_per_second: self.min_recommendation_requests_per_second,
            }
        }
    }
}
impl RecommenderConfig {
    /// Creates a new builder-style object to manufacture [`RecommenderConfig`](crate::model::RecommenderConfig)
    pub fn builder() -> crate::model::recommender_config::Builder {
        crate::model::recommender_config::Builder::default()
    }
}

/// <p>The configuration details of a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignConfig {
    /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your solution uses the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe.</p>
    pub item_exploration_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CampaignConfig {
    /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your solution uses the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe.</p>
    pub fn item_exploration_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.item_exploration_config.as_ref()
    }
}
impl std::fmt::Debug for CampaignConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignConfig");
        formatter.field("item_exploration_config", &self.item_exploration_config);
        formatter.finish()
    }
}
/// See [`CampaignConfig`](crate::model::CampaignConfig)
pub mod campaign_config {
    /// A builder for [`CampaignConfig`](crate::model::CampaignConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item_exploration_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `item_exploration_config`.
        ///
        /// To override the contents of this collection use [`set_item_exploration_config`](Self::set_item_exploration_config).
        ///
        /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your solution uses the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe.</p>
        pub fn item_exploration_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.item_exploration_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item_exploration_config = Some(hash_map);
            self
        }
        /// <p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your solution uses the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe.</p>
        pub fn set_item_exploration_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.item_exploration_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignConfig`](crate::model::CampaignConfig)
        pub fn build(self) -> crate::model::CampaignConfig {
            crate::model::CampaignConfig {
                item_exploration_config: self.item_exploration_config,
            }
        }
    }
}
impl CampaignConfig {
    /// Creates a new builder-style object to manufacture [`CampaignConfig`](crate::model::CampaignConfig)
    pub fn builder() -> crate::model::campaign_config::Builder {
        crate::model::campaign_config::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a solution version. For a complete listing, call the <code>DescribeSolutionVersion</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SolutionVersionSummary {
    /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The status of the solution version.</p>
    /// <p>A solution version can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that this version of a solution was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the solution version was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If a solution version fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl SolutionVersionSummary {
    /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The status of the solution version.</p>
    /// <p>A solution version can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that this version of a solution was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the solution version was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If a solution version fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for SolutionVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SolutionVersionSummary");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`SolutionVersionSummary`](crate::model::SolutionVersionSummary)
pub mod solution_version_summary {
    /// A builder for [`SolutionVersionSummary`](crate::model::SolutionVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>The status of the solution version.</p>
        /// <p>A solution version can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the solution version.</p>
        /// <p>A solution version can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that this version of a solution was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that this version of a solution was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the solution version was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the solution version was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If a solution version fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a solution version fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`SolutionVersionSummary`](crate::model::SolutionVersionSummary)
        pub fn build(self) -> crate::model::SolutionVersionSummary {
            crate::model::SolutionVersionSummary {
                solution_version_arn: self.solution_version_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl SolutionVersionSummary {
    /// Creates a new builder-style object to manufacture [`SolutionVersionSummary`](crate::model::SolutionVersionSummary)
    pub fn builder() -> crate::model::solution_version_summary::Builder {
        crate::model::solution_version_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a solution. For a complete listing, call the <code>DescribeSolution</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SolutionSummary {
    /// <p>The name of the solution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the solution.</p>
    pub solution_arn: std::option::Option<std::string::String>,
    /// <p>The status of the solution.</p>
    /// <p>A solution can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the solution was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the solution was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SolutionSummary {
    /// <p>The name of the solution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the solution.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
    /// <p>The status of the solution.</p>
    /// <p>A solution can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the solution was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the solution was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for SolutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SolutionSummary");
        formatter.field("name", &self.name);
        formatter.field("solution_arn", &self.solution_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`SolutionSummary`](crate::model::SolutionSummary)
pub mod solution_summary {
    /// A builder for [`SolutionSummary`](crate::model::SolutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) solution_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the solution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the solution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// <p>The status of the solution.</p>
        /// <p>A solution can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the solution.</p>
        /// <p>A solution can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the solution was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the solution was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the solution was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the solution was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SolutionSummary`](crate::model::SolutionSummary)
        pub fn build(self) -> crate::model::SolutionSummary {
            crate::model::SolutionSummary {
                name: self.name,
                solution_arn: self.solution_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl SolutionSummary {
    /// Creates a new builder-style object to manufacture [`SolutionSummary`](crate::model::SolutionSummary)
    pub fn builder() -> crate::model::solution_summary::Builder {
        crate::model::solution_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a dataset schema. For a complete listing, call the <code>DescribeSchema</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetSchemaSummary {
    /// <p>The name of the schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the schema was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the schema was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl DatasetSchemaSummary {
    /// <p>The name of the schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The date and time (in Unix time) that the schema was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the schema was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for DatasetSchemaSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetSchemaSummary");
        formatter.field("name", &self.name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DatasetSchemaSummary`](crate::model::DatasetSchemaSummary)
pub mod dataset_schema_summary {
    /// A builder for [`DatasetSchemaSummary`](crate::model::DatasetSchemaSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>The name of the schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The date and time (in Unix time) that the schema was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the schema was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the schema was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the schema was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetSchemaSummary`](crate::model::DatasetSchemaSummary)
        pub fn build(self) -> crate::model::DatasetSchemaSummary {
            crate::model::DatasetSchemaSummary {
                name: self.name,
                schema_arn: self.schema_arn,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                domain: self.domain,
            }
        }
    }
}
impl DatasetSchemaSummary {
    /// Creates a new builder-style object to manufacture [`DatasetSchemaSummary`](crate::model::DatasetSchemaSummary)
    pub fn builder() -> crate::model::dataset_schema_summary::Builder {
        crate::model::dataset_schema_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Domain {
    #[allow(missing_docs)] // documentation missing in model
    Ecommerce,
    #[allow(missing_docs)] // documentation missing in model
    VideoOnDemand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Domain {
    fn from(s: &str) -> Self {
        match s {
            "ECOMMERCE" => Domain::Ecommerce,
            "VIDEO_ON_DEMAND" => Domain::VideoOnDemand,
            other => Domain::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Domain {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Domain::from(s))
    }
}
impl Domain {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Domain::Ecommerce => "ECOMMERCE",
            Domain::VideoOnDemand => "VIDEO_ON_DEMAND",
            Domain::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ECOMMERCE", "VIDEO_ON_DEMAND"]
    }
}
impl AsRef<str> for Domain {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a summary of the properties of the recommender.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommenderSummary {
    /// <p>The name of the recommender.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
    pub recommender_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The configuration details of the recommender.</p>
    pub recommender_config: std::option::Option<crate::model::RecommenderConfig>,
    /// <p>The status of the recommender. A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix format) that the recommender was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RecommenderSummary {
    /// <p>The name of the recommender.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
    pub fn recommender_arn(&self) -> std::option::Option<&str> {
        self.recommender_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The configuration details of the recommender.</p>
    pub fn recommender_config(&self) -> std::option::Option<&crate::model::RecommenderConfig> {
        self.recommender_config.as_ref()
    }
    /// <p>The status of the recommender. A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix format) that the recommender was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for RecommenderSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommenderSummary");
        formatter.field("name", &self.name);
        formatter.field("recommender_arn", &self.recommender_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("recommender_config", &self.recommender_config);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`RecommenderSummary`](crate::model::RecommenderSummary)
pub mod recommender_summary {
    /// A builder for [`RecommenderSummary`](crate::model::RecommenderSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recommender_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) recommender_config: std::option::Option<crate::model::RecommenderConfig>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the recommender.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recommender.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
        pub fn recommender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn recommender_config(mut self, input: crate::model::RecommenderConfig) -> Self {
            self.recommender_config = Some(input);
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn set_recommender_config(
            mut self,
            input: std::option::Option<crate::model::RecommenderConfig>,
        ) -> Self {
            self.recommender_config = input;
            self
        }
        /// <p>The status of the recommender. A recommender can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the recommender. A recommender can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommenderSummary`](crate::model::RecommenderSummary)
        pub fn build(self) -> crate::model::RecommenderSummary {
            crate::model::RecommenderSummary {
                name: self.name,
                recommender_arn: self.recommender_arn,
                dataset_group_arn: self.dataset_group_arn,
                recipe_arn: self.recipe_arn,
                recommender_config: self.recommender_config,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl RecommenderSummary {
    /// Creates a new builder-style object to manufacture [`RecommenderSummary`](crate::model::RecommenderSummary)
    pub fn builder() -> crate::model::recommender_summary::Builder {
        crate::model::recommender_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a recipe. For a complete listing, call the <code>DescribeRecipe</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipeSummary {
    /// <p>The name of the recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The status of the recipe.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the recipe was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the recipe was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The domain of the recipe (if the recipe is a Domain dataset group use case).</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl RecipeSummary {
    /// <p>The name of the recipe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The status of the recipe.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the recipe was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the recipe was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The domain of the recipe (if the recipe is a Domain dataset group use case).</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for RecipeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipeSummary");
        formatter.field("name", &self.name);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`RecipeSummary`](crate::model::RecipeSummary)
pub mod recipe_summary {
    /// A builder for [`RecipeSummary`](crate::model::RecipeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The status of the recipe.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the recipe.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the recipe was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the recipe was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the recipe was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the recipe was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The domain of the recipe (if the recipe is a Domain dataset group use case).</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain of the recipe (if the recipe is a Domain dataset group use case).</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipeSummary`](crate::model::RecipeSummary)
        pub fn build(self) -> crate::model::RecipeSummary {
            crate::model::RecipeSummary {
                name: self.name,
                recipe_arn: self.recipe_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                domain: self.domain,
            }
        }
    }
}
impl RecipeSummary {
    /// Creates a new builder-style object to manufacture [`RecipeSummary`](crate::model::RecipeSummary)
    pub fn builder() -> crate::model::recipe_summary::Builder {
        crate::model::recipe_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecipeProvider {
    #[allow(missing_docs)] // documentation missing in model
    Service,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecipeProvider {
    fn from(s: &str) -> Self {
        match s {
            "SERVICE" => RecipeProvider::Service,
            other => RecipeProvider::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecipeProvider {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecipeProvider::from(s))
    }
}
impl RecipeProvider {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecipeProvider::Service => "SERVICE",
            RecipeProvider::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SERVICE"]
    }
}
impl AsRef<str> for RecipeProvider {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A short summary of a filter's attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterSummary {
    /// <p>The name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the filter.</p>
    pub filter_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the filter was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the filter was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ARN of the dataset group to which the filter belongs.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>If the filter failed, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The status of the filter.</p>
    pub status: std::option::Option<std::string::String>,
}
impl FilterSummary {
    /// <p>The name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the filter.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
    /// <p>The time at which the filter was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The time at which the filter was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The ARN of the dataset group to which the filter belongs.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>If the filter failed, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The status of the filter.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for FilterSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterSummary");
        formatter.field("name", &self.name);
        formatter.field("filter_arn", &self.filter_arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`FilterSummary`](crate::model::FilterSummary)
pub mod filter_summary {
    /// A builder for [`FilterSummary`](crate::model::FilterSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filter_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the filter.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// <p>The time at which the filter was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time at which the filter was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time at which the filter was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The time at which the filter was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The ARN of the dataset group to which the filter belongs.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group to which the filter belongs.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>If the filter failed, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the filter failed, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The status of the filter.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the filter.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterSummary`](crate::model::FilterSummary)
        pub fn build(self) -> crate::model::FilterSummary {
            crate::model::FilterSummary {
                name: self.name,
                filter_arn: self.filter_arn,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                dataset_group_arn: self.dataset_group_arn,
                failure_reason: self.failure_reason,
                status: self.status,
            }
        }
    }
}
impl FilterSummary {
    /// Creates a new builder-style object to manufacture [`FilterSummary`](crate::model::FilterSummary)
    pub fn builder() -> crate::model::filter_summary::Builder {
        crate::model::filter_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of an event tracker. For a complete listing, call the <code>DescribeEventTracker</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTrackerSummary {
    /// <p>The name of the event tracker.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the event tracker.</p>
    pub event_tracker_arn: std::option::Option<std::string::String>,
    /// <p>The status of the event tracker.</p>
    /// <p>An event tracker can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the event tracker was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EventTrackerSummary {
    /// <p>The name of the event tracker.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the event tracker.</p>
    pub fn event_tracker_arn(&self) -> std::option::Option<&str> {
        self.event_tracker_arn.as_deref()
    }
    /// <p>The status of the event tracker.</p>
    /// <p>An event tracker can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the event tracker was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for EventTrackerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTrackerSummary");
        formatter.field("name", &self.name);
        formatter.field("event_tracker_arn", &self.event_tracker_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`EventTrackerSummary`](crate::model::EventTrackerSummary)
pub mod event_tracker_summary {
    /// A builder for [`EventTrackerSummary`](crate::model::EventTrackerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_tracker_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the event tracker.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event tracker.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker.</p>
        pub fn event_tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_tracker_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_tracker_arn = input;
            self
        }
        /// <p>The status of the event tracker.</p>
        /// <p>An event tracker can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the event tracker.</p>
        /// <p>An event tracker can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the event tracker was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the event tracker was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTrackerSummary`](crate::model::EventTrackerSummary)
        pub fn build(self) -> crate::model::EventTrackerSummary {
            crate::model::EventTrackerSummary {
                name: self.name,
                event_tracker_arn: self.event_tracker_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl EventTrackerSummary {
    /// Creates a new builder-style object to manufacture [`EventTrackerSummary`](crate::model::EventTrackerSummary)
    pub fn builder() -> crate::model::event_tracker_summary::Builder {
        crate::model::event_tracker_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a dataset. For a complete listing, call the <code>DescribeDataset</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetSummary {
    /// <p>The name of the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The dataset type. One of the following values:</p>
    /// <ul>
    /// <li> <p>Interactions</p> </li>
    /// <li> <p>Items</p> </li>
    /// <li> <p>Users</p> </li>
    /// <li> <p>Event-Interactions</p> </li>
    /// </ul>
    pub dataset_type: std::option::Option<std::string::String>,
    /// <p>The status of the dataset.</p>
    /// <p>A dataset can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the dataset was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the dataset was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DatasetSummary {
    /// <p>The name of the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The dataset type. One of the following values:</p>
    /// <ul>
    /// <li> <p>Interactions</p> </li>
    /// <li> <p>Items</p> </li>
    /// <li> <p>Users</p> </li>
    /// <li> <p>Event-Interactions</p> </li>
    /// </ul>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
    /// <p>The status of the dataset.</p>
    /// <p>A dataset can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the dataset was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the dataset was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DatasetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetSummary");
        formatter.field("name", &self.name);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DatasetSummary`](crate::model::DatasetSummary)
pub mod dataset_summary {
    /// A builder for [`DatasetSummary`](crate::model::DatasetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The dataset type. One of the following values:</p>
        /// <ul>
        /// <li> <p>Interactions</p> </li>
        /// <li> <p>Items</p> </li>
        /// <li> <p>Users</p> </li>
        /// <li> <p>Event-Interactions</p> </li>
        /// </ul>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The dataset type. One of the following values:</p>
        /// <ul>
        /// <li> <p>Interactions</p> </li>
        /// <li> <p>Items</p> </li>
        /// <li> <p>Users</p> </li>
        /// <li> <p>Event-Interactions</p> </li>
        /// </ul>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>The status of the dataset.</p>
        /// <p>A dataset can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset.</p>
        /// <p>A dataset can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetSummary`](crate::model::DatasetSummary)
        pub fn build(self) -> crate::model::DatasetSummary {
            crate::model::DatasetSummary {
                name: self.name,
                dataset_arn: self.dataset_arn,
                dataset_type: self.dataset_type,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DatasetSummary {
    /// Creates a new builder-style object to manufacture [`DatasetSummary`](crate::model::DatasetSummary)
    pub fn builder() -> crate::model::dataset_summary::Builder {
        crate::model::dataset_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a dataset import job. For a complete listing, call the <code>DescribeDatasetImportJob</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetImportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset import job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The status of the dataset import job.</p>
    /// <p>A dataset import job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the dataset import job was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the dataset import job status was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If a dataset import job fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl DatasetImportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
    /// <p>The name of the dataset import job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The status of the dataset import job.</p>
    /// <p>A dataset import job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the dataset import job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the dataset import job status was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If a dataset import job fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for DatasetImportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetImportJobSummary");
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
pub mod dataset_import_job_summary {
    /// A builder for [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// <p>The name of the dataset import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The status of the dataset import job.</p>
        /// <p>A dataset import job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset import job.</p>
        /// <p>A dataset import job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset import job was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset import job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset import job status was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset import job status was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If a dataset import job fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a dataset import job fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
        pub fn build(self) -> crate::model::DatasetImportJobSummary {
            crate::model::DatasetImportJobSummary {
                dataset_import_job_arn: self.dataset_import_job_arn,
                job_name: self.job_name,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl DatasetImportJobSummary {
    /// Creates a new builder-style object to manufacture [`DatasetImportJobSummary`](crate::model::DatasetImportJobSummary)
    pub fn builder() -> crate::model::dataset_import_job_summary::Builder {
        crate::model::dataset_import_job_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a dataset group. For a complete listing, call the <code>DescribeDatasetGroup</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetGroupSummary {
    /// <p>The name of the dataset group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The status of the dataset group.</p>
    /// <p>A dataset group can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the dataset group was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the dataset group was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If creating a dataset group fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The domain of a Domain dataset group.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl DatasetGroupSummary {
    /// <p>The name of the dataset group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The status of the dataset group.</p>
    /// <p>A dataset group can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the dataset group was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the dataset group was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If creating a dataset group fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The domain of a Domain dataset group.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for DatasetGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetGroupSummary");
        formatter.field("name", &self.name);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
pub mod dataset_group_summary {
    /// A builder for [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>The name of the dataset group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The status of the dataset group.</p>
        /// <p>A dataset group can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset group.</p>
        /// <p>A dataset group can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset group was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset group was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset group was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset group was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If creating a dataset group fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If creating a dataset group fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The domain of a Domain dataset group.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain of a Domain dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
        pub fn build(self) -> crate::model::DatasetGroupSummary {
            crate::model::DatasetGroupSummary {
                name: self.name,
                dataset_group_arn: self.dataset_group_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
                domain: self.domain,
            }
        }
    }
}
impl DatasetGroupSummary {
    /// Creates a new builder-style object to manufacture [`DatasetGroupSummary`](crate::model::DatasetGroupSummary)
    pub fn builder() -> crate::model::dataset_group_summary::Builder {
        crate::model::dataset_group_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a dataset export job. For a complete listing, call the <code>DescribeDatasetExportJob</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
    pub dataset_export_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset export job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The status of the dataset export job.</p>
    /// <p>A dataset export job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the dataset export job was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the dataset export job status was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If a dataset export job fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl DatasetExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
    pub fn dataset_export_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_export_job_arn.as_deref()
    }
    /// <p>The name of the dataset export job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The status of the dataset export job.</p>
    /// <p>A dataset export job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the dataset export job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the dataset export job status was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If a dataset export job fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for DatasetExportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetExportJobSummary");
        formatter.field("dataset_export_job_arn", &self.dataset_export_job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`DatasetExportJobSummary`](crate::model::DatasetExportJobSummary)
pub mod dataset_export_job_summary {
    /// A builder for [`DatasetExportJobSummary`](crate::model::DatasetExportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_export_job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
        pub fn dataset_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
        pub fn set_dataset_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_export_job_arn = input;
            self
        }
        /// <p>The name of the dataset export job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The status of the dataset export job.</p>
        /// <p>A dataset export job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset export job.</p>
        /// <p>A dataset export job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset export job was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset export job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the dataset export job status was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the dataset export job status was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If a dataset export job fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a dataset export job fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetExportJobSummary`](crate::model::DatasetExportJobSummary)
        pub fn build(self) -> crate::model::DatasetExportJobSummary {
            crate::model::DatasetExportJobSummary {
                dataset_export_job_arn: self.dataset_export_job_arn,
                job_name: self.job_name,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl DatasetExportJobSummary {
    /// Creates a new builder-style object to manufacture [`DatasetExportJobSummary`](crate::model::DatasetExportJobSummary)
    pub fn builder() -> crate::model::dataset_export_job_summary::Builder {
        crate::model::dataset_export_job_summary::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a campaign. For a complete listing, call the <code>DescribeCampaign</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignSummary {
    /// <p>The name of the campaign.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub campaign_arn: std::option::Option<std::string::String>,
    /// <p>The status of the campaign.</p>
    /// <p>A campaign can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the campaign was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the campaign was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If a campaign fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl CampaignSummary {
    /// <p>The name of the campaign.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
    /// <p>The status of the campaign.</p>
    /// <p>A campaign can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix time) that the campaign was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the campaign was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If a campaign fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for CampaignSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignSummary");
        formatter.field("name", &self.name);
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`CampaignSummary`](crate::model::CampaignSummary)
pub mod campaign_summary {
    /// A builder for [`CampaignSummary`](crate::model::CampaignSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the campaign.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the campaign.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// <p>The status of the campaign.</p>
        /// <p>A campaign can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the campaign.</p>
        /// <p>A campaign can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix time) that the campaign was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the campaign was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the campaign was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the campaign was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If a campaign fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a campaign fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignSummary`](crate::model::CampaignSummary)
        pub fn build(self) -> crate::model::CampaignSummary {
            crate::model::CampaignSummary {
                name: self.name,
                campaign_arn: self.campaign_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl CampaignSummary {
    /// Creates a new builder-style object to manufacture [`CampaignSummary`](crate::model::CampaignSummary)
    pub fn builder() -> crate::model::campaign_summary::Builder {
        crate::model::campaign_summary::Builder::default()
    }
}

/// <p>A truncated version of the <code>BatchSegmentJob</code> datatype. The <code>ListBatchSegmentJobs</code> operation returns a list of batch segment job summaries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchSegmentJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
    pub batch_segment_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the batch segment job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The status of the batch segment job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time at which the batch segment job was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the batch segment job was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the batch segment job failed, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
}
impl BatchSegmentJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
    pub fn batch_segment_job_arn(&self) -> std::option::Option<&str> {
        self.batch_segment_job_arn.as_deref()
    }
    /// <p>The name of the batch segment job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The status of the batch segment job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time at which the batch segment job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The time at which the batch segment job was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If the batch segment job failed, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
}
impl std::fmt::Debug for BatchSegmentJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchSegmentJobSummary");
        formatter.field("batch_segment_job_arn", &self.batch_segment_job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.finish()
    }
}
/// See [`BatchSegmentJobSummary`](crate::model::BatchSegmentJobSummary)
pub mod batch_segment_job_summary {
    /// A builder for [`BatchSegmentJobSummary`](crate::model::BatchSegmentJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_segment_job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
        pub fn batch_segment_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_segment_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
        pub fn set_batch_segment_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_segment_job_arn = input;
            self
        }
        /// <p>The name of the batch segment job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the batch segment job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The status of the batch segment job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the batch segment job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the batch segment job was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch segment job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time at which the batch segment job was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch segment job was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If the batch segment job failed, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the batch segment job failed, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSegmentJobSummary`](crate::model::BatchSegmentJobSummary)
        pub fn build(self) -> crate::model::BatchSegmentJobSummary {
            crate::model::BatchSegmentJobSummary {
                batch_segment_job_arn: self.batch_segment_job_arn,
                job_name: self.job_name,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
                solution_version_arn: self.solution_version_arn,
            }
        }
    }
}
impl BatchSegmentJobSummary {
    /// Creates a new builder-style object to manufacture [`BatchSegmentJobSummary`](crate::model::BatchSegmentJobSummary)
    pub fn builder() -> crate::model::batch_segment_job_summary::Builder {
        crate::model::batch_segment_job_summary::Builder::default()
    }
}

/// <p>A truncated version of the <code>BatchInferenceJob</code> datatype. The <code>ListBatchInferenceJobs</code> operation returns a list of batch inference job summaries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchInferenceJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
    pub batch_inference_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the batch inference job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The status of the batch inference job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time at which the batch inference job was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the batch inference job was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the batch inference job failed, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The ARN of the solution version used by the batch inference job.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
}
impl BatchInferenceJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
    pub fn batch_inference_job_arn(&self) -> std::option::Option<&str> {
        self.batch_inference_job_arn.as_deref()
    }
    /// <p>The name of the batch inference job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The status of the batch inference job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time at which the batch inference job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The time at which the batch inference job was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If the batch inference job failed, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The ARN of the solution version used by the batch inference job.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
}
impl std::fmt::Debug for BatchInferenceJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchInferenceJobSummary");
        formatter.field("batch_inference_job_arn", &self.batch_inference_job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.finish()
    }
}
/// See [`BatchInferenceJobSummary`](crate::model::BatchInferenceJobSummary)
pub mod batch_inference_job_summary {
    /// A builder for [`BatchInferenceJobSummary`](crate::model::BatchInferenceJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_inference_job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
        pub fn batch_inference_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_inference_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
        pub fn set_batch_inference_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_inference_job_arn = input;
            self
        }
        /// <p>The name of the batch inference job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the batch inference job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The status of the batch inference job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the batch inference job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the batch inference job was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch inference job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time at which the batch inference job was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch inference job was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If the batch inference job failed, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the batch inference job failed, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The ARN of the solution version used by the batch inference job.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the solution version used by the batch inference job.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchInferenceJobSummary`](crate::model::BatchInferenceJobSummary)
        pub fn build(self) -> crate::model::BatchInferenceJobSummary {
            crate::model::BatchInferenceJobSummary {
                batch_inference_job_arn: self.batch_inference_job_arn,
                job_name: self.job_name,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
                solution_version_arn: self.solution_version_arn,
            }
        }
    }
}
impl BatchInferenceJobSummary {
    /// Creates a new builder-style object to manufacture [`BatchInferenceJobSummary`](crate::model::BatchInferenceJobSummary)
    pub fn builder() -> crate::model::batch_inference_job_summary::Builder {
        crate::model::batch_inference_job_summary::Builder::default()
    }
}

/// <p>An object that provides information about a specific version of a <code>Solution</code> in a Custom dataset group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SolutionVersion {
    /// <p>The ARN of the solution version.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the solution.</p>
    pub solution_arn: std::option::Option<std::string::String>,
    /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
    pub perform_hpo: bool,
    /// <p>When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.</p>
    pub perform_auto_ml: bool,
    /// <p>The ARN of the recipe used in the solution.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The event type (for example, 'click' or 'like') that is used for training the model.</p>
    pub event_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group providing the training data.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>Describes the configuration properties for the solution.</p>
    pub solution_config: std::option::Option<crate::model::SolutionConfig>,
    /// <p>The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.</p>
    pub training_hours: std::option::Option<f64>,
    /// <p>The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an entirely new one.</p> <important>
    /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution version created from the input solution using the <code>FULL</code> option and the input solution was trained with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe or the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
    /// </important>
    pub training_mode: std::option::Option<crate::model::TrainingMode>,
    /// <p>If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.</p>
    pub tuned_hpo_params: std::option::Option<crate::model::TunedHpoParams>,
    /// <p>The status of the solution version.</p>
    /// <p>A solution version can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING</p> </li>
    /// <li> <p>CREATE IN_PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// <li> <p>CREATE STOPPING</p> </li>
    /// <li> <p>CREATE STOPPED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If training a solution version fails, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that this version of the solution was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the solution was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SolutionVersion {
    /// <p>The ARN of the solution version.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The ARN of the solution.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
    /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
    pub fn perform_hpo(&self) -> bool {
        self.perform_hpo
    }
    /// <p>When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.</p>
    pub fn perform_auto_ml(&self) -> bool {
        self.perform_auto_ml
    }
    /// <p>The ARN of the recipe used in the solution.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The event type (for example, 'click' or 'like') that is used for training the model.</p>
    pub fn event_type(&self) -> std::option::Option<&str> {
        self.event_type.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group providing the training data.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>Describes the configuration properties for the solution.</p>
    pub fn solution_config(&self) -> std::option::Option<&crate::model::SolutionConfig> {
        self.solution_config.as_ref()
    }
    /// <p>The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.</p>
    pub fn training_hours(&self) -> std::option::Option<f64> {
        self.training_hours
    }
    /// <p>The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an entirely new one.</p> <important>
    /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution version created from the input solution using the <code>FULL</code> option and the input solution was trained with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe or the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
    /// </important>
    pub fn training_mode(&self) -> std::option::Option<&crate::model::TrainingMode> {
        self.training_mode.as_ref()
    }
    /// <p>If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.</p>
    pub fn tuned_hpo_params(&self) -> std::option::Option<&crate::model::TunedHpoParams> {
        self.tuned_hpo_params.as_ref()
    }
    /// <p>The status of the solution version.</p>
    /// <p>A solution version can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING</p> </li>
    /// <li> <p>CREATE IN_PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// <li> <p>CREATE STOPPING</p> </li>
    /// <li> <p>CREATE STOPPED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If training a solution version fails, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date and time (in Unix time) that this version of the solution was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the solution was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for SolutionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SolutionVersion");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("solution_arn", &self.solution_arn);
        formatter.field("perform_hpo", &self.perform_hpo);
        formatter.field("perform_auto_ml", &self.perform_auto_ml);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("event_type", &self.event_type);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("solution_config", &self.solution_config);
        formatter.field("training_hours", &self.training_hours);
        formatter.field("training_mode", &self.training_mode);
        formatter.field("tuned_hpo_params", &self.tuned_hpo_params);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`SolutionVersion`](crate::model::SolutionVersion)
pub mod solution_version {
    /// A builder for [`SolutionVersion`](crate::model::SolutionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) solution_arn: std::option::Option<std::string::String>,
        pub(crate) perform_hpo: std::option::Option<bool>,
        pub(crate) perform_auto_ml: std::option::Option<bool>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) solution_config: std::option::Option<crate::model::SolutionConfig>,
        pub(crate) training_hours: std::option::Option<f64>,
        pub(crate) training_mode: std::option::Option<crate::model::TrainingMode>,
        pub(crate) tuned_hpo_params: std::option::Option<crate::model::TunedHpoParams>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the solution version.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the solution version.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>The ARN of the solution.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the solution.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
        pub fn perform_hpo(mut self, input: bool) -> Self {
            self.perform_hpo = Some(input);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
        pub fn set_perform_hpo(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_hpo = input;
            self
        }
        /// <p>When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.</p>
        pub fn perform_auto_ml(mut self, input: bool) -> Self {
            self.perform_auto_ml = Some(input);
            self
        }
        /// <p>When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.</p>
        pub fn set_perform_auto_ml(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_auto_ml = input;
            self
        }
        /// <p>The ARN of the recipe used in the solution.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the recipe used in the solution.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The event type (for example, 'click' or 'like') that is used for training the model.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>The event type (for example, 'click' or 'like') that is used for training the model.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group providing the training data.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group providing the training data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>Describes the configuration properties for the solution.</p>
        pub fn solution_config(mut self, input: crate::model::SolutionConfig) -> Self {
            self.solution_config = Some(input);
            self
        }
        /// <p>Describes the configuration properties for the solution.</p>
        pub fn set_solution_config(
            mut self,
            input: std::option::Option<crate::model::SolutionConfig>,
        ) -> Self {
            self.solution_config = input;
            self
        }
        /// <p>The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.</p>
        pub fn training_hours(mut self, input: f64) -> Self {
            self.training_hours = Some(input);
            self
        }
        /// <p>The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.</p>
        pub fn set_training_hours(mut self, input: std::option::Option<f64>) -> Self {
            self.training_hours = input;
            self
        }
        /// <p>The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an entirely new one.</p> <important>
        /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution version created from the input solution using the <code>FULL</code> option and the input solution was trained with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe or the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
        /// </important>
        pub fn training_mode(mut self, input: crate::model::TrainingMode) -> Self {
            self.training_mode = Some(input);
            self
        }
        /// <p>The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an entirely new one.</p> <important>
        /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution version created from the input solution using the <code>FULL</code> option and the input solution was trained with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe or the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
        /// </important>
        pub fn set_training_mode(
            mut self,
            input: std::option::Option<crate::model::TrainingMode>,
        ) -> Self {
            self.training_mode = input;
            self
        }
        /// <p>If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.</p>
        pub fn tuned_hpo_params(mut self, input: crate::model::TunedHpoParams) -> Self {
            self.tuned_hpo_params = Some(input);
            self
        }
        /// <p>If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.</p>
        pub fn set_tuned_hpo_params(
            mut self,
            input: std::option::Option<crate::model::TunedHpoParams>,
        ) -> Self {
            self.tuned_hpo_params = input;
            self
        }
        /// <p>The status of the solution version.</p>
        /// <p>A solution version can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING</p> </li>
        /// <li> <p>CREATE IN_PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// <li> <p>CREATE STOPPING</p> </li>
        /// <li> <p>CREATE STOPPED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the solution version.</p>
        /// <p>A solution version can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING</p> </li>
        /// <li> <p>CREATE IN_PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// <li> <p>CREATE STOPPING</p> </li>
        /// <li> <p>CREATE STOPPED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If training a solution version fails, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If training a solution version fails, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date and time (in Unix time) that this version of the solution was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that this version of the solution was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the solution was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the solution was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SolutionVersion`](crate::model::SolutionVersion)
        pub fn build(self) -> crate::model::SolutionVersion {
            crate::model::SolutionVersion {
                solution_version_arn: self.solution_version_arn,
                solution_arn: self.solution_arn,
                perform_hpo: self.perform_hpo.unwrap_or_default(),
                perform_auto_ml: self.perform_auto_ml.unwrap_or_default(),
                recipe_arn: self.recipe_arn,
                event_type: self.event_type,
                dataset_group_arn: self.dataset_group_arn,
                solution_config: self.solution_config,
                training_hours: self.training_hours,
                training_mode: self.training_mode,
                tuned_hpo_params: self.tuned_hpo_params,
                status: self.status,
                failure_reason: self.failure_reason,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl SolutionVersion {
    /// Creates a new builder-style object to manufacture [`SolutionVersion`](crate::model::SolutionVersion)
    pub fn builder() -> crate::model::solution_version::Builder {
        crate::model::solution_version::Builder::default()
    }
}

/// <p>If hyperparameter optimization (HPO) was performed, contains the hyperparameter values of the best performing model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TunedHpoParams {
    /// <p>A list of the hyperparameter values of the best performing model.</p>
    pub algorithm_hyper_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TunedHpoParams {
    /// <p>A list of the hyperparameter values of the best performing model.</p>
    pub fn algorithm_hyper_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.algorithm_hyper_parameters.as_ref()
    }
}
impl std::fmt::Debug for TunedHpoParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TunedHpoParams");
        formatter.field(
            "algorithm_hyper_parameters",
            &self.algorithm_hyper_parameters,
        );
        formatter.finish()
    }
}
/// See [`TunedHpoParams`](crate::model::TunedHpoParams)
pub mod tuned_hpo_params {
    /// A builder for [`TunedHpoParams`](crate::model::TunedHpoParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_hyper_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `algorithm_hyper_parameters`.
        ///
        /// To override the contents of this collection use [`set_algorithm_hyper_parameters`](Self::set_algorithm_hyper_parameters).
        ///
        /// <p>A list of the hyperparameter values of the best performing model.</p>
        pub fn algorithm_hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.algorithm_hyper_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.algorithm_hyper_parameters = Some(hash_map);
            self
        }
        /// <p>A list of the hyperparameter values of the best performing model.</p>
        pub fn set_algorithm_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.algorithm_hyper_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`TunedHpoParams`](crate::model::TunedHpoParams)
        pub fn build(self) -> crate::model::TunedHpoParams {
            crate::model::TunedHpoParams {
                algorithm_hyper_parameters: self.algorithm_hyper_parameters,
            }
        }
    }
}
impl TunedHpoParams {
    /// Creates a new builder-style object to manufacture [`TunedHpoParams`](crate::model::TunedHpoParams)
    pub fn builder() -> crate::model::tuned_hpo_params::Builder {
        crate::model::tuned_hpo_params::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrainingMode {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrainingMode {
    fn from(s: &str) -> Self {
        match s {
            "FULL" => TrainingMode::Full,
            "UPDATE" => TrainingMode::Update,
            other => TrainingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrainingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrainingMode::from(s))
    }
}
impl TrainingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrainingMode::Full => "FULL",
            TrainingMode::Update => "UPDATE",
            TrainingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL", "UPDATE"]
    }
}
impl AsRef<str> for TrainingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the configuration properties for the solution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SolutionConfig {
    /// <p>Only events with a value greater than or equal to this threshold are used for training a model.</p>
    pub event_value_threshold: std::option::Option<std::string::String>,
    /// <p>Describes the properties for hyperparameter optimization (HPO).</p>
    pub hpo_config: std::option::Option<crate::model::HpoConfig>,
    /// <p>Lists the hyperparameter names and ranges.</p>
    pub algorithm_hyper_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Lists the feature transformation parameters.</p>
    pub feature_transformation_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The <code>AutoMLConfig</code> object containing a list of recipes to search when AutoML is performed.</p>
    pub auto_ml_config: std::option::Option<crate::model::AutoMlConfig>,
    /// <p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>
    pub optimization_objective: std::option::Option<crate::model::OptimizationObjective>,
}
impl SolutionConfig {
    /// <p>Only events with a value greater than or equal to this threshold are used for training a model.</p>
    pub fn event_value_threshold(&self) -> std::option::Option<&str> {
        self.event_value_threshold.as_deref()
    }
    /// <p>Describes the properties for hyperparameter optimization (HPO).</p>
    pub fn hpo_config(&self) -> std::option::Option<&crate::model::HpoConfig> {
        self.hpo_config.as_ref()
    }
    /// <p>Lists the hyperparameter names and ranges.</p>
    pub fn algorithm_hyper_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.algorithm_hyper_parameters.as_ref()
    }
    /// <p>Lists the feature transformation parameters.</p>
    pub fn feature_transformation_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.feature_transformation_parameters.as_ref()
    }
    /// <p>The <code>AutoMLConfig</code> object containing a list of recipes to search when AutoML is performed.</p>
    pub fn auto_ml_config(&self) -> std::option::Option<&crate::model::AutoMlConfig> {
        self.auto_ml_config.as_ref()
    }
    /// <p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>
    pub fn optimization_objective(
        &self,
    ) -> std::option::Option<&crate::model::OptimizationObjective> {
        self.optimization_objective.as_ref()
    }
}
impl std::fmt::Debug for SolutionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SolutionConfig");
        formatter.field("event_value_threshold", &self.event_value_threshold);
        formatter.field("hpo_config", &self.hpo_config);
        formatter.field(
            "algorithm_hyper_parameters",
            &self.algorithm_hyper_parameters,
        );
        formatter.field(
            "feature_transformation_parameters",
            &self.feature_transformation_parameters,
        );
        formatter.field("auto_ml_config", &self.auto_ml_config);
        formatter.field("optimization_objective", &self.optimization_objective);
        formatter.finish()
    }
}
/// See [`SolutionConfig`](crate::model::SolutionConfig)
pub mod solution_config {
    /// A builder for [`SolutionConfig`](crate::model::SolutionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_value_threshold: std::option::Option<std::string::String>,
        pub(crate) hpo_config: std::option::Option<crate::model::HpoConfig>,
        pub(crate) algorithm_hyper_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) feature_transformation_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) auto_ml_config: std::option::Option<crate::model::AutoMlConfig>,
        pub(crate) optimization_objective: std::option::Option<crate::model::OptimizationObjective>,
    }
    impl Builder {
        /// <p>Only events with a value greater than or equal to this threshold are used for training a model.</p>
        pub fn event_value_threshold(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_value_threshold = Some(input.into());
            self
        }
        /// <p>Only events with a value greater than or equal to this threshold are used for training a model.</p>
        pub fn set_event_value_threshold(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_value_threshold = input;
            self
        }
        /// <p>Describes the properties for hyperparameter optimization (HPO).</p>
        pub fn hpo_config(mut self, input: crate::model::HpoConfig) -> Self {
            self.hpo_config = Some(input);
            self
        }
        /// <p>Describes the properties for hyperparameter optimization (HPO).</p>
        pub fn set_hpo_config(
            mut self,
            input: std::option::Option<crate::model::HpoConfig>,
        ) -> Self {
            self.hpo_config = input;
            self
        }
        /// Adds a key-value pair to `algorithm_hyper_parameters`.
        ///
        /// To override the contents of this collection use [`set_algorithm_hyper_parameters`](Self::set_algorithm_hyper_parameters).
        ///
        /// <p>Lists the hyperparameter names and ranges.</p>
        pub fn algorithm_hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.algorithm_hyper_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.algorithm_hyper_parameters = Some(hash_map);
            self
        }
        /// <p>Lists the hyperparameter names and ranges.</p>
        pub fn set_algorithm_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.algorithm_hyper_parameters = input;
            self
        }
        /// Adds a key-value pair to `feature_transformation_parameters`.
        ///
        /// To override the contents of this collection use [`set_feature_transformation_parameters`](Self::set_feature_transformation_parameters).
        ///
        /// <p>Lists the feature transformation parameters.</p>
        pub fn feature_transformation_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.feature_transformation_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.feature_transformation_parameters = Some(hash_map);
            self
        }
        /// <p>Lists the feature transformation parameters.</p>
        pub fn set_feature_transformation_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.feature_transformation_parameters = input;
            self
        }
        /// <p>The <code>AutoMLConfig</code> object containing a list of recipes to search when AutoML is performed.</p>
        pub fn auto_ml_config(mut self, input: crate::model::AutoMlConfig) -> Self {
            self.auto_ml_config = Some(input);
            self
        }
        /// <p>The <code>AutoMLConfig</code> object containing a list of recipes to search when AutoML is performed.</p>
        pub fn set_auto_ml_config(
            mut self,
            input: std::option::Option<crate::model::AutoMlConfig>,
        ) -> Self {
            self.auto_ml_config = input;
            self
        }
        /// <p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>
        pub fn optimization_objective(
            mut self,
            input: crate::model::OptimizationObjective,
        ) -> Self {
            self.optimization_objective = Some(input);
            self
        }
        /// <p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>
        pub fn set_optimization_objective(
            mut self,
            input: std::option::Option<crate::model::OptimizationObjective>,
        ) -> Self {
            self.optimization_objective = input;
            self
        }
        /// Consumes the builder and constructs a [`SolutionConfig`](crate::model::SolutionConfig)
        pub fn build(self) -> crate::model::SolutionConfig {
            crate::model::SolutionConfig {
                event_value_threshold: self.event_value_threshold,
                hpo_config: self.hpo_config,
                algorithm_hyper_parameters: self.algorithm_hyper_parameters,
                feature_transformation_parameters: self.feature_transformation_parameters,
                auto_ml_config: self.auto_ml_config,
                optimization_objective: self.optimization_objective,
            }
        }
    }
}
impl SolutionConfig {
    /// Creates a new builder-style object to manufacture [`SolutionConfig`](crate::model::SolutionConfig)
    pub fn builder() -> crate::model::solution_config::Builder {
        crate::model::solution_config::Builder::default()
    }
}

/// <p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptimizationObjective {
    /// <p>The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).</p>
    pub item_attribute: std::option::Option<std::string::String>,
    /// <p>Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.</p>
    pub objective_sensitivity: std::option::Option<crate::model::ObjectiveSensitivity>,
}
impl OptimizationObjective {
    /// <p>The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).</p>
    pub fn item_attribute(&self) -> std::option::Option<&str> {
        self.item_attribute.as_deref()
    }
    /// <p>Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.</p>
    pub fn objective_sensitivity(
        &self,
    ) -> std::option::Option<&crate::model::ObjectiveSensitivity> {
        self.objective_sensitivity.as_ref()
    }
}
impl std::fmt::Debug for OptimizationObjective {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptimizationObjective");
        formatter.field("item_attribute", &self.item_attribute);
        formatter.field("objective_sensitivity", &self.objective_sensitivity);
        formatter.finish()
    }
}
/// See [`OptimizationObjective`](crate::model::OptimizationObjective)
pub mod optimization_objective {
    /// A builder for [`OptimizationObjective`](crate::model::OptimizationObjective)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item_attribute: std::option::Option<std::string::String>,
        pub(crate) objective_sensitivity: std::option::Option<crate::model::ObjectiveSensitivity>,
    }
    impl Builder {
        /// <p>The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).</p>
        pub fn item_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.item_attribute = Some(input.into());
            self
        }
        /// <p>The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).</p>
        pub fn set_item_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.item_attribute = input;
            self
        }
        /// <p>Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.</p>
        pub fn objective_sensitivity(mut self, input: crate::model::ObjectiveSensitivity) -> Self {
            self.objective_sensitivity = Some(input);
            self
        }
        /// <p>Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.</p>
        pub fn set_objective_sensitivity(
            mut self,
            input: std::option::Option<crate::model::ObjectiveSensitivity>,
        ) -> Self {
            self.objective_sensitivity = input;
            self
        }
        /// Consumes the builder and constructs a [`OptimizationObjective`](crate::model::OptimizationObjective)
        pub fn build(self) -> crate::model::OptimizationObjective {
            crate::model::OptimizationObjective {
                item_attribute: self.item_attribute,
                objective_sensitivity: self.objective_sensitivity,
            }
        }
    }
}
impl OptimizationObjective {
    /// Creates a new builder-style object to manufacture [`OptimizationObjective`](crate::model::OptimizationObjective)
    pub fn builder() -> crate::model::optimization_objective::Builder {
        crate::model::optimization_objective::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectiveSensitivity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectiveSensitivity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => ObjectiveSensitivity::High,
            "LOW" => ObjectiveSensitivity::Low,
            "MEDIUM" => ObjectiveSensitivity::Medium,
            "OFF" => ObjectiveSensitivity::Off,
            other => ObjectiveSensitivity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectiveSensitivity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectiveSensitivity::from(s))
    }
}
impl ObjectiveSensitivity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectiveSensitivity::High => "HIGH",
            ObjectiveSensitivity::Low => "LOW",
            ObjectiveSensitivity::Medium => "MEDIUM",
            ObjectiveSensitivity::Off => "OFF",
            ObjectiveSensitivity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for ObjectiveSensitivity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>When the solution performs AutoML (<code>performAutoML</code> is true in <code>CreateSolution</code>), Amazon Personalize determines which recipe, from the specified list, optimizes the given metric. Amazon Personalize then uses that recipe for the solution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoMlConfig {
    /// <p>The metric to optimize.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The list of candidate recipes.</p>
    pub recipe_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AutoMlConfig {
    /// <p>The metric to optimize.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The list of candidate recipes.</p>
    pub fn recipe_list(&self) -> std::option::Option<&[std::string::String]> {
        self.recipe_list.as_deref()
    }
}
impl std::fmt::Debug for AutoMlConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoMlConfig");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("recipe_list", &self.recipe_list);
        formatter.finish()
    }
}
/// See [`AutoMlConfig`](crate::model::AutoMlConfig)
pub mod auto_ml_config {
    /// A builder for [`AutoMlConfig`](crate::model::AutoMlConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) recipe_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The metric to optimize.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The metric to optimize.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `recipe_list`.
        ///
        /// To override the contents of this collection use [`set_recipe_list`](Self::set_recipe_list).
        ///
        /// <p>The list of candidate recipes.</p>
        pub fn recipe_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recipe_list.unwrap_or_default();
            v.push(input.into());
            self.recipe_list = Some(v);
            self
        }
        /// <p>The list of candidate recipes.</p>
        pub fn set_recipe_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recipe_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoMlConfig`](crate::model::AutoMlConfig)
        pub fn build(self) -> crate::model::AutoMlConfig {
            crate::model::AutoMlConfig {
                metric_name: self.metric_name,
                recipe_list: self.recipe_list,
            }
        }
    }
}
impl AutoMlConfig {
    /// Creates a new builder-style object to manufacture [`AutoMlConfig`](crate::model::AutoMlConfig)
    pub fn builder() -> crate::model::auto_ml_config::Builder {
        crate::model::auto_ml_config::Builder::default()
    }
}

/// <p>Describes the properties for hyperparameter optimization (HPO).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HpoConfig {
    /// <p>The metric to optimize during HPO.</p> <note>
    /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.</p>
    /// </note>
    pub hpo_objective: std::option::Option<crate::model::HpoObjective>,
    /// <p>Describes the resource configuration for HPO.</p>
    pub hpo_resource_config: std::option::Option<crate::model::HpoResourceConfig>,
    /// <p>The hyperparameters and their allowable ranges.</p>
    pub algorithm_hyper_parameter_ranges: std::option::Option<crate::model::HyperParameterRanges>,
}
impl HpoConfig {
    /// <p>The metric to optimize during HPO.</p> <note>
    /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.</p>
    /// </note>
    pub fn hpo_objective(&self) -> std::option::Option<&crate::model::HpoObjective> {
        self.hpo_objective.as_ref()
    }
    /// <p>Describes the resource configuration for HPO.</p>
    pub fn hpo_resource_config(&self) -> std::option::Option<&crate::model::HpoResourceConfig> {
        self.hpo_resource_config.as_ref()
    }
    /// <p>The hyperparameters and their allowable ranges.</p>
    pub fn algorithm_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterRanges> {
        self.algorithm_hyper_parameter_ranges.as_ref()
    }
}
impl std::fmt::Debug for HpoConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HpoConfig");
        formatter.field("hpo_objective", &self.hpo_objective);
        formatter.field("hpo_resource_config", &self.hpo_resource_config);
        formatter.field(
            "algorithm_hyper_parameter_ranges",
            &self.algorithm_hyper_parameter_ranges,
        );
        formatter.finish()
    }
}
/// See [`HpoConfig`](crate::model::HpoConfig)
pub mod hpo_config {
    /// A builder for [`HpoConfig`](crate::model::HpoConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hpo_objective: std::option::Option<crate::model::HpoObjective>,
        pub(crate) hpo_resource_config: std::option::Option<crate::model::HpoResourceConfig>,
        pub(crate) algorithm_hyper_parameter_ranges:
            std::option::Option<crate::model::HyperParameterRanges>,
    }
    impl Builder {
        /// <p>The metric to optimize during HPO.</p> <note>
        /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.</p>
        /// </note>
        pub fn hpo_objective(mut self, input: crate::model::HpoObjective) -> Self {
            self.hpo_objective = Some(input);
            self
        }
        /// <p>The metric to optimize during HPO.</p> <note>
        /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.</p>
        /// </note>
        pub fn set_hpo_objective(
            mut self,
            input: std::option::Option<crate::model::HpoObjective>,
        ) -> Self {
            self.hpo_objective = input;
            self
        }
        /// <p>Describes the resource configuration for HPO.</p>
        pub fn hpo_resource_config(mut self, input: crate::model::HpoResourceConfig) -> Self {
            self.hpo_resource_config = Some(input);
            self
        }
        /// <p>Describes the resource configuration for HPO.</p>
        pub fn set_hpo_resource_config(
            mut self,
            input: std::option::Option<crate::model::HpoResourceConfig>,
        ) -> Self {
            self.hpo_resource_config = input;
            self
        }
        /// <p>The hyperparameters and their allowable ranges.</p>
        pub fn algorithm_hyper_parameter_ranges(
            mut self,
            input: crate::model::HyperParameterRanges,
        ) -> Self {
            self.algorithm_hyper_parameter_ranges = Some(input);
            self
        }
        /// <p>The hyperparameters and their allowable ranges.</p>
        pub fn set_algorithm_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<crate::model::HyperParameterRanges>,
        ) -> Self {
            self.algorithm_hyper_parameter_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`HpoConfig`](crate::model::HpoConfig)
        pub fn build(self) -> crate::model::HpoConfig {
            crate::model::HpoConfig {
                hpo_objective: self.hpo_objective,
                hpo_resource_config: self.hpo_resource_config,
                algorithm_hyper_parameter_ranges: self.algorithm_hyper_parameter_ranges,
            }
        }
    }
}
impl HpoConfig {
    /// Creates a new builder-style object to manufacture [`HpoConfig`](crate::model::HpoConfig)
    pub fn builder() -> crate::model::hpo_config::Builder {
        crate::model::hpo_config::Builder::default()
    }
}

/// <p>Specifies the hyperparameters and their ranges. Hyperparameters can be categorical, continuous, or integer-valued.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HyperParameterRanges {
    /// <p>The integer-valued hyperparameters and their ranges.</p>
    pub integer_hyper_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::IntegerHyperParameterRange>>,
    /// <p>The continuous hyperparameters and their ranges.</p>
    pub continuous_hyper_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::ContinuousHyperParameterRange>>,
    /// <p>The categorical hyperparameters and their ranges.</p>
    pub categorical_hyper_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::CategoricalHyperParameterRange>>,
}
impl HyperParameterRanges {
    /// <p>The integer-valued hyperparameters and their ranges.</p>
    pub fn integer_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::IntegerHyperParameterRange]> {
        self.integer_hyper_parameter_ranges.as_deref()
    }
    /// <p>The continuous hyperparameters and their ranges.</p>
    pub fn continuous_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::ContinuousHyperParameterRange]> {
        self.continuous_hyper_parameter_ranges.as_deref()
    }
    /// <p>The categorical hyperparameters and their ranges.</p>
    pub fn categorical_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::CategoricalHyperParameterRange]> {
        self.categorical_hyper_parameter_ranges.as_deref()
    }
}
impl std::fmt::Debug for HyperParameterRanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HyperParameterRanges");
        formatter.field(
            "integer_hyper_parameter_ranges",
            &self.integer_hyper_parameter_ranges,
        );
        formatter.field(
            "continuous_hyper_parameter_ranges",
            &self.continuous_hyper_parameter_ranges,
        );
        formatter.field(
            "categorical_hyper_parameter_ranges",
            &self.categorical_hyper_parameter_ranges,
        );
        formatter.finish()
    }
}
/// See [`HyperParameterRanges`](crate::model::HyperParameterRanges)
pub mod hyper_parameter_ranges {
    /// A builder for [`HyperParameterRanges`](crate::model::HyperParameterRanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) integer_hyper_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::IntegerHyperParameterRange>>,
        pub(crate) continuous_hyper_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::ContinuousHyperParameterRange>>,
        pub(crate) categorical_hyper_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::CategoricalHyperParameterRange>>,
    }
    impl Builder {
        /// Appends an item to `integer_hyper_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_integer_hyper_parameter_ranges`](Self::set_integer_hyper_parameter_ranges).
        ///
        /// <p>The integer-valued hyperparameters and their ranges.</p>
        pub fn integer_hyper_parameter_ranges(
            mut self,
            input: crate::model::IntegerHyperParameterRange,
        ) -> Self {
            let mut v = self.integer_hyper_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.integer_hyper_parameter_ranges = Some(v);
            self
        }
        /// <p>The integer-valued hyperparameters and their ranges.</p>
        pub fn set_integer_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntegerHyperParameterRange>>,
        ) -> Self {
            self.integer_hyper_parameter_ranges = input;
            self
        }
        /// Appends an item to `continuous_hyper_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_continuous_hyper_parameter_ranges`](Self::set_continuous_hyper_parameter_ranges).
        ///
        /// <p>The continuous hyperparameters and their ranges.</p>
        pub fn continuous_hyper_parameter_ranges(
            mut self,
            input: crate::model::ContinuousHyperParameterRange,
        ) -> Self {
            let mut v = self.continuous_hyper_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.continuous_hyper_parameter_ranges = Some(v);
            self
        }
        /// <p>The continuous hyperparameters and their ranges.</p>
        pub fn set_continuous_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContinuousHyperParameterRange>>,
        ) -> Self {
            self.continuous_hyper_parameter_ranges = input;
            self
        }
        /// Appends an item to `categorical_hyper_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_categorical_hyper_parameter_ranges`](Self::set_categorical_hyper_parameter_ranges).
        ///
        /// <p>The categorical hyperparameters and their ranges.</p>
        pub fn categorical_hyper_parameter_ranges(
            mut self,
            input: crate::model::CategoricalHyperParameterRange,
        ) -> Self {
            let mut v = self.categorical_hyper_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.categorical_hyper_parameter_ranges = Some(v);
            self
        }
        /// <p>The categorical hyperparameters and their ranges.</p>
        pub fn set_categorical_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CategoricalHyperParameterRange>>,
        ) -> Self {
            self.categorical_hyper_parameter_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`HyperParameterRanges`](crate::model::HyperParameterRanges)
        pub fn build(self) -> crate::model::HyperParameterRanges {
            crate::model::HyperParameterRanges {
                integer_hyper_parameter_ranges: self.integer_hyper_parameter_ranges,
                continuous_hyper_parameter_ranges: self.continuous_hyper_parameter_ranges,
                categorical_hyper_parameter_ranges: self.categorical_hyper_parameter_ranges,
            }
        }
    }
}
impl HyperParameterRanges {
    /// Creates a new builder-style object to manufacture [`HyperParameterRanges`](crate::model::HyperParameterRanges)
    pub fn builder() -> crate::model::hyper_parameter_ranges::Builder {
        crate::model::hyper_parameter_ranges::Builder::default()
    }
}

/// <p>Provides the name and range of a categorical hyperparameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CategoricalHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the categories for the hyperparameter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CategoricalHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the categories for the hyperparameter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for CategoricalHyperParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CategoricalHyperParameterRange");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`CategoricalHyperParameterRange`](crate::model::CategoricalHyperParameterRange)
pub mod categorical_hyper_parameter_range {
    /// A builder for [`CategoricalHyperParameterRange`](crate::model::CategoricalHyperParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of the categories for the hyperparameter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of the categories for the hyperparameter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`CategoricalHyperParameterRange`](crate::model::CategoricalHyperParameterRange)
        pub fn build(self) -> crate::model::CategoricalHyperParameterRange {
            crate::model::CategoricalHyperParameterRange {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl CategoricalHyperParameterRange {
    /// Creates a new builder-style object to manufacture [`CategoricalHyperParameterRange`](crate::model::CategoricalHyperParameterRange)
    pub fn builder() -> crate::model::categorical_hyper_parameter_range::Builder {
        crate::model::categorical_hyper_parameter_range::Builder::default()
    }
}

/// <p>Provides the name and range of a continuous hyperparameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinuousHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub min_value: f64,
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub max_value: f64,
}
impl ContinuousHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub fn min_value(&self) -> f64 {
        self.min_value
    }
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub fn max_value(&self) -> f64 {
        self.max_value
    }
}
impl std::fmt::Debug for ContinuousHyperParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinuousHyperParameterRange");
        formatter.field("name", &self.name);
        formatter.field("min_value", &self.min_value);
        formatter.field("max_value", &self.max_value);
        formatter.finish()
    }
}
/// See [`ContinuousHyperParameterRange`](crate::model::ContinuousHyperParameterRange)
pub mod continuous_hyper_parameter_range {
    /// A builder for [`ContinuousHyperParameterRange`](crate::model::ContinuousHyperParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) min_value: std::option::Option<f64>,
        pub(crate) max_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn min_value(mut self, input: f64) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn set_min_value(mut self, input: std::option::Option<f64>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn max_value(mut self, input: f64) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn set_max_value(mut self, input: std::option::Option<f64>) -> Self {
            self.max_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinuousHyperParameterRange`](crate::model::ContinuousHyperParameterRange)
        pub fn build(self) -> crate::model::ContinuousHyperParameterRange {
            crate::model::ContinuousHyperParameterRange {
                name: self.name,
                min_value: self.min_value.unwrap_or_default(),
                max_value: self.max_value.unwrap_or_default(),
            }
        }
    }
}
impl ContinuousHyperParameterRange {
    /// Creates a new builder-style object to manufacture [`ContinuousHyperParameterRange`](crate::model::ContinuousHyperParameterRange)
    pub fn builder() -> crate::model::continuous_hyper_parameter_range::Builder {
        crate::model::continuous_hyper_parameter_range::Builder::default()
    }
}

/// <p>Provides the name and range of an integer-valued hyperparameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntegerHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub min_value: i32,
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub max_value: i32,
}
impl IntegerHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub fn min_value(&self) -> i32 {
        self.min_value
    }
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub fn max_value(&self) -> i32 {
        self.max_value
    }
}
impl std::fmt::Debug for IntegerHyperParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntegerHyperParameterRange");
        formatter.field("name", &self.name);
        formatter.field("min_value", &self.min_value);
        formatter.field("max_value", &self.max_value);
        formatter.finish()
    }
}
/// See [`IntegerHyperParameterRange`](crate::model::IntegerHyperParameterRange)
pub mod integer_hyper_parameter_range {
    /// A builder for [`IntegerHyperParameterRange`](crate::model::IntegerHyperParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) min_value: std::option::Option<i32>,
        pub(crate) max_value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn min_value(mut self, input: i32) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn set_min_value(mut self, input: std::option::Option<i32>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn max_value(mut self, input: i32) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn set_max_value(mut self, input: std::option::Option<i32>) -> Self {
            self.max_value = input;
            self
        }
        /// Consumes the builder and constructs a [`IntegerHyperParameterRange`](crate::model::IntegerHyperParameterRange)
        pub fn build(self) -> crate::model::IntegerHyperParameterRange {
            crate::model::IntegerHyperParameterRange {
                name: self.name,
                min_value: self.min_value.unwrap_or_default(),
                max_value: self.max_value.unwrap_or_default(),
            }
        }
    }
}
impl IntegerHyperParameterRange {
    /// Creates a new builder-style object to manufacture [`IntegerHyperParameterRange`](crate::model::IntegerHyperParameterRange)
    pub fn builder() -> crate::model::integer_hyper_parameter_range::Builder {
        crate::model::integer_hyper_parameter_range::Builder::default()
    }
}

/// <p>Describes the resource configuration for hyperparameter optimization (HPO).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HpoResourceConfig {
    /// <p>The maximum number of training jobs when you create a solution version. The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code>.</p>
    pub max_number_of_training_jobs: std::option::Option<std::string::String>,
    /// <p>The maximum number of parallel training jobs when you create a solution version. The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code>.</p>
    pub max_parallel_training_jobs: std::option::Option<std::string::String>,
}
impl HpoResourceConfig {
    /// <p>The maximum number of training jobs when you create a solution version. The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code>.</p>
    pub fn max_number_of_training_jobs(&self) -> std::option::Option<&str> {
        self.max_number_of_training_jobs.as_deref()
    }
    /// <p>The maximum number of parallel training jobs when you create a solution version. The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code>.</p>
    pub fn max_parallel_training_jobs(&self) -> std::option::Option<&str> {
        self.max_parallel_training_jobs.as_deref()
    }
}
impl std::fmt::Debug for HpoResourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HpoResourceConfig");
        formatter.field(
            "max_number_of_training_jobs",
            &self.max_number_of_training_jobs,
        );
        formatter.field(
            "max_parallel_training_jobs",
            &self.max_parallel_training_jobs,
        );
        formatter.finish()
    }
}
/// See [`HpoResourceConfig`](crate::model::HpoResourceConfig)
pub mod hpo_resource_config {
    /// A builder for [`HpoResourceConfig`](crate::model::HpoResourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_number_of_training_jobs: std::option::Option<std::string::String>,
        pub(crate) max_parallel_training_jobs: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of training jobs when you create a solution version. The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code>.</p>
        pub fn max_number_of_training_jobs(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.max_number_of_training_jobs = Some(input.into());
            self
        }
        /// <p>The maximum number of training jobs when you create a solution version. The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code>.</p>
        pub fn set_max_number_of_training_jobs(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_number_of_training_jobs = input;
            self
        }
        /// <p>The maximum number of parallel training jobs when you create a solution version. The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code>.</p>
        pub fn max_parallel_training_jobs(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_parallel_training_jobs = Some(input.into());
            self
        }
        /// <p>The maximum number of parallel training jobs when you create a solution version. The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code>.</p>
        pub fn set_max_parallel_training_jobs(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_parallel_training_jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`HpoResourceConfig`](crate::model::HpoResourceConfig)
        pub fn build(self) -> crate::model::HpoResourceConfig {
            crate::model::HpoResourceConfig {
                max_number_of_training_jobs: self.max_number_of_training_jobs,
                max_parallel_training_jobs: self.max_parallel_training_jobs,
            }
        }
    }
}
impl HpoResourceConfig {
    /// Creates a new builder-style object to manufacture [`HpoResourceConfig`](crate::model::HpoResourceConfig)
    pub fn builder() -> crate::model::hpo_resource_config::Builder {
        crate::model::hpo_resource_config::Builder::default()
    }
}

/// <p>The metric to optimize during hyperparameter optimization (HPO).</p> <note>
/// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HpoObjective {
    /// <p>The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>A regular expression for finding the metric in the training job logs.</p>
    pub metric_regex: std::option::Option<std::string::String>,
}
impl HpoObjective {
    /// <p>The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>A regular expression for finding the metric in the training job logs.</p>
    pub fn metric_regex(&self) -> std::option::Option<&str> {
        self.metric_regex.as_deref()
    }
}
impl std::fmt::Debug for HpoObjective {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HpoObjective");
        formatter.field("r#type", &self.r#type);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_regex", &self.metric_regex);
        formatter.finish()
    }
}
/// See [`HpoObjective`](crate::model::HpoObjective)
pub mod hpo_objective {
    /// A builder for [`HpoObjective`](crate::model::HpoObjective)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_regex: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>A regular expression for finding the metric in the training job logs.</p>
        pub fn metric_regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_regex = Some(input.into());
            self
        }
        /// <p>A regular expression for finding the metric in the training job logs.</p>
        pub fn set_metric_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_regex = input;
            self
        }
        /// Consumes the builder and constructs a [`HpoObjective`](crate::model::HpoObjective)
        pub fn build(self) -> crate::model::HpoObjective {
            crate::model::HpoObjective {
                r#type: self.r#type,
                metric_name: self.metric_name,
                metric_regex: self.metric_regex,
            }
        }
    }
}
impl HpoObjective {
    /// Creates a new builder-style object to manufacture [`HpoObjective`](crate::model::HpoObjective)
    pub fn builder() -> crate::model::hpo_objective::Builder {
        crate::model::hpo_objective::Builder::default()
    }
}

/// <p>An object that provides information about a solution. A solution is a trained model that can be deployed as a campaign.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Solution {
    /// <p>The name of the solution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the solution.</p>
    pub solution_arn: std::option::Option<std::string::String>,
    /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
    pub perform_hpo: bool,
    /// <p>When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.</p>
    pub perform_auto_ml: bool,
    /// <p>The ARN of the recipe used to create the solution.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The event type (for example, 'click' or 'like') that is used for training the model. If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.</p>
    pub event_type: std::option::Option<std::string::String>,
    /// <p>Describes the configuration properties for the solution.</p>
    pub solution_config: std::option::Option<crate::model::SolutionConfig>,
    /// <p>When <code>performAutoML</code> is true, specifies the best recipe found.</p>
    pub auto_ml_result: std::option::Option<crate::model::AutoMlResult>,
    /// <p>The status of the solution.</p>
    /// <p>A solution can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The creation date and time (in Unix time) of the solution.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the solution was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Describes the latest version of the solution, including the status and the ARN.</p>
    pub latest_solution_version: std::option::Option<crate::model::SolutionVersionSummary>,
}
impl Solution {
    /// <p>The name of the solution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the solution.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
    /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
    pub fn perform_hpo(&self) -> bool {
        self.perform_hpo
    }
    /// <p>When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.</p>
    pub fn perform_auto_ml(&self) -> bool {
        self.perform_auto_ml
    }
    /// <p>The ARN of the recipe used to create the solution.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The event type (for example, 'click' or 'like') that is used for training the model. If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.</p>
    pub fn event_type(&self) -> std::option::Option<&str> {
        self.event_type.as_deref()
    }
    /// <p>Describes the configuration properties for the solution.</p>
    pub fn solution_config(&self) -> std::option::Option<&crate::model::SolutionConfig> {
        self.solution_config.as_ref()
    }
    /// <p>When <code>performAutoML</code> is true, specifies the best recipe found.</p>
    pub fn auto_ml_result(&self) -> std::option::Option<&crate::model::AutoMlResult> {
        self.auto_ml_result.as_ref()
    }
    /// <p>The status of the solution.</p>
    /// <p>A solution can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The creation date and time (in Unix time) of the solution.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the solution was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Describes the latest version of the solution, including the status and the ARN.</p>
    pub fn latest_solution_version(
        &self,
    ) -> std::option::Option<&crate::model::SolutionVersionSummary> {
        self.latest_solution_version.as_ref()
    }
}
impl std::fmt::Debug for Solution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Solution");
        formatter.field("name", &self.name);
        formatter.field("solution_arn", &self.solution_arn);
        formatter.field("perform_hpo", &self.perform_hpo);
        formatter.field("perform_auto_ml", &self.perform_auto_ml);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("event_type", &self.event_type);
        formatter.field("solution_config", &self.solution_config);
        formatter.field("auto_ml_result", &self.auto_ml_result);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("latest_solution_version", &self.latest_solution_version);
        formatter.finish()
    }
}
/// See [`Solution`](crate::model::Solution)
pub mod solution {
    /// A builder for [`Solution`](crate::model::Solution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) solution_arn: std::option::Option<std::string::String>,
        pub(crate) perform_hpo: std::option::Option<bool>,
        pub(crate) perform_auto_ml: std::option::Option<bool>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<std::string::String>,
        pub(crate) solution_config: std::option::Option<crate::model::SolutionConfig>,
        pub(crate) auto_ml_result: std::option::Option<crate::model::AutoMlResult>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_solution_version:
            std::option::Option<crate::model::SolutionVersionSummary>,
    }
    impl Builder {
        /// <p>The name of the solution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the solution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the solution.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the solution.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
        pub fn perform_hpo(mut self, input: bool) -> Self {
            self.perform_hpo = Some(input);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>
        pub fn set_perform_hpo(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_hpo = input;
            self
        }
        /// <p>When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.</p>
        pub fn perform_auto_ml(mut self, input: bool) -> Self {
            self.perform_auto_ml = Some(input);
            self
        }
        /// <p>When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.</p>
        pub fn set_perform_auto_ml(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_auto_ml = input;
            self
        }
        /// <p>The ARN of the recipe used to create the solution.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the recipe used to create the solution.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The event type (for example, 'click' or 'like') that is used for training the model. If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>The event type (for example, 'click' or 'like') that is used for training the model. If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// <p>Describes the configuration properties for the solution.</p>
        pub fn solution_config(mut self, input: crate::model::SolutionConfig) -> Self {
            self.solution_config = Some(input);
            self
        }
        /// <p>Describes the configuration properties for the solution.</p>
        pub fn set_solution_config(
            mut self,
            input: std::option::Option<crate::model::SolutionConfig>,
        ) -> Self {
            self.solution_config = input;
            self
        }
        /// <p>When <code>performAutoML</code> is true, specifies the best recipe found.</p>
        pub fn auto_ml_result(mut self, input: crate::model::AutoMlResult) -> Self {
            self.auto_ml_result = Some(input);
            self
        }
        /// <p>When <code>performAutoML</code> is true, specifies the best recipe found.</p>
        pub fn set_auto_ml_result(
            mut self,
            input: std::option::Option<crate::model::AutoMlResult>,
        ) -> Self {
            self.auto_ml_result = input;
            self
        }
        /// <p>The status of the solution.</p>
        /// <p>A solution can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the solution.</p>
        /// <p>A solution can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The creation date and time (in Unix time) of the solution.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time (in Unix time) of the solution.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the solution was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the solution was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Describes the latest version of the solution, including the status and the ARN.</p>
        pub fn latest_solution_version(
            mut self,
            input: crate::model::SolutionVersionSummary,
        ) -> Self {
            self.latest_solution_version = Some(input);
            self
        }
        /// <p>Describes the latest version of the solution, including the status and the ARN.</p>
        pub fn set_latest_solution_version(
            mut self,
            input: std::option::Option<crate::model::SolutionVersionSummary>,
        ) -> Self {
            self.latest_solution_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Solution`](crate::model::Solution)
        pub fn build(self) -> crate::model::Solution {
            crate::model::Solution {
                name: self.name,
                solution_arn: self.solution_arn,
                perform_hpo: self.perform_hpo.unwrap_or_default(),
                perform_auto_ml: self.perform_auto_ml.unwrap_or_default(),
                recipe_arn: self.recipe_arn,
                dataset_group_arn: self.dataset_group_arn,
                event_type: self.event_type,
                solution_config: self.solution_config,
                auto_ml_result: self.auto_ml_result,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                latest_solution_version: self.latest_solution_version,
            }
        }
    }
}
impl Solution {
    /// Creates a new builder-style object to manufacture [`Solution`](crate::model::Solution)
    pub fn builder() -> crate::model::solution::Builder {
        crate::model::solution::Builder::default()
    }
}

/// <p>When the solution performs AutoML (<code>performAutoML</code> is true in <code>CreateSolution</code>), specifies the recipe that best optimized the specified metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoMlResult {
    /// <p>The Amazon Resource Name (ARN) of the best recipe.</p>
    pub best_recipe_arn: std::option::Option<std::string::String>,
}
impl AutoMlResult {
    /// <p>The Amazon Resource Name (ARN) of the best recipe.</p>
    pub fn best_recipe_arn(&self) -> std::option::Option<&str> {
        self.best_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for AutoMlResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoMlResult");
        formatter.field("best_recipe_arn", &self.best_recipe_arn);
        formatter.finish()
    }
}
/// See [`AutoMlResult`](crate::model::AutoMlResult)
pub mod auto_ml_result {
    /// A builder for [`AutoMlResult`](crate::model::AutoMlResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) best_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the best recipe.</p>
        pub fn best_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.best_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the best recipe.</p>
        pub fn set_best_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.best_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoMlResult`](crate::model::AutoMlResult)
        pub fn build(self) -> crate::model::AutoMlResult {
            crate::model::AutoMlResult {
                best_recipe_arn: self.best_recipe_arn,
            }
        }
    }
}
impl AutoMlResult {
    /// Creates a new builder-style object to manufacture [`AutoMlResult`](crate::model::AutoMlResult)
    pub fn builder() -> crate::model::auto_ml_result::Builder {
        crate::model::auto_ml_result::Builder::default()
    }
}

/// <p>Describes the schema for a dataset. For more information on schemas, see <code>CreateSchema</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetSchema {
    /// <p>The name of the schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The schema.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the schema was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the schema was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl DatasetSchema {
    /// <p>The name of the schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The schema.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The date and time (in Unix time) that the schema was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the schema was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for DatasetSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetSchema");
        formatter.field("name", &self.name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema", &self.schema);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DatasetSchema`](crate::model::DatasetSchema)
pub mod dataset_schema {
    /// A builder for [`DatasetSchema`](crate::model::DatasetSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>The name of the schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The date and time (in Unix time) that the schema was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the schema was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the schema was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the schema was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetSchema`](crate::model::DatasetSchema)
        pub fn build(self) -> crate::model::DatasetSchema {
            crate::model::DatasetSchema {
                name: self.name,
                schema_arn: self.schema_arn,
                schema: self.schema,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                domain: self.domain,
            }
        }
    }
}
impl DatasetSchema {
    /// Creates a new builder-style object to manufacture [`DatasetSchema`](crate::model::DatasetSchema)
    pub fn builder() -> crate::model::dataset_schema::Builder {
        crate::model::dataset_schema::Builder::default()
    }
}

/// <p>Describes a recommendation generator for a Domain dataset group. You create a recommender in a Domain dataset group for a specific domain use case (domain recipe), and specify the recommender in a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recommender {
    /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
    pub recommender_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the recommender.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for. </p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The configuration details of the recommender.</p>
    pub recommender_config: std::option::Option<crate::model::RecommenderConfig>,
    /// <p>The date and time (in Unix format) that the recommender was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the recommender.</p>
    /// <p>A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If a recommender fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Provides a summary of the latest updates to the recommender. </p>
    pub latest_recommender_update: std::option::Option<crate::model::RecommenderUpdateSummary>,
}
impl Recommender {
    /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
    pub fn recommender_arn(&self) -> std::option::Option<&str> {
        self.recommender_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The name of the recommender.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for. </p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The configuration details of the recommender.</p>
    pub fn recommender_config(&self) -> std::option::Option<&crate::model::RecommenderConfig> {
        self.recommender_config.as_ref()
    }
    /// <p>The date and time (in Unix format) that the recommender was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The status of the recommender.</p>
    /// <p>A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If a recommender fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Provides a summary of the latest updates to the recommender. </p>
    pub fn latest_recommender_update(
        &self,
    ) -> std::option::Option<&crate::model::RecommenderUpdateSummary> {
        self.latest_recommender_update.as_ref()
    }
}
impl std::fmt::Debug for Recommender {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recommender");
        formatter.field("recommender_arn", &self.recommender_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("name", &self.name);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("recommender_config", &self.recommender_config);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("latest_recommender_update", &self.latest_recommender_update);
        formatter.finish()
    }
}
/// See [`Recommender`](crate::model::Recommender)
pub mod recommender {
    /// A builder for [`Recommender`](crate::model::Recommender)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) recommender_config: std::option::Option<crate::model::RecommenderConfig>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) latest_recommender_update:
            std::option::Option<crate::model::RecommenderUpdateSummary>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
        pub fn recommender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The name of the recommender.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recommender.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for. </p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for. </p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn recommender_config(mut self, input: crate::model::RecommenderConfig) -> Self {
            self.recommender_config = Some(input);
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn set_recommender_config(
            mut self,
            input: std::option::Option<crate::model::RecommenderConfig>,
        ) -> Self {
            self.recommender_config = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recommender was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The status of the recommender.</p>
        /// <p>A recommender can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the recommender.</p>
        /// <p>A recommender can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If a recommender fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a recommender fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Provides a summary of the latest updates to the recommender. </p>
        pub fn latest_recommender_update(
            mut self,
            input: crate::model::RecommenderUpdateSummary,
        ) -> Self {
            self.latest_recommender_update = Some(input);
            self
        }
        /// <p>Provides a summary of the latest updates to the recommender. </p>
        pub fn set_latest_recommender_update(
            mut self,
            input: std::option::Option<crate::model::RecommenderUpdateSummary>,
        ) -> Self {
            self.latest_recommender_update = input;
            self
        }
        /// Consumes the builder and constructs a [`Recommender`](crate::model::Recommender)
        pub fn build(self) -> crate::model::Recommender {
            crate::model::Recommender {
                recommender_arn: self.recommender_arn,
                dataset_group_arn: self.dataset_group_arn,
                name: self.name,
                recipe_arn: self.recipe_arn,
                recommender_config: self.recommender_config,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                status: self.status,
                failure_reason: self.failure_reason,
                latest_recommender_update: self.latest_recommender_update,
            }
        }
    }
}
impl Recommender {
    /// Creates a new builder-style object to manufacture [`Recommender`](crate::model::Recommender)
    pub fn builder() -> crate::model::recommender::Builder {
        crate::model::recommender::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a recommender update. For a complete listing, call the DescribeRecommender API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommenderUpdateSummary {
    /// <p>The configuration details of the recommender update.</p>
    pub recommender_config: std::option::Option<crate::model::RecommenderConfig>,
    /// <p>The date and time (in Unix format) that the recommender update was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the recommender update was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the recommender update.</p>
    /// <p>A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If a recommender update fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl RecommenderUpdateSummary {
    /// <p>The configuration details of the recommender update.</p>
    pub fn recommender_config(&self) -> std::option::Option<&crate::model::RecommenderConfig> {
        self.recommender_config.as_ref()
    }
    /// <p>The date and time (in Unix format) that the recommender update was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the recommender update was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The status of the recommender update.</p>
    /// <p>A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If a recommender update fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for RecommenderUpdateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommenderUpdateSummary");
        formatter.field("recommender_config", &self.recommender_config);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`RecommenderUpdateSummary`](crate::model::RecommenderUpdateSummary)
pub mod recommender_update_summary {
    /// A builder for [`RecommenderUpdateSummary`](crate::model::RecommenderUpdateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_config: std::option::Option<crate::model::RecommenderConfig>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The configuration details of the recommender update.</p>
        pub fn recommender_config(mut self, input: crate::model::RecommenderConfig) -> Self {
            self.recommender_config = Some(input);
            self
        }
        /// <p>The configuration details of the recommender update.</p>
        pub fn set_recommender_config(
            mut self,
            input: std::option::Option<crate::model::RecommenderConfig>,
        ) -> Self {
            self.recommender_config = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recommender update was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recommender update was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the recommender update was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the recommender update was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The status of the recommender update.</p>
        /// <p>A recommender can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the recommender update.</p>
        /// <p>A recommender can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If a recommender update fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a recommender update fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommenderUpdateSummary`](crate::model::RecommenderUpdateSummary)
        pub fn build(self) -> crate::model::RecommenderUpdateSummary {
            crate::model::RecommenderUpdateSummary {
                recommender_config: self.recommender_config,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                status: self.status,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl RecommenderUpdateSummary {
    /// Creates a new builder-style object to manufacture [`RecommenderUpdateSummary`](crate::model::RecommenderUpdateSummary)
    pub fn builder() -> crate::model::recommender_update_summary::Builder {
        crate::model::recommender_update_summary::Builder::default()
    }
}

/// <p>Provides information about a recipe. Each recipe provides an algorithm that Amazon Personalize uses in model training when you use the <code>CreateSolution</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recipe {
    /// <p>The name of the recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.</p>
    pub algorithm_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the FeatureTransformation object.</p>
    pub feature_transformation_arn: std::option::Option<std::string::String>,
    /// <p>The status of the recipe.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The description of the recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix format) that the recipe was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>One of the following values:</p>
    /// <ul>
    /// <li> <p>PERSONALIZED_RANKING</p> </li>
    /// <li> <p>RELATED_ITEMS</p> </li>
    /// <li> <p>USER_PERSONALIZATION</p> </li>
    /// </ul>
    pub recipe_type: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix format) that the recipe was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Recipe {
    /// <p>The name of the recipe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.</p>
    pub fn algorithm_arn(&self) -> std::option::Option<&str> {
        self.algorithm_arn.as_deref()
    }
    /// <p>The ARN of the FeatureTransformation object.</p>
    pub fn feature_transformation_arn(&self) -> std::option::Option<&str> {
        self.feature_transformation_arn.as_deref()
    }
    /// <p>The status of the recipe.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The description of the recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time (in Unix format) that the recipe was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>One of the following values:</p>
    /// <ul>
    /// <li> <p>PERSONALIZED_RANKING</p> </li>
    /// <li> <p>RELATED_ITEMS</p> </li>
    /// <li> <p>USER_PERSONALIZATION</p> </li>
    /// </ul>
    pub fn recipe_type(&self) -> std::option::Option<&str> {
        self.recipe_type.as_deref()
    }
    /// <p>The date and time (in Unix format) that the recipe was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for Recipe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recipe");
        formatter.field("name", &self.name);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("algorithm_arn", &self.algorithm_arn);
        formatter.field(
            "feature_transformation_arn",
            &self.feature_transformation_arn,
        );
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("recipe_type", &self.recipe_type);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`Recipe`](crate::model::Recipe)
pub mod recipe {
    /// A builder for [`Recipe`](crate::model::Recipe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) algorithm_arn: std::option::Option<std::string::String>,
        pub(crate) feature_transformation_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) recipe_type: std::option::Option<std::string::String>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.</p>
        pub fn algorithm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_arn = input;
            self
        }
        /// <p>The ARN of the FeatureTransformation object.</p>
        pub fn feature_transformation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_transformation_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the FeatureTransformation object.</p>
        pub fn set_feature_transformation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_transformation_arn = input;
            self
        }
        /// <p>The status of the recipe.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the recipe.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recipe was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recipe was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>One of the following values:</p>
        /// <ul>
        /// <li> <p>PERSONALIZED_RANKING</p> </li>
        /// <li> <p>RELATED_ITEMS</p> </li>
        /// <li> <p>USER_PERSONALIZATION</p> </li>
        /// </ul>
        pub fn recipe_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_type = Some(input.into());
            self
        }
        /// <p>One of the following values:</p>
        /// <ul>
        /// <li> <p>PERSONALIZED_RANKING</p> </li>
        /// <li> <p>RELATED_ITEMS</p> </li>
        /// <li> <p>USER_PERSONALIZATION</p> </li>
        /// </ul>
        pub fn set_recipe_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_type = input;
            self
        }
        /// <p>The date and time (in Unix format) that the recipe was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the recipe was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Recipe`](crate::model::Recipe)
        pub fn build(self) -> crate::model::Recipe {
            crate::model::Recipe {
                name: self.name,
                recipe_arn: self.recipe_arn,
                algorithm_arn: self.algorithm_arn,
                feature_transformation_arn: self.feature_transformation_arn,
                status: self.status,
                description: self.description,
                creation_date_time: self.creation_date_time,
                recipe_type: self.recipe_type,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl Recipe {
    /// Creates a new builder-style object to manufacture [`Recipe`](crate::model::Recipe)
    pub fn builder() -> crate::model::recipe::Builder {
        crate::model::recipe::Builder::default()
    }
}

/// <p>Contains information on a recommendation filter, including its ARN, status, and filter expression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the filter.</p>
    pub filter_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the filter was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the filter was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ARN of the dataset group to which the filter belongs.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>If the filter failed, the reason for its failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see <code>filter-expressions</code>.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>The status of the filter.</p>
    pub status: std::option::Option<std::string::String>,
}
impl Filter {
    /// <p>The name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the filter.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
    /// <p>The time at which the filter was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The time at which the filter was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The ARN of the dataset group to which the filter belongs.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>If the filter failed, the reason for its failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see <code>filter-expressions</code>.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>The status of the filter.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("filter_arn", &self.filter_arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("filter_expression", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filter_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the filter.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// <p>The time at which the filter was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time at which the filter was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time at which the filter was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The time at which the filter was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The ARN of the dataset group to which the filter belongs.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group to which the filter belongs.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>If the filter failed, the reason for its failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the filter failed, the reason for its failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see <code>filter-expressions</code>.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see <code>filter-expressions</code>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>The status of the filter.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the filter.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                filter_arn: self.filter_arn,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                dataset_group_arn: self.dataset_group_arn,
                failure_reason: self.failure_reason,
                filter_expression: self.filter_expression,
                status: self.status,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Provides feature transformation information. Feature transformation is the process of modifying raw input data into a form more suitable for model training.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeatureTransformation {
    /// <p>The name of the feature transformation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the FeatureTransformation object.</p>
    pub feature_transformation_arn: std::option::Option<std::string::String>,
    /// <p>Provides the default parameters for feature transformation.</p>
    pub default_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The creation date and time (in Unix time) of the feature transformation.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last update date and time (in Unix time) of the feature transformation.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the feature transformation.</p>
    /// <p>A feature transformation can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
}
impl FeatureTransformation {
    /// <p>The name of the feature transformation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the FeatureTransformation object.</p>
    pub fn feature_transformation_arn(&self) -> std::option::Option<&str> {
        self.feature_transformation_arn.as_deref()
    }
    /// <p>Provides the default parameters for feature transformation.</p>
    pub fn default_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.default_parameters.as_ref()
    }
    /// <p>The creation date and time (in Unix time) of the feature transformation.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The last update date and time (in Unix time) of the feature transformation.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The status of the feature transformation.</p>
    /// <p>A feature transformation can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for FeatureTransformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeatureTransformation");
        formatter.field("name", &self.name);
        formatter.field(
            "feature_transformation_arn",
            &self.feature_transformation_arn,
        );
        formatter.field("default_parameters", &self.default_parameters);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`FeatureTransformation`](crate::model::FeatureTransformation)
pub mod feature_transformation {
    /// A builder for [`FeatureTransformation`](crate::model::FeatureTransformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) feature_transformation_arn: std::option::Option<std::string::String>,
        pub(crate) default_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the feature transformation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the feature transformation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FeatureTransformation object.</p>
        pub fn feature_transformation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_transformation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FeatureTransformation object.</p>
        pub fn set_feature_transformation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_transformation_arn = input;
            self
        }
        /// Adds a key-value pair to `default_parameters`.
        ///
        /// To override the contents of this collection use [`set_default_parameters`](Self::set_default_parameters).
        ///
        /// <p>Provides the default parameters for feature transformation.</p>
        pub fn default_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.default_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.default_parameters = Some(hash_map);
            self
        }
        /// <p>Provides the default parameters for feature transformation.</p>
        pub fn set_default_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.default_parameters = input;
            self
        }
        /// <p>The creation date and time (in Unix time) of the feature transformation.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time (in Unix time) of the feature transformation.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The last update date and time (in Unix time) of the feature transformation.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The last update date and time (in Unix time) of the feature transformation.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The status of the feature transformation.</p>
        /// <p>A feature transformation can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the feature transformation.</p>
        /// <p>A feature transformation can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`FeatureTransformation`](crate::model::FeatureTransformation)
        pub fn build(self) -> crate::model::FeatureTransformation {
            crate::model::FeatureTransformation {
                name: self.name,
                feature_transformation_arn: self.feature_transformation_arn,
                default_parameters: self.default_parameters,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                status: self.status,
            }
        }
    }
}
impl FeatureTransformation {
    /// Creates a new builder-style object to manufacture [`FeatureTransformation`](crate::model::FeatureTransformation)
    pub fn builder() -> crate::model::feature_transformation::Builder {
        crate::model::feature_transformation::Builder::default()
    }
}

/// <p>Provides information about an event tracker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTracker {
    /// <p>The name of the event tracker.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the event tracker.</p>
    pub event_tracker_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account that owns the event tracker.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
    pub tracking_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The status of the event tracker.</p>
    /// <p>An event tracker can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix format) that the event tracker was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EventTracker {
    /// <p>The name of the event tracker.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the event tracker.</p>
    pub fn event_tracker_arn(&self) -> std::option::Option<&str> {
        self.event_tracker_arn.as_deref()
    }
    /// <p>The Amazon Web Services account that owns the event tracker.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
    pub fn tracking_id(&self) -> std::option::Option<&str> {
        self.tracking_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The status of the event tracker.</p>
    /// <p>An event tracker can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time (in Unix format) that the event tracker was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for EventTracker {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTracker");
        formatter.field("name", &self.name);
        formatter.field("event_tracker_arn", &self.event_tracker_arn);
        formatter.field("account_id", &self.account_id);
        formatter.field("tracking_id", &self.tracking_id);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`EventTracker`](crate::model::EventTracker)
pub mod event_tracker {
    /// A builder for [`EventTracker`](crate::model::EventTracker)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_tracker_arn: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) tracking_id: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the event tracker.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event tracker.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the event tracker.</p>
        pub fn event_tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_tracker_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event tracker.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_tracker_arn = input;
            self
        }
        /// <p>The Amazon Web Services account that owns the event tracker.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that owns the event tracker.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
        pub fn tracking_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_id = Some(input.into());
            self
        }
        /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
        pub fn set_tracking_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracking_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The status of the event tracker.</p>
        /// <p>An event tracker can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the event tracker.</p>
        /// <p>An event tracker can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (in Unix format) that the event tracker was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the event tracker was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the event tracker was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTracker`](crate::model::EventTracker)
        pub fn build(self) -> crate::model::EventTracker {
            crate::model::EventTracker {
                name: self.name,
                event_tracker_arn: self.event_tracker_arn,
                account_id: self.account_id,
                tracking_id: self.tracking_id,
                dataset_group_arn: self.dataset_group_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl EventTracker {
    /// Creates a new builder-style object to manufacture [`EventTracker`](crate::model::EventTracker)
    pub fn builder() -> crate::model::event_tracker::Builder {
        crate::model::event_tracker::Builder::default()
    }
}

/// <p>Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset. For more information, see <code>CreateDatasetImportJob</code>.</p>
/// <p>A dataset import job can be in one of the following states:</p>
/// <ul>
/// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetImportJob {
    /// <p>The name of the import job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset import job.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset that receives the imported data.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket that contains the training data to import.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the dataset import job.</p>
    /// <p>A dataset import job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The creation date and time (in Unix time) of the dataset import job.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) the dataset was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If a dataset import job fails, provides the reason why.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl DatasetImportJob {
    /// <p>The name of the import job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The ARN of the dataset import job.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset that receives the imported data.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The Amazon S3 bucket that contains the training data to import.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the dataset import job.</p>
    /// <p>A dataset import job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The creation date and time (in Unix time) of the dataset import job.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) the dataset was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If a dataset import job fails, provides the reason why.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for DatasetImportJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetImportJob");
        formatter.field("job_name", &self.job_name);
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("data_source", &self.data_source);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`DatasetImportJob`](crate::model::DatasetImportJob)
pub mod dataset_import_job {
    /// A builder for [`DatasetImportJob`](crate::model::DatasetImportJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The ARN of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that receives the imported data.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that receives the imported data.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The Amazon S3 bucket that contains the training data to import.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains the training data to import.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the dataset import job.</p>
        /// <p>A dataset import job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset import job.</p>
        /// <p>A dataset import job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset import job.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset import job.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) the dataset was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) the dataset was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If a dataset import job fails, provides the reason why.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a dataset import job fails, provides the reason why.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetImportJob`](crate::model::DatasetImportJob)
        pub fn build(self) -> crate::model::DatasetImportJob {
            crate::model::DatasetImportJob {
                job_name: self.job_name,
                dataset_import_job_arn: self.dataset_import_job_arn,
                dataset_arn: self.dataset_arn,
                data_source: self.data_source,
                role_arn: self.role_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl DatasetImportJob {
    /// Creates a new builder-style object to manufacture [`DatasetImportJob`](crate::model::DatasetImportJob)
    pub fn builder() -> crate::model::dataset_import_job::Builder {
        crate::model::dataset_import_job::Builder::default()
    }
}

/// <p>Describes the data source that contains the data to upload to a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSource {
    /// <p>The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For example: </p>
    /// <p> <code>s3://bucket-name/folder-name/</code> </p>
    pub data_location: std::option::Option<std::string::String>,
}
impl DataSource {
    /// <p>The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For example: </p>
    /// <p> <code>s3://bucket-name/folder-name/</code> </p>
    pub fn data_location(&self) -> std::option::Option<&str> {
        self.data_location.as_deref()
    }
}
impl std::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSource");
        formatter.field("data_location", &self.data_location);
        formatter.finish()
    }
}
/// See [`DataSource`](crate::model::DataSource)
pub mod data_source {
    /// A builder for [`DataSource`](crate::model::DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For example: </p>
        /// <p> <code>s3://bucket-name/folder-name/</code> </p>
        pub fn data_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_location = Some(input.into());
            self
        }
        /// <p>The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For example: </p>
        /// <p> <code>s3://bucket-name/folder-name/</code> </p>
        pub fn set_data_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_location = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSource`](crate::model::DataSource)
        pub fn build(self) -> crate::model::DataSource {
            crate::model::DataSource {
                data_location: self.data_location,
            }
        }
    }
}
impl DataSource {
    /// Creates a new builder-style object to manufacture [`DataSource`](crate::model::DataSource)
    pub fn builder() -> crate::model::data_source::Builder {
        crate::model::data_source::Builder::default()
    }
}

/// <p>A dataset group is a collection of related datasets (Interactions, User, and Item). You create a dataset group by calling <code>CreateDatasetGroup</code>. You then create a dataset and add it to a dataset group by calling <code>CreateDataset</code>. The dataset group is used to create and train a solution by calling <code>CreateSolution</code>. A dataset group can contain only one of each type of dataset.</p>
/// <p>You can specify an Key Management Service (KMS) key to encrypt the datasets in the group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetGroup {
    /// <p>The name of the dataset group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the dataset group.</p>
    /// <p>A dataset group can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that has permissions to create the dataset group.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The creation date and time (in Unix time) of the dataset group.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last update date and time (in Unix time) of the dataset group.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If creating a dataset group fails, provides the reason why.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The domain of a Domain dataset group.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl DatasetGroup {
    /// <p>The name of the dataset group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The current status of the dataset group.</p>
    /// <p>A dataset group can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The ARN of the IAM role that has permissions to create the dataset group.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The creation date and time (in Unix time) of the dataset group.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The last update date and time (in Unix time) of the dataset group.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If creating a dataset group fails, provides the reason why.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The domain of a Domain dataset group.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for DatasetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetGroup");
        formatter.field("name", &self.name);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("status", &self.status);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DatasetGroup`](crate::model::DatasetGroup)
pub mod dataset_group {
    /// A builder for [`DatasetGroup`](crate::model::DatasetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>The name of the dataset group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The current status of the dataset group.</p>
        /// <p>A dataset group can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the dataset group.</p>
        /// <p>A dataset group can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The ARN of the IAM role that has permissions to create the dataset group.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that has permissions to create the dataset group.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset group.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset group.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The last update date and time (in Unix time) of the dataset group.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The last update date and time (in Unix time) of the dataset group.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If creating a dataset group fails, provides the reason why.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If creating a dataset group fails, provides the reason why.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The domain of a Domain dataset group.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain of a Domain dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetGroup`](crate::model::DatasetGroup)
        pub fn build(self) -> crate::model::DatasetGroup {
            crate::model::DatasetGroup {
                name: self.name,
                dataset_group_arn: self.dataset_group_arn,
                status: self.status,
                role_arn: self.role_arn,
                kms_key_arn: self.kms_key_arn,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
                domain: self.domain,
            }
        }
    }
}
impl DatasetGroup {
    /// Creates a new builder-style object to manufacture [`DatasetGroup`](crate::model::DatasetGroup)
    pub fn builder() -> crate::model::dataset_group::Builder {
        crate::model::dataset_group::Builder::default()
    }
}

/// <p>Describes a job that exports a dataset to an Amazon S3 bucket. For more information, see <code>CreateDatasetExportJob</code>.</p>
/// <p>A dataset export job can be in one of the following states:</p>
/// <ul>
/// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetExportJob {
    /// <p>The name of the export job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
    pub dataset_export_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset to export.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is <code>PUT</code>. </p>
    pub ingestion_mode: std::option::Option<crate::model::IngestionMode>,
    /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the dataset export job.</p>
    /// <p>A dataset export job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The path to the Amazon S3 bucket where the job's output is stored. For example:</p>
    /// <p> <code>s3://bucket-name/folder-name/</code> </p>
    pub job_output: std::option::Option<crate::model::DatasetExportJobOutput>,
    /// <p>The creation date and time (in Unix time) of the dataset export job.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) the status of the dataset export job was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If a dataset export job fails, provides the reason why.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl DatasetExportJob {
    /// <p>The name of the export job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
    pub fn dataset_export_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_export_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset to export.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is <code>PUT</code>. </p>
    pub fn ingestion_mode(&self) -> std::option::Option<&crate::model::IngestionMode> {
        self.ingestion_mode.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the dataset export job.</p>
    /// <p>A dataset export job can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The path to the Amazon S3 bucket where the job's output is stored. For example:</p>
    /// <p> <code>s3://bucket-name/folder-name/</code> </p>
    pub fn job_output(&self) -> std::option::Option<&crate::model::DatasetExportJobOutput> {
        self.job_output.as_ref()
    }
    /// <p>The creation date and time (in Unix time) of the dataset export job.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) the status of the dataset export job was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>If a dataset export job fails, provides the reason why.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for DatasetExportJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetExportJob");
        formatter.field("job_name", &self.job_name);
        formatter.field("dataset_export_job_arn", &self.dataset_export_job_arn);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("ingestion_mode", &self.ingestion_mode);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("job_output", &self.job_output);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`DatasetExportJob`](crate::model::DatasetExportJob)
pub mod dataset_export_job {
    /// A builder for [`DatasetExportJob`](crate::model::DatasetExportJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) dataset_export_job_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_mode: std::option::Option<crate::model::IngestionMode>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) job_output: std::option::Option<crate::model::DatasetExportJobOutput>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the export job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
        pub fn dataset_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
        pub fn set_dataset_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_export_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to export.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to export.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is <code>PUT</code>. </p>
        pub fn ingestion_mode(mut self, input: crate::model::IngestionMode) -> Self {
            self.ingestion_mode = Some(input);
            self
        }
        /// <p>The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is <code>PUT</code>. </p>
        pub fn set_ingestion_mode(
            mut self,
            input: std::option::Option<crate::model::IngestionMode>,
        ) -> Self {
            self.ingestion_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the dataset export job.</p>
        /// <p>A dataset export job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset export job.</p>
        /// <p>A dataset export job can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output is stored. For example:</p>
        /// <p> <code>s3://bucket-name/folder-name/</code> </p>
        pub fn job_output(mut self, input: crate::model::DatasetExportJobOutput) -> Self {
            self.job_output = Some(input);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output is stored. For example:</p>
        /// <p> <code>s3://bucket-name/folder-name/</code> </p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::DatasetExportJobOutput>,
        ) -> Self {
            self.job_output = input;
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset export job.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset export job.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) the status of the dataset export job was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) the status of the dataset export job was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>If a dataset export job fails, provides the reason why.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a dataset export job fails, provides the reason why.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetExportJob`](crate::model::DatasetExportJob)
        pub fn build(self) -> crate::model::DatasetExportJob {
            crate::model::DatasetExportJob {
                job_name: self.job_name,
                dataset_export_job_arn: self.dataset_export_job_arn,
                dataset_arn: self.dataset_arn,
                ingestion_mode: self.ingestion_mode,
                role_arn: self.role_arn,
                status: self.status,
                job_output: self.job_output,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl DatasetExportJob {
    /// Creates a new builder-style object to manufacture [`DatasetExportJob`](crate::model::DatasetExportJob)
    pub fn builder() -> crate::model::dataset_export_job::Builder {
        crate::model::dataset_export_job::Builder::default()
    }
}

/// <p>The output configuration parameters of a dataset export job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetExportJobOutput {
    /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
    pub s3_data_destination: std::option::Option<crate::model::S3DataConfig>,
}
impl DatasetExportJobOutput {
    /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
    pub fn s3_data_destination(&self) -> std::option::Option<&crate::model::S3DataConfig> {
        self.s3_data_destination.as_ref()
    }
}
impl std::fmt::Debug for DatasetExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetExportJobOutput");
        formatter.field("s3_data_destination", &self.s3_data_destination);
        formatter.finish()
    }
}
/// See [`DatasetExportJobOutput`](crate::model::DatasetExportJobOutput)
pub mod dataset_export_job_output {
    /// A builder for [`DatasetExportJobOutput`](crate::model::DatasetExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_destination: std::option::Option<crate::model::S3DataConfig>,
    }
    impl Builder {
        /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
        pub fn s3_data_destination(mut self, input: crate::model::S3DataConfig) -> Self {
            self.s3_data_destination = Some(input);
            self
        }
        /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
        pub fn set_s3_data_destination(
            mut self,
            input: std::option::Option<crate::model::S3DataConfig>,
        ) -> Self {
            self.s3_data_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetExportJobOutput`](crate::model::DatasetExportJobOutput)
        pub fn build(self) -> crate::model::DatasetExportJobOutput {
            crate::model::DatasetExportJobOutput {
                s3_data_destination: self.s3_data_destination,
            }
        }
    }
}
impl DatasetExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DatasetExportJobOutput`](crate::model::DatasetExportJobOutput)
    pub fn builder() -> crate::model::dataset_export_job_output::Builder {
        crate::model::dataset_export_job_output::Builder::default()
    }
}

/// <p>The configuration details of an Amazon S3 input or output bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DataConfig {
    /// <p>The file path of the Amazon S3 bucket.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl S3DataConfig {
    /// <p>The file path of the Amazon S3 bucket.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for S3DataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DataConfig");
        formatter.field("path", &self.path);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3DataConfig`](crate::model::S3DataConfig)
pub mod s3_data_config {
    /// A builder for [`S3DataConfig`](crate::model::S3DataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The file path of the Amazon S3 bucket.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The file path of the Amazon S3 bucket.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DataConfig`](crate::model::S3DataConfig)
        pub fn build(self) -> crate::model::S3DataConfig {
            crate::model::S3DataConfig {
                path: self.path,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3DataConfig {
    /// Creates a new builder-style object to manufacture [`S3DataConfig`](crate::model::S3DataConfig)
    pub fn builder() -> crate::model::s3_data_config::Builder {
        crate::model::s3_data_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionMode {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Bulk,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionMode {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => IngestionMode::All,
            "BULK" => IngestionMode::Bulk,
            "PUT" => IngestionMode::Put,
            other => IngestionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionMode::from(s))
    }
}
impl IngestionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionMode::All => "ALL",
            IngestionMode::Bulk => "BULK",
            IngestionMode::Put => "PUT",
            IngestionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "BULK", "PUT"]
    }
}
impl AsRef<str> for IngestionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides metadata for a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dataset {
    /// <p>The name of the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset that you want metadata for.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>One of the following values:</p>
    /// <ul>
    /// <li> <p>Interactions</p> </li>
    /// <li> <p>Items</p> </li>
    /// <li> <p>Users</p> </li>
    /// </ul>
    pub dataset_type: std::option::Option<std::string::String>,
    /// <p>The ARN of the associated schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The status of the dataset.</p>
    /// <p>A dataset can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The creation date and time (in Unix time) of the dataset.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A time stamp that shows when the dataset was updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Dataset {
    /// <p>The name of the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset that you want metadata for.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>One of the following values:</p>
    /// <ul>
    /// <li> <p>Interactions</p> </li>
    /// <li> <p>Items</p> </li>
    /// <li> <p>Users</p> </li>
    /// </ul>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
    /// <p>The ARN of the associated schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The status of the dataset.</p>
    /// <p>A dataset can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The creation date and time (in Unix time) of the dataset.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A time stamp that shows when the dataset was updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for Dataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dataset");
        formatter.field("name", &self.name);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`Dataset`](crate::model::Dataset)
pub mod dataset {
    /// A builder for [`Dataset`](crate::model::Dataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that you want metadata for.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that you want metadata for.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>One of the following values:</p>
        /// <ul>
        /// <li> <p>Interactions</p> </li>
        /// <li> <p>Items</p> </li>
        /// <li> <p>Users</p> </li>
        /// </ul>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>One of the following values:</p>
        /// <ul>
        /// <li> <p>Interactions</p> </li>
        /// <li> <p>Items</p> </li>
        /// <li> <p>Users</p> </li>
        /// </ul>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>The ARN of the associated schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the associated schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The status of the dataset.</p>
        /// <p>A dataset can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the dataset.</p>
        /// <p>A dataset can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation date and time (in Unix time) of the dataset.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A time stamp that shows when the dataset was updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A time stamp that shows when the dataset was updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Dataset`](crate::model::Dataset)
        pub fn build(self) -> crate::model::Dataset {
            crate::model::Dataset {
                name: self.name,
                dataset_arn: self.dataset_arn,
                dataset_group_arn: self.dataset_group_arn,
                dataset_type: self.dataset_type,
                schema_arn: self.schema_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl Dataset {
    /// Creates a new builder-style object to manufacture [`Dataset`](crate::model::Dataset)
    pub fn builder() -> crate::model::dataset::Builder {
        crate::model::dataset::Builder::default()
    }
}

/// <p>An object that describes the deployment of a solution version. For more information on campaigns, see <code>CreateCampaign</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Campaign {
    /// <p>The name of the campaign.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the campaign. </p>
    pub campaign_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a specific version of the solution.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second.</p>
    pub min_provisioned_tps: std::option::Option<i32>,
    /// <p>The configuration details of a campaign.</p>
    pub campaign_config: std::option::Option<crate::model::CampaignConfig>,
    /// <p>The status of the campaign.</p>
    /// <p>A campaign can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If a campaign fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix format) that the campaign was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix format) that the campaign was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Provides a summary of the properties of a campaign update. For a complete listing, call the <code>DescribeCampaign</code> API.</p>
    pub latest_campaign_update: std::option::Option<crate::model::CampaignUpdateSummary>,
}
impl Campaign {
    /// <p>The name of the campaign.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the campaign. </p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a specific version of the solution.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second.</p>
    pub fn min_provisioned_tps(&self) -> std::option::Option<i32> {
        self.min_provisioned_tps
    }
    /// <p>The configuration details of a campaign.</p>
    pub fn campaign_config(&self) -> std::option::Option<&crate::model::CampaignConfig> {
        self.campaign_config.as_ref()
    }
    /// <p>The status of the campaign.</p>
    /// <p>A campaign can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If a campaign fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date and time (in Unix format) that the campaign was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix format) that the campaign was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Provides a summary of the properties of a campaign update. For a complete listing, call the <code>DescribeCampaign</code> API.</p>
    pub fn latest_campaign_update(
        &self,
    ) -> std::option::Option<&crate::model::CampaignUpdateSummary> {
        self.latest_campaign_update.as_ref()
    }
}
impl std::fmt::Debug for Campaign {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Campaign");
        formatter.field("name", &self.name);
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("min_provisioned_tps", &self.min_provisioned_tps);
        formatter.field("campaign_config", &self.campaign_config);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("latest_campaign_update", &self.latest_campaign_update);
        formatter.finish()
    }
}
/// See [`Campaign`](crate::model::Campaign)
pub mod campaign {
    /// A builder for [`Campaign`](crate::model::Campaign)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) min_provisioned_tps: std::option::Option<i32>,
        pub(crate) campaign_config: std::option::Option<crate::model::CampaignConfig>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_campaign_update: std::option::Option<crate::model::CampaignUpdateSummary>,
    }
    impl Builder {
        /// <p>The name of the campaign.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the campaign.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign. </p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign. </p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a specific version of the solution.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a specific version of the solution.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second.</p>
        pub fn min_provisioned_tps(mut self, input: i32) -> Self {
            self.min_provisioned_tps = Some(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second.</p>
        pub fn set_min_provisioned_tps(mut self, input: std::option::Option<i32>) -> Self {
            self.min_provisioned_tps = input;
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn campaign_config(mut self, input: crate::model::CampaignConfig) -> Self {
            self.campaign_config = Some(input);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn set_campaign_config(
            mut self,
            input: std::option::Option<crate::model::CampaignConfig>,
        ) -> Self {
            self.campaign_config = input;
            self
        }
        /// <p>The status of the campaign.</p>
        /// <p>A campaign can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the campaign.</p>
        /// <p>A campaign can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If a campaign fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a campaign fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date and time (in Unix format) that the campaign was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the campaign was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix format) that the campaign was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix format) that the campaign was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Provides a summary of the properties of a campaign update. For a complete listing, call the <code>DescribeCampaign</code> API.</p>
        pub fn latest_campaign_update(
            mut self,
            input: crate::model::CampaignUpdateSummary,
        ) -> Self {
            self.latest_campaign_update = Some(input);
            self
        }
        /// <p>Provides a summary of the properties of a campaign update. For a complete listing, call the <code>DescribeCampaign</code> API.</p>
        pub fn set_latest_campaign_update(
            mut self,
            input: std::option::Option<crate::model::CampaignUpdateSummary>,
        ) -> Self {
            self.latest_campaign_update = input;
            self
        }
        /// Consumes the builder and constructs a [`Campaign`](crate::model::Campaign)
        pub fn build(self) -> crate::model::Campaign {
            crate::model::Campaign {
                name: self.name,
                campaign_arn: self.campaign_arn,
                solution_version_arn: self.solution_version_arn,
                min_provisioned_tps: self.min_provisioned_tps,
                campaign_config: self.campaign_config,
                status: self.status,
                failure_reason: self.failure_reason,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                latest_campaign_update: self.latest_campaign_update,
            }
        }
    }
}
impl Campaign {
    /// Creates a new builder-style object to manufacture [`Campaign`](crate::model::Campaign)
    pub fn builder() -> crate::model::campaign::Builder {
        crate::model::campaign::Builder::default()
    }
}

/// <p>Provides a summary of the properties of a campaign update. For a complete listing, call the <code>DescribeCampaign</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CampaignUpdateSummary {
    /// <p>The Amazon Resource Name (ARN) of the deployed solution version.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.</p>
    pub min_provisioned_tps: std::option::Option<i32>,
    /// <p>The configuration details of a campaign.</p>
    pub campaign_config: std::option::Option<crate::model::CampaignConfig>,
    /// <p>The status of the campaign update.</p>
    /// <p>A campaign update can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>If a campaign update fails, the reason behind the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the campaign update was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the campaign update was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CampaignUpdateSummary {
    /// <p>The Amazon Resource Name (ARN) of the deployed solution version.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.</p>
    pub fn min_provisioned_tps(&self) -> std::option::Option<i32> {
        self.min_provisioned_tps
    }
    /// <p>The configuration details of a campaign.</p>
    pub fn campaign_config(&self) -> std::option::Option<&crate::model::CampaignConfig> {
        self.campaign_config.as_ref()
    }
    /// <p>The status of the campaign update.</p>
    /// <p>A campaign update can be in one of the following states:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
    /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If a campaign update fails, the reason behind the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date and time (in Unix time) that the campaign update was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the campaign update was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for CampaignUpdateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CampaignUpdateSummary");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("min_provisioned_tps", &self.min_provisioned_tps);
        formatter.field("campaign_config", &self.campaign_config);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`CampaignUpdateSummary`](crate::model::CampaignUpdateSummary)
pub mod campaign_update_summary {
    /// A builder for [`CampaignUpdateSummary`](crate::model::CampaignUpdateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) min_provisioned_tps: std::option::Option<i32>,
        pub(crate) campaign_config: std::option::Option<crate::model::CampaignConfig>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deployed solution version.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployed solution version.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.</p>
        pub fn min_provisioned_tps(mut self, input: i32) -> Self {
            self.min_provisioned_tps = Some(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.</p>
        pub fn set_min_provisioned_tps(mut self, input: std::option::Option<i32>) -> Self {
            self.min_provisioned_tps = input;
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn campaign_config(mut self, input: crate::model::CampaignConfig) -> Self {
            self.campaign_config = Some(input);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn set_campaign_config(
            mut self,
            input: std::option::Option<crate::model::CampaignConfig>,
        ) -> Self {
            self.campaign_config = input;
            self
        }
        /// <p>The status of the campaign update.</p>
        /// <p>A campaign update can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the campaign update.</p>
        /// <p>A campaign update can be in one of the following states:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li>
        /// <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If a campaign update fails, the reason behind the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If a campaign update fails, the reason behind the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date and time (in Unix time) that the campaign update was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the campaign update was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the campaign update was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the campaign update was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CampaignUpdateSummary`](crate::model::CampaignUpdateSummary)
        pub fn build(self) -> crate::model::CampaignUpdateSummary {
            crate::model::CampaignUpdateSummary {
                solution_version_arn: self.solution_version_arn,
                min_provisioned_tps: self.min_provisioned_tps,
                campaign_config: self.campaign_config,
                status: self.status,
                failure_reason: self.failure_reason,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl CampaignUpdateSummary {
    /// Creates a new builder-style object to manufacture [`CampaignUpdateSummary`](crate::model::CampaignUpdateSummary)
    pub fn builder() -> crate::model::campaign_update_summary::Builder {
        crate::model::campaign_update_summary::Builder::default()
    }
}

/// <p>Contains information on a batch segment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchSegmentJob {
    /// <p>The name of the batch segment job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
    pub batch_segment_job_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the filter used on the batch segment job.</p>
    pub filter_arn: std::option::Option<std::string::String>,
    /// <p>If the batch segment job failed, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The number of predicted users generated by the batch segment job for each line of input data.</p>
    pub num_results: std::option::Option<i32>,
    /// <p>The Amazon S3 path that leads to the input data used to generate the batch segment job.</p>
    pub job_input: std::option::Option<crate::model::BatchSegmentJobInput>,
    /// <p>The Amazon S3 bucket that contains the output data generated by the batch segment job.</p>
    pub job_output: std::option::Option<crate::model::BatchSegmentJobOutput>,
    /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the batch segment job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time at which the batch segment job was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the batch segment job last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BatchSegmentJob {
    /// <p>The name of the batch segment job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
    pub fn batch_segment_job_arn(&self) -> std::option::Option<&str> {
        self.batch_segment_job_arn.as_deref()
    }
    /// <p>The ARN of the filter used on the batch segment job.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
    /// <p>If the batch segment job failed, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The number of predicted users generated by the batch segment job for each line of input data.</p>
    pub fn num_results(&self) -> std::option::Option<i32> {
        self.num_results
    }
    /// <p>The Amazon S3 path that leads to the input data used to generate the batch segment job.</p>
    pub fn job_input(&self) -> std::option::Option<&crate::model::BatchSegmentJobInput> {
        self.job_input.as_ref()
    }
    /// <p>The Amazon S3 bucket that contains the output data generated by the batch segment job.</p>
    pub fn job_output(&self) -> std::option::Option<&crate::model::BatchSegmentJobOutput> {
        self.job_output.as_ref()
    }
    /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the batch segment job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time at which the batch segment job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The time at which the batch segment job last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for BatchSegmentJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchSegmentJob");
        formatter.field("job_name", &self.job_name);
        formatter.field("batch_segment_job_arn", &self.batch_segment_job_arn);
        formatter.field("filter_arn", &self.filter_arn);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("num_results", &self.num_results);
        formatter.field("job_input", &self.job_input);
        formatter.field("job_output", &self.job_output);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`BatchSegmentJob`](crate::model::BatchSegmentJob)
pub mod batch_segment_job {
    /// A builder for [`BatchSegmentJob`](crate::model::BatchSegmentJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) batch_segment_job_arn: std::option::Option<std::string::String>,
        pub(crate) filter_arn: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) num_results: std::option::Option<i32>,
        pub(crate) job_input: std::option::Option<crate::model::BatchSegmentJobInput>,
        pub(crate) job_output: std::option::Option<crate::model::BatchSegmentJobOutput>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the batch segment job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the batch segment job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
        pub fn batch_segment_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_segment_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch segment job.</p>
        pub fn set_batch_segment_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_segment_job_arn = input;
            self
        }
        /// <p>The ARN of the filter used on the batch segment job.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter used on the batch segment job.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// <p>If the batch segment job failed, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the batch segment job failed, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>The number of predicted users generated by the batch segment job for each line of input data.</p>
        pub fn num_results(mut self, input: i32) -> Self {
            self.num_results = Some(input);
            self
        }
        /// <p>The number of predicted users generated by the batch segment job for each line of input data.</p>
        pub fn set_num_results(mut self, input: std::option::Option<i32>) -> Self {
            self.num_results = input;
            self
        }
        /// <p>The Amazon S3 path that leads to the input data used to generate the batch segment job.</p>
        pub fn job_input(mut self, input: crate::model::BatchSegmentJobInput) -> Self {
            self.job_input = Some(input);
            self
        }
        /// <p>The Amazon S3 path that leads to the input data used to generate the batch segment job.</p>
        pub fn set_job_input(
            mut self,
            input: std::option::Option<crate::model::BatchSegmentJobInput>,
        ) -> Self {
            self.job_input = input;
            self
        }
        /// <p>The Amazon S3 bucket that contains the output data generated by the batch segment job.</p>
        pub fn job_output(mut self, input: crate::model::BatchSegmentJobOutput) -> Self {
            self.job_output = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains the output data generated by the batch segment job.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::BatchSegmentJobOutput>,
        ) -> Self {
            self.job_output = input;
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the batch segment job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the batch segment job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the batch segment job was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch segment job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time at which the batch segment job last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch segment job last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSegmentJob`](crate::model::BatchSegmentJob)
        pub fn build(self) -> crate::model::BatchSegmentJob {
            crate::model::BatchSegmentJob {
                job_name: self.job_name,
                batch_segment_job_arn: self.batch_segment_job_arn,
                filter_arn: self.filter_arn,
                failure_reason: self.failure_reason,
                solution_version_arn: self.solution_version_arn,
                num_results: self.num_results,
                job_input: self.job_input,
                job_output: self.job_output,
                role_arn: self.role_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl BatchSegmentJob {
    /// Creates a new builder-style object to manufacture [`BatchSegmentJob`](crate::model::BatchSegmentJob)
    pub fn builder() -> crate::model::batch_segment_job::Builder {
        crate::model::batch_segment_job::Builder::default()
    }
}

/// <p>The output configuration parameters of a batch segment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchSegmentJobOutput {
    /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
    pub s3_data_destination: std::option::Option<crate::model::S3DataConfig>,
}
impl BatchSegmentJobOutput {
    /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
    pub fn s3_data_destination(&self) -> std::option::Option<&crate::model::S3DataConfig> {
        self.s3_data_destination.as_ref()
    }
}
impl std::fmt::Debug for BatchSegmentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchSegmentJobOutput");
        formatter.field("s3_data_destination", &self.s3_data_destination);
        formatter.finish()
    }
}
/// See [`BatchSegmentJobOutput`](crate::model::BatchSegmentJobOutput)
pub mod batch_segment_job_output {
    /// A builder for [`BatchSegmentJobOutput`](crate::model::BatchSegmentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_destination: std::option::Option<crate::model::S3DataConfig>,
    }
    impl Builder {
        /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
        pub fn s3_data_destination(mut self, input: crate::model::S3DataConfig) -> Self {
            self.s3_data_destination = Some(input);
            self
        }
        /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
        pub fn set_s3_data_destination(
            mut self,
            input: std::option::Option<crate::model::S3DataConfig>,
        ) -> Self {
            self.s3_data_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSegmentJobOutput`](crate::model::BatchSegmentJobOutput)
        pub fn build(self) -> crate::model::BatchSegmentJobOutput {
            crate::model::BatchSegmentJobOutput {
                s3_data_destination: self.s3_data_destination,
            }
        }
    }
}
impl BatchSegmentJobOutput {
    /// Creates a new builder-style object to manufacture [`BatchSegmentJobOutput`](crate::model::BatchSegmentJobOutput)
    pub fn builder() -> crate::model::batch_segment_job_output::Builder {
        crate::model::batch_segment_job_output::Builder::default()
    }
}

/// <p>The input configuration of a batch segment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchSegmentJobInput {
    /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
    pub s3_data_source: std::option::Option<crate::model::S3DataConfig>,
}
impl BatchSegmentJobInput {
    /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
    pub fn s3_data_source(&self) -> std::option::Option<&crate::model::S3DataConfig> {
        self.s3_data_source.as_ref()
    }
}
impl std::fmt::Debug for BatchSegmentJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchSegmentJobInput");
        formatter.field("s3_data_source", &self.s3_data_source);
        formatter.finish()
    }
}
/// See [`BatchSegmentJobInput`](crate::model::BatchSegmentJobInput)
pub mod batch_segment_job_input {
    /// A builder for [`BatchSegmentJobInput`](crate::model::BatchSegmentJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_source: std::option::Option<crate::model::S3DataConfig>,
    }
    impl Builder {
        /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
        pub fn s3_data_source(mut self, input: crate::model::S3DataConfig) -> Self {
            self.s3_data_source = Some(input);
            self
        }
        /// <p>The configuration details of an Amazon S3 input or output bucket.</p>
        pub fn set_s3_data_source(
            mut self,
            input: std::option::Option<crate::model::S3DataConfig>,
        ) -> Self {
            self.s3_data_source = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSegmentJobInput`](crate::model::BatchSegmentJobInput)
        pub fn build(self) -> crate::model::BatchSegmentJobInput {
            crate::model::BatchSegmentJobInput {
                s3_data_source: self.s3_data_source,
            }
        }
    }
}
impl BatchSegmentJobInput {
    /// Creates a new builder-style object to manufacture [`BatchSegmentJobInput`](crate::model::BatchSegmentJobInput)
    pub fn builder() -> crate::model::batch_segment_job_input::Builder {
        crate::model::batch_segment_job_input::Builder::default()
    }
}

/// <p>Contains information on a batch inference job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchInferenceJob {
    /// <p>The name of the batch inference job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
    pub batch_inference_job_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the filter used on the batch inference job.</p>
    pub filter_arn: std::option::Option<std::string::String>,
    /// <p>If the batch inference job failed, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.</p>
    pub num_results: std::option::Option<i32>,
    /// <p>The Amazon S3 path that leads to the input data used to generate the batch inference job.</p>
    pub job_input: std::option::Option<crate::model::BatchInferenceJobInput>,
    /// <p>The Amazon S3 bucket that contains the output data generated by the batch inference job.</p>
    pub job_output: std::option::Option<crate::model::BatchInferenceJobOutput>,
    /// <p>A string to string map of the configuration details of a batch inference job.</p>
    pub batch_inference_job_config: std::option::Option<crate::model::BatchInferenceJobConfig>,
    /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the batch inference job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time at which the batch inference job was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the batch inference job was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BatchInferenceJob {
    /// <p>The name of the batch inference job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
    pub fn batch_inference_job_arn(&self) -> std::option::Option<&str> {
        self.batch_inference_job_arn.as_deref()
    }
    /// <p>The ARN of the filter used on the batch inference job.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
    /// <p>If the batch inference job failed, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.</p>
    pub fn num_results(&self) -> std::option::Option<i32> {
        self.num_results
    }
    /// <p>The Amazon S3 path that leads to the input data used to generate the batch inference job.</p>
    pub fn job_input(&self) -> std::option::Option<&crate::model::BatchInferenceJobInput> {
        self.job_input.as_ref()
    }
    /// <p>The Amazon S3 bucket that contains the output data generated by the batch inference job.</p>
    pub fn job_output(&self) -> std::option::Option<&crate::model::BatchInferenceJobOutput> {
        self.job_output.as_ref()
    }
    /// <p>A string to string map of the configuration details of a batch inference job.</p>
    pub fn batch_inference_job_config(
        &self,
    ) -> std::option::Option<&crate::model::BatchInferenceJobConfig> {
        self.batch_inference_job_config.as_ref()
    }
    /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the batch inference job. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>PENDING</p> </li>
    /// <li> <p>IN PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time at which the batch inference job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The time at which the batch inference job was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for BatchInferenceJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchInferenceJob");
        formatter.field("job_name", &self.job_name);
        formatter.field("batch_inference_job_arn", &self.batch_inference_job_arn);
        formatter.field("filter_arn", &self.filter_arn);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("num_results", &self.num_results);
        formatter.field("job_input", &self.job_input);
        formatter.field("job_output", &self.job_output);
        formatter.field(
            "batch_inference_job_config",
            &self.batch_inference_job_config,
        );
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`BatchInferenceJob`](crate::model::BatchInferenceJob)
pub mod batch_inference_job {
    /// A builder for [`BatchInferenceJob`](crate::model::BatchInferenceJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) batch_inference_job_arn: std::option::Option<std::string::String>,
        pub(crate) filter_arn: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) num_results: std::option::Option<i32>,
        pub(crate) job_input: std::option::Option<crate::model::BatchInferenceJobInput>,
        pub(crate) job_output: std::option::Option<crate::model::BatchInferenceJobOutput>,
        pub(crate) batch_inference_job_config:
            std::option::Option<crate::model::BatchInferenceJobConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the batch inference job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the batch inference job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
        pub fn batch_inference_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_inference_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch inference job.</p>
        pub fn set_batch_inference_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_inference_job_arn = input;
            self
        }
        /// <p>The ARN of the filter used on the batch inference job.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter used on the batch inference job.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// <p>If the batch inference job failed, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the batch inference job failed, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.</p>
        pub fn num_results(mut self, input: i32) -> Self {
            self.num_results = Some(input);
            self
        }
        /// <p>The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.</p>
        pub fn set_num_results(mut self, input: std::option::Option<i32>) -> Self {
            self.num_results = input;
            self
        }
        /// <p>The Amazon S3 path that leads to the input data used to generate the batch inference job.</p>
        pub fn job_input(mut self, input: crate::model::BatchInferenceJobInput) -> Self {
            self.job_input = Some(input);
            self
        }
        /// <p>The Amazon S3 path that leads to the input data used to generate the batch inference job.</p>
        pub fn set_job_input(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobInput>,
        ) -> Self {
            self.job_input = input;
            self
        }
        /// <p>The Amazon S3 bucket that contains the output data generated by the batch inference job.</p>
        pub fn job_output(mut self, input: crate::model::BatchInferenceJobOutput) -> Self {
            self.job_output = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains the output data generated by the batch inference job.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobOutput>,
        ) -> Self {
            self.job_output = input;
            self
        }
        /// <p>A string to string map of the configuration details of a batch inference job.</p>
        pub fn batch_inference_job_config(
            mut self,
            input: crate::model::BatchInferenceJobConfig,
        ) -> Self {
            self.batch_inference_job_config = Some(input);
            self
        }
        /// <p>A string to string map of the configuration details of a batch inference job.</p>
        pub fn set_batch_inference_job_config(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobConfig>,
        ) -> Self {
            self.batch_inference_job_config = input;
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the batch inference job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the batch inference job. The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>PENDING</p> </li>
        /// <li> <p>IN PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the batch inference job was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch inference job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The time at which the batch inference job was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The time at which the batch inference job was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchInferenceJob`](crate::model::BatchInferenceJob)
        pub fn build(self) -> crate::model::BatchInferenceJob {
            crate::model::BatchInferenceJob {
                job_name: self.job_name,
                batch_inference_job_arn: self.batch_inference_job_arn,
                filter_arn: self.filter_arn,
                failure_reason: self.failure_reason,
                solution_version_arn: self.solution_version_arn,
                num_results: self.num_results,
                job_input: self.job_input,
                job_output: self.job_output,
                batch_inference_job_config: self.batch_inference_job_config,
                role_arn: self.role_arn,
                status: self.status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl BatchInferenceJob {
    /// Creates a new builder-style object to manufacture [`BatchInferenceJob`](crate::model::BatchInferenceJob)
    pub fn builder() -> crate::model::batch_inference_job::Builder {
        crate::model::batch_inference_job::Builder::default()
    }
}

/// <p>The configuration details of a batch inference job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchInferenceJobConfig {
    /// <p>A string to string map specifying the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. See <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>.</p>
    pub item_exploration_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl BatchInferenceJobConfig {
    /// <p>A string to string map specifying the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. See <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>.</p>
    pub fn item_exploration_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.item_exploration_config.as_ref()
    }
}
impl std::fmt::Debug for BatchInferenceJobConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchInferenceJobConfig");
        formatter.field("item_exploration_config", &self.item_exploration_config);
        formatter.finish()
    }
}
/// See [`BatchInferenceJobConfig`](crate::model::BatchInferenceJobConfig)
pub mod batch_inference_job_config {
    /// A builder for [`BatchInferenceJobConfig`](crate::model::BatchInferenceJobConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item_exploration_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `item_exploration_config`.
        ///
        /// To override the contents of this collection use [`set_item_exploration_config`](Self::set_item_exploration_config).
        ///
        /// <p>A string to string map specifying the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. See <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>.</p>
        pub fn item_exploration_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.item_exploration_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item_exploration_config = Some(hash_map);
            self
        }
        /// <p>A string to string map specifying the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. See <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>.</p>
        pub fn set_item_exploration_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.item_exploration_config = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchInferenceJobConfig`](crate::model::BatchInferenceJobConfig)
        pub fn build(self) -> crate::model::BatchInferenceJobConfig {
            crate::model::BatchInferenceJobConfig {
                item_exploration_config: self.item_exploration_config,
            }
        }
    }
}
impl BatchInferenceJobConfig {
    /// Creates a new builder-style object to manufacture [`BatchInferenceJobConfig`](crate::model::BatchInferenceJobConfig)
    pub fn builder() -> crate::model::batch_inference_job_config::Builder {
        crate::model::batch_inference_job_config::Builder::default()
    }
}

/// <p>The output configuration parameters of a batch inference job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchInferenceJobOutput {
    /// <p>Information on the Amazon S3 bucket in which the batch inference job's output is stored.</p>
    pub s3_data_destination: std::option::Option<crate::model::S3DataConfig>,
}
impl BatchInferenceJobOutput {
    /// <p>Information on the Amazon S3 bucket in which the batch inference job's output is stored.</p>
    pub fn s3_data_destination(&self) -> std::option::Option<&crate::model::S3DataConfig> {
        self.s3_data_destination.as_ref()
    }
}
impl std::fmt::Debug for BatchInferenceJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchInferenceJobOutput");
        formatter.field("s3_data_destination", &self.s3_data_destination);
        formatter.finish()
    }
}
/// See [`BatchInferenceJobOutput`](crate::model::BatchInferenceJobOutput)
pub mod batch_inference_job_output {
    /// A builder for [`BatchInferenceJobOutput`](crate::model::BatchInferenceJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_destination: std::option::Option<crate::model::S3DataConfig>,
    }
    impl Builder {
        /// <p>Information on the Amazon S3 bucket in which the batch inference job's output is stored.</p>
        pub fn s3_data_destination(mut self, input: crate::model::S3DataConfig) -> Self {
            self.s3_data_destination = Some(input);
            self
        }
        /// <p>Information on the Amazon S3 bucket in which the batch inference job's output is stored.</p>
        pub fn set_s3_data_destination(
            mut self,
            input: std::option::Option<crate::model::S3DataConfig>,
        ) -> Self {
            self.s3_data_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchInferenceJobOutput`](crate::model::BatchInferenceJobOutput)
        pub fn build(self) -> crate::model::BatchInferenceJobOutput {
            crate::model::BatchInferenceJobOutput {
                s3_data_destination: self.s3_data_destination,
            }
        }
    }
}
impl BatchInferenceJobOutput {
    /// Creates a new builder-style object to manufacture [`BatchInferenceJobOutput`](crate::model::BatchInferenceJobOutput)
    pub fn builder() -> crate::model::batch_inference_job_output::Builder {
        crate::model::batch_inference_job_output::Builder::default()
    }
}

/// <p>The input configuration of a batch inference job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchInferenceJobInput {
    /// <p>The URI of the Amazon S3 location that contains your input data. The Amazon S3 bucket must be in the same region as the API endpoint you are calling.</p>
    pub s3_data_source: std::option::Option<crate::model::S3DataConfig>,
}
impl BatchInferenceJobInput {
    /// <p>The URI of the Amazon S3 location that contains your input data. The Amazon S3 bucket must be in the same region as the API endpoint you are calling.</p>
    pub fn s3_data_source(&self) -> std::option::Option<&crate::model::S3DataConfig> {
        self.s3_data_source.as_ref()
    }
}
impl std::fmt::Debug for BatchInferenceJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchInferenceJobInput");
        formatter.field("s3_data_source", &self.s3_data_source);
        formatter.finish()
    }
}
/// See [`BatchInferenceJobInput`](crate::model::BatchInferenceJobInput)
pub mod batch_inference_job_input {
    /// A builder for [`BatchInferenceJobInput`](crate::model::BatchInferenceJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_source: std::option::Option<crate::model::S3DataConfig>,
    }
    impl Builder {
        /// <p>The URI of the Amazon S3 location that contains your input data. The Amazon S3 bucket must be in the same region as the API endpoint you are calling.</p>
        pub fn s3_data_source(mut self, input: crate::model::S3DataConfig) -> Self {
            self.s3_data_source = Some(input);
            self
        }
        /// <p>The URI of the Amazon S3 location that contains your input data. The Amazon S3 bucket must be in the same region as the API endpoint you are calling.</p>
        pub fn set_s3_data_source(
            mut self,
            input: std::option::Option<crate::model::S3DataConfig>,
        ) -> Self {
            self.s3_data_source = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchInferenceJobInput`](crate::model::BatchInferenceJobInput)
        pub fn build(self) -> crate::model::BatchInferenceJobInput {
            crate::model::BatchInferenceJobInput {
                s3_data_source: self.s3_data_source,
            }
        }
    }
}
impl BatchInferenceJobInput {
    /// Creates a new builder-style object to manufacture [`BatchInferenceJobInput`](crate::model::BatchInferenceJobInput)
    pub fn builder() -> crate::model::batch_inference_job_input::Builder {
        crate::model::batch_inference_job_input::Builder::default()
    }
}

/// <p>Describes a custom algorithm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Algorithm {
    /// <p>The name of the algorithm.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the algorithm.</p>
    pub algorithm_arn: std::option::Option<std::string::String>,
    /// <p>The URI of the Docker container for the algorithm image.</p>
    pub algorithm_image: std::option::Option<crate::model::AlgorithmImage>,
    /// <p>Specifies the default hyperparameters.</p>
    pub default_hyper_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
    pub default_hyper_parameter_ranges:
        std::option::Option<crate::model::DefaultHyperParameterRanges>,
    /// <p>Specifies the default maximum number of training jobs and parallel training jobs.</p>
    pub default_resource_config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The training input mode.</p>
    pub training_input_mode: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The date and time (in Unix time) that the algorithm was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (in Unix time) that the algorithm was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Algorithm {
    /// <p>The name of the algorithm.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the algorithm.</p>
    pub fn algorithm_arn(&self) -> std::option::Option<&str> {
        self.algorithm_arn.as_deref()
    }
    /// <p>The URI of the Docker container for the algorithm image.</p>
    pub fn algorithm_image(&self) -> std::option::Option<&crate::model::AlgorithmImage> {
        self.algorithm_image.as_ref()
    }
    /// <p>Specifies the default hyperparameters.</p>
    pub fn default_hyper_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.default_hyper_parameters.as_ref()
    }
    /// <p>Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
    pub fn default_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&crate::model::DefaultHyperParameterRanges> {
        self.default_hyper_parameter_ranges.as_ref()
    }
    /// <p>Specifies the default maximum number of training jobs and parallel training jobs.</p>
    pub fn default_resource_config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.default_resource_config.as_ref()
    }
    /// <p>The training input mode.</p>
    pub fn training_input_mode(&self) -> std::option::Option<&str> {
        self.training_input_mode.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The date and time (in Unix time) that the algorithm was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time (in Unix time) that the algorithm was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for Algorithm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Algorithm");
        formatter.field("name", &self.name);
        formatter.field("algorithm_arn", &self.algorithm_arn);
        formatter.field("algorithm_image", &self.algorithm_image);
        formatter.field("default_hyper_parameters", &self.default_hyper_parameters);
        formatter.field(
            "default_hyper_parameter_ranges",
            &self.default_hyper_parameter_ranges,
        );
        formatter.field("default_resource_config", &self.default_resource_config);
        formatter.field("training_input_mode", &self.training_input_mode);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`Algorithm`](crate::model::Algorithm)
pub mod algorithm {
    /// A builder for [`Algorithm`](crate::model::Algorithm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) algorithm_arn: std::option::Option<std::string::String>,
        pub(crate) algorithm_image: std::option::Option<crate::model::AlgorithmImage>,
        pub(crate) default_hyper_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) default_hyper_parameter_ranges:
            std::option::Option<crate::model::DefaultHyperParameterRanges>,
        pub(crate) default_resource_config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) training_input_mode: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the algorithm.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the algorithm.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm.</p>
        pub fn algorithm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_arn = input;
            self
        }
        /// <p>The URI of the Docker container for the algorithm image.</p>
        pub fn algorithm_image(mut self, input: crate::model::AlgorithmImage) -> Self {
            self.algorithm_image = Some(input);
            self
        }
        /// <p>The URI of the Docker container for the algorithm image.</p>
        pub fn set_algorithm_image(
            mut self,
            input: std::option::Option<crate::model::AlgorithmImage>,
        ) -> Self {
            self.algorithm_image = input;
            self
        }
        /// Adds a key-value pair to `default_hyper_parameters`.
        ///
        /// To override the contents of this collection use [`set_default_hyper_parameters`](Self::set_default_hyper_parameters).
        ///
        /// <p>Specifies the default hyperparameters.</p>
        pub fn default_hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.default_hyper_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.default_hyper_parameters = Some(hash_map);
            self
        }
        /// <p>Specifies the default hyperparameters.</p>
        pub fn set_default_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.default_hyper_parameters = input;
            self
        }
        /// <p>Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
        pub fn default_hyper_parameter_ranges(
            mut self,
            input: crate::model::DefaultHyperParameterRanges,
        ) -> Self {
            self.default_hyper_parameter_ranges = Some(input);
            self
        }
        /// <p>Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
        pub fn set_default_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<crate::model::DefaultHyperParameterRanges>,
        ) -> Self {
            self.default_hyper_parameter_ranges = input;
            self
        }
        /// Adds a key-value pair to `default_resource_config`.
        ///
        /// To override the contents of this collection use [`set_default_resource_config`](Self::set_default_resource_config).
        ///
        /// <p>Specifies the default maximum number of training jobs and parallel training jobs.</p>
        pub fn default_resource_config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.default_resource_config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.default_resource_config = Some(hash_map);
            self
        }
        /// <p>Specifies the default maximum number of training jobs and parallel training jobs.</p>
        pub fn set_default_resource_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.default_resource_config = input;
            self
        }
        /// <p>The training input mode.</p>
        pub fn training_input_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_input_mode = Some(input.into());
            self
        }
        /// <p>The training input mode.</p>
        pub fn set_training_input_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_input_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The date and time (in Unix time) that the algorithm was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the algorithm was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time (in Unix time) that the algorithm was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) that the algorithm was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Algorithm`](crate::model::Algorithm)
        pub fn build(self) -> crate::model::Algorithm {
            crate::model::Algorithm {
                name: self.name,
                algorithm_arn: self.algorithm_arn,
                algorithm_image: self.algorithm_image,
                default_hyper_parameters: self.default_hyper_parameters,
                default_hyper_parameter_ranges: self.default_hyper_parameter_ranges,
                default_resource_config: self.default_resource_config,
                training_input_mode: self.training_input_mode,
                role_arn: self.role_arn,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl Algorithm {
    /// Creates a new builder-style object to manufacture [`Algorithm`](crate::model::Algorithm)
    pub fn builder() -> crate::model::algorithm::Builder {
        crate::model::algorithm::Builder::default()
    }
}

/// <p>Specifies the hyperparameters and their default ranges. Hyperparameters can be categorical, continuous, or integer-valued.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultHyperParameterRanges {
    /// <p>The integer-valued hyperparameters and their default ranges.</p>
    pub integer_hyper_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::DefaultIntegerHyperParameterRange>>,
    /// <p>The continuous hyperparameters and their default ranges.</p>
    pub continuous_hyper_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::DefaultContinuousHyperParameterRange>>,
    /// <p>The categorical hyperparameters and their default ranges.</p>
    pub categorical_hyper_parameter_ranges:
        std::option::Option<std::vec::Vec<crate::model::DefaultCategoricalHyperParameterRange>>,
}
impl DefaultHyperParameterRanges {
    /// <p>The integer-valued hyperparameters and their default ranges.</p>
    pub fn integer_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::DefaultIntegerHyperParameterRange]> {
        self.integer_hyper_parameter_ranges.as_deref()
    }
    /// <p>The continuous hyperparameters and their default ranges.</p>
    pub fn continuous_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::DefaultContinuousHyperParameterRange]> {
        self.continuous_hyper_parameter_ranges.as_deref()
    }
    /// <p>The categorical hyperparameters and their default ranges.</p>
    pub fn categorical_hyper_parameter_ranges(
        &self,
    ) -> std::option::Option<&[crate::model::DefaultCategoricalHyperParameterRange]> {
        self.categorical_hyper_parameter_ranges.as_deref()
    }
}
impl std::fmt::Debug for DefaultHyperParameterRanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultHyperParameterRanges");
        formatter.field(
            "integer_hyper_parameter_ranges",
            &self.integer_hyper_parameter_ranges,
        );
        formatter.field(
            "continuous_hyper_parameter_ranges",
            &self.continuous_hyper_parameter_ranges,
        );
        formatter.field(
            "categorical_hyper_parameter_ranges",
            &self.categorical_hyper_parameter_ranges,
        );
        formatter.finish()
    }
}
/// See [`DefaultHyperParameterRanges`](crate::model::DefaultHyperParameterRanges)
pub mod default_hyper_parameter_ranges {
    /// A builder for [`DefaultHyperParameterRanges`](crate::model::DefaultHyperParameterRanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) integer_hyper_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::DefaultIntegerHyperParameterRange>>,
        pub(crate) continuous_hyper_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::DefaultContinuousHyperParameterRange>>,
        pub(crate) categorical_hyper_parameter_ranges:
            std::option::Option<std::vec::Vec<crate::model::DefaultCategoricalHyperParameterRange>>,
    }
    impl Builder {
        /// Appends an item to `integer_hyper_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_integer_hyper_parameter_ranges`](Self::set_integer_hyper_parameter_ranges).
        ///
        /// <p>The integer-valued hyperparameters and their default ranges.</p>
        pub fn integer_hyper_parameter_ranges(
            mut self,
            input: crate::model::DefaultIntegerHyperParameterRange,
        ) -> Self {
            let mut v = self.integer_hyper_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.integer_hyper_parameter_ranges = Some(v);
            self
        }
        /// <p>The integer-valued hyperparameters and their default ranges.</p>
        pub fn set_integer_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DefaultIntegerHyperParameterRange>,
            >,
        ) -> Self {
            self.integer_hyper_parameter_ranges = input;
            self
        }
        /// Appends an item to `continuous_hyper_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_continuous_hyper_parameter_ranges`](Self::set_continuous_hyper_parameter_ranges).
        ///
        /// <p>The continuous hyperparameters and their default ranges.</p>
        pub fn continuous_hyper_parameter_ranges(
            mut self,
            input: crate::model::DefaultContinuousHyperParameterRange,
        ) -> Self {
            let mut v = self.continuous_hyper_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.continuous_hyper_parameter_ranges = Some(v);
            self
        }
        /// <p>The continuous hyperparameters and their default ranges.</p>
        pub fn set_continuous_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DefaultContinuousHyperParameterRange>,
            >,
        ) -> Self {
            self.continuous_hyper_parameter_ranges = input;
            self
        }
        /// Appends an item to `categorical_hyper_parameter_ranges`.
        ///
        /// To override the contents of this collection use [`set_categorical_hyper_parameter_ranges`](Self::set_categorical_hyper_parameter_ranges).
        ///
        /// <p>The categorical hyperparameters and their default ranges.</p>
        pub fn categorical_hyper_parameter_ranges(
            mut self,
            input: crate::model::DefaultCategoricalHyperParameterRange,
        ) -> Self {
            let mut v = self.categorical_hyper_parameter_ranges.unwrap_or_default();
            v.push(input);
            self.categorical_hyper_parameter_ranges = Some(v);
            self
        }
        /// <p>The categorical hyperparameters and their default ranges.</p>
        pub fn set_categorical_hyper_parameter_ranges(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DefaultCategoricalHyperParameterRange>,
            >,
        ) -> Self {
            self.categorical_hyper_parameter_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultHyperParameterRanges`](crate::model::DefaultHyperParameterRanges)
        pub fn build(self) -> crate::model::DefaultHyperParameterRanges {
            crate::model::DefaultHyperParameterRanges {
                integer_hyper_parameter_ranges: self.integer_hyper_parameter_ranges,
                continuous_hyper_parameter_ranges: self.continuous_hyper_parameter_ranges,
                categorical_hyper_parameter_ranges: self.categorical_hyper_parameter_ranges,
            }
        }
    }
}
impl DefaultHyperParameterRanges {
    /// Creates a new builder-style object to manufacture [`DefaultHyperParameterRanges`](crate::model::DefaultHyperParameterRanges)
    pub fn builder() -> crate::model::default_hyper_parameter_ranges::Builder {
        crate::model::default_hyper_parameter_ranges::Builder::default()
    }
}

/// <p>Provides the name and default range of a categorical hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultCategoricalHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the categories for the hyperparameter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether the hyperparameter is tunable.</p>
    pub is_tunable: bool,
}
impl DefaultCategoricalHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the categories for the hyperparameter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>Whether the hyperparameter is tunable.</p>
    pub fn is_tunable(&self) -> bool {
        self.is_tunable
    }
}
impl std::fmt::Debug for DefaultCategoricalHyperParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultCategoricalHyperParameterRange");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("is_tunable", &self.is_tunable);
        formatter.finish()
    }
}
/// See [`DefaultCategoricalHyperParameterRange`](crate::model::DefaultCategoricalHyperParameterRange)
pub mod default_categorical_hyper_parameter_range {
    /// A builder for [`DefaultCategoricalHyperParameterRange`](crate::model::DefaultCategoricalHyperParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_tunable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of the categories for the hyperparameter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of the categories for the hyperparameter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>Whether the hyperparameter is tunable.</p>
        pub fn is_tunable(mut self, input: bool) -> Self {
            self.is_tunable = Some(input);
            self
        }
        /// <p>Whether the hyperparameter is tunable.</p>
        pub fn set_is_tunable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_tunable = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultCategoricalHyperParameterRange`](crate::model::DefaultCategoricalHyperParameterRange)
        pub fn build(self) -> crate::model::DefaultCategoricalHyperParameterRange {
            crate::model::DefaultCategoricalHyperParameterRange {
                name: self.name,
                values: self.values,
                is_tunable: self.is_tunable.unwrap_or_default(),
            }
        }
    }
}
impl DefaultCategoricalHyperParameterRange {
    /// Creates a new builder-style object to manufacture [`DefaultCategoricalHyperParameterRange`](crate::model::DefaultCategoricalHyperParameterRange)
    pub fn builder() -> crate::model::default_categorical_hyper_parameter_range::Builder {
        crate::model::default_categorical_hyper_parameter_range::Builder::default()
    }
}

/// <p>Provides the name and default range of a continuous hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultContinuousHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub min_value: f64,
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub max_value: f64,
    /// <p>Whether the hyperparameter is tunable.</p>
    pub is_tunable: bool,
}
impl DefaultContinuousHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub fn min_value(&self) -> f64 {
        self.min_value
    }
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub fn max_value(&self) -> f64 {
        self.max_value
    }
    /// <p>Whether the hyperparameter is tunable.</p>
    pub fn is_tunable(&self) -> bool {
        self.is_tunable
    }
}
impl std::fmt::Debug for DefaultContinuousHyperParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultContinuousHyperParameterRange");
        formatter.field("name", &self.name);
        formatter.field("min_value", &self.min_value);
        formatter.field("max_value", &self.max_value);
        formatter.field("is_tunable", &self.is_tunable);
        formatter.finish()
    }
}
/// See [`DefaultContinuousHyperParameterRange`](crate::model::DefaultContinuousHyperParameterRange)
pub mod default_continuous_hyper_parameter_range {
    /// A builder for [`DefaultContinuousHyperParameterRange`](crate::model::DefaultContinuousHyperParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) min_value: std::option::Option<f64>,
        pub(crate) max_value: std::option::Option<f64>,
        pub(crate) is_tunable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn min_value(mut self, input: f64) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn set_min_value(mut self, input: std::option::Option<f64>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn max_value(mut self, input: f64) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn set_max_value(mut self, input: std::option::Option<f64>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>Whether the hyperparameter is tunable.</p>
        pub fn is_tunable(mut self, input: bool) -> Self {
            self.is_tunable = Some(input);
            self
        }
        /// <p>Whether the hyperparameter is tunable.</p>
        pub fn set_is_tunable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_tunable = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultContinuousHyperParameterRange`](crate::model::DefaultContinuousHyperParameterRange)
        pub fn build(self) -> crate::model::DefaultContinuousHyperParameterRange {
            crate::model::DefaultContinuousHyperParameterRange {
                name: self.name,
                min_value: self.min_value.unwrap_or_default(),
                max_value: self.max_value.unwrap_or_default(),
                is_tunable: self.is_tunable.unwrap_or_default(),
            }
        }
    }
}
impl DefaultContinuousHyperParameterRange {
    /// Creates a new builder-style object to manufacture [`DefaultContinuousHyperParameterRange`](crate::model::DefaultContinuousHyperParameterRange)
    pub fn builder() -> crate::model::default_continuous_hyper_parameter_range::Builder {
        crate::model::default_continuous_hyper_parameter_range::Builder::default()
    }
}

/// <p>Provides the name and default range of a integer-valued hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultIntegerHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub min_value: i32,
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub max_value: i32,
    /// <p>Indicates whether the hyperparameter is tunable.</p>
    pub is_tunable: bool,
}
impl DefaultIntegerHyperParameterRange {
    /// <p>The name of the hyperparameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The minimum allowable value for the hyperparameter.</p>
    pub fn min_value(&self) -> i32 {
        self.min_value
    }
    /// <p>The maximum allowable value for the hyperparameter.</p>
    pub fn max_value(&self) -> i32 {
        self.max_value
    }
    /// <p>Indicates whether the hyperparameter is tunable.</p>
    pub fn is_tunable(&self) -> bool {
        self.is_tunable
    }
}
impl std::fmt::Debug for DefaultIntegerHyperParameterRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultIntegerHyperParameterRange");
        formatter.field("name", &self.name);
        formatter.field("min_value", &self.min_value);
        formatter.field("max_value", &self.max_value);
        formatter.field("is_tunable", &self.is_tunable);
        formatter.finish()
    }
}
/// See [`DefaultIntegerHyperParameterRange`](crate::model::DefaultIntegerHyperParameterRange)
pub mod default_integer_hyper_parameter_range {
    /// A builder for [`DefaultIntegerHyperParameterRange`](crate::model::DefaultIntegerHyperParameterRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) min_value: std::option::Option<i32>,
        pub(crate) max_value: std::option::Option<i32>,
        pub(crate) is_tunable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the hyperparameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hyperparameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn min_value(mut self, input: i32) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>The minimum allowable value for the hyperparameter.</p>
        pub fn set_min_value(mut self, input: std::option::Option<i32>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn max_value(mut self, input: i32) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>The maximum allowable value for the hyperparameter.</p>
        pub fn set_max_value(mut self, input: std::option::Option<i32>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>Indicates whether the hyperparameter is tunable.</p>
        pub fn is_tunable(mut self, input: bool) -> Self {
            self.is_tunable = Some(input);
            self
        }
        /// <p>Indicates whether the hyperparameter is tunable.</p>
        pub fn set_is_tunable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_tunable = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultIntegerHyperParameterRange`](crate::model::DefaultIntegerHyperParameterRange)
        pub fn build(self) -> crate::model::DefaultIntegerHyperParameterRange {
            crate::model::DefaultIntegerHyperParameterRange {
                name: self.name,
                min_value: self.min_value.unwrap_or_default(),
                max_value: self.max_value.unwrap_or_default(),
                is_tunable: self.is_tunable.unwrap_or_default(),
            }
        }
    }
}
impl DefaultIntegerHyperParameterRange {
    /// Creates a new builder-style object to manufacture [`DefaultIntegerHyperParameterRange`](crate::model::DefaultIntegerHyperParameterRange)
    pub fn builder() -> crate::model::default_integer_hyper_parameter_range::Builder {
        crate::model::default_integer_hyper_parameter_range::Builder::default()
    }
}

/// <p>Describes an algorithm image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlgorithmImage {
    /// <p>The name of the algorithm image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The URI of the Docker container for the algorithm image.</p>
    pub docker_uri: std::option::Option<std::string::String>,
}
impl AlgorithmImage {
    /// <p>The name of the algorithm image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The URI of the Docker container for the algorithm image.</p>
    pub fn docker_uri(&self) -> std::option::Option<&str> {
        self.docker_uri.as_deref()
    }
}
impl std::fmt::Debug for AlgorithmImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlgorithmImage");
        formatter.field("name", &self.name);
        formatter.field("docker_uri", &self.docker_uri);
        formatter.finish()
    }
}
/// See [`AlgorithmImage`](crate::model::AlgorithmImage)
pub mod algorithm_image {
    /// A builder for [`AlgorithmImage`](crate::model::AlgorithmImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) docker_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the algorithm image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the algorithm image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The URI of the Docker container for the algorithm image.</p>
        pub fn docker_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.docker_uri = Some(input.into());
            self
        }
        /// <p>The URI of the Docker container for the algorithm image.</p>
        pub fn set_docker_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.docker_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`AlgorithmImage`](crate::model::AlgorithmImage)
        pub fn build(self) -> crate::model::AlgorithmImage {
            crate::model::AlgorithmImage {
                name: self.name,
                docker_uri: self.docker_uri,
            }
        }
    }
}
impl AlgorithmImage {
    /// Creates a new builder-style object to manufacture [`AlgorithmImage`](crate::model::AlgorithmImage)
    pub fn builder() -> crate::model::algorithm_image::Builder {
        crate::model::algorithm_image::Builder::default()
    }
}
