// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateBatchInferenceJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_batch_inference_job`](crate::client::Client::create_batch_inference_job).
///
/// See [`crate::client::fluent_builders::CreateBatchInferenceJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBatchInferenceJob {
    _private: (),
}
impl CreateBatchInferenceJob {
    /// Creates a new builder-style object to manufacture [`CreateBatchInferenceJobInput`](crate::input::CreateBatchInferenceJobInput)
    pub fn builder() -> crate::input::create_batch_inference_job_input::Builder {
        crate::input::create_batch_inference_job_input::Builder::default()
    }
    /// Creates a new `CreateBatchInferenceJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBatchInferenceJob {
    type Output = std::result::Result<
        crate::output::CreateBatchInferenceJobOutput,
        crate::error::CreateBatchInferenceJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_batch_inference_job_error(response)
        } else {
            crate::operation_deser::parse_create_batch_inference_job_response(response)
        }
    }
}

/// Operation shape for `CreateBatchSegmentJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_batch_segment_job`](crate::client::Client::create_batch_segment_job).
///
/// See [`crate::client::fluent_builders::CreateBatchSegmentJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBatchSegmentJob {
    _private: (),
}
impl CreateBatchSegmentJob {
    /// Creates a new builder-style object to manufacture [`CreateBatchSegmentJobInput`](crate::input::CreateBatchSegmentJobInput)
    pub fn builder() -> crate::input::create_batch_segment_job_input::Builder {
        crate::input::create_batch_segment_job_input::Builder::default()
    }
    /// Creates a new `CreateBatchSegmentJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBatchSegmentJob {
    type Output = std::result::Result<
        crate::output::CreateBatchSegmentJobOutput,
        crate::error::CreateBatchSegmentJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_batch_segment_job_error(response)
        } else {
            crate::operation_deser::parse_create_batch_segment_job_response(response)
        }
    }
}

/// Operation shape for `CreateCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_campaign`](crate::client::Client::create_campaign).
///
/// See [`crate::client::fluent_builders::CreateCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCampaign {
    _private: (),
}
impl CreateCampaign {
    /// Creates a new builder-style object to manufacture [`CreateCampaignInput`](crate::input::CreateCampaignInput)
    pub fn builder() -> crate::input::create_campaign_input::Builder {
        crate::input::create_campaign_input::Builder::default()
    }
    /// Creates a new `CreateCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCampaign {
    type Output =
        std::result::Result<crate::output::CreateCampaignOutput, crate::error::CreateCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_campaign_error(response)
        } else {
            crate::operation_deser::parse_create_campaign_response(response)
        }
    }
}

/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateDatasetExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset_export_job`](crate::client::Client::create_dataset_export_job).
///
/// See [`crate::client::fluent_builders::CreateDatasetExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatasetExportJob {
    _private: (),
}
impl CreateDatasetExportJob {
    /// Creates a new builder-style object to manufacture [`CreateDatasetExportJobInput`](crate::input::CreateDatasetExportJobInput)
    pub fn builder() -> crate::input::create_dataset_export_job_input::Builder {
        crate::input::create_dataset_export_job_input::Builder::default()
    }
    /// Creates a new `CreateDatasetExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatasetExportJob {
    type Output = std::result::Result<
        crate::output::CreateDatasetExportJobOutput,
        crate::error::CreateDatasetExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_export_job_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_export_job_response(response)
        }
    }
}

/// Operation shape for `CreateDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset_group`](crate::client::Client::create_dataset_group).
///
/// See [`crate::client::fluent_builders::CreateDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatasetGroup {
    _private: (),
}
impl CreateDatasetGroup {
    /// Creates a new builder-style object to manufacture [`CreateDatasetGroupInput`](crate::input::CreateDatasetGroupInput)
    pub fn builder() -> crate::input::create_dataset_group_input::Builder {
        crate::input::create_dataset_group_input::Builder::default()
    }
    /// Creates a new `CreateDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatasetGroup {
    type Output = std::result::Result<
        crate::output::CreateDatasetGroupOutput,
        crate::error::CreateDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_group_response(response)
        }
    }
}

/// Operation shape for `CreateDatasetImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset_import_job`](crate::client::Client::create_dataset_import_job).
///
/// See [`crate::client::fluent_builders::CreateDatasetImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatasetImportJob {
    _private: (),
}
impl CreateDatasetImportJob {
    /// Creates a new builder-style object to manufacture [`CreateDatasetImportJobInput`](crate::input::CreateDatasetImportJobInput)
    pub fn builder() -> crate::input::create_dataset_import_job_input::Builder {
        crate::input::create_dataset_import_job_input::Builder::default()
    }
    /// Creates a new `CreateDatasetImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatasetImportJob {
    type Output = std::result::Result<
        crate::output::CreateDatasetImportJobOutput,
        crate::error::CreateDatasetImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_import_job_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_import_job_response(response)
        }
    }
}

/// Operation shape for `CreateEventTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_tracker`](crate::client::Client::create_event_tracker).
///
/// See [`crate::client::fluent_builders::CreateEventTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventTracker {
    _private: (),
}
impl CreateEventTracker {
    /// Creates a new builder-style object to manufacture [`CreateEventTrackerInput`](crate::input::CreateEventTrackerInput)
    pub fn builder() -> crate::input::create_event_tracker_input::Builder {
        crate::input::create_event_tracker_input::Builder::default()
    }
    /// Creates a new `CreateEventTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventTracker {
    type Output = std::result::Result<
        crate::output::CreateEventTrackerOutput,
        crate::error::CreateEventTrackerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_tracker_error(response)
        } else {
            crate::operation_deser::parse_create_event_tracker_response(response)
        }
    }
}

/// Operation shape for `CreateFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_filter`](crate::client::Client::create_filter).
///
/// See [`crate::client::fluent_builders::CreateFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFilter {
    _private: (),
}
impl CreateFilter {
    /// Creates a new builder-style object to manufacture [`CreateFilterInput`](crate::input::CreateFilterInput)
    pub fn builder() -> crate::input::create_filter_input::Builder {
        crate::input::create_filter_input::Builder::default()
    }
    /// Creates a new `CreateFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFilter {
    type Output =
        std::result::Result<crate::output::CreateFilterOutput, crate::error::CreateFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_filter_error(response)
        } else {
            crate::operation_deser::parse_create_filter_response(response)
        }
    }
}

/// Operation shape for `CreateRecommender`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_recommender`](crate::client::Client::create_recommender).
///
/// See [`crate::client::fluent_builders::CreateRecommender`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRecommender {
    _private: (),
}
impl CreateRecommender {
    /// Creates a new builder-style object to manufacture [`CreateRecommenderInput`](crate::input::CreateRecommenderInput)
    pub fn builder() -> crate::input::create_recommender_input::Builder {
        crate::input::create_recommender_input::Builder::default()
    }
    /// Creates a new `CreateRecommender` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRecommender {
    type Output = std::result::Result<
        crate::output::CreateRecommenderOutput,
        crate::error::CreateRecommenderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_recommender_error(response)
        } else {
            crate::operation_deser::parse_create_recommender_response(response)
        }
    }
}

/// Operation shape for `CreateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_schema`](crate::client::Client::create_schema).
///
/// See [`crate::client::fluent_builders::CreateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSchema {
    _private: (),
}
impl CreateSchema {
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
    /// Creates a new `CreateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSchema {
    type Output =
        std::result::Result<crate::output::CreateSchemaOutput, crate::error::CreateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_schema_error(response)
        } else {
            crate::operation_deser::parse_create_schema_response(response)
        }
    }
}

/// Operation shape for `CreateSolution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_solution`](crate::client::Client::create_solution).
///
/// See [`crate::client::fluent_builders::CreateSolution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSolution {
    _private: (),
}
impl CreateSolution {
    /// Creates a new builder-style object to manufacture [`CreateSolutionInput`](crate::input::CreateSolutionInput)
    pub fn builder() -> crate::input::create_solution_input::Builder {
        crate::input::create_solution_input::Builder::default()
    }
    /// Creates a new `CreateSolution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSolution {
    type Output =
        std::result::Result<crate::output::CreateSolutionOutput, crate::error::CreateSolutionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_solution_error(response)
        } else {
            crate::operation_deser::parse_create_solution_response(response)
        }
    }
}

/// Operation shape for `CreateSolutionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_solution_version`](crate::client::Client::create_solution_version).
///
/// See [`crate::client::fluent_builders::CreateSolutionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSolutionVersion {
    _private: (),
}
impl CreateSolutionVersion {
    /// Creates a new builder-style object to manufacture [`CreateSolutionVersionInput`](crate::input::CreateSolutionVersionInput)
    pub fn builder() -> crate::input::create_solution_version_input::Builder {
        crate::input::create_solution_version_input::Builder::default()
    }
    /// Creates a new `CreateSolutionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSolutionVersion {
    type Output = std::result::Result<
        crate::output::CreateSolutionVersionOutput,
        crate::error::CreateSolutionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_solution_version_error(response)
        } else {
            crate::operation_deser::parse_create_solution_version_response(response)
        }
    }
}

/// Operation shape for `DeleteCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_campaign`](crate::client::Client::delete_campaign).
///
/// See [`crate::client::fluent_builders::DeleteCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCampaign {
    _private: (),
}
impl DeleteCampaign {
    /// Creates a new builder-style object to manufacture [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
    pub fn builder() -> crate::input::delete_campaign_input::Builder {
        crate::input::delete_campaign_input::Builder::default()
    }
    /// Creates a new `DeleteCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCampaign {
    type Output =
        std::result::Result<crate::output::DeleteCampaignOutput, crate::error::DeleteCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_campaign_error(response)
        } else {
            crate::operation_deser::parse_delete_campaign_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeleteDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset_group`](crate::client::Client::delete_dataset_group).
///
/// See [`crate::client::fluent_builders::DeleteDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDatasetGroup {
    _private: (),
}
impl DeleteDatasetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetGroupInput`](crate::input::DeleteDatasetGroupInput)
    pub fn builder() -> crate::input::delete_dataset_group_input::Builder {
        crate::input::delete_dataset_group_input::Builder::default()
    }
    /// Creates a new `DeleteDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDatasetGroup {
    type Output = std::result::Result<
        crate::output::DeleteDatasetGroupOutput,
        crate::error::DeleteDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_group_response(response)
        }
    }
}

/// Operation shape for `DeleteEventTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_tracker`](crate::client::Client::delete_event_tracker).
///
/// See [`crate::client::fluent_builders::DeleteEventTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventTracker {
    _private: (),
}
impl DeleteEventTracker {
    /// Creates a new builder-style object to manufacture [`DeleteEventTrackerInput`](crate::input::DeleteEventTrackerInput)
    pub fn builder() -> crate::input::delete_event_tracker_input::Builder {
        crate::input::delete_event_tracker_input::Builder::default()
    }
    /// Creates a new `DeleteEventTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventTracker {
    type Output = std::result::Result<
        crate::output::DeleteEventTrackerOutput,
        crate::error::DeleteEventTrackerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_tracker_error(response)
        } else {
            crate::operation_deser::parse_delete_event_tracker_response(response)
        }
    }
}

/// Operation shape for `DeleteFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_filter`](crate::client::Client::delete_filter).
///
/// See [`crate::client::fluent_builders::DeleteFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFilter {
    _private: (),
}
impl DeleteFilter {
    /// Creates a new builder-style object to manufacture [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    pub fn builder() -> crate::input::delete_filter_input::Builder {
        crate::input::delete_filter_input::Builder::default()
    }
    /// Creates a new `DeleteFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFilter {
    type Output =
        std::result::Result<crate::output::DeleteFilterOutput, crate::error::DeleteFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteRecommender`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recommender`](crate::client::Client::delete_recommender).
///
/// See [`crate::client::fluent_builders::DeleteRecommender`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecommender {
    _private: (),
}
impl DeleteRecommender {
    /// Creates a new builder-style object to manufacture [`DeleteRecommenderInput`](crate::input::DeleteRecommenderInput)
    pub fn builder() -> crate::input::delete_recommender_input::Builder {
        crate::input::delete_recommender_input::Builder::default()
    }
    /// Creates a new `DeleteRecommender` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecommender {
    type Output = std::result::Result<
        crate::output::DeleteRecommenderOutput,
        crate::error::DeleteRecommenderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_recommender_error(response)
        } else {
            crate::operation_deser::parse_delete_recommender_response(response)
        }
    }
}

/// Operation shape for `DeleteSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schema`](crate::client::Client::delete_schema).
///
/// See [`crate::client::fluent_builders::DeleteSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchema {
    _private: (),
}
impl DeleteSchema {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
    /// Creates a new `DeleteSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchema {
    type Output =
        std::result::Result<crate::output::DeleteSchemaOutput, crate::error::DeleteSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_schema_error(response)
        } else {
            crate::operation_deser::parse_delete_schema_response(response)
        }
    }
}

/// Operation shape for `DeleteSolution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_solution`](crate::client::Client::delete_solution).
///
/// See [`crate::client::fluent_builders::DeleteSolution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSolution {
    _private: (),
}
impl DeleteSolution {
    /// Creates a new builder-style object to manufacture [`DeleteSolutionInput`](crate::input::DeleteSolutionInput)
    pub fn builder() -> crate::input::delete_solution_input::Builder {
        crate::input::delete_solution_input::Builder::default()
    }
    /// Creates a new `DeleteSolution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSolution {
    type Output =
        std::result::Result<crate::output::DeleteSolutionOutput, crate::error::DeleteSolutionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_solution_error(response)
        } else {
            crate::operation_deser::parse_delete_solution_response(response)
        }
    }
}

/// Operation shape for `DescribeAlgorithm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_algorithm`](crate::client::Client::describe_algorithm).
///
/// See [`crate::client::fluent_builders::DescribeAlgorithm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlgorithm {
    _private: (),
}
impl DescribeAlgorithm {
    /// Creates a new builder-style object to manufacture [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
    pub fn builder() -> crate::input::describe_algorithm_input::Builder {
        crate::input::describe_algorithm_input::Builder::default()
    }
    /// Creates a new `DescribeAlgorithm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlgorithm {
    type Output = std::result::Result<
        crate::output::DescribeAlgorithmOutput,
        crate::error::DescribeAlgorithmError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_algorithm_error(response)
        } else {
            crate::operation_deser::parse_describe_algorithm_response(response)
        }
    }
}

/// Operation shape for `DescribeBatchInferenceJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_batch_inference_job`](crate::client::Client::describe_batch_inference_job).
///
/// See [`crate::client::fluent_builders::DescribeBatchInferenceJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBatchInferenceJob {
    _private: (),
}
impl DescribeBatchInferenceJob {
    /// Creates a new builder-style object to manufacture [`DescribeBatchInferenceJobInput`](crate::input::DescribeBatchInferenceJobInput)
    pub fn builder() -> crate::input::describe_batch_inference_job_input::Builder {
        crate::input::describe_batch_inference_job_input::Builder::default()
    }
    /// Creates a new `DescribeBatchInferenceJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBatchInferenceJob {
    type Output = std::result::Result<
        crate::output::DescribeBatchInferenceJobOutput,
        crate::error::DescribeBatchInferenceJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_batch_inference_job_error(response)
        } else {
            crate::operation_deser::parse_describe_batch_inference_job_response(response)
        }
    }
}

/// Operation shape for `DescribeBatchSegmentJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_batch_segment_job`](crate::client::Client::describe_batch_segment_job).
///
/// See [`crate::client::fluent_builders::DescribeBatchSegmentJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBatchSegmentJob {
    _private: (),
}
impl DescribeBatchSegmentJob {
    /// Creates a new builder-style object to manufacture [`DescribeBatchSegmentJobInput`](crate::input::DescribeBatchSegmentJobInput)
    pub fn builder() -> crate::input::describe_batch_segment_job_input::Builder {
        crate::input::describe_batch_segment_job_input::Builder::default()
    }
    /// Creates a new `DescribeBatchSegmentJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBatchSegmentJob {
    type Output = std::result::Result<
        crate::output::DescribeBatchSegmentJobOutput,
        crate::error::DescribeBatchSegmentJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_batch_segment_job_error(response)
        } else {
            crate::operation_deser::parse_describe_batch_segment_job_response(response)
        }
    }
}

/// Operation shape for `DescribeCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_campaign`](crate::client::Client::describe_campaign).
///
/// See [`crate::client::fluent_builders::DescribeCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCampaign {
    _private: (),
}
impl DescribeCampaign {
    /// Creates a new builder-style object to manufacture [`DescribeCampaignInput`](crate::input::DescribeCampaignInput)
    pub fn builder() -> crate::input::describe_campaign_input::Builder {
        crate::input::describe_campaign_input::Builder::default()
    }
    /// Creates a new `DescribeCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCampaign {
    type Output = std::result::Result<
        crate::output::DescribeCampaignOutput,
        crate::error::DescribeCampaignError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_campaign_error(response)
        } else {
            crate::operation_deser::parse_describe_campaign_response(response)
        }
    }
}

/// Operation shape for `DescribeDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset`](crate::client::Client::describe_dataset).
///
/// See [`crate::client::fluent_builders::DescribeDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataset {
    _private: (),
}
impl DescribeDataset {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
    /// Creates a new `DescribeDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataset {
    type Output = std::result::Result<
        crate::output::DescribeDatasetOutput,
        crate::error::DescribeDatasetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_response(response)
        }
    }
}

/// Operation shape for `DescribeDatasetExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset_export_job`](crate::client::Client::describe_dataset_export_job).
///
/// See [`crate::client::fluent_builders::DescribeDatasetExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDatasetExportJob {
    _private: (),
}
impl DescribeDatasetExportJob {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetExportJobInput`](crate::input::DescribeDatasetExportJobInput)
    pub fn builder() -> crate::input::describe_dataset_export_job_input::Builder {
        crate::input::describe_dataset_export_job_input::Builder::default()
    }
    /// Creates a new `DescribeDatasetExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDatasetExportJob {
    type Output = std::result::Result<
        crate::output::DescribeDatasetExportJobOutput,
        crate::error::DescribeDatasetExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_export_job_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_export_job_response(response)
        }
    }
}

/// Operation shape for `DescribeDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset_group`](crate::client::Client::describe_dataset_group).
///
/// See [`crate::client::fluent_builders::DescribeDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDatasetGroup {
    _private: (),
}
impl DescribeDatasetGroup {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetGroupInput`](crate::input::DescribeDatasetGroupInput)
    pub fn builder() -> crate::input::describe_dataset_group_input::Builder {
        crate::input::describe_dataset_group_input::Builder::default()
    }
    /// Creates a new `DescribeDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDatasetGroup {
    type Output = std::result::Result<
        crate::output::DescribeDatasetGroupOutput,
        crate::error::DescribeDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_group_response(response)
        }
    }
}

/// Operation shape for `DescribeDatasetImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset_import_job`](crate::client::Client::describe_dataset_import_job).
///
/// See [`crate::client::fluent_builders::DescribeDatasetImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDatasetImportJob {
    _private: (),
}
impl DescribeDatasetImportJob {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetImportJobInput`](crate::input::DescribeDatasetImportJobInput)
    pub fn builder() -> crate::input::describe_dataset_import_job_input::Builder {
        crate::input::describe_dataset_import_job_input::Builder::default()
    }
    /// Creates a new `DescribeDatasetImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDatasetImportJob {
    type Output = std::result::Result<
        crate::output::DescribeDatasetImportJobOutput,
        crate::error::DescribeDatasetImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_import_job_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_import_job_response(response)
        }
    }
}

/// Operation shape for `DescribeEventTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_tracker`](crate::client::Client::describe_event_tracker).
///
/// See [`crate::client::fluent_builders::DescribeEventTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventTracker {
    _private: (),
}
impl DescribeEventTracker {
    /// Creates a new builder-style object to manufacture [`DescribeEventTrackerInput`](crate::input::DescribeEventTrackerInput)
    pub fn builder() -> crate::input::describe_event_tracker_input::Builder {
        crate::input::describe_event_tracker_input::Builder::default()
    }
    /// Creates a new `DescribeEventTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventTracker {
    type Output = std::result::Result<
        crate::output::DescribeEventTrackerOutput,
        crate::error::DescribeEventTrackerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_tracker_error(response)
        } else {
            crate::operation_deser::parse_describe_event_tracker_response(response)
        }
    }
}

/// Operation shape for `DescribeFeatureTransformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_feature_transformation`](crate::client::Client::describe_feature_transformation).
///
/// See [`crate::client::fluent_builders::DescribeFeatureTransformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFeatureTransformation {
    _private: (),
}
impl DescribeFeatureTransformation {
    /// Creates a new builder-style object to manufacture [`DescribeFeatureTransformationInput`](crate::input::DescribeFeatureTransformationInput)
    pub fn builder() -> crate::input::describe_feature_transformation_input::Builder {
        crate::input::describe_feature_transformation_input::Builder::default()
    }
    /// Creates a new `DescribeFeatureTransformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFeatureTransformation {
    type Output = std::result::Result<
        crate::output::DescribeFeatureTransformationOutput,
        crate::error::DescribeFeatureTransformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_feature_transformation_error(response)
        } else {
            crate::operation_deser::parse_describe_feature_transformation_response(response)
        }
    }
}

/// Operation shape for `DescribeFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_filter`](crate::client::Client::describe_filter).
///
/// See [`crate::client::fluent_builders::DescribeFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFilter {
    _private: (),
}
impl DescribeFilter {
    /// Creates a new builder-style object to manufacture [`DescribeFilterInput`](crate::input::DescribeFilterInput)
    pub fn builder() -> crate::input::describe_filter_input::Builder {
        crate::input::describe_filter_input::Builder::default()
    }
    /// Creates a new `DescribeFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFilter {
    type Output =
        std::result::Result<crate::output::DescribeFilterOutput, crate::error::DescribeFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_filter_error(response)
        } else {
            crate::operation_deser::parse_describe_filter_response(response)
        }
    }
}

/// Operation shape for `DescribeRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_recipe`](crate::client::Client::describe_recipe).
///
/// See [`crate::client::fluent_builders::DescribeRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecipe {
    _private: (),
}
impl DescribeRecipe {
    /// Creates a new builder-style object to manufacture [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
    pub fn builder() -> crate::input::describe_recipe_input::Builder {
        crate::input::describe_recipe_input::Builder::default()
    }
    /// Creates a new `DescribeRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecipe {
    type Output =
        std::result::Result<crate::output::DescribeRecipeOutput, crate::error::DescribeRecipeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_recipe_error(response)
        } else {
            crate::operation_deser::parse_describe_recipe_response(response)
        }
    }
}

/// Operation shape for `DescribeRecommender`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_recommender`](crate::client::Client::describe_recommender).
///
/// See [`crate::client::fluent_builders::DescribeRecommender`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecommender {
    _private: (),
}
impl DescribeRecommender {
    /// Creates a new builder-style object to manufacture [`DescribeRecommenderInput`](crate::input::DescribeRecommenderInput)
    pub fn builder() -> crate::input::describe_recommender_input::Builder {
        crate::input::describe_recommender_input::Builder::default()
    }
    /// Creates a new `DescribeRecommender` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecommender {
    type Output = std::result::Result<
        crate::output::DescribeRecommenderOutput,
        crate::error::DescribeRecommenderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_recommender_error(response)
        } else {
            crate::operation_deser::parse_describe_recommender_response(response)
        }
    }
}

/// Operation shape for `DescribeSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_schema`](crate::client::Client::describe_schema).
///
/// See [`crate::client::fluent_builders::DescribeSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSchema {
    _private: (),
}
impl DescribeSchema {
    /// Creates a new builder-style object to manufacture [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
    pub fn builder() -> crate::input::describe_schema_input::Builder {
        crate::input::describe_schema_input::Builder::default()
    }
    /// Creates a new `DescribeSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSchema {
    type Output =
        std::result::Result<crate::output::DescribeSchemaOutput, crate::error::DescribeSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_schema_error(response)
        } else {
            crate::operation_deser::parse_describe_schema_response(response)
        }
    }
}

/// Operation shape for `DescribeSolution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_solution`](crate::client::Client::describe_solution).
///
/// See [`crate::client::fluent_builders::DescribeSolution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSolution {
    _private: (),
}
impl DescribeSolution {
    /// Creates a new builder-style object to manufacture [`DescribeSolutionInput`](crate::input::DescribeSolutionInput)
    pub fn builder() -> crate::input::describe_solution_input::Builder {
        crate::input::describe_solution_input::Builder::default()
    }
    /// Creates a new `DescribeSolution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSolution {
    type Output = std::result::Result<
        crate::output::DescribeSolutionOutput,
        crate::error::DescribeSolutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_solution_error(response)
        } else {
            crate::operation_deser::parse_describe_solution_response(response)
        }
    }
}

/// Operation shape for `DescribeSolutionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_solution_version`](crate::client::Client::describe_solution_version).
///
/// See [`crate::client::fluent_builders::DescribeSolutionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSolutionVersion {
    _private: (),
}
impl DescribeSolutionVersion {
    /// Creates a new builder-style object to manufacture [`DescribeSolutionVersionInput`](crate::input::DescribeSolutionVersionInput)
    pub fn builder() -> crate::input::describe_solution_version_input::Builder {
        crate::input::describe_solution_version_input::Builder::default()
    }
    /// Creates a new `DescribeSolutionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSolutionVersion {
    type Output = std::result::Result<
        crate::output::DescribeSolutionVersionOutput,
        crate::error::DescribeSolutionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_solution_version_error(response)
        } else {
            crate::operation_deser::parse_describe_solution_version_response(response)
        }
    }
}

/// Operation shape for `GetSolutionMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_solution_metrics`](crate::client::Client::get_solution_metrics).
///
/// See [`crate::client::fluent_builders::GetSolutionMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSolutionMetrics {
    _private: (),
}
impl GetSolutionMetrics {
    /// Creates a new builder-style object to manufacture [`GetSolutionMetricsInput`](crate::input::GetSolutionMetricsInput)
    pub fn builder() -> crate::input::get_solution_metrics_input::Builder {
        crate::input::get_solution_metrics_input::Builder::default()
    }
    /// Creates a new `GetSolutionMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSolutionMetrics {
    type Output = std::result::Result<
        crate::output::GetSolutionMetricsOutput,
        crate::error::GetSolutionMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_solution_metrics_error(response)
        } else {
            crate::operation_deser::parse_get_solution_metrics_response(response)
        }
    }
}

/// Operation shape for `ListBatchInferenceJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_batch_inference_jobs`](crate::client::Client::list_batch_inference_jobs).
///
/// See [`crate::client::fluent_builders::ListBatchInferenceJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBatchInferenceJobs {
    _private: (),
}
impl ListBatchInferenceJobs {
    /// Creates a new builder-style object to manufacture [`ListBatchInferenceJobsInput`](crate::input::ListBatchInferenceJobsInput)
    pub fn builder() -> crate::input::list_batch_inference_jobs_input::Builder {
        crate::input::list_batch_inference_jobs_input::Builder::default()
    }
    /// Creates a new `ListBatchInferenceJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBatchInferenceJobs {
    type Output = std::result::Result<
        crate::output::ListBatchInferenceJobsOutput,
        crate::error::ListBatchInferenceJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_batch_inference_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_batch_inference_jobs_response(response)
        }
    }
}

/// Operation shape for `ListBatchSegmentJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_batch_segment_jobs`](crate::client::Client::list_batch_segment_jobs).
///
/// See [`crate::client::fluent_builders::ListBatchSegmentJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBatchSegmentJobs {
    _private: (),
}
impl ListBatchSegmentJobs {
    /// Creates a new builder-style object to manufacture [`ListBatchSegmentJobsInput`](crate::input::ListBatchSegmentJobsInput)
    pub fn builder() -> crate::input::list_batch_segment_jobs_input::Builder {
        crate::input::list_batch_segment_jobs_input::Builder::default()
    }
    /// Creates a new `ListBatchSegmentJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBatchSegmentJobs {
    type Output = std::result::Result<
        crate::output::ListBatchSegmentJobsOutput,
        crate::error::ListBatchSegmentJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_batch_segment_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_batch_segment_jobs_response(response)
        }
    }
}

/// Operation shape for `ListCampaigns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_campaigns`](crate::client::Client::list_campaigns).
///
/// See [`crate::client::fluent_builders::ListCampaigns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCampaigns {
    _private: (),
}
impl ListCampaigns {
    /// Creates a new builder-style object to manufacture [`ListCampaignsInput`](crate::input::ListCampaignsInput)
    pub fn builder() -> crate::input::list_campaigns_input::Builder {
        crate::input::list_campaigns_input::Builder::default()
    }
    /// Creates a new `ListCampaigns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCampaigns {
    type Output =
        std::result::Result<crate::output::ListCampaignsOutput, crate::error::ListCampaignsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_campaigns_error(response)
        } else {
            crate::operation_deser::parse_list_campaigns_response(response)
        }
    }
}

/// Operation shape for `ListDatasetExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_export_jobs`](crate::client::Client::list_dataset_export_jobs).
///
/// See [`crate::client::fluent_builders::ListDatasetExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetExportJobs {
    _private: (),
}
impl ListDatasetExportJobs {
    /// Creates a new builder-style object to manufacture [`ListDatasetExportJobsInput`](crate::input::ListDatasetExportJobsInput)
    pub fn builder() -> crate::input::list_dataset_export_jobs_input::Builder {
        crate::input::list_dataset_export_jobs_input::Builder::default()
    }
    /// Creates a new `ListDatasetExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetExportJobs {
    type Output = std::result::Result<
        crate::output::ListDatasetExportJobsOutput,
        crate::error::ListDatasetExportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_export_jobs_response(response)
        }
    }
}

/// Operation shape for `ListDatasetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_groups`](crate::client::Client::list_dataset_groups).
///
/// See [`crate::client::fluent_builders::ListDatasetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetGroups {
    _private: (),
}
impl ListDatasetGroups {
    /// Creates a new builder-style object to manufacture [`ListDatasetGroupsInput`](crate::input::ListDatasetGroupsInput)
    pub fn builder() -> crate::input::list_dataset_groups_input::Builder {
        crate::input::list_dataset_groups_input::Builder::default()
    }
    /// Creates a new `ListDatasetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetGroups {
    type Output = std::result::Result<
        crate::output::ListDatasetGroupsOutput,
        crate::error::ListDatasetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_groups_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_groups_response(response)
        }
    }
}

/// Operation shape for `ListDatasetImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_import_jobs`](crate::client::Client::list_dataset_import_jobs).
///
/// See [`crate::client::fluent_builders::ListDatasetImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetImportJobs {
    _private: (),
}
impl ListDatasetImportJobs {
    /// Creates a new builder-style object to manufacture [`ListDatasetImportJobsInput`](crate::input::ListDatasetImportJobsInput)
    pub fn builder() -> crate::input::list_dataset_import_jobs_input::Builder {
        crate::input::list_dataset_import_jobs_input::Builder::default()
    }
    /// Creates a new `ListDatasetImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetImportJobs {
    type Output = std::result::Result<
        crate::output::ListDatasetImportJobsOutput,
        crate::error::ListDatasetImportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_import_jobs_response(response)
        }
    }
}

/// Operation shape for `ListDatasets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_datasets`](crate::client::Client::list_datasets).
///
/// See [`crate::client::fluent_builders::ListDatasets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasets {
    _private: (),
}
impl ListDatasets {
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
    /// Creates a new `ListDatasets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasets {
    type Output =
        std::result::Result<crate::output::ListDatasetsOutput, crate::error::ListDatasetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_datasets_error(response)
        } else {
            crate::operation_deser::parse_list_datasets_response(response)
        }
    }
}

/// Operation shape for `ListEventTrackers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_event_trackers`](crate::client::Client::list_event_trackers).
///
/// See [`crate::client::fluent_builders::ListEventTrackers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventTrackers {
    _private: (),
}
impl ListEventTrackers {
    /// Creates a new builder-style object to manufacture [`ListEventTrackersInput`](crate::input::ListEventTrackersInput)
    pub fn builder() -> crate::input::list_event_trackers_input::Builder {
        crate::input::list_event_trackers_input::Builder::default()
    }
    /// Creates a new `ListEventTrackers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventTrackers {
    type Output = std::result::Result<
        crate::output::ListEventTrackersOutput,
        crate::error::ListEventTrackersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_event_trackers_error(response)
        } else {
            crate::operation_deser::parse_list_event_trackers_response(response)
        }
    }
}

/// Operation shape for `ListFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_filters`](crate::client::Client::list_filters).
///
/// See [`crate::client::fluent_builders::ListFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFilters {
    _private: (),
}
impl ListFilters {
    /// Creates a new builder-style object to manufacture [`ListFiltersInput`](crate::input::ListFiltersInput)
    pub fn builder() -> crate::input::list_filters_input::Builder {
        crate::input::list_filters_input::Builder::default()
    }
    /// Creates a new `ListFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFilters {
    type Output =
        std::result::Result<crate::output::ListFiltersOutput, crate::error::ListFiltersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_filters_error(response)
        } else {
            crate::operation_deser::parse_list_filters_response(response)
        }
    }
}

/// Operation shape for `ListRecipes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recipes`](crate::client::Client::list_recipes).
///
/// See [`crate::client::fluent_builders::ListRecipes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecipes {
    _private: (),
}
impl ListRecipes {
    /// Creates a new builder-style object to manufacture [`ListRecipesInput`](crate::input::ListRecipesInput)
    pub fn builder() -> crate::input::list_recipes_input::Builder {
        crate::input::list_recipes_input::Builder::default()
    }
    /// Creates a new `ListRecipes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecipes {
    type Output =
        std::result::Result<crate::output::ListRecipesOutput, crate::error::ListRecipesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recipes_error(response)
        } else {
            crate::operation_deser::parse_list_recipes_response(response)
        }
    }
}

/// Operation shape for `ListRecommenders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recommenders`](crate::client::Client::list_recommenders).
///
/// See [`crate::client::fluent_builders::ListRecommenders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecommenders {
    _private: (),
}
impl ListRecommenders {
    /// Creates a new builder-style object to manufacture [`ListRecommendersInput`](crate::input::ListRecommendersInput)
    pub fn builder() -> crate::input::list_recommenders_input::Builder {
        crate::input::list_recommenders_input::Builder::default()
    }
    /// Creates a new `ListRecommenders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecommenders {
    type Output = std::result::Result<
        crate::output::ListRecommendersOutput,
        crate::error::ListRecommendersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recommenders_error(response)
        } else {
            crate::operation_deser::parse_list_recommenders_response(response)
        }
    }
}

/// Operation shape for `ListSchemas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schemas`](crate::client::Client::list_schemas).
///
/// See [`crate::client::fluent_builders::ListSchemas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchemas {
    _private: (),
}
impl ListSchemas {
    /// Creates a new builder-style object to manufacture [`ListSchemasInput`](crate::input::ListSchemasInput)
    pub fn builder() -> crate::input::list_schemas_input::Builder {
        crate::input::list_schemas_input::Builder::default()
    }
    /// Creates a new `ListSchemas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchemas {
    type Output =
        std::result::Result<crate::output::ListSchemasOutput, crate::error::ListSchemasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schemas_error(response)
        } else {
            crate::operation_deser::parse_list_schemas_response(response)
        }
    }
}

/// Operation shape for `ListSolutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_solutions`](crate::client::Client::list_solutions).
///
/// See [`crate::client::fluent_builders::ListSolutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSolutions {
    _private: (),
}
impl ListSolutions {
    /// Creates a new builder-style object to manufacture [`ListSolutionsInput`](crate::input::ListSolutionsInput)
    pub fn builder() -> crate::input::list_solutions_input::Builder {
        crate::input::list_solutions_input::Builder::default()
    }
    /// Creates a new `ListSolutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSolutions {
    type Output =
        std::result::Result<crate::output::ListSolutionsOutput, crate::error::ListSolutionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_solutions_error(response)
        } else {
            crate::operation_deser::parse_list_solutions_response(response)
        }
    }
}

/// Operation shape for `ListSolutionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_solution_versions`](crate::client::Client::list_solution_versions).
///
/// See [`crate::client::fluent_builders::ListSolutionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSolutionVersions {
    _private: (),
}
impl ListSolutionVersions {
    /// Creates a new builder-style object to manufacture [`ListSolutionVersionsInput`](crate::input::ListSolutionVersionsInput)
    pub fn builder() -> crate::input::list_solution_versions_input::Builder {
        crate::input::list_solution_versions_input::Builder::default()
    }
    /// Creates a new `ListSolutionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSolutionVersions {
    type Output = std::result::Result<
        crate::output::ListSolutionVersionsOutput,
        crate::error::ListSolutionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_solution_versions_error(response)
        } else {
            crate::operation_deser::parse_list_solution_versions_response(response)
        }
    }
}

/// Operation shape for `StopSolutionVersionCreation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_solution_version_creation`](crate::client::Client::stop_solution_version_creation).
///
/// See [`crate::client::fluent_builders::StopSolutionVersionCreation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopSolutionVersionCreation {
    _private: (),
}
impl StopSolutionVersionCreation {
    /// Creates a new builder-style object to manufacture [`StopSolutionVersionCreationInput`](crate::input::StopSolutionVersionCreationInput)
    pub fn builder() -> crate::input::stop_solution_version_creation_input::Builder {
        crate::input::stop_solution_version_creation_input::Builder::default()
    }
    /// Creates a new `StopSolutionVersionCreation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopSolutionVersionCreation {
    type Output = std::result::Result<
        crate::output::StopSolutionVersionCreationOutput,
        crate::error::StopSolutionVersionCreationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_solution_version_creation_error(response)
        } else {
            crate::operation_deser::parse_stop_solution_version_creation_response(response)
        }
    }
}

/// Operation shape for `UpdateCampaign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_campaign`](crate::client::Client::update_campaign).
///
/// See [`crate::client::fluent_builders::UpdateCampaign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCampaign {
    _private: (),
}
impl UpdateCampaign {
    /// Creates a new builder-style object to manufacture [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
    pub fn builder() -> crate::input::update_campaign_input::Builder {
        crate::input::update_campaign_input::Builder::default()
    }
    /// Creates a new `UpdateCampaign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCampaign {
    type Output =
        std::result::Result<crate::output::UpdateCampaignOutput, crate::error::UpdateCampaignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_campaign_error(response)
        } else {
            crate::operation_deser::parse_update_campaign_response(response)
        }
    }
}

/// Operation shape for `UpdateRecommender`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_recommender`](crate::client::Client::update_recommender).
///
/// See [`crate::client::fluent_builders::UpdateRecommender`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRecommender {
    _private: (),
}
impl UpdateRecommender {
    /// Creates a new builder-style object to manufacture [`UpdateRecommenderInput`](crate::input::UpdateRecommenderInput)
    pub fn builder() -> crate::input::update_recommender_input::Builder {
        crate::input::update_recommender_input::Builder::default()
    }
    /// Creates a new `UpdateRecommender` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRecommender {
    type Output = std::result::Result<
        crate::output::UpdateRecommenderOutput,
        crate::error::UpdateRecommenderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_recommender_error(response)
        } else {
            crate::operation_deser::parse_update_recommender_response(response)
        }
    }
}
