// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Personalize
///
/// Client for invoking operations on Amazon Personalize. Each operation on Amazon Personalize is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_personalize::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_personalize::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_personalize::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateBatchInferenceJob` operation.
    ///
    /// See [`CreateBatchInferenceJob`](crate::client::fluent_builders::CreateBatchInferenceJob) for more information about the
    /// operation and its arguments.
    pub fn create_batch_inference_job(&self) -> fluent_builders::CreateBatchInferenceJob<C, M, R> {
        fluent_builders::CreateBatchInferenceJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBatchSegmentJob` operation.
    ///
    /// See [`CreateBatchSegmentJob`](crate::client::fluent_builders::CreateBatchSegmentJob) for more information about the
    /// operation and its arguments.
    pub fn create_batch_segment_job(&self) -> fluent_builders::CreateBatchSegmentJob<C, M, R> {
        fluent_builders::CreateBatchSegmentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCampaign` operation.
    ///
    /// See [`CreateCampaign`](crate::client::fluent_builders::CreateCampaign) for more information about the
    /// operation and its arguments.
    pub fn create_campaign(&self) -> fluent_builders::CreateCampaign<C, M, R> {
        fluent_builders::CreateCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataset` operation.
    ///
    /// See [`CreateDataset`](crate::client::fluent_builders::CreateDataset) for more information about the
    /// operation and its arguments.
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset<C, M, R> {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatasetExportJob` operation.
    ///
    /// See [`CreateDatasetExportJob`](crate::client::fluent_builders::CreateDatasetExportJob) for more information about the
    /// operation and its arguments.
    pub fn create_dataset_export_job(&self) -> fluent_builders::CreateDatasetExportJob<C, M, R> {
        fluent_builders::CreateDatasetExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatasetGroup` operation.
    ///
    /// See [`CreateDatasetGroup`](crate::client::fluent_builders::CreateDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_dataset_group(&self) -> fluent_builders::CreateDatasetGroup<C, M, R> {
        fluent_builders::CreateDatasetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatasetImportJob` operation.
    ///
    /// See [`CreateDatasetImportJob`](crate::client::fluent_builders::CreateDatasetImportJob) for more information about the
    /// operation and its arguments.
    pub fn create_dataset_import_job(&self) -> fluent_builders::CreateDatasetImportJob<C, M, R> {
        fluent_builders::CreateDatasetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventTracker` operation.
    ///
    /// See [`CreateEventTracker`](crate::client::fluent_builders::CreateEventTracker) for more information about the
    /// operation and its arguments.
    pub fn create_event_tracker(&self) -> fluent_builders::CreateEventTracker<C, M, R> {
        fluent_builders::CreateEventTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFilter` operation.
    ///
    /// See [`CreateFilter`](crate::client::fluent_builders::CreateFilter) for more information about the
    /// operation and its arguments.
    pub fn create_filter(&self) -> fluent_builders::CreateFilter<C, M, R> {
        fluent_builders::CreateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecommender` operation.
    ///
    /// See [`CreateRecommender`](crate::client::fluent_builders::CreateRecommender) for more information about the
    /// operation and its arguments.
    pub fn create_recommender(&self) -> fluent_builders::CreateRecommender<C, M, R> {
        fluent_builders::CreateRecommender::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSchema` operation.
    ///
    /// See [`CreateSchema`](crate::client::fluent_builders::CreateSchema) for more information about the
    /// operation and its arguments.
    pub fn create_schema(&self) -> fluent_builders::CreateSchema<C, M, R> {
        fluent_builders::CreateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSolution` operation.
    ///
    /// See [`CreateSolution`](crate::client::fluent_builders::CreateSolution) for more information about the
    /// operation and its arguments.
    pub fn create_solution(&self) -> fluent_builders::CreateSolution<C, M, R> {
        fluent_builders::CreateSolution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSolutionVersion` operation.
    ///
    /// See [`CreateSolutionVersion`](crate::client::fluent_builders::CreateSolutionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_solution_version(&self) -> fluent_builders::CreateSolutionVersion<C, M, R> {
        fluent_builders::CreateSolutionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCampaign` operation.
    ///
    /// See [`DeleteCampaign`](crate::client::fluent_builders::DeleteCampaign) for more information about the
    /// operation and its arguments.
    pub fn delete_campaign(&self) -> fluent_builders::DeleteCampaign<C, M, R> {
        fluent_builders::DeleteCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDatasetGroup` operation.
    ///
    /// See [`DeleteDatasetGroup`](crate::client::fluent_builders::DeleteDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset_group(&self) -> fluent_builders::DeleteDatasetGroup<C, M, R> {
        fluent_builders::DeleteDatasetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventTracker` operation.
    ///
    /// See [`DeleteEventTracker`](crate::client::fluent_builders::DeleteEventTracker) for more information about the
    /// operation and its arguments.
    pub fn delete_event_tracker(&self) -> fluent_builders::DeleteEventTracker<C, M, R> {
        fluent_builders::DeleteEventTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFilter` operation.
    ///
    /// See [`DeleteFilter`](crate::client::fluent_builders::DeleteFilter) for more information about the
    /// operation and its arguments.
    pub fn delete_filter(&self) -> fluent_builders::DeleteFilter<C, M, R> {
        fluent_builders::DeleteFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecommender` operation.
    ///
    /// See [`DeleteRecommender`](crate::client::fluent_builders::DeleteRecommender) for more information about the
    /// operation and its arguments.
    pub fn delete_recommender(&self) -> fluent_builders::DeleteRecommender<C, M, R> {
        fluent_builders::DeleteRecommender::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSchema` operation.
    ///
    /// See [`DeleteSchema`](crate::client::fluent_builders::DeleteSchema) for more information about the
    /// operation and its arguments.
    pub fn delete_schema(&self) -> fluent_builders::DeleteSchema<C, M, R> {
        fluent_builders::DeleteSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSolution` operation.
    ///
    /// See [`DeleteSolution`](crate::client::fluent_builders::DeleteSolution) for more information about the
    /// operation and its arguments.
    pub fn delete_solution(&self) -> fluent_builders::DeleteSolution<C, M, R> {
        fluent_builders::DeleteSolution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAlgorithm` operation.
    ///
    /// See [`DescribeAlgorithm`](crate::client::fluent_builders::DescribeAlgorithm) for more information about the
    /// operation and its arguments.
    pub fn describe_algorithm(&self) -> fluent_builders::DescribeAlgorithm<C, M, R> {
        fluent_builders::DescribeAlgorithm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBatchInferenceJob` operation.
    ///
    /// See [`DescribeBatchInferenceJob`](crate::client::fluent_builders::DescribeBatchInferenceJob) for more information about the
    /// operation and its arguments.
    pub fn describe_batch_inference_job(
        &self,
    ) -> fluent_builders::DescribeBatchInferenceJob<C, M, R> {
        fluent_builders::DescribeBatchInferenceJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBatchSegmentJob` operation.
    ///
    /// See [`DescribeBatchSegmentJob`](crate::client::fluent_builders::DescribeBatchSegmentJob) for more information about the
    /// operation and its arguments.
    pub fn describe_batch_segment_job(&self) -> fluent_builders::DescribeBatchSegmentJob<C, M, R> {
        fluent_builders::DescribeBatchSegmentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCampaign` operation.
    ///
    /// See [`DescribeCampaign`](crate::client::fluent_builders::DescribeCampaign) for more information about the
    /// operation and its arguments.
    pub fn describe_campaign(&self) -> fluent_builders::DescribeCampaign<C, M, R> {
        fluent_builders::DescribeCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDatasetExportJob` operation.
    ///
    /// See [`DescribeDatasetExportJob`](crate::client::fluent_builders::DescribeDatasetExportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset_export_job(
        &self,
    ) -> fluent_builders::DescribeDatasetExportJob<C, M, R> {
        fluent_builders::DescribeDatasetExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDatasetGroup` operation.
    ///
    /// See [`DescribeDatasetGroup`](crate::client::fluent_builders::DescribeDatasetGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset_group(&self) -> fluent_builders::DescribeDatasetGroup<C, M, R> {
        fluent_builders::DescribeDatasetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDatasetImportJob` operation.
    ///
    /// See [`DescribeDatasetImportJob`](crate::client::fluent_builders::DescribeDatasetImportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset_import_job(
        &self,
    ) -> fluent_builders::DescribeDatasetImportJob<C, M, R> {
        fluent_builders::DescribeDatasetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventTracker` operation.
    ///
    /// See [`DescribeEventTracker`](crate::client::fluent_builders::DescribeEventTracker) for more information about the
    /// operation and its arguments.
    pub fn describe_event_tracker(&self) -> fluent_builders::DescribeEventTracker<C, M, R> {
        fluent_builders::DescribeEventTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFeatureTransformation` operation.
    ///
    /// See [`DescribeFeatureTransformation`](crate::client::fluent_builders::DescribeFeatureTransformation) for more information about the
    /// operation and its arguments.
    pub fn describe_feature_transformation(
        &self,
    ) -> fluent_builders::DescribeFeatureTransformation<C, M, R> {
        fluent_builders::DescribeFeatureTransformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFilter` operation.
    ///
    /// See [`DescribeFilter`](crate::client::fluent_builders::DescribeFilter) for more information about the
    /// operation and its arguments.
    pub fn describe_filter(&self) -> fluent_builders::DescribeFilter<C, M, R> {
        fluent_builders::DescribeFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecipe` operation.
    ///
    /// See [`DescribeRecipe`](crate::client::fluent_builders::DescribeRecipe) for more information about the
    /// operation and its arguments.
    pub fn describe_recipe(&self) -> fluent_builders::DescribeRecipe<C, M, R> {
        fluent_builders::DescribeRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecommender` operation.
    ///
    /// See [`DescribeRecommender`](crate::client::fluent_builders::DescribeRecommender) for more information about the
    /// operation and its arguments.
    pub fn describe_recommender(&self) -> fluent_builders::DescribeRecommender<C, M, R> {
        fluent_builders::DescribeRecommender::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSchema` operation.
    ///
    /// See [`DescribeSchema`](crate::client::fluent_builders::DescribeSchema) for more information about the
    /// operation and its arguments.
    pub fn describe_schema(&self) -> fluent_builders::DescribeSchema<C, M, R> {
        fluent_builders::DescribeSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSolution` operation.
    ///
    /// See [`DescribeSolution`](crate::client::fluent_builders::DescribeSolution) for more information about the
    /// operation and its arguments.
    pub fn describe_solution(&self) -> fluent_builders::DescribeSolution<C, M, R> {
        fluent_builders::DescribeSolution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSolutionVersion` operation.
    ///
    /// See [`DescribeSolutionVersion`](crate::client::fluent_builders::DescribeSolutionVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_solution_version(&self) -> fluent_builders::DescribeSolutionVersion<C, M, R> {
        fluent_builders::DescribeSolutionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSolutionMetrics` operation.
    ///
    /// See [`GetSolutionMetrics`](crate::client::fluent_builders::GetSolutionMetrics) for more information about the
    /// operation and its arguments.
    pub fn get_solution_metrics(&self) -> fluent_builders::GetSolutionMetrics<C, M, R> {
        fluent_builders::GetSolutionMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBatchInferenceJobs` operation.
    ///
    /// See [`ListBatchInferenceJobs`](crate::client::fluent_builders::ListBatchInferenceJobs) for more information about the
    /// operation and its arguments.
    pub fn list_batch_inference_jobs(&self) -> fluent_builders::ListBatchInferenceJobs<C, M, R> {
        fluent_builders::ListBatchInferenceJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBatchSegmentJobs` operation.
    ///
    /// See [`ListBatchSegmentJobs`](crate::client::fluent_builders::ListBatchSegmentJobs) for more information about the
    /// operation and its arguments.
    pub fn list_batch_segment_jobs(&self) -> fluent_builders::ListBatchSegmentJobs<C, M, R> {
        fluent_builders::ListBatchSegmentJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCampaigns` operation.
    ///
    /// See [`ListCampaigns`](crate::client::fluent_builders::ListCampaigns) for more information about the
    /// operation and its arguments.
    pub fn list_campaigns(&self) -> fluent_builders::ListCampaigns<C, M, R> {
        fluent_builders::ListCampaigns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetExportJobs` operation.
    ///
    /// See [`ListDatasetExportJobs`](crate::client::fluent_builders::ListDatasetExportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_export_jobs(&self) -> fluent_builders::ListDatasetExportJobs<C, M, R> {
        fluent_builders::ListDatasetExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetGroups` operation.
    ///
    /// See [`ListDatasetGroups`](crate::client::fluent_builders::ListDatasetGroups) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_groups(&self) -> fluent_builders::ListDatasetGroups<C, M, R> {
        fluent_builders::ListDatasetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetImportJobs` operation.
    ///
    /// See [`ListDatasetImportJobs`](crate::client::fluent_builders::ListDatasetImportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_import_jobs(&self) -> fluent_builders::ListDatasetImportJobs<C, M, R> {
        fluent_builders::ListDatasetImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasets` operation.
    ///
    /// See [`ListDatasets`](crate::client::fluent_builders::ListDatasets) for more information about the
    /// operation and its arguments.
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets<C, M, R> {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventTrackers` operation.
    ///
    /// See [`ListEventTrackers`](crate::client::fluent_builders::ListEventTrackers) for more information about the
    /// operation and its arguments.
    pub fn list_event_trackers(&self) -> fluent_builders::ListEventTrackers<C, M, R> {
        fluent_builders::ListEventTrackers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFilters` operation.
    ///
    /// See [`ListFilters`](crate::client::fluent_builders::ListFilters) for more information about the
    /// operation and its arguments.
    pub fn list_filters(&self) -> fluent_builders::ListFilters<C, M, R> {
        fluent_builders::ListFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecipes` operation.
    ///
    /// See [`ListRecipes`](crate::client::fluent_builders::ListRecipes) for more information about the
    /// operation and its arguments.
    pub fn list_recipes(&self) -> fluent_builders::ListRecipes<C, M, R> {
        fluent_builders::ListRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecommenders` operation.
    ///
    /// See [`ListRecommenders`](crate::client::fluent_builders::ListRecommenders) for more information about the
    /// operation and its arguments.
    pub fn list_recommenders(&self) -> fluent_builders::ListRecommenders<C, M, R> {
        fluent_builders::ListRecommenders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSchemas` operation.
    ///
    /// See [`ListSchemas`](crate::client::fluent_builders::ListSchemas) for more information about the
    /// operation and its arguments.
    pub fn list_schemas(&self) -> fluent_builders::ListSchemas<C, M, R> {
        fluent_builders::ListSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSolutions` operation.
    ///
    /// See [`ListSolutions`](crate::client::fluent_builders::ListSolutions) for more information about the
    /// operation and its arguments.
    pub fn list_solutions(&self) -> fluent_builders::ListSolutions<C, M, R> {
        fluent_builders::ListSolutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSolutionVersions` operation.
    ///
    /// See [`ListSolutionVersions`](crate::client::fluent_builders::ListSolutionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_solution_versions(&self) -> fluent_builders::ListSolutionVersions<C, M, R> {
        fluent_builders::ListSolutionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopSolutionVersionCreation` operation.
    ///
    /// See [`StopSolutionVersionCreation`](crate::client::fluent_builders::StopSolutionVersionCreation) for more information about the
    /// operation and its arguments.
    pub fn stop_solution_version_creation(
        &self,
    ) -> fluent_builders::StopSolutionVersionCreation<C, M, R> {
        fluent_builders::StopSolutionVersionCreation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCampaign` operation.
    ///
    /// See [`UpdateCampaign`](crate::client::fluent_builders::UpdateCampaign) for more information about the
    /// operation and its arguments.
    pub fn update_campaign(&self) -> fluent_builders::UpdateCampaign<C, M, R> {
        fluent_builders::UpdateCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecommender` operation.
    ///
    /// See [`UpdateRecommender`](crate::client::fluent_builders::UpdateRecommender) for more information about the
    /// operation and its arguments.
    pub fn update_recommender(&self) -> fluent_builders::UpdateRecommender<C, M, R> {
        fluent_builders::UpdateRecommender::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBatchInferenceJob`.
    ///
    /// <p>Creates a batch inference job. The operation can handle up to 50 million records and the
    /// input file must be in JSON format. For more information, see <a>recommendations-batch</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBatchInferenceJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_batch_inference_job_input::Builder,
    }
    impl<C, M, R> CreateBatchInferenceJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBatchInferenceJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchInferenceJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchInferenceJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBatchInferenceJobInputOperationOutputAlias,
                crate::output::CreateBatchInferenceJobOutput,
                crate::error::CreateBatchInferenceJobError,
                crate::input::CreateBatchInferenceJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the batch inference job to create.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the batch inference job to create.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the
        /// batch inference recommendations.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the
        /// batch inference recommendations.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
        /// <p>The ARN of the filter to apply to the batch inference job. For more information on using
        /// filters, see
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering Batch Recommendations</a>..</p>
        pub fn filter_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_arn(inp);
            self
        }
        /// <p>The ARN of the filter to apply to the batch inference job. For more information on using
        /// filters, see
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering Batch Recommendations</a>..</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_arn(input);
            self
        }
        /// <p>The number of recommendations to retreive.</p>
        pub fn num_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.num_results(inp);
            self
        }
        /// <p>The number of recommendations to retreive.</p>
        pub fn set_num_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_results(input);
            self
        }
        /// <p>The Amazon S3 path that leads to the input file to base your recommendations on. The input
        /// material must be in JSON format.</p>
        pub fn job_input(mut self, inp: crate::model::BatchInferenceJobInput) -> Self {
            self.inner = self.inner.job_input(inp);
            self
        }
        /// <p>The Amazon S3 path that leads to the input file to base your recommendations on. The input
        /// material must be in JSON format.</p>
        pub fn set_job_input(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobInput>,
        ) -> Self {
            self.inner = self.inner.set_job_input(input);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output will be stored.</p>
        pub fn job_output(mut self, inp: crate::model::BatchInferenceJobOutput) -> Self {
            self.inner = self.inner.job_output(inp);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output will be stored.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobOutput>,
        ) -> Self {
            self.inner = self.inner.set_job_output(input);
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
        /// Amazon S3 buckets respectively.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
        /// Amazon S3 buckets respectively.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The configuration details of a batch inference job.</p>
        pub fn batch_inference_job_config(
            mut self,
            inp: crate::model::BatchInferenceJobConfig,
        ) -> Self {
            self.inner = self.inner.batch_inference_job_config(inp);
            self
        }
        /// <p>The configuration details of a batch inference job.</p>
        pub fn set_batch_inference_job_config(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobConfig>,
        ) -> Self {
            self.inner = self.inner.set_batch_inference_job_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchSegmentJob`.
    ///
    /// <p>Creates a batch segment job. The operation can handle up to 50 million records and the
    /// input file must be in JSON format. For more information, see <a>recommendations-batch</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBatchSegmentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_batch_segment_job_input::Builder,
    }
    impl<C, M, R> CreateBatchSegmentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBatchSegmentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchSegmentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchSegmentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBatchSegmentJobInputOperationOutputAlias,
                crate::output::CreateBatchSegmentJobOutput,
                crate::error::CreateBatchSegmentJobError,
                crate::input::CreateBatchSegmentJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the batch segment job to create.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the batch segment job to create.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
        /// batch segments.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
        /// batch segments.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
        /// <p>The ARN of the filter to apply to the batch segment job. For more information on using
        /// filters, see <a>filter-batch</a>.</p>
        pub fn filter_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_arn(inp);
            self
        }
        /// <p>The ARN of the filter to apply to the batch segment job. For more information on using
        /// filters, see <a>filter-batch</a>.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_arn(input);
            self
        }
        /// <p>The number of predicted users generated by the batch segment job for each line of input data.</p>
        pub fn num_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.num_results(inp);
            self
        }
        /// <p>The number of predicted users generated by the batch segment job for each line of input data.</p>
        pub fn set_num_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_results(input);
            self
        }
        /// <p>The Amazon S3 path for the input data used to generate the batch segment job.</p>
        pub fn job_input(mut self, inp: crate::model::BatchSegmentJobInput) -> Self {
            self.inner = self.inner.job_input(inp);
            self
        }
        /// <p>The Amazon S3 path for the input data used to generate the batch segment job.</p>
        pub fn set_job_input(
            mut self,
            input: std::option::Option<crate::model::BatchSegmentJobInput>,
        ) -> Self {
            self.inner = self.inner.set_job_input(input);
            self
        }
        /// <p>The Amazon S3 path for the bucket where the job's output will be stored.</p>
        pub fn job_output(mut self, inp: crate::model::BatchSegmentJobOutput) -> Self {
            self.inner = self.inner.job_output(inp);
            self
        }
        /// <p>The Amazon S3 path for the bucket where the job's output will be stored.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::BatchSegmentJobOutput>,
        ) -> Self {
            self.inner = self.inner.set_job_output(input);
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
        /// Amazon S3 buckets respectively.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
        /// Amazon S3 buckets respectively.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCampaign`.
    ///
    /// <p>Creates a campaign that deploys a solution version. When a client calls the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
    /// and
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html">GetPersonalizedRanking</a>
    /// APIs, a campaign is specified in the request.</p>
    ///
    /// <p>
    /// <b>Minimum Provisioned TPS and Auto-Scaling</b>
    /// </p>
    ///
    /// <p>A transaction is a single <code>GetRecommendations</code> or
    /// <code>GetPersonalizedRanking</code> call. Transactions per second (TPS) is the throughput
    /// and unit of billing for Amazon Personalize. The minimum provisioned TPS
    /// (<code>minProvisionedTPS</code>) specifies the baseline throughput provisioned by
    /// Amazon Personalize, and thus, the minimum billing charge.
    /// </p>
    /// <p>
    /// If your TPS increases beyond
    /// <code>minProvisionedTPS</code>, Amazon Personalize auto-scales the provisioned capacity up and down,
    /// but never below <code>minProvisionedTPS</code>.
    /// There's a short time delay while the capacity is increased that might cause loss of
    /// transactions.</p>
    /// <p>The actual TPS used is calculated as the average requests/second within a 5-minute window.
    /// You pay for maximum of either the minimum provisioned TPS or the actual TPS.
    /// We recommend starting with a low <code>minProvisionedTPS</code>, track
    /// your usage using Amazon CloudWatch metrics, and then increase the <code>minProvisionedTPS</code>
    /// as necessary.</p>
    ///
    /// <p>
    /// <b>Status</b>
    /// </p>
    /// <p>A campaign can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>To get the campaign status, call <a>DescribeCampaign</a>.</p>
    /// <note>
    /// <p>Wait until the <code>status</code> of the campaign
    /// is <code>ACTIVE</code> before asking the campaign for recommendations.</p>
    /// </note>
    ///
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListCampaigns</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeCampaign</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>UpdateCampaign</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteCampaign</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_campaign_input::Builder,
    }
    impl<C, M, R> CreateCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCampaignInputOperationOutputAlias,
                crate::output::CreateCampaignOutput,
                crate::error::CreateCampaignError,
                crate::input::CreateCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the new campaign. The campaign name must be unique within your account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name for the new campaign. The campaign name must be unique within your account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version to deploy.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version to deploy.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn min_provisioned_tps(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_provisioned_tps(inp);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn set_min_provisioned_tps(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_provisioned_tps(input);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn campaign_config(mut self, inp: crate::model::CampaignConfig) -> Self {
            self.inner = self.inner.campaign_config(inp);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn set_campaign_config(
            mut self,
            input: std::option::Option<crate::model::CampaignConfig>,
        ) -> Self {
            self.inner = self.inner.set_campaign_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates an empty dataset and adds it to the specified dataset group. Use <a>CreateDatasetImportJob</a> to import your training data to a dataset.</p>
    /// <p>There are three types of datasets:</p>
    /// <ul>
    /// <li>
    /// <p>Interactions</p>
    /// </li>
    /// <li>
    /// <p>Items</p>
    /// </li>
    /// <li>
    /// <p>Users</p>
    /// </li>
    /// </ul>
    /// <p>Each dataset type has an associated schema with required field types. Only the
    /// <code>Interactions</code> dataset is required in order to train a model (also referred to as
    /// creating a solution).</p>
    /// <p>A dataset can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>To get the status of the dataset, call <a>DescribeDataset</a>.</p>
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>CreateDatasetGroup</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>ListDatasets</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeDataset</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteDataset</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl<C, M, R> CreateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetInputOperationOutputAlias,
                crate::output::CreateDatasetOutput,
                crate::error::CreateDatasetError,
                crate::input::CreateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the dataset.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN of the schema to associate with the dataset. The schema defines the dataset
        /// fields.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The ARN of the schema to associate with the dataset. The schema defines the dataset
        /// fields.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>The type of dataset.</p>
        /// <p>One of the following (case insensitive) values:</p>
        /// <ul>
        /// <li>
        /// <p>Interactions</p>
        /// </li>
        /// <li>
        /// <p>Items</p>
        /// </li>
        /// <li>
        /// <p>Users</p>
        /// </li>
        /// </ul>
        pub fn dataset_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The type of dataset.</p>
        /// <p>One of the following (case insensitive) values:</p>
        /// <ul>
        /// <li>
        /// <p>Interactions</p>
        /// </li>
        /// <li>
        /// <p>Items</p>
        /// </li>
        /// <li>
        /// <p>Users</p>
        /// </li>
        /// </ul>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetExportJob`.
    ///
    /// <p>
    /// Creates a job that exports data from your dataset to an Amazon S3 bucket.
    /// To allow Amazon Personalize to export the training data, you must specify an
    /// service-linked IAM role that gives Amazon Personalize <code>PutObject</code> permissions for your Amazon S3 bucket.
    /// For information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/export-data.html">Exporting a dataset</a>
    /// in the Amazon Personalize developer guide.
    /// </p>
    /// <p>
    /// <b>Status</b>
    /// </p>
    /// <p>A dataset export job can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// </ul>
    /// <p>
    /// To get the status of the export job, call <a>DescribeDatasetExportJob</a>,
    /// and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is
    /// complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response
    /// includes a <code>failureReason</code> key, which describes why the job failed.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatasetExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_export_job_input::Builder,
    }
    impl<C, M, R> CreateDatasetExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatasetExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetExportJobInputOperationOutputAlias,
                crate::output::CreateDatasetExportJobOutput,
                crate::error::CreateDatasetExportJobError,
                crate::input::CreateDatasetExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the dataset export job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name for the dataset export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job,
        /// only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
        /// for both types. The default value is <code>PUT</code>.
        /// </p>
        pub fn ingestion_mode(mut self, inp: crate::model::IngestionMode) -> Self {
            self.inner = self.inner.ingestion_mode(inp);
            self
        }
        /// <p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job,
        /// only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
        /// for both types. The default value is <code>PUT</code>.
        /// </p>
        pub fn set_ingestion_mode(
            mut self,
            input: std::option::Option<crate::model::IngestionMode>,
        ) -> Self {
            self.inner = self.inner.set_ingestion_mode(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your
        /// output Amazon S3 bucket.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your
        /// output Amazon S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output is stored.</p>
        pub fn job_output(mut self, inp: crate::model::DatasetExportJobOutput) -> Self {
            self.inner = self.inner.job_output(inp);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output is stored.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::DatasetExportJobOutput>,
        ) -> Self {
            self.inner = self.inner.set_job_output(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetGroup`.
    ///
    /// <p>Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources.
    /// A dataset group can contain at most three datasets, one for each type of
    /// dataset:</p>
    /// <ul>
    /// <li>
    /// <p>Interactions</p>
    /// </li>
    /// <li>
    /// <p>Items</p>
    /// </li>
    /// <li>
    /// <p>Users</p>
    /// </li>
    /// </ul>
    /// <p>
    /// A dataset group can be a Domain dataset group, where you specify a domain and use
    /// pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that
    /// you deploy with a campaign.  If you start with a Domain dataset group, you can still add custom resources such as
    /// solutions and solution versions trained with recipes for custom use cases and deployed with campaigns.
    /// </p>
    /// <p>A dataset group can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING</p>
    /// </li>
    /// </ul>
    /// <p>To get the status of the dataset group, call <a>DescribeDatasetGroup</a>. If
    /// the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key,
    /// which describes why the creation failed.</p>
    /// <note>
    /// <p>You must wait until the <code>status</code> of the dataset group is <code>ACTIVE</code>
    /// before adding a dataset to the group.</p>
    /// </note>
    /// <p>You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you
    /// specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to
    /// access the key.</p>
    /// <p class="title">
    /// <b>APIs that require a dataset group ARN in the request</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>CreateDataset</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>CreateEventTracker</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>CreateSolution</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListDatasetGroups</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeDatasetGroup</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteDatasetGroup</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_group_input::Builder,
    }
    impl<C, M, R> CreateDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetGroupInputOperationOutputAlias,
                crate::output::CreateDatasetGroupOutput,
                crate::error::CreateDatasetGroupError,
                crate::input::CreateDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the new dataset group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the new dataset group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM
        /// role is only valid when also specifying a KMS key.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM
        /// role is only valid when also specifying a KMS key.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify
        /// determines the default schemas for datasets and the use cases available for recommenders. If you don't specify a domain,
        /// you create a Custom dataset group with solution versions that you deploy with a campaign.
        /// </p>
        pub fn domain(mut self, inp: crate::model::Domain) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify
        /// determines the default schemas for datasets and the use cases available for recommenders. If you don't specify a domain,
        /// you create a Custom dataset group with solution versions that you deploy with a campaign.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetImportJob`.
    ///
    /// <p>Creates a job that imports training data from your data source (an Amazon S3 bucket) to an
    /// Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an
    /// IAM service role that has permission to read from the data source, as Amazon Personalize makes a
    /// copy of your data and processes it internally. For information on granting access
    /// to your Amazon S3 bucket, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html">Giving Amazon Personalize
    /// Access to Amazon S3 Resources</a>. </p>
    /// <important>
    /// <p>The dataset import job replaces any existing data in the dataset that you imported in bulk.</p>
    /// </important>
    /// <p>
    /// <b>Status</b>
    /// </p>
    /// <p>A dataset import job can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// </ul>
    /// <p>To get the status of the import job, call <a>DescribeDatasetImportJob</a>,
    /// providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is
    /// complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response
    /// includes a <code>failureReason</code> key, which describes why the job failed.</p>
    /// <note>
    /// <p>Importing takes time. You must wait until the status shows as ACTIVE before training a
    /// model using the dataset.</p>
    /// </note>
    ///
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListDatasetImportJobs</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeDatasetImportJob</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatasetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_import_job_input::Builder,
    }
    impl<C, M, R> CreateDatasetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatasetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetImportJobInputOperationOutputAlias,
                crate::output::CreateDatasetImportJobOutput,
                crate::error::CreateDatasetImportJobError,
                crate::input::CreateDatasetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the dataset import job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name for the dataset import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The ARN of the dataset that receives the imported data.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The ARN of the dataset that receives the imported data.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains the training data to import.</p>
        pub fn data_source(mut self, inp: crate::model::DataSource) -> Self {
            self.inner = self.inner.data_source(inp);
            self
        }
        /// <p>The Amazon S3 bucket that contains the training data to import.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventTracker`.
    ///
    /// <p>Creates an event tracker that you use when adding event data to a specified dataset
    /// group using the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
    /// <note>
    /// <p>Only one event tracker can be associated with a dataset group. You will get
    /// an error if you call <code>CreateEventTracker</code> using the same dataset group as an
    /// existing event tracker.</p>
    /// </note>
    /// <p>When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> operation.
    /// Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify
    /// in your event tracker.
    /// </p>
    /// <p>The event tracker can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>To get the status of the event tracker, call <a>DescribeEventTracker</a>.</p>
    /// <note>
    /// <p>The event tracker must be in the ACTIVE state before using the tracking ID.</p>
    /// </note>
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListEventTrackers</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeEventTracker</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteEventTracker</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_tracker_input::Builder,
    }
    impl<C, M, R> CreateEventTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventTrackerInputOperationOutputAlias,
                crate::output::CreateEventTrackerOutput,
                crate::error::CreateEventTrackerError,
                crate::input::CreateEventTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the event tracker.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the event tracker.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFilter`.
    ///
    /// <p>Creates a recommendation filter. For more information, see <a>filter</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_filter_input::Builder,
    }
    impl<C, M, R> CreateFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFilterInputOperationOutputAlias,
                crate::output::CreateFilterOutput,
                crate::error::CreateFilterError,
                crate::input::CreateFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the filter to create.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the filter to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN of the dataset group that the filter will belong to.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The ARN of the dataset group that the filter will belong to.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules.
        /// For information about filter expression structure and syntax, see
        /// <a>filter-expressions</a>.</p>
        pub fn filter_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(inp);
            self
        }
        /// <p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules.
        /// For information about filter expression structure and syntax, see
        /// <a>filter-expressions</a>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecommender`.
    ///
    /// <p>Creates a recommender with the recipe (a Domain dataset group use case) you specify.
    /// You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
    /// request.
    /// </p>
    ///
    ///
    ///
    /// <p>
    /// <b>Status</b>
    /// </p>
    /// <p>A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>To get the recommender status, call <a>DescribeRecommender</a>.</p>
    /// <note>
    /// <p>Wait until the <code>status</code> of the recommender
    /// is <code>ACTIVE</code> before asking the recommender for recommendations.</p>
    /// </note>
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListRecommenders</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeRecommender</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>UpdateRecommender</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteRecommender</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateRecommender<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recommender_input::Builder,
    }
    impl<C, M, R> CreateRecommender<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecommender`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecommenderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecommenderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecommenderInputOperationOutputAlias,
                crate::output::CreateRecommenderOutput,
                crate::error::CreateRecommenderError,
                crate::input::CreateRecommenderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recommender.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recommender.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a Domain dataset group
        /// use case. Only Domain dataset group use cases can be used to create a recommender. For information about use cases see <a href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use cases</a>.
        /// </p>
        pub fn recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a Domain dataset group
        /// use case. Only Domain dataset group use cases can be used to create a recommender. For information about use cases see <a href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use cases</a>.
        /// </p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_arn(input);
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn recommender_config(mut self, inp: crate::model::RecommenderConfig) -> Self {
            self.inner = self.inner.recommender_config(inp);
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn set_recommender_config(
            mut self,
            input: std::option::Option<crate::model::RecommenderConfig>,
        ) -> Self {
            self.inner = self.inner.set_recommender_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSchema`.
    ///
    /// <p>Creates an Amazon Personalize schema from the specified schema string. The schema you create
    /// must be in Avro JSON format.</p>
    /// <p>Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset
    /// type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you
    /// provide the domain of the Domain dataset group.
    /// You specify a schema when you call <a>CreateDataset</a>.</p>
    ///
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListSchemas</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeSchema</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteSchema</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_schema_input::Builder,
    }
    impl<C, M, R> CreateSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSchemaInputOperationOutputAlias,
                crate::output::CreateSchemaOutput,
                crate::error::CreateSchemaError,
                crate::input::CreateSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the schema.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A schema in Avro JSON format.</p>
        pub fn schema(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>A schema in Avro JSON format.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// <p>The domain for the schema. If you are creating a schema for a dataset in a Domain dataset group, specify
        /// the domain you chose when you created the Domain dataset group.</p>
        pub fn domain(mut self, inp: crate::model::Domain) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain for the schema. If you are creating a schema for a dataset in a Domain dataset group, specify
        /// the domain you chose when you created the Domain dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSolution`.
    ///
    /// <p>Creates the configuration for training a model. A trained model is known as
    /// a solution. After the configuration is created, you train the model (create a solution)
    /// by calling the <a>CreateSolutionVersion</a> operation. Every time you call
    /// <code>CreateSolutionVersion</code>, a new version of the solution is created.</p>
    /// <p>After creating a solution version, you check its accuracy by calling
    /// <a>GetSolutionMetrics</a>. When you are satisfied with the version, you
    /// deploy it using <a>CreateCampaign</a>. The campaign provides recommendations
    /// to a client through the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> API.</p>
    /// <p>To train a model, Amazon Personalize requires training data and a recipe. The training data
    /// comes from the dataset group that you provide in the request. A recipe specifies
    /// the training algorithm and a feature transformation. You can specify one of the predefined
    /// recipes provided by Amazon Personalize. Alternatively, you can specify
    /// <code>performAutoML</code> and Amazon Personalize will analyze your data and select the
    /// optimum USER_PERSONALIZATION recipe for you.</p>
    /// <note>
    /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
    /// for solution hyperparameter optimization at this time.</p>
    /// </note>
    /// <p>
    /// <b>Status</b>
    /// </p>
    /// <p>A solution can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>To get the status of the solution, call <a>DescribeSolution</a>. Wait
    /// until the status shows as ACTIVE before calling <code>CreateSolutionVersion</code>.</p>
    ///
    ///
    ///
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListSolutions</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>CreateSolutionVersion</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeSolution</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteSolution</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListSolutionVersions</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeSolutionVersion</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateSolution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_solution_input::Builder,
    }
    impl<C, M, R> CreateSolution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSolution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSolutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSolutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSolutionInputOperationOutputAlias,
                crate::output::CreateSolutionOutput,
                crate::error::CreateSolutionError,
                crate::input::CreateSolutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the solution.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the solution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe.
        /// The default is <code>false</code>.</p>
        /// <p>When performing AutoML, this parameter is always <code>true</code> and you
        /// should not set it to <code>false</code>.</p>
        pub fn perform_hpo(mut self, inp: bool) -> Self {
            self.inner = self.inner.perform_hpo(inp);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe.
        /// The default is <code>false</code>.</p>
        /// <p>When performing AutoML, this parameter is always <code>true</code> and you
        /// should not set it to <code>false</code>.</p>
        pub fn set_perform_hpo(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_hpo(input);
            self
        }
        /// <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>.
        /// For this case, you must specify <code>recipeArn</code>.</p>
        /// <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects
        /// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit
        /// <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with
        /// different values for the hyperparameters.
        /// AutoML lengthens the training process as compared to selecting a specific recipe.</p>
        pub fn perform_auto_ml(mut self, inp: bool) -> Self {
            self.inner = self.inner.perform_auto_ml(inp);
            self
        }
        /// <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>.
        /// For this case, you must specify <code>recipeArn</code>.</p>
        /// <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects
        /// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit
        /// <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with
        /// different values for the hyperparameters.
        /// AutoML lengthens the training process as compared to selecting a specific recipe.</p>
        pub fn set_perform_auto_ml(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_auto_ml(input);
            self
        }
        /// <p>The ARN of the recipe to use for model training. Only specified when
        /// <code>performAutoML</code> is false.</p>
        pub fn recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_arn(inp);
            self
        }
        /// <p>The ARN of the recipe to use for model training. Only specified when
        /// <code>performAutoML</code> is false.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field),
        /// this parameter specifies which event type (for example, 'click' or 'like') is used for
        /// training the model.</p>
        /// <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
        /// equal weight regardless of type.</p>
        pub fn event_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type(inp);
            self
        }
        /// <p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field),
        /// this parameter specifies which event type (for example, 'click' or 'like') is used for
        /// training the model.</p>
        /// <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
        /// equal weight regardless of type.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_type(input);
            self
        }
        /// <p>The configuration to use with the solution. When <code>performAutoML</code> is set to
        /// true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section
        /// of the solution configuration.</p>
        /// <note>
        /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
        /// at this time.</p>
        /// </note>
        pub fn solution_config(mut self, inp: crate::model::SolutionConfig) -> Self {
            self.inner = self.inner.solution_config(inp);
            self
        }
        /// <p>The configuration to use with the solution. When <code>performAutoML</code> is set to
        /// true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section
        /// of the solution configuration.</p>
        /// <note>
        /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
        /// at this time.</p>
        /// </note>
        pub fn set_solution_config(
            mut self,
            input: std::option::Option<crate::model::SolutionConfig>,
        ) -> Self {
            self.inner = self.inner.set_solution_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSolutionVersion`.
    ///
    /// <p>Trains or retrains an active solution in a Custom dataset group. A solution is created using the <a>CreateSolution</a> operation and must be in the ACTIVE state before calling
    /// <code>CreateSolutionVersion</code>. A new version of the solution is created every time you
    /// call this operation.</p>
    /// <p>
    /// <b>Status</b>
    /// </p>
    /// <p>A solution version can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING</p>
    /// </li>
    /// <li>
    /// <p>CREATE IN_PROGRESS</p>
    /// </li>
    /// <li>
    /// <p>ACTIVE</p>
    /// </li>
    /// <li>
    /// <p>CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>CREATE STOPPING</p>
    /// </li>
    /// <li>
    /// <p>CREATE STOPPED</p>
    /// </li>
    /// </ul>
    /// <p>To get the status of the version, call <a>DescribeSolutionVersion</a>. Wait
    /// until the status shows as ACTIVE before calling <code>CreateCampaign</code>.</p>
    /// <p>If the status shows as CREATE FAILED, the response includes a <code>failureReason</code>
    /// key, which describes why the job failed.</p>
    /// <p class="title">
    /// <b>Related APIs</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListSolutionVersions</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeSolutionVersion</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>ListSolutions</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>CreateSolution</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeSolution</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DeleteSolution</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateSolutionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_solution_version_input::Builder,
    }
    impl<C, M, R> CreateSolutionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSolutionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSolutionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSolutionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSolutionVersionInputOperationOutputAlias,
                crate::output::CreateSolutionVersionOutput,
                crate::error::CreateSolutionVersionError,
                crate::input::CreateSolutionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution containing the training configuration
        /// information.</p>
        pub fn solution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution containing the training configuration
        /// information.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_solution_arn(input);
            self
        }
        /// <p>The scope of training to be performed when creating the solution version. The
        /// <code>FULL</code> option trains the solution version based on the entirety of the input
        /// solution's training data, while the <code>UPDATE</code> option processes only the data that
        /// has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to
        /// incrementally update your solution version instead of creating an entirely new one.</p>
        /// <important>
        /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution
        /// version created from the input solution using the <code>FULL</code> option and the input
        /// solution was trained with the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>
        /// recipe or the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
        /// </important>
        pub fn training_mode(mut self, inp: crate::model::TrainingMode) -> Self {
            self.inner = self.inner.training_mode(inp);
            self
        }
        /// <p>The scope of training to be performed when creating the solution version. The
        /// <code>FULL</code> option trains the solution version based on the entirety of the input
        /// solution's training data, while the <code>UPDATE</code> option processes only the data that
        /// has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to
        /// incrementally update your solution version instead of creating an entirely new one.</p>
        /// <important>
        /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution
        /// version created from the input solution using the <code>FULL</code> option and the input
        /// solution was trained with the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>
        /// recipe or the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
        /// </important>
        pub fn set_training_mode(
            mut self,
            input: std::option::Option<crate::model::TrainingMode>,
        ) -> Self {
            self.inner = self.inner.set_training_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCampaign`.
    ///
    /// <p>Removes a campaign by deleting the solution deployment. The solution that
    /// the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no
    /// longer be specified in a
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
    /// request.
    /// For more information on campaigns, see <a>CreateCampaign</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_campaign_input::Builder,
    }
    impl<C, M, R> DeleteCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCampaignInputOperationOutputAlias,
                crate::output::DeleteCampaignOutput,
                crate::error::DeleteCampaignError,
                crate::input::DeleteCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign to delete.</p>
        pub fn campaign_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign to delete.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes a dataset. You can't delete a dataset if an associated
    /// <code>DatasetImportJob</code> or <code>SolutionVersion</code> is in the CREATE PENDING or IN
    /// PROGRESS state. For more information on datasets, see <a>CreateDataset</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatasetGroup`.
    ///
    /// <p>Deletes a dataset group. Before you delete a dataset group, you must delete the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>All associated event trackers.</p>
    /// </li>
    /// <li>
    /// <p>All associated solutions.</p>
    /// </li>
    /// <li>
    /// <p>All datasets in the dataset group.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_group_input::Builder,
    }
    impl<C, M, R> DeleteDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetGroupInputOperationOutputAlias,
                crate::output::DeleteDatasetGroupOutput,
                crate::error::DeleteDatasetGroupError,
                crate::input::DeleteDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the dataset group to delete.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The ARN of the dataset group to delete.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventTracker`.
    ///
    /// <p>Deletes the event tracker. Does not delete the event-interactions dataset from
    /// the associated dataset group. For more
    /// information on event trackers, see <a>CreateEventTracker</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_tracker_input::Builder,
    }
    impl<C, M, R> DeleteEventTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventTrackerInputOperationOutputAlias,
                crate::output::DeleteEventTrackerOutput,
                crate::error::DeleteEventTrackerError,
                crate::input::DeleteEventTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>
        pub fn event_tracker_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_tracker_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_tracker_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFilter`.
    ///
    /// <p>Deletes a filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_filter_input::Builder,
    }
    impl<C, M, R> DeleteFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFilterInputOperationOutputAlias,
                crate::output::DeleteFilterOutput,
                crate::error::DeleteFilterError,
                crate::input::DeleteFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the filter to delete.</p>
        pub fn filter_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_arn(inp);
            self
        }
        /// <p>The ARN of the filter to delete.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecommender`.
    ///
    /// <p>Deactivates and removes a recommender. A deleted recommender can no longer be specified in a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
    /// request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRecommender<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recommender_input::Builder,
    }
    impl<C, M, R> DeleteRecommender<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecommender`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecommenderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecommenderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecommenderInputOperationOutputAlias,
                crate::output::DeleteRecommenderOutput,
                crate::error::DeleteRecommenderError,
                crate::input::DeleteRecommenderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender to delete.</p>
        pub fn recommender_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender to delete.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchema`.
    ///
    /// <p>Deletes a schema. Before deleting a schema, you must delete all
    /// datasets referencing the schema. For more information on schemas, see
    /// <a>CreateSchema</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_schema_input::Builder,
    }
    impl<C, M, R> DeleteSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSchemaInputOperationOutputAlias,
                crate::output::DeleteSchemaOutput,
                crate::error::DeleteSchemaError,
                crate::input::DeleteSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the schema to delete.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema to delete.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSolution`.
    ///
    /// <p>Deletes all versions of a solution and the <code>Solution</code> object itself.
    /// Before deleting a solution, you must delete all campaigns based on
    /// the solution. To determine what campaigns are using the solution, call
    /// <a>ListCampaigns</a> and supply the Amazon Resource Name (ARN) of the solution.
    /// You can't delete a solution if an associated <code>SolutionVersion</code> is in the
    /// CREATE PENDING or IN PROGRESS state.
    /// For more information on solutions, see <a>CreateSolution</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSolution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_solution_input::Builder,
    }
    impl<C, M, R> DeleteSolution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSolution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSolutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSolutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSolutionInputOperationOutputAlias,
                crate::output::DeleteSolutionOutput,
                crate::error::DeleteSolutionError,
                crate::input::DeleteSolutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the solution to delete.</p>
        pub fn solution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_arn(inp);
            self
        }
        /// <p>The ARN of the solution to delete.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_solution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlgorithm`.
    ///
    /// <p>Describes the given algorithm.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAlgorithm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_algorithm_input::Builder,
    }
    impl<C, M, R> DescribeAlgorithm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAlgorithm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlgorithmOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlgorithmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAlgorithmInputOperationOutputAlias,
                crate::output::DescribeAlgorithmOutput,
                crate::error::DescribeAlgorithmError,
                crate::input::DescribeAlgorithmInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>
        pub fn algorithm_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.algorithm_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBatchInferenceJob`.
    ///
    /// <p>Gets the properties of a batch inference job including name, Amazon Resource Name (ARN),
    /// status, input and output configurations, and the ARN of the solution version used to generate
    /// the recommendations.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBatchInferenceJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_batch_inference_job_input::Builder,
    }
    impl<C, M, R> DescribeBatchInferenceJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBatchInferenceJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBatchInferenceJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBatchInferenceJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBatchInferenceJobInputOperationOutputAlias,
                crate::output::DescribeBatchInferenceJobOutput,
                crate::error::DescribeBatchInferenceJobError,
                crate::input::DescribeBatchInferenceJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the batch inference job to describe.</p>
        pub fn batch_inference_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_inference_job_arn(inp);
            self
        }
        /// <p>The ARN of the batch inference job to describe.</p>
        pub fn set_batch_inference_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_inference_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBatchSegmentJob`.
    ///
    /// <p>Gets the properties of a batch segment job including name, Amazon Resource Name (ARN),
    /// status, input and output configurations, and the ARN of the solution version used to generate
    /// segments.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBatchSegmentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_batch_segment_job_input::Builder,
    }
    impl<C, M, R> DescribeBatchSegmentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBatchSegmentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBatchSegmentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBatchSegmentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBatchSegmentJobInputOperationOutputAlias,
                crate::output::DescribeBatchSegmentJobOutput,
                crate::error::DescribeBatchSegmentJobError,
                crate::input::DescribeBatchSegmentJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the batch segment job to describe.</p>
        pub fn batch_segment_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_segment_job_arn(inp);
            self
        }
        /// <p>The ARN of the batch segment job to describe.</p>
        pub fn set_batch_segment_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_segment_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCampaign`.
    ///
    /// <p>Describes the given campaign, including its status.</p>
    /// <p>A campaign can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the
    /// <code>failureReason</code> key, which describes why.</p>
    /// <p>For more information on campaigns, see <a>CreateCampaign</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_campaign_input::Builder,
    }
    impl<C, M, R> DescribeCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCampaignInputOperationOutputAlias,
                crate::output::DescribeCampaignOutput,
                crate::error::DescribeCampaignError,
                crate::input::DescribeCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn campaign_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Describes the given dataset. For more information on datasets, see <a>CreateDataset</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to describe.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to describe.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatasetExportJob`.
    ///
    /// <p>Describes the dataset export job created by <a>CreateDatasetExportJob</a>,
    /// including the export job status.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDatasetExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_export_job_input::Builder,
    }
    impl<C, M, R> DescribeDatasetExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDatasetExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetExportJobInputOperationOutputAlias,
                crate::output::DescribeDatasetExportJobOutput,
                crate::error::DescribeDatasetExportJobError,
                crate::input::DescribeDatasetExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>
        pub fn dataset_export_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_export_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>
        pub fn set_dataset_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_export_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatasetGroup`.
    ///
    /// <p>Describes the given dataset group. For more information on dataset groups, see <a>CreateDatasetGroup</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDatasetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_group_input::Builder,
    }
    impl<C, M, R> DescribeDatasetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDatasetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetGroupInputOperationOutputAlias,
                crate::output::DescribeDatasetGroupOutput,
                crate::error::DescribeDatasetGroupError,
                crate::input::DescribeDatasetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatasetImportJob`.
    ///
    /// <p>Describes the dataset import job created by <a>CreateDatasetImportJob</a>,
    /// including the import job status.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDatasetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_import_job_input::Builder,
    }
    impl<C, M, R> DescribeDatasetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDatasetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetImportJobInputOperationOutputAlias,
                crate::output::DescribeDatasetImportJobOutput,
                crate::error::DescribeDatasetImportJobError,
                crate::input::DescribeDatasetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>
        pub fn dataset_import_job_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_import_job_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_import_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventTracker`.
    ///
    /// <p>Describes an event tracker. The response includes the <code>trackingId</code> and
    /// <code>status</code> of the event tracker.
    /// For more information on event trackers, see <a>CreateEventTracker</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_tracker_input::Builder,
    }
    impl<C, M, R> DescribeEventTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventTrackerInputOperationOutputAlias,
                crate::output::DescribeEventTrackerOutput,
                crate::error::DescribeEventTrackerError,
                crate::input::DescribeEventTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>
        pub fn event_tracker_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_tracker_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_tracker_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFeatureTransformation`.
    ///
    /// <p>Describes the given feature transformation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFeatureTransformation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_feature_transformation_input::Builder,
    }
    impl<C, M, R> DescribeFeatureTransformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFeatureTransformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFeatureTransformationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFeatureTransformationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFeatureTransformationInputOperationOutputAlias,
                crate::output::DescribeFeatureTransformationOutput,
                crate::error::DescribeFeatureTransformationError,
                crate::input::DescribeFeatureTransformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>
        pub fn feature_transformation_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_transformation_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>
        pub fn set_feature_transformation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feature_transformation_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFilter`.
    ///
    /// <p>Describes a filter's properties.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_filter_input::Builder,
    }
    impl<C, M, R> DescribeFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFilterInputOperationOutputAlias,
                crate::output::DescribeFilterOutput,
                crate::error::DescribeFilterError,
                crate::input::DescribeFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the filter to describe.</p>
        pub fn filter_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_arn(inp);
            self
        }
        /// <p>The ARN of the filter to describe.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecipe`.
    ///
    /// <p>Describes a recipe.</p>
    /// <p>A recipe contains three items:</p>
    /// <ul>
    /// <li>
    /// <p>An algorithm that trains a model.</p>
    /// </li>
    /// <li>
    /// <p>Hyperparameters that govern the training.</p>
    /// </li>
    /// <li>
    /// <p>Feature transformation information for modifying the input data before training.</p>
    /// </li>
    /// </ul>
    /// <p>Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a
    /// solution with the <a>CreateSolution</a> API.
    /// <code>CreateSolution</code> trains a model by using the algorithm
    /// in the specified recipe and a training dataset. The solution, when deployed as a campaign,
    /// can provide recommendations using the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recipe_input::Builder,
    }
    impl<C, M, R> DescribeRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecipeInputOperationOutputAlias,
                crate::output::DescribeRecipeOutput,
                crate::error::DescribeRecipeError,
                crate::input::DescribeRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe to describe.</p>
        pub fn recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe to describe.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecommender`.
    ///
    /// <p>Describes the given recommender, including its status.</p>
    /// <p>A recommender can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED</p>
    /// </li>
    /// <li>
    /// <p>DELETE PENDING > DELETE IN_PROGRESS</p>
    /// </li>
    /// </ul>
    /// <p>When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the
    /// <code>failureReason</code> key, which describes why.</p>
    /// <p>For more information on recommenders, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRecommender<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recommender_input::Builder,
    }
    impl<C, M, R> DescribeRecommender<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecommender`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecommenderOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecommenderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecommenderInputOperationOutputAlias,
                crate::output::DescribeRecommenderOutput,
                crate::error::DescribeRecommenderError,
                crate::input::DescribeRecommenderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender to describe.</p>
        pub fn recommender_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender to describe.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSchema`.
    ///
    /// <p>Describes a schema. For more information on schemas, see
    /// <a>CreateSchema</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_schema_input::Builder,
    }
    impl<C, M, R> DescribeSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSchemaInputOperationOutputAlias,
                crate::output::DescribeSchemaOutput,
                crate::error::DescribeSchemaError,
                crate::input::DescribeSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>
        pub fn schema_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSolution`.
    ///
    /// <p>Describes a solution.
    /// For more information on solutions, see <a>CreateSolution</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSolution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_solution_input::Builder,
    }
    impl<C, M, R> DescribeSolution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSolution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSolutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSolutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSolutionInputOperationOutputAlias,
                crate::output::DescribeSolutionOutput,
                crate::error::DescribeSolutionError,
                crate::input::DescribeSolutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution to describe.</p>
        pub fn solution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution to describe.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_solution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSolutionVersion`.
    ///
    /// <p>Describes a specific version of a solution. For more information on solutions, see <a>CreateSolution</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSolutionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_solution_version_input::Builder,
    }
    impl<C, M, R> DescribeSolutionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSolutionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSolutionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSolutionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSolutionVersionInputOperationOutputAlias,
                crate::output::DescribeSolutionVersionOutput,
                crate::error::DescribeSolutionVersionError,
                crate::input::DescribeSolutionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSolutionMetrics`.
    ///
    /// <p>Gets the metrics for the specified solution version.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSolutionMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_solution_metrics_input::Builder,
    }
    impl<C, M, R> GetSolutionMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSolutionMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSolutionMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSolutionMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSolutionMetricsInputOperationOutputAlias,
                crate::output::GetSolutionMetricsOutput,
                crate::error::GetSolutionMetricsError,
                crate::input::GetSolutionMetricsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBatchInferenceJobs`.
    ///
    /// <p>Gets a list of the batch inference jobs that have been performed off of a solution
    /// version.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBatchInferenceJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_batch_inference_jobs_input::Builder,
    }
    impl<C, M, R> ListBatchInferenceJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBatchInferenceJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBatchInferenceJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBatchInferenceJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBatchInferenceJobsInputOperationOutputAlias,
                crate::output::ListBatchInferenceJobsOutput,
                crate::error::ListBatchInferenceJobsError,
                crate::input::ListBatchInferenceJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs
        /// were created.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs
        /// were created.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of batch inference job results to return in each page. The default
        /// value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of batch inference job results to return in each page. The default
        /// value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBatchSegmentJobs`.
    ///
    /// <p>Gets a list of the batch segment jobs that have been performed off of a solution
    /// version that you specify.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBatchSegmentJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_batch_segment_jobs_input::Builder,
    }
    impl<C, M, R> ListBatchSegmentJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBatchSegmentJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBatchSegmentJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBatchSegmentJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBatchSegmentJobsInputOperationOutputAlias,
                crate::output::ListBatchSegmentJobsOutput,
                crate::error::ListBatchSegmentJobsError,
                crate::input::ListBatchSegmentJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version that the batch segment jobs used to generate batch segments.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version that the batch segment jobs used to generate batch segments.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of batch segment job results to return in each page. The default
        /// value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of batch segment job results to return in each page. The default
        /// value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCampaigns`.
    ///
    /// <p>Returns a list of campaigns that use the given solution.
    /// When a solution is not specified, all the campaigns associated with the account are listed.
    /// The response provides the properties for each campaign, including the Amazon Resource Name (ARN).
    /// For more information on campaigns, see <a>CreateCampaign</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCampaigns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_campaigns_input::Builder,
    }
    impl<C, M, R> ListCampaigns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCampaigns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCampaignsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCampaignsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCampaignsInputOperationOutputAlias,
                crate::output::ListCampaignsOutput,
                crate::error::ListCampaignsError,
                crate::input::ListCampaignsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When
        /// a solution is not specified, all the campaigns associated with the account are listed.</p>
        pub fn solution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When
        /// a solution is not specified, all the campaigns associated with the account are listed.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_solution_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListCampaigns</code> for getting
        /// the next set of campaigns (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListCampaigns</code> for getting
        /// the next set of campaigns (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of campaigns to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of campaigns to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetExportJobs`.
    ///
    /// <p>Returns a list of dataset export jobs that use the given dataset. When a dataset is not
    /// specified, all the dataset export jobs associated with the account are listed. The response
    /// provides the properties for each dataset export job, including the Amazon Resource Name (ARN).
    /// For more information on dataset export jobs, see <a>CreateDatasetExportJob</a>. For
    /// more information on datasets, see <a>CreateDataset</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_export_jobs_input::Builder,
    }
    impl<C, M, R> ListDatasetExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetExportJobsInputOperationOutputAlias,
                crate::output::ListDatasetExportJobsOutput,
                crate::error::ListDatasetExportJobsError,
                crate::input::ListDatasetExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting
        /// the next set of dataset export jobs (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting
        /// the next set of dataset export jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of dataset export jobs to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of dataset export jobs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetGroups`.
    ///
    /// <p>Returns a list of dataset groups. The response provides the properties for each dataset
    /// group, including the Amazon Resource Name (ARN). For more information on dataset groups, see
    /// <a>CreateDatasetGroup</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_groups_input::Builder,
    }
    impl<C, M, R> ListDatasetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetGroupsInputOperationOutputAlias,
                crate::output::ListDatasetGroupsOutput,
                crate::error::ListDatasetGroupsError,
                crate::input::ListDatasetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the
        /// next set of dataset groups (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the
        /// next set of dataset groups (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of dataset groups to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of dataset groups to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetImportJobs`.
    ///
    /// <p>Returns a list of dataset import jobs that use the given dataset. When a dataset is not
    /// specified, all the dataset import jobs associated with the account are listed. The response
    /// provides the properties for each dataset import job, including the Amazon Resource Name (ARN).
    /// For more information on dataset import jobs, see <a>CreateDatasetImportJob</a>. For
    /// more information on datasets, see <a>CreateDataset</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_import_jobs_input::Builder,
    }
    impl<C, M, R> ListDatasetImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetImportJobsInputOperationOutputAlias,
                crate::output::ListDatasetImportJobsOutput,
                crate::error::ListDatasetImportJobsError,
                crate::input::ListDatasetImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of dataset import jobs to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of dataset import jobs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Returns the list of datasets contained in the given dataset group. The response provides
    /// the properties for each dataset, including the Amazon Resource Name (ARN). For more
    /// information on datasets, see <a>CreateDataset</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl<C, M, R> ListDatasets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetsInputOperationOutputAlias,
                crate::output::ListDatasetsOutput,
                crate::error::ListDatasetsError,
                crate::input::ListDatasetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to
        /// list.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to
        /// list.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of datasets to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of datasets to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventTrackers`.
    ///
    /// <p>Returns the list of event trackers associated with the account.
    /// The response provides the properties for each event tracker, including the Amazon Resource
    /// Name (ARN) and tracking ID. For more
    /// information on event trackers, see <a>CreateEventTracker</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEventTrackers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_trackers_input::Builder,
    }
    impl<C, M, R> ListEventTrackers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventTrackers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventTrackersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventTrackersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventTrackersInputOperationOutputAlias,
                crate::output::ListEventTrackersOutput,
                crate::error::ListEventTrackersError,
                crate::input::ListEventTrackersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a dataset group used to filter the response.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The ARN of a dataset group used to filter the response.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListEventTrackers</code> for getting
        /// the next set of event trackers (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListEventTrackers</code> for getting
        /// the next set of event trackers (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of event trackers to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of event trackers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFilters`.
    ///
    /// <p>Lists all filters that belong to a given dataset group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFilters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_filters_input::Builder,
    }
    impl<C, M, R> ListFilters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFiltersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFiltersInputOperationOutputAlias,
                crate::output::ListFiltersOutput,
                crate::error::ListFiltersError,
                crate::input::ListFiltersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the dataset group that contains the filters.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The ARN of the dataset group that contains the filters.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListFilters</code> for getting the
        /// next set of filters (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListFilters</code> for getting the
        /// next set of filters (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of filters to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of filters to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecipes`.
    ///
    /// <p>Returns a list of available recipes. The response provides the properties
    /// for each recipe, including the recipe's Amazon Resource Name (ARN).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecipes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recipes_input::Builder,
    }
    impl<C, M, R> ListRecipes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecipesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecipesInputOperationOutputAlias,
                crate::output::ListRecipesOutput,
                crate::error::ListRecipesError,
                crate::input::ListRecipesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The default is <code>SERVICE</code>.</p>
        pub fn recipe_provider(mut self, inp: crate::model::RecipeProvider) -> Self {
            self.inner = self.inner.recipe_provider(inp);
            self
        }
        /// <p>The default is <code>SERVICE</code>.</p>
        pub fn set_recipe_provider(
            mut self,
            input: std::option::Option<crate::model::RecipeProvider>,
        ) -> Self {
            self.inner = self.inner.set_recipe_provider(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListRecipes</code> for getting
        /// the next set of recipes (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListRecipes</code> for getting
        /// the next set of recipes (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of recipes to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of recipes to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases)
        /// for this domain are included in the response. If you don't specify a domain, only non-domain recipes are returned.
        /// </p>
        pub fn domain(mut self, inp: crate::model::Domain) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases)
        /// for this domain are included in the response. If you don't specify a domain, only non-domain recipes are returned.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommenders`.
    ///
    /// <p>Returns a list of recommenders in a given Domain dataset group.
    /// When a Domain dataset group is not specified, all the recommenders associated with the account are listed.
    /// The response provides the properties for each recommender, including the Amazon Resource Name (ARN).
    /// For more information on recommenders, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecommenders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recommenders_input::Builder,
    }
    impl<C, M, R> ListRecommenders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecommenders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecommendersInputOperationOutputAlias,
                crate::output::ListRecommendersOutput,
                crate::error::ListRecommendersError,
                crate::input::ListRecommendersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Domain dataset group to list the recommenders for. When
        /// a Domain dataset group is not specified, all the recommenders associated with the account are listed.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Domain dataset group to list the recommenders for. When
        /// a Domain dataset group is not specified, all the recommenders associated with the account are listed.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListRecommenders</code> for getting
        /// the next set of recommenders (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListRecommenders</code> for getting
        /// the next set of recommenders (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of recommenders to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of recommenders to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchemas`.
    ///
    /// <p>Returns the list of schemas associated with the account. The response provides the
    /// properties for each schema, including the Amazon Resource Name (ARN).
    /// For more information on schemas, see <a>CreateSchema</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSchemas<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schemas_input::Builder,
    }
    impl<C, M, R> ListSchemas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchemasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchemasInputOperationOutputAlias,
                crate::output::ListSchemasOutput,
                crate::error::ListSchemasError,
                crate::input::ListSchemasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from the previous call to <code>ListSchemas</code> for getting
        /// the next set of schemas (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListSchemas</code> for getting
        /// the next set of schemas (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of schemas to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of schemas to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSolutions`.
    ///
    /// <p>Returns a list of solutions that use the given dataset group.
    /// When a dataset group is not specified, all the solutions associated with the account are listed.
    /// The response provides the properties for each solution, including the Amazon Resource Name (ARN).
    /// For more information on solutions, see <a>CreateSolution</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSolutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_solutions_input::Builder,
    }
    impl<C, M, R> ListSolutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSolutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSolutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSolutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSolutionsInputOperationOutputAlias,
                crate::output::ListSolutionsOutput,
                crate::error::ListSolutionsError,
                crate::input::ListSolutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataset_group_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutions</code> for getting
        /// the next set of solutions (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutions</code> for getting
        /// the next set of solutions (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of solutions to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of solutions to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSolutionVersions`.
    ///
    /// <p>Returns a list of solution versions for the given solution. When a solution is not
    /// specified, all the solution versions associated with the account are listed. The response
    /// provides the properties for each solution version, including the Amazon Resource Name (ARN).
    /// For more information on solutions, see <a>CreateSolution</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSolutionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_solution_versions_input::Builder,
    }
    impl<C, M, R> ListSolutionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSolutionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSolutionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSolutionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSolutionVersionsInputOperationOutputAlias,
                crate::output::ListSolutionVersionsOutput,
                crate::error::ListSolutionVersionsError,
                crate::input::ListSolutionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution.</p>
        pub fn solution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_solution_arn(input);
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting
        /// the next set of solution versions (if they exist).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting
        /// the next set of solution versions (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of solution versions to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of solution versions to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopSolutionVersionCreation`.
    ///
    /// <p>Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
    /// </p>
    /// <p>Depending on the current state of the solution version, the solution version state changes as follows:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE_PENDING > CREATE_STOPPED</p>
    /// <p>or</p>
    /// </li>
    /// <li>
    /// <p>CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED</p>
    /// </li>
    /// </ul>
    /// <p>You are billed for all of the training completed up
    /// until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopSolutionVersionCreation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_solution_version_creation_input::Builder,
    }
    impl<C, M, R> StopSolutionVersionCreation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopSolutionVersionCreation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopSolutionVersionCreationOutput,
            aws_smithy_http::result::SdkError<crate::error::StopSolutionVersionCreationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopSolutionVersionCreationInputOperationOutputAlias,
                crate::output::StopSolutionVersionCreationOutput,
                crate::error::StopSolutionVersionCreationError,
                crate::input::StopSolutionVersionCreationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCampaign`.
    ///
    /// <p>Updates a campaign by either deploying a new solution or changing the value of the
    /// campaign's <code>minProvisionedTPS</code> parameter.</p>
    /// <p>To update a campaign, the campaign status must be ACTIVE or CREATE FAILED.
    /// Check the campaign status using the <a>DescribeCampaign</a> API.</p>
    /// <note>
    /// <p>You must wait until the <code>status</code> of the
    /// updated campaign is <code>ACTIVE</code> before asking the campaign for recommendations.</p>
    /// </note>
    /// <p>For more information on campaigns, see <a>CreateCampaign</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_campaign_input::Builder,
    }
    impl<C, M, R> UpdateCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCampaignInputOperationOutputAlias,
                crate::output::UpdateCampaignOutput,
                crate::error::UpdateCampaignError,
                crate::input::UpdateCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn campaign_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_arn(input);
            self
        }
        /// <p>The ARN of a new solution version to deploy.</p>
        pub fn solution_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_version_arn(inp);
            self
        }
        /// <p>The ARN of a new solution version to deploy.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_version_arn(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn min_provisioned_tps(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_provisioned_tps(inp);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn set_min_provisioned_tps(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_provisioned_tps(input);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn campaign_config(mut self, inp: crate::model::CampaignConfig) -> Self {
            self.inner = self.inner.campaign_config(inp);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn set_campaign_config(
            mut self,
            input: std::option::Option<crate::model::CampaignConfig>,
        ) -> Self {
            self.inner = self.inner.set_campaign_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecommender`.
    ///
    /// <p>Updates the recommender to modify the recommender configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecommender<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recommender_input::Builder,
    }
    impl<C, M, R> UpdateRecommender<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecommender`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecommenderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecommenderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecommenderInputOperationOutputAlias,
                crate::output::UpdateRecommenderOutput,
                crate::error::UpdateRecommenderError,
                crate::input::UpdateRecommenderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender to modify.</p>
        pub fn recommender_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommender_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender to modify.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommender_arn(input);
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn recommender_config(mut self, inp: crate::model::RecommenderConfig) -> Self {
            self.inner = self.inner.recommender_config(inp);
            self
        }
        /// <p>The configuration details of the recommender.</p>
        pub fn set_recommender_config(
            mut self,
            input: std::option::Option<crate::model::RecommenderConfig>,
        ) -> Self {
            self.inner = self.inner.set_recommender_config(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
