// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecommenderOutput {
    /// <p>The same recommender Amazon Resource Name (ARN) as given in the request.</p>
    pub recommender_arn: std::option::Option<std::string::String>,
}
impl UpdateRecommenderOutput {
    /// <p>The same recommender Amazon Resource Name (ARN) as given in the request.</p>
    pub fn recommender_arn(&self) -> std::option::Option<&str> {
        self.recommender_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateRecommenderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecommenderOutput");
        formatter.field("recommender_arn", &self.recommender_arn);
        formatter.finish()
    }
}
/// See [`UpdateRecommenderOutput`](crate::output::UpdateRecommenderOutput)
pub mod update_recommender_output {
    /// A builder for [`UpdateRecommenderOutput`](crate::output::UpdateRecommenderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The same recommender Amazon Resource Name (ARN) as given in the request.</p>
        pub fn recommender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_arn = Some(input.into());
            self
        }
        /// <p>The same recommender Amazon Resource Name (ARN) as given in the request.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecommenderOutput`](crate::output::UpdateRecommenderOutput)
        pub fn build(self) -> crate::output::UpdateRecommenderOutput {
            crate::output::UpdateRecommenderOutput {
                recommender_arn: self.recommender_arn,
            }
        }
    }
}
impl UpdateRecommenderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRecommenderOutput`](crate::output::UpdateRecommenderOutput)
    pub fn builder() -> crate::output::update_recommender_output::Builder {
        crate::output::update_recommender_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCampaignOutput {
    /// <p>The same campaign ARN as given in the request.</p>
    pub campaign_arn: std::option::Option<std::string::String>,
}
impl UpdateCampaignOutput {
    /// <p>The same campaign ARN as given in the request.</p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateCampaignOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCampaignOutput");
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.finish()
    }
}
/// See [`UpdateCampaignOutput`](crate::output::UpdateCampaignOutput)
pub mod update_campaign_output {
    /// A builder for [`UpdateCampaignOutput`](crate::output::UpdateCampaignOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The same campaign ARN as given in the request.</p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The same campaign ARN as given in the request.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCampaignOutput`](crate::output::UpdateCampaignOutput)
        pub fn build(self) -> crate::output::UpdateCampaignOutput {
            crate::output::UpdateCampaignOutput {
                campaign_arn: self.campaign_arn,
            }
        }
    }
}
impl UpdateCampaignOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCampaignOutput`](crate::output::UpdateCampaignOutput)
    pub fn builder() -> crate::output::update_campaign_output::Builder {
        crate::output::update_campaign_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopSolutionVersionCreationOutput {}
impl std::fmt::Debug for StopSolutionVersionCreationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopSolutionVersionCreationOutput");
        formatter.finish()
    }
}
/// See [`StopSolutionVersionCreationOutput`](crate::output::StopSolutionVersionCreationOutput)
pub mod stop_solution_version_creation_output {
    /// A builder for [`StopSolutionVersionCreationOutput`](crate::output::StopSolutionVersionCreationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopSolutionVersionCreationOutput`](crate::output::StopSolutionVersionCreationOutput)
        pub fn build(self) -> crate::output::StopSolutionVersionCreationOutput {
            crate::output::StopSolutionVersionCreationOutput {}
        }
    }
}
impl StopSolutionVersionCreationOutput {
    /// Creates a new builder-style object to manufacture [`StopSolutionVersionCreationOutput`](crate::output::StopSolutionVersionCreationOutput)
    pub fn builder() -> crate::output::stop_solution_version_creation_output::Builder {
        crate::output::stop_solution_version_creation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopRecommenderOutput {
    /// <p>The Amazon Resource Name (ARN) of the recommender you stopped.</p>
    pub recommender_arn: std::option::Option<std::string::String>,
}
impl StopRecommenderOutput {
    /// <p>The Amazon Resource Name (ARN) of the recommender you stopped.</p>
    pub fn recommender_arn(&self) -> std::option::Option<&str> {
        self.recommender_arn.as_deref()
    }
}
impl std::fmt::Debug for StopRecommenderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopRecommenderOutput");
        formatter.field("recommender_arn", &self.recommender_arn);
        formatter.finish()
    }
}
/// See [`StopRecommenderOutput`](crate::output::StopRecommenderOutput)
pub mod stop_recommender_output {
    /// A builder for [`StopRecommenderOutput`](crate::output::StopRecommenderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the recommender you stopped.</p>
        pub fn recommender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender you stopped.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopRecommenderOutput`](crate::output::StopRecommenderOutput)
        pub fn build(self) -> crate::output::StopRecommenderOutput {
            crate::output::StopRecommenderOutput {
                recommender_arn: self.recommender_arn,
            }
        }
    }
}
impl StopRecommenderOutput {
    /// Creates a new builder-style object to manufacture [`StopRecommenderOutput`](crate::output::StopRecommenderOutput)
    pub fn builder() -> crate::output::stop_recommender_output::Builder {
        crate::output::stop_recommender_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRecommenderOutput {
    /// <p>The Amazon Resource Name (ARN) of the recommender you started.</p>
    pub recommender_arn: std::option::Option<std::string::String>,
}
impl StartRecommenderOutput {
    /// <p>The Amazon Resource Name (ARN) of the recommender you started.</p>
    pub fn recommender_arn(&self) -> std::option::Option<&str> {
        self.recommender_arn.as_deref()
    }
}
impl std::fmt::Debug for StartRecommenderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRecommenderOutput");
        formatter.field("recommender_arn", &self.recommender_arn);
        formatter.finish()
    }
}
/// See [`StartRecommenderOutput`](crate::output::StartRecommenderOutput)
pub mod start_recommender_output {
    /// A builder for [`StartRecommenderOutput`](crate::output::StartRecommenderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the recommender you started.</p>
        pub fn recommender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender you started.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRecommenderOutput`](crate::output::StartRecommenderOutput)
        pub fn build(self) -> crate::output::StartRecommenderOutput {
            crate::output::StartRecommenderOutput {
                recommender_arn: self.recommender_arn,
            }
        }
    }
}
impl StartRecommenderOutput {
    /// Creates a new builder-style object to manufacture [`StartRecommenderOutput`](crate::output::StartRecommenderOutput)
    pub fn builder() -> crate::output::start_recommender_output::Builder {
        crate::output::start_recommender_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The resource's tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The resource's tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The resource's tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The resource's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSolutionVersionsOutput {
    /// <p>A list of solution versions describing the version properties.</p>
    pub solution_versions: std::option::Option<std::vec::Vec<crate::model::SolutionVersionSummary>>,
    /// <p>A token for getting the next set of solution versions (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSolutionVersionsOutput {
    /// <p>A list of solution versions describing the version properties.</p>
    pub fn solution_versions(
        &self,
    ) -> std::option::Option<&[crate::model::SolutionVersionSummary]> {
        self.solution_versions.as_deref()
    }
    /// <p>A token for getting the next set of solution versions (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSolutionVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSolutionVersionsOutput");
        formatter.field("solution_versions", &self.solution_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSolutionVersionsOutput`](crate::output::ListSolutionVersionsOutput)
pub mod list_solution_versions_output {
    /// A builder for [`ListSolutionVersionsOutput`](crate::output::ListSolutionVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_versions:
            std::option::Option<std::vec::Vec<crate::model::SolutionVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `solution_versions`.
        ///
        /// To override the contents of this collection use [`set_solution_versions`](Self::set_solution_versions).
        ///
        /// <p>A list of solution versions describing the version properties.</p>
        pub fn solution_versions(mut self, input: crate::model::SolutionVersionSummary) -> Self {
            let mut v = self.solution_versions.unwrap_or_default();
            v.push(input);
            self.solution_versions = Some(v);
            self
        }
        /// <p>A list of solution versions describing the version properties.</p>
        pub fn set_solution_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SolutionVersionSummary>>,
        ) -> Self {
            self.solution_versions = input;
            self
        }
        /// <p>A token for getting the next set of solution versions (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of solution versions (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSolutionVersionsOutput`](crate::output::ListSolutionVersionsOutput)
        pub fn build(self) -> crate::output::ListSolutionVersionsOutput {
            crate::output::ListSolutionVersionsOutput {
                solution_versions: self.solution_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSolutionVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListSolutionVersionsOutput`](crate::output::ListSolutionVersionsOutput)
    pub fn builder() -> crate::output::list_solution_versions_output::Builder {
        crate::output::list_solution_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSolutionsOutput {
    /// <p>A list of the current solutions.</p>
    pub solutions: std::option::Option<std::vec::Vec<crate::model::SolutionSummary>>,
    /// <p>A token for getting the next set of solutions (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSolutionsOutput {
    /// <p>A list of the current solutions.</p>
    pub fn solutions(&self) -> std::option::Option<&[crate::model::SolutionSummary]> {
        self.solutions.as_deref()
    }
    /// <p>A token for getting the next set of solutions (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSolutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSolutionsOutput");
        formatter.field("solutions", &self.solutions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSolutionsOutput`](crate::output::ListSolutionsOutput)
pub mod list_solutions_output {
    /// A builder for [`ListSolutionsOutput`](crate::output::ListSolutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solutions: std::option::Option<std::vec::Vec<crate::model::SolutionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `solutions`.
        ///
        /// To override the contents of this collection use [`set_solutions`](Self::set_solutions).
        ///
        /// <p>A list of the current solutions.</p>
        pub fn solutions(mut self, input: crate::model::SolutionSummary) -> Self {
            let mut v = self.solutions.unwrap_or_default();
            v.push(input);
            self.solutions = Some(v);
            self
        }
        /// <p>A list of the current solutions.</p>
        pub fn set_solutions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SolutionSummary>>,
        ) -> Self {
            self.solutions = input;
            self
        }
        /// <p>A token for getting the next set of solutions (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of solutions (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSolutionsOutput`](crate::output::ListSolutionsOutput)
        pub fn build(self) -> crate::output::ListSolutionsOutput {
            crate::output::ListSolutionsOutput {
                solutions: self.solutions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSolutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListSolutionsOutput`](crate::output::ListSolutionsOutput)
    pub fn builder() -> crate::output::list_solutions_output::Builder {
        crate::output::list_solutions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasOutput {
    /// <p>A list of schemas.</p>
    pub schemas: std::option::Option<std::vec::Vec<crate::model::DatasetSchemaSummary>>,
    /// <p>A token used to get the next set of schemas (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSchemasOutput {
    /// <p>A list of schemas.</p>
    pub fn schemas(&self) -> std::option::Option<&[crate::model::DatasetSchemaSummary]> {
        self.schemas.as_deref()
    }
    /// <p>A token used to get the next set of schemas (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSchemasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasOutput");
        formatter.field("schemas", &self.schemas);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSchemasOutput`](crate::output::ListSchemasOutput)
pub mod list_schemas_output {
    /// A builder for [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schemas: std::option::Option<std::vec::Vec<crate::model::DatasetSchemaSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>A list of schemas.</p>
        pub fn schemas(mut self, input: crate::model::DatasetSchemaSummary) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input);
            self.schemas = Some(v);
            self
        }
        /// <p>A list of schemas.</p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetSchemaSummary>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// <p>A token used to get the next set of schemas (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used to get the next set of schemas (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasOutput`](crate::output::ListSchemasOutput)
        pub fn build(self) -> crate::output::ListSchemasOutput {
            crate::output::ListSchemasOutput {
                schemas: self.schemas,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSchemasOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    pub fn builder() -> crate::output::list_schemas_output::Builder {
        crate::output::list_schemas_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendersOutput {
    /// <p>A list of the recommenders.</p>
    pub recommenders: std::option::Option<std::vec::Vec<crate::model::RecommenderSummary>>,
    /// <p>A token for getting the next set of recommenders (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRecommendersOutput {
    /// <p>A list of the recommenders.</p>
    pub fn recommenders(&self) -> std::option::Option<&[crate::model::RecommenderSummary]> {
        self.recommenders.as_deref()
    }
    /// <p>A token for getting the next set of recommenders (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecommendersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendersOutput");
        formatter.field("recommenders", &self.recommenders);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRecommendersOutput`](crate::output::ListRecommendersOutput)
pub mod list_recommenders_output {
    /// A builder for [`ListRecommendersOutput`](crate::output::ListRecommendersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommenders:
            std::option::Option<std::vec::Vec<crate::model::RecommenderSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `recommenders`.
        ///
        /// To override the contents of this collection use [`set_recommenders`](Self::set_recommenders).
        ///
        /// <p>A list of the recommenders.</p>
        pub fn recommenders(mut self, input: crate::model::RecommenderSummary) -> Self {
            let mut v = self.recommenders.unwrap_or_default();
            v.push(input);
            self.recommenders = Some(v);
            self
        }
        /// <p>A list of the recommenders.</p>
        pub fn set_recommenders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommenderSummary>>,
        ) -> Self {
            self.recommenders = input;
            self
        }
        /// <p>A token for getting the next set of recommenders (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of recommenders (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendersOutput`](crate::output::ListRecommendersOutput)
        pub fn build(self) -> crate::output::ListRecommendersOutput {
            crate::output::ListRecommendersOutput {
                recommenders: self.recommenders,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRecommendersOutput {
    /// Creates a new builder-style object to manufacture [`ListRecommendersOutput`](crate::output::ListRecommendersOutput)
    pub fn builder() -> crate::output::list_recommenders_output::Builder {
        crate::output::list_recommenders_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecipesOutput {
    /// <p>The list of available recipes.</p>
    pub recipes: std::option::Option<std::vec::Vec<crate::model::RecipeSummary>>,
    /// <p>A token for getting the next set of recipes.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRecipesOutput {
    /// <p>The list of available recipes.</p>
    pub fn recipes(&self) -> std::option::Option<&[crate::model::RecipeSummary]> {
        self.recipes.as_deref()
    }
    /// <p>A token for getting the next set of recipes.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecipesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecipesOutput");
        formatter.field("recipes", &self.recipes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRecipesOutput`](crate::output::ListRecipesOutput)
pub mod list_recipes_output {
    /// A builder for [`ListRecipesOutput`](crate::output::ListRecipesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipes: std::option::Option<std::vec::Vec<crate::model::RecipeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `recipes`.
        ///
        /// To override the contents of this collection use [`set_recipes`](Self::set_recipes).
        ///
        /// <p>The list of available recipes.</p>
        pub fn recipes(mut self, input: crate::model::RecipeSummary) -> Self {
            let mut v = self.recipes.unwrap_or_default();
            v.push(input);
            self.recipes = Some(v);
            self
        }
        /// <p>The list of available recipes.</p>
        pub fn set_recipes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeSummary>>,
        ) -> Self {
            self.recipes = input;
            self
        }
        /// <p>A token for getting the next set of recipes.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of recipes.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecipesOutput`](crate::output::ListRecipesOutput)
        pub fn build(self) -> crate::output::ListRecipesOutput {
            crate::output::ListRecipesOutput {
                recipes: self.recipes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRecipesOutput {
    /// Creates a new builder-style object to manufacture [`ListRecipesOutput`](crate::output::ListRecipesOutput)
    pub fn builder() -> crate::output::list_recipes_output::Builder {
        crate::output::list_recipes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFiltersOutput {
    /// <p>A list of returned filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::FilterSummary>>,
    /// <p>A token for getting the next set of filters (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFiltersOutput {
    /// <p>A list of returned filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::FilterSummary]> {
        self.filters.as_deref()
    }
    /// <p>A token for getting the next set of filters (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFiltersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFiltersOutput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFiltersOutput`](crate::output::ListFiltersOutput)
pub mod list_filters_output {
    /// A builder for [`ListFiltersOutput`](crate::output::ListFiltersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::FilterSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of returned filters.</p>
        pub fn filters(mut self, input: crate::model::FilterSummary) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A list of returned filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterSummary>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>A token for getting the next set of filters (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of filters (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFiltersOutput`](crate::output::ListFiltersOutput)
        pub fn build(self) -> crate::output::ListFiltersOutput {
            crate::output::ListFiltersOutput {
                filters: self.filters,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFiltersOutput {
    /// Creates a new builder-style object to manufacture [`ListFiltersOutput`](crate::output::ListFiltersOutput)
    pub fn builder() -> crate::output::list_filters_output::Builder {
        crate::output::list_filters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventTrackersOutput {
    /// <p>A list of event trackers.</p>
    pub event_trackers: std::option::Option<std::vec::Vec<crate::model::EventTrackerSummary>>,
    /// <p>A token for getting the next set of event trackers (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventTrackersOutput {
    /// <p>A list of event trackers.</p>
    pub fn event_trackers(&self) -> std::option::Option<&[crate::model::EventTrackerSummary]> {
        self.event_trackers.as_deref()
    }
    /// <p>A token for getting the next set of event trackers (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventTrackersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventTrackersOutput");
        formatter.field("event_trackers", &self.event_trackers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEventTrackersOutput`](crate::output::ListEventTrackersOutput)
pub mod list_event_trackers_output {
    /// A builder for [`ListEventTrackersOutput`](crate::output::ListEventTrackersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_trackers:
            std::option::Option<std::vec::Vec<crate::model::EventTrackerSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_trackers`.
        ///
        /// To override the contents of this collection use [`set_event_trackers`](Self::set_event_trackers).
        ///
        /// <p>A list of event trackers.</p>
        pub fn event_trackers(mut self, input: crate::model::EventTrackerSummary) -> Self {
            let mut v = self.event_trackers.unwrap_or_default();
            v.push(input);
            self.event_trackers = Some(v);
            self
        }
        /// <p>A list of event trackers.</p>
        pub fn set_event_trackers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTrackerSummary>>,
        ) -> Self {
            self.event_trackers = input;
            self
        }
        /// <p>A token for getting the next set of event trackers (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of event trackers (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventTrackersOutput`](crate::output::ListEventTrackersOutput)
        pub fn build(self) -> crate::output::ListEventTrackersOutput {
            crate::output::ListEventTrackersOutput {
                event_trackers: self.event_trackers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEventTrackersOutput {
    /// Creates a new builder-style object to manufacture [`ListEventTrackersOutput`](crate::output::ListEventTrackersOutput)
    pub fn builder() -> crate::output::list_event_trackers_output::Builder {
        crate::output::list_event_trackers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsOutput {
    /// <p>An array of <code>Dataset</code> objects. Each object provides metadata information.</p>
    pub datasets: std::option::Option<std::vec::Vec<crate::model::DatasetSummary>>,
    /// <p>A token for getting the next set of datasets (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetsOutput {
    /// <p>An array of <code>Dataset</code> objects. Each object provides metadata information.</p>
    pub fn datasets(&self) -> std::option::Option<&[crate::model::DatasetSummary]> {
        self.datasets.as_deref()
    }
    /// <p>A token for getting the next set of datasets (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsOutput");
        formatter.field("datasets", &self.datasets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
pub mod list_datasets_output {
    /// A builder for [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datasets: std::option::Option<std::vec::Vec<crate::model::DatasetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p>An array of <code>Dataset</code> objects. Each object provides metadata information.</p>
        pub fn datasets(mut self, input: crate::model::DatasetSummary) -> Self {
            let mut v = self.datasets.unwrap_or_default();
            v.push(input);
            self.datasets = Some(v);
            self
        }
        /// <p>An array of <code>Dataset</code> objects. Each object provides metadata information.</p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetSummary>>,
        ) -> Self {
            self.datasets = input;
            self
        }
        /// <p>A token for getting the next set of datasets (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of datasets (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
        pub fn build(self) -> crate::output::ListDatasetsOutput {
            crate::output::ListDatasetsOutput {
                datasets: self.datasets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    pub fn builder() -> crate::output::list_datasets_output::Builder {
        crate::output::list_datasets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetImportJobsOutput {
    /// <p>The list of dataset import jobs.</p>
    pub dataset_import_jobs:
        std::option::Option<std::vec::Vec<crate::model::DatasetImportJobSummary>>,
    /// <p>A token for getting the next set of dataset import jobs (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetImportJobsOutput {
    /// <p>The list of dataset import jobs.</p>
    pub fn dataset_import_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::DatasetImportJobSummary]> {
        self.dataset_import_jobs.as_deref()
    }
    /// <p>A token for getting the next set of dataset import jobs (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetImportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetImportJobsOutput");
        formatter.field("dataset_import_jobs", &self.dataset_import_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
pub mod list_dataset_import_jobs_output {
    /// A builder for [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_jobs:
            std::option::Option<std::vec::Vec<crate::model::DatasetImportJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dataset_import_jobs`.
        ///
        /// To override the contents of this collection use [`set_dataset_import_jobs`](Self::set_dataset_import_jobs).
        ///
        /// <p>The list of dataset import jobs.</p>
        pub fn dataset_import_jobs(mut self, input: crate::model::DatasetImportJobSummary) -> Self {
            let mut v = self.dataset_import_jobs.unwrap_or_default();
            v.push(input);
            self.dataset_import_jobs = Some(v);
            self
        }
        /// <p>The list of dataset import jobs.</p>
        pub fn set_dataset_import_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetImportJobSummary>>,
        ) -> Self {
            self.dataset_import_jobs = input;
            self
        }
        /// <p>A token for getting the next set of dataset import jobs (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of dataset import jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
        pub fn build(self) -> crate::output::ListDatasetImportJobsOutput {
            crate::output::ListDatasetImportJobsOutput {
                dataset_import_jobs: self.dataset_import_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetImportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetImportJobsOutput`](crate::output::ListDatasetImportJobsOutput)
    pub fn builder() -> crate::output::list_dataset_import_jobs_output::Builder {
        crate::output::list_dataset_import_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetGroupsOutput {
    /// <p>The list of your dataset groups.</p>
    pub dataset_groups: std::option::Option<std::vec::Vec<crate::model::DatasetGroupSummary>>,
    /// <p>A token for getting the next set of dataset groups (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetGroupsOutput {
    /// <p>The list of your dataset groups.</p>
    pub fn dataset_groups(&self) -> std::option::Option<&[crate::model::DatasetGroupSummary]> {
        self.dataset_groups.as_deref()
    }
    /// <p>A token for getting the next set of dataset groups (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetGroupsOutput");
        formatter.field("dataset_groups", &self.dataset_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
pub mod list_dataset_groups_output {
    /// A builder for [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_groups:
            std::option::Option<std::vec::Vec<crate::model::DatasetGroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dataset_groups`.
        ///
        /// To override the contents of this collection use [`set_dataset_groups`](Self::set_dataset_groups).
        ///
        /// <p>The list of your dataset groups.</p>
        pub fn dataset_groups(mut self, input: crate::model::DatasetGroupSummary) -> Self {
            let mut v = self.dataset_groups.unwrap_or_default();
            v.push(input);
            self.dataset_groups = Some(v);
            self
        }
        /// <p>The list of your dataset groups.</p>
        pub fn set_dataset_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetGroupSummary>>,
        ) -> Self {
            self.dataset_groups = input;
            self
        }
        /// <p>A token for getting the next set of dataset groups (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of dataset groups (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
        pub fn build(self) -> crate::output::ListDatasetGroupsOutput {
            crate::output::ListDatasetGroupsOutput {
                dataset_groups: self.dataset_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetGroupsOutput`](crate::output::ListDatasetGroupsOutput)
    pub fn builder() -> crate::output::list_dataset_groups_output::Builder {
        crate::output::list_dataset_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetExportJobsOutput {
    /// <p>The list of dataset export jobs.</p>
    pub dataset_export_jobs:
        std::option::Option<std::vec::Vec<crate::model::DatasetExportJobSummary>>,
    /// <p>A token for getting the next set of dataset export jobs (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetExportJobsOutput {
    /// <p>The list of dataset export jobs.</p>
    pub fn dataset_export_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::DatasetExportJobSummary]> {
        self.dataset_export_jobs.as_deref()
    }
    /// <p>A token for getting the next set of dataset export jobs (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetExportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetExportJobsOutput");
        formatter.field("dataset_export_jobs", &self.dataset_export_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetExportJobsOutput`](crate::output::ListDatasetExportJobsOutput)
pub mod list_dataset_export_jobs_output {
    /// A builder for [`ListDatasetExportJobsOutput`](crate::output::ListDatasetExportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_export_jobs:
            std::option::Option<std::vec::Vec<crate::model::DatasetExportJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dataset_export_jobs`.
        ///
        /// To override the contents of this collection use [`set_dataset_export_jobs`](Self::set_dataset_export_jobs).
        ///
        /// <p>The list of dataset export jobs.</p>
        pub fn dataset_export_jobs(mut self, input: crate::model::DatasetExportJobSummary) -> Self {
            let mut v = self.dataset_export_jobs.unwrap_or_default();
            v.push(input);
            self.dataset_export_jobs = Some(v);
            self
        }
        /// <p>The list of dataset export jobs.</p>
        pub fn set_dataset_export_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetExportJobSummary>>,
        ) -> Self {
            self.dataset_export_jobs = input;
            self
        }
        /// <p>A token for getting the next set of dataset export jobs (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of dataset export jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetExportJobsOutput`](crate::output::ListDatasetExportJobsOutput)
        pub fn build(self) -> crate::output::ListDatasetExportJobsOutput {
            crate::output::ListDatasetExportJobsOutput {
                dataset_export_jobs: self.dataset_export_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetExportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetExportJobsOutput`](crate::output::ListDatasetExportJobsOutput)
    pub fn builder() -> crate::output::list_dataset_export_jobs_output::Builder {
        crate::output::list_dataset_export_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCampaignsOutput {
    /// <p>A list of the campaigns.</p>
    pub campaigns: std::option::Option<std::vec::Vec<crate::model::CampaignSummary>>,
    /// <p>A token for getting the next set of campaigns (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCampaignsOutput {
    /// <p>A list of the campaigns.</p>
    pub fn campaigns(&self) -> std::option::Option<&[crate::model::CampaignSummary]> {
        self.campaigns.as_deref()
    }
    /// <p>A token for getting the next set of campaigns (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCampaignsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCampaignsOutput");
        formatter.field("campaigns", &self.campaigns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCampaignsOutput`](crate::output::ListCampaignsOutput)
pub mod list_campaigns_output {
    /// A builder for [`ListCampaignsOutput`](crate::output::ListCampaignsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaigns: std::option::Option<std::vec::Vec<crate::model::CampaignSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `campaigns`.
        ///
        /// To override the contents of this collection use [`set_campaigns`](Self::set_campaigns).
        ///
        /// <p>A list of the campaigns.</p>
        pub fn campaigns(mut self, input: crate::model::CampaignSummary) -> Self {
            let mut v = self.campaigns.unwrap_or_default();
            v.push(input);
            self.campaigns = Some(v);
            self
        }
        /// <p>A list of the campaigns.</p>
        pub fn set_campaigns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CampaignSummary>>,
        ) -> Self {
            self.campaigns = input;
            self
        }
        /// <p>A token for getting the next set of campaigns (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of campaigns (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCampaignsOutput`](crate::output::ListCampaignsOutput)
        pub fn build(self) -> crate::output::ListCampaignsOutput {
            crate::output::ListCampaignsOutput {
                campaigns: self.campaigns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCampaignsOutput {
    /// Creates a new builder-style object to manufacture [`ListCampaignsOutput`](crate::output::ListCampaignsOutput)
    pub fn builder() -> crate::output::list_campaigns_output::Builder {
        crate::output::list_campaigns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBatchSegmentJobsOutput {
    /// <p>A list containing information on each job that is returned.</p>
    pub batch_segment_jobs:
        std::option::Option<std::vec::Vec<crate::model::BatchSegmentJobSummary>>,
    /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBatchSegmentJobsOutput {
    /// <p>A list containing information on each job that is returned.</p>
    pub fn batch_segment_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::BatchSegmentJobSummary]> {
        self.batch_segment_jobs.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBatchSegmentJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBatchSegmentJobsOutput");
        formatter.field("batch_segment_jobs", &self.batch_segment_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBatchSegmentJobsOutput`](crate::output::ListBatchSegmentJobsOutput)
pub mod list_batch_segment_jobs_output {
    /// A builder for [`ListBatchSegmentJobsOutput`](crate::output::ListBatchSegmentJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_segment_jobs:
            std::option::Option<std::vec::Vec<crate::model::BatchSegmentJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `batch_segment_jobs`.
        ///
        /// To override the contents of this collection use [`set_batch_segment_jobs`](Self::set_batch_segment_jobs).
        ///
        /// <p>A list containing information on each job that is returned.</p>
        pub fn batch_segment_jobs(mut self, input: crate::model::BatchSegmentJobSummary) -> Self {
            let mut v = self.batch_segment_jobs.unwrap_or_default();
            v.push(input);
            self.batch_segment_jobs = Some(v);
            self
        }
        /// <p>A list containing information on each job that is returned.</p>
        pub fn set_batch_segment_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchSegmentJobSummary>>,
        ) -> Self {
            self.batch_segment_jobs = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBatchSegmentJobsOutput`](crate::output::ListBatchSegmentJobsOutput)
        pub fn build(self) -> crate::output::ListBatchSegmentJobsOutput {
            crate::output::ListBatchSegmentJobsOutput {
                batch_segment_jobs: self.batch_segment_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBatchSegmentJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListBatchSegmentJobsOutput`](crate::output::ListBatchSegmentJobsOutput)
    pub fn builder() -> crate::output::list_batch_segment_jobs_output::Builder {
        crate::output::list_batch_segment_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBatchInferenceJobsOutput {
    /// <p>A list containing information on each job that is returned.</p>
    pub batch_inference_jobs:
        std::option::Option<std::vec::Vec<crate::model::BatchInferenceJobSummary>>,
    /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBatchInferenceJobsOutput {
    /// <p>A list containing information on each job that is returned.</p>
    pub fn batch_inference_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::BatchInferenceJobSummary]> {
        self.batch_inference_jobs.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBatchInferenceJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBatchInferenceJobsOutput");
        formatter.field("batch_inference_jobs", &self.batch_inference_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBatchInferenceJobsOutput`](crate::output::ListBatchInferenceJobsOutput)
pub mod list_batch_inference_jobs_output {
    /// A builder for [`ListBatchInferenceJobsOutput`](crate::output::ListBatchInferenceJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_inference_jobs:
            std::option::Option<std::vec::Vec<crate::model::BatchInferenceJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `batch_inference_jobs`.
        ///
        /// To override the contents of this collection use [`set_batch_inference_jobs`](Self::set_batch_inference_jobs).
        ///
        /// <p>A list containing information on each job that is returned.</p>
        pub fn batch_inference_jobs(
            mut self,
            input: crate::model::BatchInferenceJobSummary,
        ) -> Self {
            let mut v = self.batch_inference_jobs.unwrap_or_default();
            v.push(input);
            self.batch_inference_jobs = Some(v);
            self
        }
        /// <p>A list containing information on each job that is returned.</p>
        pub fn set_batch_inference_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchInferenceJobSummary>>,
        ) -> Self {
            self.batch_inference_jobs = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBatchInferenceJobsOutput`](crate::output::ListBatchInferenceJobsOutput)
        pub fn build(self) -> crate::output::ListBatchInferenceJobsOutput {
            crate::output::ListBatchInferenceJobsOutput {
                batch_inference_jobs: self.batch_inference_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBatchInferenceJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListBatchInferenceJobsOutput`](crate::output::ListBatchInferenceJobsOutput)
    pub fn builder() -> crate::output::list_batch_inference_jobs_output::Builder {
        crate::output::list_batch_inference_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSolutionMetricsOutput {
    /// <p>The same solution version ARN as specified in the request.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The metrics for the solution version.</p>
    pub metrics: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
}
impl GetSolutionMetricsOutput {
    /// <p>The same solution version ARN as specified in the request.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The metrics for the solution version.</p>
    pub fn metrics(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.metrics.as_ref()
    }
}
impl std::fmt::Debug for GetSolutionMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSolutionMetricsOutput");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}
/// See [`GetSolutionMetricsOutput`](crate::output::GetSolutionMetricsOutput)
pub mod get_solution_metrics_output {
    /// A builder for [`GetSolutionMetricsOutput`](crate::output::GetSolutionMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) metrics:
            std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    }
    impl Builder {
        /// <p>The same solution version ARN as specified in the request.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The same solution version ARN as specified in the request.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Adds a key-value pair to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The metrics for the solution version.</p>
        pub fn metrics(mut self, k: impl Into<std::string::String>, v: f64) -> Self {
            let mut hash_map = self.metrics.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.metrics = Some(hash_map);
            self
        }
        /// <p>The metrics for the solution version.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSolutionMetricsOutput`](crate::output::GetSolutionMetricsOutput)
        pub fn build(self) -> crate::output::GetSolutionMetricsOutput {
            crate::output::GetSolutionMetricsOutput {
                solution_version_arn: self.solution_version_arn,
                metrics: self.metrics,
            }
        }
    }
}
impl GetSolutionMetricsOutput {
    /// Creates a new builder-style object to manufacture [`GetSolutionMetricsOutput`](crate::output::GetSolutionMetricsOutput)
    pub fn builder() -> crate::output::get_solution_metrics_output::Builder {
        crate::output::get_solution_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSolutionVersionOutput {
    /// <p>The solution version.</p>
    pub solution_version: std::option::Option<crate::model::SolutionVersion>,
}
impl DescribeSolutionVersionOutput {
    /// <p>The solution version.</p>
    pub fn solution_version(&self) -> std::option::Option<&crate::model::SolutionVersion> {
        self.solution_version.as_ref()
    }
}
impl std::fmt::Debug for DescribeSolutionVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSolutionVersionOutput");
        formatter.field("solution_version", &self.solution_version);
        formatter.finish()
    }
}
/// See [`DescribeSolutionVersionOutput`](crate::output::DescribeSolutionVersionOutput)
pub mod describe_solution_version_output {
    /// A builder for [`DescribeSolutionVersionOutput`](crate::output::DescribeSolutionVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version: std::option::Option<crate::model::SolutionVersion>,
    }
    impl Builder {
        /// <p>The solution version.</p>
        pub fn solution_version(mut self, input: crate::model::SolutionVersion) -> Self {
            self.solution_version = Some(input);
            self
        }
        /// <p>The solution version.</p>
        pub fn set_solution_version(
            mut self,
            input: std::option::Option<crate::model::SolutionVersion>,
        ) -> Self {
            self.solution_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSolutionVersionOutput`](crate::output::DescribeSolutionVersionOutput)
        pub fn build(self) -> crate::output::DescribeSolutionVersionOutput {
            crate::output::DescribeSolutionVersionOutput {
                solution_version: self.solution_version,
            }
        }
    }
}
impl DescribeSolutionVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSolutionVersionOutput`](crate::output::DescribeSolutionVersionOutput)
    pub fn builder() -> crate::output::describe_solution_version_output::Builder {
        crate::output::describe_solution_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSolutionOutput {
    /// <p>An object that describes the solution.</p>
    pub solution: std::option::Option<crate::model::Solution>,
}
impl DescribeSolutionOutput {
    /// <p>An object that describes the solution.</p>
    pub fn solution(&self) -> std::option::Option<&crate::model::Solution> {
        self.solution.as_ref()
    }
}
impl std::fmt::Debug for DescribeSolutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSolutionOutput");
        formatter.field("solution", &self.solution);
        formatter.finish()
    }
}
/// See [`DescribeSolutionOutput`](crate::output::DescribeSolutionOutput)
pub mod describe_solution_output {
    /// A builder for [`DescribeSolutionOutput`](crate::output::DescribeSolutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution: std::option::Option<crate::model::Solution>,
    }
    impl Builder {
        /// <p>An object that describes the solution.</p>
        pub fn solution(mut self, input: crate::model::Solution) -> Self {
            self.solution = Some(input);
            self
        }
        /// <p>An object that describes the solution.</p>
        pub fn set_solution(mut self, input: std::option::Option<crate::model::Solution>) -> Self {
            self.solution = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSolutionOutput`](crate::output::DescribeSolutionOutput)
        pub fn build(self) -> crate::output::DescribeSolutionOutput {
            crate::output::DescribeSolutionOutput {
                solution: self.solution,
            }
        }
    }
}
impl DescribeSolutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSolutionOutput`](crate::output::DescribeSolutionOutput)
    pub fn builder() -> crate::output::describe_solution_output::Builder {
        crate::output::describe_solution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSchemaOutput {
    /// <p>The requested schema.</p>
    pub schema: std::option::Option<crate::model::DatasetSchema>,
}
impl DescribeSchemaOutput {
    /// <p>The requested schema.</p>
    pub fn schema(&self) -> std::option::Option<&crate::model::DatasetSchema> {
        self.schema.as_ref()
    }
}
impl std::fmt::Debug for DescribeSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSchemaOutput");
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
pub mod describe_schema_output {
    /// A builder for [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema: std::option::Option<crate::model::DatasetSchema>,
    }
    impl Builder {
        /// <p>The requested schema.</p>
        pub fn schema(mut self, input: crate::model::DatasetSchema) -> Self {
            self.schema = Some(input);
            self
        }
        /// <p>The requested schema.</p>
        pub fn set_schema(
            mut self,
            input: std::option::Option<crate::model::DatasetSchema>,
        ) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
        pub fn build(self) -> crate::output::DescribeSchemaOutput {
            crate::output::DescribeSchemaOutput {
                schema: self.schema,
            }
        }
    }
}
impl DescribeSchemaOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
    pub fn builder() -> crate::output::describe_schema_output::Builder {
        crate::output::describe_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecommenderOutput {
    /// <p>The properties of the recommender.</p>
    pub recommender: std::option::Option<crate::model::Recommender>,
}
impl DescribeRecommenderOutput {
    /// <p>The properties of the recommender.</p>
    pub fn recommender(&self) -> std::option::Option<&crate::model::Recommender> {
        self.recommender.as_ref()
    }
}
impl std::fmt::Debug for DescribeRecommenderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecommenderOutput");
        formatter.field("recommender", &self.recommender);
        formatter.finish()
    }
}
/// See [`DescribeRecommenderOutput`](crate::output::DescribeRecommenderOutput)
pub mod describe_recommender_output {
    /// A builder for [`DescribeRecommenderOutput`](crate::output::DescribeRecommenderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender: std::option::Option<crate::model::Recommender>,
    }
    impl Builder {
        /// <p>The properties of the recommender.</p>
        pub fn recommender(mut self, input: crate::model::Recommender) -> Self {
            self.recommender = Some(input);
            self
        }
        /// <p>The properties of the recommender.</p>
        pub fn set_recommender(
            mut self,
            input: std::option::Option<crate::model::Recommender>,
        ) -> Self {
            self.recommender = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecommenderOutput`](crate::output::DescribeRecommenderOutput)
        pub fn build(self) -> crate::output::DescribeRecommenderOutput {
            crate::output::DescribeRecommenderOutput {
                recommender: self.recommender,
            }
        }
    }
}
impl DescribeRecommenderOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecommenderOutput`](crate::output::DescribeRecommenderOutput)
    pub fn builder() -> crate::output::describe_recommender_output::Builder {
        crate::output::describe_recommender_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecipeOutput {
    /// <p>An object that describes the recipe.</p>
    pub recipe: std::option::Option<crate::model::Recipe>,
}
impl DescribeRecipeOutput {
    /// <p>An object that describes the recipe.</p>
    pub fn recipe(&self) -> std::option::Option<&crate::model::Recipe> {
        self.recipe.as_ref()
    }
}
impl std::fmt::Debug for DescribeRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecipeOutput");
        formatter.field("recipe", &self.recipe);
        formatter.finish()
    }
}
/// See [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
pub mod describe_recipe_output {
    /// A builder for [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipe: std::option::Option<crate::model::Recipe>,
    }
    impl Builder {
        /// <p>An object that describes the recipe.</p>
        pub fn recipe(mut self, input: crate::model::Recipe) -> Self {
            self.recipe = Some(input);
            self
        }
        /// <p>An object that describes the recipe.</p>
        pub fn set_recipe(mut self, input: std::option::Option<crate::model::Recipe>) -> Self {
            self.recipe = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
        pub fn build(self) -> crate::output::DescribeRecipeOutput {
            crate::output::DescribeRecipeOutput {
                recipe: self.recipe,
            }
        }
    }
}
impl DescribeRecipeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
    pub fn builder() -> crate::output::describe_recipe_output::Builder {
        crate::output::describe_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFilterOutput {
    /// <p>The filter's details.</p>
    pub filter: std::option::Option<crate::model::Filter>,
}
impl DescribeFilterOutput {
    /// <p>The filter's details.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Filter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for DescribeFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFilterOutput");
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`DescribeFilterOutput`](crate::output::DescribeFilterOutput)
pub mod describe_filter_output {
    /// A builder for [`DescribeFilterOutput`](crate::output::DescribeFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::Filter>,
    }
    impl Builder {
        /// <p>The filter's details.</p>
        pub fn filter(mut self, input: crate::model::Filter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filter's details.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Filter>) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFilterOutput`](crate::output::DescribeFilterOutput)
        pub fn build(self) -> crate::output::DescribeFilterOutput {
            crate::output::DescribeFilterOutput {
                filter: self.filter,
            }
        }
    }
}
impl DescribeFilterOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFilterOutput`](crate::output::DescribeFilterOutput)
    pub fn builder() -> crate::output::describe_filter_output::Builder {
        crate::output::describe_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFeatureTransformationOutput {
    /// <p>A listing of the FeatureTransformation properties.</p>
    pub feature_transformation: std::option::Option<crate::model::FeatureTransformation>,
}
impl DescribeFeatureTransformationOutput {
    /// <p>A listing of the FeatureTransformation properties.</p>
    pub fn feature_transformation(
        &self,
    ) -> std::option::Option<&crate::model::FeatureTransformation> {
        self.feature_transformation.as_ref()
    }
}
impl std::fmt::Debug for DescribeFeatureTransformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFeatureTransformationOutput");
        formatter.field("feature_transformation", &self.feature_transformation);
        formatter.finish()
    }
}
/// See [`DescribeFeatureTransformationOutput`](crate::output::DescribeFeatureTransformationOutput)
pub mod describe_feature_transformation_output {
    /// A builder for [`DescribeFeatureTransformationOutput`](crate::output::DescribeFeatureTransformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_transformation: std::option::Option<crate::model::FeatureTransformation>,
    }
    impl Builder {
        /// <p>A listing of the FeatureTransformation properties.</p>
        pub fn feature_transformation(
            mut self,
            input: crate::model::FeatureTransformation,
        ) -> Self {
            self.feature_transformation = Some(input);
            self
        }
        /// <p>A listing of the FeatureTransformation properties.</p>
        pub fn set_feature_transformation(
            mut self,
            input: std::option::Option<crate::model::FeatureTransformation>,
        ) -> Self {
            self.feature_transformation = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFeatureTransformationOutput`](crate::output::DescribeFeatureTransformationOutput)
        pub fn build(self) -> crate::output::DescribeFeatureTransformationOutput {
            crate::output::DescribeFeatureTransformationOutput {
                feature_transformation: self.feature_transformation,
            }
        }
    }
}
impl DescribeFeatureTransformationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFeatureTransformationOutput`](crate::output::DescribeFeatureTransformationOutput)
    pub fn builder() -> crate::output::describe_feature_transformation_output::Builder {
        crate::output::describe_feature_transformation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventTrackerOutput {
    /// <p>An object that describes the event tracker.</p>
    pub event_tracker: std::option::Option<crate::model::EventTracker>,
}
impl DescribeEventTrackerOutput {
    /// <p>An object that describes the event tracker.</p>
    pub fn event_tracker(&self) -> std::option::Option<&crate::model::EventTracker> {
        self.event_tracker.as_ref()
    }
}
impl std::fmt::Debug for DescribeEventTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventTrackerOutput");
        formatter.field("event_tracker", &self.event_tracker);
        formatter.finish()
    }
}
/// See [`DescribeEventTrackerOutput`](crate::output::DescribeEventTrackerOutput)
pub mod describe_event_tracker_output {
    /// A builder for [`DescribeEventTrackerOutput`](crate::output::DescribeEventTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_tracker: std::option::Option<crate::model::EventTracker>,
    }
    impl Builder {
        /// <p>An object that describes the event tracker.</p>
        pub fn event_tracker(mut self, input: crate::model::EventTracker) -> Self {
            self.event_tracker = Some(input);
            self
        }
        /// <p>An object that describes the event tracker.</p>
        pub fn set_event_tracker(
            mut self,
            input: std::option::Option<crate::model::EventTracker>,
        ) -> Self {
            self.event_tracker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventTrackerOutput`](crate::output::DescribeEventTrackerOutput)
        pub fn build(self) -> crate::output::DescribeEventTrackerOutput {
            crate::output::DescribeEventTrackerOutput {
                event_tracker: self.event_tracker,
            }
        }
    }
}
impl DescribeEventTrackerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventTrackerOutput`](crate::output::DescribeEventTrackerOutput)
    pub fn builder() -> crate::output::describe_event_tracker_output::Builder {
        crate::output::describe_event_tracker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetImportJobOutput {
    /// <p>Information about the dataset import job, including the status.</p>
    /// <p>The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING</p> </li>
    /// <li> <p>CREATE IN_PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub dataset_import_job: std::option::Option<crate::model::DatasetImportJob>,
}
impl DescribeDatasetImportJobOutput {
    /// <p>Information about the dataset import job, including the status.</p>
    /// <p>The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING</p> </li>
    /// <li> <p>CREATE IN_PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub fn dataset_import_job(&self) -> std::option::Option<&crate::model::DatasetImportJob> {
        self.dataset_import_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetImportJobOutput");
        formatter.field("dataset_import_job", &self.dataset_import_job);
        formatter.finish()
    }
}
/// See [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
pub mod describe_dataset_import_job_output {
    /// A builder for [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job: std::option::Option<crate::model::DatasetImportJob>,
    }
    impl Builder {
        /// <p>Information about the dataset import job, including the status.</p>
        /// <p>The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING</p> </li>
        /// <li> <p>CREATE IN_PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn dataset_import_job(mut self, input: crate::model::DatasetImportJob) -> Self {
            self.dataset_import_job = Some(input);
            self
        }
        /// <p>Information about the dataset import job, including the status.</p>
        /// <p>The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING</p> </li>
        /// <li> <p>CREATE IN_PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_dataset_import_job(
            mut self,
            input: std::option::Option<crate::model::DatasetImportJob>,
        ) -> Self {
            self.dataset_import_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
        pub fn build(self) -> crate::output::DescribeDatasetImportJobOutput {
            crate::output::DescribeDatasetImportJobOutput {
                dataset_import_job: self.dataset_import_job,
            }
        }
    }
}
impl DescribeDatasetImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetImportJobOutput`](crate::output::DescribeDatasetImportJobOutput)
    pub fn builder() -> crate::output::describe_dataset_import_job_output::Builder {
        crate::output::describe_dataset_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetGroupOutput {
    /// <p>A listing of the dataset group's properties.</p>
    pub dataset_group: std::option::Option<crate::model::DatasetGroup>,
}
impl DescribeDatasetGroupOutput {
    /// <p>A listing of the dataset group's properties.</p>
    pub fn dataset_group(&self) -> std::option::Option<&crate::model::DatasetGroup> {
        self.dataset_group.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetGroupOutput");
        formatter.field("dataset_group", &self.dataset_group);
        formatter.finish()
    }
}
/// See [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
pub mod describe_dataset_group_output {
    /// A builder for [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group: std::option::Option<crate::model::DatasetGroup>,
    }
    impl Builder {
        /// <p>A listing of the dataset group's properties.</p>
        pub fn dataset_group(mut self, input: crate::model::DatasetGroup) -> Self {
            self.dataset_group = Some(input);
            self
        }
        /// <p>A listing of the dataset group's properties.</p>
        pub fn set_dataset_group(
            mut self,
            input: std::option::Option<crate::model::DatasetGroup>,
        ) -> Self {
            self.dataset_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
        pub fn build(self) -> crate::output::DescribeDatasetGroupOutput {
            crate::output::DescribeDatasetGroupOutput {
                dataset_group: self.dataset_group,
            }
        }
    }
}
impl DescribeDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetGroupOutput`](crate::output::DescribeDatasetGroupOutput)
    pub fn builder() -> crate::output::describe_dataset_group_output::Builder {
        crate::output::describe_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetExportJobOutput {
    /// <p>Information about the dataset export job, including the status.</p>
    /// <p>The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING</p> </li>
    /// <li> <p>CREATE IN_PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub dataset_export_job: std::option::Option<crate::model::DatasetExportJob>,
}
impl DescribeDatasetExportJobOutput {
    /// <p>Information about the dataset export job, including the status.</p>
    /// <p>The status is one of the following values:</p>
    /// <ul>
    /// <li> <p>CREATE PENDING</p> </li>
    /// <li> <p>CREATE IN_PROGRESS</p> </li>
    /// <li> <p>ACTIVE</p> </li>
    /// <li> <p>CREATE FAILED</p> </li>
    /// </ul>
    pub fn dataset_export_job(&self) -> std::option::Option<&crate::model::DatasetExportJob> {
        self.dataset_export_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetExportJobOutput");
        formatter.field("dataset_export_job", &self.dataset_export_job);
        formatter.finish()
    }
}
/// See [`DescribeDatasetExportJobOutput`](crate::output::DescribeDatasetExportJobOutput)
pub mod describe_dataset_export_job_output {
    /// A builder for [`DescribeDatasetExportJobOutput`](crate::output::DescribeDatasetExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_export_job: std::option::Option<crate::model::DatasetExportJob>,
    }
    impl Builder {
        /// <p>Information about the dataset export job, including the status.</p>
        /// <p>The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING</p> </li>
        /// <li> <p>CREATE IN_PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn dataset_export_job(mut self, input: crate::model::DatasetExportJob) -> Self {
            self.dataset_export_job = Some(input);
            self
        }
        /// <p>Information about the dataset export job, including the status.</p>
        /// <p>The status is one of the following values:</p>
        /// <ul>
        /// <li> <p>CREATE PENDING</p> </li>
        /// <li> <p>CREATE IN_PROGRESS</p> </li>
        /// <li> <p>ACTIVE</p> </li>
        /// <li> <p>CREATE FAILED</p> </li>
        /// </ul>
        pub fn set_dataset_export_job(
            mut self,
            input: std::option::Option<crate::model::DatasetExportJob>,
        ) -> Self {
            self.dataset_export_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetExportJobOutput`](crate::output::DescribeDatasetExportJobOutput)
        pub fn build(self) -> crate::output::DescribeDatasetExportJobOutput {
            crate::output::DescribeDatasetExportJobOutput {
                dataset_export_job: self.dataset_export_job,
            }
        }
    }
}
impl DescribeDatasetExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetExportJobOutput`](crate::output::DescribeDatasetExportJobOutput)
    pub fn builder() -> crate::output::describe_dataset_export_job_output::Builder {
        crate::output::describe_dataset_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetOutput {
    /// <p>A listing of the dataset's properties.</p>
    pub dataset: std::option::Option<crate::model::Dataset>,
}
impl DescribeDatasetOutput {
    /// <p>A listing of the dataset's properties.</p>
    pub fn dataset(&self) -> std::option::Option<&crate::model::Dataset> {
        self.dataset.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetOutput");
        formatter.field("dataset", &self.dataset);
        formatter.finish()
    }
}
/// See [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
pub mod describe_dataset_output {
    /// A builder for [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset: std::option::Option<crate::model::Dataset>,
    }
    impl Builder {
        /// <p>A listing of the dataset's properties.</p>
        pub fn dataset(mut self, input: crate::model::Dataset) -> Self {
            self.dataset = Some(input);
            self
        }
        /// <p>A listing of the dataset's properties.</p>
        pub fn set_dataset(mut self, input: std::option::Option<crate::model::Dataset>) -> Self {
            self.dataset = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
        pub fn build(self) -> crate::output::DescribeDatasetOutput {
            crate::output::DescribeDatasetOutput {
                dataset: self.dataset,
            }
        }
    }
}
impl DescribeDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    pub fn builder() -> crate::output::describe_dataset_output::Builder {
        crate::output::describe_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCampaignOutput {
    /// <p>The properties of the campaign.</p>
    pub campaign: std::option::Option<crate::model::Campaign>,
}
impl DescribeCampaignOutput {
    /// <p>The properties of the campaign.</p>
    pub fn campaign(&self) -> std::option::Option<&crate::model::Campaign> {
        self.campaign.as_ref()
    }
}
impl std::fmt::Debug for DescribeCampaignOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCampaignOutput");
        formatter.field("campaign", &self.campaign);
        formatter.finish()
    }
}
/// See [`DescribeCampaignOutput`](crate::output::DescribeCampaignOutput)
pub mod describe_campaign_output {
    /// A builder for [`DescribeCampaignOutput`](crate::output::DescribeCampaignOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign: std::option::Option<crate::model::Campaign>,
    }
    impl Builder {
        /// <p>The properties of the campaign.</p>
        pub fn campaign(mut self, input: crate::model::Campaign) -> Self {
            self.campaign = Some(input);
            self
        }
        /// <p>The properties of the campaign.</p>
        pub fn set_campaign(mut self, input: std::option::Option<crate::model::Campaign>) -> Self {
            self.campaign = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCampaignOutput`](crate::output::DescribeCampaignOutput)
        pub fn build(self) -> crate::output::DescribeCampaignOutput {
            crate::output::DescribeCampaignOutput {
                campaign: self.campaign,
            }
        }
    }
}
impl DescribeCampaignOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCampaignOutput`](crate::output::DescribeCampaignOutput)
    pub fn builder() -> crate::output::describe_campaign_output::Builder {
        crate::output::describe_campaign_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBatchSegmentJobOutput {
    /// <p>Information on the specified batch segment job.</p>
    pub batch_segment_job: std::option::Option<crate::model::BatchSegmentJob>,
}
impl DescribeBatchSegmentJobOutput {
    /// <p>Information on the specified batch segment job.</p>
    pub fn batch_segment_job(&self) -> std::option::Option<&crate::model::BatchSegmentJob> {
        self.batch_segment_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeBatchSegmentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBatchSegmentJobOutput");
        formatter.field("batch_segment_job", &self.batch_segment_job);
        formatter.finish()
    }
}
/// See [`DescribeBatchSegmentJobOutput`](crate::output::DescribeBatchSegmentJobOutput)
pub mod describe_batch_segment_job_output {
    /// A builder for [`DescribeBatchSegmentJobOutput`](crate::output::DescribeBatchSegmentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_segment_job: std::option::Option<crate::model::BatchSegmentJob>,
    }
    impl Builder {
        /// <p>Information on the specified batch segment job.</p>
        pub fn batch_segment_job(mut self, input: crate::model::BatchSegmentJob) -> Self {
            self.batch_segment_job = Some(input);
            self
        }
        /// <p>Information on the specified batch segment job.</p>
        pub fn set_batch_segment_job(
            mut self,
            input: std::option::Option<crate::model::BatchSegmentJob>,
        ) -> Self {
            self.batch_segment_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBatchSegmentJobOutput`](crate::output::DescribeBatchSegmentJobOutput)
        pub fn build(self) -> crate::output::DescribeBatchSegmentJobOutput {
            crate::output::DescribeBatchSegmentJobOutput {
                batch_segment_job: self.batch_segment_job,
            }
        }
    }
}
impl DescribeBatchSegmentJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBatchSegmentJobOutput`](crate::output::DescribeBatchSegmentJobOutput)
    pub fn builder() -> crate::output::describe_batch_segment_job_output::Builder {
        crate::output::describe_batch_segment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBatchInferenceJobOutput {
    /// <p>Information on the specified batch inference job.</p>
    pub batch_inference_job: std::option::Option<crate::model::BatchInferenceJob>,
}
impl DescribeBatchInferenceJobOutput {
    /// <p>Information on the specified batch inference job.</p>
    pub fn batch_inference_job(&self) -> std::option::Option<&crate::model::BatchInferenceJob> {
        self.batch_inference_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeBatchInferenceJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBatchInferenceJobOutput");
        formatter.field("batch_inference_job", &self.batch_inference_job);
        formatter.finish()
    }
}
/// See [`DescribeBatchInferenceJobOutput`](crate::output::DescribeBatchInferenceJobOutput)
pub mod describe_batch_inference_job_output {
    /// A builder for [`DescribeBatchInferenceJobOutput`](crate::output::DescribeBatchInferenceJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_inference_job: std::option::Option<crate::model::BatchInferenceJob>,
    }
    impl Builder {
        /// <p>Information on the specified batch inference job.</p>
        pub fn batch_inference_job(mut self, input: crate::model::BatchInferenceJob) -> Self {
            self.batch_inference_job = Some(input);
            self
        }
        /// <p>Information on the specified batch inference job.</p>
        pub fn set_batch_inference_job(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJob>,
        ) -> Self {
            self.batch_inference_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBatchInferenceJobOutput`](crate::output::DescribeBatchInferenceJobOutput)
        pub fn build(self) -> crate::output::DescribeBatchInferenceJobOutput {
            crate::output::DescribeBatchInferenceJobOutput {
                batch_inference_job: self.batch_inference_job,
            }
        }
    }
}
impl DescribeBatchInferenceJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBatchInferenceJobOutput`](crate::output::DescribeBatchInferenceJobOutput)
    pub fn builder() -> crate::output::describe_batch_inference_job_output::Builder {
        crate::output::describe_batch_inference_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlgorithmOutput {
    /// <p>A listing of the properties of the algorithm.</p>
    pub algorithm: std::option::Option<crate::model::Algorithm>,
}
impl DescribeAlgorithmOutput {
    /// <p>A listing of the properties of the algorithm.</p>
    pub fn algorithm(&self) -> std::option::Option<&crate::model::Algorithm> {
        self.algorithm.as_ref()
    }
}
impl std::fmt::Debug for DescribeAlgorithmOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlgorithmOutput");
        formatter.field("algorithm", &self.algorithm);
        formatter.finish()
    }
}
/// See [`DescribeAlgorithmOutput`](crate::output::DescribeAlgorithmOutput)
pub mod describe_algorithm_output {
    /// A builder for [`DescribeAlgorithmOutput`](crate::output::DescribeAlgorithmOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm: std::option::Option<crate::model::Algorithm>,
    }
    impl Builder {
        /// <p>A listing of the properties of the algorithm.</p>
        pub fn algorithm(mut self, input: crate::model::Algorithm) -> Self {
            self.algorithm = Some(input);
            self
        }
        /// <p>A listing of the properties of the algorithm.</p>
        pub fn set_algorithm(
            mut self,
            input: std::option::Option<crate::model::Algorithm>,
        ) -> Self {
            self.algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlgorithmOutput`](crate::output::DescribeAlgorithmOutput)
        pub fn build(self) -> crate::output::DescribeAlgorithmOutput {
            crate::output::DescribeAlgorithmOutput {
                algorithm: self.algorithm,
            }
        }
    }
}
impl DescribeAlgorithmOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAlgorithmOutput`](crate::output::DescribeAlgorithmOutput)
    pub fn builder() -> crate::output::describe_algorithm_output::Builder {
        crate::output::describe_algorithm_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSolutionOutput {}
impl std::fmt::Debug for DeleteSolutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSolutionOutput");
        formatter.finish()
    }
}
/// See [`DeleteSolutionOutput`](crate::output::DeleteSolutionOutput)
pub mod delete_solution_output {
    /// A builder for [`DeleteSolutionOutput`](crate::output::DeleteSolutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSolutionOutput`](crate::output::DeleteSolutionOutput)
        pub fn build(self) -> crate::output::DeleteSolutionOutput {
            crate::output::DeleteSolutionOutput {}
        }
    }
}
impl DeleteSolutionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSolutionOutput`](crate::output::DeleteSolutionOutput)
    pub fn builder() -> crate::output::delete_solution_output::Builder {
        crate::output::delete_solution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaOutput {}
impl std::fmt::Debug for DeleteSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaOutput");
        formatter.finish()
    }
}
/// See [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
pub mod delete_schema_output {
    /// A builder for [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
        pub fn build(self) -> crate::output::DeleteSchemaOutput {
            crate::output::DeleteSchemaOutput {}
        }
    }
}
impl DeleteSchemaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    pub fn builder() -> crate::output::delete_schema_output::Builder {
        crate::output::delete_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecommenderOutput {}
impl std::fmt::Debug for DeleteRecommenderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecommenderOutput");
        formatter.finish()
    }
}
/// See [`DeleteRecommenderOutput`](crate::output::DeleteRecommenderOutput)
pub mod delete_recommender_output {
    /// A builder for [`DeleteRecommenderOutput`](crate::output::DeleteRecommenderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRecommenderOutput`](crate::output::DeleteRecommenderOutput)
        pub fn build(self) -> crate::output::DeleteRecommenderOutput {
            crate::output::DeleteRecommenderOutput {}
        }
    }
}
impl DeleteRecommenderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecommenderOutput`](crate::output::DeleteRecommenderOutput)
    pub fn builder() -> crate::output::delete_recommender_output::Builder {
        crate::output::delete_recommender_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFilterOutput {}
impl std::fmt::Debug for DeleteFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFilterOutput");
        formatter.finish()
    }
}
/// See [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
pub mod delete_filter_output {
    /// A builder for [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
        pub fn build(self) -> crate::output::DeleteFilterOutput {
            crate::output::DeleteFilterOutput {}
        }
    }
}
impl DeleteFilterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
    pub fn builder() -> crate::output::delete_filter_output::Builder {
        crate::output::delete_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventTrackerOutput {}
impl std::fmt::Debug for DeleteEventTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventTrackerOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventTrackerOutput`](crate::output::DeleteEventTrackerOutput)
pub mod delete_event_tracker_output {
    /// A builder for [`DeleteEventTrackerOutput`](crate::output::DeleteEventTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventTrackerOutput`](crate::output::DeleteEventTrackerOutput)
        pub fn build(self) -> crate::output::DeleteEventTrackerOutput {
            crate::output::DeleteEventTrackerOutput {}
        }
    }
}
impl DeleteEventTrackerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventTrackerOutput`](crate::output::DeleteEventTrackerOutput)
    pub fn builder() -> crate::output::delete_event_tracker_output::Builder {
        crate::output::delete_event_tracker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetGroupOutput {}
impl std::fmt::Debug for DeleteDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
pub mod delete_dataset_group_output {
    /// A builder for [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
        pub fn build(self) -> crate::output::DeleteDatasetGroupOutput {
            crate::output::DeleteDatasetGroupOutput {}
        }
    }
}
impl DeleteDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetGroupOutput`](crate::output::DeleteDatasetGroupOutput)
    pub fn builder() -> crate::output::delete_dataset_group_output::Builder {
        crate::output::delete_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetOutput {}
impl std::fmt::Debug for DeleteDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
pub mod delete_dataset_output {
    /// A builder for [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
        pub fn build(self) -> crate::output::DeleteDatasetOutput {
            crate::output::DeleteDatasetOutput {}
        }
    }
}
impl DeleteDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    pub fn builder() -> crate::output::delete_dataset_output::Builder {
        crate::output::delete_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCampaignOutput {}
impl std::fmt::Debug for DeleteCampaignOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCampaignOutput");
        formatter.finish()
    }
}
/// See [`DeleteCampaignOutput`](crate::output::DeleteCampaignOutput)
pub mod delete_campaign_output {
    /// A builder for [`DeleteCampaignOutput`](crate::output::DeleteCampaignOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCampaignOutput`](crate::output::DeleteCampaignOutput)
        pub fn build(self) -> crate::output::DeleteCampaignOutput {
            crate::output::DeleteCampaignOutput {}
        }
    }
}
impl DeleteCampaignOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCampaignOutput`](crate::output::DeleteCampaignOutput)
    pub fn builder() -> crate::output::delete_campaign_output::Builder {
        crate::output::delete_campaign_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSolutionVersionOutput {
    /// <p>The ARN of the new solution version.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
}
impl CreateSolutionVersionOutput {
    /// <p>The ARN of the new solution version.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateSolutionVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSolutionVersionOutput");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.finish()
    }
}
/// See [`CreateSolutionVersionOutput`](crate::output::CreateSolutionVersionOutput)
pub mod create_solution_version_output {
    /// A builder for [`CreateSolutionVersionOutput`](crate::output::CreateSolutionVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the new solution version.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the new solution version.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSolutionVersionOutput`](crate::output::CreateSolutionVersionOutput)
        pub fn build(self) -> crate::output::CreateSolutionVersionOutput {
            crate::output::CreateSolutionVersionOutput {
                solution_version_arn: self.solution_version_arn,
            }
        }
    }
}
impl CreateSolutionVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateSolutionVersionOutput`](crate::output::CreateSolutionVersionOutput)
    pub fn builder() -> crate::output::create_solution_version_output::Builder {
        crate::output::create_solution_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSolutionOutput {
    /// <p>The ARN of the solution.</p>
    pub solution_arn: std::option::Option<std::string::String>,
}
impl CreateSolutionOutput {
    /// <p>The ARN of the solution.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateSolutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSolutionOutput");
        formatter.field("solution_arn", &self.solution_arn);
        formatter.finish()
    }
}
/// See [`CreateSolutionOutput`](crate::output::CreateSolutionOutput)
pub mod create_solution_output {
    /// A builder for [`CreateSolutionOutput`](crate::output::CreateSolutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the solution.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the solution.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSolutionOutput`](crate::output::CreateSolutionOutput)
        pub fn build(self) -> crate::output::CreateSolutionOutput {
            crate::output::CreateSolutionOutput {
                solution_arn: self.solution_arn,
            }
        }
    }
}
impl CreateSolutionOutput {
    /// Creates a new builder-style object to manufacture [`CreateSolutionOutput`](crate::output::CreateSolutionOutput)
    pub fn builder() -> crate::output::create_solution_output::Builder {
        crate::output::create_solution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaOutput {
    /// <p>The Amazon Resource Name (ARN) of the created schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl CreateSchemaOutput {
    /// <p>The Amazon Resource Name (ARN) of the created schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}
/// See [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
pub mod create_schema_output {
    /// A builder for [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the created schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
        pub fn build(self) -> crate::output::CreateSchemaOutput {
            crate::output::CreateSchemaOutput {
                schema_arn: self.schema_arn,
            }
        }
    }
}
impl CreateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    pub fn builder() -> crate::output::create_schema_output::Builder {
        crate::output::create_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecommenderOutput {
    /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
    pub recommender_arn: std::option::Option<std::string::String>,
}
impl CreateRecommenderOutput {
    /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
    pub fn recommender_arn(&self) -> std::option::Option<&str> {
        self.recommender_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateRecommenderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecommenderOutput");
        formatter.field("recommender_arn", &self.recommender_arn);
        formatter.finish()
    }
}
/// See [`CreateRecommenderOutput`](crate::output::CreateRecommenderOutput)
pub mod create_recommender_output {
    /// A builder for [`CreateRecommenderOutput`](crate::output::CreateRecommenderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommender_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
        pub fn recommender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommender_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommender.</p>
        pub fn set_recommender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommender_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecommenderOutput`](crate::output::CreateRecommenderOutput)
        pub fn build(self) -> crate::output::CreateRecommenderOutput {
            crate::output::CreateRecommenderOutput {
                recommender_arn: self.recommender_arn,
            }
        }
    }
}
impl CreateRecommenderOutput {
    /// Creates a new builder-style object to manufacture [`CreateRecommenderOutput`](crate::output::CreateRecommenderOutput)
    pub fn builder() -> crate::output::create_recommender_output::Builder {
        crate::output::create_recommender_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFilterOutput {
    /// <p>The ARN of the new filter.</p>
    pub filter_arn: std::option::Option<std::string::String>,
}
impl CreateFilterOutput {
    /// <p>The ARN of the new filter.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFilterOutput");
        formatter.field("filter_arn", &self.filter_arn);
        formatter.finish()
    }
}
/// See [`CreateFilterOutput`](crate::output::CreateFilterOutput)
pub mod create_filter_output {
    /// A builder for [`CreateFilterOutput`](crate::output::CreateFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the new filter.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the new filter.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFilterOutput`](crate::output::CreateFilterOutput)
        pub fn build(self) -> crate::output::CreateFilterOutput {
            crate::output::CreateFilterOutput {
                filter_arn: self.filter_arn,
            }
        }
    }
}
impl CreateFilterOutput {
    /// Creates a new builder-style object to manufacture [`CreateFilterOutput`](crate::output::CreateFilterOutput)
    pub fn builder() -> crate::output::create_filter_output::Builder {
        crate::output::create_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventTrackerOutput {
    /// <p>The ARN of the event tracker.</p>
    pub event_tracker_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
    pub tracking_id: std::option::Option<std::string::String>,
}
impl CreateEventTrackerOutput {
    /// <p>The ARN of the event tracker.</p>
    pub fn event_tracker_arn(&self) -> std::option::Option<&str> {
        self.event_tracker_arn.as_deref()
    }
    /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
    pub fn tracking_id(&self) -> std::option::Option<&str> {
        self.tracking_id.as_deref()
    }
}
impl std::fmt::Debug for CreateEventTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventTrackerOutput");
        formatter.field("event_tracker_arn", &self.event_tracker_arn);
        formatter.field("tracking_id", &self.tracking_id);
        formatter.finish()
    }
}
/// See [`CreateEventTrackerOutput`](crate::output::CreateEventTrackerOutput)
pub mod create_event_tracker_output {
    /// A builder for [`CreateEventTrackerOutput`](crate::output::CreateEventTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_tracker_arn: std::option::Option<std::string::String>,
        pub(crate) tracking_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the event tracker.</p>
        pub fn event_tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_tracker_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event tracker.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_tracker_arn = input;
            self
        }
        /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
        pub fn tracking_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_id = Some(input.into());
            self
        }
        /// <p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>
        pub fn set_tracking_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracking_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventTrackerOutput`](crate::output::CreateEventTrackerOutput)
        pub fn build(self) -> crate::output::CreateEventTrackerOutput {
            crate::output::CreateEventTrackerOutput {
                event_tracker_arn: self.event_tracker_arn,
                tracking_id: self.tracking_id,
            }
        }
    }
}
impl CreateEventTrackerOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventTrackerOutput`](crate::output::CreateEventTrackerOutput)
    pub fn builder() -> crate::output::create_event_tracker_output::Builder {
        crate::output::create_event_tracker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetImportJobOutput {
    /// <p>The ARN of the dataset import job.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetImportJobOutput {
    /// <p>The ARN of the dataset import job.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetImportJobOutput");
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.finish()
    }
}
/// See [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
pub mod create_dataset_import_job_output {
    /// A builder for [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dataset import job.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset import job.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
        pub fn build(self) -> crate::output::CreateDatasetImportJobOutput {
            crate::output::CreateDatasetImportJobOutput {
                dataset_import_job_arn: self.dataset_import_job_arn,
            }
        }
    }
}
impl CreateDatasetImportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetImportJobOutput`](crate::output::CreateDatasetImportJobOutput)
    pub fn builder() -> crate::output::create_dataset_import_job_output::Builder {
        crate::output::create_dataset_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the new dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The domain for the new Domain dataset group.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl CreateDatasetGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the new dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The domain for the new Domain dataset group.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for CreateDatasetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetGroupOutput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
pub mod create_dataset_group_output {
    /// A builder for [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the new dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The domain for the new Domain dataset group.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain for the new Domain dataset group.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
        pub fn build(self) -> crate::output::CreateDatasetGroupOutput {
            crate::output::CreateDatasetGroupOutput {
                dataset_group_arn: self.dataset_group_arn,
                domain: self.domain,
            }
        }
    }
}
impl CreateDatasetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetGroupOutput`](crate::output::CreateDatasetGroupOutput)
    pub fn builder() -> crate::output::create_dataset_group_output::Builder {
        crate::output::create_dataset_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
    pub dataset_export_job_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
    pub fn dataset_export_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_export_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetExportJobOutput");
        formatter.field("dataset_export_job_arn", &self.dataset_export_job_arn);
        formatter.finish()
    }
}
/// See [`CreateDatasetExportJobOutput`](crate::output::CreateDatasetExportJobOutput)
pub mod create_dataset_export_job_output {
    /// A builder for [`CreateDatasetExportJobOutput`](crate::output::CreateDatasetExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_export_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
        pub fn dataset_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
        pub fn set_dataset_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_export_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetExportJobOutput`](crate::output::CreateDatasetExportJobOutput)
        pub fn build(self) -> crate::output::CreateDatasetExportJobOutput {
            crate::output::CreateDatasetExportJobOutput {
                dataset_export_job_arn: self.dataset_export_job_arn,
            }
        }
    }
}
impl CreateDatasetExportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetExportJobOutput`](crate::output::CreateDatasetExportJobOutput)
    pub fn builder() -> crate::output::create_dataset_export_job_output::Builder {
        crate::output::create_dataset_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetOutput {
    /// <p>The ARN of the dataset.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetOutput {
    /// <p>The ARN of the dataset.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetOutput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.finish()
    }
}
/// See [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
pub mod create_dataset_output {
    /// A builder for [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dataset.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
        pub fn build(self) -> crate::output::CreateDatasetOutput {
            crate::output::CreateDatasetOutput {
                dataset_arn: self.dataset_arn,
            }
        }
    }
}
impl CreateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    pub fn builder() -> crate::output::create_dataset_output::Builder {
        crate::output::create_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCampaignOutput {
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub campaign_arn: std::option::Option<std::string::String>,
}
impl CreateCampaignOutput {
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateCampaignOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCampaignOutput");
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.finish()
    }
}
/// See [`CreateCampaignOutput`](crate::output::CreateCampaignOutput)
pub mod create_campaign_output {
    /// A builder for [`CreateCampaignOutput`](crate::output::CreateCampaignOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCampaignOutput`](crate::output::CreateCampaignOutput)
        pub fn build(self) -> crate::output::CreateCampaignOutput {
            crate::output::CreateCampaignOutput {
                campaign_arn: self.campaign_arn,
            }
        }
    }
}
impl CreateCampaignOutput {
    /// Creates a new builder-style object to manufacture [`CreateCampaignOutput`](crate::output::CreateCampaignOutput)
    pub fn builder() -> crate::output::create_campaign_output::Builder {
        crate::output::create_campaign_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchSegmentJobOutput {
    /// <p>The ARN of the batch segment job.</p>
    pub batch_segment_job_arn: std::option::Option<std::string::String>,
}
impl CreateBatchSegmentJobOutput {
    /// <p>The ARN of the batch segment job.</p>
    pub fn batch_segment_job_arn(&self) -> std::option::Option<&str> {
        self.batch_segment_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateBatchSegmentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchSegmentJobOutput");
        formatter.field("batch_segment_job_arn", &self.batch_segment_job_arn);
        formatter.finish()
    }
}
/// See [`CreateBatchSegmentJobOutput`](crate::output::CreateBatchSegmentJobOutput)
pub mod create_batch_segment_job_output {
    /// A builder for [`CreateBatchSegmentJobOutput`](crate::output::CreateBatchSegmentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_segment_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the batch segment job.</p>
        pub fn batch_segment_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_segment_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the batch segment job.</p>
        pub fn set_batch_segment_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_segment_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchSegmentJobOutput`](crate::output::CreateBatchSegmentJobOutput)
        pub fn build(self) -> crate::output::CreateBatchSegmentJobOutput {
            crate::output::CreateBatchSegmentJobOutput {
                batch_segment_job_arn: self.batch_segment_job_arn,
            }
        }
    }
}
impl CreateBatchSegmentJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateBatchSegmentJobOutput`](crate::output::CreateBatchSegmentJobOutput)
    pub fn builder() -> crate::output::create_batch_segment_job_output::Builder {
        crate::output::create_batch_segment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchInferenceJobOutput {
    /// <p>The ARN of the batch inference job.</p>
    pub batch_inference_job_arn: std::option::Option<std::string::String>,
}
impl CreateBatchInferenceJobOutput {
    /// <p>The ARN of the batch inference job.</p>
    pub fn batch_inference_job_arn(&self) -> std::option::Option<&str> {
        self.batch_inference_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateBatchInferenceJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchInferenceJobOutput");
        formatter.field("batch_inference_job_arn", &self.batch_inference_job_arn);
        formatter.finish()
    }
}
/// See [`CreateBatchInferenceJobOutput`](crate::output::CreateBatchInferenceJobOutput)
pub mod create_batch_inference_job_output {
    /// A builder for [`CreateBatchInferenceJobOutput`](crate::output::CreateBatchInferenceJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_inference_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the batch inference job.</p>
        pub fn batch_inference_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_inference_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the batch inference job.</p>
        pub fn set_batch_inference_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_inference_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchInferenceJobOutput`](crate::output::CreateBatchInferenceJobOutput)
        pub fn build(self) -> crate::output::CreateBatchInferenceJobOutput {
            crate::output::CreateBatchInferenceJobOutput {
                batch_inference_job_arn: self.batch_inference_job_arn,
            }
        }
    }
}
impl CreateBatchInferenceJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateBatchInferenceJobOutput`](crate::output::CreateBatchInferenceJobOutput)
    pub fn builder() -> crate::output::create_batch_inference_job_output::Builder {
        crate::output::create_batch_inference_job_output::Builder::default()
    }
}
