// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateBatchInferenceJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBatchInferenceJobError {
    /// Kind of error that occurred.
    pub kind: CreateBatchInferenceJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBatchInferenceJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBatchInferenceJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBatchInferenceJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBatchInferenceJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateBatchInferenceJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBatchInferenceJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateBatchInferenceJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateBatchInferenceJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateBatchInferenceJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateBatchInferenceJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBatchInferenceJobError {
    fn code(&self) -> Option<&str> {
        CreateBatchInferenceJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBatchInferenceJobError {
    /// Creates a new `CreateBatchInferenceJobError`.
    pub fn new(kind: CreateBatchInferenceJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBatchInferenceJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBatchInferenceJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBatchInferenceJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBatchInferenceJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBatchInferenceJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchInferenceJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchInferenceJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchInferenceJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchInferenceJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchInferenceJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchInferenceJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchInferenceJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchInferenceJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchInferenceJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchInferenceJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchInferenceJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateBatchInferenceJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBatchInferenceJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateBatchInferenceJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBatchInferenceJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateBatchInferenceJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateBatchInferenceJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateBatchInferenceJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateBatchInferenceJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBatchSegmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBatchSegmentJobError {
    /// Kind of error that occurred.
    pub kind: CreateBatchSegmentJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBatchSegmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBatchSegmentJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBatchSegmentJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBatchSegmentJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateBatchSegmentJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBatchSegmentJobErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBatchSegmentJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateBatchSegmentJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateBatchSegmentJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateBatchSegmentJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBatchSegmentJobError {
    fn code(&self) -> Option<&str> {
        CreateBatchSegmentJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBatchSegmentJobError {
    /// Creates a new `CreateBatchSegmentJobError`.
    pub fn new(kind: CreateBatchSegmentJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBatchSegmentJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBatchSegmentJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBatchSegmentJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBatchSegmentJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBatchSegmentJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchSegmentJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchSegmentJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchSegmentJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchSegmentJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchSegmentJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchSegmentJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchSegmentJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchSegmentJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchSegmentJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchSegmentJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchSegmentJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateBatchSegmentJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBatchSegmentJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateBatchSegmentJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBatchSegmentJobErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateBatchSegmentJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateBatchSegmentJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateBatchSegmentJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateBatchSegmentJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCampaignError {
    /// Kind of error that occurred.
    pub kind: CreateCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCampaignErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCampaignErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCampaignError {
    fn code(&self) -> Option<&str> {
        CreateCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCampaignError {
    /// Creates a new `CreateCampaignError`.
    pub fn new(kind: CreateCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCampaignErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCampaignErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCampaignErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateCampaignErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCampaignErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateCampaignErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCampaignErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateCampaignErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateCampaignErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateCampaignErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetError {
    fn code(&self) -> Option<&str> {
        CreateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetError {
    /// Creates a new `CreateDatasetError`.
    pub fn new(kind: CreateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatasetExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetExportJobError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatasetExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetExportJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetExportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetExportJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetExportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateDatasetExportJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDatasetExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetExportJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateDatasetExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetExportJobError {
    fn code(&self) -> Option<&str> {
        CreateDatasetExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetExportJobError {
    /// Creates a new `CreateDatasetExportJobError`.
    pub fn new(kind: CreateDatasetExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetExportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetExportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetExportJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetExportJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetExportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetExportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetExportJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetExportJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateDatasetExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetExportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetExportJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetExportJobErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetExportJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDatasetExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetExportJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateDatasetExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetGroupErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetGroupError {
    fn code(&self) -> Option<&str> {
        CreateDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetGroupError {
    /// Creates a new `CreateDatasetGroupError`.
    pub fn new(kind: CreateDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetGroupErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetGroupErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetImportJobError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetImportJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetImportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateDatasetImportJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateDatasetImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetImportJobError {
    fn code(&self) -> Option<&str> {
        CreateDatasetImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetImportJobError {
    /// Creates a new `CreateDatasetImportJobError`.
    pub fn new(kind: CreateDatasetImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetImportJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetImportJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateDatasetImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetImportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateDatasetImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventTracker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventTrackerError {
    /// Kind of error that occurred.
    pub kind: CreateEventTrackerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventTracker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventTrackerErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventTrackerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventTrackerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateEventTrackerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateEventTrackerErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateEventTrackerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateEventTrackerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEventTrackerErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateEventTrackerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventTrackerError {
    fn code(&self) -> Option<&str> {
        CreateEventTrackerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventTrackerError {
    /// Creates a new `CreateEventTrackerError`.
    pub fn new(kind: CreateEventTrackerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventTrackerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventTrackerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventTrackerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventTrackerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventTrackerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventTrackerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventTrackerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventTrackerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventTrackerErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventTrackerErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventTrackerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventTrackerErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventTrackerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventTrackerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventTrackerErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventTrackerErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateEventTrackerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventTrackerErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateEventTrackerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateEventTrackerErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateEventTrackerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateEventTrackerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEventTrackerErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateEventTrackerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFilterError {
    /// Kind of error that occurred.
    pub kind: CreateFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFilterErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFilterErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFilterError {
    fn code(&self) -> Option<&str> {
        CreateFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFilterError {
    /// Creates a new `CreateFilterError`.
    pub fn new(kind: CreateFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFilterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFilterErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFilterErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateFilterErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFilterErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFilterErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRecommenderError {
    /// Kind of error that occurred.
    pub kind: CreateRecommenderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRecommenderErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRecommenderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRecommenderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateRecommenderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRecommenderErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRecommenderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRecommenderErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateRecommenderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRecommenderError {
    fn code(&self) -> Option<&str> {
        CreateRecommenderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRecommenderError {
    /// Creates a new `CreateRecommenderError`.
    pub fn new(kind: CreateRecommenderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRecommenderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRecommenderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRecommenderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRecommenderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRecommenderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecommenderErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecommenderErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateRecommenderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRecommenderErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateRecommenderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRecommenderErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateRecommenderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRecommenderErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateRecommenderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSchemaError {
    /// Kind of error that occurred.
    pub kind: CreateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSchemaErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSchemaError {
    fn code(&self) -> Option<&str> {
        CreateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSchemaError {
    /// Creates a new `CreateSchemaError`.
    pub fn new(kind: CreateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateSchemaErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSchemaErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSolution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSolutionError {
    /// Kind of error that occurred.
    pub kind: CreateSolutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSolution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSolutionErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSolutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSolutionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateSolutionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSolutionErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSolutionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateSolutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateSolutionErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateSolutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSolutionError {
    fn code(&self) -> Option<&str> {
        CreateSolutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSolutionError {
    /// Creates a new `CreateSolutionError`.
    pub fn new(kind: CreateSolutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSolutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSolutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSolutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSolutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSolutionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateSolutionErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateSolutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSolutionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateSolutionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSolutionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateSolutionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateSolutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateSolutionErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateSolutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSolutionVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSolutionVersionError {
    /// Kind of error that occurred.
    pub kind: CreateSolutionVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSolutionVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSolutionVersionErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSolutionVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSolutionVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateSolutionVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSolutionVersionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateSolutionVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateSolutionVersionErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateSolutionVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSolutionVersionError {
    fn code(&self) -> Option<&str> {
        CreateSolutionVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSolutionVersionError {
    /// Creates a new `CreateSolutionVersionError`.
    pub fn new(kind: CreateSolutionVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSolutionVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSolutionVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSolutionVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSolutionVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSolutionVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionVersionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionVersionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSolutionVersionErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSolutionVersionErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateSolutionVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSolutionVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateSolutionVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSolutionVersionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateSolutionVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateSolutionVersionErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateSolutionVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCampaignError {
    /// Kind of error that occurred.
    pub kind: DeleteCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCampaignErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCampaignErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCampaignError {
    fn code(&self) -> Option<&str> {
        DeleteCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCampaignError {
    /// Creates a new `DeleteCampaignError`.
    pub fn new(kind: DeleteCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCampaignErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCampaignErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCampaignErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCampaignErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetError {
    /// Creates a new `DeleteDatasetError`.
    pub fn new(kind: DeleteDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetGroupErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDatasetGroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDatasetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetGroupError {
    /// Creates a new `DeleteDatasetGroupError`.
    pub fn new(kind: DeleteDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetGroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetGroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDatasetGroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDatasetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventTracker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventTrackerError {
    /// Kind of error that occurred.
    pub kind: DeleteEventTrackerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventTracker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventTrackerErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventTrackerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventTrackerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteEventTrackerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteEventTrackerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEventTrackerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventTrackerError {
    fn code(&self) -> Option<&str> {
        DeleteEventTrackerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventTrackerError {
    /// Creates a new `DeleteEventTrackerError`.
    pub fn new(kind: DeleteEventTrackerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventTrackerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventTrackerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventTrackerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventTrackerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventTrackerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventTrackerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventTrackerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventTrackerErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventTrackerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventTrackerErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteEventTrackerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventTrackerErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteEventTrackerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteEventTrackerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEventTrackerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFilterErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFilterErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFilterError {
    fn code(&self) -> Option<&str> {
        DeleteFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFilterError {
    /// Creates a new `DeleteFilterError`.
    pub fn new(kind: DeleteFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFilterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteFilterErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteFilterErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFilterErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFilterErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteFilterErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRecommenderError {
    /// Kind of error that occurred.
    pub kind: DeleteRecommenderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRecommenderErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRecommenderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRecommenderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteRecommenderErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteRecommenderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRecommenderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRecommenderError {
    fn code(&self) -> Option<&str> {
        DeleteRecommenderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRecommenderError {
    /// Creates a new `DeleteRecommenderError`.
    pub fn new(kind: DeleteRecommenderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRecommenderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRecommenderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRecommenderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRecommenderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRecommenderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecommenderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecommenderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteRecommenderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRecommenderErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteRecommenderErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteRecommenderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRecommenderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSchemaError {
    /// Kind of error that occurred.
    pub kind: DeleteSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSchemaErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSchemaError {
    fn code(&self) -> Option<&str> {
        DeleteSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSchemaError {
    /// Creates a new `DeleteSchemaError`.
    pub fn new(kind: DeleteSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSolution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSolutionError {
    /// Kind of error that occurred.
    pub kind: DeleteSolutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSolution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSolutionErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSolutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSolutionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSolutionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteSolutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSolutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSolutionError {
    fn code(&self) -> Option<&str> {
        DeleteSolutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSolutionError {
    /// Creates a new `DeleteSolutionError`.
    pub fn new(kind: DeleteSolutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSolutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSolutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSolutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSolutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSolutionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSolutionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSolutionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSolutionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSolutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSolutionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteSolutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSolutionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSolutionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteSolutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSolutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlgorithm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlgorithmError {
    /// Kind of error that occurred.
    pub kind: DescribeAlgorithmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlgorithm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlgorithmErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlgorithmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlgorithmErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeAlgorithmErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAlgorithmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlgorithmError {
    fn code(&self) -> Option<&str> {
        DescribeAlgorithmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAlgorithmError {
    /// Creates a new `DescribeAlgorithmError`.
    pub fn new(kind: DescribeAlgorithmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlgorithmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlgorithmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlgorithmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlgorithmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAlgorithmErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlgorithmErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlgorithmErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlgorithmErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeAlgorithmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlgorithmErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeAlgorithmErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAlgorithmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBatchInferenceJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBatchInferenceJobError {
    /// Kind of error that occurred.
    pub kind: DescribeBatchInferenceJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBatchInferenceJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBatchInferenceJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBatchInferenceJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBatchInferenceJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeBatchInferenceJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBatchInferenceJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBatchInferenceJobError {
    fn code(&self) -> Option<&str> {
        DescribeBatchInferenceJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBatchInferenceJobError {
    /// Creates a new `DescribeBatchInferenceJobError`.
    pub fn new(kind: DescribeBatchInferenceJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBatchInferenceJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBatchInferenceJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBatchInferenceJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBatchInferenceJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBatchInferenceJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBatchInferenceJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBatchInferenceJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBatchInferenceJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBatchInferenceJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBatchInferenceJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeBatchInferenceJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBatchInferenceJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBatchSegmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBatchSegmentJobError {
    /// Kind of error that occurred.
    pub kind: DescribeBatchSegmentJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBatchSegmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBatchSegmentJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBatchSegmentJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBatchSegmentJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeBatchSegmentJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBatchSegmentJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBatchSegmentJobError {
    fn code(&self) -> Option<&str> {
        DescribeBatchSegmentJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBatchSegmentJobError {
    /// Creates a new `DescribeBatchSegmentJobError`.
    pub fn new(kind: DescribeBatchSegmentJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBatchSegmentJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBatchSegmentJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBatchSegmentJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBatchSegmentJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBatchSegmentJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBatchSegmentJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBatchSegmentJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBatchSegmentJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBatchSegmentJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBatchSegmentJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeBatchSegmentJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBatchSegmentJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCampaignError {
    /// Kind of error that occurred.
    pub kind: DescribeCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCampaignErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCampaignErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeCampaignErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCampaignError {
    fn code(&self) -> Option<&str> {
        DescribeCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCampaignError {
    /// Creates a new `DescribeCampaignError`.
    pub fn new(kind: DescribeCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCampaignErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCampaignErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCampaignErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCampaignErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCampaignErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCampaignErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeCampaignErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetError {
    /// Creates a new `DescribeDatasetError`.
    pub fn new(kind: DescribeDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDatasetExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetExportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDatasetExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetExportJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetExportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetExportJobError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetExportJobError {
    /// Creates a new `DescribeDatasetExportJobError`.
    pub fn new(kind: DescribeDatasetExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetExportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetExportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetExportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetExportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDatasetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetGroupErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetGroupError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetGroupError {
    /// Creates a new `DescribeDatasetGroupError`.
    pub fn new(kind: DescribeDatasetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetImportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDatasetImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetImportJobErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetImportJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetImportJobError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetImportJobError {
    /// Creates a new `DescribeDatasetImportJobError`.
    pub fn new(kind: DescribeDatasetImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetImportJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetImportJobErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDatasetImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetImportJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDatasetImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventTracker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventTrackerError {
    /// Kind of error that occurred.
    pub kind: DescribeEventTrackerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventTracker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventTrackerErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventTrackerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventTrackerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeEventTrackerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEventTrackerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventTrackerError {
    fn code(&self) -> Option<&str> {
        DescribeEventTrackerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventTrackerError {
    /// Creates a new `DescribeEventTrackerError`.
    pub fn new(kind: DescribeEventTrackerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventTrackerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventTrackerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventTrackerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventTrackerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventTrackerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTrackerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventTrackerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTrackerErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeEventTrackerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventTrackerErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeEventTrackerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEventTrackerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFeatureTransformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFeatureTransformationError {
    /// Kind of error that occurred.
    pub kind: DescribeFeatureTransformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFeatureTransformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFeatureTransformationErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFeatureTransformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFeatureTransformationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeFeatureTransformationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFeatureTransformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFeatureTransformationError {
    fn code(&self) -> Option<&str> {
        DescribeFeatureTransformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFeatureTransformationError {
    /// Creates a new `DescribeFeatureTransformationError`.
    pub fn new(
        kind: DescribeFeatureTransformationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFeatureTransformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFeatureTransformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFeatureTransformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFeatureTransformationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFeatureTransformationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeatureTransformationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFeatureTransformationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeatureTransformationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeFeatureTransformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFeatureTransformationErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeFeatureTransformationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeFeatureTransformationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFilterError {
    /// Kind of error that occurred.
    pub kind: DescribeFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFilterErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFilterErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFilterError {
    fn code(&self) -> Option<&str> {
        DescribeFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFilterError {
    /// Creates a new `DescribeFilterError`.
    pub fn new(kind: DescribeFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFilterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFilterErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFilterErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFilterErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFilterErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRecipe` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRecipeError {
    /// Kind of error that occurred.
    pub kind: DescribeRecipeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRecipe` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRecipeErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRecipeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRecipeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeRecipeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRecipeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRecipeError {
    fn code(&self) -> Option<&str> {
        DescribeRecipeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRecipeError {
    /// Creates a new `DescribeRecipeError`.
    pub fn new(kind: DescribeRecipeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRecipeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRecipeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRecipeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRecipeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRecipeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecipeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecipeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecipeErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeRecipeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRecipeErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeRecipeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRecipeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRecommenderError {
    /// Kind of error that occurred.
    pub kind: DescribeRecommenderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRecommenderErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRecommenderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRecommenderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeRecommenderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRecommenderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRecommenderError {
    fn code(&self) -> Option<&str> {
        DescribeRecommenderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRecommenderError {
    /// Creates a new `DescribeRecommenderError`.
    pub fn new(kind: DescribeRecommenderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRecommenderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRecommenderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRecommenderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRecommenderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRecommenderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecommenderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecommenderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecommenderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeRecommenderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRecommenderErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeRecommenderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRecommenderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSchemaError {
    /// Kind of error that occurred.
    pub kind: DescribeSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSchemaErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSchemaError {
    fn code(&self) -> Option<&str> {
        DescribeSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSchemaError {
    /// Creates a new `DescribeSchemaError`.
    pub fn new(kind: DescribeSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemaErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSchemaErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemaErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSolution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSolutionError {
    /// Kind of error that occurred.
    pub kind: DescribeSolutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSolution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSolutionErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSolutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSolutionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeSolutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSolutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSolutionError {
    fn code(&self) -> Option<&str> {
        DescribeSolutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSolutionError {
    /// Creates a new `DescribeSolutionError`.
    pub fn new(kind: DescribeSolutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSolutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSolutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSolutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSolutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSolutionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSolutionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSolutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSolutionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSolutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSolutionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeSolutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSolutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSolutionVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSolutionVersionError {
    /// Kind of error that occurred.
    pub kind: DescribeSolutionVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSolutionVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSolutionVersionErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSolutionVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSolutionVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeSolutionVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSolutionVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSolutionVersionError {
    fn code(&self) -> Option<&str> {
        DescribeSolutionVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSolutionVersionError {
    /// Creates a new `DescribeSolutionVersionError`.
    pub fn new(kind: DescribeSolutionVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSolutionVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSolutionVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSolutionVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSolutionVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSolutionVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSolutionVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSolutionVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSolutionVersionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSolutionVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSolutionVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeSolutionVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSolutionVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSolutionMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSolutionMetricsError {
    /// Kind of error that occurred.
    pub kind: GetSolutionMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSolutionMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSolutionMetricsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSolutionMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSolutionMetricsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSolutionMetricsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            GetSolutionMetricsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSolutionMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSolutionMetricsError {
    fn code(&self) -> Option<&str> {
        GetSolutionMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSolutionMetricsError {
    /// Creates a new `GetSolutionMetricsError`.
    pub fn new(kind: GetSolutionMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSolutionMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSolutionMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSolutionMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSolutionMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSolutionMetricsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSolutionMetricsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSolutionMetricsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSolutionMetricsErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSolutionMetricsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSolutionMetricsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetSolutionMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSolutionMetricsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSolutionMetricsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            GetSolutionMetricsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSolutionMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBatchInferenceJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBatchInferenceJobsError {
    /// Kind of error that occurred.
    pub kind: ListBatchInferenceJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBatchInferenceJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBatchInferenceJobsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBatchInferenceJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBatchInferenceJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBatchInferenceJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListBatchInferenceJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBatchInferenceJobsError {
    fn code(&self) -> Option<&str> {
        ListBatchInferenceJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBatchInferenceJobsError {
    /// Creates a new `ListBatchInferenceJobsError`.
    pub fn new(kind: ListBatchInferenceJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBatchInferenceJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBatchInferenceJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBatchInferenceJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBatchInferenceJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBatchInferenceJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBatchInferenceJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBatchInferenceJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBatchInferenceJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListBatchInferenceJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBatchInferenceJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBatchInferenceJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListBatchInferenceJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBatchSegmentJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBatchSegmentJobsError {
    /// Kind of error that occurred.
    pub kind: ListBatchSegmentJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBatchSegmentJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBatchSegmentJobsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBatchSegmentJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBatchSegmentJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBatchSegmentJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListBatchSegmentJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBatchSegmentJobsError {
    fn code(&self) -> Option<&str> {
        ListBatchSegmentJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBatchSegmentJobsError {
    /// Creates a new `ListBatchSegmentJobsError`.
    pub fn new(kind: ListBatchSegmentJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBatchSegmentJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBatchSegmentJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBatchSegmentJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBatchSegmentJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBatchSegmentJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBatchSegmentJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBatchSegmentJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBatchSegmentJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListBatchSegmentJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBatchSegmentJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBatchSegmentJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListBatchSegmentJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCampaigns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCampaignsError {
    /// Kind of error that occurred.
    pub kind: ListCampaignsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCampaigns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCampaignsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCampaignsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCampaignsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListCampaignsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListCampaignsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCampaignsError {
    fn code(&self) -> Option<&str> {
        ListCampaignsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCampaignsError {
    /// Creates a new `ListCampaignsError`.
    pub fn new(kind: ListCampaignsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCampaignsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCampaignsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCampaignsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCampaignsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCampaignsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListCampaignsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListCampaignsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCampaignsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCampaignsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCampaignsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListCampaignsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListCampaignsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetExportJobsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetExportJobsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetExportJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDatasetExportJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetExportJobsError {
    fn code(&self) -> Option<&str> {
        ListDatasetExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetExportJobsError {
    /// Creates a new `ListDatasetExportJobsError`.
    pub fn new(kind: ListDatasetExportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetExportJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetExportJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetExportJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetExportJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetExportJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDatasetExportJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetGroupsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetGroupsErrorKind {
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetGroupsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetGroupsError {
    fn code(&self) -> Option<&str> {
        ListDatasetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetGroupsError {
    /// Creates a new `ListDatasetGroupsError`.
    pub fn new(kind: ListDatasetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetGroupsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetGroupsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetGroupsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetImportJobsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetImportJobsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetImportJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDatasetImportJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetImportJobsError {
    fn code(&self) -> Option<&str> {
        ListDatasetImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetImportJobsError {
    /// Creates a new `ListDatasetImportJobsError`.
    pub fn new(kind: ListDatasetImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetImportJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetImportJobsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetImportJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetImportJobsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetImportJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDatasetImportJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetsError {
    fn code(&self) -> Option<&str> {
        ListDatasetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetsError {
    /// Creates a new `ListDatasetsError`.
    pub fn new(kind: ListDatasetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListDatasetsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListDatasetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDatasetsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDatasetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventTrackers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventTrackersError {
    /// Kind of error that occurred.
    pub kind: ListEventTrackersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventTrackers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventTrackersErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventTrackersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventTrackersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListEventTrackersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListEventTrackersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventTrackersError {
    fn code(&self) -> Option<&str> {
        ListEventTrackersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventTrackersError {
    /// Creates a new `ListEventTrackersError`.
    pub fn new(kind: ListEventTrackersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventTrackersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventTrackersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventTrackersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventTrackersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventTrackersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventTrackersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventTrackersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventTrackersErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListEventTrackersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventTrackersErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListEventTrackersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListEventTrackersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFiltersError {
    /// Kind of error that occurred.
    pub kind: ListFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFiltersErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFiltersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFiltersError {
    fn code(&self) -> Option<&str> {
        ListFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFiltersError {
    /// Creates a new `ListFiltersError`.
    pub fn new(kind: ListFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFiltersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListFiltersErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFiltersErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFiltersErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListFiltersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecipes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecipesError {
    /// Kind of error that occurred.
    pub kind: ListRecipesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecipes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecipesErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecipesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecipesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListRecipesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListRecipesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecipesError {
    fn code(&self) -> Option<&str> {
        ListRecipesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecipesError {
    /// Creates a new `ListRecipesError`.
    pub fn new(kind: ListRecipesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecipesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecipesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecipesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecipesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRecipesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListRecipesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListRecipesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecipesErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListRecipesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecipesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListRecipesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListRecipesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecommenders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecommendersError {
    /// Kind of error that occurred.
    pub kind: ListRecommendersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecommenders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecommendersErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecommendersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecommendersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListRecommendersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListRecommendersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecommendersError {
    fn code(&self) -> Option<&str> {
        ListRecommendersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecommendersError {
    /// Creates a new `ListRecommendersError`.
    pub fn new(kind: ListRecommendersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecommendersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecommendersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecommendersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecommendersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRecommendersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecommendersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendersErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListRecommendersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecommendersErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListRecommendersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListRecommendersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemasError {
    /// Kind of error that occurred.
    pub kind: ListSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemasErrorKind {
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemasErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemasError {
    fn code(&self) -> Option<&str> {
        ListSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemasError {
    /// Creates a new `ListSchemasError`.
    pub fn new(kind: ListSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemasErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemasErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSolutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSolutionsError {
    /// Kind of error that occurred.
    pub kind: ListSolutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSolutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSolutionsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSolutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSolutionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSolutionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListSolutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSolutionsError {
    fn code(&self) -> Option<&str> {
        ListSolutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSolutionsError {
    /// Creates a new `ListSolutionsError`.
    pub fn new(kind: ListSolutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSolutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSolutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSolutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSolutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSolutionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListSolutionsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListSolutionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSolutionsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListSolutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSolutionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSolutionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListSolutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSolutionVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSolutionVersionsError {
    /// Kind of error that occurred.
    pub kind: ListSolutionVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSolutionVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSolutionVersionsErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSolutionVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSolutionVersionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSolutionVersionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListSolutionVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSolutionVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSolutionVersionsError {
    fn code(&self) -> Option<&str> {
        ListSolutionVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSolutionVersionsError {
    /// Creates a new `ListSolutionVersionsError`.
    pub fn new(kind: ListSolutionVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSolutionVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSolutionVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSolutionVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSolutionVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSolutionVersionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSolutionVersionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSolutionVersionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSolutionVersionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSolutionVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSolutionVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListSolutionVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSolutionVersionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSolutionVersionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListSolutionVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSolutionVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceInUseException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartRecommenderError {
    /// Kind of error that occurred.
    pub kind: StartRecommenderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartRecommenderErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartRecommenderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartRecommenderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartRecommenderErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StartRecommenderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartRecommenderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartRecommenderError {
    fn code(&self) -> Option<&str> {
        StartRecommenderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartRecommenderError {
    /// Creates a new `StartRecommenderError`.
    pub fn new(kind: StartRecommenderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartRecommenderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartRecommenderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartRecommenderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartRecommenderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartRecommenderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommenderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecommenderErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommenderErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecommenderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommenderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartRecommenderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartRecommenderErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartRecommenderErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StartRecommenderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartRecommenderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopRecommenderError {
    /// Kind of error that occurred.
    pub kind: StopRecommenderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopRecommenderErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopRecommenderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopRecommenderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopRecommenderErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StopRecommenderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopRecommenderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopRecommenderError {
    fn code(&self) -> Option<&str> {
        StopRecommenderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopRecommenderError {
    /// Creates a new `StopRecommenderError`.
    pub fn new(kind: StopRecommenderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopRecommenderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopRecommenderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopRecommenderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopRecommenderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopRecommenderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRecommenderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StopRecommenderErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRecommenderErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `StopRecommenderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRecommenderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopRecommenderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopRecommenderErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopRecommenderErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StopRecommenderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopRecommenderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopSolutionVersionCreation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopSolutionVersionCreationError {
    /// Kind of error that occurred.
    pub kind: StopSolutionVersionCreationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopSolutionVersionCreation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopSolutionVersionCreationErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopSolutionVersionCreationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopSolutionVersionCreationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopSolutionVersionCreationErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StopSolutionVersionCreationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopSolutionVersionCreationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopSolutionVersionCreationError {
    fn code(&self) -> Option<&str> {
        StopSolutionVersionCreationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopSolutionVersionCreationError {
    /// Creates a new `StopSolutionVersionCreationError`.
    pub fn new(kind: StopSolutionVersionCreationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopSolutionVersionCreationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopSolutionVersionCreationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopSolutionVersionCreationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopSolutionVersionCreationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopSolutionVersionCreationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopSolutionVersionCreationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StopSolutionVersionCreationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopSolutionVersionCreationErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `StopSolutionVersionCreationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopSolutionVersionCreationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopSolutionVersionCreationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopSolutionVersionCreationErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopSolutionVersionCreationErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StopSolutionVersionCreationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopSolutionVersionCreationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The limit on the number of requests per second has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceInUseException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource). </p>
    TooManyTagKeysException(crate::error::TooManyTagKeysException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyTagKeysException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyTagKeysException`.
    pub fn is_too_many_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyTagKeysException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyTagKeysException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCampaignError {
    /// Kind of error that occurred.
    pub kind: UpdateCampaignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCampaign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCampaignErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCampaignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCampaignErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCampaignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCampaignError {
    fn code(&self) -> Option<&str> {
        UpdateCampaignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCampaignError {
    /// Creates a new `UpdateCampaignError`.
    pub fn new(kind: UpdateCampaignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCampaignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCampaignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCampaignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCampaignErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCampaignErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCampaignErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateCampaignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCampaignErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCampaignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRecommenderError {
    /// Kind of error that occurred.
    pub kind: UpdateRecommenderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRecommender` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRecommenderErrorKind {
    /// <p>Provide a valid value for the field or parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Could not find the specified resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRecommenderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRecommenderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateRecommenderErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateRecommenderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRecommenderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRecommenderError {
    fn code(&self) -> Option<&str> {
        UpdateRecommenderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRecommenderError {
    /// Creates a new `UpdateRecommenderError`.
    pub fn new(kind: UpdateRecommenderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRecommenderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRecommenderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRecommenderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRecommenderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRecommenderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecommenderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecommenderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateRecommenderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRecommenderErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateRecommenderErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateRecommenderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRecommenderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Could not find the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The specified resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>Provide a valid value for the field or parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagKeysException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagKeysException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagKeysException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagKeysException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagKeysException {}
/// See [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
pub mod too_many_tag_keys_exception {
    /// A builder for [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
        pub fn build(self) -> crate::error::TooManyTagKeysException {
            crate::error::TooManyTagKeysException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagKeysException {
    /// Creates a new builder-style object to manufacture [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
    pub fn builder() -> crate::error::too_many_tag_keys_exception::Builder {
        crate::error::too_many_tag_keys_exception::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of tags you can apply to this resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The limit on the number of requests per second has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The token is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The specified resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
