// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateBatchInferenceJobInput`](crate::input::CreateBatchInferenceJobInput)
pub mod create_batch_inference_job_input {
    /// A builder for [`CreateBatchInferenceJobInput`](crate::input::CreateBatchInferenceJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) filter_arn: std::option::Option<std::string::String>,
        pub(crate) num_results: std::option::Option<i32>,
        pub(crate) job_input: std::option::Option<crate::model::BatchInferenceJobInput>,
        pub(crate) job_output: std::option::Option<crate::model::BatchInferenceJobOutput>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) batch_inference_job_config:
            std::option::Option<crate::model::BatchInferenceJobConfig>,
    }
    impl Builder {
        /// <p>The name of the batch inference job to create.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the batch inference job to create.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the
        /// batch inference recommendations.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the
        /// batch inference recommendations.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>The ARN of the filter to apply to the batch inference job. For more information on using
        /// filters, see
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering Batch Recommendations</a>..</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter to apply to the batch inference job. For more information on using
        /// filters, see
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering Batch Recommendations</a>..</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// <p>The number of recommendations to retreive.</p>
        pub fn num_results(mut self, input: i32) -> Self {
            self.num_results = Some(input);
            self
        }
        /// <p>The number of recommendations to retreive.</p>
        pub fn set_num_results(mut self, input: std::option::Option<i32>) -> Self {
            self.num_results = input;
            self
        }
        /// <p>The Amazon S3 path that leads to the input file to base your recommendations on. The input
        /// material must be in JSON format.</p>
        pub fn job_input(mut self, input: crate::model::BatchInferenceJobInput) -> Self {
            self.job_input = Some(input);
            self
        }
        /// <p>The Amazon S3 path that leads to the input file to base your recommendations on. The input
        /// material must be in JSON format.</p>
        pub fn set_job_input(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobInput>,
        ) -> Self {
            self.job_input = input;
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output will be stored.</p>
        pub fn job_output(mut self, input: crate::model::BatchInferenceJobOutput) -> Self {
            self.job_output = Some(input);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output will be stored.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobOutput>,
        ) -> Self {
            self.job_output = input;
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
        /// Amazon S3 buckets respectively.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
        /// Amazon S3 buckets respectively.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The configuration details of a batch inference job.</p>
        pub fn batch_inference_job_config(
            mut self,
            input: crate::model::BatchInferenceJobConfig,
        ) -> Self {
            self.batch_inference_job_config = Some(input);
            self
        }
        /// <p>The configuration details of a batch inference job.</p>
        pub fn set_batch_inference_job_config(
            mut self,
            input: std::option::Option<crate::model::BatchInferenceJobConfig>,
        ) -> Self {
            self.batch_inference_job_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchInferenceJobInput`](crate::input::CreateBatchInferenceJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBatchInferenceJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBatchInferenceJobInput {
                job_name: self.job_name,
                solution_version_arn: self.solution_version_arn,
                filter_arn: self.filter_arn,
                num_results: self.num_results,
                job_input: self.job_input,
                job_output: self.job_output,
                role_arn: self.role_arn,
                batch_inference_job_config: self.batch_inference_job_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBatchInferenceJobInputOperationOutputAlias =
    crate::operation::CreateBatchInferenceJob;
#[doc(hidden)]
pub type CreateBatchInferenceJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBatchInferenceJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateBatchInferenceJob`](crate::operation::CreateBatchInferenceJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBatchInferenceJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBatchInferenceJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBatchInferenceJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBatchInferenceJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateBatchInferenceJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_batch_inference_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBatchInferenceJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBatchInferenceJob",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBatchInferenceJobInput`](crate::input::CreateBatchInferenceJobInput)
    pub fn builder() -> crate::input::create_batch_inference_job_input::Builder {
        crate::input::create_batch_inference_job_input::Builder::default()
    }
}

/// See [`CreateCampaignInput`](crate::input::CreateCampaignInput)
pub mod create_campaign_input {
    /// A builder for [`CreateCampaignInput`](crate::input::CreateCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) min_provisioned_tps: std::option::Option<i32>,
        pub(crate) campaign_config: std::option::Option<crate::model::CampaignConfig>,
    }
    impl Builder {
        /// <p>A name for the new campaign. The campaign name must be unique within your account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the new campaign. The campaign name must be unique within your account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version to deploy.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version to deploy.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn min_provisioned_tps(mut self, input: i32) -> Self {
            self.min_provisioned_tps = Some(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn set_min_provisioned_tps(mut self, input: std::option::Option<i32>) -> Self {
            self.min_provisioned_tps = input;
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn campaign_config(mut self, input: crate::model::CampaignConfig) -> Self {
            self.campaign_config = Some(input);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn set_campaign_config(
            mut self,
            input: std::option::Option<crate::model::CampaignConfig>,
        ) -> Self {
            self.campaign_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCampaignInput`](crate::input::CreateCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCampaignInput {
                name: self.name,
                solution_version_arn: self.solution_version_arn,
                min_provisioned_tps: self.min_provisioned_tps,
                campaign_config: self.campaign_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCampaignInputOperationOutputAlias = crate::operation::CreateCampaign;
#[doc(hidden)]
pub type CreateCampaignInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCampaignInput {
    /// Consumes the builder and constructs an Operation<[`CreateCampaign`](crate::operation::CreateCampaign)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCampaign,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCampaignInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCampaignInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCampaignInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateCampaign",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_campaign(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCampaign",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCampaignInput`](crate::input::CreateCampaignInput)
    pub fn builder() -> crate::input::create_campaign_input::Builder {
        crate::input::create_campaign_input::Builder::default()
    }
}

/// See [`CreateDatasetInput`](crate::input::CreateDatasetInput)
pub mod create_dataset_input {
    /// A builder for [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the schema to associate with the dataset. The schema defines the dataset
        /// fields.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema to associate with the dataset. The schema defines the dataset
        /// fields.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The type of dataset.</p>
        /// <p>One of the following (case insensitive) values:</p>
        /// <ul>
        /// <li>
        /// <p>Interactions</p>
        /// </li>
        /// <li>
        /// <p>Items</p>
        /// </li>
        /// <li>
        /// <p>Users</p>
        /// </li>
        /// </ul>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The type of dataset.</p>
        /// <p>One of the following (case insensitive) values:</p>
        /// <ul>
        /// <li>
        /// <p>Interactions</p>
        /// </li>
        /// <li>
        /// <p>Items</p>
        /// </li>
        /// <li>
        /// <p>Users</p>
        /// </li>
        /// </ul>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetInput`](crate::input::CreateDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetInput {
                name: self.name,
                schema_arn: self.schema_arn,
                dataset_group_arn: self.dataset_group_arn,
                dataset_type: self.dataset_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetInputOperationOutputAlias = crate::operation::CreateDataset;
#[doc(hidden)]
pub type CreateDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDatasetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataset`](crate::operation::CreateDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateDataset",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_dataset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataset",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
}

/// See [`CreateDatasetExportJobInput`](crate::input::CreateDatasetExportJobInput)
pub mod create_dataset_export_job_input {
    /// A builder for [`CreateDatasetExportJobInput`](crate::input::CreateDatasetExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_mode: std::option::Option<crate::model::IngestionMode>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) job_output: std::option::Option<crate::model::DatasetExportJobOutput>,
    }
    impl Builder {
        /// <p>The name for the dataset export job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name for the dataset export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job,
        /// only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
        /// for both types. The default value is <code>PUT</code>.
        /// </p>
        pub fn ingestion_mode(mut self, input: crate::model::IngestionMode) -> Self {
            self.ingestion_mode = Some(input);
            self
        }
        /// <p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job,
        /// only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
        /// for both types. The default value is <code>PUT</code>.
        /// </p>
        pub fn set_ingestion_mode(
            mut self,
            input: std::option::Option<crate::model::IngestionMode>,
        ) -> Self {
            self.ingestion_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your
        /// output Amazon S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your
        /// output Amazon S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output is stored.</p>
        pub fn job_output(mut self, input: crate::model::DatasetExportJobOutput) -> Self {
            self.job_output = Some(input);
            self
        }
        /// <p>The path to the Amazon S3 bucket where the job's output is stored.</p>
        pub fn set_job_output(
            mut self,
            input: std::option::Option<crate::model::DatasetExportJobOutput>,
        ) -> Self {
            self.job_output = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetExportJobInput`](crate::input::CreateDatasetExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetExportJobInput {
                job_name: self.job_name,
                dataset_arn: self.dataset_arn,
                ingestion_mode: self.ingestion_mode,
                role_arn: self.role_arn,
                job_output: self.job_output,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetExportJobInputOperationOutputAlias = crate::operation::CreateDatasetExportJob;
#[doc(hidden)]
pub type CreateDatasetExportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDatasetExportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateDatasetExportJob`](crate::operation::CreateDatasetExportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDatasetExportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDatasetExportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDatasetExportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDatasetExportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateDatasetExportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_dataset_export_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDatasetExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDatasetExportJob",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetExportJobInput`](crate::input::CreateDatasetExportJobInput)
    pub fn builder() -> crate::input::create_dataset_export_job_input::Builder {
        crate::input::create_dataset_export_job_input::Builder::default()
    }
}

/// See [`CreateDatasetGroupInput`](crate::input::CreateDatasetGroupInput)
pub mod create_dataset_group_input {
    /// A builder for [`CreateDatasetGroupInput`](crate::input::CreateDatasetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the new dataset group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new dataset group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM
        /// role is only valid when also specifying a KMS key.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM
        /// role is only valid when also specifying a KMS key.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetGroupInput`](crate::input::CreateDatasetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetGroupInput {
                name: self.name,
                role_arn: self.role_arn,
                kms_key_arn: self.kms_key_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetGroupInputOperationOutputAlias = crate::operation::CreateDatasetGroup;
#[doc(hidden)]
pub type CreateDatasetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDatasetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDatasetGroup`](crate::operation::CreateDatasetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDatasetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDatasetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDatasetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDatasetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateDatasetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_dataset_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDatasetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDatasetGroup",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetGroupInput`](crate::input::CreateDatasetGroupInput)
    pub fn builder() -> crate::input::create_dataset_group_input::Builder {
        crate::input::create_dataset_group_input::Builder::default()
    }
}

/// See [`CreateDatasetImportJobInput`](crate::input::CreateDatasetImportJobInput)
pub mod create_dataset_import_job_input {
    /// A builder for [`CreateDatasetImportJobInput`](crate::input::CreateDatasetImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the dataset import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name for the dataset import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The ARN of the dataset that receives the imported data.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset that receives the imported data.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>The Amazon S3 bucket that contains the training data to import.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains the training data to import.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetImportJobInput`](crate::input::CreateDatasetImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetImportJobInput {
                job_name: self.job_name,
                dataset_arn: self.dataset_arn,
                data_source: self.data_source,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetImportJobInputOperationOutputAlias = crate::operation::CreateDatasetImportJob;
#[doc(hidden)]
pub type CreateDatasetImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDatasetImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateDatasetImportJob`](crate::operation::CreateDatasetImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDatasetImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDatasetImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDatasetImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDatasetImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateDatasetImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_dataset_import_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDatasetImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDatasetImportJob",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetImportJobInput`](crate::input::CreateDatasetImportJobInput)
    pub fn builder() -> crate::input::create_dataset_import_job_input::Builder {
        crate::input::create_dataset_import_job_input::Builder::default()
    }
}

/// See [`CreateEventTrackerInput`](crate::input::CreateEventTrackerInput)
pub mod create_event_tracker_input {
    /// A builder for [`CreateEventTrackerInput`](crate::input::CreateEventTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the event tracker.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the event tracker.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventTrackerInput`](crate::input::CreateEventTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventTrackerInput {
                name: self.name,
                dataset_group_arn: self.dataset_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventTrackerInputOperationOutputAlias = crate::operation::CreateEventTracker;
#[doc(hidden)]
pub type CreateEventTrackerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEventTrackerInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventTracker`](crate::operation::CreateEventTracker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventTracker,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventTrackerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventTrackerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventTrackerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateEventTracker",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_tracker(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventTracker",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventTrackerInput`](crate::input::CreateEventTrackerInput)
    pub fn builder() -> crate::input::create_event_tracker_input::Builder {
        crate::input::create_event_tracker_input::Builder::default()
    }
}

/// See [`CreateFilterInput`](crate::input::CreateFilterInput)
pub mod create_filter_input {
    /// A builder for [`CreateFilterInput`](crate::input::CreateFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the dataset group that the filter will belong to.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group that the filter will belong to.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules.
        /// For information about filter expression structure and syntax, see
        /// <a>filter-expressions</a>.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules.
        /// For information about filter expression structure and syntax, see
        /// <a>filter-expressions</a>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFilterInput`](crate::input::CreateFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFilterInput {
                name: self.name,
                dataset_group_arn: self.dataset_group_arn,
                filter_expression: self.filter_expression,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFilterInputOperationOutputAlias = crate::operation::CreateFilter;
#[doc(hidden)]
pub type CreateFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFilterInput {
    /// Consumes the builder and constructs an Operation<[`CreateFilter`](crate::operation::CreateFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateFilter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFilter",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFilterInput`](crate::input::CreateFilterInput)
    pub fn builder() -> crate::input::create_filter_input::Builder {
        crate::input::create_filter_input::Builder::default()
    }
}

/// See [`CreateSchemaInput`](crate::input::CreateSchemaInput)
pub mod create_schema_input {
    /// A builder for [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A schema in Avro JSON format.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>A schema in Avro JSON format.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaInput`](crate::input::CreateSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSchemaInput {
                name: self.name,
                schema: self.schema,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSchemaInputOperationOutputAlias = crate::operation::CreateSchema;
#[doc(hidden)]
pub type CreateSchemaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSchemaInput {
    /// Consumes the builder and constructs an Operation<[`CreateSchema`](crate::operation::CreateSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSchema,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateSchema",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSchema",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
}

/// See [`CreateSolutionInput`](crate::input::CreateSolutionInput)
pub mod create_solution_input {
    /// A builder for [`CreateSolutionInput`](crate::input::CreateSolutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) perform_hpo: std::option::Option<bool>,
        pub(crate) perform_auto_ml: std::option::Option<bool>,
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<std::string::String>,
        pub(crate) solution_config: std::option::Option<crate::model::SolutionConfig>,
    }
    impl Builder {
        /// <p>The name for the solution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the solution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe.
        /// The default is <code>false</code>.</p>
        /// <p>When performing AutoML, this parameter is always <code>true</code> and you
        /// should not set it to <code>false</code>.</p>
        pub fn perform_hpo(mut self, input: bool) -> Self {
            self.perform_hpo = Some(input);
            self
        }
        /// <p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe.
        /// The default is <code>false</code>.</p>
        /// <p>When performing AutoML, this parameter is always <code>true</code> and you
        /// should not set it to <code>false</code>.</p>
        pub fn set_perform_hpo(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_hpo = input;
            self
        }
        /// <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>.
        /// For this case, you must specify <code>recipeArn</code>.</p>
        /// <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects
        /// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit
        /// <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with
        /// different values for the hyperparameters.
        /// AutoML lengthens the training process as compared to selecting a specific recipe.</p>
        pub fn perform_auto_ml(mut self, input: bool) -> Self {
            self.perform_auto_ml = Some(input);
            self
        }
        /// <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>.
        /// For this case, you must specify <code>recipeArn</code>.</p>
        /// <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects
        /// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit
        /// <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with
        /// different values for the hyperparameters.
        /// AutoML lengthens the training process as compared to selecting a specific recipe.</p>
        pub fn set_perform_auto_ml(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_auto_ml = input;
            self
        }
        /// <p>The ARN of the recipe to use for model training. Only specified when
        /// <code>performAutoML</code> is false.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the recipe to use for model training. Only specified when
        /// <code>performAutoML</code> is false.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field),
        /// this parameter specifies which event type (for example, 'click' or 'like') is used for
        /// training the model.</p>
        /// <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
        /// equal weight regardless of type.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field),
        /// this parameter specifies which event type (for example, 'click' or 'like') is used for
        /// training the model.</p>
        /// <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
        /// equal weight regardless of type.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The configuration to use with the solution. When <code>performAutoML</code> is set to
        /// true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section
        /// of the solution configuration.</p>
        /// <note>
        /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
        /// at this time.</p>
        /// </note>
        pub fn solution_config(mut self, input: crate::model::SolutionConfig) -> Self {
            self.solution_config = Some(input);
            self
        }
        /// <p>The configuration to use with the solution. When <code>performAutoML</code> is set to
        /// true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section
        /// of the solution configuration.</p>
        /// <note>
        /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
        /// at this time.</p>
        /// </note>
        pub fn set_solution_config(
            mut self,
            input: std::option::Option<crate::model::SolutionConfig>,
        ) -> Self {
            self.solution_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSolutionInput`](crate::input::CreateSolutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSolutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSolutionInput {
                name: self.name,
                perform_hpo: self.perform_hpo,
                perform_auto_ml: self.perform_auto_ml.unwrap_or_default(),
                recipe_arn: self.recipe_arn,
                dataset_group_arn: self.dataset_group_arn,
                event_type: self.event_type,
                solution_config: self.solution_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSolutionInputOperationOutputAlias = crate::operation::CreateSolution;
#[doc(hidden)]
pub type CreateSolutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSolutionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSolution`](crate::operation::CreateSolution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSolution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSolutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSolutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSolutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateSolution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_solution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSolution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSolution",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSolutionInput`](crate::input::CreateSolutionInput)
    pub fn builder() -> crate::input::create_solution_input::Builder {
        crate::input::create_solution_input::Builder::default()
    }
}

/// See [`CreateSolutionVersionInput`](crate::input::CreateSolutionVersionInput)
pub mod create_solution_version_input {
    /// A builder for [`CreateSolutionVersionInput`](crate::input::CreateSolutionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_arn: std::option::Option<std::string::String>,
        pub(crate) training_mode: std::option::Option<crate::model::TrainingMode>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution containing the training configuration
        /// information.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution containing the training configuration
        /// information.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// <p>The scope of training to be performed when creating the solution version. The
        /// <code>FULL</code> option trains the solution version based on the entirety of the input
        /// solution's training data, while the <code>UPDATE</code> option processes only the data that
        /// has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to
        /// incrementally update your solution version instead of creating an entirely new one.</p>
        /// <important>
        /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution
        /// version created from the input solution using the <code>FULL</code> option and the input
        /// solution was trained with the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>
        /// recipe or the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
        /// </important>
        pub fn training_mode(mut self, input: crate::model::TrainingMode) -> Self {
            self.training_mode = Some(input);
            self
        }
        /// <p>The scope of training to be performed when creating the solution version. The
        /// <code>FULL</code> option trains the solution version based on the entirety of the input
        /// solution's training data, while the <code>UPDATE</code> option processes only the data that
        /// has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to
        /// incrementally update your solution version instead of creating an entirely new one.</p>
        /// <important>
        /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution
        /// version created from the input solution using the <code>FULL</code> option and the input
        /// solution was trained with the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>
        /// recipe or the
        /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
        /// </important>
        pub fn set_training_mode(
            mut self,
            input: std::option::Option<crate::model::TrainingMode>,
        ) -> Self {
            self.training_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSolutionVersionInput`](crate::input::CreateSolutionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSolutionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSolutionVersionInput {
                solution_arn: self.solution_arn,
                training_mode: self.training_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSolutionVersionInputOperationOutputAlias = crate::operation::CreateSolutionVersion;
#[doc(hidden)]
pub type CreateSolutionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSolutionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSolutionVersion`](crate::operation::CreateSolutionVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSolutionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSolutionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSolutionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSolutionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.CreateSolutionVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_solution_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSolutionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSolutionVersion",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSolutionVersionInput`](crate::input::CreateSolutionVersionInput)
    pub fn builder() -> crate::input::create_solution_version_input::Builder {
        crate::input::create_solution_version_input::Builder::default()
    }
}

/// See [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
pub mod delete_campaign_input {
    /// A builder for [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the campaign to delete.</p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign to delete.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCampaignInput {
                campaign_arn: self.campaign_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCampaignInputOperationOutputAlias = crate::operation::DeleteCampaign;
#[doc(hidden)]
pub type DeleteCampaignInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCampaignInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCampaign`](crate::operation::DeleteCampaign)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCampaign,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCampaignInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCampaignInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCampaignInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteCampaign",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_campaign(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCampaign",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCampaignInput`](crate::input::DeleteCampaignInput)
    pub fn builder() -> crate::input::delete_campaign_input::Builder {
        crate::input::delete_campaign_input::Builder::default()
    }
}

/// See [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
pub mod delete_dataset_input {
    /// A builder for [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDatasetInput {
                dataset_arn: self.dataset_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDatasetInputOperationOutputAlias = crate::operation::DeleteDataset;
#[doc(hidden)]
pub type DeleteDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataset`](crate::operation::DeleteDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteDataset",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_dataset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataset",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
}

/// See [`DeleteDatasetGroupInput`](crate::input::DeleteDatasetGroupInput)
pub mod delete_dataset_group_input {
    /// A builder for [`DeleteDatasetGroupInput`](crate::input::DeleteDatasetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dataset group to delete.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group to delete.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetGroupInput`](crate::input::DeleteDatasetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDatasetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDatasetGroupInput {
                dataset_group_arn: self.dataset_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDatasetGroupInputOperationOutputAlias = crate::operation::DeleteDatasetGroup;
#[doc(hidden)]
pub type DeleteDatasetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDatasetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDatasetGroup`](crate::operation::DeleteDatasetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDatasetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDatasetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDatasetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDatasetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteDatasetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_dataset_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDatasetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDatasetGroup",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDatasetGroupInput`](crate::input::DeleteDatasetGroupInput)
    pub fn builder() -> crate::input::delete_dataset_group_input::Builder {
        crate::input::delete_dataset_group_input::Builder::default()
    }
}

/// See [`DeleteEventTrackerInput`](crate::input::DeleteEventTrackerInput)
pub mod delete_event_tracker_input {
    /// A builder for [`DeleteEventTrackerInput`](crate::input::DeleteEventTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_tracker_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>
        pub fn event_tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_tracker_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_tracker_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventTrackerInput`](crate::input::DeleteEventTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventTrackerInput {
                event_tracker_arn: self.event_tracker_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventTrackerInputOperationOutputAlias = crate::operation::DeleteEventTracker;
#[doc(hidden)]
pub type DeleteEventTrackerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventTrackerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventTracker`](crate::operation::DeleteEventTracker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventTracker,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventTrackerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventTrackerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventTrackerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteEventTracker",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_tracker(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventTracker",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventTrackerInput`](crate::input::DeleteEventTrackerInput)
    pub fn builder() -> crate::input::delete_event_tracker_input::Builder {
        crate::input::delete_event_tracker_input::Builder::default()
    }
}

/// See [`DeleteFilterInput`](crate::input::DeleteFilterInput)
pub mod delete_filter_input {
    /// A builder for [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the filter to delete.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter to delete.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFilterInput`](crate::input::DeleteFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFilterInput {
                filter_arn: self.filter_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFilterInputOperationOutputAlias = crate::operation::DeleteFilter;
#[doc(hidden)]
pub type DeleteFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFilterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFilter`](crate::operation::DeleteFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteFilter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFilter",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    pub fn builder() -> crate::input::delete_filter_input::Builder {
        crate::input::delete_filter_input::Builder::default()
    }
}

/// See [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
pub mod delete_schema_input {
    /// A builder for [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema to delete.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema to delete.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSchemaInput {
                schema_arn: self.schema_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSchemaInputOperationOutputAlias = crate::operation::DeleteSchema;
#[doc(hidden)]
pub type DeleteSchemaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSchemaInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSchema`](crate::operation::DeleteSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSchema,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteSchema",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSchema",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
}

/// See [`DeleteSolutionInput`](crate::input::DeleteSolutionInput)
pub mod delete_solution_input {
    /// A builder for [`DeleteSolutionInput`](crate::input::DeleteSolutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the solution to delete.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the solution to delete.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSolutionInput`](crate::input::DeleteSolutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSolutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSolutionInput {
                solution_arn: self.solution_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSolutionInputOperationOutputAlias = crate::operation::DeleteSolution;
#[doc(hidden)]
pub type DeleteSolutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSolutionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSolution`](crate::operation::DeleteSolution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSolution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSolutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSolutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSolutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DeleteSolution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_solution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSolution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSolution",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSolutionInput`](crate::input::DeleteSolutionInput)
    pub fn builder() -> crate::input::delete_solution_input::Builder {
        crate::input::delete_solution_input::Builder::default()
    }
}

/// See [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
pub mod describe_algorithm_input {
    /// A builder for [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>
        pub fn algorithm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>
        pub fn set_algorithm_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAlgorithmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAlgorithmInput {
                algorithm_arn: self.algorithm_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAlgorithmInputOperationOutputAlias = crate::operation::DescribeAlgorithm;
#[doc(hidden)]
pub type DescribeAlgorithmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAlgorithmInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAlgorithm`](crate::operation::DescribeAlgorithm)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAlgorithm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAlgorithmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAlgorithmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAlgorithmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeAlgorithm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_algorithm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAlgorithm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAlgorithm",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
    pub fn builder() -> crate::input::describe_algorithm_input::Builder {
        crate::input::describe_algorithm_input::Builder::default()
    }
}

/// See [`DescribeBatchInferenceJobInput`](crate::input::DescribeBatchInferenceJobInput)
pub mod describe_batch_inference_job_input {
    /// A builder for [`DescribeBatchInferenceJobInput`](crate::input::DescribeBatchInferenceJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_inference_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the batch inference job to describe.</p>
        pub fn batch_inference_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_inference_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the batch inference job to describe.</p>
        pub fn set_batch_inference_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_inference_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBatchInferenceJobInput`](crate::input::DescribeBatchInferenceJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBatchInferenceJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBatchInferenceJobInput {
                batch_inference_job_arn: self.batch_inference_job_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBatchInferenceJobInputOperationOutputAlias =
    crate::operation::DescribeBatchInferenceJob;
#[doc(hidden)]
pub type DescribeBatchInferenceJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBatchInferenceJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBatchInferenceJob`](crate::operation::DescribeBatchInferenceJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBatchInferenceJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBatchInferenceJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBatchInferenceJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBatchInferenceJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeBatchInferenceJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_batch_inference_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBatchInferenceJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBatchInferenceJob",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBatchInferenceJobInput`](crate::input::DescribeBatchInferenceJobInput)
    pub fn builder() -> crate::input::describe_batch_inference_job_input::Builder {
        crate::input::describe_batch_inference_job_input::Builder::default()
    }
}

/// See [`DescribeCampaignInput`](crate::input::DescribeCampaignInput)
pub mod describe_campaign_input {
    /// A builder for [`DescribeCampaignInput`](crate::input::DescribeCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCampaignInput`](crate::input::DescribeCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCampaignInput {
                campaign_arn: self.campaign_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCampaignInputOperationOutputAlias = crate::operation::DescribeCampaign;
#[doc(hidden)]
pub type DescribeCampaignInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCampaignInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCampaign`](crate::operation::DescribeCampaign)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCampaign,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCampaignInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCampaignInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCampaignInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeCampaign",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_campaign(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCampaign",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCampaignInput`](crate::input::DescribeCampaignInput)
    pub fn builder() -> crate::input::describe_campaign_input::Builder {
        crate::input::describe_campaign_input::Builder::default()
    }
}

/// See [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
pub mod describe_dataset_input {
    /// A builder for [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset to describe.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to describe.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetInput {
                dataset_arn: self.dataset_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetInputOperationOutputAlias = crate::operation::DescribeDataset;
#[doc(hidden)]
pub type DescribeDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataset`](crate::operation::DescribeDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeDataset",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_dataset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataset",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
}

/// See [`DescribeDatasetExportJobInput`](crate::input::DescribeDatasetExportJobInput)
pub mod describe_dataset_export_job_input {
    /// A builder for [`DescribeDatasetExportJobInput`](crate::input::DescribeDatasetExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_export_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>
        pub fn dataset_export_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_export_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>
        pub fn set_dataset_export_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_export_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetExportJobInput`](crate::input::DescribeDatasetExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetExportJobInput {
                dataset_export_job_arn: self.dataset_export_job_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetExportJobInputOperationOutputAlias =
    crate::operation::DescribeDatasetExportJob;
#[doc(hidden)]
pub type DescribeDatasetExportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDatasetExportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDatasetExportJob`](crate::operation::DescribeDatasetExportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDatasetExportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDatasetExportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDatasetExportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDatasetExportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeDatasetExportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_dataset_export_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDatasetExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDatasetExportJob",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetExportJobInput`](crate::input::DescribeDatasetExportJobInput)
    pub fn builder() -> crate::input::describe_dataset_export_job_input::Builder {
        crate::input::describe_dataset_export_job_input::Builder::default()
    }
}

/// See [`DescribeDatasetGroupInput`](crate::input::DescribeDatasetGroupInput)
pub mod describe_dataset_group_input {
    /// A builder for [`DescribeDatasetGroupInput`](crate::input::DescribeDatasetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetGroupInput`](crate::input::DescribeDatasetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetGroupInput {
                dataset_group_arn: self.dataset_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetGroupInputOperationOutputAlias = crate::operation::DescribeDatasetGroup;
#[doc(hidden)]
pub type DescribeDatasetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDatasetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDatasetGroup`](crate::operation::DescribeDatasetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDatasetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDatasetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDatasetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDatasetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeDatasetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_dataset_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDatasetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDatasetGroup",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetGroupInput`](crate::input::DescribeDatasetGroupInput)
    pub fn builder() -> crate::input::describe_dataset_group_input::Builder {
        crate::input::describe_dataset_group_input::Builder::default()
    }
}

/// See [`DescribeDatasetImportJobInput`](crate::input::DescribeDatasetImportJobInput)
pub mod describe_dataset_import_job_input {
    /// A builder for [`DescribeDatasetImportJobInput`](crate::input::DescribeDatasetImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_import_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>
        pub fn dataset_import_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_import_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>
        pub fn set_dataset_import_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_import_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetImportJobInput`](crate::input::DescribeDatasetImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetImportJobInput {
                dataset_import_job_arn: self.dataset_import_job_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetImportJobInputOperationOutputAlias =
    crate::operation::DescribeDatasetImportJob;
#[doc(hidden)]
pub type DescribeDatasetImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDatasetImportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDatasetImportJob`](crate::operation::DescribeDatasetImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDatasetImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDatasetImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDatasetImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDatasetImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeDatasetImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_dataset_import_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDatasetImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDatasetImportJob",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetImportJobInput`](crate::input::DescribeDatasetImportJobInput)
    pub fn builder() -> crate::input::describe_dataset_import_job_input::Builder {
        crate::input::describe_dataset_import_job_input::Builder::default()
    }
}

/// See [`DescribeEventTrackerInput`](crate::input::DescribeEventTrackerInput)
pub mod describe_event_tracker_input {
    /// A builder for [`DescribeEventTrackerInput`](crate::input::DescribeEventTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_tracker_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>
        pub fn event_tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_tracker_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>
        pub fn set_event_tracker_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_tracker_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventTrackerInput`](crate::input::DescribeEventTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventTrackerInput {
                event_tracker_arn: self.event_tracker_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventTrackerInputOperationOutputAlias = crate::operation::DescribeEventTracker;
#[doc(hidden)]
pub type DescribeEventTrackerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventTrackerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventTracker`](crate::operation::DescribeEventTracker)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventTracker,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventTrackerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventTrackerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventTrackerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeEventTracker",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_tracker(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventTracker",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventTrackerInput`](crate::input::DescribeEventTrackerInput)
    pub fn builder() -> crate::input::describe_event_tracker_input::Builder {
        crate::input::describe_event_tracker_input::Builder::default()
    }
}

/// See [`DescribeFeatureTransformationInput`](crate::input::DescribeFeatureTransformationInput)
pub mod describe_feature_transformation_input {
    /// A builder for [`DescribeFeatureTransformationInput`](crate::input::DescribeFeatureTransformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_transformation_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>
        pub fn feature_transformation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_transformation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>
        pub fn set_feature_transformation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_transformation_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFeatureTransformationInput`](crate::input::DescribeFeatureTransformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFeatureTransformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFeatureTransformationInput {
                feature_transformation_arn: self.feature_transformation_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFeatureTransformationInputOperationOutputAlias =
    crate::operation::DescribeFeatureTransformation;
#[doc(hidden)]
pub type DescribeFeatureTransformationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFeatureTransformationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFeatureTransformation`](crate::operation::DescribeFeatureTransformation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFeatureTransformation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFeatureTransformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFeatureTransformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFeatureTransformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeFeatureTransformation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_feature_transformation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFeatureTransformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFeatureTransformation",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFeatureTransformationInput`](crate::input::DescribeFeatureTransformationInput)
    pub fn builder() -> crate::input::describe_feature_transformation_input::Builder {
        crate::input::describe_feature_transformation_input::Builder::default()
    }
}

/// See [`DescribeFilterInput`](crate::input::DescribeFilterInput)
pub mod describe_filter_input {
    /// A builder for [`DescribeFilterInput`](crate::input::DescribeFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the filter to describe.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the filter to describe.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFilterInput`](crate::input::DescribeFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFilterInput {
                filter_arn: self.filter_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFilterInputOperationOutputAlias = crate::operation::DescribeFilter;
#[doc(hidden)]
pub type DescribeFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFilterInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFilter`](crate::operation::DescribeFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeFilter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFilter",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFilterInput`](crate::input::DescribeFilterInput)
    pub fn builder() -> crate::input::describe_filter_input::Builder {
        crate::input::describe_filter_input::Builder::default()
    }
}

/// See [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
pub mod describe_recipe_input {
    /// A builder for [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the recipe to describe.</p>
        pub fn recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recipe to describe.</p>
        pub fn set_recipe_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecipeInput {
                recipe_arn: self.recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecipeInputOperationOutputAlias = crate::operation::DescribeRecipe;
#[doc(hidden)]
pub type DescribeRecipeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRecipeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecipe`](crate::operation::DescribeRecipe)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecipe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecipeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecipeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecipeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeRecipe",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_recipe(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecipe",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
    pub fn builder() -> crate::input::describe_recipe_input::Builder {
        crate::input::describe_recipe_input::Builder::default()
    }
}

/// See [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
pub mod describe_schema_input {
    /// A builder for [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSchemaInput {
                schema_arn: self.schema_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSchemaInputOperationOutputAlias = crate::operation::DescribeSchema;
#[doc(hidden)]
pub type DescribeSchemaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSchemaInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSchema`](crate::operation::DescribeSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSchema,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeSchema",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSchema",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
    pub fn builder() -> crate::input::describe_schema_input::Builder {
        crate::input::describe_schema_input::Builder::default()
    }
}

/// See [`DescribeSolutionInput`](crate::input::DescribeSolutionInput)
pub mod describe_solution_input {
    /// A builder for [`DescribeSolutionInput`](crate::input::DescribeSolutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution to describe.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution to describe.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSolutionInput`](crate::input::DescribeSolutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSolutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSolutionInput {
                solution_arn: self.solution_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSolutionInputOperationOutputAlias = crate::operation::DescribeSolution;
#[doc(hidden)]
pub type DescribeSolutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSolutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSolution`](crate::operation::DescribeSolution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSolution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSolutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSolutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSolutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeSolution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_solution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSolution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSolution",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSolutionInput`](crate::input::DescribeSolutionInput)
    pub fn builder() -> crate::input::describe_solution_input::Builder {
        crate::input::describe_solution_input::Builder::default()
    }
}

/// See [`DescribeSolutionVersionInput`](crate::input::DescribeSolutionVersionInput)
pub mod describe_solution_version_input {
    /// A builder for [`DescribeSolutionVersionInput`](crate::input::DescribeSolutionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSolutionVersionInput`](crate::input::DescribeSolutionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSolutionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSolutionVersionInput {
                solution_version_arn: self.solution_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSolutionVersionInputOperationOutputAlias =
    crate::operation::DescribeSolutionVersion;
#[doc(hidden)]
pub type DescribeSolutionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSolutionVersionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSolutionVersion`](crate::operation::DescribeSolutionVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSolutionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSolutionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSolutionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSolutionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.DescribeSolutionVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_solution_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSolutionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSolutionVersion",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSolutionVersionInput`](crate::input::DescribeSolutionVersionInput)
    pub fn builder() -> crate::input::describe_solution_version_input::Builder {
        crate::input::describe_solution_version_input::Builder::default()
    }
}

/// See [`GetSolutionMetricsInput`](crate::input::GetSolutionMetricsInput)
pub mod get_solution_metrics_input {
    /// A builder for [`GetSolutionMetricsInput`](crate::input::GetSolutionMetricsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSolutionMetricsInput`](crate::input::GetSolutionMetricsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSolutionMetricsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSolutionMetricsInput {
                solution_version_arn: self.solution_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSolutionMetricsInputOperationOutputAlias = crate::operation::GetSolutionMetrics;
#[doc(hidden)]
pub type GetSolutionMetricsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSolutionMetricsInput {
    /// Consumes the builder and constructs an Operation<[`GetSolutionMetrics`](crate::operation::GetSolutionMetrics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSolutionMetrics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSolutionMetricsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSolutionMetricsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSolutionMetricsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.GetSolutionMetrics",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_solution_metrics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSolutionMetrics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSolutionMetrics",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSolutionMetricsInput`](crate::input::GetSolutionMetricsInput)
    pub fn builder() -> crate::input::get_solution_metrics_input::Builder {
        crate::input::get_solution_metrics_input::Builder::default()
    }
}

/// See [`ListBatchInferenceJobsInput`](crate::input::ListBatchInferenceJobsInput)
pub mod list_batch_inference_jobs_input {
    /// A builder for [`ListBatchInferenceJobsInput`](crate::input::ListBatchInferenceJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs
        /// were created.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs
        /// were created.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of batch inference job results to return in each page. The default
        /// value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of batch inference job results to return in each page. The default
        /// value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBatchInferenceJobsInput`](crate::input::ListBatchInferenceJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBatchInferenceJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBatchInferenceJobsInput {
                solution_version_arn: self.solution_version_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBatchInferenceJobsInputOperationOutputAlias = crate::operation::ListBatchInferenceJobs;
#[doc(hidden)]
pub type ListBatchInferenceJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBatchInferenceJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListBatchInferenceJobs`](crate::operation::ListBatchInferenceJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBatchInferenceJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBatchInferenceJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBatchInferenceJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBatchInferenceJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListBatchInferenceJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_batch_inference_jobs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBatchInferenceJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBatchInferenceJobs",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBatchInferenceJobsInput`](crate::input::ListBatchInferenceJobsInput)
    pub fn builder() -> crate::input::list_batch_inference_jobs_input::Builder {
        crate::input::list_batch_inference_jobs_input::Builder::default()
    }
}

/// See [`ListCampaignsInput`](crate::input::ListCampaignsInput)
pub mod list_campaigns_input {
    /// A builder for [`ListCampaignsInput`](crate::input::ListCampaignsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When
        /// a solution is not specified, all the campaigns associated with the account are listed.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When
        /// a solution is not specified, all the campaigns associated with the account are listed.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListCampaigns</code> for getting
        /// the next set of campaigns (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListCampaigns</code> for getting
        /// the next set of campaigns (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of campaigns to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of campaigns to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCampaignsInput`](crate::input::ListCampaignsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCampaignsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCampaignsInput {
                solution_arn: self.solution_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCampaignsInputOperationOutputAlias = crate::operation::ListCampaigns;
#[doc(hidden)]
pub type ListCampaignsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCampaignsInput {
    /// Consumes the builder and constructs an Operation<[`ListCampaigns`](crate::operation::ListCampaigns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCampaigns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCampaignsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCampaignsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCampaignsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListCampaigns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_campaigns(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCampaigns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCampaigns",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCampaignsInput`](crate::input::ListCampaignsInput)
    pub fn builder() -> crate::input::list_campaigns_input::Builder {
        crate::input::list_campaigns_input::Builder::default()
    }
}

/// See [`ListDatasetExportJobsInput`](crate::input::ListDatasetExportJobsInput)
pub mod list_dataset_export_jobs_input {
    /// A builder for [`ListDatasetExportJobsInput`](crate::input::ListDatasetExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting
        /// the next set of dataset export jobs (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting
        /// the next set of dataset export jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of dataset export jobs to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of dataset export jobs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetExportJobsInput`](crate::input::ListDatasetExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetExportJobsInput {
                dataset_arn: self.dataset_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetExportJobsInputOperationOutputAlias = crate::operation::ListDatasetExportJobs;
#[doc(hidden)]
pub type ListDatasetExportJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatasetExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasetExportJobs`](crate::operation::ListDatasetExportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasetExportJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatasetExportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatasetExportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatasetExportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListDatasetExportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_dataset_export_jobs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasetExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasetExportJobs",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetExportJobsInput`](crate::input::ListDatasetExportJobsInput)
    pub fn builder() -> crate::input::list_dataset_export_jobs_input::Builder {
        crate::input::list_dataset_export_jobs_input::Builder::default()
    }
}

/// See [`ListDatasetGroupsInput`](crate::input::ListDatasetGroupsInput)
pub mod list_dataset_groups_input {
    /// A builder for [`ListDatasetGroupsInput`](crate::input::ListDatasetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the
        /// next set of dataset groups (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the
        /// next set of dataset groups (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of dataset groups to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of dataset groups to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetGroupsInput`](crate::input::ListDatasetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetGroupsInputOperationOutputAlias = crate::operation::ListDatasetGroups;
#[doc(hidden)]
pub type ListDatasetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatasetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasetGroups`](crate::operation::ListDatasetGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatasetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatasetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatasetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListDatasetGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_dataset_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasetGroups",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetGroupsInput`](crate::input::ListDatasetGroupsInput)
    pub fn builder() -> crate::input::list_dataset_groups_input::Builder {
        crate::input::list_dataset_groups_input::Builder::default()
    }
}

/// See [`ListDatasetImportJobsInput`](crate::input::ListDatasetImportJobsInput)
pub mod list_dataset_import_jobs_input {
    /// A builder for [`ListDatasetImportJobsInput`](crate::input::ListDatasetImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of dataset import jobs to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of dataset import jobs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetImportJobsInput`](crate::input::ListDatasetImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetImportJobsInput {
                dataset_arn: self.dataset_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetImportJobsInputOperationOutputAlias = crate::operation::ListDatasetImportJobs;
#[doc(hidden)]
pub type ListDatasetImportJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatasetImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasetImportJobs`](crate::operation::ListDatasetImportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasetImportJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatasetImportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatasetImportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatasetImportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListDatasetImportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_dataset_import_jobs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasetImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasetImportJobs",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetImportJobsInput`](crate::input::ListDatasetImportJobsInput)
    pub fn builder() -> crate::input::list_dataset_import_jobs_input::Builder {
        crate::input::list_dataset_import_jobs_input::Builder::default()
    }
}

/// See [`ListDatasetsInput`](crate::input::ListDatasetsInput)
pub mod list_datasets_input {
    /// A builder for [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to
        /// list.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to
        /// list.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
        /// the next set of dataset import jobs (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of datasets to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of datasets to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsInput`](crate::input::ListDatasetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetsInput {
                dataset_group_arn: self.dataset_group_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetsInputOperationOutputAlias = crate::operation::ListDatasets;
#[doc(hidden)]
pub type ListDatasetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatasetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasets`](crate::operation::ListDatasets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatasetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatasetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatasetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListDatasets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_datasets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasets",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
}

/// See [`ListEventTrackersInput`](crate::input::ListEventTrackersInput)
pub mod list_event_trackers_input {
    /// A builder for [`ListEventTrackersInput`](crate::input::ListEventTrackersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of a dataset group used to filter the response.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a dataset group used to filter the response.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListEventTrackers</code> for getting
        /// the next set of event trackers (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListEventTrackers</code> for getting
        /// the next set of event trackers (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of event trackers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of event trackers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventTrackersInput`](crate::input::ListEventTrackersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventTrackersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventTrackersInput {
                dataset_group_arn: self.dataset_group_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventTrackersInputOperationOutputAlias = crate::operation::ListEventTrackers;
#[doc(hidden)]
pub type ListEventTrackersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEventTrackersInput {
    /// Consumes the builder and constructs an Operation<[`ListEventTrackers`](crate::operation::ListEventTrackers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventTrackers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventTrackersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventTrackersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventTrackersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListEventTrackers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_event_trackers(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventTrackers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventTrackers",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventTrackersInput`](crate::input::ListEventTrackersInput)
    pub fn builder() -> crate::input::list_event_trackers_input::Builder {
        crate::input::list_event_trackers_input::Builder::default()
    }
}

/// See [`ListFiltersInput`](crate::input::ListFiltersInput)
pub mod list_filters_input {
    /// A builder for [`ListFiltersInput`](crate::input::ListFiltersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the dataset group that contains the filters.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset group that contains the filters.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListFilters</code> for getting the
        /// next set of filters (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListFilters</code> for getting the
        /// next set of filters (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of filters to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of filters to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFiltersInput`](crate::input::ListFiltersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFiltersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFiltersInput {
                dataset_group_arn: self.dataset_group_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFiltersInputOperationOutputAlias = crate::operation::ListFilters;
#[doc(hidden)]
pub type ListFiltersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFiltersInput {
    /// Consumes the builder and constructs an Operation<[`ListFilters`](crate::operation::ListFilters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFilters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFiltersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFiltersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFiltersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListFilters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_filters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFilters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFilters",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFiltersInput`](crate::input::ListFiltersInput)
    pub fn builder() -> crate::input::list_filters_input::Builder {
        crate::input::list_filters_input::Builder::default()
    }
}

/// See [`ListRecipesInput`](crate::input::ListRecipesInput)
pub mod list_recipes_input {
    /// A builder for [`ListRecipesInput`](crate::input::ListRecipesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipe_provider: std::option::Option<crate::model::RecipeProvider>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The default is <code>SERVICE</code>.</p>
        pub fn recipe_provider(mut self, input: crate::model::RecipeProvider) -> Self {
            self.recipe_provider = Some(input);
            self
        }
        /// <p>The default is <code>SERVICE</code>.</p>
        pub fn set_recipe_provider(
            mut self,
            input: std::option::Option<crate::model::RecipeProvider>,
        ) -> Self {
            self.recipe_provider = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListRecipes</code> for getting
        /// the next set of recipes (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListRecipes</code> for getting
        /// the next set of recipes (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of recipes to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of recipes to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecipesInput`](crate::input::ListRecipesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecipesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecipesInput {
                recipe_provider: self.recipe_provider,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecipesInputOperationOutputAlias = crate::operation::ListRecipes;
#[doc(hidden)]
pub type ListRecipesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecipesInput {
    /// Consumes the builder and constructs an Operation<[`ListRecipes`](crate::operation::ListRecipes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecipes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecipesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecipesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecipesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListRecipes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_recipes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecipes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecipes",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecipesInput`](crate::input::ListRecipesInput)
    pub fn builder() -> crate::input::list_recipes_input::Builder {
        crate::input::list_recipes_input::Builder::default()
    }
}

/// See [`ListSchemasInput`](crate::input::ListSchemasInput)
pub mod list_schemas_input {
    /// A builder for [`ListSchemasInput`](crate::input::ListSchemasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from the previous call to <code>ListSchemas</code> for getting
        /// the next set of schemas (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListSchemas</code> for getting
        /// the next set of schemas (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of schemas to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of schemas to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasInput`](crate::input::ListSchemasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSchemasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSchemasInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSchemasInputOperationOutputAlias = crate::operation::ListSchemas;
#[doc(hidden)]
pub type ListSchemasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSchemasInput {
    /// Consumes the builder and constructs an Operation<[`ListSchemas`](crate::operation::ListSchemas)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSchemas,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSchemasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSchemasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSchemasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListSchemas",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_schemas(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSchemas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSchemas",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSchemasInput`](crate::input::ListSchemasInput)
    pub fn builder() -> crate::input::list_schemas_input::Builder {
        crate::input::list_schemas_input::Builder::default()
    }
}

/// See [`ListSolutionsInput`](crate::input::ListSolutionsInput)
pub mod list_solutions_input {
    /// A builder for [`ListSolutionsInput`](crate::input::ListSolutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_group_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn dataset_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
        pub fn set_dataset_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataset_group_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutions</code> for getting
        /// the next set of solutions (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutions</code> for getting
        /// the next set of solutions (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of solutions to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of solutions to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSolutionsInput`](crate::input::ListSolutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSolutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSolutionsInput {
                dataset_group_arn: self.dataset_group_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSolutionsInputOperationOutputAlias = crate::operation::ListSolutions;
#[doc(hidden)]
pub type ListSolutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSolutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSolutions`](crate::operation::ListSolutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSolutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSolutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSolutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSolutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListSolutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_solutions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSolutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSolutions",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSolutionsInput`](crate::input::ListSolutionsInput)
    pub fn builder() -> crate::input::list_solutions_input::Builder {
        crate::input::list_solutions_input::Builder::default()
    }
}

/// See [`ListSolutionVersionsInput`](crate::input::ListSolutionVersionsInput)
pub mod list_solution_versions_input {
    /// A builder for [`ListSolutionVersionsInput`](crate::input::ListSolutionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution.</p>
        pub fn solution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution.</p>
        pub fn set_solution_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.solution_arn = input;
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting
        /// the next set of solution versions (if they exist).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting
        /// the next set of solution versions (if they exist).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of solution versions to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of solution versions to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSolutionVersionsInput`](crate::input::ListSolutionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSolutionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSolutionVersionsInput {
                solution_arn: self.solution_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSolutionVersionsInputOperationOutputAlias = crate::operation::ListSolutionVersions;
#[doc(hidden)]
pub type ListSolutionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSolutionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSolutionVersions`](crate::operation::ListSolutionVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSolutionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSolutionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSolutionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSolutionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.ListSolutionVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_solution_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSolutionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSolutionVersions",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSolutionVersionsInput`](crate::input::ListSolutionVersionsInput)
    pub fn builder() -> crate::input::list_solution_versions_input::Builder {
        crate::input::list_solution_versions_input::Builder::default()
    }
}

/// See [`StopSolutionVersionCreationInput`](crate::input::StopSolutionVersionCreationInput)
pub mod stop_solution_version_creation_input {
    /// A builder for [`StopSolutionVersionCreationInput`](crate::input::StopSolutionVersionCreationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopSolutionVersionCreationInput`](crate::input::StopSolutionVersionCreationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopSolutionVersionCreationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopSolutionVersionCreationInput {
                solution_version_arn: self.solution_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StopSolutionVersionCreationInputOperationOutputAlias =
    crate::operation::StopSolutionVersionCreation;
#[doc(hidden)]
pub type StopSolutionVersionCreationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopSolutionVersionCreationInput {
    /// Consumes the builder and constructs an Operation<[`StopSolutionVersionCreation`](crate::operation::StopSolutionVersionCreation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopSolutionVersionCreation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopSolutionVersionCreationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopSolutionVersionCreationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopSolutionVersionCreationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.StopSolutionVersionCreation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_solution_version_creation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopSolutionVersionCreation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopSolutionVersionCreation",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopSolutionVersionCreationInput`](crate::input::StopSolutionVersionCreationInput)
    pub fn builder() -> crate::input::stop_solution_version_creation_input::Builder {
        crate::input::stop_solution_version_creation_input::Builder::default()
    }
}

/// See [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
pub mod update_campaign_input {
    /// A builder for [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_arn: std::option::Option<std::string::String>,
        pub(crate) solution_version_arn: std::option::Option<std::string::String>,
        pub(crate) min_provisioned_tps: std::option::Option<i32>,
        pub(crate) campaign_config: std::option::Option<crate::model::CampaignConfig>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn campaign_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
        pub fn set_campaign_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_arn = input;
            self
        }
        /// <p>The ARN of a new solution version to deploy.</p>
        pub fn solution_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a new solution version to deploy.</p>
        pub fn set_solution_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_version_arn = input;
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn min_provisioned_tps(mut self, input: i32) -> Self {
            self.min_provisioned_tps = Some(input);
            self
        }
        /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
        /// Amazon Personalize will support.</p>
        pub fn set_min_provisioned_tps(mut self, input: std::option::Option<i32>) -> Self {
            self.min_provisioned_tps = input;
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn campaign_config(mut self, input: crate::model::CampaignConfig) -> Self {
            self.campaign_config = Some(input);
            self
        }
        /// <p>The configuration details of a campaign.</p>
        pub fn set_campaign_config(
            mut self,
            input: std::option::Option<crate::model::CampaignConfig>,
        ) -> Self {
            self.campaign_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCampaignInput {
                campaign_arn: self.campaign_arn,
                solution_version_arn: self.solution_version_arn,
                min_provisioned_tps: self.min_provisioned_tps,
                campaign_config: self.campaign_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCampaignInputOperationOutputAlias = crate::operation::UpdateCampaign;
#[doc(hidden)]
pub type UpdateCampaignInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCampaignInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCampaign`](crate::operation::UpdateCampaign)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCampaign,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCampaignInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCampaignInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCampaignInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonPersonalize.UpdateCampaign",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_campaign(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCampaign",
            "personalize",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCampaignInput`](crate::input::UpdateCampaignInput)
    pub fn builder() -> crate::input::update_campaign_input::Builder {
        crate::input::update_campaign_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCampaignInput {
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub campaign_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of a new solution version to deploy.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
    /// Amazon Personalize will support.</p>
    pub min_provisioned_tps: std::option::Option<i32>,
    /// <p>The configuration details of a campaign.</p>
    pub campaign_config: std::option::Option<crate::model::CampaignConfig>,
}
impl UpdateCampaignInput {
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
    /// <p>The ARN of a new solution version to deploy.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
    /// Amazon Personalize will support.</p>
    pub fn min_provisioned_tps(&self) -> std::option::Option<i32> {
        self.min_provisioned_tps
    }
    /// <p>The configuration details of a campaign.</p>
    pub fn campaign_config(&self) -> std::option::Option<&crate::model::CampaignConfig> {
        self.campaign_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateCampaignInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCampaignInput");
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("min_provisioned_tps", &self.min_provisioned_tps);
        formatter.field("campaign_config", &self.campaign_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopSolutionVersionCreationInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
}
impl StopSolutionVersionCreationInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
}
impl std::fmt::Debug for StopSolutionVersionCreationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopSolutionVersionCreationInput");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSolutionVersionsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution.</p>
    pub solution_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting
    /// the next set of solution versions (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of solution versions to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListSolutionVersionsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting
    /// the next set of solution versions (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of solution versions to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListSolutionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSolutionVersionsInput");
        formatter.field("solution_arn", &self.solution_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSolutionsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListSolutions</code> for getting
    /// the next set of solutions (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of solutions to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListSolutionsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListSolutions</code> for getting
    /// the next set of solutions (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of solutions to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListSolutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSolutionsInput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasInput {
    /// <p>A token returned from the previous call to <code>ListSchemas</code> for getting
    /// the next set of schemas (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of schemas to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListSchemasInput {
    /// <p>A token returned from the previous call to <code>ListSchemas</code> for getting
    /// the next set of schemas (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of schemas to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListSchemasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecipesInput {
    /// <p>The default is <code>SERVICE</code>.</p>
    pub recipe_provider: std::option::Option<crate::model::RecipeProvider>,
    /// <p>A token returned from the previous call to <code>ListRecipes</code> for getting
    /// the next set of recipes (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of recipes to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRecipesInput {
    /// <p>The default is <code>SERVICE</code>.</p>
    pub fn recipe_provider(&self) -> std::option::Option<&crate::model::RecipeProvider> {
        self.recipe_provider.as_ref()
    }
    /// <p>A token returned from the previous call to <code>ListRecipes</code> for getting
    /// the next set of recipes (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of recipes to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRecipesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecipesInput");
        formatter.field("recipe_provider", &self.recipe_provider);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFiltersInput {
    /// <p>The ARN of the dataset group that contains the filters.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListFilters</code> for getting the
    /// next set of filters (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of filters to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFiltersInput {
    /// <p>The ARN of the dataset group that contains the filters.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListFilters</code> for getting the
    /// next set of filters (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of filters to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFiltersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFiltersInput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventTrackersInput {
    /// <p>The ARN of a dataset group used to filter the response.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListEventTrackers</code> for getting
    /// the next set of event trackers (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of event trackers to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEventTrackersInput {
    /// <p>The ARN of a dataset group used to filter the response.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListEventTrackers</code> for getting
    /// the next set of event trackers (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of event trackers to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEventTrackersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventTrackersInput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to
    /// list.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
    /// the next set of dataset import jobs (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of datasets to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDatasetsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to
    /// list.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
    /// the next set of dataset import jobs (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of datasets to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatasetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsInput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetImportJobsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
    /// the next set of dataset import jobs (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of dataset import jobs to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDatasetImportJobsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting
    /// the next set of dataset import jobs (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of dataset import jobs to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatasetImportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetImportJobsInput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetGroupsInput {
    /// <p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the
    /// next set of dataset groups (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of dataset groups to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDatasetGroupsInput {
    /// <p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the
    /// next set of dataset groups (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of dataset groups to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatasetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetExportJobsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting
    /// the next set of dataset export jobs (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of dataset export jobs to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDatasetExportJobsInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting
    /// the next set of dataset export jobs (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of dataset export jobs to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatasetExportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetExportJobsInput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCampaignsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When
    /// a solution is not specified, all the campaigns associated with the account are listed.</p>
    pub solution_arn: std::option::Option<std::string::String>,
    /// <p>A token returned from the previous call to <code>ListCampaigns</code> for getting
    /// the next set of campaigns (if they exist).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of campaigns to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListCampaignsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When
    /// a solution is not specified, all the campaigns associated with the account are listed.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
    /// <p>A token returned from the previous call to <code>ListCampaigns</code> for getting
    /// the next set of campaigns (if they exist).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of campaigns to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListCampaignsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCampaignsInput");
        formatter.field("solution_arn", &self.solution_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBatchInferenceJobsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs
    /// were created.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of batch inference job results to return in each page. The default
    /// value is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListBatchInferenceJobsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs
    /// were created.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of batch inference job results to return in each page. The default
    /// value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListBatchInferenceJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBatchInferenceJobsInput");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSolutionMetricsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
}
impl GetSolutionMetricsInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
}
impl std::fmt::Debug for GetSolutionMetricsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSolutionMetricsInput");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSolutionVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
}
impl DescribeSolutionVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the solution version.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSolutionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSolutionVersionInput");
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSolutionInput {
    /// <p>The Amazon Resource Name (ARN) of the solution to describe.</p>
    pub solution_arn: std::option::Option<std::string::String>,
}
impl DescribeSolutionInput {
    /// <p>The Amazon Resource Name (ARN) of the solution to describe.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSolutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSolutionInput");
        formatter.field("solution_arn", &self.solution_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl DescribeSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSchemaInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the recipe to describe.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
}
impl DescribeRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the recipe to describe.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecipeInput");
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFilterInput {
    /// <p>The ARN of the filter to describe.</p>
    pub filter_arn: std::option::Option<std::string::String>,
}
impl DescribeFilterInput {
    /// <p>The ARN of the filter to describe.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFilterInput");
        formatter.field("filter_arn", &self.filter_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFeatureTransformationInput {
    /// <p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>
    pub feature_transformation_arn: std::option::Option<std::string::String>,
}
impl DescribeFeatureTransformationInput {
    /// <p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>
    pub fn feature_transformation_arn(&self) -> std::option::Option<&str> {
        self.feature_transformation_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeFeatureTransformationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFeatureTransformationInput");
        formatter.field(
            "feature_transformation_arn",
            &self.feature_transformation_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventTrackerInput {
    /// <p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>
    pub event_tracker_arn: std::option::Option<std::string::String>,
}
impl DescribeEventTrackerInput {
    /// <p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>
    pub fn event_tracker_arn(&self) -> std::option::Option<&str> {
        self.event_tracker_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventTrackerInput");
        formatter.field("event_tracker_arn", &self.event_tracker_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetImportJobInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>
    pub dataset_import_job_arn: std::option::Option<std::string::String>,
}
impl DescribeDatasetImportJobInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>
    pub fn dataset_import_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_import_job_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetImportJobInput");
        formatter.field("dataset_import_job_arn", &self.dataset_import_job_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
}
impl DescribeDatasetGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetGroupInput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetExportJobInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>
    pub dataset_export_job_arn: std::option::Option<std::string::String>,
}
impl DescribeDatasetExportJobInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>
    pub fn dataset_export_job_arn(&self) -> std::option::Option<&str> {
        self.dataset_export_job_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetExportJobInput");
        formatter.field("dataset_export_job_arn", &self.dataset_export_job_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to describe.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
}
impl DescribeDatasetInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to describe.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetInput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCampaignInput {
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub campaign_arn: std::option::Option<std::string::String>,
}
impl DescribeCampaignInput {
    /// <p>The Amazon Resource Name (ARN) of the campaign.</p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCampaignInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCampaignInput");
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBatchInferenceJobInput {
    /// <p>The ARN of the batch inference job to describe.</p>
    pub batch_inference_job_arn: std::option::Option<std::string::String>,
}
impl DescribeBatchInferenceJobInput {
    /// <p>The ARN of the batch inference job to describe.</p>
    pub fn batch_inference_job_arn(&self) -> std::option::Option<&str> {
        self.batch_inference_job_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeBatchInferenceJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBatchInferenceJobInput");
        formatter.field("batch_inference_job_arn", &self.batch_inference_job_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlgorithmInput {
    /// <p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>
    pub algorithm_arn: std::option::Option<std::string::String>,
}
impl DescribeAlgorithmInput {
    /// <p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>
    pub fn algorithm_arn(&self) -> std::option::Option<&str> {
        self.algorithm_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAlgorithmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlgorithmInput");
        formatter.field("algorithm_arn", &self.algorithm_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSolutionInput {
    /// <p>The ARN of the solution to delete.</p>
    pub solution_arn: std::option::Option<std::string::String>,
}
impl DeleteSolutionInput {
    /// <p>The ARN of the solution to delete.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSolutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSolutionInput");
        formatter.field("solution_arn", &self.solution_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the schema to delete.</p>
    pub schema_arn: std::option::Option<std::string::String>,
}
impl DeleteSchemaInput {
    /// <p>The Amazon Resource Name (ARN) of the schema to delete.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaInput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFilterInput {
    /// <p>The ARN of the filter to delete.</p>
    pub filter_arn: std::option::Option<std::string::String>,
}
impl DeleteFilterInput {
    /// <p>The ARN of the filter to delete.</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFilterInput");
        formatter.field("filter_arn", &self.filter_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventTrackerInput {
    /// <p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>
    pub event_tracker_arn: std::option::Option<std::string::String>,
}
impl DeleteEventTrackerInput {
    /// <p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>
    pub fn event_tracker_arn(&self) -> std::option::Option<&str> {
        self.event_tracker_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventTrackerInput");
        formatter.field("event_tracker_arn", &self.event_tracker_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetGroupInput {
    /// <p>The ARN of the dataset group to delete.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
}
impl DeleteDatasetGroupInput {
    /// <p>The ARN of the dataset group to delete.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetGroupInput");
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
}
impl DeleteDatasetInput {
    /// <p>The Amazon Resource Name (ARN) of the dataset to delete.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetInput");
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCampaignInput {
    /// <p>The Amazon Resource Name (ARN) of the campaign to delete.</p>
    pub campaign_arn: std::option::Option<std::string::String>,
}
impl DeleteCampaignInput {
    /// <p>The Amazon Resource Name (ARN) of the campaign to delete.</p>
    pub fn campaign_arn(&self) -> std::option::Option<&str> {
        self.campaign_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCampaignInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCampaignInput");
        formatter.field("campaign_arn", &self.campaign_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSolutionVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the solution containing the training configuration
    /// information.</p>
    pub solution_arn: std::option::Option<std::string::String>,
    /// <p>The scope of training to be performed when creating the solution version. The
    /// <code>FULL</code> option trains the solution version based on the entirety of the input
    /// solution's training data, while the <code>UPDATE</code> option processes only the data that
    /// has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to
    /// incrementally update your solution version instead of creating an entirely new one.</p>
    /// <important>
    /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution
    /// version created from the input solution using the <code>FULL</code> option and the input
    /// solution was trained with the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>
    /// recipe or the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
    /// </important>
    pub training_mode: std::option::Option<crate::model::TrainingMode>,
}
impl CreateSolutionVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the solution containing the training configuration
    /// information.</p>
    pub fn solution_arn(&self) -> std::option::Option<&str> {
        self.solution_arn.as_deref()
    }
    /// <p>The scope of training to be performed when creating the solution version. The
    /// <code>FULL</code> option trains the solution version based on the entirety of the input
    /// solution's training data, while the <code>UPDATE</code> option processes only the data that
    /// has changed in comparison to the input solution. Choose <code>UPDATE</code> when you want to
    /// incrementally update your solution version instead of creating an entirely new one.</p>
    /// <important>
    /// <p>The <code>UPDATE</code> option can only be used when you already have an active solution
    /// version created from the input solution using the <code>FULL</code> option and the input
    /// solution was trained with the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>
    /// recipe or the
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>
    /// </important>
    pub fn training_mode(&self) -> std::option::Option<&crate::model::TrainingMode> {
        self.training_mode.as_ref()
    }
}
impl std::fmt::Debug for CreateSolutionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSolutionVersionInput");
        formatter.field("solution_arn", &self.solution_arn);
        formatter.field("training_mode", &self.training_mode);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSolutionInput {
    /// <p>The name for the solution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe.
    /// The default is <code>false</code>.</p>
    /// <p>When performing AutoML, this parameter is always <code>true</code> and you
    /// should not set it to <code>false</code>.</p>
    pub perform_hpo: std::option::Option<bool>,
    /// <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>.
    /// For this case, you must specify <code>recipeArn</code>.</p>
    /// <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects
    /// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit
    /// <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with
    /// different values for the hyperparameters.
    /// AutoML lengthens the training process as compared to selecting a specific recipe.</p>
    pub perform_auto_ml: bool,
    /// <p>The ARN of the recipe to use for model training. Only specified when
    /// <code>performAutoML</code> is false.</p>
    pub recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field),
    /// this parameter specifies which event type (for example, 'click' or 'like') is used for
    /// training the model.</p>
    /// <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
    /// equal weight regardless of type.</p>
    pub event_type: std::option::Option<std::string::String>,
    /// <p>The configuration to use with the solution. When <code>performAutoML</code> is set to
    /// true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section
    /// of the solution configuration.</p>
    /// <note>
    /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
    /// at this time.</p>
    /// </note>
    pub solution_config: std::option::Option<crate::model::SolutionConfig>,
}
impl CreateSolutionInput {
    /// <p>The name for the solution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe.
    /// The default is <code>false</code>.</p>
    /// <p>When performing AutoML, this parameter is always <code>true</code> and you
    /// should not set it to <code>false</code>.</p>
    pub fn perform_hpo(&self) -> std::option::Option<bool> {
        self.perform_hpo
    }
    /// <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>.
    /// For this case, you must specify <code>recipeArn</code>.</p>
    /// <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects
    /// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit
    /// <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with
    /// different values for the hyperparameters.
    /// AutoML lengthens the training process as compared to selecting a specific recipe.</p>
    pub fn perform_auto_ml(&self) -> bool {
        self.perform_auto_ml
    }
    /// <p>The ARN of the recipe to use for model training. Only specified when
    /// <code>performAutoML</code> is false.</p>
    pub fn recipe_arn(&self) -> std::option::Option<&str> {
        self.recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field),
    /// this parameter specifies which event type (for example, 'click' or 'like') is used for
    /// training the model.</p>
    /// <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with
    /// equal weight regardless of type.</p>
    pub fn event_type(&self) -> std::option::Option<&str> {
        self.event_type.as_deref()
    }
    /// <p>The configuration to use with the solution. When <code>performAutoML</code> is set to
    /// true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section
    /// of the solution configuration.</p>
    /// <note>
    /// <p>Amazon Personalize doesn't support configuring the <code>hpoObjective</code>
    /// at this time.</p>
    /// </note>
    pub fn solution_config(&self) -> std::option::Option<&crate::model::SolutionConfig> {
        self.solution_config.as_ref()
    }
}
impl std::fmt::Debug for CreateSolutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSolutionInput");
        formatter.field("name", &self.name);
        formatter.field("perform_hpo", &self.perform_hpo);
        formatter.field("perform_auto_ml", &self.perform_auto_ml);
        formatter.field("recipe_arn", &self.recipe_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("event_type", &self.event_type);
        formatter.field("solution_config", &self.solution_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaInput {
    /// <p>The name for the schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A schema in Avro JSON format.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl CreateSchemaInput {
    /// <p>The name for the schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A schema in Avro JSON format.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for CreateSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaInput");
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFilterInput {
    /// <p>The name of the filter to create.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset group that the filter will belong to.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules.
    /// For information about filter expression structure and syntax, see
    /// <a>filter-expressions</a>.</p>
    pub filter_expression: std::option::Option<std::string::String>,
}
impl CreateFilterInput {
    /// <p>The name of the filter to create.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the dataset group that the filter will belong to.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules.
    /// For information about filter expression structure and syntax, see
    /// <a>filter-expressions</a>.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
}
impl std::fmt::Debug for CreateFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFilterInput");
        formatter.field("name", &self.name);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("filter_expression", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventTrackerInput {
    /// <p>The name for the event tracker.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
}
impl CreateEventTrackerInput {
    /// <p>The name for the event tracker.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateEventTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventTrackerInput");
        formatter.field("name", &self.name);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetImportJobInput {
    /// <p>The name for the dataset import job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset that receives the imported data.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket that contains the training data to import.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetImportJobInput {
    /// <p>The name for the dataset import job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The ARN of the dataset that receives the imported data.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The Amazon S3 bucket that contains the training data to import.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetImportJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("data_source", &self.data_source);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetGroupInput {
    /// <p>The name for the new dataset group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM
    /// role is only valid when also specifying a KMS key.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl CreateDatasetGroupInput {
    /// <p>The name for the new dataset group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM
    /// role is only valid when also specifying a KMS key.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetGroupInput");
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetExportJobInput {
    /// <p>The name for the dataset export job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job,
    /// only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
    /// for both types. The default value is <code>PUT</code>.
    /// </p>
    pub ingestion_mode: std::option::Option<crate::model::IngestionMode>,
    /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your
    /// output Amazon S3 bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The path to the Amazon S3 bucket where the job's output is stored.</p>
    pub job_output: std::option::Option<crate::model::DatasetExportJobOutput>,
}
impl CreateDatasetExportJobInput {
    /// <p>The name for the dataset export job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job,
    /// only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
    /// for both types. The default value is <code>PUT</code>.
    /// </p>
    pub fn ingestion_mode(&self) -> std::option::Option<&crate::model::IngestionMode> {
        self.ingestion_mode.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your
    /// output Amazon S3 bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The path to the Amazon S3 bucket where the job's output is stored.</p>
    pub fn job_output(&self) -> std::option::Option<&crate::model::DatasetExportJobOutput> {
        self.job_output.as_ref()
    }
}
impl std::fmt::Debug for CreateDatasetExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetExportJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("ingestion_mode", &self.ingestion_mode);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("job_output", &self.job_output);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetInput {
    /// <p>The name for the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the schema to associate with the dataset. The schema defines the dataset
    /// fields.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>
    pub dataset_group_arn: std::option::Option<std::string::String>,
    /// <p>The type of dataset.</p>
    /// <p>One of the following (case insensitive) values:</p>
    /// <ul>
    /// <li>
    /// <p>Interactions</p>
    /// </li>
    /// <li>
    /// <p>Items</p>
    /// </li>
    /// <li>
    /// <p>Users</p>
    /// </li>
    /// </ul>
    pub dataset_type: std::option::Option<std::string::String>,
}
impl CreateDatasetInput {
    /// <p>The name for the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the schema to associate with the dataset. The schema defines the dataset
    /// fields.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>
    pub fn dataset_group_arn(&self) -> std::option::Option<&str> {
        self.dataset_group_arn.as_deref()
    }
    /// <p>The type of dataset.</p>
    /// <p>One of the following (case insensitive) values:</p>
    /// <ul>
    /// <li>
    /// <p>Interactions</p>
    /// </li>
    /// <li>
    /// <p>Items</p>
    /// </li>
    /// <li>
    /// <p>Users</p>
    /// </li>
    /// </ul>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetInput");
        formatter.field("name", &self.name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("dataset_group_arn", &self.dataset_group_arn);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCampaignInput {
    /// <p>A name for the new campaign. The campaign name must be unique within your account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the solution version to deploy.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
    /// Amazon Personalize will support.</p>
    pub min_provisioned_tps: std::option::Option<i32>,
    /// <p>The configuration details of a campaign.</p>
    pub campaign_config: std::option::Option<crate::model::CampaignConfig>,
}
impl CreateCampaignInput {
    /// <p>A name for the new campaign. The campaign name must be unique within your account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the solution version to deploy.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>Specifies the requested minimum provisioned transactions (recommendations) per second that
    /// Amazon Personalize will support.</p>
    pub fn min_provisioned_tps(&self) -> std::option::Option<i32> {
        self.min_provisioned_tps
    }
    /// <p>The configuration details of a campaign.</p>
    pub fn campaign_config(&self) -> std::option::Option<&crate::model::CampaignConfig> {
        self.campaign_config.as_ref()
    }
}
impl std::fmt::Debug for CreateCampaignInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCampaignInput");
        formatter.field("name", &self.name);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("min_provisioned_tps", &self.min_provisioned_tps);
        formatter.field("campaign_config", &self.campaign_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchInferenceJobInput {
    /// <p>The name of the batch inference job to create.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the
    /// batch inference recommendations.</p>
    pub solution_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the filter to apply to the batch inference job. For more information on using
    /// filters, see
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering Batch Recommendations</a>..</p>
    pub filter_arn: std::option::Option<std::string::String>,
    /// <p>The number of recommendations to retreive.</p>
    pub num_results: std::option::Option<i32>,
    /// <p>The Amazon S3 path that leads to the input file to base your recommendations on. The input
    /// material must be in JSON format.</p>
    pub job_input: std::option::Option<crate::model::BatchInferenceJobInput>,
    /// <p>The path to the Amazon S3 bucket where the job's output will be stored.</p>
    pub job_output: std::option::Option<crate::model::BatchInferenceJobOutput>,
    /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
    /// Amazon S3 buckets respectively.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The configuration details of a batch inference job.</p>
    pub batch_inference_job_config: std::option::Option<crate::model::BatchInferenceJobConfig>,
}
impl CreateBatchInferenceJobInput {
    /// <p>The name of the batch inference job to create.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the
    /// batch inference recommendations.</p>
    pub fn solution_version_arn(&self) -> std::option::Option<&str> {
        self.solution_version_arn.as_deref()
    }
    /// <p>The ARN of the filter to apply to the batch inference job. For more information on using
    /// filters, see
    /// <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering Batch Recommendations</a>..</p>
    pub fn filter_arn(&self) -> std::option::Option<&str> {
        self.filter_arn.as_deref()
    }
    /// <p>The number of recommendations to retreive.</p>
    pub fn num_results(&self) -> std::option::Option<i32> {
        self.num_results
    }
    /// <p>The Amazon S3 path that leads to the input file to base your recommendations on. The input
    /// material must be in JSON format.</p>
    pub fn job_input(&self) -> std::option::Option<&crate::model::BatchInferenceJobInput> {
        self.job_input.as_ref()
    }
    /// <p>The path to the Amazon S3 bucket where the job's output will be stored.</p>
    pub fn job_output(&self) -> std::option::Option<&crate::model::BatchInferenceJobOutput> {
        self.job_output.as_ref()
    }
    /// <p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output
    /// Amazon S3 buckets respectively.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The configuration details of a batch inference job.</p>
    pub fn batch_inference_job_config(
        &self,
    ) -> std::option::Option<&crate::model::BatchInferenceJobConfig> {
        self.batch_inference_job_config.as_ref()
    }
}
impl std::fmt::Debug for CreateBatchInferenceJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchInferenceJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("solution_version_arn", &self.solution_version_arn);
        formatter.field("filter_arn", &self.filter_arn);
        formatter.field("num_results", &self.num_results);
        formatter.field("job_input", &self.job_input);
        formatter.field("job_output", &self.job_output);
        formatter.field("role_arn", &self.role_arn);
        formatter.field(
            "batch_inference_job_config",
            &self.batch_inference_job_config,
        );
        formatter.finish()
    }
}
