// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceMetadataOutput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl UpdateDeviceMetadataOutput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDeviceMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceMetadataOutput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}
/// See [`UpdateDeviceMetadataOutput`](crate::output::UpdateDeviceMetadataOutput)
pub mod update_device_metadata_output {
    /// A builder for [`UpdateDeviceMetadataOutput`](crate::output::UpdateDeviceMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceMetadataOutput`](crate::output::UpdateDeviceMetadataOutput)
        pub fn build(self) -> crate::output::UpdateDeviceMetadataOutput {
            crate::output::UpdateDeviceMetadataOutput {
                device_id: self.device_id,
            }
        }
    }
}
impl UpdateDeviceMetadataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceMetadataOutput`](crate::output::UpdateDeviceMetadataOutput)
    pub fn builder() -> crate::output::update_device_metadata_output::Builder {
        crate::output::update_device_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveApplicationInstanceOutput {}
impl std::fmt::Debug for RemoveApplicationInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveApplicationInstanceOutput");
        formatter.finish()
    }
}
/// See [`RemoveApplicationInstanceOutput`](crate::output::RemoveApplicationInstanceOutput)
pub mod remove_application_instance_output {
    /// A builder for [`RemoveApplicationInstanceOutput`](crate::output::RemoveApplicationInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveApplicationInstanceOutput`](crate::output::RemoveApplicationInstanceOutput)
        pub fn build(self) -> crate::output::RemoveApplicationInstanceOutput {
            crate::output::RemoveApplicationInstanceOutput {}
        }
    }
}
impl RemoveApplicationInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveApplicationInstanceOutput`](crate::output::RemoveApplicationInstanceOutput)
    pub fn builder() -> crate::output::remove_application_instance_output::Builder {
        crate::output::remove_application_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterPackageVersionOutput {}
impl std::fmt::Debug for RegisterPackageVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterPackageVersionOutput");
        formatter.finish()
    }
}
/// See [`RegisterPackageVersionOutput`](crate::output::RegisterPackageVersionOutput)
pub mod register_package_version_output {
    /// A builder for [`RegisterPackageVersionOutput`](crate::output::RegisterPackageVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterPackageVersionOutput`](crate::output::RegisterPackageVersionOutput)
        pub fn build(self) -> crate::output::RegisterPackageVersionOutput {
            crate::output::RegisterPackageVersionOutput {}
        }
    }
}
impl RegisterPackageVersionOutput {
    /// Creates a new builder-style object to manufacture [`RegisterPackageVersionOutput`](crate::output::RegisterPackageVersionOutput)
    pub fn builder() -> crate::output::register_package_version_output::Builder {
        crate::output::register_package_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionDeviceOutput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The device's status.</p>
    pub status: std::option::Option<crate::model::DeviceStatus>,
    /// <p>The device's configuration bundle.</p>
    pub certificates: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The device's IoT thing name.</p>
    pub iot_thing_name: std::option::Option<std::string::String>,
}
impl ProvisionDeviceOutput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The device's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The device's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeviceStatus> {
        self.status.as_ref()
    }
    /// <p>The device's configuration bundle.</p>
    pub fn certificates(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.certificates.as_ref()
    }
    /// <p>The device's IoT thing name.</p>
    pub fn iot_thing_name(&self) -> std::option::Option<&str> {
        self.iot_thing_name.as_deref()
    }
}
impl std::fmt::Debug for ProvisionDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionDeviceOutput");
        formatter.field("device_id", &self.device_id);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("certificates", &self.certificates);
        formatter.field("iot_thing_name", &self.iot_thing_name);
        formatter.finish()
    }
}
/// See [`ProvisionDeviceOutput`](crate::output::ProvisionDeviceOutput)
pub mod provision_device_output {
    /// A builder for [`ProvisionDeviceOutput`](crate::output::ProvisionDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DeviceStatus>,
        pub(crate) certificates: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) iot_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The device's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The device's status.</p>
        pub fn status(mut self, input: crate::model::DeviceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The device's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeviceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The device's configuration bundle.</p>
        pub fn certificates(mut self, input: aws_smithy_types::Blob) -> Self {
            self.certificates = Some(input);
            self
        }
        /// <p>The device's configuration bundle.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>The device's IoT thing name.</p>
        pub fn iot_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_thing_name = Some(input.into());
            self
        }
        /// <p>The device's IoT thing name.</p>
        pub fn set_iot_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iot_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionDeviceOutput`](crate::output::ProvisionDeviceOutput)
        pub fn build(self) -> crate::output::ProvisionDeviceOutput {
            crate::output::ProvisionDeviceOutput {
                device_id: self.device_id,
                arn: self.arn,
                status: self.status,
                certificates: self.certificates,
                iot_thing_name: self.iot_thing_name,
            }
        }
    }
}
impl ProvisionDeviceOutput {
    /// Creates a new builder-style object to manufacture [`ProvisionDeviceOutput`](crate::output::ProvisionDeviceOutput)
    pub fn builder() -> crate::output::provision_device_output::Builder {
        crate::output::provision_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesOutput {
    /// <p>A list of packages.</p>
    pub packages: std::option::Option<std::vec::Vec<crate::model::PackageListItem>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagesOutput {
    /// <p>A list of packages.</p>
    pub fn packages(&self) -> std::option::Option<&[crate::model::PackageListItem]> {
        self.packages.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesOutput");
        formatter.field("packages", &self.packages);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPackagesOutput`](crate::output::ListPackagesOutput)
pub mod list_packages_output {
    /// A builder for [`ListPackagesOutput`](crate::output::ListPackagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) packages: std::option::Option<std::vec::Vec<crate::model::PackageListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `packages`.
        ///
        /// To override the contents of this collection use [`set_packages`](Self::set_packages).
        ///
        /// <p>A list of packages.</p>
        pub fn packages(mut self, input: crate::model::PackageListItem) -> Self {
            let mut v = self.packages.unwrap_or_default();
            v.push(input);
            self.packages = Some(v);
            self
        }
        /// <p>A list of packages.</p>
        pub fn set_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageListItem>>,
        ) -> Self {
            self.packages = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesOutput`](crate::output::ListPackagesOutput)
        pub fn build(self) -> crate::output::ListPackagesOutput {
            crate::output::ListPackagesOutput {
                packages: self.packages,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPackagesOutput {
    /// Creates a new builder-style object to manufacture [`ListPackagesOutput`](crate::output::ListPackagesOutput)
    pub fn builder() -> crate::output::list_packages_output::Builder {
        crate::output::list_packages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageImportJobsOutput {
    /// <p>A list of package import jobs.</p>
    pub package_import_jobs: std::option::Option<std::vec::Vec<crate::model::PackageImportJob>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackageImportJobsOutput {
    /// <p>A list of package import jobs.</p>
    pub fn package_import_jobs(&self) -> std::option::Option<&[crate::model::PackageImportJob]> {
        self.package_import_jobs.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackageImportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageImportJobsOutput");
        formatter.field("package_import_jobs", &self.package_import_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPackageImportJobsOutput`](crate::output::ListPackageImportJobsOutput)
pub mod list_package_import_jobs_output {
    /// A builder for [`ListPackageImportJobsOutput`](crate::output::ListPackageImportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_import_jobs:
            std::option::Option<std::vec::Vec<crate::model::PackageImportJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `package_import_jobs`.
        ///
        /// To override the contents of this collection use [`set_package_import_jobs`](Self::set_package_import_jobs).
        ///
        /// <p>A list of package import jobs.</p>
        pub fn package_import_jobs(mut self, input: crate::model::PackageImportJob) -> Self {
            let mut v = self.package_import_jobs.unwrap_or_default();
            v.push(input);
            self.package_import_jobs = Some(v);
            self
        }
        /// <p>A list of package import jobs.</p>
        pub fn set_package_import_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageImportJob>>,
        ) -> Self {
            self.package_import_jobs = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageImportJobsOutput`](crate::output::ListPackageImportJobsOutput)
        pub fn build(self) -> crate::output::ListPackageImportJobsOutput {
            crate::output::ListPackageImportJobsOutput {
                package_import_jobs: self.package_import_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPackageImportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListPackageImportJobsOutput`](crate::output::ListPackageImportJobsOutput)
    pub fn builder() -> crate::output::list_package_import_jobs_output::Builder {
        crate::output::list_package_import_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNodesOutput {
    /// <p>A list of nodes.</p>
    pub nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNodesOutput {
    /// <p>A list of nodes.</p>
    pub fn nodes(&self) -> std::option::Option<&[crate::model::Node]> {
        self.nodes.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNodesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNodesOutput");
        formatter.field("nodes", &self.nodes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListNodesOutput`](crate::output::ListNodesOutput)
pub mod list_nodes_output {
    /// A builder for [`ListNodesOutput`](crate::output::ListNodesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `nodes`.
        ///
        /// To override the contents of this collection use [`set_nodes`](Self::set_nodes).
        ///
        /// <p>A list of nodes.</p>
        pub fn nodes(mut self, input: crate::model::Node) -> Self {
            let mut v = self.nodes.unwrap_or_default();
            v.push(input);
            self.nodes = Some(v);
            self
        }
        /// <p>A list of nodes.</p>
        pub fn set_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Node>>,
        ) -> Self {
            self.nodes = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNodesOutput`](crate::output::ListNodesOutput)
        pub fn build(self) -> crate::output::ListNodesOutput {
            crate::output::ListNodesOutput {
                nodes: self.nodes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListNodesOutput {
    /// Creates a new builder-style object to manufacture [`ListNodesOutput`](crate::output::ListNodesOutput)
    pub fn builder() -> crate::output::list_nodes_output::Builder {
        crate::output::list_nodes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNodeFromTemplateJobsOutput {
    /// <p>A list of jobs.</p>
    pub node_from_template_jobs:
        std::option::Option<std::vec::Vec<crate::model::NodeFromTemplateJob>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNodeFromTemplateJobsOutput {
    /// <p>A list of jobs.</p>
    pub fn node_from_template_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::NodeFromTemplateJob]> {
        self.node_from_template_jobs.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNodeFromTemplateJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNodeFromTemplateJobsOutput");
        formatter.field("node_from_template_jobs", &self.node_from_template_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListNodeFromTemplateJobsOutput`](crate::output::ListNodeFromTemplateJobsOutput)
pub mod list_node_from_template_jobs_output {
    /// A builder for [`ListNodeFromTemplateJobsOutput`](crate::output::ListNodeFromTemplateJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_from_template_jobs:
            std::option::Option<std::vec::Vec<crate::model::NodeFromTemplateJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `node_from_template_jobs`.
        ///
        /// To override the contents of this collection use [`set_node_from_template_jobs`](Self::set_node_from_template_jobs).
        ///
        /// <p>A list of jobs.</p>
        pub fn node_from_template_jobs(mut self, input: crate::model::NodeFromTemplateJob) -> Self {
            let mut v = self.node_from_template_jobs.unwrap_or_default();
            v.push(input);
            self.node_from_template_jobs = Some(v);
            self
        }
        /// <p>A list of jobs.</p>
        pub fn set_node_from_template_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeFromTemplateJob>>,
        ) -> Self {
            self.node_from_template_jobs = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNodeFromTemplateJobsOutput`](crate::output::ListNodeFromTemplateJobsOutput)
        pub fn build(self) -> crate::output::ListNodeFromTemplateJobsOutput {
            crate::output::ListNodeFromTemplateJobsOutput {
                node_from_template_jobs: self.node_from_template_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListNodeFromTemplateJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListNodeFromTemplateJobsOutput`](crate::output::ListNodeFromTemplateJobsOutput)
    pub fn builder() -> crate::output::list_node_from_template_jobs_output::Builder {
        crate::output::list_node_from_template_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesJobsOutput {
    /// <p>A list of jobs.</p>
    pub device_jobs: std::option::Option<std::vec::Vec<crate::model::DeviceJob>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicesJobsOutput {
    /// <p>A list of jobs.</p>
    pub fn device_jobs(&self) -> std::option::Option<&[crate::model::DeviceJob]> {
        self.device_jobs.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicesJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesJobsOutput");
        formatter.field("device_jobs", &self.device_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicesJobsOutput`](crate::output::ListDevicesJobsOutput)
pub mod list_devices_jobs_output {
    /// A builder for [`ListDevicesJobsOutput`](crate::output::ListDevicesJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_jobs: std::option::Option<std::vec::Vec<crate::model::DeviceJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `device_jobs`.
        ///
        /// To override the contents of this collection use [`set_device_jobs`](Self::set_device_jobs).
        ///
        /// <p>A list of jobs.</p>
        pub fn device_jobs(mut self, input: crate::model::DeviceJob) -> Self {
            let mut v = self.device_jobs.unwrap_or_default();
            v.push(input);
            self.device_jobs = Some(v);
            self
        }
        /// <p>A list of jobs.</p>
        pub fn set_device_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceJob>>,
        ) -> Self {
            self.device_jobs = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesJobsOutput`](crate::output::ListDevicesJobsOutput)
        pub fn build(self) -> crate::output::ListDevicesJobsOutput {
            crate::output::ListDevicesJobsOutput {
                device_jobs: self.device_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicesJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicesJobsOutput`](crate::output::ListDevicesJobsOutput)
    pub fn builder() -> crate::output::list_devices_jobs_output::Builder {
        crate::output::list_devices_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesOutput {
    /// <p>A list of devices.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicesOutput {
    /// <p>A list of devices.</p>
    pub fn devices(&self) -> std::option::Option<&[crate::model::Device]> {
        self.devices.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicesOutput`](crate::output::ListDevicesOutput)
pub mod list_devices_output {
    /// A builder for [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>A list of devices.</p>
        pub fn devices(mut self, input: crate::model::Device) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input);
            self.devices = Some(v);
            self
        }
        /// <p>A list of devices.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesOutput`](crate::output::ListDevicesOutput)
        pub fn build(self) -> crate::output::ListDevicesOutput {
            crate::output::ListDevicesOutput {
                devices: self.devices,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    pub fn builder() -> crate::output::list_devices_output::Builder {
        crate::output::list_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationInstancesOutput {
    /// <p>A list of application instances.</p>
    pub application_instances:
        std::option::Option<std::vec::Vec<crate::model::ApplicationInstance>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationInstancesOutput {
    /// <p>A list of application instances.</p>
    pub fn application_instances(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationInstance]> {
        self.application_instances.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationInstancesOutput");
        formatter.field("application_instances", &self.application_instances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationInstancesOutput`](crate::output::ListApplicationInstancesOutput)
pub mod list_application_instances_output {
    /// A builder for [`ListApplicationInstancesOutput`](crate::output::ListApplicationInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instances:
            std::option::Option<std::vec::Vec<crate::model::ApplicationInstance>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `application_instances`.
        ///
        /// To override the contents of this collection use [`set_application_instances`](Self::set_application_instances).
        ///
        /// <p>A list of application instances.</p>
        pub fn application_instances(mut self, input: crate::model::ApplicationInstance) -> Self {
            let mut v = self.application_instances.unwrap_or_default();
            v.push(input);
            self.application_instances = Some(v);
            self
        }
        /// <p>A list of application instances.</p>
        pub fn set_application_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationInstance>>,
        ) -> Self {
            self.application_instances = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationInstancesOutput`](crate::output::ListApplicationInstancesOutput)
        pub fn build(self) -> crate::output::ListApplicationInstancesOutput {
            crate::output::ListApplicationInstancesOutput {
                application_instances: self.application_instances,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationInstancesOutput`](crate::output::ListApplicationInstancesOutput)
    pub fn builder() -> crate::output::list_application_instances_output::Builder {
        crate::output::list_application_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationInstanceNodeInstancesOutput {
    /// <p>A list of node instances.</p>
    pub node_instances: std::option::Option<std::vec::Vec<crate::model::NodeInstance>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationInstanceNodeInstancesOutput {
    /// <p>A list of node instances.</p>
    pub fn node_instances(&self) -> std::option::Option<&[crate::model::NodeInstance]> {
        self.node_instances.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationInstanceNodeInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationInstanceNodeInstancesOutput");
        formatter.field("node_instances", &self.node_instances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationInstanceNodeInstancesOutput`](crate::output::ListApplicationInstanceNodeInstancesOutput)
pub mod list_application_instance_node_instances_output {
    /// A builder for [`ListApplicationInstanceNodeInstancesOutput`](crate::output::ListApplicationInstanceNodeInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_instances: std::option::Option<std::vec::Vec<crate::model::NodeInstance>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `node_instances`.
        ///
        /// To override the contents of this collection use [`set_node_instances`](Self::set_node_instances).
        ///
        /// <p>A list of node instances.</p>
        pub fn node_instances(mut self, input: crate::model::NodeInstance) -> Self {
            let mut v = self.node_instances.unwrap_or_default();
            v.push(input);
            self.node_instances = Some(v);
            self
        }
        /// <p>A list of node instances.</p>
        pub fn set_node_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeInstance>>,
        ) -> Self {
            self.node_instances = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationInstanceNodeInstancesOutput`](crate::output::ListApplicationInstanceNodeInstancesOutput)
        pub fn build(self) -> crate::output::ListApplicationInstanceNodeInstancesOutput {
            crate::output::ListApplicationInstanceNodeInstancesOutput {
                node_instances: self.node_instances,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationInstanceNodeInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationInstanceNodeInstancesOutput`](crate::output::ListApplicationInstanceNodeInstancesOutput)
    pub fn builder() -> crate::output::list_application_instance_node_instances_output::Builder {
        crate::output::list_application_instance_node_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationInstanceDependenciesOutput {
    /// <p>A list of package objects.</p>
    pub package_objects: std::option::Option<std::vec::Vec<crate::model::PackageObject>>,
    /// <p>A pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationInstanceDependenciesOutput {
    /// <p>A list of package objects.</p>
    pub fn package_objects(&self) -> std::option::Option<&[crate::model::PackageObject]> {
        self.package_objects.as_deref()
    }
    /// <p>A pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationInstanceDependenciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationInstanceDependenciesOutput");
        formatter.field("package_objects", &self.package_objects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationInstanceDependenciesOutput`](crate::output::ListApplicationInstanceDependenciesOutput)
pub mod list_application_instance_dependencies_output {
    /// A builder for [`ListApplicationInstanceDependenciesOutput`](crate::output::ListApplicationInstanceDependenciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_objects: std::option::Option<std::vec::Vec<crate::model::PackageObject>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `package_objects`.
        ///
        /// To override the contents of this collection use [`set_package_objects`](Self::set_package_objects).
        ///
        /// <p>A list of package objects.</p>
        pub fn package_objects(mut self, input: crate::model::PackageObject) -> Self {
            let mut v = self.package_objects.unwrap_or_default();
            v.push(input);
            self.package_objects = Some(v);
            self
        }
        /// <p>A list of package objects.</p>
        pub fn set_package_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageObject>>,
        ) -> Self {
            self.package_objects = input;
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationInstanceDependenciesOutput`](crate::output::ListApplicationInstanceDependenciesOutput)
        pub fn build(self) -> crate::output::ListApplicationInstanceDependenciesOutput {
            crate::output::ListApplicationInstanceDependenciesOutput {
                package_objects: self.package_objects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationInstanceDependenciesOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationInstanceDependenciesOutput`](crate::output::ListApplicationInstanceDependenciesOutput)
    pub fn builder() -> crate::output::list_application_instance_dependencies_output::Builder {
        crate::output::list_application_instance_dependencies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageVersionOutput {
    /// <p>The account ID of the version's owner.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The version's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the package.</p>
    pub package_arn: std::option::Option<std::string::String>,
    /// <p>The version's name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The version's version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The version's patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>Whether the version is the latest available.</p>
    pub is_latest_patch: bool,
    /// <p>The version's status.</p>
    pub status: std::option::Option<crate::model::PackageVersionStatus>,
    /// <p>The version's status description.</p>
    pub status_description: std::option::Option<std::string::String>,
    /// <p>The version's registered time.</p>
    pub registered_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribePackageVersionOutput {
    /// <p>The account ID of the version's owner.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The version's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The ARN of the package.</p>
    pub fn package_arn(&self) -> std::option::Option<&str> {
        self.package_arn.as_deref()
    }
    /// <p>The version's name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The version's version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The version's patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>Whether the version is the latest available.</p>
    pub fn is_latest_patch(&self) -> bool {
        self.is_latest_patch
    }
    /// <p>The version's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.status.as_ref()
    }
    /// <p>The version's status description.</p>
    pub fn status_description(&self) -> std::option::Option<&str> {
        self.status_description.as_deref()
    }
    /// <p>The version's registered time.</p>
    pub fn registered_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.registered_time.as_ref()
    }
}
impl std::fmt::Debug for DescribePackageVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageVersionOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_id", &self.package_id);
        formatter.field("package_arn", &self.package_arn);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field("is_latest_patch", &self.is_latest_patch);
        formatter.field("status", &self.status);
        formatter.field("status_description", &self.status_description);
        formatter.field("registered_time", &self.registered_time);
        formatter.finish()
    }
}
/// See [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
pub mod describe_package_version_output {
    /// A builder for [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_arn: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) is_latest_patch: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::PackageVersionStatus>,
        pub(crate) status_description: std::option::Option<std::string::String>,
        pub(crate) registered_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The account ID of the version's owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The account ID of the version's owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The version's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The version's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The ARN of the package.</p>
        pub fn package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the package.</p>
        pub fn set_package_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_arn = input;
            self
        }
        /// <p>The version's name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The version's name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The version's version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The version's version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The version's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>The version's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>Whether the version is the latest available.</p>
        pub fn is_latest_patch(mut self, input: bool) -> Self {
            self.is_latest_patch = Some(input);
            self
        }
        /// <p>Whether the version is the latest available.</p>
        pub fn set_is_latest_patch(mut self, input: std::option::Option<bool>) -> Self {
            self.is_latest_patch = input;
            self
        }
        /// <p>The version's status.</p>
        pub fn status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The version's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The version's status description.</p>
        pub fn status_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_description = Some(input.into());
            self
        }
        /// <p>The version's status description.</p>
        pub fn set_status_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_description = input;
            self
        }
        /// <p>The version's registered time.</p>
        pub fn registered_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.registered_time = Some(input);
            self
        }
        /// <p>The version's registered time.</p>
        pub fn set_registered_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.registered_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
        pub fn build(self) -> crate::output::DescribePackageVersionOutput {
            crate::output::DescribePackageVersionOutput {
                owner_account: self.owner_account,
                package_id: self.package_id,
                package_arn: self.package_arn,
                package_name: self.package_name,
                package_version: self.package_version,
                patch_version: self.patch_version,
                is_latest_patch: self.is_latest_patch.unwrap_or_default(),
                status: self.status,
                status_description: self.status_description,
                registered_time: self.registered_time,
            }
        }
    }
}
impl DescribePackageVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
    pub fn builder() -> crate::output::describe_package_version_output::Builder {
        crate::output::describe_package_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageImportJobOutput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job's client token.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The job's type.</p>
    pub job_type: std::option::Option<crate::model::PackageImportJobType>,
    /// <p>The job's input config.</p>
    pub input_config: std::option::Option<crate::model::PackageImportJobInputConfig>,
    /// <p>The job's output config.</p>
    pub output_config: std::option::Option<crate::model::PackageImportJobOutputConfig>,
    /// <p>The job's output.</p>
    pub output: std::option::Option<crate::model::PackageImportJobOutput>,
    /// <p>When the job was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the job was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The job's status.</p>
    pub status: std::option::Option<crate::model::PackageImportJobStatus>,
    /// <p>The job's status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The job's tags.</p>
    pub job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
}
impl DescribePackageImportJobOutput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job's client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The job's type.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::PackageImportJobType> {
        self.job_type.as_ref()
    }
    /// <p>The job's input config.</p>
    pub fn input_config(&self) -> std::option::Option<&crate::model::PackageImportJobInputConfig> {
        self.input_config.as_ref()
    }
    /// <p>The job's output config.</p>
    pub fn output_config(
        &self,
    ) -> std::option::Option<&crate::model::PackageImportJobOutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The job's output.</p>
    pub fn output(&self) -> std::option::Option<&crate::model::PackageImportJobOutput> {
        self.output.as_ref()
    }
    /// <p>When the job was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>When the job was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The job's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageImportJobStatus> {
        self.status.as_ref()
    }
    /// <p>The job's status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The job's tags.</p>
    pub fn job_tags(&self) -> std::option::Option<&[crate::model::JobResourceTags]> {
        self.job_tags.as_deref()
    }
}
impl std::fmt::Debug for DescribePackageImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageImportJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("job_type", &self.job_type);
        formatter.field("input_config", &self.input_config);
        formatter.field("output_config", &self.output_config);
        formatter.field("output", &self.output);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("job_tags", &self.job_tags);
        formatter.finish()
    }
}
/// See [`DescribePackageImportJobOutput`](crate::output::DescribePackageImportJobOutput)
pub mod describe_package_import_job_output {
    /// A builder for [`DescribePackageImportJobOutput`](crate::output::DescribePackageImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) job_type: std::option::Option<crate::model::PackageImportJobType>,
        pub(crate) input_config: std::option::Option<crate::model::PackageImportJobInputConfig>,
        pub(crate) output_config: std::option::Option<crate::model::PackageImportJobOutputConfig>,
        pub(crate) output: std::option::Option<crate::model::PackageImportJobOutput>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::PackageImportJobStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job's client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The job's client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The job's type.</p>
        pub fn job_type(mut self, input: crate::model::PackageImportJobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The job's type.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobType>,
        ) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The job's input config.</p>
        pub fn input_config(mut self, input: crate::model::PackageImportJobInputConfig) -> Self {
            self.input_config = Some(input);
            self
        }
        /// <p>The job's input config.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobInputConfig>,
        ) -> Self {
            self.input_config = input;
            self
        }
        /// <p>The job's output config.</p>
        pub fn output_config(mut self, input: crate::model::PackageImportJobOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The job's output config.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The job's output.</p>
        pub fn output(mut self, input: crate::model::PackageImportJobOutput) -> Self {
            self.output = Some(input);
            self
        }
        /// <p>The job's output.</p>
        pub fn set_output(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobOutput>,
        ) -> Self {
            self.output = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>When the job was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>When the job was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The job's status.</p>
        pub fn status(mut self, input: crate::model::PackageImportJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The job's status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The job's status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Appends an item to `job_tags`.
        ///
        /// To override the contents of this collection use [`set_job_tags`](Self::set_job_tags).
        ///
        /// <p>The job's tags.</p>
        pub fn job_tags(mut self, input: crate::model::JobResourceTags) -> Self {
            let mut v = self.job_tags.unwrap_or_default();
            v.push(input);
            self.job_tags = Some(v);
            self
        }
        /// <p>The job's tags.</p>
        pub fn set_job_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
        ) -> Self {
            self.job_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageImportJobOutput`](crate::output::DescribePackageImportJobOutput)
        pub fn build(self) -> crate::output::DescribePackageImportJobOutput {
            crate::output::DescribePackageImportJobOutput {
                job_id: self.job_id,
                client_token: self.client_token,
                job_type: self.job_type,
                input_config: self.input_config,
                output_config: self.output_config,
                output: self.output,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                status: self.status,
                status_message: self.status_message,
                job_tags: self.job_tags,
            }
        }
    }
}
impl DescribePackageImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackageImportJobOutput`](crate::output::DescribePackageImportJobOutput)
    pub fn builder() -> crate::output::describe_package_import_job_output::Builder {
        crate::output::describe_package_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageOutput {
    /// <p>The package's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The package's name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The package's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The package's storage location.</p>
    pub storage_location: std::option::Option<crate::model::StorageLocation>,
    /// <p>ARNs of accounts that have read access to the package.</p>
    pub read_access_principal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>ARNs of accounts that have write access to the package.</p>
    pub write_access_principal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When the package was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The package's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribePackageOutput {
    /// <p>The package's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The package's name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The package's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The package's storage location.</p>
    pub fn storage_location(&self) -> std::option::Option<&crate::model::StorageLocation> {
        self.storage_location.as_ref()
    }
    /// <p>ARNs of accounts that have read access to the package.</p>
    pub fn read_access_principal_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.read_access_principal_arns.as_deref()
    }
    /// <p>ARNs of accounts that have write access to the package.</p>
    pub fn write_access_principal_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.write_access_principal_arns.as_deref()
    }
    /// <p>When the package was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The package's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageOutput");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_name", &self.package_name);
        formatter.field("arn", &self.arn);
        formatter.field("storage_location", &self.storage_location);
        formatter.field(
            "read_access_principal_arns",
            &self.read_access_principal_arns,
        );
        formatter.field(
            "write_access_principal_arns",
            &self.write_access_principal_arns,
        );
        formatter.field("created_time", &self.created_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribePackageOutput`](crate::output::DescribePackageOutput)
pub mod describe_package_output {
    /// A builder for [`DescribePackageOutput`](crate::output::DescribePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) storage_location: std::option::Option<crate::model::StorageLocation>,
        pub(crate) read_access_principal_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) write_access_principal_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The package's name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The package's name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The package's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The package's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The package's storage location.</p>
        pub fn storage_location(mut self, input: crate::model::StorageLocation) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>The package's storage location.</p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::StorageLocation>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// Appends an item to `read_access_principal_arns`.
        ///
        /// To override the contents of this collection use [`set_read_access_principal_arns`](Self::set_read_access_principal_arns).
        ///
        /// <p>ARNs of accounts that have read access to the package.</p>
        pub fn read_access_principal_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_access_principal_arns.unwrap_or_default();
            v.push(input.into());
            self.read_access_principal_arns = Some(v);
            self
        }
        /// <p>ARNs of accounts that have read access to the package.</p>
        pub fn set_read_access_principal_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_access_principal_arns = input;
            self
        }
        /// Appends an item to `write_access_principal_arns`.
        ///
        /// To override the contents of this collection use [`set_write_access_principal_arns`](Self::set_write_access_principal_arns).
        ///
        /// <p>ARNs of accounts that have write access to the package.</p>
        pub fn write_access_principal_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.write_access_principal_arns.unwrap_or_default();
            v.push(input.into());
            self.write_access_principal_arns = Some(v);
            self
        }
        /// <p>ARNs of accounts that have write access to the package.</p>
        pub fn set_write_access_principal_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.write_access_principal_arns = input;
            self
        }
        /// <p>When the package was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the package was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The package's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The package's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageOutput`](crate::output::DescribePackageOutput)
        pub fn build(self) -> crate::output::DescribePackageOutput {
            crate::output::DescribePackageOutput {
                package_id: self.package_id,
                package_name: self.package_name,
                arn: self.arn,
                storage_location: self.storage_location,
                read_access_principal_arns: self.read_access_principal_arns,
                write_access_principal_arns: self.write_access_principal_arns,
                created_time: self.created_time,
                tags: self.tags,
            }
        }
    }
}
impl DescribePackageOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackageOutput`](crate::output::DescribePackageOutput)
    pub fn builder() -> crate::output::describe_package_output::Builder {
        crate::output::describe_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNodeFromTemplateJobOutput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job's status.</p>
    pub status: std::option::Option<crate::model::NodeFromTemplateJobStatus>,
    /// <p>The job's status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>When the job was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the job was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The job's output package name.</p>
    pub output_package_name: std::option::Option<std::string::String>,
    /// <p>The job's output package version.</p>
    pub output_package_version: std::option::Option<std::string::String>,
    /// <p>The node's name.</p>
    pub node_name: std::option::Option<std::string::String>,
    /// <p>The node's description.</p>
    pub node_description: std::option::Option<std::string::String>,
    /// <p>The job's template type.</p>
    pub template_type: std::option::Option<crate::model::TemplateType>,
    /// <p>The job's template parameters.</p>
    pub template_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The job's tags.</p>
    pub job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
}
impl DescribeNodeFromTemplateJobOutput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NodeFromTemplateJobStatus> {
        self.status.as_ref()
    }
    /// <p>The job's status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>When the job was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>When the job was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The job's output package name.</p>
    pub fn output_package_name(&self) -> std::option::Option<&str> {
        self.output_package_name.as_deref()
    }
    /// <p>The job's output package version.</p>
    pub fn output_package_version(&self) -> std::option::Option<&str> {
        self.output_package_version.as_deref()
    }
    /// <p>The node's name.</p>
    pub fn node_name(&self) -> std::option::Option<&str> {
        self.node_name.as_deref()
    }
    /// <p>The node's description.</p>
    pub fn node_description(&self) -> std::option::Option<&str> {
        self.node_description.as_deref()
    }
    /// <p>The job's template type.</p>
    pub fn template_type(&self) -> std::option::Option<&crate::model::TemplateType> {
        self.template_type.as_ref()
    }
    /// <p>The job's template parameters.</p>
    pub fn template_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.template_parameters.as_ref()
    }
    /// <p>The job's tags.</p>
    pub fn job_tags(&self) -> std::option::Option<&[crate::model::JobResourceTags]> {
        self.job_tags.as_deref()
    }
}
impl std::fmt::Debug for DescribeNodeFromTemplateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNodeFromTemplateJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("output_package_name", &self.output_package_name);
        formatter.field("output_package_version", &self.output_package_version);
        formatter.field("node_name", &self.node_name);
        formatter.field("node_description", &self.node_description);
        formatter.field("template_type", &self.template_type);
        formatter.field("template_parameters", &self.template_parameters);
        formatter.field("job_tags", &self.job_tags);
        formatter.finish()
    }
}
/// See [`DescribeNodeFromTemplateJobOutput`](crate::output::DescribeNodeFromTemplateJobOutput)
pub mod describe_node_from_template_job_output {
    /// A builder for [`DescribeNodeFromTemplateJobOutput`](crate::output::DescribeNodeFromTemplateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NodeFromTemplateJobStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) output_package_name: std::option::Option<std::string::String>,
        pub(crate) output_package_version: std::option::Option<std::string::String>,
        pub(crate) node_name: std::option::Option<std::string::String>,
        pub(crate) node_description: std::option::Option<std::string::String>,
        pub(crate) template_type: std::option::Option<crate::model::TemplateType>,
        pub(crate) template_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job's status.</p>
        pub fn status(mut self, input: crate::model::NodeFromTemplateJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NodeFromTemplateJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The job's status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The job's status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>When the job was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>When the job was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The job's output package name.</p>
        pub fn output_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_package_name = Some(input.into());
            self
        }
        /// <p>The job's output package name.</p>
        pub fn set_output_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_package_name = input;
            self
        }
        /// <p>The job's output package version.</p>
        pub fn output_package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_package_version = Some(input.into());
            self
        }
        /// <p>The job's output package version.</p>
        pub fn set_output_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_package_version = input;
            self
        }
        /// <p>The node's name.</p>
        pub fn node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_name = Some(input.into());
            self
        }
        /// <p>The node's name.</p>
        pub fn set_node_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_name = input;
            self
        }
        /// <p>The node's description.</p>
        pub fn node_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_description = Some(input.into());
            self
        }
        /// <p>The node's description.</p>
        pub fn set_node_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_description = input;
            self
        }
        /// <p>The job's template type.</p>
        pub fn template_type(mut self, input: crate::model::TemplateType) -> Self {
            self.template_type = Some(input);
            self
        }
        /// <p>The job's template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// Adds a key-value pair to `template_parameters`.
        ///
        /// To override the contents of this collection use [`set_template_parameters`](Self::set_template_parameters).
        ///
        /// <p>The job's template parameters.</p>
        pub fn template_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.template_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.template_parameters = Some(hash_map);
            self
        }
        /// <p>The job's template parameters.</p>
        pub fn set_template_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.template_parameters = input;
            self
        }
        /// Appends an item to `job_tags`.
        ///
        /// To override the contents of this collection use [`set_job_tags`](Self::set_job_tags).
        ///
        /// <p>The job's tags.</p>
        pub fn job_tags(mut self, input: crate::model::JobResourceTags) -> Self {
            let mut v = self.job_tags.unwrap_or_default();
            v.push(input);
            self.job_tags = Some(v);
            self
        }
        /// <p>The job's tags.</p>
        pub fn set_job_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
        ) -> Self {
            self.job_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeFromTemplateJobOutput`](crate::output::DescribeNodeFromTemplateJobOutput)
        pub fn build(self) -> crate::output::DescribeNodeFromTemplateJobOutput {
            crate::output::DescribeNodeFromTemplateJobOutput {
                job_id: self.job_id,
                status: self.status,
                status_message: self.status_message,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                output_package_name: self.output_package_name,
                output_package_version: self.output_package_version,
                node_name: self.node_name,
                node_description: self.node_description,
                template_type: self.template_type,
                template_parameters: self.template_parameters,
                job_tags: self.job_tags,
            }
        }
    }
}
impl DescribeNodeFromTemplateJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNodeFromTemplateJobOutput`](crate::output::DescribeNodeFromTemplateJobOutput)
    pub fn builder() -> crate::output::describe_node_from_template_job_output::Builder {
        crate::output::describe_node_from_template_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNodeOutput {
    /// <p>The node's ID.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>The node's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The node's category.</p>
    pub category: std::option::Option<crate::model::NodeCategory>,
    /// <p>The account ID of the node's owner.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The node's package name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The node's package ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The node's ARN.</p>
    pub package_arn: std::option::Option<std::string::String>,
    /// <p>The node's package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The node's patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>The node's interface.</p>
    pub node_interface: std::option::Option<crate::model::NodeInterface>,
    /// <p>The node's asset name.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>The node's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>When the node was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the node was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeNodeOutput {
    /// <p>The node's ID.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>The node's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The node's category.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::NodeCategory> {
        self.category.as_ref()
    }
    /// <p>The account ID of the node's owner.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The node's package name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The node's package ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The node's ARN.</p>
    pub fn package_arn(&self) -> std::option::Option<&str> {
        self.package_arn.as_deref()
    }
    /// <p>The node's package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The node's patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>The node's interface.</p>
    pub fn node_interface(&self) -> std::option::Option<&crate::model::NodeInterface> {
        self.node_interface.as_ref()
    }
    /// <p>The node's asset name.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>The node's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>When the node was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>When the node was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNodeOutput");
        formatter.field("node_id", &self.node_id);
        formatter.field("name", &self.name);
        formatter.field("category", &self.category);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_id", &self.package_id);
        formatter.field("package_arn", &self.package_arn);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field("node_interface", &self.node_interface);
        formatter.field("asset_name", &self.asset_name);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DescribeNodeOutput`](crate::output::DescribeNodeOutput)
pub mod describe_node_output {
    /// A builder for [`DescribeNodeOutput`](crate::output::DescribeNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<crate::model::NodeCategory>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_arn: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) node_interface: std::option::Option<crate::model::NodeInterface>,
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The node's ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The node's ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// <p>The node's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The node's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The node's category.</p>
        pub fn category(mut self, input: crate::model::NodeCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The node's category.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::NodeCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The node's package name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The node's package name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The node's package ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The node's package ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The node's ARN.</p>
        pub fn package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_arn = Some(input.into());
            self
        }
        /// <p>The node's ARN.</p>
        pub fn set_package_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_arn = input;
            self
        }
        /// <p>The node's package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The node's package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The node's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>The node's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>The node's interface.</p>
        pub fn node_interface(mut self, input: crate::model::NodeInterface) -> Self {
            self.node_interface = Some(input);
            self
        }
        /// <p>The node's interface.</p>
        pub fn set_node_interface(
            mut self,
            input: std::option::Option<crate::model::NodeInterface>,
        ) -> Self {
            self.node_interface = input;
            self
        }
        /// <p>The node's asset name.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>The node's asset name.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>The node's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The node's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>When the node was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the node was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>When the node was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>When the node was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeOutput`](crate::output::DescribeNodeOutput)
        pub fn build(self) -> crate::output::DescribeNodeOutput {
            crate::output::DescribeNodeOutput {
                node_id: self.node_id,
                name: self.name,
                category: self.category,
                owner_account: self.owner_account,
                package_name: self.package_name,
                package_id: self.package_id,
                package_arn: self.package_arn,
                package_version: self.package_version,
                patch_version: self.patch_version,
                node_interface: self.node_interface,
                asset_name: self.asset_name,
                description: self.description,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DescribeNodeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNodeOutput`](crate::output::DescribeNodeOutput)
    pub fn builder() -> crate::output::describe_node_output::Builder {
        crate::output::describe_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceJobOutput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device's ARN.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The device's name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The device's type.</p>
    pub device_type: std::option::Option<crate::model::DeviceType>,
    /// <p>For an OTA job, the target version of the device software.</p>
    pub image_version: std::option::Option<std::string::String>,
    /// <p>The job's status.</p>
    pub status: std::option::Option<crate::model::UpdateProgress>,
    /// <p>When the job was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeDeviceJobOutput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The device's ARN.</p>
    pub fn device_arn(&self) -> std::option::Option<&str> {
        self.device_arn.as_deref()
    }
    /// <p>The device's name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The device's type.</p>
    pub fn device_type(&self) -> std::option::Option<&crate::model::DeviceType> {
        self.device_type.as_ref()
    }
    /// <p>For an OTA job, the target version of the device software.</p>
    pub fn image_version(&self) -> std::option::Option<&str> {
        self.image_version.as_deref()
    }
    /// <p>The job's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::UpdateProgress> {
        self.status.as_ref()
    }
    /// <p>When the job was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeDeviceJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_name", &self.device_name);
        formatter.field("device_type", &self.device_type);
        formatter.field("image_version", &self.image_version);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`DescribeDeviceJobOutput`](crate::output::DescribeDeviceJobOutput)
pub mod describe_device_job_output {
    /// A builder for [`DescribeDeviceJobOutput`](crate::output::DescribeDeviceJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<crate::model::DeviceType>,
        pub(crate) image_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::UpdateProgress>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device's ARN.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The device's ARN.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The device's name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device's name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The device's type.</p>
        pub fn device_type(mut self, input: crate::model::DeviceType) -> Self {
            self.device_type = Some(input);
            self
        }
        /// <p>The device's type.</p>
        pub fn set_device_type(
            mut self,
            input: std::option::Option<crate::model::DeviceType>,
        ) -> Self {
            self.device_type = input;
            self
        }
        /// <p>For an OTA job, the target version of the device software.</p>
        pub fn image_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_version = Some(input.into());
            self
        }
        /// <p>For an OTA job, the target version of the device software.</p>
        pub fn set_image_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_version = input;
            self
        }
        /// <p>The job's status.</p>
        pub fn status(mut self, input: crate::model::UpdateProgress) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UpdateProgress>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceJobOutput`](crate::output::DescribeDeviceJobOutput)
        pub fn build(self) -> crate::output::DescribeDeviceJobOutput {
            crate::output::DescribeDeviceJobOutput {
                job_id: self.job_id,
                device_id: self.device_id,
                device_arn: self.device_arn,
                device_name: self.device_name,
                device_type: self.device_type,
                image_version: self.image_version,
                status: self.status,
                created_time: self.created_time,
            }
        }
    }
}
impl DescribeDeviceJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceJobOutput`](crate::output::DescribeDeviceJobOutput)
    pub fn builder() -> crate::output::describe_device_job_output::Builder {
        crate::output::describe_device_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceOutput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The device's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The device's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The device's type.</p>
    pub r#type: std::option::Option<crate::model::DeviceType>,
    /// <p>The device's connection status.</p>
    pub device_connection_status: std::option::Option<crate::model::DeviceConnectionStatus>,
    /// <p>When the device was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The device's provisioning status.</p>
    pub provisioning_status: std::option::Option<crate::model::DeviceStatus>,
    /// <p>The latest software version available for the device.</p>
    pub latest_software: std::option::Option<std::string::String>,
    /// <p>The device's current software version.</p>
    pub current_software: std::option::Option<std::string::String>,
    /// <p>The device's serial number.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The device's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The device's networking configuration.</p>
    pub networking_configuration: std::option::Option<crate::model::NetworkPayload>,
    /// <p>The device's networking status.</p>
    pub current_networking_status: std::option::Option<crate::model::NetworkStatus>,
    /// <p>The device's lease expiration time.</p>
    pub lease_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Beta software releases available for the device.</p>
    pub alternate_softwares:
        std::option::Option<std::vec::Vec<crate::model::AlternateSoftwareMetadata>>,
    /// <p>The most recent beta software release.</p>
    pub latest_alternate_software: std::option::Option<std::string::String>,
}
impl DescribeDeviceOutput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The device's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The device's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The device's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The device's type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DeviceType> {
        self.r#type.as_ref()
    }
    /// <p>The device's connection status.</p>
    pub fn device_connection_status(
        &self,
    ) -> std::option::Option<&crate::model::DeviceConnectionStatus> {
        self.device_connection_status.as_ref()
    }
    /// <p>When the device was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The device's provisioning status.</p>
    pub fn provisioning_status(&self) -> std::option::Option<&crate::model::DeviceStatus> {
        self.provisioning_status.as_ref()
    }
    /// <p>The latest software version available for the device.</p>
    pub fn latest_software(&self) -> std::option::Option<&str> {
        self.latest_software.as_deref()
    }
    /// <p>The device's current software version.</p>
    pub fn current_software(&self) -> std::option::Option<&str> {
        self.current_software.as_deref()
    }
    /// <p>The device's serial number.</p>
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// <p>The device's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The device's networking configuration.</p>
    pub fn networking_configuration(&self) -> std::option::Option<&crate::model::NetworkPayload> {
        self.networking_configuration.as_ref()
    }
    /// <p>The device's networking status.</p>
    pub fn current_networking_status(&self) -> std::option::Option<&crate::model::NetworkStatus> {
        self.current_networking_status.as_ref()
    }
    /// <p>The device's lease expiration time.</p>
    pub fn lease_expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.lease_expiration_time.as_ref()
    }
    /// <p>Beta software releases available for the device.</p>
    pub fn alternate_softwares(
        &self,
    ) -> std::option::Option<&[crate::model::AlternateSoftwareMetadata]> {
        self.alternate_softwares.as_deref()
    }
    /// <p>The most recent beta software release.</p>
    pub fn latest_alternate_software(&self) -> std::option::Option<&str> {
        self.latest_alternate_software.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceOutput");
        formatter.field("device_id", &self.device_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("device_connection_status", &self.device_connection_status);
        formatter.field("created_time", &self.created_time);
        formatter.field("provisioning_status", &self.provisioning_status);
        formatter.field("latest_software", &self.latest_software);
        formatter.field("current_software", &self.current_software);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("tags", &self.tags);
        formatter.field("networking_configuration", &self.networking_configuration);
        formatter.field("current_networking_status", &self.current_networking_status);
        formatter.field("lease_expiration_time", &self.lease_expiration_time);
        formatter.field("alternate_softwares", &self.alternate_softwares);
        formatter.field("latest_alternate_software", &self.latest_alternate_software);
        formatter.finish()
    }
}
/// See [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
pub mod describe_device_output {
    /// A builder for [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DeviceType>,
        pub(crate) device_connection_status:
            std::option::Option<crate::model::DeviceConnectionStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) provisioning_status: std::option::Option<crate::model::DeviceStatus>,
        pub(crate) latest_software: std::option::Option<std::string::String>,
        pub(crate) current_software: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) networking_configuration: std::option::Option<crate::model::NetworkPayload>,
        pub(crate) current_networking_status: std::option::Option<crate::model::NetworkStatus>,
        pub(crate) lease_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) alternate_softwares:
            std::option::Option<std::vec::Vec<crate::model::AlternateSoftwareMetadata>>,
        pub(crate) latest_alternate_software: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The device's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The device's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The device's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The device's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The device's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The device's type.</p>
        pub fn r#type(mut self, input: crate::model::DeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The device's type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DeviceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The device's connection status.</p>
        pub fn device_connection_status(
            mut self,
            input: crate::model::DeviceConnectionStatus,
        ) -> Self {
            self.device_connection_status = Some(input);
            self
        }
        /// <p>The device's connection status.</p>
        pub fn set_device_connection_status(
            mut self,
            input: std::option::Option<crate::model::DeviceConnectionStatus>,
        ) -> Self {
            self.device_connection_status = input;
            self
        }
        /// <p>When the device was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the device was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The device's provisioning status.</p>
        pub fn provisioning_status(mut self, input: crate::model::DeviceStatus) -> Self {
            self.provisioning_status = Some(input);
            self
        }
        /// <p>The device's provisioning status.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::DeviceStatus>,
        ) -> Self {
            self.provisioning_status = input;
            self
        }
        /// <p>The latest software version available for the device.</p>
        pub fn latest_software(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_software = Some(input.into());
            self
        }
        /// <p>The latest software version available for the device.</p>
        pub fn set_latest_software(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_software = input;
            self
        }
        /// <p>The device's current software version.</p>
        pub fn current_software(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_software = Some(input.into());
            self
        }
        /// <p>The device's current software version.</p>
        pub fn set_current_software(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_software = input;
            self
        }
        /// <p>The device's serial number.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The device's serial number.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The device's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The device's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The device's networking configuration.</p>
        pub fn networking_configuration(mut self, input: crate::model::NetworkPayload) -> Self {
            self.networking_configuration = Some(input);
            self
        }
        /// <p>The device's networking configuration.</p>
        pub fn set_networking_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkPayload>,
        ) -> Self {
            self.networking_configuration = input;
            self
        }
        /// <p>The device's networking status.</p>
        pub fn current_networking_status(mut self, input: crate::model::NetworkStatus) -> Self {
            self.current_networking_status = Some(input);
            self
        }
        /// <p>The device's networking status.</p>
        pub fn set_current_networking_status(
            mut self,
            input: std::option::Option<crate::model::NetworkStatus>,
        ) -> Self {
            self.current_networking_status = input;
            self
        }
        /// <p>The device's lease expiration time.</p>
        pub fn lease_expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.lease_expiration_time = Some(input);
            self
        }
        /// <p>The device's lease expiration time.</p>
        pub fn set_lease_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.lease_expiration_time = input;
            self
        }
        /// Appends an item to `alternate_softwares`.
        ///
        /// To override the contents of this collection use [`set_alternate_softwares`](Self::set_alternate_softwares).
        ///
        /// <p>Beta software releases available for the device.</p>
        pub fn alternate_softwares(
            mut self,
            input: crate::model::AlternateSoftwareMetadata,
        ) -> Self {
            let mut v = self.alternate_softwares.unwrap_or_default();
            v.push(input);
            self.alternate_softwares = Some(v);
            self
        }
        /// <p>Beta software releases available for the device.</p>
        pub fn set_alternate_softwares(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlternateSoftwareMetadata>>,
        ) -> Self {
            self.alternate_softwares = input;
            self
        }
        /// <p>The most recent beta software release.</p>
        pub fn latest_alternate_software(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_alternate_software = Some(input.into());
            self
        }
        /// <p>The most recent beta software release.</p>
        pub fn set_latest_alternate_software(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_alternate_software = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
        pub fn build(self) -> crate::output::DescribeDeviceOutput {
            crate::output::DescribeDeviceOutput {
                device_id: self.device_id,
                name: self.name,
                arn: self.arn,
                description: self.description,
                r#type: self.r#type,
                device_connection_status: self.device_connection_status,
                created_time: self.created_time,
                provisioning_status: self.provisioning_status,
                latest_software: self.latest_software,
                current_software: self.current_software,
                serial_number: self.serial_number,
                tags: self.tags,
                networking_configuration: self.networking_configuration,
                current_networking_status: self.current_networking_status,
                lease_expiration_time: self.lease_expiration_time,
                alternate_softwares: self.alternate_softwares,
                latest_alternate_software: self.latest_alternate_software,
            }
        }
    }
}
impl DescribeDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
    pub fn builder() -> crate::output::describe_device_output::Builder {
        crate::output::describe_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationInstanceDetailsOutput {
    /// <p>The application instance's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The application instance's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The application instance's default runtime context device.</p>
    pub default_runtime_context_device: std::option::Option<std::string::String>,
    /// <p>The application instance's configuration manifest.</p>
    pub manifest_payload: std::option::Option<crate::model::ManifestPayload>,
    /// <p>Parameter overrides for the configuration manifest.</p>
    pub manifest_overrides_payload: std::option::Option<crate::model::ManifestOverridesPayload>,
    /// <p>The ID of the application instance that this instance replaced.</p>
    pub application_instance_id_to_replace: std::option::Option<std::string::String>,
    /// <p>When the application instance was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
}
impl DescribeApplicationInstanceDetailsOutput {
    /// <p>The application instance's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The application instance's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The application instance's default runtime context device.</p>
    pub fn default_runtime_context_device(&self) -> std::option::Option<&str> {
        self.default_runtime_context_device.as_deref()
    }
    /// <p>The application instance's configuration manifest.</p>
    pub fn manifest_payload(&self) -> std::option::Option<&crate::model::ManifestPayload> {
        self.manifest_payload.as_ref()
    }
    /// <p>Parameter overrides for the configuration manifest.</p>
    pub fn manifest_overrides_payload(
        &self,
    ) -> std::option::Option<&crate::model::ManifestOverridesPayload> {
        self.manifest_overrides_payload.as_ref()
    }
    /// <p>The ID of the application instance that this instance replaced.</p>
    pub fn application_instance_id_to_replace(&self) -> std::option::Option<&str> {
        self.application_instance_id_to_replace.as_deref()
    }
    /// <p>When the application instance was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationInstanceDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationInstanceDetailsOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "default_runtime_context_device",
            &self.default_runtime_context_device,
        );
        formatter.field("manifest_payload", &self.manifest_payload);
        formatter.field(
            "manifest_overrides_payload",
            &self.manifest_overrides_payload,
        );
        formatter.field(
            "application_instance_id_to_replace",
            &self.application_instance_id_to_replace,
        );
        formatter.field("created_time", &self.created_time);
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.finish()
    }
}
/// See [`DescribeApplicationInstanceDetailsOutput`](crate::output::DescribeApplicationInstanceDetailsOutput)
pub mod describe_application_instance_details_output {
    /// A builder for [`DescribeApplicationInstanceDetailsOutput`](crate::output::DescribeApplicationInstanceDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_runtime_context_device: std::option::Option<std::string::String>,
        pub(crate) manifest_payload: std::option::Option<crate::model::ManifestPayload>,
        pub(crate) manifest_overrides_payload:
            std::option::Option<crate::model::ManifestOverridesPayload>,
        pub(crate) application_instance_id_to_replace: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application instance's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application instance's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The application instance's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The application instance's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The application instance's default runtime context device.</p>
        pub fn default_runtime_context_device(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = Some(input.into());
            self
        }
        /// <p>The application instance's default runtime context device.</p>
        pub fn set_default_runtime_context_device(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = input;
            self
        }
        /// <p>The application instance's configuration manifest.</p>
        pub fn manifest_payload(mut self, input: crate::model::ManifestPayload) -> Self {
            self.manifest_payload = Some(input);
            self
        }
        /// <p>The application instance's configuration manifest.</p>
        pub fn set_manifest_payload(
            mut self,
            input: std::option::Option<crate::model::ManifestPayload>,
        ) -> Self {
            self.manifest_payload = input;
            self
        }
        /// <p>Parameter overrides for the configuration manifest.</p>
        pub fn manifest_overrides_payload(
            mut self,
            input: crate::model::ManifestOverridesPayload,
        ) -> Self {
            self.manifest_overrides_payload = Some(input);
            self
        }
        /// <p>Parameter overrides for the configuration manifest.</p>
        pub fn set_manifest_overrides_payload(
            mut self,
            input: std::option::Option<crate::model::ManifestOverridesPayload>,
        ) -> Self {
            self.manifest_overrides_payload = input;
            self
        }
        /// <p>The ID of the application instance that this instance replaced.</p>
        pub fn application_instance_id_to_replace(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.application_instance_id_to_replace = Some(input.into());
            self
        }
        /// <p>The ID of the application instance that this instance replaced.</p>
        pub fn set_application_instance_id_to_replace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id_to_replace = input;
            self
        }
        /// <p>When the application instance was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the application instance was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationInstanceDetailsOutput`](crate::output::DescribeApplicationInstanceDetailsOutput)
        pub fn build(self) -> crate::output::DescribeApplicationInstanceDetailsOutput {
            crate::output::DescribeApplicationInstanceDetailsOutput {
                name: self.name,
                description: self.description,
                default_runtime_context_device: self.default_runtime_context_device,
                manifest_payload: self.manifest_payload,
                manifest_overrides_payload: self.manifest_overrides_payload,
                application_instance_id_to_replace: self.application_instance_id_to_replace,
                created_time: self.created_time,
                application_instance_id: self.application_instance_id,
            }
        }
    }
}
impl DescribeApplicationInstanceDetailsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInstanceDetailsOutput`](crate::output::DescribeApplicationInstanceDetailsOutput)
    pub fn builder() -> crate::output::describe_application_instance_details_output::Builder {
        crate::output::describe_application_instance_details_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationInstanceOutput {
    /// <p>The application instance's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The application instance's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The device's ID.</p>
    pub default_runtime_context_device: std::option::Option<std::string::String>,
    /// <p>The device's bane.</p>
    pub default_runtime_context_device_name: std::option::Option<std::string::String>,
    /// <p>The ID of the application instance that this instance replaced.</p>
    pub application_instance_id_to_replace: std::option::Option<std::string::String>,
    /// <p>The application instance's runtime role ARN.</p>
    pub runtime_role_arn: std::option::Option<std::string::String>,
    /// <p>The application instance's status.</p>
    pub status: std::option::Option<crate::model::ApplicationInstanceStatus>,
    /// <p>The application instance's health status.</p>
    pub health_status: std::option::Option<crate::model::ApplicationInstanceHealthStatus>,
    /// <p>The application instance's status description.</p>
    pub status_description: std::option::Option<std::string::String>,
    /// <p>When the application instance was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The application instance was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
    /// <p>The application instance's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The application instance's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeApplicationInstanceOutput {
    /// <p>The application instance's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The application instance's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The device's ID.</p>
    pub fn default_runtime_context_device(&self) -> std::option::Option<&str> {
        self.default_runtime_context_device.as_deref()
    }
    /// <p>The device's bane.</p>
    pub fn default_runtime_context_device_name(&self) -> std::option::Option<&str> {
        self.default_runtime_context_device_name.as_deref()
    }
    /// <p>The ID of the application instance that this instance replaced.</p>
    pub fn application_instance_id_to_replace(&self) -> std::option::Option<&str> {
        self.application_instance_id_to_replace.as_deref()
    }
    /// <p>The application instance's runtime role ARN.</p>
    pub fn runtime_role_arn(&self) -> std::option::Option<&str> {
        self.runtime_role_arn.as_deref()
    }
    /// <p>The application instance's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ApplicationInstanceStatus> {
        self.status.as_ref()
    }
    /// <p>The application instance's health status.</p>
    pub fn health_status(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationInstanceHealthStatus> {
        self.health_status.as_ref()
    }
    /// <p>The application instance's status description.</p>
    pub fn status_description(&self) -> std::option::Option<&str> {
        self.status_description.as_deref()
    }
    /// <p>When the application instance was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The application instance was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
    /// <p>The application instance's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The application instance's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeApplicationInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationInstanceOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "default_runtime_context_device",
            &self.default_runtime_context_device,
        );
        formatter.field(
            "default_runtime_context_device_name",
            &self.default_runtime_context_device_name,
        );
        formatter.field(
            "application_instance_id_to_replace",
            &self.application_instance_id_to_replace,
        );
        formatter.field("runtime_role_arn", &self.runtime_role_arn);
        formatter.field("status", &self.status);
        formatter.field("health_status", &self.health_status);
        formatter.field("status_description", &self.status_description);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeApplicationInstanceOutput`](crate::output::DescribeApplicationInstanceOutput)
pub mod describe_application_instance_output {
    /// A builder for [`DescribeApplicationInstanceOutput`](crate::output::DescribeApplicationInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_runtime_context_device: std::option::Option<std::string::String>,
        pub(crate) default_runtime_context_device_name: std::option::Option<std::string::String>,
        pub(crate) application_instance_id_to_replace: std::option::Option<std::string::String>,
        pub(crate) runtime_role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ApplicationInstanceStatus>,
        pub(crate) health_status:
            std::option::Option<crate::model::ApplicationInstanceHealthStatus>,
        pub(crate) status_description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The application instance's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application instance's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The application instance's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The application instance's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The device's ID.</p>
        pub fn default_runtime_context_device(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_default_runtime_context_device(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = input;
            self
        }
        /// <p>The device's bane.</p>
        pub fn default_runtime_context_device_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device_name = Some(input.into());
            self
        }
        /// <p>The device's bane.</p>
        pub fn set_default_runtime_context_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device_name = input;
            self
        }
        /// <p>The ID of the application instance that this instance replaced.</p>
        pub fn application_instance_id_to_replace(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.application_instance_id_to_replace = Some(input.into());
            self
        }
        /// <p>The ID of the application instance that this instance replaced.</p>
        pub fn set_application_instance_id_to_replace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id_to_replace = input;
            self
        }
        /// <p>The application instance's runtime role ARN.</p>
        pub fn runtime_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_role_arn = Some(input.into());
            self
        }
        /// <p>The application instance's runtime role ARN.</p>
        pub fn set_runtime_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.runtime_role_arn = input;
            self
        }
        /// <p>The application instance's status.</p>
        pub fn status(mut self, input: crate::model::ApplicationInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The application instance's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The application instance's health status.</p>
        pub fn health_status(
            mut self,
            input: crate::model::ApplicationInstanceHealthStatus,
        ) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>The application instance's health status.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationInstanceHealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The application instance's status description.</p>
        pub fn status_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_description = Some(input.into());
            self
        }
        /// <p>The application instance's status description.</p>
        pub fn set_status_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_description = input;
            self
        }
        /// <p>When the application instance was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the application instance was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The application instance was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The application instance was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// <p>The application instance's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The application instance's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The application instance's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The application instance's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationInstanceOutput`](crate::output::DescribeApplicationInstanceOutput)
        pub fn build(self) -> crate::output::DescribeApplicationInstanceOutput {
            crate::output::DescribeApplicationInstanceOutput {
                name: self.name,
                description: self.description,
                default_runtime_context_device: self.default_runtime_context_device,
                default_runtime_context_device_name: self.default_runtime_context_device_name,
                application_instance_id_to_replace: self.application_instance_id_to_replace,
                runtime_role_arn: self.runtime_role_arn,
                status: self.status,
                health_status: self.health_status,
                status_description: self.status_description,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                application_instance_id: self.application_instance_id,
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl DescribeApplicationInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInstanceOutput`](crate::output::DescribeApplicationInstanceOutput)
    pub fn builder() -> crate::output::describe_application_instance_output::Builder {
        crate::output::describe_application_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterPackageVersionOutput {}
impl std::fmt::Debug for DeregisterPackageVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterPackageVersionOutput");
        formatter.finish()
    }
}
/// See [`DeregisterPackageVersionOutput`](crate::output::DeregisterPackageVersionOutput)
pub mod deregister_package_version_output {
    /// A builder for [`DeregisterPackageVersionOutput`](crate::output::DeregisterPackageVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterPackageVersionOutput`](crate::output::DeregisterPackageVersionOutput)
        pub fn build(self) -> crate::output::DeregisterPackageVersionOutput {
            crate::output::DeregisterPackageVersionOutput {}
        }
    }
}
impl DeregisterPackageVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterPackageVersionOutput`](crate::output::DeregisterPackageVersionOutput)
    pub fn builder() -> crate::output::deregister_package_version_output::Builder {
        crate::output::deregister_package_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageOutput {}
impl std::fmt::Debug for DeletePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageOutput");
        formatter.finish()
    }
}
/// See [`DeletePackageOutput`](crate::output::DeletePackageOutput)
pub mod delete_package_output {
    /// A builder for [`DeletePackageOutput`](crate::output::DeletePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePackageOutput`](crate::output::DeletePackageOutput)
        pub fn build(self) -> crate::output::DeletePackageOutput {
            crate::output::DeletePackageOutput {}
        }
    }
}
impl DeletePackageOutput {
    /// Creates a new builder-style object to manufacture [`DeletePackageOutput`](crate::output::DeletePackageOutput)
    pub fn builder() -> crate::output::delete_package_output::Builder {
        crate::output::delete_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceOutput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl DeleteDeviceOutput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceOutput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}
/// See [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
pub mod delete_device_output {
    /// A builder for [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
        pub fn build(self) -> crate::output::DeleteDeviceOutput {
            crate::output::DeleteDeviceOutput {
                device_id: self.device_id,
            }
        }
    }
}
impl DeleteDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceOutput`](crate::output::DeleteDeviceOutput)
    pub fn builder() -> crate::output::delete_device_output::Builder {
        crate::output::delete_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageImportJobOutput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl CreatePackageImportJobOutput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePackageImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageImportJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`CreatePackageImportJobOutput`](crate::output::CreatePackageImportJobOutput)
pub mod create_package_import_job_output {
    /// A builder for [`CreatePackageImportJobOutput`](crate::output::CreatePackageImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageImportJobOutput`](crate::output::CreatePackageImportJobOutput)
        pub fn build(self) -> crate::output::CreatePackageImportJobOutput {
            crate::output::CreatePackageImportJobOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl CreatePackageImportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreatePackageImportJobOutput`](crate::output::CreatePackageImportJobOutput)
    pub fn builder() -> crate::output::create_package_import_job_output::Builder {
        crate::output::create_package_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageOutput {
    /// <p>The package's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The package's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The package's storage location.</p>
    pub storage_location: std::option::Option<crate::model::StorageLocation>,
}
impl CreatePackageOutput {
    /// <p>The package's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The package's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The package's storage location.</p>
    pub fn storage_location(&self) -> std::option::Option<&crate::model::StorageLocation> {
        self.storage_location.as_ref()
    }
}
impl std::fmt::Debug for CreatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageOutput");
        formatter.field("package_id", &self.package_id);
        formatter.field("arn", &self.arn);
        formatter.field("storage_location", &self.storage_location);
        formatter.finish()
    }
}
/// See [`CreatePackageOutput`](crate::output::CreatePackageOutput)
pub mod create_package_output {
    /// A builder for [`CreatePackageOutput`](crate::output::CreatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) storage_location: std::option::Option<crate::model::StorageLocation>,
    }
    impl Builder {
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The package's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The package's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The package's storage location.</p>
        pub fn storage_location(mut self, input: crate::model::StorageLocation) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>The package's storage location.</p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::StorageLocation>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageOutput`](crate::output::CreatePackageOutput)
        pub fn build(self) -> crate::output::CreatePackageOutput {
            crate::output::CreatePackageOutput {
                package_id: self.package_id,
                arn: self.arn,
                storage_location: self.storage_location,
            }
        }
    }
}
impl CreatePackageOutput {
    /// Creates a new builder-style object to manufacture [`CreatePackageOutput`](crate::output::CreatePackageOutput)
    pub fn builder() -> crate::output::create_package_output::Builder {
        crate::output::create_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNodeFromTemplateJobOutput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl CreateNodeFromTemplateJobOutput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for CreateNodeFromTemplateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNodeFromTemplateJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`CreateNodeFromTemplateJobOutput`](crate::output::CreateNodeFromTemplateJobOutput)
pub mod create_node_from_template_job_output {
    /// A builder for [`CreateNodeFromTemplateJobOutput`](crate::output::CreateNodeFromTemplateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNodeFromTemplateJobOutput`](crate::output::CreateNodeFromTemplateJobOutput)
        pub fn build(self) -> crate::output::CreateNodeFromTemplateJobOutput {
            crate::output::CreateNodeFromTemplateJobOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl CreateNodeFromTemplateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateNodeFromTemplateJobOutput`](crate::output::CreateNodeFromTemplateJobOutput)
    pub fn builder() -> crate::output::create_node_from_template_job_output::Builder {
        crate::output::create_node_from_template_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobForDevicesOutput {
    /// <p>A list of jobs.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
}
impl CreateJobForDevicesOutput {
    /// <p>A list of jobs.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
}
impl std::fmt::Debug for CreateJobForDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobForDevicesOutput");
        formatter.field("jobs", &self.jobs);
        formatter.finish()
    }
}
/// See [`CreateJobForDevicesOutput`](crate::output::CreateJobForDevicesOutput)
pub mod create_job_for_devices_output {
    /// A builder for [`CreateJobForDevicesOutput`](crate::output::CreateJobForDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of jobs.</p>
        pub fn jobs(mut self, input: crate::model::Job) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input);
            self.jobs = Some(v);
            self
        }
        /// <p>A list of jobs.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobForDevicesOutput`](crate::output::CreateJobForDevicesOutput)
        pub fn build(self) -> crate::output::CreateJobForDevicesOutput {
            crate::output::CreateJobForDevicesOutput { jobs: self.jobs }
        }
    }
}
impl CreateJobForDevicesOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobForDevicesOutput`](crate::output::CreateJobForDevicesOutput)
    pub fn builder() -> crate::output::create_job_for_devices_output::Builder {
        crate::output::create_job_for_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInstanceOutput {
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
}
impl CreateApplicationInstanceOutput {
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInstanceOutput");
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.finish()
    }
}
/// See [`CreateApplicationInstanceOutput`](crate::output::CreateApplicationInstanceOutput)
pub mod create_application_instance_output {
    /// A builder for [`CreateApplicationInstanceOutput`](crate::output::CreateApplicationInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInstanceOutput`](crate::output::CreateApplicationInstanceOutput)
        pub fn build(self) -> crate::output::CreateApplicationInstanceOutput {
            crate::output::CreateApplicationInstanceOutput {
                application_instance_id: self.application_instance_id,
            }
        }
    }
}
impl CreateApplicationInstanceOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationInstanceOutput`](crate::output::CreateApplicationInstanceOutput)
    pub fn builder() -> crate::output::create_application_instance_output::Builder {
        crate::output::create_application_instance_output::Builder::default()
    }
}
